<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class invoice_details_list extends invoice_details
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'invoice_details';

	// Page object name
	public $PageObjName = "invoice_details_list";

	// Grid form hidden field names
	public $FormName = "finvoice_detailslist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (invoice_details)
		if (!isset($GLOBALS["invoice_details"]) || get_class($GLOBALS["invoice_details"]) == PROJECT_NAMESPACE . "invoice_details") {
			$GLOBALS["invoice_details"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["invoice_details"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "invoice_detailsadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "invoice_detailsdelete.php";
		$this->MultiUpdateUrl = "invoice_detailsupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'invoice_details');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option finvoice_detailslistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $invoice_details;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($invoice_details);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->_barcode->Visible = FALSE;
		$this->exporter->setVisibility();
		$this->consignee->setVisibility();
		$this->consignee_other->setVisibility();
		$this->packing_list_no->setVisibility();
		$this->d_11->setVisibility();
		$this->description_11->Visible = FALSE;
		$this->in_template->setVisibility();
		$this->pl_template->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->po_no->setVisibility();
		$this->other_reference->setVisibility();
		$this->origin->setVisibility();
		$this->final_destination->setVisibility();
		$this->payment_terms->setVisibility();
		$this->pre_carriage_receipt->setVisibility();
		$this->place_of_receipt->setVisibility();
		$this->loading_port->setVisibility();
		$this->port_discharge->setVisibility();
		$this->d_01->setVisibility();
		$this->description_01->setVisibility();
		$this->d_02->setVisibility();
		$this->description_02->setVisibility();
		$this->gross_weight->setVisibility();
		$this->nett_weight->setVisibility();
		$this->cbm->setVisibility();
		$this->exporter_bank_details->Visible = FALSE;
		$this->intermediary_bank->Visible = FALSE;
		$this->shipment_mode->setVisibility();
		$this->ex_factory_date->setVisibility();
		$this->sailing_date->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->delivery_terms->Visible = FALSE;
		$this->po_date->Visible = FALSE;
		$this->cart_lines->setVisibility();
		$this->pl_lines->setVisibility();
		$this->freezed->setVisibility();
		$this->pl_pdf->Visible = FALSE;
		$this->in_pdf->Visible = FALSE;
		$this->a_operator->setVisibility();
		$this->port_delivery->setVisibility();
		$this->dispatch_details->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->exporter);
		$this->setupLookupOptions($this->consignee);
		$this->setupLookupOptions($this->consignee_other);
		$this->setupLookupOptions($this->packing_list_no);
		$this->setupLookupOptions($this->in_template);
		$this->setupLookupOptions($this->pl_template);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "finvoice_detailslistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->_barcode->AdvancedSearch->toJson(), ","); // Field barcode
		$filterList = Concat($filterList, $this->exporter->AdvancedSearch->toJson(), ","); // Field exporter
		$filterList = Concat($filterList, $this->consignee->AdvancedSearch->toJson(), ","); // Field consignee
		$filterList = Concat($filterList, $this->consignee_other->AdvancedSearch->toJson(), ","); // Field consignee_other
		$filterList = Concat($filterList, $this->packing_list_no->AdvancedSearch->toJson(), ","); // Field packing_list_no
		$filterList = Concat($filterList, $this->d_11->AdvancedSearch->toJson(), ","); // Field d_11
		$filterList = Concat($filterList, $this->description_11->AdvancedSearch->toJson(), ","); // Field description_11
		$filterList = Concat($filterList, $this->in_template->AdvancedSearch->toJson(), ","); // Field in_template
		$filterList = Concat($filterList, $this->pl_template->AdvancedSearch->toJson(), ","); // Field pl_template
		$filterList = Concat($filterList, $this->invoice_no->AdvancedSearch->toJson(), ","); // Field invoice_no
		$filterList = Concat($filterList, $this->invoice_date->AdvancedSearch->toJson(), ","); // Field invoice_date
		$filterList = Concat($filterList, $this->po_no->AdvancedSearch->toJson(), ","); // Field po_no
		$filterList = Concat($filterList, $this->other_reference->AdvancedSearch->toJson(), ","); // Field other_reference
		$filterList = Concat($filterList, $this->origin->AdvancedSearch->toJson(), ","); // Field origin
		$filterList = Concat($filterList, $this->final_destination->AdvancedSearch->toJson(), ","); // Field final_destination
		$filterList = Concat($filterList, $this->payment_terms->AdvancedSearch->toJson(), ","); // Field payment_terms
		$filterList = Concat($filterList, $this->pre_carriage_receipt->AdvancedSearch->toJson(), ","); // Field pre_carriage_receipt
		$filterList = Concat($filterList, $this->place_of_receipt->AdvancedSearch->toJson(), ","); // Field place_of_receipt
		$filterList = Concat($filterList, $this->loading_port->AdvancedSearch->toJson(), ","); // Field loading_port
		$filterList = Concat($filterList, $this->port_discharge->AdvancedSearch->toJson(), ","); // Field port_discharge
		$filterList = Concat($filterList, $this->d_01->AdvancedSearch->toJson(), ","); // Field d_01
		$filterList = Concat($filterList, $this->description_01->AdvancedSearch->toJson(), ","); // Field description_01
		$filterList = Concat($filterList, $this->d_02->AdvancedSearch->toJson(), ","); // Field d_02
		$filterList = Concat($filterList, $this->description_02->AdvancedSearch->toJson(), ","); // Field description_02
		$filterList = Concat($filterList, $this->gross_weight->AdvancedSearch->toJson(), ","); // Field gross_weight
		$filterList = Concat($filterList, $this->nett_weight->AdvancedSearch->toJson(), ","); // Field nett_weight
		$filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
		$filterList = Concat($filterList, $this->exporter_bank_details->AdvancedSearch->toJson(), ","); // Field exporter_bank_details
		$filterList = Concat($filterList, $this->intermediary_bank->AdvancedSearch->toJson(), ","); // Field intermediary_bank
		$filterList = Concat($filterList, $this->shipment_mode->AdvancedSearch->toJson(), ","); // Field shipment_mode
		$filterList = Concat($filterList, $this->ex_factory_date->AdvancedSearch->toJson(), ","); // Field ex_factory_date
		$filterList = Concat($filterList, $this->sailing_date->AdvancedSearch->toJson(), ","); // Field sailing_date
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->cart_lines->AdvancedSearch->toJson(), ","); // Field cart_lines
		$filterList = Concat($filterList, $this->pl_lines->AdvancedSearch->toJson(), ","); // Field pl_lines
		$filterList = Concat($filterList, $this->freezed->AdvancedSearch->toJson(), ","); // Field freezed
		$filterList = Concat($filterList, $this->a_operator->AdvancedSearch->toJson(), ","); // Field a_operator
		$filterList = Concat($filterList, $this->port_delivery->AdvancedSearch->toJson(), ","); // Field port_delivery
		$filterList = Concat($filterList, $this->dispatch_details->AdvancedSearch->toJson(), ","); // Field dispatch_details
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "finvoice_detailslistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field barcode
		$this->_barcode->AdvancedSearch->SearchValue = @$filter["x__barcode"];
		$this->_barcode->AdvancedSearch->SearchOperator = @$filter["z__barcode"];
		$this->_barcode->AdvancedSearch->SearchCondition = @$filter["v__barcode"];
		$this->_barcode->AdvancedSearch->SearchValue2 = @$filter["y__barcode"];
		$this->_barcode->AdvancedSearch->SearchOperator2 = @$filter["w__barcode"];
		$this->_barcode->AdvancedSearch->save();

		// Field exporter
		$this->exporter->AdvancedSearch->SearchValue = @$filter["x_exporter"];
		$this->exporter->AdvancedSearch->SearchOperator = @$filter["z_exporter"];
		$this->exporter->AdvancedSearch->SearchCondition = @$filter["v_exporter"];
		$this->exporter->AdvancedSearch->SearchValue2 = @$filter["y_exporter"];
		$this->exporter->AdvancedSearch->SearchOperator2 = @$filter["w_exporter"];
		$this->exporter->AdvancedSearch->save();

		// Field consignee
		$this->consignee->AdvancedSearch->SearchValue = @$filter["x_consignee"];
		$this->consignee->AdvancedSearch->SearchOperator = @$filter["z_consignee"];
		$this->consignee->AdvancedSearch->SearchCondition = @$filter["v_consignee"];
		$this->consignee->AdvancedSearch->SearchValue2 = @$filter["y_consignee"];
		$this->consignee->AdvancedSearch->SearchOperator2 = @$filter["w_consignee"];
		$this->consignee->AdvancedSearch->save();

		// Field consignee_other
		$this->consignee_other->AdvancedSearch->SearchValue = @$filter["x_consignee_other"];
		$this->consignee_other->AdvancedSearch->SearchOperator = @$filter["z_consignee_other"];
		$this->consignee_other->AdvancedSearch->SearchCondition = @$filter["v_consignee_other"];
		$this->consignee_other->AdvancedSearch->SearchValue2 = @$filter["y_consignee_other"];
		$this->consignee_other->AdvancedSearch->SearchOperator2 = @$filter["w_consignee_other"];
		$this->consignee_other->AdvancedSearch->save();

		// Field packing_list_no
		$this->packing_list_no->AdvancedSearch->SearchValue = @$filter["x_packing_list_no"];
		$this->packing_list_no->AdvancedSearch->SearchOperator = @$filter["z_packing_list_no"];
		$this->packing_list_no->AdvancedSearch->SearchCondition = @$filter["v_packing_list_no"];
		$this->packing_list_no->AdvancedSearch->SearchValue2 = @$filter["y_packing_list_no"];
		$this->packing_list_no->AdvancedSearch->SearchOperator2 = @$filter["w_packing_list_no"];
		$this->packing_list_no->AdvancedSearch->save();

		// Field d_11
		$this->d_11->AdvancedSearch->SearchValue = @$filter["x_d_11"];
		$this->d_11->AdvancedSearch->SearchOperator = @$filter["z_d_11"];
		$this->d_11->AdvancedSearch->SearchCondition = @$filter["v_d_11"];
		$this->d_11->AdvancedSearch->SearchValue2 = @$filter["y_d_11"];
		$this->d_11->AdvancedSearch->SearchOperator2 = @$filter["w_d_11"];
		$this->d_11->AdvancedSearch->save();

		// Field description_11
		$this->description_11->AdvancedSearch->SearchValue = @$filter["x_description_11"];
		$this->description_11->AdvancedSearch->SearchOperator = @$filter["z_description_11"];
		$this->description_11->AdvancedSearch->SearchCondition = @$filter["v_description_11"];
		$this->description_11->AdvancedSearch->SearchValue2 = @$filter["y_description_11"];
		$this->description_11->AdvancedSearch->SearchOperator2 = @$filter["w_description_11"];
		$this->description_11->AdvancedSearch->save();

		// Field in_template
		$this->in_template->AdvancedSearch->SearchValue = @$filter["x_in_template"];
		$this->in_template->AdvancedSearch->SearchOperator = @$filter["z_in_template"];
		$this->in_template->AdvancedSearch->SearchCondition = @$filter["v_in_template"];
		$this->in_template->AdvancedSearch->SearchValue2 = @$filter["y_in_template"];
		$this->in_template->AdvancedSearch->SearchOperator2 = @$filter["w_in_template"];
		$this->in_template->AdvancedSearch->save();

		// Field pl_template
		$this->pl_template->AdvancedSearch->SearchValue = @$filter["x_pl_template"];
		$this->pl_template->AdvancedSearch->SearchOperator = @$filter["z_pl_template"];
		$this->pl_template->AdvancedSearch->SearchCondition = @$filter["v_pl_template"];
		$this->pl_template->AdvancedSearch->SearchValue2 = @$filter["y_pl_template"];
		$this->pl_template->AdvancedSearch->SearchOperator2 = @$filter["w_pl_template"];
		$this->pl_template->AdvancedSearch->save();

		// Field invoice_no
		$this->invoice_no->AdvancedSearch->SearchValue = @$filter["x_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchOperator = @$filter["z_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchCondition = @$filter["v_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchValue2 = @$filter["y_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_no"];
		$this->invoice_no->AdvancedSearch->save();

		// Field invoice_date
		$this->invoice_date->AdvancedSearch->SearchValue = @$filter["x_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchOperator = @$filter["z_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchCondition = @$filter["v_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchValue2 = @$filter["y_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_date"];
		$this->invoice_date->AdvancedSearch->save();

		// Field po_no
		$this->po_no->AdvancedSearch->SearchValue = @$filter["x_po_no"];
		$this->po_no->AdvancedSearch->SearchOperator = @$filter["z_po_no"];
		$this->po_no->AdvancedSearch->SearchCondition = @$filter["v_po_no"];
		$this->po_no->AdvancedSearch->SearchValue2 = @$filter["y_po_no"];
		$this->po_no->AdvancedSearch->SearchOperator2 = @$filter["w_po_no"];
		$this->po_no->AdvancedSearch->save();

		// Field other_reference
		$this->other_reference->AdvancedSearch->SearchValue = @$filter["x_other_reference"];
		$this->other_reference->AdvancedSearch->SearchOperator = @$filter["z_other_reference"];
		$this->other_reference->AdvancedSearch->SearchCondition = @$filter["v_other_reference"];
		$this->other_reference->AdvancedSearch->SearchValue2 = @$filter["y_other_reference"];
		$this->other_reference->AdvancedSearch->SearchOperator2 = @$filter["w_other_reference"];
		$this->other_reference->AdvancedSearch->save();

		// Field origin
		$this->origin->AdvancedSearch->SearchValue = @$filter["x_origin"];
		$this->origin->AdvancedSearch->SearchOperator = @$filter["z_origin"];
		$this->origin->AdvancedSearch->SearchCondition = @$filter["v_origin"];
		$this->origin->AdvancedSearch->SearchValue2 = @$filter["y_origin"];
		$this->origin->AdvancedSearch->SearchOperator2 = @$filter["w_origin"];
		$this->origin->AdvancedSearch->save();

		// Field final_destination
		$this->final_destination->AdvancedSearch->SearchValue = @$filter["x_final_destination"];
		$this->final_destination->AdvancedSearch->SearchOperator = @$filter["z_final_destination"];
		$this->final_destination->AdvancedSearch->SearchCondition = @$filter["v_final_destination"];
		$this->final_destination->AdvancedSearch->SearchValue2 = @$filter["y_final_destination"];
		$this->final_destination->AdvancedSearch->SearchOperator2 = @$filter["w_final_destination"];
		$this->final_destination->AdvancedSearch->save();

		// Field payment_terms
		$this->payment_terms->AdvancedSearch->SearchValue = @$filter["x_payment_terms"];
		$this->payment_terms->AdvancedSearch->SearchOperator = @$filter["z_payment_terms"];
		$this->payment_terms->AdvancedSearch->SearchCondition = @$filter["v_payment_terms"];
		$this->payment_terms->AdvancedSearch->SearchValue2 = @$filter["y_payment_terms"];
		$this->payment_terms->AdvancedSearch->SearchOperator2 = @$filter["w_payment_terms"];
		$this->payment_terms->AdvancedSearch->save();

		// Field pre_carriage_receipt
		$this->pre_carriage_receipt->AdvancedSearch->SearchValue = @$filter["x_pre_carriage_receipt"];
		$this->pre_carriage_receipt->AdvancedSearch->SearchOperator = @$filter["z_pre_carriage_receipt"];
		$this->pre_carriage_receipt->AdvancedSearch->SearchCondition = @$filter["v_pre_carriage_receipt"];
		$this->pre_carriage_receipt->AdvancedSearch->SearchValue2 = @$filter["y_pre_carriage_receipt"];
		$this->pre_carriage_receipt->AdvancedSearch->SearchOperator2 = @$filter["w_pre_carriage_receipt"];
		$this->pre_carriage_receipt->AdvancedSearch->save();

		// Field place_of_receipt
		$this->place_of_receipt->AdvancedSearch->SearchValue = @$filter["x_place_of_receipt"];
		$this->place_of_receipt->AdvancedSearch->SearchOperator = @$filter["z_place_of_receipt"];
		$this->place_of_receipt->AdvancedSearch->SearchCondition = @$filter["v_place_of_receipt"];
		$this->place_of_receipt->AdvancedSearch->SearchValue2 = @$filter["y_place_of_receipt"];
		$this->place_of_receipt->AdvancedSearch->SearchOperator2 = @$filter["w_place_of_receipt"];
		$this->place_of_receipt->AdvancedSearch->save();

		// Field loading_port
		$this->loading_port->AdvancedSearch->SearchValue = @$filter["x_loading_port"];
		$this->loading_port->AdvancedSearch->SearchOperator = @$filter["z_loading_port"];
		$this->loading_port->AdvancedSearch->SearchCondition = @$filter["v_loading_port"];
		$this->loading_port->AdvancedSearch->SearchValue2 = @$filter["y_loading_port"];
		$this->loading_port->AdvancedSearch->SearchOperator2 = @$filter["w_loading_port"];
		$this->loading_port->AdvancedSearch->save();

		// Field port_discharge
		$this->port_discharge->AdvancedSearch->SearchValue = @$filter["x_port_discharge"];
		$this->port_discharge->AdvancedSearch->SearchOperator = @$filter["z_port_discharge"];
		$this->port_discharge->AdvancedSearch->SearchCondition = @$filter["v_port_discharge"];
		$this->port_discharge->AdvancedSearch->SearchValue2 = @$filter["y_port_discharge"];
		$this->port_discharge->AdvancedSearch->SearchOperator2 = @$filter["w_port_discharge"];
		$this->port_discharge->AdvancedSearch->save();

		// Field d_01
		$this->d_01->AdvancedSearch->SearchValue = @$filter["x_d_01"];
		$this->d_01->AdvancedSearch->SearchOperator = @$filter["z_d_01"];
		$this->d_01->AdvancedSearch->SearchCondition = @$filter["v_d_01"];
		$this->d_01->AdvancedSearch->SearchValue2 = @$filter["y_d_01"];
		$this->d_01->AdvancedSearch->SearchOperator2 = @$filter["w_d_01"];
		$this->d_01->AdvancedSearch->save();

		// Field description_01
		$this->description_01->AdvancedSearch->SearchValue = @$filter["x_description_01"];
		$this->description_01->AdvancedSearch->SearchOperator = @$filter["z_description_01"];
		$this->description_01->AdvancedSearch->SearchCondition = @$filter["v_description_01"];
		$this->description_01->AdvancedSearch->SearchValue2 = @$filter["y_description_01"];
		$this->description_01->AdvancedSearch->SearchOperator2 = @$filter["w_description_01"];
		$this->description_01->AdvancedSearch->save();

		// Field d_02
		$this->d_02->AdvancedSearch->SearchValue = @$filter["x_d_02"];
		$this->d_02->AdvancedSearch->SearchOperator = @$filter["z_d_02"];
		$this->d_02->AdvancedSearch->SearchCondition = @$filter["v_d_02"];
		$this->d_02->AdvancedSearch->SearchValue2 = @$filter["y_d_02"];
		$this->d_02->AdvancedSearch->SearchOperator2 = @$filter["w_d_02"];
		$this->d_02->AdvancedSearch->save();

		// Field description_02
		$this->description_02->AdvancedSearch->SearchValue = @$filter["x_description_02"];
		$this->description_02->AdvancedSearch->SearchOperator = @$filter["z_description_02"];
		$this->description_02->AdvancedSearch->SearchCondition = @$filter["v_description_02"];
		$this->description_02->AdvancedSearch->SearchValue2 = @$filter["y_description_02"];
		$this->description_02->AdvancedSearch->SearchOperator2 = @$filter["w_description_02"];
		$this->description_02->AdvancedSearch->save();

		// Field gross_weight
		$this->gross_weight->AdvancedSearch->SearchValue = @$filter["x_gross_weight"];
		$this->gross_weight->AdvancedSearch->SearchOperator = @$filter["z_gross_weight"];
		$this->gross_weight->AdvancedSearch->SearchCondition = @$filter["v_gross_weight"];
		$this->gross_weight->AdvancedSearch->SearchValue2 = @$filter["y_gross_weight"];
		$this->gross_weight->AdvancedSearch->SearchOperator2 = @$filter["w_gross_weight"];
		$this->gross_weight->AdvancedSearch->save();

		// Field nett_weight
		$this->nett_weight->AdvancedSearch->SearchValue = @$filter["x_nett_weight"];
		$this->nett_weight->AdvancedSearch->SearchOperator = @$filter["z_nett_weight"];
		$this->nett_weight->AdvancedSearch->SearchCondition = @$filter["v_nett_weight"];
		$this->nett_weight->AdvancedSearch->SearchValue2 = @$filter["y_nett_weight"];
		$this->nett_weight->AdvancedSearch->SearchOperator2 = @$filter["w_nett_weight"];
		$this->nett_weight->AdvancedSearch->save();

		// Field cbm
		$this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
		$this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
		$this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
		$this->cbm->AdvancedSearch->save();

		// Field exporter_bank_details
		$this->exporter_bank_details->AdvancedSearch->SearchValue = @$filter["x_exporter_bank_details"];
		$this->exporter_bank_details->AdvancedSearch->SearchOperator = @$filter["z_exporter_bank_details"];
		$this->exporter_bank_details->AdvancedSearch->SearchCondition = @$filter["v_exporter_bank_details"];
		$this->exporter_bank_details->AdvancedSearch->SearchValue2 = @$filter["y_exporter_bank_details"];
		$this->exporter_bank_details->AdvancedSearch->SearchOperator2 = @$filter["w_exporter_bank_details"];
		$this->exporter_bank_details->AdvancedSearch->save();

		// Field intermediary_bank
		$this->intermediary_bank->AdvancedSearch->SearchValue = @$filter["x_intermediary_bank"];
		$this->intermediary_bank->AdvancedSearch->SearchOperator = @$filter["z_intermediary_bank"];
		$this->intermediary_bank->AdvancedSearch->SearchCondition = @$filter["v_intermediary_bank"];
		$this->intermediary_bank->AdvancedSearch->SearchValue2 = @$filter["y_intermediary_bank"];
		$this->intermediary_bank->AdvancedSearch->SearchOperator2 = @$filter["w_intermediary_bank"];
		$this->intermediary_bank->AdvancedSearch->save();

		// Field shipment_mode
		$this->shipment_mode->AdvancedSearch->SearchValue = @$filter["x_shipment_mode"];
		$this->shipment_mode->AdvancedSearch->SearchOperator = @$filter["z_shipment_mode"];
		$this->shipment_mode->AdvancedSearch->SearchCondition = @$filter["v_shipment_mode"];
		$this->shipment_mode->AdvancedSearch->SearchValue2 = @$filter["y_shipment_mode"];
		$this->shipment_mode->AdvancedSearch->SearchOperator2 = @$filter["w_shipment_mode"];
		$this->shipment_mode->AdvancedSearch->save();

		// Field ex_factory_date
		$this->ex_factory_date->AdvancedSearch->SearchValue = @$filter["x_ex_factory_date"];
		$this->ex_factory_date->AdvancedSearch->SearchOperator = @$filter["z_ex_factory_date"];
		$this->ex_factory_date->AdvancedSearch->SearchCondition = @$filter["v_ex_factory_date"];
		$this->ex_factory_date->AdvancedSearch->SearchValue2 = @$filter["y_ex_factory_date"];
		$this->ex_factory_date->AdvancedSearch->SearchOperator2 = @$filter["w_ex_factory_date"];
		$this->ex_factory_date->AdvancedSearch->save();

		// Field sailing_date
		$this->sailing_date->AdvancedSearch->SearchValue = @$filter["x_sailing_date"];
		$this->sailing_date->AdvancedSearch->SearchOperator = @$filter["z_sailing_date"];
		$this->sailing_date->AdvancedSearch->SearchCondition = @$filter["v_sailing_date"];
		$this->sailing_date->AdvancedSearch->SearchValue2 = @$filter["y_sailing_date"];
		$this->sailing_date->AdvancedSearch->SearchOperator2 = @$filter["w_sailing_date"];
		$this->sailing_date->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field cart_lines
		$this->cart_lines->AdvancedSearch->SearchValue = @$filter["x_cart_lines"];
		$this->cart_lines->AdvancedSearch->SearchOperator = @$filter["z_cart_lines"];
		$this->cart_lines->AdvancedSearch->SearchCondition = @$filter["v_cart_lines"];
		$this->cart_lines->AdvancedSearch->SearchValue2 = @$filter["y_cart_lines"];
		$this->cart_lines->AdvancedSearch->SearchOperator2 = @$filter["w_cart_lines"];
		$this->cart_lines->AdvancedSearch->save();

		// Field pl_lines
		$this->pl_lines->AdvancedSearch->SearchValue = @$filter["x_pl_lines"];
		$this->pl_lines->AdvancedSearch->SearchOperator = @$filter["z_pl_lines"];
		$this->pl_lines->AdvancedSearch->SearchCondition = @$filter["v_pl_lines"];
		$this->pl_lines->AdvancedSearch->SearchValue2 = @$filter["y_pl_lines"];
		$this->pl_lines->AdvancedSearch->SearchOperator2 = @$filter["w_pl_lines"];
		$this->pl_lines->AdvancedSearch->save();

		// Field freezed
		$this->freezed->AdvancedSearch->SearchValue = @$filter["x_freezed"];
		$this->freezed->AdvancedSearch->SearchOperator = @$filter["z_freezed"];
		$this->freezed->AdvancedSearch->SearchCondition = @$filter["v_freezed"];
		$this->freezed->AdvancedSearch->SearchValue2 = @$filter["y_freezed"];
		$this->freezed->AdvancedSearch->SearchOperator2 = @$filter["w_freezed"];
		$this->freezed->AdvancedSearch->save();

		// Field a_operator
		$this->a_operator->AdvancedSearch->SearchValue = @$filter["x_a_operator"];
		$this->a_operator->AdvancedSearch->SearchOperator = @$filter["z_a_operator"];
		$this->a_operator->AdvancedSearch->SearchCondition = @$filter["v_a_operator"];
		$this->a_operator->AdvancedSearch->SearchValue2 = @$filter["y_a_operator"];
		$this->a_operator->AdvancedSearch->SearchOperator2 = @$filter["w_a_operator"];
		$this->a_operator->AdvancedSearch->save();

		// Field port_delivery
		$this->port_delivery->AdvancedSearch->SearchValue = @$filter["x_port_delivery"];
		$this->port_delivery->AdvancedSearch->SearchOperator = @$filter["z_port_delivery"];
		$this->port_delivery->AdvancedSearch->SearchCondition = @$filter["v_port_delivery"];
		$this->port_delivery->AdvancedSearch->SearchValue2 = @$filter["y_port_delivery"];
		$this->port_delivery->AdvancedSearch->SearchOperator2 = @$filter["w_port_delivery"];
		$this->port_delivery->AdvancedSearch->save();

		// Field dispatch_details
		$this->dispatch_details->AdvancedSearch->SearchValue = @$filter["x_dispatch_details"];
		$this->dispatch_details->AdvancedSearch->SearchOperator = @$filter["z_dispatch_details"];
		$this->dispatch_details->AdvancedSearch->SearchCondition = @$filter["v_dispatch_details"];
		$this->dispatch_details->AdvancedSearch->SearchValue2 = @$filter["y_dispatch_details"];
		$this->dispatch_details->AdvancedSearch->SearchOperator2 = @$filter["w_dispatch_details"];
		$this->dispatch_details->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->_barcode, $default, FALSE); // barcode
		$this->buildSearchSql($where, $this->exporter, $default, FALSE); // exporter
		$this->buildSearchSql($where, $this->consignee, $default, FALSE); // consignee
		$this->buildSearchSql($where, $this->consignee_other, $default, FALSE); // consignee_other
		$this->buildSearchSql($where, $this->packing_list_no, $default, FALSE); // packing_list_no
		$this->buildSearchSql($where, $this->d_11, $default, FALSE); // d_11
		$this->buildSearchSql($where, $this->description_11, $default, FALSE); // description_11
		$this->buildSearchSql($where, $this->in_template, $default, FALSE); // in_template
		$this->buildSearchSql($where, $this->pl_template, $default, FALSE); // pl_template
		$this->buildSearchSql($where, $this->invoice_no, $default, FALSE); // invoice_no
		$this->buildSearchSql($where, $this->invoice_date, $default, FALSE); // invoice_date
		$this->buildSearchSql($where, $this->po_no, $default, FALSE); // po_no
		$this->buildSearchSql($where, $this->other_reference, $default, FALSE); // other_reference
		$this->buildSearchSql($where, $this->origin, $default, FALSE); // origin
		$this->buildSearchSql($where, $this->final_destination, $default, FALSE); // final_destination
		$this->buildSearchSql($where, $this->payment_terms, $default, FALSE); // payment_terms
		$this->buildSearchSql($where, $this->pre_carriage_receipt, $default, FALSE); // pre_carriage_receipt
		$this->buildSearchSql($where, $this->place_of_receipt, $default, FALSE); // place_of_receipt
		$this->buildSearchSql($where, $this->loading_port, $default, FALSE); // loading_port
		$this->buildSearchSql($where, $this->port_discharge, $default, FALSE); // port_discharge
		$this->buildSearchSql($where, $this->d_01, $default, FALSE); // d_01
		$this->buildSearchSql($where, $this->description_01, $default, FALSE); // description_01
		$this->buildSearchSql($where, $this->d_02, $default, FALSE); // d_02
		$this->buildSearchSql($where, $this->description_02, $default, FALSE); // description_02
		$this->buildSearchSql($where, $this->gross_weight, $default, FALSE); // gross_weight
		$this->buildSearchSql($where, $this->nett_weight, $default, FALSE); // nett_weight
		$this->buildSearchSql($where, $this->cbm, $default, FALSE); // cbm
		$this->buildSearchSql($where, $this->exporter_bank_details, $default, FALSE); // exporter_bank_details
		$this->buildSearchSql($where, $this->intermediary_bank, $default, FALSE); // intermediary_bank
		$this->buildSearchSql($where, $this->shipment_mode, $default, FALSE); // shipment_mode
		$this->buildSearchSql($where, $this->ex_factory_date, $default, FALSE); // ex_factory_date
		$this->buildSearchSql($where, $this->sailing_date, $default, FALSE); // sailing_date
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->cart_lines, $default, FALSE); // cart_lines
		$this->buildSearchSql($where, $this->pl_lines, $default, FALSE); // pl_lines
		$this->buildSearchSql($where, $this->freezed, $default, FALSE); // freezed
		$this->buildSearchSql($where, $this->a_operator, $default, FALSE); // a_operator
		$this->buildSearchSql($where, $this->port_delivery, $default, FALSE); // port_delivery
		$this->buildSearchSql($where, $this->dispatch_details, $default, FALSE); // dispatch_details

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->_barcode->AdvancedSearch->save(); // barcode
			$this->exporter->AdvancedSearch->save(); // exporter
			$this->consignee->AdvancedSearch->save(); // consignee
			$this->consignee_other->AdvancedSearch->save(); // consignee_other
			$this->packing_list_no->AdvancedSearch->save(); // packing_list_no
			$this->d_11->AdvancedSearch->save(); // d_11
			$this->description_11->AdvancedSearch->save(); // description_11
			$this->in_template->AdvancedSearch->save(); // in_template
			$this->pl_template->AdvancedSearch->save(); // pl_template
			$this->invoice_no->AdvancedSearch->save(); // invoice_no
			$this->invoice_date->AdvancedSearch->save(); // invoice_date
			$this->po_no->AdvancedSearch->save(); // po_no
			$this->other_reference->AdvancedSearch->save(); // other_reference
			$this->origin->AdvancedSearch->save(); // origin
			$this->final_destination->AdvancedSearch->save(); // final_destination
			$this->payment_terms->AdvancedSearch->save(); // payment_terms
			$this->pre_carriage_receipt->AdvancedSearch->save(); // pre_carriage_receipt
			$this->place_of_receipt->AdvancedSearch->save(); // place_of_receipt
			$this->loading_port->AdvancedSearch->save(); // loading_port
			$this->port_discharge->AdvancedSearch->save(); // port_discharge
			$this->d_01->AdvancedSearch->save(); // d_01
			$this->description_01->AdvancedSearch->save(); // description_01
			$this->d_02->AdvancedSearch->save(); // d_02
			$this->description_02->AdvancedSearch->save(); // description_02
			$this->gross_weight->AdvancedSearch->save(); // gross_weight
			$this->nett_weight->AdvancedSearch->save(); // nett_weight
			$this->cbm->AdvancedSearch->save(); // cbm
			$this->exporter_bank_details->AdvancedSearch->save(); // exporter_bank_details
			$this->intermediary_bank->AdvancedSearch->save(); // intermediary_bank
			$this->shipment_mode->AdvancedSearch->save(); // shipment_mode
			$this->ex_factory_date->AdvancedSearch->save(); // ex_factory_date
			$this->sailing_date->AdvancedSearch->save(); // sailing_date
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->cart_lines->AdvancedSearch->save(); // cart_lines
			$this->pl_lines->AdvancedSearch->save(); // pl_lines
			$this->freezed->AdvancedSearch->save(); // freezed
			$this->a_operator->AdvancedSearch->save(); // a_operator
			$this->port_delivery->AdvancedSearch->save(); // port_delivery
			$this->dispatch_details->AdvancedSearch->save(); // dispatch_details
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->_barcode, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->exporter, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->consignee, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->consignee_other, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_11, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_11, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->invoice_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->other_reference, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->origin, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->final_destination, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->payment_terms, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pre_carriage_receipt, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->place_of_receipt, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->loading_port, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->port_discharge, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->gross_weight, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nett_weight, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cbm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->exporter_bank_details, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->intermediary_bank, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->port_delivery, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->dispatch_details, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_barcode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->exporter->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->consignee->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->consignee_other->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packing_list_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->in_template->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_template->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->other_reference->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->origin->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->final_destination->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->payment_terms->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pre_carriage_receipt->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->place_of_receipt->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->loading_port->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->port_discharge->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gross_weight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->nett_weight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cbm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->exporter_bank_details->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->intermediary_bank->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->shipment_mode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ex_factory_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sailing_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cart_lines->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_lines->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->freezed->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->a_operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->port_delivery->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->dispatch_details->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->_barcode->AdvancedSearch->unsetSession();
		$this->exporter->AdvancedSearch->unsetSession();
		$this->consignee->AdvancedSearch->unsetSession();
		$this->consignee_other->AdvancedSearch->unsetSession();
		$this->packing_list_no->AdvancedSearch->unsetSession();
		$this->d_11->AdvancedSearch->unsetSession();
		$this->description_11->AdvancedSearch->unsetSession();
		$this->in_template->AdvancedSearch->unsetSession();
		$this->pl_template->AdvancedSearch->unsetSession();
		$this->invoice_no->AdvancedSearch->unsetSession();
		$this->invoice_date->AdvancedSearch->unsetSession();
		$this->po_no->AdvancedSearch->unsetSession();
		$this->other_reference->AdvancedSearch->unsetSession();
		$this->origin->AdvancedSearch->unsetSession();
		$this->final_destination->AdvancedSearch->unsetSession();
		$this->payment_terms->AdvancedSearch->unsetSession();
		$this->pre_carriage_receipt->AdvancedSearch->unsetSession();
		$this->place_of_receipt->AdvancedSearch->unsetSession();
		$this->loading_port->AdvancedSearch->unsetSession();
		$this->port_discharge->AdvancedSearch->unsetSession();
		$this->d_01->AdvancedSearch->unsetSession();
		$this->description_01->AdvancedSearch->unsetSession();
		$this->d_02->AdvancedSearch->unsetSession();
		$this->description_02->AdvancedSearch->unsetSession();
		$this->gross_weight->AdvancedSearch->unsetSession();
		$this->nett_weight->AdvancedSearch->unsetSession();
		$this->cbm->AdvancedSearch->unsetSession();
		$this->exporter_bank_details->AdvancedSearch->unsetSession();
		$this->intermediary_bank->AdvancedSearch->unsetSession();
		$this->shipment_mode->AdvancedSearch->unsetSession();
		$this->ex_factory_date->AdvancedSearch->unsetSession();
		$this->sailing_date->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->cart_lines->AdvancedSearch->unsetSession();
		$this->pl_lines->AdvancedSearch->unsetSession();
		$this->freezed->AdvancedSearch->unsetSession();
		$this->a_operator->AdvancedSearch->unsetSession();
		$this->port_delivery->AdvancedSearch->unsetSession();
		$this->dispatch_details->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->exporter->AdvancedSearch->load();
		$this->consignee->AdvancedSearch->load();
		$this->consignee_other->AdvancedSearch->load();
		$this->packing_list_no->AdvancedSearch->load();
		$this->d_11->AdvancedSearch->load();
		$this->description_11->AdvancedSearch->load();
		$this->in_template->AdvancedSearch->load();
		$this->pl_template->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->po_no->AdvancedSearch->load();
		$this->other_reference->AdvancedSearch->load();
		$this->origin->AdvancedSearch->load();
		$this->final_destination->AdvancedSearch->load();
		$this->payment_terms->AdvancedSearch->load();
		$this->pre_carriage_receipt->AdvancedSearch->load();
		$this->place_of_receipt->AdvancedSearch->load();
		$this->loading_port->AdvancedSearch->load();
		$this->port_discharge->AdvancedSearch->load();
		$this->d_01->AdvancedSearch->load();
		$this->description_01->AdvancedSearch->load();
		$this->d_02->AdvancedSearch->load();
		$this->description_02->AdvancedSearch->load();
		$this->gross_weight->AdvancedSearch->load();
		$this->nett_weight->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->exporter_bank_details->AdvancedSearch->load();
		$this->intermediary_bank->AdvancedSearch->load();
		$this->shipment_mode->AdvancedSearch->load();
		$this->ex_factory_date->AdvancedSearch->load();
		$this->sailing_date->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->cart_lines->AdvancedSearch->load();
		$this->pl_lines->AdvancedSearch->load();
		$this->freezed->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->port_delivery->AdvancedSearch->load();
		$this->dispatch_details->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->exporter, $ctrl); // exporter
			$this->updateSort($this->consignee, $ctrl); // consignee
			$this->updateSort($this->consignee_other, $ctrl); // consignee_other
			$this->updateSort($this->packing_list_no, $ctrl); // packing_list_no
			$this->updateSort($this->d_11, $ctrl); // d_11
			$this->updateSort($this->in_template, $ctrl); // in_template
			$this->updateSort($this->pl_template, $ctrl); // pl_template
			$this->updateSort($this->invoice_no, $ctrl); // invoice_no
			$this->updateSort($this->invoice_date, $ctrl); // invoice_date
			$this->updateSort($this->po_no, $ctrl); // po_no
			$this->updateSort($this->other_reference, $ctrl); // other_reference
			$this->updateSort($this->origin, $ctrl); // origin
			$this->updateSort($this->final_destination, $ctrl); // final_destination
			$this->updateSort($this->payment_terms, $ctrl); // payment_terms
			$this->updateSort($this->pre_carriage_receipt, $ctrl); // pre_carriage_receipt
			$this->updateSort($this->place_of_receipt, $ctrl); // place_of_receipt
			$this->updateSort($this->loading_port, $ctrl); // loading_port
			$this->updateSort($this->port_discharge, $ctrl); // port_discharge
			$this->updateSort($this->d_01, $ctrl); // d_01
			$this->updateSort($this->description_01, $ctrl); // description_01
			$this->updateSort($this->d_02, $ctrl); // d_02
			$this->updateSort($this->description_02, $ctrl); // description_02
			$this->updateSort($this->gross_weight, $ctrl); // gross_weight
			$this->updateSort($this->nett_weight, $ctrl); // nett_weight
			$this->updateSort($this->cbm, $ctrl); // cbm
			$this->updateSort($this->shipment_mode, $ctrl); // shipment_mode
			$this->updateSort($this->ex_factory_date, $ctrl); // ex_factory_date
			$this->updateSort($this->sailing_date, $ctrl); // sailing_date
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->updateSort($this->cart_lines, $ctrl); // cart_lines
			$this->updateSort($this->pl_lines, $ctrl); // pl_lines
			$this->updateSort($this->freezed, $ctrl); // freezed
			$this->updateSort($this->a_operator, $ctrl); // a_operator
			$this->updateSort($this->port_delivery, $ctrl); // port_delivery
			$this->updateSort($this->dispatch_details, $ctrl); // dispatch_details
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->exporter->setSort("");
				$this->consignee->setSort("");
				$this->consignee_other->setSort("");
				$this->packing_list_no->setSort("");
				$this->d_11->setSort("");
				$this->in_template->setSort("");
				$this->pl_template->setSort("");
				$this->invoice_no->setSort("");
				$this->invoice_date->setSort("");
				$this->po_no->setSort("");
				$this->other_reference->setSort("");
				$this->origin->setSort("");
				$this->final_destination->setSort("");
				$this->payment_terms->setSort("");
				$this->pre_carriage_receipt->setSort("");
				$this->place_of_receipt->setSort("");
				$this->loading_port->setSort("");
				$this->port_discharge->setSort("");
				$this->d_01->setSort("");
				$this->description_01->setSort("");
				$this->d_02->setSort("");
				$this->description_02->setSort("");
				$this->gross_weight->setSort("");
				$this->nett_weight->setSort("");
				$this->cbm->setSort("");
				$this->shipment_mode->setSort("");
				$this->ex_factory_date->setSort("");
				$this->sailing_date->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
				$this->cart_lines->setSort("");
				$this->pl_lines->setSort("");
				$this->freezed->setSort("");
				$this->a_operator->setSort("");
				$this->port_delivery->setSort("");
				$this->dispatch_details->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"finvoice_detailslistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"finvoice_detailslistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.finvoice_detailslist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"finvoice_detailslistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"invoice_detailssrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"invoice_details\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'invoice_detailssrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"finvoice_detailslistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue(Get("x__barcode", Get("_barcode", "")));
		if ($this->_barcode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_barcode->AdvancedSearch->setSearchOperator(Get("z__barcode", ""));

		// exporter
		if (!$this->isAddOrEdit())
			$this->exporter->AdvancedSearch->setSearchValue(Get("x_exporter", Get("exporter", "")));
		if ($this->exporter->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->exporter->AdvancedSearch->setSearchOperator(Get("z_exporter", ""));

		// consignee
		if (!$this->isAddOrEdit())
			$this->consignee->AdvancedSearch->setSearchValue(Get("x_consignee", Get("consignee", "")));
		if ($this->consignee->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->consignee->AdvancedSearch->setSearchOperator(Get("z_consignee", ""));

		// consignee_other
		if (!$this->isAddOrEdit())
			$this->consignee_other->AdvancedSearch->setSearchValue(Get("x_consignee_other", Get("consignee_other", "")));
		if ($this->consignee_other->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->consignee_other->AdvancedSearch->setSearchOperator(Get("z_consignee_other", ""));

		// packing_list_no
		if (!$this->isAddOrEdit())
			$this->packing_list_no->AdvancedSearch->setSearchValue(Get("x_packing_list_no", Get("packing_list_no", "")));
		if ($this->packing_list_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packing_list_no->AdvancedSearch->setSearchOperator(Get("z_packing_list_no", ""));

		// d_11
		if (!$this->isAddOrEdit())
			$this->d_11->AdvancedSearch->setSearchValue(Get("x_d_11", Get("d_11", "")));
		if ($this->d_11->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_11->AdvancedSearch->setSearchOperator(Get("z_d_11", ""));

		// description_11
		if (!$this->isAddOrEdit())
			$this->description_11->AdvancedSearch->setSearchValue(Get("x_description_11", Get("description_11", "")));
		if ($this->description_11->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_11->AdvancedSearch->setSearchOperator(Get("z_description_11", ""));

		// in_template
		if (!$this->isAddOrEdit())
			$this->in_template->AdvancedSearch->setSearchValue(Get("x_in_template", Get("in_template", "")));
		if ($this->in_template->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->in_template->AdvancedSearch->setSearchOperator(Get("z_in_template", ""));

		// pl_template
		if (!$this->isAddOrEdit())
			$this->pl_template->AdvancedSearch->setSearchValue(Get("x_pl_template", Get("pl_template", "")));
		if ($this->pl_template->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_template->AdvancedSearch->setSearchOperator(Get("z_pl_template", ""));

		// invoice_no
		if (!$this->isAddOrEdit())
			$this->invoice_no->AdvancedSearch->setSearchValue(Get("x_invoice_no", Get("invoice_no", "")));
		if ($this->invoice_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_no->AdvancedSearch->setSearchOperator(Get("z_invoice_no", ""));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue(Get("x_invoice_date", Get("invoice_date", "")));
		if ($this->invoice_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_date->AdvancedSearch->setSearchOperator(Get("z_invoice_date", ""));

		// po_no
		if (!$this->isAddOrEdit())
			$this->po_no->AdvancedSearch->setSearchValue(Get("x_po_no", Get("po_no", "")));
		if ($this->po_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_no->AdvancedSearch->setSearchOperator(Get("z_po_no", ""));

		// other_reference
		if (!$this->isAddOrEdit())
			$this->other_reference->AdvancedSearch->setSearchValue(Get("x_other_reference", Get("other_reference", "")));
		if ($this->other_reference->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->other_reference->AdvancedSearch->setSearchOperator(Get("z_other_reference", ""));

		// origin
		if (!$this->isAddOrEdit())
			$this->origin->AdvancedSearch->setSearchValue(Get("x_origin", Get("origin", "")));
		if ($this->origin->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->origin->AdvancedSearch->setSearchOperator(Get("z_origin", ""));

		// final_destination
		if (!$this->isAddOrEdit())
			$this->final_destination->AdvancedSearch->setSearchValue(Get("x_final_destination", Get("final_destination", "")));
		if ($this->final_destination->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->final_destination->AdvancedSearch->setSearchOperator(Get("z_final_destination", ""));

		// payment_terms
		if (!$this->isAddOrEdit())
			$this->payment_terms->AdvancedSearch->setSearchValue(Get("x_payment_terms", Get("payment_terms", "")));
		if ($this->payment_terms->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->payment_terms->AdvancedSearch->setSearchOperator(Get("z_payment_terms", ""));

		// pre_carriage_receipt
		if (!$this->isAddOrEdit())
			$this->pre_carriage_receipt->AdvancedSearch->setSearchValue(Get("x_pre_carriage_receipt", Get("pre_carriage_receipt", "")));
		if ($this->pre_carriage_receipt->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pre_carriage_receipt->AdvancedSearch->setSearchOperator(Get("z_pre_carriage_receipt", ""));

		// place_of_receipt
		if (!$this->isAddOrEdit())
			$this->place_of_receipt->AdvancedSearch->setSearchValue(Get("x_place_of_receipt", Get("place_of_receipt", "")));
		if ($this->place_of_receipt->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->place_of_receipt->AdvancedSearch->setSearchOperator(Get("z_place_of_receipt", ""));

		// loading_port
		if (!$this->isAddOrEdit())
			$this->loading_port->AdvancedSearch->setSearchValue(Get("x_loading_port", Get("loading_port", "")));
		if ($this->loading_port->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->loading_port->AdvancedSearch->setSearchOperator(Get("z_loading_port", ""));

		// port_discharge
		if (!$this->isAddOrEdit())
			$this->port_discharge->AdvancedSearch->setSearchValue(Get("x_port_discharge", Get("port_discharge", "")));
		if ($this->port_discharge->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->port_discharge->AdvancedSearch->setSearchOperator(Get("z_port_discharge", ""));

		// d_01
		if (!$this->isAddOrEdit())
			$this->d_01->AdvancedSearch->setSearchValue(Get("x_d_01", Get("d_01", "")));
		if ($this->d_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_01->AdvancedSearch->setSearchOperator(Get("z_d_01", ""));

		// description_01
		if (!$this->isAddOrEdit())
			$this->description_01->AdvancedSearch->setSearchValue(Get("x_description_01", Get("description_01", "")));
		if ($this->description_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_01->AdvancedSearch->setSearchOperator(Get("z_description_01", ""));

		// d_02
		if (!$this->isAddOrEdit())
			$this->d_02->AdvancedSearch->setSearchValue(Get("x_d_02", Get("d_02", "")));
		if ($this->d_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_02->AdvancedSearch->setSearchOperator(Get("z_d_02", ""));

		// description_02
		if (!$this->isAddOrEdit())
			$this->description_02->AdvancedSearch->setSearchValue(Get("x_description_02", Get("description_02", "")));
		if ($this->description_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_02->AdvancedSearch->setSearchOperator(Get("z_description_02", ""));

		// gross_weight
		if (!$this->isAddOrEdit())
			$this->gross_weight->AdvancedSearch->setSearchValue(Get("x_gross_weight", Get("gross_weight", "")));
		if ($this->gross_weight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gross_weight->AdvancedSearch->setSearchOperator(Get("z_gross_weight", ""));

		// nett_weight
		if (!$this->isAddOrEdit())
			$this->nett_weight->AdvancedSearch->setSearchValue(Get("x_nett_weight", Get("nett_weight", "")));
		if ($this->nett_weight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->nett_weight->AdvancedSearch->setSearchOperator(Get("z_nett_weight", ""));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue(Get("x_cbm", Get("cbm", "")));
		if ($this->cbm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cbm->AdvancedSearch->setSearchOperator(Get("z_cbm", ""));

		// exporter_bank_details
		if (!$this->isAddOrEdit())
			$this->exporter_bank_details->AdvancedSearch->setSearchValue(Get("x_exporter_bank_details", Get("exporter_bank_details", "")));
		if ($this->exporter_bank_details->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->exporter_bank_details->AdvancedSearch->setSearchOperator(Get("z_exporter_bank_details", ""));

		// intermediary_bank
		if (!$this->isAddOrEdit())
			$this->intermediary_bank->AdvancedSearch->setSearchValue(Get("x_intermediary_bank", Get("intermediary_bank", "")));
		if ($this->intermediary_bank->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->intermediary_bank->AdvancedSearch->setSearchOperator(Get("z_intermediary_bank", ""));

		// shipment_mode
		if (!$this->isAddOrEdit())
			$this->shipment_mode->AdvancedSearch->setSearchValue(Get("x_shipment_mode", Get("shipment_mode", "")));
		if ($this->shipment_mode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->shipment_mode->AdvancedSearch->setSearchOperator(Get("z_shipment_mode", ""));

		// ex_factory_date
		if (!$this->isAddOrEdit())
			$this->ex_factory_date->AdvancedSearch->setSearchValue(Get("x_ex_factory_date", Get("ex_factory_date", "")));
		if ($this->ex_factory_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ex_factory_date->AdvancedSearch->setSearchOperator(Get("z_ex_factory_date", ""));

		// sailing_date
		if (!$this->isAddOrEdit())
			$this->sailing_date->AdvancedSearch->setSearchValue(Get("x_sailing_date", Get("sailing_date", "")));
		if ($this->sailing_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sailing_date->AdvancedSearch->setSearchOperator(Get("z_sailing_date", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// cart_lines
		if (!$this->isAddOrEdit())
			$this->cart_lines->AdvancedSearch->setSearchValue(Get("x_cart_lines", Get("cart_lines", "")));
		if ($this->cart_lines->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cart_lines->AdvancedSearch->setSearchOperator(Get("z_cart_lines", ""));

		// pl_lines
		if (!$this->isAddOrEdit())
			$this->pl_lines->AdvancedSearch->setSearchValue(Get("x_pl_lines", Get("pl_lines", "")));
		if ($this->pl_lines->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_lines->AdvancedSearch->setSearchOperator(Get("z_pl_lines", ""));

		// freezed
		if (!$this->isAddOrEdit())
			$this->freezed->AdvancedSearch->setSearchValue(Get("x_freezed", Get("freezed", "")));
		if ($this->freezed->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->freezed->AdvancedSearch->setSearchOperator(Get("z_freezed", ""));

		// a_operator
		if (!$this->isAddOrEdit())
			$this->a_operator->AdvancedSearch->setSearchValue(Get("x_a_operator", Get("a_operator", "")));
		if ($this->a_operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->a_operator->AdvancedSearch->setSearchOperator(Get("z_a_operator", ""));

		// port_delivery
		if (!$this->isAddOrEdit())
			$this->port_delivery->AdvancedSearch->setSearchValue(Get("x_port_delivery", Get("port_delivery", "")));
		if ($this->port_delivery->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->port_delivery->AdvancedSearch->setSearchOperator(Get("z_port_delivery", ""));

		// dispatch_details
		if (!$this->isAddOrEdit())
			$this->dispatch_details->AdvancedSearch->setSearchValue(Get("x_dispatch_details", Get("dispatch_details", "")));
		if ($this->dispatch_details->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->dispatch_details->AdvancedSearch->setSearchOperator(Get("z_dispatch_details", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->exporter->setDbValue($row['exporter']);
		$this->consignee->setDbValue($row['consignee']);
		$this->consignee_other->setDbValue($row['consignee_other']);
		$this->packing_list_no->setDbValue($row['packing_list_no']);
		$this->d_11->setDbValue($row['d_11']);
		$this->description_11->setDbValue($row['description_11']);
		$this->in_template->setDbValue($row['in_template']);
		$this->pl_template->setDbValue($row['pl_template']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->po_no->setDbValue($row['po_no']);
		$this->other_reference->setDbValue($row['other_reference']);
		$this->origin->setDbValue($row['origin']);
		$this->final_destination->setDbValue($row['final_destination']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->pre_carriage_receipt->setDbValue($row['pre_carriage_receipt']);
		$this->place_of_receipt->setDbValue($row['place_of_receipt']);
		$this->loading_port->setDbValue($row['loading_port']);
		$this->port_discharge->setDbValue($row['port_discharge']);
		$this->d_01->setDbValue($row['d_01']);
		$this->description_01->setDbValue($row['description_01']);
		$this->d_02->setDbValue($row['d_02']);
		$this->description_02->setDbValue($row['description_02']);
		$this->gross_weight->setDbValue($row['gross_weight']);
		$this->nett_weight->setDbValue($row['nett_weight']);
		$this->cbm->setDbValue($row['cbm']);
		$this->exporter_bank_details->setDbValue($row['exporter_bank_details']);
		$this->intermediary_bank->setDbValue($row['intermediary_bank']);
		$this->shipment_mode->setDbValue($row['shipment_mode']);
		$this->ex_factory_date->setDbValue($row['ex_factory_date']);
		$this->sailing_date->setDbValue($row['sailing_date']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->delivery_terms->setDbValue($row['delivery_terms']);
		$this->po_date->setDbValue($row['po_date']);
		$this->cart_lines->setDbValue($row['cart_lines']);
		$this->pl_lines->setDbValue($row['pl_lines']);
		$this->freezed->setDbValue($row['freezed']);
		$this->pl_pdf->setDbValue($row['pl_pdf']);
		$this->in_pdf->setDbValue($row['in_pdf']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->port_delivery->setDbValue($row['port_delivery']);
		$this->dispatch_details->setDbValue($row['dispatch_details']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['barcode'] = NULL;
		$row['exporter'] = NULL;
		$row['consignee'] = NULL;
		$row['consignee_other'] = NULL;
		$row['packing_list_no'] = NULL;
		$row['d_11'] = NULL;
		$row['description_11'] = NULL;
		$row['in_template'] = NULL;
		$row['pl_template'] = NULL;
		$row['invoice_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['po_no'] = NULL;
		$row['other_reference'] = NULL;
		$row['origin'] = NULL;
		$row['final_destination'] = NULL;
		$row['payment_terms'] = NULL;
		$row['pre_carriage_receipt'] = NULL;
		$row['place_of_receipt'] = NULL;
		$row['loading_port'] = NULL;
		$row['port_discharge'] = NULL;
		$row['d_01'] = NULL;
		$row['description_01'] = NULL;
		$row['d_02'] = NULL;
		$row['description_02'] = NULL;
		$row['gross_weight'] = NULL;
		$row['nett_weight'] = NULL;
		$row['cbm'] = NULL;
		$row['exporter_bank_details'] = NULL;
		$row['intermediary_bank'] = NULL;
		$row['shipment_mode'] = NULL;
		$row['ex_factory_date'] = NULL;
		$row['sailing_date'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['delivery_terms'] = NULL;
		$row['po_date'] = NULL;
		$row['cart_lines'] = NULL;
		$row['pl_lines'] = NULL;
		$row['freezed'] = NULL;
		$row['pl_pdf'] = NULL;
		$row['in_pdf'] = NULL;
		$row['a_operator'] = NULL;
		$row['port_delivery'] = NULL;
		$row['dispatch_details'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// barcode
		// exporter
		// consignee
		// consignee_other
		// packing_list_no
		// d_11
		// description_11
		// in_template
		// pl_template
		// invoice_no
		// invoice_date
		// po_no
		// other_reference
		// origin
		// final_destination
		// payment_terms
		// pre_carriage_receipt
		// place_of_receipt
		// loading_port
		// port_discharge
		// d_01
		// description_01
		// d_02
		// description_02
		// gross_weight
		// nett_weight
		// cbm
		// exporter_bank_details
		// intermediary_bank
		// shipment_mode
		// ex_factory_date
		// sailing_date
		// operator
		// datetime
		// delivery_terms

		$this->delivery_terms->CellCssStyle = "white-space: nowrap;";

		// po_date
		$this->po_date->CellCssStyle = "white-space: nowrap;";

		// cart_lines
		// pl_lines
		// freezed
		// pl_pdf

		$this->pl_pdf->CellCssStyle = "white-space: nowrap;";

		// in_pdf
		$this->in_pdf->CellCssStyle = "white-space: nowrap;";

		// a_operator
		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// port_delivery
		// dispatch_details

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// exporter
			$curVal = strval($this->exporter->CurrentValue);
			if ($curVal <> "") {
				$this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
				if ($this->exporter->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->exporter->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->exporter->ViewValue = $this->exporter->CurrentValue;
					}
				}
			} else {
				$this->exporter->ViewValue = NULL;
			}
			$this->exporter->ViewCustomAttributes = "";

			// consignee
			$curVal = strval($this->consignee->CurrentValue);
			if ($curVal <> "") {
				$this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
				if ($this->consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignee->ViewValue = $this->consignee->CurrentValue;
					}
				}
			} else {
				$this->consignee->ViewValue = NULL;
			}
			$this->consignee->ViewCustomAttributes = "";

			// consignee_other
			$curVal = strval($this->consignee_other->CurrentValue);
			if ($curVal <> "") {
				$this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
				if ($this->consignee_other->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignee_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
					}
				}
			} else {
				$this->consignee_other->ViewValue = NULL;
			}
			$this->consignee_other->ViewCustomAttributes = "";

			// packing_list_no
			$curVal = strval($this->packing_list_no->CurrentValue);
			if ($curVal <> "") {
				$this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
				if ($this->packing_list_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`pl_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`pl_no` != 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_list_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
						$this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_list_no->ViewValue = $this->packing_list_no->CurrentValue;
					}
				}
			} else {
				$this->packing_list_no->ViewValue = NULL;
			}
			$this->packing_list_no->ViewCustomAttributes = "";

			// d_11
			$this->d_11->ViewValue = $this->d_11->CurrentValue;
			$this->d_11->ViewCustomAttributes = "";

			// in_template
			$curVal = strval($this->in_template->CurrentValue);
			if ($curVal <> "") {
				$this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
				if ($this->in_template->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`apcid` between 45501 and 45999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->in_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->in_template->ViewValue = $this->in_template->CurrentValue;
					}
				}
			} else {
				$this->in_template->ViewValue = NULL;
			}
			$this->in_template->ViewCustomAttributes = "";

			// pl_template
			$curVal = strval($this->pl_template->CurrentValue);
			if ($curVal <> "") {
				$this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
				if ($this->pl_template->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`apcid` between 45001 and 45500";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_template->ViewValue = $this->pl_template->CurrentValue;
					}
				}
			} else {
				$this->pl_template->ViewValue = NULL;
			}
			$this->pl_template->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// po_no
			$this->po_no->ViewValue = $this->po_no->CurrentValue;
			$this->po_no->ViewCustomAttributes = "";

			// other_reference
			$this->other_reference->ViewValue = $this->other_reference->CurrentValue;
			$this->other_reference->ViewCustomAttributes = "";

			// origin
			$this->origin->ViewValue = $this->origin->CurrentValue;
			$this->origin->ViewCustomAttributes = "";

			// final_destination
			$this->final_destination->ViewValue = $this->final_destination->CurrentValue;
			$this->final_destination->ViewCustomAttributes = "";

			// payment_terms
			$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
			$this->payment_terms->ViewCustomAttributes = "";

			// pre_carriage_receipt
			$this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;
			$this->pre_carriage_receipt->ViewCustomAttributes = "";

			// place_of_receipt
			$this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;
			$this->place_of_receipt->ViewCustomAttributes = "";

			// loading_port
			$this->loading_port->ViewValue = $this->loading_port->CurrentValue;
			$this->loading_port->ViewCustomAttributes = "";

			// port_discharge
			$this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;
			$this->port_discharge->ViewCustomAttributes = "";

			// d_01
			$this->d_01->ViewValue = $this->d_01->CurrentValue;
			$this->d_01->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewCustomAttributes = "";

			// d_02
			$this->d_02->ViewValue = $this->d_02->CurrentValue;
			$this->d_02->ViewCustomAttributes = "";

			// description_02
			$this->description_02->ViewValue = $this->description_02->CurrentValue;
			$this->description_02->ViewCustomAttributes = "";

			// gross_weight
			$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
			$this->gross_weight->ViewCustomAttributes = "";

			// nett_weight
			$this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;
			$this->nett_weight->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// shipment_mode
			$this->shipment_mode->ViewValue = $this->shipment_mode->CurrentValue;
			$this->shipment_mode->ViewValue = FormatNumber($this->shipment_mode->ViewValue, 0, -2, -2, -2);
			$this->shipment_mode->ViewCustomAttributes = "";

			// ex_factory_date
			$this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
			$this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, 0);
			$this->ex_factory_date->ViewCustomAttributes = "";

			// sailing_date
			$this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
			$this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, 0);
			$this->sailing_date->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// cart_lines
			$this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;
			$this->cart_lines->ViewCustomAttributes = "";

			// pl_lines
			$this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;
			$this->pl_lines->ViewCustomAttributes = "";

			// freezed
			if (strval($this->freezed->CurrentValue) <> "") {
				$this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
			} else {
				$this->freezed->ViewValue = NULL;
			}
			$this->freezed->ViewCustomAttributes = "";

			// a_operator
			$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
			$this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, 0, -2, -2, -2);
			$this->a_operator->ViewCustomAttributes = "";

			// port_delivery
			$this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;
			$this->port_delivery->ViewCustomAttributes = "";

			// dispatch_details
			$this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;
			$this->dispatch_details->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// exporter
			$this->exporter->LinkCustomAttributes = "";
			$this->exporter->HrefValue = "";
			$this->exporter->TooltipValue = "";

			// consignee
			$this->consignee->LinkCustomAttributes = "";
			$this->consignee->HrefValue = "";
			$this->consignee->TooltipValue = "";

			// consignee_other
			$this->consignee_other->LinkCustomAttributes = "";
			$this->consignee_other->HrefValue = "";
			$this->consignee_other->TooltipValue = "";

			// packing_list_no
			$this->packing_list_no->LinkCustomAttributes = "";
			$this->packing_list_no->HrefValue = "";
			$this->packing_list_no->TooltipValue = "";

			// d_11
			$this->d_11->LinkCustomAttributes = "";
			$this->d_11->HrefValue = "";
			$this->d_11->TooltipValue = "";
			if (!$this->isExport())
				$this->d_11->ViewValue = $this->highlightValue($this->d_11);

			// in_template
			$this->in_template->LinkCustomAttributes = "";
			$this->in_template->HrefValue = "";
			$this->in_template->TooltipValue = "";

			// pl_template
			$this->pl_template->LinkCustomAttributes = "";
			$this->pl_template->HrefValue = "";
			$this->pl_template->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";
			if (!$this->isExport())
				$this->invoice_no->ViewValue = $this->highlightValue($this->invoice_no);

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// po_no
			$this->po_no->LinkCustomAttributes = "";
			$this->po_no->HrefValue = "";
			$this->po_no->TooltipValue = "";
			if (!$this->isExport())
				$this->po_no->ViewValue = $this->highlightValue($this->po_no);

			// other_reference
			$this->other_reference->LinkCustomAttributes = "";
			$this->other_reference->HrefValue = "";
			$this->other_reference->TooltipValue = "";
			if (!$this->isExport())
				$this->other_reference->ViewValue = $this->highlightValue($this->other_reference);

			// origin
			$this->origin->LinkCustomAttributes = "";
			$this->origin->HrefValue = "";
			$this->origin->TooltipValue = "";
			if (!$this->isExport())
				$this->origin->ViewValue = $this->highlightValue($this->origin);

			// final_destination
			$this->final_destination->LinkCustomAttributes = "";
			$this->final_destination->HrefValue = "";
			$this->final_destination->TooltipValue = "";
			if (!$this->isExport())
				$this->final_destination->ViewValue = $this->highlightValue($this->final_destination);

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";
			if (!$this->isExport())
				$this->payment_terms->ViewValue = $this->highlightValue($this->payment_terms);

			// pre_carriage_receipt
			$this->pre_carriage_receipt->LinkCustomAttributes = "";
			$this->pre_carriage_receipt->HrefValue = "";
			$this->pre_carriage_receipt->TooltipValue = "";
			if (!$this->isExport())
				$this->pre_carriage_receipt->ViewValue = $this->highlightValue($this->pre_carriage_receipt);

			// place_of_receipt
			$this->place_of_receipt->LinkCustomAttributes = "";
			$this->place_of_receipt->HrefValue = "";
			$this->place_of_receipt->TooltipValue = "";
			if (!$this->isExport())
				$this->place_of_receipt->ViewValue = $this->highlightValue($this->place_of_receipt);

			// loading_port
			$this->loading_port->LinkCustomAttributes = "";
			$this->loading_port->HrefValue = "";
			$this->loading_port->TooltipValue = "";
			if (!$this->isExport())
				$this->loading_port->ViewValue = $this->highlightValue($this->loading_port);

			// port_discharge
			$this->port_discharge->LinkCustomAttributes = "";
			$this->port_discharge->HrefValue = "";
			$this->port_discharge->TooltipValue = "";
			if (!$this->isExport())
				$this->port_discharge->ViewValue = $this->highlightValue($this->port_discharge);

			// d_01
			$this->d_01->LinkCustomAttributes = "";
			$this->d_01->HrefValue = "";
			$this->d_01->TooltipValue = "";
			if (!$this->isExport())
				$this->d_01->ViewValue = $this->highlightValue($this->d_01);

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";
			if (!$this->isExport())
				$this->description_01->ViewValue = $this->highlightValue($this->description_01);

			// d_02
			$this->d_02->LinkCustomAttributes = "";
			$this->d_02->HrefValue = "";
			$this->d_02->TooltipValue = "";
			if (!$this->isExport())
				$this->d_02->ViewValue = $this->highlightValue($this->d_02);

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";
			$this->description_02->TooltipValue = "";
			if (!$this->isExport())
				$this->description_02->ViewValue = $this->highlightValue($this->description_02);

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";
			$this->gross_weight->TooltipValue = "";
			if (!$this->isExport())
				$this->gross_weight->ViewValue = $this->highlightValue($this->gross_weight);

			// nett_weight
			$this->nett_weight->LinkCustomAttributes = "";
			$this->nett_weight->HrefValue = "";
			$this->nett_weight->TooltipValue = "";
			if (!$this->isExport())
				$this->nett_weight->ViewValue = $this->highlightValue($this->nett_weight);

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";
			if (!$this->isExport())
				$this->cbm->ViewValue = $this->highlightValue($this->cbm);

			// shipment_mode
			$this->shipment_mode->LinkCustomAttributes = "";
			$this->shipment_mode->HrefValue = "";
			$this->shipment_mode->TooltipValue = "";

			// ex_factory_date
			$this->ex_factory_date->LinkCustomAttributes = "";
			$this->ex_factory_date->HrefValue = "";
			$this->ex_factory_date->TooltipValue = "";

			// sailing_date
			$this->sailing_date->LinkCustomAttributes = "";
			$this->sailing_date->HrefValue = "";
			$this->sailing_date->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// cart_lines
			$this->cart_lines->LinkCustomAttributes = "";
			$this->cart_lines->HrefValue = "";
			$this->cart_lines->TooltipValue = "";
			if (!$this->isExport())
				$this->cart_lines->ViewValue = $this->highlightValue($this->cart_lines);

			// pl_lines
			$this->pl_lines->LinkCustomAttributes = "";
			$this->pl_lines->HrefValue = "";
			$this->pl_lines->TooltipValue = "";
			if (!$this->isExport())
				$this->pl_lines->ViewValue = $this->highlightValue($this->pl_lines);

			// freezed
			$this->freezed->LinkCustomAttributes = "";
			$this->freezed->HrefValue = "";
			$this->freezed->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// port_delivery
			$this->port_delivery->LinkCustomAttributes = "";
			$this->port_delivery->HrefValue = "";
			$this->port_delivery->TooltipValue = "";
			if (!$this->isExport())
				$this->port_delivery->ViewValue = $this->highlightValue($this->port_delivery);

			// dispatch_details
			$this->dispatch_details->LinkCustomAttributes = "";
			$this->dispatch_details->HrefValue = "";
			$this->dispatch_details->TooltipValue = "";
			if (!$this->isExport())
				$this->dispatch_details->ViewValue = $this->highlightValue($this->dispatch_details);
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->exporter->AdvancedSearch->load();
		$this->consignee->AdvancedSearch->load();
		$this->consignee_other->AdvancedSearch->load();
		$this->packing_list_no->AdvancedSearch->load();
		$this->d_11->AdvancedSearch->load();
		$this->description_11->AdvancedSearch->load();
		$this->in_template->AdvancedSearch->load();
		$this->pl_template->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->po_no->AdvancedSearch->load();
		$this->other_reference->AdvancedSearch->load();
		$this->origin->AdvancedSearch->load();
		$this->final_destination->AdvancedSearch->load();
		$this->payment_terms->AdvancedSearch->load();
		$this->pre_carriage_receipt->AdvancedSearch->load();
		$this->place_of_receipt->AdvancedSearch->load();
		$this->loading_port->AdvancedSearch->load();
		$this->port_discharge->AdvancedSearch->load();
		$this->d_01->AdvancedSearch->load();
		$this->description_01->AdvancedSearch->load();
		$this->d_02->AdvancedSearch->load();
		$this->description_02->AdvancedSearch->load();
		$this->gross_weight->AdvancedSearch->load();
		$this->nett_weight->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->exporter_bank_details->AdvancedSearch->load();
		$this->intermediary_bank->AdvancedSearch->load();
		$this->shipment_mode->AdvancedSearch->load();
		$this->ex_factory_date->AdvancedSearch->load();
		$this->sailing_date->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->cart_lines->AdvancedSearch->load();
		$this->pl_lines->AdvancedSearch->load();
		$this->freezed->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->port_delivery->AdvancedSearch->load();
		$this->dispatch_details->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.finvoice_detailslist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.finvoice_detailslist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.finvoice_detailslist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_invoice_details\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_invoice_details',hdr:ew.language.phrase('ExportToEmailText'),f:document.finvoice_detailslist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_exporter":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignee":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignee_other":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_list_no":
					$lookupFilter = function() {
						return "`pl_no` != 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_in_template":
					$lookupFilter = function() {
						return "`apcid` between 45501 and 45999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_template":
					$lookupFilter = function() {
						return "`apcid` between 45001 and 45500";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_exporter":
							break;
						case "x_consignee":
							break;
						case "x_consignee_other":
							break;
						case "x_packing_list_no":
							$row[1] = FormatNumber($row[1], 2, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_in_template":
							break;
						case "x_pl_template":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

		$infile = '.p_uploads/aW52b2ljZQ/' . $this->in_pdf->CurrentValue;
		if (is_null($this->in_pdf->CurrentValue))
		{
			$this->ListOptions->Add("Generate Invoice"); // Replace abclink with your name of the link
			$this->ListOptions->Items["Generate Invoice"]->Body ='<a href="autoprogramme.php?apcid='.$this->in_template->CurrentValue.'&ID=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s&action=generate" data-original-title ="Generate Invoice"><i data-phrase="Generate Invoice" style="color:red" class="fa fa-print ew-icon"></i></a>'; 
		}
		else
		{
			$this->ListOptions->Add("ReGenerate Invoice"); // Replace abclink with your name of the link
			$this->ListOptions->Items["ReGenerate Invoice"]->Body ='<a href="autoprogramme.php?apcid='.$this->in_template->CurrentValue.'&ID=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s&action=generate" data-original-title ="ReGenerate Invoice"><i data-phrase="ReGenerate Invoice" style="color:red" class="fa fa-print ew-icon"></i></a>';
		}
		IF (file_exists($infile))
		{
		$this->ListOptions->Add("Download Invoice");
		$this->ListOptions->Items["Download Invoice"]->Body =
			'<a href="'.$infile.'" data-original-title ="Download Invoice"><i data-phrase="Download Invoice" style="font-size: 16px; color:red" class="fa fa-file-pdf-o"></i></a>';
		}
		$plfile = '.p_uploads/aW52b2ljZQ/' . $this->pl_pdf->CurrentValue;
		if (is_null($this->pl_pdf->CurrentValue))
		{
			$this->ListOptions->Add("Generate Packing List"); // Replace abclink with your name of the link
			$this->ListOptions->Items["Generate Packing List"]->Body ='<a href="autoprogramme.php?apcid='.$this->pl_template->CurrentValue.'&ID=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s&action=generate" data-original-title ="Generate Packing List"><i data-phrase="Generate Packing List" style="color:green" class="fa fa-print ew-icon" ></i></a>'; 
		}
		else
		{
			$this->ListOptions->Add("ReGenerate Packing List"); // Replace abclink with your name of the link
			$this->ListOptions->Items["ReGenerate Packing List"]->Body ='<a href="autoprogramme.php?apcid='.$this->pl_template->CurrentValue.'&ID=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s&action=generate" data-original-title ="ReGenerate Packing List"><i data-phrase="ReGenerate Packing List" style="color:green" class="fa fa-print ew-icon" ></i></a>'; 
		}
		IF (file_exists($plfile))
		{
		$this->ListOptions->Add("Download Packing List");
		$this->ListOptions->Items["Download Packing List"]->Body =
			'<a href="'.$plfile.'" download data-original-title ="Download Packing List"><i data-phrase="Download Packing List" style="font-size: 16px; color:green" class="fa fa-file-pdf-o"></i></a>';
		}	
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>