<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class invoice_details_search extends invoice_details
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'invoice_details';

	// Page object name
	public $PageObjName = "invoice_details_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (invoice_details)
		if (!isset($GLOBALS["invoice_details"]) || get_class($GLOBALS["invoice_details"]) == PROJECT_NAMESPACE . "invoice_details") {
			$GLOBALS["invoice_details"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["invoice_details"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'invoice_details');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $invoice_details;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($invoice_details);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "invoice_detailsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("invoice_detailslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->_barcode->setVisibility();
		$this->exporter->setVisibility();
		$this->consignee->setVisibility();
		$this->consignee_other->setVisibility();
		$this->packing_list_no->setVisibility();
		$this->d_11->setVisibility();
		$this->description_11->setVisibility();
		$this->in_template->setVisibility();
		$this->pl_template->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->po_no->setVisibility();
		$this->other_reference->setVisibility();
		$this->origin->setVisibility();
		$this->final_destination->setVisibility();
		$this->payment_terms->setVisibility();
		$this->pre_carriage_receipt->setVisibility();
		$this->place_of_receipt->setVisibility();
		$this->loading_port->setVisibility();
		$this->port_discharge->setVisibility();
		$this->d_01->setVisibility();
		$this->description_01->setVisibility();
		$this->d_02->setVisibility();
		$this->description_02->setVisibility();
		$this->gross_weight->setVisibility();
		$this->nett_weight->setVisibility();
		$this->cbm->setVisibility();
		$this->exporter_bank_details->setVisibility();
		$this->intermediary_bank->setVisibility();
		$this->shipment_mode->setVisibility();
		$this->ex_factory_date->setVisibility();
		$this->sailing_date->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->delivery_terms->Visible = FALSE;
		$this->po_date->Visible = FALSE;
		$this->cart_lines->setVisibility();
		$this->pl_lines->setVisibility();
		$this->freezed->setVisibility();
		$this->pl_pdf->Visible = FALSE;
		$this->in_pdf->Visible = FALSE;
		$this->a_operator->setVisibility();
		$this->port_delivery->setVisibility();
		$this->dispatch_details->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->exporter);
		$this->setupLookupOptions($this->consignee);
		$this->setupLookupOptions($this->consignee_other);
		$this->setupLookupOptions($this->packing_list_no);
		$this->setupLookupOptions($this->in_template);
		$this->setupLookupOptions($this->pl_template);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "invoice_detailslist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
		$this->buildSearchUrl($srchUrl, $this->exporter); // exporter
		$this->buildSearchUrl($srchUrl, $this->consignee); // consignee
		$this->buildSearchUrl($srchUrl, $this->consignee_other); // consignee_other
		$this->buildSearchUrl($srchUrl, $this->packing_list_no); // packing_list_no
		$this->buildSearchUrl($srchUrl, $this->d_11); // d_11
		$this->buildSearchUrl($srchUrl, $this->description_11); // description_11
		$this->buildSearchUrl($srchUrl, $this->in_template); // in_template
		$this->buildSearchUrl($srchUrl, $this->pl_template); // pl_template
		$this->buildSearchUrl($srchUrl, $this->invoice_no); // invoice_no
		$this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
		$this->buildSearchUrl($srchUrl, $this->po_no); // po_no
		$this->buildSearchUrl($srchUrl, $this->other_reference); // other_reference
		$this->buildSearchUrl($srchUrl, $this->origin); // origin
		$this->buildSearchUrl($srchUrl, $this->final_destination); // final_destination
		$this->buildSearchUrl($srchUrl, $this->payment_terms); // payment_terms
		$this->buildSearchUrl($srchUrl, $this->pre_carriage_receipt); // pre_carriage_receipt
		$this->buildSearchUrl($srchUrl, $this->place_of_receipt); // place_of_receipt
		$this->buildSearchUrl($srchUrl, $this->loading_port); // loading_port
		$this->buildSearchUrl($srchUrl, $this->port_discharge); // port_discharge
		$this->buildSearchUrl($srchUrl, $this->d_01); // d_01
		$this->buildSearchUrl($srchUrl, $this->description_01); // description_01
		$this->buildSearchUrl($srchUrl, $this->d_02); // d_02
		$this->buildSearchUrl($srchUrl, $this->description_02); // description_02
		$this->buildSearchUrl($srchUrl, $this->gross_weight); // gross_weight
		$this->buildSearchUrl($srchUrl, $this->nett_weight); // nett_weight
		$this->buildSearchUrl($srchUrl, $this->cbm); // cbm
		$this->buildSearchUrl($srchUrl, $this->exporter_bank_details); // exporter_bank_details
		$this->buildSearchUrl($srchUrl, $this->intermediary_bank); // intermediary_bank
		$this->buildSearchUrl($srchUrl, $this->shipment_mode); // shipment_mode
		$this->buildSearchUrl($srchUrl, $this->ex_factory_date); // ex_factory_date
		$this->buildSearchUrl($srchUrl, $this->sailing_date); // sailing_date
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->cart_lines); // cart_lines
		$this->buildSearchUrl($srchUrl, $this->pl_lines); // pl_lines
		$this->buildSearchUrl($srchUrl, $this->freezed); // freezed
		$this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
		$this->buildSearchUrl($srchUrl, $this->port_delivery); // port_delivery
		$this->buildSearchUrl($srchUrl, $this->dispatch_details); // dispatch_details
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__barcode"));

		// exporter
		if (!$this->isAddOrEdit())
			$this->exporter->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_exporter"));
		$this->exporter->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_exporter"));

		// consignee
		if (!$this->isAddOrEdit())
			$this->consignee->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_consignee"));
		$this->consignee->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_consignee"));

		// consignee_other
		if (!$this->isAddOrEdit())
			$this->consignee_other->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_consignee_other"));
		$this->consignee_other->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_consignee_other"));

		// packing_list_no
		if (!$this->isAddOrEdit())
			$this->packing_list_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packing_list_no"));
		$this->packing_list_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packing_list_no"));

		// d_11
		if (!$this->isAddOrEdit())
			$this->d_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_11"));
		$this->d_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_11"));

		// description_11
		if (!$this->isAddOrEdit())
			$this->description_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_11"));
		$this->description_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_11"));

		// in_template
		if (!$this->isAddOrEdit())
			$this->in_template->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_in_template"));
		$this->in_template->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_in_template"));

		// pl_template
		if (!$this->isAddOrEdit())
			$this->pl_template->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_template"));
		$this->pl_template->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_template"));

		// invoice_no
		if (!$this->isAddOrEdit())
			$this->invoice_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_no"));
		$this->invoice_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_no"));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_date"));
		$this->invoice_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_date"));

		// po_no
		if (!$this->isAddOrEdit())
			$this->po_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_no"));
		$this->po_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_no"));

		// other_reference
		if (!$this->isAddOrEdit())
			$this->other_reference->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_other_reference"));
		$this->other_reference->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_other_reference"));

		// origin
		if (!$this->isAddOrEdit())
			$this->origin->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_origin"));
		$this->origin->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_origin"));

		// final_destination
		if (!$this->isAddOrEdit())
			$this->final_destination->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_final_destination"));
		$this->final_destination->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_final_destination"));

		// payment_terms
		if (!$this->isAddOrEdit())
			$this->payment_terms->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_terms"));
		$this->payment_terms->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_terms"));

		// pre_carriage_receipt
		if (!$this->isAddOrEdit())
			$this->pre_carriage_receipt->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pre_carriage_receipt"));
		$this->pre_carriage_receipt->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pre_carriage_receipt"));

		// place_of_receipt
		if (!$this->isAddOrEdit())
			$this->place_of_receipt->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_place_of_receipt"));
		$this->place_of_receipt->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_place_of_receipt"));

		// loading_port
		if (!$this->isAddOrEdit())
			$this->loading_port->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_loading_port"));
		$this->loading_port->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_loading_port"));

		// port_discharge
		if (!$this->isAddOrEdit())
			$this->port_discharge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_port_discharge"));
		$this->port_discharge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_port_discharge"));

		// d_01
		if (!$this->isAddOrEdit())
			$this->d_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_01"));
		$this->d_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_01"));

		// description_01
		if (!$this->isAddOrEdit())
			$this->description_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_01"));
		$this->description_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_01"));

		// d_02
		if (!$this->isAddOrEdit())
			$this->d_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_02"));
		$this->d_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_02"));

		// description_02
		if (!$this->isAddOrEdit())
			$this->description_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_02"));
		$this->description_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_02"));

		// gross_weight
		if (!$this->isAddOrEdit())
			$this->gross_weight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gross_weight"));
		$this->gross_weight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gross_weight"));

		// nett_weight
		if (!$this->isAddOrEdit())
			$this->nett_weight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_nett_weight"));
		$this->nett_weight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_nett_weight"));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cbm"));
		$this->cbm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cbm"));

		// exporter_bank_details
		if (!$this->isAddOrEdit())
			$this->exporter_bank_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_exporter_bank_details"));
		$this->exporter_bank_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_exporter_bank_details"));

		// intermediary_bank
		if (!$this->isAddOrEdit())
			$this->intermediary_bank->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_intermediary_bank"));
		$this->intermediary_bank->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_intermediary_bank"));

		// shipment_mode
		if (!$this->isAddOrEdit())
			$this->shipment_mode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipment_mode"));
		$this->shipment_mode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipment_mode"));

		// ex_factory_date
		if (!$this->isAddOrEdit())
			$this->ex_factory_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ex_factory_date"));
		$this->ex_factory_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ex_factory_date"));

		// sailing_date
		if (!$this->isAddOrEdit())
			$this->sailing_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sailing_date"));
		$this->sailing_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sailing_date"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// cart_lines
		if (!$this->isAddOrEdit())
			$this->cart_lines->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cart_lines"));
		$this->cart_lines->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cart_lines"));

		// pl_lines
		if (!$this->isAddOrEdit())
			$this->pl_lines->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_lines"));
		$this->pl_lines->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_lines"));

		// freezed
		if (!$this->isAddOrEdit())
			$this->freezed->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_freezed"));
		$this->freezed->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_freezed"));

		// a_operator
		if (!$this->isAddOrEdit())
			$this->a_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_a_operator"));
		$this->a_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_a_operator"));

		// port_delivery
		if (!$this->isAddOrEdit())
			$this->port_delivery->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_port_delivery"));
		$this->port_delivery->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_port_delivery"));

		// dispatch_details
		if (!$this->isAddOrEdit())
			$this->dispatch_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dispatch_details"));
		$this->dispatch_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dispatch_details"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// barcode
		// exporter
		// consignee
		// consignee_other
		// packing_list_no
		// d_11
		// description_11
		// in_template
		// pl_template
		// invoice_no
		// invoice_date
		// po_no
		// other_reference
		// origin
		// final_destination
		// payment_terms
		// pre_carriage_receipt
		// place_of_receipt
		// loading_port
		// port_discharge
		// d_01
		// description_01
		// d_02
		// description_02
		// gross_weight
		// nett_weight
		// cbm
		// exporter_bank_details
		// intermediary_bank
		// shipment_mode
		// ex_factory_date
		// sailing_date
		// operator
		// datetime
		// delivery_terms
		// po_date
		// cart_lines
		// pl_lines
		// freezed
		// pl_pdf
		// in_pdf
		// a_operator
		// port_delivery
		// dispatch_details

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// exporter
			$curVal = strval($this->exporter->CurrentValue);
			if ($curVal <> "") {
				$this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
				if ($this->exporter->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->exporter->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->exporter->ViewValue = $this->exporter->CurrentValue;
					}
				}
			} else {
				$this->exporter->ViewValue = NULL;
			}
			$this->exporter->ViewCustomAttributes = "";

			// consignee
			$curVal = strval($this->consignee->CurrentValue);
			if ($curVal <> "") {
				$this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
				if ($this->consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignee->ViewValue = $this->consignee->CurrentValue;
					}
				}
			} else {
				$this->consignee->ViewValue = NULL;
			}
			$this->consignee->ViewCustomAttributes = "";

			// consignee_other
			$curVal = strval($this->consignee_other->CurrentValue);
			if ($curVal <> "") {
				$this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
				if ($this->consignee_other->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignee_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
					}
				}
			} else {
				$this->consignee_other->ViewValue = NULL;
			}
			$this->consignee_other->ViewCustomAttributes = "";

			// packing_list_no
			$curVal = strval($this->packing_list_no->CurrentValue);
			if ($curVal <> "") {
				$this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
				if ($this->packing_list_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`pl_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`pl_no` != 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_list_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
						$this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_list_no->ViewValue = $this->packing_list_no->CurrentValue;
					}
				}
			} else {
				$this->packing_list_no->ViewValue = NULL;
			}
			$this->packing_list_no->ViewCustomAttributes = "";

			// d_11
			$this->d_11->ViewValue = $this->d_11->CurrentValue;
			$this->d_11->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// in_template
			$curVal = strval($this->in_template->CurrentValue);
			if ($curVal <> "") {
				$this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
				if ($this->in_template->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`apcid` between 45501 and 45999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->in_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->in_template->ViewValue = $this->in_template->CurrentValue;
					}
				}
			} else {
				$this->in_template->ViewValue = NULL;
			}
			$this->in_template->ViewCustomAttributes = "";

			// pl_template
			$curVal = strval($this->pl_template->CurrentValue);
			if ($curVal <> "") {
				$this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
				if ($this->pl_template->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`apcid` between 45001 and 45500";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_template->ViewValue = $this->pl_template->CurrentValue;
					}
				}
			} else {
				$this->pl_template->ViewValue = NULL;
			}
			$this->pl_template->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// po_no
			$this->po_no->ViewValue = $this->po_no->CurrentValue;
			$this->po_no->ViewCustomAttributes = "";

			// other_reference
			$this->other_reference->ViewValue = $this->other_reference->CurrentValue;
			$this->other_reference->ViewCustomAttributes = "";

			// origin
			$this->origin->ViewValue = $this->origin->CurrentValue;
			$this->origin->ViewCustomAttributes = "";

			// final_destination
			$this->final_destination->ViewValue = $this->final_destination->CurrentValue;
			$this->final_destination->ViewCustomAttributes = "";

			// payment_terms
			$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
			$this->payment_terms->ViewCustomAttributes = "";

			// pre_carriage_receipt
			$this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;
			$this->pre_carriage_receipt->ViewCustomAttributes = "";

			// place_of_receipt
			$this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;
			$this->place_of_receipt->ViewCustomAttributes = "";

			// loading_port
			$this->loading_port->ViewValue = $this->loading_port->CurrentValue;
			$this->loading_port->ViewCustomAttributes = "";

			// port_discharge
			$this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;
			$this->port_discharge->ViewCustomAttributes = "";

			// d_01
			$this->d_01->ViewValue = $this->d_01->CurrentValue;
			$this->d_01->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewCustomAttributes = "";

			// d_02
			$this->d_02->ViewValue = $this->d_02->CurrentValue;
			$this->d_02->ViewCustomAttributes = "";

			// description_02
			$this->description_02->ViewValue = $this->description_02->CurrentValue;
			$this->description_02->ViewCustomAttributes = "";

			// gross_weight
			$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
			$this->gross_weight->ViewCustomAttributes = "";

			// nett_weight
			$this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;
			$this->nett_weight->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// exporter_bank_details
			$this->exporter_bank_details->ViewValue = $this->exporter_bank_details->CurrentValue;
			$this->exporter_bank_details->ViewCustomAttributes = "";

			// intermediary_bank
			$this->intermediary_bank->ViewValue = $this->intermediary_bank->CurrentValue;
			$this->intermediary_bank->ViewCustomAttributes = "";

			// shipment_mode
			$this->shipment_mode->ViewValue = $this->shipment_mode->CurrentValue;
			$this->shipment_mode->ViewValue = FormatNumber($this->shipment_mode->ViewValue, 0, -2, -2, -2);
			$this->shipment_mode->ViewCustomAttributes = "";

			// ex_factory_date
			$this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
			$this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, 0);
			$this->ex_factory_date->ViewCustomAttributes = "";

			// sailing_date
			$this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
			$this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, 0);
			$this->sailing_date->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// cart_lines
			$this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;
			$this->cart_lines->ViewCustomAttributes = "";

			// pl_lines
			$this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;
			$this->pl_lines->ViewCustomAttributes = "";

			// freezed
			if (strval($this->freezed->CurrentValue) <> "") {
				$this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
			} else {
				$this->freezed->ViewValue = NULL;
			}
			$this->freezed->ViewCustomAttributes = "";

			// a_operator
			$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
			$this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, 0, -2, -2, -2);
			$this->a_operator->ViewCustomAttributes = "";

			// port_delivery
			$this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;
			$this->port_delivery->ViewCustomAttributes = "";

			// dispatch_details
			$this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;
			$this->dispatch_details->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// exporter
			$this->exporter->LinkCustomAttributes = "";
			$this->exporter->HrefValue = "";
			$this->exporter->TooltipValue = "";

			// consignee
			$this->consignee->LinkCustomAttributes = "";
			$this->consignee->HrefValue = "";
			$this->consignee->TooltipValue = "";

			// consignee_other
			$this->consignee_other->LinkCustomAttributes = "";
			$this->consignee_other->HrefValue = "";
			$this->consignee_other->TooltipValue = "";

			// packing_list_no
			$this->packing_list_no->LinkCustomAttributes = "";
			$this->packing_list_no->HrefValue = "";
			$this->packing_list_no->TooltipValue = "";

			// d_11
			$this->d_11->LinkCustomAttributes = "";
			$this->d_11->HrefValue = "";
			$this->d_11->TooltipValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";
			$this->description_11->TooltipValue = "";

			// in_template
			$this->in_template->LinkCustomAttributes = "";
			$this->in_template->HrefValue = "";
			$this->in_template->TooltipValue = "";

			// pl_template
			$this->pl_template->LinkCustomAttributes = "";
			$this->pl_template->HrefValue = "";
			$this->pl_template->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// po_no
			$this->po_no->LinkCustomAttributes = "";
			$this->po_no->HrefValue = "";
			$this->po_no->TooltipValue = "";

			// other_reference
			$this->other_reference->LinkCustomAttributes = "";
			$this->other_reference->HrefValue = "";
			$this->other_reference->TooltipValue = "";

			// origin
			$this->origin->LinkCustomAttributes = "";
			$this->origin->HrefValue = "";
			$this->origin->TooltipValue = "";

			// final_destination
			$this->final_destination->LinkCustomAttributes = "";
			$this->final_destination->HrefValue = "";
			$this->final_destination->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// pre_carriage_receipt
			$this->pre_carriage_receipt->LinkCustomAttributes = "";
			$this->pre_carriage_receipt->HrefValue = "";
			$this->pre_carriage_receipt->TooltipValue = "";

			// place_of_receipt
			$this->place_of_receipt->LinkCustomAttributes = "";
			$this->place_of_receipt->HrefValue = "";
			$this->place_of_receipt->TooltipValue = "";

			// loading_port
			$this->loading_port->LinkCustomAttributes = "";
			$this->loading_port->HrefValue = "";
			$this->loading_port->TooltipValue = "";

			// port_discharge
			$this->port_discharge->LinkCustomAttributes = "";
			$this->port_discharge->HrefValue = "";
			$this->port_discharge->TooltipValue = "";

			// d_01
			$this->d_01->LinkCustomAttributes = "";
			$this->d_01->HrefValue = "";
			$this->d_01->TooltipValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";

			// d_02
			$this->d_02->LinkCustomAttributes = "";
			$this->d_02->HrefValue = "";
			$this->d_02->TooltipValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";
			$this->description_02->TooltipValue = "";

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";
			$this->gross_weight->TooltipValue = "";

			// nett_weight
			$this->nett_weight->LinkCustomAttributes = "";
			$this->nett_weight->HrefValue = "";
			$this->nett_weight->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// exporter_bank_details
			$this->exporter_bank_details->LinkCustomAttributes = "";
			$this->exporter_bank_details->HrefValue = "";
			$this->exporter_bank_details->TooltipValue = "";

			// intermediary_bank
			$this->intermediary_bank->LinkCustomAttributes = "";
			$this->intermediary_bank->HrefValue = "";
			$this->intermediary_bank->TooltipValue = "";

			// shipment_mode
			$this->shipment_mode->LinkCustomAttributes = "";
			$this->shipment_mode->HrefValue = "";
			$this->shipment_mode->TooltipValue = "";

			// ex_factory_date
			$this->ex_factory_date->LinkCustomAttributes = "";
			$this->ex_factory_date->HrefValue = "";
			$this->ex_factory_date->TooltipValue = "";

			// sailing_date
			$this->sailing_date->LinkCustomAttributes = "";
			$this->sailing_date->HrefValue = "";
			$this->sailing_date->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// cart_lines
			$this->cart_lines->LinkCustomAttributes = "";
			$this->cart_lines->HrefValue = "";
			$this->cart_lines->TooltipValue = "";

			// pl_lines
			$this->pl_lines->LinkCustomAttributes = "";
			$this->pl_lines->HrefValue = "";
			$this->pl_lines->TooltipValue = "";

			// freezed
			$this->freezed->LinkCustomAttributes = "";
			$this->freezed->HrefValue = "";
			$this->freezed->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// port_delivery
			$this->port_delivery->LinkCustomAttributes = "";
			$this->port_delivery->HrefValue = "";
			$this->port_delivery->TooltipValue = "";

			// dispatch_details
			$this->dispatch_details->LinkCustomAttributes = "";
			$this->dispatch_details->HrefValue = "";
			$this->dispatch_details->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// exporter
			$this->exporter->EditAttrs["class"] = "form-control";
			$this->exporter->EditCustomAttributes = "";
			$curVal = trim(strval($this->exporter->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->exporter->AdvancedSearch->ViewValue = $this->exporter->lookupCacheOption($curVal);
			else
				$this->exporter->AdvancedSearch->ViewValue = $this->exporter->Lookup !== NULL && is_array($this->exporter->Lookup->Options) ? $curVal : NULL;
			if ($this->exporter->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->exporter->EditValue = array_values($this->exporter->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->exporter->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->exporter->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->exporter->EditValue = $arwrk;
			}

			// consignee
			$this->consignee->EditAttrs["class"] = "form-control";
			$this->consignee->EditCustomAttributes = "";
			$curVal = trim(strval($this->consignee->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->consignee->AdvancedSearch->ViewValue = $this->consignee->lookupCacheOption($curVal);
			else
				$this->consignee->AdvancedSearch->ViewValue = $this->consignee->Lookup !== NULL && is_array($this->consignee->Lookup->Options) ? $curVal : NULL;
			if ($this->consignee->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->consignee->EditValue = array_values($this->consignee->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->consignee->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consignee->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->consignee->EditValue = $arwrk;
			}

			// consignee_other
			$this->consignee_other->EditAttrs["class"] = "form-control";
			$this->consignee_other->EditCustomAttributes = "";
			$curVal = trim(strval($this->consignee_other->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->consignee_other->AdvancedSearch->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
			else
				$this->consignee_other->AdvancedSearch->ViewValue = $this->consignee_other->Lookup !== NULL && is_array($this->consignee_other->Lookup->Options) ? $curVal : NULL;
			if ($this->consignee_other->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->consignee_other->EditValue = array_values($this->consignee_other->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->consignee_other->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consignee_other->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->consignee_other->EditValue = $arwrk;
			}

			// packing_list_no
			$this->packing_list_no->EditAttrs["class"] = "form-control";
			$this->packing_list_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_list_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->packing_list_no->AdvancedSearch->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
			else
				$this->packing_list_no->AdvancedSearch->ViewValue = $this->packing_list_no->Lookup !== NULL && is_array($this->packing_list_no->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_list_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->packing_list_no->EditValue = array_values($this->packing_list_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`pl_no`" . SearchString("=", $this->packing_list_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`pl_no` != 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_list_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 2, -2, -2, -2);
				}
				$this->packing_list_no->EditValue = $arwrk;
			}

			// d_11
			$this->d_11->EditAttrs["class"] = "form-control";
			$this->d_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_11->AdvancedSearch->SearchValue = HtmlDecode($this->d_11->AdvancedSearch->SearchValue);
			$this->d_11->EditValue = HtmlEncode($this->d_11->AdvancedSearch->SearchValue);
			$this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

			// description_11
			$this->description_11->EditAttrs["class"] = "form-control";
			$this->description_11->EditCustomAttributes = "";
			$this->description_11->EditValue = HtmlEncode($this->description_11->AdvancedSearch->SearchValue);
			$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

			// in_template
			$this->in_template->EditAttrs["class"] = "form-control";
			$this->in_template->EditCustomAttributes = "";
			$curVal = trim(strval($this->in_template->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->in_template->AdvancedSearch->ViewValue = $this->in_template->lookupCacheOption($curVal);
			else
				$this->in_template->AdvancedSearch->ViewValue = $this->in_template->Lookup !== NULL && is_array($this->in_template->Lookup->Options) ? $curVal : NULL;
			if ($this->in_template->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->in_template->EditValue = array_values($this->in_template->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->in_template->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`apcid` between 45501 and 45999";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->in_template->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->in_template->EditValue = $arwrk;
			}

			// pl_template
			$this->pl_template->EditAttrs["class"] = "form-control";
			$this->pl_template->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_template->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->pl_template->AdvancedSearch->ViewValue = $this->pl_template->lookupCacheOption($curVal);
			else
				$this->pl_template->AdvancedSearch->ViewValue = $this->pl_template->Lookup !== NULL && is_array($this->pl_template->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_template->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->pl_template->EditValue = array_values($this->pl_template->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_template->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`apcid` between 45001 and 45500";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_template->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_template->EditValue = $arwrk;
			}

			// invoice_no
			$this->invoice_no->EditAttrs["class"] = "form-control";
			$this->invoice_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice_no->AdvancedSearch->SearchValue = HtmlDecode($this->invoice_no->AdvancedSearch->SearchValue);
			$this->invoice_no->EditValue = HtmlEncode($this->invoice_no->AdvancedSearch->SearchValue);
			$this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, 0), 8));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// po_no
			$this->po_no->EditAttrs["class"] = "form-control";
			$this->po_no->EditCustomAttributes = "";
			$this->po_no->EditValue = HtmlEncode($this->po_no->AdvancedSearch->SearchValue);
			$this->po_no->PlaceHolder = RemoveHtml($this->po_no->caption());

			// other_reference
			$this->other_reference->EditAttrs["class"] = "form-control";
			$this->other_reference->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other_reference->AdvancedSearch->SearchValue = HtmlDecode($this->other_reference->AdvancedSearch->SearchValue);
			$this->other_reference->EditValue = HtmlEncode($this->other_reference->AdvancedSearch->SearchValue);
			$this->other_reference->PlaceHolder = RemoveHtml($this->other_reference->caption());

			// origin
			$this->origin->EditAttrs["class"] = "form-control";
			$this->origin->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->origin->AdvancedSearch->SearchValue = HtmlDecode($this->origin->AdvancedSearch->SearchValue);
			$this->origin->EditValue = HtmlEncode($this->origin->AdvancedSearch->SearchValue);
			$this->origin->PlaceHolder = RemoveHtml($this->origin->caption());

			// final_destination
			$this->final_destination->EditAttrs["class"] = "form-control";
			$this->final_destination->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->final_destination->AdvancedSearch->SearchValue = HtmlDecode($this->final_destination->AdvancedSearch->SearchValue);
			$this->final_destination->EditValue = HtmlEncode($this->final_destination->AdvancedSearch->SearchValue);
			$this->final_destination->PlaceHolder = RemoveHtml($this->final_destination->caption());

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			$this->payment_terms->EditValue = HtmlEncode($this->payment_terms->AdvancedSearch->SearchValue);
			$this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

			// pre_carriage_receipt
			$this->pre_carriage_receipt->EditAttrs["class"] = "form-control";
			$this->pre_carriage_receipt->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pre_carriage_receipt->AdvancedSearch->SearchValue = HtmlDecode($this->pre_carriage_receipt->AdvancedSearch->SearchValue);
			$this->pre_carriage_receipt->EditValue = HtmlEncode($this->pre_carriage_receipt->AdvancedSearch->SearchValue);
			$this->pre_carriage_receipt->PlaceHolder = RemoveHtml($this->pre_carriage_receipt->caption());

			// place_of_receipt
			$this->place_of_receipt->EditAttrs["class"] = "form-control";
			$this->place_of_receipt->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->place_of_receipt->AdvancedSearch->SearchValue = HtmlDecode($this->place_of_receipt->AdvancedSearch->SearchValue);
			$this->place_of_receipt->EditValue = HtmlEncode($this->place_of_receipt->AdvancedSearch->SearchValue);
			$this->place_of_receipt->PlaceHolder = RemoveHtml($this->place_of_receipt->caption());

			// loading_port
			$this->loading_port->EditAttrs["class"] = "form-control";
			$this->loading_port->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->loading_port->AdvancedSearch->SearchValue = HtmlDecode($this->loading_port->AdvancedSearch->SearchValue);
			$this->loading_port->EditValue = HtmlEncode($this->loading_port->AdvancedSearch->SearchValue);
			$this->loading_port->PlaceHolder = RemoveHtml($this->loading_port->caption());

			// port_discharge
			$this->port_discharge->EditAttrs["class"] = "form-control";
			$this->port_discharge->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->port_discharge->AdvancedSearch->SearchValue = HtmlDecode($this->port_discharge->AdvancedSearch->SearchValue);
			$this->port_discharge->EditValue = HtmlEncode($this->port_discharge->AdvancedSearch->SearchValue);
			$this->port_discharge->PlaceHolder = RemoveHtml($this->port_discharge->caption());

			// d_01
			$this->d_01->EditAttrs["class"] = "form-control";
			$this->d_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_01->AdvancedSearch->SearchValue = HtmlDecode($this->d_01->AdvancedSearch->SearchValue);
			$this->d_01->EditValue = HtmlEncode($this->d_01->AdvancedSearch->SearchValue);
			$this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

			// description_01
			$this->description_01->EditAttrs["class"] = "form-control";
			$this->description_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_01->AdvancedSearch->SearchValue = HtmlDecode($this->description_01->AdvancedSearch->SearchValue);
			$this->description_01->EditValue = HtmlEncode($this->description_01->AdvancedSearch->SearchValue);
			$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

			// d_02
			$this->d_02->EditAttrs["class"] = "form-control";
			$this->d_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_02->AdvancedSearch->SearchValue = HtmlDecode($this->d_02->AdvancedSearch->SearchValue);
			$this->d_02->EditValue = HtmlEncode($this->d_02->AdvancedSearch->SearchValue);
			$this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

			// description_02
			$this->description_02->EditAttrs["class"] = "form-control";
			$this->description_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_02->AdvancedSearch->SearchValue = HtmlDecode($this->description_02->AdvancedSearch->SearchValue);
			$this->description_02->EditValue = HtmlEncode($this->description_02->AdvancedSearch->SearchValue);
			$this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

			// gross_weight
			$this->gross_weight->EditAttrs["class"] = "form-control";
			$this->gross_weight->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->gross_weight->AdvancedSearch->SearchValue = HtmlDecode($this->gross_weight->AdvancedSearch->SearchValue);
			$this->gross_weight->EditValue = HtmlEncode($this->gross_weight->AdvancedSearch->SearchValue);
			$this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());

			// nett_weight
			$this->nett_weight->EditAttrs["class"] = "form-control";
			$this->nett_weight->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->nett_weight->AdvancedSearch->SearchValue = HtmlDecode($this->nett_weight->AdvancedSearch->SearchValue);
			$this->nett_weight->EditValue = HtmlEncode($this->nett_weight->AdvancedSearch->SearchValue);
			$this->nett_weight->PlaceHolder = RemoveHtml($this->nett_weight->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cbm->AdvancedSearch->SearchValue = HtmlDecode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// exporter_bank_details
			$this->exporter_bank_details->EditAttrs["class"] = "form-control";
			$this->exporter_bank_details->EditCustomAttributes = "";
			$this->exporter_bank_details->EditValue = HtmlEncode($this->exporter_bank_details->AdvancedSearch->SearchValue);
			$this->exporter_bank_details->PlaceHolder = RemoveHtml($this->exporter_bank_details->caption());

			// intermediary_bank
			$this->intermediary_bank->EditAttrs["class"] = "form-control";
			$this->intermediary_bank->EditCustomAttributes = "";
			$this->intermediary_bank->EditValue = HtmlEncode($this->intermediary_bank->AdvancedSearch->SearchValue);
			$this->intermediary_bank->PlaceHolder = RemoveHtml($this->intermediary_bank->caption());

			// shipment_mode
			$this->shipment_mode->EditAttrs["class"] = "form-control";
			$this->shipment_mode->EditCustomAttributes = "";
			$this->shipment_mode->EditValue = HtmlEncode($this->shipment_mode->AdvancedSearch->SearchValue);
			$this->shipment_mode->PlaceHolder = RemoveHtml($this->shipment_mode->caption());

			// ex_factory_date
			$this->ex_factory_date->EditAttrs["class"] = "form-control";
			$this->ex_factory_date->EditCustomAttributes = "";
			$this->ex_factory_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->ex_factory_date->AdvancedSearch->SearchValue, 0), 8));
			$this->ex_factory_date->PlaceHolder = RemoveHtml($this->ex_factory_date->caption());

			// sailing_date
			$this->sailing_date->EditAttrs["class"] = "form-control";
			$this->sailing_date->EditCustomAttributes = "";
			$this->sailing_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->sailing_date->AdvancedSearch->SearchValue, 0), 8));
			$this->sailing_date->PlaceHolder = RemoveHtml($this->sailing_date->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// cart_lines
			$this->cart_lines->EditAttrs["class"] = "form-control";
			$this->cart_lines->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cart_lines->AdvancedSearch->SearchValue = HtmlDecode($this->cart_lines->AdvancedSearch->SearchValue);
			$this->cart_lines->EditValue = HtmlEncode($this->cart_lines->AdvancedSearch->SearchValue);
			$this->cart_lines->PlaceHolder = RemoveHtml($this->cart_lines->caption());

			// pl_lines
			$this->pl_lines->EditAttrs["class"] = "form-control";
			$this->pl_lines->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pl_lines->AdvancedSearch->SearchValue = HtmlDecode($this->pl_lines->AdvancedSearch->SearchValue);
			$this->pl_lines->EditValue = HtmlEncode($this->pl_lines->AdvancedSearch->SearchValue);
			$this->pl_lines->PlaceHolder = RemoveHtml($this->pl_lines->caption());

			// freezed
			$this->freezed->EditAttrs["class"] = "form-control";
			$this->freezed->EditCustomAttributes = "";
			$this->freezed->EditValue = $this->freezed->options(TRUE);

			// a_operator
			$this->a_operator->EditAttrs["class"] = "form-control";
			$this->a_operator->EditCustomAttributes = "";
			$this->a_operator->EditValue = HtmlEncode($this->a_operator->AdvancedSearch->SearchValue);
			$this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

			// port_delivery
			$this->port_delivery->EditAttrs["class"] = "form-control";
			$this->port_delivery->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->port_delivery->AdvancedSearch->SearchValue = HtmlDecode($this->port_delivery->AdvancedSearch->SearchValue);
			$this->port_delivery->EditValue = HtmlEncode($this->port_delivery->AdvancedSearch->SearchValue);
			$this->port_delivery->PlaceHolder = RemoveHtml($this->port_delivery->caption());

			// dispatch_details
			$this->dispatch_details->EditAttrs["class"] = "form-control";
			$this->dispatch_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->dispatch_details->AdvancedSearch->SearchValue = HtmlDecode($this->dispatch_details->AdvancedSearch->SearchValue);
			$this->dispatch_details->EditValue = HtmlEncode($this->dispatch_details->AdvancedSearch->SearchValue);
			$this->dispatch_details->PlaceHolder = RemoveHtml($this->dispatch_details->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->invoice_date->errorMessage());
		}
		if (!CheckInteger($this->shipment_mode->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->shipment_mode->errorMessage());
		}
		if (!CheckDate($this->ex_factory_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->ex_factory_date->errorMessage());
		}
		if (!CheckDate($this->sailing_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sailing_date->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->a_operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->a_operator->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->exporter->AdvancedSearch->load();
		$this->consignee->AdvancedSearch->load();
		$this->consignee_other->AdvancedSearch->load();
		$this->packing_list_no->AdvancedSearch->load();
		$this->d_11->AdvancedSearch->load();
		$this->description_11->AdvancedSearch->load();
		$this->in_template->AdvancedSearch->load();
		$this->pl_template->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->po_no->AdvancedSearch->load();
		$this->other_reference->AdvancedSearch->load();
		$this->origin->AdvancedSearch->load();
		$this->final_destination->AdvancedSearch->load();
		$this->payment_terms->AdvancedSearch->load();
		$this->pre_carriage_receipt->AdvancedSearch->load();
		$this->place_of_receipt->AdvancedSearch->load();
		$this->loading_port->AdvancedSearch->load();
		$this->port_discharge->AdvancedSearch->load();
		$this->d_01->AdvancedSearch->load();
		$this->description_01->AdvancedSearch->load();
		$this->d_02->AdvancedSearch->load();
		$this->description_02->AdvancedSearch->load();
		$this->gross_weight->AdvancedSearch->load();
		$this->nett_weight->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->exporter_bank_details->AdvancedSearch->load();
		$this->intermediary_bank->AdvancedSearch->load();
		$this->shipment_mode->AdvancedSearch->load();
		$this->ex_factory_date->AdvancedSearch->load();
		$this->sailing_date->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->cart_lines->AdvancedSearch->load();
		$this->pl_lines->AdvancedSearch->load();
		$this->freezed->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->port_delivery->AdvancedSearch->load();
		$this->dispatch_details->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("invoice_detailslist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_exporter":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignee":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignee_other":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_list_no":
					$lookupFilter = function() {
						return "`pl_no` != 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_in_template":
					$lookupFilter = function() {
						return "`apcid` between 45501 and 45999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_template":
					$lookupFilter = function() {
						return "`apcid` between 45001 and 45500";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_exporter":
							break;
						case "x_consignee":
							break;
						case "x_consignee_other":
							break;
						case "x_packing_list_no":
							$row[1] = FormatNumber($row[1], 2, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_in_template":
							break;
						case "x_pl_template":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>