<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class invoice_details_view extends invoice_details
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'invoice_details';

	// Page object name
	public $PageObjName = "invoice_details_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (invoice_details)
		if (!isset($GLOBALS["invoice_details"]) || get_class($GLOBALS["invoice_details"]) == PROJECT_NAMESPACE . "invoice_details") {
			$GLOBALS["invoice_details"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["invoice_details"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'invoice_details');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $invoice_details;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($invoice_details);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "invoice_detailsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("invoice_detailslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->_barcode->setVisibility();
		$this->exporter->setVisibility();
		$this->consignee->setVisibility();
		$this->consignee_other->setVisibility();
		$this->packing_list_no->setVisibility();
		$this->d_11->setVisibility();
		$this->description_11->setVisibility();
		$this->in_template->setVisibility();
		$this->pl_template->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->po_no->setVisibility();
		$this->other_reference->setVisibility();
		$this->origin->setVisibility();
		$this->final_destination->setVisibility();
		$this->payment_terms->setVisibility();
		$this->pre_carriage_receipt->setVisibility();
		$this->place_of_receipt->setVisibility();
		$this->loading_port->setVisibility();
		$this->port_discharge->setVisibility();
		$this->d_01->setVisibility();
		$this->description_01->setVisibility();
		$this->d_02->setVisibility();
		$this->description_02->setVisibility();
		$this->gross_weight->setVisibility();
		$this->nett_weight->setVisibility();
		$this->cbm->setVisibility();
		$this->exporter_bank_details->setVisibility();
		$this->intermediary_bank->setVisibility();
		$this->shipment_mode->setVisibility();
		$this->ex_factory_date->setVisibility();
		$this->sailing_date->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->delivery_terms->Visible = FALSE;
		$this->po_date->Visible = FALSE;
		$this->cart_lines->setVisibility();
		$this->pl_lines->setVisibility();
		$this->freezed->setVisibility();
		$this->pl_pdf->Visible = FALSE;
		$this->in_pdf->Visible = FALSE;
		$this->a_operator->setVisibility();
		$this->port_delivery->setVisibility();
		$this->dispatch_details->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->exporter);
		$this->setupLookupOptions($this->consignee);
		$this->setupLookupOptions($this->consignee_other);
		$this->setupLookupOptions($this->packing_list_no);
		$this->setupLookupOptions($this->in_template);
		$this->setupLookupOptions($this->pl_template);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "invoice_detailslist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "invoice_detailslist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "invoice_detailslist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->canAdd());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->canDelete());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		if ($this->AuditTrailOnView)
			$this->writeAuditTrailOnView($row);
		$this->id->setDbValue($row['id']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->exporter->setDbValue($row['exporter']);
		$this->consignee->setDbValue($row['consignee']);
		$this->consignee_other->setDbValue($row['consignee_other']);
		$this->packing_list_no->setDbValue($row['packing_list_no']);
		$this->d_11->setDbValue($row['d_11']);
		$this->description_11->setDbValue($row['description_11']);
		$this->in_template->setDbValue($row['in_template']);
		$this->pl_template->setDbValue($row['pl_template']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->po_no->setDbValue($row['po_no']);
		$this->other_reference->setDbValue($row['other_reference']);
		$this->origin->setDbValue($row['origin']);
		$this->final_destination->setDbValue($row['final_destination']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->pre_carriage_receipt->setDbValue($row['pre_carriage_receipt']);
		$this->place_of_receipt->setDbValue($row['place_of_receipt']);
		$this->loading_port->setDbValue($row['loading_port']);
		$this->port_discharge->setDbValue($row['port_discharge']);
		$this->d_01->setDbValue($row['d_01']);
		$this->description_01->setDbValue($row['description_01']);
		$this->d_02->setDbValue($row['d_02']);
		$this->description_02->setDbValue($row['description_02']);
		$this->gross_weight->setDbValue($row['gross_weight']);
		$this->nett_weight->setDbValue($row['nett_weight']);
		$this->cbm->setDbValue($row['cbm']);
		$this->exporter_bank_details->setDbValue($row['exporter_bank_details']);
		$this->intermediary_bank->setDbValue($row['intermediary_bank']);
		$this->shipment_mode->setDbValue($row['shipment_mode']);
		$this->ex_factory_date->setDbValue($row['ex_factory_date']);
		$this->sailing_date->setDbValue($row['sailing_date']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->delivery_terms->setDbValue($row['delivery_terms']);
		$this->po_date->setDbValue($row['po_date']);
		$this->cart_lines->setDbValue($row['cart_lines']);
		$this->pl_lines->setDbValue($row['pl_lines']);
		$this->freezed->setDbValue($row['freezed']);
		$this->pl_pdf->setDbValue($row['pl_pdf']);
		$this->in_pdf->setDbValue($row['in_pdf']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->port_delivery->setDbValue($row['port_delivery']);
		$this->dispatch_details->setDbValue($row['dispatch_details']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['barcode'] = NULL;
		$row['exporter'] = NULL;
		$row['consignee'] = NULL;
		$row['consignee_other'] = NULL;
		$row['packing_list_no'] = NULL;
		$row['d_11'] = NULL;
		$row['description_11'] = NULL;
		$row['in_template'] = NULL;
		$row['pl_template'] = NULL;
		$row['invoice_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['po_no'] = NULL;
		$row['other_reference'] = NULL;
		$row['origin'] = NULL;
		$row['final_destination'] = NULL;
		$row['payment_terms'] = NULL;
		$row['pre_carriage_receipt'] = NULL;
		$row['place_of_receipt'] = NULL;
		$row['loading_port'] = NULL;
		$row['port_discharge'] = NULL;
		$row['d_01'] = NULL;
		$row['description_01'] = NULL;
		$row['d_02'] = NULL;
		$row['description_02'] = NULL;
		$row['gross_weight'] = NULL;
		$row['nett_weight'] = NULL;
		$row['cbm'] = NULL;
		$row['exporter_bank_details'] = NULL;
		$row['intermediary_bank'] = NULL;
		$row['shipment_mode'] = NULL;
		$row['ex_factory_date'] = NULL;
		$row['sailing_date'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['delivery_terms'] = NULL;
		$row['po_date'] = NULL;
		$row['cart_lines'] = NULL;
		$row['pl_lines'] = NULL;
		$row['freezed'] = NULL;
		$row['pl_pdf'] = NULL;
		$row['in_pdf'] = NULL;
		$row['a_operator'] = NULL;
		$row['port_delivery'] = NULL;
		$row['dispatch_details'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// barcode
		// exporter
		// consignee
		// consignee_other
		// packing_list_no
		// d_11
		// description_11
		// in_template
		// pl_template
		// invoice_no
		// invoice_date
		// po_no
		// other_reference
		// origin
		// final_destination
		// payment_terms
		// pre_carriage_receipt
		// place_of_receipt
		// loading_port
		// port_discharge
		// d_01
		// description_01
		// d_02
		// description_02
		// gross_weight
		// nett_weight
		// cbm
		// exporter_bank_details
		// intermediary_bank
		// shipment_mode
		// ex_factory_date
		// sailing_date
		// operator
		// datetime
		// delivery_terms
		// po_date
		// cart_lines
		// pl_lines
		// freezed
		// pl_pdf
		// in_pdf
		// a_operator
		// port_delivery
		// dispatch_details

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// exporter
			$curVal = strval($this->exporter->CurrentValue);
			if ($curVal <> "") {
				$this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
				if ($this->exporter->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->exporter->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->exporter->ViewValue = $this->exporter->CurrentValue;
					}
				}
			} else {
				$this->exporter->ViewValue = NULL;
			}
			$this->exporter->ViewCustomAttributes = "";

			// consignee
			$curVal = strval($this->consignee->CurrentValue);
			if ($curVal <> "") {
				$this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
				if ($this->consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignee->ViewValue = $this->consignee->CurrentValue;
					}
				}
			} else {
				$this->consignee->ViewValue = NULL;
			}
			$this->consignee->ViewCustomAttributes = "";

			// consignee_other
			$curVal = strval($this->consignee_other->CurrentValue);
			if ($curVal <> "") {
				$this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
				if ($this->consignee_other->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignee_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
					}
				}
			} else {
				$this->consignee_other->ViewValue = NULL;
			}
			$this->consignee_other->ViewCustomAttributes = "";

			// packing_list_no
			$curVal = strval($this->packing_list_no->CurrentValue);
			if ($curVal <> "") {
				$this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
				if ($this->packing_list_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`pl_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`pl_no` != 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_list_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
						$this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_list_no->ViewValue = $this->packing_list_no->CurrentValue;
					}
				}
			} else {
				$this->packing_list_no->ViewValue = NULL;
			}
			$this->packing_list_no->ViewCustomAttributes = "";

			// d_11
			$this->d_11->ViewValue = $this->d_11->CurrentValue;
			$this->d_11->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// in_template
			$curVal = strval($this->in_template->CurrentValue);
			if ($curVal <> "") {
				$this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
				if ($this->in_template->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`apcid` between 45501 and 45999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->in_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->in_template->ViewValue = $this->in_template->CurrentValue;
					}
				}
			} else {
				$this->in_template->ViewValue = NULL;
			}
			$this->in_template->ViewCustomAttributes = "";

			// pl_template
			$curVal = strval($this->pl_template->CurrentValue);
			if ($curVal <> "") {
				$this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
				if ($this->pl_template->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`apcid` between 45001 and 45500";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_template->ViewValue = $this->pl_template->CurrentValue;
					}
				}
			} else {
				$this->pl_template->ViewValue = NULL;
			}
			$this->pl_template->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// po_no
			$this->po_no->ViewValue = $this->po_no->CurrentValue;
			$this->po_no->ViewCustomAttributes = "";

			// other_reference
			$this->other_reference->ViewValue = $this->other_reference->CurrentValue;
			$this->other_reference->ViewCustomAttributes = "";

			// origin
			$this->origin->ViewValue = $this->origin->CurrentValue;
			$this->origin->ViewCustomAttributes = "";

			// final_destination
			$this->final_destination->ViewValue = $this->final_destination->CurrentValue;
			$this->final_destination->ViewCustomAttributes = "";

			// payment_terms
			$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
			$this->payment_terms->ViewCustomAttributes = "";

			// pre_carriage_receipt
			$this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;
			$this->pre_carriage_receipt->ViewCustomAttributes = "";

			// place_of_receipt
			$this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;
			$this->place_of_receipt->ViewCustomAttributes = "";

			// loading_port
			$this->loading_port->ViewValue = $this->loading_port->CurrentValue;
			$this->loading_port->ViewCustomAttributes = "";

			// port_discharge
			$this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;
			$this->port_discharge->ViewCustomAttributes = "";

			// d_01
			$this->d_01->ViewValue = $this->d_01->CurrentValue;
			$this->d_01->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewCustomAttributes = "";

			// d_02
			$this->d_02->ViewValue = $this->d_02->CurrentValue;
			$this->d_02->ViewCustomAttributes = "";

			// description_02
			$this->description_02->ViewValue = $this->description_02->CurrentValue;
			$this->description_02->ViewCustomAttributes = "";

			// gross_weight
			$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
			$this->gross_weight->ViewCustomAttributes = "";

			// nett_weight
			$this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;
			$this->nett_weight->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// exporter_bank_details
			$this->exporter_bank_details->ViewValue = $this->exporter_bank_details->CurrentValue;
			$this->exporter_bank_details->ViewCustomAttributes = "";

			// intermediary_bank
			$this->intermediary_bank->ViewValue = $this->intermediary_bank->CurrentValue;
			$this->intermediary_bank->ViewCustomAttributes = "";

			// shipment_mode
			$this->shipment_mode->ViewValue = $this->shipment_mode->CurrentValue;
			$this->shipment_mode->ViewValue = FormatNumber($this->shipment_mode->ViewValue, 0, -2, -2, -2);
			$this->shipment_mode->ViewCustomAttributes = "";

			// ex_factory_date
			$this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
			$this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, 0);
			$this->ex_factory_date->ViewCustomAttributes = "";

			// sailing_date
			$this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
			$this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, 0);
			$this->sailing_date->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// cart_lines
			$this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;
			$this->cart_lines->ViewCustomAttributes = "";

			// pl_lines
			$this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;
			$this->pl_lines->ViewCustomAttributes = "";

			// freezed
			if (strval($this->freezed->CurrentValue) <> "") {
				$this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
			} else {
				$this->freezed->ViewValue = NULL;
			}
			$this->freezed->ViewCustomAttributes = "";

			// a_operator
			$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
			$this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, 0, -2, -2, -2);
			$this->a_operator->ViewCustomAttributes = "";

			// port_delivery
			$this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;
			$this->port_delivery->ViewCustomAttributes = "";

			// dispatch_details
			$this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;
			$this->dispatch_details->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// exporter
			$this->exporter->LinkCustomAttributes = "";
			$this->exporter->HrefValue = "";
			$this->exporter->TooltipValue = "";

			// consignee
			$this->consignee->LinkCustomAttributes = "";
			$this->consignee->HrefValue = "";
			$this->consignee->TooltipValue = "";

			// consignee_other
			$this->consignee_other->LinkCustomAttributes = "";
			$this->consignee_other->HrefValue = "";
			$this->consignee_other->TooltipValue = "";

			// packing_list_no
			$this->packing_list_no->LinkCustomAttributes = "";
			$this->packing_list_no->HrefValue = "";
			$this->packing_list_no->TooltipValue = "";

			// d_11
			$this->d_11->LinkCustomAttributes = "";
			$this->d_11->HrefValue = "";
			$this->d_11->TooltipValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";
			$this->description_11->TooltipValue = "";

			// in_template
			$this->in_template->LinkCustomAttributes = "";
			$this->in_template->HrefValue = "";
			$this->in_template->TooltipValue = "";

			// pl_template
			$this->pl_template->LinkCustomAttributes = "";
			$this->pl_template->HrefValue = "";
			$this->pl_template->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// po_no
			$this->po_no->LinkCustomAttributes = "";
			$this->po_no->HrefValue = "";
			$this->po_no->TooltipValue = "";

			// other_reference
			$this->other_reference->LinkCustomAttributes = "";
			$this->other_reference->HrefValue = "";
			$this->other_reference->TooltipValue = "";

			// origin
			$this->origin->LinkCustomAttributes = "";
			$this->origin->HrefValue = "";
			$this->origin->TooltipValue = "";

			// final_destination
			$this->final_destination->LinkCustomAttributes = "";
			$this->final_destination->HrefValue = "";
			$this->final_destination->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// pre_carriage_receipt
			$this->pre_carriage_receipt->LinkCustomAttributes = "";
			$this->pre_carriage_receipt->HrefValue = "";
			$this->pre_carriage_receipt->TooltipValue = "";

			// place_of_receipt
			$this->place_of_receipt->LinkCustomAttributes = "";
			$this->place_of_receipt->HrefValue = "";
			$this->place_of_receipt->TooltipValue = "";

			// loading_port
			$this->loading_port->LinkCustomAttributes = "";
			$this->loading_port->HrefValue = "";
			$this->loading_port->TooltipValue = "";

			// port_discharge
			$this->port_discharge->LinkCustomAttributes = "";
			$this->port_discharge->HrefValue = "";
			$this->port_discharge->TooltipValue = "";

			// d_01
			$this->d_01->LinkCustomAttributes = "";
			$this->d_01->HrefValue = "";
			$this->d_01->TooltipValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";

			// d_02
			$this->d_02->LinkCustomAttributes = "";
			$this->d_02->HrefValue = "";
			$this->d_02->TooltipValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";
			$this->description_02->TooltipValue = "";

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";
			$this->gross_weight->TooltipValue = "";

			// nett_weight
			$this->nett_weight->LinkCustomAttributes = "";
			$this->nett_weight->HrefValue = "";
			$this->nett_weight->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// exporter_bank_details
			$this->exporter_bank_details->LinkCustomAttributes = "";
			$this->exporter_bank_details->HrefValue = "";
			$this->exporter_bank_details->TooltipValue = "";

			// intermediary_bank
			$this->intermediary_bank->LinkCustomAttributes = "";
			$this->intermediary_bank->HrefValue = "";
			$this->intermediary_bank->TooltipValue = "";

			// shipment_mode
			$this->shipment_mode->LinkCustomAttributes = "";
			$this->shipment_mode->HrefValue = "";
			$this->shipment_mode->TooltipValue = "";

			// ex_factory_date
			$this->ex_factory_date->LinkCustomAttributes = "";
			$this->ex_factory_date->HrefValue = "";
			$this->ex_factory_date->TooltipValue = "";

			// sailing_date
			$this->sailing_date->LinkCustomAttributes = "";
			$this->sailing_date->HrefValue = "";
			$this->sailing_date->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// cart_lines
			$this->cart_lines->LinkCustomAttributes = "";
			$this->cart_lines->HrefValue = "";
			$this->cart_lines->TooltipValue = "";

			// pl_lines
			$this->pl_lines->LinkCustomAttributes = "";
			$this->pl_lines->HrefValue = "";
			$this->pl_lines->TooltipValue = "";

			// freezed
			$this->freezed->LinkCustomAttributes = "";
			$this->freezed->HrefValue = "";
			$this->freezed->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// port_delivery
			$this->port_delivery->LinkCustomAttributes = "";
			$this->port_delivery->HrefValue = "";
			$this->port_delivery->TooltipValue = "";

			// dispatch_details
			$this->dispatch_details->LinkCustomAttributes = "";
			$this->dispatch_details->HrefValue = "";
			$this->dispatch_details->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("invoice_detailslist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_exporter":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignee":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignee_other":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_list_no":
					$lookupFilter = function() {
						return "`pl_no` != 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_in_template":
					$lookupFilter = function() {
						return "`apcid` between 45501 and 45999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_template":
					$lookupFilter = function() {
						return "`apcid` between 45001 and 45500";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_exporter":
							break;
						case "x_consignee":
							break;
						case "x_consignee_other":
							break;
						case "x_packing_list_no":
							$row[1] = FormatNumber($row[1], 2, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_in_template":
							break;
						case "x_pl_template":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>