<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for job_card
 */
class job_card extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $jc_no;
	public $works;
	public $issue_to_internal;
	public $issue_to_external;
	public $issue_to;
	public $grp;
	public $s_grp;
	public $packing_type;
	public $product_code;
	public $item;
	public $poid;
	public $po;
	public $batch_no;
	public $quantity;
	public $lot_no;
	public $pro_unit;
	public $employee_id;
	public $_1;
	public $_2;
	public $_3;
	public $_4;
	public $_5;
	public $_6;
	public $_7;
	public $_8;
	public $other1;
	public $other2;
	public $operator;
	public $datetime;
	public $updated;
	public $in_id;
	public $balance_quantity;
	public $product;
	public $buyer_id;
	public $company_id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'job_card';
		$this->TableName = 'job_card';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`job_card`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('job_card', 'job_card', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// jc_no
		$this->jc_no = new DbField('job_card', 'job_card', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 19, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Required = TRUE; // Required field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// works
		$this->works = new DbField('job_card', 'job_card', 'x_works', 'works', '`works`', '`works`', 17, -1, FALSE, '`works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->works->Sortable = TRUE; // Allow sort
		$this->works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->works->Lookup = new Lookup('works', 'godown_table', TRUE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['works'] = &$this->works;

		// issue_to_internal
		$this->issue_to_internal = new DbField('job_card', 'job_card', 'x_issue_to_internal', 'issue_to_internal', '0', '0', 3, -1, FALSE, '0', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to_internal->IsCustom = TRUE; // Custom field
		$this->issue_to_internal->Sortable = TRUE; // Allow sort
		$this->issue_to_internal->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to_internal->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to_internal->Lookup = new Lookup('issue_to_internal', 'buyer_seller_view', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->issue_to_internal->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to_internal'] = &$this->issue_to_internal;

		// issue_to_external
		$this->issue_to_external = new DbField('job_card', 'job_card', 'x_issue_to_external', 'issue_to_external', '0', '0', 3, -1, FALSE, '0', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to_external->IsCustom = TRUE; // Custom field
		$this->issue_to_external->Sortable = TRUE; // Allow sort
		$this->issue_to_external->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to_external->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to_external->Lookup = new Lookup('issue_to_external', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->issue_to_external->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to_external'] = &$this->issue_to_external;

		// issue_to
		$this->issue_to = new DbField('job_card', 'job_card', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 3, -1, FALSE, '`issue_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to->Required = TRUE; // Required field
		$this->issue_to->Sortable = TRUE; // Allow sort
		$this->issue_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to->Lookup = new Lookup('issue_to', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to'] = &$this->issue_to;

		// grp
		$this->grp = new DbField('job_card', 'job_card', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp","x_product_code","x_pro_unit"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('job_card', 'job_card', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 17, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product_code"], ["grp"], ["x_grp"], [], [], '', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// packing_type
		$this->packing_type = new DbField('job_card', 'job_card', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 2, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type_table', FALSE, 'id', ["code","packing","",""], [], ["x_product_code","x_poid[]","x_batch_no"], [], [], [], [], '`code` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// product_code
		$this->product_code = new DbField('job_card', 'job_card', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 2, -1, FALSE, '`EV__product_code`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->product_code->Required = TRUE; // Required field
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->product_code->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_code->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_code->Lookup = new Lookup('product_code', 'po_pending_wbc', TRUE, 'id', ["product_code","","",""], ["x_s_grp","x_grp","x_packing_type"], [], ["s_grp","grp","packing_type"], ["x_s_grp","x_grp","x_packing_type"], ["rid","batch_no"], ["x_item","x_batch_no"], '`product_code` ASC', '');
		$this->fields['product_code'] = &$this->product_code;

		// item
		$this->item = new DbField('job_card', 'job_card', 'x_item', 'item', '`item`', '`item`', 2, -1, FALSE, '`EV__item`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->item->Sortable = FALSE; // Allow sort
		$this->item->Lookup = new Lookup('item', 'ref', FALSE, 'id', ["product_code","","",""], [], ["x_poid[]","x_batch_no"], [], [], [], [], '`product_code` ASC', '');
		$this->fields['item'] = &$this->item;

		// poid
		$this->poid = new DbField('job_card', 'job_card', 'x_poid', 'poid', '`poid`', '`poid`', 200, -1, FALSE, '`poid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->poid->Nullable = FALSE; // NOT NULL field
		$this->poid->Required = TRUE; // Required field
		$this->poid->Sortable = FALSE; // Allow sort
		$this->poid->Lookup = new Lookup('poid', 'po_pending_wbc', TRUE, 'id', ["po","product_code","pending_qty","jc_no"], ["x_item","x_packing_type"], [], ["rid","packing_type"], ["x_rid","x_packing_type"], ["rid"], ["x_product_code"], '`po` ASC', '<span class="text-info">PO : {{:df1}}, Code : {{:df2}}, Qty : {{:df3}}, <span style="color:red">JC# : {{:df4}}</span></span>');
		$this->fields['poid'] = &$this->poid;

		// po
		$this->po = new DbField('job_card', 'job_card', 'x_po', 'po', '`po`', '`po`', 200, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->Lookup = new Lookup('po', 'po_pending_wbc', TRUE, 'id', ["po","","",""], [], [], [], [], [], [], '`po` ASC', '');
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// batch_no
		$this->batch_no = new DbField('job_card', 'job_card', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 200, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', TRUE, 'id', ["id","batch_no","",""], ["x_item","x_packing_type"], [], ["rid","packing_type"], ["x_rid","x_packing_type"], ["process"], ["x_pro_unit"], '`batch_no` ASC', '');
		$this->fields['batch_no'] = &$this->batch_no;

		// quantity
		$this->quantity = new DbField('job_card', 'job_card', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 4, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// lot_no
		$this->lot_no = new DbField('job_card', 'job_card', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Sortable = FALSE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// pro_unit
		$this->pro_unit = new DbField('job_card', 'job_card', 'x_pro_unit', 'pro_unit', '`pro_unit`', '`pro_unit`', 200, -1, FALSE, '`pro_unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pro_unit->Required = TRUE; // Required field
		$this->pro_unit->Sortable = TRUE; // Allow sort
		$this->pro_unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pro_unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pro_unit->Lookup = new Lookup('pro_unit', 'sub_process_type_view', TRUE, 'id', ["name","","",""], ["x_grp"], ["x_employee_id[]"], ["grp"], ["x_grp"], [], [], '`process` ASC', '');
		$this->pro_unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pro_unit'] = &$this->pro_unit;

		// employee_id
		$this->employee_id = new DbField('job_card', 'job_card', 'x_employee_id', 'employee_id', '`employee_id`', '`employee_id`', 200, -1, FALSE, '`EV__employee_id`', TRUE, TRUE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->employee_id->Nullable = FALSE; // NOT NULL field
		$this->employee_id->Required = TRUE; // Required field
		$this->employee_id->Sortable = TRUE; // Allow sort
		$this->employee_id->Lookup = new Lookup('employee_id', 'production_employee_view_pw', TRUE, 'id', ["id","user_name","",""], ["x_pro_unit"], [], ["process"], ["x_process"], [], [], '`user_name` ASC', '');
		$this->fields['employee_id'] = &$this->employee_id;

		// 1
		$this->_1 = new DbField('job_card', 'job_card', 'x__1', '1', '`1`', '`1`', 200, -1, FALSE, '`1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_1->Sortable = TRUE; // Allow sort
		$this->fields['1'] = &$this->_1;

		// 2
		$this->_2 = new DbField('job_card', 'job_card', 'x__2', '2', '`2`', '`2`', 200, -1, FALSE, '`2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2->Sortable = TRUE; // Allow sort
		$this->fields['2'] = &$this->_2;

		// 3
		$this->_3 = new DbField('job_card', 'job_card', 'x__3', '3', '`3`', '`3`', 200, -1, FALSE, '`3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_3->Sortable = TRUE; // Allow sort
		$this->fields['3'] = &$this->_3;

		// 4
		$this->_4 = new DbField('job_card', 'job_card', 'x__4', '4', '`4`', '`4`', 200, -1, FALSE, '`4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4->Sortable = TRUE; // Allow sort
		$this->fields['4'] = &$this->_4;

		// 5
		$this->_5 = new DbField('job_card', 'job_card', 'x__5', '5', '`5`', '`5`', 200, -1, FALSE, '`5`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_5->Sortable = TRUE; // Allow sort
		$this->fields['5'] = &$this->_5;

		// 6
		$this->_6 = new DbField('job_card', 'job_card', 'x__6', '6', '`6`', '`6`', 200, -1, FALSE, '`6`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_6->Sortable = TRUE; // Allow sort
		$this->fields['6'] = &$this->_6;

		// 7
		$this->_7 = new DbField('job_card', 'job_card', 'x__7', '7', '`7`', '`7`', 200, -1, FALSE, '`7`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_7->Sortable = TRUE; // Allow sort
		$this->fields['7'] = &$this->_7;

		// 8
		$this->_8 = new DbField('job_card', 'job_card', 'x__8', '8', '`8`', '`8`', 200, -1, FALSE, '`8`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_8->Sortable = TRUE; // Allow sort
		$this->fields['8'] = &$this->_8;

		// other1
		$this->other1 = new DbField('job_card', 'job_card', 'x_other1', 'other1', '`other1`', '`other1`', 200, -1, FALSE, '`other1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other1->Sortable = TRUE; // Allow sort
		$this->fields['other1'] = &$this->other1;

		// other2
		$this->other2 = new DbField('job_card', 'job_card', 'x_other2', 'other2', '`other2`', '`other2`', 200, -1, FALSE, '`other2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other2->Sortable = TRUE; // Allow sort
		$this->fields['other2'] = &$this->other2;

		// operator
		$this->operator = new DbField('job_card', 'job_card', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('job_card', 'job_card', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// updated
		$this->updated = new DbField('job_card', 'job_card', 'x_updated', 'updated', '`updated`', '`updated`', 17, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Sortable = FALSE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;

		// in_id
		$this->in_id = new DbField('job_card', 'job_card', 'x_in_id', 'in_id', '`in_id`', '`in_id`', 200, -1, FALSE, '`in_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->in_id->Sortable = FALSE; // Allow sort
		$this->fields['in_id'] = &$this->in_id;

		// balance_quantity
		$this->balance_quantity = new DbField('job_card', 'job_card', 'x_balance_quantity', 'balance_quantity', '`balance_quantity`', '`balance_quantity`', 4, -1, FALSE, '`balance_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->balance_quantity->Nullable = FALSE; // NOT NULL field
		$this->balance_quantity->Sortable = FALSE; // Allow sort
		$this->balance_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['balance_quantity'] = &$this->balance_quantity;

		// product
		$this->product = new DbField('job_card', 'job_card', 'x_product', 'product', '`product`', '`product`', 2, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Sortable = FALSE; // Allow sort
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// buyer_id
		$this->buyer_id = new DbField('job_card', 'job_card', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 3, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// company_id
		$this->company_id = new DbField('job_card', 'job_card', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 3, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`job_card`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, 0 AS `issue_to_internal`, 0 AS `issue_to_external` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, 0 AS `issue_to_internal`, 0 AS `issue_to_external`, (SELECT DISTINCT `product_code` FROM `po_pending_wbc` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `job_card`.`product_code` LIMIT 1) AS `EV__product_code`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `job_card`.`item` LIMIT 1) AS `EV__item`, (SELECT DISTINCT CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_id) . "',COALESCE(`user_name`,'')) FROM `production_employee_view_pw` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `job_card`.`employee_id` LIMIT 1) AS `EV__employee_id` FROM `job_card`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->product_code->AdvancedSearch->SearchValue <> "" ||
			$this->product_code->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->product_code->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->product_code->VirtualExpression . " "))
			return TRUE;
		if ($this->item->AdvancedSearch->SearchValue <> "" ||
			$this->item->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->item->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->item->VirtualExpression . " "))
			return TRUE;
		if ($this->employee_id->AdvancedSearch->SearchValue <> "" ||
			$this->employee_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->employee_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->employee_id->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->works->DbValue = $row['works'];
		$this->issue_to_internal->DbValue = $row['issue_to_internal'];
		$this->issue_to_external->DbValue = $row['issue_to_external'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->product_code->DbValue = $row['product_code'];
		$this->item->DbValue = $row['item'];
		$this->poid->DbValue = $row['poid'];
		$this->po->DbValue = $row['po'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->quantity->DbValue = $row['quantity'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->pro_unit->DbValue = $row['pro_unit'];
		$this->employee_id->DbValue = $row['employee_id'];
		$this->_1->DbValue = $row['1'];
		$this->_2->DbValue = $row['2'];
		$this->_3->DbValue = $row['3'];
		$this->_4->DbValue = $row['4'];
		$this->_5->DbValue = $row['5'];
		$this->_6->DbValue = $row['6'];
		$this->_7->DbValue = $row['7'];
		$this->_8->DbValue = $row['8'];
		$this->other1->DbValue = $row['other1'];
		$this->other2->DbValue = $row['other2'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->updated->DbValue = $row['updated'];
		$this->in_id->DbValue = $row['in_id'];
		$this->balance_quantity->DbValue = $row['balance_quantity'];
		$this->product->DbValue = $row['product'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->company_id->DbValue = $row['company_id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "job_cardlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "job_cardview.php")
			return $Language->phrase("View");
		elseif ($pageName == "job_cardedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "job_cardadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "job_cardlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("job_cardview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("job_cardview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "job_cardadd.php?" . $this->getUrlParm($parm);
		else
			$url = "job_cardadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("job_cardedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("job_cardadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("job_carddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->works->setDbValue($rs->fields('works'));
		$this->issue_to_internal->setDbValue($rs->fields('issue_to_internal'));
		$this->issue_to_external->setDbValue($rs->fields('issue_to_external'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->item->setDbValue($rs->fields('item'));
		$this->poid->setDbValue($rs->fields('poid'));
		$this->po->setDbValue($rs->fields('po'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->pro_unit->setDbValue($rs->fields('pro_unit'));
		$this->employee_id->setDbValue($rs->fields('employee_id'));
		$this->_1->setDbValue($rs->fields('1'));
		$this->_2->setDbValue($rs->fields('2'));
		$this->_3->setDbValue($rs->fields('3'));
		$this->_4->setDbValue($rs->fields('4'));
		$this->_5->setDbValue($rs->fields('5'));
		$this->_6->setDbValue($rs->fields('6'));
		$this->_7->setDbValue($rs->fields('7'));
		$this->_8->setDbValue($rs->fields('8'));
		$this->other1->setDbValue($rs->fields('other1'));
		$this->other2->setDbValue($rs->fields('other2'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->updated->setDbValue($rs->fields('updated'));
		$this->in_id->setDbValue($rs->fields('in_id'));
		$this->balance_quantity->setDbValue($rs->fields('balance_quantity'));
		$this->product->setDbValue($rs->fields('product'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->company_id->setDbValue($rs->fields('company_id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// jc_no
		// works
		// issue_to_internal
		// issue_to_external
		// issue_to
		// grp
		// s_grp
		// packing_type
		// product_code
		// item

		$this->item->CellCssStyle = "white-space: nowrap;";

		// poid
		$this->poid->CellCssStyle = "white-space: nowrap;";

		// po
		// batch_no
		// quantity
		// lot_no

		$this->lot_no->CellCssStyle = "white-space: nowrap;";

		// pro_unit
		// employee_id
		// 1
		// 2
		// 3
		// 4
		// 5
		// 6
		// 7
		// 8
		// other1
		// other2
		// operator
		// datetime
		// updated

		$this->updated->CellCssStyle = "white-space: nowrap;";

		// in_id
		$this->in_id->CellCssStyle = "white-space: nowrap;";

		// balance_quantity
		$this->balance_quantity->CellCssStyle = "white-space: nowrap;";

		// product
		$this->product->CellCssStyle = "white-space: nowrap;";

		// buyer_id
		// company_id
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
		$this->jc_no->ViewCustomAttributes = "";

		// works
		$curVal = strval($this->works->CurrentValue);
		if ($curVal <> "") {
			$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
			if ($this->works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `id` > 0 and (FIND_IN_SET('0', `type`) || FIND_IN_SET('1', `type`))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->works->ViewValue = $this->works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->works->ViewValue = $this->works->CurrentValue;
				}
			}
		} else {
			$this->works->ViewValue = NULL;
		}
		$this->works->ViewCustomAttributes = "";

		// issue_to_internal
		$curVal = strval($this->issue_to_internal->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to_internal->ViewValue = $this->issue_to_internal->lookupCacheOption($curVal);
			if ($this->issue_to_internal->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`category`=1" : "`id` = " . User_Company_ID() . " and `category`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to_internal->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->issue_to_internal->ViewValue = $this->issue_to_internal->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to_internal->ViewValue = $this->issue_to_internal->CurrentValue;
				}
			}
		} else {
			$this->issue_to_internal->ViewValue = NULL;
		}
		$this->issue_to_internal->ViewCustomAttributes = "";

		// issue_to_external
		$curVal = strval($this->issue_to_external->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to_external->ViewValue = $this->issue_to_external->lookupCacheOption($curVal);
			if ($this->issue_to_external->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category`=999";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to_external->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->issue_to_external->ViewValue = $this->issue_to_external->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to_external->ViewValue = $this->issue_to_external->CurrentValue;
				}
			}
		} else {
			$this->issue_to_external->ViewValue = NULL;
		}
		$this->issue_to_external->ViewCustomAttributes = "";

		// issue_to
		$curVal = strval($this->issue_to->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			if ($this->issue_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category`=999 || `category`=105";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
				}
			}
		} else {
			$this->issue_to->ViewValue = NULL;
		}
		$this->issue_to->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// product_code
		if ($this->product_code->VirtualValue <> "") {
			$this->product_code->ViewValue = $this->product_code->VirtualValue;
		} else {
		$curVal = strval($this->product_code->CurrentValue);
		if ($curVal <> "") {
			$this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
			if ($this->product_code->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`pending_qty` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_code->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_code->ViewValue = $this->product_code->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_code->ViewValue = $this->product_code->CurrentValue;
				}
			}
		} else {
			$this->product_code->ViewValue = NULL;
		}
		}
		$this->product_code->ViewCustomAttributes = "";

		// item
		if ($this->item->VirtualValue <> "") {
			$this->item->ViewValue = $this->item->VirtualValue;
		} else {
			$this->item->ViewValue = $this->item->CurrentValue;
		$curVal = strval($this->item->CurrentValue);
		if ($curVal <> "") {
			$this->item->ViewValue = $this->item->lookupCacheOption($curVal);
			if ($this->item->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->item->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->item->ViewValue = $this->item->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->item->ViewValue = $this->item->CurrentValue;
				}
			}
		} else {
			$this->item->ViewValue = NULL;
		}
		}
		$this->item->ViewCustomAttributes = "";

		// poid
		$curVal = strval($this->poid->CurrentValue);
		if ($curVal <> "") {
			$this->poid->ViewValue = $this->poid->lookupCacheOption($curVal);
			if ($this->poid->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`pending_qty`>0 and `po`!='0'";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->poid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->poid->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = $rswrk->fields('df4');
						$this->poid->ViewValue->add($this->poid->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->poid->ViewValue = $this->poid->CurrentValue;
				}
			}
		} else {
			$this->poid->ViewValue = NULL;
		}
		$this->poid->ViewCustomAttributes = "";

		// po
		$curVal = strval($this->po->CurrentValue);
		if ($curVal <> "") {
			$this->po->ViewValue = $this->po->lookupCacheOption($curVal);
			if ($this->po->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->po->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po->ViewValue->add($this->po->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->po->ViewValue = $this->po->CurrentValue;
				}
			}
		} else {
			$this->po->ViewValue = NULL;
		}
		$this->po->CellCssStyle .= "text-align: left;";
		$this->po->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// pro_unit
		$curVal = strval($this->pro_unit->CurrentValue);
		if ($curVal <> "") {
			$this->pro_unit->ViewValue = $this->pro_unit->lookupCacheOption($curVal);
			if ($this->pro_unit->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pro_unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pro_unit->ViewValue = $this->pro_unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pro_unit->ViewValue = $this->pro_unit->CurrentValue;
				}
			}
		} else {
			$this->pro_unit->ViewValue = NULL;
		}
		$this->pro_unit->ViewCustomAttributes = "";

		// employee_id
		if ($this->employee_id->VirtualValue <> "") {
			$this->employee_id->ViewValue = $this->employee_id->VirtualValue;
		} else {
		$curVal = strval($this->employee_id->CurrentValue);
		if ($curVal <> "") {
			$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			if ($this->employee_id->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->employee_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
				}
			}
		} else {
			$this->employee_id->ViewValue = NULL;
		}
		}
		$this->employee_id->ViewCustomAttributes = "";

		// 1
		$this->_1->ViewValue = $this->_1->CurrentValue;
		$this->_1->ViewCustomAttributes = "";

		// 2
		$this->_2->ViewValue = $this->_2->CurrentValue;
		$this->_2->ViewCustomAttributes = "";

		// 3
		$this->_3->ViewValue = $this->_3->CurrentValue;
		$this->_3->ViewCustomAttributes = "";

		// 4
		$this->_4->ViewValue = $this->_4->CurrentValue;
		$this->_4->ViewCustomAttributes = "";

		// 5
		$this->_5->ViewValue = $this->_5->CurrentValue;
		$this->_5->ViewCustomAttributes = "";

		// 6
		$this->_6->ViewValue = $this->_6->CurrentValue;
		$this->_6->ViewCustomAttributes = "";

		// 7
		$this->_7->ViewValue = $this->_7->CurrentValue;
		$this->_7->ViewCustomAttributes = "";

		// 8
		$this->_8->ViewValue = $this->_8->CurrentValue;
		$this->_8->ViewCustomAttributes = "";

		// other1
		$this->other1->ViewValue = $this->other1->CurrentValue;
		$this->other1->ViewCustomAttributes = "";

		// other2
		$this->other2->ViewValue = $this->other2->CurrentValue;
		$this->other2->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
		$this->updated->ViewCustomAttributes = "";

		// in_id
		$this->in_id->ViewValue = $this->in_id->CurrentValue;
		$this->in_id->ViewCustomAttributes = "";

		// balance_quantity
		$this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
		$this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, 2, -2, -2, -2);
		$this->balance_quantity->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
		$this->product->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
		$this->buyer_id->ViewValue = FormatNumber($this->buyer_id->ViewValue, 0, -2, -2, -2);
		$this->buyer_id->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
		$this->company_id->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// works
		$this->works->LinkCustomAttributes = "";
		if (!EmptyValue($this->works->CurrentValue)) {
			$this->works->HrefValue = "job_cardlist.php?x_works=" . $this->works->CurrentValue; // Add prefix/suffix
			$this->works->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->works->HrefValue = FullUrl($this->works->HrefValue, "href");
		} else {
			$this->works->HrefValue = "";
		}
		$this->works->TooltipValue = "";

		// issue_to_internal
		$this->issue_to_internal->LinkCustomAttributes = "";
		$this->issue_to_internal->HrefValue = "";
		$this->issue_to_internal->TooltipValue = "";

		// issue_to_external
		$this->issue_to_external->LinkCustomAttributes = "";
		$this->issue_to_external->HrefValue = "";
		$this->issue_to_external->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		$this->issue_to->HrefValue = "";
		$this->issue_to->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "job_cardlist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_parent"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		$this->product_code->HrefValue = "";
		$this->product_code->TooltipValue = "";

		// item
		$this->item->LinkCustomAttributes = "";
		if (!EmptyValue($this->item->CurrentValue)) {
			$this->item->HrefValue = "job_cardlist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
			$this->item->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
		} else {
			$this->item->HrefValue = "";
		}
		$this->item->TooltipValue = "";

		// poid
		$this->poid->LinkCustomAttributes = "";
		if (!EmptyValue($this->poid->CurrentValue)) {
			$this->poid->HrefValue = "job_cardlist.php?x_poid=" . $this->poid->CurrentValue; // Add prefix/suffix
			$this->poid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->poid->HrefValue = FullUrl($this->poid->HrefValue, "href");
		} else {
			$this->poid->HrefValue = "";
		}
		$this->poid->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		if (!EmptyValue($this->po->CurrentValue)) {
			$this->po->HrefValue = "job_cardlist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
			$this->po->LinkAttrs["target"] = "_parent"; // Add target
			if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
		} else {
			$this->po->HrefValue = "";
		}
		$this->po->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->batch_no->CurrentValue)) {
			$this->batch_no->HrefValue = "job_cardlist.php?x_batch_no=" . $this->batch_no->CurrentValue; // Add prefix/suffix
			$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
		} else {
			$this->batch_no->HrefValue = "";
		}
		$this->batch_no->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		if (!EmptyValue($this->quantity->CurrentValue)) {
			$this->quantity->HrefValue = "job_cardlist.php?x_quantity=" . $this->quantity->CurrentValue; // Add prefix/suffix
			$this->quantity->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->quantity->HrefValue = FullUrl($this->quantity->HrefValue, "href");
		} else {
			$this->quantity->HrefValue = "";
		}
		$this->quantity->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// pro_unit
		$this->pro_unit->LinkCustomAttributes = "";
		$this->pro_unit->HrefValue = "";
		$this->pro_unit->TooltipValue = "";

		// employee_id
		$this->employee_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->employee_id->CurrentValue)) {
			$this->employee_id->HrefValue = "job_cardlist.php?x_employee_id=" . $this->employee_id->CurrentValue; // Add prefix/suffix
			$this->employee_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
		} else {
			$this->employee_id->HrefValue = "";
		}
		$this->employee_id->TooltipValue = "";

		// 1
		$this->_1->LinkCustomAttributes = "";
		$this->_1->HrefValue = "";
		$this->_1->TooltipValue = "";

		// 2
		$this->_2->LinkCustomAttributes = "";
		$this->_2->HrefValue = "";
		$this->_2->TooltipValue = "";

		// 3
		$this->_3->LinkCustomAttributes = "";
		$this->_3->HrefValue = "";
		$this->_3->TooltipValue = "";

		// 4
		$this->_4->LinkCustomAttributes = "";
		$this->_4->HrefValue = "";
		$this->_4->TooltipValue = "";

		// 5
		$this->_5->LinkCustomAttributes = "";
		$this->_5->HrefValue = "";
		$this->_5->TooltipValue = "";

		// 6
		$this->_6->LinkCustomAttributes = "";
		$this->_6->HrefValue = "";
		$this->_6->TooltipValue = "";

		// 7
		$this->_7->LinkCustomAttributes = "";
		$this->_7->HrefValue = "";
		$this->_7->TooltipValue = "";

		// 8
		$this->_8->LinkCustomAttributes = "";
		$this->_8->HrefValue = "";
		$this->_8->TooltipValue = "";

		// other1
		$this->other1->LinkCustomAttributes = "";
		$this->other1->HrefValue = "";
		$this->other1->TooltipValue = "";

		// other2
		$this->other2->LinkCustomAttributes = "";
		$this->other2->HrefValue = "";
		$this->other2->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// in_id
		$this->in_id->LinkCustomAttributes = "";
		$this->in_id->HrefValue = "";
		$this->in_id->TooltipValue = "";

		// balance_quantity
		$this->balance_quantity->LinkCustomAttributes = "";
		$this->balance_quantity->HrefValue = "";
		$this->balance_quantity->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		$this->buyer_id->HrefValue = "";
		$this->buyer_id->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// works
		$this->works->EditAttrs["class"] = "form-control";
		$this->works->EditCustomAttributes = "";

		// issue_to_internal
		$this->issue_to_internal->EditAttrs["class"] = "form-control";
		$this->issue_to_internal->EditCustomAttributes = "";

		// issue_to_external
		$this->issue_to_external->EditAttrs["class"] = "form-control";
		$this->issue_to_external->EditCustomAttributes = "";

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";

		// item
		$this->item->EditAttrs["class"] = "form-control";
		$this->item->EditCustomAttributes = "";
		$this->item->EditValue = $this->item->CurrentValue;
		$this->item->PlaceHolder = RemoveHtml($this->item->caption());

		// poid
		$this->poid->EditCustomAttributes = "";

		// po
		$this->po->EditCustomAttributes = "";

		// batch_no
		$this->batch_no->EditCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

		// pro_unit
		$this->pro_unit->EditAttrs["class"] = "form-control";
		$this->pro_unit->EditCustomAttributes = "";

		// employee_id
		$this->employee_id->EditCustomAttributes = "";

		// 1
		$this->_1->EditAttrs["class"] = "form-control";
		$this->_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
		$this->_1->EditValue = $this->_1->CurrentValue;
		$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

		// 2
		$this->_2->EditAttrs["class"] = "form-control";
		$this->_2->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
		$this->_2->EditValue = $this->_2->CurrentValue;
		$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

		// 3
		$this->_3->EditAttrs["class"] = "form-control";
		$this->_3->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
		$this->_3->EditValue = $this->_3->CurrentValue;
		$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

		// 4
		$this->_4->EditAttrs["class"] = "form-control";
		$this->_4->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
		$this->_4->EditValue = $this->_4->CurrentValue;
		$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

		// 5
		$this->_5->EditAttrs["class"] = "form-control";
		$this->_5->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
		$this->_5->EditValue = $this->_5->CurrentValue;
		$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

		// 6
		$this->_6->EditAttrs["class"] = "form-control";
		$this->_6->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
		$this->_6->EditValue = $this->_6->CurrentValue;
		$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

		// 7
		$this->_7->EditAttrs["class"] = "form-control";
		$this->_7->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
		$this->_7->EditValue = $this->_7->CurrentValue;
		$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

		// 8
		$this->_8->EditAttrs["class"] = "form-control";
		$this->_8->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
		$this->_8->EditValue = $this->_8->CurrentValue;
		$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

		// other1
		$this->other1->EditAttrs["class"] = "form-control";
		$this->other1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->other1->CurrentValue = HtmlDecode($this->other1->CurrentValue);
		$this->other1->EditValue = $this->other1->CurrentValue;
		$this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

		// other2
		$this->other2->EditAttrs["class"] = "form-control";
		$this->other2->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->other2->CurrentValue = HtmlDecode($this->other2->CurrentValue);
		$this->other2->EditValue = $this->other2->CurrentValue;
		$this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

		// operator
		// datetime
		// updated

		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// in_id
		$this->in_id->EditAttrs["class"] = "form-control";
		$this->in_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->in_id->CurrentValue = HtmlDecode($this->in_id->CurrentValue);
		$this->in_id->EditValue = $this->in_id->CurrentValue;
		$this->in_id->PlaceHolder = RemoveHtml($this->in_id->caption());

		// balance_quantity
		$this->balance_quantity->EditAttrs["class"] = "form-control";
		$this->balance_quantity->EditCustomAttributes = "";
		$this->balance_quantity->EditValue = $this->balance_quantity->CurrentValue;
		$this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());
		if (strval($this->balance_quantity->EditValue) <> "" && is_numeric($this->balance_quantity->EditValue))
			$this->balance_quantity->EditValue = FormatNumber($this->balance_quantity->EditValue, -2, -2, -2, -2);

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";
		$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
		$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->works);
					$doc->exportCaption($this->issue_to_internal);
					$doc->exportCaption($this->issue_to_external);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->pro_unit);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->_1);
					$doc->exportCaption($this->_2);
					$doc->exportCaption($this->_3);
					$doc->exportCaption($this->_4);
					$doc->exportCaption($this->_5);
					$doc->exportCaption($this->_6);
					$doc->exportCaption($this->_7);
					$doc->exportCaption($this->_8);
					$doc->exportCaption($this->other1);
					$doc->exportCaption($this->other2);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->company_id);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->works);
					$doc->exportCaption($this->issue_to_internal);
					$doc->exportCaption($this->issue_to_external);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->pro_unit);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->_1);
					$doc->exportCaption($this->_2);
					$doc->exportCaption($this->_3);
					$doc->exportCaption($this->_4);
					$doc->exportCaption($this->_5);
					$doc->exportCaption($this->_6);
					$doc->exportCaption($this->_7);
					$doc->exportCaption($this->_8);
					$doc->exportCaption($this->other1);
					$doc->exportCaption($this->other2);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->company_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->works);
						$doc->exportField($this->issue_to_internal);
						$doc->exportField($this->issue_to_external);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->product_code);
						$doc->exportField($this->po);
						$doc->exportField($this->quantity);
						$doc->exportField($this->pro_unit);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->_1);
						$doc->exportField($this->_2);
						$doc->exportField($this->_3);
						$doc->exportField($this->_4);
						$doc->exportField($this->_5);
						$doc->exportField($this->_6);
						$doc->exportField($this->_7);
						$doc->exportField($this->_8);
						$doc->exportField($this->other1);
						$doc->exportField($this->other2);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->company_id);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->works);
						$doc->exportField($this->issue_to_internal);
						$doc->exportField($this->issue_to_external);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->product_code);
						$doc->exportField($this->po);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->quantity);
						$doc->exportField($this->pro_unit);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->_1);
						$doc->exportField($this->_2);
						$doc->exportField($this->_3);
						$doc->exportField($this->_4);
						$doc->exportField($this->_5);
						$doc->exportField($this->_6);
						$doc->exportField($this->_7);
						$doc->exportField($this->_8);
						$doc->exportField($this->other1);
						$doc->exportField($this->other2);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->company_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->jc_no, '');
				$doc->exportAggregate($this->works, '');
				$doc->exportAggregate($this->issue_to_internal, '');
				$doc->exportAggregate($this->issue_to_external, '');
				$doc->exportAggregate($this->issue_to, '');
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->s_grp, '');
				$doc->exportAggregate($this->packing_type, '');
				$doc->exportAggregate($this->product_code, '');
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->batch_no, '');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->exportAggregate($this->pro_unit, '');
				$doc->exportAggregate($this->employee_id, '');
				$doc->exportAggregate($this->_1, '');
				$doc->exportAggregate($this->_2, '');
				$doc->exportAggregate($this->_3, '');
				$doc->exportAggregate($this->_4, '');
				$doc->exportAggregate($this->_5, '');
				$doc->exportAggregate($this->_6, '');
				$doc->exportAggregate($this->_7, '');
				$doc->exportAggregate($this->_8, '');
				$doc->exportAggregate($this->other1, '');
				$doc->exportAggregate($this->other2, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->exportAggregate($this->buyer_id, '');
				$doc->exportAggregate($this->company_id, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'job_card';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'job_card';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'job_card';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'job_card';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>