<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class job_card_add extends job_card
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'job_card';

	// Page object name
	public $PageObjName = "job_card_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (job_card)
		if (!isset($GLOBALS["job_card"]) || get_class($GLOBALS["job_card"]) == PROJECT_NAMESPACE . "job_card") {
			$GLOBALS["job_card"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["job_card"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $job_card;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($job_card);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "job_cardview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("job_cardlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->jc_no->setVisibility();
		$this->works->setVisibility();
		$this->issue_to_internal->setVisibility();
		$this->issue_to_external->setVisibility();
		$this->issue_to->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->packing_type->setVisibility();
		$this->product_code->setVisibility();
		$this->item->setVisibility();
		$this->poid->setVisibility();
		$this->po->Visible = FALSE;
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->lot_no->Visible = FALSE;
		$this->pro_unit->setVisibility();
		$this->employee_id->setVisibility();
		$this->_1->setVisibility();
		$this->_2->setVisibility();
		$this->_3->setVisibility();
		$this->_4->setVisibility();
		$this->_5->setVisibility();
		$this->_6->setVisibility();
		$this->_7->setVisibility();
		$this->_8->setVisibility();
		$this->other1->setVisibility();
		$this->other2->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->in_id->Visible = FALSE;
		$this->balance_quantity->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->buyer_id->setVisibility();
		$this->company_id->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->works);
		$this->setupLookupOptions($this->issue_to_internal);
		$this->setupLookupOptions($this->issue_to_external);
		$this->setupLookupOptions($this->issue_to);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->product_code);
		$this->setupLookupOptions($this->item);
		$this->setupLookupOptions($this->poid);
		$this->setupLookupOptions($this->po);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->pro_unit);
		$this->setupLookupOptions($this->employee_id);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("job_cardlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "job_cardlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "job_cardview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->jc_no->CurrentValue = NULL;
		$this->jc_no->OldValue = $this->jc_no->CurrentValue;
		$this->works->CurrentValue = (isset($_COOKIE["User_Site"]))? $_COOKIE["User_Site"]:0;
		$this->issue_to_internal->CurrentValue = NULL;
		$this->issue_to_internal->OldValue = $this->issue_to_internal->CurrentValue;
		$this->issue_to_external->CurrentValue = NULL;
		$this->issue_to_external->OldValue = $this->issue_to_external->CurrentValue;
		$this->issue_to->CurrentValue = 0;
		$this->grp->CurrentValue = 2;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->packing_type->CurrentValue = NULL;
		$this->packing_type->OldValue = $this->packing_type->CurrentValue;
		$this->product_code->CurrentValue = NULL;
		$this->product_code->OldValue = $this->product_code->CurrentValue;
		$this->item->CurrentValue = NULL;
		$this->item->OldValue = $this->item->CurrentValue;
		$this->poid->CurrentValue = NULL;
		$this->poid->OldValue = $this->poid->CurrentValue;
		$this->po->CurrentValue = NULL;
		$this->po->OldValue = $this->po->CurrentValue;
		$this->batch_no->CurrentValue = NULL;
		$this->batch_no->OldValue = $this->batch_no->CurrentValue;
		$this->quantity->CurrentValue = NULL;
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->pro_unit->CurrentValue = NULL;
		$this->pro_unit->OldValue = $this->pro_unit->CurrentValue;
		$this->employee_id->CurrentValue = 1001;
		$this->_1->CurrentValue = NULL;
		$this->_1->OldValue = $this->_1->CurrentValue;
		$this->_2->CurrentValue = NULL;
		$this->_2->OldValue = $this->_2->CurrentValue;
		$this->_3->CurrentValue = NULL;
		$this->_3->OldValue = $this->_3->CurrentValue;
		$this->_4->CurrentValue = NULL;
		$this->_4->OldValue = $this->_4->CurrentValue;
		$this->_5->CurrentValue = NULL;
		$this->_5->OldValue = $this->_5->CurrentValue;
		$this->_6->CurrentValue = NULL;
		$this->_6->OldValue = $this->_6->CurrentValue;
		$this->_7->CurrentValue = NULL;
		$this->_7->OldValue = $this->_7->CurrentValue;
		$this->_8->CurrentValue = NULL;
		$this->_8->OldValue = $this->_8->CurrentValue;
		$this->other1->CurrentValue = NULL;
		$this->other1->OldValue = $this->other1->CurrentValue;
		$this->other2->CurrentValue = NULL;
		$this->other2->OldValue = $this->other2->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->updated->CurrentValue = 0;
		$this->in_id->CurrentValue = NULL;
		$this->in_id->OldValue = $this->in_id->CurrentValue;
		$this->balance_quantity->CurrentValue = 0;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->buyer_id->CurrentValue = NULL;
		$this->buyer_id->OldValue = $this->buyer_id->CurrentValue;
		$this->company_id->CurrentValue = NULL;
		$this->company_id->OldValue = $this->company_id->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_no->Visible = FALSE; // Disable update for API request
			else
				$this->jc_no->setFormValue($val);
		}

		// Check field name 'works' first before field var 'x_works'
		$val = $CurrentForm->hasValue("works") ? $CurrentForm->getValue("works") : $CurrentForm->getValue("x_works");
		if (!$this->works->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->works->Visible = FALSE; // Disable update for API request
			else
				$this->works->setFormValue($val);
		}

		// Check field name 'issue_to_internal' first before field var 'x_issue_to_internal'
		$val = $CurrentForm->hasValue("issue_to_internal") ? $CurrentForm->getValue("issue_to_internal") : $CurrentForm->getValue("x_issue_to_internal");
		if (!$this->issue_to_internal->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_to_internal->Visible = FALSE; // Disable update for API request
			else
				$this->issue_to_internal->setFormValue($val);
		}

		// Check field name 'issue_to_external' first before field var 'x_issue_to_external'
		$val = $CurrentForm->hasValue("issue_to_external") ? $CurrentForm->getValue("issue_to_external") : $CurrentForm->getValue("x_issue_to_external");
		if (!$this->issue_to_external->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_to_external->Visible = FALSE; // Disable update for API request
			else
				$this->issue_to_external->setFormValue($val);
		}

		// Check field name 'issue_to' first before field var 'x_issue_to'
		$val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
		if (!$this->issue_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_to->Visible = FALSE; // Disable update for API request
			else
				$this->issue_to->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'product_code' first before field var 'x_product_code'
		$val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
		if (!$this->product_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_code->Visible = FALSE; // Disable update for API request
			else
				$this->product_code->setFormValue($val);
		}

		// Check field name 'item' first before field var 'x_item'
		$val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
		if (!$this->item->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->item->Visible = FALSE; // Disable update for API request
			else
				$this->item->setFormValue($val);
		}

		// Check field name 'poid' first before field var 'x_poid'
		$val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
		if (!$this->poid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->poid->Visible = FALSE; // Disable update for API request
			else
				$this->poid->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'pro_unit' first before field var 'x_pro_unit'
		$val = $CurrentForm->hasValue("pro_unit") ? $CurrentForm->getValue("pro_unit") : $CurrentForm->getValue("x_pro_unit");
		if (!$this->pro_unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pro_unit->Visible = FALSE; // Disable update for API request
			else
				$this->pro_unit->setFormValue($val);
		}

		// Check field name 'employee_id' first before field var 'x_employee_id'
		$val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
		if (!$this->employee_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_id->Visible = FALSE; // Disable update for API request
			else
				$this->employee_id->setFormValue($val);
		}

		// Check field name '1' first before field var 'x__1'
		$val = $CurrentForm->hasValue("1") ? $CurrentForm->getValue("1") : $CurrentForm->getValue("x__1");
		if (!$this->_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_1->Visible = FALSE; // Disable update for API request
			else
				$this->_1->setFormValue($val);
		}

		// Check field name '2' first before field var 'x__2'
		$val = $CurrentForm->hasValue("2") ? $CurrentForm->getValue("2") : $CurrentForm->getValue("x__2");
		if (!$this->_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_2->Visible = FALSE; // Disable update for API request
			else
				$this->_2->setFormValue($val);
		}

		// Check field name '3' first before field var 'x__3'
		$val = $CurrentForm->hasValue("3") ? $CurrentForm->getValue("3") : $CurrentForm->getValue("x__3");
		if (!$this->_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_3->Visible = FALSE; // Disable update for API request
			else
				$this->_3->setFormValue($val);
		}

		// Check field name '4' first before field var 'x__4'
		$val = $CurrentForm->hasValue("4") ? $CurrentForm->getValue("4") : $CurrentForm->getValue("x__4");
		if (!$this->_4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_4->Visible = FALSE; // Disable update for API request
			else
				$this->_4->setFormValue($val);
		}

		// Check field name '5' first before field var 'x__5'
		$val = $CurrentForm->hasValue("5") ? $CurrentForm->getValue("5") : $CurrentForm->getValue("x__5");
		if (!$this->_5->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_5->Visible = FALSE; // Disable update for API request
			else
				$this->_5->setFormValue($val);
		}

		// Check field name '6' first before field var 'x__6'
		$val = $CurrentForm->hasValue("6") ? $CurrentForm->getValue("6") : $CurrentForm->getValue("x__6");
		if (!$this->_6->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_6->Visible = FALSE; // Disable update for API request
			else
				$this->_6->setFormValue($val);
		}

		// Check field name '7' first before field var 'x__7'
		$val = $CurrentForm->hasValue("7") ? $CurrentForm->getValue("7") : $CurrentForm->getValue("x__7");
		if (!$this->_7->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_7->Visible = FALSE; // Disable update for API request
			else
				$this->_7->setFormValue($val);
		}

		// Check field name '8' first before field var 'x__8'
		$val = $CurrentForm->hasValue("8") ? $CurrentForm->getValue("8") : $CurrentForm->getValue("x__8");
		if (!$this->_8->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_8->Visible = FALSE; // Disable update for API request
			else
				$this->_8->setFormValue($val);
		}

		// Check field name 'other1' first before field var 'x_other1'
		$val = $CurrentForm->hasValue("other1") ? $CurrentForm->getValue("other1") : $CurrentForm->getValue("x_other1");
		if (!$this->other1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other1->Visible = FALSE; // Disable update for API request
			else
				$this->other1->setFormValue($val);
		}

		// Check field name 'other2' first before field var 'x_other2'
		$val = $CurrentForm->hasValue("other2") ? $CurrentForm->getValue("other2") : $CurrentForm->getValue("x_other2");
		if (!$this->other2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other2->Visible = FALSE; // Disable update for API request
			else
				$this->other2->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->jc_no->CurrentValue = $this->jc_no->FormValue;
		$this->works->CurrentValue = $this->works->FormValue;
		$this->issue_to_internal->CurrentValue = $this->issue_to_internal->FormValue;
		$this->issue_to_external->CurrentValue = $this->issue_to_external->FormValue;
		$this->issue_to->CurrentValue = $this->issue_to->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->product_code->CurrentValue = $this->product_code->FormValue;
		$this->item->CurrentValue = $this->item->FormValue;
		$this->poid->CurrentValue = $this->poid->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->pro_unit->CurrentValue = $this->pro_unit->FormValue;
		$this->employee_id->CurrentValue = $this->employee_id->FormValue;
		$this->_1->CurrentValue = $this->_1->FormValue;
		$this->_2->CurrentValue = $this->_2->FormValue;
		$this->_3->CurrentValue = $this->_3->FormValue;
		$this->_4->CurrentValue = $this->_4->FormValue;
		$this->_5->CurrentValue = $this->_5->FormValue;
		$this->_6->CurrentValue = $this->_6->FormValue;
		$this->_7->CurrentValue = $this->_7->FormValue;
		$this->_8->CurrentValue = $this->_8->FormValue;
		$this->other1->CurrentValue = $this->other1->FormValue;
		$this->other2->CurrentValue = $this->other2->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->works->setDbValue($row['works']);
		$this->issue_to_internal->setDbValue($row['issue_to_internal']);
		$this->issue_to_external->setDbValue($row['issue_to_external']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->product_code->setDbValue($row['product_code']);
		if (array_key_exists('EV__product_code', $rs->fields)) {
			$this->product_code->VirtualValue = $rs->fields('EV__product_code'); // Set up virtual field value
		} else {
			$this->product_code->VirtualValue = ""; // Clear value
		}
		$this->item->setDbValue($row['item']);
		if (array_key_exists('EV__item', $rs->fields)) {
			$this->item->VirtualValue = $rs->fields('EV__item'); // Set up virtual field value
		} else {
			$this->item->VirtualValue = ""; // Clear value
		}
		$this->poid->setDbValue($row['poid']);
		$this->po->setDbValue($row['po']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->pro_unit->setDbValue($row['pro_unit']);
		$this->employee_id->setDbValue($row['employee_id']);
		if (array_key_exists('EV__employee_id', $rs->fields)) {
			$this->employee_id->VirtualValue = $rs->fields('EV__employee_id'); // Set up virtual field value
		} else {
			$this->employee_id->VirtualValue = ""; // Clear value
		}
		$this->_1->setDbValue($row['1']);
		$this->_2->setDbValue($row['2']);
		$this->_3->setDbValue($row['3']);
		$this->_4->setDbValue($row['4']);
		$this->_5->setDbValue($row['5']);
		$this->_6->setDbValue($row['6']);
		$this->_7->setDbValue($row['7']);
		$this->_8->setDbValue($row['8']);
		$this->other1->setDbValue($row['other1']);
		$this->other2->setDbValue($row['other2']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->updated->setDbValue($row['updated']);
		$this->in_id->setDbValue($row['in_id']);
		$this->balance_quantity->setDbValue($row['balance_quantity']);
		$this->product->setDbValue($row['product']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->company_id->setDbValue($row['company_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['jc_no'] = $this->jc_no->CurrentValue;
		$row['works'] = $this->works->CurrentValue;
		$row['issue_to_internal'] = $this->issue_to_internal->CurrentValue;
		$row['issue_to_external'] = $this->issue_to_external->CurrentValue;
		$row['issue_to'] = $this->issue_to->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['packing_type'] = $this->packing_type->CurrentValue;
		$row['product_code'] = $this->product_code->CurrentValue;
		$row['item'] = $this->item->CurrentValue;
		$row['poid'] = $this->poid->CurrentValue;
		$row['po'] = $this->po->CurrentValue;
		$row['batch_no'] = $this->batch_no->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['pro_unit'] = $this->pro_unit->CurrentValue;
		$row['employee_id'] = $this->employee_id->CurrentValue;
		$row['1'] = $this->_1->CurrentValue;
		$row['2'] = $this->_2->CurrentValue;
		$row['3'] = $this->_3->CurrentValue;
		$row['4'] = $this->_4->CurrentValue;
		$row['5'] = $this->_5->CurrentValue;
		$row['6'] = $this->_6->CurrentValue;
		$row['7'] = $this->_7->CurrentValue;
		$row['8'] = $this->_8->CurrentValue;
		$row['other1'] = $this->other1->CurrentValue;
		$row['other2'] = $this->other2->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['updated'] = $this->updated->CurrentValue;
		$row['in_id'] = $this->in_id->CurrentValue;
		$row['balance_quantity'] = $this->balance_quantity->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['buyer_id'] = $this->buyer_id->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// jc_no
		// works
		// issue_to_internal
		// issue_to_external
		// issue_to
		// grp
		// s_grp
		// packing_type
		// product_code
		// item
		// poid
		// po
		// batch_no
		// quantity
		// lot_no
		// pro_unit
		// employee_id
		// 1
		// 2
		// 3
		// 4
		// 5
		// 6
		// 7
		// 8
		// other1
		// other2
		// operator
		// datetime
		// updated
		// in_id
		// balance_quantity
		// product
		// buyer_id
		// company_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// works
			$curVal = strval($this->works->CurrentValue);
			if ($curVal <> "") {
				$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
				if ($this->works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0 and (FIND_IN_SET('0', `type`) || FIND_IN_SET('1', `type`))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->works->ViewValue = $this->works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->works->ViewValue = $this->works->CurrentValue;
					}
				}
			} else {
				$this->works->ViewValue = NULL;
			}
			$this->works->ViewCustomAttributes = "";

			// issue_to_internal
			$curVal = strval($this->issue_to_internal->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to_internal->ViewValue = $this->issue_to_internal->lookupCacheOption($curVal);
				if ($this->issue_to_internal->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`category`=1" : "`id` = " . User_Company_ID() . " and `category`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to_internal->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_to_internal->ViewValue = $this->issue_to_internal->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to_internal->ViewValue = $this->issue_to_internal->CurrentValue;
					}
				}
			} else {
				$this->issue_to_internal->ViewValue = NULL;
			}
			$this->issue_to_internal->ViewCustomAttributes = "";

			// issue_to_external
			$curVal = strval($this->issue_to_external->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to_external->ViewValue = $this->issue_to_external->lookupCacheOption($curVal);
				if ($this->issue_to_external->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to_external->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_to_external->ViewValue = $this->issue_to_external->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to_external->ViewValue = $this->issue_to_external->CurrentValue;
					}
				}
			} else {
				$this->issue_to_external->ViewValue = NULL;
			}
			$this->issue_to_external->ViewCustomAttributes = "";

			// issue_to
			$curVal = strval($this->issue_to->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
				if ($this->issue_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=999 || `category`=105";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
					}
				}
			} else {
				$this->issue_to->ViewValue = NULL;
			}
			$this->issue_to->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// product_code
			if ($this->product_code->VirtualValue <> "") {
				$this->product_code->ViewValue = $this->product_code->VirtualValue;
			} else {
			$curVal = strval($this->product_code->CurrentValue);
			if ($curVal <> "") {
				$this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
				if ($this->product_code->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`pending_qty` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_code->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_code->ViewValue = $this->product_code->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_code->ViewValue = $this->product_code->CurrentValue;
					}
				}
			} else {
				$this->product_code->ViewValue = NULL;
			}
			}
			$this->product_code->ViewCustomAttributes = "";

			// item
			if ($this->item->VirtualValue <> "") {
				$this->item->ViewValue = $this->item->VirtualValue;
			} else {
				$this->item->ViewValue = $this->item->CurrentValue;
			$curVal = strval($this->item->CurrentValue);
			if ($curVal <> "") {
				$this->item->ViewValue = $this->item->lookupCacheOption($curVal);
				if ($this->item->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->item->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->item->ViewValue = $this->item->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->item->ViewValue = $this->item->CurrentValue;
					}
				}
			} else {
				$this->item->ViewValue = NULL;
			}
			}
			$this->item->ViewCustomAttributes = "";

			// poid
			$curVal = strval($this->poid->CurrentValue);
			if ($curVal <> "") {
				$this->poid->ViewValue = $this->poid->lookupCacheOption($curVal);
				if ($this->poid->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`pending_qty`>0 and `po`!='0'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->poid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->poid->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = $rswrk->fields('df4');
							$this->poid->ViewValue->add($this->poid->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->poid->ViewValue = $this->poid->CurrentValue;
					}
				}
			} else {
				$this->poid->ViewValue = NULL;
			}
			$this->poid->ViewCustomAttributes = "";

			// po
			$curVal = strval($this->po->CurrentValue);
			if ($curVal <> "") {
				$this->po->ViewValue = $this->po->lookupCacheOption($curVal);
				if ($this->po->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->po->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$this->po->ViewValue->add($this->po->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->po->ViewValue = $this->po->CurrentValue;
					}
				}
			} else {
				$this->po->ViewValue = NULL;
			}
			$this->po->CellCssStyle .= "text-align: left;";
			$this->po->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// pro_unit
			$curVal = strval($this->pro_unit->CurrentValue);
			if ($curVal <> "") {
				$this->pro_unit->ViewValue = $this->pro_unit->lookupCacheOption($curVal);
				if ($this->pro_unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pro_unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pro_unit->ViewValue = $this->pro_unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pro_unit->ViewValue = $this->pro_unit->CurrentValue;
					}
				}
			} else {
				$this->pro_unit->ViewValue = NULL;
			}
			$this->pro_unit->ViewCustomAttributes = "";

			// employee_id
			if ($this->employee_id->VirtualValue <> "") {
				$this->employee_id->ViewValue = $this->employee_id->VirtualValue;
			} else {
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->employee_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			}
			$this->employee_id->ViewCustomAttributes = "";

			// 1
			$this->_1->ViewValue = $this->_1->CurrentValue;
			$this->_1->ViewCustomAttributes = "";

			// 2
			$this->_2->ViewValue = $this->_2->CurrentValue;
			$this->_2->ViewCustomAttributes = "";

			// 3
			$this->_3->ViewValue = $this->_3->CurrentValue;
			$this->_3->ViewCustomAttributes = "";

			// 4
			$this->_4->ViewValue = $this->_4->CurrentValue;
			$this->_4->ViewCustomAttributes = "";

			// 5
			$this->_5->ViewValue = $this->_5->CurrentValue;
			$this->_5->ViewCustomAttributes = "";

			// 6
			$this->_6->ViewValue = $this->_6->CurrentValue;
			$this->_6->ViewCustomAttributes = "";

			// 7
			$this->_7->ViewValue = $this->_7->CurrentValue;
			$this->_7->ViewCustomAttributes = "";

			// 8
			$this->_8->ViewValue = $this->_8->CurrentValue;
			$this->_8->ViewCustomAttributes = "";

			// other1
			$this->other1->ViewValue = $this->other1->CurrentValue;
			$this->other1->ViewCustomAttributes = "";

			// other2
			$this->other2->ViewValue = $this->other2->CurrentValue;
			$this->other2->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$this->buyer_id->ViewValue = FormatNumber($this->buyer_id->ViewValue, 0, -2, -2, -2);
			$this->buyer_id->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
			$this->company_id->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// works
			$this->works->LinkCustomAttributes = "";
			if (!EmptyValue($this->works->CurrentValue)) {
				$this->works->HrefValue = "job_cardlist.php?x_works=" . $this->works->CurrentValue; // Add prefix/suffix
				$this->works->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->works->HrefValue = FullUrl($this->works->HrefValue, "href");
			} else {
				$this->works->HrefValue = "";
			}
			$this->works->TooltipValue = "";

			// issue_to_internal
			$this->issue_to_internal->LinkCustomAttributes = "";
			$this->issue_to_internal->HrefValue = "";
			$this->issue_to_internal->TooltipValue = "";

			// issue_to_external
			$this->issue_to_external->LinkCustomAttributes = "";
			$this->issue_to_external->HrefValue = "";
			$this->issue_to_external->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";
			$this->issue_to->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "job_cardlist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_parent"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";
			$this->product_code->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "job_cardlist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}
			$this->item->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			if (!EmptyValue($this->poid->CurrentValue)) {
				$this->poid->HrefValue = "job_cardlist.php?x_poid=" . $this->poid->CurrentValue; // Add prefix/suffix
				$this->poid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->poid->HrefValue = FullUrl($this->poid->HrefValue, "href");
			} else {
				$this->poid->HrefValue = "";
			}
			$this->poid->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "job_cardlist.php?x_batch_no=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			if (!EmptyValue($this->quantity->CurrentValue)) {
				$this->quantity->HrefValue = "job_cardlist.php?x_quantity=" . $this->quantity->CurrentValue; // Add prefix/suffix
				$this->quantity->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->quantity->HrefValue = FullUrl($this->quantity->HrefValue, "href");
			} else {
				$this->quantity->HrefValue = "";
			}
			$this->quantity->TooltipValue = "";

			// pro_unit
			$this->pro_unit->LinkCustomAttributes = "";
			$this->pro_unit->HrefValue = "";
			$this->pro_unit->TooltipValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_id->CurrentValue)) {
				$this->employee_id->HrefValue = "job_cardlist.php?x_employee_id=" . $this->employee_id->CurrentValue; // Add prefix/suffix
				$this->employee_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
			} else {
				$this->employee_id->HrefValue = "";
			}
			$this->employee_id->TooltipValue = "";

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";
			$this->_1->TooltipValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";
			$this->_2->TooltipValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";
			$this->_3->TooltipValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";
			$this->_4->TooltipValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";
			$this->_5->TooltipValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";
			$this->_6->TooltipValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";
			$this->_7->TooltipValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";
			$this->_8->TooltipValue = "";

			// other1
			$this->other1->LinkCustomAttributes = "";
			$this->other1->HrefValue = "";
			$this->other1->TooltipValue = "";

			// other2
			$this->other2->LinkCustomAttributes = "";
			$this->other2->HrefValue = "";
			$this->other2->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->CurrentValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// works
			$this->works->EditAttrs["class"] = "form-control";
			$this->works->EditCustomAttributes = "";
			$curVal = trim(strval($this->works->CurrentValue));
			if ($curVal <> "")
				$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
			else
				$this->works->ViewValue = $this->works->Lookup !== NULL && is_array($this->works->Lookup->Options) ? $curVal : NULL;
			if ($this->works->ViewValue !== NULL) { // Load from cache
				$this->works->EditValue = array_values($this->works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->works->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 0 and (FIND_IN_SET('0', `type`) || FIND_IN_SET('1', `type`))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->works->EditValue = $arwrk;
			}

			// issue_to_internal
			$this->issue_to_internal->EditAttrs["class"] = "form-control";
			$this->issue_to_internal->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_to_internal->CurrentValue));
			if ($curVal <> "")
				$this->issue_to_internal->ViewValue = $this->issue_to_internal->lookupCacheOption($curVal);
			else
				$this->issue_to_internal->ViewValue = $this->issue_to_internal->Lookup !== NULL && is_array($this->issue_to_internal->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_to_internal->ViewValue !== NULL) { // Load from cache
				$this->issue_to_internal->EditValue = array_values($this->issue_to_internal->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_to_internal->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`category`=1" : "`id` = " . User_Company_ID() . " and `category`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to_internal->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_to_internal->EditValue = $arwrk;
			}

			// issue_to_external
			$this->issue_to_external->EditAttrs["class"] = "form-control";
			$this->issue_to_external->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_to_external->CurrentValue));
			if ($curVal <> "")
				$this->issue_to_external->ViewValue = $this->issue_to_external->lookupCacheOption($curVal);
			else
				$this->issue_to_external->ViewValue = $this->issue_to_external->Lookup !== NULL && is_array($this->issue_to_external->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_to_external->ViewValue !== NULL) { // Load from cache
				$this->issue_to_external->EditValue = array_values($this->issue_to_external->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_to_external->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`=999";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to_external->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_to_external->EditValue = $arwrk;
			}

			// issue_to
			$this->issue_to->EditAttrs["class"] = "form-control";
			$this->issue_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_to->CurrentValue));
			if ($curVal <> "")
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			else
				$this->issue_to->ViewValue = $this->issue_to->Lookup !== NULL && is_array($this->issue_to->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_to->ViewValue !== NULL) { // Load from cache
				$this->issue_to->EditValue = array_values($this->issue_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`=999 || `category`=105";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_to->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_code->CurrentValue));
			if ($curVal <> "")
				$this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
			else
				$this->product_code->ViewValue = $this->product_code->Lookup !== NULL && is_array($this->product_code->Lookup->Options) ? $curVal : NULL;
			if ($this->product_code->ViewValue !== NULL) { // Load from cache
				$this->product_code->EditValue = array_values($this->product_code->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_code->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`pending_qty` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_code->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_code->EditValue = $arwrk;
			}

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			$this->item->EditValue = HtmlEncode($this->item->CurrentValue);
			$curVal = strval($this->item->CurrentValue);
			if ($curVal <> "") {
				$this->item->EditValue = $this->item->lookupCacheOption($curVal);
				if ($this->item->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->item->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->item->EditValue = $this->item->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->item->EditValue = HtmlEncode($this->item->CurrentValue);
					}
				}
			} else {
				$this->item->EditValue = NULL;
			}
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// poid
			$this->poid->EditCustomAttributes = "";
			$curVal = trim(strval($this->poid->CurrentValue));
			if ($curVal <> "")
				$this->poid->ViewValue = $this->poid->lookupCacheOption($curVal);
			else
				$this->poid->ViewValue = $this->poid->Lookup !== NULL && is_array($this->poid->Lookup->Options) ? $curVal : NULL;
			if ($this->poid->ViewValue !== NULL) { // Load from cache
				$this->poid->EditValue = array_values($this->poid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`pending_qty`>0 and `po`!='0'";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->poid->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
				}
				$this->poid->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->CurrentValue));
			if ($curVal <> "")
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

			// pro_unit
			$this->pro_unit->EditAttrs["class"] = "form-control";
			$this->pro_unit->EditCustomAttributes = "";
			$curVal = trim(strval($this->pro_unit->CurrentValue));
			if ($curVal <> "")
				$this->pro_unit->ViewValue = $this->pro_unit->lookupCacheOption($curVal);
			else
				$this->pro_unit->ViewValue = $this->pro_unit->Lookup !== NULL && is_array($this->pro_unit->Lookup->Options) ? $curVal : NULL;
			if ($this->pro_unit->ViewValue !== NULL) { // Load from cache
				$this->pro_unit->EditValue = array_values($this->pro_unit->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pro_unit->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pro_unit->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pro_unit->EditValue = $arwrk;
			}

			// employee_id
			$this->employee_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_id->CurrentValue));
			if ($curVal <> "")
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			else
				$this->employee_id->ViewValue = $this->employee_id->Lookup !== NULL && is_array($this->employee_id->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_id->ViewValue !== NULL) { // Load from cache
				$this->employee_id->EditValue = array_values($this->employee_id->Lookup->Options);
				if ($this->employee_id->ViewValue == "")
					$this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->employee_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->employee_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_id->EditValue = $arwrk;
			}

			// 1
			$this->_1->EditAttrs["class"] = "form-control";
			$this->_1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
			$this->_1->EditValue = HtmlEncode($this->_1->CurrentValue);
			$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

			// 2
			$this->_2->EditAttrs["class"] = "form-control";
			$this->_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
			$this->_2->EditValue = HtmlEncode($this->_2->CurrentValue);
			$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

			// 3
			$this->_3->EditAttrs["class"] = "form-control";
			$this->_3->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
			$this->_3->EditValue = HtmlEncode($this->_3->CurrentValue);
			$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

			// 4
			$this->_4->EditAttrs["class"] = "form-control";
			$this->_4->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
			$this->_4->EditValue = HtmlEncode($this->_4->CurrentValue);
			$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

			// 5
			$this->_5->EditAttrs["class"] = "form-control";
			$this->_5->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
			$this->_5->EditValue = HtmlEncode($this->_5->CurrentValue);
			$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

			// 6
			$this->_6->EditAttrs["class"] = "form-control";
			$this->_6->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
			$this->_6->EditValue = HtmlEncode($this->_6->CurrentValue);
			$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

			// 7
			$this->_7->EditAttrs["class"] = "form-control";
			$this->_7->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
			$this->_7->EditValue = HtmlEncode($this->_7->CurrentValue);
			$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

			// 8
			$this->_8->EditAttrs["class"] = "form-control";
			$this->_8->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
			$this->_8->EditValue = HtmlEncode($this->_8->CurrentValue);
			$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

			// other1
			$this->other1->EditAttrs["class"] = "form-control";
			$this->other1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other1->CurrentValue = HtmlDecode($this->other1->CurrentValue);
			$this->other1->EditValue = HtmlEncode($this->other1->CurrentValue);
			$this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

			// other2
			$this->other2->EditAttrs["class"] = "form-control";
			$this->other2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other2->CurrentValue = HtmlDecode($this->other2->CurrentValue);
			$this->other2->EditValue = HtmlEncode($this->other2->CurrentValue);
			$this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

			// operator
			// datetime
			// buyer_id

			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->CurrentValue);
			$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// Add refer script
			// jc_no

			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";

			// works
			$this->works->LinkCustomAttributes = "";
			if (!EmptyValue($this->works->CurrentValue)) {
				$this->works->HrefValue = "job_cardlist.php?x_works=" . $this->works->CurrentValue; // Add prefix/suffix
				$this->works->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->works->HrefValue = FullUrl($this->works->HrefValue, "href");
			} else {
				$this->works->HrefValue = "";
			}

			// issue_to_internal
			$this->issue_to_internal->LinkCustomAttributes = "";
			$this->issue_to_internal->HrefValue = "";

			// issue_to_external
			$this->issue_to_external->LinkCustomAttributes = "";
			$this->issue_to_external->HrefValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "job_cardlist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_parent"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "job_cardlist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}

			// poid
			$this->poid->LinkCustomAttributes = "";
			if (!EmptyValue($this->poid->CurrentValue)) {
				$this->poid->HrefValue = "job_cardlist.php?x_poid=" . $this->poid->CurrentValue; // Add prefix/suffix
				$this->poid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->poid->HrefValue = FullUrl($this->poid->HrefValue, "href");
			} else {
				$this->poid->HrefValue = "";
			}

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "job_cardlist.php?x_batch_no=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			if (!EmptyValue($this->quantity->CurrentValue)) {
				$this->quantity->HrefValue = "job_cardlist.php?x_quantity=" . $this->quantity->CurrentValue; // Add prefix/suffix
				$this->quantity->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->quantity->HrefValue = FullUrl($this->quantity->HrefValue, "href");
			} else {
				$this->quantity->HrefValue = "";
			}

			// pro_unit
			$this->pro_unit->LinkCustomAttributes = "";
			$this->pro_unit->HrefValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_id->CurrentValue)) {
				$this->employee_id->HrefValue = "job_cardlist.php?x_employee_id=" . $this->employee_id->CurrentValue; // Add prefix/suffix
				$this->employee_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
			} else {
				$this->employee_id->HrefValue = "";
			}

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";

			// other1
			$this->other1->LinkCustomAttributes = "";
			$this->other1->HrefValue = "";

			// other2
			$this->other2->LinkCustomAttributes = "";
			$this->other2->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_no->FormValue)) {
			AddMessage($FormError, $this->jc_no->errorMessage());
		}
		if ($this->works->Required) {
			if (!$this->works->IsDetailKey && $this->works->FormValue != NULL && $this->works->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->works->caption(), $this->works->RequiredErrorMessage));
			}
		}
		if ($this->issue_to_internal->Required) {
			if (!$this->issue_to_internal->IsDetailKey && $this->issue_to_internal->FormValue != NULL && $this->issue_to_internal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to_internal->caption(), $this->issue_to_internal->RequiredErrorMessage));
			}
		}
		if ($this->issue_to_external->Required) {
			if (!$this->issue_to_external->IsDetailKey && $this->issue_to_external->FormValue != NULL && $this->issue_to_external->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to_external->caption(), $this->issue_to_external->RequiredErrorMessage));
			}
		}
		if ($this->issue_to->Required) {
			if (!$this->issue_to->IsDetailKey && $this->issue_to->FormValue != NULL && $this->issue_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->product_code->Required) {
			if (!$this->product_code->IsDetailKey && $this->product_code->FormValue != NULL && $this->product_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
			}
		}
		if ($this->item->Required) {
			if (!$this->item->IsDetailKey && $this->item->FormValue != NULL && $this->item->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
			}
		}
		if ($this->poid->Required) {
			if ($this->poid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if ($this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if ($this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->pro_unit->Required) {
			if (!$this->pro_unit->IsDetailKey && $this->pro_unit->FormValue != NULL && $this->pro_unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pro_unit->caption(), $this->pro_unit->RequiredErrorMessage));
			}
		}
		if ($this->employee_id->Required) {
			if ($this->employee_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
			}
		}
		if ($this->_1->Required) {
			if (!$this->_1->IsDetailKey && $this->_1->FormValue != NULL && $this->_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
			}
		}
		if ($this->_2->Required) {
			if (!$this->_2->IsDetailKey && $this->_2->FormValue != NULL && $this->_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
			}
		}
		if ($this->_3->Required) {
			if (!$this->_3->IsDetailKey && $this->_3->FormValue != NULL && $this->_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
			}
		}
		if ($this->_4->Required) {
			if (!$this->_4->IsDetailKey && $this->_4->FormValue != NULL && $this->_4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
			}
		}
		if ($this->_5->Required) {
			if (!$this->_5->IsDetailKey && $this->_5->FormValue != NULL && $this->_5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
			}
		}
		if ($this->_6->Required) {
			if (!$this->_6->IsDetailKey && $this->_6->FormValue != NULL && $this->_6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
			}
		}
		if ($this->_7->Required) {
			if (!$this->_7->IsDetailKey && $this->_7->FormValue != NULL && $this->_7->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
			}
		}
		if ($this->_8->Required) {
			if (!$this->_8->IsDetailKey && $this->_8->FormValue != NULL && $this->_8->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
			}
		}
		if ($this->other1->Required) {
			if (!$this->other1->IsDetailKey && $this->other1->FormValue != NULL && $this->other1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other1->caption(), $this->other1->RequiredErrorMessage));
			}
		}
		if ($this->other2->Required) {
			if (!$this->other2->IsDetailKey && $this->other2->FormValue != NULL && $this->other2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other2->caption(), $this->other2->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if ($this->in_id->Required) {
			if (!$this->in_id->IsDetailKey && $this->in_id->FormValue != NULL && $this->in_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->in_id->caption(), $this->in_id->RequiredErrorMessage));
			}
		}
		if ($this->balance_quantity->Required) {
			if (!$this->balance_quantity->IsDetailKey && $this->balance_quantity->FormValue != NULL && $this->balance_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->balance_quantity->caption(), $this->balance_quantity->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->buyer_id->FormValue)) {
			AddMessage($FormError, $this->buyer_id->errorMessage());
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->jc_no->CurrentValue <> "") { // Check field with unique index
			$filter = "(jc_no = " . AdjustSql($this->jc_no->CurrentValue, $this->Dbid) . ")";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->jc_no->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->jc_no->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// jc_no
		$this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, NULL, FALSE);

		// works
		$this->works->setDbValueDef($rsnew, $this->works->CurrentValue, NULL, FALSE);

		// issue_to_internal
		$this->issue_to_internal->setDbValueDef($rsnew, $this->issue_to_internal->CurrentValue, 0, FALSE);

		// issue_to_external
		$this->issue_to_external->setDbValueDef($rsnew, $this->issue_to_external->CurrentValue, 0, FALSE);

		// issue_to
		$this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, NULL, strval($this->issue_to->CurrentValue) == "");

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, 0, FALSE);

		// packing_type
		$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, 0, FALSE);

		// product_code
		$this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, NULL, FALSE);

		// item
		$this->item->setDbValueDef($rsnew, $this->item->CurrentValue, NULL, FALSE);

		// poid
		$this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, "", FALSE);

		// batch_no
		$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, NULL, FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, 0, FALSE);

		// pro_unit
		$this->pro_unit->setDbValueDef($rsnew, $this->pro_unit->CurrentValue, NULL, FALSE);

		// employee_id
		$this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, "", FALSE);

		// 1
		$this->_1->setDbValueDef($rsnew, $this->_1->CurrentValue, NULL, FALSE);

		// 2
		$this->_2->setDbValueDef($rsnew, $this->_2->CurrentValue, NULL, FALSE);

		// 3
		$this->_3->setDbValueDef($rsnew, $this->_3->CurrentValue, NULL, FALSE);

		// 4
		$this->_4->setDbValueDef($rsnew, $this->_4->CurrentValue, NULL, FALSE);

		// 5
		$this->_5->setDbValueDef($rsnew, $this->_5->CurrentValue, NULL, FALSE);

		// 6
		$this->_6->setDbValueDef($rsnew, $this->_6->CurrentValue, NULL, FALSE);

		// 7
		$this->_7->setDbValueDef($rsnew, $this->_7->CurrentValue, NULL, FALSE);

		// 8
		$this->_8->setDbValueDef($rsnew, $this->_8->CurrentValue, NULL, FALSE);

		// other1
		$this->other1->setDbValueDef($rsnew, $this->other1->CurrentValue, NULL, FALSE);

		// other2
		$this->other2->setDbValueDef($rsnew, $this->other2->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// buyer_id
		$this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, NULL, FALSE);

		// company_id
		$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("job_cardlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_works":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0 and (FIND_IN_SET('0', `type`) || FIND_IN_SET('1', `type`))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to_internal":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`category`=1" : "`id` = " . User_Company_ID() . " and `category`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to_external":
					$lookupFilter = function() {
						return "`category`=999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to":
					$lookupFilter = function() {
						return "`category`=999 || `category`=105";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_code":
					$lookupFilter = function() {
						return "`pending_qty` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_poid":
					$lookupFilter = function() {
						return "`pending_qty`>0 and `po`!='0'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pro_unit":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_works":
							break;
						case "x_issue_to_internal":
							break;
						case "x_issue_to_external":
							break;
						case "x_issue_to":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_packing_type":
							break;
						case "x_product_code":
							break;
						case "x_item":
							break;
						case "x_poid":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_po":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_batch_no":
							break;
						case "x_pro_unit":
							break;
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'job_card');
		if ($this->PageID == "add" || $this->PageID == "edit")
		{
			$this->item->ReadOnly = true;
		}
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>