<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for job_card_bc
 */
class job_card_bc extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $no;
	public $works;
	public $issue_to;
	public $grp;
	public $s_grp;
	public $po;
	public $design_size_1;
	public $design_size;
	public $size_wl;
	public $loom_no;
	public $employee_1;
	public $employee_2;
	public $employee_3;
	public $employee_id;
	public $_barcode;
	public $r_date;
	public $lot_no;
	public $deduction;
	public $ded_remarks;
	public $operator;
	public $datetime;
	public $updated;
	public $_1;
	public $_2;
	public $_3;
	public $_4;
	public $_5;
	public $_6;
	public $_7;
	public $_8;
	public $other1;
	public $other2;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'job_card_bc';
		$this->TableName = 'job_card_bc';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`job_card_bc`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('job_card_bc', 'job_card_bc', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// no
		$this->no = new DbField('job_card_bc', 'job_card_bc', 'x_no', 'no', '`no`', '`no`', 19, -1, FALSE, '`no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->no->Required = TRUE; // Required field
		$this->no->Sortable = TRUE; // Allow sort
		$this->no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['no'] = &$this->no;

		// works
		$this->works = new DbField('job_card_bc', 'job_card_bc', 'x_works', 'works', '`works`', '`works`', 17, -1, FALSE, '`works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->works->Sortable = TRUE; // Allow sort
		$this->works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->works->Lookup = new Lookup('works', 'godown', TRUE, 'id', ["name","code","",""], [], ["x_po","x_design_size","x_employee_1","x_employee_2","x_employee_3","x_employee_id[]","x__barcode[]"], [], [], [], [], '`name` ASC', '');
		$this->works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['works'] = &$this->works;

		// issue_to
		$this->issue_to = new DbField('job_card_bc', 'job_card_bc', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 3, -1, FALSE, '`issue_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to->Required = TRUE; // Required field
		$this->issue_to->Sortable = TRUE; // Allow sort
		$this->issue_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to->Lookup = new Lookup('issue_to', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to'] = &$this->issue_to;

		// grp
		$this->grp = new DbField('job_card_bc', 'job_card_bc', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp","x_po","x_employee_1","x_employee_2","x_employee_3","x_employee_id[]"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('job_card_bc', 'job_card_bc', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`grp` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// po
		$this->po = new DbField('job_card_bc', 'job_card_bc', 'x_po', 'po', '`po`', '`po`', 200, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po->Nullable = FALSE; // NOT NULL field
		$this->po->Required = TRUE; // Required field
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po->Lookup = new Lookup('po', 'not_loomcard', TRUE, 'po', ["po_d","","",""], ["x_grp","x_works"], ["x_design_size","x__barcode[]"], ["grp","weaving_works"], ["x_grp","x_weaving_works"], [], [], '`sort` ASC', '');
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// design_size_1
		$this->design_size_1 = new DbField('job_card_bc', 'job_card_bc', 'x_design_size_1', 'design_size_1', '`design_size`', '`design_size`', 200, -1, FALSE, '`design_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design_size_1->IsCustom = TRUE; // Custom field
		$this->design_size_1->Sortable = TRUE; // Allow sort
		$this->fields['design_size_1'] = &$this->design_size_1;

		// design_size
		$this->design_size = new DbField('job_card_bc', 'job_card_bc', 'x_design_size', 'design_size', '`design_size`', '`design_size`', 200, -1, FALSE, '`design_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->design_size->Required = TRUE; // Required field
		$this->design_size->Sortable = FALSE; // Allow sort
		$this->design_size->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->design_size->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->design_size->Lookup = new Lookup('design_size', 'not_loomcard', TRUE, 'design_size', ["design_size","","",""], ["x_po","x_works"], ["x__barcode[]"], ["po","weaving_works"], ["x_po","x_weaving_works"], [], [], '`design_size` ASC', '');
		$this->fields['design_size'] = &$this->design_size;

		// size_wl
		$this->size_wl = new DbField('job_card_bc', 'job_card_bc', 'x_size_wl', 'size_wl', '`size_wl`', '`size_wl`', 200, -1, FALSE, '`size_wl`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_wl->Nullable = FALSE; // NOT NULL field
		$this->size_wl->Required = TRUE; // Required field
		$this->size_wl->Sortable = FALSE; // Allow sort
		$this->fields['size_wl'] = &$this->size_wl;

		// loom_no
		$this->loom_no = new DbField('job_card_bc', 'job_card_bc', 'x_loom_no', 'loom_no', '`loom_no`', '`loom_no`', 18, -1, FALSE, '`loom_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->loom_no->Required = TRUE; // Required field
		$this->loom_no->Sortable = TRUE; // Allow sort
		$this->loom_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->loom_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->loom_no->Lookup = new Lookup('loom_no', 'loom_info', FALSE, 'id', ["item","size_width","a_barcode","prod_sqm_daily"], [], [], [], [], [], [], '`a_barcode` ASC', '<span class="text-info">{{:df1}}, No. Loom,  Size: {{:df2}}, Pending: {{:df3}}</span>');
		$this->loom_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['loom_no'] = &$this->loom_no;

		// employee_1
		$this->employee_1 = new DbField('job_card_bc', 'job_card_bc', 'x_employee_1', 'employee_1', '`employee_1`', '`employee_1`', 2, -1, FALSE, '`EV__employee_1`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->employee_1->Required = TRUE; // Required field
		$this->employee_1->Sortable = FALSE; // Allow sort
		$this->employee_1->Lookup = new Lookup('employee_1', 'production_employee_view_pw', TRUE, 'id', ["id","user_name","",""], ["x_grp","x_works"], [], ["grp","site"], ["x_grp","x_site"], [], [], '`user_name` ASC', '');
		$this->employee_1->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['employee_1'] = &$this->employee_1;

		// employee_2
		$this->employee_2 = new DbField('job_card_bc', 'job_card_bc', 'x_employee_2', 'employee_2', '`employee_2`', '`employee_2`', 2, -1, FALSE, '`EV__employee_2`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->employee_2->Required = TRUE; // Required field
		$this->employee_2->Sortable = FALSE; // Allow sort
		$this->employee_2->Lookup = new Lookup('employee_2', 'production_employee_view_pw', TRUE, 'id', ["id","user_name","",""], ["x_grp","x_works"], [], ["grp","site"], ["x_grp","x_site"], [], [], '`user_name` ASC', '');
		$this->employee_2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['employee_2'] = &$this->employee_2;

		// employee_3
		$this->employee_3 = new DbField('job_card_bc', 'job_card_bc', 'x_employee_3', 'employee_3', '`employee_3`', '`employee_3`', 2, -1, FALSE, '`employee_3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->employee_3->Required = TRUE; // Required field
		$this->employee_3->Sortable = FALSE; // Allow sort
		$this->employee_3->Lookup = new Lookup('employee_3', 'production_employee_view_pw', TRUE, 'id', ["id","user_name","",""], ["x_grp","x_works"], [], ["grp","site"], ["x_grp","x_site"], [], [], '`user_name` ASC', '');
		$this->employee_3->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['employee_3'] = &$this->employee_3;

		// employee_id
		$this->employee_id = new DbField('job_card_bc', 'job_card_bc', 'x_employee_id', 'employee_id', '`employee_id`', '`employee_id`', 200, -1, FALSE, '`employee_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->employee_id->Sortable = TRUE; // Allow sort
		$this->employee_id->SelectMultiple = TRUE; // Multiple select
		$this->employee_id->Lookup = new Lookup('employee_id', 'production_employee_view_pw', TRUE, 'id', ["id","user_name","",""], ["x_grp","x_works"], [], ["grp","site"], ["x_grp","x_site"], [], [], '`user_name` ASC', '');
		$this->fields['employee_id'] = &$this->employee_id;

		// barcode
		$this->_barcode = new DbField('job_card_bc', 'job_card_bc', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 201, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->_barcode->Required = TRUE; // Required field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->SelectMultiple = TRUE; // Multiple select
		$this->_barcode->Lookup = new Lookup('barcode', 'not_loomcard', FALSE, 'barcode', ["barcode","","",""], ["x_po","x_design_size","x_works"], [], ["po","design_size","weaving_works"], ["x_po","x_design_size","x_weaving_works"], [], [], '`barcode` ASC', '');
		$this->fields['barcode'] = &$this->_barcode;

		// r_date
		$this->r_date = new DbField('job_card_bc', 'job_card_bc', 'x_r_date', 'r_date', '`r_date`', CastDateFieldForLike('`r_date`', 0, "DB"), 133, 0, FALSE, '`r_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->r_date->Sortable = TRUE; // Allow sort
		$this->r_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['r_date'] = &$this->r_date;

		// lot_no
		$this->lot_no = new DbField('job_card_bc', 'job_card_bc', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->lot_no->Lookup = new Lookup('lot_no', 'jc_mrlot', FALSE, 'id', ["product_code","packing","lot_no","Balance"], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->fields['lot_no'] = &$this->lot_no;

		// deduction
		$this->deduction = new DbField('job_card_bc', 'job_card_bc', 'x_deduction', 'deduction', '`deduction`', '`deduction`', 131, -1, FALSE, '`deduction`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->deduction->Nullable = FALSE; // NOT NULL field
		$this->deduction->Sortable = TRUE; // Allow sort
		$this->deduction->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['deduction'] = &$this->deduction;

		// ded_remarks
		$this->ded_remarks = new DbField('job_card_bc', 'job_card_bc', 'x_ded_remarks', 'ded_remarks', '`ded_remarks`', '`ded_remarks`', 200, -1, FALSE, '`ded_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ded_remarks->Sortable = TRUE; // Allow sort
		$this->fields['ded_remarks'] = &$this->ded_remarks;

		// operator
		$this->operator = new DbField('job_card_bc', 'job_card_bc', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('job_card_bc', 'job_card_bc', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 7, "DB"), 135, 7, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['datetime'] = &$this->datetime;

		// updated
		$this->updated = new DbField('job_card_bc', 'job_card_bc', 'x_updated', 'updated', '`updated`', '`updated`', 17, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Sortable = FALSE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;

		// 1
		$this->_1 = new DbField('job_card_bc', 'job_card_bc', 'x__1', '1', '`1`', '`1`', 200, -1, FALSE, '`1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_1->Sortable = TRUE; // Allow sort
		$this->fields['1'] = &$this->_1;

		// 2
		$this->_2 = new DbField('job_card_bc', 'job_card_bc', 'x__2', '2', '`2`', '`2`', 200, -1, FALSE, '`2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2->Sortable = TRUE; // Allow sort
		$this->fields['2'] = &$this->_2;

		// 3
		$this->_3 = new DbField('job_card_bc', 'job_card_bc', 'x__3', '3', '`3`', '`3`', 200, -1, FALSE, '`3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_3->Sortable = TRUE; // Allow sort
		$this->fields['3'] = &$this->_3;

		// 4
		$this->_4 = new DbField('job_card_bc', 'job_card_bc', 'x__4', '4', '`4`', '`4`', 200, -1, FALSE, '`4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4->Sortable = TRUE; // Allow sort
		$this->fields['4'] = &$this->_4;

		// 5
		$this->_5 = new DbField('job_card_bc', 'job_card_bc', 'x__5', '5', '`5`', '`5`', 200, -1, FALSE, '`5`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_5->Sortable = TRUE; // Allow sort
		$this->fields['5'] = &$this->_5;

		// 6
		$this->_6 = new DbField('job_card_bc', 'job_card_bc', 'x__6', '6', '`6`', '`6`', 200, -1, FALSE, '`6`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_6->Sortable = TRUE; // Allow sort
		$this->fields['6'] = &$this->_6;

		// 7
		$this->_7 = new DbField('job_card_bc', 'job_card_bc', 'x__7', '7', '`7`', '`7`', 200, -1, FALSE, '`7`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_7->Sortable = TRUE; // Allow sort
		$this->fields['7'] = &$this->_7;

		// 8
		$this->_8 = new DbField('job_card_bc', 'job_card_bc', 'x__8', '8', '`8`', '`8`', 200, -1, FALSE, '`8`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_8->Sortable = TRUE; // Allow sort
		$this->fields['8'] = &$this->_8;

		// other1
		$this->other1 = new DbField('job_card_bc', 'job_card_bc', 'x_other1', 'other1', '`other1`', '`other1`', 200, -1, FALSE, '`other1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other1->Sortable = TRUE; // Allow sort
		$this->fields['other1'] = &$this->other1;

		// other2
		$this->other2 = new DbField('job_card_bc', 'job_card_bc', 'x_other2', 'other2', '`other2`', '`other2`', 200, -1, FALSE, '`other2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other2->Sortable = TRUE; // Allow sort
		$this->fields['other2'] = &$this->other2;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`job_card_bc`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, `design_size` AS `design_size_1` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, `design_size` AS `design_size_1`, (SELECT DISTINCT CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_1) . "',COALESCE(`user_name`,'')) FROM `production_employee_view_pw` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `job_card_bc`.`employee_1` LIMIT 1) AS `EV__employee_1`, (SELECT DISTINCT CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_2) . "',COALESCE(`user_name`,'')) FROM `production_employee_view_pw` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `job_card_bc`.`employee_2` LIMIT 1) AS `EV__employee_2` FROM `job_card_bc`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = User_Site() == 0 ?  "`works` > 0" : "`works` > 0 and FIND_IN_SET(`works`, " . User_Site() . ")";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->employee_1->AdvancedSearch->SearchValue <> "" ||
			$this->employee_1->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->employee_1->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->employee_1->VirtualExpression . " "))
			return TRUE;
		if ($this->employee_2->AdvancedSearch->SearchValue <> "" ||
			$this->employee_2->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->employee_2->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->employee_2->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->no->DbValue = $row['no'];
		$this->works->DbValue = $row['works'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->po->DbValue = $row['po'];
		$this->design_size_1->DbValue = $row['design_size_1'];
		$this->design_size->DbValue = $row['design_size'];
		$this->size_wl->DbValue = $row['size_wl'];
		$this->loom_no->DbValue = $row['loom_no'];
		$this->employee_1->DbValue = $row['employee_1'];
		$this->employee_2->DbValue = $row['employee_2'];
		$this->employee_3->DbValue = $row['employee_3'];
		$this->employee_id->DbValue = $row['employee_id'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->r_date->DbValue = $row['r_date'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->deduction->DbValue = $row['deduction'];
		$this->ded_remarks->DbValue = $row['ded_remarks'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->updated->DbValue = $row['updated'];
		$this->_1->DbValue = $row['1'];
		$this->_2->DbValue = $row['2'];
		$this->_3->DbValue = $row['3'];
		$this->_4->DbValue = $row['4'];
		$this->_5->DbValue = $row['5'];
		$this->_6->DbValue = $row['6'];
		$this->_7->DbValue = $row['7'];
		$this->_8->DbValue = $row['8'];
		$this->other1->DbValue = $row['other1'];
		$this->other2->DbValue = $row['other2'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "job_card_bclist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "job_card_bcview.php")
			return $Language->phrase("View");
		elseif ($pageName == "job_card_bcedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "job_card_bcadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "job_card_bclist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("job_card_bcview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("job_card_bcview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "job_card_bcadd.php?" . $this->getUrlParm($parm);
		else
			$url = "job_card_bcadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("job_card_bcedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("job_card_bcadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("job_card_bcdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->no->setDbValue($rs->fields('no'));
		$this->works->setDbValue($rs->fields('works'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->po->setDbValue($rs->fields('po'));
		$this->design_size_1->setDbValue($rs->fields('design_size_1'));
		$this->design_size->setDbValue($rs->fields('design_size'));
		$this->size_wl->setDbValue($rs->fields('size_wl'));
		$this->loom_no->setDbValue($rs->fields('loom_no'));
		$this->employee_1->setDbValue($rs->fields('employee_1'));
		$this->employee_2->setDbValue($rs->fields('employee_2'));
		$this->employee_3->setDbValue($rs->fields('employee_3'));
		$this->employee_id->setDbValue($rs->fields('employee_id'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->r_date->setDbValue($rs->fields('r_date'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->deduction->setDbValue($rs->fields('deduction'));
		$this->ded_remarks->setDbValue($rs->fields('ded_remarks'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->updated->setDbValue($rs->fields('updated'));
		$this->_1->setDbValue($rs->fields('1'));
		$this->_2->setDbValue($rs->fields('2'));
		$this->_3->setDbValue($rs->fields('3'));
		$this->_4->setDbValue($rs->fields('4'));
		$this->_5->setDbValue($rs->fields('5'));
		$this->_6->setDbValue($rs->fields('6'));
		$this->_7->setDbValue($rs->fields('7'));
		$this->_8->setDbValue($rs->fields('8'));
		$this->other1->setDbValue($rs->fields('other1'));
		$this->other2->setDbValue($rs->fields('other2'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// no
		// works
		// issue_to
		// grp
		// s_grp

		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// po
		// design_size_1
		// design_size

		$this->design_size->CellCssStyle = "white-space: nowrap;";

		// size_wl
		$this->size_wl->CellCssStyle = "white-space: nowrap;";

		// loom_no
		// employee_1

		$this->employee_1->CellCssStyle = "white-space: nowrap;";

		// employee_2
		$this->employee_2->CellCssStyle = "white-space: nowrap;";

		// employee_3
		$this->employee_3->CellCssStyle = "white-space: nowrap;";

		// employee_id
		// barcode
		// r_date
		// lot_no
		// deduction
		// ded_remarks
		// operator
		// datetime
		// updated

		$this->updated->CellCssStyle = "white-space: nowrap;";

		// 1
		// 2
		// 3
		// 4
		// 5
		// 6
		// 7
		// 8
		// other1
		// other2
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// no
		$this->no->ViewValue = $this->no->CurrentValue;
		$this->no->ViewValue = FormatNumber($this->no->ViewValue, 0, -2, -2, -2);
		$this->no->ViewCustomAttributes = "";

		// works
		$curVal = strval($this->works->CurrentValue);
		if ($curVal <> "") {
			$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
			if ($this->works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return User_Site() == 0 ?  "`status`=1 and `id` > 0 && `id` != 10" : "`status`=1 and `id` > 0 && `id` != 10 and FIND_IN_SET(id, " . User_Site() . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->works->ViewValue = $this->works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->works->ViewValue = $this->works->CurrentValue;
				}
			}
		} else {
			$this->works->ViewValue = NULL;
		}
		$this->works->ViewCustomAttributes = "";

		// issue_to
		$curVal = strval($this->issue_to->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			if ($this->issue_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category`=999";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
				}
			}
		} else {
			$this->issue_to->ViewValue = NULL;
		}
		$this->issue_to->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// po
		$curVal = strval($this->po->CurrentValue);
		if ($curVal <> "") {
			$this->po->ViewValue = $this->po->lookupCacheOption($curVal);
			if ($this->po->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`po`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`loom_week` != 0 and `loom_week` <= (" . CWeekID() . " + `extra_loom_week`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->po->ViewValue = $this->po->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->po->ViewValue = $this->po->CurrentValue;
				}
			}
		} else {
			$this->po->ViewValue = NULL;
		}
		$this->po->ViewCustomAttributes = "";

		// design_size_1
		$this->design_size_1->ViewValue = $this->design_size_1->CurrentValue;
		$this->design_size_1->ViewCustomAttributes = "";

		// design_size
		$curVal = strval($this->design_size->CurrentValue);
		if ($curVal <> "") {
			$this->design_size->ViewValue = $this->design_size->lookupCacheOption($curVal);
			if ($this->design_size->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`design_size`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return "`loom_week` != 0 and `loom_week` <= (" . CWeekID() . " + `extra_loom_week`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_size->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_size->ViewValue = $this->design_size->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_size->ViewValue = $this->design_size->CurrentValue;
				}
			}
		} else {
			$this->design_size->ViewValue = NULL;
		}
		$this->design_size->ViewCustomAttributes = "";

		// size_wl
		$this->size_wl->ViewValue = $this->size_wl->CurrentValue;
		$this->size_wl->ViewCustomAttributes = "";

		// loom_no
		$curVal = strval($this->loom_no->CurrentValue);
		if ($curVal <> "") {
			$this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
			if ($this->loom_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id`=0 || `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->loom_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
					$this->loom_no->ViewValue = $this->loom_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->loom_no->ViewValue = $this->loom_no->CurrentValue;
				}
			}
		} else {
			$this->loom_no->ViewValue = NULL;
		}
		$this->loom_no->ViewCustomAttributes = "";

		// employee_1
		if ($this->employee_1->VirtualValue <> "") {
			$this->employee_1->ViewValue = $this->employee_1->VirtualValue;
		} else {
			$this->employee_1->ViewValue = $this->employee_1->CurrentValue;
		$curVal = strval($this->employee_1->CurrentValue);
		if ($curVal <> "") {
			$this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
			if ($this->employee_1->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->employee_1->ViewValue = $this->employee_1->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->employee_1->ViewValue = $this->employee_1->CurrentValue;
				}
			}
		} else {
			$this->employee_1->ViewValue = NULL;
		}
		}
		$this->employee_1->ViewCustomAttributes = "";

		// employee_2
		if ($this->employee_2->VirtualValue <> "") {
			$this->employee_2->ViewValue = $this->employee_2->VirtualValue;
		} else {
			$this->employee_2->ViewValue = $this->employee_2->CurrentValue;
		$curVal = strval($this->employee_2->CurrentValue);
		if ($curVal <> "") {
			$this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
			if ($this->employee_2->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_2->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->employee_2->ViewValue = $this->employee_2->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->employee_2->ViewValue = $this->employee_2->CurrentValue;
				}
			}
		} else {
			$this->employee_2->ViewValue = NULL;
		}
		}
		$this->employee_2->ViewCustomAttributes = "";

		// employee_3
		$this->employee_3->ViewValue = $this->employee_3->CurrentValue;
		$curVal = strval($this->employee_3->CurrentValue);
		if ($curVal <> "") {
			$this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
			if ($this->employee_3->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_3->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->employee_3->ViewValue = $this->employee_3->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->employee_3->ViewValue = $this->employee_3->CurrentValue;
				}
			}
		} else {
			$this->employee_3->ViewValue = NULL;
		}
		$this->employee_3->ViewCustomAttributes = "";

		// employee_id
		$curVal = strval($this->employee_id->CurrentValue);
		if ($curVal <> "") {
			$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			if ($this->employee_id->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->employee_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
				}
			}
		} else {
			$this->employee_id->ViewValue = NULL;
		}
		$this->employee_id->ViewCustomAttributes = "";

		// barcode
		$curVal = strval($this->_barcode->CurrentValue);
		if ($curVal <> "") {
			$this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
			if ($this->_barcode->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`barcode`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->_barcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->_barcode->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
				}
			}
		} else {
			$this->_barcode->ViewValue = NULL;
		}
		$this->_barcode->ViewCustomAttributes = "";

		// r_date
		$this->r_date->ViewValue = $this->r_date->CurrentValue;
		$this->r_date->ViewValue = FormatDateTime($this->r_date->ViewValue, 0);
		$this->r_date->ViewCustomAttributes = "";

		// lot_no
		$curVal = strval($this->lot_no->CurrentValue);
		if ($curVal <> "") {
			$this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
			if ($this->lot_no->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_MEMO, "");
				}
				$sqlWrk = $this->lot_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->lot_no->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->lot_no->ViewValue->add($this->lot_no->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
				}
			}
		} else {
			$this->lot_no->ViewValue = NULL;
		}
		$this->lot_no->ViewCustomAttributes = "";

		// deduction
		$this->deduction->ViewValue = $this->deduction->CurrentValue;
		$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 2, -2, -2, -2);
		$this->deduction->ViewCustomAttributes = "";

		// ded_remarks
		$this->ded_remarks->ViewValue = $this->ded_remarks->CurrentValue;
		$this->ded_remarks->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
		$this->datetime->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
		$this->updated->ViewCustomAttributes = "";

		// 1
		$this->_1->ViewValue = $this->_1->CurrentValue;
		$this->_1->ViewCustomAttributes = "";

		// 2
		$this->_2->ViewValue = $this->_2->CurrentValue;
		$this->_2->ViewCustomAttributes = "";

		// 3
		$this->_3->ViewValue = $this->_3->CurrentValue;
		$this->_3->ViewCustomAttributes = "";

		// 4
		$this->_4->ViewValue = $this->_4->CurrentValue;
		$this->_4->ViewCustomAttributes = "";

		// 5
		$this->_5->ViewValue = $this->_5->CurrentValue;
		$this->_5->ViewCustomAttributes = "";

		// 6
		$this->_6->ViewValue = $this->_6->CurrentValue;
		$this->_6->ViewCustomAttributes = "";

		// 7
		$this->_7->ViewValue = $this->_7->CurrentValue;
		$this->_7->ViewCustomAttributes = "";

		// 8
		$this->_8->ViewValue = $this->_8->CurrentValue;
		$this->_8->ViewCustomAttributes = "";

		// other1
		$this->other1->ViewValue = $this->other1->CurrentValue;
		$this->other1->ViewCustomAttributes = "";

		// other2
		$this->other2->ViewValue = $this->other2->CurrentValue;
		$this->other2->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// no
		$this->no->LinkCustomAttributes = "";
		if (!EmptyValue($this->no->CurrentValue)) {
			$this->no->HrefValue = "bcodelist.php?x_jc_no=" . $this->no->CurrentValue; // Add prefix/suffix
			$this->no->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->no->HrefValue = FullUrl($this->no->HrefValue, "href");
		} else {
			$this->no->HrefValue = "";
		}
		$this->no->TooltipValue = "";

		// works
		$this->works->LinkCustomAttributes = "";
		$this->works->HrefValue = "";
		$this->works->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		$this->issue_to->HrefValue = "";
		$this->issue_to->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// design_size_1
		$this->design_size_1->LinkCustomAttributes = "";
		$this->design_size_1->HrefValue = "";
		$this->design_size_1->TooltipValue = "";

		// design_size
		$this->design_size->LinkCustomAttributes = "";
		$this->design_size->HrefValue = "";
		$this->design_size->TooltipValue = "";

		// size_wl
		$this->size_wl->LinkCustomAttributes = "";
		$this->size_wl->HrefValue = "";
		$this->size_wl->TooltipValue = "";

		// loom_no
		$this->loom_no->LinkCustomAttributes = "";
		$this->loom_no->HrefValue = "";
		$this->loom_no->TooltipValue = "";

		// employee_1
		$this->employee_1->LinkCustomAttributes = "";
		$this->employee_1->HrefValue = "";
		$this->employee_1->TooltipValue = "";

		// employee_2
		$this->employee_2->LinkCustomAttributes = "";
		$this->employee_2->HrefValue = "";
		$this->employee_2->TooltipValue = "";

		// employee_3
		$this->employee_3->LinkCustomAttributes = "";
		$this->employee_3->HrefValue = "";
		$this->employee_3->TooltipValue = "";

		// employee_id
		$this->employee_id->LinkCustomAttributes = "";
		$this->employee_id->HrefValue = "";
		$this->employee_id->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// r_date
		$this->r_date->LinkCustomAttributes = "";
		$this->r_date->HrefValue = "";
		$this->r_date->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// deduction
		$this->deduction->LinkCustomAttributes = "";
		$this->deduction->HrefValue = "";
		$this->deduction->TooltipValue = "";

		// ded_remarks
		$this->ded_remarks->LinkCustomAttributes = "";
		$this->ded_remarks->HrefValue = "";
		$this->ded_remarks->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// 1
		$this->_1->LinkCustomAttributes = "";
		$this->_1->HrefValue = "";
		$this->_1->TooltipValue = "";

		// 2
		$this->_2->LinkCustomAttributes = "";
		$this->_2->HrefValue = "";
		$this->_2->TooltipValue = "";

		// 3
		$this->_3->LinkCustomAttributes = "";
		$this->_3->HrefValue = "";
		$this->_3->TooltipValue = "";

		// 4
		$this->_4->LinkCustomAttributes = "";
		$this->_4->HrefValue = "";
		$this->_4->TooltipValue = "";

		// 5
		$this->_5->LinkCustomAttributes = "";
		$this->_5->HrefValue = "";
		$this->_5->TooltipValue = "";

		// 6
		$this->_6->LinkCustomAttributes = "";
		$this->_6->HrefValue = "";
		$this->_6->TooltipValue = "";

		// 7
		$this->_7->LinkCustomAttributes = "";
		$this->_7->HrefValue = "";
		$this->_7->TooltipValue = "";

		// 8
		$this->_8->LinkCustomAttributes = "";
		$this->_8->HrefValue = "";
		$this->_8->TooltipValue = "";

		// other1
		$this->other1->LinkCustomAttributes = "";
		$this->other1->HrefValue = "";
		$this->other1->TooltipValue = "";

		// other2
		$this->other2->LinkCustomAttributes = "";
		$this->other2->HrefValue = "";
		$this->other2->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// no
		$this->no->EditAttrs["class"] = "form-control";
		$this->no->EditCustomAttributes = "";
		$this->no->EditValue = $this->no->CurrentValue;
		$this->no->PlaceHolder = RemoveHtml($this->no->caption());

		// works
		$this->works->EditAttrs["class"] = "form-control";
		$this->works->EditCustomAttributes = "";

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";

		// design_size_1
		$this->design_size_1->EditAttrs["class"] = "form-control";
		$this->design_size_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design_size_1->CurrentValue = HtmlDecode($this->design_size_1->CurrentValue);
		$this->design_size_1->EditValue = $this->design_size_1->CurrentValue;
		$this->design_size_1->PlaceHolder = RemoveHtml($this->design_size_1->caption());

		// design_size
		$this->design_size->EditAttrs["class"] = "form-control";
		$this->design_size->EditCustomAttributes = "";

		// size_wl
		$this->size_wl->EditAttrs["class"] = "form-control";
		$this->size_wl->EditCustomAttributes = 'ReadOnly';
		if (REMOVE_XSS)
			$this->size_wl->CurrentValue = HtmlDecode($this->size_wl->CurrentValue);
		$this->size_wl->EditValue = $this->size_wl->CurrentValue;
		$this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

		// loom_no
		$this->loom_no->EditAttrs["class"] = "form-control";
		$this->loom_no->EditCustomAttributes = "";

		// employee_1
		$this->employee_1->EditAttrs["class"] = "form-control";
		$this->employee_1->EditCustomAttributes = "";
		$this->employee_1->EditValue = $this->employee_1->CurrentValue;
		$this->employee_1->PlaceHolder = RemoveHtml($this->employee_1->caption());

		// employee_2
		$this->employee_2->EditAttrs["class"] = "form-control";
		$this->employee_2->EditCustomAttributes = "";
		$this->employee_2->EditValue = $this->employee_2->CurrentValue;
		$this->employee_2->PlaceHolder = RemoveHtml($this->employee_2->caption());

		// employee_3
		$this->employee_3->EditAttrs["class"] = "form-control";
		$this->employee_3->EditCustomAttributes = "";
		$this->employee_3->EditValue = $this->employee_3->CurrentValue;
		$this->employee_3->PlaceHolder = RemoveHtml($this->employee_3->caption());

		// employee_id
		$this->employee_id->EditAttrs["class"] = "form-control";
		$this->employee_id->EditCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";

		// r_date
		$this->r_date->EditAttrs["class"] = "form-control";
		$this->r_date->EditCustomAttributes = "";
		$this->r_date->EditValue = FormatDateTime($this->r_date->CurrentValue, 8);
		$this->r_date->PlaceHolder = RemoveHtml($this->r_date->caption());

		// lot_no
		$this->lot_no->EditCustomAttributes = "";

		// deduction
		$this->deduction->EditAttrs["class"] = "form-control";
		$this->deduction->EditCustomAttributes = "";
		$this->deduction->EditValue = $this->deduction->CurrentValue;
		$this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
		if (strval($this->deduction->EditValue) <> "" && is_numeric($this->deduction->EditValue))
			$this->deduction->EditValue = FormatNumber($this->deduction->EditValue, -2, -2, -2, -2);

		// ded_remarks
		$this->ded_remarks->EditAttrs["class"] = "form-control";
		$this->ded_remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->ded_remarks->CurrentValue = HtmlDecode($this->ded_remarks->CurrentValue);
		$this->ded_remarks->EditValue = $this->ded_remarks->CurrentValue;
		$this->ded_remarks->PlaceHolder = RemoveHtml($this->ded_remarks->caption());

		// operator
		// datetime
		// updated

		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// 1
		$this->_1->EditAttrs["class"] = "form-control";
		$this->_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
		$this->_1->EditValue = $this->_1->CurrentValue;
		$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

		// 2
		$this->_2->EditAttrs["class"] = "form-control";
		$this->_2->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
		$this->_2->EditValue = $this->_2->CurrentValue;
		$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

		// 3
		$this->_3->EditAttrs["class"] = "form-control";
		$this->_3->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
		$this->_3->EditValue = $this->_3->CurrentValue;
		$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

		// 4
		$this->_4->EditAttrs["class"] = "form-control";
		$this->_4->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
		$this->_4->EditValue = $this->_4->CurrentValue;
		$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

		// 5
		$this->_5->EditAttrs["class"] = "form-control";
		$this->_5->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
		$this->_5->EditValue = $this->_5->CurrentValue;
		$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

		// 6
		$this->_6->EditAttrs["class"] = "form-control";
		$this->_6->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
		$this->_6->EditValue = $this->_6->CurrentValue;
		$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

		// 7
		$this->_7->EditAttrs["class"] = "form-control";
		$this->_7->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
		$this->_7->EditValue = $this->_7->CurrentValue;
		$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

		// 8
		$this->_8->EditAttrs["class"] = "form-control";
		$this->_8->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
		$this->_8->EditValue = $this->_8->CurrentValue;
		$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

		// other1
		$this->other1->EditAttrs["class"] = "form-control";
		$this->other1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->other1->CurrentValue = HtmlDecode($this->other1->CurrentValue);
		$this->other1->EditValue = $this->other1->CurrentValue;
		$this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

		// other2
		$this->other2->EditAttrs["class"] = "form-control";
		$this->other2->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->other2->CurrentValue = HtmlDecode($this->other2->CurrentValue);
		$this->other2->EditValue = $this->other2->CurrentValue;
		$this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->no);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->design_size_1);
					$doc->exportCaption($this->loom_no);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->r_date);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->deduction);
					$doc->exportCaption($this->ded_remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->no);
					$doc->exportCaption($this->works);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->design_size_1);
					$doc->exportCaption($this->loom_no);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->r_date);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->deduction);
					$doc->exportCaption($this->ded_remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->no);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->grp);
						$doc->exportField($this->po);
						$doc->exportField($this->design_size_1);
						$doc->exportField($this->loom_no);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->r_date);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->deduction);
						$doc->exportField($this->ded_remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->no);
						$doc->exportField($this->works);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->po);
						$doc->exportField($this->design_size_1);
						$doc->exportField($this->loom_no);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->r_date);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->deduction);
						$doc->exportField($this->ded_remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>