<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class job_card_bc_add extends job_card_bc
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'job_card_bc';

	// Page object name
	public $PageObjName = "job_card_bc_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (job_card_bc)
		if (!isset($GLOBALS["job_card_bc"]) || get_class($GLOBALS["job_card_bc"]) == PROJECT_NAMESPACE . "job_card_bc") {
			$GLOBALS["job_card_bc"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["job_card_bc"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card_bc');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $job_card_bc;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($job_card_bc);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "job_card_bcview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("job_card_bclist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->no->setVisibility();
		$this->works->setVisibility();
		$this->issue_to->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->po->setVisibility();
		$this->design_size_1->Visible = FALSE;
		$this->design_size->setVisibility();
		$this->size_wl->setVisibility();
		$this->loom_no->setVisibility();
		$this->employee_1->setVisibility();
		$this->employee_2->setVisibility();
		$this->employee_3->setVisibility();
		$this->employee_id->Visible = FALSE;
		$this->_barcode->setVisibility();
		$this->r_date->setVisibility();
		$this->lot_no->setVisibility();
		$this->deduction->setVisibility();
		$this->ded_remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->_1->setVisibility();
		$this->_2->setVisibility();
		$this->_3->setVisibility();
		$this->_4->setVisibility();
		$this->_5->setVisibility();
		$this->_6->setVisibility();
		$this->_7->setVisibility();
		$this->_8->setVisibility();
		$this->other1->setVisibility();
		$this->other2->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->works);
		$this->setupLookupOptions($this->issue_to);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->po);
		$this->setupLookupOptions($this->design_size);
		$this->setupLookupOptions($this->loom_no);
		$this->setupLookupOptions($this->employee_1);
		$this->setupLookupOptions($this->employee_2);
		$this->setupLookupOptions($this->employee_3);
		$this->setupLookupOptions($this->employee_id);
		$this->setupLookupOptions($this->_barcode);
		$this->setupLookupOptions($this->lot_no);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("job_card_bclist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "job_card_bclist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "job_card_bcview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->no->CurrentValue = 0;
		$this->works->CurrentValue = (isset($_COOKIE["location"]))? $_COOKIE["location"]:User_Site();
		$this->issue_to->CurrentValue = NULL;
		$this->issue_to->OldValue = $this->issue_to->CurrentValue;
		$this->grp->CurrentValue = (isset($_COOKIE["grp"]))? $_COOKIE["grp"]:'3';
		$this->s_grp->CurrentValue = (isset($_COOKIE["s_grp"]))? $_COOKIE["s_grp"]:'91';
		$this->po->CurrentValue = (isset($_COOKIE["po"]))? $_COOKIE["po"]:'';
		$this->design_size_1->CurrentValue = NULL;
		$this->design_size_1->OldValue = $this->design_size_1->CurrentValue;
		$this->design_size->CurrentValue = NULL;
		$this->design_size->OldValue = $this->design_size->CurrentValue;
		$this->size_wl->CurrentValue = NULL;
		$this->size_wl->OldValue = $this->size_wl->CurrentValue;
		$this->loom_no->CurrentValue = NULL;
		$this->loom_no->OldValue = $this->loom_no->CurrentValue;
		$this->employee_1->CurrentValue = NULL;
		$this->employee_1->OldValue = $this->employee_1->CurrentValue;
		$this->employee_2->CurrentValue = 10000;
		$this->employee_3->CurrentValue = 10000;
		$this->employee_id->CurrentValue = NULL;
		$this->employee_id->OldValue = $this->employee_id->CurrentValue;
		$this->_barcode->CurrentValue = NULL;
		$this->_barcode->OldValue = $this->_barcode->CurrentValue;
		$this->r_date->CurrentValue = NULL;
		$this->r_date->OldValue = $this->r_date->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->deduction->CurrentValue = 0.00;
		$this->ded_remarks->CurrentValue = NULL;
		$this->ded_remarks->OldValue = $this->ded_remarks->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->updated->CurrentValue = 0;
		$this->_1->CurrentValue = NULL;
		$this->_1->OldValue = $this->_1->CurrentValue;
		$this->_2->CurrentValue = NULL;
		$this->_2->OldValue = $this->_2->CurrentValue;
		$this->_3->CurrentValue = NULL;
		$this->_3->OldValue = $this->_3->CurrentValue;
		$this->_4->CurrentValue = NULL;
		$this->_4->OldValue = $this->_4->CurrentValue;
		$this->_5->CurrentValue = NULL;
		$this->_5->OldValue = $this->_5->CurrentValue;
		$this->_6->CurrentValue = NULL;
		$this->_6->OldValue = $this->_6->CurrentValue;
		$this->_7->CurrentValue = NULL;
		$this->_7->OldValue = $this->_7->CurrentValue;
		$this->_8->CurrentValue = NULL;
		$this->_8->OldValue = $this->_8->CurrentValue;
		$this->other1->CurrentValue = NULL;
		$this->other1->OldValue = $this->other1->CurrentValue;
		$this->other2->CurrentValue = NULL;
		$this->other2->OldValue = $this->other2->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'no' first before field var 'x_no'
		$val = $CurrentForm->hasValue("no") ? $CurrentForm->getValue("no") : $CurrentForm->getValue("x_no");
		if (!$this->no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->no->Visible = FALSE; // Disable update for API request
			else
				$this->no->setFormValue($val);
		}

		// Check field name 'works' first before field var 'x_works'
		$val = $CurrentForm->hasValue("works") ? $CurrentForm->getValue("works") : $CurrentForm->getValue("x_works");
		if (!$this->works->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->works->Visible = FALSE; // Disable update for API request
			else
				$this->works->setFormValue($val);
		}

		// Check field name 'issue_to' first before field var 'x_issue_to'
		$val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
		if (!$this->issue_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_to->Visible = FALSE; // Disable update for API request
			else
				$this->issue_to->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'design_size' first before field var 'x_design_size'
		$val = $CurrentForm->hasValue("design_size") ? $CurrentForm->getValue("design_size") : $CurrentForm->getValue("x_design_size");
		if (!$this->design_size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->design_size->Visible = FALSE; // Disable update for API request
			else
				$this->design_size->setFormValue($val);
		}

		// Check field name 'size_wl' first before field var 'x_size_wl'
		$val = $CurrentForm->hasValue("size_wl") ? $CurrentForm->getValue("size_wl") : $CurrentForm->getValue("x_size_wl");
		if (!$this->size_wl->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size_wl->Visible = FALSE; // Disable update for API request
			else
				$this->size_wl->setFormValue($val);
		}

		// Check field name 'loom_no' first before field var 'x_loom_no'
		$val = $CurrentForm->hasValue("loom_no") ? $CurrentForm->getValue("loom_no") : $CurrentForm->getValue("x_loom_no");
		if (!$this->loom_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->loom_no->Visible = FALSE; // Disable update for API request
			else
				$this->loom_no->setFormValue($val);
		}

		// Check field name 'employee_1' first before field var 'x_employee_1'
		$val = $CurrentForm->hasValue("employee_1") ? $CurrentForm->getValue("employee_1") : $CurrentForm->getValue("x_employee_1");
		if (!$this->employee_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_1->Visible = FALSE; // Disable update for API request
			else
				$this->employee_1->setFormValue($val);
		}

		// Check field name 'employee_2' first before field var 'x_employee_2'
		$val = $CurrentForm->hasValue("employee_2") ? $CurrentForm->getValue("employee_2") : $CurrentForm->getValue("x_employee_2");
		if (!$this->employee_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_2->Visible = FALSE; // Disable update for API request
			else
				$this->employee_2->setFormValue($val);
		}

		// Check field name 'employee_3' first before field var 'x_employee_3'
		$val = $CurrentForm->hasValue("employee_3") ? $CurrentForm->getValue("employee_3") : $CurrentForm->getValue("x_employee_3");
		if (!$this->employee_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_3->Visible = FALSE; // Disable update for API request
			else
				$this->employee_3->setFormValue($val);
		}

		// Check field name 'barcode' first before field var 'x__barcode'
		$val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
		if (!$this->_barcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_barcode->Visible = FALSE; // Disable update for API request
			else
				$this->_barcode->setFormValue($val);
		}

		// Check field name 'r_date' first before field var 'x_r_date'
		$val = $CurrentForm->hasValue("r_date") ? $CurrentForm->getValue("r_date") : $CurrentForm->getValue("x_r_date");
		if (!$this->r_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->r_date->Visible = FALSE; // Disable update for API request
			else
				$this->r_date->setFormValue($val);
			$this->r_date->CurrentValue = UnFormatDateTime($this->r_date->CurrentValue, 0);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'deduction' first before field var 'x_deduction'
		$val = $CurrentForm->hasValue("deduction") ? $CurrentForm->getValue("deduction") : $CurrentForm->getValue("x_deduction");
		if (!$this->deduction->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->deduction->Visible = FALSE; // Disable update for API request
			else
				$this->deduction->setFormValue($val);
		}

		// Check field name 'ded_remarks' first before field var 'x_ded_remarks'
		$val = $CurrentForm->hasValue("ded_remarks") ? $CurrentForm->getValue("ded_remarks") : $CurrentForm->getValue("x_ded_remarks");
		if (!$this->ded_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ded_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->ded_remarks->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		}

		// Check field name '1' first before field var 'x__1'
		$val = $CurrentForm->hasValue("1") ? $CurrentForm->getValue("1") : $CurrentForm->getValue("x__1");
		if (!$this->_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_1->Visible = FALSE; // Disable update for API request
			else
				$this->_1->setFormValue($val);
		}

		// Check field name '2' first before field var 'x__2'
		$val = $CurrentForm->hasValue("2") ? $CurrentForm->getValue("2") : $CurrentForm->getValue("x__2");
		if (!$this->_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_2->Visible = FALSE; // Disable update for API request
			else
				$this->_2->setFormValue($val);
		}

		// Check field name '3' first before field var 'x__3'
		$val = $CurrentForm->hasValue("3") ? $CurrentForm->getValue("3") : $CurrentForm->getValue("x__3");
		if (!$this->_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_3->Visible = FALSE; // Disable update for API request
			else
				$this->_3->setFormValue($val);
		}

		// Check field name '4' first before field var 'x__4'
		$val = $CurrentForm->hasValue("4") ? $CurrentForm->getValue("4") : $CurrentForm->getValue("x__4");
		if (!$this->_4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_4->Visible = FALSE; // Disable update for API request
			else
				$this->_4->setFormValue($val);
		}

		// Check field name '5' first before field var 'x__5'
		$val = $CurrentForm->hasValue("5") ? $CurrentForm->getValue("5") : $CurrentForm->getValue("x__5");
		if (!$this->_5->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_5->Visible = FALSE; // Disable update for API request
			else
				$this->_5->setFormValue($val);
		}

		// Check field name '6' first before field var 'x__6'
		$val = $CurrentForm->hasValue("6") ? $CurrentForm->getValue("6") : $CurrentForm->getValue("x__6");
		if (!$this->_6->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_6->Visible = FALSE; // Disable update for API request
			else
				$this->_6->setFormValue($val);
		}

		// Check field name '7' first before field var 'x__7'
		$val = $CurrentForm->hasValue("7") ? $CurrentForm->getValue("7") : $CurrentForm->getValue("x__7");
		if (!$this->_7->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_7->Visible = FALSE; // Disable update for API request
			else
				$this->_7->setFormValue($val);
		}

		// Check field name '8' first before field var 'x__8'
		$val = $CurrentForm->hasValue("8") ? $CurrentForm->getValue("8") : $CurrentForm->getValue("x__8");
		if (!$this->_8->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_8->Visible = FALSE; // Disable update for API request
			else
				$this->_8->setFormValue($val);
		}

		// Check field name 'other1' first before field var 'x_other1'
		$val = $CurrentForm->hasValue("other1") ? $CurrentForm->getValue("other1") : $CurrentForm->getValue("x_other1");
		if (!$this->other1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other1->Visible = FALSE; // Disable update for API request
			else
				$this->other1->setFormValue($val);
		}

		// Check field name 'other2' first before field var 'x_other2'
		$val = $CurrentForm->hasValue("other2") ? $CurrentForm->getValue("other2") : $CurrentForm->getValue("x_other2");
		if (!$this->other2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other2->Visible = FALSE; // Disable update for API request
			else
				$this->other2->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->no->CurrentValue = $this->no->FormValue;
		$this->works->CurrentValue = $this->works->FormValue;
		$this->issue_to->CurrentValue = $this->issue_to->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->design_size->CurrentValue = $this->design_size->FormValue;
		$this->size_wl->CurrentValue = $this->size_wl->FormValue;
		$this->loom_no->CurrentValue = $this->loom_no->FormValue;
		$this->employee_1->CurrentValue = $this->employee_1->FormValue;
		$this->employee_2->CurrentValue = $this->employee_2->FormValue;
		$this->employee_3->CurrentValue = $this->employee_3->FormValue;
		$this->_barcode->CurrentValue = $this->_barcode->FormValue;
		$this->r_date->CurrentValue = $this->r_date->FormValue;
		$this->r_date->CurrentValue = UnFormatDateTime($this->r_date->CurrentValue, 0);
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->deduction->CurrentValue = $this->deduction->FormValue;
		$this->ded_remarks->CurrentValue = $this->ded_remarks->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		$this->_1->CurrentValue = $this->_1->FormValue;
		$this->_2->CurrentValue = $this->_2->FormValue;
		$this->_3->CurrentValue = $this->_3->FormValue;
		$this->_4->CurrentValue = $this->_4->FormValue;
		$this->_5->CurrentValue = $this->_5->FormValue;
		$this->_6->CurrentValue = $this->_6->FormValue;
		$this->_7->CurrentValue = $this->_7->FormValue;
		$this->_8->CurrentValue = $this->_8->FormValue;
		$this->other1->CurrentValue = $this->other1->FormValue;
		$this->other2->CurrentValue = $this->other2->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->no->setDbValue($row['no']);
		$this->works->setDbValue($row['works']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->po->setDbValue($row['po']);
		$this->design_size_1->setDbValue($row['design_size_1']);
		$this->design_size->setDbValue($row['design_size']);
		$this->size_wl->setDbValue($row['size_wl']);
		$this->loom_no->setDbValue($row['loom_no']);
		$this->employee_1->setDbValue($row['employee_1']);
		if (array_key_exists('EV__employee_1', $rs->fields)) {
			$this->employee_1->VirtualValue = $rs->fields('EV__employee_1'); // Set up virtual field value
		} else {
			$this->employee_1->VirtualValue = ""; // Clear value
		}
		$this->employee_2->setDbValue($row['employee_2']);
		if (array_key_exists('EV__employee_2', $rs->fields)) {
			$this->employee_2->VirtualValue = $rs->fields('EV__employee_2'); // Set up virtual field value
		} else {
			$this->employee_2->VirtualValue = ""; // Clear value
		}
		$this->employee_3->setDbValue($row['employee_3']);
		$this->employee_id->setDbValue($row['employee_id']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->r_date->setDbValue($row['r_date']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->deduction->setDbValue($row['deduction']);
		$this->ded_remarks->setDbValue($row['ded_remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->updated->setDbValue($row['updated']);
		$this->_1->setDbValue($row['1']);
		$this->_2->setDbValue($row['2']);
		$this->_3->setDbValue($row['3']);
		$this->_4->setDbValue($row['4']);
		$this->_5->setDbValue($row['5']);
		$this->_6->setDbValue($row['6']);
		$this->_7->setDbValue($row['7']);
		$this->_8->setDbValue($row['8']);
		$this->other1->setDbValue($row['other1']);
		$this->other2->setDbValue($row['other2']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['no'] = $this->no->CurrentValue;
		$row['works'] = $this->works->CurrentValue;
		$row['issue_to'] = $this->issue_to->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['po'] = $this->po->CurrentValue;
		$row['design_size_1'] = $this->design_size_1->CurrentValue;
		$row['design_size'] = $this->design_size->CurrentValue;
		$row['size_wl'] = $this->size_wl->CurrentValue;
		$row['loom_no'] = $this->loom_no->CurrentValue;
		$row['employee_1'] = $this->employee_1->CurrentValue;
		$row['employee_2'] = $this->employee_2->CurrentValue;
		$row['employee_3'] = $this->employee_3->CurrentValue;
		$row['employee_id'] = $this->employee_id->CurrentValue;
		$row['barcode'] = $this->_barcode->CurrentValue;
		$row['r_date'] = $this->r_date->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['deduction'] = $this->deduction->CurrentValue;
		$row['ded_remarks'] = $this->ded_remarks->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['updated'] = $this->updated->CurrentValue;
		$row['1'] = $this->_1->CurrentValue;
		$row['2'] = $this->_2->CurrentValue;
		$row['3'] = $this->_3->CurrentValue;
		$row['4'] = $this->_4->CurrentValue;
		$row['5'] = $this->_5->CurrentValue;
		$row['6'] = $this->_6->CurrentValue;
		$row['7'] = $this->_7->CurrentValue;
		$row['8'] = $this->_8->CurrentValue;
		$row['other1'] = $this->other1->CurrentValue;
		$row['other2'] = $this->other2->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->deduction->FormValue == $this->deduction->CurrentValue && is_numeric(ConvertToFloatString($this->deduction->CurrentValue)))
			$this->deduction->CurrentValue = ConvertToFloatString($this->deduction->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// no
		// works
		// issue_to
		// grp
		// s_grp
		// po
		// design_size_1
		// design_size
		// size_wl
		// loom_no
		// employee_1
		// employee_2
		// employee_3
		// employee_id
		// barcode
		// r_date
		// lot_no
		// deduction
		// ded_remarks
		// operator
		// datetime
		// updated
		// 1
		// 2
		// 3
		// 4
		// 5
		// 6
		// 7
		// 8
		// other1
		// other2

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// no
			$this->no->ViewValue = $this->no->CurrentValue;
			$this->no->ViewValue = FormatNumber($this->no->ViewValue, 0, -2, -2, -2);
			$this->no->ViewCustomAttributes = "";

			// works
			$curVal = strval($this->works->CurrentValue);
			if ($curVal <> "") {
				$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
				if ($this->works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return User_Site() == 0 ?  "`status`=1 and `id` > 0 && `id` != 10" : "`status`=1 and `id` > 0 && `id` != 10 and FIND_IN_SET(id, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->works->ViewValue = $this->works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->works->ViewValue = $this->works->CurrentValue;
					}
				}
			} else {
				$this->works->ViewValue = NULL;
			}
			$this->works->ViewCustomAttributes = "";

			// issue_to
			$curVal = strval($this->issue_to->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
				if ($this->issue_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
					}
				}
			} else {
				$this->issue_to->ViewValue = NULL;
			}
			$this->issue_to->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// po
			$curVal = strval($this->po->CurrentValue);
			if ($curVal <> "") {
				$this->po->ViewValue = $this->po->lookupCacheOption($curVal);
				if ($this->po->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`po`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`loom_week` != 0 and `loom_week` <= (" . CWeekID() . " + `extra_loom_week`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->po->ViewValue = $this->po->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po->ViewValue = $this->po->CurrentValue;
					}
				}
			} else {
				$this->po->ViewValue = NULL;
			}
			$this->po->ViewCustomAttributes = "";

			// design_size_1
			$this->design_size_1->ViewValue = $this->design_size_1->CurrentValue;
			$this->design_size_1->ViewCustomAttributes = "";

			// design_size
			$curVal = strval($this->design_size->CurrentValue);
			if ($curVal <> "") {
				$this->design_size->ViewValue = $this->design_size->lookupCacheOption($curVal);
				if ($this->design_size->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`design_size`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`loom_week` != 0 and `loom_week` <= (" . CWeekID() . " + `extra_loom_week`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_size->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_size->ViewValue = $this->design_size->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_size->ViewValue = $this->design_size->CurrentValue;
					}
				}
			} else {
				$this->design_size->ViewValue = NULL;
			}
			$this->design_size->ViewCustomAttributes = "";

			// size_wl
			$this->size_wl->ViewValue = $this->size_wl->CurrentValue;
			$this->size_wl->ViewCustomAttributes = "";

			// loom_no
			$curVal = strval($this->loom_no->CurrentValue);
			if ($curVal <> "") {
				$this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
				if ($this->loom_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`=0 || `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->loom_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
						$this->loom_no->ViewValue = $this->loom_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->loom_no->ViewValue = $this->loom_no->CurrentValue;
					}
				}
			} else {
				$this->loom_no->ViewValue = NULL;
			}
			$this->loom_no->ViewCustomAttributes = "";

			// employee_1
			if ($this->employee_1->VirtualValue <> "") {
				$this->employee_1->ViewValue = $this->employee_1->VirtualValue;
			} else {
				$this->employee_1->ViewValue = $this->employee_1->CurrentValue;
			$curVal = strval($this->employee_1->CurrentValue);
			if ($curVal <> "") {
				$this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
				if ($this->employee_1->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_1->ViewValue = $this->employee_1->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_1->ViewValue = $this->employee_1->CurrentValue;
					}
				}
			} else {
				$this->employee_1->ViewValue = NULL;
			}
			}
			$this->employee_1->ViewCustomAttributes = "";

			// employee_2
			if ($this->employee_2->VirtualValue <> "") {
				$this->employee_2->ViewValue = $this->employee_2->VirtualValue;
			} else {
				$this->employee_2->ViewValue = $this->employee_2->CurrentValue;
			$curVal = strval($this->employee_2->CurrentValue);
			if ($curVal <> "") {
				$this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
				if ($this->employee_2->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_2->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_2->ViewValue = $this->employee_2->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_2->ViewValue = $this->employee_2->CurrentValue;
					}
				}
			} else {
				$this->employee_2->ViewValue = NULL;
			}
			}
			$this->employee_2->ViewCustomAttributes = "";

			// employee_3
			$this->employee_3->ViewValue = $this->employee_3->CurrentValue;
			$curVal = strval($this->employee_3->CurrentValue);
			if ($curVal <> "") {
				$this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
				if ($this->employee_3->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_3->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_3->ViewValue = $this->employee_3->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_3->ViewValue = $this->employee_3->CurrentValue;
					}
				}
			} else {
				$this->employee_3->ViewValue = NULL;
			}
			$this->employee_3->ViewCustomAttributes = "";

			// employee_id
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->employee_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			$this->employee_id->ViewCustomAttributes = "";

			// barcode
			$curVal = strval($this->_barcode->CurrentValue);
			if ($curVal <> "") {
				$this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
				if ($this->_barcode->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`barcode`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->_barcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->_barcode->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
					}
				}
			} else {
				$this->_barcode->ViewValue = NULL;
			}
			$this->_barcode->ViewCustomAttributes = "";

			// r_date
			$this->r_date->ViewValue = $this->r_date->CurrentValue;
			$this->r_date->ViewValue = FormatDateTime($this->r_date->ViewValue, 0);
			$this->r_date->ViewCustomAttributes = "";

			// lot_no
			$curVal = strval($this->lot_no->CurrentValue);
			if ($curVal <> "") {
				$this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
				if ($this->lot_no->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_MEMO, "");
					}
					$sqlWrk = $this->lot_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->lot_no->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = $rswrk->fields('df3');
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->lot_no->ViewValue->add($this->lot_no->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
					}
				}
			} else {
				$this->lot_no->ViewValue = NULL;
			}
			$this->lot_no->ViewCustomAttributes = "";

			// deduction
			$this->deduction->ViewValue = $this->deduction->CurrentValue;
			$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 2, -2, -2, -2);
			$this->deduction->ViewCustomAttributes = "";

			// ded_remarks
			$this->ded_remarks->ViewValue = $this->ded_remarks->CurrentValue;
			$this->ded_remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// 1
			$this->_1->ViewValue = $this->_1->CurrentValue;
			$this->_1->ViewCustomAttributes = "";

			// 2
			$this->_2->ViewValue = $this->_2->CurrentValue;
			$this->_2->ViewCustomAttributes = "";

			// 3
			$this->_3->ViewValue = $this->_3->CurrentValue;
			$this->_3->ViewCustomAttributes = "";

			// 4
			$this->_4->ViewValue = $this->_4->CurrentValue;
			$this->_4->ViewCustomAttributes = "";

			// 5
			$this->_5->ViewValue = $this->_5->CurrentValue;
			$this->_5->ViewCustomAttributes = "";

			// 6
			$this->_6->ViewValue = $this->_6->CurrentValue;
			$this->_6->ViewCustomAttributes = "";

			// 7
			$this->_7->ViewValue = $this->_7->CurrentValue;
			$this->_7->ViewCustomAttributes = "";

			// 8
			$this->_8->ViewValue = $this->_8->CurrentValue;
			$this->_8->ViewCustomAttributes = "";

			// other1
			$this->other1->ViewValue = $this->other1->CurrentValue;
			$this->other1->ViewCustomAttributes = "";

			// other2
			$this->other2->ViewValue = $this->other2->CurrentValue;
			$this->other2->ViewCustomAttributes = "";

			// no
			$this->no->LinkCustomAttributes = "";
			if (!EmptyValue($this->no->CurrentValue)) {
				$this->no->HrefValue = "bcodelist.php?x_jc_no=" . $this->no->CurrentValue; // Add prefix/suffix
				$this->no->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->no->HrefValue = FullUrl($this->no->HrefValue, "href");
			} else {
				$this->no->HrefValue = "";
			}
			$this->no->TooltipValue = "";

			// works
			$this->works->LinkCustomAttributes = "";
			$this->works->HrefValue = "";
			$this->works->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";
			$this->issue_to->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design_size
			$this->design_size->LinkCustomAttributes = "";
			$this->design_size->HrefValue = "";
			$this->design_size->TooltipValue = "";

			// size_wl
			$this->size_wl->LinkCustomAttributes = "";
			$this->size_wl->HrefValue = "";
			$this->size_wl->TooltipValue = "";

			// loom_no
			$this->loom_no->LinkCustomAttributes = "";
			$this->loom_no->HrefValue = "";
			$this->loom_no->TooltipValue = "";

			// employee_1
			$this->employee_1->LinkCustomAttributes = "";
			$this->employee_1->HrefValue = "";
			$this->employee_1->TooltipValue = "";

			// employee_2
			$this->employee_2->LinkCustomAttributes = "";
			$this->employee_2->HrefValue = "";
			$this->employee_2->TooltipValue = "";

			// employee_3
			$this->employee_3->LinkCustomAttributes = "";
			$this->employee_3->HrefValue = "";
			$this->employee_3->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// r_date
			$this->r_date->LinkCustomAttributes = "";
			$this->r_date->HrefValue = "";
			$this->r_date->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";
			$this->deduction->TooltipValue = "";

			// ded_remarks
			$this->ded_remarks->LinkCustomAttributes = "";
			$this->ded_remarks->HrefValue = "";
			$this->ded_remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";
			$this->_1->TooltipValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";
			$this->_2->TooltipValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";
			$this->_3->TooltipValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";
			$this->_4->TooltipValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";
			$this->_5->TooltipValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";
			$this->_6->TooltipValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";
			$this->_7->TooltipValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";
			$this->_8->TooltipValue = "";

			// other1
			$this->other1->LinkCustomAttributes = "";
			$this->other1->HrefValue = "";
			$this->other1->TooltipValue = "";

			// other2
			$this->other2->LinkCustomAttributes = "";
			$this->other2->HrefValue = "";
			$this->other2->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// no
			$this->no->EditAttrs["class"] = "form-control";
			$this->no->EditCustomAttributes = "";
			$this->no->EditValue = HtmlEncode($this->no->CurrentValue);
			$this->no->PlaceHolder = RemoveHtml($this->no->caption());

			// works
			$this->works->EditAttrs["class"] = "form-control";
			$this->works->EditCustomAttributes = "";
			$curVal = trim(strval($this->works->CurrentValue));
			if ($curVal <> "")
				$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
			else
				$this->works->ViewValue = $this->works->Lookup !== NULL && is_array($this->works->Lookup->Options) ? $curVal : NULL;
			if ($this->works->ViewValue !== NULL) { // Load from cache
				$this->works->EditValue = array_values($this->works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->works->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return User_Site() == 0 ?  "`status`=1 and `id` > 0 && `id` != 10" : "`status`=1 and `id` > 0 && `id` != 10 and FIND_IN_SET(id, " . User_Site() . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->works->EditValue = $arwrk;
			}

			// issue_to
			$this->issue_to->EditAttrs["class"] = "form-control";
			$this->issue_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_to->CurrentValue));
			if ($curVal <> "")
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			else
				$this->issue_to->ViewValue = $this->issue_to->Lookup !== NULL && is_array($this->issue_to->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_to->ViewValue !== NULL) { // Load from cache
				$this->issue_to->EditValue = array_values($this->issue_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`=999";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_to->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$curVal = trim(strval($this->po->CurrentValue));
			if ($curVal <> "")
				$this->po->ViewValue = $this->po->lookupCacheOption($curVal);
			else
				$this->po->ViewValue = $this->po->Lookup !== NULL && is_array($this->po->Lookup->Options) ? $curVal : NULL;
			if ($this->po->ViewValue !== NULL) { // Load from cache
				$this->po->EditValue = array_values($this->po->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`po`" . SearchString("=", $this->po->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`loom_week` != 0 and `loom_week` <= (" . CWeekID() . " + `extra_loom_week`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->po->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->po->EditValue = $arwrk;
			}

			// design_size
			$this->design_size->EditAttrs["class"] = "form-control";
			$this->design_size->EditCustomAttributes = "";
			$curVal = trim(strval($this->design_size->CurrentValue));
			if ($curVal <> "")
				$this->design_size->ViewValue = $this->design_size->lookupCacheOption($curVal);
			else
				$this->design_size->ViewValue = $this->design_size->Lookup !== NULL && is_array($this->design_size->Lookup->Options) ? $curVal : NULL;
			if ($this->design_size->ViewValue !== NULL) { // Load from cache
				$this->design_size->EditValue = array_values($this->design_size->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`design_size`" . SearchString("=", $this->design_size->CurrentValue, DATATYPE_MEMO, "");
				}
				$lookupFilter = function() {
					return "`loom_week` != 0 and `loom_week` <= (" . CWeekID() . " + `extra_loom_week`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_size->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->design_size->EditValue = $arwrk;
			}

			// size_wl
			$this->size_wl->EditAttrs["class"] = "form-control";
			$this->size_wl->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->size_wl->CurrentValue = HtmlDecode($this->size_wl->CurrentValue);
			$this->size_wl->EditValue = HtmlEncode($this->size_wl->CurrentValue);
			$this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

			// loom_no
			$this->loom_no->EditAttrs["class"] = "form-control";
			$this->loom_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->loom_no->CurrentValue));
			if ($curVal <> "")
				$this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
			else
				$this->loom_no->ViewValue = $this->loom_no->Lookup !== NULL && is_array($this->loom_no->Lookup->Options) ? $curVal : NULL;
			if ($this->loom_no->ViewValue !== NULL) { // Load from cache
				$this->loom_no->EditValue = array_values($this->loom_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->loom_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id`=0 || `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->loom_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 0, -2, -2, -2);
				}
				$this->loom_no->EditValue = $arwrk;
			}

			// employee_1
			$this->employee_1->EditAttrs["class"] = "form-control";
			$this->employee_1->EditCustomAttributes = "";
			$this->employee_1->EditValue = HtmlEncode($this->employee_1->CurrentValue);
			$curVal = strval($this->employee_1->CurrentValue);
			if ($curVal <> "") {
				$this->employee_1->EditValue = $this->employee_1->lookupCacheOption($curVal);
				if ($this->employee_1->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->employee_1->EditValue = $this->employee_1->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_1->EditValue = HtmlEncode($this->employee_1->CurrentValue);
					}
				}
			} else {
				$this->employee_1->EditValue = NULL;
			}
			$this->employee_1->PlaceHolder = RemoveHtml($this->employee_1->caption());

			// employee_2
			$this->employee_2->EditAttrs["class"] = "form-control";
			$this->employee_2->EditCustomAttributes = "";
			$this->employee_2->EditValue = HtmlEncode($this->employee_2->CurrentValue);
			$curVal = strval($this->employee_2->CurrentValue);
			if ($curVal <> "") {
				$this->employee_2->EditValue = $this->employee_2->lookupCacheOption($curVal);
				if ($this->employee_2->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_2->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->employee_2->EditValue = $this->employee_2->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_2->EditValue = HtmlEncode($this->employee_2->CurrentValue);
					}
				}
			} else {
				$this->employee_2->EditValue = NULL;
			}
			$this->employee_2->PlaceHolder = RemoveHtml($this->employee_2->caption());

			// employee_3
			$this->employee_3->EditAttrs["class"] = "form-control";
			$this->employee_3->EditCustomAttributes = "";
			$this->employee_3->EditValue = HtmlEncode($this->employee_3->CurrentValue);
			$curVal = strval($this->employee_3->CurrentValue);
			if ($curVal <> "") {
				$this->employee_3->EditValue = $this->employee_3->lookupCacheOption($curVal);
				if ($this->employee_3->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_3->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->employee_3->EditValue = $this->employee_3->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_3->EditValue = HtmlEncode($this->employee_3->CurrentValue);
					}
				}
			} else {
				$this->employee_3->EditValue = NULL;
			}
			$this->employee_3->PlaceHolder = RemoveHtml($this->employee_3->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$curVal = trim(strval($this->_barcode->CurrentValue));
			if ($curVal <> "")
				$this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
			else
				$this->_barcode->ViewValue = $this->_barcode->Lookup !== NULL && is_array($this->_barcode->Lookup->Options) ? $curVal : NULL;
			if ($this->_barcode->ViewValue !== NULL) { // Load from cache
				$this->_barcode->EditValue = array_values($this->_barcode->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`barcode`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->_barcode->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->_barcode->EditValue = $arwrk;
			}

			// r_date
			$this->r_date->EditAttrs["class"] = "form-control";
			$this->r_date->EditCustomAttributes = "";
			$this->r_date->EditValue = HtmlEncode(FormatDateTime($this->r_date->CurrentValue, 8));
			$this->r_date->PlaceHolder = RemoveHtml($this->r_date->caption());

			// lot_no
			$this->lot_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->lot_no->CurrentValue));
			if ($curVal <> "")
				$this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
			else
				$this->lot_no->ViewValue = $this->lot_no->Lookup !== NULL && is_array($this->lot_no->Lookup->Options) ? $curVal : NULL;
			if ($this->lot_no->ViewValue !== NULL) { // Load from cache
				$this->lot_no->EditValue = array_values($this->lot_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_MEMO, "");
					}
				}
				$sqlWrk = $this->lot_no->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->lot_no->EditValue = $arwrk;
			}

			// deduction
			$this->deduction->EditAttrs["class"] = "form-control";
			$this->deduction->EditCustomAttributes = "";
			$this->deduction->EditValue = HtmlEncode($this->deduction->CurrentValue);
			$this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
			if (strval($this->deduction->EditValue) <> "" && is_numeric($this->deduction->EditValue))
				$this->deduction->EditValue = FormatNumber($this->deduction->EditValue, -2, -2, -2, -2);

			// ded_remarks
			$this->ded_remarks->EditAttrs["class"] = "form-control";
			$this->ded_remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ded_remarks->CurrentValue = HtmlDecode($this->ded_remarks->CurrentValue);
			$this->ded_remarks->EditValue = HtmlEncode($this->ded_remarks->CurrentValue);
			$this->ded_remarks->PlaceHolder = RemoveHtml($this->ded_remarks->caption());

			// operator
			// datetime
			// 1

			$this->_1->EditAttrs["class"] = "form-control";
			$this->_1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
			$this->_1->EditValue = HtmlEncode($this->_1->CurrentValue);
			$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

			// 2
			$this->_2->EditAttrs["class"] = "form-control";
			$this->_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
			$this->_2->EditValue = HtmlEncode($this->_2->CurrentValue);
			$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

			// 3
			$this->_3->EditAttrs["class"] = "form-control";
			$this->_3->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
			$this->_3->EditValue = HtmlEncode($this->_3->CurrentValue);
			$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

			// 4
			$this->_4->EditAttrs["class"] = "form-control";
			$this->_4->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
			$this->_4->EditValue = HtmlEncode($this->_4->CurrentValue);
			$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

			// 5
			$this->_5->EditAttrs["class"] = "form-control";
			$this->_5->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
			$this->_5->EditValue = HtmlEncode($this->_5->CurrentValue);
			$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

			// 6
			$this->_6->EditAttrs["class"] = "form-control";
			$this->_6->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
			$this->_6->EditValue = HtmlEncode($this->_6->CurrentValue);
			$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

			// 7
			$this->_7->EditAttrs["class"] = "form-control";
			$this->_7->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
			$this->_7->EditValue = HtmlEncode($this->_7->CurrentValue);
			$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

			// 8
			$this->_8->EditAttrs["class"] = "form-control";
			$this->_8->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
			$this->_8->EditValue = HtmlEncode($this->_8->CurrentValue);
			$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

			// other1
			$this->other1->EditAttrs["class"] = "form-control";
			$this->other1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other1->CurrentValue = HtmlDecode($this->other1->CurrentValue);
			$this->other1->EditValue = HtmlEncode($this->other1->CurrentValue);
			$this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

			// other2
			$this->other2->EditAttrs["class"] = "form-control";
			$this->other2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other2->CurrentValue = HtmlDecode($this->other2->CurrentValue);
			$this->other2->EditValue = HtmlEncode($this->other2->CurrentValue);
			$this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

			// Add refer script
			// no

			$this->no->LinkCustomAttributes = "";
			if (!EmptyValue($this->no->CurrentValue)) {
				$this->no->HrefValue = "bcodelist.php?x_jc_no=" . $this->no->CurrentValue; // Add prefix/suffix
				$this->no->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->no->HrefValue = FullUrl($this->no->HrefValue, "href");
			} else {
				$this->no->HrefValue = "";
			}

			// works
			$this->works->LinkCustomAttributes = "";
			$this->works->HrefValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";

			// design_size
			$this->design_size->LinkCustomAttributes = "";
			$this->design_size->HrefValue = "";

			// size_wl
			$this->size_wl->LinkCustomAttributes = "";
			$this->size_wl->HrefValue = "";

			// loom_no
			$this->loom_no->LinkCustomAttributes = "";
			$this->loom_no->HrefValue = "";

			// employee_1
			$this->employee_1->LinkCustomAttributes = "";
			$this->employee_1->HrefValue = "";

			// employee_2
			$this->employee_2->LinkCustomAttributes = "";
			$this->employee_2->HrefValue = "";

			// employee_3
			$this->employee_3->LinkCustomAttributes = "";
			$this->employee_3->HrefValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";

			// r_date
			$this->r_date->LinkCustomAttributes = "";
			$this->r_date->HrefValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";

			// ded_remarks
			$this->ded_remarks->LinkCustomAttributes = "";
			$this->ded_remarks->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";

			// other1
			$this->other1->LinkCustomAttributes = "";
			$this->other1->HrefValue = "";

			// other2
			$this->other2->LinkCustomAttributes = "";
			$this->other2->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->no->Required) {
			if (!$this->no->IsDetailKey && $this->no->FormValue != NULL && $this->no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->no->caption(), $this->no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->no->FormValue)) {
			AddMessage($FormError, $this->no->errorMessage());
		}
		if ($this->works->Required) {
			if (!$this->works->IsDetailKey && $this->works->FormValue != NULL && $this->works->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->works->caption(), $this->works->RequiredErrorMessage));
			}
		}
		if ($this->issue_to->Required) {
			if (!$this->issue_to->IsDetailKey && $this->issue_to->FormValue != NULL && $this->issue_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->design_size_1->Required) {
			if (!$this->design_size_1->IsDetailKey && $this->design_size_1->FormValue != NULL && $this->design_size_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design_size_1->caption(), $this->design_size_1->RequiredErrorMessage));
			}
		}
		if ($this->design_size->Required) {
			if (!$this->design_size->IsDetailKey && $this->design_size->FormValue != NULL && $this->design_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design_size->caption(), $this->design_size->RequiredErrorMessage));
			}
		}
		if ($this->size_wl->Required) {
			if (!$this->size_wl->IsDetailKey && $this->size_wl->FormValue != NULL && $this->size_wl->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size_wl->caption(), $this->size_wl->RequiredErrorMessage));
			}
		}
		if ($this->loom_no->Required) {
			if (!$this->loom_no->IsDetailKey && $this->loom_no->FormValue != NULL && $this->loom_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->loom_no->caption(), $this->loom_no->RequiredErrorMessage));
			}
		}
		if ($this->employee_1->Required) {
			if (!$this->employee_1->IsDetailKey && $this->employee_1->FormValue != NULL && $this->employee_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_1->caption(), $this->employee_1->RequiredErrorMessage));
			}
		}
		if ($this->employee_2->Required) {
			if (!$this->employee_2->IsDetailKey && $this->employee_2->FormValue != NULL && $this->employee_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_2->caption(), $this->employee_2->RequiredErrorMessage));
			}
		}
		if ($this->employee_3->Required) {
			if (!$this->employee_3->IsDetailKey && $this->employee_3->FormValue != NULL && $this->employee_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_3->caption(), $this->employee_3->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->employee_3->FormValue)) {
			AddMessage($FormError, $this->employee_3->errorMessage());
		}
		if ($this->employee_id->Required) {
			if ($this->employee_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if ($this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->r_date->Required) {
			if (!$this->r_date->IsDetailKey && $this->r_date->FormValue != NULL && $this->r_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_date->caption(), $this->r_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->r_date->FormValue)) {
			AddMessage($FormError, $this->r_date->errorMessage());
		}
		if ($this->lot_no->Required) {
			if ($this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->deduction->Required) {
			if (!$this->deduction->IsDetailKey && $this->deduction->FormValue != NULL && $this->deduction->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->deduction->caption(), $this->deduction->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->deduction->FormValue)) {
			AddMessage($FormError, $this->deduction->errorMessage());
		}
		if ($this->ded_remarks->Required) {
			if (!$this->ded_remarks->IsDetailKey && $this->ded_remarks->FormValue != NULL && $this->ded_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ded_remarks->caption(), $this->ded_remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if ($this->_1->Required) {
			if (!$this->_1->IsDetailKey && $this->_1->FormValue != NULL && $this->_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
			}
		}
		if ($this->_2->Required) {
			if (!$this->_2->IsDetailKey && $this->_2->FormValue != NULL && $this->_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
			}
		}
		if ($this->_3->Required) {
			if (!$this->_3->IsDetailKey && $this->_3->FormValue != NULL && $this->_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
			}
		}
		if ($this->_4->Required) {
			if (!$this->_4->IsDetailKey && $this->_4->FormValue != NULL && $this->_4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
			}
		}
		if ($this->_5->Required) {
			if (!$this->_5->IsDetailKey && $this->_5->FormValue != NULL && $this->_5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
			}
		}
		if ($this->_6->Required) {
			if (!$this->_6->IsDetailKey && $this->_6->FormValue != NULL && $this->_6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
			}
		}
		if ($this->_7->Required) {
			if (!$this->_7->IsDetailKey && $this->_7->FormValue != NULL && $this->_7->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
			}
		}
		if ($this->_8->Required) {
			if (!$this->_8->IsDetailKey && $this->_8->FormValue != NULL && $this->_8->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
			}
		}
		if ($this->other1->Required) {
			if (!$this->other1->IsDetailKey && $this->other1->FormValue != NULL && $this->other1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other1->caption(), $this->other1->RequiredErrorMessage));
			}
		}
		if ($this->other2->Required) {
			if (!$this->other2->IsDetailKey && $this->other2->FormValue != NULL && $this->other2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other2->caption(), $this->other2->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->_barcode->CurrentValue <> "") { // Check field with unique index
			$filter = "(barcode = '" . AdjustSql($this->_barcode->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->_barcode->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->_barcode->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// no
		$this->no->setDbValueDef($rsnew, $this->no->CurrentValue, NULL, strval($this->no->CurrentValue) == "");

		// works
		$this->works->setDbValueDef($rsnew, $this->works->CurrentValue, NULL, FALSE);

		// issue_to
		$this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, NULL, strval($this->issue_to->CurrentValue) == "");

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, FALSE);

		// po
		$this->po->setDbValueDef($rsnew, $this->po->CurrentValue, "", FALSE);

		// design_size
		$this->design_size->setDbValueDef($rsnew, $this->design_size->CurrentValue, NULL, FALSE);

		// size_wl
		$this->size_wl->setDbValueDef($rsnew, $this->size_wl->CurrentValue, "", FALSE);

		// loom_no
		$this->loom_no->setDbValueDef($rsnew, $this->loom_no->CurrentValue, NULL, FALSE);

		// employee_1
		$this->employee_1->setDbValueDef($rsnew, $this->employee_1->CurrentValue, NULL, FALSE);

		// employee_2
		$this->employee_2->setDbValueDef($rsnew, $this->employee_2->CurrentValue, NULL, FALSE);

		// employee_3
		$this->employee_3->setDbValueDef($rsnew, $this->employee_3->CurrentValue, NULL, FALSE);

		// barcode
		$this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, NULL, FALSE);

		// r_date
		$this->r_date->setDbValueDef($rsnew, UnFormatDateTime($this->r_date->CurrentValue, 0), NULL, FALSE);

		// lot_no
		$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, NULL, FALSE);

		// deduction
		$this->deduction->setDbValueDef($rsnew, $this->deduction->CurrentValue, 0, strval($this->deduction->CurrentValue) == "");

		// ded_remarks
		$this->ded_remarks->setDbValueDef($rsnew, $this->ded_remarks->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// 1
		$this->_1->setDbValueDef($rsnew, $this->_1->CurrentValue, NULL, FALSE);

		// 2
		$this->_2->setDbValueDef($rsnew, $this->_2->CurrentValue, NULL, FALSE);

		// 3
		$this->_3->setDbValueDef($rsnew, $this->_3->CurrentValue, NULL, FALSE);

		// 4
		$this->_4->setDbValueDef($rsnew, $this->_4->CurrentValue, NULL, FALSE);

		// 5
		$this->_5->setDbValueDef($rsnew, $this->_5->CurrentValue, NULL, FALSE);

		// 6
		$this->_6->setDbValueDef($rsnew, $this->_6->CurrentValue, NULL, FALSE);

		// 7
		$this->_7->setDbValueDef($rsnew, $this->_7->CurrentValue, NULL, FALSE);

		// 8
		$this->_8->setDbValueDef($rsnew, $this->_8->CurrentValue, NULL, FALSE);

		// other1
		$this->other1->setDbValueDef($rsnew, $this->other1->CurrentValue, NULL, FALSE);

		// other2
		$this->other2->setDbValueDef($rsnew, $this->other2->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("job_card_bclist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_works":
					$lookupFilter = function() {
						return User_Site() == 0 ?  "`status`=1 and `id` > 0 && `id` != 10" : "`status`=1 and `id` > 0 && `id` != 10 and FIND_IN_SET(id, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to":
					$lookupFilter = function() {
						return "`category`=999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_po":
					$lookupFilter = function() {
						return "`loom_week` != 0 and `loom_week` <= (" . CWeekID() . " + `extra_loom_week`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_design_size":
					$lookupFilter = function() {
						return "`loom_week` != 0 and `loom_week` <= (" . CWeekID() . " + `extra_loom_week`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_loom_no":
					$lookupFilter = function() {
						return "`id`=0 || `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_1":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_2":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_3":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "FIND_IN_SET(`process`, '27,28,29,16,17,39')" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_works":
							break;
						case "x_issue_to":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_po":
							break;
						case "x_design_size":
							break;
						case "x_loom_no":
							$row[4] = FormatNumber($row[4], 0, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_employee_1":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_2":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_3":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x__barcode":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_lot_no":
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		$jc_material_issue = ExecuteScalar("SELECT `jc_material_issue` FROM `carpet_setup`  order by `id` asc limit 1");
		setcookie('checkmat', $jc_material_issue);
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'job_card_bc');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) 
		{

		// Return error message in CustomError
		extract($_POST,EXTR_OVERWRITE);
		$_SESSION[SESSION_MESSAGE] = '';
			$row = ExecuteRow("SELECT concat_ws(' - ',`bcode`.`design`,`bcode`.`size_cm`,ifnull(`ppr`.`partner_ref`,NULL)) as design_size from `bcode` left join `partner_product_ref` `ppr` on((`ppr`.`id` = `bcode`.`buyer_ref`)) where `bcode`.`barcode` IN ($x__barcode[0])");
			if ($row['design_size'] != $x_design_size)
				{
					$_SESSION[SESSION_WARNING_MESSAGE].= 'Data Mismatch';
				}							
			if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
			{return TRUE;}
			else
			{return false;}
		}
}
?>