<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class job_card_fp_search extends job_card_fp
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'job_card_fp';

	// Page object name
	public $PageObjName = "job_card_fp_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (job_card_fp)
		if (!isset($GLOBALS["job_card_fp"]) || get_class($GLOBALS["job_card_fp"]) == PROJECT_NAMESPACE . "job_card_fp") {
			$GLOBALS["job_card_fp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["job_card_fp"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card_fp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $job_card_fp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($job_card_fp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "job_card_fpview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("job_card_fplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->jc_no->setVisibility();
		$this->works->Visible = FALSE;
		$this->s_grp->setVisibility();
		$this->poid->setVisibility();
		$this->po->Visible = FALSE;
		$this->item->setVisibility();
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->lot_no->Visible = FALSE;
		$this->pro_unit->setVisibility();
		$this->employee_id->setVisibility();
		$this->_1->setVisibility();
		$this->_2->setVisibility();
		$this->_3->setVisibility();
		$this->_4->setVisibility();
		$this->_5->setVisibility();
		$this->_6->setVisibility();
		$this->_7->setVisibility();
		$this->_8->setVisibility();
		$this->other1->setVisibility();
		$this->other2->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->product_code->setVisibility();
		$this->in_id->setVisibility();
		$this->balance_quantity->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->works);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->item);
		$this->setupLookupOptions($this->employee_id);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "job_card_fplist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		$this->buildSearchUrl($srchUrl, $this->poid); // poid
		$this->buildSearchUrl($srchUrl, $this->item); // item
		$this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->pro_unit); // pro_unit
		$this->buildSearchUrl($srchUrl, $this->employee_id); // employee_id
		$this->buildSearchUrl($srchUrl, $this->_1); // 1
		$this->buildSearchUrl($srchUrl, $this->_2); // 2
		$this->buildSearchUrl($srchUrl, $this->_3); // 3
		$this->buildSearchUrl($srchUrl, $this->_4); // 4
		$this->buildSearchUrl($srchUrl, $this->_5); // 5
		$this->buildSearchUrl($srchUrl, $this->_6); // 6
		$this->buildSearchUrl($srchUrl, $this->_7); // 7
		$this->buildSearchUrl($srchUrl, $this->_8); // 8
		$this->buildSearchUrl($srchUrl, $this->other1); // other1
		$this->buildSearchUrl($srchUrl, $this->other2); // other2
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->product_code); // product_code
		$this->buildSearchUrl($srchUrl, $this->in_id); // in_id
		$this->buildSearchUrl($srchUrl, $this->balance_quantity); // balance_quantity
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_no"));
		$this->jc_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_no"));

		// works
		if (!$this->isAddOrEdit())
			$this->works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_works"));
		$this->works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_works"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));

		// poid
		if (!$this->isAddOrEdit())
			$this->poid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_poid"));
		$this->poid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_poid"));

		// item
		if (!$this->isAddOrEdit())
			$this->item->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_item"));
		$this->item->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_item"));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_batch_no"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// pro_unit
		if (!$this->isAddOrEdit())
			$this->pro_unit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pro_unit"));
		$this->pro_unit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pro_unit"));

		// employee_id
		if (!$this->isAddOrEdit())
			$this->employee_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_employee_id"));
		$this->employee_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_employee_id"));
		if (is_array($this->employee_id->AdvancedSearch->SearchValue))
			$this->employee_id->AdvancedSearch->SearchValue = implode(",", $this->employee_id->AdvancedSearch->SearchValue);
		if (is_array($this->employee_id->AdvancedSearch->SearchValue2))
			$this->employee_id->AdvancedSearch->SearchValue2 = implode(",", $this->employee_id->AdvancedSearch->SearchValue2);

		// 1
		if (!$this->isAddOrEdit())
			$this->_1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__1"));
		$this->_1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__1"));

		// 2
		if (!$this->isAddOrEdit())
			$this->_2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__2"));
		$this->_2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__2"));

		// 3
		if (!$this->isAddOrEdit())
			$this->_3->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__3"));
		$this->_3->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__3"));

		// 4
		if (!$this->isAddOrEdit())
			$this->_4->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__4"));
		$this->_4->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__4"));

		// 5
		if (!$this->isAddOrEdit())
			$this->_5->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__5"));
		$this->_5->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__5"));

		// 6
		if (!$this->isAddOrEdit())
			$this->_6->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__6"));
		$this->_6->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__6"));

		// 7
		if (!$this->isAddOrEdit())
			$this->_7->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__7"));
		$this->_7->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__7"));

		// 8
		if (!$this->isAddOrEdit())
			$this->_8->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__8"));
		$this->_8->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__8"));

		// other1
		if (!$this->isAddOrEdit())
			$this->other1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_other1"));
		$this->other1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_other1"));

		// other2
		if (!$this->isAddOrEdit())
			$this->other2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_other2"));
		$this->other2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_other2"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// product_code
		if (!$this->isAddOrEdit())
			$this->product_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_code"));
		$this->product_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_code"));

		// in_id
		if (!$this->isAddOrEdit())
			$this->in_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_in_id"));
		$this->in_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_in_id"));

		// balance_quantity
		if (!$this->isAddOrEdit())
			$this->balance_quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_balance_quantity"));
		$this->balance_quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_balance_quantity"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->balance_quantity->FormValue == $this->balance_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->balance_quantity->CurrentValue)))
			$this->balance_quantity->CurrentValue = ConvertToFloatString($this->balance_quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// jc_no
		// works
		// s_grp
		// poid
		// po
		// item
		// batch_no
		// quantity
		// lot_no
		// pro_unit
		// employee_id
		// 1
		// 2
		// 3
		// 4
		// 5
		// 6
		// 7
		// 8
		// other1
		// other2
		// operator
		// datetime
		// updated
		// product_code
		// in_id
		// balance_quantity

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// works
			$curVal = strval($this->works->CurrentValue);
			if ($curVal <> "") {
				$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
				if ($this->works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET(`grp`,'0,2'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->works->ViewValue = $this->works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->works->ViewValue = $this->works->CurrentValue;
					}
				}
			} else {
				$this->works->ViewValue = NULL;
			}
			$this->works->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// item
			$curVal = strval($this->item->CurrentValue);
			if ($curVal <> "") {
				$this->item->ViewValue = $this->item->lookupCacheOption($curVal);
				if ($this->item->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`gcode`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->item->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->item->ViewValue = $this->item->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->item->ViewValue = $this->item->CurrentValue;
					}
				}
			} else {
				$this->item->ViewValue = NULL;
			}
			$this->item->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// pro_unit
			$this->pro_unit->ViewValue = $this->pro_unit->CurrentValue;
			$this->pro_unit->ViewCustomAttributes = "";

			// employee_id
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->employee_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			$this->employee_id->ViewCustomAttributes = "";

			// 1
			$this->_1->ViewValue = $this->_1->CurrentValue;
			$this->_1->ViewCustomAttributes = "";

			// 2
			$this->_2->ViewValue = $this->_2->CurrentValue;
			$this->_2->ViewCustomAttributes = "";

			// 3
			$this->_3->ViewValue = $this->_3->CurrentValue;
			$this->_3->ViewCustomAttributes = "";

			// 4
			$this->_4->ViewValue = $this->_4->CurrentValue;
			$this->_4->ViewCustomAttributes = "";

			// 5
			$this->_5->ViewValue = $this->_5->CurrentValue;
			$this->_5->ViewCustomAttributes = "";

			// 6
			$this->_6->ViewValue = $this->_6->CurrentValue;
			$this->_6->ViewCustomAttributes = "";

			// 7
			$this->_7->ViewValue = $this->_7->CurrentValue;
			$this->_7->ViewCustomAttributes = "";

			// 8
			$this->_8->ViewValue = $this->_8->CurrentValue;
			$this->_8->ViewCustomAttributes = "";

			// other1
			$this->other1->ViewValue = $this->other1->CurrentValue;
			$this->other1->ViewCustomAttributes = "";

			// other2
			$this->other2->ViewValue = $this->other2->CurrentValue;
			$this->other2->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// in_id
			$this->in_id->ViewValue = $this->in_id->CurrentValue;
			$this->in_id->ViewCustomAttributes = "";

			// balance_quantity
			$this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
			$this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, 2, -2, -2, -2);
			$this->balance_quantity->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->jc_no->CurrentValue)) {
				$this->jc_no->HrefValue = "job_card_fplist.php?x_jc_no=" . $this->jc_no->CurrentValue; // Add prefix/suffix
				$this->jc_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->jc_no->HrefValue = FullUrl($this->jc_no->HrefValue, "href");
			} else {
				$this->jc_no->HrefValue = "";
			}
			$this->jc_no->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "job_card_fplist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_parent"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			if (!EmptyValue($this->poid->CurrentValue)) {
				$this->poid->HrefValue = "job_card_fplist.php?x_poid=" . $this->poid->CurrentValue; // Add prefix/suffix
				$this->poid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->poid->HrefValue = FullUrl($this->poid->HrefValue, "href");
			} else {
				$this->poid->HrefValue = "";
			}
			$this->poid->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "job_card_fplist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}
			$this->item->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "job_card_fplist.php?x_batch_no=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			if (!EmptyValue($this->quantity->CurrentValue)) {
				$this->quantity->HrefValue = "job_card_fplist.php?x_quantity=" . $this->quantity->CurrentValue; // Add prefix/suffix
				$this->quantity->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->quantity->HrefValue = FullUrl($this->quantity->HrefValue, "href");
			} else {
				$this->quantity->HrefValue = "";
			}
			$this->quantity->TooltipValue = "";

			// pro_unit
			$this->pro_unit->LinkCustomAttributes = "";
			$this->pro_unit->HrefValue = "";
			$this->pro_unit->TooltipValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_id->CurrentValue)) {
				$this->employee_id->HrefValue = "job_card_fplist.php?x_employee_id=" . $this->employee_id->CurrentValue; // Add prefix/suffix
				$this->employee_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
			} else {
				$this->employee_id->HrefValue = "";
			}
			$this->employee_id->TooltipValue = "";

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";
			$this->_1->TooltipValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";
			$this->_2->TooltipValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";
			$this->_3->TooltipValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";
			$this->_4->TooltipValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";
			$this->_5->TooltipValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";
			$this->_6->TooltipValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";
			$this->_7->TooltipValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";
			$this->_8->TooltipValue = "";

			// other1
			$this->other1->LinkCustomAttributes = "";
			$this->other1->HrefValue = "";
			$this->other1->TooltipValue = "";

			// other2
			$this->other2->LinkCustomAttributes = "";
			$this->other2->HrefValue = "";
			$this->other2->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";
			$this->product_code->TooltipValue = "";

			// in_id
			$this->in_id->LinkCustomAttributes = "";
			$this->in_id->HrefValue = "";
			$this->in_id->TooltipValue = "";

			// balance_quantity
			$this->balance_quantity->LinkCustomAttributes = "";
			$this->balance_quantity->HrefValue = "";
			$this->balance_quantity->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = $this->grp->options(TRUE);

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// poid
			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->poid->AdvancedSearch->SearchValue = HtmlDecode($this->poid->AdvancedSearch->SearchValue);
			$this->poid->EditValue = HtmlEncode($this->poid->AdvancedSearch->SearchValue);
			$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			$curVal = trim(strval($this->item->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->item->AdvancedSearch->ViewValue = $this->item->lookupCacheOption($curVal);
			else
				$this->item->AdvancedSearch->ViewValue = $this->item->Lookup !== NULL && is_array($this->item->Lookup->Options) ? $curVal : NULL;
			if ($this->item->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->item->EditValue = array_values($this->item->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`gcode`" . SearchString("=", $this->item->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->item->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->item->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->batch_no->AdvancedSearch->SearchValue = HtmlDecode($this->batch_no->AdvancedSearch->SearchValue);
			$this->batch_no->EditValue = HtmlEncode($this->batch_no->AdvancedSearch->SearchValue);
			$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// pro_unit
			$this->pro_unit->EditAttrs["class"] = "form-control";
			$this->pro_unit->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pro_unit->AdvancedSearch->SearchValue = HtmlDecode($this->pro_unit->AdvancedSearch->SearchValue);
			$this->pro_unit->EditValue = HtmlEncode($this->pro_unit->AdvancedSearch->SearchValue);
			$this->pro_unit->PlaceHolder = RemoveHtml($this->pro_unit->caption());

			// employee_id
			$this->employee_id->EditAttrs["class"] = "form-control";
			$this->employee_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->employee_id->AdvancedSearch->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			else
				$this->employee_id->AdvancedSearch->ViewValue = $this->employee_id->Lookup !== NULL && is_array($this->employee_id->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->employee_id->EditValue = array_values($this->employee_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->employee_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_id->EditValue = $arwrk;
			}

			// 1
			$this->_1->EditAttrs["class"] = "form-control";
			$this->_1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_1->AdvancedSearch->SearchValue = HtmlDecode($this->_1->AdvancedSearch->SearchValue);
			$this->_1->EditValue = HtmlEncode($this->_1->AdvancedSearch->SearchValue);
			$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

			// 2
			$this->_2->EditAttrs["class"] = "form-control";
			$this->_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_2->AdvancedSearch->SearchValue = HtmlDecode($this->_2->AdvancedSearch->SearchValue);
			$this->_2->EditValue = HtmlEncode($this->_2->AdvancedSearch->SearchValue);
			$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

			// 3
			$this->_3->EditAttrs["class"] = "form-control";
			$this->_3->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_3->AdvancedSearch->SearchValue = HtmlDecode($this->_3->AdvancedSearch->SearchValue);
			$this->_3->EditValue = HtmlEncode($this->_3->AdvancedSearch->SearchValue);
			$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

			// 4
			$this->_4->EditAttrs["class"] = "form-control";
			$this->_4->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_4->AdvancedSearch->SearchValue = HtmlDecode($this->_4->AdvancedSearch->SearchValue);
			$this->_4->EditValue = HtmlEncode($this->_4->AdvancedSearch->SearchValue);
			$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

			// 5
			$this->_5->EditAttrs["class"] = "form-control";
			$this->_5->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_5->AdvancedSearch->SearchValue = HtmlDecode($this->_5->AdvancedSearch->SearchValue);
			$this->_5->EditValue = HtmlEncode($this->_5->AdvancedSearch->SearchValue);
			$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

			// 6
			$this->_6->EditAttrs["class"] = "form-control";
			$this->_6->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_6->AdvancedSearch->SearchValue = HtmlDecode($this->_6->AdvancedSearch->SearchValue);
			$this->_6->EditValue = HtmlEncode($this->_6->AdvancedSearch->SearchValue);
			$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

			// 7
			$this->_7->EditAttrs["class"] = "form-control";
			$this->_7->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_7->AdvancedSearch->SearchValue = HtmlDecode($this->_7->AdvancedSearch->SearchValue);
			$this->_7->EditValue = HtmlEncode($this->_7->AdvancedSearch->SearchValue);
			$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

			// 8
			$this->_8->EditAttrs["class"] = "form-control";
			$this->_8->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_8->AdvancedSearch->SearchValue = HtmlDecode($this->_8->AdvancedSearch->SearchValue);
			$this->_8->EditValue = HtmlEncode($this->_8->AdvancedSearch->SearchValue);
			$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

			// other1
			$this->other1->EditAttrs["class"] = "form-control";
			$this->other1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other1->AdvancedSearch->SearchValue = HtmlDecode($this->other1->AdvancedSearch->SearchValue);
			$this->other1->EditValue = HtmlEncode($this->other1->AdvancedSearch->SearchValue);
			$this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

			// other2
			$this->other2->EditAttrs["class"] = "form-control";
			$this->other2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other2->AdvancedSearch->SearchValue = HtmlDecode($this->other2->AdvancedSearch->SearchValue);
			$this->other2->EditValue = HtmlEncode($this->other2->AdvancedSearch->SearchValue);
			$this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			$this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// in_id
			$this->in_id->EditAttrs["class"] = "form-control";
			$this->in_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->in_id->AdvancedSearch->SearchValue = HtmlDecode($this->in_id->AdvancedSearch->SearchValue);
			$this->in_id->EditValue = HtmlEncode($this->in_id->AdvancedSearch->SearchValue);
			$this->in_id->PlaceHolder = RemoveHtml($this->in_id->caption());

			// balance_quantity
			$this->balance_quantity->EditAttrs["class"] = "form-control";
			$this->balance_quantity->EditCustomAttributes = "";
			$this->balance_quantity->EditValue = HtmlEncode($this->balance_quantity->AdvancedSearch->SearchValue);
			$this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->jc_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->jc_no->errorMessage());
		}
		if (!CheckNumber($this->quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->quantity->errorMessage());
		}
		if (!CheckInteger($this->pro_unit->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pro_unit->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckNumber($this->balance_quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->balance_quantity->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->works->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->poid->AdvancedSearch->load();
		$this->item->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->pro_unit->AdvancedSearch->load();
		$this->employee_id->AdvancedSearch->load();
		$this->_1->AdvancedSearch->load();
		$this->_2->AdvancedSearch->load();
		$this->_3->AdvancedSearch->load();
		$this->_4->AdvancedSearch->load();
		$this->_5->AdvancedSearch->load();
		$this->_6->AdvancedSearch->load();
		$this->_7->AdvancedSearch->load();
		$this->_8->AdvancedSearch->load();
		$this->other1->AdvancedSearch->load();
		$this->other2->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->product_code->AdvancedSearch->load();
		$this->in_id->AdvancedSearch->load();
		$this->balance_quantity->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("job_card_fplist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_works":
					$lookupFilter = function() {
						return "FIND_IN_SET(`grp`,'0,2'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_works":
							break;
						case "x_s_grp":
							break;
						case "x_item":
							break;
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'job_card_fp');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>