<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for job_card_hs
 */
class job_card_hs extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $works;
	public $jc_no_fp;
	public $item;
	public $batch_no;
	public $po;
	public $employee_id;
	public $avl_qty;
	public $quantity;
	public $_1;
	public $_2;
	public $operator;
	public $datetime;
	public $grp;
	public $s_grp;
	public $jc_no_hs;
	public $updated;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'job_card_hs';
		$this->TableName = 'job_card_hs';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`job_card_hs`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('job_card_hs', 'job_card_hs', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// works
		$this->works = new DbField('job_card_hs', 'job_card_hs', 'x_works', 'works', '`works`', '`works`', 17, -1, FALSE, '`works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->works->Required = TRUE; // Required field
		$this->works->Sortable = TRUE; // Allow sort
		$this->works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->works->Lookup = new Lookup('works', 'godown_table', FALSE, 'id', ["name","code","",""], [], ["x_jc_no_fp"], [], [], [], [], '`name` ASC', '');
		$this->works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['works'] = &$this->works;

		// jc_no_fp
		$this->jc_no_fp = new DbField('job_card_hs', 'job_card_hs', 'x_jc_no_fp', 'jc_no_fp', '`jc_no_fp`', '`jc_no_fp`', 19, -1, FALSE, '`jc_no_fp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->jc_no_fp->Nullable = FALSE; // NOT NULL field
		$this->jc_no_fp->Required = TRUE; // Required field
		$this->jc_no_fp->Sortable = TRUE; // Allow sort
		$this->jc_no_fp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->jc_no_fp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->jc_no_fp->Lookup = new Lookup('jc_no_fp', 'stock_material_hs', TRUE, 'jc_no', ["jc_no","po","item_code","jc_Balance"], ["x_works"], [], ["godown"], ["x_godown"], ["item_code","batch_no","po","jc_Balance"], ["x_item","x_batch_no","x_po","x_avl_qty"], '`jc_no` ASC', '');
		$this->jc_no_fp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no_fp'] = &$this->jc_no_fp;

		// item
		$this->item = new DbField('job_card_hs', 'job_card_hs', 'x_item', 'item', '`item`', '`item`', 200, -1, FALSE, '`item`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->item->Nullable = FALSE; // NOT NULL field
		$this->item->Required = TRUE; // Required field
		$this->item->Sortable = TRUE; // Allow sort
		$this->fields['item'] = &$this->item;

		// batch_no
		$this->batch_no = new DbField('job_card_hs', 'job_card_hs', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', FALSE, 'id', ["batch_no","","",""], [], [], [], [], [], [], '`batch_no` DESC', '');
		$this->fields['batch_no'] = &$this->batch_no;

		// po
		$this->po = new DbField('job_card_hs', 'job_card_hs', 'x_po', 'po', '`po`', '`po`', 200, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Nullable = FALSE; // NOT NULL field
		$this->po->Required = TRUE; // Required field
		$this->po->Sortable = TRUE; // Allow sort
		$this->fields['po'] = &$this->po;

		// employee_id
		$this->employee_id = new DbField('job_card_hs', 'job_card_hs', 'x_employee_id', 'employee_id', '`employee_id`', '`employee_id`', 200, -1, FALSE, '`EV__employee_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->employee_id->Nullable = FALSE; // NOT NULL field
		$this->employee_id->Required = TRUE; // Required field
		$this->employee_id->Sortable = TRUE; // Allow sort
		$this->employee_id->Lookup = new Lookup('employee_id', 'production_employee_hs', FALSE, 'id', ["id","employee_name","mobile",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->fields['employee_id'] = &$this->employee_id;

		// avl_qty
		$this->avl_qty = new DbField('job_card_hs', 'job_card_hs', 'x_avl_qty', 'avl_qty', '`avl_qty`', '`avl_qty`', 4, -1, FALSE, '`avl_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avl_qty->Nullable = FALSE; // NOT NULL field
		$this->avl_qty->Required = TRUE; // Required field
		$this->avl_qty->Sortable = TRUE; // Allow sort
		$this->avl_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['avl_qty'] = &$this->avl_qty;

		// quantity
		$this->quantity = new DbField('job_card_hs', 'job_card_hs', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 4, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// 1
		$this->_1 = new DbField('job_card_hs', 'job_card_hs', 'x__1', '1', '`1`', '`1`', 200, -1, FALSE, '`1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_1->Sortable = TRUE; // Allow sort
		$this->fields['1'] = &$this->_1;

		// 2
		$this->_2 = new DbField('job_card_hs', 'job_card_hs', 'x__2', '2', '`2`', '`2`', 200, -1, FALSE, '`2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2->Sortable = TRUE; // Allow sort
		$this->fields['2'] = &$this->_2;

		// operator
		$this->operator = new DbField('job_card_hs', 'job_card_hs', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('job_card_hs', 'job_card_hs', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// grp
		$this->grp = new DbField('job_card_hs', 'job_card_hs', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('job_card_hs', 'job_card_hs', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 17, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// jc_no_hs
		$this->jc_no_hs = new DbField('job_card_hs', 'job_card_hs', 'x_jc_no_hs', 'jc_no_hs', '`jc_no_hs`', '`jc_no_hs`', 19, -1, FALSE, '`jc_no_hs`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no_hs->Sortable = FALSE; // Allow sort
		$this->jc_no_hs->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no_hs'] = &$this->jc_no_hs;

		// updated
		$this->updated = new DbField('job_card_hs', 'job_card_hs', 'x_updated', 'updated', '`updated`', '`updated`', 17, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Sortable = FALSE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`job_card_hs`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_id) . "',COALESCE(`employee_name`,''),'" . ValueSeparator(2, $this->employee_id) . "',COALESCE(`mobile`,'')) FROM `production_employee_hs` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `job_card_hs`.`employee_id` LIMIT 1) AS `EV__employee_id` FROM `job_card_hs`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->employee_id->AdvancedSearch->SearchValue <> "" ||
			$this->employee_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->employee_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->employee_id->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->works->DbValue = $row['works'];
		$this->jc_no_fp->DbValue = $row['jc_no_fp'];
		$this->item->DbValue = $row['item'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->po->DbValue = $row['po'];
		$this->employee_id->DbValue = $row['employee_id'];
		$this->avl_qty->DbValue = $row['avl_qty'];
		$this->quantity->DbValue = $row['quantity'];
		$this->_1->DbValue = $row['1'];
		$this->_2->DbValue = $row['2'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->jc_no_hs->DbValue = $row['jc_no_hs'];
		$this->updated->DbValue = $row['updated'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "job_card_hslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "job_card_hsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "job_card_hsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "job_card_hsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "job_card_hslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("job_card_hsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("job_card_hsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "job_card_hsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "job_card_hsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("job_card_hsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("job_card_hsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("job_card_hsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->works->setDbValue($rs->fields('works'));
		$this->jc_no_fp->setDbValue($rs->fields('jc_no_fp'));
		$this->item->setDbValue($rs->fields('item'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->po->setDbValue($rs->fields('po'));
		$this->employee_id->setDbValue($rs->fields('employee_id'));
		$this->avl_qty->setDbValue($rs->fields('avl_qty'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->_1->setDbValue($rs->fields('1'));
		$this->_2->setDbValue($rs->fields('2'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->jc_no_hs->setDbValue($rs->fields('jc_no_hs'));
		$this->updated->setDbValue($rs->fields('updated'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// works
		// jc_no_fp
		// item
		// batch_no
		// po
		// employee_id
		// avl_qty
		// quantity
		// 1
		// 2
		// operator
		// datetime
		// grp
		// s_grp
		// jc_no_hs

		$this->jc_no_hs->CellCssStyle = "white-space: nowrap;";

		// updated
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// works
		$curVal = strval($this->works->CurrentValue);
		if ($curVal <> "") {
			$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
			if ($this->works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->works->ViewValue = $this->works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->works->ViewValue = $this->works->CurrentValue;
				}
			}
		} else {
			$this->works->ViewValue = NULL;
		}
		$this->works->ViewCustomAttributes = "";

		// jc_no_fp
		$curVal = strval($this->jc_no_fp->CurrentValue);
		if ($curVal <> "") {
			$this->jc_no_fp->ViewValue = $this->jc_no_fp->lookupCacheOption($curVal);
			if ($this->jc_no_fp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (hs_bom_byepass() == 1) ? "" : "`Balance` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->jc_no_fp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
					$this->jc_no_fp->ViewValue = $this->jc_no_fp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->jc_no_fp->ViewValue = $this->jc_no_fp->CurrentValue;
				}
			}
		} else {
			$this->jc_no_fp->ViewValue = NULL;
		}
		$this->jc_no_fp->ViewCustomAttributes = "";

		// item
		$this->item->ViewValue = $this->item->CurrentValue;
		$this->item->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// employee_id
		if ($this->employee_id->VirtualValue <> "") {
			$this->employee_id->ViewValue = $this->employee_id->VirtualValue;
		} else {
			$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
		$curVal = strval($this->employee_id->CurrentValue);
		if ($curVal <> "") {
			$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			if ($this->employee_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
					$this->employee_id->ViewValue = $this->employee_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
				}
			}
		} else {
			$this->employee_id->ViewValue = NULL;
		}
		}
		$this->employee_id->ViewCustomAttributes = "";

		// avl_qty
		$this->avl_qty->ViewValue = $this->avl_qty->CurrentValue;
		$this->avl_qty->ViewValue = FormatNumber($this->avl_qty->ViewValue, 2, -2, -2, -2);
		$this->avl_qty->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// 1
		$this->_1->ViewValue = $this->_1->CurrentValue;
		$this->_1->ViewCustomAttributes = "";

		// 2
		$this->_2->ViewValue = $this->_2->CurrentValue;
		$this->_2->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
		$this->s_grp->ViewCustomAttributes = "";

		// jc_no_hs
		$this->jc_no_hs->ViewValue = $this->jc_no_hs->CurrentValue;
		$this->jc_no_hs->ViewValue = FormatNumber($this->jc_no_hs->ViewValue, 0, -2, -2, -2);
		$this->jc_no_hs->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
		$this->updated->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// works
		$this->works->LinkCustomAttributes = "";
		$this->works->HrefValue = "";
		$this->works->TooltipValue = "";

		// jc_no_fp
		$this->jc_no_fp->LinkCustomAttributes = "";
		$this->jc_no_fp->HrefValue = "";
		$this->jc_no_fp->TooltipValue = "";

		// item
		$this->item->LinkCustomAttributes = "";
		$this->item->HrefValue = "";
		$this->item->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// employee_id
		$this->employee_id->LinkCustomAttributes = "";
		$this->employee_id->HrefValue = "";
		$this->employee_id->TooltipValue = "";

		// avl_qty
		$this->avl_qty->LinkCustomAttributes = "";
		$this->avl_qty->HrefValue = "";
		$this->avl_qty->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// 1
		$this->_1->LinkCustomAttributes = "";
		$this->_1->HrefValue = "";
		$this->_1->TooltipValue = "";

		// 2
		$this->_2->LinkCustomAttributes = "";
		$this->_2->HrefValue = "";
		$this->_2->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// jc_no_hs
		$this->jc_no_hs->LinkCustomAttributes = "";
		$this->jc_no_hs->HrefValue = "";
		$this->jc_no_hs->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// works
		$this->works->EditAttrs["class"] = "form-control";
		$this->works->EditCustomAttributes = "";

		// jc_no_fp
		$this->jc_no_fp->EditAttrs["class"] = "form-control";
		$this->jc_no_fp->EditCustomAttributes = "";

		// item
		$this->item->EditAttrs["class"] = "form-control";
		$this->item->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
		$this->item->EditValue = $this->item->CurrentValue;
		$this->item->PlaceHolder = RemoveHtml($this->item->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->po->CurrentValue = HtmlDecode($this->po->CurrentValue);
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// employee_id
		$this->employee_id->EditAttrs["class"] = "form-control";
		$this->employee_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->employee_id->CurrentValue = HtmlDecode($this->employee_id->CurrentValue);
		$this->employee_id->EditValue = $this->employee_id->CurrentValue;
		$this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

		// avl_qty
		$this->avl_qty->EditAttrs["class"] = "form-control";
		$this->avl_qty->EditCustomAttributes = "";
		$this->avl_qty->EditValue = $this->avl_qty->CurrentValue;
		$this->avl_qty->PlaceHolder = RemoveHtml($this->avl_qty->caption());
		if (strval($this->avl_qty->EditValue) <> "" && is_numeric($this->avl_qty->EditValue))
			$this->avl_qty->EditValue = FormatNumber($this->avl_qty->EditValue, -2, -2, -2, -2);

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// 1
		$this->_1->EditAttrs["class"] = "form-control";
		$this->_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
		$this->_1->EditValue = $this->_1->CurrentValue;
		$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

		// 2
		$this->_2->EditAttrs["class"] = "form-control";
		$this->_2->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
		$this->_2->EditValue = $this->_2->CurrentValue;
		$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

		// operator
		// datetime
		// grp

		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// jc_no_hs
		$this->jc_no_hs->EditAttrs["class"] = "form-control";
		$this->jc_no_hs->EditCustomAttributes = "";
		$this->jc_no_hs->EditValue = $this->jc_no_hs->CurrentValue;
		$this->jc_no_hs->PlaceHolder = RemoveHtml($this->jc_no_hs->caption());

		// updated
		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->works);
					$doc->exportCaption($this->jc_no_fp);
					$doc->exportCaption($this->item);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->avl_qty);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->_1);
					$doc->exportCaption($this->_2);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->works);
					$doc->exportCaption($this->jc_no_fp);
					$doc->exportCaption($this->item);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->avl_qty);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->_1);
					$doc->exportCaption($this->_2);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->works);
						$doc->exportField($this->jc_no_fp);
						$doc->exportField($this->item);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->po);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->avl_qty);
						$doc->exportField($this->quantity);
						$doc->exportField($this->_1);
						$doc->exportField($this->_2);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->works);
						$doc->exportField($this->jc_no_fp);
						$doc->exportField($this->item);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->po);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->avl_qty);
						$doc->exportField($this->quantity);
						$doc->exportField($this->_1);
						$doc->exportField($this->_2);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>