<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class job_card_hs_search extends job_card_hs
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'job_card_hs';

	// Page object name
	public $PageObjName = "job_card_hs_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (job_card_hs)
		if (!isset($GLOBALS["job_card_hs"]) || get_class($GLOBALS["job_card_hs"]) == PROJECT_NAMESPACE . "job_card_hs") {
			$GLOBALS["job_card_hs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["job_card_hs"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card_hs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $job_card_hs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($job_card_hs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "job_card_hsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("job_card_hslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->works->setVisibility();
		$this->jc_no_fp->setVisibility();
		$this->item->setVisibility();
		$this->batch_no->setVisibility();
		$this->po->setVisibility();
		$this->employee_id->setVisibility();
		$this->avl_qty->setVisibility();
		$this->quantity->setVisibility();
		$this->_1->setVisibility();
		$this->_2->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->jc_no_hs->setVisibility();
		$this->updated->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->works);
		$this->setupLookupOptions($this->jc_no_fp);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->employee_id);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "job_card_hslist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->works); // works
		$this->buildSearchUrl($srchUrl, $this->jc_no_fp); // jc_no_fp
		$this->buildSearchUrl($srchUrl, $this->item); // item
		$this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->employee_id); // employee_id
		$this->buildSearchUrl($srchUrl, $this->avl_qty); // avl_qty
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->_1); // 1
		$this->buildSearchUrl($srchUrl, $this->_2); // 2
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		$this->buildSearchUrl($srchUrl, $this->jc_no_hs); // jc_no_hs
		$this->buildSearchUrl($srchUrl, $this->updated); // updated
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// works
		if (!$this->isAddOrEdit())
			$this->works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_works"));
		$this->works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_works"));

		// jc_no_fp
		if (!$this->isAddOrEdit())
			$this->jc_no_fp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_no_fp"));
		$this->jc_no_fp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_no_fp"));

		// item
		if (!$this->isAddOrEdit())
			$this->item->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_item"));
		$this->item->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_item"));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_batch_no"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));

		// employee_id
		if (!$this->isAddOrEdit())
			$this->employee_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_employee_id"));
		$this->employee_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_employee_id"));

		// avl_qty
		if (!$this->isAddOrEdit())
			$this->avl_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_avl_qty"));
		$this->avl_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_avl_qty"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// 1
		if (!$this->isAddOrEdit())
			$this->_1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__1"));
		$this->_1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__1"));

		// 2
		if (!$this->isAddOrEdit())
			$this->_2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__2"));
		$this->_2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__2"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));

		// jc_no_hs
		if (!$this->isAddOrEdit())
			$this->jc_no_hs->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_no_hs"));
		$this->jc_no_hs->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_no_hs"));

		// updated
		if (!$this->isAddOrEdit())
			$this->updated->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_updated"));
		$this->updated->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_updated"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->avl_qty->FormValue == $this->avl_qty->CurrentValue && is_numeric(ConvertToFloatString($this->avl_qty->CurrentValue)))
			$this->avl_qty->CurrentValue = ConvertToFloatString($this->avl_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// works
		// jc_no_fp
		// item
		// batch_no
		// po
		// employee_id
		// avl_qty
		// quantity
		// 1
		// 2
		// operator
		// datetime
		// grp
		// s_grp
		// jc_no_hs
		// updated

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// works
			$curVal = strval($this->works->CurrentValue);
			if ($curVal <> "") {
				$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
				if ($this->works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->works->ViewValue = $this->works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->works->ViewValue = $this->works->CurrentValue;
					}
				}
			} else {
				$this->works->ViewValue = NULL;
			}
			$this->works->ViewCustomAttributes = "";

			// jc_no_fp
			$curVal = strval($this->jc_no_fp->CurrentValue);
			if ($curVal <> "") {
				$this->jc_no_fp->ViewValue = $this->jc_no_fp->lookupCacheOption($curVal);
				if ($this->jc_no_fp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (hs_bom_byepass() == 1) ? "" : "`Balance` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->jc_no_fp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->jc_no_fp->ViewValue = $this->jc_no_fp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->jc_no_fp->ViewValue = $this->jc_no_fp->CurrentValue;
					}
				}
			} else {
				$this->jc_no_fp->ViewValue = NULL;
			}
			$this->jc_no_fp->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			$this->item->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// employee_id
			if ($this->employee_id->VirtualValue <> "") {
				$this->employee_id->ViewValue = $this->employee_id->VirtualValue;
			} else {
				$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$this->employee_id->ViewValue = $this->employee_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			}
			$this->employee_id->ViewCustomAttributes = "";

			// avl_qty
			$this->avl_qty->ViewValue = $this->avl_qty->CurrentValue;
			$this->avl_qty->ViewValue = FormatNumber($this->avl_qty->ViewValue, 2, -2, -2, -2);
			$this->avl_qty->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// 1
			$this->_1->ViewValue = $this->_1->CurrentValue;
			$this->_1->ViewCustomAttributes = "";

			// 2
			$this->_2->ViewValue = $this->_2->CurrentValue;
			$this->_2->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
			$this->s_grp->ViewCustomAttributes = "";

			// jc_no_hs
			$this->jc_no_hs->ViewValue = $this->jc_no_hs->CurrentValue;
			$this->jc_no_hs->ViewValue = FormatNumber($this->jc_no_hs->ViewValue, 0, -2, -2, -2);
			$this->jc_no_hs->ViewCustomAttributes = "";

			// updated
			$this->updated->ViewValue = $this->updated->CurrentValue;
			$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
			$this->updated->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// works
			$this->works->LinkCustomAttributes = "";
			$this->works->HrefValue = "";
			$this->works->TooltipValue = "";

			// jc_no_fp
			$this->jc_no_fp->LinkCustomAttributes = "";
			$this->jc_no_fp->HrefValue = "";
			$this->jc_no_fp->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			$this->item->HrefValue = "";
			$this->item->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			$this->employee_id->HrefValue = "";
			$this->employee_id->TooltipValue = "";

			// avl_qty
			$this->avl_qty->LinkCustomAttributes = "";
			$this->avl_qty->HrefValue = "";
			$this->avl_qty->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";
			$this->_1->TooltipValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";
			$this->_2->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// jc_no_hs
			$this->jc_no_hs->LinkCustomAttributes = "";
			$this->jc_no_hs->HrefValue = "";
			$this->jc_no_hs->TooltipValue = "";

			// updated
			$this->updated->LinkCustomAttributes = "";
			$this->updated->HrefValue = "";
			$this->updated->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// works
			$this->works->EditAttrs["class"] = "form-control";
			$this->works->EditCustomAttributes = "";
			$curVal = trim(strval($this->works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->works->AdvancedSearch->ViewValue = $this->works->lookupCacheOption($curVal);
			else
				$this->works->AdvancedSearch->ViewValue = $this->works->Lookup !== NULL && is_array($this->works->Lookup->Options) ? $curVal : NULL;
			if ($this->works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->works->EditValue = array_values($this->works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->works->EditValue = $arwrk;
			}

			// jc_no_fp
			$this->jc_no_fp->EditAttrs["class"] = "form-control";
			$this->jc_no_fp->EditCustomAttributes = "";
			$curVal = trim(strval($this->jc_no_fp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->jc_no_fp->AdvancedSearch->ViewValue = $this->jc_no_fp->lookupCacheOption($curVal);
			else
				$this->jc_no_fp->AdvancedSearch->ViewValue = $this->jc_no_fp->Lookup !== NULL && is_array($this->jc_no_fp->Lookup->Options) ? $curVal : NULL;
			if ($this->jc_no_fp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->jc_no_fp->EditValue = array_values($this->jc_no_fp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`jc_no`" . SearchString("=", $this->jc_no_fp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (hs_bom_byepass() == 1) ? "" : "`Balance` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->jc_no_fp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->jc_no_fp->EditValue = $arwrk;
			}

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
			$this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po->AdvancedSearch->SearchValue = HtmlDecode($this->po->AdvancedSearch->SearchValue);
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// employee_id
			$this->employee_id->EditAttrs["class"] = "form-control";
			$this->employee_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->employee_id->AdvancedSearch->SearchValue = HtmlDecode($this->employee_id->AdvancedSearch->SearchValue);
			$this->employee_id->EditValue = HtmlEncode($this->employee_id->AdvancedSearch->SearchValue);
			$this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

			// avl_qty
			$this->avl_qty->EditAttrs["class"] = "form-control";
			$this->avl_qty->EditCustomAttributes = "";
			$this->avl_qty->EditValue = HtmlEncode($this->avl_qty->AdvancedSearch->SearchValue);
			$this->avl_qty->PlaceHolder = RemoveHtml($this->avl_qty->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// 1
			$this->_1->EditAttrs["class"] = "form-control";
			$this->_1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_1->AdvancedSearch->SearchValue = HtmlDecode($this->_1->AdvancedSearch->SearchValue);
			$this->_1->EditValue = HtmlEncode($this->_1->AdvancedSearch->SearchValue);
			$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

			// 2
			$this->_2->EditAttrs["class"] = "form-control";
			$this->_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_2->AdvancedSearch->SearchValue = HtmlDecode($this->_2->AdvancedSearch->SearchValue);
			$this->_2->EditValue = HtmlEncode($this->_2->AdvancedSearch->SearchValue);
			$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = HtmlEncode($this->grp->AdvancedSearch->SearchValue);
			$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->AdvancedSearch->SearchValue);
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// jc_no_hs
			$this->jc_no_hs->EditAttrs["class"] = "form-control";
			$this->jc_no_hs->EditCustomAttributes = "";
			$this->jc_no_hs->EditValue = HtmlEncode($this->jc_no_hs->AdvancedSearch->SearchValue);
			$this->jc_no_hs->PlaceHolder = RemoveHtml($this->jc_no_hs->caption());

			// updated
			$this->updated->EditAttrs["class"] = "form-control";
			$this->updated->EditCustomAttributes = "";
			$this->updated->EditValue = HtmlEncode($this->updated->AdvancedSearch->SearchValue);
			$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckNumber($this->avl_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->avl_qty->errorMessage());
		}
		if (!CheckNumber($this->quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->quantity->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->grp->errorMessage());
		}
		if (!CheckInteger($this->s_grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->s_grp->errorMessage());
		}
		if (!CheckInteger($this->jc_no_hs->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->jc_no_hs->errorMessage());
		}
		if (!CheckInteger($this->updated->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->updated->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->works->AdvancedSearch->load();
		$this->jc_no_fp->AdvancedSearch->load();
		$this->item->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->employee_id->AdvancedSearch->load();
		$this->avl_qty->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->_1->AdvancedSearch->load();
		$this->_2->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->jc_no_hs->AdvancedSearch->load();
		$this->updated->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("job_card_hslist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_works":
					$lookupFilter = function() {
						return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_jc_no_fp":
					$lookupFilter = function() {
						return (hs_bom_byepass() == 1) ? "" : "`Balance` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_works":
							break;
						case "x_jc_no_fp":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_batch_no":
							break;
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>