<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for job_card_pending_query
 */
class job_card_pending_query extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $works;
	public $po;
	public $jc_no;
	public $datetime;
	public $emp_name;
	public $tqty;
	public $count;
	public $tsqm;
	public $psqm;
	public $pending_days;
	public $_barcode;
	public $plan_week;
	public $dispatch_date;
	public $loom_no;
	public $id;
	public $buyers_id;
	public $design_size;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'job_card_pending_query';
		$this->TableName = 'job_card_pending_query';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`job_card_pending_query`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// works
		$this->works = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_works', 'works', '`works`', '`works`', 18, -1, FALSE, '`works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->works->Nullable = FALSE; // NOT NULL field
		$this->works->Required = TRUE; // Required field
		$this->works->Sortable = TRUE; // Allow sort
		$this->works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->works->Lookup = new Lookup('works', 'godown', TRUE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['works'] = &$this->works;

		// po
		$this->po = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// jc_no
		$this->jc_no = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 19, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Required = TRUE; // Required field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// datetime
		$this->datetime = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 2, "DB"), 135, 2, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// emp_name
		$this->emp_name = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_emp_name', 'emp_name', '`emp_name`', '`emp_name`', 200, -1, FALSE, '`emp_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->emp_name->Sortable = TRUE; // Allow sort
		$this->emp_name->SelectMultiple = TRUE; // Multiple select
		$this->emp_name->Lookup = new Lookup('emp_name', '_production_employee_view', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->fields['emp_name'] = &$this->emp_name;

		// tqty
		$this->tqty = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_tqty', 'tqty', '`tqty`', '`tqty`', 20, -1, FALSE, '`tqty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tqty->Sortable = TRUE; // Allow sort
		$this->tqty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tqty'] = &$this->tqty;

		// count
		$this->count = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_count', 'count', '`count`', '`count`', 20, -1, FALSE, '`count`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->count->Nullable = FALSE; // NOT NULL field
		$this->count->Required = TRUE; // Required field
		$this->count->Sortable = TRUE; // Allow sort
		$this->count->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['count'] = &$this->count;

		// tsqm
		$this->tsqm = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_tsqm', 'tsqm', '`tsqm`', '`tsqm`', 5, -1, FALSE, '`tsqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tsqm->Sortable = TRUE; // Allow sort
		$this->tsqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tsqm'] = &$this->tsqm;

		// psqm
		$this->psqm = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_psqm', 'psqm', '`psqm`', '`psqm`', 5, -1, FALSE, '`psqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->psqm->Nullable = FALSE; // NOT NULL field
		$this->psqm->Sortable = TRUE; // Allow sort
		$this->psqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['psqm'] = &$this->psqm;

		// pending_days
		$this->pending_days = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_pending_days', 'pending_days', '`pending_days`', '`pending_days`', 3, -1, FALSE, '`pending_days`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pending_days->Sortable = TRUE; // Allow sort
		$this->pending_days->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pending_days'] = &$this->pending_days;

		// barcode
		$this->_barcode = new DbField('job_card_pending_query', 'job_card_pending_query', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 201, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->_barcode->Required = TRUE; // Required field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->SelectMultiple = TRUE; // Multiple select
		$this->_barcode->Lookup = new Lookup('barcode', 'bcode', FALSE, 'barcode', ["barcode","","",""], [], [], [], [], [], [], '`barcode` ASC', '');
		$this->fields['barcode'] = &$this->_barcode;

		// plan_week
		$this->plan_week = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_plan_week', 'plan_week', '`plan_week`', '`plan_week`', 18, -1, FALSE, '`plan_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->plan_week->Sortable = TRUE; // Allow sort
		$this->plan_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['plan_week'] = &$this->plan_week;

		// dispatch_date
		$this->dispatch_date = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_dispatch_date', 'dispatch_date', '`dispatch_date`', '`dispatch_date`', 18, 2, FALSE, '`dispatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->dispatch_date->Required = TRUE; // Required field
		$this->dispatch_date->Sortable = TRUE; // Allow sort
		$this->dispatch_date->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->dispatch_date->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->dispatch_date->Lookup = new Lookup('dispatch_date', 'not_week', FALSE, 'id', ["week","","",""], [], [], [], [], [], [], '`week` ASC', '');
		$this->dispatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dispatch_date'] = &$this->dispatch_date;

		// loom_no
		$this->loom_no = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_loom_no', 'loom_no', '`loom_no`', '`loom_no`', 18, -1, FALSE, '`loom_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->loom_no->Sortable = TRUE; // Allow sort
		$this->loom_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->loom_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->loom_no->Lookup = new Lookup('loom_no', 'loom_info', FALSE, 'id', ["id","item","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->loom_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['loom_no'] = &$this->loom_no;

		// id
		$this->id = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = FALSE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// buyers_id
		$this->buyers_id = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 19, -1, FALSE, '`buyers_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyers_id->Sortable = TRUE; // Allow sort
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// design_size
		$this->design_size = new DbField('job_card_pending_query', 'job_card_pending_query', 'x_design_size', 'design_size', '`design_size`', '`design_size`', 200, -1, FALSE, '`design_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design_size->Sortable = TRUE; // Allow sort
		$this->fields['design_size'] = &$this->design_size;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`job_card_pending_query`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Site()  == 0)? "" : "FIND_IN_SET(`works`, " . User_Site() . ")";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`pending_days` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->works->DbValue = $row['works'];
		$this->po->DbValue = $row['po'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->datetime->DbValue = $row['datetime'];
		$this->emp_name->DbValue = $row['emp_name'];
		$this->tqty->DbValue = $row['tqty'];
		$this->count->DbValue = $row['count'];
		$this->tsqm->DbValue = $row['tsqm'];
		$this->psqm->DbValue = $row['psqm'];
		$this->pending_days->DbValue = $row['pending_days'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->plan_week->DbValue = $row['plan_week'];
		$this->dispatch_date->DbValue = $row['dispatch_date'];
		$this->loom_no->DbValue = $row['loom_no'];
		$this->id->DbValue = $row['id'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->design_size->DbValue = $row['design_size'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "job_card_pending_querylist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "job_card_pending_queryview.php")
			return $Language->phrase("View");
		elseif ($pageName == "job_card_pending_queryedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "job_card_pending_queryadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "job_card_pending_querylist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("job_card_pending_queryview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("job_card_pending_queryview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "job_card_pending_queryadd.php?" . $this->getUrlParm($parm);
		else
			$url = "job_card_pending_queryadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("job_card_pending_queryedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("job_card_pending_queryadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("job_card_pending_querydelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->works->setDbValue($rs->fields('works'));
		$this->po->setDbValue($rs->fields('po'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->emp_name->setDbValue($rs->fields('emp_name'));
		$this->tqty->setDbValue($rs->fields('tqty'));
		$this->count->setDbValue($rs->fields('count'));
		$this->tsqm->setDbValue($rs->fields('tsqm'));
		$this->psqm->setDbValue($rs->fields('psqm'));
		$this->pending_days->setDbValue($rs->fields('pending_days'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->plan_week->setDbValue($rs->fields('plan_week'));
		$this->dispatch_date->setDbValue($rs->fields('dispatch_date'));
		$this->loom_no->setDbValue($rs->fields('loom_no'));
		$this->id->setDbValue($rs->fields('id'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->design_size->setDbValue($rs->fields('design_size'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// works
		// po
		// jc_no
		// datetime
		// emp_name
		// tqty
		// count
		// tsqm
		// psqm
		// pending_days
		// barcode
		// plan_week
		// dispatch_date
		// loom_no
		// id

		$this->id->CellCssStyle = "white-space: nowrap;";

		// buyers_id
		// design_size
		// works

		$curVal = strval($this->works->CurrentValue);
		if ($curVal <> "") {
			$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
			if ($this->works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->works->ViewValue = $this->works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->works->ViewValue = $this->works->CurrentValue;
				}
			}
		} else {
			$this->works->ViewValue = NULL;
		}
		$this->works->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
		$this->jc_no->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 2);
		$this->datetime->ViewCustomAttributes = "";

		// emp_name
		$curVal = strval($this->emp_name->CurrentValue);
		if ($curVal <> "") {
			$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
			if ($this->emp_name->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->emp_name->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->emp_name->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->emp_name->ViewValue->add($this->emp_name->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
				}
			}
		} else {
			$this->emp_name->ViewValue = NULL;
		}
		$this->emp_name->ViewCustomAttributes = "";

		// tqty
		$this->tqty->ViewValue = $this->tqty->CurrentValue;
		$this->tqty->ViewValue = FormatNumber($this->tqty->ViewValue, 0, -2, -2, -2);
		$this->tqty->ViewCustomAttributes = "";

		// count
		$this->count->ViewValue = $this->count->CurrentValue;
		$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
		$this->count->ViewCustomAttributes = "";

		// tsqm
		$this->tsqm->ViewValue = $this->tsqm->CurrentValue;
		$this->tsqm->ViewValue = FormatNumber($this->tsqm->ViewValue, 2, -2, -2, -2);
		$this->tsqm->ViewCustomAttributes = "";

		// psqm
		$this->psqm->ViewValue = $this->psqm->CurrentValue;
		$this->psqm->ViewValue = FormatNumber($this->psqm->ViewValue, 2, -2, -2, -2);
		$this->psqm->ViewCustomAttributes = "";

		// pending_days
		$this->pending_days->ViewValue = $this->pending_days->CurrentValue;
		$this->pending_days->ViewValue = FormatNumber($this->pending_days->ViewValue, 0, -2, -2, -2);
		$this->pending_days->ViewCustomAttributes = "";

		// barcode
		$curVal = strval($this->_barcode->CurrentValue);
		if ($curVal <> "") {
			$this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
			if ($this->_barcode->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`barcode`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->_barcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->_barcode->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
				}
			}
		} else {
			$this->_barcode->ViewValue = NULL;
		}
		$this->_barcode->ViewCustomAttributes = "";

		// plan_week
		$this->plan_week->ViewValue = $this->plan_week->CurrentValue;
		$this->plan_week->ViewValue = FormatNumber($this->plan_week->ViewValue, 0, -2, -2, -2);
		$this->plan_week->ViewCustomAttributes = "";

		// dispatch_date
		$curVal = strval($this->dispatch_date->CurrentValue);
		if ($curVal <> "") {
			$this->dispatch_date->ViewValue = $this->dispatch_date->lookupCacheOption($curVal);
			if ($this->dispatch_date->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->dispatch_date->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->dispatch_date->ViewValue = $this->dispatch_date->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->dispatch_date->ViewValue = $this->dispatch_date->CurrentValue;
				}
			}
		} else {
			$this->dispatch_date->ViewValue = NULL;
		}
		$this->dispatch_date->ViewCustomAttributes = "";

		// loom_no
		$curVal = strval($this->loom_no->CurrentValue);
		if ($curVal <> "") {
			$this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
			if ($this->loom_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->loom_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->loom_no->ViewValue = $this->loom_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->loom_no->ViewValue = $this->loom_no->CurrentValue;
				}
			}
		} else {
			$this->loom_no->ViewValue = NULL;
		}
		$this->loom_no->ViewCustomAttributes = "";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// buyers_id
		$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
		$this->buyers_id->ViewValue = FormatNumber($this->buyers_id->ViewValue, 0, -2, -2, -2);
		$this->buyers_id->ViewCustomAttributes = "";

		// design_size
		$this->design_size->ViewValue = $this->design_size->CurrentValue;
		$this->design_size->ViewCustomAttributes = "";

		// works
		$this->works->LinkCustomAttributes = "";
		$this->works->HrefValue = "";
		$this->works->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->jc_no->CurrentValue)) {
			$this->jc_no->HrefValue = "print_job_card_bc.php?id=0&jc=" . $this->jc_no->CurrentValue; // Add prefix/suffix
			$this->jc_no->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->jc_no->HrefValue = FullUrl($this->jc_no->HrefValue, "href");
		} else {
			$this->jc_no->HrefValue = "";
		}
		$this->jc_no->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// emp_name
		$this->emp_name->LinkCustomAttributes = "";
		$this->emp_name->HrefValue = "";
		$this->emp_name->TooltipValue = "";

		// tqty
		$this->tqty->LinkCustomAttributes = "";
		$this->tqty->HrefValue = "";
		$this->tqty->TooltipValue = "";

		// count
		$this->count->LinkCustomAttributes = "";
		$this->count->HrefValue = "";
		$this->count->TooltipValue = "";

		// tsqm
		$this->tsqm->LinkCustomAttributes = "";
		$this->tsqm->HrefValue = "";
		$this->tsqm->TooltipValue = "";

		// psqm
		$this->psqm->LinkCustomAttributes = "";
		$this->psqm->HrefValue = "";
		$this->psqm->TooltipValue = "";

		// pending_days
		$this->pending_days->LinkCustomAttributes = "";
		$this->pending_days->HrefValue = "";
		$this->pending_days->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// plan_week
		$this->plan_week->LinkCustomAttributes = "";
		$this->plan_week->HrefValue = "";
		$this->plan_week->TooltipValue = "";

		// dispatch_date
		$this->dispatch_date->LinkCustomAttributes = "";
		$this->dispatch_date->HrefValue = "";
		$this->dispatch_date->TooltipValue = "";

		// loom_no
		$this->loom_no->LinkCustomAttributes = "";
		$this->loom_no->HrefValue = "";
		$this->loom_no->TooltipValue = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		$this->buyers_id->HrefValue = "";
		$this->buyers_id->TooltipValue = "";

		// design_size
		$this->design_size->LinkCustomAttributes = "";
		$this->design_size->HrefValue = "";
		$this->design_size->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// works
		$this->works->EditAttrs["class"] = "form-control";
		$this->works->EditCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// datetime
		$this->datetime->EditAttrs["class"] = "form-control";
		$this->datetime->EditCustomAttributes = "";
		$this->datetime->EditValue = $this->datetime->CurrentValue;
		$this->datetime->EditValue = FormatDateTime($this->datetime->EditValue, 2);
		$this->datetime->ViewCustomAttributes = "";

		// emp_name
		$this->emp_name->EditAttrs["class"] = "form-control";
		$this->emp_name->EditCustomAttributes = "";

		// tqty
		$this->tqty->EditAttrs["class"] = "form-control";
		$this->tqty->EditCustomAttributes = "";
		$this->tqty->EditValue = $this->tqty->CurrentValue;
		$this->tqty->PlaceHolder = RemoveHtml($this->tqty->caption());

		// count
		$this->count->EditAttrs["class"] = "form-control";
		$this->count->EditCustomAttributes = "";
		$this->count->EditValue = $this->count->CurrentValue;
		$this->count->PlaceHolder = RemoveHtml($this->count->caption());

		// tsqm
		$this->tsqm->EditAttrs["class"] = "form-control";
		$this->tsqm->EditCustomAttributes = "";
		$this->tsqm->EditValue = $this->tsqm->CurrentValue;
		$this->tsqm->PlaceHolder = RemoveHtml($this->tsqm->caption());
		if (strval($this->tsqm->EditValue) <> "" && is_numeric($this->tsqm->EditValue))
			$this->tsqm->EditValue = FormatNumber($this->tsqm->EditValue, -2, -2, -2, -2);

		// psqm
		$this->psqm->EditAttrs["class"] = "form-control";
		$this->psqm->EditCustomAttributes = "";
		$this->psqm->EditValue = $this->psqm->CurrentValue;
		$this->psqm->PlaceHolder = RemoveHtml($this->psqm->caption());
		if (strval($this->psqm->EditValue) <> "" && is_numeric($this->psqm->EditValue))
			$this->psqm->EditValue = FormatNumber($this->psqm->EditValue, -2, -2, -2, -2);

		// pending_days
		$this->pending_days->EditAttrs["class"] = "form-control";
		$this->pending_days->EditCustomAttributes = "";
		$this->pending_days->EditValue = $this->pending_days->CurrentValue;
		$this->pending_days->PlaceHolder = RemoveHtml($this->pending_days->caption());

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$curVal = strval($this->_barcode->CurrentValue);
		if ($curVal <> "") {
			$this->_barcode->EditValue = $this->_barcode->lookupCacheOption($curVal);
			if ($this->_barcode->EditValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`barcode`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->_barcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->_barcode->EditValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->_barcode->EditValue->add($this->_barcode->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->_barcode->EditValue = $this->_barcode->CurrentValue;
				}
			}
		} else {
			$this->_barcode->EditValue = NULL;
		}
		$this->_barcode->ViewCustomAttributes = "";

		// plan_week
		$this->plan_week->EditAttrs["class"] = "form-control";
		$this->plan_week->EditCustomAttributes = "";
		$this->plan_week->EditValue = $this->plan_week->CurrentValue;
		$this->plan_week->PlaceHolder = RemoveHtml($this->plan_week->caption());

		// dispatch_date
		$this->dispatch_date->EditAttrs["class"] = "form-control";
		$this->dispatch_date->EditCustomAttributes = "";

		// loom_no
		$this->loom_no->EditAttrs["class"] = "form-control";
		$this->loom_no->EditCustomAttributes = "";

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";
		$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
		$this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

		// design_size
		$this->design_size->EditAttrs["class"] = "form-control";
		$this->design_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design_size->CurrentValue = HtmlDecode($this->design_size->CurrentValue);
		$this->design_size->EditValue = $this->design_size->CurrentValue;
		$this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->tqty->CurrentValue))
				$this->tqty->Total += $this->tqty->CurrentValue; // Accumulate total
			if (is_numeric($this->count->CurrentValue))
				$this->count->Total += $this->count->CurrentValue; // Accumulate total
			if (is_numeric($this->tsqm->CurrentValue))
				$this->tsqm->Total += $this->tsqm->CurrentValue; // Accumulate total
			if (is_numeric($this->psqm->CurrentValue))
				$this->psqm->Total += $this->psqm->CurrentValue; // Accumulate total
			$this->pending_days->Count++; // Increment count
			if (is_numeric($this->pending_days->CurrentValue))
				$this->pending_days->Total += $this->pending_days->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->tqty->CurrentValue = $this->tqty->Total;
			$this->tqty->ViewValue = $this->tqty->CurrentValue;
			$this->tqty->ViewValue = FormatNumber($this->tqty->ViewValue, 0, -2, -2, -2);
			$this->tqty->ViewCustomAttributes = "";
			$this->tqty->HrefValue = ""; // Clear href value
			$this->count->CurrentValue = $this->count->Total;
			$this->count->ViewValue = $this->count->CurrentValue;
			$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
			$this->count->ViewCustomAttributes = "";
			$this->count->HrefValue = ""; // Clear href value
			$this->tsqm->CurrentValue = $this->tsqm->Total;
			$this->tsqm->ViewValue = $this->tsqm->CurrentValue;
			$this->tsqm->ViewValue = FormatNumber($this->tsqm->ViewValue, 2, -2, -2, -2);
			$this->tsqm->ViewCustomAttributes = "";
			$this->tsqm->HrefValue = ""; // Clear href value
			$this->psqm->CurrentValue = $this->psqm->Total;
			$this->psqm->ViewValue = $this->psqm->CurrentValue;
			$this->psqm->ViewValue = FormatNumber($this->psqm->ViewValue, 2, -2, -2, -2);
			$this->psqm->ViewCustomAttributes = "";
			$this->psqm->HrefValue = ""; // Clear href value
			if ($this->pending_days->Count > 0) {
				$this->pending_days->CurrentValue = $this->pending_days->Total / $this->pending_days->Count;
			}
			$this->pending_days->ViewValue = $this->pending_days->CurrentValue;
			$this->pending_days->ViewValue = FormatNumber($this->pending_days->ViewValue, 0, -2, -2, -2);
			$this->pending_days->ViewCustomAttributes = "";
			$this->pending_days->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->works);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->emp_name);
					$doc->exportCaption($this->tqty);
					$doc->exportCaption($this->count);
					$doc->exportCaption($this->tsqm);
					$doc->exportCaption($this->psqm);
					$doc->exportCaption($this->pending_days);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->plan_week);
					$doc->exportCaption($this->dispatch_date);
					$doc->exportCaption($this->loom_no);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->design_size);
				} else {
					$doc->exportCaption($this->works);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->emp_name);
					$doc->exportCaption($this->tqty);
					$doc->exportCaption($this->count);
					$doc->exportCaption($this->tsqm);
					$doc->exportCaption($this->psqm);
					$doc->exportCaption($this->pending_days);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->plan_week);
					$doc->exportCaption($this->dispatch_date);
					$doc->exportCaption($this->loom_no);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->design_size);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->works);
						$doc->exportField($this->po);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->datetime);
						$doc->exportField($this->emp_name);
						$doc->exportField($this->tqty);
						$doc->exportField($this->count);
						$doc->exportField($this->tsqm);
						$doc->exportField($this->psqm);
						$doc->exportField($this->pending_days);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->plan_week);
						$doc->exportField($this->dispatch_date);
						$doc->exportField($this->loom_no);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->design_size);
					} else {
						$doc->exportField($this->works);
						$doc->exportField($this->po);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->datetime);
						$doc->exportField($this->emp_name);
						$doc->exportField($this->tqty);
						$doc->exportField($this->count);
						$doc->exportField($this->tsqm);
						$doc->exportField($this->psqm);
						$doc->exportField($this->pending_days);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->plan_week);
						$doc->exportField($this->dispatch_date);
						$doc->exportField($this->loom_no);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->design_size);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->works, '');
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->jc_no, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->exportAggregate($this->emp_name, '');
				$doc->exportAggregate($this->tqty, 'TOTAL');
				$doc->exportAggregate($this->count, 'TOTAL');
				$doc->exportAggregate($this->tsqm, 'TOTAL');
				$doc->exportAggregate($this->psqm, 'TOTAL');
				$doc->exportAggregate($this->pending_days, 'AVERAGE');
				$doc->exportAggregate($this->_barcode, '');
				$doc->exportAggregate($this->plan_week, '');
				$doc->exportAggregate($this->dispatch_date, '');
				$doc->exportAggregate($this->loom_no, '');
				$doc->exportAggregate($this->buyers_id, '');
				$doc->exportAggregate($this->design_size, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>