<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class job_card_pending_query_search extends job_card_pending_query
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'job_card_pending_query';

	// Page object name
	public $PageObjName = "job_card_pending_query_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (job_card_pending_query)
		if (!isset($GLOBALS["job_card_pending_query"]) || get_class($GLOBALS["job_card_pending_query"]) == PROJECT_NAMESPACE . "job_card_pending_query") {
			$GLOBALS["job_card_pending_query"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["job_card_pending_query"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card_pending_query');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $job_card_pending_query;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($job_card_pending_query);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "job_card_pending_queryview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("job_card_pending_querylist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->works->setVisibility();
		$this->po->setVisibility();
		$this->jc_no->setVisibility();
		$this->datetime->setVisibility();
		$this->emp_name->setVisibility();
		$this->tqty->setVisibility();
		$this->count->setVisibility();
		$this->tsqm->setVisibility();
		$this->psqm->setVisibility();
		$this->pending_days->setVisibility();
		$this->_barcode->setVisibility();
		$this->plan_week->setVisibility();
		$this->dispatch_date->setVisibility();
		$this->loom_no->setVisibility();
		$this->id->Visible = FALSE;
		$this->buyers_id->setVisibility();
		$this->design_size->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->works);
		$this->setupLookupOptions($this->emp_name);
		$this->setupLookupOptions($this->_barcode);
		$this->setupLookupOptions($this->dispatch_date);
		$this->setupLookupOptions($this->loom_no);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "job_card_pending_querylist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->works); // works
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->emp_name); // emp_name
		$this->buildSearchUrl($srchUrl, $this->tqty); // tqty
		$this->buildSearchUrl($srchUrl, $this->count); // count
		$this->buildSearchUrl($srchUrl, $this->tsqm); // tsqm
		$this->buildSearchUrl($srchUrl, $this->psqm); // psqm
		$this->buildSearchUrl($srchUrl, $this->pending_days); // pending_days
		$this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
		$this->buildSearchUrl($srchUrl, $this->plan_week); // plan_week
		$this->buildSearchUrl($srchUrl, $this->dispatch_date); // dispatch_date
		$this->buildSearchUrl($srchUrl, $this->loom_no); // loom_no
		$this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
		$this->buildSearchUrl($srchUrl, $this->design_size); // design_size
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// works

		if (!$this->isAddOrEdit())
			$this->works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_works"));
		$this->works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_works"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_no"));
		$this->jc_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_no"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// emp_name
		if (!$this->isAddOrEdit())
			$this->emp_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_emp_name"));
		$this->emp_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_emp_name"));
		if (is_array($this->emp_name->AdvancedSearch->SearchValue))
			$this->emp_name->AdvancedSearch->SearchValue = implode(",", $this->emp_name->AdvancedSearch->SearchValue);
		if (is_array($this->emp_name->AdvancedSearch->SearchValue2))
			$this->emp_name->AdvancedSearch->SearchValue2 = implode(",", $this->emp_name->AdvancedSearch->SearchValue2);

		// tqty
		if (!$this->isAddOrEdit())
			$this->tqty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_tqty"));
		$this->tqty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_tqty"));

		// count
		if (!$this->isAddOrEdit())
			$this->count->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_count"));
		$this->count->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_count"));

		// tsqm
		if (!$this->isAddOrEdit())
			$this->tsqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_tsqm"));
		$this->tsqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_tsqm"));

		// psqm
		if (!$this->isAddOrEdit())
			$this->psqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_psqm"));
		$this->psqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_psqm"));

		// pending_days
		if (!$this->isAddOrEdit())
			$this->pending_days->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pending_days"));
		$this->pending_days->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pending_days"));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__barcode"));
		if (is_array($this->_barcode->AdvancedSearch->SearchValue))
			$this->_barcode->AdvancedSearch->SearchValue = implode(",", $this->_barcode->AdvancedSearch->SearchValue);
		if (is_array($this->_barcode->AdvancedSearch->SearchValue2))
			$this->_barcode->AdvancedSearch->SearchValue2 = implode(",", $this->_barcode->AdvancedSearch->SearchValue2);

		// plan_week
		if (!$this->isAddOrEdit())
			$this->plan_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_plan_week"));
		$this->plan_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_plan_week"));

		// dispatch_date
		if (!$this->isAddOrEdit())
			$this->dispatch_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dispatch_date"));
		$this->dispatch_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dispatch_date"));

		// loom_no
		if (!$this->isAddOrEdit())
			$this->loom_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_loom_no"));
		$this->loom_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_loom_no"));

		// buyers_id
		if (!$this->isAddOrEdit())
			$this->buyers_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyers_id"));
		$this->buyers_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyers_id"));

		// design_size
		if (!$this->isAddOrEdit())
			$this->design_size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design_size"));
		$this->design_size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design_size"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->tsqm->FormValue == $this->tsqm->CurrentValue && is_numeric(ConvertToFloatString($this->tsqm->CurrentValue)))
			$this->tsqm->CurrentValue = ConvertToFloatString($this->tsqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->psqm->FormValue == $this->psqm->CurrentValue && is_numeric(ConvertToFloatString($this->psqm->CurrentValue)))
			$this->psqm->CurrentValue = ConvertToFloatString($this->psqm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// works
		// po
		// jc_no
		// datetime
		// emp_name
		// tqty
		// count
		// tsqm
		// psqm
		// pending_days
		// barcode
		// plan_week
		// dispatch_date
		// loom_no
		// id
		// buyers_id
		// design_size

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// works
			$curVal = strval($this->works->CurrentValue);
			if ($curVal <> "") {
				$this->works->ViewValue = $this->works->lookupCacheOption($curVal);
				if ($this->works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->works->ViewValue = $this->works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->works->ViewValue = $this->works->CurrentValue;
					}
				}
			} else {
				$this->works->ViewValue = NULL;
			}
			$this->works->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 2);
			$this->datetime->ViewCustomAttributes = "";

			// emp_name
			$curVal = strval($this->emp_name->CurrentValue);
			if ($curVal <> "") {
				$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
				if ($this->emp_name->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->emp_name->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->emp_name->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->emp_name->ViewValue->add($this->emp_name->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
					}
				}
			} else {
				$this->emp_name->ViewValue = NULL;
			}
			$this->emp_name->ViewCustomAttributes = "";

			// tqty
			$this->tqty->ViewValue = $this->tqty->CurrentValue;
			$this->tqty->ViewValue = FormatNumber($this->tqty->ViewValue, 0, -2, -2, -2);
			$this->tqty->ViewCustomAttributes = "";

			// count
			$this->count->ViewValue = $this->count->CurrentValue;
			$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
			$this->count->ViewCustomAttributes = "";

			// tsqm
			$this->tsqm->ViewValue = $this->tsqm->CurrentValue;
			$this->tsqm->ViewValue = FormatNumber($this->tsqm->ViewValue, 2, -2, -2, -2);
			$this->tsqm->ViewCustomAttributes = "";

			// psqm
			$this->psqm->ViewValue = $this->psqm->CurrentValue;
			$this->psqm->ViewValue = FormatNumber($this->psqm->ViewValue, 2, -2, -2, -2);
			$this->psqm->ViewCustomAttributes = "";

			// pending_days
			$this->pending_days->ViewValue = $this->pending_days->CurrentValue;
			$this->pending_days->ViewValue = FormatNumber($this->pending_days->ViewValue, 0, -2, -2, -2);
			$this->pending_days->ViewCustomAttributes = "";

			// barcode
			$curVal = strval($this->_barcode->CurrentValue);
			if ($curVal <> "") {
				$this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
				if ($this->_barcode->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`barcode`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->_barcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->_barcode->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
					}
				}
			} else {
				$this->_barcode->ViewValue = NULL;
			}
			$this->_barcode->ViewCustomAttributes = "";

			// plan_week
			$this->plan_week->ViewValue = $this->plan_week->CurrentValue;
			$this->plan_week->ViewValue = FormatNumber($this->plan_week->ViewValue, 0, -2, -2, -2);
			$this->plan_week->ViewCustomAttributes = "";

			// dispatch_date
			$curVal = strval($this->dispatch_date->CurrentValue);
			if ($curVal <> "") {
				$this->dispatch_date->ViewValue = $this->dispatch_date->lookupCacheOption($curVal);
				if ($this->dispatch_date->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dispatch_date->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->dispatch_date->ViewValue = $this->dispatch_date->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dispatch_date->ViewValue = $this->dispatch_date->CurrentValue;
					}
				}
			} else {
				$this->dispatch_date->ViewValue = NULL;
			}
			$this->dispatch_date->ViewCustomAttributes = "";

			// loom_no
			$curVal = strval($this->loom_no->CurrentValue);
			if ($curVal <> "") {
				$this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
				if ($this->loom_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->loom_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->loom_no->ViewValue = $this->loom_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->loom_no->ViewValue = $this->loom_no->CurrentValue;
					}
				}
			} else {
				$this->loom_no->ViewValue = NULL;
			}
			$this->loom_no->ViewCustomAttributes = "";

			// buyers_id
			$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
			$this->buyers_id->ViewValue = FormatNumber($this->buyers_id->ViewValue, 0, -2, -2, -2);
			$this->buyers_id->ViewCustomAttributes = "";

			// design_size
			$this->design_size->ViewValue = $this->design_size->CurrentValue;
			$this->design_size->ViewCustomAttributes = "";

			// works
			$this->works->LinkCustomAttributes = "";
			$this->works->HrefValue = "";
			$this->works->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->jc_no->CurrentValue)) {
				$this->jc_no->HrefValue = "print_job_card_bc.php?id=0&jc=" . $this->jc_no->CurrentValue; // Add prefix/suffix
				$this->jc_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->jc_no->HrefValue = FullUrl($this->jc_no->HrefValue, "href");
			} else {
				$this->jc_no->HrefValue = "";
			}
			$this->jc_no->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			$this->emp_name->HrefValue = "";
			$this->emp_name->TooltipValue = "";

			// tqty
			$this->tqty->LinkCustomAttributes = "";
			$this->tqty->HrefValue = "";
			$this->tqty->TooltipValue = "";

			// count
			$this->count->LinkCustomAttributes = "";
			$this->count->HrefValue = "";
			$this->count->TooltipValue = "";

			// tsqm
			$this->tsqm->LinkCustomAttributes = "";
			$this->tsqm->HrefValue = "";
			$this->tsqm->TooltipValue = "";

			// psqm
			$this->psqm->LinkCustomAttributes = "";
			$this->psqm->HrefValue = "";
			$this->psqm->TooltipValue = "";

			// pending_days
			$this->pending_days->LinkCustomAttributes = "";
			$this->pending_days->HrefValue = "";
			$this->pending_days->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// plan_week
			$this->plan_week->LinkCustomAttributes = "";
			$this->plan_week->HrefValue = "";
			$this->plan_week->TooltipValue = "";

			// dispatch_date
			$this->dispatch_date->LinkCustomAttributes = "";
			$this->dispatch_date->HrefValue = "";
			$this->dispatch_date->TooltipValue = "";

			// loom_no
			$this->loom_no->LinkCustomAttributes = "";
			$this->loom_no->HrefValue = "";
			$this->loom_no->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			$this->buyers_id->HrefValue = "";
			$this->buyers_id->TooltipValue = "";

			// design_size
			$this->design_size->LinkCustomAttributes = "";
			$this->design_size->HrefValue = "";
			$this->design_size->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// works
			$this->works->EditAttrs["class"] = "form-control";
			$this->works->EditCustomAttributes = "";
			$curVal = trim(strval($this->works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->works->AdvancedSearch->ViewValue = $this->works->lookupCacheOption($curVal);
			else
				$this->works->AdvancedSearch->ViewValue = $this->works->Lookup !== NULL && is_array($this->works->Lookup->Options) ? $curVal : NULL;
			if ($this->works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->works->EditValue = array_values($this->works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->works->EditValue = $arwrk;
			}

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 2), 2));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// emp_name
			$this->emp_name->EditAttrs["class"] = "form-control";
			$this->emp_name->EditCustomAttributes = "";
			$curVal = trim(strval($this->emp_name->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->emp_name->AdvancedSearch->ViewValue = $this->emp_name->lookupCacheOption($curVal);
			else
				$this->emp_name->AdvancedSearch->ViewValue = $this->emp_name->Lookup !== NULL && is_array($this->emp_name->Lookup->Options) ? $curVal : NULL;
			if ($this->emp_name->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->emp_name->EditValue = array_values($this->emp_name->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->emp_name->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->emp_name->EditValue = $arwrk;
			}

			// tqty
			$this->tqty->EditAttrs["class"] = "form-control";
			$this->tqty->EditCustomAttributes = "";
			$this->tqty->EditValue = HtmlEncode($this->tqty->AdvancedSearch->SearchValue);
			$this->tqty->PlaceHolder = RemoveHtml($this->tqty->caption());

			// count
			$this->count->EditAttrs["class"] = "form-control";
			$this->count->EditCustomAttributes = "";
			$this->count->EditValue = HtmlEncode($this->count->AdvancedSearch->SearchValue);
			$this->count->PlaceHolder = RemoveHtml($this->count->caption());

			// tsqm
			$this->tsqm->EditAttrs["class"] = "form-control";
			$this->tsqm->EditCustomAttributes = "";
			$this->tsqm->EditValue = HtmlEncode($this->tsqm->AdvancedSearch->SearchValue);
			$this->tsqm->PlaceHolder = RemoveHtml($this->tsqm->caption());

			// psqm
			$this->psqm->EditAttrs["class"] = "form-control";
			$this->psqm->EditCustomAttributes = "";
			$this->psqm->EditValue = HtmlEncode($this->psqm->AdvancedSearch->SearchValue);
			$this->psqm->PlaceHolder = RemoveHtml($this->psqm->caption());

			// pending_days
			$this->pending_days->EditAttrs["class"] = "form-control";
			$this->pending_days->EditCustomAttributes = "";
			$this->pending_days->EditValue = HtmlEncode($this->pending_days->AdvancedSearch->SearchValue);
			$this->pending_days->PlaceHolder = RemoveHtml($this->pending_days->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$curVal = trim(strval($this->_barcode->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->_barcode->AdvancedSearch->ViewValue = $this->_barcode->lookupCacheOption($curVal);
			else
				$this->_barcode->AdvancedSearch->ViewValue = $this->_barcode->Lookup !== NULL && is_array($this->_barcode->Lookup->Options) ? $curVal : NULL;
			if ($this->_barcode->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->_barcode->EditValue = array_values($this->_barcode->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`barcode`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->_barcode->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->_barcode->EditValue = $arwrk;
			}

			// plan_week
			$this->plan_week->EditAttrs["class"] = "form-control";
			$this->plan_week->EditCustomAttributes = "";
			$this->plan_week->EditValue = HtmlEncode($this->plan_week->AdvancedSearch->SearchValue);
			$this->plan_week->PlaceHolder = RemoveHtml($this->plan_week->caption());

			// dispatch_date
			$this->dispatch_date->EditAttrs["class"] = "form-control";
			$this->dispatch_date->EditCustomAttributes = "";
			$curVal = trim(strval($this->dispatch_date->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->dispatch_date->AdvancedSearch->ViewValue = $this->dispatch_date->lookupCacheOption($curVal);
			else
				$this->dispatch_date->AdvancedSearch->ViewValue = $this->dispatch_date->Lookup !== NULL && is_array($this->dispatch_date->Lookup->Options) ? $curVal : NULL;
			if ($this->dispatch_date->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->dispatch_date->EditValue = array_values($this->dispatch_date->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->dispatch_date->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->dispatch_date->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->dispatch_date->EditValue = $arwrk;
			}

			// loom_no
			$this->loom_no->EditAttrs["class"] = "form-control";
			$this->loom_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->loom_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->loom_no->AdvancedSearch->ViewValue = $this->loom_no->lookupCacheOption($curVal);
			else
				$this->loom_no->AdvancedSearch->ViewValue = $this->loom_no->Lookup !== NULL && is_array($this->loom_no->Lookup->Options) ? $curVal : NULL;
			if ($this->loom_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->loom_no->EditValue = array_values($this->loom_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->loom_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->loom_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->loom_no->EditValue = $arwrk;
			}

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";
			$this->buyers_id->EditValue = HtmlEncode($this->buyers_id->AdvancedSearch->SearchValue);
			$this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

			// design_size
			$this->design_size->EditAttrs["class"] = "form-control";
			$this->design_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design_size->AdvancedSearch->SearchValue = HtmlDecode($this->design_size->AdvancedSearch->SearchValue);
			$this->design_size->EditValue = HtmlEncode($this->design_size->AdvancedSearch->SearchValue);
			$this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->jc_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->jc_no->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->tqty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->tqty->errorMessage());
		}
		if (!CheckInteger($this->count->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->count->errorMessage());
		}
		if (!CheckNumber($this->tsqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->tsqm->errorMessage());
		}
		if (!CheckNumber($this->psqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->psqm->errorMessage());
		}
		if (!CheckInteger($this->pending_days->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending_days->errorMessage());
		}
		if (!CheckInteger($this->plan_week->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->plan_week->errorMessage());
		}
		if (!CheckInteger($this->buyers_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyers_id->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->works->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->emp_name->AdvancedSearch->load();
		$this->tqty->AdvancedSearch->load();
		$this->count->AdvancedSearch->load();
		$this->tsqm->AdvancedSearch->load();
		$this->psqm->AdvancedSearch->load();
		$this->pending_days->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->plan_week->AdvancedSearch->load();
		$this->dispatch_date->AdvancedSearch->load();
		$this->loom_no->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->design_size->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("job_card_pending_querylist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_emp_name":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_loom_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_works":
							break;
						case "x_emp_name":
							break;
						case "x__barcode":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_dispatch_date":
							break;
						case "x_loom_no":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>