<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for l_examination
 */
class l_examination extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $mobile;
	public $user;
	public $category;
	public $name;
	public $age;
	public $sex;
	public $referral;
	public $examination_grp;
	public $examination_type;
	public $total_amount;
	public $discount_percent;
	public $discount_amount;
	public $final_amount;
	public $remarks;
	public $operator;
	public $datetime;
	public $receipt;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'l_examination';
		$this->TableName = 'l_examination';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`l_examination`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('l_examination', 'l_examination', 'x_id', 'id', '`id`', '`id`', 3, 0, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['id'] = &$this->id;

		// mobile
		$this->mobile = new DbField('l_examination', 'l_examination', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 200, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Required = TRUE; // Required field
		$this->mobile->Sortable = TRUE; // Allow sort
		$this->mobile->Lookup = new Lookup('mobile', 'user', TRUE, 'mobile', ["mobile","","",""], [], ["x_name"], [], [], ["user_name","category"], ["x_user","x_category"], '`mobile` ASC', '');
		$this->fields['mobile'] = &$this->mobile;

		// user
		$this->user = new DbField('l_examination', 'l_examination', 'x_user', 'user', '`user`', '`user`', 18, -1, FALSE, '`user`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->user->Nullable = FALSE; // NOT NULL field
		$this->user->Required = TRUE; // Required field
		$this->user->Sortable = TRUE; // Allow sort
		$this->user->Lookup = new Lookup('user', 'user', TRUE, 'id', ["mobile","id","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['user'] = &$this->user;

		// category
		$this->category = new DbField('l_examination', 'l_examination', 'x_category', 'category', '`category`', '`category`', 17, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->category->Nullable = FALSE; // NOT NULL field
		$this->category->Sortable = TRUE; // Allow sort
		$this->category->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->category->Lookup = new Lookup('category', 'l_examination', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->category->OptionCount = 2;
		$this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['category'] = &$this->category;

		// name
		$this->name = new DbField('l_examination', 'l_examination', 'x_name', 'name', '`name`', '`name`', 200, -1, FALSE, '`name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name->Required = TRUE; // Required field
		$this->name->Sortable = TRUE; // Allow sort
		$this->name->Lookup = new Lookup('name', 'l_examination', TRUE, 'name', ["name","","",""], ["x_mobile"], [], ["mobile"], ["x_mobile"], ["mobile"], ["x_mobile"], '`name` ASC', '');
		$this->fields['name'] = &$this->name;

		// age
		$this->age = new DbField('l_examination', 'l_examination', 'x_age', 'age', '`age`', '`age`', 17, -1, FALSE, '`age`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->age->Nullable = FALSE; // NOT NULL field
		$this->age->Required = TRUE; // Required field
		$this->age->Sortable = TRUE; // Allow sort
		$this->age->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['age'] = &$this->age;

		// sex
		$this->sex = new DbField('l_examination', 'l_examination', 'x_sex', 'sex', '`sex`', '`sex`', 17, -1, FALSE, '`sex`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->sex->Nullable = FALSE; // NOT NULL field
		$this->sex->Required = TRUE; // Required field
		$this->sex->Sortable = TRUE; // Allow sort
		$this->sex->Lookup = new Lookup('sex', 'l_examination', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->sex->OptionCount = 3;
		$this->sex->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['sex'] = &$this->sex;

		// referral
		$this->referral = new DbField('l_examination', 'l_examination', 'x_referral', 'referral', '`referral`', '`referral`', 18, -1, FALSE, '`referral`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->referral->Sortable = TRUE; // Allow sort
		$this->referral->Lookup = new Lookup('referral', 'l_referral', FALSE, 'id', ["name","mobile","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->referral->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['referral'] = &$this->referral;

		// examination_grp
		$this->examination_grp = new DbField('l_examination', 'l_examination', 'x_examination_grp', 'examination_grp', '`examination_grp`', '`examination_grp`', 200, -1, FALSE, '`examination_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->examination_grp->Sortable = TRUE; // Allow sort
		$this->examination_grp->Lookup = new Lookup('examination_grp', 'l_examination_type', FALSE, 'id', ["name","","",""], [], ["x_examination_type[]"], [], [], [], [], '`name` ASC', '');
		$this->examination_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['examination_grp'] = &$this->examination_grp;

		// examination_type
		$this->examination_type = new DbField('l_examination', 'l_examination', 'x_examination_type', 'examination_type', '`examination_type`', '`examination_type`', 200, -1, FALSE, '`examination_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->examination_type->Nullable = FALSE; // NOT NULL field
		$this->examination_type->Required = TRUE; // Required field
		$this->examination_type->Sortable = TRUE; // Allow sort
		$this->examination_type->Lookup = new Lookup('examination_type', 'l_examination_type', FALSE, 'id', ["name","price","",""], ["x_examination_grp[]"], [], ["grp"], ["x_grp"], [], [], '`name` ASC', '');
		$this->fields['examination_type'] = &$this->examination_type;

		// total_amount
		$this->total_amount = new DbField('l_examination', 'l_examination', 'x_total_amount', 'total_amount', '`total_amount`', '`total_amount`', 131, -1, FALSE, '`total_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->total_amount->Nullable = FALSE; // NOT NULL field
		$this->total_amount->Required = TRUE; // Required field
		$this->total_amount->Sortable = TRUE; // Allow sort
		$this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['total_amount'] = &$this->total_amount;

		// discount_percent
		$this->discount_percent = new DbField('l_examination', 'l_examination', 'x_discount_percent', 'discount_percent', '`discount_percent`', '`discount_percent`', 131, -1, FALSE, '`discount_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->discount_percent->Nullable = FALSE; // NOT NULL field
		$this->discount_percent->Required = TRUE; // Required field
		$this->discount_percent->Sortable = TRUE; // Allow sort
		$this->discount_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['discount_percent'] = &$this->discount_percent;

		// discount_amount
		$this->discount_amount = new DbField('l_examination', 'l_examination', 'x_discount_amount', 'discount_amount', '`discount_amount`', '`discount_amount`', 131, -1, FALSE, '`discount_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->discount_amount->Nullable = FALSE; // NOT NULL field
		$this->discount_amount->Required = TRUE; // Required field
		$this->discount_amount->Sortable = TRUE; // Allow sort
		$this->discount_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['discount_amount'] = &$this->discount_amount;

		// final_amount
		$this->final_amount = new DbField('l_examination', 'l_examination', 'x_final_amount', 'final_amount', '`final_amount`', '`final_amount`', 131, -1, FALSE, '`final_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->final_amount->Nullable = FALSE; // NOT NULL field
		$this->final_amount->Required = TRUE; // Required field
		$this->final_amount->Sortable = TRUE; // Allow sort
		$this->final_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['final_amount'] = &$this->final_amount;

		// remarks
		$this->remarks = new DbField('l_examination', 'l_examination', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// operator
		$this->operator = new DbField('l_examination', 'l_examination', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('l_examination', 'l_examination', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// receipt
		$this->receipt = new DbField('l_examination', 'l_examination', 'x_receipt', 'receipt', '`receipt`', '`receipt`', 131, -1, FALSE, '`receipt`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->receipt->Nullable = FALSE; // NOT NULL field
		$this->receipt->Sortable = TRUE; // Allow sort
		$this->receipt->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['receipt'] = &$this->receipt;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`l_examination`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->mobile->DbValue = $row['mobile'];
		$this->user->DbValue = $row['user'];
		$this->category->DbValue = $row['category'];
		$this->name->DbValue = $row['name'];
		$this->age->DbValue = $row['age'];
		$this->sex->DbValue = $row['sex'];
		$this->referral->DbValue = $row['referral'];
		$this->examination_grp->DbValue = $row['examination_grp'];
		$this->examination_type->DbValue = $row['examination_type'];
		$this->total_amount->DbValue = $row['total_amount'];
		$this->discount_percent->DbValue = $row['discount_percent'];
		$this->discount_amount->DbValue = $row['discount_amount'];
		$this->final_amount->DbValue = $row['final_amount'];
		$this->remarks->DbValue = $row['remarks'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->receipt->DbValue = $row['receipt'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "l_examinationlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "l_examinationview.php")
			return $Language->phrase("View");
		elseif ($pageName == "l_examinationedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "l_examinationadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "l_examinationlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("l_examinationview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("l_examinationview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "l_examinationadd.php?" . $this->getUrlParm($parm);
		else
			$url = "l_examinationadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("l_examinationedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("l_examinationadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("l_examinationdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->user->setDbValue($rs->fields('user'));
		$this->category->setDbValue($rs->fields('category'));
		$this->name->setDbValue($rs->fields('name'));
		$this->age->setDbValue($rs->fields('age'));
		$this->sex->setDbValue($rs->fields('sex'));
		$this->referral->setDbValue($rs->fields('referral'));
		$this->examination_grp->setDbValue($rs->fields('examination_grp'));
		$this->examination_type->setDbValue($rs->fields('examination_type'));
		$this->total_amount->setDbValue($rs->fields('total_amount'));
		$this->discount_percent->setDbValue($rs->fields('discount_percent'));
		$this->discount_amount->setDbValue($rs->fields('discount_amount'));
		$this->final_amount->setDbValue($rs->fields('final_amount'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->receipt->setDbValue($rs->fields('receipt'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// mobile
		// user
		// category
		// name
		// age
		// sex
		// referral
		// examination_grp
		// examination_type
		// total_amount
		// discount_percent
		// discount_amount
		// final_amount
		// remarks
		// operator
		// datetime
		// receipt
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$curVal = strval($this->mobile->CurrentValue);
		if ($curVal <> "") {
			$this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
			if ($this->mobile->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`mobile`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->mobile->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->mobile->ViewValue = $this->mobile->CurrentValue;
				}
			}
		} else {
			$this->mobile->ViewValue = NULL;
		}
		$this->mobile->ViewCustomAttributes = "";

		// user
		$this->user->ViewValue = $this->user->CurrentValue;
		$curVal = strval($this->user->CurrentValue);
		if ($curVal <> "") {
			$this->user->ViewValue = $this->user->lookupCacheOption($curVal);
			if ($this->user->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->user->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->user->ViewValue = $this->user->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->user->ViewValue = $this->user->CurrentValue;
				}
			}
		} else {
			$this->user->ViewValue = NULL;
		}
		$this->user->ViewCustomAttributes = "";

		// category
		if (strval($this->category->CurrentValue) <> "") {
			$this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
		} else {
			$this->category->ViewValue = NULL;
		}
		$this->category->ViewCustomAttributes = "";

		// name
		$this->name->ViewValue = $this->name->CurrentValue;
		$arwrk = array();
		$arwrk[1] = $this->name->CurrentValue;
		$this->name->ViewValue = $this->name->displayValue($arwrk);
		$this->name->ViewCustomAttributes = "";

		// age
		$this->age->ViewValue = $this->age->CurrentValue;
		$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
		$this->age->ViewCustomAttributes = "";

		// sex
		if (strval($this->sex->CurrentValue) <> "") {
			$this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
		} else {
			$this->sex->ViewValue = NULL;
		}
		$this->sex->ViewCustomAttributes = "";

		// referral
		$this->referral->ViewValue = $this->referral->CurrentValue;
		$curVal = strval($this->referral->CurrentValue);
		if ($curVal <> "") {
			$this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
			if ($this->referral->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->referral->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
					$this->referral->ViewValue = $this->referral->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->referral->ViewValue = $this->referral->CurrentValue;
				}
			}
		} else {
			$this->referral->ViewValue = NULL;
		}
		$this->referral->ViewCustomAttributes = "";

		// examination_grp
		$curVal = strval($this->examination_grp->CurrentValue);
		if ($curVal <> "") {
			$this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
			if ($this->examination_grp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->examination_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->examination_grp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->examination_grp->ViewValue->add($this->examination_grp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->examination_grp->ViewValue = $this->examination_grp->CurrentValue;
				}
			}
		} else {
			$this->examination_grp->ViewValue = NULL;
		}
		$this->examination_grp->ViewCustomAttributes = "";

		// examination_type
		$curVal = strval($this->examination_type->CurrentValue);
		if ($curVal <> "") {
			$this->examination_type->ViewValue = $this->examination_type->lookupCacheOption($curVal);
			if ($this->examination_type->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->examination_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->examination_type->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$this->examination_type->ViewValue->add($this->examination_type->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->examination_type->ViewValue = $this->examination_type->CurrentValue;
				}
			}
		} else {
			$this->examination_type->ViewValue = NULL;
		}
		$this->examination_type->ViewCustomAttributes = "";

		// total_amount
		$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
		$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
		$this->total_amount->ViewCustomAttributes = "";

		// discount_percent
		$this->discount_percent->ViewValue = $this->discount_percent->CurrentValue;
		$this->discount_percent->ViewValue = FormatNumber($this->discount_percent->ViewValue, 2, -1, 0, 0);
		$this->discount_percent->ViewCustomAttributes = "";

		// discount_amount
		$this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
		$this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, 2, -1, 0, 0);
		$this->discount_amount->ViewCustomAttributes = "";

		// final_amount
		$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
		$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
		$this->final_amount->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// receipt
		$this->receipt->ViewValue = $this->receipt->CurrentValue;
		$this->receipt->ViewValue = FormatNumber($this->receipt->ViewValue, 2, -2, -2, -2);
		$this->receipt->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// user
		$this->user->LinkCustomAttributes = "";
		$this->user->HrefValue = "";
		$this->user->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// name
		$this->name->LinkCustomAttributes = "";
		$this->name->HrefValue = "";
		$this->name->TooltipValue = "";

		// age
		$this->age->LinkCustomAttributes = "";
		$this->age->HrefValue = "";
		$this->age->TooltipValue = "";

		// sex
		$this->sex->LinkCustomAttributes = "";
		$this->sex->HrefValue = "";
		$this->sex->TooltipValue = "";

		// referral
		$this->referral->LinkCustomAttributes = "";
		$this->referral->HrefValue = "";
		$this->referral->TooltipValue = "";

		// examination_grp
		$this->examination_grp->LinkCustomAttributes = "";
		$this->examination_grp->HrefValue = "";
		$this->examination_grp->TooltipValue = "";

		// examination_type
		$this->examination_type->LinkCustomAttributes = "";
		$this->examination_type->HrefValue = "";
		$this->examination_type->TooltipValue = "";

		// total_amount
		$this->total_amount->LinkCustomAttributes = "";
		$this->total_amount->HrefValue = "";
		$this->total_amount->TooltipValue = "";

		// discount_percent
		$this->discount_percent->LinkCustomAttributes = "";
		$this->discount_percent->HrefValue = "";
		$this->discount_percent->TooltipValue = "";

		// discount_amount
		$this->discount_amount->LinkCustomAttributes = "";
		$this->discount_amount->HrefValue = "";
		$this->discount_amount->TooltipValue = "";

		// final_amount
		$this->final_amount->LinkCustomAttributes = "";
		$this->final_amount->HrefValue = "";
		$this->final_amount->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// receipt
		$this->receipt->LinkCustomAttributes = "";
		$this->receipt->HrefValue = "";
		$this->receipt->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

		// user
		$this->user->EditAttrs["class"] = "form-control";
		$this->user->EditCustomAttributes = 'ReadOnly';
		$this->user->EditValue = $this->user->CurrentValue;
		$this->user->PlaceHolder = RemoveHtml($this->user->caption());

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";
		$this->category->EditValue = $this->category->options(TRUE);

		// name
		$this->name->EditAttrs["class"] = "form-control";
		$this->name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
		$this->name->EditValue = $this->name->CurrentValue;
		$this->name->PlaceHolder = RemoveHtml($this->name->caption());

		// age
		$this->age->EditAttrs["class"] = "form-control";
		$this->age->EditCustomAttributes = "";
		$this->age->EditValue = $this->age->CurrentValue;
		$this->age->PlaceHolder = RemoveHtml($this->age->caption());

		// sex
		$this->sex->EditCustomAttributes = "";
		$this->sex->EditValue = $this->sex->options(FALSE);

		// referral
		$this->referral->EditAttrs["class"] = "form-control";
		$this->referral->EditCustomAttributes = "";
		$this->referral->EditValue = $this->referral->CurrentValue;
		$this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

		// examination_grp
		$this->examination_grp->EditCustomAttributes = "";

		// examination_type
		$this->examination_type->EditCustomAttributes = "";

		// total_amount
		$this->total_amount->EditAttrs["class"] = "form-control";
		$this->total_amount->EditCustomAttributes = "";
		$this->total_amount->EditValue = $this->total_amount->CurrentValue;
		$this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());
		if (strval($this->total_amount->EditValue) <> "" && is_numeric($this->total_amount->EditValue))
			$this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, -2, -2, -2, -2);

		// discount_percent
		$this->discount_percent->EditAttrs["class"] = "form-control";
		$this->discount_percent->EditCustomAttributes = "";
		$this->discount_percent->EditValue = $this->discount_percent->CurrentValue;
		$this->discount_percent->PlaceHolder = RemoveHtml($this->discount_percent->caption());
		if (strval($this->discount_percent->EditValue) <> "" && is_numeric($this->discount_percent->EditValue))
			$this->discount_percent->EditValue = FormatNumber($this->discount_percent->EditValue, -2, -1, -2, 0);

		// discount_amount
		$this->discount_amount->EditAttrs["class"] = "form-control";
		$this->discount_amount->EditCustomAttributes = "";
		$this->discount_amount->EditValue = $this->discount_amount->CurrentValue;
		$this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());
		if (strval($this->discount_amount->EditValue) <> "" && is_numeric($this->discount_amount->EditValue))
			$this->discount_amount->EditValue = FormatNumber($this->discount_amount->EditValue, -2, -1, -2, 0);

		// final_amount
		$this->final_amount->EditAttrs["class"] = "form-control";
		$this->final_amount->EditCustomAttributes = 'ReadOnly';
		$this->final_amount->EditValue = $this->final_amount->CurrentValue;
		$this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());
		if (strval($this->final_amount->EditValue) <> "" && is_numeric($this->final_amount->EditValue))
			$this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, -2, -2, -2, -2);

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// operator
		// datetime
		// receipt

		$this->receipt->EditAttrs["class"] = "form-control";
		$this->receipt->EditCustomAttributes = "";
		$this->receipt->EditValue = $this->receipt->CurrentValue;
		$this->receipt->PlaceHolder = RemoveHtml($this->receipt->caption());
		if (strval($this->receipt->EditValue) <> "" && is_numeric($this->receipt->EditValue))
			$this->receipt->EditValue = FormatNumber($this->receipt->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->user);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->age);
					$doc->exportCaption($this->sex);
					$doc->exportCaption($this->referral);
					$doc->exportCaption($this->examination_grp);
					$doc->exportCaption($this->examination_type);
					$doc->exportCaption($this->total_amount);
					$doc->exportCaption($this->discount_percent);
					$doc->exportCaption($this->discount_amount);
					$doc->exportCaption($this->final_amount);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->receipt);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->user);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->age);
					$doc->exportCaption($this->sex);
					$doc->exportCaption($this->referral);
					$doc->exportCaption($this->examination_grp);
					$doc->exportCaption($this->examination_type);
					$doc->exportCaption($this->total_amount);
					$doc->exportCaption($this->discount_percent);
					$doc->exportCaption($this->discount_amount);
					$doc->exportCaption($this->final_amount);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->receipt);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->mobile);
						$doc->exportField($this->user);
						$doc->exportField($this->category);
						$doc->exportField($this->name);
						$doc->exportField($this->age);
						$doc->exportField($this->sex);
						$doc->exportField($this->referral);
						$doc->exportField($this->examination_grp);
						$doc->exportField($this->examination_type);
						$doc->exportField($this->total_amount);
						$doc->exportField($this->discount_percent);
						$doc->exportField($this->discount_amount);
						$doc->exportField($this->final_amount);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->receipt);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->mobile);
						$doc->exportField($this->user);
						$doc->exportField($this->category);
						$doc->exportField($this->name);
						$doc->exportField($this->age);
						$doc->exportField($this->sex);
						$doc->exportField($this->referral);
						$doc->exportField($this->examination_grp);
						$doc->exportField($this->examination_type);
						$doc->exportField($this->total_amount);
						$doc->exportField($this->discount_percent);
						$doc->exportField($this->discount_amount);
						$doc->exportField($this->final_amount);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->receipt);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>