<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class l_examination_search extends l_examination
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'l_examination';

	// Page object name
	public $PageObjName = "l_examination_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (l_examination)
		if (!isset($GLOBALS["l_examination"]) || get_class($GLOBALS["l_examination"]) == PROJECT_NAMESPACE . "l_examination") {
			$GLOBALS["l_examination"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["l_examination"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'l_examination');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $l_examination;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($l_examination);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "l_examinationview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("l_examinationlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->mobile->setVisibility();
		$this->user->setVisibility();
		$this->category->setVisibility();
		$this->name->setVisibility();
		$this->age->setVisibility();
		$this->sex->setVisibility();
		$this->referral->setVisibility();
		$this->examination_grp->setVisibility();
		$this->examination_type->setVisibility();
		$this->total_amount->setVisibility();
		$this->discount_percent->setVisibility();
		$this->discount_amount->setVisibility();
		$this->final_amount->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->receipt->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->mobile);
		$this->setupLookupOptions($this->user);
		$this->setupLookupOptions($this->name);
		$this->setupLookupOptions($this->referral);
		$this->setupLookupOptions($this->examination_grp);
		$this->setupLookupOptions($this->examination_type);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "l_examinationlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->mobile); // mobile
		$this->buildSearchUrl($srchUrl, $this->user); // user
		$this->buildSearchUrl($srchUrl, $this->category); // category
		$this->buildSearchUrl($srchUrl, $this->name); // name
		$this->buildSearchUrl($srchUrl, $this->age); // age
		$this->buildSearchUrl($srchUrl, $this->sex); // sex
		$this->buildSearchUrl($srchUrl, $this->referral); // referral
		$this->buildSearchUrl($srchUrl, $this->examination_grp); // examination_grp
		$this->buildSearchUrl($srchUrl, $this->examination_type); // examination_type
		$this->buildSearchUrl($srchUrl, $this->total_amount); // total_amount
		$this->buildSearchUrl($srchUrl, $this->discount_percent); // discount_percent
		$this->buildSearchUrl($srchUrl, $this->discount_amount); // discount_amount
		$this->buildSearchUrl($srchUrl, $this->final_amount); // final_amount
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->receipt); // receipt
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// mobile
		if (!$this->isAddOrEdit())
			$this->mobile->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mobile"));
		$this->mobile->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mobile"));

		// user
		if (!$this->isAddOrEdit())
			$this->user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_user"));
		$this->user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_user"));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_category"));
		$this->category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_category"));

		// name
		if (!$this->isAddOrEdit())
			$this->name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_name"));
		$this->name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_name"));

		// age
		if (!$this->isAddOrEdit())
			$this->age->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_age"));
		$this->age->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_age"));

		// sex
		if (!$this->isAddOrEdit())
			$this->sex->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sex"));
		$this->sex->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sex"));

		// referral
		if (!$this->isAddOrEdit())
			$this->referral->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_referral"));
		$this->referral->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_referral"));

		// examination_grp
		if (!$this->isAddOrEdit())
			$this->examination_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_examination_grp"));
		$this->examination_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_examination_grp"));
		if (is_array($this->examination_grp->AdvancedSearch->SearchValue))
			$this->examination_grp->AdvancedSearch->SearchValue = implode(",", $this->examination_grp->AdvancedSearch->SearchValue);
		if (is_array($this->examination_grp->AdvancedSearch->SearchValue2))
			$this->examination_grp->AdvancedSearch->SearchValue2 = implode(",", $this->examination_grp->AdvancedSearch->SearchValue2);

		// examination_type
		if (!$this->isAddOrEdit())
			$this->examination_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_examination_type"));
		$this->examination_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_examination_type"));
		if (is_array($this->examination_type->AdvancedSearch->SearchValue))
			$this->examination_type->AdvancedSearch->SearchValue = implode(",", $this->examination_type->AdvancedSearch->SearchValue);
		if (is_array($this->examination_type->AdvancedSearch->SearchValue2))
			$this->examination_type->AdvancedSearch->SearchValue2 = implode(",", $this->examination_type->AdvancedSearch->SearchValue2);

		// total_amount
		if (!$this->isAddOrEdit())
			$this->total_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_total_amount"));
		$this->total_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_total_amount"));

		// discount_percent
		if (!$this->isAddOrEdit())
			$this->discount_percent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_discount_percent"));
		$this->discount_percent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_discount_percent"));

		// discount_amount
		if (!$this->isAddOrEdit())
			$this->discount_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_discount_amount"));
		$this->discount_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_discount_amount"));

		// final_amount
		if (!$this->isAddOrEdit())
			$this->final_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_final_amount"));
		$this->final_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_final_amount"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// receipt
		if (!$this->isAddOrEdit())
			$this->receipt->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_receipt"));
		$this->receipt->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_receipt"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->total_amount->FormValue == $this->total_amount->CurrentValue && is_numeric(ConvertToFloatString($this->total_amount->CurrentValue)))
			$this->total_amount->CurrentValue = ConvertToFloatString($this->total_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->discount_percent->FormValue == $this->discount_percent->CurrentValue && is_numeric(ConvertToFloatString($this->discount_percent->CurrentValue)))
			$this->discount_percent->CurrentValue = ConvertToFloatString($this->discount_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->discount_amount->FormValue == $this->discount_amount->CurrentValue && is_numeric(ConvertToFloatString($this->discount_amount->CurrentValue)))
			$this->discount_amount->CurrentValue = ConvertToFloatString($this->discount_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->final_amount->FormValue == $this->final_amount->CurrentValue && is_numeric(ConvertToFloatString($this->final_amount->CurrentValue)))
			$this->final_amount->CurrentValue = ConvertToFloatString($this->final_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->receipt->FormValue == $this->receipt->CurrentValue && is_numeric(ConvertToFloatString($this->receipt->CurrentValue)))
			$this->receipt->CurrentValue = ConvertToFloatString($this->receipt->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// mobile
		// user
		// category
		// name
		// age
		// sex
		// referral
		// examination_grp
		// examination_type
		// total_amount
		// discount_percent
		// discount_amount
		// final_amount
		// remarks
		// operator
		// datetime
		// receipt

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$curVal = strval($this->mobile->CurrentValue);
			if ($curVal <> "") {
				$this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
				if ($this->mobile->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`mobile`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->mobile->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->mobile->ViewValue = $this->mobile->CurrentValue;
					}
				}
			} else {
				$this->mobile->ViewValue = NULL;
			}
			$this->mobile->ViewCustomAttributes = "";

			// user
			$this->user->ViewValue = $this->user->CurrentValue;
			$curVal = strval($this->user->CurrentValue);
			if ($curVal <> "") {
				$this->user->ViewValue = $this->user->lookupCacheOption($curVal);
				if ($this->user->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->user->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->user->ViewValue = $this->user->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->user->ViewValue = $this->user->CurrentValue;
					}
				}
			} else {
				$this->user->ViewValue = NULL;
			}
			$this->user->ViewCustomAttributes = "";

			// category
			if (strval($this->category->CurrentValue) <> "") {
				$this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->name->CurrentValue;
			$this->name->ViewValue = $this->name->displayValue($arwrk);
			$this->name->ViewCustomAttributes = "";

			// age
			$this->age->ViewValue = $this->age->CurrentValue;
			$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
			$this->age->ViewCustomAttributes = "";

			// sex
			if (strval($this->sex->CurrentValue) <> "") {
				$this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
			} else {
				$this->sex->ViewValue = NULL;
			}
			$this->sex->ViewCustomAttributes = "";

			// referral
			$this->referral->ViewValue = $this->referral->CurrentValue;
			$curVal = strval($this->referral->CurrentValue);
			if ($curVal <> "") {
				$this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
				if ($this->referral->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->referral->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
						$this->referral->ViewValue = $this->referral->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->referral->ViewValue = $this->referral->CurrentValue;
					}
				}
			} else {
				$this->referral->ViewValue = NULL;
			}
			$this->referral->ViewCustomAttributes = "";

			// examination_grp
			$curVal = strval($this->examination_grp->CurrentValue);
			if ($curVal <> "") {
				$this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
				if ($this->examination_grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->examination_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->examination_grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->examination_grp->ViewValue->add($this->examination_grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->examination_grp->ViewValue = $this->examination_grp->CurrentValue;
					}
				}
			} else {
				$this->examination_grp->ViewValue = NULL;
			}
			$this->examination_grp->ViewCustomAttributes = "";

			// examination_type
			$curVal = strval($this->examination_type->CurrentValue);
			if ($curVal <> "") {
				$this->examination_type->ViewValue = $this->examination_type->lookupCacheOption($curVal);
				if ($this->examination_type->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->examination_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->examination_type->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$this->examination_type->ViewValue->add($this->examination_type->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->examination_type->ViewValue = $this->examination_type->CurrentValue;
					}
				}
			} else {
				$this->examination_type->ViewValue = NULL;
			}
			$this->examination_type->ViewCustomAttributes = "";

			// total_amount
			$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
			$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
			$this->total_amount->ViewCustomAttributes = "";

			// discount_percent
			$this->discount_percent->ViewValue = $this->discount_percent->CurrentValue;
			$this->discount_percent->ViewValue = FormatNumber($this->discount_percent->ViewValue, 2, -1, 0, 0);
			$this->discount_percent->ViewCustomAttributes = "";

			// discount_amount
			$this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
			$this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, 2, -1, 0, 0);
			$this->discount_amount->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// receipt
			$this->receipt->ViewValue = $this->receipt->CurrentValue;
			$this->receipt->ViewValue = FormatNumber($this->receipt->ViewValue, 2, -2, -2, -2);
			$this->receipt->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// user
			$this->user->LinkCustomAttributes = "";
			$this->user->HrefValue = "";
			$this->user->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
			$this->age->TooltipValue = "";

			// sex
			$this->sex->LinkCustomAttributes = "";
			$this->sex->HrefValue = "";
			$this->sex->TooltipValue = "";

			// referral
			$this->referral->LinkCustomAttributes = "";
			$this->referral->HrefValue = "";
			$this->referral->TooltipValue = "";

			// examination_grp
			$this->examination_grp->LinkCustomAttributes = "";
			$this->examination_grp->HrefValue = "";
			$this->examination_grp->TooltipValue = "";

			// examination_type
			$this->examination_type->LinkCustomAttributes = "";
			$this->examination_type->HrefValue = "";
			$this->examination_type->TooltipValue = "";

			// total_amount
			$this->total_amount->LinkCustomAttributes = "";
			$this->total_amount->HrefValue = "";
			$this->total_amount->TooltipValue = "";

			// discount_percent
			$this->discount_percent->LinkCustomAttributes = "";
			$this->discount_percent->HrefValue = "";
			$this->discount_percent->TooltipValue = "";

			// discount_amount
			$this->discount_amount->LinkCustomAttributes = "";
			$this->discount_amount->HrefValue = "";
			$this->discount_amount->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// receipt
			$this->receipt->LinkCustomAttributes = "";
			$this->receipt->HrefValue = "";
			$this->receipt->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
			$curVal = strval($this->mobile->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->mobile->EditValue = $this->mobile->lookupCacheOption($curVal);
				if ($this->mobile->EditValue === NULL) { // Lookup from database
					$filterWrk = "`mobile`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->mobile->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->mobile->EditValue = $this->mobile->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->mobile->EditValue = NULL;
			}
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// user
			$this->user->EditAttrs["class"] = "form-control";
			$this->user->EditCustomAttributes = 'ReadOnly';
			$this->user->EditValue = HtmlEncode($this->user->AdvancedSearch->SearchValue);
			$curVal = strval($this->user->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->user->EditValue = $this->user->lookupCacheOption($curVal);
				if ($this->user->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->user->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->user->EditValue = $this->user->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->user->EditValue = HtmlEncode($this->user->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->user->EditValue = NULL;
			}
			$this->user->PlaceHolder = RemoveHtml($this->user->caption());

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$this->category->EditValue = $this->category->options(TRUE);

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
			$this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
			$arwrk = array();
			$arwrk[1] = HtmlEncode($this->name->CurrentValue);
			$this->name->EditValue = $this->name->displayValue($arwrk);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// age
			$this->age->EditAttrs["class"] = "form-control";
			$this->age->EditCustomAttributes = "";
			$this->age->EditValue = HtmlEncode($this->age->AdvancedSearch->SearchValue);
			$this->age->PlaceHolder = RemoveHtml($this->age->caption());

			// sex
			$this->sex->EditCustomAttributes = "";
			$this->sex->EditValue = $this->sex->options(FALSE);

			// referral
			$this->referral->EditAttrs["class"] = "form-control";
			$this->referral->EditCustomAttributes = "";
			$this->referral->EditValue = HtmlEncode($this->referral->AdvancedSearch->SearchValue);
			$curVal = strval($this->referral->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->referral->EditValue = $this->referral->lookupCacheOption($curVal);
				if ($this->referral->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->referral->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode(FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2));
						$this->referral->EditValue = $this->referral->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->referral->EditValue = HtmlEncode($this->referral->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->referral->EditValue = NULL;
			}
			$this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

			// examination_grp
			$this->examination_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->examination_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->examination_grp->AdvancedSearch->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
			else
				$this->examination_grp->AdvancedSearch->ViewValue = $this->examination_grp->Lookup !== NULL && is_array($this->examination_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->examination_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->examination_grp->EditValue = array_values($this->examination_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`grp`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->examination_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->examination_grp->EditValue = $arwrk;
			}

			// examination_type
			$this->examination_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->examination_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->examination_type->AdvancedSearch->ViewValue = $this->examination_type->lookupCacheOption($curVal);
			else
				$this->examination_type->AdvancedSearch->ViewValue = $this->examination_type->Lookup !== NULL && is_array($this->examination_type->Lookup->Options) ? $curVal : NULL;
			if ($this->examination_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->examination_type->EditValue = array_values($this->examination_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->examination_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
				}
				$this->examination_type->EditValue = $arwrk;
			}

			// total_amount
			$this->total_amount->EditAttrs["class"] = "form-control";
			$this->total_amount->EditCustomAttributes = "";
			$this->total_amount->EditValue = HtmlEncode($this->total_amount->AdvancedSearch->SearchValue);
			$this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());

			// discount_percent
			$this->discount_percent->EditAttrs["class"] = "form-control";
			$this->discount_percent->EditCustomAttributes = "";
			$this->discount_percent->EditValue = HtmlEncode($this->discount_percent->AdvancedSearch->SearchValue);
			$this->discount_percent->PlaceHolder = RemoveHtml($this->discount_percent->caption());

			// discount_amount
			$this->discount_amount->EditAttrs["class"] = "form-control";
			$this->discount_amount->EditCustomAttributes = "";
			$this->discount_amount->EditValue = HtmlEncode($this->discount_amount->AdvancedSearch->SearchValue);
			$this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());

			// final_amount
			$this->final_amount->EditAttrs["class"] = "form-control";
			$this->final_amount->EditCustomAttributes = 'ReadOnly';
			$this->final_amount->EditValue = HtmlEncode($this->final_amount->AdvancedSearch->SearchValue);
			$this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// receipt
			$this->receipt->EditAttrs["class"] = "form-control";
			$this->receipt->EditCustomAttributes = "";
			$this->receipt->EditValue = HtmlEncode($this->receipt->AdvancedSearch->SearchValue);
			$this->receipt->PlaceHolder = RemoveHtml($this->receipt->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckDate($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->user->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->user->errorMessage());
		}
		if (!CheckInteger($this->age->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->age->errorMessage());
		}
		if (!CheckInteger($this->referral->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->referral->errorMessage());
		}
		if (!CheckNumber($this->total_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->total_amount->errorMessage());
		}
		if (!CheckNumber($this->discount_percent->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->discount_percent->errorMessage());
		}
		if (!CheckNumber($this->discount_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->discount_amount->errorMessage());
		}
		if (!CheckNumber($this->final_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->final_amount->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckNumber($this->receipt->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->receipt->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->user->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->name->AdvancedSearch->load();
		$this->age->AdvancedSearch->load();
		$this->sex->AdvancedSearch->load();
		$this->referral->AdvancedSearch->load();
		$this->examination_grp->AdvancedSearch->load();
		$this->examination_type->AdvancedSearch->load();
		$this->total_amount->AdvancedSearch->load();
		$this->discount_percent->AdvancedSearch->load();
		$this->discount_amount->AdvancedSearch->load();
		$this->final_amount->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->receipt->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("l_examinationlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_examination_grp":
					$lookupFilter = function() {
						return "`grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_examination_type":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_mobile":
							break;
						case "x_user":
							break;
						case "x_name":
							break;
						case "x_referral":
							$row[2] = FormatNumber($row[2], 0, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_examination_grp":
							break;
						case "x_examination_type":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>