<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for l_examination_type
 */
class l_examination_type extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $grp;
	public $report_grp;
	public $name;
	public $ex_grp;
	public $price;
	public $max_discount;
	public $code;
	public $standard_min;
	public $standard_max;
	public $standard_unit;
	public $header;
	public $footer;
	public $process_time_hours;
	public $status;
	public $diagnosis_code;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'l_examination_type';
		$this->TableName = 'l_examination_type';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`l_examination_type`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('l_examination_type', 'l_examination_type', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// grp
		$this->grp = new DbField('l_examination_type', 'l_examination_type', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'l_examination_type', FALSE, 'id', ["name","","",""], [], ["x_report_grp"], [], [], [], [], '`id` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// report_grp
		$this->report_grp = new DbField('l_examination_type', 'l_examination_type', 'x_report_grp', 'report_grp', '`report_grp`', '`report_grp`', 18, -1, FALSE, '`report_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->report_grp->Nullable = FALSE; // NOT NULL field
		$this->report_grp->Required = TRUE; // Required field
		$this->report_grp->Sortable = TRUE; // Allow sort
		$this->report_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->report_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->report_grp->Lookup = new Lookup('report_grp', 'l_examination_type', FALSE, 'id', ["name","","",""], ["x_grp"], [], ["report_grp"], ["x_report_grp"], [], [], '`name` ASC', '');
		$this->report_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['report_grp'] = &$this->report_grp;

		// name
		$this->name = new DbField('l_examination_type', 'l_examination_type', 'x_name', 'name', '`name`', '`name`', 200, -1, FALSE, '`name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name->Nullable = FALSE; // NOT NULL field
		$this->name->Required = TRUE; // Required field
		$this->name->Sortable = TRUE; // Allow sort
		$this->fields['name'] = &$this->name;

		// ex_grp
		$this->ex_grp = new DbField('l_examination_type', 'l_examination_type', 'x_ex_grp', 'ex_grp', '\'\'', '\'\'', 201, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->ex_grp->IsCustom = TRUE; // Custom field
		$this->ex_grp->Sortable = TRUE; // Allow sort
		$this->ex_grp->Lookup = new Lookup('ex_grp', 'l_examination_type', FALSE, 'code', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['ex_grp'] = &$this->ex_grp;

		// price
		$this->price = new DbField('l_examination_type', 'l_examination_type', 'x_price', 'price', '`price`', '`price`', 131, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Nullable = FALSE; // NOT NULL field
		$this->price->Required = TRUE; // Required field
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// max_discount
		$this->max_discount = new DbField('l_examination_type', 'l_examination_type', 'x_max_discount', 'max_discount', '`max_discount`', '`max_discount`', 131, -1, FALSE, '`max_discount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->max_discount->Nullable = FALSE; // NOT NULL field
		$this->max_discount->Required = TRUE; // Required field
		$this->max_discount->Sortable = TRUE; // Allow sort
		$this->max_discount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['max_discount'] = &$this->max_discount;

		// code
		$this->code = new DbField('l_examination_type', 'l_examination_type', 'x_code', 'code', '`code`', '`code`', 200, -1, FALSE, '`code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->code->Nullable = FALSE; // NOT NULL field
		$this->code->Required = TRUE; // Required field
		$this->code->Sortable = TRUE; // Allow sort
		$this->fields['code'] = &$this->code;

		// standard_min
		$this->standard_min = new DbField('l_examination_type', 'l_examination_type', 'x_standard_min', 'standard_min', '`standard_min`', '`standard_min`', 200, -1, FALSE, '`standard_min`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->standard_min->Nullable = FALSE; // NOT NULL field
		$this->standard_min->Sortable = TRUE; // Allow sort
		$this->fields['standard_min'] = &$this->standard_min;

		// standard_max
		$this->standard_max = new DbField('l_examination_type', 'l_examination_type', 'x_standard_max', 'standard_max', '`standard_max`', '`standard_max`', 200, -1, FALSE, '`standard_max`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->standard_max->Nullable = FALSE; // NOT NULL field
		$this->standard_max->Sortable = TRUE; // Allow sort
		$this->standard_max->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['standard_max'] = &$this->standard_max;

		// standard_unit
		$this->standard_unit = new DbField('l_examination_type', 'l_examination_type', 'x_standard_unit', 'standard_unit', '`standard_unit`', '`standard_unit`', 200, -1, FALSE, '`standard_unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->standard_unit->Nullable = FALSE; // NOT NULL field
		$this->standard_unit->Required = TRUE; // Required field
		$this->standard_unit->Sortable = TRUE; // Allow sort
		$this->fields['standard_unit'] = &$this->standard_unit;

		// header
		$this->header = new DbField('l_examination_type', 'l_examination_type', 'x_header', 'header', '`header`', '`header`', 201, -1, FALSE, '`header`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->header->Sortable = TRUE; // Allow sort
		$this->fields['header'] = &$this->header;

		// footer
		$this->footer = new DbField('l_examination_type', 'l_examination_type', 'x_footer', 'footer', '`footer`', '`footer`', 201, -1, FALSE, '`footer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->footer->Sortable = TRUE; // Allow sort
		$this->fields['footer'] = &$this->footer;

		// process_time_hours
		$this->process_time_hours = new DbField('l_examination_type', 'l_examination_type', 'x_process_time_hours', 'process_time_hours', '`process_time_hours`', '`process_time_hours`', 18, -1, FALSE, '`process_time_hours`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->process_time_hours->Nullable = FALSE; // NOT NULL field
		$this->process_time_hours->Required = TRUE; // Required field
		$this->process_time_hours->Sortable = TRUE; // Allow sort
		$this->process_time_hours->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process_time_hours'] = &$this->process_time_hours;

		// status
		$this->status = new DbField('l_examination_type', 'l_examination_type', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'l_examination_type', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// diagnosis_code
		$this->diagnosis_code = new DbField('l_examination_type', 'l_examination_type', 'x_diagnosis_code', 'diagnosis_code', '`diagnosis_code`', '`diagnosis_code`', 201, -1, FALSE, '`diagnosis_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->diagnosis_code->Sortable = TRUE; // Allow sort
		$this->fields['diagnosis_code'] = &$this->diagnosis_code;

		// operator
		$this->operator = new DbField('l_examination_type', 'l_examination_type', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('l_examination_type', 'l_examination_type', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`l_examination_type`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, '' AS `ex_grp` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`id` > 100";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->grp->DbValue = $row['grp'];
		$this->report_grp->DbValue = $row['report_grp'];
		$this->name->DbValue = $row['name'];
		$this->ex_grp->DbValue = $row['ex_grp'];
		$this->price->DbValue = $row['price'];
		$this->max_discount->DbValue = $row['max_discount'];
		$this->code->DbValue = $row['code'];
		$this->standard_min->DbValue = $row['standard_min'];
		$this->standard_max->DbValue = $row['standard_max'];
		$this->standard_unit->DbValue = $row['standard_unit'];
		$this->header->DbValue = $row['header'];
		$this->footer->DbValue = $row['footer'];
		$this->process_time_hours->DbValue = $row['process_time_hours'];
		$this->status->DbValue = $row['status'];
		$this->diagnosis_code->DbValue = $row['diagnosis_code'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "l_examination_typelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "l_examination_typeview.php")
			return $Language->phrase("View");
		elseif ($pageName == "l_examination_typeedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "l_examination_typeadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "l_examination_typelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("l_examination_typeview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("l_examination_typeview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "l_examination_typeadd.php?" . $this->getUrlParm($parm);
		else
			$url = "l_examination_typeadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("l_examination_typeedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("l_examination_typeadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("l_examination_typedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->report_grp->setDbValue($rs->fields('report_grp'));
		$this->name->setDbValue($rs->fields('name'));
		$this->ex_grp->setDbValue($rs->fields('ex_grp'));
		$this->price->setDbValue($rs->fields('price'));
		$this->max_discount->setDbValue($rs->fields('max_discount'));
		$this->code->setDbValue($rs->fields('code'));
		$this->standard_min->setDbValue($rs->fields('standard_min'));
		$this->standard_max->setDbValue($rs->fields('standard_max'));
		$this->standard_unit->setDbValue($rs->fields('standard_unit'));
		$this->header->setDbValue($rs->fields('header'));
		$this->footer->setDbValue($rs->fields('footer'));
		$this->process_time_hours->setDbValue($rs->fields('process_time_hours'));
		$this->status->setDbValue($rs->fields('status'));
		$this->diagnosis_code->setDbValue($rs->fields('diagnosis_code'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// grp
		// report_grp
		// name
		// ex_grp
		// price
		// max_discount
		// code
		// standard_min
		// standard_max
		// standard_unit
		// header
		// footer
		// process_time_hours
		// status
		// diagnosis_code
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`> 0 and `grp`< 3 and `id` > 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// report_grp
		$curVal = strval($this->report_grp->CurrentValue);
		if ($curVal <> "") {
			$this->report_grp->ViewValue = $this->report_grp->lookupCacheOption($curVal);
			if ($this->report_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=2 || `grp`=3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->report_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->report_grp->ViewValue = $this->report_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->report_grp->ViewValue = $this->report_grp->CurrentValue;
				}
			}
		} else {
			$this->report_grp->ViewValue = NULL;
		}
		$this->report_grp->ViewCustomAttributes = "";

		// name
		$this->name->ViewValue = $this->name->CurrentValue;
		$this->name->ViewCustomAttributes = "";

		// ex_grp
		$curVal = strval($this->ex_grp->CurrentValue);
		if ($curVal <> "") {
			$this->ex_grp->ViewValue = $this->ex_grp->lookupCacheOption($curVal);
			if ($this->ex_grp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 100 and `report_grp` > 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ex_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->ex_grp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->ex_grp->ViewValue->add($this->ex_grp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->ex_grp->ViewValue = $this->ex_grp->CurrentValue;
				}
			}
		} else {
			$this->ex_grp->ViewValue = NULL;
		}
		$this->ex_grp->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// max_discount
		$this->max_discount->ViewValue = $this->max_discount->CurrentValue;
		$this->max_discount->ViewValue = FormatNumber($this->max_discount->ViewValue, 2, -2, -2, -2);
		$this->max_discount->ViewCustomAttributes = "";

		// code
		$this->code->ViewValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// standard_min
		$this->standard_min->ViewValue = $this->standard_min->CurrentValue;
		$this->standard_min->ViewCustomAttributes = "";

		// standard_max
		$this->standard_max->ViewValue = $this->standard_max->CurrentValue;
		$this->standard_max->ViewCustomAttributes = "";

		// standard_unit
		$this->standard_unit->ViewValue = $this->standard_unit->CurrentValue;
		$this->standard_unit->ViewCustomAttributes = "";

		// header
		$this->header->ViewValue = $this->header->CurrentValue;
		$this->header->ViewCustomAttributes = "";

		// footer
		$this->footer->ViewValue = $this->footer->CurrentValue;
		$this->footer->ViewCustomAttributes = "";

		// process_time_hours
		$this->process_time_hours->ViewValue = $this->process_time_hours->CurrentValue;
		$this->process_time_hours->ViewValue = FormatNumber($this->process_time_hours->ViewValue, 0, -2, -2, -2);
		$this->process_time_hours->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// diagnosis_code
		$this->diagnosis_code->ViewValue = $this->diagnosis_code->CurrentValue;
		$this->diagnosis_code->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// report_grp
		$this->report_grp->LinkCustomAttributes = "";
		$this->report_grp->HrefValue = "";
		$this->report_grp->TooltipValue = "";

		// name
		$this->name->LinkCustomAttributes = "";
		$this->name->HrefValue = "";
		$this->name->TooltipValue = "";

		// ex_grp
		$this->ex_grp->LinkCustomAttributes = "";
		$this->ex_grp->HrefValue = "";
		$this->ex_grp->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// max_discount
		$this->max_discount->LinkCustomAttributes = "";
		$this->max_discount->HrefValue = "";
		$this->max_discount->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		$this->code->HrefValue = "";
		$this->code->TooltipValue = "";

		// standard_min
		$this->standard_min->LinkCustomAttributes = "";
		$this->standard_min->HrefValue = "";
		$this->standard_min->TooltipValue = "";

		// standard_max
		$this->standard_max->LinkCustomAttributes = "";
		$this->standard_max->HrefValue = "";
		$this->standard_max->TooltipValue = "";

		// standard_unit
		$this->standard_unit->LinkCustomAttributes = "";
		$this->standard_unit->HrefValue = "";
		$this->standard_unit->TooltipValue = "";

		// header
		$this->header->LinkCustomAttributes = "";
		$this->header->HrefValue = "";
		$this->header->TooltipValue = "";

		// footer
		$this->footer->LinkCustomAttributes = "";
		$this->footer->HrefValue = "";
		$this->footer->TooltipValue = "";

		// process_time_hours
		$this->process_time_hours->LinkCustomAttributes = "";
		$this->process_time_hours->HrefValue = "";
		$this->process_time_hours->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// diagnosis_code
		$this->diagnosis_code->LinkCustomAttributes = "";
		$this->diagnosis_code->HrefValue = "";
		$this->diagnosis_code->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// report_grp
		$this->report_grp->EditAttrs["class"] = "form-control";
		$this->report_grp->EditCustomAttributes = "";

		// name
		$this->name->EditAttrs["class"] = "form-control";
		$this->name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
		$this->name->EditValue = $this->name->CurrentValue;
		$this->name->PlaceHolder = RemoveHtml($this->name->caption());

		// ex_grp
		$this->ex_grp->EditCustomAttributes = "";

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

		// max_discount
		$this->max_discount->EditAttrs["class"] = "form-control";
		$this->max_discount->EditCustomAttributes = "";
		$this->max_discount->EditValue = $this->max_discount->CurrentValue;
		$this->max_discount->PlaceHolder = RemoveHtml($this->max_discount->caption());
		if (strval($this->max_discount->EditValue) <> "" && is_numeric($this->max_discount->EditValue))
			$this->max_discount->EditValue = FormatNumber($this->max_discount->EditValue, -2, -2, -2, -2);

		// code
		$this->code->EditAttrs["class"] = "form-control";
		$this->code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
		$this->code->EditValue = $this->code->CurrentValue;
		$this->code->PlaceHolder = RemoveHtml($this->code->caption());

		// standard_min
		$this->standard_min->EditAttrs["class"] = "form-control";
		$this->standard_min->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->standard_min->CurrentValue = HtmlDecode($this->standard_min->CurrentValue);
		$this->standard_min->EditValue = $this->standard_min->CurrentValue;
		$this->standard_min->PlaceHolder = RemoveHtml($this->standard_min->caption());

		// standard_max
		$this->standard_max->EditAttrs["class"] = "form-control";
		$this->standard_max->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->standard_max->CurrentValue = HtmlDecode($this->standard_max->CurrentValue);
		$this->standard_max->EditValue = $this->standard_max->CurrentValue;
		$this->standard_max->PlaceHolder = RemoveHtml($this->standard_max->caption());

		// standard_unit
		$this->standard_unit->EditAttrs["class"] = "form-control";
		$this->standard_unit->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->standard_unit->CurrentValue = HtmlDecode($this->standard_unit->CurrentValue);
		$this->standard_unit->EditValue = $this->standard_unit->CurrentValue;
		$this->standard_unit->PlaceHolder = RemoveHtml($this->standard_unit->caption());

		// header
		$this->header->EditAttrs["class"] = "form-control";
		$this->header->EditCustomAttributes = "";
		$this->header->EditValue = $this->header->CurrentValue;
		$this->header->PlaceHolder = RemoveHtml($this->header->caption());

		// footer
		$this->footer->EditAttrs["class"] = "form-control";
		$this->footer->EditCustomAttributes = "";
		$this->footer->EditValue = $this->footer->CurrentValue;
		$this->footer->PlaceHolder = RemoveHtml($this->footer->caption());

		// process_time_hours
		$this->process_time_hours->EditAttrs["class"] = "form-control";
		$this->process_time_hours->EditCustomAttributes = "";
		$this->process_time_hours->EditValue = $this->process_time_hours->CurrentValue;
		$this->process_time_hours->PlaceHolder = RemoveHtml($this->process_time_hours->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// diagnosis_code
		$this->diagnosis_code->EditAttrs["class"] = "form-control";
		$this->diagnosis_code->EditCustomAttributes = "";
		$this->diagnosis_code->EditValue = $this->diagnosis_code->CurrentValue;
		$this->diagnosis_code->PlaceHolder = RemoveHtml($this->diagnosis_code->caption());

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->report_grp);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->ex_grp);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->max_discount);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->standard_min);
					$doc->exportCaption($this->standard_max);
					$doc->exportCaption($this->standard_unit);
					$doc->exportCaption($this->header);
					$doc->exportCaption($this->footer);
					$doc->exportCaption($this->process_time_hours);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->diagnosis_code);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->report_grp);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->max_discount);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->standard_min);
					$doc->exportCaption($this->standard_max);
					$doc->exportCaption($this->standard_unit);
					$doc->exportCaption($this->process_time_hours);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->report_grp);
						$doc->exportField($this->name);
						$doc->exportField($this->ex_grp);
						$doc->exportField($this->price);
						$doc->exportField($this->max_discount);
						$doc->exportField($this->code);
						$doc->exportField($this->standard_min);
						$doc->exportField($this->standard_max);
						$doc->exportField($this->standard_unit);
						$doc->exportField($this->header);
						$doc->exportField($this->footer);
						$doc->exportField($this->process_time_hours);
						$doc->exportField($this->status);
						$doc->exportField($this->diagnosis_code);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->report_grp);
						$doc->exportField($this->name);
						$doc->exportField($this->price);
						$doc->exportField($this->max_discount);
						$doc->exportField($this->code);
						$doc->exportField($this->standard_min);
						$doc->exportField($this->standard_max);
						$doc->exportField($this->standard_unit);
						$doc->exportField($this->process_time_hours);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>