<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class l_examination_type_add extends l_examination_type
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'l_examination_type';

	// Page object name
	public $PageObjName = "l_examination_type_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (l_examination_type)
		if (!isset($GLOBALS["l_examination_type"]) || get_class($GLOBALS["l_examination_type"]) == PROJECT_NAMESPACE . "l_examination_type") {
			$GLOBALS["l_examination_type"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["l_examination_type"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'l_examination_type');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $l_examination_type;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($l_examination_type);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "l_examination_typeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("l_examination_typelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->grp->setVisibility();
		$this->report_grp->setVisibility();
		$this->name->setVisibility();
		$this->ex_grp->setVisibility();
		$this->price->setVisibility();
		$this->max_discount->setVisibility();
		$this->code->setVisibility();
		$this->standard_min->setVisibility();
		$this->standard_max->setVisibility();
		$this->standard_unit->setVisibility();
		$this->header->setVisibility();
		$this->footer->setVisibility();
		$this->process_time_hours->setVisibility();
		$this->status->setVisibility();
		$this->diagnosis_code->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->report_grp);
		$this->setupLookupOptions($this->ex_grp);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("l_examination_typelist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "l_examination_typelist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "l_examination_typeview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->report_grp->CurrentValue = 0;
		$this->name->CurrentValue = NULL;
		$this->name->OldValue = $this->name->CurrentValue;
		$this->ex_grp->CurrentValue = NULL;
		$this->ex_grp->OldValue = $this->ex_grp->CurrentValue;
		$this->price->CurrentValue = NULL;
		$this->price->OldValue = $this->price->CurrentValue;
		$this->max_discount->CurrentValue = NULL;
		$this->max_discount->OldValue = $this->max_discount->CurrentValue;
		$this->code->CurrentValue = NULL;
		$this->code->OldValue = $this->code->CurrentValue;
		$this->standard_min->CurrentValue = NULL;
		$this->standard_min->OldValue = $this->standard_min->CurrentValue;
		$this->standard_max->CurrentValue = 0.00;
		$this->standard_unit->CurrentValue = NULL;
		$this->standard_unit->OldValue = $this->standard_unit->CurrentValue;
		$this->header->CurrentValue = NULL;
		$this->header->OldValue = $this->header->CurrentValue;
		$this->footer->CurrentValue = NULL;
		$this->footer->OldValue = $this->footer->CurrentValue;
		$this->process_time_hours->CurrentValue = NULL;
		$this->process_time_hours->OldValue = $this->process_time_hours->CurrentValue;
		$this->status->CurrentValue = 1;
		$this->diagnosis_code->CurrentValue = NULL;
		$this->diagnosis_code->OldValue = $this->diagnosis_code->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 'report_grp' first before field var 'x_report_grp'
		$val = $CurrentForm->hasValue("report_grp") ? $CurrentForm->getValue("report_grp") : $CurrentForm->getValue("x_report_grp");
		if (!$this->report_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->report_grp->Visible = FALSE; // Disable update for API request
			else
				$this->report_grp->setFormValue($val);
		}

		// Check field name 'name' first before field var 'x_name'
		$val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
		if (!$this->name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->name->Visible = FALSE; // Disable update for API request
			else
				$this->name->setFormValue($val);
		}

		// Check field name 'ex_grp' first before field var 'x_ex_grp'
		$val = $CurrentForm->hasValue("ex_grp") ? $CurrentForm->getValue("ex_grp") : $CurrentForm->getValue("x_ex_grp");
		if (!$this->ex_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ex_grp->Visible = FALSE; // Disable update for API request
			else
				$this->ex_grp->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'max_discount' first before field var 'x_max_discount'
		$val = $CurrentForm->hasValue("max_discount") ? $CurrentForm->getValue("max_discount") : $CurrentForm->getValue("x_max_discount");
		if (!$this->max_discount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->max_discount->Visible = FALSE; // Disable update for API request
			else
				$this->max_discount->setFormValue($val);
		}

		// Check field name 'code' first before field var 'x_code'
		$val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
		if (!$this->code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->code->Visible = FALSE; // Disable update for API request
			else
				$this->code->setFormValue($val);
		}

		// Check field name 'standard_min' first before field var 'x_standard_min'
		$val = $CurrentForm->hasValue("standard_min") ? $CurrentForm->getValue("standard_min") : $CurrentForm->getValue("x_standard_min");
		if (!$this->standard_min->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->standard_min->Visible = FALSE; // Disable update for API request
			else
				$this->standard_min->setFormValue($val);
		}

		// Check field name 'standard_max' first before field var 'x_standard_max'
		$val = $CurrentForm->hasValue("standard_max") ? $CurrentForm->getValue("standard_max") : $CurrentForm->getValue("x_standard_max");
		if (!$this->standard_max->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->standard_max->Visible = FALSE; // Disable update for API request
			else
				$this->standard_max->setFormValue($val);
		}

		// Check field name 'standard_unit' first before field var 'x_standard_unit'
		$val = $CurrentForm->hasValue("standard_unit") ? $CurrentForm->getValue("standard_unit") : $CurrentForm->getValue("x_standard_unit");
		if (!$this->standard_unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->standard_unit->Visible = FALSE; // Disable update for API request
			else
				$this->standard_unit->setFormValue($val);
		}

		// Check field name 'header' first before field var 'x_header'
		$val = $CurrentForm->hasValue("header") ? $CurrentForm->getValue("header") : $CurrentForm->getValue("x_header");
		if (!$this->header->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->header->Visible = FALSE; // Disable update for API request
			else
				$this->header->setFormValue($val);
		}

		// Check field name 'footer' first before field var 'x_footer'
		$val = $CurrentForm->hasValue("footer") ? $CurrentForm->getValue("footer") : $CurrentForm->getValue("x_footer");
		if (!$this->footer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->footer->Visible = FALSE; // Disable update for API request
			else
				$this->footer->setFormValue($val);
		}

		// Check field name 'process_time_hours' first before field var 'x_process_time_hours'
		$val = $CurrentForm->hasValue("process_time_hours") ? $CurrentForm->getValue("process_time_hours") : $CurrentForm->getValue("x_process_time_hours");
		if (!$this->process_time_hours->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process_time_hours->Visible = FALSE; // Disable update for API request
			else
				$this->process_time_hours->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'diagnosis_code' first before field var 'x_diagnosis_code'
		$val = $CurrentForm->hasValue("diagnosis_code") ? $CurrentForm->getValue("diagnosis_code") : $CurrentForm->getValue("x_diagnosis_code");
		if (!$this->diagnosis_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diagnosis_code->Visible = FALSE; // Disable update for API request
			else
				$this->diagnosis_code->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->report_grp->CurrentValue = $this->report_grp->FormValue;
		$this->name->CurrentValue = $this->name->FormValue;
		$this->ex_grp->CurrentValue = $this->ex_grp->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->max_discount->CurrentValue = $this->max_discount->FormValue;
		$this->code->CurrentValue = $this->code->FormValue;
		$this->standard_min->CurrentValue = $this->standard_min->FormValue;
		$this->standard_max->CurrentValue = $this->standard_max->FormValue;
		$this->standard_unit->CurrentValue = $this->standard_unit->FormValue;
		$this->header->CurrentValue = $this->header->FormValue;
		$this->footer->CurrentValue = $this->footer->FormValue;
		$this->process_time_hours->CurrentValue = $this->process_time_hours->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->diagnosis_code->CurrentValue = $this->diagnosis_code->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->report_grp->setDbValue($row['report_grp']);
		$this->name->setDbValue($row['name']);
		$this->ex_grp->setDbValue($row['ex_grp']);
		$this->price->setDbValue($row['price']);
		$this->max_discount->setDbValue($row['max_discount']);
		$this->code->setDbValue($row['code']);
		$this->standard_min->setDbValue($row['standard_min']);
		$this->standard_max->setDbValue($row['standard_max']);
		$this->standard_unit->setDbValue($row['standard_unit']);
		$this->header->setDbValue($row['header']);
		$this->footer->setDbValue($row['footer']);
		$this->process_time_hours->setDbValue($row['process_time_hours']);
		$this->status->setDbValue($row['status']);
		$this->diagnosis_code->setDbValue($row['diagnosis_code']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['report_grp'] = $this->report_grp->CurrentValue;
		$row['name'] = $this->name->CurrentValue;
		$row['ex_grp'] = $this->ex_grp->CurrentValue;
		$row['price'] = $this->price->CurrentValue;
		$row['max_discount'] = $this->max_discount->CurrentValue;
		$row['code'] = $this->code->CurrentValue;
		$row['standard_min'] = $this->standard_min->CurrentValue;
		$row['standard_max'] = $this->standard_max->CurrentValue;
		$row['standard_unit'] = $this->standard_unit->CurrentValue;
		$row['header'] = $this->header->CurrentValue;
		$row['footer'] = $this->footer->CurrentValue;
		$row['process_time_hours'] = $this->process_time_hours->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['diagnosis_code'] = $this->diagnosis_code->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->max_discount->FormValue == $this->max_discount->CurrentValue && is_numeric(ConvertToFloatString($this->max_discount->CurrentValue)))
			$this->max_discount->CurrentValue = ConvertToFloatString($this->max_discount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// report_grp
		// name
		// ex_grp
		// price
		// max_discount
		// code
		// standard_min
		// standard_max
		// standard_unit
		// header
		// footer
		// process_time_hours
		// status
		// diagnosis_code
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`> 0 and `grp`< 3 and `id` > 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// report_grp
			$curVal = strval($this->report_grp->CurrentValue);
			if ($curVal <> "") {
				$this->report_grp->ViewValue = $this->report_grp->lookupCacheOption($curVal);
				if ($this->report_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=2 || `grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->report_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->report_grp->ViewValue = $this->report_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->report_grp->ViewValue = $this->report_grp->CurrentValue;
					}
				}
			} else {
				$this->report_grp->ViewValue = NULL;
			}
			$this->report_grp->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// ex_grp
			$curVal = strval($this->ex_grp->CurrentValue);
			if ($curVal <> "") {
				$this->ex_grp->ViewValue = $this->ex_grp->lookupCacheOption($curVal);
				if ($this->ex_grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` > 100 and `report_grp` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->ex_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->ex_grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->ex_grp->ViewValue->add($this->ex_grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->ex_grp->ViewValue = $this->ex_grp->CurrentValue;
					}
				}
			} else {
				$this->ex_grp->ViewValue = NULL;
			}
			$this->ex_grp->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// max_discount
			$this->max_discount->ViewValue = $this->max_discount->CurrentValue;
			$this->max_discount->ViewValue = FormatNumber($this->max_discount->ViewValue, 2, -2, -2, -2);
			$this->max_discount->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// standard_min
			$this->standard_min->ViewValue = $this->standard_min->CurrentValue;
			$this->standard_min->ViewCustomAttributes = "";

			// standard_max
			$this->standard_max->ViewValue = $this->standard_max->CurrentValue;
			$this->standard_max->ViewCustomAttributes = "";

			// standard_unit
			$this->standard_unit->ViewValue = $this->standard_unit->CurrentValue;
			$this->standard_unit->ViewCustomAttributes = "";

			// header
			$this->header->ViewValue = $this->header->CurrentValue;
			$this->header->ViewCustomAttributes = "";

			// footer
			$this->footer->ViewValue = $this->footer->CurrentValue;
			$this->footer->ViewCustomAttributes = "";

			// process_time_hours
			$this->process_time_hours->ViewValue = $this->process_time_hours->CurrentValue;
			$this->process_time_hours->ViewValue = FormatNumber($this->process_time_hours->ViewValue, 0, -2, -2, -2);
			$this->process_time_hours->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// diagnosis_code
			$this->diagnosis_code->ViewValue = $this->diagnosis_code->CurrentValue;
			$this->diagnosis_code->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// report_grp
			$this->report_grp->LinkCustomAttributes = "";
			$this->report_grp->HrefValue = "";
			$this->report_grp->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// ex_grp
			$this->ex_grp->LinkCustomAttributes = "";
			$this->ex_grp->HrefValue = "";
			$this->ex_grp->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// max_discount
			$this->max_discount->LinkCustomAttributes = "";
			$this->max_discount->HrefValue = "";
			$this->max_discount->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";

			// standard_min
			$this->standard_min->LinkCustomAttributes = "";
			$this->standard_min->HrefValue = "";
			$this->standard_min->TooltipValue = "";

			// standard_max
			$this->standard_max->LinkCustomAttributes = "";
			$this->standard_max->HrefValue = "";
			$this->standard_max->TooltipValue = "";

			// standard_unit
			$this->standard_unit->LinkCustomAttributes = "";
			$this->standard_unit->HrefValue = "";
			$this->standard_unit->TooltipValue = "";

			// header
			$this->header->LinkCustomAttributes = "";
			$this->header->HrefValue = "";
			$this->header->TooltipValue = "";

			// footer
			$this->footer->LinkCustomAttributes = "";
			$this->footer->HrefValue = "";
			$this->footer->TooltipValue = "";

			// process_time_hours
			$this->process_time_hours->LinkCustomAttributes = "";
			$this->process_time_hours->HrefValue = "";
			$this->process_time_hours->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// diagnosis_code
			$this->diagnosis_code->LinkCustomAttributes = "";
			$this->diagnosis_code->HrefValue = "";
			$this->diagnosis_code->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`> 0 and `grp`< 3 and `id` > 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// report_grp
			$this->report_grp->EditAttrs["class"] = "form-control";
			$this->report_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->report_grp->CurrentValue));
			if ($curVal <> "")
				$this->report_grp->ViewValue = $this->report_grp->lookupCacheOption($curVal);
			else
				$this->report_grp->ViewValue = $this->report_grp->Lookup !== NULL && is_array($this->report_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->report_grp->ViewValue !== NULL) { // Load from cache
				$this->report_grp->EditValue = array_values($this->report_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->report_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=2 || `grp`=3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->report_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->report_grp->EditValue = $arwrk;
			}

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
			$this->name->EditValue = HtmlEncode($this->name->CurrentValue);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// ex_grp
			$this->ex_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->ex_grp->CurrentValue));
			if ($curVal <> "")
				$this->ex_grp->ViewValue = $this->ex_grp->lookupCacheOption($curVal);
			else
				$this->ex_grp->ViewValue = $this->ex_grp->Lookup !== NULL && is_array($this->ex_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->ex_grp->ViewValue !== NULL) { // Load from cache
				$this->ex_grp->EditValue = array_values($this->ex_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 100 and `report_grp` > 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ex_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ex_grp->EditValue = $arwrk;
			}

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

			// max_discount
			$this->max_discount->EditAttrs["class"] = "form-control";
			$this->max_discount->EditCustomAttributes = "";
			$this->max_discount->EditValue = HtmlEncode($this->max_discount->CurrentValue);
			$this->max_discount->PlaceHolder = RemoveHtml($this->max_discount->caption());
			if (strval($this->max_discount->EditValue) <> "" && is_numeric($this->max_discount->EditValue))
				$this->max_discount->EditValue = FormatNumber($this->max_discount->EditValue, -2, -2, -2, -2);

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
			$this->code->EditValue = HtmlEncode($this->code->CurrentValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// standard_min
			$this->standard_min->EditAttrs["class"] = "form-control";
			$this->standard_min->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->standard_min->CurrentValue = HtmlDecode($this->standard_min->CurrentValue);
			$this->standard_min->EditValue = HtmlEncode($this->standard_min->CurrentValue);
			$this->standard_min->PlaceHolder = RemoveHtml($this->standard_min->caption());

			// standard_max
			$this->standard_max->EditAttrs["class"] = "form-control";
			$this->standard_max->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->standard_max->CurrentValue = HtmlDecode($this->standard_max->CurrentValue);
			$this->standard_max->EditValue = HtmlEncode($this->standard_max->CurrentValue);
			$this->standard_max->PlaceHolder = RemoveHtml($this->standard_max->caption());

			// standard_unit
			$this->standard_unit->EditAttrs["class"] = "form-control";
			$this->standard_unit->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->standard_unit->CurrentValue = HtmlDecode($this->standard_unit->CurrentValue);
			$this->standard_unit->EditValue = HtmlEncode($this->standard_unit->CurrentValue);
			$this->standard_unit->PlaceHolder = RemoveHtml($this->standard_unit->caption());

			// header
			$this->header->EditAttrs["class"] = "form-control";
			$this->header->EditCustomAttributes = "";
			$this->header->EditValue = HtmlEncode($this->header->CurrentValue);
			$this->header->PlaceHolder = RemoveHtml($this->header->caption());

			// footer
			$this->footer->EditAttrs["class"] = "form-control";
			$this->footer->EditCustomAttributes = "";
			$this->footer->EditValue = HtmlEncode($this->footer->CurrentValue);
			$this->footer->PlaceHolder = RemoveHtml($this->footer->caption());

			// process_time_hours
			$this->process_time_hours->EditAttrs["class"] = "form-control";
			$this->process_time_hours->EditCustomAttributes = "";
			$this->process_time_hours->EditValue = HtmlEncode($this->process_time_hours->CurrentValue);
			$this->process_time_hours->PlaceHolder = RemoveHtml($this->process_time_hours->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// diagnosis_code
			$this->diagnosis_code->EditAttrs["class"] = "form-control";
			$this->diagnosis_code->EditCustomAttributes = "";
			$this->diagnosis_code->EditValue = HtmlEncode($this->diagnosis_code->CurrentValue);
			$this->diagnosis_code->PlaceHolder = RemoveHtml($this->diagnosis_code->caption());

			// operator
			// datetime
			// Add refer script
			// grp

			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// report_grp
			$this->report_grp->LinkCustomAttributes = "";
			$this->report_grp->HrefValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";

			// ex_grp
			$this->ex_grp->LinkCustomAttributes = "";
			$this->ex_grp->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// max_discount
			$this->max_discount->LinkCustomAttributes = "";
			$this->max_discount->HrefValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";

			// standard_min
			$this->standard_min->LinkCustomAttributes = "";
			$this->standard_min->HrefValue = "";

			// standard_max
			$this->standard_max->LinkCustomAttributes = "";
			$this->standard_max->HrefValue = "";

			// standard_unit
			$this->standard_unit->LinkCustomAttributes = "";
			$this->standard_unit->HrefValue = "";

			// header
			$this->header->LinkCustomAttributes = "";
			$this->header->HrefValue = "";

			// footer
			$this->footer->LinkCustomAttributes = "";
			$this->footer->HrefValue = "";

			// process_time_hours
			$this->process_time_hours->LinkCustomAttributes = "";
			$this->process_time_hours->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// diagnosis_code
			$this->diagnosis_code->LinkCustomAttributes = "";
			$this->diagnosis_code->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->report_grp->Required) {
			if (!$this->report_grp->IsDetailKey && $this->report_grp->FormValue != NULL && $this->report_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->report_grp->caption(), $this->report_grp->RequiredErrorMessage));
			}
		}
		if ($this->name->Required) {
			if (!$this->name->IsDetailKey && $this->name->FormValue != NULL && $this->name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
			}
		}
		if ($this->ex_grp->Required) {
			if ($this->ex_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ex_grp->caption(), $this->ex_grp->RequiredErrorMessage));
			}
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->price->FormValue)) {
			AddMessage($FormError, $this->price->errorMessage());
		}
		if ($this->max_discount->Required) {
			if (!$this->max_discount->IsDetailKey && $this->max_discount->FormValue != NULL && $this->max_discount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->max_discount->caption(), $this->max_discount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->max_discount->FormValue)) {
			AddMessage($FormError, $this->max_discount->errorMessage());
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if ($this->standard_min->Required) {
			if (!$this->standard_min->IsDetailKey && $this->standard_min->FormValue != NULL && $this->standard_min->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->standard_min->caption(), $this->standard_min->RequiredErrorMessage));
			}
		}
		if ($this->standard_max->Required) {
			if (!$this->standard_max->IsDetailKey && $this->standard_max->FormValue != NULL && $this->standard_max->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->standard_max->caption(), $this->standard_max->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->standard_max->FormValue)) {
			AddMessage($FormError, $this->standard_max->errorMessage());
		}
		if ($this->standard_unit->Required) {
			if (!$this->standard_unit->IsDetailKey && $this->standard_unit->FormValue != NULL && $this->standard_unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->standard_unit->caption(), $this->standard_unit->RequiredErrorMessage));
			}
		}
		if ($this->header->Required) {
			if (!$this->header->IsDetailKey && $this->header->FormValue != NULL && $this->header->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->header->caption(), $this->header->RequiredErrorMessage));
			}
		}
		if ($this->footer->Required) {
			if (!$this->footer->IsDetailKey && $this->footer->FormValue != NULL && $this->footer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->footer->caption(), $this->footer->RequiredErrorMessage));
			}
		}
		if ($this->process_time_hours->Required) {
			if (!$this->process_time_hours->IsDetailKey && $this->process_time_hours->FormValue != NULL && $this->process_time_hours->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_time_hours->caption(), $this->process_time_hours->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->process_time_hours->FormValue)) {
			AddMessage($FormError, $this->process_time_hours->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->diagnosis_code->Required) {
			if (!$this->diagnosis_code->IsDetailKey && $this->diagnosis_code->FormValue != NULL && $this->diagnosis_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diagnosis_code->caption(), $this->diagnosis_code->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, FALSE);

		// report_grp
		$this->report_grp->setDbValueDef($rsnew, $this->report_grp->CurrentValue, 0, strval($this->report_grp->CurrentValue) == "");

		// name
		$this->name->setDbValueDef($rsnew, $this->name->CurrentValue, "", FALSE);

		// ex_grp
		$this->ex_grp->setDbValueDef($rsnew, $this->ex_grp->CurrentValue, "", FALSE);

		// price
		$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, 0, FALSE);

		// max_discount
		$this->max_discount->setDbValueDef($rsnew, $this->max_discount->CurrentValue, 0, FALSE);

		// code
		$this->code->setDbValueDef($rsnew, $this->code->CurrentValue, "", FALSE);

		// standard_min
		$this->standard_min->setDbValueDef($rsnew, $this->standard_min->CurrentValue, "", strval($this->standard_min->CurrentValue) == "");

		// standard_max
		$this->standard_max->setDbValueDef($rsnew, $this->standard_max->CurrentValue, "", strval($this->standard_max->CurrentValue) == "");

		// standard_unit
		$this->standard_unit->setDbValueDef($rsnew, $this->standard_unit->CurrentValue, "", FALSE);

		// header
		$this->header->setDbValueDef($rsnew, $this->header->CurrentValue, NULL, FALSE);

		// footer
		$this->footer->setDbValueDef($rsnew, $this->footer->CurrentValue, NULL, FALSE);

		// process_time_hours
		$this->process_time_hours->setDbValueDef($rsnew, $this->process_time_hours->CurrentValue, 0, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, strval($this->status->CurrentValue) == "");

		// diagnosis_code
		$this->diagnosis_code->setDbValueDef($rsnew, $this->diagnosis_code->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("l_examination_typelist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`grp`> 0 and `grp`< 3 and `id` > 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_report_grp":
					$lookupFilter = function() {
						return "`grp`=2 || `grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_ex_grp":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 100 and `report_grp` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_report_grp":
							break;
						case "x_ex_grp":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>