<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for margin_list
 */
class margin_list extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $godown;
	public $margin_monthly;
	public $margin_25;
	public $packets_p;
	public $quantity_p;
	public $_40_p;
	public $amount_p;
	public $packets_s;
	public $quantity_s;
	public $_40_s;
	public $amount_s;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'margin_list';
		$this->TableName = 'margin_list';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`margin_list`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// grp
		$this->grp = new DbField('margin_list', 'margin_list', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('margin_list', 'margin_list', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], [], [], [], [], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('margin_list', 'margin_list', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product', FALSE, 'id', ["product","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('margin_list', 'margin_list', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->rid->IsForeignKey = TRUE; // Foreign key field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// godown
		$this->godown = new DbField('margin_list', 'margin_list', 'x_godown', 'godown', '`godown`', '`godown`', 19, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->godown->Lookup = new Lookup('godown', 'godown', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// margin_monthly
		$this->margin_monthly = new DbField('margin_list', 'margin_list', 'x_margin_monthly', 'margin_monthly', '`margin_monthly`', '`margin_monthly`', 5, -1, FALSE, '`margin_monthly`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->margin_monthly->Sortable = TRUE; // Allow sort
		$this->margin_monthly->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['margin_monthly'] = &$this->margin_monthly;

		// margin_%
		$this->margin_25 = new DbField('margin_list', 'margin_list', 'x_margin_25', 'margin_%', '`margin_%`', '`margin_%`', 5, -1, FALSE, '`margin_%`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->margin_25->Sortable = TRUE; // Allow sort
		$this->margin_25->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['margin_%'] = &$this->margin_25;

		// packets_p
		$this->packets_p = new DbField('margin_list', 'margin_list', 'x_packets_p', 'packets_p', '`packets_p`', '`packets_p`', 131, -1, FALSE, '`packets_p`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets_p->Sortable = TRUE; // Allow sort
		$this->packets_p->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packets_p'] = &$this->packets_p;

		// quantity_p
		$this->quantity_p = new DbField('margin_list', 'margin_list', 'x_quantity_p', 'quantity_p', '`quantity_p`', '`quantity_p`', 131, -1, FALSE, '`quantity_p`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity_p->Sortable = TRUE; // Allow sort
		$this->quantity_p->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity_p'] = &$this->quantity_p;

		// @_p
		$this->_40_p = new DbField('margin_list', 'margin_list', 'x__40_p', '@_p', '`@_p`', '`@_p`', 131, -1, FALSE, '`@_p`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40_p->Sortable = TRUE; // Allow sort
		$this->_40_p->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@_p'] = &$this->_40_p;

		// amount_p
		$this->amount_p = new DbField('margin_list', 'margin_list', 'x_amount_p', 'amount_p', '`amount_p`', '`amount_p`', 131, -1, FALSE, '`amount_p`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount_p->Sortable = TRUE; // Allow sort
		$this->amount_p->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount_p'] = &$this->amount_p;

		// packets_s
		$this->packets_s = new DbField('margin_list', 'margin_list', 'x_packets_s', 'packets_s', '`packets_s`', '`packets_s`', 131, -1, FALSE, '`packets_s`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets_s->Sortable = TRUE; // Allow sort
		$this->packets_s->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packets_s'] = &$this->packets_s;

		// quantity_s
		$this->quantity_s = new DbField('margin_list', 'margin_list', 'x_quantity_s', 'quantity_s', '`quantity_s`', '`quantity_s`', 131, -1, FALSE, '`quantity_s`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity_s->Sortable = TRUE; // Allow sort
		$this->quantity_s->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity_s'] = &$this->quantity_s;

		// @_s
		$this->_40_s = new DbField('margin_list', 'margin_list', 'x__40_s', '@_s', '`@_s`', '`@_s`', 5, -1, FALSE, '`@_s`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40_s->Sortable = TRUE; // Allow sort
		$this->_40_s->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@_s'] = &$this->_40_s;

		// amount_s
		$this->amount_s = new DbField('margin_list', 'margin_list', 'x_amount_s', 'amount_s', '`amount_s`', '`amount_s`', 5, -1, FALSE, '`amount_s`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount_s->Sortable = TRUE; // Allow sort
		$this->amount_s->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount_s'] = &$this->amount_s;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "sales_ref") {
			$detailUrl = $GLOBALS["sales_ref"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_rid=" . urlencode($this->rid->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "purchase_ref") {
			$detailUrl = $GLOBALS["purchase_ref"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_rid=" . urlencode($this->rid->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "margin_listlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`margin_list`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();

		// Cascade Update detail table 'sales_ref'
		$cascadeUpdate = FALSE;
		$rscascade = array();
		if ($rsold && (isset($rs['rid']) && $rsold['rid'] <> $rs['rid'])) { // Update detail field 'rid'
			$cascadeUpdate = TRUE;
			$rscascade['rid'] = $rs['rid']; 
		}
		if ($cascadeUpdate) {
			if (!isset($GLOBALS["sales_ref"]))
				$GLOBALS["sales_ref"] = new sales_ref();
			$rswrk = $GLOBALS["sales_ref"]->loadRs("`rid` = " . QuotedValue($rsold['rid'], DATATYPE_NUMBER, 'DB')); 
			while ($rswrk && !$rswrk->EOF) {
				$rskey = array();
				$rsdtlold = &$rswrk->fields;
				$rsdtlnew = array_merge($rsdtlold, $rscascade);

				// Call Row_Updating event
				$success = $GLOBALS["sales_ref"]->Row_Updating($rsdtlold, $rsdtlnew);
				if ($success)
					$success = $GLOBALS["sales_ref"]->update($rscascade, $rskey, $rswrk->fields);
				if (!$success)
					return FALSE;

				// Call Row_Updated event
				$GLOBALS["sales_ref"]->Row_Updated($rsdtlold, $rsdtlnew);
				$rswrk->moveNext();
			}
		}
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();

		// Cascade delete detail table 'sales_ref'
		if (!isset($GLOBALS["sales_ref"]))
			$GLOBALS["sales_ref"] = new sales_ref();
		$rscascade = $GLOBALS["sales_ref"]->loadRs("`rid` = " . QuotedValue($rs['rid'], DATATYPE_NUMBER, "DB")); 
		$dtlrows = ($rscascade) ? $rscascade->getRows() : array();

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["sales_ref"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["sales_ref"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["sales_ref"]->Row_Deleted($dtlrow);
		}
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->godown->DbValue = $row['godown'];
		$this->margin_monthly->DbValue = $row['margin_monthly'];
		$this->margin_25->DbValue = $row['margin_%'];
		$this->packets_p->DbValue = $row['packets_p'];
		$this->quantity_p->DbValue = $row['quantity_p'];
		$this->_40_p->DbValue = $row['@_p'];
		$this->amount_p->DbValue = $row['amount_p'];
		$this->packets_s->DbValue = $row['packets_s'];
		$this->quantity_s->DbValue = $row['quantity_s'];
		$this->_40_s->DbValue = $row['@_s'];
		$this->amount_s->DbValue = $row['amount_s'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "margin_listlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "margin_listview.php")
			return $Language->phrase("View");
		elseif ($pageName == "margin_listedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "margin_listadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "margin_listlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("margin_listview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("margin_listview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "margin_listadd.php?" . $this->getUrlParm($parm);
		else
			$url = "margin_listadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("margin_listedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("margin_listadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("margin_listdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->margin_monthly->setDbValue($rs->fields('margin_monthly'));
		$this->margin_25->setDbValue($rs->fields('margin_%'));
		$this->packets_p->setDbValue($rs->fields('packets_p'));
		$this->quantity_p->setDbValue($rs->fields('quantity_p'));
		$this->_40_p->setDbValue($rs->fields('@_p'));
		$this->amount_p->setDbValue($rs->fields('amount_p'));
		$this->packets_s->setDbValue($rs->fields('packets_s'));
		$this->quantity_s->setDbValue($rs->fields('quantity_s'));
		$this->_40_s->setDbValue($rs->fields('@_s'));
		$this->amount_s->setDbValue($rs->fields('amount_s'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// grp
		// s_grp
		// product
		// rid
		// godown
		// margin_monthly
		// margin_%
		// packets_p
		// quantity_p
		// @_p
		// amount_p
		// packets_s
		// quantity_s
		// @_s
		// amount_s
		// grp

		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// godown
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// margin_monthly
		$this->margin_monthly->ViewValue = $this->margin_monthly->CurrentValue;
		$this->margin_monthly->ViewValue = FormatNumber($this->margin_monthly->ViewValue, 2, -2, -2, -2);
		$this->margin_monthly->ViewCustomAttributes = "";

		// margin_%
		$this->margin_25->ViewValue = $this->margin_25->CurrentValue;
		$this->margin_25->ViewValue = FormatNumber($this->margin_25->ViewValue, 2, -2, -2, -2);
		$this->margin_25->ViewCustomAttributes = "";

		// packets_p
		$this->packets_p->ViewValue = $this->packets_p->CurrentValue;
		$this->packets_p->ViewValue = FormatNumber($this->packets_p->ViewValue, 2, -2, -2, -2);
		$this->packets_p->ViewCustomAttributes = "";

		// quantity_p
		$this->quantity_p->ViewValue = $this->quantity_p->CurrentValue;
		$this->quantity_p->ViewValue = FormatNumber($this->quantity_p->ViewValue, 2, -2, -2, -2);
		$this->quantity_p->ViewCustomAttributes = "";

		// @_p
		$this->_40_p->ViewValue = $this->_40_p->CurrentValue;
		$this->_40_p->ViewValue = FormatNumber($this->_40_p->ViewValue, 2, -2, -2, -2);
		$this->_40_p->ViewCustomAttributes = "";

		// amount_p
		$this->amount_p->ViewValue = $this->amount_p->CurrentValue;
		$this->amount_p->ViewValue = FormatNumber($this->amount_p->ViewValue, 2, -2, -2, -2);
		$this->amount_p->ViewCustomAttributes = "";

		// packets_s
		$this->packets_s->ViewValue = $this->packets_s->CurrentValue;
		$this->packets_s->ViewValue = FormatNumber($this->packets_s->ViewValue, 2, -2, -2, -2);
		$this->packets_s->ViewCustomAttributes = "";

		// quantity_s
		$this->quantity_s->ViewValue = $this->quantity_s->CurrentValue;
		$this->quantity_s->ViewValue = FormatNumber($this->quantity_s->ViewValue, 2, -2, -2, -2);
		$this->quantity_s->ViewCustomAttributes = "";

		// @_s
		$this->_40_s->ViewValue = $this->_40_s->CurrentValue;
		$this->_40_s->ViewValue = FormatNumber($this->_40_s->ViewValue, 2, -2, -2, -2);
		$this->_40_s->ViewCustomAttributes = "";

		// amount_s
		$this->amount_s->ViewValue = $this->amount_s->CurrentValue;
		$this->amount_s->ViewValue = FormatNumber($this->amount_s->ViewValue, 2, -2, -2, -2);
		$this->amount_s->ViewCustomAttributes = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "margin_listlist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "margin_listlist.php?x_sgrp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "margin_listlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown->CurrentValue)) {
			$this->godown->HrefValue = "margin_listlist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
			$this->godown->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
		} else {
			$this->godown->HrefValue = "";
		}
		$this->godown->TooltipValue = "";

		// margin_monthly
		$this->margin_monthly->LinkCustomAttributes = "";
		$this->margin_monthly->HrefValue = "";
		$this->margin_monthly->TooltipValue = "";

		// margin_%
		$this->margin_25->LinkCustomAttributes = "";
		$this->margin_25->HrefValue = "";
		$this->margin_25->TooltipValue = "";

		// packets_p
		$this->packets_p->LinkCustomAttributes = "";
		$this->packets_p->HrefValue = "";
		$this->packets_p->TooltipValue = "";

		// quantity_p
		$this->quantity_p->LinkCustomAttributes = "";
		$this->quantity_p->HrefValue = "";
		$this->quantity_p->TooltipValue = "";

		// @_p
		$this->_40_p->LinkCustomAttributes = "";
		$this->_40_p->HrefValue = "";
		$this->_40_p->TooltipValue = "";

		// amount_p
		$this->amount_p->LinkCustomAttributes = "";
		$this->amount_p->HrefValue = "";
		$this->amount_p->TooltipValue = "";

		// packets_s
		$this->packets_s->LinkCustomAttributes = "";
		$this->packets_s->HrefValue = "";
		$this->packets_s->TooltipValue = "";

		// quantity_s
		$this->quantity_s->LinkCustomAttributes = "";
		$this->quantity_s->HrefValue = "";
		$this->quantity_s->TooltipValue = "";

		// @_s
		$this->_40_s->LinkCustomAttributes = "";
		$this->_40_s->HrefValue = "";
		$this->_40_s->TooltipValue = "";

		// amount_s
		$this->amount_s->LinkCustomAttributes = "";
		$this->amount_s->HrefValue = "";
		$this->amount_s->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";

		// margin_monthly
		$this->margin_monthly->EditAttrs["class"] = "form-control";
		$this->margin_monthly->EditCustomAttributes = "";
		$this->margin_monthly->EditValue = $this->margin_monthly->CurrentValue;
		$this->margin_monthly->PlaceHolder = RemoveHtml($this->margin_monthly->caption());
		if (strval($this->margin_monthly->EditValue) <> "" && is_numeric($this->margin_monthly->EditValue))
			$this->margin_monthly->EditValue = FormatNumber($this->margin_monthly->EditValue, -2, -2, -2, -2);

		// margin_%
		$this->margin_25->EditAttrs["class"] = "form-control";
		$this->margin_25->EditCustomAttributes = "";
		$this->margin_25->EditValue = $this->margin_25->CurrentValue;
		$this->margin_25->PlaceHolder = RemoveHtml($this->margin_25->caption());
		if (strval($this->margin_25->EditValue) <> "" && is_numeric($this->margin_25->EditValue))
			$this->margin_25->EditValue = FormatNumber($this->margin_25->EditValue, -2, -2, -2, -2);

		// packets_p
		$this->packets_p->EditAttrs["class"] = "form-control";
		$this->packets_p->EditCustomAttributes = "";
		$this->packets_p->EditValue = $this->packets_p->CurrentValue;
		$this->packets_p->PlaceHolder = RemoveHtml($this->packets_p->caption());
		if (strval($this->packets_p->EditValue) <> "" && is_numeric($this->packets_p->EditValue))
			$this->packets_p->EditValue = FormatNumber($this->packets_p->EditValue, -2, -2, -2, -2);

		// quantity_p
		$this->quantity_p->EditAttrs["class"] = "form-control";
		$this->quantity_p->EditCustomAttributes = "";
		$this->quantity_p->EditValue = $this->quantity_p->CurrentValue;
		$this->quantity_p->PlaceHolder = RemoveHtml($this->quantity_p->caption());
		if (strval($this->quantity_p->EditValue) <> "" && is_numeric($this->quantity_p->EditValue))
			$this->quantity_p->EditValue = FormatNumber($this->quantity_p->EditValue, -2, -2, -2, -2);

		// @_p
		$this->_40_p->EditAttrs["class"] = "form-control";
		$this->_40_p->EditCustomAttributes = "";
		$this->_40_p->EditValue = $this->_40_p->CurrentValue;
		$this->_40_p->PlaceHolder = RemoveHtml($this->_40_p->caption());
		if (strval($this->_40_p->EditValue) <> "" && is_numeric($this->_40_p->EditValue))
			$this->_40_p->EditValue = FormatNumber($this->_40_p->EditValue, -2, -2, -2, -2);

		// amount_p
		$this->amount_p->EditAttrs["class"] = "form-control";
		$this->amount_p->EditCustomAttributes = "";
		$this->amount_p->EditValue = $this->amount_p->CurrentValue;
		$this->amount_p->PlaceHolder = RemoveHtml($this->amount_p->caption());
		if (strval($this->amount_p->EditValue) <> "" && is_numeric($this->amount_p->EditValue))
			$this->amount_p->EditValue = FormatNumber($this->amount_p->EditValue, -2, -2, -2, -2);

		// packets_s
		$this->packets_s->EditAttrs["class"] = "form-control";
		$this->packets_s->EditCustomAttributes = "";
		$this->packets_s->EditValue = $this->packets_s->CurrentValue;
		$this->packets_s->PlaceHolder = RemoveHtml($this->packets_s->caption());
		if (strval($this->packets_s->EditValue) <> "" && is_numeric($this->packets_s->EditValue))
			$this->packets_s->EditValue = FormatNumber($this->packets_s->EditValue, -2, -2, -2, -2);

		// quantity_s
		$this->quantity_s->EditAttrs["class"] = "form-control";
		$this->quantity_s->EditCustomAttributes = "";
		$this->quantity_s->EditValue = $this->quantity_s->CurrentValue;
		$this->quantity_s->PlaceHolder = RemoveHtml($this->quantity_s->caption());
		if (strval($this->quantity_s->EditValue) <> "" && is_numeric($this->quantity_s->EditValue))
			$this->quantity_s->EditValue = FormatNumber($this->quantity_s->EditValue, -2, -2, -2, -2);

		// @_s
		$this->_40_s->EditAttrs["class"] = "form-control";
		$this->_40_s->EditCustomAttributes = "";
		$this->_40_s->EditValue = $this->_40_s->CurrentValue;
		$this->_40_s->PlaceHolder = RemoveHtml($this->_40_s->caption());
		if (strval($this->_40_s->EditValue) <> "" && is_numeric($this->_40_s->EditValue))
			$this->_40_s->EditValue = FormatNumber($this->_40_s->EditValue, -2, -2, -2, -2);

		// amount_s
		$this->amount_s->EditAttrs["class"] = "form-control";
		$this->amount_s->EditCustomAttributes = "";
		$this->amount_s->EditValue = $this->amount_s->CurrentValue;
		$this->amount_s->PlaceHolder = RemoveHtml($this->amount_s->caption());
		if (strval($this->amount_s->EditValue) <> "" && is_numeric($this->amount_s->EditValue))
			$this->amount_s->EditValue = FormatNumber($this->amount_s->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->margin_monthly->CurrentValue))
				$this->margin_monthly->Total += $this->margin_monthly->CurrentValue; // Accumulate total
			$this->margin_25->Count++; // Increment count
			if (is_numeric($this->margin_25->CurrentValue))
				$this->margin_25->Total += $this->margin_25->CurrentValue; // Accumulate total
			if (is_numeric($this->packets_s->CurrentValue))
				$this->packets_s->Total += $this->packets_s->CurrentValue; // Accumulate total
			if (is_numeric($this->quantity_s->CurrentValue))
				$this->quantity_s->Total += $this->quantity_s->CurrentValue; // Accumulate total
			if (is_numeric($this->amount_s->CurrentValue))
				$this->amount_s->Total += $this->amount_s->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->margin_monthly->CurrentValue = $this->margin_monthly->Total;
			$this->margin_monthly->ViewValue = $this->margin_monthly->CurrentValue;
			$this->margin_monthly->ViewValue = FormatNumber($this->margin_monthly->ViewValue, 2, -2, -2, -2);
			$this->margin_monthly->ViewCustomAttributes = "";
			$this->margin_monthly->HrefValue = ""; // Clear href value
			if ($this->margin_25->Count > 0) {
				$this->margin_25->CurrentValue = $this->margin_25->Total / $this->margin_25->Count;
			}
			$this->margin_25->ViewValue = $this->margin_25->CurrentValue;
			$this->margin_25->ViewValue = FormatNumber($this->margin_25->ViewValue, 2, -2, -2, -2);
			$this->margin_25->ViewCustomAttributes = "";
			$this->margin_25->HrefValue = ""; // Clear href value
			$this->packets_s->CurrentValue = $this->packets_s->Total;
			$this->packets_s->ViewValue = $this->packets_s->CurrentValue;
			$this->packets_s->ViewValue = FormatNumber($this->packets_s->ViewValue, 2, -2, -2, -2);
			$this->packets_s->ViewCustomAttributes = "";
			$this->packets_s->HrefValue = ""; // Clear href value
			$this->quantity_s->CurrentValue = $this->quantity_s->Total;
			$this->quantity_s->ViewValue = $this->quantity_s->CurrentValue;
			$this->quantity_s->ViewValue = FormatNumber($this->quantity_s->ViewValue, 2, -2, -2, -2);
			$this->quantity_s->ViewCustomAttributes = "";
			$this->quantity_s->HrefValue = ""; // Clear href value
			$this->amount_s->CurrentValue = $this->amount_s->Total;
			$this->amount_s->ViewValue = $this->amount_s->CurrentValue;
			$this->amount_s->ViewValue = FormatNumber($this->amount_s->ViewValue, 2, -2, -2, -2);
			$this->amount_s->ViewCustomAttributes = "";
			$this->amount_s->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->margin_monthly);
					$doc->exportCaption($this->margin_25);
					$doc->exportCaption($this->packets_p);
					$doc->exportCaption($this->quantity_p);
					$doc->exportCaption($this->_40_p);
					$doc->exportCaption($this->amount_p);
					$doc->exportCaption($this->packets_s);
					$doc->exportCaption($this->quantity_s);
					$doc->exportCaption($this->_40_s);
					$doc->exportCaption($this->amount_s);
				} else {
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->margin_monthly);
					$doc->exportCaption($this->margin_25);
					$doc->exportCaption($this->packets_p);
					$doc->exportCaption($this->quantity_p);
					$doc->exportCaption($this->_40_p);
					$doc->exportCaption($this->amount_p);
					$doc->exportCaption($this->packets_s);
					$doc->exportCaption($this->quantity_s);
					$doc->exportCaption($this->_40_s);
					$doc->exportCaption($this->amount_s);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->godown);
						$doc->exportField($this->margin_monthly);
						$doc->exportField($this->margin_25);
						$doc->exportField($this->packets_p);
						$doc->exportField($this->quantity_p);
						$doc->exportField($this->_40_p);
						$doc->exportField($this->amount_p);
						$doc->exportField($this->packets_s);
						$doc->exportField($this->quantity_s);
						$doc->exportField($this->_40_s);
						$doc->exportField($this->amount_s);
					} else {
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->godown);
						$doc->exportField($this->margin_monthly);
						$doc->exportField($this->margin_25);
						$doc->exportField($this->packets_p);
						$doc->exportField($this->quantity_p);
						$doc->exportField($this->_40_p);
						$doc->exportField($this->amount_p);
						$doc->exportField($this->packets_s);
						$doc->exportField($this->quantity_s);
						$doc->exportField($this->_40_s);
						$doc->exportField($this->amount_s);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->s_grp, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->rid, '');
				$doc->exportAggregate($this->godown, '');
				$doc->exportAggregate($this->margin_monthly, 'TOTAL');
				$doc->exportAggregate($this->margin_25, 'AVERAGE');
				$doc->exportAggregate($this->packets_p, '');
				$doc->exportAggregate($this->quantity_p, '');
				$doc->exportAggregate($this->_40_p, '');
				$doc->exportAggregate($this->amount_p, '');
				$doc->exportAggregate($this->packets_s, 'TOTAL');
				$doc->exportAggregate($this->quantity_s, 'TOTAL');
				$doc->exportAggregate($this->_40_s, '');
				$doc->exportAggregate($this->amount_s, 'TOTAL');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>