<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class margin_list_monthly_add extends margin_list_monthly
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'margin_list_monthly';

	// Page object name
	public $PageObjName = "margin_list_monthly_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (margin_list_monthly)
		if (!isset($GLOBALS["margin_list_monthly"]) || get_class($GLOBALS["margin_list_monthly"]) == PROJECT_NAMESPACE . "margin_list_monthly") {
			$GLOBALS["margin_list_monthly"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["margin_list_monthly"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'margin_list_monthly');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $margin_list_monthly;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($margin_list_monthly);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "margin_list_monthlyview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("margin_list_monthlylist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->lot_no->setVisibility();
		$this->margin_monthly->setVisibility();
		$this->margin_25->setVisibility();
		$this->packets_p->setVisibility();
		$this->quantity_p->setVisibility();
		$this->_40_p->setVisibility();
		$this->amount_p->setVisibility();
		$this->packets_s->setVisibility();
		$this->quantity_s->setVisibility();
		$this->_40_s->setVisibility();
		$this->amount_s->setVisibility();
		$this->godown->setVisibility();
		$this->ref->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->godown);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back
			$this->CopyRecord = FALSE;
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("margin_list_monthlylist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "margin_list_monthlylist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "margin_list_monthlyview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->margin_monthly->CurrentValue = NULL;
		$this->margin_monthly->OldValue = $this->margin_monthly->CurrentValue;
		$this->margin_25->CurrentValue = NULL;
		$this->margin_25->OldValue = $this->margin_25->CurrentValue;
		$this->packets_p->CurrentValue = NULL;
		$this->packets_p->OldValue = $this->packets_p->CurrentValue;
		$this->quantity_p->CurrentValue = NULL;
		$this->quantity_p->OldValue = $this->quantity_p->CurrentValue;
		$this->_40_p->CurrentValue = NULL;
		$this->_40_p->OldValue = $this->_40_p->CurrentValue;
		$this->amount_p->CurrentValue = NULL;
		$this->amount_p->OldValue = $this->amount_p->CurrentValue;
		$this->packets_s->CurrentValue = NULL;
		$this->packets_s->OldValue = $this->packets_s->CurrentValue;
		$this->quantity_s->CurrentValue = NULL;
		$this->quantity_s->OldValue = $this->quantity_s->CurrentValue;
		$this->_40_s->CurrentValue = NULL;
		$this->_40_s->OldValue = $this->_40_s->CurrentValue;
		$this->amount_s->CurrentValue = NULL;
		$this->amount_s->OldValue = $this->amount_s->CurrentValue;
		$this->godown->CurrentValue = NULL;
		$this->godown->OldValue = $this->godown->CurrentValue;
		$this->ref->CurrentValue = NULL;
		$this->ref->OldValue = $this->ref->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'margin_monthly' first before field var 'x_margin_monthly'
		$val = $CurrentForm->hasValue("margin_monthly") ? $CurrentForm->getValue("margin_monthly") : $CurrentForm->getValue("x_margin_monthly");
		if (!$this->margin_monthly->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->margin_monthly->Visible = FALSE; // Disable update for API request
			else
				$this->margin_monthly->setFormValue($val);
		}

		// Check field name 'margin_%' first before field var 'x_margin_25'
		$val = $CurrentForm->hasValue("margin_%") ? $CurrentForm->getValue("margin_%") : $CurrentForm->getValue("x_margin_25");
		if (!$this->margin_25->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->margin_25->Visible = FALSE; // Disable update for API request
			else
				$this->margin_25->setFormValue($val);
		}

		// Check field name 'packets_p' first before field var 'x_packets_p'
		$val = $CurrentForm->hasValue("packets_p") ? $CurrentForm->getValue("packets_p") : $CurrentForm->getValue("x_packets_p");
		if (!$this->packets_p->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packets_p->Visible = FALSE; // Disable update for API request
			else
				$this->packets_p->setFormValue($val);
		}

		// Check field name 'quantity_p' first before field var 'x_quantity_p'
		$val = $CurrentForm->hasValue("quantity_p") ? $CurrentForm->getValue("quantity_p") : $CurrentForm->getValue("x_quantity_p");
		if (!$this->quantity_p->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity_p->Visible = FALSE; // Disable update for API request
			else
				$this->quantity_p->setFormValue($val);
		}

		// Check field name '@_p' first before field var 'x__40_p'
		$val = $CurrentForm->hasValue("@_p") ? $CurrentForm->getValue("@_p") : $CurrentForm->getValue("x__40_p");
		if (!$this->_40_p->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_40_p->Visible = FALSE; // Disable update for API request
			else
				$this->_40_p->setFormValue($val);
		}

		// Check field name 'amount_p' first before field var 'x_amount_p'
		$val = $CurrentForm->hasValue("amount_p") ? $CurrentForm->getValue("amount_p") : $CurrentForm->getValue("x_amount_p");
		if (!$this->amount_p->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount_p->Visible = FALSE; // Disable update for API request
			else
				$this->amount_p->setFormValue($val);
		}

		// Check field name 'packets_s' first before field var 'x_packets_s'
		$val = $CurrentForm->hasValue("packets_s") ? $CurrentForm->getValue("packets_s") : $CurrentForm->getValue("x_packets_s");
		if (!$this->packets_s->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packets_s->Visible = FALSE; // Disable update for API request
			else
				$this->packets_s->setFormValue($val);
		}

		// Check field name 'quantity_s' first before field var 'x_quantity_s'
		$val = $CurrentForm->hasValue("quantity_s") ? $CurrentForm->getValue("quantity_s") : $CurrentForm->getValue("x_quantity_s");
		if (!$this->quantity_s->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity_s->Visible = FALSE; // Disable update for API request
			else
				$this->quantity_s->setFormValue($val);
		}

		// Check field name '@_s' first before field var 'x__40_s'
		$val = $CurrentForm->hasValue("@_s") ? $CurrentForm->getValue("@_s") : $CurrentForm->getValue("x__40_s");
		if (!$this->_40_s->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_40_s->Visible = FALSE; // Disable update for API request
			else
				$this->_40_s->setFormValue($val);
		}

		// Check field name 'amount_s' first before field var 'x_amount_s'
		$val = $CurrentForm->hasValue("amount_s") ? $CurrentForm->getValue("amount_s") : $CurrentForm->getValue("x_amount_s");
		if (!$this->amount_s->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount_s->Visible = FALSE; // Disable update for API request
			else
				$this->amount_s->setFormValue($val);
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown->Visible = FALSE; // Disable update for API request
			else
				$this->godown->setFormValue($val);
		}

		// Check field name 'ref' first before field var 'x_ref'
		$val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
		if (!$this->ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ref->Visible = FALSE; // Disable update for API request
			else
				$this->ref->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->margin_monthly->CurrentValue = $this->margin_monthly->FormValue;
		$this->margin_25->CurrentValue = $this->margin_25->FormValue;
		$this->packets_p->CurrentValue = $this->packets_p->FormValue;
		$this->quantity_p->CurrentValue = $this->quantity_p->FormValue;
		$this->_40_p->CurrentValue = $this->_40_p->FormValue;
		$this->amount_p->CurrentValue = $this->amount_p->FormValue;
		$this->packets_s->CurrentValue = $this->packets_s->FormValue;
		$this->quantity_s->CurrentValue = $this->quantity_s->FormValue;
		$this->_40_s->CurrentValue = $this->_40_s->FormValue;
		$this->amount_s->CurrentValue = $this->amount_s->FormValue;
		$this->godown->CurrentValue = $this->godown->FormValue;
		$this->ref->CurrentValue = $this->ref->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->margin_monthly->setDbValue($row['margin_monthly']);
		$this->margin_25->setDbValue($row['margin_%']);
		$this->packets_p->setDbValue($row['packets_p']);
		$this->quantity_p->setDbValue($row['quantity_p']);
		$this->_40_p->setDbValue($row['@_p']);
		$this->amount_p->setDbValue($row['amount_p']);
		$this->packets_s->setDbValue($row['packets_s']);
		$this->quantity_s->setDbValue($row['quantity_s']);
		$this->_40_s->setDbValue($row['@_s']);
		$this->amount_s->setDbValue($row['amount_s']);
		$this->godown->setDbValue($row['godown']);
		$this->ref->setDbValue($row['ref']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['margin_monthly'] = $this->margin_monthly->CurrentValue;
		$row['margin_%'] = $this->margin_25->CurrentValue;
		$row['packets_p'] = $this->packets_p->CurrentValue;
		$row['quantity_p'] = $this->quantity_p->CurrentValue;
		$row['@_p'] = $this->_40_p->CurrentValue;
		$row['amount_p'] = $this->amount_p->CurrentValue;
		$row['packets_s'] = $this->packets_s->CurrentValue;
		$row['quantity_s'] = $this->quantity_s->CurrentValue;
		$row['@_s'] = $this->_40_s->CurrentValue;
		$row['amount_s'] = $this->amount_s->CurrentValue;
		$row['godown'] = $this->godown->CurrentValue;
		$row['ref'] = $this->ref->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{
		return FALSE;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->margin_monthly->FormValue == $this->margin_monthly->CurrentValue && is_numeric(ConvertToFloatString($this->margin_monthly->CurrentValue)))
			$this->margin_monthly->CurrentValue = ConvertToFloatString($this->margin_monthly->CurrentValue);

		// Convert decimal values if posted back
		if ($this->margin_25->FormValue == $this->margin_25->CurrentValue && is_numeric(ConvertToFloatString($this->margin_25->CurrentValue)))
			$this->margin_25->CurrentValue = ConvertToFloatString($this->margin_25->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packets_p->FormValue == $this->packets_p->CurrentValue && is_numeric(ConvertToFloatString($this->packets_p->CurrentValue)))
			$this->packets_p->CurrentValue = ConvertToFloatString($this->packets_p->CurrentValue);

		// Convert decimal values if posted back
		if ($this->quantity_p->FormValue == $this->quantity_p->CurrentValue && is_numeric(ConvertToFloatString($this->quantity_p->CurrentValue)))
			$this->quantity_p->CurrentValue = ConvertToFloatString($this->quantity_p->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40_p->FormValue == $this->_40_p->CurrentValue && is_numeric(ConvertToFloatString($this->_40_p->CurrentValue)))
			$this->_40_p->CurrentValue = ConvertToFloatString($this->_40_p->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount_p->FormValue == $this->amount_p->CurrentValue && is_numeric(ConvertToFloatString($this->amount_p->CurrentValue)))
			$this->amount_p->CurrentValue = ConvertToFloatString($this->amount_p->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packets_s->FormValue == $this->packets_s->CurrentValue && is_numeric(ConvertToFloatString($this->packets_s->CurrentValue)))
			$this->packets_s->CurrentValue = ConvertToFloatString($this->packets_s->CurrentValue);

		// Convert decimal values if posted back
		if ($this->quantity_s->FormValue == $this->quantity_s->CurrentValue && is_numeric(ConvertToFloatString($this->quantity_s->CurrentValue)))
			$this->quantity_s->CurrentValue = ConvertToFloatString($this->quantity_s->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40_s->FormValue == $this->_40_s->CurrentValue && is_numeric(ConvertToFloatString($this->_40_s->CurrentValue)))
			$this->_40_s->CurrentValue = ConvertToFloatString($this->_40_s->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount_s->FormValue == $this->amount_s->CurrentValue && is_numeric(ConvertToFloatString($this->amount_s->CurrentValue)))
			$this->amount_s->CurrentValue = ConvertToFloatString($this->amount_s->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// grp
		// s_grp
		// product
		// rid
		// lot_no
		// margin_monthly
		// margin_%
		// packets_p
		// quantity_p
		// @_p
		// amount_p
		// packets_s
		// quantity_s
		// @_s
		// amount_s
		// godown
		// ref

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// margin_monthly
			$this->margin_monthly->ViewValue = $this->margin_monthly->CurrentValue;
			$this->margin_monthly->ViewValue = FormatNumber($this->margin_monthly->ViewValue, 2, -2, -2, -2);
			$this->margin_monthly->ViewCustomAttributes = "";

			// margin_%
			$this->margin_25->ViewValue = $this->margin_25->CurrentValue;
			$this->margin_25->ViewValue = FormatNumber($this->margin_25->ViewValue, 2, -2, -2, -2);
			$this->margin_25->ViewCustomAttributes = "";

			// packets_p
			$this->packets_p->ViewValue = $this->packets_p->CurrentValue;
			$this->packets_p->ViewValue = FormatNumber($this->packets_p->ViewValue, 2, -2, -2, -2);
			$this->packets_p->ViewCustomAttributes = "";

			// quantity_p
			$this->quantity_p->ViewValue = $this->quantity_p->CurrentValue;
			$this->quantity_p->ViewValue = FormatNumber($this->quantity_p->ViewValue, 2, -2, -2, -2);
			$this->quantity_p->ViewCustomAttributes = "";

			// @_p
			$this->_40_p->ViewValue = $this->_40_p->CurrentValue;
			$this->_40_p->ViewValue = FormatNumber($this->_40_p->ViewValue, 2, -2, -2, -2);
			$this->_40_p->ViewCustomAttributes = "";

			// amount_p
			$this->amount_p->ViewValue = $this->amount_p->CurrentValue;
			$this->amount_p->ViewValue = FormatNumber($this->amount_p->ViewValue, 2, -2, -2, -2);
			$this->amount_p->ViewCustomAttributes = "";

			// packets_s
			$this->packets_s->ViewValue = $this->packets_s->CurrentValue;
			$this->packets_s->ViewValue = FormatNumber($this->packets_s->ViewValue, 2, -2, -2, -2);
			$this->packets_s->ViewCustomAttributes = "";

			// quantity_s
			$this->quantity_s->ViewValue = $this->quantity_s->CurrentValue;
			$this->quantity_s->ViewValue = FormatNumber($this->quantity_s->ViewValue, 2, -2, -2, -2);
			$this->quantity_s->ViewCustomAttributes = "";

			// @_s
			$this->_40_s->ViewValue = $this->_40_s->CurrentValue;
			$this->_40_s->ViewValue = FormatNumber($this->_40_s->ViewValue, 2, -2, -2, -2);
			$this->_40_s->ViewCustomAttributes = "";

			// amount_s
			$this->amount_s->ViewValue = $this->amount_s->CurrentValue;
			$this->amount_s->ViewValue = FormatNumber($this->amount_s->ViewValue, 2, -2, -2, -2);
			$this->amount_s->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// ref
			$this->ref->ViewValue = $this->ref->CurrentValue;
			$this->ref->ViewCustomAttributes = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_glist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// margin_monthly
			$this->margin_monthly->LinkCustomAttributes = "";
			$this->margin_monthly->HrefValue = "";
			$this->margin_monthly->TooltipValue = "";

			// margin_%
			$this->margin_25->LinkCustomAttributes = "";
			$this->margin_25->HrefValue = "";
			$this->margin_25->TooltipValue = "";

			// packets_p
			$this->packets_p->LinkCustomAttributes = "";
			$this->packets_p->HrefValue = "";
			$this->packets_p->TooltipValue = "";

			// quantity_p
			$this->quantity_p->LinkCustomAttributes = "";
			$this->quantity_p->HrefValue = "";
			$this->quantity_p->TooltipValue = "";

			// @_p
			$this->_40_p->LinkCustomAttributes = "";
			$this->_40_p->HrefValue = "";
			$this->_40_p->TooltipValue = "";

			// amount_p
			$this->amount_p->LinkCustomAttributes = "";
			$this->amount_p->HrefValue = "";
			$this->amount_p->TooltipValue = "";

			// packets_s
			$this->packets_s->LinkCustomAttributes = "";
			$this->packets_s->HrefValue = "";
			$this->packets_s->TooltipValue = "";

			// quantity_s
			$this->quantity_s->LinkCustomAttributes = "";
			$this->quantity_s->HrefValue = "";
			$this->quantity_s->TooltipValue = "";

			// @_s
			$this->_40_s->LinkCustomAttributes = "";
			$this->_40_s->HrefValue = "";
			$this->_40_s->TooltipValue = "";

			// amount_s
			$this->amount_s->LinkCustomAttributes = "";
			$this->amount_s->HrefValue = "";
			$this->amount_s->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";
			$this->godown->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// margin_monthly
			$this->margin_monthly->EditAttrs["class"] = "form-control";
			$this->margin_monthly->EditCustomAttributes = "";
			$this->margin_monthly->EditValue = HtmlEncode($this->margin_monthly->CurrentValue);
			$this->margin_monthly->PlaceHolder = RemoveHtml($this->margin_monthly->caption());
			if (strval($this->margin_monthly->EditValue) <> "" && is_numeric($this->margin_monthly->EditValue))
				$this->margin_monthly->EditValue = FormatNumber($this->margin_monthly->EditValue, -2, -2, -2, -2);

			// margin_%
			$this->margin_25->EditAttrs["class"] = "form-control";
			$this->margin_25->EditCustomAttributes = "";
			$this->margin_25->EditValue = HtmlEncode($this->margin_25->CurrentValue);
			$this->margin_25->PlaceHolder = RemoveHtml($this->margin_25->caption());
			if (strval($this->margin_25->EditValue) <> "" && is_numeric($this->margin_25->EditValue))
				$this->margin_25->EditValue = FormatNumber($this->margin_25->EditValue, -2, -2, -2, -2);

			// packets_p
			$this->packets_p->EditAttrs["class"] = "form-control";
			$this->packets_p->EditCustomAttributes = "";
			$this->packets_p->EditValue = HtmlEncode($this->packets_p->CurrentValue);
			$this->packets_p->PlaceHolder = RemoveHtml($this->packets_p->caption());
			if (strval($this->packets_p->EditValue) <> "" && is_numeric($this->packets_p->EditValue))
				$this->packets_p->EditValue = FormatNumber($this->packets_p->EditValue, -2, -2, -2, -2);

			// quantity_p
			$this->quantity_p->EditAttrs["class"] = "form-control";
			$this->quantity_p->EditCustomAttributes = "";
			$this->quantity_p->EditValue = HtmlEncode($this->quantity_p->CurrentValue);
			$this->quantity_p->PlaceHolder = RemoveHtml($this->quantity_p->caption());
			if (strval($this->quantity_p->EditValue) <> "" && is_numeric($this->quantity_p->EditValue))
				$this->quantity_p->EditValue = FormatNumber($this->quantity_p->EditValue, -2, -2, -2, -2);

			// @_p
			$this->_40_p->EditAttrs["class"] = "form-control";
			$this->_40_p->EditCustomAttributes = "";
			$this->_40_p->EditValue = HtmlEncode($this->_40_p->CurrentValue);
			$this->_40_p->PlaceHolder = RemoveHtml($this->_40_p->caption());
			if (strval($this->_40_p->EditValue) <> "" && is_numeric($this->_40_p->EditValue))
				$this->_40_p->EditValue = FormatNumber($this->_40_p->EditValue, -2, -2, -2, -2);

			// amount_p
			$this->amount_p->EditAttrs["class"] = "form-control";
			$this->amount_p->EditCustomAttributes = "";
			$this->amount_p->EditValue = HtmlEncode($this->amount_p->CurrentValue);
			$this->amount_p->PlaceHolder = RemoveHtml($this->amount_p->caption());
			if (strval($this->amount_p->EditValue) <> "" && is_numeric($this->amount_p->EditValue))
				$this->amount_p->EditValue = FormatNumber($this->amount_p->EditValue, -2, -2, -2, -2);

			// packets_s
			$this->packets_s->EditAttrs["class"] = "form-control";
			$this->packets_s->EditCustomAttributes = "";
			$this->packets_s->EditValue = HtmlEncode($this->packets_s->CurrentValue);
			$this->packets_s->PlaceHolder = RemoveHtml($this->packets_s->caption());
			if (strval($this->packets_s->EditValue) <> "" && is_numeric($this->packets_s->EditValue))
				$this->packets_s->EditValue = FormatNumber($this->packets_s->EditValue, -2, -2, -2, -2);

			// quantity_s
			$this->quantity_s->EditAttrs["class"] = "form-control";
			$this->quantity_s->EditCustomAttributes = "";
			$this->quantity_s->EditValue = HtmlEncode($this->quantity_s->CurrentValue);
			$this->quantity_s->PlaceHolder = RemoveHtml($this->quantity_s->caption());
			if (strval($this->quantity_s->EditValue) <> "" && is_numeric($this->quantity_s->EditValue))
				$this->quantity_s->EditValue = FormatNumber($this->quantity_s->EditValue, -2, -2, -2, -2);

			// @_s
			$this->_40_s->EditAttrs["class"] = "form-control";
			$this->_40_s->EditCustomAttributes = "";
			$this->_40_s->EditValue = HtmlEncode($this->_40_s->CurrentValue);
			$this->_40_s->PlaceHolder = RemoveHtml($this->_40_s->caption());
			if (strval($this->_40_s->EditValue) <> "" && is_numeric($this->_40_s->EditValue))
				$this->_40_s->EditValue = FormatNumber($this->_40_s->EditValue, -2, -2, -2, -2);

			// amount_s
			$this->amount_s->EditAttrs["class"] = "form-control";
			$this->amount_s->EditCustomAttributes = "";
			$this->amount_s->EditValue = HtmlEncode($this->amount_s->CurrentValue);
			$this->amount_s->PlaceHolder = RemoveHtml($this->amount_s->caption());
			if (strval($this->amount_s->EditValue) <> "" && is_numeric($this->amount_s->EditValue))
				$this->amount_s->EditValue = FormatNumber($this->amount_s->EditValue, -2, -2, -2, -2);

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->CurrentValue));
			if ($curVal <> "")
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
			$this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
			$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

			// Add refer script
			// grp

			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_glist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// margin_monthly
			$this->margin_monthly->LinkCustomAttributes = "";
			$this->margin_monthly->HrefValue = "";

			// margin_%
			$this->margin_25->LinkCustomAttributes = "";
			$this->margin_25->HrefValue = "";

			// packets_p
			$this->packets_p->LinkCustomAttributes = "";
			$this->packets_p->HrefValue = "";

			// quantity_p
			$this->quantity_p->LinkCustomAttributes = "";
			$this->quantity_p->HrefValue = "";

			// @_p
			$this->_40_p->LinkCustomAttributes = "";
			$this->_40_p->HrefValue = "";

			// amount_p
			$this->amount_p->LinkCustomAttributes = "";
			$this->amount_p->HrefValue = "";

			// packets_s
			$this->packets_s->LinkCustomAttributes = "";
			$this->packets_s->HrefValue = "";

			// quantity_s
			$this->quantity_s->LinkCustomAttributes = "";
			$this->quantity_s->HrefValue = "";

			// @_s
			$this->_40_s->LinkCustomAttributes = "";
			$this->_40_s->HrefValue = "";

			// amount_s
			$this->amount_s->LinkCustomAttributes = "";
			$this->amount_s->HrefValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->rid->FormValue)) {
			AddMessage($FormError, $this->rid->errorMessage());
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->margin_monthly->Required) {
			if (!$this->margin_monthly->IsDetailKey && $this->margin_monthly->FormValue != NULL && $this->margin_monthly->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->margin_monthly->caption(), $this->margin_monthly->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->margin_monthly->FormValue)) {
			AddMessage($FormError, $this->margin_monthly->errorMessage());
		}
		if ($this->margin_25->Required) {
			if (!$this->margin_25->IsDetailKey && $this->margin_25->FormValue != NULL && $this->margin_25->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->margin_25->caption(), $this->margin_25->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->margin_25->FormValue)) {
			AddMessage($FormError, $this->margin_25->errorMessage());
		}
		if ($this->packets_p->Required) {
			if (!$this->packets_p->IsDetailKey && $this->packets_p->FormValue != NULL && $this->packets_p->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packets_p->caption(), $this->packets_p->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->packets_p->FormValue)) {
			AddMessage($FormError, $this->packets_p->errorMessage());
		}
		if ($this->quantity_p->Required) {
			if (!$this->quantity_p->IsDetailKey && $this->quantity_p->FormValue != NULL && $this->quantity_p->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity_p->caption(), $this->quantity_p->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity_p->FormValue)) {
			AddMessage($FormError, $this->quantity_p->errorMessage());
		}
		if ($this->_40_p->Required) {
			if (!$this->_40_p->IsDetailKey && $this->_40_p->FormValue != NULL && $this->_40_p->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40_p->caption(), $this->_40_p->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->_40_p->FormValue)) {
			AddMessage($FormError, $this->_40_p->errorMessage());
		}
		if ($this->amount_p->Required) {
			if (!$this->amount_p->IsDetailKey && $this->amount_p->FormValue != NULL && $this->amount_p->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount_p->caption(), $this->amount_p->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amount_p->FormValue)) {
			AddMessage($FormError, $this->amount_p->errorMessage());
		}
		if ($this->packets_s->Required) {
			if (!$this->packets_s->IsDetailKey && $this->packets_s->FormValue != NULL && $this->packets_s->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packets_s->caption(), $this->packets_s->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->packets_s->FormValue)) {
			AddMessage($FormError, $this->packets_s->errorMessage());
		}
		if ($this->quantity_s->Required) {
			if (!$this->quantity_s->IsDetailKey && $this->quantity_s->FormValue != NULL && $this->quantity_s->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity_s->caption(), $this->quantity_s->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity_s->FormValue)) {
			AddMessage($FormError, $this->quantity_s->errorMessage());
		}
		if ($this->_40_s->Required) {
			if (!$this->_40_s->IsDetailKey && $this->_40_s->FormValue != NULL && $this->_40_s->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40_s->caption(), $this->_40_s->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->_40_s->FormValue)) {
			AddMessage($FormError, $this->_40_s->errorMessage());
		}
		if ($this->amount_s->Required) {
			if (!$this->amount_s->IsDetailKey && $this->amount_s->FormValue != NULL && $this->amount_s->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount_s->caption(), $this->amount_s->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amount_s->FormValue)) {
			AddMessage($FormError, $this->amount_s->errorMessage());
		}
		if ($this->godown->Required) {
			if (!$this->godown->IsDetailKey && $this->godown->FormValue != NULL && $this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if ($this->ref->Required) {
			if (!$this->ref->IsDetailKey && $this->ref->FormValue != NULL && $this->ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, FALSE);

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, NULL, FALSE);

		// lot_no
		$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, NULL, FALSE);

		// margin_monthly
		$this->margin_monthly->setDbValueDef($rsnew, $this->margin_monthly->CurrentValue, NULL, FALSE);

		// margin_%
		$this->margin_25->setDbValueDef($rsnew, $this->margin_25->CurrentValue, NULL, FALSE);

		// packets_p
		$this->packets_p->setDbValueDef($rsnew, $this->packets_p->CurrentValue, NULL, FALSE);

		// quantity_p
		$this->quantity_p->setDbValueDef($rsnew, $this->quantity_p->CurrentValue, NULL, FALSE);

		// @_p
		$this->_40_p->setDbValueDef($rsnew, $this->_40_p->CurrentValue, NULL, FALSE);

		// amount_p
		$this->amount_p->setDbValueDef($rsnew, $this->amount_p->CurrentValue, NULL, FALSE);

		// packets_s
		$this->packets_s->setDbValueDef($rsnew, $this->packets_s->CurrentValue, NULL, FALSE);

		// quantity_s
		$this->quantity_s->setDbValueDef($rsnew, $this->quantity_s->CurrentValue, NULL, FALSE);

		// @_s
		$this->_40_s->setDbValueDef($rsnew, $this->_40_s->CurrentValue, NULL, FALSE);

		// amount_s
		$this->amount_s->setDbValueDef($rsnew, $this->amount_s->CurrentValue, NULL, FALSE);

		// godown
		$this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, NULL, FALSE);

		// ref
		$this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("margin_list_monthlylist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_godown":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>