<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for material order
 */
class material_order extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $order_no;
	public $date;
	public $name;
	public $delivery;
	public $ref;
	public $quantity;
	public $unit;
	public $price;
	public $taxes;
	public $delivery_terms;
	public $delivery_address;
	public $payments_terms;
	public $reference;
	public $remarks;
	public $receving_remarks;
	public $authorised;
	public $_print;
	public $updated;
	public $operator;
	public $datetime;
	public $a_operator;
	public $a_datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'material_order';
		$this->TableName = 'material order';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`material order`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('material_order', 'material order', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// order_no
		$this->order_no = new DbField('material_order', 'material order', 'x_order_no', 'order_no', '`order_no`', '`order_no`', 18, -1, FALSE, '`order_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_no->Sortable = TRUE; // Allow sort
		$this->order_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['order_no'] = &$this->order_no;

		// date
		$this->date = new DbField('material_order', 'material order', 'x_date', 'date', '`date`', CastDateFieldForLike('`date`', 0, "DB"), 135, 0, FALSE, '`date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->date->Sortable = TRUE; // Allow sort
		$this->date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['date'] = &$this->date;

		// name
		$this->name = new DbField('material_order', 'material order', 'x_name', 'name', '`name`', '`name`', 18, -1, FALSE, '`name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name->Sortable = TRUE; // Allow sort
		$this->name->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['name'] = &$this->name;

		// delivery
		$this->delivery = new DbField('material_order', 'material order', 'x_delivery', 'delivery', '`delivery`', CastDateFieldForLike('`delivery`', 0, "DB"), 135, 0, FALSE, '`delivery`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->delivery->Sortable = TRUE; // Allow sort
		$this->delivery->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['delivery'] = &$this->delivery;

		// ref
		$this->ref = new DbField('material_order', 'material order', 'x_ref', 'ref', '`ref`', '`ref`', 18, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ref->Sortable = TRUE; // Allow sort
		$this->ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ref'] = &$this->ref;

		// quantity
		$this->quantity = new DbField('material_order', 'material order', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// unit
		$this->unit = new DbField('material_order', 'material order', 'x_unit', 'unit', '`unit`', '`unit`', 18, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unit'] = &$this->unit;

		// price
		$this->price = new DbField('material_order', 'material order', 'x_price', 'price', '`price`', '`price`', 131, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// taxes
		$this->taxes = new DbField('material_order', 'material order', 'x_taxes', 'taxes', '`taxes`', '`taxes`', 131, -1, FALSE, '`taxes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->taxes->Sortable = TRUE; // Allow sort
		$this->taxes->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['taxes'] = &$this->taxes;

		// delivery_terms
		$this->delivery_terms = new DbField('material_order', 'material order', 'x_delivery_terms', 'delivery_terms', '`delivery_terms`', '`delivery_terms`', 17, -1, FALSE, '`delivery_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->delivery_terms->Sortable = TRUE; // Allow sort
		$this->delivery_terms->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['delivery_terms'] = &$this->delivery_terms;

		// delivery_address
		$this->delivery_address = new DbField('material_order', 'material order', 'x_delivery_address', 'delivery_address', '`delivery_address`', '`delivery_address`', 200, -1, FALSE, '`delivery_address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->delivery_address->Sortable = TRUE; // Allow sort
		$this->fields['delivery_address'] = &$this->delivery_address;

		// payments_terms
		$this->payments_terms = new DbField('material_order', 'material order', 'x_payments_terms', 'payments_terms', '`payments_terms`', '`payments_terms`', 200, -1, FALSE, '`payments_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payments_terms->Sortable = TRUE; // Allow sort
		$this->fields['payments_terms'] = &$this->payments_terms;

		// reference
		$this->reference = new DbField('material_order', 'material order', 'x_reference', 'reference', '`reference`', '`reference`', 200, -1, FALSE, '`reference`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reference->Sortable = TRUE; // Allow sort
		$this->fields['reference'] = &$this->reference;

		// remarks
		$this->remarks = new DbField('material_order', 'material order', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// receving_remarks
		$this->receving_remarks = new DbField('material_order', 'material order', 'x_receving_remarks', 'receving_remarks', '`receving_remarks`', '`receving_remarks`', 200, -1, FALSE, '`receving_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->receving_remarks->Sortable = TRUE; // Allow sort
		$this->fields['receving_remarks'] = &$this->receving_remarks;

		// authorised
		$this->authorised = new DbField('material_order', 'material order', 'x_authorised', 'authorised', '`authorised`', '`authorised`', 17, -1, FALSE, '`authorised`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->authorised->Sortable = TRUE; // Allow sort
		$this->authorised->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['authorised'] = &$this->authorised;

		// print
		$this->_print = new DbField('material_order', 'material order', 'x__print', 'print', '`print`', '`print`', 200, -1, FALSE, '`print`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_print->Sortable = TRUE; // Allow sort
		$this->fields['print'] = &$this->_print;

		// updated
		$this->updated = new DbField('material_order', 'material order', 'x_updated', 'updated', '`updated`', '`updated`', 17, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Nullable = FALSE; // NOT NULL field
		$this->updated->Required = TRUE; // Required field
		$this->updated->Sortable = TRUE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;

		// operator
		$this->operator = new DbField('material_order', 'material order', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('material_order', 'material order', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// a_operator
		$this->a_operator = new DbField('material_order', 'material order', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 18, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('material_order', 'material order', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 0, "DB"), 135, 0, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = TRUE; // Allow sort
		$this->a_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['a_datetime'] = &$this->a_datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`material order`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->order_no->DbValue = $row['order_no'];
		$this->date->DbValue = $row['date'];
		$this->name->DbValue = $row['name'];
		$this->delivery->DbValue = $row['delivery'];
		$this->ref->DbValue = $row['ref'];
		$this->quantity->DbValue = $row['quantity'];
		$this->unit->DbValue = $row['unit'];
		$this->price->DbValue = $row['price'];
		$this->taxes->DbValue = $row['taxes'];
		$this->delivery_terms->DbValue = $row['delivery_terms'];
		$this->delivery_address->DbValue = $row['delivery_address'];
		$this->payments_terms->DbValue = $row['payments_terms'];
		$this->reference->DbValue = $row['reference'];
		$this->remarks->DbValue = $row['remarks'];
		$this->receving_remarks->DbValue = $row['receving_remarks'];
		$this->authorised->DbValue = $row['authorised'];
		$this->_print->DbValue = $row['print'];
		$this->updated->DbValue = $row['updated'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "material_orderlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "material_orderview.php")
			return $Language->phrase("View");
		elseif ($pageName == "material_orderedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "material_orderadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "material_orderlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("material_orderview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("material_orderview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "material_orderadd.php?" . $this->getUrlParm($parm);
		else
			$url = "material_orderadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("material_orderedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("material_orderadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("material_orderdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->order_no->setDbValue($rs->fields('order_no'));
		$this->date->setDbValue($rs->fields('date'));
		$this->name->setDbValue($rs->fields('name'));
		$this->delivery->setDbValue($rs->fields('delivery'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->price->setDbValue($rs->fields('price'));
		$this->taxes->setDbValue($rs->fields('taxes'));
		$this->delivery_terms->setDbValue($rs->fields('delivery_terms'));
		$this->delivery_address->setDbValue($rs->fields('delivery_address'));
		$this->payments_terms->setDbValue($rs->fields('payments_terms'));
		$this->reference->setDbValue($rs->fields('reference'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->receving_remarks->setDbValue($rs->fields('receving_remarks'));
		$this->authorised->setDbValue($rs->fields('authorised'));
		$this->_print->setDbValue($rs->fields('print'));
		$this->updated->setDbValue($rs->fields('updated'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// order_no
		// date
		// name
		// delivery
		// ref
		// quantity
		// unit
		// price
		// taxes
		// delivery_terms
		// delivery_address
		// payments_terms
		// reference
		// remarks
		// receving_remarks
		// authorised
		// print
		// updated
		// operator
		// datetime
		// a_operator
		// a_datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// order_no
		$this->order_no->ViewValue = $this->order_no->CurrentValue;
		$this->order_no->ViewValue = FormatNumber($this->order_no->ViewValue, 0, -2, -2, -2);
		$this->order_no->ViewCustomAttributes = "";

		// date
		$this->date->ViewValue = $this->date->CurrentValue;
		$this->date->ViewValue = FormatDateTime($this->date->ViewValue, 0);
		$this->date->ViewCustomAttributes = "";

		// name
		$this->name->ViewValue = $this->name->CurrentValue;
		$this->name->ViewValue = FormatNumber($this->name->ViewValue, 0, -2, -2, -2);
		$this->name->ViewCustomAttributes = "";

		// delivery
		$this->delivery->ViewValue = $this->delivery->CurrentValue;
		$this->delivery->ViewValue = FormatDateTime($this->delivery->ViewValue, 0);
		$this->delivery->ViewCustomAttributes = "";

		// ref
		$this->ref->ViewValue = $this->ref->CurrentValue;
		$this->ref->ViewValue = FormatNumber($this->ref->ViewValue, 0, -2, -2, -2);
		$this->ref->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// unit
		$this->unit->ViewValue = $this->unit->CurrentValue;
		$this->unit->ViewValue = FormatNumber($this->unit->ViewValue, 0, -2, -2, -2);
		$this->unit->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// taxes
		$this->taxes->ViewValue = $this->taxes->CurrentValue;
		$this->taxes->ViewValue = FormatNumber($this->taxes->ViewValue, 2, -2, -2, -2);
		$this->taxes->ViewCustomAttributes = "";

		// delivery_terms
		$this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;
		$this->delivery_terms->ViewValue = FormatNumber($this->delivery_terms->ViewValue, 0, -2, -2, -2);
		$this->delivery_terms->ViewCustomAttributes = "";

		// delivery_address
		$this->delivery_address->ViewValue = $this->delivery_address->CurrentValue;
		$this->delivery_address->ViewCustomAttributes = "";

		// payments_terms
		$this->payments_terms->ViewValue = $this->payments_terms->CurrentValue;
		$this->payments_terms->ViewCustomAttributes = "";

		// reference
		$this->reference->ViewValue = $this->reference->CurrentValue;
		$this->reference->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// receving_remarks
		$this->receving_remarks->ViewValue = $this->receving_remarks->CurrentValue;
		$this->receving_remarks->ViewCustomAttributes = "";

		// authorised
		$this->authorised->ViewValue = $this->authorised->CurrentValue;
		$this->authorised->ViewValue = FormatNumber($this->authorised->ViewValue, 0, -2, -2, -2);
		$this->authorised->ViewCustomAttributes = "";

		// print
		$this->_print->ViewValue = $this->_print->CurrentValue;
		$this->_print->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
		$this->updated->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// a_operator
		$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
		$this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, 0, -2, -2, -2);
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
		$this->a_datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// order_no
		$this->order_no->LinkCustomAttributes = "";
		$this->order_no->HrefValue = "";
		$this->order_no->TooltipValue = "";

		// date
		$this->date->LinkCustomAttributes = "";
		$this->date->HrefValue = "";
		$this->date->TooltipValue = "";

		// name
		$this->name->LinkCustomAttributes = "";
		$this->name->HrefValue = "";
		$this->name->TooltipValue = "";

		// delivery
		$this->delivery->LinkCustomAttributes = "";
		$this->delivery->HrefValue = "";
		$this->delivery->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		$this->unit->HrefValue = "";
		$this->unit->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// taxes
		$this->taxes->LinkCustomAttributes = "";
		$this->taxes->HrefValue = "";
		$this->taxes->TooltipValue = "";

		// delivery_terms
		$this->delivery_terms->LinkCustomAttributes = "";
		$this->delivery_terms->HrefValue = "";
		$this->delivery_terms->TooltipValue = "";

		// delivery_address
		$this->delivery_address->LinkCustomAttributes = "";
		$this->delivery_address->HrefValue = "";
		$this->delivery_address->TooltipValue = "";

		// payments_terms
		$this->payments_terms->LinkCustomAttributes = "";
		$this->payments_terms->HrefValue = "";
		$this->payments_terms->TooltipValue = "";

		// reference
		$this->reference->LinkCustomAttributes = "";
		$this->reference->HrefValue = "";
		$this->reference->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// receving_remarks
		$this->receving_remarks->LinkCustomAttributes = "";
		$this->receving_remarks->HrefValue = "";
		$this->receving_remarks->TooltipValue = "";

		// authorised
		$this->authorised->LinkCustomAttributes = "";
		$this->authorised->HrefValue = "";
		$this->authorised->TooltipValue = "";

		// print
		$this->_print->LinkCustomAttributes = "";
		$this->_print->HrefValue = "";
		$this->_print->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// order_no
		$this->order_no->EditAttrs["class"] = "form-control";
		$this->order_no->EditCustomAttributes = "";
		$this->order_no->EditValue = $this->order_no->CurrentValue;
		$this->order_no->PlaceHolder = RemoveHtml($this->order_no->caption());

		// date
		$this->date->EditAttrs["class"] = "form-control";
		$this->date->EditCustomAttributes = "";
		$this->date->EditValue = FormatDateTime($this->date->CurrentValue, 8);
		$this->date->PlaceHolder = RemoveHtml($this->date->caption());

		// name
		$this->name->EditAttrs["class"] = "form-control";
		$this->name->EditCustomAttributes = "";
		$this->name->EditValue = $this->name->CurrentValue;
		$this->name->PlaceHolder = RemoveHtml($this->name->caption());

		// delivery
		$this->delivery->EditAttrs["class"] = "form-control";
		$this->delivery->EditCustomAttributes = "";
		$this->delivery->EditValue = FormatDateTime($this->delivery->CurrentValue, 8);
		$this->delivery->PlaceHolder = RemoveHtml($this->delivery->caption());

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";
		$this->ref->EditValue = $this->ref->CurrentValue;
		$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		$this->unit->EditValue = $this->unit->CurrentValue;
		$this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

		// taxes
		$this->taxes->EditAttrs["class"] = "form-control";
		$this->taxes->EditCustomAttributes = "";
		$this->taxes->EditValue = $this->taxes->CurrentValue;
		$this->taxes->PlaceHolder = RemoveHtml($this->taxes->caption());
		if (strval($this->taxes->EditValue) <> "" && is_numeric($this->taxes->EditValue))
			$this->taxes->EditValue = FormatNumber($this->taxes->EditValue, -2, -2, -2, -2);

		// delivery_terms
		$this->delivery_terms->EditAttrs["class"] = "form-control";
		$this->delivery_terms->EditCustomAttributes = "";
		$this->delivery_terms->EditValue = $this->delivery_terms->CurrentValue;
		$this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

		// delivery_address
		$this->delivery_address->EditAttrs["class"] = "form-control";
		$this->delivery_address->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->delivery_address->CurrentValue = HtmlDecode($this->delivery_address->CurrentValue);
		$this->delivery_address->EditValue = $this->delivery_address->CurrentValue;
		$this->delivery_address->PlaceHolder = RemoveHtml($this->delivery_address->caption());

		// payments_terms
		$this->payments_terms->EditAttrs["class"] = "form-control";
		$this->payments_terms->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payments_terms->CurrentValue = HtmlDecode($this->payments_terms->CurrentValue);
		$this->payments_terms->EditValue = $this->payments_terms->CurrentValue;
		$this->payments_terms->PlaceHolder = RemoveHtml($this->payments_terms->caption());

		// reference
		$this->reference->EditAttrs["class"] = "form-control";
		$this->reference->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
		$this->reference->EditValue = $this->reference->CurrentValue;
		$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// receving_remarks
		$this->receving_remarks->EditAttrs["class"] = "form-control";
		$this->receving_remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->receving_remarks->CurrentValue = HtmlDecode($this->receving_remarks->CurrentValue);
		$this->receving_remarks->EditValue = $this->receving_remarks->CurrentValue;
		$this->receving_remarks->PlaceHolder = RemoveHtml($this->receving_remarks->caption());

		// authorised
		$this->authorised->EditAttrs["class"] = "form-control";
		$this->authorised->EditCustomAttributes = "";
		$this->authorised->EditValue = $this->authorised->CurrentValue;
		$this->authorised->PlaceHolder = RemoveHtml($this->authorised->caption());

		// print
		$this->_print->EditAttrs["class"] = "form-control";
		$this->_print->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_print->CurrentValue = HtmlDecode($this->_print->CurrentValue);
		$this->_print->EditValue = $this->_print->CurrentValue;
		$this->_print->PlaceHolder = RemoveHtml($this->_print->caption());

		// updated
		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// operator
		$this->operator->EditAttrs["class"] = "form-control";
		$this->operator->EditCustomAttributes = "";
		$this->operator->EditValue = $this->operator->CurrentValue;
		$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

		// datetime
		$this->datetime->EditAttrs["class"] = "form-control";
		$this->datetime->EditCustomAttributes = "";
		$this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, 8);
		$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

		// a_operator
		$this->a_operator->EditAttrs["class"] = "form-control";
		$this->a_operator->EditCustomAttributes = "";
		$this->a_operator->EditValue = $this->a_operator->CurrentValue;
		$this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

		// a_datetime
		$this->a_datetime->EditAttrs["class"] = "form-control";
		$this->a_datetime->EditCustomAttributes = "";
		$this->a_datetime->EditValue = FormatDateTime($this->a_datetime->CurrentValue, 8);
		$this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->order_no);
					$doc->exportCaption($this->date);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->delivery);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->taxes);
					$doc->exportCaption($this->delivery_terms);
					$doc->exportCaption($this->delivery_address);
					$doc->exportCaption($this->payments_terms);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->receving_remarks);
					$doc->exportCaption($this->authorised);
					$doc->exportCaption($this->_print);
					$doc->exportCaption($this->updated);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->order_no);
					$doc->exportCaption($this->date);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->delivery);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->taxes);
					$doc->exportCaption($this->delivery_terms);
					$doc->exportCaption($this->delivery_address);
					$doc->exportCaption($this->payments_terms);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->receving_remarks);
					$doc->exportCaption($this->authorised);
					$doc->exportCaption($this->_print);
					$doc->exportCaption($this->updated);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->order_no);
						$doc->exportField($this->date);
						$doc->exportField($this->name);
						$doc->exportField($this->delivery);
						$doc->exportField($this->ref);
						$doc->exportField($this->quantity);
						$doc->exportField($this->unit);
						$doc->exportField($this->price);
						$doc->exportField($this->taxes);
						$doc->exportField($this->delivery_terms);
						$doc->exportField($this->delivery_address);
						$doc->exportField($this->payments_terms);
						$doc->exportField($this->reference);
						$doc->exportField($this->remarks);
						$doc->exportField($this->receving_remarks);
						$doc->exportField($this->authorised);
						$doc->exportField($this->_print);
						$doc->exportField($this->updated);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->order_no);
						$doc->exportField($this->date);
						$doc->exportField($this->name);
						$doc->exportField($this->delivery);
						$doc->exportField($this->ref);
						$doc->exportField($this->quantity);
						$doc->exportField($this->unit);
						$doc->exportField($this->price);
						$doc->exportField($this->taxes);
						$doc->exportField($this->delivery_terms);
						$doc->exportField($this->delivery_address);
						$doc->exportField($this->payments_terms);
						$doc->exportField($this->reference);
						$doc->exportField($this->remarks);
						$doc->exportField($this->receving_remarks);
						$doc->exportField($this->authorised);
						$doc->exportField($this->_print);
						$doc->exportField($this->updated);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>