<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_order_edit extends material_order
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material order';

	// Page object name
	public $PageObjName = "material_order_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_order)
		if (!isset($GLOBALS["material_order"]) || get_class($GLOBALS["material_order"]) == PROJECT_NAMESPACE . "material_order") {
			$GLOBALS["material_order"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_order"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material order');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_order;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_order);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "material_orderview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("material_orderlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->order_no->setVisibility();
		$this->date->setVisibility();
		$this->name->setVisibility();
		$this->delivery->setVisibility();
		$this->ref->setVisibility();
		$this->quantity->setVisibility();
		$this->unit->setVisibility();
		$this->price->setVisibility();
		$this->taxes->setVisibility();
		$this->delivery_terms->setVisibility();
		$this->delivery_address->setVisibility();
		$this->payments_terms->setVisibility();
		$this->reference->setVisibility();
		$this->remarks->setVisibility();
		$this->receving_remarks->setVisibility();
		$this->authorised->setVisibility();
		$this->_print->setVisibility();
		$this->updated->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->setVisibility();
		$this->a_datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("material_orderlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "material_orderlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'order_no' first before field var 'x_order_no'
		$val = $CurrentForm->hasValue("order_no") ? $CurrentForm->getValue("order_no") : $CurrentForm->getValue("x_order_no");
		if (!$this->order_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_no->Visible = FALSE; // Disable update for API request
			else
				$this->order_no->setFormValue($val);
		}

		// Check field name 'date' first before field var 'x_date'
		$val = $CurrentForm->hasValue("date") ? $CurrentForm->getValue("date") : $CurrentForm->getValue("x_date");
		if (!$this->date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->date->Visible = FALSE; // Disable update for API request
			else
				$this->date->setFormValue($val);
			$this->date->CurrentValue = UnFormatDateTime($this->date->CurrentValue, 0);
		}

		// Check field name 'name' first before field var 'x_name'
		$val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
		if (!$this->name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->name->Visible = FALSE; // Disable update for API request
			else
				$this->name->setFormValue($val);
		}

		// Check field name 'delivery' first before field var 'x_delivery'
		$val = $CurrentForm->hasValue("delivery") ? $CurrentForm->getValue("delivery") : $CurrentForm->getValue("x_delivery");
		if (!$this->delivery->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery->Visible = FALSE; // Disable update for API request
			else
				$this->delivery->setFormValue($val);
			$this->delivery->CurrentValue = UnFormatDateTime($this->delivery->CurrentValue, 0);
		}

		// Check field name 'ref' first before field var 'x_ref'
		$val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
		if (!$this->ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ref->Visible = FALSE; // Disable update for API request
			else
				$this->ref->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'taxes' first before field var 'x_taxes'
		$val = $CurrentForm->hasValue("taxes") ? $CurrentForm->getValue("taxes") : $CurrentForm->getValue("x_taxes");
		if (!$this->taxes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->taxes->Visible = FALSE; // Disable update for API request
			else
				$this->taxes->setFormValue($val);
		}

		// Check field name 'delivery_terms' first before field var 'x_delivery_terms'
		$val = $CurrentForm->hasValue("delivery_terms") ? $CurrentForm->getValue("delivery_terms") : $CurrentForm->getValue("x_delivery_terms");
		if (!$this->delivery_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_terms->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_terms->setFormValue($val);
		}

		// Check field name 'delivery_address' first before field var 'x_delivery_address'
		$val = $CurrentForm->hasValue("delivery_address") ? $CurrentForm->getValue("delivery_address") : $CurrentForm->getValue("x_delivery_address");
		if (!$this->delivery_address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_address->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_address->setFormValue($val);
		}

		// Check field name 'payments_terms' first before field var 'x_payments_terms'
		$val = $CurrentForm->hasValue("payments_terms") ? $CurrentForm->getValue("payments_terms") : $CurrentForm->getValue("x_payments_terms");
		if (!$this->payments_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payments_terms->Visible = FALSE; // Disable update for API request
			else
				$this->payments_terms->setFormValue($val);
		}

		// Check field name 'reference' first before field var 'x_reference'
		$val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
		if (!$this->reference->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reference->Visible = FALSE; // Disable update for API request
			else
				$this->reference->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'receving_remarks' first before field var 'x_receving_remarks'
		$val = $CurrentForm->hasValue("receving_remarks") ? $CurrentForm->getValue("receving_remarks") : $CurrentForm->getValue("x_receving_remarks");
		if (!$this->receving_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->receving_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->receving_remarks->setFormValue($val);
		}

		// Check field name 'authorised' first before field var 'x_authorised'
		$val = $CurrentForm->hasValue("authorised") ? $CurrentForm->getValue("authorised") : $CurrentForm->getValue("x_authorised");
		if (!$this->authorised->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->authorised->Visible = FALSE; // Disable update for API request
			else
				$this->authorised->setFormValue($val);
		}

		// Check field name 'print' first before field var 'x__print'
		$val = $CurrentForm->hasValue("print") ? $CurrentForm->getValue("print") : $CurrentForm->getValue("x__print");
		if (!$this->_print->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_print->Visible = FALSE; // Disable update for API request
			else
				$this->_print->setFormValue($val);
		}

		// Check field name 'updated' first before field var 'x_updated'
		$val = $CurrentForm->hasValue("updated") ? $CurrentForm->getValue("updated") : $CurrentForm->getValue("x_updated");
		if (!$this->updated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->updated->Visible = FALSE; // Disable update for API request
			else
				$this->updated->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'a_operator' first before field var 'x_a_operator'
		$val = $CurrentForm->hasValue("a_operator") ? $CurrentForm->getValue("a_operator") : $CurrentForm->getValue("x_a_operator");
		if (!$this->a_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->a_operator->Visible = FALSE; // Disable update for API request
			else
				$this->a_operator->setFormValue($val);
		}

		// Check field name 'a_datetime' first before field var 'x_a_datetime'
		$val = $CurrentForm->hasValue("a_datetime") ? $CurrentForm->getValue("a_datetime") : $CurrentForm->getValue("x_a_datetime");
		if (!$this->a_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->a_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->a_datetime->setFormValue($val);
			$this->a_datetime->CurrentValue = UnFormatDateTime($this->a_datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->order_no->CurrentValue = $this->order_no->FormValue;
		$this->date->CurrentValue = $this->date->FormValue;
		$this->date->CurrentValue = UnFormatDateTime($this->date->CurrentValue, 0);
		$this->name->CurrentValue = $this->name->FormValue;
		$this->delivery->CurrentValue = $this->delivery->FormValue;
		$this->delivery->CurrentValue = UnFormatDateTime($this->delivery->CurrentValue, 0);
		$this->ref->CurrentValue = $this->ref->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->taxes->CurrentValue = $this->taxes->FormValue;
		$this->delivery_terms->CurrentValue = $this->delivery_terms->FormValue;
		$this->delivery_address->CurrentValue = $this->delivery_address->FormValue;
		$this->payments_terms->CurrentValue = $this->payments_terms->FormValue;
		$this->reference->CurrentValue = $this->reference->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->receving_remarks->CurrentValue = $this->receving_remarks->FormValue;
		$this->authorised->CurrentValue = $this->authorised->FormValue;
		$this->_print->CurrentValue = $this->_print->FormValue;
		$this->updated->CurrentValue = $this->updated->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->a_operator->CurrentValue = $this->a_operator->FormValue;
		$this->a_datetime->CurrentValue = $this->a_datetime->FormValue;
		$this->a_datetime->CurrentValue = UnFormatDateTime($this->a_datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->order_no->setDbValue($row['order_no']);
		$this->date->setDbValue($row['date']);
		$this->name->setDbValue($row['name']);
		$this->delivery->setDbValue($row['delivery']);
		$this->ref->setDbValue($row['ref']);
		$this->quantity->setDbValue($row['quantity']);
		$this->unit->setDbValue($row['unit']);
		$this->price->setDbValue($row['price']);
		$this->taxes->setDbValue($row['taxes']);
		$this->delivery_terms->setDbValue($row['delivery_terms']);
		$this->delivery_address->setDbValue($row['delivery_address']);
		$this->payments_terms->setDbValue($row['payments_terms']);
		$this->reference->setDbValue($row['reference']);
		$this->remarks->setDbValue($row['remarks']);
		$this->receving_remarks->setDbValue($row['receving_remarks']);
		$this->authorised->setDbValue($row['authorised']);
		$this->_print->setDbValue($row['print']);
		$this->updated->setDbValue($row['updated']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['order_no'] = NULL;
		$row['date'] = NULL;
		$row['name'] = NULL;
		$row['delivery'] = NULL;
		$row['ref'] = NULL;
		$row['quantity'] = NULL;
		$row['unit'] = NULL;
		$row['price'] = NULL;
		$row['taxes'] = NULL;
		$row['delivery_terms'] = NULL;
		$row['delivery_address'] = NULL;
		$row['payments_terms'] = NULL;
		$row['reference'] = NULL;
		$row['remarks'] = NULL;
		$row['receving_remarks'] = NULL;
		$row['authorised'] = NULL;
		$row['print'] = NULL;
		$row['updated'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->taxes->FormValue == $this->taxes->CurrentValue && is_numeric(ConvertToFloatString($this->taxes->CurrentValue)))
			$this->taxes->CurrentValue = ConvertToFloatString($this->taxes->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// order_no
		// date
		// name
		// delivery
		// ref
		// quantity
		// unit
		// price
		// taxes
		// delivery_terms
		// delivery_address
		// payments_terms
		// reference
		// remarks
		// receving_remarks
		// authorised
		// print
		// updated
		// operator
		// datetime
		// a_operator
		// a_datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// order_no
			$this->order_no->ViewValue = $this->order_no->CurrentValue;
			$this->order_no->ViewValue = FormatNumber($this->order_no->ViewValue, 0, -2, -2, -2);
			$this->order_no->ViewCustomAttributes = "";

			// date
			$this->date->ViewValue = $this->date->CurrentValue;
			$this->date->ViewValue = FormatDateTime($this->date->ViewValue, 0);
			$this->date->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewValue = FormatNumber($this->name->ViewValue, 0, -2, -2, -2);
			$this->name->ViewCustomAttributes = "";

			// delivery
			$this->delivery->ViewValue = $this->delivery->CurrentValue;
			$this->delivery->ViewValue = FormatDateTime($this->delivery->ViewValue, 0);
			$this->delivery->ViewCustomAttributes = "";

			// ref
			$this->ref->ViewValue = $this->ref->CurrentValue;
			$this->ref->ViewValue = FormatNumber($this->ref->ViewValue, 0, -2, -2, -2);
			$this->ref->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// unit
			$this->unit->ViewValue = $this->unit->CurrentValue;
			$this->unit->ViewValue = FormatNumber($this->unit->ViewValue, 0, -2, -2, -2);
			$this->unit->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// taxes
			$this->taxes->ViewValue = $this->taxes->CurrentValue;
			$this->taxes->ViewValue = FormatNumber($this->taxes->ViewValue, 2, -2, -2, -2);
			$this->taxes->ViewCustomAttributes = "";

			// delivery_terms
			$this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;
			$this->delivery_terms->ViewValue = FormatNumber($this->delivery_terms->ViewValue, 0, -2, -2, -2);
			$this->delivery_terms->ViewCustomAttributes = "";

			// delivery_address
			$this->delivery_address->ViewValue = $this->delivery_address->CurrentValue;
			$this->delivery_address->ViewCustomAttributes = "";

			// payments_terms
			$this->payments_terms->ViewValue = $this->payments_terms->CurrentValue;
			$this->payments_terms->ViewCustomAttributes = "";

			// reference
			$this->reference->ViewValue = $this->reference->CurrentValue;
			$this->reference->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// receving_remarks
			$this->receving_remarks->ViewValue = $this->receving_remarks->CurrentValue;
			$this->receving_remarks->ViewCustomAttributes = "";

			// authorised
			$this->authorised->ViewValue = $this->authorised->CurrentValue;
			$this->authorised->ViewValue = FormatNumber($this->authorised->ViewValue, 0, -2, -2, -2);
			$this->authorised->ViewCustomAttributes = "";

			// print
			$this->_print->ViewValue = $this->_print->CurrentValue;
			$this->_print->ViewCustomAttributes = "";

			// updated
			$this->updated->ViewValue = $this->updated->CurrentValue;
			$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
			$this->updated->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
			$this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, 0, -2, -2, -2);
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
			$this->a_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// order_no
			$this->order_no->LinkCustomAttributes = "";
			$this->order_no->HrefValue = "";
			$this->order_no->TooltipValue = "";

			// date
			$this->date->LinkCustomAttributes = "";
			$this->date->HrefValue = "";
			$this->date->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// delivery
			$this->delivery->LinkCustomAttributes = "";
			$this->delivery->HrefValue = "";
			$this->delivery->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// taxes
			$this->taxes->LinkCustomAttributes = "";
			$this->taxes->HrefValue = "";
			$this->taxes->TooltipValue = "";

			// delivery_terms
			$this->delivery_terms->LinkCustomAttributes = "";
			$this->delivery_terms->HrefValue = "";
			$this->delivery_terms->TooltipValue = "";

			// delivery_address
			$this->delivery_address->LinkCustomAttributes = "";
			$this->delivery_address->HrefValue = "";
			$this->delivery_address->TooltipValue = "";

			// payments_terms
			$this->payments_terms->LinkCustomAttributes = "";
			$this->payments_terms->HrefValue = "";
			$this->payments_terms->TooltipValue = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";
			$this->reference->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// receving_remarks
			$this->receving_remarks->LinkCustomAttributes = "";
			$this->receving_remarks->HrefValue = "";
			$this->receving_remarks->TooltipValue = "";

			// authorised
			$this->authorised->LinkCustomAttributes = "";
			$this->authorised->HrefValue = "";
			$this->authorised->TooltipValue = "";

			// print
			$this->_print->LinkCustomAttributes = "";
			$this->_print->HrefValue = "";
			$this->_print->TooltipValue = "";

			// updated
			$this->updated->LinkCustomAttributes = "";
			$this->updated->HrefValue = "";
			$this->updated->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";
			$this->a_datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// order_no
			$this->order_no->EditAttrs["class"] = "form-control";
			$this->order_no->EditCustomAttributes = "";
			$this->order_no->EditValue = HtmlEncode($this->order_no->CurrentValue);
			$this->order_no->PlaceHolder = RemoveHtml($this->order_no->caption());

			// date
			$this->date->EditAttrs["class"] = "form-control";
			$this->date->EditCustomAttributes = "";
			$this->date->EditValue = HtmlEncode(FormatDateTime($this->date->CurrentValue, 8));
			$this->date->PlaceHolder = RemoveHtml($this->date->caption());

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			$this->name->EditValue = HtmlEncode($this->name->CurrentValue);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// delivery
			$this->delivery->EditAttrs["class"] = "form-control";
			$this->delivery->EditCustomAttributes = "";
			$this->delivery->EditValue = HtmlEncode(FormatDateTime($this->delivery->CurrentValue, 8));
			$this->delivery->PlaceHolder = RemoveHtml($this->delivery->caption());

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			$this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
			$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$this->unit->EditValue = HtmlEncode($this->unit->CurrentValue);
			$this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

			// taxes
			$this->taxes->EditAttrs["class"] = "form-control";
			$this->taxes->EditCustomAttributes = "";
			$this->taxes->EditValue = HtmlEncode($this->taxes->CurrentValue);
			$this->taxes->PlaceHolder = RemoveHtml($this->taxes->caption());
			if (strval($this->taxes->EditValue) <> "" && is_numeric($this->taxes->EditValue))
				$this->taxes->EditValue = FormatNumber($this->taxes->EditValue, -2, -2, -2, -2);

			// delivery_terms
			$this->delivery_terms->EditAttrs["class"] = "form-control";
			$this->delivery_terms->EditCustomAttributes = "";
			$this->delivery_terms->EditValue = HtmlEncode($this->delivery_terms->CurrentValue);
			$this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

			// delivery_address
			$this->delivery_address->EditAttrs["class"] = "form-control";
			$this->delivery_address->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->delivery_address->CurrentValue = HtmlDecode($this->delivery_address->CurrentValue);
			$this->delivery_address->EditValue = HtmlEncode($this->delivery_address->CurrentValue);
			$this->delivery_address->PlaceHolder = RemoveHtml($this->delivery_address->caption());

			// payments_terms
			$this->payments_terms->EditAttrs["class"] = "form-control";
			$this->payments_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payments_terms->CurrentValue = HtmlDecode($this->payments_terms->CurrentValue);
			$this->payments_terms->EditValue = HtmlEncode($this->payments_terms->CurrentValue);
			$this->payments_terms->PlaceHolder = RemoveHtml($this->payments_terms->caption());

			// reference
			$this->reference->EditAttrs["class"] = "form-control";
			$this->reference->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
			$this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
			$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// receving_remarks
			$this->receving_remarks->EditAttrs["class"] = "form-control";
			$this->receving_remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->receving_remarks->CurrentValue = HtmlDecode($this->receving_remarks->CurrentValue);
			$this->receving_remarks->EditValue = HtmlEncode($this->receving_remarks->CurrentValue);
			$this->receving_remarks->PlaceHolder = RemoveHtml($this->receving_remarks->caption());

			// authorised
			$this->authorised->EditAttrs["class"] = "form-control";
			$this->authorised->EditCustomAttributes = "";
			$this->authorised->EditValue = HtmlEncode($this->authorised->CurrentValue);
			$this->authorised->PlaceHolder = RemoveHtml($this->authorised->caption());

			// print
			$this->_print->EditAttrs["class"] = "form-control";
			$this->_print->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_print->CurrentValue = HtmlDecode($this->_print->CurrentValue);
			$this->_print->EditValue = HtmlEncode($this->_print->CurrentValue);
			$this->_print->PlaceHolder = RemoveHtml($this->_print->caption());

			// updated
			$this->updated->EditAttrs["class"] = "form-control";
			$this->updated->EditCustomAttributes = "";
			$this->updated->EditValue = HtmlEncode($this->updated->CurrentValue);
			$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->CurrentValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// a_operator
			$this->a_operator->EditAttrs["class"] = "form-control";
			$this->a_operator->EditCustomAttributes = "";
			$this->a_operator->EditValue = HtmlEncode($this->a_operator->CurrentValue);
			$this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

			// a_datetime
			$this->a_datetime->EditAttrs["class"] = "form-control";
			$this->a_datetime->EditCustomAttributes = "";
			$this->a_datetime->EditValue = HtmlEncode(FormatDateTime($this->a_datetime->CurrentValue, 8));
			$this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// order_no
			$this->order_no->LinkCustomAttributes = "";
			$this->order_no->HrefValue = "";

			// date
			$this->date->LinkCustomAttributes = "";
			$this->date->HrefValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";

			// delivery
			$this->delivery->LinkCustomAttributes = "";
			$this->delivery->HrefValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// taxes
			$this->taxes->LinkCustomAttributes = "";
			$this->taxes->HrefValue = "";

			// delivery_terms
			$this->delivery_terms->LinkCustomAttributes = "";
			$this->delivery_terms->HrefValue = "";

			// delivery_address
			$this->delivery_address->LinkCustomAttributes = "";
			$this->delivery_address->HrefValue = "";

			// payments_terms
			$this->payments_terms->LinkCustomAttributes = "";
			$this->payments_terms->HrefValue = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// receving_remarks
			$this->receving_remarks->LinkCustomAttributes = "";
			$this->receving_remarks->HrefValue = "";

			// authorised
			$this->authorised->LinkCustomAttributes = "";
			$this->authorised->HrefValue = "";

			// print
			$this->_print->LinkCustomAttributes = "";
			$this->_print->HrefValue = "";

			// updated
			$this->updated->LinkCustomAttributes = "";
			$this->updated->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->order_no->Required) {
			if (!$this->order_no->IsDetailKey && $this->order_no->FormValue != NULL && $this->order_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_no->caption(), $this->order_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->order_no->FormValue)) {
			AddMessage($FormError, $this->order_no->errorMessage());
		}
		if ($this->date->Required) {
			if (!$this->date->IsDetailKey && $this->date->FormValue != NULL && $this->date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->date->caption(), $this->date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->date->FormValue)) {
			AddMessage($FormError, $this->date->errorMessage());
		}
		if ($this->name->Required) {
			if (!$this->name->IsDetailKey && $this->name->FormValue != NULL && $this->name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->name->FormValue)) {
			AddMessage($FormError, $this->name->errorMessage());
		}
		if ($this->delivery->Required) {
			if (!$this->delivery->IsDetailKey && $this->delivery->FormValue != NULL && $this->delivery->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery->caption(), $this->delivery->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->delivery->FormValue)) {
			AddMessage($FormError, $this->delivery->errorMessage());
		}
		if ($this->ref->Required) {
			if (!$this->ref->IsDetailKey && $this->ref->FormValue != NULL && $this->ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->ref->FormValue)) {
			AddMessage($FormError, $this->ref->errorMessage());
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->unit->FormValue)) {
			AddMessage($FormError, $this->unit->errorMessage());
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->price->FormValue)) {
			AddMessage($FormError, $this->price->errorMessage());
		}
		if ($this->taxes->Required) {
			if (!$this->taxes->IsDetailKey && $this->taxes->FormValue != NULL && $this->taxes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->taxes->caption(), $this->taxes->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->taxes->FormValue)) {
			AddMessage($FormError, $this->taxes->errorMessage());
		}
		if ($this->delivery_terms->Required) {
			if (!$this->delivery_terms->IsDetailKey && $this->delivery_terms->FormValue != NULL && $this->delivery_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_terms->caption(), $this->delivery_terms->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->delivery_terms->FormValue)) {
			AddMessage($FormError, $this->delivery_terms->errorMessage());
		}
		if ($this->delivery_address->Required) {
			if (!$this->delivery_address->IsDetailKey && $this->delivery_address->FormValue != NULL && $this->delivery_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_address->caption(), $this->delivery_address->RequiredErrorMessage));
			}
		}
		if ($this->payments_terms->Required) {
			if (!$this->payments_terms->IsDetailKey && $this->payments_terms->FormValue != NULL && $this->payments_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payments_terms->caption(), $this->payments_terms->RequiredErrorMessage));
			}
		}
		if ($this->reference->Required) {
			if (!$this->reference->IsDetailKey && $this->reference->FormValue != NULL && $this->reference->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->receving_remarks->Required) {
			if (!$this->receving_remarks->IsDetailKey && $this->receving_remarks->FormValue != NULL && $this->receving_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->receving_remarks->caption(), $this->receving_remarks->RequiredErrorMessage));
			}
		}
		if ($this->authorised->Required) {
			if (!$this->authorised->IsDetailKey && $this->authorised->FormValue != NULL && $this->authorised->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->authorised->caption(), $this->authorised->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->authorised->FormValue)) {
			AddMessage($FormError, $this->authorised->errorMessage());
		}
		if ($this->_print->Required) {
			if (!$this->_print->IsDetailKey && $this->_print->FormValue != NULL && $this->_print->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_print->caption(), $this->_print->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->updated->FormValue)) {
			AddMessage($FormError, $this->updated->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->operator->FormValue)) {
			AddMessage($FormError, $this->operator->errorMessage());
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->datetime->FormValue)) {
			AddMessage($FormError, $this->datetime->errorMessage());
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->a_operator->FormValue)) {
			AddMessage($FormError, $this->a_operator->errorMessage());
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->a_datetime->FormValue)) {
			AddMessage($FormError, $this->a_datetime->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// order_no
			$this->order_no->setDbValueDef($rsnew, $this->order_no->CurrentValue, NULL, $this->order_no->ReadOnly);

			// date
			$this->date->setDbValueDef($rsnew, UnFormatDateTime($this->date->CurrentValue, 0), NULL, $this->date->ReadOnly);

			// name
			$this->name->setDbValueDef($rsnew, $this->name->CurrentValue, NULL, $this->name->ReadOnly);

			// delivery
			$this->delivery->setDbValueDef($rsnew, UnFormatDateTime($this->delivery->CurrentValue, 0), NULL, $this->delivery->ReadOnly);

			// ref
			$this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, NULL, $this->ref->ReadOnly);

			// quantity
			$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, $this->quantity->ReadOnly);

			// unit
			$this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, NULL, $this->unit->ReadOnly);

			// price
			$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, NULL, $this->price->ReadOnly);

			// taxes
			$this->taxes->setDbValueDef($rsnew, $this->taxes->CurrentValue, NULL, $this->taxes->ReadOnly);

			// delivery_terms
			$this->delivery_terms->setDbValueDef($rsnew, $this->delivery_terms->CurrentValue, NULL, $this->delivery_terms->ReadOnly);

			// delivery_address
			$this->delivery_address->setDbValueDef($rsnew, $this->delivery_address->CurrentValue, NULL, $this->delivery_address->ReadOnly);

			// payments_terms
			$this->payments_terms->setDbValueDef($rsnew, $this->payments_terms->CurrentValue, NULL, $this->payments_terms->ReadOnly);

			// reference
			$this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, NULL, $this->reference->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// receving_remarks
			$this->receving_remarks->setDbValueDef($rsnew, $this->receving_remarks->CurrentValue, NULL, $this->receving_remarks->ReadOnly);

			// authorised
			$this->authorised->setDbValueDef($rsnew, $this->authorised->CurrentValue, NULL, $this->authorised->ReadOnly);

			// print
			$this->_print->setDbValueDef($rsnew, $this->_print->CurrentValue, NULL, $this->_print->ReadOnly);

			// updated
			$this->updated->setDbValueDef($rsnew, $this->updated->CurrentValue, 0, $this->updated->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, NULL, $this->operator->ReadOnly);

			// datetime
			$this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, 0), NULL, $this->datetime->ReadOnly);

			// a_operator
			$this->a_operator->setDbValueDef($rsnew, $this->a_operator->CurrentValue, NULL, $this->a_operator->ReadOnly);

			// a_datetime
			$this->a_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->a_datetime->CurrentValue, 0), NULL, $this->a_datetime->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("material_orderlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>