<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for material_out
 */
class material_out extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $process;
	public $process_type;
	public $issue_to_unit;
	public $issue_to;
	public $godown;
	public $jc_no;
	public $gp_no;
	public $grp;
	public $s_grp;
	public $product;
	public $rid_1;
	public $packing_type;
	public $rid_2;
	public $rid_3;
	public $rid;
	public $lot_no;
	public $avg_quantity;
	public $quantity_avg_act;
	public $max_qty;
	public $quantity_sub;
	public $quantity;
	public $packets;
	public $price;
	public $cart_amount;
	public $other_amount;
	public $operator;
	public $datetime;
	public $dated;
	public $remarks;
	public $status;
	public $tmp_lot;
	public $hsn_code;
	public $amount;
	public $tax_amount;
	public $tax_percent;
	public $total_amount;
	public $cart_ref;
	public $po;
	public $_print;
	public $_barcode;
	public $url;
	public $uploads;
	public $company_id;
	public $rid_name;
	public $godown_po;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'material_out';
		$this->TableName = 'material_out';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`material_out`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('material_out', 'material_out', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// process
		$this->process = new DbField('material_out', 'material_out', 'x_process', 'process', '`process`', '`process`', 17, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process->Required = TRUE; // Required field
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process->Lookup = new Lookup('process', 'process', TRUE, 'id', ["id","name","",""], [], ["x_issue_to"], [], [], [], [], '`id` ASC', '');
		$this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process'] = &$this->process;

		// process_type
		$this->process_type = new DbField('material_out', 'material_out', 'x_process_type', 'process_type', '`process_type`', '`process_type`', 2, -1, FALSE, '`EV__process_type`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->process_type->Sortable = TRUE; // Allow sort
		$this->process_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process_type->Lookup = new Lookup('process_type', 'sub_process_type_view', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->process_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process_type'] = &$this->process_type;

		// issue_to_unit
		$this->issue_to_unit = new DbField('material_out', 'material_out', 'x_issue_to_unit', 'issue_to_unit', '`issue_to_unit`', '`issue_to_unit`', 2, -1, FALSE, '`issue_to_unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->issue_to_unit->Sortable = TRUE; // Allow sort
		$this->issue_to_unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to_unit'] = &$this->issue_to_unit;

		// issue_to
		$this->issue_to = new DbField('material_out', 'material_out', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 19, -1, FALSE, '`issue_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to->Required = TRUE; // Required field
		$this->issue_to->Sortable = TRUE; // Allow sort
		$this->issue_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to->Lookup = new Lookup('issue_to', 'buyer_seller_view', FALSE, 'id', ["name","mobile","",""], ["x_process"], [], ["mo_type"], ["x_mo_type"], [], [], '`name` ASC', '');
		$this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to'] = &$this->issue_to;

		// godown
		$this->godown = new DbField('material_out', 'material_out', 'x_godown', 'godown', '`godown`', '`godown`', 19, -1, FALSE, '`EV__godown`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'RADIO');
		$this->godown->Required = TRUE; // Required field
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->Lookup = new Lookup('godown', 'godown_table', FALSE, 'id', ["code","name","",""], [], ["x_rid_1","x_rid_2","x_rid_3"], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// jc_no
		$this->jc_no = new DbField('material_out', 'material_out', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 200, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->fields['jc_no'] = &$this->jc_no;

		// gp_no
		$this->gp_no = new DbField('material_out', 'material_out', 'x_gp_no', 'gp_no', '`gp_no`', '`gp_no`', 18, -1, FALSE, '`gp_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gp_no->Sortable = TRUE; // Allow sort
		$this->gp_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gp_no'] = &$this->gp_no;

		// grp
		$this->grp = new DbField('material_out', 'material_out', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp","x_packing_type"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('material_out', 'material_out', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`EV__s_grp`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('material_out', 'material_out', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`EV__product`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', '_product_view', FALSE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid_1","x_rid_2","x_rid_3"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid_1
		$this->rid_1 = new DbField('material_out', 'material_out', 'x_rid_1', 'rid_1', '`rid_1`', '`rid_1`', 200, -1, FALSE, '`EV__rid_1`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->rid_1->Sortable = FALSE; // Allow sort
		$this->rid_1->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid_1->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid_1->Lookup = new Lookup('rid_1', 'stock_lcgp', FALSE, 'id', ["packing_type_n","lot_no","Balance","product_code"], ["x_product","x_godown"], [], ["product","godown"], ["x_product","x_godown"], ["packing_type","rid","lot_no","avg_quantity","Balance"], ["x_packing_type","x_rid","x_lot_no","x_avg_quantity","x_max_qty"], '`product_code` ASC', '');
		$this->fields['rid_1'] = &$this->rid_1;

		// packing_type
		$this->packing_type = new DbField('material_out', 'material_out', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`EV__packing_type`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["packing","code","",""], ["x_grp"], ["x_rid_3"], ["grp"], ["x_grp"], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// rid_2
		$this->rid_2 = new DbField('material_out', 'material_out', 'x_rid_2', 'rid_2', '\'\'', '\'\'', 201, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->rid_2->IsCustom = TRUE; // Custom field
		$this->rid_2->Sortable = TRUE; // Allow sort
		$this->rid_2->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid_2->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid_2->Lookup = new Lookup('rid_2', 'stock_lcgp', FALSE, 'id', ["product_code","lot_no","packing_type_n","Balance"], ["x_product","x_godown"], [], ["product","godown"], ["x_product","x_godown"], ["rid","lot_no","avg_quantity","Balance"], ["x_rid","x_lot_no","x_avg_quantity","x_max_qty"], '`product_code` ASC', '');
		$this->rid_2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid_2'] = &$this->rid_2;

		// rid_3
		$this->rid_3 = new DbField('material_out', 'material_out', 'x_rid_3', 'rid_3', '\'\'', '\'\'', 201, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->rid_3->IsCustom = TRUE; // Custom field
		$this->rid_3->Sortable = TRUE; // Allow sort
		$this->rid_3->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid_3->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid_3->Lookup = new Lookup('rid_3', 'stock_lcgp', FALSE, 'id', ["lot_no","Balance","product_code","packing_type_n"], ["x_product","x_godown","x_packing_type"], [], ["product","godown","packing_type"], ["x_product","x_godown","x_packing_type"], ["rid","lot_no","avg_quantity","Balance"], ["x_rid","x_lot_no","x_avg_quantity","x_max_qty"], '`product_code` ASC', '');
		$this->fields['rid_3'] = &$this->rid_3;

		// rid
		$this->rid = new DbField('material_out', 'material_out', 'x_rid', 'rid', '`rid`', '`rid`', 2, -1, FALSE, '`EV__rid`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], ["packing_type"], ["x_packing_type"], '`product_code` ASC', '');
		$this->fields['rid'] = &$this->rid;

		// lot_no
		$this->lot_no = new DbField('material_out', 'material_out', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// avg_quantity
		$this->avg_quantity = new DbField('material_out', 'material_out', 'x_avg_quantity', 'avg_quantity', '0.00', '0.00', 201, -1, FALSE, '0.00', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avg_quantity->IsCustom = TRUE; // Custom field
		$this->avg_quantity->Sortable = TRUE; // Allow sort
		$this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['avg_quantity'] = &$this->avg_quantity;

		// quantity_avg_act
		$this->quantity_avg_act = new DbField('material_out', 'material_out', 'x_quantity_avg_act', 'quantity_avg_act', '`quantity_avg_act`', '`quantity_avg_act`', 17, -1, FALSE, '`quantity_avg_act`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->quantity_avg_act->Sortable = TRUE; // Allow sort
		$this->quantity_avg_act->Lookup = new Lookup('quantity_avg_act', 'material_out', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->quantity_avg_act->OptionCount = 2;
		$this->quantity_avg_act->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity_avg_act'] = &$this->quantity_avg_act;

		// max_qty
		$this->max_qty = new DbField('material_out', 'material_out', 'x_max_qty', 'max_qty', '0', '0', 20, -1, FALSE, '0', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->max_qty->IsCustom = TRUE; // Custom field
		$this->max_qty->Sortable = TRUE; // Allow sort
		$this->max_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['max_qty'] = &$this->max_qty;

		// quantity_sub
		$this->quantity_sub = new DbField('material_out', 'material_out', 'x_quantity_sub', 'quantity_sub', '`quantity_sub`', '`quantity_sub`', 131, -1, FALSE, '`quantity_sub`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity_sub->Sortable = TRUE; // Allow sort
		$this->quantity_sub->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity_sub'] = &$this->quantity_sub;

		// quantity
		$this->quantity = new DbField('material_out', 'material_out', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// packets
		$this->packets = new DbField('material_out', 'material_out', 'x_packets', 'packets', '`packets`', '`packets`', 131, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Required = TRUE; // Required field
		$this->packets->Sortable = TRUE; // Allow sort
		$this->fields['packets'] = &$this->packets;

		// price
		$this->price = new DbField('material_out', 'material_out', 'x_price', 'price', '`price`', '`price`', 4, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// cart_amount
		$this->cart_amount = new DbField('material_out', 'material_out', 'x_cart_amount', 'cart_amount', '`cart_amount`', '`cart_amount`', 4, -1, FALSE, '`cart_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_amount->Sortable = TRUE; // Allow sort
		$this->cart_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cart_amount'] = &$this->cart_amount;

		// other_amount
		$this->other_amount = new DbField('material_out', 'material_out', 'x_other_amount', 'other_amount', '`other_amount`', '`other_amount`', 4, -1, FALSE, '`other_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other_amount->Sortable = TRUE; // Allow sort
		$this->other_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['other_amount'] = &$this->other_amount;

		// operator
		$this->operator = new DbField('material_out', 'material_out', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('material_out', 'material_out', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// dated
		$this->dated = new DbField('material_out', 'material_out', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 135, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Required = TRUE; // Required field
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// remarks
		$this->remarks = new DbField('material_out', 'material_out', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// status
		$this->status = new DbField('material_out', 'material_out', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'material_out', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 3;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// tmp_lot
		$this->tmp_lot = new DbField('material_out', 'material_out', 'x_tmp_lot', 'tmp_lot', '`tmp_lot`', '`tmp_lot`', 131, -1, FALSE, '`tmp_lot`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tmp_lot->Required = TRUE; // Required field
		$this->tmp_lot->Sortable = TRUE; // Allow sort
		$this->tmp_lot->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tmp_lot'] = &$this->tmp_lot;

		// hsn_code
		$this->hsn_code = new DbField('material_out', 'material_out', 'x_hsn_code', 'hsn_code', '`hsn_code`', '`hsn_code`', 4, -1, FALSE, '`hsn_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->hsn_code->Sortable = TRUE; // Allow sort
		$this->hsn_code->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['hsn_code'] = &$this->hsn_code;

		// amount
		$this->amount = new DbField('material_out', 'material_out', 'x_amount', 'amount', '`amount`', '`amount`', 4, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// tax_amount
		$this->tax_amount = new DbField('material_out', 'material_out', 'x_tax_amount', 'tax_amount', '`tax_amount`', '`tax_amount`', 4, -1, FALSE, '`tax_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tax_amount->Sortable = TRUE; // Allow sort
		$this->tax_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tax_amount'] = &$this->tax_amount;

		// tax_percent
		$this->tax_percent = new DbField('material_out', 'material_out', 'x_tax_percent', 'tax_percent', '`tax_percent`', '`tax_percent`', 4, -1, FALSE, '`tax_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tax_percent->Sortable = TRUE; // Allow sort
		$this->tax_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tax_percent'] = &$this->tax_percent;

		// total_amount
		$this->total_amount = new DbField('material_out', 'material_out', 'x_total_amount', 'total_amount', '`total_amount`', '`total_amount`', 4, -1, FALSE, '`total_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->total_amount->Sortable = TRUE; // Allow sort
		$this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['total_amount'] = &$this->total_amount;

		// cart_ref
		$this->cart_ref = new DbField('material_out', 'material_out', 'x_cart_ref', 'cart_ref', '`cart_ref`', '`cart_ref`', 19, -1, FALSE, '`cart_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_ref->Sortable = TRUE; // Allow sort
		$this->cart_ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cart_ref'] = &$this->cart_ref;

		// po
		$this->po = new DbField('material_out', 'material_out', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = FALSE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// print
		$this->_print = new DbField('material_out', 'material_out', 'x__print', 'print', '`print`', '`print`', 200, -1, FALSE, '`print`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_print->Sortable = FALSE; // Allow sort
		$this->fields['print'] = &$this->_print;

		// barcode
		$this->_barcode = new DbField('material_out', 'material_out', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Sortable = FALSE; // Allow sort
		$this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['barcode'] = &$this->_barcode;

		// url
		$this->url = new DbField('material_out', 'material_out', 'x_url', 'url', 'concat(\'receiptadd.php?location=\',`godown`,\'&partner=\',`issue_to`,\'&oid=\',`cart_ref`,\'&balance=\',`total_amount`)', 'concat(\'receiptadd.php?location=\',`godown`,\'&partner=\',`issue_to`,\'&oid=\',`cart_ref`,\'&balance=\',`total_amount`)', 200, -1, FALSE, 'concat(\'receiptadd.php?location=\',`godown`,\'&partner=\',`issue_to`,\'&oid=\',`cart_ref`,\'&balance=\',`total_amount`)', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->IsCustom = TRUE; // Custom field
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;

		// uploads
		$this->uploads = new DbField('material_out', 'material_out', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 200, -1, TRUE, '`uploads`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->uploads->Sortable = TRUE; // Allow sort
		$this->uploads->ImageResize = TRUE;
		$this->uploads->UploadMultiple = TRUE;
		$this->uploads->Upload->UploadMultiple = TRUE;
		$this->uploads->UploadMaxFileCount = 0;
		$this->fields['uploads'] = &$this->uploads;

		// company_id
		$this->company_id = new DbField('material_out', 'material_out', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 3, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Sortable = FALSE; // Allow sort
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// rid_name
		$this->rid_name = new DbField('material_out', 'material_out', 'x_rid_name', 'rid_name', '`rid_name`', '`rid_name`', 200, -1, FALSE, '`rid_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid_name->Sortable = FALSE; // Allow sort
		$this->fields['rid_name'] = &$this->rid_name;

		// godown_po
		$this->godown_po = new DbField('material_out', 'material_out', 'x_godown_po', 'godown_po', '`godown_po`', '`godown_po`', 3, -1, FALSE, '`godown_po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->godown_po->Sortable = TRUE; // Allow sort
		$this->godown_po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown_po'] = &$this->godown_po;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`material_out`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, '' AS `rid_2`, '' AS `rid_3`, 0.00 AS `avg_quantity`, 0 AS `max_qty`, concat('receiptadd.php?location=',`godown`,'&partner=',`issue_to`,'&oid=',`cart_ref`,'&balance=',`total_amount`) AS `url` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, '' AS `rid_2`, '' AS `rid_3`, 0.00 AS `avg_quantity`, 0 AS `max_qty`, concat('receiptadd.php?location=',`godown`,'&partner=',`issue_to`,'&oid=',`cart_ref`,'&balance=',`total_amount`) AS `url`, (SELECT DISTINCT `name` FROM `sub_process_type_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out`.`process_type` LIMIT 1) AS `EV__process_type`, (SELECT CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->godown) . "',COALESCE(`name`,'')) FROM `godown_table` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out`.`godown` LIMIT 1) AS `EV__godown`, (SELECT `product_group` FROM `product_group` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out`.`s_grp` LIMIT 1) AS `EV__s_grp`, (SELECT `product` FROM `product_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out`.`product` LIMIT 1) AS `EV__product`, (SELECT CONCAT(COALESCE(`packing_type_n`, ''),'" . ValueSeparator(1, $this->rid_1) . "',COALESCE(`lot_no`,''),'" . ValueSeparator(2, $this->rid_1) . "',COALESCE(`Balance`,''),'" . ValueSeparator(3, $this->rid_1) . "',COALESCE(`product_code`,'')) FROM `stock_lcgp` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out`.`rid_1` LIMIT 1) AS `EV__rid_1`, (SELECT CONCAT(COALESCE(`packing`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`code`,'')) FROM `packing_type` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out`.`packing_type` LIMIT 1) AS `EV__packing_type`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out`.`rid` LIMIT 1) AS `EV__rid` FROM `material_out`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->process_type->AdvancedSearch->SearchValue <> "" ||
			$this->process_type->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->process_type->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->process_type->VirtualExpression . " "))
			return TRUE;
		if ($this->godown->AdvancedSearch->SearchValue <> "" ||
			$this->godown->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->godown->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->godown->VirtualExpression . " "))
			return TRUE;
		if ($this->s_grp->AdvancedSearch->SearchValue <> "" ||
			$this->s_grp->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->s_grp->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->s_grp->VirtualExpression . " "))
			return TRUE;
		if ($this->product->AdvancedSearch->SearchValue <> "" ||
			$this->product->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->product->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->product->VirtualExpression . " "))
			return TRUE;
		if ($this->rid_1->AdvancedSearch->SearchValue <> "" ||
			$this->rid_1->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid_1->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid_1->VirtualExpression . " "))
			return TRUE;
		if ($this->packing_type->AdvancedSearch->SearchValue <> "" ||
			$this->packing_type->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->packing_type->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->packing_type->VirtualExpression . " "))
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->process->DbValue = $row['process'];
		$this->process_type->DbValue = $row['process_type'];
		$this->issue_to_unit->DbValue = $row['issue_to_unit'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->godown->DbValue = $row['godown'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->gp_no->DbValue = $row['gp_no'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid_1->DbValue = $row['rid_1'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->rid_2->DbValue = $row['rid_2'];
		$this->rid_3->DbValue = $row['rid_3'];
		$this->rid->DbValue = $row['rid'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->avg_quantity->DbValue = $row['avg_quantity'];
		$this->quantity_avg_act->DbValue = $row['quantity_avg_act'];
		$this->max_qty->DbValue = $row['max_qty'];
		$this->quantity_sub->DbValue = $row['quantity_sub'];
		$this->quantity->DbValue = $row['quantity'];
		$this->packets->DbValue = $row['packets'];
		$this->price->DbValue = $row['price'];
		$this->cart_amount->DbValue = $row['cart_amount'];
		$this->other_amount->DbValue = $row['other_amount'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->dated->DbValue = $row['dated'];
		$this->remarks->DbValue = $row['remarks'];
		$this->status->DbValue = $row['status'];
		$this->tmp_lot->DbValue = $row['tmp_lot'];
		$this->hsn_code->DbValue = $row['hsn_code'];
		$this->amount->DbValue = $row['amount'];
		$this->tax_amount->DbValue = $row['tax_amount'];
		$this->tax_percent->DbValue = $row['tax_percent'];
		$this->total_amount->DbValue = $row['total_amount'];
		$this->cart_ref->DbValue = $row['cart_ref'];
		$this->po->DbValue = $row['po'];
		$this->_print->DbValue = $row['print'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->url->DbValue = $row['url'];
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->company_id->DbValue = $row['company_id'];
		$this->rid_name->DbValue = $row['rid_name'];
		$this->godown_po->DbValue = $row['godown_po'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$oldFiles = EmptyValue($row['uploads']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['uploads']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "material_outlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "material_outview.php")
			return $Language->phrase("View");
		elseif ($pageName == "material_outedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "material_outadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "material_outlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("material_outview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("material_outview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "material_outadd.php?" . $this->getUrlParm($parm);
		else
			$url = "material_outadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("material_outedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("material_outadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("material_outdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->process->setDbValue($rs->fields('process'));
		$this->process_type->setDbValue($rs->fields('process_type'));
		$this->issue_to_unit->setDbValue($rs->fields('issue_to_unit'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->gp_no->setDbValue($rs->fields('gp_no'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid_1->setDbValue($rs->fields('rid_1'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->rid_2->setDbValue($rs->fields('rid_2'));
		$this->rid_3->setDbValue($rs->fields('rid_3'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->avg_quantity->setDbValue($rs->fields('avg_quantity'));
		$this->quantity_avg_act->setDbValue($rs->fields('quantity_avg_act'));
		$this->max_qty->setDbValue($rs->fields('max_qty'));
		$this->quantity_sub->setDbValue($rs->fields('quantity_sub'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->price->setDbValue($rs->fields('price'));
		$this->cart_amount->setDbValue($rs->fields('cart_amount'));
		$this->other_amount->setDbValue($rs->fields('other_amount'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->status->setDbValue($rs->fields('status'));
		$this->tmp_lot->setDbValue($rs->fields('tmp_lot'));
		$this->hsn_code->setDbValue($rs->fields('hsn_code'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->tax_amount->setDbValue($rs->fields('tax_amount'));
		$this->tax_percent->setDbValue($rs->fields('tax_percent'));
		$this->total_amount->setDbValue($rs->fields('total_amount'));
		$this->cart_ref->setDbValue($rs->fields('cart_ref'));
		$this->po->setDbValue($rs->fields('po'));
		$this->_print->setDbValue($rs->fields('print'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->url->setDbValue($rs->fields('url'));
		$this->uploads->Upload->DbValue = $rs->fields('uploads');
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->rid_name->setDbValue($rs->fields('rid_name'));
		$this->godown_po->setDbValue($rs->fields('godown_po'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id

		$this->id->CellCssStyle = "white-space: nowrap;";

		// process
		$this->process->CellCssStyle = "white-space: nowrap;";

		// process_type
		$this->process_type->CellCssStyle = "white-space: nowrap;";

		// issue_to_unit
		// issue_to
		// godown
		// jc_no

		$this->jc_no->CellCssStyle = "white-space: nowrap;";

		// gp_no
		$this->gp_no->CellCssStyle = "white-space: nowrap;";

		// grp
		// s_grp
		// product
		// rid_1

		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// packing_type
		// rid_2
		// rid_3
		// rid
		// lot_no
		// avg_quantity
		// quantity_avg_act

		$this->quantity_avg_act->CellCssStyle = "white-space: nowrap;";

		// max_qty
		// quantity_sub
		// quantity
		// packets
		// price
		// cart_amount
		// other_amount
		// operator
		// datetime
		// dated
		// remarks
		// status
		// tmp_lot

		$this->tmp_lot->CellCssStyle = "white-space: nowrap;";

		// hsn_code
		$this->hsn_code->CellCssStyle = "white-space: nowrap;";

		// amount
		$this->amount->CellCssStyle = "white-space: nowrap;";

		// tax_amount
		$this->tax_amount->CellCssStyle = "white-space: nowrap;";

		// tax_percent
		$this->tax_percent->CellCssStyle = "white-space: nowrap;";

		// total_amount
		// cart_ref

		$this->cart_ref->CellCssStyle = "white-space: nowrap;";

		// po
		$this->po->CellCssStyle = "white-space: nowrap;";

		// print
		$this->_print->CellCssStyle = "white-space: nowrap;";

		// barcode
		$this->_barcode->CellCssStyle = "white-space: nowrap;";

		// url
		$this->url->CellCssStyle = "white-space: nowrap;";

		// uploads
		// company_id

		$this->company_id->CellCssStyle = "white-space: nowrap;";

		// rid_name
		$this->rid_name->CellCssStyle = "white-space: nowrap;";

		// godown_po
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->process->ViewValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// process_type
		if ($this->process_type->VirtualValue <> "") {
			$this->process_type->ViewValue = $this->process_type->VirtualValue;
		} else {
		$curVal = strval($this->process_type->CurrentValue);
		if ($curVal <> "") {
			$this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
			if ($this->process_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process_type->ViewValue = $this->process_type->CurrentValue;
				}
			}
		} else {
			$this->process_type->ViewValue = NULL;
		}
		}
		$this->process_type->ViewCustomAttributes = "";

		// issue_to_unit
		$this->issue_to_unit->ViewValue = $this->issue_to_unit->CurrentValue;
		$this->issue_to_unit->ViewValue = FormatNumber($this->issue_to_unit->ViewValue, 0, -2, -2, -2);
		$this->issue_to_unit->ViewCustomAttributes = "";

		// issue_to
		$curVal = strval($this->issue_to->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			if ($this->issue_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `id` > 0 and `category` != 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
				}
			}
		} else {
			$this->issue_to->ViewValue = NULL;
		}
		$this->issue_to->ViewCustomAttributes = "";

		// godown
		if ($this->godown->VirtualValue <> "") {
			$this->godown->ViewValue = $this->godown->VirtualValue;
		} else {
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		}
		$this->godown->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewCustomAttributes = "";

		// gp_no
		$this->gp_no->ViewValue = $this->gp_no->CurrentValue;
		$this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, 0, -2, -2, -2);
		$this->gp_no->ViewCustomAttributes = 'class="btn btn-default"';

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		if ($this->s_grp->VirtualValue <> "") {
			$this->s_grp->ViewValue = $this->s_grp->VirtualValue;
		} else {
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		if ($this->product->VirtualValue <> "") {
			$this->product->ViewValue = $this->product->VirtualValue;
		} else {
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		}
		$this->product->ViewCustomAttributes = "";

		// rid_1
		if ($this->rid_1->VirtualValue <> "") {
			$this->rid_1->ViewValue = $this->rid_1->VirtualValue;
		} else {
		$curVal = strval($this->rid_1->CurrentValue);
		if ($curVal <> "") {
			$this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
			if ($this->rid_1->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
					$arwrk[4] = $rswrk->fields('df4');
					$this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
				}
			}
		} else {
			$this->rid_1->ViewValue = NULL;
		}
		}
		$this->rid_1->ViewCustomAttributes = "";

		// packing_type
		if ($this->packing_type->VirtualValue <> "") {
			$this->packing_type->ViewValue = $this->packing_type->VirtualValue;
		} else {
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		}
		$this->packing_type->ViewCustomAttributes = "";

		// rid_2
		$curVal = strval($this->rid_2->CurrentValue);
		if ($curVal <> "") {
			$this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
			if ($this->rid_2->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$sqlWrk = $this->rid_2->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
					$this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_2->ViewValue = $this->rid_2->CurrentValue;
				}
			}
		} else {
			$this->rid_2->ViewValue = NULL;
		}
		$this->rid_2->ViewCustomAttributes = "";

		// rid_3
		$curVal = strval($this->rid_3->CurrentValue);
		if ($curVal <> "") {
			$this->rid_3->ViewValue = $this->rid_3->lookupCacheOption($curVal);
			if ($this->rid_3->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_3->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0);
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->rid_3->ViewValue = $this->rid_3->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_3->ViewValue = $this->rid_3->CurrentValue;
				}
			}
		} else {
			$this->rid_3->ViewValue = NULL;
		}
		$this->rid_3->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
			$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewCustomAttributes = "";

		// quantity_avg_act
		if (strval($this->quantity_avg_act->CurrentValue) <> "") {
			$this->quantity_avg_act->ViewValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
		} else {
			$this->quantity_avg_act->ViewValue = NULL;
		}
		$this->quantity_avg_act->ViewCustomAttributes = "";

		// max_qty
		$this->max_qty->ViewValue = $this->max_qty->CurrentValue;
		$this->max_qty->ViewCustomAttributes = "";

		// quantity_sub
		$this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
		$this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, 2, -2, -2, -2);
		$this->quantity_sub->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -1, -1, -1);
		$this->quantity->CssClass = "font-weight-bold";
		$this->quantity->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// cart_amount
		$this->cart_amount->ViewValue = $this->cart_amount->CurrentValue;
		$this->cart_amount->ViewValue = FormatNumber($this->cart_amount->ViewValue, 2, -2, -2, -2);
		$this->cart_amount->ViewCustomAttributes = "";

		// other_amount
		$this->other_amount->ViewValue = $this->other_amount->CurrentValue;
		$this->other_amount->ViewValue = FormatNumber($this->other_amount->ViewValue, 2, -2, -2, -2);
		$this->other_amount->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// tmp_lot
		$this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
		$this->tmp_lot->ViewValue = FormatNumber($this->tmp_lot->ViewValue, 2, -2, -2, -2);
		$this->tmp_lot->ViewCustomAttributes = "";

		// hsn_code
		$this->hsn_code->ViewValue = $this->hsn_code->CurrentValue;
		$this->hsn_code->ViewValue = FormatNumber($this->hsn_code->ViewValue, 2, -2, -2, -2);
		$this->hsn_code->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// tax_amount
		$this->tax_amount->ViewValue = $this->tax_amount->CurrentValue;
		$this->tax_amount->ViewValue = FormatNumber($this->tax_amount->ViewValue, 2, -2, -2, -2);
		$this->tax_amount->ViewCustomAttributes = "";

		// tax_percent
		$this->tax_percent->ViewValue = $this->tax_percent->CurrentValue;
		$this->tax_percent->ViewValue = FormatNumber($this->tax_percent->ViewValue, 2, -2, -2, -2);
		$this->tax_percent->ViewCustomAttributes = "";

		// total_amount
		$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
		$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
		$this->total_amount->ViewCustomAttributes = "";

		// cart_ref
		$this->cart_ref->ViewValue = $this->cart_ref->CurrentValue;
		$this->cart_ref->ViewValue = FormatNumber($this->cart_ref->ViewValue, 0, -2, -2, -2);
		$this->cart_ref->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// print
		$this->_print->ViewValue = $this->_print->CurrentValue;
		$this->_print->CssClass = "font-weight-bold";
		$this->_print->ViewCustomAttributes = 'class = "btn btn-default"';

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// uploads
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->ViewValue = "";
		}
		$this->uploads->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
		$this->company_id->ViewCustomAttributes = "";

		// rid_name
		$this->rid_name->ViewValue = $this->rid_name->CurrentValue;
		$this->rid_name->ViewCustomAttributes = "";

		// godown_po
		$this->godown_po->ViewValue = $this->godown_po->CurrentValue;
		$this->godown_po->ViewValue = FormatNumber($this->godown_po->ViewValue, 0, -2, -2, -2);
		$this->godown_po->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		if (!EmptyValue($this->process->CurrentValue)) {
			$this->process->HrefValue = "material_outlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
			$this->process->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
		} else {
			$this->process->HrefValue = "";
		}
		$this->process->TooltipValue = "";

		// process_type
		$this->process_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->process_type->CurrentValue)) {
			$this->process_type->HrefValue = "material_outlist.php?x_process_type=" . $this->process_type->CurrentValue; // Add prefix/suffix
			$this->process_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
		} else {
			$this->process_type->HrefValue = "";
		}
		$this->process_type->TooltipValue = "";

		// issue_to_unit
		$this->issue_to_unit->LinkCustomAttributes = "";
		$this->issue_to_unit->HrefValue = "";
		$this->issue_to_unit->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		if (!EmptyValue($this->issue_to->CurrentValue)) {
			$this->issue_to->HrefValue = "material_outlist.php?x_issue_to=" . $this->issue_to->CurrentValue; // Add prefix/suffix
			$this->issue_to->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
		} else {
			$this->issue_to->HrefValue = "";
		}
		$this->issue_to->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown->CurrentValue)) {
			$this->godown->HrefValue = "material_outlist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
			$this->godown->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
		} else {
			$this->godown->HrefValue = "";
		}
		$this->godown->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// gp_no
		$this->gp_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->id->CurrentValue)) {
			$this->gp_no->HrefValue = "gst_challan.php?ID=" . $this->id->CurrentValue; // Add prefix/suffix
			$this->gp_no->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->gp_no->HrefValue = FullUrl($this->gp_no->HrefValue, "href");
		} else {
			$this->gp_no->HrefValue = "";
		}
		$this->gp_no->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "material_outlist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "material_outlist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "material_outlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid_1
		$this->rid_1->LinkCustomAttributes = "";
		$this->rid_1->HrefValue = "";
		$this->rid_1->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->packing_type->CurrentValue)) {
			$this->packing_type->HrefValue = "material_outlist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
			$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
		} else {
			$this->packing_type->HrefValue = "";
		}
		$this->packing_type->TooltipValue = "";

		// rid_2
		$this->rid_2->LinkCustomAttributes = "";
		$this->rid_2->HrefValue = "";
		$this->rid_2->TooltipValue = "";

		// rid_3
		$this->rid_3->LinkCustomAttributes = "";
		$this->rid_3->HrefValue = "";
		$this->rid_3->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "material_outlist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// avg_quantity
		$this->avg_quantity->LinkCustomAttributes = "";
		$this->avg_quantity->HrefValue = "";
		$this->avg_quantity->TooltipValue = "";

		// quantity_avg_act
		$this->quantity_avg_act->LinkCustomAttributes = "";
		$this->quantity_avg_act->HrefValue = "";
		$this->quantity_avg_act->TooltipValue = "";

		// max_qty
		$this->max_qty->LinkCustomAttributes = "";
		$this->max_qty->HrefValue = "";
		$this->max_qty->TooltipValue = "";

		// quantity_sub
		$this->quantity_sub->LinkCustomAttributes = "";
		$this->quantity_sub->HrefValue = "";
		$this->quantity_sub->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// cart_amount
		$this->cart_amount->LinkCustomAttributes = "";
		$this->cart_amount->HrefValue = "";
		$this->cart_amount->TooltipValue = "";

		// other_amount
		$this->other_amount->LinkCustomAttributes = "";
		$this->other_amount->HrefValue = "";
		$this->other_amount->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		if (!EmptyValue($this->status->CurrentValue)) {
			$this->status->HrefValue = "material_outlist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
			$this->status->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
		} else {
			$this->status->HrefValue = "";
		}
		$this->status->TooltipValue = "";

		// tmp_lot
		$this->tmp_lot->LinkCustomAttributes = "";
		$this->tmp_lot->HrefValue = "";
		$this->tmp_lot->TooltipValue = "";

		// hsn_code
		$this->hsn_code->LinkCustomAttributes = "";
		$this->hsn_code->HrefValue = "";
		$this->hsn_code->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// tax_amount
		$this->tax_amount->LinkCustomAttributes = "";
		$this->tax_amount->HrefValue = "";
		$this->tax_amount->TooltipValue = "";

		// tax_percent
		$this->tax_percent->LinkCustomAttributes = "";
		$this->tax_percent->HrefValue = "";
		$this->tax_percent->TooltipValue = "";

		// total_amount
		$this->total_amount->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->total_amount->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->total_amount->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->total_amount->HrefValue = FullUrl($this->total_amount->HrefValue, "href");
		} else {
			$this->total_amount->HrefValue = "";
		}
		$this->total_amount->TooltipValue = "";

		// cart_ref
		$this->cart_ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->cart_ref->CurrentValue)) {
			$this->cart_ref->HrefValue = "material_outlist.php?x_cart_ref=" . $this->cart_ref->CurrentValue; // Add prefix/suffix
			$this->cart_ref->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->cart_ref->HrefValue = FullUrl($this->cart_ref->HrefValue, "href");
		} else {
			$this->cart_ref->HrefValue = "";
		}
		$this->cart_ref->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// print
		$this->_print->LinkCustomAttributes = "";
		$this->_print->HrefValue = "";
		$this->_print->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->url->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->url->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->url->HrefValue = FullUrl($this->url->HrefValue, "href");
		} else {
			$this->url->HrefValue = "";
		}
		$this->url->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->HrefValue = "%u"; // Add prefix/suffix
			$this->uploads->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
		} else {
			$this->uploads->HrefValue = "";
		}
		$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
		$this->uploads->TooltipValue = "";
		if ($this->uploads->UseColorbox) {
			if (EmptyValue($this->uploads->TooltipValue))
				$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->uploads->LinkAttrs["data-rel"] = "material_out_x_uploads";
			AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
		}

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// rid_name
		$this->rid_name->LinkCustomAttributes = "";
		$this->rid_name->HrefValue = "";
		$this->rid_name->TooltipValue = "";

		// godown_po
		$this->godown_po->LinkCustomAttributes = "";
		$this->godown_po->HrefValue = "";
		$this->godown_po->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->EditValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->process->EditValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->EditValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->EditValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// process_type
		$this->process_type->EditAttrs["class"] = "form-control";
		$this->process_type->EditCustomAttributes = "";
		if ($this->process_type->VirtualValue <> "") {
			$this->process_type->EditValue = $this->process_type->VirtualValue;
		} else {
		$curVal = strval($this->process_type->CurrentValue);
		if ($curVal <> "") {
			$this->process_type->EditValue = $this->process_type->lookupCacheOption($curVal);
			if ($this->process_type->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process_type->EditValue = $this->process_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process_type->EditValue = $this->process_type->CurrentValue;
				}
			}
		} else {
			$this->process_type->EditValue = NULL;
		}
		}
		$this->process_type->ViewCustomAttributes = "";

		// issue_to_unit
		$this->issue_to_unit->EditAttrs["class"] = "form-control";
		$this->issue_to_unit->EditCustomAttributes = "";
		$this->issue_to_unit->EditValue = $this->issue_to_unit->CurrentValue;
		$this->issue_to_unit->PlaceHolder = RemoveHtml($this->issue_to_unit->caption());

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";
		if ($this->godown->VirtualValue <> "") {
			$this->godown->EditValue = $this->godown->VirtualValue;
		} else {
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->godown->EditValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->EditValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->EditValue = NULL;
		}
		}
		$this->godown->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewCustomAttributes = "";

		// gp_no
		$this->gp_no->EditAttrs["class"] = "form-control";
		$this->gp_no->EditCustomAttributes = "";
		$this->gp_no->EditValue = $this->gp_no->CurrentValue;
		$this->gp_no->EditValue = FormatNumber($this->gp_no->EditValue, 0, -2, -2, -2);
		$this->gp_no->ViewCustomAttributes = 'class="btn btn-default"';

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->EditValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->EditValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		if ($this->s_grp->VirtualValue <> "") {
			$this->s_grp->EditValue = $this->s_grp->VirtualValue;
		} else {
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->EditValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->EditValue = NULL;
		}
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		if ($this->product->VirtualValue <> "") {
			$this->product->EditValue = $this->product->VirtualValue;
		} else {
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->EditValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->EditValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->EditValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->EditValue = NULL;
		}
		}
		$this->product->ViewCustomAttributes = "";

		// rid_1
		$this->rid_1->EditAttrs["class"] = "form-control";
		$this->rid_1->EditCustomAttributes = "";
		if ($this->rid_1->VirtualValue <> "") {
			$this->rid_1->EditValue = $this->rid_1->VirtualValue;
		} else {
		$curVal = strval($this->rid_1->CurrentValue);
		if ($curVal <> "") {
			$this->rid_1->EditValue = $this->rid_1->lookupCacheOption($curVal);
			if ($this->rid_1->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
					$arwrk[4] = $rswrk->fields('df4');
					$this->rid_1->EditValue = $this->rid_1->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_1->EditValue = $this->rid_1->CurrentValue;
				}
			}
		} else {
			$this->rid_1->EditValue = NULL;
		}
		}
		$this->rid_1->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		if ($this->packing_type->VirtualValue <> "") {
			$this->packing_type->EditValue = $this->packing_type->VirtualValue;
		} else {
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->EditValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->EditValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->EditValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->EditValue = NULL;
		}
		}
		$this->packing_type->ViewCustomAttributes = "";

		// rid_2
		$this->rid_2->EditAttrs["class"] = "form-control";
		$this->rid_2->EditCustomAttributes = "";

		// rid_3
		$this->rid_3->EditAttrs["class"] = "form-control";
		$this->rid_3->EditCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		if ($this->rid->VirtualValue <> "") {
			$this->rid->EditValue = $this->rid->VirtualValue;
		} else {
			$this->rid->EditValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->EditValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->EditValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->EditValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->EditAttrs["class"] = "form-control";
		$this->avg_quantity->EditCustomAttributes = "";
		$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewCustomAttributes = "";

		// quantity_avg_act
		$this->quantity_avg_act->EditAttrs["class"] = "form-control";
		$this->quantity_avg_act->EditCustomAttributes = 'Disabled';
		if (strval($this->quantity_avg_act->CurrentValue) <> "") {
			$this->quantity_avg_act->EditValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
		} else {
			$this->quantity_avg_act->EditValue = NULL;
		}
		$this->quantity_avg_act->ViewCustomAttributes = "";

		// max_qty
		$this->max_qty->EditAttrs["class"] = "form-control";
		$this->max_qty->EditCustomAttributes = "readonly";
		$this->max_qty->EditValue = $this->max_qty->CurrentValue;
		$this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());

		// quantity_sub
		$this->quantity_sub->EditAttrs["class"] = "form-control";
		$this->quantity_sub->EditCustomAttributes = "";
		$this->quantity_sub->EditValue = $this->quantity_sub->CurrentValue;
		$this->quantity_sub->PlaceHolder = RemoveHtml($this->quantity_sub->caption());
		if (strval($this->quantity_sub->EditValue) <> "" && is_numeric($this->quantity_sub->EditValue))
			$this->quantity_sub->EditValue = FormatNumber($this->quantity_sub->EditValue, -2, -2, -2, -2);

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 3, -1, -1, -1);
		$this->quantity->CssClass = "font-weight-bold";
		$this->quantity->ViewCustomAttributes = "";

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = 'ReadOnly';
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->ViewCustomAttributes = "";

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->EditValue = FormatNumber($this->price->EditValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// cart_amount
		$this->cart_amount->EditAttrs["class"] = "form-control";
		$this->cart_amount->EditCustomAttributes = 'ReadOnly';
		$this->cart_amount->EditValue = $this->cart_amount->CurrentValue;
		$this->cart_amount->EditValue = FormatNumber($this->cart_amount->EditValue, 2, -2, -2, -2);
		$this->cart_amount->ViewCustomAttributes = "";

		// other_amount
		$this->other_amount->EditAttrs["class"] = "form-control";
		$this->other_amount->EditCustomAttributes = "";
		$this->other_amount->EditValue = $this->other_amount->CurrentValue;
		$this->other_amount->PlaceHolder = RemoveHtml($this->other_amount->caption());
		if (strval($this->other_amount->EditValue) <> "" && is_numeric($this->other_amount->EditValue))
			$this->other_amount->EditValue = FormatNumber($this->other_amount->EditValue, -2, -2, -2, -2);

		// operator
		// datetime
		// dated

		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = $this->dated->CurrentValue;
		$this->dated->EditValue = FormatDateTime($this->dated->EditValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->EditValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// tmp_lot
		$this->tmp_lot->EditAttrs["class"] = "form-control";
		$this->tmp_lot->EditCustomAttributes = "";
		$this->tmp_lot->EditValue = $this->tmp_lot->CurrentValue;
		$this->tmp_lot->EditValue = FormatNumber($this->tmp_lot->EditValue, 2, -2, -2, -2);
		$this->tmp_lot->ViewCustomAttributes = "";

		// hsn_code
		$this->hsn_code->EditAttrs["class"] = "form-control";
		$this->hsn_code->EditCustomAttributes = "";
		$this->hsn_code->EditValue = $this->hsn_code->CurrentValue;
		$this->hsn_code->EditValue = FormatNumber($this->hsn_code->EditValue, 2, -2, -2, -2);
		$this->hsn_code->ViewCustomAttributes = "";

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->EditValue = FormatNumber($this->amount->EditValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// tax_amount
		$this->tax_amount->EditAttrs["class"] = "form-control";
		$this->tax_amount->EditCustomAttributes = "";
		$this->tax_amount->EditValue = $this->tax_amount->CurrentValue;
		$this->tax_amount->EditValue = FormatNumber($this->tax_amount->EditValue, 2, -2, -2, -2);
		$this->tax_amount->ViewCustomAttributes = "";

		// tax_percent
		$this->tax_percent->EditAttrs["class"] = "form-control";
		$this->tax_percent->EditCustomAttributes = "";
		$this->tax_percent->EditValue = $this->tax_percent->CurrentValue;
		$this->tax_percent->EditValue = FormatNumber($this->tax_percent->EditValue, 2, -2, -2, -2);
		$this->tax_percent->ViewCustomAttributes = "";

		// total_amount
		$this->total_amount->EditAttrs["class"] = "form-control";
		$this->total_amount->EditCustomAttributes = "";
		$this->total_amount->EditValue = $this->total_amount->CurrentValue;
		$this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, 2, -2, -2, -2);
		$this->total_amount->ViewCustomAttributes = "";

		// cart_ref
		$this->cart_ref->EditAttrs["class"] = "form-control";
		$this->cart_ref->EditCustomAttributes = "";
		$this->cart_ref->EditValue = $this->cart_ref->CurrentValue;
		$this->cart_ref->PlaceHolder = RemoveHtml($this->cart_ref->caption());

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// print
		$this->_print->EditAttrs["class"] = "form-control";
		$this->_print->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_print->CurrentValue = HtmlDecode($this->_print->CurrentValue);
		$this->_print->EditValue = $this->_print->CurrentValue;
		$this->_print->PlaceHolder = RemoveHtml($this->_print->caption());

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->EditValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->EditValue = "";
		}
		if (!EmptyValue($this->uploads->CurrentValue))
				$this->uploads->Upload->FileName = $this->uploads->CurrentValue;

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// rid_name
		$this->rid_name->EditAttrs["class"] = "form-control";
		$this->rid_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rid_name->CurrentValue = HtmlDecode($this->rid_name->CurrentValue);
		$this->rid_name->EditValue = $this->rid_name->CurrentValue;
		$this->rid_name->PlaceHolder = RemoveHtml($this->rid_name->caption());

		// godown_po
		$this->godown_po->EditAttrs["class"] = "form-control";
		$this->godown_po->EditCustomAttributes = "";
		$this->godown_po->EditValue = $this->godown_po->CurrentValue;
		$this->godown_po->PlaceHolder = RemoveHtml($this->godown_po->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
			if (is_numeric($this->packets->CurrentValue))
				$this->packets->Total += $this->packets->CurrentValue; // Accumulate total
			if (is_numeric($this->total_amount->CurrentValue))
				$this->total_amount->Total += $this->total_amount->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -1, -1, -1);
			$this->quantity->CssClass = "font-weight-bold";
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value
			$this->packets->CurrentValue = $this->packets->Total;
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";
			$this->packets->HrefValue = ""; // Clear href value
			$this->total_amount->CurrentValue = $this->total_amount->Total;
			$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
			$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
			$this->total_amount->ViewCustomAttributes = "";
			$this->total_amount->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->issue_to_unit);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid_1);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->rid_2);
					$doc->exportCaption($this->rid_3);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->max_qty);
					$doc->exportCaption($this->quantity_sub);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->cart_amount);
					$doc->exportCaption($this->other_amount);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->tax_percent);
					$doc->exportCaption($this->cart_ref);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->godown_po);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->process_type);
					$doc->exportCaption($this->issue_to_unit);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->max_qty);
					$doc->exportCaption($this->quantity_sub);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->godown_po);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->process);
						$doc->exportField($this->issue_to_unit);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->godown);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid_1);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->rid_2);
						$doc->exportField($this->rid_3);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->max_qty);
						$doc->exportField($this->quantity_sub);
						$doc->exportField($this->quantity);
						$doc->exportField($this->packets);
						$doc->exportField($this->price);
						$doc->exportField($this->cart_amount);
						$doc->exportField($this->other_amount);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->dated);
						$doc->exportField($this->remarks);
						$doc->exportField($this->status);
						$doc->exportField($this->tax_percent);
						$doc->exportField($this->cart_ref);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->uploads);
						$doc->exportField($this->company_id);
						$doc->exportField($this->godown_po);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->process);
						$doc->exportField($this->process_type);
						$doc->exportField($this->issue_to_unit);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->godown);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->rid);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->max_qty);
						$doc->exportField($this->quantity_sub);
						$doc->exportField($this->quantity);
						$doc->exportField($this->packets);
						$doc->exportField($this->price);
						$doc->exportField($this->dated);
						$doc->exportField($this->status);
						$doc->exportField($this->uploads);
						$doc->exportField($this->godown_po);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->process, '');
				$doc->exportAggregate($this->process_type, '');
				$doc->exportAggregate($this->issue_to_unit, '');
				$doc->exportAggregate($this->issue_to, '');
				$doc->exportAggregate($this->godown, '');
				$doc->exportAggregate($this->jc_no, '');
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->s_grp, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->packing_type, '');
				$doc->exportAggregate($this->rid, '');
				$doc->exportAggregate($this->lot_no, '');
				$doc->exportAggregate($this->avg_quantity, '');
				$doc->exportAggregate($this->max_qty, '');
				$doc->exportAggregate($this->quantity_sub, '');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->exportAggregate($this->packets, 'TOTAL');
				$doc->exportAggregate($this->price, '');
				$doc->exportAggregate($this->dated, '');
				$doc->exportAggregate($this->status, '');
				$doc->exportAggregate($this->uploads, '');
				$doc->exportAggregate($this->godown_po, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'uploads') {
			$fldName = "uploads";
			$fileNameFld = "uploads";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>