<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_out_edit extends material_out
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_out';

	// Page object name
	public $PageObjName = "material_out_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_out)
		if (!isset($GLOBALS["material_out"]) || get_class($GLOBALS["material_out"]) == PROJECT_NAMESPACE . "material_out") {
			$GLOBALS["material_out"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_out"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_out');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_out;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_out);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "material_outview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $DisplayRecs = 1;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $RecCnt;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("material_outlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->process->setVisibility();
		$this->process_type->setVisibility();
		$this->issue_to_unit->setVisibility();
		$this->issue_to->setVisibility();
		$this->godown->setVisibility();
		$this->jc_no->Visible = FALSE;
		$this->gp_no->Visible = FALSE;
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid_1->setVisibility();
		$this->packing_type->setVisibility();
		$this->rid_2->Visible = FALSE;
		$this->rid_3->setVisibility();
		$this->rid->setVisibility();
		$this->lot_no->setVisibility();
		$this->avg_quantity->setVisibility();
		$this->quantity_avg_act->Visible = FALSE;
		$this->max_qty->setVisibility();
		$this->quantity_sub->setVisibility();
		$this->quantity->setVisibility();
		$this->packets->setVisibility();
		$this->price->setVisibility();
		$this->cart_amount->setVisibility();
		$this->other_amount->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->dated->setVisibility();
		$this->remarks->setVisibility();
		$this->status->Visible = FALSE;
		$this->tmp_lot->Visible = FALSE;
		$this->hsn_code->Visible = FALSE;
		$this->amount->Visible = FALSE;
		$this->tax_amount->Visible = FALSE;
		$this->tax_percent->Visible = FALSE;
		$this->total_amount->Visible = FALSE;
		$this->cart_ref->Visible = FALSE;
		$this->po->Visible = FALSE;
		$this->_print->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->url->Visible = FALSE;
		$this->uploads->setVisibility();
		$this->company_id->Visible = FALSE;
		$this->rid_name->Visible = FALSE;
		$this->godown_po->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->process->Required = FALSE;
		$this->godown->Required = FALSE;
		$this->grp->Required = FALSE;
		$this->s_grp->Required = FALSE;
		$this->product->Required = FALSE;
		$this->packing_type->Required = FALSE;
		$this->rid->Required = FALSE;
		$this->quantity->Required = FALSE;
		$this->packets->Required = FALSE;
		$this->dated->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->process_type);
		$this->setupLookupOptions($this->issue_to);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid_1);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->rid_2);
		$this->setupLookupOptions($this->rid_3);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";

		// Load record by position
		$loadByPosition = FALSE;
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
			if (!$loadByQuery)
				$loadByPosition = TRUE;
		}

		// Load recordset
		$this->StartRec = 1; // Initialize start position
		if ($rs = $this->loadRecordset()) // Load records
			$this->TotalRecs = $rs->RecordCount(); // Get record count
		if ($this->TotalRecs <= 0) { // No record found
			if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$this->terminate("material_outlist.php"); // Return to list page
		} elseif ($loadByPosition) { // Load record by position
			$this->setupStartRec(); // Set up start record position

			// Point to current record
			if ($this->StartRec <= $this->TotalRecs) {
				$rs->move($this->StartRec - 1);
				$loaded = TRUE;
			}
		} else { // Match key values
			if ($this->id->CurrentValue != NULL) {
				while (!$rs->EOF) {
					if (SameString($this->id->CurrentValue, $rs->fields('id'))) {
						$this->setStartRecordNumber($this->StartRec); // Save record position
						$loaded = TRUE;
						break;
					} else {
						$this->StartRec++;
						$rs->moveNext();
					}
				}
			}
		}

		// Load current row values
		if ($loaded)
			$this->loadRowValues($rs);

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) {
					if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
					$this->terminate("material_outlist.php"); // Return to list page
				} else {
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "material_outlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->uploads->Upload->Index = $CurrentForm->Index;
		$this->uploads->Upload->uploadFile();
		$this->uploads->CurrentValue = $this->uploads->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'process_type' first before field var 'x_process_type'
		$val = $CurrentForm->hasValue("process_type") ? $CurrentForm->getValue("process_type") : $CurrentForm->getValue("x_process_type");
		if (!$this->process_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process_type->Visible = FALSE; // Disable update for API request
			else
				$this->process_type->setFormValue($val);
		}

		// Check field name 'issue_to_unit' first before field var 'x_issue_to_unit'
		$val = $CurrentForm->hasValue("issue_to_unit") ? $CurrentForm->getValue("issue_to_unit") : $CurrentForm->getValue("x_issue_to_unit");
		if (!$this->issue_to_unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_to_unit->Visible = FALSE; // Disable update for API request
			else
				$this->issue_to_unit->setFormValue($val);
		}

		// Check field name 'issue_to' first before field var 'x_issue_to'
		$val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
		if (!$this->issue_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_to->Visible = FALSE; // Disable update for API request
			else
				$this->issue_to->setFormValue($val);
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown->Visible = FALSE; // Disable update for API request
			else
				$this->godown->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid_1' first before field var 'x_rid_1'
		$val = $CurrentForm->hasValue("rid_1") ? $CurrentForm->getValue("rid_1") : $CurrentForm->getValue("x_rid_1");
		if (!$this->rid_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_1->Visible = FALSE; // Disable update for API request
			else
				$this->rid_1->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'rid_3' first before field var 'x_rid_3'
		$val = $CurrentForm->hasValue("rid_3") ? $CurrentForm->getValue("rid_3") : $CurrentForm->getValue("x_rid_3");
		if (!$this->rid_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_3->Visible = FALSE; // Disable update for API request
			else
				$this->rid_3->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'avg_quantity' first before field var 'x_avg_quantity'
		$val = $CurrentForm->hasValue("avg_quantity") ? $CurrentForm->getValue("avg_quantity") : $CurrentForm->getValue("x_avg_quantity");
		if (!$this->avg_quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->avg_quantity->Visible = FALSE; // Disable update for API request
			else
				$this->avg_quantity->setFormValue($val);
		}

		// Check field name 'max_qty' first before field var 'x_max_qty'
		$val = $CurrentForm->hasValue("max_qty") ? $CurrentForm->getValue("max_qty") : $CurrentForm->getValue("x_max_qty");
		if (!$this->max_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->max_qty->Visible = FALSE; // Disable update for API request
			else
				$this->max_qty->setFormValue($val);
		}

		// Check field name 'quantity_sub' first before field var 'x_quantity_sub'
		$val = $CurrentForm->hasValue("quantity_sub") ? $CurrentForm->getValue("quantity_sub") : $CurrentForm->getValue("x_quantity_sub");
		if (!$this->quantity_sub->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity_sub->Visible = FALSE; // Disable update for API request
			else
				$this->quantity_sub->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'packets' first before field var 'x_packets'
		$val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
		if (!$this->packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packets->Visible = FALSE; // Disable update for API request
			else
				$this->packets->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'cart_amount' first before field var 'x_cart_amount'
		$val = $CurrentForm->hasValue("cart_amount") ? $CurrentForm->getValue("cart_amount") : $CurrentForm->getValue("x_cart_amount");
		if (!$this->cart_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cart_amount->Visible = FALSE; // Disable update for API request
			else
				$this->cart_amount->setFormValue($val);
		}

		// Check field name 'other_amount' first before field var 'x_other_amount'
		$val = $CurrentForm->hasValue("other_amount") ? $CurrentForm->getValue("other_amount") : $CurrentForm->getValue("x_other_amount");
		if (!$this->other_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other_amount->Visible = FALSE; // Disable update for API request
			else
				$this->other_amount->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'dated' first before field var 'x_dated'
		$val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
		if (!$this->dated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dated->Visible = FALSE; // Disable update for API request
			else
				$this->dated->setFormValue($val);
			$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'godown_po' first before field var 'x_godown_po'
		$val = $CurrentForm->hasValue("godown_po") ? $CurrentForm->getValue("godown_po") : $CurrentForm->getValue("x_godown_po");
		if (!$this->godown_po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown_po->Visible = FALSE; // Disable update for API request
			else
				$this->godown_po->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->process_type->CurrentValue = $this->process_type->FormValue;
		$this->issue_to_unit->CurrentValue = $this->issue_to_unit->FormValue;
		$this->issue_to->CurrentValue = $this->issue_to->FormValue;
		$this->godown->CurrentValue = $this->godown->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid_1->CurrentValue = $this->rid_1->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->rid_3->CurrentValue = $this->rid_3->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->avg_quantity->CurrentValue = $this->avg_quantity->FormValue;
		$this->max_qty->CurrentValue = $this->max_qty->FormValue;
		$this->quantity_sub->CurrentValue = $this->quantity_sub->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->packets->CurrentValue = $this->packets->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->cart_amount->CurrentValue = $this->cart_amount->FormValue;
		$this->other_amount->CurrentValue = $this->other_amount->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->dated->CurrentValue = $this->dated->FormValue;
		$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->godown_po->CurrentValue = $this->godown_po->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->process->setDbValue($row['process']);
		$this->process_type->setDbValue($row['process_type']);
		if (array_key_exists('EV__process_type', $rs->fields)) {
			$this->process_type->VirtualValue = $rs->fields('EV__process_type'); // Set up virtual field value
		} else {
			$this->process_type->VirtualValue = ""; // Clear value
		}
		$this->issue_to_unit->setDbValue($row['issue_to_unit']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->godown->setDbValue($row['godown']);
		if (array_key_exists('EV__godown', $rs->fields)) {
			$this->godown->VirtualValue = $rs->fields('EV__godown'); // Set up virtual field value
		} else {
			$this->godown->VirtualValue = ""; // Clear value
		}
		$this->jc_no->setDbValue($row['jc_no']);
		$this->gp_no->setDbValue($row['gp_no']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		if (array_key_exists('EV__s_grp', $rs->fields)) {
			$this->s_grp->VirtualValue = $rs->fields('EV__s_grp'); // Set up virtual field value
		} else {
			$this->s_grp->VirtualValue = ""; // Clear value
		}
		$this->product->setDbValue($row['product']);
		if (array_key_exists('EV__product', $rs->fields)) {
			$this->product->VirtualValue = $rs->fields('EV__product'); // Set up virtual field value
		} else {
			$this->product->VirtualValue = ""; // Clear value
		}
		$this->rid_1->setDbValue($row['rid_1']);
		if (array_key_exists('EV__rid_1', $rs->fields)) {
			$this->rid_1->VirtualValue = $rs->fields('EV__rid_1'); // Set up virtual field value
		} else {
			$this->rid_1->VirtualValue = ""; // Clear value
		}
		$this->packing_type->setDbValue($row['packing_type']);
		if (array_key_exists('EV__packing_type', $rs->fields)) {
			$this->packing_type->VirtualValue = $rs->fields('EV__packing_type'); // Set up virtual field value
		} else {
			$this->packing_type->VirtualValue = ""; // Clear value
		}
		$this->rid_2->setDbValue($row['rid_2']);
		$this->rid_3->setDbValue($row['rid_3']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->lot_no->setDbValue($row['lot_no']);
		$this->avg_quantity->setDbValue($row['avg_quantity']);
		$this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
		$this->max_qty->setDbValue($row['max_qty']);
		$this->quantity_sub->setDbValue($row['quantity_sub']);
		$this->quantity->setDbValue($row['quantity']);
		$this->packets->setDbValue($row['packets']);
		$this->price->setDbValue($row['price']);
		$this->cart_amount->setDbValue($row['cart_amount']);
		$this->other_amount->setDbValue($row['other_amount']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->dated->setDbValue($row['dated']);
		$this->remarks->setDbValue($row['remarks']);
		$this->status->setDbValue($row['status']);
		$this->tmp_lot->setDbValue($row['tmp_lot']);
		$this->hsn_code->setDbValue($row['hsn_code']);
		$this->amount->setDbValue($row['amount']);
		$this->tax_amount->setDbValue($row['tax_amount']);
		$this->tax_percent->setDbValue($row['tax_percent']);
		$this->total_amount->setDbValue($row['total_amount']);
		$this->cart_ref->setDbValue($row['cart_ref']);
		$this->po->setDbValue($row['po']);
		$this->_print->setDbValue($row['print']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->url->setDbValue($row['url']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->company_id->setDbValue($row['company_id']);
		$this->rid_name->setDbValue($row['rid_name']);
		$this->godown_po->setDbValue($row['godown_po']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['process'] = NULL;
		$row['process_type'] = NULL;
		$row['issue_to_unit'] = NULL;
		$row['issue_to'] = NULL;
		$row['godown'] = NULL;
		$row['jc_no'] = NULL;
		$row['gp_no'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid_1'] = NULL;
		$row['packing_type'] = NULL;
		$row['rid_2'] = NULL;
		$row['rid_3'] = NULL;
		$row['rid'] = NULL;
		$row['lot_no'] = NULL;
		$row['avg_quantity'] = NULL;
		$row['quantity_avg_act'] = NULL;
		$row['max_qty'] = NULL;
		$row['quantity_sub'] = NULL;
		$row['quantity'] = NULL;
		$row['packets'] = NULL;
		$row['price'] = NULL;
		$row['cart_amount'] = NULL;
		$row['other_amount'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['dated'] = NULL;
		$row['remarks'] = NULL;
		$row['status'] = NULL;
		$row['tmp_lot'] = NULL;
		$row['hsn_code'] = NULL;
		$row['amount'] = NULL;
		$row['tax_amount'] = NULL;
		$row['tax_percent'] = NULL;
		$row['total_amount'] = NULL;
		$row['cart_ref'] = NULL;
		$row['po'] = NULL;
		$row['print'] = NULL;
		$row['barcode'] = NULL;
		$row['url'] = NULL;
		$row['uploads'] = NULL;
		$row['company_id'] = NULL;
		$row['rid_name'] = NULL;
		$row['godown_po'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity_sub->FormValue == $this->quantity_sub->CurrentValue && is_numeric(ConvertToFloatString($this->quantity_sub->CurrentValue)))
			$this->quantity_sub->CurrentValue = ConvertToFloatString($this->quantity_sub->CurrentValue);

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packets->FormValue == $this->packets->CurrentValue && is_numeric(ConvertToFloatString($this->packets->CurrentValue)))
			$this->packets->CurrentValue = ConvertToFloatString($this->packets->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cart_amount->FormValue == $this->cart_amount->CurrentValue && is_numeric(ConvertToFloatString($this->cart_amount->CurrentValue)))
			$this->cart_amount->CurrentValue = ConvertToFloatString($this->cart_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->other_amount->FormValue == $this->other_amount->CurrentValue && is_numeric(ConvertToFloatString($this->other_amount->CurrentValue)))
			$this->other_amount->CurrentValue = ConvertToFloatString($this->other_amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// process
		// process_type
		// issue_to_unit
		// issue_to
		// godown
		// jc_no
		// gp_no
		// grp
		// s_grp
		// product
		// rid_1
		// packing_type
		// rid_2
		// rid_3
		// rid
		// lot_no
		// avg_quantity
		// quantity_avg_act
		// max_qty
		// quantity_sub
		// quantity
		// packets
		// price
		// cart_amount
		// other_amount
		// operator
		// datetime
		// dated
		// remarks
		// status
		// tmp_lot
		// hsn_code
		// amount
		// tax_amount
		// tax_percent
		// total_amount
		// cart_ref
		// po
		// print
		// barcode
		// url
		// uploads
		// company_id
		// rid_name
		// godown_po

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_type
			if ($this->process_type->VirtualValue <> "") {
				$this->process_type->ViewValue = $this->process_type->VirtualValue;
			} else {
			$curVal = strval($this->process_type->CurrentValue);
			if ($curVal <> "") {
				$this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
				if ($this->process_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process_type->ViewValue = $this->process_type->CurrentValue;
					}
				}
			} else {
				$this->process_type->ViewValue = NULL;
			}
			}
			$this->process_type->ViewCustomAttributes = "";

			// issue_to_unit
			$this->issue_to_unit->ViewValue = $this->issue_to_unit->CurrentValue;
			$this->issue_to_unit->ViewValue = FormatNumber($this->issue_to_unit->ViewValue, 0, -2, -2, -2);
			$this->issue_to_unit->ViewCustomAttributes = "";

			// issue_to
			$curVal = strval($this->issue_to->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
				if ($this->issue_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0 and `category` != 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
					}
				}
			} else {
				$this->issue_to->ViewValue = NULL;
			}
			$this->issue_to->ViewCustomAttributes = "";

			// godown
			if ($this->godown->VirtualValue <> "") {
				$this->godown->ViewValue = $this->godown->VirtualValue;
			} else {
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			}
			$this->godown->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			if ($this->s_grp->VirtualValue <> "") {
				$this->s_grp->ViewValue = $this->s_grp->VirtualValue;
			} else {
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			if ($this->product->VirtualValue <> "") {
				$this->product->ViewValue = $this->product->VirtualValue;
			} else {
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// rid_1
			if ($this->rid_1->VirtualValue <> "") {
				$this->rid_1->ViewValue = $this->rid_1->VirtualValue;
			} else {
			$curVal = strval($this->rid_1->CurrentValue);
			if ($curVal <> "") {
				$this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
				if ($this->rid_1->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
						$arwrk[4] = $rswrk->fields('df4');
						$this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
					}
				}
			} else {
				$this->rid_1->ViewValue = NULL;
			}
			}
			$this->rid_1->ViewCustomAttributes = "";

			// packing_type
			if ($this->packing_type->VirtualValue <> "") {
				$this->packing_type->ViewValue = $this->packing_type->VirtualValue;
			} else {
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			}
			$this->packing_type->ViewCustomAttributes = "";

			// rid_3
			$curVal = strval($this->rid_3->CurrentValue);
			if ($curVal <> "") {
				$this->rid_3->ViewValue = $this->rid_3->lookupCacheOption($curVal);
				if ($this->rid_3->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid_3->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0);
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->rid_3->ViewValue = $this->rid_3->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_3->ViewValue = $this->rid_3->CurrentValue;
					}
				}
			} else {
				$this->rid_3->ViewValue = NULL;
			}
			$this->rid_3->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
				$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// avg_quantity
			$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
			$this->avg_quantity->ViewCustomAttributes = "";

			// max_qty
			$this->max_qty->ViewValue = $this->max_qty->CurrentValue;
			$this->max_qty->ViewCustomAttributes = "";

			// quantity_sub
			$this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
			$this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, 2, -2, -2, -2);
			$this->quantity_sub->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -1, -1, -1);
			$this->quantity->CssClass = "font-weight-bold";
			$this->quantity->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// cart_amount
			$this->cart_amount->ViewValue = $this->cart_amount->CurrentValue;
			$this->cart_amount->ViewValue = FormatNumber($this->cart_amount->ViewValue, 2, -2, -2, -2);
			$this->cart_amount->ViewCustomAttributes = "";

			// other_amount
			$this->other_amount->ViewValue = $this->other_amount->CurrentValue;
			$this->other_amount->ViewValue = FormatNumber($this->other_amount->ViewValue, 2, -2, -2, -2);
			$this->other_amount->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// uploads
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// godown_po
			$this->godown_po->ViewValue = $this->godown_po->CurrentValue;
			$this->godown_po->ViewValue = FormatNumber($this->godown_po->ViewValue, 0, -2, -2, -2);
			$this->godown_po->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "material_outlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// process_type
			$this->process_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->process_type->CurrentValue)) {
				$this->process_type->HrefValue = "material_outlist.php?x_process_type=" . $this->process_type->CurrentValue; // Add prefix/suffix
				$this->process_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
			} else {
				$this->process_type->HrefValue = "";
			}
			$this->process_type->TooltipValue = "";

			// issue_to_unit
			$this->issue_to_unit->LinkCustomAttributes = "";
			$this->issue_to_unit->HrefValue = "";
			$this->issue_to_unit->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			if (!EmptyValue($this->issue_to->CurrentValue)) {
				$this->issue_to->HrefValue = "material_outlist.php?x_issue_to=" . $this->issue_to->CurrentValue; // Add prefix/suffix
				$this->issue_to->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
			} else {
				$this->issue_to->HrefValue = "";
			}
			$this->issue_to->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "material_outlist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "material_outlist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "material_outlist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "material_outlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid_1
			$this->rid_1->LinkCustomAttributes = "";
			$this->rid_1->HrefValue = "";
			$this->rid_1->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "material_outlist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// rid_3
			$this->rid_3->LinkCustomAttributes = "";
			$this->rid_3->HrefValue = "";
			$this->rid_3->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "material_outlist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// avg_quantity
			$this->avg_quantity->LinkCustomAttributes = "";
			$this->avg_quantity->HrefValue = "";
			$this->avg_quantity->TooltipValue = "";

			// max_qty
			$this->max_qty->LinkCustomAttributes = "";
			$this->max_qty->HrefValue = "";
			$this->max_qty->TooltipValue = "";

			// quantity_sub
			$this->quantity_sub->LinkCustomAttributes = "";
			$this->quantity_sub->HrefValue = "";
			$this->quantity_sub->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// cart_amount
			$this->cart_amount->LinkCustomAttributes = "";
			$this->cart_amount->HrefValue = "";
			$this->cart_amount->TooltipValue = "";

			// other_amount
			$this->other_amount->LinkCustomAttributes = "";
			$this->other_amount->HrefValue = "";
			$this->other_amount->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "material_out_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// godown_po
			$this->godown_po->LinkCustomAttributes = "";
			$this->godown_po->HrefValue = "";
			$this->godown_po->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->EditValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->process->EditValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->EditValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->EditValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_type
			$this->process_type->EditAttrs["class"] = "form-control";
			$this->process_type->EditCustomAttributes = "";
			if ($this->process_type->VirtualValue <> "") {
				$this->process_type->EditValue = $this->process_type->VirtualValue;
			} else {
			$curVal = strval($this->process_type->CurrentValue);
			if ($curVal <> "") {
				$this->process_type->EditValue = $this->process_type->lookupCacheOption($curVal);
				if ($this->process_type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_type->EditValue = $this->process_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process_type->EditValue = $this->process_type->CurrentValue;
					}
				}
			} else {
				$this->process_type->EditValue = NULL;
			}
			}
			$this->process_type->ViewCustomAttributes = "";

			// issue_to_unit
			$this->issue_to_unit->EditAttrs["class"] = "form-control";
			$this->issue_to_unit->EditCustomAttributes = "";
			$this->issue_to_unit->EditValue = HtmlEncode($this->issue_to_unit->CurrentValue);
			$this->issue_to_unit->PlaceHolder = RemoveHtml($this->issue_to_unit->caption());

			// issue_to
			$this->issue_to->EditAttrs["class"] = "form-control";
			$this->issue_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_to->CurrentValue));
			if ($curVal <> "")
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			else
				$this->issue_to->ViewValue = $this->issue_to->Lookup !== NULL && is_array($this->issue_to->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_to->ViewValue !== NULL) { // Load from cache
				$this->issue_to->EditValue = array_values($this->issue_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 0 and `category` != 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_to->EditValue = $arwrk;
			}

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			if ($this->godown->VirtualValue <> "") {
				$this->godown->EditValue = $this->godown->VirtualValue;
			} else {
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->EditValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->EditValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->EditValue = NULL;
			}
			}
			$this->godown->ViewCustomAttributes = "";

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			if ($this->s_grp->VirtualValue <> "") {
				$this->s_grp->EditValue = $this->s_grp->VirtualValue;
			} else {
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			if ($this->product->VirtualValue <> "") {
				$this->product->EditValue = $this->product->VirtualValue;
			} else {
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// rid_1
			$this->rid_1->EditAttrs["class"] = "form-control";
			$this->rid_1->EditCustomAttributes = "";
			if ($this->rid_1->VirtualValue <> "") {
				$this->rid_1->EditValue = $this->rid_1->VirtualValue;
			} else {
			$curVal = strval($this->rid_1->CurrentValue);
			if ($curVal <> "") {
				$this->rid_1->EditValue = $this->rid_1->lookupCacheOption($curVal);
				if ($this->rid_1->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
						$arwrk[4] = $rswrk->fields('df4');
						$this->rid_1->EditValue = $this->rid_1->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_1->EditValue = $this->rid_1->CurrentValue;
					}
				}
			} else {
				$this->rid_1->EditValue = NULL;
			}
			}
			$this->rid_1->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			if ($this->packing_type->VirtualValue <> "") {
				$this->packing_type->EditValue = $this->packing_type->VirtualValue;
			} else {
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->EditValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->EditValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->EditValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->EditValue = NULL;
			}
			}
			$this->packing_type->ViewCustomAttributes = "";

			// rid_3
			$this->rid_3->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid_3->CurrentValue));
			if ($curVal <> "")
				$this->rid_3->ViewValue = $this->rid_3->lookupCacheOption($curVal);
			else
				$this->rid_3->ViewValue = $this->rid_3->Lookup !== NULL && is_array($this->rid_3->Lookup->Options) ? $curVal : NULL;
			if ($this->rid_3->ViewValue !== NULL) { // Load from cache
				$this->rid_3->EditValue = array_values($this->rid_3->Lookup->Options);
				if ($this->rid_3->ViewValue == "")
					$this->rid_3->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid_3->CurrentValue, DATATYPE_MEMO, "");
				}
				$lookupFilter = function() {
					return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_3->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode(FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0));
					$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
					$arwrk[4] = HtmlEncode($rswrk->fields('df4'));
					$this->rid_3->ViewValue = $this->rid_3->displayValue($arwrk);
				} else {
					$this->rid_3->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, 0);
				}
				$this->rid_3->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			if ($this->rid->VirtualValue <> "") {
				$this->rid->EditValue = $this->rid->VirtualValue;
			} else {
				$this->rid->EditValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			$this->lot_no->EditValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// avg_quantity
			$this->avg_quantity->EditAttrs["class"] = "form-control";
			$this->avg_quantity->EditCustomAttributes = "";
			$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
			$this->avg_quantity->ViewCustomAttributes = "";

			// max_qty
			$this->max_qty->EditAttrs["class"] = "form-control";
			$this->max_qty->EditCustomAttributes = "readonly";
			$this->max_qty->EditValue = HtmlEncode($this->max_qty->CurrentValue);
			$this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());

			// quantity_sub
			$this->quantity_sub->EditAttrs["class"] = "form-control";
			$this->quantity_sub->EditCustomAttributes = "";
			$this->quantity_sub->EditValue = HtmlEncode($this->quantity_sub->CurrentValue);
			$this->quantity_sub->PlaceHolder = RemoveHtml($this->quantity_sub->caption());
			if (strval($this->quantity_sub->EditValue) <> "" && is_numeric($this->quantity_sub->EditValue))
				$this->quantity_sub->EditValue = FormatNumber($this->quantity_sub->EditValue, -2, -2, -2, -2);

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = $this->quantity->CurrentValue;
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 3, -1, -1, -1);
			$this->quantity->CssClass = "font-weight-bold";
			$this->quantity->ViewCustomAttributes = "";

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = 'ReadOnly';
			$this->packets->EditValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = $this->price->CurrentValue;
			$this->price->EditValue = FormatNumber($this->price->EditValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// cart_amount
			$this->cart_amount->EditAttrs["class"] = "form-control";
			$this->cart_amount->EditCustomAttributes = 'ReadOnly';
			$this->cart_amount->EditValue = $this->cart_amount->CurrentValue;
			$this->cart_amount->EditValue = FormatNumber($this->cart_amount->EditValue, 2, -2, -2, -2);
			$this->cart_amount->ViewCustomAttributes = "";

			// other_amount
			$this->other_amount->EditAttrs["class"] = "form-control";
			$this->other_amount->EditCustomAttributes = "";
			$this->other_amount->EditValue = HtmlEncode($this->other_amount->CurrentValue);
			$this->other_amount->PlaceHolder = RemoveHtml($this->other_amount->caption());
			if (strval($this->other_amount->EditValue) <> "" && is_numeric($this->other_amount->EditValue))
				$this->other_amount->EditValue = FormatNumber($this->other_amount->EditValue, -2, -2, -2, -2);

			// operator
			// datetime
			// dated

			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = $this->dated->CurrentValue;
			$this->dated->EditValue = FormatDateTime($this->dated->EditValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->uploads);

			// godown_po
			$this->godown_po->EditAttrs["class"] = "form-control";
			$this->godown_po->EditCustomAttributes = "";
			$this->godown_po->EditValue = HtmlEncode($this->godown_po->CurrentValue);
			$this->godown_po->PlaceHolder = RemoveHtml($this->godown_po->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "material_outlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// process_type
			$this->process_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->process_type->CurrentValue)) {
				$this->process_type->HrefValue = "material_outlist.php?x_process_type=" . $this->process_type->CurrentValue; // Add prefix/suffix
				$this->process_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
			} else {
				$this->process_type->HrefValue = "";
			}
			$this->process_type->TooltipValue = "";

			// issue_to_unit
			$this->issue_to_unit->LinkCustomAttributes = "";
			$this->issue_to_unit->HrefValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			if (!EmptyValue($this->issue_to->CurrentValue)) {
				$this->issue_to->HrefValue = "material_outlist.php?x_issue_to=" . $this->issue_to->CurrentValue; // Add prefix/suffix
				$this->issue_to->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
			} else {
				$this->issue_to->HrefValue = "";
			}

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "material_outlist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "material_outlist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "material_outlist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "material_outlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid_1
			$this->rid_1->LinkCustomAttributes = "";
			$this->rid_1->HrefValue = "";
			$this->rid_1->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "material_outlist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// rid_3
			$this->rid_3->LinkCustomAttributes = "";
			$this->rid_3->HrefValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "material_outlist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// avg_quantity
			$this->avg_quantity->LinkCustomAttributes = "";
			$this->avg_quantity->HrefValue = "";
			$this->avg_quantity->TooltipValue = "";

			// max_qty
			$this->max_qty->LinkCustomAttributes = "";
			$this->max_qty->HrefValue = "";

			// quantity_sub
			$this->quantity_sub->LinkCustomAttributes = "";
			$this->quantity_sub->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// cart_amount
			$this->cart_amount->LinkCustomAttributes = "";
			$this->cart_amount->HrefValue = "";
			$this->cart_amount->TooltipValue = "";

			// other_amount
			$this->other_amount->LinkCustomAttributes = "";
			$this->other_amount->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// godown_po
			$this->godown_po->LinkCustomAttributes = "";
			$this->godown_po->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->process->Required) {
			if (!$this->process->IsDetailKey && $this->process->FormValue != NULL && $this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if ($this->process_type->Required) {
			if (!$this->process_type->IsDetailKey && $this->process_type->FormValue != NULL && $this->process_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_type->caption(), $this->process_type->RequiredErrorMessage));
			}
		}
		if ($this->issue_to_unit->Required) {
			if (!$this->issue_to_unit->IsDetailKey && $this->issue_to_unit->FormValue != NULL && $this->issue_to_unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to_unit->caption(), $this->issue_to_unit->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->issue_to_unit->FormValue)) {
			AddMessage($FormError, $this->issue_to_unit->errorMessage());
		}
		if ($this->issue_to->Required) {
			if (!$this->issue_to->IsDetailKey && $this->issue_to->FormValue != NULL && $this->issue_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
			}
		}
		if ($this->godown->Required) {
			if ($this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->gp_no->Required) {
			if (!$this->gp_no->IsDetailKey && $this->gp_no->FormValue != NULL && $this->gp_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gp_no->caption(), $this->gp_no->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid_1->Required) {
			if (!$this->rid_1->IsDetailKey && $this->rid_1->FormValue != NULL && $this->rid_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->rid_2->Required) {
			if (!$this->rid_2->IsDetailKey && $this->rid_2->FormValue != NULL && $this->rid_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_2->caption(), $this->rid_2->RequiredErrorMessage));
			}
		}
		if ($this->rid_3->Required) {
			if (!$this->rid_3->IsDetailKey && $this->rid_3->FormValue != NULL && $this->rid_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_3->caption(), $this->rid_3->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->avg_quantity->Required) {
			if (!$this->avg_quantity->IsDetailKey && $this->avg_quantity->FormValue != NULL && $this->avg_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->avg_quantity->caption(), $this->avg_quantity->RequiredErrorMessage));
			}
		}
		if ($this->quantity_avg_act->Required) {
			if ($this->quantity_avg_act->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity_avg_act->caption(), $this->quantity_avg_act->RequiredErrorMessage));
			}
		}
		if ($this->max_qty->Required) {
			if (!$this->max_qty->IsDetailKey && $this->max_qty->FormValue != NULL && $this->max_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->max_qty->caption(), $this->max_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->max_qty->FormValue)) {
			AddMessage($FormError, $this->max_qty->errorMessage());
		}
		if ($this->quantity_sub->Required) {
			if (!$this->quantity_sub->IsDetailKey && $this->quantity_sub->FormValue != NULL && $this->quantity_sub->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity_sub->caption(), $this->quantity_sub->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity_sub->FormValue)) {
			AddMessage($FormError, $this->quantity_sub->errorMessage());
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->packets->Required) {
			if (!$this->packets->IsDetailKey && $this->packets->FormValue != NULL && $this->packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
			}
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if ($this->cart_amount->Required) {
			if (!$this->cart_amount->IsDetailKey && $this->cart_amount->FormValue != NULL && $this->cart_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_amount->caption(), $this->cart_amount->RequiredErrorMessage));
			}
		}
		if ($this->other_amount->Required) {
			if (!$this->other_amount->IsDetailKey && $this->other_amount->FormValue != NULL && $this->other_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_amount->caption(), $this->other_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->other_amount->FormValue)) {
			AddMessage($FormError, $this->other_amount->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->dated->Required) {
			if (!$this->dated->IsDetailKey && $this->dated->FormValue != NULL && $this->dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->tmp_lot->Required) {
			if (!$this->tmp_lot->IsDetailKey && $this->tmp_lot->FormValue != NULL && $this->tmp_lot->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tmp_lot->caption(), $this->tmp_lot->RequiredErrorMessage));
			}
		}
		if ($this->hsn_code->Required) {
			if (!$this->hsn_code->IsDetailKey && $this->hsn_code->FormValue != NULL && $this->hsn_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->hsn_code->caption(), $this->hsn_code->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if ($this->tax_amount->Required) {
			if (!$this->tax_amount->IsDetailKey && $this->tax_amount->FormValue != NULL && $this->tax_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax_amount->caption(), $this->tax_amount->RequiredErrorMessage));
			}
		}
		if ($this->tax_percent->Required) {
			if (!$this->tax_percent->IsDetailKey && $this->tax_percent->FormValue != NULL && $this->tax_percent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax_percent->caption(), $this->tax_percent->RequiredErrorMessage));
			}
		}
		if ($this->total_amount->Required) {
			if (!$this->total_amount->IsDetailKey && $this->total_amount->FormValue != NULL && $this->total_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
			}
		}
		if ($this->cart_ref->Required) {
			if (!$this->cart_ref->IsDetailKey && $this->cart_ref->FormValue != NULL && $this->cart_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_ref->caption(), $this->cart_ref->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->_print->Required) {
			if (!$this->_print->IsDetailKey && $this->_print->FormValue != NULL && $this->_print->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_print->caption(), $this->_print->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if (!$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->rid_name->Required) {
			if (!$this->rid_name->IsDetailKey && $this->rid_name->FormValue != NULL && $this->rid_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_name->caption(), $this->rid_name->RequiredErrorMessage));
			}
		}
		if ($this->godown_po->Required) {
			if (!$this->godown_po->IsDetailKey && $this->godown_po->FormValue != NULL && $this->godown_po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown_po->caption(), $this->godown_po->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->godown_po->FormValue)) {
			AddMessage($FormError, $this->godown_po->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// issue_to_unit
			$this->issue_to_unit->setDbValueDef($rsnew, $this->issue_to_unit->CurrentValue, NULL, $this->issue_to_unit->ReadOnly);

			// issue_to
			$this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, NULL, $this->issue_to->ReadOnly);

			// rid_3
			$this->rid_3->setDbValueDef($rsnew, $this->rid_3->CurrentValue, "", $this->rid_3->ReadOnly);

			// max_qty
			$this->max_qty->setDbValueDef($rsnew, $this->max_qty->CurrentValue, 0, $this->max_qty->ReadOnly);

			// quantity_sub
			$this->quantity_sub->setDbValueDef($rsnew, $this->quantity_sub->CurrentValue, NULL, $this->quantity_sub->ReadOnly);

			// other_amount
			$this->other_amount->setDbValueDef($rsnew, $this->other_amount->CurrentValue, NULL, $this->other_amount->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// uploads
			if ($this->uploads->Visible && !$this->uploads->ReadOnly && !$this->uploads->Upload->KeepFile) {
				$this->uploads->Upload->DbValue = $rsold['uploads']; // Get original value
				if ($this->uploads->Upload->FileName == "") {
					$rsnew['uploads'] = NULL;
				} else {
					$rsnew['uploads'] = $this->uploads->Upload->FileName;
				}
				$this->uploads->ImageWidth = 600; // Resize width
				$this->uploads->ImageHeight = 600; // Resize height
			}

			// godown_po
			$this->godown_po->setDbValueDef($rsnew, $this->godown_po->CurrentValue, NULL, $this->godown_po->ReadOnly);
			if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
				$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
				if (!EmptyValue($this->uploads->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, $this->uploads->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
						if (!EmptyValue($this->uploads->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['uploads']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->uploads->Upload->resizeAndSaveToFile($this->uploads->ImageWidth, $this->uploads->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("material_outlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_type":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0 and `category` != 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_1":
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_3":
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_process":
							break;
						case "x_process_type":
							break;
						case "x_issue_to":
							break;
						case "x_godown":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid_1":
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							break;
						case "x_packing_type":
							break;
						case "x_rid_2":
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_rid_3":
							$row[2] = FormatNumber($row[2], 2, -2, -2, 0);
							$row['df2'] = $row[2];
							break;
						case "x_rid":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'material_out');
		$this->lot_no->ReadOnly = True;
		$this->rid->ReadOnly = True;
		$this->avg_quantity->ReadOnly = True;

		//$this->packing_type->ReadOnly = True;
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>