<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for material_out_f
 */
class material_out_f extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $gp_no;
	public $grp;
	public $s_grp;
	public $product;
	public $rid_1;
	public $rid;
	public $lot_no;
	public $packing_type;
	public $godown;
	public $quantity_avg_act;
	public $packets;
	public $quantity;
	public $max_qty;
	public $avg_quantity;
	public $dated;
	public $process;
	public $process_type;
	public $fp_jc_no;
	public $remarks;
	public $issue_to_sale;
	public $issue_to_godown;
	public $tmp_lot;
	public $issue_to;
	public $status;
	public $operator;
	public $datetime;
	public $jc_no;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'material_out_f';
		$this->TableName = 'material_out_f';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`material_out_f`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('material_out_f', 'material_out_f', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// gp_no
		$this->gp_no = new DbField('material_out_f', 'material_out_f', 'x_gp_no', 'gp_no', '`gp_no`', '`gp_no`', 18, -1, FALSE, '`gp_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gp_no->Sortable = FALSE; // Allow sort
		$this->gp_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gp_no'] = &$this->gp_no;

		// grp
		$this->grp = new DbField('material_out_f', 'material_out_f', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'material_out_f', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->grp->OptionCount = 1;
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('material_out_f', 'material_out_f', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`EV__s_grp`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], [], ["x_product"], [], [], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('material_out_f', 'material_out_f', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid_1
		$this->rid_1 = new DbField('material_out_f', 'material_out_f', 'x_rid_1', 'rid_1', '`rid_1`', '`rid_1`', 200, -1, FALSE, '`rid_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid_1->Sortable = FALSE; // Allow sort
		$this->fields['rid_1'] = &$this->rid_1;

		// rid
		$this->rid = new DbField('material_out_f', 'material_out_f', 'x_rid', 'rid', '`rid`', '`rid`', 2, -1, FALSE, '`EV__rid`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref_f', FALSE, 'id', ["product_code","","",""], ["x_product"], [], ["product"], ["x_product"], [], [], '`product_code` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// lot_no
		$this->lot_no = new DbField('material_out_f', 'material_out_f', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// packing_type
		$this->packing_type = new DbField('material_out_f', 'material_out_f', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`EV__packing_type`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["packing","code","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// godown
		$this->godown = new DbField('material_out_f', 'material_out_f', 'x_godown', 'godown', '`godown`', '`godown`', 19, -1, FALSE, '`EV__godown`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->godown->Required = TRUE; // Required field
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->Lookup = new Lookup('godown', 'godown_table', FALSE, 'id', ["name","location","code",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// quantity_avg_act
		$this->quantity_avg_act = new DbField('material_out_f', 'material_out_f', 'x_quantity_avg_act', 'quantity_avg_act', '`quantity_avg_act`', '`quantity_avg_act`', 17, -1, FALSE, '`quantity_avg_act`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->quantity_avg_act->Sortable = TRUE; // Allow sort
		$this->quantity_avg_act->Lookup = new Lookup('quantity_avg_act', 'material_out_f', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->quantity_avg_act->OptionCount = 2;
		$this->quantity_avg_act->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity_avg_act'] = &$this->quantity_avg_act;

		// packets
		$this->packets = new DbField('material_out_f', 'material_out_f', 'x_packets', 'packets', '`packets`', '`packets`', 131, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Required = TRUE; // Required field
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->DefaultErrorMessage = str_replace(array("%1", "%2"), array("0.001", "10000"), $Language->phrase("IncorrectRange"));
		$this->fields['packets'] = &$this->packets;

		// quantity
		$this->quantity = new DbField('material_out_f', 'material_out_f', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// max_qty
		$this->max_qty = new DbField('material_out_f', 'material_out_f', 'x_max_qty', 'max_qty', '0.00', '0.00', 131, -1, FALSE, '0.00', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->max_qty->IsCustom = TRUE; // Custom field
		$this->max_qty->Sortable = FALSE; // Allow sort
		$this->max_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['max_qty'] = &$this->max_qty;

		// avg_quantity
		$this->avg_quantity = new DbField('material_out_f', 'material_out_f', 'x_avg_quantity', 'avg_quantity', '0.00', '0.00', 131, -1, FALSE, '0.00', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avg_quantity->IsCustom = TRUE; // Custom field
		$this->avg_quantity->Sortable = FALSE; // Allow sort
		$this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['avg_quantity'] = &$this->avg_quantity;

		// dated
		$this->dated = new DbField('material_out_f', 'material_out_f', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 135, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Required = TRUE; // Required field
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// process
		$this->process = new DbField('material_out_f', 'material_out_f', 'x_process', 'process', '`process`', '`process`', 17, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process->Required = TRUE; // Required field
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process->Lookup = new Lookup('process', 'process', TRUE, 'id', ["id","name","",""], [], ["x_process_type"], [], [], [], [], '`id` ASC', '');
		$this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process'] = &$this->process;

		// process_type
		$this->process_type = new DbField('material_out_f', 'material_out_f', 'x_process_type', 'process_type', '`process_type`', '`process_type`', 2, -1, FALSE, '`EV__process_type`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->process_type->Sortable = TRUE; // Allow sort
		$this->process_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process_type->Lookup = new Lookup('process_type', 'process_type_f', FALSE, 'id', ["code","name","avg_yield",""], ["x_process","x_product"], [], ["process","product"], ["x_process","x_product"], [], [], '`code` ASC', '');
		$this->process_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process_type'] = &$this->process_type;

		// fp_jc_no
		$this->fp_jc_no = new DbField('material_out_f', 'material_out_f', 'x_fp_jc_no', 'fp_jc_no', 'process_type', 'process_type', 2, -1, FALSE, 'process_type', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->fp_jc_no->IsCustom = TRUE; // Custom field
		$this->fp_jc_no->Sortable = FALSE; // Allow sort
		$this->fp_jc_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->fp_jc_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->fp_jc_no->Lookup = new Lookup('fp_jc_no', 'job_card', FALSE, 'jc_no', ["jc_no","item","batch_no","quantity"], [], [], [], [], ["works","jc_no"], ["x_issue_to_godown","x_jc_no"], '`jc_no` ASC', '');
		$this->fp_jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['fp_jc_no'] = &$this->fp_jc_no;

		// remarks
		$this->remarks = new DbField('material_out_f', 'material_out_f', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// issue_to_sale
		$this->issue_to_sale = new DbField('material_out_f', 'material_out_f', 'x_issue_to_sale', 'issue_to_sale', 'issue_to', 'issue_to', 18, -1, FALSE, 'issue_to', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to_sale->IsCustom = TRUE; // Custom field
		$this->issue_to_sale->Required = TRUE; // Required field
		$this->issue_to_sale->Sortable = FALSE; // Allow sort
		$this->issue_to_sale->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to_sale->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to_sale->Lookup = new Lookup('issue_to_sale', 'buyer', FALSE, 'id', ["code","name","",""], [], [], [], [], ["id"], ["x_issue_to"], '`name` ASC', '');
		$this->issue_to_sale->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to_sale'] = &$this->issue_to_sale;

		// issue_to_godown
		$this->issue_to_godown = new DbField('material_out_f', 'material_out_f', 'x_issue_to_godown', 'issue_to_godown', 'issue_to', 'issue_to', 18, -1, FALSE, 'issue_to', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to_godown->IsCustom = TRUE; // Custom field
		$this->issue_to_godown->Required = TRUE; // Required field
		$this->issue_to_godown->Sortable = FALSE; // Allow sort
		$this->issue_to_godown->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to_godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to_godown->Lookup = new Lookup('issue_to_godown', 'godown_table', FALSE, 'id', ["code","name","",""], [], [], [], [], ["id"], ["x_issue_to"], '`name` ASC', '');
		$this->issue_to_godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to_godown'] = &$this->issue_to_godown;

		// tmp_lot
		$this->tmp_lot = new DbField('material_out_f', 'material_out_f', 'x_tmp_lot', 'tmp_lot', '`tmp_lot`', '`tmp_lot`', 131, -1, FALSE, '`tmp_lot`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tmp_lot->Required = TRUE; // Required field
		$this->tmp_lot->Sortable = TRUE; // Allow sort
		$this->tmp_lot->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tmp_lot'] = &$this->tmp_lot;

		// issue_to
		$this->issue_to = new DbField('material_out_f', 'material_out_f', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 19, -1, FALSE, '`EV__issue_to`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to->Required = TRUE; // Required field
		$this->issue_to->Sortable = TRUE; // Allow sort
		$this->issue_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to->Lookup = new Lookup('issue_to', 'buyer', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to'] = &$this->issue_to;

		// status
		$this->status = new DbField('material_out_f', 'material_out_f', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'material_out_f', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 3;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('material_out_f', 'material_out_f', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('material_out_f', 'material_out_f', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// jc_no
		$this->jc_no = new DbField('material_out_f', 'material_out_f', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 200, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->jc_no->Sortable = FALSE; // Allow sort
		$this->jc_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->jc_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->jc_no->Lookup = new Lookup('jc_no', 'job_card', TRUE, 'jc_no', ["jc_no","","",""], [], [], [], [], [], [], '`jc_no` ASC', '');
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`material_out_f`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, 0.00 AS `max_qty`, 0.00 AS `avg_quantity`, process_type AS `fp_jc_no`, issue_to AS `issue_to_sale`, issue_to AS `issue_to_godown` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, 0.00 AS `max_qty`, 0.00 AS `avg_quantity`, process_type AS `fp_jc_no`, issue_to AS `issue_to_sale`, issue_to AS `issue_to_godown`, (SELECT `product_group` FROM `product_group` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out_f`.`s_grp` LIMIT 1) AS `EV__s_grp`, (SELECT `product_code` FROM `ref_f` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out_f`.`rid` LIMIT 1) AS `EV__rid`, (SELECT CONCAT(COALESCE(`packing`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`code`,'')) FROM `packing_type` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out_f`.`packing_type` LIMIT 1) AS `EV__packing_type`, (SELECT CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->godown) . "',COALESCE(`location`,''),'" . ValueSeparator(2, $this->godown) . "',COALESCE(`code`,'')) FROM `godown_table` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out_f`.`godown` LIMIT 1) AS `EV__godown`, (SELECT CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->process_type) . "',COALESCE(`name`,''),'" . ValueSeparator(2, $this->process_type) . "',COALESCE(`avg_yield`,'')) FROM `process_type_f` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out_f`.`process_type` LIMIT 1) AS `EV__process_type`, (SELECT CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->issue_to) . "',COALESCE(`name`,'')) FROM `buyer` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_out_f`.`issue_to` LIMIT 1) AS `EV__issue_to` FROM `material_out_f`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Site() == 0) ? "" :  "FIND_IN_SET(`godown`, '" . User_Site() . "')";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->s_grp->AdvancedSearch->SearchValue <> "" ||
			$this->s_grp->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->s_grp->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->s_grp->VirtualExpression . " "))
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if ($this->packing_type->AdvancedSearch->SearchValue <> "" ||
			$this->packing_type->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->packing_type->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->packing_type->VirtualExpression . " "))
			return TRUE;
		if ($this->godown->AdvancedSearch->SearchValue <> "" ||
			$this->godown->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->godown->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->godown->VirtualExpression . " "))
			return TRUE;
		if ($this->process_type->AdvancedSearch->SearchValue <> "" ||
			$this->process_type->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->process_type->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->process_type->VirtualExpression . " "))
			return TRUE;
		if ($this->issue_to->AdvancedSearch->SearchValue <> "" ||
			$this->issue_to->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->issue_to->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->issue_to->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->gp_no->DbValue = $row['gp_no'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid_1->DbValue = $row['rid_1'];
		$this->rid->DbValue = $row['rid'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->godown->DbValue = $row['godown'];
		$this->quantity_avg_act->DbValue = $row['quantity_avg_act'];
		$this->packets->DbValue = $row['packets'];
		$this->quantity->DbValue = $row['quantity'];
		$this->max_qty->DbValue = $row['max_qty'];
		$this->avg_quantity->DbValue = $row['avg_quantity'];
		$this->dated->DbValue = $row['dated'];
		$this->process->DbValue = $row['process'];
		$this->process_type->DbValue = $row['process_type'];
		$this->fp_jc_no->DbValue = $row['fp_jc_no'];
		$this->remarks->DbValue = $row['remarks'];
		$this->issue_to_sale->DbValue = $row['issue_to_sale'];
		$this->issue_to_godown->DbValue = $row['issue_to_godown'];
		$this->tmp_lot->DbValue = $row['tmp_lot'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->jc_no->DbValue = $row['jc_no'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "material_out_flist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "material_out_fview.php")
			return $Language->phrase("View");
		elseif ($pageName == "material_out_fedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "material_out_fadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "material_out_flist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("material_out_fview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("material_out_fview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "material_out_fadd.php?" . $this->getUrlParm($parm);
		else
			$url = "material_out_fadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("material_out_fedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("material_out_fadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("material_out_fdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->gp_no->setDbValue($rs->fields('gp_no'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid_1->setDbValue($rs->fields('rid_1'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->quantity_avg_act->setDbValue($rs->fields('quantity_avg_act'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->max_qty->setDbValue($rs->fields('max_qty'));
		$this->avg_quantity->setDbValue($rs->fields('avg_quantity'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->process->setDbValue($rs->fields('process'));
		$this->process_type->setDbValue($rs->fields('process_type'));
		$this->fp_jc_no->setDbValue($rs->fields('fp_jc_no'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->issue_to_sale->setDbValue($rs->fields('issue_to_sale'));
		$this->issue_to_godown->setDbValue($rs->fields('issue_to_godown'));
		$this->tmp_lot->setDbValue($rs->fields('tmp_lot'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// gp_no

		$this->gp_no->CellCssStyle = "white-space: nowrap;";

		// grp
		// s_grp
		// product
		// rid_1

		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// rid
		// lot_no
		// packing_type
		// godown
		// quantity_avg_act
		// packets
		// quantity
		// max_qty

		$this->max_qty->CellCssStyle = "white-space: nowrap;";

		// avg_quantity
		$this->avg_quantity->CellCssStyle = "white-space: nowrap;";

		// dated
		// process
		// process_type
		// fp_jc_no

		$this->fp_jc_no->CellCssStyle = "white-space: nowrap;";

		// remarks
		// issue_to_sale

		$this->issue_to_sale->CellCssStyle = "white-space: nowrap;";

		// issue_to_godown
		$this->issue_to_godown->CellCssStyle = "white-space: nowrap;";

		// tmp_lot
		// issue_to
		// status
		// operator
		// datetime
		// jc_no

		$this->jc_no->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// gp_no
		$this->gp_no->ViewValue = $this->gp_no->CurrentValue;
		$this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, 0, -2, -2, -2);
		$this->gp_no->ViewCustomAttributes = 'class="btn btn-default"';

		// grp
		if (strval($this->grp->CurrentValue) <> "") {
			$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		if ($this->s_grp->VirtualValue <> "") {
			$this->s_grp->ViewValue = $this->s_grp->VirtualValue;
		} else {
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 1 AND `status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$this->product->ViewCustomAttributes = "";

		// rid_1
		$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
		$this->rid_1->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
			$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// packing_type
		if ($this->packing_type->VirtualValue <> "") {
			$this->packing_type->ViewValue = $this->packing_type->VirtualValue;
		} else {
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		}
		$this->packing_type->ViewCustomAttributes = "";

		// godown
		if ($this->godown->VirtualValue <> "") {
			$this->godown->ViewValue = $this->godown->VirtualValue;
		} else {
			$this->godown->ViewValue = $this->godown->CurrentValue;
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		}
		$this->godown->ViewCustomAttributes = "";

		// quantity_avg_act
		if (strval($this->quantity_avg_act->CurrentValue) <> "") {
			$this->quantity_avg_act->ViewValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
		} else {
			$this->quantity_avg_act->ViewValue = NULL;
		}
		$this->quantity_avg_act->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -1, -1, -1);
		$this->quantity->CssClass = "font-weight-bold";
		$this->quantity->ViewCustomAttributes = "";

		// max_qty
		$this->max_qty->ViewValue = $this->max_qty->CurrentValue;
		$this->max_qty->ViewValue = FormatNumber($this->max_qty->ViewValue, 2, -2, -2, -2);
		$this->max_qty->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 2, -2, -2, -2);
		$this->avg_quantity->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` =1 and `status` = 1 and id > 10";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->process->ViewValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// process_type
		if ($this->process_type->VirtualValue <> "") {
			$this->process_type->ViewValue = $this->process_type->VirtualValue;
		} else {
		$curVal = strval($this->process_type->CurrentValue);
		if ($curVal <> "") {
			$this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
			if ($this->process_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->process_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process_type->ViewValue = $this->process_type->CurrentValue;
				}
			}
		} else {
			$this->process_type->ViewValue = NULL;
		}
		}
		$this->process_type->ViewCustomAttributes = "";

		// fp_jc_no
		$curVal = strval($this->fp_jc_no->CurrentValue);
		if ($curVal <> "") {
			$this->fp_jc_no->ViewValue = $this->fp_jc_no->lookupCacheOption($curVal);
			if ($this->fp_jc_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->fp_jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
					$this->fp_jc_no->ViewValue = $this->fp_jc_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->fp_jc_no->ViewValue = $this->fp_jc_no->CurrentValue;
				}
			}
		} else {
			$this->fp_jc_no->ViewValue = NULL;
		}
		$this->fp_jc_no->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// issue_to_sale
		$curVal = strval($this->issue_to_sale->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to_sale->ViewValue = $this->issue_to_sale->lookupCacheOption($curVal);
			if ($this->issue_to_sale->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `grp` IN(0,1) and `type`=3 ";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to_sale->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->issue_to_sale->ViewValue = $this->issue_to_sale->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to_sale->ViewValue = $this->issue_to_sale->CurrentValue;
				}
			}
		} else {
			$this->issue_to_sale->ViewValue = NULL;
		}
		$this->issue_to_sale->ViewCustomAttributes = "";

		// issue_to_godown
		$curVal = strval($this->issue_to_godown->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to_godown->ViewValue = $this->issue_to_godown->lookupCacheOption($curVal);
			if ($this->issue_to_godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `grp` IN(0,1,23)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to_godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->issue_to_godown->ViewValue = $this->issue_to_godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to_godown->ViewValue = $this->issue_to_godown->CurrentValue;
				}
			}
		} else {
			$this->issue_to_godown->ViewValue = NULL;
		}
		$this->issue_to_godown->ViewCustomAttributes = "";

		// tmp_lot
		$this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
		$this->tmp_lot->ViewValue = FormatNumber($this->tmp_lot->ViewValue, 2, -2, -2, -2);
		$this->tmp_lot->ViewCustomAttributes = "";

		// issue_to
		if ($this->issue_to->VirtualValue <> "") {
			$this->issue_to->ViewValue = $this->issue_to->VirtualValue;
		} else {
		$curVal = strval($this->issue_to->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			if ($this->issue_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
				}
			}
		} else {
			$this->issue_to->ViewValue = NULL;
		}
		}
		$this->issue_to->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// jc_no
		$curVal = strval($this->jc_no->CurrentValue);
		if ($curVal <> "") {
			$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
			if ($this->jc_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
				}
			}
		} else {
			$this->jc_no->ViewValue = NULL;
		}
		$this->jc_no->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// gp_no
		$this->gp_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->id->CurrentValue)) {
			$this->gp_no->HrefValue = "gst_challan.php?ID=" . $this->id->CurrentValue; // Add prefix/suffix
			$this->gp_no->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->gp_no->HrefValue = FullUrl($this->gp_no->HrefValue, "href");
		} else {
			$this->gp_no->HrefValue = "";
		}
		$this->gp_no->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "material_out_flist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "material_out_flist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "material_out_flist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid_1
		$this->rid_1->LinkCustomAttributes = "";
		$this->rid_1->HrefValue = "";
		$this->rid_1->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "material_out_flist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->packing_type->CurrentValue)) {
			$this->packing_type->HrefValue = "material_out_flist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
			$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
		} else {
			$this->packing_type->HrefValue = "";
		}
		$this->packing_type->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown->CurrentValue)) {
			$this->godown->HrefValue = "material_out_flist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
			$this->godown->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
		} else {
			$this->godown->HrefValue = "";
		}
		$this->godown->TooltipValue = "";

		// quantity_avg_act
		$this->quantity_avg_act->LinkCustomAttributes = "";
		$this->quantity_avg_act->HrefValue = "";
		$this->quantity_avg_act->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// max_qty
		$this->max_qty->LinkCustomAttributes = "";
		$this->max_qty->HrefValue = "";
		$this->max_qty->TooltipValue = "";

		// avg_quantity
		$this->avg_quantity->LinkCustomAttributes = "";
		$this->avg_quantity->HrefValue = "";
		$this->avg_quantity->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		if (!EmptyValue($this->process->CurrentValue)) {
			$this->process->HrefValue = "material_out_flist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
			$this->process->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
		} else {
			$this->process->HrefValue = "";
		}
		$this->process->TooltipValue = "";

		// process_type
		$this->process_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->process_type->CurrentValue)) {
			$this->process_type->HrefValue = "material_out_flist.php?x_process_type=" . $this->process_type->CurrentValue; // Add prefix/suffix
			$this->process_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
		} else {
			$this->process_type->HrefValue = "";
		}
		$this->process_type->TooltipValue = "";

		// fp_jc_no
		$this->fp_jc_no->LinkCustomAttributes = "";
		$this->fp_jc_no->HrefValue = "";
		$this->fp_jc_no->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// issue_to_sale
		$this->issue_to_sale->LinkCustomAttributes = "";
		$this->issue_to_sale->HrefValue = "";
		$this->issue_to_sale->TooltipValue = "";

		// issue_to_godown
		$this->issue_to_godown->LinkCustomAttributes = "";
		$this->issue_to_godown->HrefValue = "";
		$this->issue_to_godown->TooltipValue = "";

		// tmp_lot
		$this->tmp_lot->LinkCustomAttributes = "";
		$this->tmp_lot->HrefValue = "";
		$this->tmp_lot->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		if (!EmptyValue($this->issue_to->CurrentValue)) {
			$this->issue_to->HrefValue = "material_out_flist.php?x_issue_to=" . $this->issue_to->CurrentValue; // Add prefix/suffix
			$this->issue_to->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
		} else {
			$this->issue_to->HrefValue = "";
		}
		$this->issue_to->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		if (!EmptyValue($this->status->CurrentValue)) {
			$this->status->HrefValue = "material_out_flist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
			$this->status->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
		} else {
			$this->status->HrefValue = "";
		}
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// gp_no
		$this->gp_no->EditAttrs["class"] = "form-control";
		$this->gp_no->EditCustomAttributes = "";
		$this->gp_no->EditValue = $this->gp_no->CurrentValue;
		$this->gp_no->PlaceHolder = RemoveHtml($this->gp_no->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->options(TRUE);

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		if ($this->s_grp->VirtualValue <> "") {
			$this->s_grp->EditValue = $this->s_grp->VirtualValue;
		} else {
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 1 AND `status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->EditValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->EditValue = NULL;
		}
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->ViewCustomAttributes = "";

		// rid_1
		$this->rid_1->EditAttrs["class"] = "form-control";
		$this->rid_1->EditCustomAttributes = "";
		$this->rid_1->EditValue = $this->rid_1->CurrentValue;
		$this->rid_1->ViewCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		if ($this->rid->VirtualValue <> "") {
			$this->rid->EditValue = $this->rid->VirtualValue;
		} else {
			$this->rid->EditValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->EditValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->EditValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->EditValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "readonly";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "readonly";
		$this->godown->EditValue = $this->godown->CurrentValue;
		$this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

		// quantity_avg_act
		$this->quantity_avg_act->EditCustomAttributes = "";
		$this->quantity_avg_act->EditValue = $this->quantity_avg_act->options(FALSE);

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
		if (strval($this->packets->EditValue) <> "" && is_numeric($this->packets->EditValue))
			$this->packets->EditValue = FormatNumber($this->packets->EditValue, -2, -1, -2, 0);

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -1, -2, -1);

		// max_qty
		$this->max_qty->EditAttrs["class"] = "form-control";
		$this->max_qty->EditCustomAttributes = 'ReadOnly';
		$this->max_qty->EditValue = $this->max_qty->CurrentValue;
		$this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());
		if (strval($this->max_qty->EditValue) <> "" && is_numeric($this->max_qty->EditValue))
			$this->max_qty->EditValue = FormatNumber($this->max_qty->EditValue, -2, -2, -2, -2);

		// avg_quantity
		$this->avg_quantity->EditAttrs["class"] = "form-control";
		$this->avg_quantity->EditCustomAttributes = "readonly";
		$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());
		if (strval($this->avg_quantity->EditValue) <> "" && is_numeric($this->avg_quantity->EditValue))
			$this->avg_quantity->EditValue = FormatNumber($this->avg_quantity->EditValue, -2, -2, -2, -2);

		// dated
		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, 8);
		$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";

		// process_type
		$this->process_type->EditAttrs["class"] = "form-control";
		$this->process_type->EditCustomAttributes = "";

		// fp_jc_no
		$this->fp_jc_no->EditAttrs["class"] = "form-control";
		$this->fp_jc_no->EditCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// issue_to_sale
		$this->issue_to_sale->EditAttrs["class"] = "form-control";
		$this->issue_to_sale->EditCustomAttributes = "";

		// issue_to_godown
		$this->issue_to_godown->EditAttrs["class"] = "form-control";
		$this->issue_to_godown->EditCustomAttributes = "";

		// tmp_lot
		$this->tmp_lot->EditAttrs["class"] = "form-control";
		$this->tmp_lot->EditCustomAttributes = "";
		$this->tmp_lot->EditValue = $this->tmp_lot->CurrentValue;
		$this->tmp_lot->PlaceHolder = RemoveHtml($this->tmp_lot->caption());
		if (strval($this->tmp_lot->EditValue) <> "" && is_numeric($this->tmp_lot->EditValue))
			$this->tmp_lot->EditValue = FormatNumber($this->tmp_lot->EditValue, -2, -2, -2, -2);

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// operator
		// datetime
		// jc_no

		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = `ReadOnly`;

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->packets->CurrentValue))
				$this->packets->Total += $this->packets->CurrentValue; // Accumulate total
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->packets->CurrentValue = $this->packets->Total;
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";
			$this->packets->HrefValue = ""; // Clear href value
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -1, -1, -1);
			$this->quantity->CssClass = "font-weight-bold";
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid_1);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->quantity_avg_act);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->max_qty);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->process_type);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->tmp_lot);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->quantity_avg_act);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->process_type);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->tmp_lot);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid_1);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->godown);
						$doc->exportField($this->quantity_avg_act);
						$doc->exportField($this->packets);
						$doc->exportField($this->quantity);
						$doc->exportField($this->max_qty);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->dated);
						$doc->exportField($this->process);
						$doc->exportField($this->process_type);
						$doc->exportField($this->remarks);
						$doc->exportField($this->tmp_lot);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->godown);
						$doc->exportField($this->quantity_avg_act);
						$doc->exportField($this->packets);
						$doc->exportField($this->quantity);
						$doc->exportField($this->dated);
						$doc->exportField($this->process);
						$doc->exportField($this->process_type);
						$doc->exportField($this->remarks);
						$doc->exportField($this->tmp_lot);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->s_grp, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->rid, '');
				$doc->exportAggregate($this->lot_no, '');
				$doc->exportAggregate($this->packing_type, '');
				$doc->exportAggregate($this->godown, '');
				$doc->exportAggregate($this->quantity_avg_act, '');
				$doc->exportAggregate($this->packets, 'TOTAL');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->exportAggregate($this->dated, '');
				$doc->exportAggregate($this->process, '');
				$doc->exportAggregate($this->process_type, '');
				$doc->exportAggregate($this->remarks, '');
				$doc->exportAggregate($this->tmp_lot, '');
				$doc->exportAggregate($this->issue_to, '');
				$doc->exportAggregate($this->status, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>