<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_out_hs_list extends material_out_hs
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_out_hs';

	// Page object name
	public $PageObjName = "material_out_hs_list";

	// Grid form hidden field names
	public $FormName = "fmaterial_out_hslist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_out_hs)
		if (!isset($GLOBALS["material_out_hs"]) || get_class($GLOBALS["material_out_hs"]) == PROJECT_NAMESPACE . "material_out_hs") {
			$GLOBALS["material_out_hs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_out_hs"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "material_out_hsadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "material_out_hsdelete.php";
		$this->MultiUpdateUrl = "material_out_hsupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_out_hs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fmaterial_out_hslistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_out_hs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_out_hs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->godown->setVisibility();
		$this->jc_no->setVisibility();
		$this->rid_1->Visible = FALSE;
		$this->rid->setVisibility();
		$this->emp_id->setVisibility();
		$this->quantity->setVisibility();
		$this->lot_no->setVisibility();
		$this->tmp_lot->setVisibility();
		$this->process->Visible = FALSE;
		$this->process_type->Visible = FALSE;
		$this->dated->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->po->Visible = FALSE;
		$this->_print->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->issue_to->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->quantity_avg_act->Visible = FALSE;
		$this->available_quantity->Visible = FALSE;
		$this->avg_wt->Visible = FALSE;
		$this->packing_type->Visible = FALSE;
		$this->packets->Visible = FALSE;
		$this->gp_no->Visible = FALSE;
		$this->jc_quantity->setVisibility();
		$this->batch_no->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->jc_no);
		$this->setupLookupOptions($this->rid_1);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->emp_id);
		$this->setupLookupOptions($this->lot_no);
		$this->setupLookupOptions($this->tmp_lot);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->process_type);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->po);
		$this->setupLookupOptions($this->issue_to);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->packing_type);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fmaterial_out_hslistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
		$filterList = Concat($filterList, $this->godown->AdvancedSearch->toJson(), ","); // Field godown
		$filterList = Concat($filterList, $this->jc_no->AdvancedSearch->toJson(), ","); // Field jc_no
		$filterList = Concat($filterList, $this->rid_1->AdvancedSearch->toJson(), ","); // Field rid_1
		$filterList = Concat($filterList, $this->emp_id->AdvancedSearch->toJson(), ","); // Field emp_id
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->lot_no->AdvancedSearch->toJson(), ","); // Field lot_no
		$filterList = Concat($filterList, $this->tmp_lot->AdvancedSearch->toJson(), ","); // Field tmp_lot
		$filterList = Concat($filterList, $this->process->AdvancedSearch->toJson(), ","); // Field process
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->available_quantity->AdvancedSearch->toJson(), ","); // Field available_quantity
		$filterList = Concat($filterList, $this->avg_wt->AdvancedSearch->toJson(), ","); // Field avg_wt
		$filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
		$filterList = Concat($filterList, $this->packets->AdvancedSearch->toJson(), ","); // Field packets
		$filterList = Concat($filterList, $this->jc_quantity->AdvancedSearch->toJson(), ","); // Field jc_quantity
		$filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fmaterial_out_hslistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field s_grp
		$this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
		$this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
		$this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
		$this->s_grp->AdvancedSearch->save();

		// Field godown
		$this->godown->AdvancedSearch->SearchValue = @$filter["x_godown"];
		$this->godown->AdvancedSearch->SearchOperator = @$filter["z_godown"];
		$this->godown->AdvancedSearch->SearchCondition = @$filter["v_godown"];
		$this->godown->AdvancedSearch->SearchValue2 = @$filter["y_godown"];
		$this->godown->AdvancedSearch->SearchOperator2 = @$filter["w_godown"];
		$this->godown->AdvancedSearch->save();

		// Field jc_no
		$this->jc_no->AdvancedSearch->SearchValue = @$filter["x_jc_no"];
		$this->jc_no->AdvancedSearch->SearchOperator = @$filter["z_jc_no"];
		$this->jc_no->AdvancedSearch->SearchCondition = @$filter["v_jc_no"];
		$this->jc_no->AdvancedSearch->SearchValue2 = @$filter["y_jc_no"];
		$this->jc_no->AdvancedSearch->SearchOperator2 = @$filter["w_jc_no"];
		$this->jc_no->AdvancedSearch->save();

		// Field rid_1
		$this->rid_1->AdvancedSearch->SearchValue = @$filter["x_rid_1"];
		$this->rid_1->AdvancedSearch->SearchOperator = @$filter["z_rid_1"];
		$this->rid_1->AdvancedSearch->SearchCondition = @$filter["v_rid_1"];
		$this->rid_1->AdvancedSearch->SearchValue2 = @$filter["y_rid_1"];
		$this->rid_1->AdvancedSearch->SearchOperator2 = @$filter["w_rid_1"];
		$this->rid_1->AdvancedSearch->save();

		// Field emp_id
		$this->emp_id->AdvancedSearch->SearchValue = @$filter["x_emp_id"];
		$this->emp_id->AdvancedSearch->SearchOperator = @$filter["z_emp_id"];
		$this->emp_id->AdvancedSearch->SearchCondition = @$filter["v_emp_id"];
		$this->emp_id->AdvancedSearch->SearchValue2 = @$filter["y_emp_id"];
		$this->emp_id->AdvancedSearch->SearchOperator2 = @$filter["w_emp_id"];
		$this->emp_id->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field lot_no
		$this->lot_no->AdvancedSearch->SearchValue = @$filter["x_lot_no"];
		$this->lot_no->AdvancedSearch->SearchOperator = @$filter["z_lot_no"];
		$this->lot_no->AdvancedSearch->SearchCondition = @$filter["v_lot_no"];
		$this->lot_no->AdvancedSearch->SearchValue2 = @$filter["y_lot_no"];
		$this->lot_no->AdvancedSearch->SearchOperator2 = @$filter["w_lot_no"];
		$this->lot_no->AdvancedSearch->save();

		// Field tmp_lot
		$this->tmp_lot->AdvancedSearch->SearchValue = @$filter["x_tmp_lot"];
		$this->tmp_lot->AdvancedSearch->SearchOperator = @$filter["z_tmp_lot"];
		$this->tmp_lot->AdvancedSearch->SearchCondition = @$filter["v_tmp_lot"];
		$this->tmp_lot->AdvancedSearch->SearchValue2 = @$filter["y_tmp_lot"];
		$this->tmp_lot->AdvancedSearch->SearchOperator2 = @$filter["w_tmp_lot"];
		$this->tmp_lot->AdvancedSearch->save();

		// Field process
		$this->process->AdvancedSearch->SearchValue = @$filter["x_process"];
		$this->process->AdvancedSearch->SearchOperator = @$filter["z_process"];
		$this->process->AdvancedSearch->SearchCondition = @$filter["v_process"];
		$this->process->AdvancedSearch->SearchValue2 = @$filter["y_process"];
		$this->process->AdvancedSearch->SearchOperator2 = @$filter["w_process"];
		$this->process->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field available_quantity
		$this->available_quantity->AdvancedSearch->SearchValue = @$filter["x_available_quantity"];
		$this->available_quantity->AdvancedSearch->SearchOperator = @$filter["z_available_quantity"];
		$this->available_quantity->AdvancedSearch->SearchCondition = @$filter["v_available_quantity"];
		$this->available_quantity->AdvancedSearch->SearchValue2 = @$filter["y_available_quantity"];
		$this->available_quantity->AdvancedSearch->SearchOperator2 = @$filter["w_available_quantity"];
		$this->available_quantity->AdvancedSearch->save();

		// Field avg_wt
		$this->avg_wt->AdvancedSearch->SearchValue = @$filter["x_avg_wt"];
		$this->avg_wt->AdvancedSearch->SearchOperator = @$filter["z_avg_wt"];
		$this->avg_wt->AdvancedSearch->SearchCondition = @$filter["v_avg_wt"];
		$this->avg_wt->AdvancedSearch->SearchValue2 = @$filter["y_avg_wt"];
		$this->avg_wt->AdvancedSearch->SearchOperator2 = @$filter["w_avg_wt"];
		$this->avg_wt->AdvancedSearch->save();

		// Field packing_type
		$this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
		$this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
		$this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
		$this->packing_type->AdvancedSearch->save();

		// Field packets
		$this->packets->AdvancedSearch->SearchValue = @$filter["x_packets"];
		$this->packets->AdvancedSearch->SearchOperator = @$filter["z_packets"];
		$this->packets->AdvancedSearch->SearchCondition = @$filter["v_packets"];
		$this->packets->AdvancedSearch->SearchValue2 = @$filter["y_packets"];
		$this->packets->AdvancedSearch->SearchOperator2 = @$filter["w_packets"];
		$this->packets->AdvancedSearch->save();

		// Field jc_quantity
		$this->jc_quantity->AdvancedSearch->SearchValue = @$filter["x_jc_quantity"];
		$this->jc_quantity->AdvancedSearch->SearchOperator = @$filter["z_jc_quantity"];
		$this->jc_quantity->AdvancedSearch->SearchCondition = @$filter["v_jc_quantity"];
		$this->jc_quantity->AdvancedSearch->SearchValue2 = @$filter["y_jc_quantity"];
		$this->jc_quantity->AdvancedSearch->SearchOperator2 = @$filter["w_jc_quantity"];
		$this->jc_quantity->AdvancedSearch->save();

		// Field batch_no
		$this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
		$this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
		$this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
		$this->batch_no->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->s_grp, $default, FALSE); // s_grp
		$this->buildSearchSql($where, $this->godown, $default, FALSE); // godown
		$this->buildSearchSql($where, $this->jc_no, $default, FALSE); // jc_no
		$this->buildSearchSql($where, $this->rid_1, $default, FALSE); // rid_1
		$this->buildSearchSql($where, $this->emp_id, $default, FALSE); // emp_id
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->lot_no, $default, FALSE); // lot_no
		$this->buildSearchSql($where, $this->tmp_lot, $default, FALSE); // tmp_lot
		$this->buildSearchSql($where, $this->process, $default, FALSE); // process
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->available_quantity, $default, FALSE); // available_quantity
		$this->buildSearchSql($where, $this->avg_wt, $default, FALSE); // avg_wt
		$this->buildSearchSql($where, $this->packing_type, $default, FALSE); // packing_type
		$this->buildSearchSql($where, $this->packets, $default, FALSE); // packets
		$this->buildSearchSql($where, $this->jc_quantity, $default, FALSE); // jc_quantity
		$this->buildSearchSql($where, $this->batch_no, $default, FALSE); // batch_no

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->grp->AdvancedSearch->save(); // grp
			$this->s_grp->AdvancedSearch->save(); // s_grp
			$this->godown->AdvancedSearch->save(); // godown
			$this->jc_no->AdvancedSearch->save(); // jc_no
			$this->rid_1->AdvancedSearch->save(); // rid_1
			$this->emp_id->AdvancedSearch->save(); // emp_id
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->lot_no->AdvancedSearch->save(); // lot_no
			$this->tmp_lot->AdvancedSearch->save(); // tmp_lot
			$this->process->AdvancedSearch->save(); // process
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->available_quantity->AdvancedSearch->save(); // available_quantity
			$this->avg_wt->AdvancedSearch->save(); // avg_wt
			$this->packing_type->AdvancedSearch->save(); // packing_type
			$this->packets->AdvancedSearch->save(); // packets
			$this->jc_quantity->AdvancedSearch->save(); // jc_quantity
			$this->batch_no->AdvancedSearch->save(); // batch_no
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->godown, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->lot_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tmp_lot, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->godown->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rid_1->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->emp_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->lot_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->tmp_lot->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->available_quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->avg_wt->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packing_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packets->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->batch_no->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->s_grp->AdvancedSearch->unsetSession();
		$this->godown->AdvancedSearch->unsetSession();
		$this->jc_no->AdvancedSearch->unsetSession();
		$this->rid_1->AdvancedSearch->unsetSession();
		$this->emp_id->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->lot_no->AdvancedSearch->unsetSession();
		$this->tmp_lot->AdvancedSearch->unsetSession();
		$this->process->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->available_quantity->AdvancedSearch->unsetSession();
		$this->avg_wt->AdvancedSearch->unsetSession();
		$this->packing_type->AdvancedSearch->unsetSession();
		$this->packets->AdvancedSearch->unsetSession();
		$this->jc_quantity->AdvancedSearch->unsetSession();
		$this->batch_no->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->rid_1->AdvancedSearch->load();
		$this->emp_id->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->tmp_lot->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->available_quantity->AdvancedSearch->load();
		$this->avg_wt->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->jc_quantity->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->grp, $ctrl); // grp
			$this->updateSort($this->s_grp, $ctrl); // s_grp
			$this->updateSort($this->godown, $ctrl); // godown
			$this->updateSort($this->jc_no, $ctrl); // jc_no
			$this->updateSort($this->rid, $ctrl); // rid
			$this->updateSort($this->emp_id, $ctrl); // emp_id
			$this->updateSort($this->quantity, $ctrl); // quantity
			$this->updateSort($this->lot_no, $ctrl); // lot_no
			$this->updateSort($this->tmp_lot, $ctrl); // tmp_lot
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->updateSort($this->jc_quantity, $ctrl); // jc_quantity
			$this->updateSort($this->batch_no, $ctrl); // batch_no
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->grp->setSort("");
				$this->s_grp->setSort("");
				$this->godown->setSort("");
				$this->jc_no->setSort("");
				$this->rid->setSort("");
				$this->emp_id->setSort("");
				$this->quantity->setSort("");
				$this->lot_no->setSort("");
				$this->tmp_lot->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
				$this->jc_quantity->setSort("");
				$this->batch_no->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fmaterial_out_hslistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fmaterial_out_hslistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fmaterial_out_hslist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fmaterial_out_hslistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"material_out_hssrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"material_out_hs\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'material_out_hssrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fmaterial_out_hslistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue(Get("x_s_grp", Get("s_grp", "")));
		if ($this->s_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_grp->AdvancedSearch->setSearchOperator(Get("z_s_grp", ""));

		// godown
		if (!$this->isAddOrEdit())
			$this->godown->AdvancedSearch->setSearchValue(Get("x_godown", Get("godown", "")));
		if ($this->godown->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->godown->AdvancedSearch->setSearchOperator(Get("z_godown", ""));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue(Get("x_jc_no", Get("jc_no", "")));
		if ($this->jc_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_no->AdvancedSearch->setSearchOperator(Get("z_jc_no", ""));

		// rid_1
		if (!$this->isAddOrEdit())
			$this->rid_1->AdvancedSearch->setSearchValue(Get("x_rid_1", Get("rid_1", "")));
		if ($this->rid_1->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rid_1->AdvancedSearch->setSearchOperator(Get("z_rid_1", ""));

		// emp_id
		if (!$this->isAddOrEdit())
			$this->emp_id->AdvancedSearch->setSearchValue(Get("x_emp_id", Get("emp_id", "")));
		if ($this->emp_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->emp_id->AdvancedSearch->setSearchOperator(Get("z_emp_id", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// lot_no
		if (!$this->isAddOrEdit())
			$this->lot_no->AdvancedSearch->setSearchValue(Get("x_lot_no", Get("lot_no", "")));
		if ($this->lot_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->lot_no->AdvancedSearch->setSearchOperator(Get("z_lot_no", ""));

		// tmp_lot
		if (!$this->isAddOrEdit())
			$this->tmp_lot->AdvancedSearch->setSearchValue(Get("x_tmp_lot", Get("tmp_lot", "")));
		if ($this->tmp_lot->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->tmp_lot->AdvancedSearch->setSearchOperator(Get("z_tmp_lot", ""));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue(Get("x_process", Get("process", "")));
		if ($this->process->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process->AdvancedSearch->setSearchOperator(Get("z_process", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// available_quantity
		if (!$this->isAddOrEdit())
			$this->available_quantity->AdvancedSearch->setSearchValue(Get("x_available_quantity", Get("available_quantity", "")));
		if ($this->available_quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->available_quantity->AdvancedSearch->setSearchOperator(Get("z_available_quantity", ""));

		// avg_wt
		if (!$this->isAddOrEdit())
			$this->avg_wt->AdvancedSearch->setSearchValue(Get("x_avg_wt", Get("avg_wt", "")));
		if ($this->avg_wt->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->avg_wt->AdvancedSearch->setSearchOperator(Get("z_avg_wt", ""));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue(Get("x_packing_type", Get("packing_type", "")));
		if ($this->packing_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packing_type->AdvancedSearch->setSearchOperator(Get("z_packing_type", ""));

		// packets
		if (!$this->isAddOrEdit())
			$this->packets->AdvancedSearch->setSearchValue(Get("x_packets", Get("packets", "")));
		if ($this->packets->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packets->AdvancedSearch->setSearchOperator(Get("z_packets", ""));

		// jc_quantity
		if (!$this->isAddOrEdit())
			$this->jc_quantity->AdvancedSearch->setSearchValue(Get("x_jc_quantity", Get("jc_quantity", "")));
		if ($this->jc_quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_quantity->AdvancedSearch->setSearchOperator(Get("z_jc_quantity", ""));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue(Get("x_batch_no", Get("batch_no", "")));
		if ($this->batch_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->batch_no->AdvancedSearch->setSearchOperator(Get("z_batch_no", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->godown->setDbValue($row['godown']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->rid_1->setDbValue($row['rid_1']);
		$this->rid->setDbValue($row['rid']);
		$this->emp_id->setDbValue($row['emp_id']);
		if (array_key_exists('EV__emp_id', $rs->fields)) {
			$this->emp_id->VirtualValue = $rs->fields('EV__emp_id'); // Set up virtual field value
		} else {
			$this->emp_id->VirtualValue = ""; // Clear value
		}
		$this->quantity->setDbValue($row['quantity']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->tmp_lot->setDbValue($row['tmp_lot']);
		$this->process->setDbValue($row['process']);
		$this->process_type->setDbValue($row['process_type']);
		$this->dated->setDbValue($row['dated']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->po->setDbValue($row['po']);
		$this->_print->setDbValue($row['print']);
		$this->remarks->setDbValue($row['remarks']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->product->setDbValue($row['product']);
		$this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
		$this->available_quantity->setDbValue($row['available_quantity']);
		$this->avg_wt->setDbValue($row['avg_wt']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->packets->setDbValue($row['packets']);
		$this->gp_no->setDbValue($row['gp_no']);
		$this->jc_quantity->setDbValue($row['jc_quantity']);
		$this->batch_no->setDbValue($row['batch_no']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['godown'] = NULL;
		$row['jc_no'] = NULL;
		$row['rid_1'] = NULL;
		$row['rid'] = NULL;
		$row['emp_id'] = NULL;
		$row['quantity'] = NULL;
		$row['lot_no'] = NULL;
		$row['tmp_lot'] = NULL;
		$row['process'] = NULL;
		$row['process_type'] = NULL;
		$row['dated'] = NULL;
		$row['status'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['po'] = NULL;
		$row['print'] = NULL;
		$row['remarks'] = NULL;
		$row['issue_to'] = NULL;
		$row['product'] = NULL;
		$row['quantity_avg_act'] = NULL;
		$row['available_quantity'] = NULL;
		$row['avg_wt'] = NULL;
		$row['packing_type'] = NULL;
		$row['packets'] = NULL;
		$row['gp_no'] = NULL;
		$row['jc_quantity'] = NULL;
		$row['batch_no'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->jc_quantity->FormValue == $this->jc_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->jc_quantity->CurrentValue)))
			$this->jc_quantity->CurrentValue = ConvertToFloatString($this->jc_quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// s_grp
		// godown
		// jc_no
		// rid_1
		// rid

		$this->rid->CellCssStyle = "white-space: nowrap;";

		// emp_id
		// quantity
		// lot_no
		// tmp_lot
		// process

		$this->process->CellCssStyle = "white-space: nowrap;";

		// process_type
		$this->process_type->CellCssStyle = "white-space: nowrap;";

		// dated
		$this->dated->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// operator
		// datetime
		// po

		$this->po->CellCssStyle = "white-space: nowrap;";

		// print
		$this->_print->CellCssStyle = "white-space: nowrap;";

		// remarks
		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// issue_to
		$this->issue_to->CellCssStyle = "white-space: nowrap;";

		// product
		$this->product->CellCssStyle = "white-space: nowrap;";

		// quantity_avg_act
		$this->quantity_avg_act->CellCssStyle = "white-space: nowrap;";

		// available_quantity
		$this->available_quantity->CellCssStyle = "white-space: nowrap;";

		// avg_wt
		$this->avg_wt->CellCssStyle = "white-space: nowrap;";

		// packing_type
		$this->packing_type->CellCssStyle = "white-space: nowrap;";

		// packets
		$this->packets->CellCssStyle = "white-space: nowrap;";

		// gp_no
		$this->gp_no->CellCssStyle = "white-space: nowrap;";

		// jc_quantity
		// batch_no
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			if (strval($this->s_grp->CurrentValue) <> "") {
				$this->s_grp->ViewValue = $this->s_grp->optionCaption($this->s_grp->CurrentValue);
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// jc_no
			$curVal = strval($this->jc_no->CurrentValue);
			if ($curVal <> "") {
				$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
				if ($this->jc_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
					}
				}
			} else {
				$this->jc_no->ViewValue = NULL;
			}
			$this->jc_no->ViewCustomAttributes = "";

			// rid
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// emp_id
			if ($this->emp_id->VirtualValue <> "") {
				$this->emp_id->ViewValue = $this->emp_id->VirtualValue;
			} else {
				$this->emp_id->ViewValue = $this->emp_id->CurrentValue;
			$curVal = strval($this->emp_id->CurrentValue);
			if ($curVal <> "") {
				$this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
				if ($this->emp_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->emp_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->emp_id->ViewValue = $this->emp_id->CurrentValue;
					}
				}
			} else {
				$this->emp_id->ViewValue = NULL;
			}
			}
			$this->emp_id->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$curVal = strval($this->lot_no->CurrentValue);
			if ($curVal <> "") {
				$this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
				if ($this->lot_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`lot_no`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->lot_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->lot_no->ViewValue = $this->lot_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
					}
				}
			} else {
				$this->lot_no->ViewValue = NULL;
			}
			$this->lot_no->ViewCustomAttributes = "";

			// tmp_lot
			$this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
			$curVal = strval($this->tmp_lot->CurrentValue);
			if ($curVal <> "") {
				$this->tmp_lot->ViewValue = $this->tmp_lot->lookupCacheOption($curVal);
				if ($this->tmp_lot->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`tmp_lot`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->tmp_lot->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
						$this->tmp_lot->ViewValue = $this->tmp_lot->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
					}
				}
			} else {
				$this->tmp_lot->ViewValue = NULL;
			}
			$this->tmp_lot->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// jc_quantity
			$this->jc_quantity->ViewValue = $this->jc_quantity->CurrentValue;
			$this->jc_quantity->ViewValue = FormatNumber($this->jc_quantity->ViewValue, 2, -2, -2, -2);
			$this->jc_quantity->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
			$this->batch_no->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";
			$this->godown->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->jc_no->CurrentValue)) {
				$this->jc_no->HrefValue = "material_out_hslist.php?x_jc_no=" . $this->jc_no->CurrentValue; // Add prefix/suffix
				$this->jc_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->jc_no->HrefValue = FullUrl($this->jc_no->HrefValue, "href");
			} else {
				$this->jc_no->HrefValue = "";
			}
			$this->jc_no->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "material_out_hslist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// emp_id
			$this->emp_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->emp_id->CurrentValue)) {
				$this->emp_id->HrefValue = "material_out_hslist.php?x_emp_id=" . $this->emp_id->CurrentValue; // Add prefix/suffix
				$this->emp_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->emp_id->HrefValue = FullUrl($this->emp_id->HrefValue, "href");
			} else {
				$this->emp_id->HrefValue = "";
			}
			$this->emp_id->TooltipValue = "";
			if (!$this->isExport())
				$this->emp_id->ViewValue = $this->highlightValue($this->emp_id);

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->lot_no->CurrentValue)) {
				$this->lot_no->HrefValue = "material_out_hslist.php?x_lot_no=" . $this->lot_no->CurrentValue; // Add prefix/suffix
				$this->lot_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->lot_no->HrefValue = FullUrl($this->lot_no->HrefValue, "href");
			} else {
				$this->lot_no->HrefValue = "";
			}
			$this->lot_no->TooltipValue = "";
			if (!$this->isExport())
				$this->lot_no->ViewValue = $this->highlightValue($this->lot_no);

			// tmp_lot
			$this->tmp_lot->LinkCustomAttributes = "";
			$this->tmp_lot->HrefValue = "";
			$this->tmp_lot->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// jc_quantity
			$this->jc_quantity->LinkCustomAttributes = "";
			$this->jc_quantity->HrefValue = "";
			$this->jc_quantity->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = $this->grp->options(TRUE);

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = $this->s_grp->options(TRUE);

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->godown->AdvancedSearch->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->AdvancedSearch->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";

			// emp_id
			$this->emp_id->EditAttrs["class"] = "form-control";
			$this->emp_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->emp_id->AdvancedSearch->SearchValue = HtmlDecode($this->emp_id->AdvancedSearch->SearchValue);
			$this->emp_id->EditValue = HtmlEncode($this->emp_id->AdvancedSearch->SearchValue);
			$this->emp_id->PlaceHolder = RemoveHtml($this->emp_id->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
			$curVal = strval($this->lot_no->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->lot_no->EditValue = $this->lot_no->lookupCacheOption($curVal);
				if ($this->lot_no->EditValue === NULL) { // Lookup from database
					$filterWrk = "`lot_no`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->lot_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->lot_no->EditValue = $this->lot_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->lot_no->EditValue = NULL;
			}
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// tmp_lot
			$this->tmp_lot->EditAttrs["class"] = "form-control";
			$this->tmp_lot->EditCustomAttributes = "";
			$this->tmp_lot->EditValue = HtmlEncode($this->tmp_lot->AdvancedSearch->SearchValue);
			$curVal = strval($this->tmp_lot->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->tmp_lot->EditValue = $this->tmp_lot->lookupCacheOption($curVal);
				if ($this->tmp_lot->EditValue === NULL) { // Lookup from database
					$filterWrk = "`tmp_lot`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->tmp_lot->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 2, -2, -2, -2));
						$this->tmp_lot->EditValue = $this->tmp_lot->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->tmp_lot->EditValue = HtmlEncode($this->tmp_lot->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->tmp_lot->EditValue = NULL;
			}
			$this->tmp_lot->PlaceHolder = RemoveHtml($this->tmp_lot->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// jc_quantity
			$this->jc_quantity->EditAttrs["class"] = "form-control";
			$this->jc_quantity->EditCustomAttributes = "";
			$this->jc_quantity->EditValue = HtmlEncode($this->jc_quantity->AdvancedSearch->SearchValue);
			$this->jc_quantity->PlaceHolder = RemoveHtml($this->jc_quantity->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$this->batch_no->EditValue = HtmlEncode($this->batch_no->AdvancedSearch->SearchValue);
			$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->quantity->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckNumber($this->tmp_lot->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->tmp_lot->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->rid_1->AdvancedSearch->load();
		$this->emp_id->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->tmp_lot->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->available_quantity->AdvancedSearch->load();
		$this->avg_wt->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->jc_quantity->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fmaterial_out_hslist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fmaterial_out_hslist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fmaterial_out_hslist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_material_out_hs\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_material_out_hs',hdr:ew.language.phrase('ExportToEmailText'),f:document.fmaterial_out_hslist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_godown":
					$lookupFilter = function() {
						return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_1":
					$lookupFilter = function() {
						return "`Balance` >0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_type":
					$lookupFilter = function() {
						return "`grp`  =  23 ";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_po":
					$lookupFilter = function() {
						return "`s_grp` = 23";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_godown":
							break;
						case "x_jc_no":
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_rid_1":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_rid":
							break;
						case "x_emp_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_lot_no":
							break;
						case "x_tmp_lot":
							$row[1] = FormatNumber($row[1], 2, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_process":
							break;
						case "x_process_type":
							break;
						case "x_operator":
							break;
						case "x_po":
							$row[2] = FormatNumber($row[2], 3, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_issue_to":
							break;
						case "x_product":
							break;
						case "x_packing_type":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>