<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_out_list extends material_out
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_out';

	// Page object name
	public $PageObjName = "material_out_list";

	// Grid form hidden field names
	public $FormName = "fmaterial_outlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_out)
		if (!isset($GLOBALS["material_out"]) || get_class($GLOBALS["material_out"]) == PROJECT_NAMESPACE . "material_out") {
			$GLOBALS["material_out"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_out"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "material_outadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "material_outdelete.php";
		$this->MultiUpdateUrl = "material_outupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_out');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fmaterial_outlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_out;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_out);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->process->setVisibility();
		$this->process_type->setVisibility();
		$this->issue_to_unit->setVisibility();
		$this->issue_to->setVisibility();
		$this->godown->setVisibility();
		$this->jc_no->setVisibility();
		$this->gp_no->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->product->setVisibility();
		$this->rid_1->Visible = FALSE;
		$this->packing_type->setVisibility();
		$this->rid_2->Visible = FALSE;
		$this->rid_3->Visible = FALSE;
		$this->rid->setVisibility();
		$this->lot_no->setVisibility();
		$this->avg_quantity->Visible = FALSE;
		$this->quantity_avg_act->Visible = FALSE;
		$this->max_qty->Visible = FALSE;
		$this->quantity_sub->setVisibility();
		$this->quantity->setVisibility();
		$this->packets->setVisibility();
		$this->price->setVisibility();
		$this->cart_amount->Visible = FALSE;
		$this->other_amount->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->dated->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->status->setVisibility();
		$this->tmp_lot->Visible = FALSE;
		$this->hsn_code->Visible = FALSE;
		$this->amount->Visible = FALSE;
		$this->tax_amount->Visible = FALSE;
		$this->tax_percent->Visible = FALSE;
		$this->total_amount->setVisibility();
		$this->cart_ref->setVisibility();
		$this->po->Visible = FALSE;
		$this->_print->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->url->Visible = FALSE;
		$this->uploads->setVisibility();
		$this->company_id->Visible = FALSE;
		$this->rid_name->Visible = FALSE;
		$this->godown_po->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->process_type);
		$this->setupLookupOptions($this->issue_to);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid_1);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->rid_2);
		$this->setupLookupOptions($this->rid_3);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export selected records
		if ($this->isExport())
			$this->CurrentFilter = $this->buildExportSelectedFilter();

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fmaterial_outlistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->process->AdvancedSearch->toJson(), ","); // Field process
		$filterList = Concat($filterList, $this->issue_to_unit->AdvancedSearch->toJson(), ","); // Field issue_to_unit
		$filterList = Concat($filterList, $this->issue_to->AdvancedSearch->toJson(), ","); // Field issue_to
		$filterList = Concat($filterList, $this->godown->AdvancedSearch->toJson(), ","); // Field godown
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
		$filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
		$filterList = Concat($filterList, $this->rid_1->AdvancedSearch->toJson(), ","); // Field rid_1
		$filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
		$filterList = Concat($filterList, $this->rid_2->AdvancedSearch->toJson(), ","); // Field rid_2
		$filterList = Concat($filterList, $this->rid_3->AdvancedSearch->toJson(), ","); // Field rid_3
		$filterList = Concat($filterList, $this->rid->AdvancedSearch->toJson(), ","); // Field rid
		$filterList = Concat($filterList, $this->lot_no->AdvancedSearch->toJson(), ","); // Field lot_no
		$filterList = Concat($filterList, $this->avg_quantity->AdvancedSearch->toJson(), ","); // Field avg_quantity
		$filterList = Concat($filterList, $this->max_qty->AdvancedSearch->toJson(), ","); // Field max_qty
		$filterList = Concat($filterList, $this->quantity_sub->AdvancedSearch->toJson(), ","); // Field quantity_sub
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->packets->AdvancedSearch->toJson(), ","); // Field packets
		$filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
		$filterList = Concat($filterList, $this->cart_amount->AdvancedSearch->toJson(), ","); // Field cart_amount
		$filterList = Concat($filterList, $this->other_amount->AdvancedSearch->toJson(), ","); // Field other_amount
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->dated->AdvancedSearch->toJson(), ","); // Field dated
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->hsn_code->AdvancedSearch->toJson(), ","); // Field hsn_code
		$filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
		$filterList = Concat($filterList, $this->tax_amount->AdvancedSearch->toJson(), ","); // Field tax_amount
		$filterList = Concat($filterList, $this->tax_percent->AdvancedSearch->toJson(), ","); // Field tax_percent
		$filterList = Concat($filterList, $this->total_amount->AdvancedSearch->toJson(), ","); // Field total_amount
		$filterList = Concat($filterList, $this->cart_ref->AdvancedSearch->toJson(), ","); // Field cart_ref
		$filterList = Concat($filterList, $this->uploads->AdvancedSearch->toJson(), ","); // Field uploads
		$filterList = Concat($filterList, $this->godown_po->AdvancedSearch->toJson(), ","); // Field godown_po
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fmaterial_outlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field process
		$this->process->AdvancedSearch->SearchValue = @$filter["x_process"];
		$this->process->AdvancedSearch->SearchOperator = @$filter["z_process"];
		$this->process->AdvancedSearch->SearchCondition = @$filter["v_process"];
		$this->process->AdvancedSearch->SearchValue2 = @$filter["y_process"];
		$this->process->AdvancedSearch->SearchOperator2 = @$filter["w_process"];
		$this->process->AdvancedSearch->save();

		// Field issue_to_unit
		$this->issue_to_unit->AdvancedSearch->SearchValue = @$filter["x_issue_to_unit"];
		$this->issue_to_unit->AdvancedSearch->SearchOperator = @$filter["z_issue_to_unit"];
		$this->issue_to_unit->AdvancedSearch->SearchCondition = @$filter["v_issue_to_unit"];
		$this->issue_to_unit->AdvancedSearch->SearchValue2 = @$filter["y_issue_to_unit"];
		$this->issue_to_unit->AdvancedSearch->SearchOperator2 = @$filter["w_issue_to_unit"];
		$this->issue_to_unit->AdvancedSearch->save();

		// Field issue_to
		$this->issue_to->AdvancedSearch->SearchValue = @$filter["x_issue_to"];
		$this->issue_to->AdvancedSearch->SearchOperator = @$filter["z_issue_to"];
		$this->issue_to->AdvancedSearch->SearchCondition = @$filter["v_issue_to"];
		$this->issue_to->AdvancedSearch->SearchValue2 = @$filter["y_issue_to"];
		$this->issue_to->AdvancedSearch->SearchOperator2 = @$filter["w_issue_to"];
		$this->issue_to->AdvancedSearch->save();

		// Field godown
		$this->godown->AdvancedSearch->SearchValue = @$filter["x_godown"];
		$this->godown->AdvancedSearch->SearchOperator = @$filter["z_godown"];
		$this->godown->AdvancedSearch->SearchCondition = @$filter["v_godown"];
		$this->godown->AdvancedSearch->SearchValue2 = @$filter["y_godown"];
		$this->godown->AdvancedSearch->SearchOperator2 = @$filter["w_godown"];
		$this->godown->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field s_grp
		$this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
		$this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
		$this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
		$this->s_grp->AdvancedSearch->save();

		// Field product
		$this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
		$this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
		$this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
		$this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
		$this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
		$this->product->AdvancedSearch->save();

		// Field rid_1
		$this->rid_1->AdvancedSearch->SearchValue = @$filter["x_rid_1"];
		$this->rid_1->AdvancedSearch->SearchOperator = @$filter["z_rid_1"];
		$this->rid_1->AdvancedSearch->SearchCondition = @$filter["v_rid_1"];
		$this->rid_1->AdvancedSearch->SearchValue2 = @$filter["y_rid_1"];
		$this->rid_1->AdvancedSearch->SearchOperator2 = @$filter["w_rid_1"];
		$this->rid_1->AdvancedSearch->save();

		// Field packing_type
		$this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
		$this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
		$this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
		$this->packing_type->AdvancedSearch->save();

		// Field rid_2
		$this->rid_2->AdvancedSearch->SearchValue = @$filter["x_rid_2"];
		$this->rid_2->AdvancedSearch->SearchOperator = @$filter["z_rid_2"];
		$this->rid_2->AdvancedSearch->SearchCondition = @$filter["v_rid_2"];
		$this->rid_2->AdvancedSearch->SearchValue2 = @$filter["y_rid_2"];
		$this->rid_2->AdvancedSearch->SearchOperator2 = @$filter["w_rid_2"];
		$this->rid_2->AdvancedSearch->save();

		// Field rid_3
		$this->rid_3->AdvancedSearch->SearchValue = @$filter["x_rid_3"];
		$this->rid_3->AdvancedSearch->SearchOperator = @$filter["z_rid_3"];
		$this->rid_3->AdvancedSearch->SearchCondition = @$filter["v_rid_3"];
		$this->rid_3->AdvancedSearch->SearchValue2 = @$filter["y_rid_3"];
		$this->rid_3->AdvancedSearch->SearchOperator2 = @$filter["w_rid_3"];
		$this->rid_3->AdvancedSearch->save();

		// Field rid
		$this->rid->AdvancedSearch->SearchValue = @$filter["x_rid"];
		$this->rid->AdvancedSearch->SearchOperator = @$filter["z_rid"];
		$this->rid->AdvancedSearch->SearchCondition = @$filter["v_rid"];
		$this->rid->AdvancedSearch->SearchValue2 = @$filter["y_rid"];
		$this->rid->AdvancedSearch->SearchOperator2 = @$filter["w_rid"];
		$this->rid->AdvancedSearch->save();

		// Field lot_no
		$this->lot_no->AdvancedSearch->SearchValue = @$filter["x_lot_no"];
		$this->lot_no->AdvancedSearch->SearchOperator = @$filter["z_lot_no"];
		$this->lot_no->AdvancedSearch->SearchCondition = @$filter["v_lot_no"];
		$this->lot_no->AdvancedSearch->SearchValue2 = @$filter["y_lot_no"];
		$this->lot_no->AdvancedSearch->SearchOperator2 = @$filter["w_lot_no"];
		$this->lot_no->AdvancedSearch->save();

		// Field avg_quantity
		$this->avg_quantity->AdvancedSearch->SearchValue = @$filter["x_avg_quantity"];
		$this->avg_quantity->AdvancedSearch->SearchOperator = @$filter["z_avg_quantity"];
		$this->avg_quantity->AdvancedSearch->SearchCondition = @$filter["v_avg_quantity"];
		$this->avg_quantity->AdvancedSearch->SearchValue2 = @$filter["y_avg_quantity"];
		$this->avg_quantity->AdvancedSearch->SearchOperator2 = @$filter["w_avg_quantity"];
		$this->avg_quantity->AdvancedSearch->save();

		// Field max_qty
		$this->max_qty->AdvancedSearch->SearchValue = @$filter["x_max_qty"];
		$this->max_qty->AdvancedSearch->SearchOperator = @$filter["z_max_qty"];
		$this->max_qty->AdvancedSearch->SearchCondition = @$filter["v_max_qty"];
		$this->max_qty->AdvancedSearch->SearchValue2 = @$filter["y_max_qty"];
		$this->max_qty->AdvancedSearch->SearchOperator2 = @$filter["w_max_qty"];
		$this->max_qty->AdvancedSearch->save();

		// Field quantity_sub
		$this->quantity_sub->AdvancedSearch->SearchValue = @$filter["x_quantity_sub"];
		$this->quantity_sub->AdvancedSearch->SearchOperator = @$filter["z_quantity_sub"];
		$this->quantity_sub->AdvancedSearch->SearchCondition = @$filter["v_quantity_sub"];
		$this->quantity_sub->AdvancedSearch->SearchValue2 = @$filter["y_quantity_sub"];
		$this->quantity_sub->AdvancedSearch->SearchOperator2 = @$filter["w_quantity_sub"];
		$this->quantity_sub->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field packets
		$this->packets->AdvancedSearch->SearchValue = @$filter["x_packets"];
		$this->packets->AdvancedSearch->SearchOperator = @$filter["z_packets"];
		$this->packets->AdvancedSearch->SearchCondition = @$filter["v_packets"];
		$this->packets->AdvancedSearch->SearchValue2 = @$filter["y_packets"];
		$this->packets->AdvancedSearch->SearchOperator2 = @$filter["w_packets"];
		$this->packets->AdvancedSearch->save();

		// Field price
		$this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
		$this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
		$this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
		$this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
		$this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
		$this->price->AdvancedSearch->save();

		// Field cart_amount
		$this->cart_amount->AdvancedSearch->SearchValue = @$filter["x_cart_amount"];
		$this->cart_amount->AdvancedSearch->SearchOperator = @$filter["z_cart_amount"];
		$this->cart_amount->AdvancedSearch->SearchCondition = @$filter["v_cart_amount"];
		$this->cart_amount->AdvancedSearch->SearchValue2 = @$filter["y_cart_amount"];
		$this->cart_amount->AdvancedSearch->SearchOperator2 = @$filter["w_cart_amount"];
		$this->cart_amount->AdvancedSearch->save();

		// Field other_amount
		$this->other_amount->AdvancedSearch->SearchValue = @$filter["x_other_amount"];
		$this->other_amount->AdvancedSearch->SearchOperator = @$filter["z_other_amount"];
		$this->other_amount->AdvancedSearch->SearchCondition = @$filter["v_other_amount"];
		$this->other_amount->AdvancedSearch->SearchValue2 = @$filter["y_other_amount"];
		$this->other_amount->AdvancedSearch->SearchOperator2 = @$filter["w_other_amount"];
		$this->other_amount->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field dated
		$this->dated->AdvancedSearch->SearchValue = @$filter["x_dated"];
		$this->dated->AdvancedSearch->SearchOperator = @$filter["z_dated"];
		$this->dated->AdvancedSearch->SearchCondition = @$filter["v_dated"];
		$this->dated->AdvancedSearch->SearchValue2 = @$filter["y_dated"];
		$this->dated->AdvancedSearch->SearchOperator2 = @$filter["w_dated"];
		$this->dated->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field hsn_code
		$this->hsn_code->AdvancedSearch->SearchValue = @$filter["x_hsn_code"];
		$this->hsn_code->AdvancedSearch->SearchOperator = @$filter["z_hsn_code"];
		$this->hsn_code->AdvancedSearch->SearchCondition = @$filter["v_hsn_code"];
		$this->hsn_code->AdvancedSearch->SearchValue2 = @$filter["y_hsn_code"];
		$this->hsn_code->AdvancedSearch->SearchOperator2 = @$filter["w_hsn_code"];
		$this->hsn_code->AdvancedSearch->save();

		// Field amount
		$this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
		$this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
		$this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
		$this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
		$this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
		$this->amount->AdvancedSearch->save();

		// Field tax_amount
		$this->tax_amount->AdvancedSearch->SearchValue = @$filter["x_tax_amount"];
		$this->tax_amount->AdvancedSearch->SearchOperator = @$filter["z_tax_amount"];
		$this->tax_amount->AdvancedSearch->SearchCondition = @$filter["v_tax_amount"];
		$this->tax_amount->AdvancedSearch->SearchValue2 = @$filter["y_tax_amount"];
		$this->tax_amount->AdvancedSearch->SearchOperator2 = @$filter["w_tax_amount"];
		$this->tax_amount->AdvancedSearch->save();

		// Field tax_percent
		$this->tax_percent->AdvancedSearch->SearchValue = @$filter["x_tax_percent"];
		$this->tax_percent->AdvancedSearch->SearchOperator = @$filter["z_tax_percent"];
		$this->tax_percent->AdvancedSearch->SearchCondition = @$filter["v_tax_percent"];
		$this->tax_percent->AdvancedSearch->SearchValue2 = @$filter["y_tax_percent"];
		$this->tax_percent->AdvancedSearch->SearchOperator2 = @$filter["w_tax_percent"];
		$this->tax_percent->AdvancedSearch->save();

		// Field total_amount
		$this->total_amount->AdvancedSearch->SearchValue = @$filter["x_total_amount"];
		$this->total_amount->AdvancedSearch->SearchOperator = @$filter["z_total_amount"];
		$this->total_amount->AdvancedSearch->SearchCondition = @$filter["v_total_amount"];
		$this->total_amount->AdvancedSearch->SearchValue2 = @$filter["y_total_amount"];
		$this->total_amount->AdvancedSearch->SearchOperator2 = @$filter["w_total_amount"];
		$this->total_amount->AdvancedSearch->save();

		// Field cart_ref
		$this->cart_ref->AdvancedSearch->SearchValue = @$filter["x_cart_ref"];
		$this->cart_ref->AdvancedSearch->SearchOperator = @$filter["z_cart_ref"];
		$this->cart_ref->AdvancedSearch->SearchCondition = @$filter["v_cart_ref"];
		$this->cart_ref->AdvancedSearch->SearchValue2 = @$filter["y_cart_ref"];
		$this->cart_ref->AdvancedSearch->SearchOperator2 = @$filter["w_cart_ref"];
		$this->cart_ref->AdvancedSearch->save();

		// Field uploads
		$this->uploads->AdvancedSearch->SearchValue = @$filter["x_uploads"];
		$this->uploads->AdvancedSearch->SearchOperator = @$filter["z_uploads"];
		$this->uploads->AdvancedSearch->SearchCondition = @$filter["v_uploads"];
		$this->uploads->AdvancedSearch->SearchValue2 = @$filter["y_uploads"];
		$this->uploads->AdvancedSearch->SearchOperator2 = @$filter["w_uploads"];
		$this->uploads->AdvancedSearch->save();

		// Field godown_po
		$this->godown_po->AdvancedSearch->SearchValue = @$filter["x_godown_po"];
		$this->godown_po->AdvancedSearch->SearchOperator = @$filter["z_godown_po"];
		$this->godown_po->AdvancedSearch->SearchCondition = @$filter["v_godown_po"];
		$this->godown_po->AdvancedSearch->SearchValue2 = @$filter["y_godown_po"];
		$this->godown_po->AdvancedSearch->SearchOperator2 = @$filter["w_godown_po"];
		$this->godown_po->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->process, $default, FALSE); // process
		$this->buildSearchSql($where, $this->issue_to_unit, $default, FALSE); // issue_to_unit
		$this->buildSearchSql($where, $this->issue_to, $default, FALSE); // issue_to
		$this->buildSearchSql($where, $this->godown, $default, FALSE); // godown
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->s_grp, $default, FALSE); // s_grp
		$this->buildSearchSql($where, $this->product, $default, FALSE); // product
		$this->buildSearchSql($where, $this->rid_1, $default, FALSE); // rid_1
		$this->buildSearchSql($where, $this->packing_type, $default, FALSE); // packing_type
		$this->buildSearchSql($where, $this->rid_2, $default, FALSE); // rid_2
		$this->buildSearchSql($where, $this->rid_3, $default, FALSE); // rid_3
		$this->buildSearchSql($where, $this->rid, $default, FALSE); // rid
		$this->buildSearchSql($where, $this->lot_no, $default, FALSE); // lot_no
		$this->buildSearchSql($where, $this->avg_quantity, $default, FALSE); // avg_quantity
		$this->buildSearchSql($where, $this->max_qty, $default, FALSE); // max_qty
		$this->buildSearchSql($where, $this->quantity_sub, $default, FALSE); // quantity_sub
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->packets, $default, FALSE); // packets
		$this->buildSearchSql($where, $this->price, $default, FALSE); // price
		$this->buildSearchSql($where, $this->cart_amount, $default, FALSE); // cart_amount
		$this->buildSearchSql($where, $this->other_amount, $default, FALSE); // other_amount
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->dated, $default, FALSE); // dated
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->status, $default, FALSE); // status
		$this->buildSearchSql($where, $this->hsn_code, $default, FALSE); // hsn_code
		$this->buildSearchSql($where, $this->amount, $default, FALSE); // amount
		$this->buildSearchSql($where, $this->tax_amount, $default, FALSE); // tax_amount
		$this->buildSearchSql($where, $this->tax_percent, $default, FALSE); // tax_percent
		$this->buildSearchSql($where, $this->total_amount, $default, FALSE); // total_amount
		$this->buildSearchSql($where, $this->cart_ref, $default, FALSE); // cart_ref
		$this->buildSearchSql($where, $this->uploads, $default, FALSE); // uploads
		$this->buildSearchSql($where, $this->godown_po, $default, FALSE); // godown_po

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->process->AdvancedSearch->save(); // process
			$this->issue_to_unit->AdvancedSearch->save(); // issue_to_unit
			$this->issue_to->AdvancedSearch->save(); // issue_to
			$this->godown->AdvancedSearch->save(); // godown
			$this->grp->AdvancedSearch->save(); // grp
			$this->s_grp->AdvancedSearch->save(); // s_grp
			$this->product->AdvancedSearch->save(); // product
			$this->rid_1->AdvancedSearch->save(); // rid_1
			$this->packing_type->AdvancedSearch->save(); // packing_type
			$this->rid_2->AdvancedSearch->save(); // rid_2
			$this->rid_3->AdvancedSearch->save(); // rid_3
			$this->rid->AdvancedSearch->save(); // rid
			$this->lot_no->AdvancedSearch->save(); // lot_no
			$this->avg_quantity->AdvancedSearch->save(); // avg_quantity
			$this->max_qty->AdvancedSearch->save(); // max_qty
			$this->quantity_sub->AdvancedSearch->save(); // quantity_sub
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->packets->AdvancedSearch->save(); // packets
			$this->price->AdvancedSearch->save(); // price
			$this->cart_amount->AdvancedSearch->save(); // cart_amount
			$this->other_amount->AdvancedSearch->save(); // other_amount
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->dated->AdvancedSearch->save(); // dated
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->status->AdvancedSearch->save(); // status
			$this->hsn_code->AdvancedSearch->save(); // hsn_code
			$this->amount->AdvancedSearch->save(); // amount
			$this->tax_amount->AdvancedSearch->save(); // tax_amount
			$this->tax_percent->AdvancedSearch->save(); // tax_percent
			$this->total_amount->AdvancedSearch->save(); // total_amount
			$this->cart_ref->AdvancedSearch->save(); // cart_ref
			$this->uploads->AdvancedSearch->save(); // uploads
			$this->godown_po->AdvancedSearch->save(); // godown_po
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->process, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->process_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->issue_to, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->godown, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->gp_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->rid_1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->packing_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->rid_2, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->rid_3, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->rid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->lot_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->avg_quantity, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->quantity_avg_act, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->max_qty, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->quantity_sub, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->quantity, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->packets, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->price, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cart_amount, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->other_amount, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->dated, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tmp_lot, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->hsn_code, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->amount, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tax_amount, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tax_percent, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->total_amount, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cart_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_print, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_barcode, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->url, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->uploads, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->issue_to_unit->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->issue_to->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->godown->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rid_1->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packing_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rid_2->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rid_3->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->lot_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->avg_quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->max_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity_sub->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packets->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->price->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cart_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->other_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->dated->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->hsn_code->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->tax_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->tax_percent->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->total_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cart_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->uploads->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->godown_po->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->process->AdvancedSearch->unsetSession();
		$this->issue_to_unit->AdvancedSearch->unsetSession();
		$this->issue_to->AdvancedSearch->unsetSession();
		$this->godown->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->s_grp->AdvancedSearch->unsetSession();
		$this->product->AdvancedSearch->unsetSession();
		$this->rid_1->AdvancedSearch->unsetSession();
		$this->packing_type->AdvancedSearch->unsetSession();
		$this->rid_2->AdvancedSearch->unsetSession();
		$this->rid_3->AdvancedSearch->unsetSession();
		$this->rid->AdvancedSearch->unsetSession();
		$this->lot_no->AdvancedSearch->unsetSession();
		$this->avg_quantity->AdvancedSearch->unsetSession();
		$this->max_qty->AdvancedSearch->unsetSession();
		$this->quantity_sub->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->packets->AdvancedSearch->unsetSession();
		$this->price->AdvancedSearch->unsetSession();
		$this->cart_amount->AdvancedSearch->unsetSession();
		$this->other_amount->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->dated->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->hsn_code->AdvancedSearch->unsetSession();
		$this->amount->AdvancedSearch->unsetSession();
		$this->tax_amount->AdvancedSearch->unsetSession();
		$this->tax_percent->AdvancedSearch->unsetSession();
		$this->total_amount->AdvancedSearch->unsetSession();
		$this->cart_ref->AdvancedSearch->unsetSession();
		$this->uploads->AdvancedSearch->unsetSession();
		$this->godown_po->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->issue_to_unit->AdvancedSearch->load();
		$this->issue_to->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->rid_1->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->rid_2->AdvancedSearch->load();
		$this->rid_3->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->avg_quantity->AdvancedSearch->load();
		$this->max_qty->AdvancedSearch->load();
		$this->quantity_sub->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->cart_amount->AdvancedSearch->load();
		$this->other_amount->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->dated->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->hsn_code->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->tax_amount->AdvancedSearch->load();
		$this->tax_percent->AdvancedSearch->load();
		$this->total_amount->AdvancedSearch->load();
		$this->cart_ref->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
		$this->godown_po->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id); // id
			$this->updateSort($this->process); // process
			$this->updateSort($this->process_type); // process_type
			$this->updateSort($this->issue_to_unit); // issue_to_unit
			$this->updateSort($this->issue_to); // issue_to
			$this->updateSort($this->godown); // godown
			$this->updateSort($this->jc_no); // jc_no
			$this->updateSort($this->product); // product
			$this->updateSort($this->packing_type); // packing_type
			$this->updateSort($this->rid); // rid
			$this->updateSort($this->lot_no); // lot_no
			$this->updateSort($this->quantity_sub); // quantity_sub
			$this->updateSort($this->quantity); // quantity
			$this->updateSort($this->packets); // packets
			$this->updateSort($this->price); // price
			$this->updateSort($this->dated); // dated
			$this->updateSort($this->status); // status
			$this->updateSort($this->total_amount); // total_amount
			$this->updateSort($this->cart_ref); // cart_ref
			$this->updateSort($this->uploads); // uploads
			$this->updateSort($this->godown_po); // godown_po
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->process->setSort("");
				$this->process_type->setSort("");
				$this->issue_to_unit->setSort("");
				$this->issue_to->setSort("");
				$this->godown->setSort("");
				$this->jc_no->setSort("");
				$this->product->setSort("");
				$this->packing_type->setSort("");
				$this->rid->setSort("");
				$this->lot_no->setSort("");
				$this->quantity_sub->setSort("");
				$this->quantity->setSort("");
				$this->packets->setSort("");
				$this->price->setSort("");
				$this->dated->setSort("");
				$this->status->setSort("");
				$this->total_amount->setSort("");
				$this->cart_ref->setSort("");
				$this->uploads->setSort("");
				$this->godown_po->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = TRUE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fmaterial_outlistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fmaterial_outlistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fmaterial_outlist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fmaterial_outlistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"material_outsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fmaterial_outlistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue(Get("x_process", Get("process", "")));
		if ($this->process->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process->AdvancedSearch->setSearchOperator(Get("z_process", ""));

		// issue_to_unit
		if (!$this->isAddOrEdit())
			$this->issue_to_unit->AdvancedSearch->setSearchValue(Get("x_issue_to_unit", Get("issue_to_unit", "")));
		if ($this->issue_to_unit->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->issue_to_unit->AdvancedSearch->setSearchOperator(Get("z_issue_to_unit", ""));

		// issue_to
		if (!$this->isAddOrEdit())
			$this->issue_to->AdvancedSearch->setSearchValue(Get("x_issue_to", Get("issue_to", "")));
		if ($this->issue_to->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->issue_to->AdvancedSearch->setSearchOperator(Get("z_issue_to", ""));

		// godown
		if (!$this->isAddOrEdit())
			$this->godown->AdvancedSearch->setSearchValue(Get("x_godown", Get("godown", "")));
		if ($this->godown->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->godown->AdvancedSearch->setSearchOperator(Get("z_godown", ""));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue(Get("x_s_grp", Get("s_grp", "")));
		if ($this->s_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_grp->AdvancedSearch->setSearchOperator(Get("z_s_grp", ""));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue(Get("x_product", Get("product", "")));
		if ($this->product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product->AdvancedSearch->setSearchOperator(Get("z_product", ""));

		// rid_1
		if (!$this->isAddOrEdit())
			$this->rid_1->AdvancedSearch->setSearchValue(Get("x_rid_1", Get("rid_1", "")));
		if ($this->rid_1->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rid_1->AdvancedSearch->setSearchOperator(Get("z_rid_1", ""));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue(Get("x_packing_type", Get("packing_type", "")));
		if ($this->packing_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packing_type->AdvancedSearch->setSearchOperator(Get("z_packing_type", ""));

		// rid_2
		if (!$this->isAddOrEdit())
			$this->rid_2->AdvancedSearch->setSearchValue(Get("x_rid_2", Get("rid_2", "")));
		if ($this->rid_2->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rid_2->AdvancedSearch->setSearchOperator(Get("z_rid_2", ""));

		// rid_3
		if (!$this->isAddOrEdit())
			$this->rid_3->AdvancedSearch->setSearchValue(Get("x_rid_3", Get("rid_3", "")));
		if ($this->rid_3->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rid_3->AdvancedSearch->setSearchOperator(Get("z_rid_3", ""));

		// rid
		if (!$this->isAddOrEdit())
			$this->rid->AdvancedSearch->setSearchValue(Get("x_rid", Get("rid", "")));
		if ($this->rid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rid->AdvancedSearch->setSearchOperator(Get("z_rid", ""));

		// lot_no
		if (!$this->isAddOrEdit())
			$this->lot_no->AdvancedSearch->setSearchValue(Get("x_lot_no", Get("lot_no", "")));
		if ($this->lot_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->lot_no->AdvancedSearch->setSearchOperator(Get("z_lot_no", ""));

		// avg_quantity
		if (!$this->isAddOrEdit())
			$this->avg_quantity->AdvancedSearch->setSearchValue(Get("x_avg_quantity", Get("avg_quantity", "")));
		if ($this->avg_quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->avg_quantity->AdvancedSearch->setSearchOperator(Get("z_avg_quantity", ""));

		// max_qty
		if (!$this->isAddOrEdit())
			$this->max_qty->AdvancedSearch->setSearchValue(Get("x_max_qty", Get("max_qty", "")));
		if ($this->max_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->max_qty->AdvancedSearch->setSearchOperator(Get("z_max_qty", ""));

		// quantity_sub
		if (!$this->isAddOrEdit())
			$this->quantity_sub->AdvancedSearch->setSearchValue(Get("x_quantity_sub", Get("quantity_sub", "")));
		if ($this->quantity_sub->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity_sub->AdvancedSearch->setSearchOperator(Get("z_quantity_sub", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// packets
		if (!$this->isAddOrEdit())
			$this->packets->AdvancedSearch->setSearchValue(Get("x_packets", Get("packets", "")));
		if ($this->packets->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packets->AdvancedSearch->setSearchOperator(Get("z_packets", ""));

		// price
		if (!$this->isAddOrEdit())
			$this->price->AdvancedSearch->setSearchValue(Get("x_price", Get("price", "")));
		if ($this->price->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->price->AdvancedSearch->setSearchOperator(Get("z_price", ""));

		// cart_amount
		if (!$this->isAddOrEdit())
			$this->cart_amount->AdvancedSearch->setSearchValue(Get("x_cart_amount", Get("cart_amount", "")));
		if ($this->cart_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cart_amount->AdvancedSearch->setSearchOperator(Get("z_cart_amount", ""));

		// other_amount
		if (!$this->isAddOrEdit())
			$this->other_amount->AdvancedSearch->setSearchValue(Get("x_other_amount", Get("other_amount", "")));
		if ($this->other_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->other_amount->AdvancedSearch->setSearchOperator(Get("z_other_amount", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// dated
		if (!$this->isAddOrEdit())
			$this->dated->AdvancedSearch->setSearchValue(Get("x_dated", Get("dated", "")));
		if ($this->dated->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->dated->AdvancedSearch->setSearchOperator(Get("z_dated", ""));
		$this->dated->AdvancedSearch->setSearchCondition(Get("v_dated", ""));
		$this->dated->AdvancedSearch->setSearchValue2(Get("y_dated", ""));
		if ($this->dated->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->dated->AdvancedSearch->setSearchOperator2(Get("w_dated", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));

		// hsn_code
		if (!$this->isAddOrEdit())
			$this->hsn_code->AdvancedSearch->setSearchValue(Get("x_hsn_code", Get("hsn_code", "")));
		if ($this->hsn_code->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->hsn_code->AdvancedSearch->setSearchOperator(Get("z_hsn_code", ""));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue(Get("x_amount", Get("amount", "")));
		if ($this->amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->amount->AdvancedSearch->setSearchOperator(Get("z_amount", ""));

		// tax_amount
		if (!$this->isAddOrEdit())
			$this->tax_amount->AdvancedSearch->setSearchValue(Get("x_tax_amount", Get("tax_amount", "")));
		if ($this->tax_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->tax_amount->AdvancedSearch->setSearchOperator(Get("z_tax_amount", ""));

		// tax_percent
		if (!$this->isAddOrEdit())
			$this->tax_percent->AdvancedSearch->setSearchValue(Get("x_tax_percent", Get("tax_percent", "")));
		if ($this->tax_percent->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->tax_percent->AdvancedSearch->setSearchOperator(Get("z_tax_percent", ""));

		// total_amount
		if (!$this->isAddOrEdit())
			$this->total_amount->AdvancedSearch->setSearchValue(Get("x_total_amount", Get("total_amount", "")));
		if ($this->total_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->total_amount->AdvancedSearch->setSearchOperator(Get("z_total_amount", ""));

		// cart_ref
		if (!$this->isAddOrEdit())
			$this->cart_ref->AdvancedSearch->setSearchValue(Get("x_cart_ref", Get("cart_ref", "")));
		if ($this->cart_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cart_ref->AdvancedSearch->setSearchOperator(Get("z_cart_ref", ""));

		// uploads
		if (!$this->isAddOrEdit())
			$this->uploads->AdvancedSearch->setSearchValue(Get("x_uploads", Get("uploads", "")));
		if ($this->uploads->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->uploads->AdvancedSearch->setSearchOperator(Get("z_uploads", ""));

		// godown_po
		if (!$this->isAddOrEdit())
			$this->godown_po->AdvancedSearch->setSearchValue(Get("x_godown_po", Get("godown_po", "")));
		if ($this->godown_po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->godown_po->AdvancedSearch->setSearchOperator(Get("z_godown_po", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->process->setDbValue($row['process']);
		$this->process_type->setDbValue($row['process_type']);
		if (array_key_exists('EV__process_type', $rs->fields)) {
			$this->process_type->VirtualValue = $rs->fields('EV__process_type'); // Set up virtual field value
		} else {
			$this->process_type->VirtualValue = ""; // Clear value
		}
		$this->issue_to_unit->setDbValue($row['issue_to_unit']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->godown->setDbValue($row['godown']);
		if (array_key_exists('EV__godown', $rs->fields)) {
			$this->godown->VirtualValue = $rs->fields('EV__godown'); // Set up virtual field value
		} else {
			$this->godown->VirtualValue = ""; // Clear value
		}
		$this->jc_no->setDbValue($row['jc_no']);
		$this->gp_no->setDbValue($row['gp_no']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		if (array_key_exists('EV__s_grp', $rs->fields)) {
			$this->s_grp->VirtualValue = $rs->fields('EV__s_grp'); // Set up virtual field value
		} else {
			$this->s_grp->VirtualValue = ""; // Clear value
		}
		$this->product->setDbValue($row['product']);
		if (array_key_exists('EV__product', $rs->fields)) {
			$this->product->VirtualValue = $rs->fields('EV__product'); // Set up virtual field value
		} else {
			$this->product->VirtualValue = ""; // Clear value
		}
		$this->rid_1->setDbValue($row['rid_1']);
		if (array_key_exists('EV__rid_1', $rs->fields)) {
			$this->rid_1->VirtualValue = $rs->fields('EV__rid_1'); // Set up virtual field value
		} else {
			$this->rid_1->VirtualValue = ""; // Clear value
		}
		$this->packing_type->setDbValue($row['packing_type']);
		if (array_key_exists('EV__packing_type', $rs->fields)) {
			$this->packing_type->VirtualValue = $rs->fields('EV__packing_type'); // Set up virtual field value
		} else {
			$this->packing_type->VirtualValue = ""; // Clear value
		}
		$this->rid_2->setDbValue($row['rid_2']);
		$this->rid_3->setDbValue($row['rid_3']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->lot_no->setDbValue($row['lot_no']);
		$this->avg_quantity->setDbValue($row['avg_quantity']);
		$this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
		$this->max_qty->setDbValue($row['max_qty']);
		$this->quantity_sub->setDbValue($row['quantity_sub']);
		$this->quantity->setDbValue($row['quantity']);
		$this->packets->setDbValue($row['packets']);
		$this->price->setDbValue($row['price']);
		$this->cart_amount->setDbValue($row['cart_amount']);
		$this->other_amount->setDbValue($row['other_amount']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->dated->setDbValue($row['dated']);
		$this->remarks->setDbValue($row['remarks']);
		$this->status->setDbValue($row['status']);
		$this->tmp_lot->setDbValue($row['tmp_lot']);
		$this->hsn_code->setDbValue($row['hsn_code']);
		$this->amount->setDbValue($row['amount']);
		$this->tax_amount->setDbValue($row['tax_amount']);
		$this->tax_percent->setDbValue($row['tax_percent']);
		$this->total_amount->setDbValue($row['total_amount']);
		$this->cart_ref->setDbValue($row['cart_ref']);
		$this->po->setDbValue($row['po']);
		$this->_print->setDbValue($row['print']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->url->setDbValue($row['url']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->company_id->setDbValue($row['company_id']);
		$this->rid_name->setDbValue($row['rid_name']);
		$this->godown_po->setDbValue($row['godown_po']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['process'] = NULL;
		$row['process_type'] = NULL;
		$row['issue_to_unit'] = NULL;
		$row['issue_to'] = NULL;
		$row['godown'] = NULL;
		$row['jc_no'] = NULL;
		$row['gp_no'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid_1'] = NULL;
		$row['packing_type'] = NULL;
		$row['rid_2'] = NULL;
		$row['rid_3'] = NULL;
		$row['rid'] = NULL;
		$row['lot_no'] = NULL;
		$row['avg_quantity'] = NULL;
		$row['quantity_avg_act'] = NULL;
		$row['max_qty'] = NULL;
		$row['quantity_sub'] = NULL;
		$row['quantity'] = NULL;
		$row['packets'] = NULL;
		$row['price'] = NULL;
		$row['cart_amount'] = NULL;
		$row['other_amount'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['dated'] = NULL;
		$row['remarks'] = NULL;
		$row['status'] = NULL;
		$row['tmp_lot'] = NULL;
		$row['hsn_code'] = NULL;
		$row['amount'] = NULL;
		$row['tax_amount'] = NULL;
		$row['tax_percent'] = NULL;
		$row['total_amount'] = NULL;
		$row['cart_ref'] = NULL;
		$row['po'] = NULL;
		$row['print'] = NULL;
		$row['barcode'] = NULL;
		$row['url'] = NULL;
		$row['uploads'] = NULL;
		$row['company_id'] = NULL;
		$row['rid_name'] = NULL;
		$row['godown_po'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->quantity_sub->FormValue == $this->quantity_sub->CurrentValue && is_numeric(ConvertToFloatString($this->quantity_sub->CurrentValue)))
			$this->quantity_sub->CurrentValue = ConvertToFloatString($this->quantity_sub->CurrentValue);

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packets->FormValue == $this->packets->CurrentValue && is_numeric(ConvertToFloatString($this->packets->CurrentValue)))
			$this->packets->CurrentValue = ConvertToFloatString($this->packets->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->total_amount->FormValue == $this->total_amount->CurrentValue && is_numeric(ConvertToFloatString($this->total_amount->CurrentValue)))
			$this->total_amount->CurrentValue = ConvertToFloatString($this->total_amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id

		$this->id->CellCssStyle = "white-space: nowrap;";

		// process
		$this->process->CellCssStyle = "white-space: nowrap;";

		// process_type
		$this->process_type->CellCssStyle = "white-space: nowrap;";

		// issue_to_unit
		// issue_to
		// godown
		// jc_no

		$this->jc_no->CellCssStyle = "white-space: nowrap;";

		// gp_no
		$this->gp_no->CellCssStyle = "white-space: nowrap;";

		// grp
		// s_grp
		// product
		// rid_1

		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// packing_type
		// rid_2
		// rid_3
		// rid
		// lot_no
		// avg_quantity
		// quantity_avg_act

		$this->quantity_avg_act->CellCssStyle = "white-space: nowrap;";

		// max_qty
		// quantity_sub
		// quantity
		// packets
		// price
		// cart_amount
		// other_amount
		// operator
		// datetime
		// dated
		// remarks
		// status
		// tmp_lot

		$this->tmp_lot->CellCssStyle = "white-space: nowrap;";

		// hsn_code
		$this->hsn_code->CellCssStyle = "white-space: nowrap;";

		// amount
		$this->amount->CellCssStyle = "white-space: nowrap;";

		// tax_amount
		$this->tax_amount->CellCssStyle = "white-space: nowrap;";

		// tax_percent
		$this->tax_percent->CellCssStyle = "white-space: nowrap;";

		// total_amount
		// cart_ref

		$this->cart_ref->CellCssStyle = "white-space: nowrap;";

		// po
		$this->po->CellCssStyle = "white-space: nowrap;";

		// print
		$this->_print->CellCssStyle = "white-space: nowrap;";

		// barcode
		$this->_barcode->CellCssStyle = "white-space: nowrap;";

		// url
		$this->url->CellCssStyle = "white-space: nowrap;";

		// uploads
		// company_id

		$this->company_id->CellCssStyle = "white-space: nowrap;";

		// rid_name
		$this->rid_name->CellCssStyle = "white-space: nowrap;";

		// godown_po
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
			if (is_numeric($this->packets->CurrentValue))
				$this->packets->Total += $this->packets->CurrentValue; // Accumulate total
			if (is_numeric($this->total_amount->CurrentValue))
				$this->total_amount->Total += $this->total_amount->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_type
			if ($this->process_type->VirtualValue <> "") {
				$this->process_type->ViewValue = $this->process_type->VirtualValue;
			} else {
			$curVal = strval($this->process_type->CurrentValue);
			if ($curVal <> "") {
				$this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
				if ($this->process_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process_type->ViewValue = $this->process_type->CurrentValue;
					}
				}
			} else {
				$this->process_type->ViewValue = NULL;
			}
			}
			$this->process_type->ViewCustomAttributes = "";

			// issue_to_unit
			$this->issue_to_unit->ViewValue = $this->issue_to_unit->CurrentValue;
			$this->issue_to_unit->ViewValue = FormatNumber($this->issue_to_unit->ViewValue, 0, -2, -2, -2);
			$this->issue_to_unit->ViewCustomAttributes = "";

			// issue_to
			$curVal = strval($this->issue_to->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
				if ($this->issue_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0 and `category` != 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
					}
				}
			} else {
				$this->issue_to->ViewValue = NULL;
			}
			$this->issue_to->ViewCustomAttributes = "";

			// godown
			if ($this->godown->VirtualValue <> "") {
				$this->godown->ViewValue = $this->godown->VirtualValue;
			} else {
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			}
			$this->godown->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			if ($this->s_grp->VirtualValue <> "") {
				$this->s_grp->ViewValue = $this->s_grp->VirtualValue;
			} else {
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			if ($this->product->VirtualValue <> "") {
				$this->product->ViewValue = $this->product->VirtualValue;
			} else {
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// packing_type
			if ($this->packing_type->VirtualValue <> "") {
				$this->packing_type->ViewValue = $this->packing_type->VirtualValue;
			} else {
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			}
			$this->packing_type->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
				$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// avg_quantity
			$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
			$this->avg_quantity->ViewCustomAttributes = "";

			// max_qty
			$this->max_qty->ViewValue = $this->max_qty->CurrentValue;
			$this->max_qty->ViewCustomAttributes = "";

			// quantity_sub
			$this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
			$this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, 2, -2, -2, -2);
			$this->quantity_sub->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -1, -1, -1);
			$this->quantity->CssClass = "font-weight-bold";
			$this->quantity->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// total_amount
			$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
			$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
			$this->total_amount->ViewCustomAttributes = "";

			// cart_ref
			$this->cart_ref->ViewValue = $this->cart_ref->CurrentValue;
			$this->cart_ref->ViewValue = FormatNumber($this->cart_ref->ViewValue, 0, -2, -2, -2);
			$this->cart_ref->ViewCustomAttributes = "";

			// uploads
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// godown_po
			$this->godown_po->ViewValue = $this->godown_po->CurrentValue;
			$this->godown_po->ViewValue = FormatNumber($this->godown_po->ViewValue, 0, -2, -2, -2);
			$this->godown_po->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "material_outlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// process_type
			$this->process_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->process_type->CurrentValue)) {
				$this->process_type->HrefValue = "material_outlist.php?x_process_type=" . $this->process_type->CurrentValue; // Add prefix/suffix
				$this->process_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
			} else {
				$this->process_type->HrefValue = "";
			}
			$this->process_type->TooltipValue = "";
			if (!$this->isExport())
				$this->process_type->ViewValue = $this->highlightValue($this->process_type);

			// issue_to_unit
			$this->issue_to_unit->LinkCustomAttributes = "";
			$this->issue_to_unit->HrefValue = "";
			$this->issue_to_unit->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			if (!EmptyValue($this->issue_to->CurrentValue)) {
				$this->issue_to->HrefValue = "material_outlist.php?x_issue_to=" . $this->issue_to->CurrentValue; // Add prefix/suffix
				$this->issue_to->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
			} else {
				$this->issue_to->HrefValue = "";
			}
			$this->issue_to->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "material_outlist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";
			if (!$this->isExport())
				$this->godown->ViewValue = $this->highlightValue($this->godown);

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_no->ViewValue = $this->highlightValue($this->jc_no);

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "material_outlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";
			if (!$this->isExport())
				$this->product->ViewValue = $this->highlightValue($this->product);

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "material_outlist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";
			if (!$this->isExport())
				$this->packing_type->ViewValue = $this->highlightValue($this->packing_type);

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "material_outlist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";
			if (!$this->isExport())
				$this->rid->ViewValue = $this->highlightValue($this->rid);

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";
			if (!$this->isExport())
				$this->lot_no->ViewValue = $this->highlightValue($this->lot_no);

			// quantity_sub
			$this->quantity_sub->LinkCustomAttributes = "";
			$this->quantity_sub->HrefValue = "";
			$this->quantity_sub->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";
			if (!$this->isExport())
				$this->packets->ViewValue = $this->highlightValue($this->packets);

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			if (!EmptyValue($this->status->CurrentValue)) {
				$this->status->HrefValue = "material_outlist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
				$this->status->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
			} else {
				$this->status->HrefValue = "";
			}
			$this->status->TooltipValue = "";

			// total_amount
			$this->total_amount->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->total_amount->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->total_amount->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->total_amount->HrefValue = FullUrl($this->total_amount->HrefValue, "href");
			} else {
				$this->total_amount->HrefValue = "";
			}
			$this->total_amount->TooltipValue = "";

			// cart_ref
			$this->cart_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->cart_ref->CurrentValue)) {
				$this->cart_ref->HrefValue = "material_outlist.php?x_cart_ref=" . $this->cart_ref->CurrentValue; // Add prefix/suffix
				$this->cart_ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->cart_ref->HrefValue = FullUrl($this->cart_ref->HrefValue, "href");
			} else {
				$this->cart_ref->HrefValue = "";
			}
			$this->cart_ref->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "material_out_x" . $this->RowCnt . "_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// godown_po
			$this->godown_po->LinkCustomAttributes = "";
			$this->godown_po->HrefValue = "";
			$this->godown_po->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// process_type
			$this->process_type->EditAttrs["class"] = "form-control";
			$this->process_type->EditCustomAttributes = "";
			$this->process_type->EditValue = HtmlEncode($this->process_type->AdvancedSearch->SearchValue);
			$this->process_type->PlaceHolder = RemoveHtml($this->process_type->caption());

			// issue_to_unit
			$this->issue_to_unit->EditAttrs["class"] = "form-control";
			$this->issue_to_unit->EditCustomAttributes = "";
			$this->issue_to_unit->EditValue = HtmlEncode($this->issue_to_unit->AdvancedSearch->SearchValue);
			$this->issue_to_unit->PlaceHolder = RemoveHtml($this->issue_to_unit->caption());

			// issue_to
			$this->issue_to->EditAttrs["class"] = "form-control";
			$this->issue_to->EditCustomAttributes = "";

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$this->godown->EditValue = HtmlEncode($this->godown->AdvancedSearch->SearchValue);
			$this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_no->AdvancedSearch->SearchValue = HtmlDecode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->AdvancedSearch->SearchValue);
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$this->packing_type->EditValue = HtmlEncode($this->packing_type->AdvancedSearch->SearchValue);
			$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// quantity_sub
			$this->quantity_sub->EditAttrs["class"] = "form-control";
			$this->quantity_sub->EditCustomAttributes = "";
			$this->quantity_sub->EditValue = HtmlEncode($this->quantity_sub->AdvancedSearch->SearchValue);
			$this->quantity_sub->PlaceHolder = RemoveHtml($this->quantity_sub->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = 'ReadOnly';
			$this->packets->EditValue = HtmlEncode($this->packets->AdvancedSearch->SearchValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->AdvancedSearch->SearchValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, 0), 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue2, 0), 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// total_amount
			$this->total_amount->EditAttrs["class"] = "form-control";
			$this->total_amount->EditCustomAttributes = "";
			$this->total_amount->EditValue = HtmlEncode($this->total_amount->AdvancedSearch->SearchValue);
			$this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());

			// cart_ref
			$this->cart_ref->EditAttrs["class"] = "form-control";
			$this->cart_ref->EditCustomAttributes = "";
			$this->cart_ref->EditValue = HtmlEncode($this->cart_ref->AdvancedSearch->SearchValue);
			$this->cart_ref->PlaceHolder = RemoveHtml($this->cart_ref->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

			// godown_po
			$this->godown_po->EditAttrs["class"] = "form-control";
			$this->godown_po->EditCustomAttributes = "";
			$this->godown_po->EditValue = HtmlEncode($this->godown_po->AdvancedSearch->SearchValue);
			$this->godown_po->PlaceHolder = RemoveHtml($this->godown_po->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->quantity->Total = 0; // Initialize total
			$this->packets->Total = 0; // Initialize total
			$this->total_amount->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -1, -1, -1);
			$this->quantity->CssClass = "font-weight-bold";
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value
			$this->packets->CurrentValue = $this->packets->Total;
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";
			$this->packets->HrefValue = ""; // Clear href value
			$this->total_amount->CurrentValue = $this->total_amount->Total;
			$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
			$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
			$this->total_amount->ViewCustomAttributes = "";
			$this->total_amount->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->issue_to_unit->AdvancedSearch->load();
		$this->issue_to->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->rid_1->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->rid_2->AdvancedSearch->load();
		$this->rid_3->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->avg_quantity->AdvancedSearch->load();
		$this->max_qty->AdvancedSearch->load();
		$this->quantity_sub->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->cart_amount->AdvancedSearch->load();
		$this->other_amount->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->dated->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->hsn_code->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->tax_amount->AdvancedSearch->load();
		$this->tax_percent->AdvancedSearch->load();
		$this->total_amount->AdvancedSearch->load();
		$this->cart_ref->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
		$this->godown_po->AdvancedSearch->load();
	}

	// Build export filter for selected records
	protected function buildExportSelectedFilter()
	{
		global $Language;
		$wrkFilter = "";
		if ($this->isExport())
			$wrkFilter = $this->getFilterFromRecordKeys();
		return $wrkFilter;
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','excel',true,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','excel',false,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','word',true,true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','word',false,true);\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','pdf',true,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','pdf',false,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','html',false,true);\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','xml',false,true);\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','csv',false,true);\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" onclick=\"ew.export(document.fmaterial_outlist,'" . CurrentPageName() . "','print',false,true);\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_material_out\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_material_out',hdr:ew.language.phrase('ExportToEmailText'),f:document.fmaterial_outlist,sel:true" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_type":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0 and `category` != 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_1":
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_3":
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_process":
							break;
						case "x_process_type":
							break;
						case "x_issue_to":
							break;
						case "x_godown":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid_1":
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							break;
						case "x_packing_type":
							break;
						case "x_rid_2":
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_rid_3":
							$row[2] = FormatNumber($row[2], 2, -2, -2, 0);
							$row['df2'] = $row[2];
							break;
						case "x_rid":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'material_out');
		$item = &$this->OtherOptions['action']->Add("GST Challan");
		$item->Body = "<button class=\"btn btn-default ew-action\" onclick=\"javascript:GSTChallan()\">Create GST Challan (Selected)</button>";
		$item->Visible = True;
		$CUID = CurrentUserID();
		$row=ExecuteRow("SELECT `process`, `issue_to`, `godown`, `grp`, `s_grp`, `product` FROM `material_out` where `operator` = $CUID ORDER BY `material_out`.`id` DESC");
	if ($row)
	{
	setcookie("Process", $row['process']);
	setcookie("BUY", $row['issue_to']);
	setcookie("GODOWN", $row['godown']);
	setcookie("GRP", $row['grp']);
	setcookie("SGRP", $row['s_grp']);
	setcookie("PR", $row['product']);
	}
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

		if ($this->gp_no->CurrentValue > 0)
		{
			$this->ListOptions->Add("Print"); // Replace abclink with your name of the link
			$this->ListOptions->Items["Print"]->Body =
			'<a href="gst_challan.php?id=' . $this->gp_no->CurrentValue . '" data-original-title ="Print"><i data-phrase="Print"  class="fa fa-print ew-icon" ></i></a>';
		}
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>