<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for material_out_po
 */
class material_out_po extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $s_grp;
	public $product;
	public $po;
	public $rid;
	public $packing_type;
	public $godown;
	public $quantity_avg_act;
	public $packets;
	public $max_qty;
	public $req_qty;
	public $quantity;
	public $avg_quantity;
	public $process;
	public $process_type;
	public $dated;
	public $issue_to;
	public $remarks;
	public $operator;
	public $datetime;
	public $status;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'material_out_po';
		$this->TableName = 'material_out_po';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`material_out_po`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('material_out_po', 'material_out_po', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// s_grp
		$this->s_grp = new DbField('material_out_po', 'material_out_po', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], [], ["x_product"], [], [], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('material_out_po', 'material_out_po', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product_f', FALSE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// po
		$this->po = new DbField('material_out_po', 'material_out_po', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po->Sortable = FALSE; // Allow sort
		$this->po->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po->Lookup = new Lookup('po', 'material_required', TRUE, 'poid', ["poid","po","",""], [], [], [], [], [], [], '`poid` ASC', '');
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// rid
		$this->rid = new DbField('material_out_po', 'material_out_po', 'x_rid', 'rid', '`rid`', '`rid`', 2, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// packing_type
		$this->packing_type = new DbField('material_out_po', 'material_out_po', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["packing","code","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// godown
		$this->godown = new DbField('material_out_po', 'material_out_po', 'x_godown', 'godown', '`godown`', '`godown`', 19, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->godown->Required = TRUE; // Required field
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->Lookup = new Lookup('godown', 'godown_table', FALSE, 'id', ["name","location","code",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// quantity_avg_act
		$this->quantity_avg_act = new DbField('material_out_po', 'material_out_po', 'x_quantity_avg_act', 'quantity_avg_act', '`quantity_avg_act`', '`quantity_avg_act`', 17, -1, FALSE, '`quantity_avg_act`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->quantity_avg_act->Sortable = TRUE; // Allow sort
		$this->quantity_avg_act->Lookup = new Lookup('quantity_avg_act', 'material_out_po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->quantity_avg_act->OptionCount = 2;
		$this->quantity_avg_act->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity_avg_act'] = &$this->quantity_avg_act;

		// packets
		$this->packets = new DbField('material_out_po', 'material_out_po', 'x_packets', 'packets', '`packets`', '`packets`', 131, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Required = TRUE; // Required field
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->DefaultErrorMessage = str_replace(array("%1", "%2"), array("0.001", "10000"), $Language->phrase("IncorrectRange"));
		$this->fields['packets'] = &$this->packets;

		// max_qty
		$this->max_qty = new DbField('material_out_po', 'material_out_po', 'x_max_qty', 'max_qty', '0', '0', 20, -1, FALSE, '0', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->max_qty->IsCustom = TRUE; // Custom field
		$this->max_qty->Sortable = TRUE; // Allow sort
		$this->max_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['max_qty'] = &$this->max_qty;

		// req_qty
		$this->req_qty = new DbField('material_out_po', 'material_out_po', 'x_req_qty', 'req_qty', '\'\'', '\'\'', 201, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_qty->IsCustom = TRUE; // Custom field
		$this->req_qty->Sortable = TRUE; // Allow sort
		$this->fields['req_qty'] = &$this->req_qty;

		// quantity
		$this->quantity = new DbField('material_out_po', 'material_out_po', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->Lookup = new Lookup('quantity', 'material_required', FALSE, 'quantity', ["quantity","","",""], [], [], [], [], [], [], '', '');
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// avg_quantity
		$this->avg_quantity = new DbField('material_out_po', 'material_out_po', 'x_avg_quantity', 'avg_quantity', '0', '0', 20, -1, FALSE, '0', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avg_quantity->IsCustom = TRUE; // Custom field
		$this->avg_quantity->Sortable = TRUE; // Allow sort
		$this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['avg_quantity'] = &$this->avg_quantity;

		// process
		$this->process = new DbField('material_out_po', 'material_out_po', 'x_process', 'process', '`process`', '`process`', 17, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->process->Required = TRUE; // Required field
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->Lookup = new Lookup('process', 'process', FALSE, 'id', ["id","name","",""], [], ["x_process_type"], [], [], [], [], '`id` ASC', '');
		$this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process'] = &$this->process;

		// process_type
		$this->process_type = new DbField('material_out_po', 'material_out_po', 'x_process_type', 'process_type', '`process_type`', '`process_type`', 2, -1, FALSE, '`process_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process_type->Sortable = FALSE; // Allow sort
		$this->process_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process_type->Lookup = new Lookup('process_type', 'process_type', FALSE, 'id', ["code","name","avg_yield",""], ["x_process"], [], ["process"], ["x_process"], [], [], '`code` ASC', '');
		$this->process_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process_type'] = &$this->process_type;

		// dated
		$this->dated = new DbField('material_out_po', 'material_out_po', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 135, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Required = TRUE; // Required field
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// issue_to
		$this->issue_to = new DbField('material_out_po', 'material_out_po', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 19, -1, FALSE, '`issue_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to->Sortable = TRUE; // Allow sort
		$this->issue_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to->Lookup = new Lookup('issue_to', 'buyer', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to'] = &$this->issue_to;

		// remarks
		$this->remarks = new DbField('material_out_po', 'material_out_po', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// operator
		$this->operator = new DbField('material_out_po', 'material_out_po', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('material_out_po', 'material_out_po', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// status
		$this->status = new DbField('material_out_po', 'material_out_po', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'material_out_po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 3;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`material_out_po`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, 0 AS `max_qty`, '' AS `req_qty`, 0 AS `avg_quantity` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->po->DbValue = $row['po'];
		$this->rid->DbValue = $row['rid'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->godown->DbValue = $row['godown'];
		$this->quantity_avg_act->DbValue = $row['quantity_avg_act'];
		$this->packets->DbValue = $row['packets'];
		$this->max_qty->DbValue = $row['max_qty'];
		$this->req_qty->DbValue = $row['req_qty'];
		$this->quantity->DbValue = $row['quantity'];
		$this->avg_quantity->DbValue = $row['avg_quantity'];
		$this->process->DbValue = $row['process'];
		$this->process_type->DbValue = $row['process_type'];
		$this->dated->DbValue = $row['dated'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->remarks->DbValue = $row['remarks'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->status->DbValue = $row['status'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "material_out_polist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "material_out_poview.php")
			return $Language->phrase("View");
		elseif ($pageName == "material_out_poedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "material_out_poadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "material_out_polist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("material_out_poview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("material_out_poview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "material_out_poadd.php?" . $this->getUrlParm($parm);
		else
			$url = "material_out_poadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("material_out_poedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("material_out_poadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("material_out_podelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->po->setDbValue($rs->fields('po'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->quantity_avg_act->setDbValue($rs->fields('quantity_avg_act'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->max_qty->setDbValue($rs->fields('max_qty'));
		$this->req_qty->setDbValue($rs->fields('req_qty'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->avg_quantity->setDbValue($rs->fields('avg_quantity'));
		$this->process->setDbValue($rs->fields('process'));
		$this->process_type->setDbValue($rs->fields('process_type'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->status->setDbValue($rs->fields('status'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// s_grp
		// product
		// po

		$this->po->CellCssStyle = "white-space: nowrap;";

		// rid
		// packing_type
		// godown
		// quantity_avg_act
		// packets
		// max_qty
		// req_qty
		// quantity
		// avg_quantity
		// process
		// process_type

		$this->process_type->CellCssStyle = "white-space: nowrap;";

		// dated
		// issue_to
		// remarks
		// operator
		// datetime
		// status
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// po
		$curVal = strval($this->po->CurrentValue);
		if ($curVal <> "") {
			$this->po->ViewValue = $this->po->lookupCacheOption($curVal);
			if ($this->po->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`poid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (isset($_GET['POID']))  ? "`poid` = " . $_GET['POID'] : '';
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->po->ViewValue = $this->po->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->po->ViewValue = $this->po->CurrentValue;
				}
			}
		} else {
			$this->po->ViewValue = NULL;
		}
		$this->po->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$this->rid->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// godown
		$this->godown->ViewValue = $this->godown->CurrentValue;
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// quantity_avg_act
		if (strval($this->quantity_avg_act->CurrentValue) <> "") {
			$this->quantity_avg_act->ViewValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
		} else {
			$this->quantity_avg_act->ViewValue = NULL;
		}
		$this->quantity_avg_act->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewCustomAttributes = "";

		// max_qty
		$this->max_qty->ViewValue = $this->max_qty->CurrentValue;
		$this->max_qty->ViewCustomAttributes = "";

		// req_qty
		$this->req_qty->ViewValue = $this->req_qty->CurrentValue;
		$this->req_qty->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$curVal = strval($this->quantity->CurrentValue);
		if ($curVal <> "") {
			$this->quantity->ViewValue = $this->quantity->lookupCacheOption($curVal);
			if ($this->quantity->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`quantity`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->quantity->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 3, -2, -2, -2);
					$this->quantity->ViewValue = $this->quantity->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->quantity->ViewValue = $this->quantity->CurrentValue;
				}
			}
		} else {
			$this->quantity->ViewValue = NULL;
		}
		$this->quantity->CssClass = "font-weight-bold";
		$this->quantity->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewCustomAttributes = "";

		// process
		$this->process->ViewValue = $this->process->CurrentValue;
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` =2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->process->ViewValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// process_type
		$curVal = strval($this->process_type->CurrentValue);
		if ($curVal <> "") {
			$this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
			if ($this->process_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->process_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process_type->ViewValue = $this->process_type->CurrentValue;
				}
			}
		} else {
			$this->process_type->ViewValue = NULL;
		}
		$this->process_type->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// issue_to
		$curVal = strval($this->issue_to->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			if ($this->issue_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
				}
			}
		} else {
			$this->issue_to->ViewValue = NULL;
		}
		$this->issue_to->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		$this->godown->HrefValue = "";
		$this->godown->TooltipValue = "";

		// quantity_avg_act
		$this->quantity_avg_act->LinkCustomAttributes = "";
		$this->quantity_avg_act->HrefValue = "";
		$this->quantity_avg_act->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// max_qty
		$this->max_qty->LinkCustomAttributes = "";
		$this->max_qty->HrefValue = "";
		$this->max_qty->TooltipValue = "";

		// req_qty
		$this->req_qty->LinkCustomAttributes = "";
		$this->req_qty->HrefValue = "";
		$this->req_qty->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// avg_quantity
		$this->avg_quantity->LinkCustomAttributes = "";
		$this->avg_quantity->HrefValue = "";
		$this->avg_quantity->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		$this->process->HrefValue = "";
		$this->process->TooltipValue = "";

		// process_type
		$this->process_type->LinkCustomAttributes = "";
		$this->process_type->HrefValue = "";
		$this->process_type->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		$this->issue_to->HrefValue = "";
		$this->issue_to->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "readonly";
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->EditValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->EditValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "readonly";
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->EditValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->EditValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->EditValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->EditValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "readonly";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "readonly";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "readonly";
		$this->godown->EditValue = $this->godown->CurrentValue;
		$this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

		// quantity_avg_act
		$this->quantity_avg_act->EditCustomAttributes = "";
		$this->quantity_avg_act->EditValue = $this->quantity_avg_act->options(FALSE);

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
		if (strval($this->packets->EditValue) <> "" && is_numeric($this->packets->EditValue))
			$this->packets->EditValue = FormatNumber($this->packets->EditValue, -2, -1, -2, 0);

		// max_qty
		$this->max_qty->EditAttrs["class"] = "form-control";
		$this->max_qty->EditCustomAttributes = "readonly";
		$this->max_qty->EditValue = $this->max_qty->CurrentValue;
		$this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());

		// req_qty
		$this->req_qty->EditAttrs["class"] = "form-control";
		$this->req_qty->EditCustomAttributes = "readonly";
		if (REMOVE_XSS)
			$this->req_qty->CurrentValue = HtmlDecode($this->req_qty->CurrentValue);
		$this->req_qty->EditValue = $this->req_qty->CurrentValue;
		$this->req_qty->PlaceHolder = RemoveHtml($this->req_qty->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

		// avg_quantity
		$this->avg_quantity->EditAttrs["class"] = "form-control";
		$this->avg_quantity->EditCustomAttributes = "readonly";
		$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "readonly";
		$this->process->EditValue = $this->process->CurrentValue;
		$this->process->PlaceHolder = RemoveHtml($this->process->caption());

		// process_type
		$this->process_type->EditAttrs["class"] = "form-control";
		$this->process_type->EditCustomAttributes = "";

		// dated
		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, 8);
		$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// operator
		// datetime
		// status

		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->quantity_avg_act);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->max_qty);
					$doc->exportCaption($this->req_qty);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->status);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->quantity_avg_act);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->max_qty);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->status);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->godown);
						$doc->exportField($this->quantity_avg_act);
						$doc->exportField($this->packets);
						$doc->exportField($this->max_qty);
						$doc->exportField($this->req_qty);
						$doc->exportField($this->quantity);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->process);
						$doc->exportField($this->dated);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->status);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->godown);
						$doc->exportField($this->quantity_avg_act);
						$doc->exportField($this->packets);
						$doc->exportField($this->max_qty);
						$doc->exportField($this->quantity);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->process);
						$doc->exportField($this->dated);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->status);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>