<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_out_view extends material_out
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_out';

	// Page object name
	public $PageObjName = "material_out_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_out)
		if (!isset($GLOBALS["material_out"]) || get_class($GLOBALS["material_out"]) == PROJECT_NAMESPACE . "material_out") {
			$GLOBALS["material_out"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_out"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_out');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_out;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_out);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "material_outview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("material_outlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->process->setVisibility();
		$this->process_type->Visible = FALSE;
		$this->issue_to_unit->setVisibility();
		$this->issue_to->setVisibility();
		$this->godown->setVisibility();
		$this->jc_no->setVisibility();
		$this->gp_no->Visible = FALSE;
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid_1->setVisibility();
		$this->packing_type->setVisibility();
		$this->rid_2->setVisibility();
		$this->rid_3->setVisibility();
		$this->rid->Visible = FALSE;
		$this->lot_no->setVisibility();
		$this->avg_quantity->setVisibility();
		$this->quantity_avg_act->Visible = FALSE;
		$this->max_qty->setVisibility();
		$this->quantity_sub->setVisibility();
		$this->quantity->setVisibility();
		$this->packets->setVisibility();
		$this->price->setVisibility();
		$this->cart_amount->setVisibility();
		$this->other_amount->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->dated->setVisibility();
		$this->remarks->setVisibility();
		$this->status->setVisibility();
		$this->tmp_lot->Visible = FALSE;
		$this->hsn_code->Visible = FALSE;
		$this->amount->Visible = FALSE;
		$this->tax_amount->Visible = FALSE;
		$this->tax_percent->setVisibility();
		$this->total_amount->Visible = FALSE;
		$this->cart_ref->setVisibility();
		$this->po->Visible = FALSE;
		$this->_print->Visible = FALSE;
		$this->_barcode->setVisibility();
		$this->url->Visible = FALSE;
		$this->uploads->setVisibility();
		$this->company_id->setVisibility();
		$this->rid_name->Visible = FALSE;
		$this->godown_po->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->process_type);
		$this->setupLookupOptions($this->issue_to);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid_1);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->rid_2);
		$this->setupLookupOptions($this->rid_3);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "material_outlist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "material_outlist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "material_outlist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->canAdd());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->process->setDbValue($row['process']);
		$this->process_type->setDbValue($row['process_type']);
		if (array_key_exists('EV__process_type', $rs->fields)) {
			$this->process_type->VirtualValue = $rs->fields('EV__process_type'); // Set up virtual field value
		} else {
			$this->process_type->VirtualValue = ""; // Clear value
		}
		$this->issue_to_unit->setDbValue($row['issue_to_unit']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->godown->setDbValue($row['godown']);
		if (array_key_exists('EV__godown', $rs->fields)) {
			$this->godown->VirtualValue = $rs->fields('EV__godown'); // Set up virtual field value
		} else {
			$this->godown->VirtualValue = ""; // Clear value
		}
		$this->jc_no->setDbValue($row['jc_no']);
		$this->gp_no->setDbValue($row['gp_no']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		if (array_key_exists('EV__s_grp', $rs->fields)) {
			$this->s_grp->VirtualValue = $rs->fields('EV__s_grp'); // Set up virtual field value
		} else {
			$this->s_grp->VirtualValue = ""; // Clear value
		}
		$this->product->setDbValue($row['product']);
		if (array_key_exists('EV__product', $rs->fields)) {
			$this->product->VirtualValue = $rs->fields('EV__product'); // Set up virtual field value
		} else {
			$this->product->VirtualValue = ""; // Clear value
		}
		$this->rid_1->setDbValue($row['rid_1']);
		if (array_key_exists('EV__rid_1', $rs->fields)) {
			$this->rid_1->VirtualValue = $rs->fields('EV__rid_1'); // Set up virtual field value
		} else {
			$this->rid_1->VirtualValue = ""; // Clear value
		}
		$this->packing_type->setDbValue($row['packing_type']);
		if (array_key_exists('EV__packing_type', $rs->fields)) {
			$this->packing_type->VirtualValue = $rs->fields('EV__packing_type'); // Set up virtual field value
		} else {
			$this->packing_type->VirtualValue = ""; // Clear value
		}
		$this->rid_2->setDbValue($row['rid_2']);
		$this->rid_3->setDbValue($row['rid_3']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->lot_no->setDbValue($row['lot_no']);
		$this->avg_quantity->setDbValue($row['avg_quantity']);
		$this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
		$this->max_qty->setDbValue($row['max_qty']);
		$this->quantity_sub->setDbValue($row['quantity_sub']);
		$this->quantity->setDbValue($row['quantity']);
		$this->packets->setDbValue($row['packets']);
		$this->price->setDbValue($row['price']);
		$this->cart_amount->setDbValue($row['cart_amount']);
		$this->other_amount->setDbValue($row['other_amount']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->dated->setDbValue($row['dated']);
		$this->remarks->setDbValue($row['remarks']);
		$this->status->setDbValue($row['status']);
		$this->tmp_lot->setDbValue($row['tmp_lot']);
		$this->hsn_code->setDbValue($row['hsn_code']);
		$this->amount->setDbValue($row['amount']);
		$this->tax_amount->setDbValue($row['tax_amount']);
		$this->tax_percent->setDbValue($row['tax_percent']);
		$this->total_amount->setDbValue($row['total_amount']);
		$this->cart_ref->setDbValue($row['cart_ref']);
		$this->po->setDbValue($row['po']);
		$this->_print->setDbValue($row['print']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->url->setDbValue($row['url']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->company_id->setDbValue($row['company_id']);
		$this->rid_name->setDbValue($row['rid_name']);
		$this->godown_po->setDbValue($row['godown_po']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['process'] = NULL;
		$row['process_type'] = NULL;
		$row['issue_to_unit'] = NULL;
		$row['issue_to'] = NULL;
		$row['godown'] = NULL;
		$row['jc_no'] = NULL;
		$row['gp_no'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid_1'] = NULL;
		$row['packing_type'] = NULL;
		$row['rid_2'] = NULL;
		$row['rid_3'] = NULL;
		$row['rid'] = NULL;
		$row['lot_no'] = NULL;
		$row['avg_quantity'] = NULL;
		$row['quantity_avg_act'] = NULL;
		$row['max_qty'] = NULL;
		$row['quantity_sub'] = NULL;
		$row['quantity'] = NULL;
		$row['packets'] = NULL;
		$row['price'] = NULL;
		$row['cart_amount'] = NULL;
		$row['other_amount'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['dated'] = NULL;
		$row['remarks'] = NULL;
		$row['status'] = NULL;
		$row['tmp_lot'] = NULL;
		$row['hsn_code'] = NULL;
		$row['amount'] = NULL;
		$row['tax_amount'] = NULL;
		$row['tax_percent'] = NULL;
		$row['total_amount'] = NULL;
		$row['cart_ref'] = NULL;
		$row['po'] = NULL;
		$row['print'] = NULL;
		$row['barcode'] = NULL;
		$row['url'] = NULL;
		$row['uploads'] = NULL;
		$row['company_id'] = NULL;
		$row['rid_name'] = NULL;
		$row['godown_po'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->quantity_sub->FormValue == $this->quantity_sub->CurrentValue && is_numeric(ConvertToFloatString($this->quantity_sub->CurrentValue)))
			$this->quantity_sub->CurrentValue = ConvertToFloatString($this->quantity_sub->CurrentValue);

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packets->FormValue == $this->packets->CurrentValue && is_numeric(ConvertToFloatString($this->packets->CurrentValue)))
			$this->packets->CurrentValue = ConvertToFloatString($this->packets->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cart_amount->FormValue == $this->cart_amount->CurrentValue && is_numeric(ConvertToFloatString($this->cart_amount->CurrentValue)))
			$this->cart_amount->CurrentValue = ConvertToFloatString($this->cart_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->other_amount->FormValue == $this->other_amount->CurrentValue && is_numeric(ConvertToFloatString($this->other_amount->CurrentValue)))
			$this->other_amount->CurrentValue = ConvertToFloatString($this->other_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->tax_percent->FormValue == $this->tax_percent->CurrentValue && is_numeric(ConvertToFloatString($this->tax_percent->CurrentValue)))
			$this->tax_percent->CurrentValue = ConvertToFloatString($this->tax_percent->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// process
		// process_type
		// issue_to_unit
		// issue_to
		// godown
		// jc_no
		// gp_no
		// grp
		// s_grp
		// product
		// rid_1
		// packing_type
		// rid_2
		// rid_3
		// rid
		// lot_no
		// avg_quantity
		// quantity_avg_act
		// max_qty
		// quantity_sub
		// quantity
		// packets
		// price
		// cart_amount
		// other_amount
		// operator
		// datetime
		// dated
		// remarks
		// status
		// tmp_lot
		// hsn_code
		// amount
		// tax_amount
		// tax_percent
		// total_amount
		// cart_ref
		// po
		// print
		// barcode
		// url
		// uploads
		// company_id
		// rid_name
		// godown_po

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_type
			if ($this->process_type->VirtualValue <> "") {
				$this->process_type->ViewValue = $this->process_type->VirtualValue;
			} else {
			$curVal = strval($this->process_type->CurrentValue);
			if ($curVal <> "") {
				$this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
				if ($this->process_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process_type->ViewValue = $this->process_type->CurrentValue;
					}
				}
			} else {
				$this->process_type->ViewValue = NULL;
			}
			}
			$this->process_type->ViewCustomAttributes = "";

			// issue_to_unit
			$this->issue_to_unit->ViewValue = $this->issue_to_unit->CurrentValue;
			$this->issue_to_unit->ViewValue = FormatNumber($this->issue_to_unit->ViewValue, 0, -2, -2, -2);
			$this->issue_to_unit->ViewCustomAttributes = "";

			// issue_to
			$curVal = strval($this->issue_to->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
				if ($this->issue_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0 and `category` != 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
					}
				}
			} else {
				$this->issue_to->ViewValue = NULL;
			}
			$this->issue_to->ViewCustomAttributes = "";

			// godown
			if ($this->godown->VirtualValue <> "") {
				$this->godown->ViewValue = $this->godown->VirtualValue;
			} else {
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			}
			$this->godown->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			if ($this->s_grp->VirtualValue <> "") {
				$this->s_grp->ViewValue = $this->s_grp->VirtualValue;
			} else {
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			if ($this->product->VirtualValue <> "") {
				$this->product->ViewValue = $this->product->VirtualValue;
			} else {
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// rid_1
			if ($this->rid_1->VirtualValue <> "") {
				$this->rid_1->ViewValue = $this->rid_1->VirtualValue;
			} else {
			$curVal = strval($this->rid_1->CurrentValue);
			if ($curVal <> "") {
				$this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
				if ($this->rid_1->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
						$arwrk[4] = $rswrk->fields('df4');
						$this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
					}
				}
			} else {
				$this->rid_1->ViewValue = NULL;
			}
			}
			$this->rid_1->ViewCustomAttributes = "";

			// packing_type
			if ($this->packing_type->VirtualValue <> "") {
				$this->packing_type->ViewValue = $this->packing_type->VirtualValue;
			} else {
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			}
			$this->packing_type->ViewCustomAttributes = "";

			// rid_2
			$curVal = strval($this->rid_2->CurrentValue);
			if ($curVal <> "") {
				$this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
				if ($this->rid_2->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$sqlWrk = $this->rid_2->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
						$this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_2->ViewValue = $this->rid_2->CurrentValue;
					}
				}
			} else {
				$this->rid_2->ViewValue = NULL;
			}
			$this->rid_2->ViewCustomAttributes = "";

			// rid_3
			$curVal = strval($this->rid_3->CurrentValue);
			if ($curVal <> "") {
				$this->rid_3->ViewValue = $this->rid_3->lookupCacheOption($curVal);
				if ($this->rid_3->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid_3->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0);
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->rid_3->ViewValue = $this->rid_3->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_3->ViewValue = $this->rid_3->CurrentValue;
					}
				}
			} else {
				$this->rid_3->ViewValue = NULL;
			}
			$this->rid_3->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
				$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// avg_quantity
			$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
			$this->avg_quantity->ViewCustomAttributes = "";

			// max_qty
			$this->max_qty->ViewValue = $this->max_qty->CurrentValue;
			$this->max_qty->ViewCustomAttributes = "";

			// quantity_sub
			$this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
			$this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, 2, -2, -2, -2);
			$this->quantity_sub->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -1, -1, -1);
			$this->quantity->CssClass = "font-weight-bold";
			$this->quantity->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// cart_amount
			$this->cart_amount->ViewValue = $this->cart_amount->CurrentValue;
			$this->cart_amount->ViewValue = FormatNumber($this->cart_amount->ViewValue, 2, -2, -2, -2);
			$this->cart_amount->ViewCustomAttributes = "";

			// other_amount
			$this->other_amount->ViewValue = $this->other_amount->CurrentValue;
			$this->other_amount->ViewValue = FormatNumber($this->other_amount->ViewValue, 2, -2, -2, -2);
			$this->other_amount->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// tax_percent
			$this->tax_percent->ViewValue = $this->tax_percent->CurrentValue;
			$this->tax_percent->ViewValue = FormatNumber($this->tax_percent->ViewValue, 2, -2, -2, -2);
			$this->tax_percent->ViewCustomAttributes = "";

			// cart_ref
			$this->cart_ref->ViewValue = $this->cart_ref->CurrentValue;
			$this->cart_ref->ViewValue = FormatNumber($this->cart_ref->ViewValue, 0, -2, -2, -2);
			$this->cart_ref->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// uploads
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
			$this->company_id->ViewCustomAttributes = "";

			// godown_po
			$this->godown_po->ViewValue = $this->godown_po->CurrentValue;
			$this->godown_po->ViewValue = FormatNumber($this->godown_po->ViewValue, 0, -2, -2, -2);
			$this->godown_po->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "material_outlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// issue_to_unit
			$this->issue_to_unit->LinkCustomAttributes = "";
			$this->issue_to_unit->HrefValue = "";
			$this->issue_to_unit->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			if (!EmptyValue($this->issue_to->CurrentValue)) {
				$this->issue_to->HrefValue = "material_outlist.php?x_issue_to=" . $this->issue_to->CurrentValue; // Add prefix/suffix
				$this->issue_to->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
			} else {
				$this->issue_to->HrefValue = "";
			}
			$this->issue_to->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "material_outlist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "material_outlist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "material_outlist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "material_outlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid_1
			$this->rid_1->LinkCustomAttributes = "";
			$this->rid_1->HrefValue = "";
			$this->rid_1->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "material_outlist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// rid_2
			$this->rid_2->LinkCustomAttributes = "";
			$this->rid_2->HrefValue = "";
			$this->rid_2->TooltipValue = "";

			// rid_3
			$this->rid_3->LinkCustomAttributes = "";
			$this->rid_3->HrefValue = "";
			$this->rid_3->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// avg_quantity
			$this->avg_quantity->LinkCustomAttributes = "";
			$this->avg_quantity->HrefValue = "";
			$this->avg_quantity->TooltipValue = "";

			// max_qty
			$this->max_qty->LinkCustomAttributes = "";
			$this->max_qty->HrefValue = "";
			$this->max_qty->TooltipValue = "";

			// quantity_sub
			$this->quantity_sub->LinkCustomAttributes = "";
			$this->quantity_sub->HrefValue = "";
			$this->quantity_sub->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// cart_amount
			$this->cart_amount->LinkCustomAttributes = "";
			$this->cart_amount->HrefValue = "";
			$this->cart_amount->TooltipValue = "";

			// other_amount
			$this->other_amount->LinkCustomAttributes = "";
			$this->other_amount->HrefValue = "";
			$this->other_amount->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			if (!EmptyValue($this->status->CurrentValue)) {
				$this->status->HrefValue = "material_outlist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
				$this->status->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
			} else {
				$this->status->HrefValue = "";
			}
			$this->status->TooltipValue = "";

			// tax_percent
			$this->tax_percent->LinkCustomAttributes = "";
			$this->tax_percent->HrefValue = "";
			$this->tax_percent->TooltipValue = "";

			// cart_ref
			$this->cart_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->cart_ref->CurrentValue)) {
				$this->cart_ref->HrefValue = "material_outlist.php?x_cart_ref=" . $this->cart_ref->CurrentValue; // Add prefix/suffix
				$this->cart_ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->cart_ref->HrefValue = FullUrl($this->cart_ref->HrefValue, "href");
			} else {
				$this->cart_ref->HrefValue = "";
			}
			$this->cart_ref->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "material_out_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// godown_po
			$this->godown_po->LinkCustomAttributes = "";
			$this->godown_po->HrefValue = "";
			$this->godown_po->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("material_outlist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_type":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0 and `category` != 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `type` = 2" : "`status` = 1 and `type` = 2 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_1":
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_3":
					$lookupFilter = function() {
						return (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_process":
							break;
						case "x_process_type":
							break;
						case "x_issue_to":
							break;
						case "x_godown":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid_1":
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							break;
						case "x_packing_type":
							break;
						case "x_rid_2":
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_rid_3":
							$row[2] = FormatNumber($row[2], 2, -2, -2, 0);
							$row['df2'] = $row[2];
							break;
						case "x_rid":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'material_out');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>