<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_required_grid extends material_required
{

	// Page ID
	public $PageID = "grid";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_required';

	// Page object name
	public $PageObjName = "material_required_grid";

	// Grid form hidden field names
	public $FormName = "fmaterial_requiredgrid";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$this->FormActionName .= "_" . $this->FormName;
		$this->FormKeyName .= "_" . $this->FormName;
		$this->FormOldKeyName .= "_" . $this->FormName;
		$this->FormBlankRowName .= "_" . $this->FormName;
		$this->FormKeyCountName .= "_" . $this->FormName;
		$GLOBALS["Grid"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_required)
		if (!isset($GLOBALS["material_required"]) || get_class($GLOBALS["material_required"]) == PROJECT_NAMESPACE . "material_required") {
			$GLOBALS["material_required"] = &$this;

			// $GLOBALS["MasterTable"] = &$GLOBALS["Table"];
			// if (!isset($GLOBALS["Table"]))
			// 	$GLOBALS["Table"] = &$GLOBALS["material_required"];

		}
		$this->AddUrl = "material_requiredadd.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'grid');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Export
		global $EXPORT, $material_required;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_required);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}

//		$GLOBALS["Table"] = &$GLOBALS["MasterTable"];
		unset($GLOBALS["Grid"]);
		if ($url === "")
			return;
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $ShowOtherOptions = FALSE;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->id->setVisibility();
		$this->poid->setVisibility();
		$this->po->setVisibility();
		$this->week->setVisibility();
		$this->buyer_id->setVisibility();
		$this->product_id->setVisibility();
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->Size_wl->setVisibility();
		$this->grp->Visible = FALSE;
		$this->sqm->setVisibility();
		$this->t_sqm->setVisibility();
		$this->unit->setVisibility();
		$this->material_qty->setVisibility();
		$this->method->setVisibility();
		$this->despatch_week->setVisibility();
		$this->production_plan->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->updated->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->req_material_grp->Visible = FALSE;
		$this->req_material_sgrp->Visible = FALSE;
		$this->req_material_product->Visible = FALSE;
		$this->req_material_rid->setVisibility();
		$this->req_material_packing->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->s_grp->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->material_out->Visible = FALSE;
		$this->material_out_id->Visible = FALSE;
		$this->operator->setVisibility();
		$this->despatch_date->setVisibility();
		$this->order_id->setVisibility();
		$this->weaving_works->setVisibility();
		$this->issue_material_grp->Visible = FALSE;
		$this->issue_material_sgrp->Visible = FALSE;
		$this->issue_material_product->Visible = FALSE;
		$this->issue_material_rid->Visible = FALSE;
		$this->issue_material_packing->Visible = FALSE;
		$this->issue_material_qty->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->issue_material_lcgp_rid->setVisibility();
		$this->issue_material_lot_no->setVisibility();
		$this->issue_material_godown->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up master detail parameters
		$this->setupMasterParms();

		// Setup other options
		$this->setupOtherOptions();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->product_id);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->req_material_sgrp);
		$this->setupLookupOptions($this->req_material_product);
		$this->setupLookupOptions($this->req_material_rid);
		$this->setupLookupOptions($this->req_material_packing);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Show grid delete link for grid add / grid edit
			if ($this->AllowAddDeleteRow) {
				if ($this->isGridAdd() || $this->isGridEdit()) {
					$item = &$this->ListOptions->getItem("griddelete");
					if ($item)
						$item->Visible = TRUE;
				}
			}

			// Set up sorting order
			$this->setupSortOrder();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records

		// Restore master/detail filter
		$this->DbMasterFilter = $this->getMasterFilter(); // Restore master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Restore detail filter
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Load master record
		if ($this->CurrentMode <> "add" && $this->getMasterFilter() <> "" && $this->getCurrentMasterTable() == "required_material_compiled") {
			global $required_material_compiled;
			$rsmaster = $required_material_compiled->loadRs($this->DbMasterFilter);
			$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
			if (!$this->MasterRecordExists) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
				$this->terminate("required_material_compiledlist.php"); // Return to master page
			} else {
				$required_material_compiled->loadListRowValues($rsmaster);
				$required_material_compiled->RowType = ROWTYPE_MASTER; // Master row
				$required_material_compiled->renderListRow();
				$rsmaster->close();
			}
		}

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			if ($this->CurrentMode == "copy") {
				$selectLimit = $this->UseSelectLimit;
				if ($selectLimit) {
					$this->TotalRecs = $this->listRecordCount();
					$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);
				} else {
					if ($this->Recordset = $this->loadRecordset())
						$this->TotalRecs = $this->Recordset->RecordCount();
				}
				$this->StartRec = 1;
				$this->DisplayRecs = $this->TotalRecs;
			} else {
				$this->CurrentFilter = "0=1";
				$this->StartRec = 1;
				$this->DisplayRecs = $this->GridAddRowCount;
			}
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			$this->DisplayRecs = $this->TotalRecs; // Display all records
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Exit inline mode
	protected function clearInlineMode()
	{
		$this->sqm->FormValue = ""; // Clear form value
		$this->t_sqm->FormValue = ""; // Clear form value
		$this->material_qty->FormValue = ""; // Clear form value
		$this->req_material_qty->FormValue = ""; // Clear form value
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Grid Add mode
	protected function gridAddMode()
	{
		$this->CurrentAction = "gridadd";
		$_SESSION[SESSION_INLINE_MODE] = "gridadd";
		$this->hideFieldsForAddEdit();
	}

	// Switch to Grid Edit mode
	protected function gridEditMode()
	{
		$this->CurrentAction = "gridedit";
		$_SESSION[SESSION_INLINE_MODE] = "gridedit";
		$this->hideFieldsForAddEdit();
	}

	// Perform update to grid
	public function gridUpdate()
	{
		global $Language, $CurrentForm, $FormError;
		$gridUpdate = TRUE;

		// Get old recordset
		$this->CurrentFilter = $this->buildKeyFilter();
		if ($this->CurrentFilter == "")
			$this->CurrentFilter = "0=1";
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sql)) {
			$rsold = $rs->getRows();
			$rs->close();
		}

		// Call Grid Updating event
		if (!$this->Grid_Updating($rsold)) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
			return FALSE;
		}
		$key = "";

		// Update row index and get row key
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Update all rows based on key
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
			$CurrentForm->Index = $rowindex;
			$rowkey = strval($CurrentForm->getValue($this->FormKeyName));
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));

			// Load all values and keys
			if ($rowaction <> "insertdelete") { // Skip insert then deleted rows
				$this->loadFormValues(); // Get form values
				if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
					$gridUpdate = $this->setupKeyValues($rowkey); // Set up key values
				} else {
					$gridUpdate = TRUE;
				}

				// Skip empty row
				if ($rowaction == "insert" && $this->emptyRow()) {

					// No action required
				// Validate form and insert/update/delete record

				} elseif ($gridUpdate) {
					if ($rowaction == "delete") {
						$this->CurrentFilter = $this->getRecordFilter();
						$gridUpdate = $this->deleteRows(); // Delete this row
					} else if (!$this->validateForm()) {
						$gridUpdate = FALSE; // Form error, reset action
						$this->setFailureMessage($FormError);
					} else {
						if ($rowaction == "insert") {
							$gridUpdate = $this->addRow(); // Insert this row
						} else {
							if ($rowkey <> "") {
								$this->SendEmail = FALSE; // Do not send email on update success
								$gridUpdate = $this->editRow(); // Update this row
							}
						} // End update
					}
				}
				if ($gridUpdate) {
					if ($key <> "")
						$key .= ", ";
					$key .= $rowkey;
				} else {
					break;
				}
			}
		}
		if ($gridUpdate) {

			// Get new recordset
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Updated event
			$this->Grid_Updated($rsold, $rsnew);
			$this->clearInlineMode(); // Clear inline edit mode
		} else {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
		}
		return $gridUpdate;
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Perform Grid Add
	public function gridInsert()
	{
		global $Language, $CurrentForm, $FormError;
		$rowindex = 1;
		$gridInsert = FALSE;
		$conn = &$this->getConnection();

		// Call Grid Inserting event
		if (!$this->Grid_Inserting()) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
			return FALSE;
		}

		// Init key filter
		$wrkfilter = "";
		$addcnt = 0;
		$key = "";

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Insert all rows
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "" && $rowaction <> "insert")
				continue; // Skip
			if ($rowaction == "insert") {
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
				$this->loadOldRecord(); // Load old record
			}
			$this->loadFormValues(); // Get form values
			if (!$this->emptyRow()) {
				$addcnt++;
				$this->SendEmail = FALSE; // Do not send email on insert success

				// Validate form
				if (!$this->validateForm()) {
					$gridInsert = FALSE; // Form error, reset action
					$this->setFailureMessage($FormError);
				} else {
					$gridInsert = $this->addRow($this->OldRecordset); // Insert this row
				}
				if ($gridInsert) {
					if ($key <> "")
						$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
					$key .= $this->id->CurrentValue;

					// Add filter for this record
					$filter = $this->getRecordFilter();
					if ($wrkfilter <> "")
						$wrkfilter .= " OR ";
					$wrkfilter .= $filter;
				} else {
					break;
				}
			}
		}
		if ($addcnt == 0) { // No record inserted
			$this->clearInlineMode(); // Clear grid add mode and return
			return TRUE;
		}
		if ($gridInsert) {

			// Get new recordset
			$this->CurrentFilter = $wrkfilter;
			$sql = $this->getCurrentSql();
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Inserted event
			$this->Grid_Inserted($rsnew);
			$this->clearInlineMode(); // Clear grid add mode
		} else {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
		}
		return $gridInsert;
	}

	// Check if empty row
	public function emptyRow()
	{
		global $CurrentForm;
		if ($CurrentForm->hasValue("x_poid") && $CurrentForm->hasValue("o_poid") && $this->poid->CurrentValue <> $this->poid->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_po") && $CurrentForm->hasValue("o_po") && $this->po->CurrentValue <> $this->po->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_week") && $CurrentForm->hasValue("o_week") && $this->week->CurrentValue <> $this->week->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_buyer_id") && $CurrentForm->hasValue("o_buyer_id") && $this->buyer_id->CurrentValue <> $this->buyer_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_product_id") && $CurrentForm->hasValue("o_product_id") && $this->product_id->CurrentValue <> $this->product_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_batch_no") && $CurrentForm->hasValue("o_batch_no") && $this->batch_no->CurrentValue <> $this->batch_no->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_quantity") && $CurrentForm->hasValue("o_quantity") && $this->quantity->CurrentValue <> $this->quantity->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_Size_wl") && $CurrentForm->hasValue("o_Size_wl") && $this->Size_wl->CurrentValue <> $this->Size_wl->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_sqm") && $CurrentForm->hasValue("o_sqm") && $this->sqm->CurrentValue <> $this->sqm->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_t_sqm") && $CurrentForm->hasValue("o_t_sqm") && $this->t_sqm->CurrentValue <> $this->t_sqm->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_unit") && $CurrentForm->hasValue("o_unit") && $this->unit->CurrentValue <> $this->unit->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_material_qty") && $CurrentForm->hasValue("o_material_qty") && $this->material_qty->CurrentValue <> $this->material_qty->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_method") && $CurrentForm->hasValue("o_method") && $this->method->CurrentValue <> $this->method->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_despatch_week") && $CurrentForm->hasValue("o_despatch_week") && $this->despatch_week->CurrentValue <> $this->despatch_week->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_req_material_rid") && $CurrentForm->hasValue("o_req_material_rid") && $this->req_material_rid->CurrentValue <> $this->req_material_rid->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_req_material_packing") && $CurrentForm->hasValue("o_req_material_packing") && $this->req_material_packing->CurrentValue <> $this->req_material_packing->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_req_material_qty") && $CurrentForm->hasValue("o_req_material_qty") && $this->req_material_qty->CurrentValue <> $this->req_material_qty->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_despatch_date") && $CurrentForm->hasValue("o_despatch_date") && $this->despatch_date->CurrentValue <> $this->despatch_date->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_order_id") && $CurrentForm->hasValue("o_order_id") && $this->order_id->CurrentValue <> $this->order_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_weaving_works") && $CurrentForm->hasValue("o_weaving_works") && $this->weaving_works->CurrentValue <> $this->weaving_works->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_company_id") && $CurrentForm->hasValue("o_company_id") && $this->company_id->CurrentValue <> $this->company_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_issue_material_lcgp_rid") && $CurrentForm->hasValue("o_issue_material_lcgp_rid") && $this->issue_material_lcgp_rid->CurrentValue <> $this->issue_material_lcgp_rid->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_issue_material_lot_no") && $CurrentForm->hasValue("o_issue_material_lot_no") && $this->issue_material_lot_no->CurrentValue <> $this->issue_material_lot_no->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_issue_material_godown") && $CurrentForm->hasValue("o_issue_material_godown") && $this->issue_material_godown->CurrentValue <> $this->issue_material_godown->OldValue)
			return FALSE;
		return TRUE;
	}

	// Validate grid form
	public function validateGridForm()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Validate all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else if (!$this->validateForm()) {
					return FALSE;
				}
			}
		}
		return TRUE;
	}

	// Get all form values of the grid
	public function getGridFormValues()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;
		$rows = array();

		// Loop through all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else {
					$rows[] = $this->getFieldValues("FormValue"); // Return row as array
				}
			}
		}
		return $rows; // Return as array of array
	}

	// Restore form values for current row
	public function restoreCurrentRowFormValues($idx)
	{
		global $CurrentForm;

		// Get row based on current index
		$CurrentForm->Index = $idx;
		$this->loadFormValues(); // Load form values
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset master/detail keys
			if ($this->Command == "resetall") {
				$this->setCurrentMasterTable(""); // Clear master table
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
				$this->po->setSessionValue("");
				$this->req_material_rid->setSessionValue("");
			}

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// "griddelete"
		if ($this->AllowAddDeleteRow) {
			$item = &$this->ListOptions->add("griddelete");
			$item->CssClass = "text-nowrap";
			$item->OnLeft = TRUE;
			$item->Visible = FALSE; // Default hidden
		}

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode <> "view") {
			$CurrentForm->Index = $this->RowIndex;
			$actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
			if ($CurrentForm->hasValue($this->FormOldKeyName))
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
			if ($this->RowOldKey <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($this->RowOldKey) . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $CurrentForm->getValue($this->FormKeyName);
				$this->setupKeyValues($rowkey);
			}
			if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
		}

		// "delete"
		if ($this->AllowAddDeleteRow) {
			if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
				$options = &$this->ListOptions;
				$options->UseButtonGroup = TRUE; // Use button group for grid delete button
				$opt = &$options->Items["griddelete"];
				if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
					$opt->Body = "&nbsp;";
				} else {
					$opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
				}
			}
		}
		if ($this->CurrentMode == "view") { // View mode
		} // End View mode
		if ($this->CurrentMode == "edit" && is_numeric($this->RowIndex)) {
			$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . $this->id->CurrentValue . "\">";
		}
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set record key
	public function setRecordKey(&$key, $rs)
	{
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs->fields('id');
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$option = &$this->OtherOptions["addedit"];
		$option->UseDropDownButton = FALSE;
		$option->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$option->UseButtonGroup = TRUE;

		//$option->ButtonClass = ""; // Class for button group
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		if (($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") && !$this->isConfirm()) { // Check add/copy/edit mode
			if ($this->AllowAddDeleteRow) {
				$option = &$options["addedit"];
				$option->UseDropDownButton = FALSE;
				$item = &$option->add("addblankrow");
				$item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"javascript:void(0);\" onclick=\"ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
				$item->Visible = FALSE;
				$this->ShowOtherOptions = $item->Visible;
			}
		}
		if ($this->CurrentMode == "view") { // Check view mode
			$option = &$options["addedit"];
			$item = &$option->getItem("add");
			$this->ShowOtherOptions = $item && $item->Visible;
		}
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->poid->CurrentValue = NULL;
		$this->poid->OldValue = $this->poid->CurrentValue;
		$this->po->CurrentValue = NULL;
		$this->po->OldValue = $this->po->CurrentValue;
		$this->week->CurrentValue = 0;
		$this->week->OldValue = $this->week->CurrentValue;
		$this->buyer_id->CurrentValue = NULL;
		$this->buyer_id->OldValue = $this->buyer_id->CurrentValue;
		$this->product_id->CurrentValue = NULL;
		$this->product_id->OldValue = $this->product_id->CurrentValue;
		$this->batch_no->CurrentValue = NULL;
		$this->batch_no->OldValue = $this->batch_no->CurrentValue;
		$this->quantity->CurrentValue = NULL;
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->Size_wl->CurrentValue = NULL;
		$this->Size_wl->OldValue = $this->Size_wl->CurrentValue;
		$this->grp->CurrentValue = 3;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->sqm->CurrentValue = NULL;
		$this->sqm->OldValue = $this->sqm->CurrentValue;
		$this->t_sqm->CurrentValue = NULL;
		$this->t_sqm->OldValue = $this->t_sqm->CurrentValue;
		$this->unit->CurrentValue = NULL;
		$this->unit->OldValue = $this->unit->CurrentValue;
		$this->material_qty->CurrentValue = NULL;
		$this->material_qty->OldValue = $this->material_qty->CurrentValue;
		$this->method->CurrentValue = NULL;
		$this->method->OldValue = $this->method->CurrentValue;
		$this->despatch_week->CurrentValue = NULL;
		$this->despatch_week->OldValue = $this->despatch_week->CurrentValue;
		$this->production_plan->CurrentValue = NULL;
		$this->production_plan->OldValue = $this->production_plan->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->updated->CurrentValue = 0;
		$this->updated->OldValue = $this->updated->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->req_material_grp->CurrentValue = NULL;
		$this->req_material_grp->OldValue = $this->req_material_grp->CurrentValue;
		$this->req_material_sgrp->CurrentValue = NULL;
		$this->req_material_sgrp->OldValue = $this->req_material_sgrp->CurrentValue;
		$this->req_material_product->CurrentValue = NULL;
		$this->req_material_product->OldValue = $this->req_material_product->CurrentValue;
		$this->req_material_rid->CurrentValue = NULL;
		$this->req_material_rid->OldValue = $this->req_material_rid->CurrentValue;
		$this->req_material_packing->CurrentValue = NULL;
		$this->req_material_packing->OldValue = $this->req_material_packing->CurrentValue;
		$this->req_material_qty->CurrentValue = NULL;
		$this->req_material_qty->OldValue = $this->req_material_qty->CurrentValue;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->material_out->CurrentValue = NULL;
		$this->material_out->OldValue = $this->material_out->CurrentValue;
		$this->material_out_id->CurrentValue = NULL;
		$this->material_out_id->OldValue = $this->material_out_id->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->despatch_date->CurrentValue = NULL;
		$this->despatch_date->OldValue = $this->despatch_date->CurrentValue;
		$this->order_id->CurrentValue = NULL;
		$this->order_id->OldValue = $this->order_id->CurrentValue;
		$this->weaving_works->CurrentValue = NULL;
		$this->weaving_works->OldValue = $this->weaving_works->CurrentValue;
		$this->issue_material_grp->CurrentValue = NULL;
		$this->issue_material_grp->OldValue = $this->issue_material_grp->CurrentValue;
		$this->issue_material_sgrp->CurrentValue = NULL;
		$this->issue_material_sgrp->OldValue = $this->issue_material_sgrp->CurrentValue;
		$this->issue_material_product->CurrentValue = NULL;
		$this->issue_material_product->OldValue = $this->issue_material_product->CurrentValue;
		$this->issue_material_rid->CurrentValue = NULL;
		$this->issue_material_rid->OldValue = $this->issue_material_rid->CurrentValue;
		$this->issue_material_packing->CurrentValue = NULL;
		$this->issue_material_packing->OldValue = $this->issue_material_packing->CurrentValue;
		$this->issue_material_qty->CurrentValue = NULL;
		$this->issue_material_qty->OldValue = $this->issue_material_qty->CurrentValue;
		$this->company_id->CurrentValue = NULL;
		$this->company_id->OldValue = $this->company_id->CurrentValue;
		$this->issue_material_lcgp_rid->CurrentValue = NULL;
		$this->issue_material_lcgp_rid->OldValue = $this->issue_material_lcgp_rid->CurrentValue;
		$this->issue_material_lot_no->CurrentValue = NULL;
		$this->issue_material_lot_no->OldValue = $this->issue_material_lot_no->CurrentValue;
		$this->issue_material_godown->CurrentValue = NULL;
		$this->issue_material_godown->OldValue = $this->issue_material_godown->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$CurrentForm->FormName = $this->FormName;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd())
			$this->id->setFormValue($val);

		// Check field name 'poid' first before field var 'x_poid'
		$val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
		if (!$this->poid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->poid->Visible = FALSE; // Disable update for API request
			else
				$this->poid->setFormValue($val);
		}
		$this->poid->setOldValue($CurrentForm->getValue("o_poid"));

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}
		$this->po->setOldValue($CurrentForm->getValue("o_po"));

		// Check field name 'week' first before field var 'x_week'
		$val = $CurrentForm->hasValue("week") ? $CurrentForm->getValue("week") : $CurrentForm->getValue("x_week");
		if (!$this->week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->week->Visible = FALSE; // Disable update for API request
			else
				$this->week->setFormValue($val);
		}
		$this->week->setOldValue($CurrentForm->getValue("o_week"));

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}
		$this->buyer_id->setOldValue($CurrentForm->getValue("o_buyer_id"));

		// Check field name 'product_id' first before field var 'x_product_id'
		$val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
		if (!$this->product_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_id->Visible = FALSE; // Disable update for API request
			else
				$this->product_id->setFormValue($val);
		}
		$this->product_id->setOldValue($CurrentForm->getValue("o_product_id"));

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}
		$this->batch_no->setOldValue($CurrentForm->getValue("o_batch_no"));

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}
		$this->quantity->setOldValue($CurrentForm->getValue("o_quantity"));

		// Check field name 'Size_wl' first before field var 'x_Size_wl'
		$val = $CurrentForm->hasValue("Size_wl") ? $CurrentForm->getValue("Size_wl") : $CurrentForm->getValue("x_Size_wl");
		if (!$this->Size_wl->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Size_wl->Visible = FALSE; // Disable update for API request
			else
				$this->Size_wl->setFormValue($val);
		}
		$this->Size_wl->setOldValue($CurrentForm->getValue("o_Size_wl"));

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}
		$this->sqm->setOldValue($CurrentForm->getValue("o_sqm"));

		// Check field name 't_sqm' first before field var 'x_t_sqm'
		$val = $CurrentForm->hasValue("t_sqm") ? $CurrentForm->getValue("t_sqm") : $CurrentForm->getValue("x_t_sqm");
		if (!$this->t_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->t_sqm->setFormValue($val);
		}
		$this->t_sqm->setOldValue($CurrentForm->getValue("o_t_sqm"));

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}
		$this->unit->setOldValue($CurrentForm->getValue("o_unit"));

		// Check field name 'material_qty' first before field var 'x_material_qty'
		$val = $CurrentForm->hasValue("material_qty") ? $CurrentForm->getValue("material_qty") : $CurrentForm->getValue("x_material_qty");
		if (!$this->material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->material_qty->setFormValue($val);
		}
		$this->material_qty->setOldValue($CurrentForm->getValue("o_material_qty"));

		// Check field name 'method' first before field var 'x_method'
		$val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
		if (!$this->method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->method->Visible = FALSE; // Disable update for API request
			else
				$this->method->setFormValue($val);
		}
		$this->method->setOldValue($CurrentForm->getValue("o_method"));

		// Check field name 'despatch_week' first before field var 'x_despatch_week'
		$val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
		if (!$this->despatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_week->setFormValue($val);
		}
		$this->despatch_week->setOldValue($CurrentForm->getValue("o_despatch_week"));

		// Check field name 'req_material_rid' first before field var 'x_req_material_rid'
		$val = $CurrentForm->hasValue("req_material_rid") ? $CurrentForm->getValue("req_material_rid") : $CurrentForm->getValue("x_req_material_rid");
		if (!$this->req_material_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_rid->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_rid->setFormValue($val);
		}
		$this->req_material_rid->setOldValue($CurrentForm->getValue("o_req_material_rid"));

		// Check field name 'req_material_packing' first before field var 'x_req_material_packing'
		$val = $CurrentForm->hasValue("req_material_packing") ? $CurrentForm->getValue("req_material_packing") : $CurrentForm->getValue("x_req_material_packing");
		if (!$this->req_material_packing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_packing->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_packing->setFormValue($val);
		}
		$this->req_material_packing->setOldValue($CurrentForm->getValue("o_req_material_packing"));

		// Check field name 'req_material_qty' first before field var 'x_req_material_qty'
		$val = $CurrentForm->hasValue("req_material_qty") ? $CurrentForm->getValue("req_material_qty") : $CurrentForm->getValue("x_req_material_qty");
		if (!$this->req_material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_qty->setFormValue($val);
		}
		$this->req_material_qty->setOldValue($CurrentForm->getValue("o_req_material_qty"));

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}
		$this->operator->setOldValue($CurrentForm->getValue("o_operator"));

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}
		$this->despatch_date->setOldValue($CurrentForm->getValue("o_despatch_date"));

		// Check field name 'order_id' first before field var 'x_order_id'
		$val = $CurrentForm->hasValue("order_id") ? $CurrentForm->getValue("order_id") : $CurrentForm->getValue("x_order_id");
		if (!$this->order_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_id->Visible = FALSE; // Disable update for API request
			else
				$this->order_id->setFormValue($val);
		}
		$this->order_id->setOldValue($CurrentForm->getValue("o_order_id"));

		// Check field name 'weaving_works' first before field var 'x_weaving_works'
		$val = $CurrentForm->hasValue("weaving_works") ? $CurrentForm->getValue("weaving_works") : $CurrentForm->getValue("x_weaving_works");
		if (!$this->weaving_works->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->weaving_works->Visible = FALSE; // Disable update for API request
			else
				$this->weaving_works->setFormValue($val);
		}
		$this->weaving_works->setOldValue($CurrentForm->getValue("o_weaving_works"));

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}
		$this->company_id->setOldValue($CurrentForm->getValue("o_company_id"));

		// Check field name 'issue_material_lcgp_rid' first before field var 'x_issue_material_lcgp_rid'
		$val = $CurrentForm->hasValue("issue_material_lcgp_rid") ? $CurrentForm->getValue("issue_material_lcgp_rid") : $CurrentForm->getValue("x_issue_material_lcgp_rid");
		if (!$this->issue_material_lcgp_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_lcgp_rid->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_lcgp_rid->setFormValue($val);
		}
		$this->issue_material_lcgp_rid->setOldValue($CurrentForm->getValue("o_issue_material_lcgp_rid"));

		// Check field name 'issue_material_lot_no' first before field var 'x_issue_material_lot_no'
		$val = $CurrentForm->hasValue("issue_material_lot_no") ? $CurrentForm->getValue("issue_material_lot_no") : $CurrentForm->getValue("x_issue_material_lot_no");
		if (!$this->issue_material_lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_lot_no->setFormValue($val);
		}
		$this->issue_material_lot_no->setOldValue($CurrentForm->getValue("o_issue_material_lot_no"));

		// Check field name 'issue_material_godown' first before field var 'x_issue_material_godown'
		$val = $CurrentForm->hasValue("issue_material_godown") ? $CurrentForm->getValue("issue_material_godown") : $CurrentForm->getValue("x_issue_material_godown");
		if (!$this->issue_material_godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_godown->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_godown->setFormValue($val);
		}
		$this->issue_material_godown->setOldValue($CurrentForm->getValue("o_issue_material_godown"));
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		if (!$this->isGridAdd() && !$this->isAdd())
			$this->id->CurrentValue = $this->id->FormValue;
		$this->poid->CurrentValue = $this->poid->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->week->CurrentValue = $this->week->FormValue;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->product_id->CurrentValue = $this->product_id->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->Size_wl->CurrentValue = $this->Size_wl->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->t_sqm->CurrentValue = $this->t_sqm->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->material_qty->CurrentValue = $this->material_qty->FormValue;
		$this->method->CurrentValue = $this->method->FormValue;
		$this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
		$this->req_material_rid->CurrentValue = $this->req_material_rid->FormValue;
		$this->req_material_packing->CurrentValue = $this->req_material_packing->FormValue;
		$this->req_material_qty->CurrentValue = $this->req_material_qty->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->order_id->CurrentValue = $this->order_id->FormValue;
		$this->weaving_works->CurrentValue = $this->weaving_works->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->issue_material_lcgp_rid->CurrentValue = $this->issue_material_lcgp_rid->FormValue;
		$this->issue_material_lot_no->CurrentValue = $this->issue_material_lot_no->FormValue;
		$this->issue_material_godown->CurrentValue = $this->issue_material_godown->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->poid->setDbValue($row['poid']);
		$this->po->setDbValue($row['po']);
		$this->week->setDbValue($row['week']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->product_id->setDbValue($row['product_id']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->Size_wl->setDbValue($row['Size_wl']);
		$this->grp->setDbValue($row['grp']);
		$this->sqm->setDbValue($row['sqm']);
		$this->t_sqm->setDbValue($row['t_sqm']);
		$this->unit->setDbValue($row['unit']);
		$this->material_qty->setDbValue($row['material_qty']);
		$this->method->setDbValue($row['method']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->remarks->setDbValue($row['remarks']);
		$this->updated->setDbValue($row['updated']);
		$this->datetime->setDbValue($row['datetime']);
		$this->req_material_grp->setDbValue($row['req_material_grp']);
		$this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
		$this->req_material_product->setDbValue($row['req_material_product']);
		$this->req_material_rid->setDbValue($row['req_material_rid']);
		if (array_key_exists('EV__req_material_rid', $rs->fields)) {
			$this->req_material_rid->VirtualValue = $rs->fields('EV__req_material_rid'); // Set up virtual field value
		} else {
			$this->req_material_rid->VirtualValue = ""; // Clear value
		}
		$this->req_material_packing->setDbValue($row['req_material_packing']);
		$this->req_material_qty->setDbValue($row['req_material_qty']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->material_out->setDbValue($row['material_out']);
		$this->material_out_id->setDbValue($row['material_out_id']);
		$this->operator->setDbValue($row['operator']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->order_id->setDbValue($row['order_id']);
		$this->weaving_works->setDbValue($row['weaving_works']);
		$this->issue_material_grp->setDbValue($row['issue_material_grp']);
		$this->issue_material_sgrp->setDbValue($row['issue_material_sgrp']);
		$this->issue_material_product->setDbValue($row['issue_material_product']);
		$this->issue_material_rid->setDbValue($row['issue_material_rid']);
		$this->issue_material_packing->setDbValue($row['issue_material_packing']);
		$this->issue_material_qty->setDbValue($row['issue_material_qty']);
		$this->company_id->setDbValue($row['company_id']);
		$this->issue_material_lcgp_rid->setDbValue($row['issue_material_lcgp_rid']);
		$this->issue_material_lot_no->setDbValue($row['issue_material_lot_no']);
		$this->issue_material_godown->setDbValue($row['issue_material_godown']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['poid'] = $this->poid->CurrentValue;
		$row['po'] = $this->po->CurrentValue;
		$row['week'] = $this->week->CurrentValue;
		$row['buyer_id'] = $this->buyer_id->CurrentValue;
		$row['product_id'] = $this->product_id->CurrentValue;
		$row['batch_no'] = $this->batch_no->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['Size_wl'] = $this->Size_wl->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['sqm'] = $this->sqm->CurrentValue;
		$row['t_sqm'] = $this->t_sqm->CurrentValue;
		$row['unit'] = $this->unit->CurrentValue;
		$row['material_qty'] = $this->material_qty->CurrentValue;
		$row['method'] = $this->method->CurrentValue;
		$row['despatch_week'] = $this->despatch_week->CurrentValue;
		$row['production_plan'] = $this->production_plan->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['updated'] = $this->updated->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['req_material_grp'] = $this->req_material_grp->CurrentValue;
		$row['req_material_sgrp'] = $this->req_material_sgrp->CurrentValue;
		$row['req_material_product'] = $this->req_material_product->CurrentValue;
		$row['req_material_rid'] = $this->req_material_rid->CurrentValue;
		$row['req_material_packing'] = $this->req_material_packing->CurrentValue;
		$row['req_material_qty'] = $this->req_material_qty->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['material_out'] = $this->material_out->CurrentValue;
		$row['material_out_id'] = $this->material_out_id->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['despatch_date'] = $this->despatch_date->CurrentValue;
		$row['order_id'] = $this->order_id->CurrentValue;
		$row['weaving_works'] = $this->weaving_works->CurrentValue;
		$row['issue_material_grp'] = $this->issue_material_grp->CurrentValue;
		$row['issue_material_sgrp'] = $this->issue_material_sgrp->CurrentValue;
		$row['issue_material_product'] = $this->issue_material_product->CurrentValue;
		$row['issue_material_rid'] = $this->issue_material_rid->CurrentValue;
		$row['issue_material_packing'] = $this->issue_material_packing->CurrentValue;
		$row['issue_material_qty'] = $this->issue_material_qty->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		$row['issue_material_lcgp_rid'] = $this->issue_material_lcgp_rid->CurrentValue;
		$row['issue_material_lot_no'] = $this->issue_material_lot_no->CurrentValue;
		$row['issue_material_godown'] = $this->issue_material_godown->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		$arKeys[] = $this->RowOldKey;
		$cnt = count($arKeys);
		if ($cnt >= 1) {
			if (strval($arKeys[0]) <> "")
				$this->id->CurrentValue = strval($arKeys[0]); // id
			else
				$validKey = FALSE;
		} else {
			$validKey = FALSE;
		}

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->t_sqm->FormValue == $this->t_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->t_sqm->CurrentValue)))
			$this->t_sqm->CurrentValue = ConvertToFloatString($this->t_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->material_qty->FormValue == $this->material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->material_qty->CurrentValue)))
			$this->material_qty->CurrentValue = ConvertToFloatString($this->material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// poid
		// po
		// week
		// buyer_id
		// product_id
		// batch_no

		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// quantity
		// Size_wl
		// grp
		// sqm
		// t_sqm
		// unit
		// material_qty
		// method
		// despatch_week
		// production_plan
		// remarks

		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// updated
		$this->updated->CellCssStyle = "white-space: nowrap;";

		// datetime
		// req_material_grp
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_packing
		// req_material_qty
		// s_grp
		// product
		// material_out
		// material_out_id

		$this->material_out_id->CellCssStyle = "white-space: nowrap;";

		// operator
		// despatch_date
		// order_id
		// weaving_works
		// issue_material_grp

		$this->issue_material_grp->CellCssStyle = "white-space: nowrap;";

		// issue_material_sgrp
		$this->issue_material_sgrp->CellCssStyle = "white-space: nowrap;";

		// issue_material_product
		$this->issue_material_product->CellCssStyle = "white-space: nowrap;";

		// issue_material_rid
		$this->issue_material_rid->CellCssStyle = "white-space: nowrap;";

		// issue_material_packing
		$this->issue_material_packing->CellCssStyle = "white-space: nowrap;";

		// issue_material_qty
		$this->issue_material_qty->CellCssStyle = "white-space: nowrap;";

		// company_id
		// issue_material_lcgp_rid
		// issue_material_lot_no
		// issue_material_godown
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->req_material_qty->CurrentValue))
				$this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
			if (is_numeric($this->issue_material_qty->CurrentValue))
				$this->issue_material_qty->Total += $this->issue_material_qty->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// week
			$this->week->ViewValue = $this->week->CurrentValue;
			$this->week->ViewValue = FormatNumber($this->week->ViewValue, 0, -2, -2, -2);
			$this->week->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// product_id
			$curVal = strval($this->product_id->CurrentValue);
			if ($curVal <> "") {
				$this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
				if ($this->product_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_id->ViewValue = $this->product_id->CurrentValue;
					}
				}
			} else {
				$this->product_id->ViewValue = NULL;
			}
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// Size_wl
			$this->Size_wl->ViewValue = $this->Size_wl->CurrentValue;
			$this->Size_wl->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// t_sqm
			$this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
			$this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, 2, -2, -2, -2);
			$this->t_sqm->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
			$this->material_qty->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// req_material_rid
			if ($this->req_material_rid->VirtualValue <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
			} else {
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->ViewValue = NULL;
			}
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_packing
			$curVal = strval($this->req_material_packing->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
				if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
					}
				}
			} else {
				$this->req_material_packing->ViewValue = NULL;
			}
			$this->req_material_packing->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, 0, 0, 0);
			$this->req_material_qty->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// order_id
			$this->order_id->ViewValue = $this->order_id->CurrentValue;
			$this->order_id->ViewCustomAttributes = "";

			// weaving_works
			$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
			$this->weaving_works->ViewValue = FormatNumber($this->weaving_works->ViewValue, 0, -2, -2, -2);
			$this->weaving_works->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
			$this->company_id->ViewCustomAttributes = "";

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->CurrentValue;
			$this->issue_material_lcgp_rid->ViewCustomAttributes = "";

			// issue_material_lot_no
			$this->issue_material_lot_no->ViewValue = $this->issue_material_lot_no->CurrentValue;
			$this->issue_material_lot_no->ViewCustomAttributes = "";

			// issue_material_godown
			$this->issue_material_godown->ViewValue = $this->issue_material_godown->CurrentValue;
			$this->issue_material_godown->ViewValue = FormatNumber($this->issue_material_godown->ViewValue, 0, -2, -2, -2);
			$this->issue_material_godown->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_id->CurrentValue)) {
				$this->buyer_id->HrefValue = "material_requiredlist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
				$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
			} else {
				$this->buyer_id->HrefValue = "";
			}
			$this->buyer_id->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_id->CurrentValue)) {
				$this->product_id->HrefValue = "material_requiredlist.php?x_product_item=" . $this->product_id->CurrentValue; // Add prefix/suffix
				$this->product_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
			} else {
				$this->product_id->HrefValue = "";
			}
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// Size_wl
			$this->Size_wl->LinkCustomAttributes = "";
			$this->Size_wl->HrefValue = "";
			$this->Size_wl->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// t_sqm
			$this->t_sqm->LinkCustomAttributes = "";
			$this->t_sqm->HrefValue = "";
			$this->t_sqm->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";
			$this->req_material_packing->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// order_id
			$this->order_id->LinkCustomAttributes = "";
			$this->order_id->HrefValue = "";
			$this->order_id->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->LinkCustomAttributes = "";
			$this->issue_material_lcgp_rid->HrefValue = "";
			$this->issue_material_lcgp_rid->TooltipValue = "";

			// issue_material_lot_no
			$this->issue_material_lot_no->LinkCustomAttributes = "";
			$this->issue_material_lot_no->HrefValue = "";
			$this->issue_material_lot_no->TooltipValue = "";

			// issue_material_godown
			$this->issue_material_godown->LinkCustomAttributes = "";
			$this->issue_material_godown->HrefValue = "";
			$this->issue_material_godown->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			// poid

			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = "";
			$this->poid->EditValue = HtmlEncode($this->poid->CurrentValue);
			$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			if ($this->po->getSessionValue() <> "") {
				$this->po->CurrentValue = $this->po->getSessionValue();
				$this->po->OldValue = $this->po->CurrentValue;
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";
			} else {
			$this->po->EditValue = HtmlEncode($this->po->CurrentValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			}

			// week
			$this->week->EditAttrs["class"] = "form-control";
			$this->week->EditCustomAttributes = "";
			$this->week->EditValue = HtmlEncode($this->week->CurrentValue);
			$this->week->PlaceHolder = RemoveHtml($this->week->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_id->CurrentValue));
			if ($curVal <> "")
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			else
				$this->buyer_id->ViewValue = $this->buyer_id->Lookup !== NULL && is_array($this->buyer_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_id->ViewValue !== NULL) { // Load from cache
				$this->buyer_id->EditValue = array_values($this->buyer_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_id->EditValue = $arwrk;
			}

			// product_id
			$this->product_id->EditAttrs["class"] = "form-control";
			$this->product_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_id->CurrentValue));
			if ($curVal <> "")
				$this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
			else
				$this->product_id->ViewValue = $this->product_id->Lookup !== NULL && is_array($this->product_id->Lookup->Options) ? $curVal : NULL;
			if ($this->product_id->ViewValue !== NULL) { // Load from cache
				$this->product_id->EditValue = array_values($this->product_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_id->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->CurrentValue));
			if ($curVal <> "")
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
				if ($this->batch_no->ViewValue == "")
					$this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
				} else {
					$this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// Size_wl
			$this->Size_wl->EditAttrs["class"] = "form-control";
			$this->Size_wl->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Size_wl->CurrentValue = HtmlDecode($this->Size_wl->CurrentValue);
			$this->Size_wl->EditValue = HtmlEncode($this->Size_wl->CurrentValue);
			$this->Size_wl->PlaceHolder = RemoveHtml($this->Size_wl->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->CurrentValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
			if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue)) {
				$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -1, -2, 0);
				$this->sqm->OldValue = $this->sqm->EditValue;
			}

			// t_sqm
			$this->t_sqm->EditAttrs["class"] = "form-control";
			$this->t_sqm->EditCustomAttributes = "";
			$this->t_sqm->EditValue = HtmlEncode($this->t_sqm->CurrentValue);
			$this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());
			if (strval($this->t_sqm->EditValue) <> "" && is_numeric($this->t_sqm->EditValue)) {
				$this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, -2, -2, -2, -2);
				$this->t_sqm->OldValue = $this->t_sqm->EditValue;
			}

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$curVal = trim(strval($this->unit->CurrentValue));
			if ($curVal <> "")
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
			else
				$this->unit->ViewValue = $this->unit->Lookup !== NULL && is_array($this->unit->Lookup->Options) ? $curVal : NULL;
			if ($this->unit->ViewValue !== NULL) { // Load from cache
				$this->unit->EditValue = array_values($this->unit->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->unit->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->unit->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->unit->EditValue = $arwrk;
			}

			// material_qty
			$this->material_qty->EditAttrs["class"] = "form-control";
			$this->material_qty->EditCustomAttributes = "";
			$this->material_qty->EditValue = HtmlEncode($this->material_qty->CurrentValue);
			$this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());
			if (strval($this->material_qty->EditValue) <> "" && is_numeric($this->material_qty->EditValue)) {
				$this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, -2, -1, -2, 0);
				$this->material_qty->OldValue = $this->material_qty->EditValue;
			}

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = trim(strval($this->method->CurrentValue));
			if ($curVal <> "")
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
			else
				$this->method->ViewValue = $this->method->Lookup !== NULL && is_array($this->method->Lookup->Options) ? $curVal : NULL;
			if ($this->method->ViewValue !== NULL) { // Load from cache
				$this->method->EditValue = array_values($this->method->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->method->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=21";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->method->EditValue = $arwrk;
			}

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->CurrentValue));
			if ($curVal <> "")
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// req_material_rid
			$this->req_material_rid->EditCustomAttributes = "";
			if ($this->req_material_rid->getSessionValue() <> "") {
				$this->req_material_rid->CurrentValue = $this->req_material_rid->getSessionValue();
				$this->req_material_rid->OldValue = $this->req_material_rid->CurrentValue;
			if ($this->req_material_rid->VirtualValue <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
			} else {
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->ViewValue = NULL;
			}
			}
			$this->req_material_rid->ViewCustomAttributes = "";
			} else {
			$curVal = trim(strval($this->req_material_rid->CurrentValue));
			if ($curVal <> "")
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
			else
				$this->req_material_rid->ViewValue = $this->req_material_rid->Lookup !== NULL && is_array($this->req_material_rid->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_rid->ViewValue !== NULL) { // Load from cache
				$this->req_material_rid->EditValue = array_values($this->req_material_rid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_rid->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->req_material_rid->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_rid->EditValue = $arwrk;
			}
			}

			// req_material_packing
			$this->req_material_packing->EditAttrs["class"] = "form-control";
			$this->req_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_packing->CurrentValue));
			if ($curVal <> "")
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			else
				$this->req_material_packing->ViewValue = $this->req_material_packing->Lookup !== NULL && is_array($this->req_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_packing->ViewValue !== NULL) { // Load from cache
				$this->req_material_packing->EditValue = array_values($this->req_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_packing->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_packing->EditValue = $arwrk;
			}

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = HtmlEncode($this->req_material_qty->CurrentValue);
			$this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
			if (strval($this->req_material_qty->EditValue) <> "" && is_numeric($this->req_material_qty->EditValue)) {
				$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, -2, 0, -2, 0);
				$this->req_material_qty->OldValue = $this->req_material_qty->EditValue;
			}

			// operator
			// despatch_date

			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// order_id
			$this->order_id->EditAttrs["class"] = "form-control";
			$this->order_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->order_id->CurrentValue = HtmlDecode($this->order_id->CurrentValue);
			$this->order_id->EditValue = HtmlEncode($this->order_id->CurrentValue);
			$this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";
			$this->weaving_works->EditValue = HtmlEncode($this->weaving_works->CurrentValue);
			$this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->EditAttrs["class"] = "form-control";
			$this->issue_material_lcgp_rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->issue_material_lcgp_rid->CurrentValue = HtmlDecode($this->issue_material_lcgp_rid->CurrentValue);
			$this->issue_material_lcgp_rid->EditValue = HtmlEncode($this->issue_material_lcgp_rid->CurrentValue);
			$this->issue_material_lcgp_rid->PlaceHolder = RemoveHtml($this->issue_material_lcgp_rid->caption());

			// issue_material_lot_no
			$this->issue_material_lot_no->EditAttrs["class"] = "form-control";
			$this->issue_material_lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->issue_material_lot_no->CurrentValue = HtmlDecode($this->issue_material_lot_no->CurrentValue);
			$this->issue_material_lot_no->EditValue = HtmlEncode($this->issue_material_lot_no->CurrentValue);
			$this->issue_material_lot_no->PlaceHolder = RemoveHtml($this->issue_material_lot_no->caption());

			// issue_material_godown
			$this->issue_material_godown->EditAttrs["class"] = "form-control";
			$this->issue_material_godown->EditCustomAttributes = "";
			$this->issue_material_godown->EditValue = HtmlEncode($this->issue_material_godown->CurrentValue);
			$this->issue_material_godown->PlaceHolder = RemoveHtml($this->issue_material_godown->caption());

			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_id->CurrentValue)) {
				$this->buyer_id->HrefValue = "material_requiredlist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
				$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
			} else {
				$this->buyer_id->HrefValue = "";
			}

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_id->CurrentValue)) {
				$this->product_id->HrefValue = "material_requiredlist.php?x_product_item=" . $this->product_id->CurrentValue; // Add prefix/suffix
				$this->product_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
			} else {
				$this->product_id->HrefValue = "";
			}

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// Size_wl
			$this->Size_wl->LinkCustomAttributes = "";
			$this->Size_wl->HrefValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";

			// t_sqm
			$this->t_sqm->LinkCustomAttributes = "";
			$this->t_sqm->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// order_id
			$this->order_id->LinkCustomAttributes = "";
			$this->order_id->HrefValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->LinkCustomAttributes = "";
			$this->issue_material_lcgp_rid->HrefValue = "";

			// issue_material_lot_no
			$this->issue_material_lot_no->LinkCustomAttributes = "";
			$this->issue_material_lot_no->HrefValue = "";

			// issue_material_godown
			$this->issue_material_godown->LinkCustomAttributes = "";
			$this->issue_material_godown->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// poid
			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = "";
			$this->poid->EditValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// week
			$this->week->EditAttrs["class"] = "form-control";
			$this->week->EditCustomAttributes = "";
			$this->week->EditValue = HtmlEncode($this->week->CurrentValue);
			$this->week->PlaceHolder = RemoveHtml($this->week->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->EditValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// product_id
			$this->product_id->EditAttrs["class"] = "form-control";
			$this->product_id->EditCustomAttributes = "";
			$curVal = strval($this->product_id->CurrentValue);
			if ($curVal <> "") {
				$this->product_id->EditValue = $this->product_id->lookupCacheOption($curVal);
				if ($this->product_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_id->EditValue = $this->product_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_id->EditValue = $this->product_id->CurrentValue;
					}
				}
			} else {
				$this->product_id->EditValue = NULL;
			}
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->EditValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->EditValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = $this->quantity->CurrentValue;
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// Size_wl
			$this->Size_wl->EditAttrs["class"] = "form-control";
			$this->Size_wl->EditCustomAttributes = "";
			$this->Size_wl->EditValue = $this->Size_wl->CurrentValue;
			$this->Size_wl->ViewCustomAttributes = "";

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// t_sqm
			$this->t_sqm->EditAttrs["class"] = "form-control";
			$this->t_sqm->EditCustomAttributes = "";
			$this->t_sqm->EditValue = HtmlEncode($this->t_sqm->CurrentValue);
			$this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());
			if (strval($this->t_sqm->EditValue) <> "" && is_numeric($this->t_sqm->EditValue)) {
				$this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, -2, -2, -2, -2);
				$this->t_sqm->OldValue = $this->t_sqm->EditValue;
			}

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->unit->EditValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->EditValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->EditValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->EditAttrs["class"] = "form-control";
			$this->material_qty->EditCustomAttributes = "";
			$this->material_qty->EditValue = $this->material_qty->CurrentValue;
			$this->material_qty->ViewCustomAttributes = "";

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->EditValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->EditValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->EditValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->EditValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->EditValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// req_material_rid
			$this->req_material_rid->EditAttrs["class"] = "form-control";
			$this->req_material_rid->EditCustomAttributes = "";
			if ($this->req_material_rid->VirtualValue <> "") {
				$this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
			} else {
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->EditValue = NULL;
			}
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_packing
			$this->req_material_packing->EditAttrs["class"] = "form-control";
			$this->req_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_packing->CurrentValue));
			if ($curVal <> "")
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			else
				$this->req_material_packing->ViewValue = $this->req_material_packing->Lookup !== NULL && is_array($this->req_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_packing->ViewValue !== NULL) { // Load from cache
				$this->req_material_packing->EditValue = array_values($this->req_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_packing->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_packing->EditValue = $arwrk;
			}

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, 2, 0, 0, 0);
			$this->req_material_qty->ViewCustomAttributes = "";

			// operator
			// despatch_date

			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// order_id
			$this->order_id->EditAttrs["class"] = "form-control";
			$this->order_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->order_id->CurrentValue = HtmlDecode($this->order_id->CurrentValue);
			$this->order_id->EditValue = HtmlEncode($this->order_id->CurrentValue);
			$this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";
			$this->weaving_works->EditValue = HtmlEncode($this->weaving_works->CurrentValue);
			$this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->EditAttrs["class"] = "form-control";
			$this->issue_material_lcgp_rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->issue_material_lcgp_rid->CurrentValue = HtmlDecode($this->issue_material_lcgp_rid->CurrentValue);
			$this->issue_material_lcgp_rid->EditValue = HtmlEncode($this->issue_material_lcgp_rid->CurrentValue);
			$this->issue_material_lcgp_rid->PlaceHolder = RemoveHtml($this->issue_material_lcgp_rid->caption());

			// issue_material_lot_no
			$this->issue_material_lot_no->EditAttrs["class"] = "form-control";
			$this->issue_material_lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->issue_material_lot_no->CurrentValue = HtmlDecode($this->issue_material_lot_no->CurrentValue);
			$this->issue_material_lot_no->EditValue = HtmlEncode($this->issue_material_lot_no->CurrentValue);
			$this->issue_material_lot_no->PlaceHolder = RemoveHtml($this->issue_material_lot_no->caption());

			// issue_material_godown
			$this->issue_material_godown->EditAttrs["class"] = "form-control";
			$this->issue_material_godown->EditCustomAttributes = "";
			$this->issue_material_godown->EditValue = HtmlEncode($this->issue_material_godown->CurrentValue);
			$this->issue_material_godown->PlaceHolder = RemoveHtml($this->issue_material_godown->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_id->CurrentValue)) {
				$this->buyer_id->HrefValue = "material_requiredlist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
				$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
			} else {
				$this->buyer_id->HrefValue = "";
			}
			$this->buyer_id->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_id->CurrentValue)) {
				$this->product_id->HrefValue = "material_requiredlist.php?x_product_item=" . $this->product_id->CurrentValue; // Add prefix/suffix
				$this->product_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
			} else {
				$this->product_id->HrefValue = "";
			}
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// Size_wl
			$this->Size_wl->LinkCustomAttributes = "";
			$this->Size_wl->HrefValue = "";
			$this->Size_wl->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// t_sqm
			$this->t_sqm->LinkCustomAttributes = "";
			$this->t_sqm->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// order_id
			$this->order_id->LinkCustomAttributes = "";
			$this->order_id->HrefValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->LinkCustomAttributes = "";
			$this->issue_material_lcgp_rid->HrefValue = "";

			// issue_material_lot_no
			$this->issue_material_lot_no->LinkCustomAttributes = "";
			$this->issue_material_lot_no->HrefValue = "";

			// issue_material_godown
			$this->issue_material_godown->LinkCustomAttributes = "";
			$this->issue_material_godown->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->req_material_qty->Total = 0; // Initialize total
			$this->issue_material_qty->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, 0, 0, 0);
			$this->req_material_qty->ViewCustomAttributes = "";
			$this->req_material_qty->HrefValue = ""; // Clear href value
			$this->issue_material_qty->CurrentValue = $this->issue_material_qty->Total;
			$this->issue_material_qty->ViewValue = $this->issue_material_qty->CurrentValue;
			$this->issue_material_qty->ViewValue = FormatNumber($this->issue_material_qty->ViewValue, 2, -2, -2, -2);
			$this->issue_material_qty->ViewCustomAttributes = "";
			$this->issue_material_qty->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->poid->Required) {
			if (!$this->poid->IsDetailKey && $this->poid->FormValue != NULL && $this->poid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->week->Required) {
			if (!$this->week->IsDetailKey && $this->week->FormValue != NULL && $this->week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->week->caption(), $this->week->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->week->FormValue)) {
			AddMessage($FormError, $this->week->errorMessage());
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if ($this->product_id->Required) {
			if (!$this->product_id->IsDetailKey && $this->product_id->FormValue != NULL && $this->product_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->Size_wl->Required) {
			if (!$this->Size_wl->IsDetailKey && $this->Size_wl->FormValue != NULL && $this->Size_wl->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Size_wl->caption(), $this->Size_wl->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->t_sqm->Required) {
			if (!$this->t_sqm->IsDetailKey && $this->t_sqm->FormValue != NULL && $this->t_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_sqm->caption(), $this->t_sqm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->t_sqm->FormValue)) {
			AddMessage($FormError, $this->t_sqm->errorMessage());
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->material_qty->Required) {
			if (!$this->material_qty->IsDetailKey && $this->material_qty->FormValue != NULL && $this->material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_qty->caption(), $this->material_qty->RequiredErrorMessage));
			}
		}
		if ($this->method->Required) {
			if (!$this->method->IsDetailKey && $this->method->FormValue != NULL && $this->method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
			}
		}
		if ($this->despatch_week->Required) {
			if (!$this->despatch_week->IsDetailKey && $this->despatch_week->FormValue != NULL && $this->despatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
			}
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->req_material_grp->Required) {
			if (!$this->req_material_grp->IsDetailKey && $this->req_material_grp->FormValue != NULL && $this->req_material_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_grp->caption(), $this->req_material_grp->RequiredErrorMessage));
			}
		}
		if ($this->req_material_sgrp->Required) {
			if (!$this->req_material_sgrp->IsDetailKey && $this->req_material_sgrp->FormValue != NULL && $this->req_material_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_sgrp->caption(), $this->req_material_sgrp->RequiredErrorMessage));
			}
		}
		if ($this->req_material_product->Required) {
			if (!$this->req_material_product->IsDetailKey && $this->req_material_product->FormValue != NULL && $this->req_material_product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_product->caption(), $this->req_material_product->RequiredErrorMessage));
			}
		}
		if ($this->req_material_rid->Required) {
			if ($this->req_material_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_rid->caption(), $this->req_material_rid->RequiredErrorMessage));
			}
		}
		if ($this->req_material_packing->Required) {
			if (!$this->req_material_packing->IsDetailKey && $this->req_material_packing->FormValue != NULL && $this->req_material_packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_packing->caption(), $this->req_material_packing->RequiredErrorMessage));
			}
		}
		if ($this->req_material_qty->Required) {
			if (!$this->req_material_qty->IsDetailKey && $this->req_material_qty->FormValue != NULL && $this->req_material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_qty->caption(), $this->req_material_qty->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->material_out->Required) {
			if ($this->material_out->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_out->caption(), $this->material_out->RequiredErrorMessage));
			}
		}
		if ($this->material_out_id->Required) {
			if (!$this->material_out_id->IsDetailKey && $this->material_out_id->FormValue != NULL && $this->material_out_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_out_id->caption(), $this->material_out_id->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_date->FormValue)) {
			AddMessage($FormError, $this->despatch_date->errorMessage());
		}
		if ($this->order_id->Required) {
			if (!$this->order_id->IsDetailKey && $this->order_id->FormValue != NULL && $this->order_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_id->caption(), $this->order_id->RequiredErrorMessage));
			}
		}
		if ($this->weaving_works->Required) {
			if (!$this->weaving_works->IsDetailKey && $this->weaving_works->FormValue != NULL && $this->weaving_works->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->weaving_works->caption(), $this->weaving_works->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->weaving_works->FormValue)) {
			AddMessage($FormError, $this->weaving_works->errorMessage());
		}
		if ($this->issue_material_grp->Required) {
			if (!$this->issue_material_grp->IsDetailKey && $this->issue_material_grp->FormValue != NULL && $this->issue_material_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_grp->caption(), $this->issue_material_grp->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_sgrp->Required) {
			if (!$this->issue_material_sgrp->IsDetailKey && $this->issue_material_sgrp->FormValue != NULL && $this->issue_material_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_sgrp->caption(), $this->issue_material_sgrp->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_product->Required) {
			if (!$this->issue_material_product->IsDetailKey && $this->issue_material_product->FormValue != NULL && $this->issue_material_product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_product->caption(), $this->issue_material_product->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_rid->Required) {
			if (!$this->issue_material_rid->IsDetailKey && $this->issue_material_rid->FormValue != NULL && $this->issue_material_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_rid->caption(), $this->issue_material_rid->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_packing->Required) {
			if (!$this->issue_material_packing->IsDetailKey && $this->issue_material_packing->FormValue != NULL && $this->issue_material_packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_packing->caption(), $this->issue_material_packing->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_qty->Required) {
			if (!$this->issue_material_qty->IsDetailKey && $this->issue_material_qty->FormValue != NULL && $this->issue_material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_qty->caption(), $this->issue_material_qty->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->issue_material_lcgp_rid->Required) {
			if (!$this->issue_material_lcgp_rid->IsDetailKey && $this->issue_material_lcgp_rid->FormValue != NULL && $this->issue_material_lcgp_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_lcgp_rid->caption(), $this->issue_material_lcgp_rid->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_lot_no->Required) {
			if (!$this->issue_material_lot_no->IsDetailKey && $this->issue_material_lot_no->FormValue != NULL && $this->issue_material_lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_lot_no->caption(), $this->issue_material_lot_no->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_godown->Required) {
			if (!$this->issue_material_godown->IsDetailKey && $this->issue_material_godown->FormValue != NULL && $this->issue_material_godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_godown->caption(), $this->issue_material_godown->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->issue_material_godown->FormValue)) {
			AddMessage($FormError, $this->issue_material_godown->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// week
			$this->week->setDbValueDef($rsnew, $this->week->CurrentValue, 0, $this->week->ReadOnly);

			// t_sqm
			$this->t_sqm->setDbValueDef($rsnew, $this->t_sqm->CurrentValue, NULL, $this->t_sqm->ReadOnly);

			// req_material_packing
			$this->req_material_packing->setDbValueDef($rsnew, $this->req_material_packing->CurrentValue, 0, $this->req_material_packing->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// despatch_date
			$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), CurrentDate(), $this->despatch_date->ReadOnly);

			// order_id
			$this->order_id->setDbValueDef($rsnew, $this->order_id->CurrentValue, NULL, $this->order_id->ReadOnly);

			// weaving_works
			$this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, NULL, $this->weaving_works->ReadOnly);

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, 0, $this->company_id->ReadOnly);

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->setDbValueDef($rsnew, $this->issue_material_lcgp_rid->CurrentValue, NULL, $this->issue_material_lcgp_rid->ReadOnly);

			// issue_material_lot_no
			$this->issue_material_lot_no->setDbValueDef($rsnew, $this->issue_material_lot_no->CurrentValue, NULL, $this->issue_material_lot_no->ReadOnly);

			// issue_material_godown
			$this->issue_material_godown->setDbValueDef($rsnew, $this->issue_material_godown->CurrentValue, NULL, $this->issue_material_godown->ReadOnly);

			// Check referential integrity for master table 'required_material_compiled'
			$validMasterRecord = TRUE;
			$masterFilter = $this->sqlMasterFilter_required_material_compiled();
			$keyValue = isset($rsnew['po']) ? $rsnew['po'] : $rsold['po'];
			if (strval($keyValue) <> "") {
				$masterFilter = str_replace("@po@", AdjustSql($keyValue), $masterFilter);
			} else {
				$validMasterRecord = FALSE;
			}
			$keyValue = isset($rsnew['req_material_rid']) ? $rsnew['req_material_rid'] : $rsold['req_material_rid'];
			if (strval($keyValue) <> "") {
				$masterFilter = str_replace("@req_material_rid@", AdjustSql($keyValue), $masterFilter);
			} else {
				$validMasterRecord = FALSE;
			}
			if ($validMasterRecord) {
				if (!isset($GLOBALS["required_material_compiled"]))
					$GLOBALS["required_material_compiled"] = new required_material_compiled();
				$rsmaster = $GLOBALS["required_material_compiled"]->loadRs($masterFilter);
				$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
				$rsmaster->close();
			}
			if (!$validMasterRecord) {
				$relatedRecordMsg = str_replace("%t", "required_material_compiled", $Language->phrase("RelatedRecordRequired"));
				$this->setFailureMessage($relatedRecordMsg);
				$rs->close();
				return FALSE;
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Set up foreign key field value from Session
			if ($this->getCurrentMasterTable() == "required_material_compiled") {
				$this->po->CurrentValue = $this->po->getSessionValue();
				$this->req_material_rid->CurrentValue = $this->req_material_rid->getSessionValue();
			}

		// Check referential integrity for master table 'required_material_compiled'
		$validMasterRecord = TRUE;
		$masterFilter = $this->sqlMasterFilter_required_material_compiled();
		if (strval($this->po->CurrentValue) <> "") {
			$masterFilter = str_replace("@po@", AdjustSql($this->po->CurrentValue, "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if (strval($this->req_material_rid->CurrentValue) <> "") {
			$masterFilter = str_replace("@req_material_rid@", AdjustSql($this->req_material_rid->CurrentValue, "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if ($validMasterRecord) {
			if (!isset($GLOBALS["required_material_compiled"]))
				$GLOBALS["required_material_compiled"] = new required_material_compiled();
			$rsmaster = $GLOBALS["required_material_compiled"]->loadRs($masterFilter);
			$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
			$rsmaster->close();
		}
		if (!$validMasterRecord) {
			$relatedRecordMsg = str_replace("%t", "required_material_compiled", $Language->phrase("RelatedRecordRequired"));
			$this->setFailureMessage($relatedRecordMsg);
			return FALSE;
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// poid
		$this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, 0, FALSE);

		// po
		$this->po->setDbValueDef($rsnew, $this->po->CurrentValue, NULL, FALSE);

		// week
		$this->week->setDbValueDef($rsnew, $this->week->CurrentValue, 0, FALSE);

		// buyer_id
		$this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, 0, FALSE);

		// product_id
		$this->product_id->setDbValueDef($rsnew, $this->product_id->CurrentValue, NULL, FALSE);

		// batch_no
		$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, 0, FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, FALSE);

		// Size_wl
		$this->Size_wl->setDbValueDef($rsnew, $this->Size_wl->CurrentValue, NULL, FALSE);

		// sqm
		$this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, NULL, FALSE);

		// t_sqm
		$this->t_sqm->setDbValueDef($rsnew, $this->t_sqm->CurrentValue, NULL, FALSE);

		// unit
		$this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, NULL, FALSE);

		// material_qty
		$this->material_qty->setDbValueDef($rsnew, $this->material_qty->CurrentValue, NULL, FALSE);

		// method
		$this->method->setDbValueDef($rsnew, $this->method->CurrentValue, NULL, FALSE);

		// despatch_week
		$this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, NULL, FALSE);

		// req_material_rid
		$this->req_material_rid->setDbValueDef($rsnew, $this->req_material_rid->CurrentValue, NULL, FALSE);

		// req_material_packing
		$this->req_material_packing->setDbValueDef($rsnew, $this->req_material_packing->CurrentValue, 0, FALSE);

		// req_material_qty
		$this->req_material_qty->setDbValueDef($rsnew, $this->req_material_qty->CurrentValue, 0, strval($this->req_material_qty->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// despatch_date
		$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), CurrentDate(), FALSE);

		// order_id
		$this->order_id->setDbValueDef($rsnew, $this->order_id->CurrentValue, NULL, FALSE);

		// weaving_works
		$this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, NULL, FALSE);

		// company_id
		$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, 0, FALSE);

		// issue_material_lcgp_rid
		$this->issue_material_lcgp_rid->setDbValueDef($rsnew, $this->issue_material_lcgp_rid->CurrentValue, NULL, FALSE);

		// issue_material_lot_no
		$this->issue_material_lot_no->setDbValueDef($rsnew, $this->issue_material_lot_no->CurrentValue, NULL, FALSE);

		// issue_material_godown
		$this->issue_material_godown->setDbValueDef($rsnew, $this->issue_material_godown->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{

		// Hide foreign keys
		$masterTblVar = $this->getCurrentMasterTable();
		if ($masterTblVar == "required_material_compiled") {
			$this->po->Visible = FALSE;
			if ($GLOBALS["required_material_compiled"]->EventCancelled)
				$this->EventCancelled = TRUE;
			$this->req_material_rid->Visible = FALSE;
			if ($GLOBALS["required_material_compiled"]->EventCancelled)
				$this->EventCancelled = TRUE;
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_product_id":
							break;
						case "x_batch_no":
							break;
						case "x_unit":
							break;
						case "x_method":
							break;
						case "x_despatch_week":
							break;
						case "x_req_material_sgrp":
							break;
						case "x_req_material_product":
							break;
						case "x_req_material_rid":
							break;
						case "x_req_material_packing":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}
}
?>