<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_required_issue_edit extends material_required_issue
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_required_issue';

	// Page object name
	public $PageObjName = "material_required_issue_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_required_issue)
		if (!isset($GLOBALS["material_required_issue"]) || get_class($GLOBALS["material_required_issue"]) == PROJECT_NAMESPACE . "material_required_issue") {
			$GLOBALS["material_required_issue"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_required_issue"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required_issue');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_required_issue;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_required_issue);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "material_required_issueview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("material_required_issuelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->jc_no->setVisibility();
		$this->po->setVisibility();
		$this->week->setVisibility();
		$this->buyer_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_id->setVisibility();
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->req_material_sgrp->setVisibility();
		$this->issue_material_sgrp->setVisibility();
		$this->req_material_product->setVisibility();
		$this->issue_material_product->setVisibility();
		$this->req_material_rid->setVisibility();
		$this->issue_material_rid->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->issue_material_qty->setVisibility();
		$this->material_qty->setVisibility();
		$this->unit->setVisibility();
		$this->method->setVisibility();
		$this->despatch_week->setVisibility();
		$this->production_plan->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->material_out->setVisibility();
		$this->material_out_id->Visible = FALSE;
		$this->size_wl->Visible = FALSE;
		$this->sqm->Visible = FALSE;
		$this->req_material_grp->Visible = FALSE;
		$this->issue_material_grp->Visible = FALSE;
		$this->updated->Visible = FALSE;
		$this->poid->Visible = FALSE;
		$this->issue_to->Visible = FALSE;
		$this->despatch_date->setVisibility();
		$this->issue_material_id->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->jc_no->Required = FALSE;
		$this->week->Required = FALSE;
		$this->buyer_id->Required = FALSE;
		$this->grp->Required = FALSE;
		$this->s_grp->Required = FALSE;
		$this->product->Required = FALSE;
		$this->batch_no->Required = FALSE;
		$this->req_material_qty->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->jc_no);
		$this->setupLookupOptions($this->week);
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_id);
		$this->setupLookupOptions($this->req_material_sgrp);
		$this->setupLookupOptions($this->issue_material_sgrp);
		$this->setupLookupOptions($this->req_material_product);
		$this->setupLookupOptions($this->issue_material_product);
		$this->setupLookupOptions($this->req_material_rid);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->material_out_id);
		$this->setupLookupOptions($this->req_material_grp);
		$this->setupLookupOptions($this->poid);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("material_required_issuelist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = "autoprogramme.php?apcid=69cb3ea317a32c4e6143e665fdb20b14";
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_no->Visible = FALSE; // Disable update for API request
			else
				$this->jc_no->setFormValue($val);
		}

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'week' first before field var 'x_week'
		$val = $CurrentForm->hasValue("week") ? $CurrentForm->getValue("week") : $CurrentForm->getValue("x_week");
		if (!$this->week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->week->Visible = FALSE; // Disable update for API request
			else
				$this->week->setFormValue($val);
		}

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'product_id' first before field var 'x_product_id'
		$val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
		if (!$this->product_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_id->Visible = FALSE; // Disable update for API request
			else
				$this->product_id->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'req_material_sgrp' first before field var 'x_req_material_sgrp'
		$val = $CurrentForm->hasValue("req_material_sgrp") ? $CurrentForm->getValue("req_material_sgrp") : $CurrentForm->getValue("x_req_material_sgrp");
		if (!$this->req_material_sgrp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_sgrp->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_sgrp->setFormValue($val);
		}

		// Check field name 'issue_material_sgrp' first before field var 'x_issue_material_sgrp'
		$val = $CurrentForm->hasValue("issue_material_sgrp") ? $CurrentForm->getValue("issue_material_sgrp") : $CurrentForm->getValue("x_issue_material_sgrp");
		if (!$this->issue_material_sgrp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_sgrp->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_sgrp->setFormValue($val);
		}

		// Check field name 'req_material_product' first before field var 'x_req_material_product'
		$val = $CurrentForm->hasValue("req_material_product") ? $CurrentForm->getValue("req_material_product") : $CurrentForm->getValue("x_req_material_product");
		if (!$this->req_material_product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_product->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_product->setFormValue($val);
		}

		// Check field name 'issue_material_product' first before field var 'x_issue_material_product'
		$val = $CurrentForm->hasValue("issue_material_product") ? $CurrentForm->getValue("issue_material_product") : $CurrentForm->getValue("x_issue_material_product");
		if (!$this->issue_material_product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_product->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_product->setFormValue($val);
		}

		// Check field name 'req_material_rid' first before field var 'x_req_material_rid'
		$val = $CurrentForm->hasValue("req_material_rid") ? $CurrentForm->getValue("req_material_rid") : $CurrentForm->getValue("x_req_material_rid");
		if (!$this->req_material_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_rid->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_rid->setFormValue($val);
		}

		// Check field name 'issue_material_rid' first before field var 'x_issue_material_rid'
		$val = $CurrentForm->hasValue("issue_material_rid") ? $CurrentForm->getValue("issue_material_rid") : $CurrentForm->getValue("x_issue_material_rid");
		if (!$this->issue_material_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_rid->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_rid->setFormValue($val);
		}

		// Check field name 'req_material_qty' first before field var 'x_req_material_qty'
		$val = $CurrentForm->hasValue("req_material_qty") ? $CurrentForm->getValue("req_material_qty") : $CurrentForm->getValue("x_req_material_qty");
		if (!$this->req_material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_qty->setFormValue($val);
		}

		// Check field name 'issue_material_qty' first before field var 'x_issue_material_qty'
		$val = $CurrentForm->hasValue("issue_material_qty") ? $CurrentForm->getValue("issue_material_qty") : $CurrentForm->getValue("x_issue_material_qty");
		if (!$this->issue_material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_qty->setFormValue($val);
		}

		// Check field name 'material_qty' first before field var 'x_material_qty'
		$val = $CurrentForm->hasValue("material_qty") ? $CurrentForm->getValue("material_qty") : $CurrentForm->getValue("x_material_qty");
		if (!$this->material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->material_qty->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name 'method' first before field var 'x_method'
		$val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
		if (!$this->method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->method->Visible = FALSE; // Disable update for API request
			else
				$this->method->setFormValue($val);
		}

		// Check field name 'despatch_week' first before field var 'x_despatch_week'
		$val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
		if (!$this->despatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_week->setFormValue($val);
		}

		// Check field name 'production_plan' first before field var 'x_production_plan'
		$val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
		if (!$this->production_plan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_plan->Visible = FALSE; // Disable update for API request
			else
				$this->production_plan->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'material_out' first before field var 'x_material_out'
		$val = $CurrentForm->hasValue("material_out") ? $CurrentForm->getValue("material_out") : $CurrentForm->getValue("x_material_out");
		if (!$this->material_out->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material_out->Visible = FALSE; // Disable update for API request
			else
				$this->material_out->setFormValue($val);
		}

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}

		// Check field name 'issue_material_id' first before field var 'x_issue_material_id'
		$val = $CurrentForm->hasValue("issue_material_id") ? $CurrentForm->getValue("issue_material_id") : $CurrentForm->getValue("x_issue_material_id");
		if (!$this->issue_material_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_id->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_id->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->jc_no->CurrentValue = $this->jc_no->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->week->CurrentValue = $this->week->FormValue;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->product_id->CurrentValue = $this->product_id->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->req_material_sgrp->CurrentValue = $this->req_material_sgrp->FormValue;
		$this->issue_material_sgrp->CurrentValue = $this->issue_material_sgrp->FormValue;
		$this->req_material_product->CurrentValue = $this->req_material_product->FormValue;
		$this->issue_material_product->CurrentValue = $this->issue_material_product->FormValue;
		$this->req_material_rid->CurrentValue = $this->req_material_rid->FormValue;
		$this->issue_material_rid->CurrentValue = $this->issue_material_rid->FormValue;
		$this->req_material_qty->CurrentValue = $this->req_material_qty->FormValue;
		$this->issue_material_qty->CurrentValue = $this->issue_material_qty->FormValue;
		$this->material_qty->CurrentValue = $this->material_qty->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->method->CurrentValue = $this->method->FormValue;
		$this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
		$this->production_plan->CurrentValue = $this->production_plan->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->material_out->CurrentValue = $this->material_out->FormValue;
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->issue_material_id->CurrentValue = $this->issue_material_id->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->po->setDbValue($row['po']);
		$this->week->setDbValue($row['week']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->product_id->setDbValue($row['product_id']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
		$this->issue_material_sgrp->setDbValue($row['issue_material_sgrp']);
		$this->req_material_product->setDbValue($row['req_material_product']);
		$this->issue_material_product->setDbValue($row['issue_material_product']);
		$this->req_material_rid->setDbValue($row['req_material_rid']);
		$this->issue_material_rid->setDbValue($row['issue_material_rid']);
		$this->req_material_qty->setDbValue($row['req_material_qty']);
		$this->issue_material_qty->setDbValue($row['issue_material_qty']);
		$this->material_qty->setDbValue($row['material_qty']);
		$this->unit->setDbValue($row['unit']);
		$this->method->setDbValue($row['method']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->material_out->setDbValue($row['material_out']);
		$this->material_out_id->setDbValue($row['material_out_id']);
		$this->size_wl->setDbValue($row['size_wl']);
		$this->sqm->setDbValue($row['sqm']);
		$this->req_material_grp->setDbValue($row['req_material_grp']);
		$this->issue_material_grp->setDbValue($row['issue_material_grp']);
		$this->updated->setDbValue($row['updated']);
		$this->poid->setDbValue($row['poid']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->issue_material_id->setDbValue($row['issue_material_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['jc_no'] = NULL;
		$row['po'] = NULL;
		$row['week'] = NULL;
		$row['buyer_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['product_id'] = NULL;
		$row['batch_no'] = NULL;
		$row['quantity'] = NULL;
		$row['req_material_sgrp'] = NULL;
		$row['issue_material_sgrp'] = NULL;
		$row['req_material_product'] = NULL;
		$row['issue_material_product'] = NULL;
		$row['req_material_rid'] = NULL;
		$row['issue_material_rid'] = NULL;
		$row['req_material_qty'] = NULL;
		$row['issue_material_qty'] = NULL;
		$row['material_qty'] = NULL;
		$row['unit'] = NULL;
		$row['method'] = NULL;
		$row['despatch_week'] = NULL;
		$row['production_plan'] = NULL;
		$row['remarks'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['material_out'] = NULL;
		$row['material_out_id'] = NULL;
		$row['size_wl'] = NULL;
		$row['sqm'] = NULL;
		$row['req_material_grp'] = NULL;
		$row['issue_material_grp'] = NULL;
		$row['updated'] = NULL;
		$row['poid'] = NULL;
		$row['issue_to'] = NULL;
		$row['despatch_date'] = NULL;
		$row['issue_material_id'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->issue_material_qty->FormValue == $this->issue_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->issue_material_qty->CurrentValue)))
			$this->issue_material_qty->CurrentValue = ConvertToFloatString($this->issue_material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->material_qty->FormValue == $this->material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->material_qty->CurrentValue)))
			$this->material_qty->CurrentValue = ConvertToFloatString($this->material_qty->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// jc_no
		// po
		// week
		// buyer_id
		// grp
		// s_grp
		// product
		// product_id
		// batch_no
		// quantity
		// req_material_sgrp
		// issue_material_sgrp
		// req_material_product
		// issue_material_product
		// req_material_rid
		// issue_material_rid
		// req_material_qty
		// issue_material_qty
		// material_qty
		// unit
		// method
		// despatch_week
		// production_plan
		// remarks
		// operator
		// datetime
		// material_out
		// material_out_id
		// size_wl
		// sqm
		// req_material_grp
		// issue_material_grp
		// updated
		// poid
		// issue_to
		// despatch_date
		// issue_material_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// jc_no
			$curVal = strval($this->jc_no->CurrentValue);
			if ($curVal <> "") {
				$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
				if ($this->jc_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
					}
				}
			} else {
				$this->jc_no->ViewValue = NULL;
			}
			$this->jc_no->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// week
			$curVal = strval($this->week->CurrentValue);
			if ($curVal <> "") {
				$this->week->ViewValue = $this->week->lookupCacheOption($curVal);
				if ($this->week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->week->ViewValue = $this->week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->week->ViewValue = $this->week->CurrentValue;
					}
				}
			} else {
				$this->week->ViewValue = NULL;
			}
			$this->week->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_id
			$curVal = strval($this->product_id->CurrentValue);
			if ($curVal <> "") {
				$this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
				if ($this->product_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_id->ViewValue = $this->product_id->CurrentValue;
					}
				}
			} else {
				$this->product_id->ViewValue = NULL;
			}
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// req_material_sgrp
			$curVal = strval($this->req_material_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
				if ($this->req_material_sgrp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =2 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
					}
				}
			} else {
				$this->req_material_sgrp->ViewValue = NULL;
			}
			$this->req_material_sgrp->ViewCustomAttributes = "";

			// issue_material_sgrp
			$curVal = strval($this->issue_material_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->lookupCacheOption($curVal);
				if ($this->issue_material_sgrp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->issue_material_sgrp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->CurrentValue;
					}
				}
			} else {
				$this->issue_material_sgrp->ViewValue = NULL;
			}
			$this->issue_material_sgrp->ViewCustomAttributes = "";

			// req_material_product
			$curVal = strval($this->req_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
				if ($this->req_material_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
					}
				}
			} else {
				$this->req_material_product->ViewValue = NULL;
			}
			$this->req_material_product->ViewCustomAttributes = "";

			// issue_material_product
			$curVal = strval($this->issue_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->issue_material_product->ViewValue = $this->issue_material_product->lookupCacheOption($curVal);
				if ($this->issue_material_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_material_product->ViewValue = $this->issue_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_material_product->ViewValue = $this->issue_material_product->CurrentValue;
					}
				}
			} else {
				$this->issue_material_product->ViewValue = NULL;
			}
			$this->issue_material_product->ViewCustomAttributes = "";

			// req_material_rid
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->ViewValue = NULL;
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// issue_material_rid
			$this->issue_material_rid->ViewValue = $this->issue_material_rid->CurrentValue;
			$this->issue_material_rid->ViewValue = FormatNumber($this->issue_material_rid->ViewValue, 0, -2, -2, -2);
			$this->issue_material_rid->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// issue_material_qty
			$this->issue_material_qty->ViewValue = $this->issue_material_qty->CurrentValue;
			$this->issue_material_qty->ViewValue = FormatNumber($this->issue_material_qty->ViewValue, 2, -2, -2, -2);
			$this->issue_material_qty->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
			$this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, 2, -2, -2, -2);
			$this->material_qty->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` = 22";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// material_out
			if (strval($this->material_out->CurrentValue) <> "") {
				$this->material_out->ViewValue = $this->material_out->optionCaption($this->material_out->CurrentValue);
			} else {
				$this->material_out->ViewValue = NULL;
			}
			$this->material_out->ViewCustomAttributes = "";

			// material_out_id
			$curVal = strval($this->material_out_id->CurrentValue);
			if ($curVal <> "") {
				$this->material_out_id->ViewValue = $this->material_out_id->lookupCacheOption($curVal);
				if ($this->material_out_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->material_out_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->material_out_id->ViewValue = $this->material_out_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->material_out_id->ViewValue = $this->material_out_id->CurrentValue;
					}
				}
			} else {
				$this->material_out_id->ViewValue = NULL;
			}
			$this->material_out_id->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// issue_material_id
			$this->issue_material_id->ViewValue = $this->issue_material_id->CurrentValue;
			$this->issue_material_id->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			$this->product_id->HrefValue = "";
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// req_material_sgrp
			$this->req_material_sgrp->LinkCustomAttributes = "";
			$this->req_material_sgrp->HrefValue = "";
			$this->req_material_sgrp->TooltipValue = "";

			// issue_material_sgrp
			$this->issue_material_sgrp->LinkCustomAttributes = "";
			$this->issue_material_sgrp->HrefValue = "";
			$this->issue_material_sgrp->TooltipValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// issue_material_product
			$this->issue_material_product->LinkCustomAttributes = "";
			$this->issue_material_product->HrefValue = "";
			$this->issue_material_product->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// issue_material_rid
			$this->issue_material_rid->LinkCustomAttributes = "";
			$this->issue_material_rid->HrefValue = "";
			$this->issue_material_rid->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// issue_material_qty
			$this->issue_material_qty->LinkCustomAttributes = "";
			$this->issue_material_qty->HrefValue = "";
			$this->issue_material_qty->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// material_out
			$this->material_out->LinkCustomAttributes = "";
			$this->material_out->HrefValue = "";
			$this->material_out->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// issue_material_id
			$this->issue_material_id->LinkCustomAttributes = "";
			$this->issue_material_id->HrefValue = "";
			$this->issue_material_id->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$curVal = strval($this->jc_no->CurrentValue);
			if ($curVal <> "") {
				$this->jc_no->EditValue = $this->jc_no->lookupCacheOption($curVal);
				if ($this->jc_no->EditValue === NULL) { // Lookup from database
					$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->jc_no->EditValue = $this->jc_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->jc_no->EditValue = $this->jc_no->CurrentValue;
					}
				}
			} else {
				$this->jc_no->EditValue = NULL;
			}
			$this->jc_no->ViewCustomAttributes = "";

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = $this->po->CurrentValue;
			$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// week
			$this->week->EditAttrs["class"] = "form-control";
			$this->week->EditCustomAttributes = "";
			$curVal = strval($this->week->CurrentValue);
			if ($curVal <> "") {
				$this->week->EditValue = $this->week->lookupCacheOption($curVal);
				if ($this->week->EditValue === NULL) { // Lookup from database
					$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->week->EditValue = $this->week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->week->EditValue = $this->week->CurrentValue;
					}
				}
			} else {
				$this->week->EditValue = NULL;
			}
			$this->week->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->EditValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->EditValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_id
			$this->product_id->EditAttrs["class"] = "form-control";
			$this->product_id->EditCustomAttributes = "";
			$curVal = strval($this->product_id->CurrentValue);
			if ($curVal <> "") {
				$this->product_id->EditValue = $this->product_id->lookupCacheOption($curVal);
				if ($this->product_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_id->EditValue = $this->product_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_id->EditValue = $this->product_id->CurrentValue;
					}
				}
			} else {
				$this->product_id->EditValue = NULL;
			}
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$this->batch_no->EditValue = $this->batch_no->CurrentValue;
			$this->batch_no->EditValue = FormatNumber($this->batch_no->EditValue, 0, -2, -2, -2);
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// req_material_sgrp
			$this->req_material_sgrp->EditAttrs["class"] = "form-control";
			$this->req_material_sgrp->EditCustomAttributes = "";
			$curVal = strval($this->req_material_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_sgrp->EditValue = $this->req_material_sgrp->lookupCacheOption($curVal);
				if ($this->req_material_sgrp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =2 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_sgrp->EditValue = $this->req_material_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_sgrp->EditValue = $this->req_material_sgrp->CurrentValue;
					}
				}
			} else {
				$this->req_material_sgrp->EditValue = NULL;
			}
			$this->req_material_sgrp->ViewCustomAttributes = "";

			// issue_material_sgrp
			$this->issue_material_sgrp->EditAttrs["class"] = "form-control";
			$this->issue_material_sgrp->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_material_sgrp->CurrentValue));
			if ($curVal <> "")
				$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->lookupCacheOption($curVal);
			else
				$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->Lookup !== NULL && is_array($this->issue_material_sgrp->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_material_sgrp->ViewValue !== NULL) { // Load from cache
				$this->issue_material_sgrp->EditValue = array_values($this->issue_material_sgrp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_material_sgrp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->issue_material_sgrp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_material_sgrp->EditValue = $arwrk;
			}

			// req_material_product
			$this->req_material_product->EditAttrs["class"] = "form-control";
			$this->req_material_product->EditCustomAttributes = "";
			$curVal = strval($this->req_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_product->EditValue = $this->req_material_product->lookupCacheOption($curVal);
				if ($this->req_material_product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_product->EditValue = $this->req_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_product->EditValue = $this->req_material_product->CurrentValue;
					}
				}
			} else {
				$this->req_material_product->EditValue = NULL;
			}
			$this->req_material_product->ViewCustomAttributes = "";

			// issue_material_product
			$this->issue_material_product->EditAttrs["class"] = "form-control";
			$this->issue_material_product->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_material_product->CurrentValue));
			if ($curVal <> "")
				$this->issue_material_product->ViewValue = $this->issue_material_product->lookupCacheOption($curVal);
			else
				$this->issue_material_product->ViewValue = $this->issue_material_product->Lookup !== NULL && is_array($this->issue_material_product->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_material_product->ViewValue !== NULL) { // Load from cache
				$this->issue_material_product->EditValue = array_values($this->issue_material_product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_material_product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_material_product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_material_product->EditValue = $arwrk;
			}

			// req_material_rid
			$this->req_material_rid->EditAttrs["class"] = "form-control";
			$this->req_material_rid->EditCustomAttributes = "";
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->EditValue = NULL;
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// issue_material_rid
			$this->issue_material_rid->EditAttrs["class"] = "form-control";
			$this->issue_material_rid->EditCustomAttributes = "";
			$this->issue_material_rid->EditValue = HtmlEncode($this->issue_material_rid->CurrentValue);
			$this->issue_material_rid->PlaceHolder = RemoveHtml($this->issue_material_rid->caption());

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// issue_material_qty
			$this->issue_material_qty->EditAttrs["class"] = "form-control";
			$this->issue_material_qty->EditCustomAttributes = "";
			$this->issue_material_qty->EditValue = HtmlEncode($this->issue_material_qty->CurrentValue);
			$this->issue_material_qty->PlaceHolder = RemoveHtml($this->issue_material_qty->caption());
			if (strval($this->issue_material_qty->EditValue) <> "" && is_numeric($this->issue_material_qty->EditValue))
				$this->issue_material_qty->EditValue = FormatNumber($this->issue_material_qty->EditValue, -2, -2, -2, -2);

			// material_qty
			$this->material_qty->EditAttrs["class"] = "form-control";
			$this->material_qty->EditCustomAttributes = "";
			$this->material_qty->EditValue = $this->material_qty->CurrentValue;
			$this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, 2, -2, -2, -2);
			$this->material_qty->ViewCustomAttributes = "";

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->unit->EditValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->EditValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->EditValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->EditValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` = 22";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->EditValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->EditValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->EditValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->EditValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->EditValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->EditValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// operator
			// datetime
			// material_out

			$this->material_out->EditCustomAttributes = "";
			$this->material_out->EditValue = $this->material_out->options(FALSE);

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// issue_material_id
			$this->issue_material_id->EditAttrs["class"] = "form-control";
			$this->issue_material_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->issue_material_id->CurrentValue = HtmlDecode($this->issue_material_id->CurrentValue);
			$this->issue_material_id->EditValue = HtmlEncode($this->issue_material_id->CurrentValue);
			$this->issue_material_id->PlaceHolder = RemoveHtml($this->issue_material_id->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			$this->product_id->HrefValue = "";
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// req_material_sgrp
			$this->req_material_sgrp->LinkCustomAttributes = "";
			$this->req_material_sgrp->HrefValue = "";
			$this->req_material_sgrp->TooltipValue = "";

			// issue_material_sgrp
			$this->issue_material_sgrp->LinkCustomAttributes = "";
			$this->issue_material_sgrp->HrefValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// issue_material_product
			$this->issue_material_product->LinkCustomAttributes = "";
			$this->issue_material_product->HrefValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// issue_material_rid
			$this->issue_material_rid->LinkCustomAttributes = "";
			$this->issue_material_rid->HrefValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// issue_material_qty
			$this->issue_material_qty->LinkCustomAttributes = "";
			$this->issue_material_qty->HrefValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// material_out
			$this->material_out->LinkCustomAttributes = "";
			$this->material_out->HrefValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// issue_material_id
			$this->issue_material_id->LinkCustomAttributes = "";
			$this->issue_material_id->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->week->Required) {
			if (!$this->week->IsDetailKey && $this->week->FormValue != NULL && $this->week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->week->caption(), $this->week->RequiredErrorMessage));
			}
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->product_id->Required) {
			if (!$this->product_id->IsDetailKey && $this->product_id->FormValue != NULL && $this->product_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->req_material_sgrp->Required) {
			if (!$this->req_material_sgrp->IsDetailKey && $this->req_material_sgrp->FormValue != NULL && $this->req_material_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_sgrp->caption(), $this->req_material_sgrp->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_sgrp->Required) {
			if (!$this->issue_material_sgrp->IsDetailKey && $this->issue_material_sgrp->FormValue != NULL && $this->issue_material_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_sgrp->caption(), $this->issue_material_sgrp->RequiredErrorMessage));
			}
		}
		if ($this->req_material_product->Required) {
			if (!$this->req_material_product->IsDetailKey && $this->req_material_product->FormValue != NULL && $this->req_material_product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_product->caption(), $this->req_material_product->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_product->Required) {
			if (!$this->issue_material_product->IsDetailKey && $this->issue_material_product->FormValue != NULL && $this->issue_material_product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_product->caption(), $this->issue_material_product->RequiredErrorMessage));
			}
		}
		if ($this->req_material_rid->Required) {
			if (!$this->req_material_rid->IsDetailKey && $this->req_material_rid->FormValue != NULL && $this->req_material_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_rid->caption(), $this->req_material_rid->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_rid->Required) {
			if (!$this->issue_material_rid->IsDetailKey && $this->issue_material_rid->FormValue != NULL && $this->issue_material_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_rid->caption(), $this->issue_material_rid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->issue_material_rid->FormValue)) {
			AddMessage($FormError, $this->issue_material_rid->errorMessage());
		}
		if ($this->req_material_qty->Required) {
			if (!$this->req_material_qty->IsDetailKey && $this->req_material_qty->FormValue != NULL && $this->req_material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_qty->caption(), $this->req_material_qty->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_qty->Required) {
			if (!$this->issue_material_qty->IsDetailKey && $this->issue_material_qty->FormValue != NULL && $this->issue_material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_qty->caption(), $this->issue_material_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->issue_material_qty->FormValue)) {
			AddMessage($FormError, $this->issue_material_qty->errorMessage());
		}
		if ($this->material_qty->Required) {
			if (!$this->material_qty->IsDetailKey && $this->material_qty->FormValue != NULL && $this->material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_qty->caption(), $this->material_qty->RequiredErrorMessage));
			}
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->method->Required) {
			if (!$this->method->IsDetailKey && $this->method->FormValue != NULL && $this->method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
			}
		}
		if ($this->despatch_week->Required) {
			if (!$this->despatch_week->IsDetailKey && $this->despatch_week->FormValue != NULL && $this->despatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
			}
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->material_out->Required) {
			if ($this->material_out->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_out->caption(), $this->material_out->RequiredErrorMessage));
			}
		}
		if ($this->material_out_id->Required) {
			if (!$this->material_out_id->IsDetailKey && $this->material_out_id->FormValue != NULL && $this->material_out_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_out_id->caption(), $this->material_out_id->RequiredErrorMessage));
			}
		}
		if ($this->size_wl->Required) {
			if (!$this->size_wl->IsDetailKey && $this->size_wl->FormValue != NULL && $this->size_wl->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size_wl->caption(), $this->size_wl->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->req_material_grp->Required) {
			if (!$this->req_material_grp->IsDetailKey && $this->req_material_grp->FormValue != NULL && $this->req_material_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_grp->caption(), $this->req_material_grp->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_grp->Required) {
			if (!$this->issue_material_grp->IsDetailKey && $this->issue_material_grp->FormValue != NULL && $this->issue_material_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_grp->caption(), $this->issue_material_grp->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if ($this->poid->Required) {
			if (!$this->poid->IsDetailKey && $this->poid->FormValue != NULL && $this->poid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
			}
		}
		if ($this->issue_to->Required) {
			if (!$this->issue_to->IsDetailKey && $this->issue_to->FormValue != NULL && $this->issue_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
			}
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_date->FormValue)) {
			AddMessage($FormError, $this->despatch_date->errorMessage());
		}
		if ($this->issue_material_id->Required) {
			if (!$this->issue_material_id->IsDetailKey && $this->issue_material_id->FormValue != NULL && $this->issue_material_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_id->caption(), $this->issue_material_id->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// quantity
			$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, $this->quantity->ReadOnly);

			// issue_material_sgrp
			$this->issue_material_sgrp->setDbValueDef($rsnew, $this->issue_material_sgrp->CurrentValue, 0, $this->issue_material_sgrp->ReadOnly);

			// issue_material_product
			$this->issue_material_product->setDbValueDef($rsnew, $this->issue_material_product->CurrentValue, 0, $this->issue_material_product->ReadOnly);

			// issue_material_rid
			$this->issue_material_rid->setDbValueDef($rsnew, $this->issue_material_rid->CurrentValue, NULL, $this->issue_material_rid->ReadOnly);

			// issue_material_qty
			$this->issue_material_qty->setDbValueDef($rsnew, $this->issue_material_qty->CurrentValue, NULL, $this->issue_material_qty->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// material_out
			$this->material_out->setDbValueDef($rsnew, $this->material_out->CurrentValue, 0, $this->material_out->ReadOnly);

			// despatch_date
			$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), CurrentDate(), $this->despatch_date->ReadOnly);

			// issue_material_id
			$this->issue_material_id->setDbValueDef($rsnew, $this->issue_material_id->CurrentValue, "", $this->issue_material_id->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("material_required_issuelist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_s_grp":
					$lookupFilter = function() {
						return "`grp` =2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`grp` = 2 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_sgrp":
					$lookupFilter = function() {
						return "`grp` =2 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_material_product":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_unit":
					$lookupFilter = function() {
						return "`grp` =11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`id` = 22";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_grp":
					$lookupFilter = function() {
						return "`grp`  =2 and`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_jc_no":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_week":
							break;
						case "x_buyer_id":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_product_id":
							break;
						case "x_req_material_sgrp":
							break;
						case "x_issue_material_sgrp":
							break;
						case "x_req_material_product":
							break;
						case "x_issue_material_product":
							break;
						case "x_req_material_rid":
							break;
						case "x_unit":
							break;
						case "x_method":
							break;
						case "x_despatch_week":
							break;
						case "x_operator":
							break;
						case "x_material_out_id":
							break;
						case "x_req_material_grp":
							break;
						case "x_poid":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>