<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for material_required_issue_fp
 */
class material_required_issue_fp extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $jc_no;
	public $po;
	public $poid;
	public $week;
	public $buyer_id;
	public $grp;
	public $s_grp;
	public $product;
	public $product_id;
	public $batch_no;
	public $quantity;
	public $req_material_sgrp;
	public $issue_material_sgrp;
	public $req_material_product;
	public $issue_material_product;
	public $req_material_rid;
	public $issue_material_rid;
	public $issue_material_id;
	public $req_material_qty;
	public $issue_material_qty;
	public $material_qty;
	public $unit;
	public $method;
	public $despatch_week;
	public $despatch_date;
	public $production_plan;
	public $remarks;
	public $updated;
	public $operator;
	public $datetime;
	public $material_out;
	public $material_out_id;
	public $issue_to;
	public $size_wl;
	public $sqm;
	public $req_material_grp;
	public $issue_material_grp;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'material_required_issue_fp';
		$this->TableName = 'material_required_issue_fp';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`material_required_issue_fp`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// jc_no
		$this->jc_no = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 19, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Required = TRUE; // Required field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->jc_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->jc_no->Lookup = new Lookup('jc_no', 'job_card', FALSE, 'jc_no', ["jc_no","","",""], [], [], [], [], [], [], '`jc_no` ASC', '');
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// po
		$this->po = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// poid
		$this->poid = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_poid', 'poid', '`poid`', '`poid`', 18, -1, FALSE, '`poid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->poid->Nullable = FALSE; // NOT NULL field
		$this->poid->Required = TRUE; // Required field
		$this->poid->Sortable = FALSE; // Allow sort
		$this->poid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->poid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->poid->Lookup = new Lookup('poid', 'po_fp', FALSE, 'id', ["id","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->poid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['poid'] = &$this->poid;

		// week
		$this->week = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_week', 'week', '`week`', '`week`', 18, -1, FALSE, '`week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->week->Nullable = FALSE; // NOT NULL field
		$this->week->Required = TRUE; // Required field
		$this->week->Sortable = TRUE; // Allow sort
		$this->week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->week->Lookup = new Lookup('week', 'not_week', FALSE, 'wid', ["week","","",""], [], [], [], [], [], [], '`week` ASC', '');
		$this->week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['week'] = &$this->week;

		// buyer_id
		$this->buyer_id = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 17, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_id->Nullable = FALSE; // NOT NULL field
		$this->buyer_id->Required = TRUE; // Required field
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_id->Lookup = new Lookup('buyer_id', 'buyer', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// grp
		$this->grp = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'material_required_issue_fp', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->grp->OptionCount = 1;
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], [], [], [], [], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product_f_fp', FALSE, 'id', ["product","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// product_id
		$this->product_id = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_product_id', 'product_id', '`product_id`', '`product_id`', 18, -1, FALSE, '`product_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_id->Sortable = TRUE; // Allow sort
		$this->product_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_id->Lookup = new Lookup('product_id', 'ref_fp', FALSE, 'id', ["gcode","","",""], [], ["x_material_out_id"], [], [], [], [], '`gcode` ASC', '');
		$this->product_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_id'] = &$this->product_id;

		// batch_no
		$this->batch_no = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Nullable = FALSE; // NOT NULL field
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// quantity
		$this->quantity = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// req_material_sgrp
		$this->req_material_sgrp = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_req_material_sgrp', 'req_material_sgrp', '`req_material_sgrp`', '`req_material_sgrp`', 18, -1, FALSE, '`req_material_sgrp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_sgrp->Sortable = TRUE; // Allow sort
		$this->req_material_sgrp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_sgrp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_sgrp->Lookup = new Lookup('req_material_sgrp', 'product_group', FALSE, 'id', ["product_group","","",""], [], [], [], [], [], [], '`product_group` ASC', '');
		$this->req_material_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_sgrp'] = &$this->req_material_sgrp;

		// issue_material_sgrp
		$this->issue_material_sgrp = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_issue_material_sgrp', 'issue_material_sgrp', '`issue_material_sgrp`', '`issue_material_sgrp`', 18, -1, FALSE, '`issue_material_sgrp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_material_sgrp->Nullable = FALSE; // NOT NULL field
		$this->issue_material_sgrp->Required = TRUE; // Required field
		$this->issue_material_sgrp->Sortable = TRUE; // Allow sort
		$this->issue_material_sgrp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_material_sgrp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_material_sgrp->Lookup = new Lookup('issue_material_sgrp', 'product_group', FALSE, 'id', ["product_group","","",""], [], ["x_issue_material_product"], [], [], [], [], '`product_group` ASC', '');
		$this->issue_material_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_material_sgrp'] = &$this->issue_material_sgrp;

		// req_material_product
		$this->req_material_product = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_req_material_product', 'req_material_product', '`req_material_product`', '`req_material_product`', 18, -1, FALSE, '`req_material_product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_product->Sortable = TRUE; // Allow sort
		$this->req_material_product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_product->Lookup = new Lookup('req_material_product', 'product_f_fp', FALSE, 'id', ["product","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->req_material_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_product'] = &$this->req_material_product;

		// issue_material_product
		$this->issue_material_product = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_issue_material_product', 'issue_material_product', '`issue_material_product`', '`issue_material_product`', 18, -1, FALSE, '`issue_material_product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_material_product->Nullable = FALSE; // NOT NULL field
		$this->issue_material_product->Required = TRUE; // Required field
		$this->issue_material_product->Sortable = TRUE; // Allow sort
		$this->issue_material_product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_material_product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_material_product->Lookup = new Lookup('issue_material_product', 'product_f_fp', FALSE, 'id', ["product","","",""], ["x_issue_material_sgrp"], [], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->issue_material_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_material_product'] = &$this->issue_material_product;

		// req_material_rid
		$this->req_material_rid = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_req_material_rid', 'req_material_rid', '`req_material_rid`', '`req_material_rid`', 18, -1, FALSE, '`req_material_rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_rid->Sortable = TRUE; // Allow sort
		$this->req_material_rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_rid->Lookup = new Lookup('req_material_rid', 'ref_f_fp', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_rid'] = &$this->req_material_rid;

		// issue_material_rid
		$this->issue_material_rid = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_issue_material_rid', 'issue_material_rid', '`issue_material_rid`', '`issue_material_rid`', 2, -1, FALSE, '`issue_material_rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->issue_material_rid->Sortable = TRUE; // Allow sort
		$this->issue_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_material_rid'] = &$this->issue_material_rid;

		// issue_material_id
		$this->issue_material_id = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_issue_material_id', 'issue_material_id', '`issue_material_id`', '`issue_material_id`', 200, -1, FALSE, '`issue_material_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->issue_material_id->Nullable = FALSE; // NOT NULL field
		$this->issue_material_id->Required = TRUE; // Required field
		$this->issue_material_id->Sortable = FALSE; // Allow sort
		$this->fields['issue_material_id'] = &$this->issue_material_id;

		// req_material_qty
		$this->req_material_qty = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_req_material_qty', 'req_material_qty', '`req_material_qty`', '`req_material_qty`', 4, -1, FALSE, '`req_material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_qty->Nullable = FALSE; // NOT NULL field
		$this->req_material_qty->Required = TRUE; // Required field
		$this->req_material_qty->Sortable = TRUE; // Allow sort
		$this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['req_material_qty'] = &$this->req_material_qty;

		// issue_material_qty
		$this->issue_material_qty = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_issue_material_qty', 'issue_material_qty', '`issue_material_qty`', '`issue_material_qty`', 4, -1, FALSE, '`issue_material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->issue_material_qty->Sortable = TRUE; // Allow sort
		$this->issue_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['issue_material_qty'] = &$this->issue_material_qty;

		// material_qty
		$this->material_qty = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_material_qty', 'material_qty', '`material_qty`', '`material_qty`', 131, -1, FALSE, '`material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->material_qty->Sortable = TRUE; // Allow sort
		$this->material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['material_qty'] = &$this->material_qty;

		// unit
		$this->unit = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_unit', 'unit', '`unit`', '`unit`', 200, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->unit->Lookup = new Lookup('unit', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['unit'] = &$this->unit;

		// method
		$this->method = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_method', 'method', '`method`', '`method`', 17, -1, FALSE, '`method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->method->Sortable = TRUE; // Allow sort
		$this->method->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->method->Lookup = new Lookup('method', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['method'] = &$this->method;

		// despatch_week
		$this->despatch_week = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, -1, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`wsd` ASC', '');
		$this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['despatch_week'] = &$this->despatch_week;

		// despatch_date
		$this->despatch_date = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Nullable = FALSE; // NOT NULL field
		$this->despatch_date->Required = TRUE; // Required field
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// production_plan
		$this->production_plan = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_production_plan', 'production_plan', '`production_plan`', '`production_plan`', 18, -1, FALSE, '`production_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->production_plan->Sortable = TRUE; // Allow sort
		$this->production_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->production_plan->Lookup = new Lookup('production_plan', 'material_required_issue_fp', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->production_plan->OptionCount = 6;
		$this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_plan'] = &$this->production_plan;

		// remarks
		$this->remarks = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Nullable = FALSE; // NOT NULL field
		$this->remarks->Required = TRUE; // Required field
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// updated
		$this->updated = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_updated', 'updated', '`updated`', '`updated`', 16, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Nullable = FALSE; // NOT NULL field
		$this->updated->Required = TRUE; // Required field
		$this->updated->Sortable = FALSE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;

		// operator
		$this->operator = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// material_out
		$this->material_out = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_material_out', 'material_out', '`material_out`', '`material_out`', 17, -1, FALSE, '`material_out`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->material_out->Nullable = FALSE; // NOT NULL field
		$this->material_out->Required = TRUE; // Required field
		$this->material_out->Sortable = TRUE; // Allow sort
		$this->material_out->Lookup = new Lookup('material_out', 'material_required_issue_fp', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->material_out->OptionCount = 3;
		$this->material_out->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['material_out'] = &$this->material_out;

		// material_out_id
		$this->material_out_id = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_material_out_id', 'material_out_id', '`material_out_id`', '`material_out_id`', 19, -1, FALSE, '`material_out_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->material_out_id->Nullable = FALSE; // NOT NULL field
		$this->material_out_id->Required = TRUE; // Required field
		$this->material_out_id->Sortable = TRUE; // Allow sort
		$this->material_out_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->material_out_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->material_out_id->Lookup = new Lookup('material_out_id', 'material_out_fp', FALSE, 'id', ["id","","",""], ["x_product_id"], [], ["rid"], ["x_rid"], [], [], '`id` ASC', '');
		$this->material_out_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['material_out_id'] = &$this->material_out_id;

		// issue_to
		$this->issue_to = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 2, -1, FALSE, '`issue_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to->Nullable = FALSE; // NOT NULL field
		$this->issue_to->Required = TRUE; // Required field
		$this->issue_to->Sortable = FALSE; // Allow sort
		$this->issue_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to->Lookup = new Lookup('issue_to', 'godown_table', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to'] = &$this->issue_to;

		// size_wl
		$this->size_wl = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_size_wl', 'size_wl', '`size_wl`', '`size_wl`', 200, -1, FALSE, '`size_wl`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_wl->Sortable = FALSE; // Allow sort
		$this->fields['size_wl'] = &$this->size_wl;

		// sqm
		$this->sqm = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = FALSE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// req_material_grp
		$this->req_material_grp = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_req_material_grp', 'req_material_grp', '`req_material_grp`', '`req_material_grp`', 18, -1, FALSE, '`req_material_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_grp->Nullable = FALSE; // NOT NULL field
		$this->req_material_grp->Required = TRUE; // Required field
		$this->req_material_grp->Sortable = FALSE; // Allow sort
		$this->req_material_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_grp->Lookup = new Lookup('req_material_grp', 'product_group', FALSE, 'id', ["product_group","","",""], [], [], [], [], [], [], '`product_group` ASC', '');
		$this->req_material_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_grp'] = &$this->req_material_grp;

		// issue_material_grp
		$this->issue_material_grp = new DbField('material_required_issue_fp', 'material_required_issue_fp', 'x_issue_material_grp', 'issue_material_grp', '`issue_material_grp`', '`issue_material_grp`', 18, -1, FALSE, '`issue_material_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_material_grp->Nullable = FALSE; // NOT NULL field
		$this->issue_material_grp->Required = TRUE; // Required field
		$this->issue_material_grp->Sortable = FALSE; // Allow sort
		$this->issue_material_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_material_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_material_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_material_grp'] = &$this->issue_material_grp;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`material_required_issue_fp`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->po->DbValue = $row['po'];
		$this->poid->DbValue = $row['poid'];
		$this->week->DbValue = $row['week'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->product_id->DbValue = $row['product_id'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->quantity->DbValue = $row['quantity'];
		$this->req_material_sgrp->DbValue = $row['req_material_sgrp'];
		$this->issue_material_sgrp->DbValue = $row['issue_material_sgrp'];
		$this->req_material_product->DbValue = $row['req_material_product'];
		$this->issue_material_product->DbValue = $row['issue_material_product'];
		$this->req_material_rid->DbValue = $row['req_material_rid'];
		$this->issue_material_rid->DbValue = $row['issue_material_rid'];
		$this->issue_material_id->DbValue = $row['issue_material_id'];
		$this->req_material_qty->DbValue = $row['req_material_qty'];
		$this->issue_material_qty->DbValue = $row['issue_material_qty'];
		$this->material_qty->DbValue = $row['material_qty'];
		$this->unit->DbValue = $row['unit'];
		$this->method->DbValue = $row['method'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->production_plan->DbValue = $row['production_plan'];
		$this->remarks->DbValue = $row['remarks'];
		$this->updated->DbValue = $row['updated'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->material_out->DbValue = $row['material_out'];
		$this->material_out_id->DbValue = $row['material_out_id'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->size_wl->DbValue = $row['size_wl'];
		$this->sqm->DbValue = $row['sqm'];
		$this->req_material_grp->DbValue = $row['req_material_grp'];
		$this->issue_material_grp->DbValue = $row['issue_material_grp'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "material_required_issue_fplist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "material_required_issue_fpview.php")
			return $Language->phrase("View");
		elseif ($pageName == "material_required_issue_fpedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "material_required_issue_fpadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "material_required_issue_fplist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("material_required_issue_fpview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("material_required_issue_fpview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "material_required_issue_fpadd.php?" . $this->getUrlParm($parm);
		else
			$url = "material_required_issue_fpadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("material_required_issue_fpedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("material_required_issue_fpadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("material_required_issue_fpdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->po->setDbValue($rs->fields('po'));
		$this->poid->setDbValue($rs->fields('poid'));
		$this->week->setDbValue($rs->fields('week'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->product_id->setDbValue($rs->fields('product_id'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->req_material_sgrp->setDbValue($rs->fields('req_material_sgrp'));
		$this->issue_material_sgrp->setDbValue($rs->fields('issue_material_sgrp'));
		$this->req_material_product->setDbValue($rs->fields('req_material_product'));
		$this->issue_material_product->setDbValue($rs->fields('issue_material_product'));
		$this->req_material_rid->setDbValue($rs->fields('req_material_rid'));
		$this->issue_material_rid->setDbValue($rs->fields('issue_material_rid'));
		$this->issue_material_id->setDbValue($rs->fields('issue_material_id'));
		$this->req_material_qty->setDbValue($rs->fields('req_material_qty'));
		$this->issue_material_qty->setDbValue($rs->fields('issue_material_qty'));
		$this->material_qty->setDbValue($rs->fields('material_qty'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->method->setDbValue($rs->fields('method'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->production_plan->setDbValue($rs->fields('production_plan'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->updated->setDbValue($rs->fields('updated'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->material_out->setDbValue($rs->fields('material_out'));
		$this->material_out_id->setDbValue($rs->fields('material_out_id'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->size_wl->setDbValue($rs->fields('size_wl'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->req_material_grp->setDbValue($rs->fields('req_material_grp'));
		$this->issue_material_grp->setDbValue($rs->fields('issue_material_grp'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// jc_no
		// po
		// poid
		// week
		// buyer_id
		// grp
		// s_grp
		// product
		// product_id
		// batch_no
		// quantity
		// req_material_sgrp
		// issue_material_sgrp
		// req_material_product
		// issue_material_product
		// req_material_rid
		// issue_material_rid
		// issue_material_id

		$this->issue_material_id->CellCssStyle = "white-space: nowrap;";

		// req_material_qty
		// issue_material_qty
		// material_qty
		// unit
		// method
		// despatch_week
		// despatch_date
		// production_plan
		// remarks
		// updated
		// operator
		// datetime
		// material_out
		// material_out_id
		// issue_to

		$this->issue_to->CellCssStyle = "white-space: nowrap;";

		// size_wl
		$this->size_wl->CellCssStyle = "white-space: nowrap;";

		// sqm
		$this->sqm->CellCssStyle = "white-space: nowrap;";

		// req_material_grp
		$this->req_material_grp->CellCssStyle = "white-space: nowrap;";

		// issue_material_grp
		$this->issue_material_grp->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// jc_no
		$curVal = strval($this->jc_no->CurrentValue);
		if ($curVal <> "") {
			$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
			if ($this->jc_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
				}
			}
		} else {
			$this->jc_no->ViewValue = NULL;
		}
		$this->jc_no->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// poid
		$curVal = strval($this->poid->CurrentValue);
		if ($curVal <> "") {
			$this->poid->ViewValue = $this->poid->lookupCacheOption($curVal);
			if ($this->poid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->poid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->poid->ViewValue = $this->poid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->poid->ViewValue = $this->poid->CurrentValue;
				}
			}
		} else {
			$this->poid->ViewValue = NULL;
		}
		$this->poid->ViewCustomAttributes = "";

		// week
		$curVal = strval($this->week->CurrentValue);
		if ($curVal <> "") {
			$this->week->ViewValue = $this->week->lookupCacheOption($curVal);
			if ($this->week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->week->ViewValue = $this->week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->week->ViewValue = $this->week->CurrentValue;
				}
			}
		} else {
			$this->week->ViewValue = NULL;
		}
		$this->week->ViewCustomAttributes = "";

		// buyer_id
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->ViewValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// grp
		if (strval($this->grp->CurrentValue) <> "") {
			$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` =2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// product_id
		$curVal = strval($this->product_id->CurrentValue);
		if ($curVal <> "") {
			$this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
			if ($this->product_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_id->ViewValue = $this->product_id->CurrentValue;
				}
			}
		} else {
			$this->product_id->ViewValue = NULL;
		}
		$this->product_id->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
		$this->batch_no->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// req_material_sgrp
		$curVal = strval($this->req_material_sgrp->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
			if ($this->req_material_sgrp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "FIND_IN_SET(`grp`, '0,1,2')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
				}
			}
		} else {
			$this->req_material_sgrp->ViewValue = NULL;
		}
		$this->req_material_sgrp->ViewCustomAttributes = "";

		// issue_material_sgrp
		$curVal = strval($this->issue_material_sgrp->CurrentValue);
		if ($curVal <> "") {
			$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->lookupCacheOption($curVal);
			if ($this->issue_material_sgrp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "FIND_IN_SET(`grp`, '0,1,2')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_material_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->CurrentValue;
				}
			}
		} else {
			$this->issue_material_sgrp->ViewValue = NULL;
		}
		$this->issue_material_sgrp->ViewCustomAttributes = "";

		// req_material_product
		$curVal = strval($this->req_material_product->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
			if ($this->req_material_product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
				}
			}
		} else {
			$this->req_material_product->ViewValue = NULL;
		}
		$this->req_material_product->ViewCustomAttributes = "";

		// issue_material_product
		$curVal = strval($this->issue_material_product->CurrentValue);
		if ($curVal <> "") {
			$this->issue_material_product->ViewValue = $this->issue_material_product->lookupCacheOption($curVal);
			if ($this->issue_material_product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->issue_material_product->ViewValue = $this->issue_material_product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_material_product->ViewValue = $this->issue_material_product->CurrentValue;
				}
			}
		} else {
			$this->issue_material_product->ViewValue = NULL;
		}
		$this->issue_material_product->ViewCustomAttributes = "";

		// req_material_rid
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->ViewValue = NULL;
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// issue_material_rid
		$this->issue_material_rid->ViewValue = $this->issue_material_rid->CurrentValue;
		$this->issue_material_rid->ViewValue = FormatNumber($this->issue_material_rid->ViewValue, 0, -2, -2, -2);
		$this->issue_material_rid->ViewCustomAttributes = "";

		// issue_material_id
		$this->issue_material_id->ViewValue = $this->issue_material_id->CurrentValue;
		$this->issue_material_id->ViewCustomAttributes = "";

		// req_material_qty
		$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
		$this->req_material_qty->ViewCustomAttributes = "";

		// issue_material_qty
		$this->issue_material_qty->ViewValue = $this->issue_material_qty->CurrentValue;
		$this->issue_material_qty->ViewValue = FormatNumber($this->issue_material_qty->ViewValue, 2, -2, -2, -2);
		$this->issue_material_qty->ViewCustomAttributes = "";

		// material_qty
		$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
		$this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, 2, -2, -2, -2);
		$this->material_qty->ViewCustomAttributes = "";

		// unit
		$curVal = strval($this->unit->CurrentValue);
		if ($curVal <> "") {
			$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
			if ($this->unit->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` =11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->unit->ViewValue = $this->unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->unit->ViewValue = $this->unit->CurrentValue;
				}
			}
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// method
		$curVal = strval($this->method->CurrentValue);
		if ($curVal <> "") {
			$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
			if ($this->method->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` = 22";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->method->ViewValue = $this->method->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->method->ViewValue = $this->method->CurrentValue;
				}
			}
		} else {
			$this->method->ViewValue = NULL;
		}
		$this->method->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// production_plan
		if (strval($this->production_plan->CurrentValue) <> "") {
			$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
		} else {
			$this->production_plan->ViewValue = NULL;
		}
		$this->production_plan->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
		$this->updated->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// material_out
		if (strval($this->material_out->CurrentValue) <> "") {
			$this->material_out->ViewValue = $this->material_out->optionCaption($this->material_out->CurrentValue);
		} else {
			$this->material_out->ViewValue = NULL;
		}
		$this->material_out->ViewCustomAttributes = "";

		// material_out_id
		$curVal = strval($this->material_out_id->CurrentValue);
		if ($curVal <> "") {
			$this->material_out_id->ViewValue = $this->material_out_id->lookupCacheOption($curVal);
			if ($this->material_out_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->material_out_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->material_out_id->ViewValue = $this->material_out_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->material_out_id->ViewValue = $this->material_out_id->CurrentValue;
				}
			}
		} else {
			$this->material_out_id->ViewValue = NULL;
		}
		$this->material_out_id->ViewCustomAttributes = "";

		// issue_to
		$curVal = strval($this->issue_to->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			if ($this->issue_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
				}
			}
		} else {
			$this->issue_to->ViewValue = NULL;
		}
		$this->issue_to->ViewCustomAttributes = "";

		// size_wl
		$this->size_wl->ViewValue = $this->size_wl->CurrentValue;
		$this->size_wl->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// req_material_grp
		$curVal = strval($this->req_material_grp->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_grp->ViewValue = $this->req_material_grp->lookupCacheOption($curVal);
			if ($this->req_material_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`  =2 and`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_grp->ViewValue = $this->req_material_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
				}
			}
		} else {
			$this->req_material_grp->ViewValue = NULL;
		}
		$this->req_material_grp->ViewCustomAttributes = "";

		// issue_material_grp
		$this->issue_material_grp->ViewValue = FormatNumber($this->issue_material_grp->ViewValue, 0, -2, -2, -2);
		$this->issue_material_grp->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// poid
		$this->poid->LinkCustomAttributes = "";
		$this->poid->HrefValue = "";
		$this->poid->TooltipValue = "";

		// week
		$this->week->LinkCustomAttributes = "";
		$this->week->HrefValue = "";
		$this->week->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		$this->buyer_id->HrefValue = "";
		$this->buyer_id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// product_id
		$this->product_id->LinkCustomAttributes = "";
		$this->product_id->HrefValue = "";
		$this->product_id->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// req_material_sgrp
		$this->req_material_sgrp->LinkCustomAttributes = "";
		$this->req_material_sgrp->HrefValue = "";
		$this->req_material_sgrp->TooltipValue = "";

		// issue_material_sgrp
		$this->issue_material_sgrp->LinkCustomAttributes = "";
		$this->issue_material_sgrp->HrefValue = "";
		$this->issue_material_sgrp->TooltipValue = "";

		// req_material_product
		$this->req_material_product->LinkCustomAttributes = "";
		$this->req_material_product->HrefValue = "";
		$this->req_material_product->TooltipValue = "";

		// issue_material_product
		$this->issue_material_product->LinkCustomAttributes = "";
		$this->issue_material_product->HrefValue = "";
		$this->issue_material_product->TooltipValue = "";

		// req_material_rid
		$this->req_material_rid->LinkCustomAttributes = "";
		$this->req_material_rid->HrefValue = "";
		$this->req_material_rid->TooltipValue = "";

		// issue_material_rid
		$this->issue_material_rid->LinkCustomAttributes = "";
		$this->issue_material_rid->HrefValue = "";
		$this->issue_material_rid->TooltipValue = "";

		// issue_material_id
		$this->issue_material_id->LinkCustomAttributes = "";
		$this->issue_material_id->HrefValue = "";
		$this->issue_material_id->TooltipValue = "";

		// req_material_qty
		$this->req_material_qty->LinkCustomAttributes = "";
		$this->req_material_qty->HrefValue = "";
		$this->req_material_qty->TooltipValue = "";

		// issue_material_qty
		$this->issue_material_qty->LinkCustomAttributes = "";
		$this->issue_material_qty->HrefValue = "";
		$this->issue_material_qty->TooltipValue = "";

		// material_qty
		$this->material_qty->LinkCustomAttributes = "";
		$this->material_qty->HrefValue = "";
		$this->material_qty->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		$this->unit->HrefValue = "";
		$this->unit->TooltipValue = "";

		// method
		$this->method->LinkCustomAttributes = "";
		$this->method->HrefValue = "";
		$this->method->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// production_plan
		$this->production_plan->LinkCustomAttributes = "";
		$this->production_plan->HrefValue = "";
		$this->production_plan->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// material_out
		$this->material_out->LinkCustomAttributes = "";
		$this->material_out->HrefValue = "";
		$this->material_out->TooltipValue = "";

		// material_out_id
		$this->material_out_id->LinkCustomAttributes = "";
		$this->material_out_id->HrefValue = "";
		$this->material_out_id->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		$this->issue_to->HrefValue = "";
		$this->issue_to->TooltipValue = "";

		// size_wl
		$this->size_wl->LinkCustomAttributes = "";
		$this->size_wl->HrefValue = "";
		$this->size_wl->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// req_material_grp
		$this->req_material_grp->LinkCustomAttributes = "";
		$this->req_material_grp->HrefValue = "";
		$this->req_material_grp->TooltipValue = "";

		// issue_material_grp
		$this->issue_material_grp->LinkCustomAttributes = "";
		$this->issue_material_grp->HrefValue = "";
		$this->issue_material_grp->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$curVal = strval($this->jc_no->CurrentValue);
		if ($curVal <> "") {
			$this->jc_no->EditValue = $this->jc_no->lookupCacheOption($curVal);
			if ($this->jc_no->EditValue === NULL) { // Lookup from database
				$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$this->jc_no->EditValue = $this->jc_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->jc_no->EditValue = $this->jc_no->CurrentValue;
				}
			}
		} else {
			$this->jc_no->EditValue = NULL;
		}
		$this->jc_no->ViewCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// poid
		$this->poid->EditAttrs["class"] = "form-control";
		$this->poid->EditCustomAttributes = "";

		// week
		$this->week->EditAttrs["class"] = "form-control";
		$this->week->EditCustomAttributes = "";
		$curVal = strval($this->week->CurrentValue);
		if ($curVal <> "") {
			$this->week->EditValue = $this->week->lookupCacheOption($curVal);
			if ($this->week->EditValue === NULL) { // Lookup from database
				$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->week->EditValue = $this->week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->week->EditValue = $this->week->CurrentValue;
				}
			}
		} else {
			$this->week->EditValue = NULL;
		}
		$this->week->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->EditValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		if (strval($this->grp->CurrentValue) <> "") {
			$this->grp->EditValue = $this->grp->optionCaption($this->grp->CurrentValue);
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` =2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->EditValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->EditValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->EditValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->EditValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->EditValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->EditValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// product_id
		$this->product_id->EditAttrs["class"] = "form-control";
		$this->product_id->EditCustomAttributes = "";
		$curVal = strval($this->product_id->CurrentValue);
		if ($curVal <> "") {
			$this->product_id->EditValue = $this->product_id->lookupCacheOption($curVal);
			if ($this->product_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_id->EditValue = $this->product_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_id->EditValue = $this->product_id->CurrentValue;
				}
			}
		} else {
			$this->product_id->EditValue = NULL;
		}
		$this->product_id->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->EditValue = FormatNumber($this->batch_no->EditValue, 0, -2, -2, -2);
		$this->batch_no->ViewCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// req_material_sgrp
		$this->req_material_sgrp->EditAttrs["class"] = "form-control";
		$this->req_material_sgrp->EditCustomAttributes = "";
		$curVal = strval($this->req_material_sgrp->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_sgrp->EditValue = $this->req_material_sgrp->lookupCacheOption($curVal);
			if ($this->req_material_sgrp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "FIND_IN_SET(`grp`, '0,1,2')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_sgrp->EditValue = $this->req_material_sgrp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_sgrp->EditValue = $this->req_material_sgrp->CurrentValue;
				}
			}
		} else {
			$this->req_material_sgrp->EditValue = NULL;
		}
		$this->req_material_sgrp->ViewCustomAttributes = "";

		// issue_material_sgrp
		$this->issue_material_sgrp->EditAttrs["class"] = "form-control";
		$this->issue_material_sgrp->EditCustomAttributes = "";

		// req_material_product
		$this->req_material_product->EditAttrs["class"] = "form-control";
		$this->req_material_product->EditCustomAttributes = "";
		$curVal = strval($this->req_material_product->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_product->EditValue = $this->req_material_product->lookupCacheOption($curVal);
			if ($this->req_material_product->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_product->EditValue = $this->req_material_product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_product->EditValue = $this->req_material_product->CurrentValue;
				}
			}
		} else {
			$this->req_material_product->EditValue = NULL;
		}
		$this->req_material_product->ViewCustomAttributes = "";

		// issue_material_product
		$this->issue_material_product->EditAttrs["class"] = "form-control";
		$this->issue_material_product->EditCustomAttributes = "";

		// req_material_rid
		$this->req_material_rid->EditAttrs["class"] = "form-control";
		$this->req_material_rid->EditCustomAttributes = "";
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->EditValue = NULL;
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// issue_material_rid
		$this->issue_material_rid->EditAttrs["class"] = "form-control";
		$this->issue_material_rid->EditCustomAttributes = "";
		$this->issue_material_rid->EditValue = $this->issue_material_rid->CurrentValue;
		$this->issue_material_rid->PlaceHolder = RemoveHtml($this->issue_material_rid->caption());

		// issue_material_id
		$this->issue_material_id->EditAttrs["class"] = "form-control";
		$this->issue_material_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->issue_material_id->CurrentValue = HtmlDecode($this->issue_material_id->CurrentValue);
		$this->issue_material_id->EditValue = $this->issue_material_id->CurrentValue;
		$this->issue_material_id->PlaceHolder = RemoveHtml($this->issue_material_id->caption());

		// req_material_qty
		$this->req_material_qty->EditAttrs["class"] = "form-control";
		$this->req_material_qty->EditCustomAttributes = "";
		$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, 2, -2, -2, -2);
		$this->req_material_qty->ViewCustomAttributes = "";

		// issue_material_qty
		$this->issue_material_qty->EditAttrs["class"] = "form-control";
		$this->issue_material_qty->EditCustomAttributes = "";
		$this->issue_material_qty->EditValue = $this->issue_material_qty->CurrentValue;
		$this->issue_material_qty->PlaceHolder = RemoveHtml($this->issue_material_qty->caption());
		if (strval($this->issue_material_qty->EditValue) <> "" && is_numeric($this->issue_material_qty->EditValue))
			$this->issue_material_qty->EditValue = FormatNumber($this->issue_material_qty->EditValue, -2, -2, -2, -2);

		// material_qty
		$this->material_qty->EditAttrs["class"] = "form-control";
		$this->material_qty->EditCustomAttributes = "";
		$this->material_qty->EditValue = $this->material_qty->CurrentValue;
		$this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, 2, -2, -2, -2);
		$this->material_qty->ViewCustomAttributes = "";

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		$curVal = strval($this->unit->CurrentValue);
		if ($curVal <> "") {
			$this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
			if ($this->unit->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` =11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->unit->EditValue = $this->unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->unit->EditValue = $this->unit->CurrentValue;
				}
			}
		} else {
			$this->unit->EditValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// method
		$this->method->EditAttrs["class"] = "form-control";
		$this->method->EditCustomAttributes = "";
		$curVal = strval($this->method->CurrentValue);
		if ($curVal <> "") {
			$this->method->EditValue = $this->method->lookupCacheOption($curVal);
			if ($this->method->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` = 22";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->method->EditValue = $this->method->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->method->EditValue = $this->method->CurrentValue;
				}
			}
		} else {
			$this->method->EditValue = NULL;
		}
		$this->method->ViewCustomAttributes = "";

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->EditValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 8);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// production_plan
		$this->production_plan->EditAttrs["class"] = "form-control";
		$this->production_plan->EditCustomAttributes = "";
		if (strval($this->production_plan->CurrentValue) <> "") {
			$this->production_plan->EditValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
		} else {
			$this->production_plan->EditValue = NULL;
		}
		$this->production_plan->ViewCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// updated
		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// operator
		// datetime
		// material_out

		$this->material_out->EditCustomAttributes = "";
		$this->material_out->EditValue = $this->material_out->options(FALSE);

		// material_out_id
		$this->material_out_id->EditAttrs["class"] = "form-control";
		$this->material_out_id->EditCustomAttributes = "";

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";
		$curVal = strval($this->issue_to->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to->EditValue = $this->issue_to->lookupCacheOption($curVal);
			if ($this->issue_to->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->issue_to->EditValue = $this->issue_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to->EditValue = $this->issue_to->CurrentValue;
				}
			}
		} else {
			$this->issue_to->EditValue = NULL;
		}
		$this->issue_to->ViewCustomAttributes = "";

		// size_wl
		$this->size_wl->EditAttrs["class"] = "form-control";
		$this->size_wl->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_wl->CurrentValue = HtmlDecode($this->size_wl->CurrentValue);
		$this->size_wl->EditValue = $this->size_wl->CurrentValue;
		$this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// req_material_grp
		$this->req_material_grp->EditAttrs["class"] = "form-control";
		$this->req_material_grp->EditCustomAttributes = "";

		// issue_material_grp
		$this->issue_material_grp->EditAttrs["class"] = "form-control";
		$this->issue_material_grp->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->poid);
					$doc->exportCaption($this->week);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_id);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->req_material_sgrp);
					$doc->exportCaption($this->issue_material_sgrp);
					$doc->exportCaption($this->req_material_product);
					$doc->exportCaption($this->issue_material_product);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->issue_material_rid);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->issue_material_qty);
					$doc->exportCaption($this->material_qty);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->updated);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->material_out);
					$doc->exportCaption($this->material_out_id);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->week);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_id);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->req_material_sgrp);
					$doc->exportCaption($this->issue_material_sgrp);
					$doc->exportCaption($this->req_material_product);
					$doc->exportCaption($this->issue_material_product);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->issue_material_rid);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->issue_material_qty);
					$doc->exportCaption($this->material_qty);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->material_out);
					$doc->exportCaption($this->material_out_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->po);
						$doc->exportField($this->poid);
						$doc->exportField($this->week);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->product_id);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->quantity);
						$doc->exportField($this->req_material_sgrp);
						$doc->exportField($this->issue_material_sgrp);
						$doc->exportField($this->req_material_product);
						$doc->exportField($this->issue_material_product);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->issue_material_rid);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->issue_material_qty);
						$doc->exportField($this->material_qty);
						$doc->exportField($this->unit);
						$doc->exportField($this->method);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->remarks);
						$doc->exportField($this->updated);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->material_out);
						$doc->exportField($this->material_out_id);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->po);
						$doc->exportField($this->week);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->product);
						$doc->exportField($this->product_id);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->quantity);
						$doc->exportField($this->req_material_sgrp);
						$doc->exportField($this->issue_material_sgrp);
						$doc->exportField($this->req_material_product);
						$doc->exportField($this->issue_material_product);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->issue_material_rid);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->issue_material_qty);
						$doc->exportField($this->material_qty);
						$doc->exportField($this->unit);
						$doc->exportField($this->method);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->material_out);
						$doc->exportField($this->material_out_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>