<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for material_required_job_card
 */
class material_required_job_card extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $poid;
	public $jc_no;
	public $location;
	public $issue_to;
	public $week;
	public $po;
	public $buyer_id;
	public $grp;
	public $s_grp;
	public $product;
	public $product_id;
	public $batch_no;
	public $quantity;
	public $size_cm;
	public $sqm;
	public $t_sqm;
	public $req_material_grp;
	public $req_material_sgrp;
	public $req_material_product;
	public $req_material_rid;
	public $req_material_qty;
	public $req_material_packing;
	public $stock;
	public $short;
	public $unit;
	public $material_qty;
	public $method;
	public $despatch_week;
	public $despatch_date;
	public $production_plan;
	public $remarks;
	public $updated;
	public $operator;
	public $datetime;
	public $jc_datetime;
	public $company_id;
	public $m_out_id;
	public $issued_qty;
	public $pending_qty;
	public $m_out_remarks;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'material_required_job_card';
		$this->TableName = 'material_required_job_card';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`material_required_job_card`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('material_required_job_card', 'material_required_job_card', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// poid
		$this->poid = new DbField('material_required_job_card', 'material_required_job_card', 'x_poid', 'poid', '`poid`', '`poid`', 19, -1, FALSE, '`poid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->poid->Nullable = FALSE; // NOT NULL field
		$this->poid->Required = TRUE; // Required field
		$this->poid->Sortable = TRUE; // Allow sort
		$this->poid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['poid'] = &$this->poid;

		// jc_no
		$this->jc_no = new DbField('material_required_job_card', 'material_required_job_card', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 3, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// location
		$this->location = new DbField('material_required_job_card', 'material_required_job_card', 'x_location', 'location', '`location`', '`location`', 2, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['location'] = &$this->location;

		// issue_to
		$this->issue_to = new DbField('material_required_job_card', 'material_required_job_card', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 3, -1, FALSE, '`issue_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->issue_to->Nullable = FALSE; // NOT NULL field
		$this->issue_to->Required = TRUE; // Required field
		$this->issue_to->Sortable = TRUE; // Allow sort
		$this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to'] = &$this->issue_to;

		// week
		$this->week = new DbField('material_required_job_card', 'material_required_job_card', 'x_week', 'week', '`week`', '`week`', 18, -1, FALSE, '`week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->week->Nullable = FALSE; // NOT NULL field
		$this->week->Required = TRUE; // Required field
		$this->week->Sortable = TRUE; // Allow sort
		$this->week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['week'] = &$this->week;

		// po
		$this->po = new DbField('material_required_job_card', 'material_required_job_card', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// buyer_id
		$this->buyer_id = new DbField('material_required_job_card', 'material_required_job_card', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 19, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_id->Nullable = FALSE; // NOT NULL field
		$this->buyer_id->Required = TRUE; // Required field
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// grp
		$this->grp = new DbField('material_required_job_card', 'material_required_job_card', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('material_required_job_card', 'material_required_job_card', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('material_required_job_card', 'material_required_job_card', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// product_id
		$this->product_id = new DbField('material_required_job_card', 'material_required_job_card', 'x_product_id', 'product_id', '`product_id`', '`product_id`', 18, -1, FALSE, '`product_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_id->Sortable = TRUE; // Allow sort
		$this->product_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_id'] = &$this->product_id;

		// batch_no
		$this->batch_no = new DbField('material_required_job_card', 'material_required_job_card', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Nullable = FALSE; // NOT NULL field
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// quantity
		$this->quantity = new DbField('material_required_job_card', 'material_required_job_card', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// size_cm
		$this->size_cm = new DbField('material_required_job_card', 'material_required_job_card', 'x_size_cm', 'size_cm', '`size_cm`', '`size_cm`', 200, -1, FALSE, '`size_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_cm->Sortable = TRUE; // Allow sort
		$this->fields['size_cm'] = &$this->size_cm;

		// sqm
		$this->sqm = new DbField('material_required_job_card', 'material_required_job_card', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// t_sqm
		$this->t_sqm = new DbField('material_required_job_card', 'material_required_job_card', 'x_t_sqm', 't_sqm', '`t_sqm`', '`t_sqm`', 131, -1, FALSE, '`t_sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_sqm->Sortable = TRUE; // Allow sort
		$this->t_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['t_sqm'] = &$this->t_sqm;

		// req_material_grp
		$this->req_material_grp = new DbField('material_required_job_card', 'material_required_job_card', 'x_req_material_grp', 'req_material_grp', '`req_material_grp`', '`req_material_grp`', 18, -1, FALSE, '`req_material_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_grp->Sortable = TRUE; // Allow sort
		$this->req_material_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_grp'] = &$this->req_material_grp;

		// req_material_sgrp
		$this->req_material_sgrp = new DbField('material_required_job_card', 'material_required_job_card', 'x_req_material_sgrp', 'req_material_sgrp', '`req_material_sgrp`', '`req_material_sgrp`', 18, -1, FALSE, '`req_material_sgrp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_sgrp->Sortable = TRUE; // Allow sort
		$this->req_material_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_sgrp'] = &$this->req_material_sgrp;

		// req_material_product
		$this->req_material_product = new DbField('material_required_job_card', 'material_required_job_card', 'x_req_material_product', 'req_material_product', '`req_material_product`', '`req_material_product`', 18, -1, FALSE, '`req_material_product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_product->Sortable = TRUE; // Allow sort
		$this->req_material_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_product'] = &$this->req_material_product;

		// req_material_rid
		$this->req_material_rid = new DbField('material_required_job_card', 'material_required_job_card', 'x_req_material_rid', 'req_material_rid', '`req_material_rid`', '`req_material_rid`', 18, -1, FALSE, '`req_material_rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_rid->Sortable = TRUE; // Allow sort
		$this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_rid'] = &$this->req_material_rid;

		// req_material_qty
		$this->req_material_qty = new DbField('material_required_job_card', 'material_required_job_card', 'x_req_material_qty', 'req_material_qty', '`req_material_qty`', '`req_material_qty`', 131, -1, FALSE, '`req_material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_qty->Nullable = FALSE; // NOT NULL field
		$this->req_material_qty->Required = TRUE; // Required field
		$this->req_material_qty->Sortable = TRUE; // Allow sort
		$this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['req_material_qty'] = &$this->req_material_qty;

		// req_material_packing
		$this->req_material_packing = new DbField('material_required_job_card', 'material_required_job_card', 'x_req_material_packing', 'req_material_packing', '`req_material_packing`', '`req_material_packing`', 2, -1, FALSE, '`req_material_packing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_packing->Nullable = FALSE; // NOT NULL field
		$this->req_material_packing->Required = TRUE; // Required field
		$this->req_material_packing->Sortable = TRUE; // Allow sort
		$this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_packing'] = &$this->req_material_packing;

		// stock
		$this->stock = new DbField('material_required_job_card', 'material_required_job_card', 'x_stock', 'stock', '`stock`', '`stock`', 131, -1, FALSE, '`stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->stock->Nullable = FALSE; // NOT NULL field
		$this->stock->Required = TRUE; // Required field
		$this->stock->Sortable = TRUE; // Allow sort
		$this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['stock'] = &$this->stock;

		// short
		$this->short = new DbField('material_required_job_card', 'material_required_job_card', 'x_short', 'short', '`short`', '`short`', 131, -1, FALSE, '`short`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->short->Nullable = FALSE; // NOT NULL field
		$this->short->Required = TRUE; // Required field
		$this->short->Sortable = TRUE; // Allow sort
		$this->short->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['short'] = &$this->short;

		// unit
		$this->unit = new DbField('material_required_job_card', 'material_required_job_card', 'x_unit', 'unit', '`unit`', '`unit`', 200, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unit->Sortable = TRUE; // Allow sort
		$this->fields['unit'] = &$this->unit;

		// material_qty
		$this->material_qty = new DbField('material_required_job_card', 'material_required_job_card', 'x_material_qty', 'material_qty', '`material_qty`', '`material_qty`', 131, -1, FALSE, '`material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->material_qty->Sortable = TRUE; // Allow sort
		$this->material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['material_qty'] = &$this->material_qty;

		// method
		$this->method = new DbField('material_required_job_card', 'material_required_job_card', 'x_method', 'method', '`method`', '`method`', 17, -1, FALSE, '`method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->method->Sortable = TRUE; // Allow sort
		$this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['method'] = &$this->method;

		// despatch_week
		$this->despatch_week = new DbField('material_required_job_card', 'material_required_job_card', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, -1, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['despatch_week'] = &$this->despatch_week;

		// despatch_date
		$this->despatch_date = new DbField('material_required_job_card', 'material_required_job_card', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Nullable = FALSE; // NOT NULL field
		$this->despatch_date->Required = TRUE; // Required field
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// production_plan
		$this->production_plan = new DbField('material_required_job_card', 'material_required_job_card', 'x_production_plan', 'production_plan', '`production_plan`', '`production_plan`', 18, -1, FALSE, '`production_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->production_plan->Sortable = TRUE; // Allow sort
		$this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_plan'] = &$this->production_plan;

		// remarks
		$this->remarks = new DbField('material_required_job_card', 'material_required_job_card', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Nullable = FALSE; // NOT NULL field
		$this->remarks->Required = TRUE; // Required field
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// updated
		$this->updated = new DbField('material_required_job_card', 'material_required_job_card', 'x_updated', 'updated', '`updated`', '`updated`', 16, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Nullable = FALSE; // NOT NULL field
		$this->updated->Required = TRUE; // Required field
		$this->updated->Sortable = TRUE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;

		// operator
		$this->operator = new DbField('material_required_job_card', 'material_required_job_card', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Required = TRUE; // Required field
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('material_required_job_card', 'material_required_job_card', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Required = TRUE; // Required field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// jc_datetime
		$this->jc_datetime = new DbField('material_required_job_card', 'material_required_job_card', 'x_jc_datetime', 'jc_datetime', '`jc_datetime`', CastDateFieldForLike('`jc_datetime`', 0, "DB"), 135, 0, FALSE, '`jc_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_datetime->Sortable = TRUE; // Allow sort
		$this->jc_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['jc_datetime'] = &$this->jc_datetime;

		// company_id
		$this->company_id = new DbField('material_required_job_card', 'material_required_job_card', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// m_out_id
		$this->m_out_id = new DbField('material_required_job_card', 'material_required_job_card', 'x_m_out_id', 'm_out_id', '`m_out_id`', '`m_out_id`', 200, -1, FALSE, '`m_out_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->m_out_id->Sortable = TRUE; // Allow sort
		$this->fields['m_out_id'] = &$this->m_out_id;

		// issued_qty
		$this->issued_qty = new DbField('material_required_job_card', 'material_required_job_card', 'x_issued_qty', 'issued_qty', '`issued_qty`', '`issued_qty`', 131, -1, FALSE, '`issued_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->issued_qty->Sortable = TRUE; // Allow sort
		$this->issued_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['issued_qty'] = &$this->issued_qty;

		// pending_qty
		$this->pending_qty = new DbField('material_required_job_card', 'material_required_job_card', 'x_pending_qty', 'pending_qty', '`pending_qty`', '`pending_qty`', 131, -1, FALSE, '`pending_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pending_qty->Sortable = TRUE; // Allow sort
		$this->pending_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pending_qty'] = &$this->pending_qty;

		// m_out_remarks
		$this->m_out_remarks = new DbField('material_required_job_card', 'material_required_job_card', 'x_m_out_remarks', 'm_out_remarks', '`m_out_remarks`', '`m_out_remarks`', 200, -1, FALSE, '`m_out_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->m_out_remarks->Sortable = TRUE; // Allow sort
		$this->fields['m_out_remarks'] = &$this->m_out_remarks;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`material_required_job_card`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->poid->DbValue = $row['poid'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->location->DbValue = $row['location'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->week->DbValue = $row['week'];
		$this->po->DbValue = $row['po'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->product_id->DbValue = $row['product_id'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->quantity->DbValue = $row['quantity'];
		$this->size_cm->DbValue = $row['size_cm'];
		$this->sqm->DbValue = $row['sqm'];
		$this->t_sqm->DbValue = $row['t_sqm'];
		$this->req_material_grp->DbValue = $row['req_material_grp'];
		$this->req_material_sgrp->DbValue = $row['req_material_sgrp'];
		$this->req_material_product->DbValue = $row['req_material_product'];
		$this->req_material_rid->DbValue = $row['req_material_rid'];
		$this->req_material_qty->DbValue = $row['req_material_qty'];
		$this->req_material_packing->DbValue = $row['req_material_packing'];
		$this->stock->DbValue = $row['stock'];
		$this->short->DbValue = $row['short'];
		$this->unit->DbValue = $row['unit'];
		$this->material_qty->DbValue = $row['material_qty'];
		$this->method->DbValue = $row['method'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->production_plan->DbValue = $row['production_plan'];
		$this->remarks->DbValue = $row['remarks'];
		$this->updated->DbValue = $row['updated'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->jc_datetime->DbValue = $row['jc_datetime'];
		$this->company_id->DbValue = $row['company_id'];
		$this->m_out_id->DbValue = $row['m_out_id'];
		$this->issued_qty->DbValue = $row['issued_qty'];
		$this->pending_qty->DbValue = $row['pending_qty'];
		$this->m_out_remarks->DbValue = $row['m_out_remarks'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "material_required_job_cardlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "material_required_job_cardview.php")
			return $Language->phrase("View");
		elseif ($pageName == "material_required_job_cardedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "material_required_job_cardadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "material_required_job_cardlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("material_required_job_cardview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("material_required_job_cardview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "material_required_job_cardadd.php?" . $this->getUrlParm($parm);
		else
			$url = "material_required_job_cardadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("material_required_job_cardedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("material_required_job_cardadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("material_required_job_carddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->poid->setDbValue($rs->fields('poid'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->location->setDbValue($rs->fields('location'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->week->setDbValue($rs->fields('week'));
		$this->po->setDbValue($rs->fields('po'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->product_id->setDbValue($rs->fields('product_id'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->size_cm->setDbValue($rs->fields('size_cm'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->t_sqm->setDbValue($rs->fields('t_sqm'));
		$this->req_material_grp->setDbValue($rs->fields('req_material_grp'));
		$this->req_material_sgrp->setDbValue($rs->fields('req_material_sgrp'));
		$this->req_material_product->setDbValue($rs->fields('req_material_product'));
		$this->req_material_rid->setDbValue($rs->fields('req_material_rid'));
		$this->req_material_qty->setDbValue($rs->fields('req_material_qty'));
		$this->req_material_packing->setDbValue($rs->fields('req_material_packing'));
		$this->stock->setDbValue($rs->fields('stock'));
		$this->short->setDbValue($rs->fields('short'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->material_qty->setDbValue($rs->fields('material_qty'));
		$this->method->setDbValue($rs->fields('method'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->production_plan->setDbValue($rs->fields('production_plan'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->updated->setDbValue($rs->fields('updated'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->jc_datetime->setDbValue($rs->fields('jc_datetime'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->m_out_id->setDbValue($rs->fields('m_out_id'));
		$this->issued_qty->setDbValue($rs->fields('issued_qty'));
		$this->pending_qty->setDbValue($rs->fields('pending_qty'));
		$this->m_out_remarks->setDbValue($rs->fields('m_out_remarks'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// poid
		// jc_no
		// location
		// issue_to
		// week
		// po
		// buyer_id
		// grp
		// s_grp
		// product
		// product_id
		// batch_no
		// quantity
		// size_cm
		// sqm
		// t_sqm
		// req_material_grp
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_qty
		// req_material_packing
		// stock
		// short
		// unit
		// material_qty
		// method
		// despatch_week
		// despatch_date
		// production_plan
		// remarks
		// updated
		// operator
		// datetime
		// jc_datetime
		// company_id
		// m_out_id
		// issued_qty
		// pending_qty
		// m_out_remarks
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// poid
		$this->poid->ViewValue = $this->poid->CurrentValue;
		$this->poid->ViewValue = FormatNumber($this->poid->ViewValue, 0, -2, -2, -2);
		$this->poid->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
		$this->jc_no->ViewCustomAttributes = "";

		// location
		$this->location->ViewValue = $this->location->CurrentValue;
		$this->location->ViewValue = FormatNumber($this->location->ViewValue, 0, -2, -2, -2);
		$this->location->ViewCustomAttributes = "";

		// issue_to
		$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
		$this->issue_to->ViewValue = FormatNumber($this->issue_to->ViewValue, 0, -2, -2, -2);
		$this->issue_to->ViewCustomAttributes = "";

		// week
		$this->week->ViewValue = $this->week->CurrentValue;
		$this->week->ViewValue = FormatNumber($this->week->ViewValue, 0, -2, -2, -2);
		$this->week->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
		$this->buyer_id->ViewValue = FormatNumber($this->buyer_id->ViewValue, 0, -2, -2, -2);
		$this->buyer_id->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
		$this->product->ViewCustomAttributes = "";

		// product_id
		$this->product_id->ViewValue = $this->product_id->CurrentValue;
		$this->product_id->ViewValue = FormatNumber($this->product_id->ViewValue, 0, -2, -2, -2);
		$this->product_id->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
		$this->batch_no->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// t_sqm
		$this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
		$this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, 2, -2, -2, -2);
		$this->t_sqm->ViewCustomAttributes = "";

		// req_material_grp
		$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
		$this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, 0, -2, -2, -2);
		$this->req_material_grp->ViewCustomAttributes = "";

		// req_material_sgrp
		$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
		$this->req_material_sgrp->ViewValue = FormatNumber($this->req_material_sgrp->ViewValue, 0, -2, -2, -2);
		$this->req_material_sgrp->ViewCustomAttributes = "";

		// req_material_product
		$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
		$this->req_material_product->ViewValue = FormatNumber($this->req_material_product->ViewValue, 0, -2, -2, -2);
		$this->req_material_product->ViewCustomAttributes = "";

		// req_material_rid
		$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
		$this->req_material_rid->ViewValue = FormatNumber($this->req_material_rid->ViewValue, 0, -2, -2, -2);
		$this->req_material_rid->ViewCustomAttributes = "";

		// req_material_qty
		$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
		$this->req_material_qty->ViewCustomAttributes = "";

		// req_material_packing
		$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
		$this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->ViewValue, 0, -2, -2, -2);
		$this->req_material_packing->ViewCustomAttributes = "";

		// stock
		$this->stock->ViewValue = $this->stock->CurrentValue;
		$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
		$this->stock->ViewCustomAttributes = "";

		// short
		$this->short->ViewValue = $this->short->CurrentValue;
		$this->short->ViewValue = FormatNumber($this->short->ViewValue, 2, -2, -2, -2);
		$this->short->ViewCustomAttributes = "";

		// unit
		$this->unit->ViewValue = $this->unit->CurrentValue;
		$this->unit->ViewCustomAttributes = "";

		// material_qty
		$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
		$this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, 2, -2, -2, -2);
		$this->material_qty->ViewCustomAttributes = "";

		// method
		$this->method->ViewValue = $this->method->CurrentValue;
		$this->method->ViewValue = FormatNumber($this->method->ViewValue, 0, -2, -2, -2);
		$this->method->ViewCustomAttributes = "";

		// despatch_week
		$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
		$this->despatch_week->ViewValue = FormatNumber($this->despatch_week->ViewValue, 0, -2, -2, -2);
		$this->despatch_week->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// production_plan
		$this->production_plan->ViewValue = $this->production_plan->CurrentValue;
		$this->production_plan->ViewValue = FormatNumber($this->production_plan->ViewValue, 0, -2, -2, -2);
		$this->production_plan->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
		$this->updated->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// jc_datetime
		$this->jc_datetime->ViewValue = $this->jc_datetime->CurrentValue;
		$this->jc_datetime->ViewValue = FormatDateTime($this->jc_datetime->ViewValue, 0);
		$this->jc_datetime->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
		$this->company_id->ViewCustomAttributes = "";

		// m_out_id
		$this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;
		$this->m_out_id->ViewCustomAttributes = "";

		// issued_qty
		$this->issued_qty->ViewValue = $this->issued_qty->CurrentValue;
		$this->issued_qty->ViewValue = FormatNumber($this->issued_qty->ViewValue, 2, -2, -2, -2);
		$this->issued_qty->ViewCustomAttributes = "";

		// pending_qty
		$this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
		$this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, 2, -2, -2, -2);
		$this->pending_qty->ViewCustomAttributes = "";

		// m_out_remarks
		$this->m_out_remarks->ViewValue = $this->m_out_remarks->CurrentValue;
		$this->m_out_remarks->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// poid
		$this->poid->LinkCustomAttributes = "";
		$this->poid->HrefValue = "";
		$this->poid->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		$this->issue_to->HrefValue = "";
		$this->issue_to->TooltipValue = "";

		// week
		$this->week->LinkCustomAttributes = "";
		$this->week->HrefValue = "";
		$this->week->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		$this->buyer_id->HrefValue = "";
		$this->buyer_id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// product_id
		$this->product_id->LinkCustomAttributes = "";
		$this->product_id->HrefValue = "";
		$this->product_id->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// size_cm
		$this->size_cm->LinkCustomAttributes = "";
		$this->size_cm->HrefValue = "";
		$this->size_cm->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// t_sqm
		$this->t_sqm->LinkCustomAttributes = "";
		$this->t_sqm->HrefValue = "";
		$this->t_sqm->TooltipValue = "";

		// req_material_grp
		$this->req_material_grp->LinkCustomAttributes = "";
		$this->req_material_grp->HrefValue = "";
		$this->req_material_grp->TooltipValue = "";

		// req_material_sgrp
		$this->req_material_sgrp->LinkCustomAttributes = "";
		$this->req_material_sgrp->HrefValue = "";
		$this->req_material_sgrp->TooltipValue = "";

		// req_material_product
		$this->req_material_product->LinkCustomAttributes = "";
		$this->req_material_product->HrefValue = "";
		$this->req_material_product->TooltipValue = "";

		// req_material_rid
		$this->req_material_rid->LinkCustomAttributes = "";
		$this->req_material_rid->HrefValue = "";
		$this->req_material_rid->TooltipValue = "";

		// req_material_qty
		$this->req_material_qty->LinkCustomAttributes = "";
		$this->req_material_qty->HrefValue = "";
		$this->req_material_qty->TooltipValue = "";

		// req_material_packing
		$this->req_material_packing->LinkCustomAttributes = "";
		$this->req_material_packing->HrefValue = "";
		$this->req_material_packing->TooltipValue = "";

		// stock
		$this->stock->LinkCustomAttributes = "";
		$this->stock->HrefValue = "";
		$this->stock->TooltipValue = "";

		// short
		$this->short->LinkCustomAttributes = "";
		$this->short->HrefValue = "";
		$this->short->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		$this->unit->HrefValue = "";
		$this->unit->TooltipValue = "";

		// material_qty
		$this->material_qty->LinkCustomAttributes = "";
		$this->material_qty->HrefValue = "";
		$this->material_qty->TooltipValue = "";

		// method
		$this->method->LinkCustomAttributes = "";
		$this->method->HrefValue = "";
		$this->method->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// production_plan
		$this->production_plan->LinkCustomAttributes = "";
		$this->production_plan->HrefValue = "";
		$this->production_plan->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// jc_datetime
		$this->jc_datetime->LinkCustomAttributes = "";
		$this->jc_datetime->HrefValue = "";
		$this->jc_datetime->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// m_out_id
		$this->m_out_id->LinkCustomAttributes = "";
		$this->m_out_id->HrefValue = "";
		$this->m_out_id->TooltipValue = "";

		// issued_qty
		$this->issued_qty->LinkCustomAttributes = "";
		$this->issued_qty->HrefValue = "";
		$this->issued_qty->TooltipValue = "";

		// pending_qty
		$this->pending_qty->LinkCustomAttributes = "";
		$this->pending_qty->HrefValue = "";
		$this->pending_qty->TooltipValue = "";

		// m_out_remarks
		$this->m_out_remarks->LinkCustomAttributes = "";
		$this->m_out_remarks->HrefValue = "";
		$this->m_out_remarks->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// poid
		$this->poid->EditAttrs["class"] = "form-control";
		$this->poid->EditCustomAttributes = "";
		$this->poid->EditValue = $this->poid->CurrentValue;
		$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";
		$this->location->EditValue = $this->location->CurrentValue;
		$this->location->PlaceHolder = RemoveHtml($this->location->caption());

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";
		$this->issue_to->EditValue = $this->issue_to->CurrentValue;
		$this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

		// week
		$this->week->EditAttrs["class"] = "form-control";
		$this->week->EditCustomAttributes = "";
		$this->week->EditValue = $this->week->CurrentValue;
		$this->week->PlaceHolder = RemoveHtml($this->week->caption());

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";
		$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
		$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// product_id
		$this->product_id->EditAttrs["class"] = "form-control";
		$this->product_id->EditCustomAttributes = "";
		$this->product_id->EditValue = $this->product_id->CurrentValue;
		$this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// size_cm
		$this->size_cm->EditAttrs["class"] = "form-control";
		$this->size_cm->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
		$this->size_cm->EditValue = $this->size_cm->CurrentValue;
		$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// t_sqm
		$this->t_sqm->EditAttrs["class"] = "form-control";
		$this->t_sqm->EditCustomAttributes = "";
		$this->t_sqm->EditValue = $this->t_sqm->CurrentValue;
		$this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());
		if (strval($this->t_sqm->EditValue) <> "" && is_numeric($this->t_sqm->EditValue))
			$this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, -2, -2, -2, -2);

		// req_material_grp
		$this->req_material_grp->EditAttrs["class"] = "form-control";
		$this->req_material_grp->EditCustomAttributes = "";
		$this->req_material_grp->EditValue = $this->req_material_grp->CurrentValue;
		$this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());

		// req_material_sgrp
		$this->req_material_sgrp->EditAttrs["class"] = "form-control";
		$this->req_material_sgrp->EditCustomAttributes = "";
		$this->req_material_sgrp->EditValue = $this->req_material_sgrp->CurrentValue;
		$this->req_material_sgrp->PlaceHolder = RemoveHtml($this->req_material_sgrp->caption());

		// req_material_product
		$this->req_material_product->EditAttrs["class"] = "form-control";
		$this->req_material_product->EditCustomAttributes = "";
		$this->req_material_product->EditValue = $this->req_material_product->CurrentValue;
		$this->req_material_product->PlaceHolder = RemoveHtml($this->req_material_product->caption());

		// req_material_rid
		$this->req_material_rid->EditAttrs["class"] = "form-control";
		$this->req_material_rid->EditCustomAttributes = "";
		$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
		$this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

		// req_material_qty
		$this->req_material_qty->EditAttrs["class"] = "form-control";
		$this->req_material_qty->EditCustomAttributes = "";
		$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
		if (strval($this->req_material_qty->EditValue) <> "" && is_numeric($this->req_material_qty->EditValue))
			$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, -2, -2, -2, -2);

		// req_material_packing
		$this->req_material_packing->EditAttrs["class"] = "form-control";
		$this->req_material_packing->EditCustomAttributes = "";
		$this->req_material_packing->EditValue = $this->req_material_packing->CurrentValue;
		$this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());

		// stock
		$this->stock->EditAttrs["class"] = "form-control";
		$this->stock->EditCustomAttributes = "";
		$this->stock->EditValue = $this->stock->CurrentValue;
		$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
		if (strval($this->stock->EditValue) <> "" && is_numeric($this->stock->EditValue))
			$this->stock->EditValue = FormatNumber($this->stock->EditValue, -2, -2, -2, -2);

		// short
		$this->short->EditAttrs["class"] = "form-control";
		$this->short->EditCustomAttributes = "";
		$this->short->EditValue = $this->short->CurrentValue;
		$this->short->PlaceHolder = RemoveHtml($this->short->caption());
		if (strval($this->short->EditValue) <> "" && is_numeric($this->short->EditValue))
			$this->short->EditValue = FormatNumber($this->short->EditValue, -2, -2, -2, -2);

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->unit->CurrentValue = HtmlDecode($this->unit->CurrentValue);
		$this->unit->EditValue = $this->unit->CurrentValue;
		$this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

		// material_qty
		$this->material_qty->EditAttrs["class"] = "form-control";
		$this->material_qty->EditCustomAttributes = "";
		$this->material_qty->EditValue = $this->material_qty->CurrentValue;
		$this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());
		if (strval($this->material_qty->EditValue) <> "" && is_numeric($this->material_qty->EditValue))
			$this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, -2, -2, -2, -2);

		// method
		$this->method->EditAttrs["class"] = "form-control";
		$this->method->EditCustomAttributes = "";
		$this->method->EditValue = $this->method->CurrentValue;
		$this->method->PlaceHolder = RemoveHtml($this->method->caption());

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";
		$this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
		$this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 8);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// production_plan
		$this->production_plan->EditAttrs["class"] = "form-control";
		$this->production_plan->EditCustomAttributes = "";
		$this->production_plan->EditValue = $this->production_plan->CurrentValue;
		$this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// updated
		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// operator
		$this->operator->EditAttrs["class"] = "form-control";
		$this->operator->EditCustomAttributes = "";
		$this->operator->EditValue = $this->operator->CurrentValue;
		$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

		// datetime
		$this->datetime->EditAttrs["class"] = "form-control";
		$this->datetime->EditCustomAttributes = "";
		$this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, 8);
		$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

		// jc_datetime
		$this->jc_datetime->EditAttrs["class"] = "form-control";
		$this->jc_datetime->EditCustomAttributes = "";
		$this->jc_datetime->EditValue = FormatDateTime($this->jc_datetime->CurrentValue, 8);
		$this->jc_datetime->PlaceHolder = RemoveHtml($this->jc_datetime->caption());

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// m_out_id
		$this->m_out_id->EditAttrs["class"] = "form-control";
		$this->m_out_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->m_out_id->CurrentValue = HtmlDecode($this->m_out_id->CurrentValue);
		$this->m_out_id->EditValue = $this->m_out_id->CurrentValue;
		$this->m_out_id->PlaceHolder = RemoveHtml($this->m_out_id->caption());

		// issued_qty
		$this->issued_qty->EditAttrs["class"] = "form-control";
		$this->issued_qty->EditCustomAttributes = "";
		$this->issued_qty->EditValue = $this->issued_qty->CurrentValue;
		$this->issued_qty->PlaceHolder = RemoveHtml($this->issued_qty->caption());
		if (strval($this->issued_qty->EditValue) <> "" && is_numeric($this->issued_qty->EditValue))
			$this->issued_qty->EditValue = FormatNumber($this->issued_qty->EditValue, -2, -2, -2, -2);

		// pending_qty
		$this->pending_qty->EditAttrs["class"] = "form-control";
		$this->pending_qty->EditCustomAttributes = "";
		$this->pending_qty->EditValue = $this->pending_qty->CurrentValue;
		$this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());
		if (strval($this->pending_qty->EditValue) <> "" && is_numeric($this->pending_qty->EditValue))
			$this->pending_qty->EditValue = FormatNumber($this->pending_qty->EditValue, -2, -2, -2, -2);

		// m_out_remarks
		$this->m_out_remarks->EditAttrs["class"] = "form-control";
		$this->m_out_remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->m_out_remarks->CurrentValue = HtmlDecode($this->m_out_remarks->CurrentValue);
		$this->m_out_remarks->EditValue = $this->m_out_remarks->CurrentValue;
		$this->m_out_remarks->PlaceHolder = RemoveHtml($this->m_out_remarks->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->poid);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->week);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_id);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->t_sqm);
					$doc->exportCaption($this->req_material_grp);
					$doc->exportCaption($this->req_material_sgrp);
					$doc->exportCaption($this->req_material_product);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->short);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->material_qty);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->updated);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->jc_datetime);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->m_out_id);
					$doc->exportCaption($this->issued_qty);
					$doc->exportCaption($this->pending_qty);
					$doc->exportCaption($this->m_out_remarks);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->poid);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->week);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_id);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->t_sqm);
					$doc->exportCaption($this->req_material_grp);
					$doc->exportCaption($this->req_material_sgrp);
					$doc->exportCaption($this->req_material_product);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->short);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->material_qty);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->updated);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->jc_datetime);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->m_out_id);
					$doc->exportCaption($this->issued_qty);
					$doc->exportCaption($this->pending_qty);
					$doc->exportCaption($this->m_out_remarks);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->poid);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->location);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->week);
						$doc->exportField($this->po);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->product_id);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->quantity);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->sqm);
						$doc->exportField($this->t_sqm);
						$doc->exportField($this->req_material_grp);
						$doc->exportField($this->req_material_sgrp);
						$doc->exportField($this->req_material_product);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->stock);
						$doc->exportField($this->short);
						$doc->exportField($this->unit);
						$doc->exportField($this->material_qty);
						$doc->exportField($this->method);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->remarks);
						$doc->exportField($this->updated);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->jc_datetime);
						$doc->exportField($this->company_id);
						$doc->exportField($this->m_out_id);
						$doc->exportField($this->issued_qty);
						$doc->exportField($this->pending_qty);
						$doc->exportField($this->m_out_remarks);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->poid);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->location);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->week);
						$doc->exportField($this->po);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->product_id);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->quantity);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->sqm);
						$doc->exportField($this->t_sqm);
						$doc->exportField($this->req_material_grp);
						$doc->exportField($this->req_material_sgrp);
						$doc->exportField($this->req_material_product);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->stock);
						$doc->exportField($this->short);
						$doc->exportField($this->unit);
						$doc->exportField($this->material_qty);
						$doc->exportField($this->method);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->updated);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->jc_datetime);
						$doc->exportField($this->company_id);
						$doc->exportField($this->m_out_id);
						$doc->exportField($this->issued_qty);
						$doc->exportField($this->pending_qty);
						$doc->exportField($this->m_out_remarks);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>