<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_required_job_card_add extends material_required_job_card
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_required_job_card';

	// Page object name
	public $PageObjName = "material_required_job_card_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_required_job_card)
		if (!isset($GLOBALS["material_required_job_card"]) || get_class($GLOBALS["material_required_job_card"]) == PROJECT_NAMESPACE . "material_required_job_card") {
			$GLOBALS["material_required_job_card"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_required_job_card"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required_job_card');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_required_job_card;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_required_job_card);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "material_required_job_cardview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("material_required_job_cardlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->poid->setVisibility();
		$this->jc_no->setVisibility();
		$this->location->setVisibility();
		$this->issue_to->setVisibility();
		$this->week->setVisibility();
		$this->po->setVisibility();
		$this->buyer_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_id->setVisibility();
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->size_cm->setVisibility();
		$this->sqm->setVisibility();
		$this->t_sqm->setVisibility();
		$this->req_material_grp->setVisibility();
		$this->req_material_sgrp->setVisibility();
		$this->req_material_product->setVisibility();
		$this->req_material_rid->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->req_material_packing->setVisibility();
		$this->stock->setVisibility();
		$this->short->setVisibility();
		$this->unit->setVisibility();
		$this->material_qty->setVisibility();
		$this->method->setVisibility();
		$this->despatch_week->setVisibility();
		$this->despatch_date->setVisibility();
		$this->production_plan->setVisibility();
		$this->remarks->setVisibility();
		$this->updated->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->jc_datetime->setVisibility();
		$this->company_id->setVisibility();
		$this->m_out_id->setVisibility();
		$this->issued_qty->setVisibility();
		$this->pending_qty->setVisibility();
		$this->m_out_remarks->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("material_required_job_cardlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "material_required_job_cardlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "material_required_job_cardview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->poid->CurrentValue = NULL;
		$this->poid->OldValue = $this->poid->CurrentValue;
		$this->jc_no->CurrentValue = NULL;
		$this->jc_no->OldValue = $this->jc_no->CurrentValue;
		$this->location->CurrentValue = NULL;
		$this->location->OldValue = $this->location->CurrentValue;
		$this->issue_to->CurrentValue = NULL;
		$this->issue_to->OldValue = $this->issue_to->CurrentValue;
		$this->week->CurrentValue = NULL;
		$this->week->OldValue = $this->week->CurrentValue;
		$this->po->CurrentValue = NULL;
		$this->po->OldValue = $this->po->CurrentValue;
		$this->buyer_id->CurrentValue = NULL;
		$this->buyer_id->OldValue = $this->buyer_id->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->product_id->CurrentValue = NULL;
		$this->product_id->OldValue = $this->product_id->CurrentValue;
		$this->batch_no->CurrentValue = NULL;
		$this->batch_no->OldValue = $this->batch_no->CurrentValue;
		$this->quantity->CurrentValue = NULL;
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->size_cm->CurrentValue = NULL;
		$this->size_cm->OldValue = $this->size_cm->CurrentValue;
		$this->sqm->CurrentValue = NULL;
		$this->sqm->OldValue = $this->sqm->CurrentValue;
		$this->t_sqm->CurrentValue = NULL;
		$this->t_sqm->OldValue = $this->t_sqm->CurrentValue;
		$this->req_material_grp->CurrentValue = NULL;
		$this->req_material_grp->OldValue = $this->req_material_grp->CurrentValue;
		$this->req_material_sgrp->CurrentValue = NULL;
		$this->req_material_sgrp->OldValue = $this->req_material_sgrp->CurrentValue;
		$this->req_material_product->CurrentValue = NULL;
		$this->req_material_product->OldValue = $this->req_material_product->CurrentValue;
		$this->req_material_rid->CurrentValue = NULL;
		$this->req_material_rid->OldValue = $this->req_material_rid->CurrentValue;
		$this->req_material_qty->CurrentValue = 0.00;
		$this->req_material_packing->CurrentValue = NULL;
		$this->req_material_packing->OldValue = $this->req_material_packing->CurrentValue;
		$this->stock->CurrentValue = 0.000;
		$this->short->CurrentValue = NULL;
		$this->short->OldValue = $this->short->CurrentValue;
		$this->unit->CurrentValue = NULL;
		$this->unit->OldValue = $this->unit->CurrentValue;
		$this->material_qty->CurrentValue = NULL;
		$this->material_qty->OldValue = $this->material_qty->CurrentValue;
		$this->method->CurrentValue = NULL;
		$this->method->OldValue = $this->method->CurrentValue;
		$this->despatch_week->CurrentValue = NULL;
		$this->despatch_week->OldValue = $this->despatch_week->CurrentValue;
		$this->despatch_date->CurrentValue = NULL;
		$this->despatch_date->OldValue = $this->despatch_date->CurrentValue;
		$this->production_plan->CurrentValue = NULL;
		$this->production_plan->OldValue = $this->production_plan->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->updated->CurrentValue = 0;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->jc_datetime->CurrentValue = NULL;
		$this->jc_datetime->OldValue = $this->jc_datetime->CurrentValue;
		$this->company_id->CurrentValue = NULL;
		$this->company_id->OldValue = $this->company_id->CurrentValue;
		$this->m_out_id->CurrentValue = NULL;
		$this->m_out_id->OldValue = $this->m_out_id->CurrentValue;
		$this->issued_qty->CurrentValue = NULL;
		$this->issued_qty->OldValue = $this->issued_qty->CurrentValue;
		$this->pending_qty->CurrentValue = NULL;
		$this->pending_qty->OldValue = $this->pending_qty->CurrentValue;
		$this->m_out_remarks->CurrentValue = NULL;
		$this->m_out_remarks->OldValue = $this->m_out_remarks->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'poid' first before field var 'x_poid'
		$val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
		if (!$this->poid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->poid->Visible = FALSE; // Disable update for API request
			else
				$this->poid->setFormValue($val);
		}

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_no->Visible = FALSE; // Disable update for API request
			else
				$this->jc_no->setFormValue($val);
		}

		// Check field name 'location' first before field var 'x_location'
		$val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
		if (!$this->location->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->location->Visible = FALSE; // Disable update for API request
			else
				$this->location->setFormValue($val);
		}

		// Check field name 'issue_to' first before field var 'x_issue_to'
		$val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
		if (!$this->issue_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_to->Visible = FALSE; // Disable update for API request
			else
				$this->issue_to->setFormValue($val);
		}

		// Check field name 'week' first before field var 'x_week'
		$val = $CurrentForm->hasValue("week") ? $CurrentForm->getValue("week") : $CurrentForm->getValue("x_week");
		if (!$this->week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->week->Visible = FALSE; // Disable update for API request
			else
				$this->week->setFormValue($val);
		}

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'product_id' first before field var 'x_product_id'
		$val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
		if (!$this->product_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_id->Visible = FALSE; // Disable update for API request
			else
				$this->product_id->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'size_cm' first before field var 'x_size_cm'
		$val = $CurrentForm->hasValue("size_cm") ? $CurrentForm->getValue("size_cm") : $CurrentForm->getValue("x_size_cm");
		if (!$this->size_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size_cm->Visible = FALSE; // Disable update for API request
			else
				$this->size_cm->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 't_sqm' first before field var 'x_t_sqm'
		$val = $CurrentForm->hasValue("t_sqm") ? $CurrentForm->getValue("t_sqm") : $CurrentForm->getValue("x_t_sqm");
		if (!$this->t_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->t_sqm->setFormValue($val);
		}

		// Check field name 'req_material_grp' first before field var 'x_req_material_grp'
		$val = $CurrentForm->hasValue("req_material_grp") ? $CurrentForm->getValue("req_material_grp") : $CurrentForm->getValue("x_req_material_grp");
		if (!$this->req_material_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_grp->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_grp->setFormValue($val);
		}

		// Check field name 'req_material_sgrp' first before field var 'x_req_material_sgrp'
		$val = $CurrentForm->hasValue("req_material_sgrp") ? $CurrentForm->getValue("req_material_sgrp") : $CurrentForm->getValue("x_req_material_sgrp");
		if (!$this->req_material_sgrp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_sgrp->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_sgrp->setFormValue($val);
		}

		// Check field name 'req_material_product' first before field var 'x_req_material_product'
		$val = $CurrentForm->hasValue("req_material_product") ? $CurrentForm->getValue("req_material_product") : $CurrentForm->getValue("x_req_material_product");
		if (!$this->req_material_product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_product->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_product->setFormValue($val);
		}

		// Check field name 'req_material_rid' first before field var 'x_req_material_rid'
		$val = $CurrentForm->hasValue("req_material_rid") ? $CurrentForm->getValue("req_material_rid") : $CurrentForm->getValue("x_req_material_rid");
		if (!$this->req_material_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_rid->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_rid->setFormValue($val);
		}

		// Check field name 'req_material_qty' first before field var 'x_req_material_qty'
		$val = $CurrentForm->hasValue("req_material_qty") ? $CurrentForm->getValue("req_material_qty") : $CurrentForm->getValue("x_req_material_qty");
		if (!$this->req_material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_qty->setFormValue($val);
		}

		// Check field name 'req_material_packing' first before field var 'x_req_material_packing'
		$val = $CurrentForm->hasValue("req_material_packing") ? $CurrentForm->getValue("req_material_packing") : $CurrentForm->getValue("x_req_material_packing");
		if (!$this->req_material_packing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_packing->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_packing->setFormValue($val);
		}

		// Check field name 'stock' first before field var 'x_stock'
		$val = $CurrentForm->hasValue("stock") ? $CurrentForm->getValue("stock") : $CurrentForm->getValue("x_stock");
		if (!$this->stock->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->stock->Visible = FALSE; // Disable update for API request
			else
				$this->stock->setFormValue($val);
		}

		// Check field name 'short' first before field var 'x_short'
		$val = $CurrentForm->hasValue("short") ? $CurrentForm->getValue("short") : $CurrentForm->getValue("x_short");
		if (!$this->short->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->short->Visible = FALSE; // Disable update for API request
			else
				$this->short->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name 'material_qty' first before field var 'x_material_qty'
		$val = $CurrentForm->hasValue("material_qty") ? $CurrentForm->getValue("material_qty") : $CurrentForm->getValue("x_material_qty");
		if (!$this->material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->material_qty->setFormValue($val);
		}

		// Check field name 'method' first before field var 'x_method'
		$val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
		if (!$this->method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->method->Visible = FALSE; // Disable update for API request
			else
				$this->method->setFormValue($val);
		}

		// Check field name 'despatch_week' first before field var 'x_despatch_week'
		$val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
		if (!$this->despatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_week->setFormValue($val);
		}

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}

		// Check field name 'production_plan' first before field var 'x_production_plan'
		$val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
		if (!$this->production_plan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_plan->Visible = FALSE; // Disable update for API request
			else
				$this->production_plan->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'updated' first before field var 'x_updated'
		$val = $CurrentForm->hasValue("updated") ? $CurrentForm->getValue("updated") : $CurrentForm->getValue("x_updated");
		if (!$this->updated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->updated->Visible = FALSE; // Disable update for API request
			else
				$this->updated->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'jc_datetime' first before field var 'x_jc_datetime'
		$val = $CurrentForm->hasValue("jc_datetime") ? $CurrentForm->getValue("jc_datetime") : $CurrentForm->getValue("x_jc_datetime");
		if (!$this->jc_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->jc_datetime->setFormValue($val);
			$this->jc_datetime->CurrentValue = UnFormatDateTime($this->jc_datetime->CurrentValue, 0);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'm_out_id' first before field var 'x_m_out_id'
		$val = $CurrentForm->hasValue("m_out_id") ? $CurrentForm->getValue("m_out_id") : $CurrentForm->getValue("x_m_out_id");
		if (!$this->m_out_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_out_id->Visible = FALSE; // Disable update for API request
			else
				$this->m_out_id->setFormValue($val);
		}

		// Check field name 'issued_qty' first before field var 'x_issued_qty'
		$val = $CurrentForm->hasValue("issued_qty") ? $CurrentForm->getValue("issued_qty") : $CurrentForm->getValue("x_issued_qty");
		if (!$this->issued_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issued_qty->Visible = FALSE; // Disable update for API request
			else
				$this->issued_qty->setFormValue($val);
		}

		// Check field name 'pending_qty' first before field var 'x_pending_qty'
		$val = $CurrentForm->hasValue("pending_qty") ? $CurrentForm->getValue("pending_qty") : $CurrentForm->getValue("x_pending_qty");
		if (!$this->pending_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pending_qty->Visible = FALSE; // Disable update for API request
			else
				$this->pending_qty->setFormValue($val);
		}

		// Check field name 'm_out_remarks' first before field var 'x_m_out_remarks'
		$val = $CurrentForm->hasValue("m_out_remarks") ? $CurrentForm->getValue("m_out_remarks") : $CurrentForm->getValue("x_m_out_remarks");
		if (!$this->m_out_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_out_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->m_out_remarks->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->poid->CurrentValue = $this->poid->FormValue;
		$this->jc_no->CurrentValue = $this->jc_no->FormValue;
		$this->location->CurrentValue = $this->location->FormValue;
		$this->issue_to->CurrentValue = $this->issue_to->FormValue;
		$this->week->CurrentValue = $this->week->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->product_id->CurrentValue = $this->product_id->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->size_cm->CurrentValue = $this->size_cm->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->t_sqm->CurrentValue = $this->t_sqm->FormValue;
		$this->req_material_grp->CurrentValue = $this->req_material_grp->FormValue;
		$this->req_material_sgrp->CurrentValue = $this->req_material_sgrp->FormValue;
		$this->req_material_product->CurrentValue = $this->req_material_product->FormValue;
		$this->req_material_rid->CurrentValue = $this->req_material_rid->FormValue;
		$this->req_material_qty->CurrentValue = $this->req_material_qty->FormValue;
		$this->req_material_packing->CurrentValue = $this->req_material_packing->FormValue;
		$this->stock->CurrentValue = $this->stock->FormValue;
		$this->short->CurrentValue = $this->short->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->material_qty->CurrentValue = $this->material_qty->FormValue;
		$this->method->CurrentValue = $this->method->FormValue;
		$this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->production_plan->CurrentValue = $this->production_plan->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->updated->CurrentValue = $this->updated->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->jc_datetime->CurrentValue = $this->jc_datetime->FormValue;
		$this->jc_datetime->CurrentValue = UnFormatDateTime($this->jc_datetime->CurrentValue, 0);
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->m_out_id->CurrentValue = $this->m_out_id->FormValue;
		$this->issued_qty->CurrentValue = $this->issued_qty->FormValue;
		$this->pending_qty->CurrentValue = $this->pending_qty->FormValue;
		$this->m_out_remarks->CurrentValue = $this->m_out_remarks->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->poid->setDbValue($row['poid']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->location->setDbValue($row['location']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->week->setDbValue($row['week']);
		$this->po->setDbValue($row['po']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->product_id->setDbValue($row['product_id']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->size_cm->setDbValue($row['size_cm']);
		$this->sqm->setDbValue($row['sqm']);
		$this->t_sqm->setDbValue($row['t_sqm']);
		$this->req_material_grp->setDbValue($row['req_material_grp']);
		$this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
		$this->req_material_product->setDbValue($row['req_material_product']);
		$this->req_material_rid->setDbValue($row['req_material_rid']);
		$this->req_material_qty->setDbValue($row['req_material_qty']);
		$this->req_material_packing->setDbValue($row['req_material_packing']);
		$this->stock->setDbValue($row['stock']);
		$this->short->setDbValue($row['short']);
		$this->unit->setDbValue($row['unit']);
		$this->material_qty->setDbValue($row['material_qty']);
		$this->method->setDbValue($row['method']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->remarks->setDbValue($row['remarks']);
		$this->updated->setDbValue($row['updated']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->jc_datetime->setDbValue($row['jc_datetime']);
		$this->company_id->setDbValue($row['company_id']);
		$this->m_out_id->setDbValue($row['m_out_id']);
		$this->issued_qty->setDbValue($row['issued_qty']);
		$this->pending_qty->setDbValue($row['pending_qty']);
		$this->m_out_remarks->setDbValue($row['m_out_remarks']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['poid'] = $this->poid->CurrentValue;
		$row['jc_no'] = $this->jc_no->CurrentValue;
		$row['location'] = $this->location->CurrentValue;
		$row['issue_to'] = $this->issue_to->CurrentValue;
		$row['week'] = $this->week->CurrentValue;
		$row['po'] = $this->po->CurrentValue;
		$row['buyer_id'] = $this->buyer_id->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['product_id'] = $this->product_id->CurrentValue;
		$row['batch_no'] = $this->batch_no->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['size_cm'] = $this->size_cm->CurrentValue;
		$row['sqm'] = $this->sqm->CurrentValue;
		$row['t_sqm'] = $this->t_sqm->CurrentValue;
		$row['req_material_grp'] = $this->req_material_grp->CurrentValue;
		$row['req_material_sgrp'] = $this->req_material_sgrp->CurrentValue;
		$row['req_material_product'] = $this->req_material_product->CurrentValue;
		$row['req_material_rid'] = $this->req_material_rid->CurrentValue;
		$row['req_material_qty'] = $this->req_material_qty->CurrentValue;
		$row['req_material_packing'] = $this->req_material_packing->CurrentValue;
		$row['stock'] = $this->stock->CurrentValue;
		$row['short'] = $this->short->CurrentValue;
		$row['unit'] = $this->unit->CurrentValue;
		$row['material_qty'] = $this->material_qty->CurrentValue;
		$row['method'] = $this->method->CurrentValue;
		$row['despatch_week'] = $this->despatch_week->CurrentValue;
		$row['despatch_date'] = $this->despatch_date->CurrentValue;
		$row['production_plan'] = $this->production_plan->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['updated'] = $this->updated->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['jc_datetime'] = $this->jc_datetime->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		$row['m_out_id'] = $this->m_out_id->CurrentValue;
		$row['issued_qty'] = $this->issued_qty->CurrentValue;
		$row['pending_qty'] = $this->pending_qty->CurrentValue;
		$row['m_out_remarks'] = $this->m_out_remarks->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->t_sqm->FormValue == $this->t_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->t_sqm->CurrentValue)))
			$this->t_sqm->CurrentValue = ConvertToFloatString($this->t_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stock->FormValue == $this->stock->CurrentValue && is_numeric(ConvertToFloatString($this->stock->CurrentValue)))
			$this->stock->CurrentValue = ConvertToFloatString($this->stock->CurrentValue);

		// Convert decimal values if posted back
		if ($this->short->FormValue == $this->short->CurrentValue && is_numeric(ConvertToFloatString($this->short->CurrentValue)))
			$this->short->CurrentValue = ConvertToFloatString($this->short->CurrentValue);

		// Convert decimal values if posted back
		if ($this->material_qty->FormValue == $this->material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->material_qty->CurrentValue)))
			$this->material_qty->CurrentValue = ConvertToFloatString($this->material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->issued_qty->FormValue == $this->issued_qty->CurrentValue && is_numeric(ConvertToFloatString($this->issued_qty->CurrentValue)))
			$this->issued_qty->CurrentValue = ConvertToFloatString($this->issued_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_qty->FormValue == $this->pending_qty->CurrentValue && is_numeric(ConvertToFloatString($this->pending_qty->CurrentValue)))
			$this->pending_qty->CurrentValue = ConvertToFloatString($this->pending_qty->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// poid
		// jc_no
		// location
		// issue_to
		// week
		// po
		// buyer_id
		// grp
		// s_grp
		// product
		// product_id
		// batch_no
		// quantity
		// size_cm
		// sqm
		// t_sqm
		// req_material_grp
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_qty
		// req_material_packing
		// stock
		// short
		// unit
		// material_qty
		// method
		// despatch_week
		// despatch_date
		// production_plan
		// remarks
		// updated
		// operator
		// datetime
		// jc_datetime
		// company_id
		// m_out_id
		// issued_qty
		// pending_qty
		// m_out_remarks

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewValue = FormatNumber($this->poid->ViewValue, 0, -2, -2, -2);
			$this->poid->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// location
			$this->location->ViewValue = $this->location->CurrentValue;
			$this->location->ViewValue = FormatNumber($this->location->ViewValue, 0, -2, -2, -2);
			$this->location->ViewCustomAttributes = "";

			// issue_to
			$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
			$this->issue_to->ViewValue = FormatNumber($this->issue_to->ViewValue, 0, -2, -2, -2);
			$this->issue_to->ViewCustomAttributes = "";

			// week
			$this->week->ViewValue = $this->week->CurrentValue;
			$this->week->ViewValue = FormatNumber($this->week->ViewValue, 0, -2, -2, -2);
			$this->week->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$this->buyer_id->ViewValue = FormatNumber($this->buyer_id->ViewValue, 0, -2, -2, -2);
			$this->buyer_id->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
			$this->product->ViewCustomAttributes = "";

			// product_id
			$this->product_id->ViewValue = $this->product_id->CurrentValue;
			$this->product_id->ViewValue = FormatNumber($this->product_id->ViewValue, 0, -2, -2, -2);
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// t_sqm
			$this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
			$this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, 2, -2, -2, -2);
			$this->t_sqm->ViewCustomAttributes = "";

			// req_material_grp
			$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
			$this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, 0, -2, -2, -2);
			$this->req_material_grp->ViewCustomAttributes = "";

			// req_material_sgrp
			$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
			$this->req_material_sgrp->ViewValue = FormatNumber($this->req_material_sgrp->ViewValue, 0, -2, -2, -2);
			$this->req_material_sgrp->ViewCustomAttributes = "";

			// req_material_product
			$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
			$this->req_material_product->ViewValue = FormatNumber($this->req_material_product->ViewValue, 0, -2, -2, -2);
			$this->req_material_product->ViewCustomAttributes = "";

			// req_material_rid
			$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
			$this->req_material_rid->ViewValue = FormatNumber($this->req_material_rid->ViewValue, 0, -2, -2, -2);
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// req_material_packing
			$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
			$this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->ViewValue, 0, -2, -2, -2);
			$this->req_material_packing->ViewCustomAttributes = "";

			// stock
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";

			// short
			$this->short->ViewValue = $this->short->CurrentValue;
			$this->short->ViewValue = FormatNumber($this->short->ViewValue, 2, -2, -2, -2);
			$this->short->ViewCustomAttributes = "";

			// unit
			$this->unit->ViewValue = $this->unit->CurrentValue;
			$this->unit->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
			$this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, 2, -2, -2, -2);
			$this->material_qty->ViewCustomAttributes = "";

			// method
			$this->method->ViewValue = $this->method->CurrentValue;
			$this->method->ViewValue = FormatNumber($this->method->ViewValue, 0, -2, -2, -2);
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
			$this->despatch_week->ViewValue = FormatNumber($this->despatch_week->ViewValue, 0, -2, -2, -2);
			$this->despatch_week->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// production_plan
			$this->production_plan->ViewValue = $this->production_plan->CurrentValue;
			$this->production_plan->ViewValue = FormatNumber($this->production_plan->ViewValue, 0, -2, -2, -2);
			$this->production_plan->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// updated
			$this->updated->ViewValue = $this->updated->CurrentValue;
			$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
			$this->updated->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// jc_datetime
			$this->jc_datetime->ViewValue = $this->jc_datetime->CurrentValue;
			$this->jc_datetime->ViewValue = FormatDateTime($this->jc_datetime->ViewValue, 0);
			$this->jc_datetime->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
			$this->company_id->ViewCustomAttributes = "";

			// m_out_id
			$this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;
			$this->m_out_id->ViewCustomAttributes = "";

			// issued_qty
			$this->issued_qty->ViewValue = $this->issued_qty->CurrentValue;
			$this->issued_qty->ViewValue = FormatNumber($this->issued_qty->ViewValue, 2, -2, -2, -2);
			$this->issued_qty->ViewCustomAttributes = "";

			// pending_qty
			$this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
			$this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, 2, -2, -2, -2);
			$this->pending_qty->ViewCustomAttributes = "";

			// m_out_remarks
			$this->m_out_remarks->ViewValue = $this->m_out_remarks->CurrentValue;
			$this->m_out_remarks->ViewCustomAttributes = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";
			$this->issue_to->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			$this->product_id->HrefValue = "";
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";
			$this->size_cm->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// t_sqm
			$this->t_sqm->LinkCustomAttributes = "";
			$this->t_sqm->HrefValue = "";
			$this->t_sqm->TooltipValue = "";

			// req_material_grp
			$this->req_material_grp->LinkCustomAttributes = "";
			$this->req_material_grp->HrefValue = "";
			$this->req_material_grp->TooltipValue = "";

			// req_material_sgrp
			$this->req_material_sgrp->LinkCustomAttributes = "";
			$this->req_material_sgrp->HrefValue = "";
			$this->req_material_sgrp->TooltipValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";
			$this->req_material_packing->TooltipValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";
			$this->stock->TooltipValue = "";

			// short
			$this->short->LinkCustomAttributes = "";
			$this->short->HrefValue = "";
			$this->short->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// updated
			$this->updated->LinkCustomAttributes = "";
			$this->updated->HrefValue = "";
			$this->updated->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// jc_datetime
			$this->jc_datetime->LinkCustomAttributes = "";
			$this->jc_datetime->HrefValue = "";
			$this->jc_datetime->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// m_out_id
			$this->m_out_id->LinkCustomAttributes = "";
			$this->m_out_id->HrefValue = "";
			$this->m_out_id->TooltipValue = "";

			// issued_qty
			$this->issued_qty->LinkCustomAttributes = "";
			$this->issued_qty->HrefValue = "";
			$this->issued_qty->TooltipValue = "";

			// pending_qty
			$this->pending_qty->LinkCustomAttributes = "";
			$this->pending_qty->HrefValue = "";
			$this->pending_qty->TooltipValue = "";

			// m_out_remarks
			$this->m_out_remarks->LinkCustomAttributes = "";
			$this->m_out_remarks->HrefValue = "";
			$this->m_out_remarks->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// poid
			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = "";
			$this->poid->EditValue = HtmlEncode($this->poid->CurrentValue);
			$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->CurrentValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$this->location->EditValue = HtmlEncode($this->location->CurrentValue);
			$this->location->PlaceHolder = RemoveHtml($this->location->caption());

			// issue_to
			$this->issue_to->EditAttrs["class"] = "form-control";
			$this->issue_to->EditCustomAttributes = "";
			$this->issue_to->EditValue = HtmlEncode($this->issue_to->CurrentValue);
			$this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

			// week
			$this->week->EditAttrs["class"] = "form-control";
			$this->week->EditCustomAttributes = "";
			$this->week->EditValue = HtmlEncode($this->week->CurrentValue);
			$this->week->PlaceHolder = RemoveHtml($this->week->caption());

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->CurrentValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->CurrentValue);
			$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = HtmlEncode($this->grp->CurrentValue);
			$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// product_id
			$this->product_id->EditAttrs["class"] = "form-control";
			$this->product_id->EditCustomAttributes = "";
			$this->product_id->EditValue = HtmlEncode($this->product_id->CurrentValue);
			$this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
			$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

			// size_cm
			$this->size_cm->EditAttrs["class"] = "form-control";
			$this->size_cm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
			$this->size_cm->EditValue = HtmlEncode($this->size_cm->CurrentValue);
			$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->CurrentValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
			if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
				$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

			// t_sqm
			$this->t_sqm->EditAttrs["class"] = "form-control";
			$this->t_sqm->EditCustomAttributes = "";
			$this->t_sqm->EditValue = HtmlEncode($this->t_sqm->CurrentValue);
			$this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());
			if (strval($this->t_sqm->EditValue) <> "" && is_numeric($this->t_sqm->EditValue))
				$this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, -2, -2, -2, -2);

			// req_material_grp
			$this->req_material_grp->EditAttrs["class"] = "form-control";
			$this->req_material_grp->EditCustomAttributes = "";
			$this->req_material_grp->EditValue = HtmlEncode($this->req_material_grp->CurrentValue);
			$this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());

			// req_material_sgrp
			$this->req_material_sgrp->EditAttrs["class"] = "form-control";
			$this->req_material_sgrp->EditCustomAttributes = "";
			$this->req_material_sgrp->EditValue = HtmlEncode($this->req_material_sgrp->CurrentValue);
			$this->req_material_sgrp->PlaceHolder = RemoveHtml($this->req_material_sgrp->caption());

			// req_material_product
			$this->req_material_product->EditAttrs["class"] = "form-control";
			$this->req_material_product->EditCustomAttributes = "";
			$this->req_material_product->EditValue = HtmlEncode($this->req_material_product->CurrentValue);
			$this->req_material_product->PlaceHolder = RemoveHtml($this->req_material_product->caption());

			// req_material_rid
			$this->req_material_rid->EditAttrs["class"] = "form-control";
			$this->req_material_rid->EditCustomAttributes = "";
			$this->req_material_rid->EditValue = HtmlEncode($this->req_material_rid->CurrentValue);
			$this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = HtmlEncode($this->req_material_qty->CurrentValue);
			$this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
			if (strval($this->req_material_qty->EditValue) <> "" && is_numeric($this->req_material_qty->EditValue))
				$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, -2, -2, -2, -2);

			// req_material_packing
			$this->req_material_packing->EditAttrs["class"] = "form-control";
			$this->req_material_packing->EditCustomAttributes = "";
			$this->req_material_packing->EditValue = HtmlEncode($this->req_material_packing->CurrentValue);
			$this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());

			// stock
			$this->stock->EditAttrs["class"] = "form-control";
			$this->stock->EditCustomAttributes = "";
			$this->stock->EditValue = HtmlEncode($this->stock->CurrentValue);
			$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
			if (strval($this->stock->EditValue) <> "" && is_numeric($this->stock->EditValue))
				$this->stock->EditValue = FormatNumber($this->stock->EditValue, -2, -2, -2, -2);

			// short
			$this->short->EditAttrs["class"] = "form-control";
			$this->short->EditCustomAttributes = "";
			$this->short->EditValue = HtmlEncode($this->short->CurrentValue);
			$this->short->PlaceHolder = RemoveHtml($this->short->caption());
			if (strval($this->short->EditValue) <> "" && is_numeric($this->short->EditValue))
				$this->short->EditValue = FormatNumber($this->short->EditValue, -2, -2, -2, -2);

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->unit->CurrentValue = HtmlDecode($this->unit->CurrentValue);
			$this->unit->EditValue = HtmlEncode($this->unit->CurrentValue);
			$this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

			// material_qty
			$this->material_qty->EditAttrs["class"] = "form-control";
			$this->material_qty->EditCustomAttributes = "";
			$this->material_qty->EditValue = HtmlEncode($this->material_qty->CurrentValue);
			$this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());
			if (strval($this->material_qty->EditValue) <> "" && is_numeric($this->material_qty->EditValue))
				$this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, -2, -2, -2, -2);

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$this->method->EditValue = HtmlEncode($this->method->CurrentValue);
			$this->method->PlaceHolder = RemoveHtml($this->method->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$this->despatch_week->EditValue = HtmlEncode($this->despatch_week->CurrentValue);
			$this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			$this->production_plan->EditValue = HtmlEncode($this->production_plan->CurrentValue);
			$this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// updated
			$this->updated->EditAttrs["class"] = "form-control";
			$this->updated->EditCustomAttributes = "";
			$this->updated->EditValue = HtmlEncode($this->updated->CurrentValue);
			$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->CurrentValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// jc_datetime
			$this->jc_datetime->EditAttrs["class"] = "form-control";
			$this->jc_datetime->EditCustomAttributes = "";
			$this->jc_datetime->EditValue = HtmlEncode(FormatDateTime($this->jc_datetime->CurrentValue, 8));
			$this->jc_datetime->PlaceHolder = RemoveHtml($this->jc_datetime->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// m_out_id
			$this->m_out_id->EditAttrs["class"] = "form-control";
			$this->m_out_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->m_out_id->CurrentValue = HtmlDecode($this->m_out_id->CurrentValue);
			$this->m_out_id->EditValue = HtmlEncode($this->m_out_id->CurrentValue);
			$this->m_out_id->PlaceHolder = RemoveHtml($this->m_out_id->caption());

			// issued_qty
			$this->issued_qty->EditAttrs["class"] = "form-control";
			$this->issued_qty->EditCustomAttributes = "";
			$this->issued_qty->EditValue = HtmlEncode($this->issued_qty->CurrentValue);
			$this->issued_qty->PlaceHolder = RemoveHtml($this->issued_qty->caption());
			if (strval($this->issued_qty->EditValue) <> "" && is_numeric($this->issued_qty->EditValue))
				$this->issued_qty->EditValue = FormatNumber($this->issued_qty->EditValue, -2, -2, -2, -2);

			// pending_qty
			$this->pending_qty->EditAttrs["class"] = "form-control";
			$this->pending_qty->EditCustomAttributes = "";
			$this->pending_qty->EditValue = HtmlEncode($this->pending_qty->CurrentValue);
			$this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());
			if (strval($this->pending_qty->EditValue) <> "" && is_numeric($this->pending_qty->EditValue))
				$this->pending_qty->EditValue = FormatNumber($this->pending_qty->EditValue, -2, -2, -2, -2);

			// m_out_remarks
			$this->m_out_remarks->EditAttrs["class"] = "form-control";
			$this->m_out_remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->m_out_remarks->CurrentValue = HtmlDecode($this->m_out_remarks->CurrentValue);
			$this->m_out_remarks->EditValue = HtmlEncode($this->m_out_remarks->CurrentValue);
			$this->m_out_remarks->PlaceHolder = RemoveHtml($this->m_out_remarks->caption());

			// Add refer script
			// poid

			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			$this->product_id->HrefValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";

			// t_sqm
			$this->t_sqm->LinkCustomAttributes = "";
			$this->t_sqm->HrefValue = "";

			// req_material_grp
			$this->req_material_grp->LinkCustomAttributes = "";
			$this->req_material_grp->HrefValue = "";

			// req_material_sgrp
			$this->req_material_sgrp->LinkCustomAttributes = "";
			$this->req_material_sgrp->HrefValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";

			// short
			$this->short->LinkCustomAttributes = "";
			$this->short->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// updated
			$this->updated->LinkCustomAttributes = "";
			$this->updated->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// jc_datetime
			$this->jc_datetime->LinkCustomAttributes = "";
			$this->jc_datetime->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// m_out_id
			$this->m_out_id->LinkCustomAttributes = "";
			$this->m_out_id->HrefValue = "";

			// issued_qty
			$this->issued_qty->LinkCustomAttributes = "";
			$this->issued_qty->HrefValue = "";

			// pending_qty
			$this->pending_qty->LinkCustomAttributes = "";
			$this->pending_qty->HrefValue = "";

			// m_out_remarks
			$this->m_out_remarks->LinkCustomAttributes = "";
			$this->m_out_remarks->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->poid->Required) {
			if (!$this->poid->IsDetailKey && $this->poid->FormValue != NULL && $this->poid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->poid->FormValue)) {
			AddMessage($FormError, $this->poid->errorMessage());
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_no->FormValue)) {
			AddMessage($FormError, $this->jc_no->errorMessage());
		}
		if ($this->location->Required) {
			if (!$this->location->IsDetailKey && $this->location->FormValue != NULL && $this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->location->FormValue)) {
			AddMessage($FormError, $this->location->errorMessage());
		}
		if ($this->issue_to->Required) {
			if (!$this->issue_to->IsDetailKey && $this->issue_to->FormValue != NULL && $this->issue_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->issue_to->FormValue)) {
			AddMessage($FormError, $this->issue_to->errorMessage());
		}
		if ($this->week->Required) {
			if (!$this->week->IsDetailKey && $this->week->FormValue != NULL && $this->week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->week->caption(), $this->week->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->week->FormValue)) {
			AddMessage($FormError, $this->week->errorMessage());
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->po->FormValue)) {
			AddMessage($FormError, $this->po->errorMessage());
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->buyer_id->FormValue)) {
			AddMessage($FormError, $this->buyer_id->errorMessage());
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->grp->FormValue)) {
			AddMessage($FormError, $this->grp->errorMessage());
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->s_grp->FormValue)) {
			AddMessage($FormError, $this->s_grp->errorMessage());
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->product->FormValue)) {
			AddMessage($FormError, $this->product->errorMessage());
		}
		if ($this->product_id->Required) {
			if (!$this->product_id->IsDetailKey && $this->product_id->FormValue != NULL && $this->product_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->product_id->FormValue)) {
			AddMessage($FormError, $this->product_id->errorMessage());
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->batch_no->FormValue)) {
			AddMessage($FormError, $this->batch_no->errorMessage());
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->size_cm->Required) {
			if (!$this->size_cm->IsDetailKey && $this->size_cm->FormValue != NULL && $this->size_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size_cm->caption(), $this->size_cm->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->sqm->FormValue)) {
			AddMessage($FormError, $this->sqm->errorMessage());
		}
		if ($this->t_sqm->Required) {
			if (!$this->t_sqm->IsDetailKey && $this->t_sqm->FormValue != NULL && $this->t_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_sqm->caption(), $this->t_sqm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->t_sqm->FormValue)) {
			AddMessage($FormError, $this->t_sqm->errorMessage());
		}
		if ($this->req_material_grp->Required) {
			if (!$this->req_material_grp->IsDetailKey && $this->req_material_grp->FormValue != NULL && $this->req_material_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_grp->caption(), $this->req_material_grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->req_material_grp->FormValue)) {
			AddMessage($FormError, $this->req_material_grp->errorMessage());
		}
		if ($this->req_material_sgrp->Required) {
			if (!$this->req_material_sgrp->IsDetailKey && $this->req_material_sgrp->FormValue != NULL && $this->req_material_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_sgrp->caption(), $this->req_material_sgrp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->req_material_sgrp->FormValue)) {
			AddMessage($FormError, $this->req_material_sgrp->errorMessage());
		}
		if ($this->req_material_product->Required) {
			if (!$this->req_material_product->IsDetailKey && $this->req_material_product->FormValue != NULL && $this->req_material_product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_product->caption(), $this->req_material_product->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->req_material_product->FormValue)) {
			AddMessage($FormError, $this->req_material_product->errorMessage());
		}
		if ($this->req_material_rid->Required) {
			if (!$this->req_material_rid->IsDetailKey && $this->req_material_rid->FormValue != NULL && $this->req_material_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_rid->caption(), $this->req_material_rid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->req_material_rid->FormValue)) {
			AddMessage($FormError, $this->req_material_rid->errorMessage());
		}
		if ($this->req_material_qty->Required) {
			if (!$this->req_material_qty->IsDetailKey && $this->req_material_qty->FormValue != NULL && $this->req_material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_qty->caption(), $this->req_material_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->req_material_qty->FormValue)) {
			AddMessage($FormError, $this->req_material_qty->errorMessage());
		}
		if ($this->req_material_packing->Required) {
			if (!$this->req_material_packing->IsDetailKey && $this->req_material_packing->FormValue != NULL && $this->req_material_packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_packing->caption(), $this->req_material_packing->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->req_material_packing->FormValue)) {
			AddMessage($FormError, $this->req_material_packing->errorMessage());
		}
		if ($this->stock->Required) {
			if (!$this->stock->IsDetailKey && $this->stock->FormValue != NULL && $this->stock->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->stock->caption(), $this->stock->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->stock->FormValue)) {
			AddMessage($FormError, $this->stock->errorMessage());
		}
		if ($this->short->Required) {
			if (!$this->short->IsDetailKey && $this->short->FormValue != NULL && $this->short->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->short->caption(), $this->short->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->short->FormValue)) {
			AddMessage($FormError, $this->short->errorMessage());
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->material_qty->Required) {
			if (!$this->material_qty->IsDetailKey && $this->material_qty->FormValue != NULL && $this->material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_qty->caption(), $this->material_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->material_qty->FormValue)) {
			AddMessage($FormError, $this->material_qty->errorMessage());
		}
		if ($this->method->Required) {
			if (!$this->method->IsDetailKey && $this->method->FormValue != NULL && $this->method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->method->FormValue)) {
			AddMessage($FormError, $this->method->errorMessage());
		}
		if ($this->despatch_week->Required) {
			if (!$this->despatch_week->IsDetailKey && $this->despatch_week->FormValue != NULL && $this->despatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->despatch_week->FormValue)) {
			AddMessage($FormError, $this->despatch_week->errorMessage());
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_date->FormValue)) {
			AddMessage($FormError, $this->despatch_date->errorMessage());
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->production_plan->FormValue)) {
			AddMessage($FormError, $this->production_plan->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->updated->FormValue)) {
			AddMessage($FormError, $this->updated->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->operator->FormValue)) {
			AddMessage($FormError, $this->operator->errorMessage());
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->datetime->FormValue)) {
			AddMessage($FormError, $this->datetime->errorMessage());
		}
		if ($this->jc_datetime->Required) {
			if (!$this->jc_datetime->IsDetailKey && $this->jc_datetime->FormValue != NULL && $this->jc_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_datetime->caption(), $this->jc_datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->jc_datetime->FormValue)) {
			AddMessage($FormError, $this->jc_datetime->errorMessage());
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->m_out_id->Required) {
			if (!$this->m_out_id->IsDetailKey && $this->m_out_id->FormValue != NULL && $this->m_out_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_out_id->caption(), $this->m_out_id->RequiredErrorMessage));
			}
		}
		if ($this->issued_qty->Required) {
			if (!$this->issued_qty->IsDetailKey && $this->issued_qty->FormValue != NULL && $this->issued_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issued_qty->caption(), $this->issued_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->issued_qty->FormValue)) {
			AddMessage($FormError, $this->issued_qty->errorMessage());
		}
		if ($this->pending_qty->Required) {
			if (!$this->pending_qty->IsDetailKey && $this->pending_qty->FormValue != NULL && $this->pending_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pending_qty->caption(), $this->pending_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->pending_qty->FormValue)) {
			AddMessage($FormError, $this->pending_qty->errorMessage());
		}
		if ($this->m_out_remarks->Required) {
			if (!$this->m_out_remarks->IsDetailKey && $this->m_out_remarks->FormValue != NULL && $this->m_out_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_out_remarks->caption(), $this->m_out_remarks->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// poid
		$this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, 0, FALSE);

		// jc_no
		$this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, NULL, FALSE);

		// location
		$this->location->setDbValueDef($rsnew, $this->location->CurrentValue, NULL, FALSE);

		// issue_to
		$this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, 0, FALSE);

		// week
		$this->week->setDbValueDef($rsnew, $this->week->CurrentValue, 0, FALSE);

		// po
		$this->po->setDbValueDef($rsnew, $this->po->CurrentValue, NULL, FALSE);

		// buyer_id
		$this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, 0, FALSE);

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, 0, FALSE);

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, 0, FALSE);

		// product_id
		$this->product_id->setDbValueDef($rsnew, $this->product_id->CurrentValue, NULL, FALSE);

		// batch_no
		$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, 0, FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, FALSE);

		// size_cm
		$this->size_cm->setDbValueDef($rsnew, $this->size_cm->CurrentValue, NULL, FALSE);

		// sqm
		$this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, NULL, FALSE);

		// t_sqm
		$this->t_sqm->setDbValueDef($rsnew, $this->t_sqm->CurrentValue, NULL, FALSE);

		// req_material_grp
		$this->req_material_grp->setDbValueDef($rsnew, $this->req_material_grp->CurrentValue, NULL, FALSE);

		// req_material_sgrp
		$this->req_material_sgrp->setDbValueDef($rsnew, $this->req_material_sgrp->CurrentValue, NULL, FALSE);

		// req_material_product
		$this->req_material_product->setDbValueDef($rsnew, $this->req_material_product->CurrentValue, NULL, FALSE);

		// req_material_rid
		$this->req_material_rid->setDbValueDef($rsnew, $this->req_material_rid->CurrentValue, NULL, FALSE);

		// req_material_qty
		$this->req_material_qty->setDbValueDef($rsnew, $this->req_material_qty->CurrentValue, 0, strval($this->req_material_qty->CurrentValue) == "");

		// req_material_packing
		$this->req_material_packing->setDbValueDef($rsnew, $this->req_material_packing->CurrentValue, 0, FALSE);

		// stock
		$this->stock->setDbValueDef($rsnew, $this->stock->CurrentValue, 0, strval($this->stock->CurrentValue) == "");

		// short
		$this->short->setDbValueDef($rsnew, $this->short->CurrentValue, 0, FALSE);

		// unit
		$this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, NULL, FALSE);

		// material_qty
		$this->material_qty->setDbValueDef($rsnew, $this->material_qty->CurrentValue, NULL, FALSE);

		// method
		$this->method->setDbValueDef($rsnew, $this->method->CurrentValue, NULL, FALSE);

		// despatch_week
		$this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, NULL, FALSE);

		// despatch_date
		$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), CurrentDate(), FALSE);

		// production_plan
		$this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, NULL, FALSE);

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, "", FALSE);

		// updated
		$this->updated->setDbValueDef($rsnew, $this->updated->CurrentValue, 0, strval($this->updated->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, NULL, strval($this->operator->CurrentValue) == "");

		// datetime
		$this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, 0), CurrentDate(), FALSE);

		// jc_datetime
		$this->jc_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->jc_datetime->CurrentValue, 0), NULL, FALSE);

		// company_id
		$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, FALSE);

		// m_out_id
		$this->m_out_id->setDbValueDef($rsnew, $this->m_out_id->CurrentValue, NULL, FALSE);

		// issued_qty
		$this->issued_qty->setDbValueDef($rsnew, $this->issued_qty->CurrentValue, NULL, FALSE);

		// pending_qty
		$this->pending_qty->setDbValueDef($rsnew, $this->pending_qty->CurrentValue, NULL, FALSE);

		// m_out_remarks
		$this->m_out_remarks->setDbValueDef($rsnew, $this->m_out_remarks->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("material_required_job_cardlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>