<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_required_job_card_delete extends material_required_job_card
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_required_job_card';

	// Page object name
	public $PageObjName = "material_required_job_card_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_required_job_card)
		if (!isset($GLOBALS["material_required_job_card"]) || get_class($GLOBALS["material_required_job_card"]) == PROJECT_NAMESPACE . "material_required_job_card") {
			$GLOBALS["material_required_job_card"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_required_job_card"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required_job_card');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_required_job_card;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_required_job_card);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $TotalRecs = 0;
	public $RecCnt;
	public $RecKeys = array();
	public $StartRowCnt = 1;
	public $RowCnt = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("material_required_job_cardlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->poid->setVisibility();
		$this->jc_no->setVisibility();
		$this->location->setVisibility();
		$this->issue_to->setVisibility();
		$this->week->setVisibility();
		$this->po->setVisibility();
		$this->buyer_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_id->setVisibility();
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->size_cm->setVisibility();
		$this->sqm->setVisibility();
		$this->t_sqm->setVisibility();
		$this->req_material_grp->setVisibility();
		$this->req_material_sgrp->setVisibility();
		$this->req_material_product->setVisibility();
		$this->req_material_rid->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->req_material_packing->setVisibility();
		$this->stock->setVisibility();
		$this->short->setVisibility();
		$this->unit->setVisibility();
		$this->material_qty->setVisibility();
		$this->method->setVisibility();
		$this->despatch_week->setVisibility();
		$this->despatch_date->setVisibility();
		$this->production_plan->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->updated->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->jc_datetime->setVisibility();
		$this->company_id->setVisibility();
		$this->m_out_id->setVisibility();
		$this->issued_qty->setVisibility();
		$this->pending_qty->setVisibility();
		$this->m_out_remarks->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Set up Breadcrumb

		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("material_required_job_cardlist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("material_required_job_cardlist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->poid->setDbValue($row['poid']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->location->setDbValue($row['location']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->week->setDbValue($row['week']);
		$this->po->setDbValue($row['po']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->product_id->setDbValue($row['product_id']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->size_cm->setDbValue($row['size_cm']);
		$this->sqm->setDbValue($row['sqm']);
		$this->t_sqm->setDbValue($row['t_sqm']);
		$this->req_material_grp->setDbValue($row['req_material_grp']);
		$this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
		$this->req_material_product->setDbValue($row['req_material_product']);
		$this->req_material_rid->setDbValue($row['req_material_rid']);
		$this->req_material_qty->setDbValue($row['req_material_qty']);
		$this->req_material_packing->setDbValue($row['req_material_packing']);
		$this->stock->setDbValue($row['stock']);
		$this->short->setDbValue($row['short']);
		$this->unit->setDbValue($row['unit']);
		$this->material_qty->setDbValue($row['material_qty']);
		$this->method->setDbValue($row['method']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->remarks->setDbValue($row['remarks']);
		$this->updated->setDbValue($row['updated']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->jc_datetime->setDbValue($row['jc_datetime']);
		$this->company_id->setDbValue($row['company_id']);
		$this->m_out_id->setDbValue($row['m_out_id']);
		$this->issued_qty->setDbValue($row['issued_qty']);
		$this->pending_qty->setDbValue($row['pending_qty']);
		$this->m_out_remarks->setDbValue($row['m_out_remarks']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['poid'] = NULL;
		$row['jc_no'] = NULL;
		$row['location'] = NULL;
		$row['issue_to'] = NULL;
		$row['week'] = NULL;
		$row['po'] = NULL;
		$row['buyer_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['product_id'] = NULL;
		$row['batch_no'] = NULL;
		$row['quantity'] = NULL;
		$row['size_cm'] = NULL;
		$row['sqm'] = NULL;
		$row['t_sqm'] = NULL;
		$row['req_material_grp'] = NULL;
		$row['req_material_sgrp'] = NULL;
		$row['req_material_product'] = NULL;
		$row['req_material_rid'] = NULL;
		$row['req_material_qty'] = NULL;
		$row['req_material_packing'] = NULL;
		$row['stock'] = NULL;
		$row['short'] = NULL;
		$row['unit'] = NULL;
		$row['material_qty'] = NULL;
		$row['method'] = NULL;
		$row['despatch_week'] = NULL;
		$row['despatch_date'] = NULL;
		$row['production_plan'] = NULL;
		$row['remarks'] = NULL;
		$row['updated'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['jc_datetime'] = NULL;
		$row['company_id'] = NULL;
		$row['m_out_id'] = NULL;
		$row['issued_qty'] = NULL;
		$row['pending_qty'] = NULL;
		$row['m_out_remarks'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->t_sqm->FormValue == $this->t_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->t_sqm->CurrentValue)))
			$this->t_sqm->CurrentValue = ConvertToFloatString($this->t_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stock->FormValue == $this->stock->CurrentValue && is_numeric(ConvertToFloatString($this->stock->CurrentValue)))
			$this->stock->CurrentValue = ConvertToFloatString($this->stock->CurrentValue);

		// Convert decimal values if posted back
		if ($this->short->FormValue == $this->short->CurrentValue && is_numeric(ConvertToFloatString($this->short->CurrentValue)))
			$this->short->CurrentValue = ConvertToFloatString($this->short->CurrentValue);

		// Convert decimal values if posted back
		if ($this->material_qty->FormValue == $this->material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->material_qty->CurrentValue)))
			$this->material_qty->CurrentValue = ConvertToFloatString($this->material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->issued_qty->FormValue == $this->issued_qty->CurrentValue && is_numeric(ConvertToFloatString($this->issued_qty->CurrentValue)))
			$this->issued_qty->CurrentValue = ConvertToFloatString($this->issued_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_qty->FormValue == $this->pending_qty->CurrentValue && is_numeric(ConvertToFloatString($this->pending_qty->CurrentValue)))
			$this->pending_qty->CurrentValue = ConvertToFloatString($this->pending_qty->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// poid
		// jc_no
		// location
		// issue_to
		// week
		// po
		// buyer_id
		// grp
		// s_grp
		// product
		// product_id
		// batch_no
		// quantity
		// size_cm
		// sqm
		// t_sqm
		// req_material_grp
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_qty
		// req_material_packing
		// stock
		// short
		// unit
		// material_qty
		// method
		// despatch_week
		// despatch_date
		// production_plan
		// remarks
		// updated
		// operator
		// datetime
		// jc_datetime
		// company_id
		// m_out_id
		// issued_qty
		// pending_qty
		// m_out_remarks

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewValue = FormatNumber($this->poid->ViewValue, 0, -2, -2, -2);
			$this->poid->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// location
			$this->location->ViewValue = $this->location->CurrentValue;
			$this->location->ViewValue = FormatNumber($this->location->ViewValue, 0, -2, -2, -2);
			$this->location->ViewCustomAttributes = "";

			// issue_to
			$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
			$this->issue_to->ViewValue = FormatNumber($this->issue_to->ViewValue, 0, -2, -2, -2);
			$this->issue_to->ViewCustomAttributes = "";

			// week
			$this->week->ViewValue = $this->week->CurrentValue;
			$this->week->ViewValue = FormatNumber($this->week->ViewValue, 0, -2, -2, -2);
			$this->week->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$this->buyer_id->ViewValue = FormatNumber($this->buyer_id->ViewValue, 0, -2, -2, -2);
			$this->buyer_id->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
			$this->product->ViewCustomAttributes = "";

			// product_id
			$this->product_id->ViewValue = $this->product_id->CurrentValue;
			$this->product_id->ViewValue = FormatNumber($this->product_id->ViewValue, 0, -2, -2, -2);
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// t_sqm
			$this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
			$this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, 2, -2, -2, -2);
			$this->t_sqm->ViewCustomAttributes = "";

			// req_material_grp
			$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
			$this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, 0, -2, -2, -2);
			$this->req_material_grp->ViewCustomAttributes = "";

			// req_material_sgrp
			$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
			$this->req_material_sgrp->ViewValue = FormatNumber($this->req_material_sgrp->ViewValue, 0, -2, -2, -2);
			$this->req_material_sgrp->ViewCustomAttributes = "";

			// req_material_product
			$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
			$this->req_material_product->ViewValue = FormatNumber($this->req_material_product->ViewValue, 0, -2, -2, -2);
			$this->req_material_product->ViewCustomAttributes = "";

			// req_material_rid
			$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
			$this->req_material_rid->ViewValue = FormatNumber($this->req_material_rid->ViewValue, 0, -2, -2, -2);
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// req_material_packing
			$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
			$this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->ViewValue, 0, -2, -2, -2);
			$this->req_material_packing->ViewCustomAttributes = "";

			// stock
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";

			// short
			$this->short->ViewValue = $this->short->CurrentValue;
			$this->short->ViewValue = FormatNumber($this->short->ViewValue, 2, -2, -2, -2);
			$this->short->ViewCustomAttributes = "";

			// unit
			$this->unit->ViewValue = $this->unit->CurrentValue;
			$this->unit->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
			$this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, 2, -2, -2, -2);
			$this->material_qty->ViewCustomAttributes = "";

			// method
			$this->method->ViewValue = $this->method->CurrentValue;
			$this->method->ViewValue = FormatNumber($this->method->ViewValue, 0, -2, -2, -2);
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
			$this->despatch_week->ViewValue = FormatNumber($this->despatch_week->ViewValue, 0, -2, -2, -2);
			$this->despatch_week->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// production_plan
			$this->production_plan->ViewValue = $this->production_plan->CurrentValue;
			$this->production_plan->ViewValue = FormatNumber($this->production_plan->ViewValue, 0, -2, -2, -2);
			$this->production_plan->ViewCustomAttributes = "";

			// updated
			$this->updated->ViewValue = $this->updated->CurrentValue;
			$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
			$this->updated->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// jc_datetime
			$this->jc_datetime->ViewValue = $this->jc_datetime->CurrentValue;
			$this->jc_datetime->ViewValue = FormatDateTime($this->jc_datetime->ViewValue, 0);
			$this->jc_datetime->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
			$this->company_id->ViewCustomAttributes = "";

			// m_out_id
			$this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;
			$this->m_out_id->ViewCustomAttributes = "";

			// issued_qty
			$this->issued_qty->ViewValue = $this->issued_qty->CurrentValue;
			$this->issued_qty->ViewValue = FormatNumber($this->issued_qty->ViewValue, 2, -2, -2, -2);
			$this->issued_qty->ViewCustomAttributes = "";

			// pending_qty
			$this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
			$this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, 2, -2, -2, -2);
			$this->pending_qty->ViewCustomAttributes = "";

			// m_out_remarks
			$this->m_out_remarks->ViewValue = $this->m_out_remarks->CurrentValue;
			$this->m_out_remarks->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";
			$this->issue_to->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			$this->product_id->HrefValue = "";
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";
			$this->size_cm->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// t_sqm
			$this->t_sqm->LinkCustomAttributes = "";
			$this->t_sqm->HrefValue = "";
			$this->t_sqm->TooltipValue = "";

			// req_material_grp
			$this->req_material_grp->LinkCustomAttributes = "";
			$this->req_material_grp->HrefValue = "";
			$this->req_material_grp->TooltipValue = "";

			// req_material_sgrp
			$this->req_material_sgrp->LinkCustomAttributes = "";
			$this->req_material_sgrp->HrefValue = "";
			$this->req_material_sgrp->TooltipValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";
			$this->req_material_packing->TooltipValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";
			$this->stock->TooltipValue = "";

			// short
			$this->short->LinkCustomAttributes = "";
			$this->short->HrefValue = "";
			$this->short->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// updated
			$this->updated->LinkCustomAttributes = "";
			$this->updated->HrefValue = "";
			$this->updated->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// jc_datetime
			$this->jc_datetime->LinkCustomAttributes = "";
			$this->jc_datetime->HrefValue = "";
			$this->jc_datetime->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// m_out_id
			$this->m_out_id->LinkCustomAttributes = "";
			$this->m_out_id->HrefValue = "";
			$this->m_out_id->TooltipValue = "";

			// issued_qty
			$this->issued_qty->LinkCustomAttributes = "";
			$this->issued_qty->HrefValue = "";
			$this->issued_qty->TooltipValue = "";

			// pending_qty
			$this->pending_qty->LinkCustomAttributes = "";
			$this->pending_qty->HrefValue = "";
			$this->pending_qty->TooltipValue = "";

			// m_out_remarks
			$this->m_out_remarks->LinkCustomAttributes = "";
			$this->m_out_remarks->HrefValue = "";
			$this->m_out_remarks->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("material_required_job_cardlist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>