<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_required_list extends material_required
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_required';

	// Page object name
	public $PageObjName = "material_required_list";

	// Grid form hidden field names
	public $FormName = "fmaterial_requiredlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_required)
		if (!isset($GLOBALS["material_required"]) || get_class($GLOBALS["material_required"]) == PROJECT_NAMESPACE . "material_required") {
			$GLOBALS["material_required"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_required"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "material_requiredadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "material_requireddelete.php";
		$this->MultiUpdateUrl = "material_requiredupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Table object (required_material_compiled)
		if (!isset($GLOBALS['required_material_compiled']))
			$GLOBALS['required_material_compiled'] = new required_material_compiled();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fmaterial_requiredlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_required;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_required);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->poid->setVisibility();
		$this->po->setVisibility();
		$this->week->setVisibility();
		$this->buyer_id->setVisibility();
		$this->product_id->setVisibility();
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->Size_wl->setVisibility();
		$this->grp->Visible = FALSE;
		$this->sqm->setVisibility();
		$this->t_sqm->setVisibility();
		$this->unit->setVisibility();
		$this->material_qty->setVisibility();
		$this->method->setVisibility();
		$this->despatch_week->setVisibility();
		$this->production_plan->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->updated->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->req_material_grp->Visible = FALSE;
		$this->req_material_sgrp->Visible = FALSE;
		$this->req_material_product->Visible = FALSE;
		$this->req_material_rid->setVisibility();
		$this->req_material_packing->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->s_grp->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->material_out->Visible = FALSE;
		$this->material_out_id->Visible = FALSE;
		$this->operator->setVisibility();
		$this->despatch_date->setVisibility();
		$this->order_id->setVisibility();
		$this->weaving_works->setVisibility();
		$this->issue_material_grp->Visible = FALSE;
		$this->issue_material_sgrp->Visible = FALSE;
		$this->issue_material_product->Visible = FALSE;
		$this->issue_material_rid->Visible = FALSE;
		$this->issue_material_packing->Visible = FALSE;
		$this->issue_material_qty->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->issue_material_lcgp_rid->setVisibility();
		$this->issue_material_lot_no->setVisibility();
		$this->issue_material_godown->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up master detail parameters
		$this->setupMasterParms();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->product_id);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->req_material_sgrp);
		$this->setupLookupOptions($this->req_material_product);
		$this->setupLookupOptions($this->req_material_rid);
		$this->setupLookupOptions($this->req_material_packing);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records

		// Restore master/detail filter
		$this->DbMasterFilter = $this->getMasterFilter(); // Restore master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Restore detail filter
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Load master record
		if ($this->CurrentMode <> "add" && $this->getMasterFilter() <> "" && $this->getCurrentMasterTable() == "required_material_compiled") {
			global $required_material_compiled;
			$rsmaster = $required_material_compiled->loadRs($this->DbMasterFilter);
			$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
			if (!$this->MasterRecordExists) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
				$this->terminate("required_material_compiledlist.php"); // Return to master page
			} else {
				$required_material_compiled->loadListRowValues($rsmaster);
				$required_material_compiled->RowType = ROWTYPE_MASTER; // Master row
				$required_material_compiled->renderListRow();
				$rsmaster->close();
			}
		}

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fmaterial_requiredlistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->poid->AdvancedSearch->toJson(), ","); // Field poid
		$filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
		$filterList = Concat($filterList, $this->week->AdvancedSearch->toJson(), ","); // Field week
		$filterList = Concat($filterList, $this->buyer_id->AdvancedSearch->toJson(), ","); // Field buyer_id
		$filterList = Concat($filterList, $this->product_id->AdvancedSearch->toJson(), ","); // Field product_id
		$filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->Size_wl->AdvancedSearch->toJson(), ","); // Field Size_wl
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->t_sqm->AdvancedSearch->toJson(), ","); // Field t_sqm
		$filterList = Concat($filterList, $this->unit->AdvancedSearch->toJson(), ","); // Field unit
		$filterList = Concat($filterList, $this->material_qty->AdvancedSearch->toJson(), ","); // Field material_qty
		$filterList = Concat($filterList, $this->method->AdvancedSearch->toJson(), ","); // Field method
		$filterList = Concat($filterList, $this->despatch_week->AdvancedSearch->toJson(), ","); // Field despatch_week
		$filterList = Concat($filterList, $this->production_plan->AdvancedSearch->toJson(), ","); // Field production_plan
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->req_material_grp->AdvancedSearch->toJson(), ","); // Field req_material_grp
		$filterList = Concat($filterList, $this->req_material_sgrp->AdvancedSearch->toJson(), ","); // Field req_material_sgrp
		$filterList = Concat($filterList, $this->req_material_product->AdvancedSearch->toJson(), ","); // Field req_material_product
		$filterList = Concat($filterList, $this->req_material_rid->AdvancedSearch->toJson(), ","); // Field req_material_rid
		$filterList = Concat($filterList, $this->req_material_packing->AdvancedSearch->toJson(), ","); // Field req_material_packing
		$filterList = Concat($filterList, $this->req_material_qty->AdvancedSearch->toJson(), ","); // Field req_material_qty
		$filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
		$filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
		$filterList = Concat($filterList, $this->material_out->AdvancedSearch->toJson(), ","); // Field material_out
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->despatch_date->AdvancedSearch->toJson(), ","); // Field despatch_date
		$filterList = Concat($filterList, $this->weaving_works->AdvancedSearch->toJson(), ","); // Field weaving_works
		$filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
		$filterList = Concat($filterList, $this->issue_material_lcgp_rid->AdvancedSearch->toJson(), ","); // Field issue_material_lcgp_rid
		$filterList = Concat($filterList, $this->issue_material_lot_no->AdvancedSearch->toJson(), ","); // Field issue_material_lot_no
		$filterList = Concat($filterList, $this->issue_material_godown->AdvancedSearch->toJson(), ","); // Field issue_material_godown
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fmaterial_requiredlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field poid
		$this->poid->AdvancedSearch->SearchValue = @$filter["x_poid"];
		$this->poid->AdvancedSearch->SearchOperator = @$filter["z_poid"];
		$this->poid->AdvancedSearch->SearchCondition = @$filter["v_poid"];
		$this->poid->AdvancedSearch->SearchValue2 = @$filter["y_poid"];
		$this->poid->AdvancedSearch->SearchOperator2 = @$filter["w_poid"];
		$this->poid->AdvancedSearch->save();

		// Field po
		$this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
		$this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
		$this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
		$this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
		$this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
		$this->po->AdvancedSearch->save();

		// Field week
		$this->week->AdvancedSearch->SearchValue = @$filter["x_week"];
		$this->week->AdvancedSearch->SearchOperator = @$filter["z_week"];
		$this->week->AdvancedSearch->SearchCondition = @$filter["v_week"];
		$this->week->AdvancedSearch->SearchValue2 = @$filter["y_week"];
		$this->week->AdvancedSearch->SearchOperator2 = @$filter["w_week"];
		$this->week->AdvancedSearch->save();

		// Field buyer_id
		$this->buyer_id->AdvancedSearch->SearchValue = @$filter["x_buyer_id"];
		$this->buyer_id->AdvancedSearch->SearchOperator = @$filter["z_buyer_id"];
		$this->buyer_id->AdvancedSearch->SearchCondition = @$filter["v_buyer_id"];
		$this->buyer_id->AdvancedSearch->SearchValue2 = @$filter["y_buyer_id"];
		$this->buyer_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_id"];
		$this->buyer_id->AdvancedSearch->save();

		// Field product_id
		$this->product_id->AdvancedSearch->SearchValue = @$filter["x_product_id"];
		$this->product_id->AdvancedSearch->SearchOperator = @$filter["z_product_id"];
		$this->product_id->AdvancedSearch->SearchCondition = @$filter["v_product_id"];
		$this->product_id->AdvancedSearch->SearchValue2 = @$filter["y_product_id"];
		$this->product_id->AdvancedSearch->SearchOperator2 = @$filter["w_product_id"];
		$this->product_id->AdvancedSearch->save();

		// Field batch_no
		$this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
		$this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
		$this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
		$this->batch_no->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field Size_wl
		$this->Size_wl->AdvancedSearch->SearchValue = @$filter["x_Size_wl"];
		$this->Size_wl->AdvancedSearch->SearchOperator = @$filter["z_Size_wl"];
		$this->Size_wl->AdvancedSearch->SearchCondition = @$filter["v_Size_wl"];
		$this->Size_wl->AdvancedSearch->SearchValue2 = @$filter["y_Size_wl"];
		$this->Size_wl->AdvancedSearch->SearchOperator2 = @$filter["w_Size_wl"];
		$this->Size_wl->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field t_sqm
		$this->t_sqm->AdvancedSearch->SearchValue = @$filter["x_t_sqm"];
		$this->t_sqm->AdvancedSearch->SearchOperator = @$filter["z_t_sqm"];
		$this->t_sqm->AdvancedSearch->SearchCondition = @$filter["v_t_sqm"];
		$this->t_sqm->AdvancedSearch->SearchValue2 = @$filter["y_t_sqm"];
		$this->t_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_t_sqm"];
		$this->t_sqm->AdvancedSearch->save();

		// Field unit
		$this->unit->AdvancedSearch->SearchValue = @$filter["x_unit"];
		$this->unit->AdvancedSearch->SearchOperator = @$filter["z_unit"];
		$this->unit->AdvancedSearch->SearchCondition = @$filter["v_unit"];
		$this->unit->AdvancedSearch->SearchValue2 = @$filter["y_unit"];
		$this->unit->AdvancedSearch->SearchOperator2 = @$filter["w_unit"];
		$this->unit->AdvancedSearch->save();

		// Field material_qty
		$this->material_qty->AdvancedSearch->SearchValue = @$filter["x_material_qty"];
		$this->material_qty->AdvancedSearch->SearchOperator = @$filter["z_material_qty"];
		$this->material_qty->AdvancedSearch->SearchCondition = @$filter["v_material_qty"];
		$this->material_qty->AdvancedSearch->SearchValue2 = @$filter["y_material_qty"];
		$this->material_qty->AdvancedSearch->SearchOperator2 = @$filter["w_material_qty"];
		$this->material_qty->AdvancedSearch->save();

		// Field method
		$this->method->AdvancedSearch->SearchValue = @$filter["x_method"];
		$this->method->AdvancedSearch->SearchOperator = @$filter["z_method"];
		$this->method->AdvancedSearch->SearchCondition = @$filter["v_method"];
		$this->method->AdvancedSearch->SearchValue2 = @$filter["y_method"];
		$this->method->AdvancedSearch->SearchOperator2 = @$filter["w_method"];
		$this->method->AdvancedSearch->save();

		// Field despatch_week
		$this->despatch_week->AdvancedSearch->SearchValue = @$filter["x_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchOperator = @$filter["z_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchCondition = @$filter["v_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchValue2 = @$filter["y_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_week"];
		$this->despatch_week->AdvancedSearch->save();

		// Field production_plan
		$this->production_plan->AdvancedSearch->SearchValue = @$filter["x_production_plan"];
		$this->production_plan->AdvancedSearch->SearchOperator = @$filter["z_production_plan"];
		$this->production_plan->AdvancedSearch->SearchCondition = @$filter["v_production_plan"];
		$this->production_plan->AdvancedSearch->SearchValue2 = @$filter["y_production_plan"];
		$this->production_plan->AdvancedSearch->SearchOperator2 = @$filter["w_production_plan"];
		$this->production_plan->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field req_material_grp
		$this->req_material_grp->AdvancedSearch->SearchValue = @$filter["x_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->SearchOperator = @$filter["z_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->SearchCondition = @$filter["v_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->SearchValue2 = @$filter["y_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->save();

		// Field req_material_sgrp
		$this->req_material_sgrp->AdvancedSearch->SearchValue = @$filter["x_req_material_sgrp"];
		$this->req_material_sgrp->AdvancedSearch->SearchOperator = @$filter["z_req_material_sgrp"];
		$this->req_material_sgrp->AdvancedSearch->SearchCondition = @$filter["v_req_material_sgrp"];
		$this->req_material_sgrp->AdvancedSearch->SearchValue2 = @$filter["y_req_material_sgrp"];
		$this->req_material_sgrp->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_sgrp"];
		$this->req_material_sgrp->AdvancedSearch->save();

		// Field req_material_product
		$this->req_material_product->AdvancedSearch->SearchValue = @$filter["x_req_material_product"];
		$this->req_material_product->AdvancedSearch->SearchOperator = @$filter["z_req_material_product"];
		$this->req_material_product->AdvancedSearch->SearchCondition = @$filter["v_req_material_product"];
		$this->req_material_product->AdvancedSearch->SearchValue2 = @$filter["y_req_material_product"];
		$this->req_material_product->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_product"];
		$this->req_material_product->AdvancedSearch->save();

		// Field req_material_rid
		$this->req_material_rid->AdvancedSearch->SearchValue = @$filter["x_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->SearchOperator = @$filter["z_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->SearchCondition = @$filter["v_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->SearchValue2 = @$filter["y_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->save();

		// Field req_material_packing
		$this->req_material_packing->AdvancedSearch->SearchValue = @$filter["x_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->SearchOperator = @$filter["z_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->SearchCondition = @$filter["v_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->SearchValue2 = @$filter["y_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->save();

		// Field req_material_qty
		$this->req_material_qty->AdvancedSearch->SearchValue = @$filter["x_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->SearchOperator = @$filter["z_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->SearchCondition = @$filter["v_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->SearchValue2 = @$filter["y_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->save();

		// Field s_grp
		$this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
		$this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
		$this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
		$this->s_grp->AdvancedSearch->save();

		// Field product
		$this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
		$this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
		$this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
		$this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
		$this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
		$this->product->AdvancedSearch->save();

		// Field material_out
		$this->material_out->AdvancedSearch->SearchValue = @$filter["x_material_out"];
		$this->material_out->AdvancedSearch->SearchOperator = @$filter["z_material_out"];
		$this->material_out->AdvancedSearch->SearchCondition = @$filter["v_material_out"];
		$this->material_out->AdvancedSearch->SearchValue2 = @$filter["y_material_out"];
		$this->material_out->AdvancedSearch->SearchOperator2 = @$filter["w_material_out"];
		$this->material_out->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field despatch_date
		$this->despatch_date->AdvancedSearch->SearchValue = @$filter["x_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchOperator = @$filter["z_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchCondition = @$filter["v_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchValue2 = @$filter["y_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_date"];
		$this->despatch_date->AdvancedSearch->save();

		// Field weaving_works
		$this->weaving_works->AdvancedSearch->SearchValue = @$filter["x_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchOperator = @$filter["z_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchCondition = @$filter["v_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchValue2 = @$filter["y_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchOperator2 = @$filter["w_weaving_works"];
		$this->weaving_works->AdvancedSearch->save();

		// Field company_id
		$this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
		$this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
		$this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
		$this->company_id->AdvancedSearch->save();

		// Field issue_material_lcgp_rid
		$this->issue_material_lcgp_rid->AdvancedSearch->SearchValue = @$filter["x_issue_material_lcgp_rid"];
		$this->issue_material_lcgp_rid->AdvancedSearch->SearchOperator = @$filter["z_issue_material_lcgp_rid"];
		$this->issue_material_lcgp_rid->AdvancedSearch->SearchCondition = @$filter["v_issue_material_lcgp_rid"];
		$this->issue_material_lcgp_rid->AdvancedSearch->SearchValue2 = @$filter["y_issue_material_lcgp_rid"];
		$this->issue_material_lcgp_rid->AdvancedSearch->SearchOperator2 = @$filter["w_issue_material_lcgp_rid"];
		$this->issue_material_lcgp_rid->AdvancedSearch->save();

		// Field issue_material_lot_no
		$this->issue_material_lot_no->AdvancedSearch->SearchValue = @$filter["x_issue_material_lot_no"];
		$this->issue_material_lot_no->AdvancedSearch->SearchOperator = @$filter["z_issue_material_lot_no"];
		$this->issue_material_lot_no->AdvancedSearch->SearchCondition = @$filter["v_issue_material_lot_no"];
		$this->issue_material_lot_no->AdvancedSearch->SearchValue2 = @$filter["y_issue_material_lot_no"];
		$this->issue_material_lot_no->AdvancedSearch->SearchOperator2 = @$filter["w_issue_material_lot_no"];
		$this->issue_material_lot_no->AdvancedSearch->save();

		// Field issue_material_godown
		$this->issue_material_godown->AdvancedSearch->SearchValue = @$filter["x_issue_material_godown"];
		$this->issue_material_godown->AdvancedSearch->SearchOperator = @$filter["z_issue_material_godown"];
		$this->issue_material_godown->AdvancedSearch->SearchCondition = @$filter["v_issue_material_godown"];
		$this->issue_material_godown->AdvancedSearch->SearchValue2 = @$filter["y_issue_material_godown"];
		$this->issue_material_godown->AdvancedSearch->SearchOperator2 = @$filter["w_issue_material_godown"];
		$this->issue_material_godown->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->poid, $default, FALSE); // poid
		$this->buildSearchSql($where, $this->po, $default, FALSE); // po
		$this->buildSearchSql($where, $this->week, $default, FALSE); // week
		$this->buildSearchSql($where, $this->buyer_id, $default, FALSE); // buyer_id
		$this->buildSearchSql($where, $this->product_id, $default, FALSE); // product_id
		$this->buildSearchSql($where, $this->batch_no, $default, FALSE); // batch_no
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->Size_wl, $default, FALSE); // Size_wl
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->t_sqm, $default, FALSE); // t_sqm
		$this->buildSearchSql($where, $this->unit, $default, FALSE); // unit
		$this->buildSearchSql($where, $this->material_qty, $default, FALSE); // material_qty
		$this->buildSearchSql($where, $this->method, $default, FALSE); // method
		$this->buildSearchSql($where, $this->despatch_week, $default, FALSE); // despatch_week
		$this->buildSearchSql($where, $this->production_plan, $default, FALSE); // production_plan
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->req_material_grp, $default, FALSE); // req_material_grp
		$this->buildSearchSql($where, $this->req_material_sgrp, $default, FALSE); // req_material_sgrp
		$this->buildSearchSql($where, $this->req_material_product, $default, FALSE); // req_material_product
		$this->buildSearchSql($where, $this->req_material_rid, $default, FALSE); // req_material_rid
		$this->buildSearchSql($where, $this->req_material_packing, $default, FALSE); // req_material_packing
		$this->buildSearchSql($where, $this->req_material_qty, $default, FALSE); // req_material_qty
		$this->buildSearchSql($where, $this->s_grp, $default, FALSE); // s_grp
		$this->buildSearchSql($where, $this->product, $default, FALSE); // product
		$this->buildSearchSql($where, $this->material_out, $default, FALSE); // material_out
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->despatch_date, $default, FALSE); // despatch_date
		$this->buildSearchSql($where, $this->weaving_works, $default, FALSE); // weaving_works
		$this->buildSearchSql($where, $this->company_id, $default, FALSE); // company_id
		$this->buildSearchSql($where, $this->issue_material_lcgp_rid, $default, FALSE); // issue_material_lcgp_rid
		$this->buildSearchSql($where, $this->issue_material_lot_no, $default, FALSE); // issue_material_lot_no
		$this->buildSearchSql($where, $this->issue_material_godown, $default, FALSE); // issue_material_godown

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->poid->AdvancedSearch->save(); // poid
			$this->po->AdvancedSearch->save(); // po
			$this->week->AdvancedSearch->save(); // week
			$this->buyer_id->AdvancedSearch->save(); // buyer_id
			$this->product_id->AdvancedSearch->save(); // product_id
			$this->batch_no->AdvancedSearch->save(); // batch_no
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->Size_wl->AdvancedSearch->save(); // Size_wl
			$this->grp->AdvancedSearch->save(); // grp
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->t_sqm->AdvancedSearch->save(); // t_sqm
			$this->unit->AdvancedSearch->save(); // unit
			$this->material_qty->AdvancedSearch->save(); // material_qty
			$this->method->AdvancedSearch->save(); // method
			$this->despatch_week->AdvancedSearch->save(); // despatch_week
			$this->production_plan->AdvancedSearch->save(); // production_plan
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->req_material_grp->AdvancedSearch->save(); // req_material_grp
			$this->req_material_sgrp->AdvancedSearch->save(); // req_material_sgrp
			$this->req_material_product->AdvancedSearch->save(); // req_material_product
			$this->req_material_rid->AdvancedSearch->save(); // req_material_rid
			$this->req_material_packing->AdvancedSearch->save(); // req_material_packing
			$this->req_material_qty->AdvancedSearch->save(); // req_material_qty
			$this->s_grp->AdvancedSearch->save(); // s_grp
			$this->product->AdvancedSearch->save(); // product
			$this->material_out->AdvancedSearch->save(); // material_out
			$this->operator->AdvancedSearch->save(); // operator
			$this->despatch_date->AdvancedSearch->save(); // despatch_date
			$this->weaving_works->AdvancedSearch->save(); // weaving_works
			$this->company_id->AdvancedSearch->save(); // company_id
			$this->issue_material_lcgp_rid->AdvancedSearch->save(); // issue_material_lcgp_rid
			$this->issue_material_lot_no->AdvancedSearch->save(); // issue_material_lot_no
			$this->issue_material_godown->AdvancedSearch->save(); // issue_material_godown
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->batch_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->quantity, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Size_wl, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sqm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->unit, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->material_qty, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->method, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->despatch_week, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->production_plan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_sgrp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_product, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_rid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_qty, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->material_out, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->material_out_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->despatch_date, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->order_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->issue_material_lcgp_rid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->issue_material_lot_no, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->poid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->week->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->batch_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Size_wl->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->unit->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->material_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->method->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->despatch_week->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->production_plan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_sgrp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_rid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_packing->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->material_out->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->despatch_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->weaving_works->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->company_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->issue_material_lcgp_rid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->issue_material_lot_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->issue_material_godown->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->poid->AdvancedSearch->unsetSession();
		$this->po->AdvancedSearch->unsetSession();
		$this->week->AdvancedSearch->unsetSession();
		$this->buyer_id->AdvancedSearch->unsetSession();
		$this->product_id->AdvancedSearch->unsetSession();
		$this->batch_no->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->Size_wl->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->t_sqm->AdvancedSearch->unsetSession();
		$this->unit->AdvancedSearch->unsetSession();
		$this->material_qty->AdvancedSearch->unsetSession();
		$this->method->AdvancedSearch->unsetSession();
		$this->despatch_week->AdvancedSearch->unsetSession();
		$this->production_plan->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->req_material_grp->AdvancedSearch->unsetSession();
		$this->req_material_sgrp->AdvancedSearch->unsetSession();
		$this->req_material_product->AdvancedSearch->unsetSession();
		$this->req_material_rid->AdvancedSearch->unsetSession();
		$this->req_material_packing->AdvancedSearch->unsetSession();
		$this->req_material_qty->AdvancedSearch->unsetSession();
		$this->s_grp->AdvancedSearch->unsetSession();
		$this->product->AdvancedSearch->unsetSession();
		$this->material_out->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->despatch_date->AdvancedSearch->unsetSession();
		$this->weaving_works->AdvancedSearch->unsetSession();
		$this->company_id->AdvancedSearch->unsetSession();
		$this->issue_material_lcgp_rid->AdvancedSearch->unsetSession();
		$this->issue_material_lot_no->AdvancedSearch->unsetSession();
		$this->issue_material_godown->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->poid->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->week->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->product_id->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->Size_wl->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->t_sqm->AdvancedSearch->load();
		$this->unit->AdvancedSearch->load();
		$this->material_qty->AdvancedSearch->load();
		$this->method->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->req_material_grp->AdvancedSearch->load();
		$this->req_material_sgrp->AdvancedSearch->load();
		$this->req_material_product->AdvancedSearch->load();
		$this->req_material_rid->AdvancedSearch->load();
		$this->req_material_packing->AdvancedSearch->load();
		$this->req_material_qty->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->material_out->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->issue_material_lcgp_rid->AdvancedSearch->load();
		$this->issue_material_lot_no->AdvancedSearch->load();
		$this->issue_material_godown->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->poid, $ctrl); // poid
			$this->updateSort($this->po, $ctrl); // po
			$this->updateSort($this->week, $ctrl); // week
			$this->updateSort($this->buyer_id, $ctrl); // buyer_id
			$this->updateSort($this->product_id, $ctrl); // product_id
			$this->updateSort($this->batch_no, $ctrl); // batch_no
			$this->updateSort($this->quantity, $ctrl); // quantity
			$this->updateSort($this->Size_wl, $ctrl); // Size_wl
			$this->updateSort($this->sqm, $ctrl); // sqm
			$this->updateSort($this->t_sqm, $ctrl); // t_sqm
			$this->updateSort($this->unit, $ctrl); // unit
			$this->updateSort($this->material_qty, $ctrl); // material_qty
			$this->updateSort($this->method, $ctrl); // method
			$this->updateSort($this->despatch_week, $ctrl); // despatch_week
			$this->updateSort($this->req_material_rid, $ctrl); // req_material_rid
			$this->updateSort($this->req_material_packing, $ctrl); // req_material_packing
			$this->updateSort($this->req_material_qty, $ctrl); // req_material_qty
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->despatch_date, $ctrl); // despatch_date
			$this->updateSort($this->order_id, $ctrl); // order_id
			$this->updateSort($this->weaving_works, $ctrl); // weaving_works
			$this->updateSort($this->company_id, $ctrl); // company_id
			$this->updateSort($this->issue_material_lcgp_rid, $ctrl); // issue_material_lcgp_rid
			$this->updateSort($this->issue_material_lot_no, $ctrl); // issue_material_lot_no
			$this->updateSort($this->issue_material_godown, $ctrl); // issue_material_godown
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset master/detail keys
			if ($this->Command == "resetall") {
				$this->setCurrentMasterTable(""); // Clear master table
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
				$this->po->setSessionValue("");
				$this->req_material_rid->setSessionValue("");
			}

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->poid->setSort("");
				$this->po->setSort("");
				$this->week->setSort("");
				$this->buyer_id->setSort("");
				$this->product_id->setSort("");
				$this->batch_no->setSort("");
				$this->quantity->setSort("");
				$this->Size_wl->setSort("");
				$this->sqm->setSort("");
				$this->t_sqm->setSort("");
				$this->unit->setSort("");
				$this->material_qty->setSort("");
				$this->method->setSort("");
				$this->despatch_week->setSort("");
				$this->req_material_rid->setSort("");
				$this->req_material_packing->setSort("");
				$this->req_material_qty->setSort("");
				$this->operator->setSort("");
				$this->despatch_date->setSort("");
				$this->order_id->setSort("");
				$this->weaving_works->setSort("");
				$this->company_id->setSort("");
				$this->issue_material_lcgp_rid->setSort("");
				$this->issue_material_lot_no->setSort("");
				$this->issue_material_godown->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fmaterial_requiredlistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fmaterial_requiredlistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fmaterial_requiredlist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fmaterial_requiredlistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// poid
		if (!$this->isAddOrEdit())
			$this->poid->AdvancedSearch->setSearchValue(Get("x_poid", Get("poid", "")));
		if ($this->poid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->poid->AdvancedSearch->setSearchOperator(Get("z_poid", ""));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue(Get("x_po", Get("po", "")));
		if ($this->po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator(Get("z_po", ""));
		$this->po->AdvancedSearch->setSearchCondition(Get("v_po", ""));
		$this->po->AdvancedSearch->setSearchValue2(Get("y_po", ""));
		if ($this->po->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator2(Get("w_po", ""));

		// week
		if (!$this->isAddOrEdit())
			$this->week->AdvancedSearch->setSearchValue(Get("x_week", Get("week", "")));
		if ($this->week->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->week->AdvancedSearch->setSearchOperator(Get("z_week", ""));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue(Get("x_buyer_id", Get("buyer_id", "")));
		if ($this->buyer_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_id->AdvancedSearch->setSearchOperator(Get("z_buyer_id", ""));

		// product_id
		if (!$this->isAddOrEdit())
			$this->product_id->AdvancedSearch->setSearchValue(Get("x_product_id", Get("product_id", "")));
		if ($this->product_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product_id->AdvancedSearch->setSearchOperator(Get("z_product_id", ""));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue(Get("x_batch_no", Get("batch_no", "")));
		if ($this->batch_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->batch_no->AdvancedSearch->setSearchOperator(Get("z_batch_no", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// Size_wl
		if (!$this->isAddOrEdit())
			$this->Size_wl->AdvancedSearch->setSearchValue(Get("x_Size_wl", Get("Size_wl", "")));
		if ($this->Size_wl->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Size_wl->AdvancedSearch->setSearchOperator(Get("z_Size_wl", ""));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));

		// t_sqm
		if (!$this->isAddOrEdit())
			$this->t_sqm->AdvancedSearch->setSearchValue(Get("x_t_sqm", Get("t_sqm", "")));
		if ($this->t_sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_sqm->AdvancedSearch->setSearchOperator(Get("z_t_sqm", ""));

		// unit
		if (!$this->isAddOrEdit())
			$this->unit->AdvancedSearch->setSearchValue(Get("x_unit", Get("unit", "")));
		if ($this->unit->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->unit->AdvancedSearch->setSearchOperator(Get("z_unit", ""));

		// material_qty
		if (!$this->isAddOrEdit())
			$this->material_qty->AdvancedSearch->setSearchValue(Get("x_material_qty", Get("material_qty", "")));
		if ($this->material_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->material_qty->AdvancedSearch->setSearchOperator(Get("z_material_qty", ""));

		// method
		if (!$this->isAddOrEdit())
			$this->method->AdvancedSearch->setSearchValue(Get("x_method", Get("method", "")));
		if ($this->method->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->method->AdvancedSearch->setSearchOperator(Get("z_method", ""));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue(Get("x_despatch_week", Get("despatch_week", "")));
		if ($this->despatch_week->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->despatch_week->AdvancedSearch->setSearchOperator(Get("z_despatch_week", ""));

		// production_plan
		if (!$this->isAddOrEdit())
			$this->production_plan->AdvancedSearch->setSearchValue(Get("x_production_plan", Get("production_plan", "")));
		if ($this->production_plan->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->production_plan->AdvancedSearch->setSearchOperator(Get("z_production_plan", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// req_material_grp
		if (!$this->isAddOrEdit())
			$this->req_material_grp->AdvancedSearch->setSearchValue(Get("x_req_material_grp", Get("req_material_grp", "")));
		if ($this->req_material_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_grp->AdvancedSearch->setSearchOperator(Get("z_req_material_grp", ""));

		// req_material_sgrp
		if (!$this->isAddOrEdit())
			$this->req_material_sgrp->AdvancedSearch->setSearchValue(Get("x_req_material_sgrp", Get("req_material_sgrp", "")));
		if ($this->req_material_sgrp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_sgrp->AdvancedSearch->setSearchOperator(Get("z_req_material_sgrp", ""));

		// req_material_product
		if (!$this->isAddOrEdit())
			$this->req_material_product->AdvancedSearch->setSearchValue(Get("x_req_material_product", Get("req_material_product", "")));
		if ($this->req_material_product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_product->AdvancedSearch->setSearchOperator(Get("z_req_material_product", ""));

		// req_material_rid
		if (!$this->isAddOrEdit())
			$this->req_material_rid->AdvancedSearch->setSearchValue(Get("x_req_material_rid", Get("req_material_rid", "")));
		if ($this->req_material_rid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_rid->AdvancedSearch->setSearchOperator(Get("z_req_material_rid", ""));

		// req_material_packing
		if (!$this->isAddOrEdit())
			$this->req_material_packing->AdvancedSearch->setSearchValue(Get("x_req_material_packing", Get("req_material_packing", "")));
		if ($this->req_material_packing->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_packing->AdvancedSearch->setSearchOperator(Get("z_req_material_packing", ""));

		// req_material_qty
		if (!$this->isAddOrEdit())
			$this->req_material_qty->AdvancedSearch->setSearchValue(Get("x_req_material_qty", Get("req_material_qty", "")));
		if ($this->req_material_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_qty->AdvancedSearch->setSearchOperator(Get("z_req_material_qty", ""));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue(Get("x_s_grp", Get("s_grp", "")));
		if ($this->s_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_grp->AdvancedSearch->setSearchOperator(Get("z_s_grp", ""));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue(Get("x_product", Get("product", "")));
		if ($this->product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product->AdvancedSearch->setSearchOperator(Get("z_product", ""));

		// material_out
		if (!$this->isAddOrEdit())
			$this->material_out->AdvancedSearch->setSearchValue(Get("x_material_out", Get("material_out", "")));
		if ($this->material_out->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->material_out->AdvancedSearch->setSearchOperator(Get("z_material_out", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// despatch_date
		if (!$this->isAddOrEdit())
			$this->despatch_date->AdvancedSearch->setSearchValue(Get("x_despatch_date", Get("despatch_date", "")));
		if ($this->despatch_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->despatch_date->AdvancedSearch->setSearchOperator(Get("z_despatch_date", ""));

		// weaving_works
		if (!$this->isAddOrEdit())
			$this->weaving_works->AdvancedSearch->setSearchValue(Get("x_weaving_works", Get("weaving_works", "")));
		if ($this->weaving_works->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->weaving_works->AdvancedSearch->setSearchOperator(Get("z_weaving_works", ""));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue(Get("x_company_id", Get("company_id", "")));
		if ($this->company_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->company_id->AdvancedSearch->setSearchOperator(Get("z_company_id", ""));

		// issue_material_lcgp_rid
		if (!$this->isAddOrEdit())
			$this->issue_material_lcgp_rid->AdvancedSearch->setSearchValue(Get("x_issue_material_lcgp_rid", Get("issue_material_lcgp_rid", "")));
		if ($this->issue_material_lcgp_rid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->issue_material_lcgp_rid->AdvancedSearch->setSearchOperator(Get("z_issue_material_lcgp_rid", ""));

		// issue_material_lot_no
		if (!$this->isAddOrEdit())
			$this->issue_material_lot_no->AdvancedSearch->setSearchValue(Get("x_issue_material_lot_no", Get("issue_material_lot_no", "")));
		if ($this->issue_material_lot_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->issue_material_lot_no->AdvancedSearch->setSearchOperator(Get("z_issue_material_lot_no", ""));

		// issue_material_godown
		if (!$this->isAddOrEdit())
			$this->issue_material_godown->AdvancedSearch->setSearchValue(Get("x_issue_material_godown", Get("issue_material_godown", "")));
		if ($this->issue_material_godown->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->issue_material_godown->AdvancedSearch->setSearchOperator(Get("z_issue_material_godown", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->poid->setDbValue($row['poid']);
		$this->po->setDbValue($row['po']);
		$this->week->setDbValue($row['week']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->product_id->setDbValue($row['product_id']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->Size_wl->setDbValue($row['Size_wl']);
		$this->grp->setDbValue($row['grp']);
		$this->sqm->setDbValue($row['sqm']);
		$this->t_sqm->setDbValue($row['t_sqm']);
		$this->unit->setDbValue($row['unit']);
		$this->material_qty->setDbValue($row['material_qty']);
		$this->method->setDbValue($row['method']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->remarks->setDbValue($row['remarks']);
		$this->updated->setDbValue($row['updated']);
		$this->datetime->setDbValue($row['datetime']);
		$this->req_material_grp->setDbValue($row['req_material_grp']);
		$this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
		$this->req_material_product->setDbValue($row['req_material_product']);
		$this->req_material_rid->setDbValue($row['req_material_rid']);
		if (array_key_exists('EV__req_material_rid', $rs->fields)) {
			$this->req_material_rid->VirtualValue = $rs->fields('EV__req_material_rid'); // Set up virtual field value
		} else {
			$this->req_material_rid->VirtualValue = ""; // Clear value
		}
		$this->req_material_packing->setDbValue($row['req_material_packing']);
		$this->req_material_qty->setDbValue($row['req_material_qty']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->material_out->setDbValue($row['material_out']);
		$this->material_out_id->setDbValue($row['material_out_id']);
		$this->operator->setDbValue($row['operator']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->order_id->setDbValue($row['order_id']);
		$this->weaving_works->setDbValue($row['weaving_works']);
		$this->issue_material_grp->setDbValue($row['issue_material_grp']);
		$this->issue_material_sgrp->setDbValue($row['issue_material_sgrp']);
		$this->issue_material_product->setDbValue($row['issue_material_product']);
		$this->issue_material_rid->setDbValue($row['issue_material_rid']);
		$this->issue_material_packing->setDbValue($row['issue_material_packing']);
		$this->issue_material_qty->setDbValue($row['issue_material_qty']);
		$this->company_id->setDbValue($row['company_id']);
		$this->issue_material_lcgp_rid->setDbValue($row['issue_material_lcgp_rid']);
		$this->issue_material_lot_no->setDbValue($row['issue_material_lot_no']);
		$this->issue_material_godown->setDbValue($row['issue_material_godown']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['poid'] = NULL;
		$row['po'] = NULL;
		$row['week'] = NULL;
		$row['buyer_id'] = NULL;
		$row['product_id'] = NULL;
		$row['batch_no'] = NULL;
		$row['quantity'] = NULL;
		$row['Size_wl'] = NULL;
		$row['grp'] = NULL;
		$row['sqm'] = NULL;
		$row['t_sqm'] = NULL;
		$row['unit'] = NULL;
		$row['material_qty'] = NULL;
		$row['method'] = NULL;
		$row['despatch_week'] = NULL;
		$row['production_plan'] = NULL;
		$row['remarks'] = NULL;
		$row['updated'] = NULL;
		$row['datetime'] = NULL;
		$row['req_material_grp'] = NULL;
		$row['req_material_sgrp'] = NULL;
		$row['req_material_product'] = NULL;
		$row['req_material_rid'] = NULL;
		$row['req_material_packing'] = NULL;
		$row['req_material_qty'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['material_out'] = NULL;
		$row['material_out_id'] = NULL;
		$row['operator'] = NULL;
		$row['despatch_date'] = NULL;
		$row['order_id'] = NULL;
		$row['weaving_works'] = NULL;
		$row['issue_material_grp'] = NULL;
		$row['issue_material_sgrp'] = NULL;
		$row['issue_material_product'] = NULL;
		$row['issue_material_rid'] = NULL;
		$row['issue_material_packing'] = NULL;
		$row['issue_material_qty'] = NULL;
		$row['company_id'] = NULL;
		$row['issue_material_lcgp_rid'] = NULL;
		$row['issue_material_lot_no'] = NULL;
		$row['issue_material_godown'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->t_sqm->FormValue == $this->t_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->t_sqm->CurrentValue)))
			$this->t_sqm->CurrentValue = ConvertToFloatString($this->t_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->material_qty->FormValue == $this->material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->material_qty->CurrentValue)))
			$this->material_qty->CurrentValue = ConvertToFloatString($this->material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// poid
		// po
		// week
		// buyer_id
		// product_id
		// batch_no

		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// quantity
		// Size_wl
		// grp
		// sqm
		// t_sqm
		// unit
		// material_qty
		// method
		// despatch_week
		// production_plan
		// remarks

		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// updated
		$this->updated->CellCssStyle = "white-space: nowrap;";

		// datetime
		// req_material_grp
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_packing
		// req_material_qty
		// s_grp
		// product
		// material_out
		// material_out_id

		$this->material_out_id->CellCssStyle = "white-space: nowrap;";

		// operator
		// despatch_date
		// order_id
		// weaving_works
		// issue_material_grp

		$this->issue_material_grp->CellCssStyle = "white-space: nowrap;";

		// issue_material_sgrp
		$this->issue_material_sgrp->CellCssStyle = "white-space: nowrap;";

		// issue_material_product
		$this->issue_material_product->CellCssStyle = "white-space: nowrap;";

		// issue_material_rid
		$this->issue_material_rid->CellCssStyle = "white-space: nowrap;";

		// issue_material_packing
		$this->issue_material_packing->CellCssStyle = "white-space: nowrap;";

		// issue_material_qty
		$this->issue_material_qty->CellCssStyle = "white-space: nowrap;";

		// company_id
		// issue_material_lcgp_rid
		// issue_material_lot_no
		// issue_material_godown
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->req_material_qty->CurrentValue))
				$this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
			if (is_numeric($this->issue_material_qty->CurrentValue))
				$this->issue_material_qty->Total += $this->issue_material_qty->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// week
			$this->week->ViewValue = $this->week->CurrentValue;
			$this->week->ViewValue = FormatNumber($this->week->ViewValue, 0, -2, -2, -2);
			$this->week->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// product_id
			$curVal = strval($this->product_id->CurrentValue);
			if ($curVal <> "") {
				$this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
				if ($this->product_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_id->ViewValue = $this->product_id->CurrentValue;
					}
				}
			} else {
				$this->product_id->ViewValue = NULL;
			}
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// Size_wl
			$this->Size_wl->ViewValue = $this->Size_wl->CurrentValue;
			$this->Size_wl->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// t_sqm
			$this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
			$this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, 2, -2, -2, -2);
			$this->t_sqm->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
			$this->material_qty->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// req_material_rid
			if ($this->req_material_rid->VirtualValue <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
			} else {
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->ViewValue = NULL;
			}
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_packing
			$curVal = strval($this->req_material_packing->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
				if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
					}
				}
			} else {
				$this->req_material_packing->ViewValue = NULL;
			}
			$this->req_material_packing->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, 0, 0, 0);
			$this->req_material_qty->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// order_id
			$this->order_id->ViewValue = $this->order_id->CurrentValue;
			$this->order_id->ViewCustomAttributes = "";

			// weaving_works
			$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
			$this->weaving_works->ViewValue = FormatNumber($this->weaving_works->ViewValue, 0, -2, -2, -2);
			$this->weaving_works->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
			$this->company_id->ViewCustomAttributes = "";

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->CurrentValue;
			$this->issue_material_lcgp_rid->ViewCustomAttributes = "";

			// issue_material_lot_no
			$this->issue_material_lot_no->ViewValue = $this->issue_material_lot_no->CurrentValue;
			$this->issue_material_lot_no->ViewCustomAttributes = "";

			// issue_material_godown
			$this->issue_material_godown->ViewValue = $this->issue_material_godown->CurrentValue;
			$this->issue_material_godown->ViewValue = FormatNumber($this->issue_material_godown->ViewValue, 0, -2, -2, -2);
			$this->issue_material_godown->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_id->CurrentValue)) {
				$this->buyer_id->HrefValue = "material_requiredlist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
				$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
			} else {
				$this->buyer_id->HrefValue = "";
			}
			$this->buyer_id->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_id->CurrentValue)) {
				$this->product_id->HrefValue = "material_requiredlist.php?x_product_item=" . $this->product_id->CurrentValue; // Add prefix/suffix
				$this->product_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
			} else {
				$this->product_id->HrefValue = "";
			}
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// Size_wl
			$this->Size_wl->LinkCustomAttributes = "";
			$this->Size_wl->HrefValue = "";
			$this->Size_wl->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// t_sqm
			$this->t_sqm->LinkCustomAttributes = "";
			$this->t_sqm->HrefValue = "";
			$this->t_sqm->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";
			$this->req_material_packing->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// order_id
			$this->order_id->LinkCustomAttributes = "";
			$this->order_id->HrefValue = "";
			$this->order_id->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->LinkCustomAttributes = "";
			$this->issue_material_lcgp_rid->HrefValue = "";
			$this->issue_material_lcgp_rid->TooltipValue = "";

			// issue_material_lot_no
			$this->issue_material_lot_no->LinkCustomAttributes = "";
			$this->issue_material_lot_no->HrefValue = "";
			$this->issue_material_lot_no->TooltipValue = "";

			// issue_material_godown
			$this->issue_material_godown->LinkCustomAttributes = "";
			$this->issue_material_godown->HrefValue = "";
			$this->issue_material_godown->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// poid
			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = "";
			$this->poid->EditValue = HtmlEncode($this->poid->AdvancedSearch->SearchValue);
			$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// week
			$this->week->EditAttrs["class"] = "form-control";
			$this->week->EditCustomAttributes = "";
			$this->week->EditValue = HtmlEncode($this->week->AdvancedSearch->SearchValue);
			$this->week->PlaceHolder = RemoveHtml($this->week->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";

			// product_id
			$this->product_id->EditAttrs["class"] = "form-control";
			$this->product_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product_id->AdvancedSearch->ViewValue = $this->product_id->lookupCacheOption($curVal);
			else
				$this->product_id->AdvancedSearch->ViewValue = $this->product_id->Lookup !== NULL && is_array($this->product_id->Lookup->Options) ? $curVal : NULL;
			if ($this->product_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product_id->EditValue = array_values($this->product_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_id->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// Size_wl
			$this->Size_wl->EditAttrs["class"] = "form-control";
			$this->Size_wl->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Size_wl->AdvancedSearch->SearchValue = HtmlDecode($this->Size_wl->AdvancedSearch->SearchValue);
			$this->Size_wl->EditValue = HtmlEncode($this->Size_wl->AdvancedSearch->SearchValue);
			$this->Size_wl->PlaceHolder = RemoveHtml($this->Size_wl->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// t_sqm
			$this->t_sqm->EditAttrs["class"] = "form-control";
			$this->t_sqm->EditCustomAttributes = "";
			$this->t_sqm->EditValue = HtmlEncode($this->t_sqm->AdvancedSearch->SearchValue);
			$this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";

			// material_qty
			$this->material_qty->EditAttrs["class"] = "form-control";
			$this->material_qty->EditCustomAttributes = "";
			$this->material_qty->EditValue = HtmlEncode($this->material_qty->AdvancedSearch->SearchValue);
			$this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";

			// req_material_rid
			$this->req_material_rid->EditAttrs["class"] = "form-control";
			$this->req_material_rid->EditCustomAttributes = "";
			$this->req_material_rid->EditValue = HtmlEncode($this->req_material_rid->AdvancedSearch->SearchValue);
			$this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

			// req_material_packing
			$this->req_material_packing->EditAttrs["class"] = "form-control";
			$this->req_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_packing->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			else
				$this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->Lookup !== NULL && is_array($this->req_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_packing->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->req_material_packing->EditValue = array_values($this->req_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_packing->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_packing->EditValue = $arwrk;
			}

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = HtmlEncode($this->req_material_qty->AdvancedSearch->SearchValue);
			$this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, 0), 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// order_id
			$this->order_id->EditAttrs["class"] = "form-control";
			$this->order_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->order_id->AdvancedSearch->SearchValue = HtmlDecode($this->order_id->AdvancedSearch->SearchValue);
			$this->order_id->EditValue = HtmlEncode($this->order_id->AdvancedSearch->SearchValue);
			$this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";
			$this->weaving_works->EditValue = HtmlEncode($this->weaving_works->AdvancedSearch->SearchValue);
			$this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->AdvancedSearch->SearchValue);
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// issue_material_lcgp_rid
			$this->issue_material_lcgp_rid->EditAttrs["class"] = "form-control";
			$this->issue_material_lcgp_rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->issue_material_lcgp_rid->AdvancedSearch->SearchValue = HtmlDecode($this->issue_material_lcgp_rid->AdvancedSearch->SearchValue);
			$this->issue_material_lcgp_rid->EditValue = HtmlEncode($this->issue_material_lcgp_rid->AdvancedSearch->SearchValue);
			$this->issue_material_lcgp_rid->PlaceHolder = RemoveHtml($this->issue_material_lcgp_rid->caption());

			// issue_material_lot_no
			$this->issue_material_lot_no->EditAttrs["class"] = "form-control";
			$this->issue_material_lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->issue_material_lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->issue_material_lot_no->AdvancedSearch->SearchValue);
			$this->issue_material_lot_no->EditValue = HtmlEncode($this->issue_material_lot_no->AdvancedSearch->SearchValue);
			$this->issue_material_lot_no->PlaceHolder = RemoveHtml($this->issue_material_lot_no->caption());

			// issue_material_godown
			$this->issue_material_godown->EditAttrs["class"] = "form-control";
			$this->issue_material_godown->EditCustomAttributes = "";
			$this->issue_material_godown->EditValue = HtmlEncode($this->issue_material_godown->AdvancedSearch->SearchValue);
			$this->issue_material_godown->PlaceHolder = RemoveHtml($this->issue_material_godown->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->req_material_qty->Total = 0; // Initialize total
			$this->issue_material_qty->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, 0, 0, 0);
			$this->req_material_qty->ViewCustomAttributes = "";
			$this->req_material_qty->HrefValue = ""; // Clear href value
			$this->issue_material_qty->CurrentValue = $this->issue_material_qty->Total;
			$this->issue_material_qty->ViewValue = $this->issue_material_qty->CurrentValue;
			$this->issue_material_qty->ViewValue = FormatNumber($this->issue_material_qty->ViewValue, 2, -2, -2, -2);
			$this->issue_material_qty->ViewCustomAttributes = "";
			$this->issue_material_qty->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->poid->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->week->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->product_id->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->Size_wl->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->t_sqm->AdvancedSearch->load();
		$this->unit->AdvancedSearch->load();
		$this->material_qty->AdvancedSearch->load();
		$this->method->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->req_material_grp->AdvancedSearch->load();
		$this->req_material_sgrp->AdvancedSearch->load();
		$this->req_material_product->AdvancedSearch->load();
		$this->req_material_rid->AdvancedSearch->load();
		$this->req_material_packing->AdvancedSearch->load();
		$this->req_material_qty->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->material_out->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->issue_material_lcgp_rid->AdvancedSearch->load();
		$this->issue_material_lot_no->AdvancedSearch->load();
		$this->issue_material_godown->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fmaterial_requiredlist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fmaterial_requiredlist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fmaterial_requiredlist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_material_required\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_material_required',hdr:ew.language.phrase('ExportToEmailText'),f:document.fmaterial_requiredlist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();

		// Export master record
		if (EXPORT_MASTER_RECORD && $this->getMasterFilter() <> "" && $this->getCurrentMasterTable() == "required_material_compiled") {
			global $required_material_compiled;
			if (!isset($required_material_compiled))
				$required_material_compiled = new required_material_compiled();
			$rsmaster = $required_material_compiled->loadRs($this->DbMasterFilter); // Load master record
			if ($rsmaster && !$rsmaster->EOF) {
				$exportStyle = $doc->Style;
				$doc->setStyle("v"); // Change to vertical
				if (!$this->isExport("csv") || EXPORT_MASTER_RECORD_FOR_CSV) {
					$doc->Table = &$required_material_compiled;
					$required_material_compiled->exportDocument($doc, $rsmaster);
					$doc->exportEmptyRow();
					$doc->Table = &$this;
				}
				$doc->setStyle($exportStyle); // Restore
				$rsmaster->close();
			}
		}
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (Get(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Get(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "required_material_compiled") {
				$validMaster = TRUE;
				if (Get("fk_po") !== NULL) {
					$this->po->setQueryStringValue(Get("fk_po"));
					$this->po->setSessionValue($this->po->QueryStringValue);
					if (!is_numeric($this->po->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
				if (Get("fk_req_material_rid") !== NULL) {
					$this->req_material_rid->setQueryStringValue(Get("fk_req_material_rid"));
					$this->req_material_rid->setSessionValue($this->req_material_rid->QueryStringValue);
					if (!is_numeric($this->req_material_rid->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (Post(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Post(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "required_material_compiled") {
				$validMaster = TRUE;
				if (Post("fk_po") !== NULL) {
					$this->po->setFormValue(Post("fk_po"));
					$this->po->setSessionValue($this->po->FormValue);
					if (!is_numeric($this->po->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
				if (Post("fk_req_material_rid") !== NULL) {
					$this->req_material_rid->setFormValue(Post("fk_req_material_rid"));
					$this->req_material_rid->setSessionValue($this->req_material_rid->FormValue);
					if (!is_numeric($this->req_material_rid->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Update URL
			$this->AddUrl = $this->addMasterUrl($this->AddUrl);
			$this->InlineAddUrl = $this->addMasterUrl($this->InlineAddUrl);
			$this->GridAddUrl = $this->addMasterUrl($this->GridAddUrl);
			$this->GridEditUrl = $this->addMasterUrl($this->GridEditUrl);
			$this->CancelUrl = $this->addMasterUrl($this->CancelUrl);

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRec = 1;
				$this->setStartRecordNumber($this->StartRec);
			}

			// Clear previous master key from Session
			if ($masterTblVar <> "required_material_compiled") {
				if ($this->po->CurrentValue == "")
					$this->po->setSessionValue("");
				if ($this->req_material_rid->CurrentValue == "")
					$this->req_material_rid->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_product_id":
							break;
						case "x_batch_no":
							break;
						case "x_unit":
							break;
						case "x_method":
							break;
						case "x_despatch_week":
							break;
						case "x_req_material_sgrp":
							break;
						case "x_req_material_product":
							break;
						case "x_req_material_rid":
							break;
						case "x_req_material_packing":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>