<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_required_live_edit extends material_required_live
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_required_live';

	// Page object name
	public $PageObjName = "material_required_live_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_required_live)
		if (!isset($GLOBALS["material_required_live"]) || get_class($GLOBALS["material_required_live"]) == PROJECT_NAMESPACE . "material_required_live") {
			$GLOBALS["material_required_live"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_required_live"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Table object (required_material_compiled_live)
		if (!isset($GLOBALS['required_material_compiled_live']))
			$GLOBALS['required_material_compiled_live'] = new required_material_compiled_live();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required_live');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_required_live;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_required_live);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "material_required_liveview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("material_required_livelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->poid->setVisibility();
		$this->weaving_works->setVisibility();
		$this->week->setVisibility();
		$this->po->setVisibility();
		$this->buyer_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_id->setVisibility();
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->Size_wl->setVisibility();
		$this->sqm->setVisibility();
		$this->req_material_grp->setVisibility();
		$this->req_material_sgrp->setVisibility();
		$this->req_material_product->setVisibility();
		$this->req_material_rid->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->req_material_packing->setVisibility();
		$this->issue_material_grp->setVisibility();
		$this->issue_material_sgrp->setVisibility();
		$this->issue_material_product->setVisibility();
		$this->issue_material_rid->setVisibility();
		$this->issue_material_packing->setVisibility();
		$this->issue_material_qty->setVisibility();
		$this->unit->setVisibility();
		$this->material_qty->setVisibility();
		$this->method->setVisibility();
		$this->despatch_week->setVisibility();
		$this->despatch_date->setVisibility();
		$this->production_plan->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->updated->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->material_out->setVisibility();
		$this->material_out_id->Visible = FALSE;
		$this->order_id->Visible = FALSE;
		$this->issue_to->setVisibility();
		$this->t_sqm->Visible = FALSE;
		$this->pp_id->setVisibility();
		$this->level->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->poid->Required = FALSE;
		$this->week->Required = FALSE;
		$this->buyer_id->Required = FALSE;
		$this->grp->Required = FALSE;
		$this->s_grp->Required = FALSE;
		$this->product->Required = FALSE;
		$this->product_id->Required = FALSE;
		$this->batch_no->Required = FALSE;
		$this->quantity->Required = FALSE;
		$this->req_material_qty->Required = FALSE;
		$this->unit->Required = FALSE;
		$this->method->Required = FALSE;
		$this->despatch_week->Required = FALSE;
		$this->production_plan->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->weaving_works);
		$this->setupLookupOptions($this->week);
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_id);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->req_material_sgrp);
		$this->setupLookupOptions($this->req_material_product);
		$this->setupLookupOptions($this->req_material_rid);
		$this->setupLookupOptions($this->req_material_packing);
		$this->setupLookupOptions($this->issue_material_sgrp);
		$this->setupLookupOptions($this->issue_material_product);
		$this->setupLookupOptions($this->issue_material_packing);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->material_qty);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->issue_to);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Set up master detail parameters
		$this->setupMasterParms();

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("material_required_livelist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = "autoprogramme.php?apcid=c3992e9a68c5ae12bd18488bc579b30d";
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'poid' first before field var 'x_poid'
		$val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
		if (!$this->poid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->poid->Visible = FALSE; // Disable update for API request
			else
				$this->poid->setFormValue($val);
		}

		// Check field name 'weaving_works' first before field var 'x_weaving_works'
		$val = $CurrentForm->hasValue("weaving_works") ? $CurrentForm->getValue("weaving_works") : $CurrentForm->getValue("x_weaving_works");
		if (!$this->weaving_works->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->weaving_works->Visible = FALSE; // Disable update for API request
			else
				$this->weaving_works->setFormValue($val);
		}

		// Check field name 'week' first before field var 'x_week'
		$val = $CurrentForm->hasValue("week") ? $CurrentForm->getValue("week") : $CurrentForm->getValue("x_week");
		if (!$this->week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->week->Visible = FALSE; // Disable update for API request
			else
				$this->week->setFormValue($val);
		}

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'product_id' first before field var 'x_product_id'
		$val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
		if (!$this->product_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_id->Visible = FALSE; // Disable update for API request
			else
				$this->product_id->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'Size_wl' first before field var 'x_Size_wl'
		$val = $CurrentForm->hasValue("Size_wl") ? $CurrentForm->getValue("Size_wl") : $CurrentForm->getValue("x_Size_wl");
		if (!$this->Size_wl->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Size_wl->Visible = FALSE; // Disable update for API request
			else
				$this->Size_wl->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 'req_material_grp' first before field var 'x_req_material_grp'
		$val = $CurrentForm->hasValue("req_material_grp") ? $CurrentForm->getValue("req_material_grp") : $CurrentForm->getValue("x_req_material_grp");
		if (!$this->req_material_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_grp->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_grp->setFormValue($val);
		}

		// Check field name 'req_material_sgrp' first before field var 'x_req_material_sgrp'
		$val = $CurrentForm->hasValue("req_material_sgrp") ? $CurrentForm->getValue("req_material_sgrp") : $CurrentForm->getValue("x_req_material_sgrp");
		if (!$this->req_material_sgrp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_sgrp->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_sgrp->setFormValue($val);
		}

		// Check field name 'req_material_product' first before field var 'x_req_material_product'
		$val = $CurrentForm->hasValue("req_material_product") ? $CurrentForm->getValue("req_material_product") : $CurrentForm->getValue("x_req_material_product");
		if (!$this->req_material_product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_product->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_product->setFormValue($val);
		}

		// Check field name 'req_material_rid' first before field var 'x_req_material_rid'
		$val = $CurrentForm->hasValue("req_material_rid") ? $CurrentForm->getValue("req_material_rid") : $CurrentForm->getValue("x_req_material_rid");
		if (!$this->req_material_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_rid->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_rid->setFormValue($val);
		}

		// Check field name 'req_material_qty' first before field var 'x_req_material_qty'
		$val = $CurrentForm->hasValue("req_material_qty") ? $CurrentForm->getValue("req_material_qty") : $CurrentForm->getValue("x_req_material_qty");
		if (!$this->req_material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_qty->setFormValue($val);
		}

		// Check field name 'req_material_packing' first before field var 'x_req_material_packing'
		$val = $CurrentForm->hasValue("req_material_packing") ? $CurrentForm->getValue("req_material_packing") : $CurrentForm->getValue("x_req_material_packing");
		if (!$this->req_material_packing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->req_material_packing->Visible = FALSE; // Disable update for API request
			else
				$this->req_material_packing->setFormValue($val);
		}

		// Check field name 'issue_material_grp' first before field var 'x_issue_material_grp'
		$val = $CurrentForm->hasValue("issue_material_grp") ? $CurrentForm->getValue("issue_material_grp") : $CurrentForm->getValue("x_issue_material_grp");
		if (!$this->issue_material_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_grp->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_grp->setFormValue($val);
		}

		// Check field name 'issue_material_sgrp' first before field var 'x_issue_material_sgrp'
		$val = $CurrentForm->hasValue("issue_material_sgrp") ? $CurrentForm->getValue("issue_material_sgrp") : $CurrentForm->getValue("x_issue_material_sgrp");
		if (!$this->issue_material_sgrp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_sgrp->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_sgrp->setFormValue($val);
		}

		// Check field name 'issue_material_product' first before field var 'x_issue_material_product'
		$val = $CurrentForm->hasValue("issue_material_product") ? $CurrentForm->getValue("issue_material_product") : $CurrentForm->getValue("x_issue_material_product");
		if (!$this->issue_material_product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_product->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_product->setFormValue($val);
		}

		// Check field name 'issue_material_rid' first before field var 'x_issue_material_rid'
		$val = $CurrentForm->hasValue("issue_material_rid") ? $CurrentForm->getValue("issue_material_rid") : $CurrentForm->getValue("x_issue_material_rid");
		if (!$this->issue_material_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_rid->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_rid->setFormValue($val);
		}

		// Check field name 'issue_material_packing' first before field var 'x_issue_material_packing'
		$val = $CurrentForm->hasValue("issue_material_packing") ? $CurrentForm->getValue("issue_material_packing") : $CurrentForm->getValue("x_issue_material_packing");
		if (!$this->issue_material_packing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_packing->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_packing->setFormValue($val);
		}

		// Check field name 'issue_material_qty' first before field var 'x_issue_material_qty'
		$val = $CurrentForm->hasValue("issue_material_qty") ? $CurrentForm->getValue("issue_material_qty") : $CurrentForm->getValue("x_issue_material_qty");
		if (!$this->issue_material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->issue_material_qty->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name 'material_qty' first before field var 'x_material_qty'
		$val = $CurrentForm->hasValue("material_qty") ? $CurrentForm->getValue("material_qty") : $CurrentForm->getValue("x_material_qty");
		if (!$this->material_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material_qty->Visible = FALSE; // Disable update for API request
			else
				$this->material_qty->setFormValue($val);
		}

		// Check field name 'method' first before field var 'x_method'
		$val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
		if (!$this->method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->method->Visible = FALSE; // Disable update for API request
			else
				$this->method->setFormValue($val);
		}

		// Check field name 'despatch_week' first before field var 'x_despatch_week'
		$val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
		if (!$this->despatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_week->setFormValue($val);
		}

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}

		// Check field name 'production_plan' first before field var 'x_production_plan'
		$val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
		if (!$this->production_plan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_plan->Visible = FALSE; // Disable update for API request
			else
				$this->production_plan->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'material_out' first before field var 'x_material_out'
		$val = $CurrentForm->hasValue("material_out") ? $CurrentForm->getValue("material_out") : $CurrentForm->getValue("x_material_out");
		if (!$this->material_out->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material_out->Visible = FALSE; // Disable update for API request
			else
				$this->material_out->setFormValue($val);
		}

		// Check field name 'issue_to' first before field var 'x_issue_to'
		$val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
		if (!$this->issue_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->issue_to->Visible = FALSE; // Disable update for API request
			else
				$this->issue_to->setFormValue($val);
		}

		// Check field name 'pp_id' first before field var 'x_pp_id'
		$val = $CurrentForm->hasValue("pp_id") ? $CurrentForm->getValue("pp_id") : $CurrentForm->getValue("x_pp_id");
		if (!$this->pp_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pp_id->Visible = FALSE; // Disable update for API request
			else
				$this->pp_id->setFormValue($val);
		}

		// Check field name 'level' first before field var 'x_level'
		$val = $CurrentForm->hasValue("level") ? $CurrentForm->getValue("level") : $CurrentForm->getValue("x_level");
		if (!$this->level->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->level->Visible = FALSE; // Disable update for API request
			else
				$this->level->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->poid->CurrentValue = $this->poid->FormValue;
		$this->weaving_works->CurrentValue = $this->weaving_works->FormValue;
		$this->week->CurrentValue = $this->week->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->product_id->CurrentValue = $this->product_id->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->Size_wl->CurrentValue = $this->Size_wl->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->req_material_grp->CurrentValue = $this->req_material_grp->FormValue;
		$this->req_material_sgrp->CurrentValue = $this->req_material_sgrp->FormValue;
		$this->req_material_product->CurrentValue = $this->req_material_product->FormValue;
		$this->req_material_rid->CurrentValue = $this->req_material_rid->FormValue;
		$this->req_material_qty->CurrentValue = $this->req_material_qty->FormValue;
		$this->req_material_packing->CurrentValue = $this->req_material_packing->FormValue;
		$this->issue_material_grp->CurrentValue = $this->issue_material_grp->FormValue;
		$this->issue_material_sgrp->CurrentValue = $this->issue_material_sgrp->FormValue;
		$this->issue_material_product->CurrentValue = $this->issue_material_product->FormValue;
		$this->issue_material_rid->CurrentValue = $this->issue_material_rid->FormValue;
		$this->issue_material_packing->CurrentValue = $this->issue_material_packing->FormValue;
		$this->issue_material_qty->CurrentValue = $this->issue_material_qty->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->material_qty->CurrentValue = $this->material_qty->FormValue;
		$this->method->CurrentValue = $this->method->FormValue;
		$this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->production_plan->CurrentValue = $this->production_plan->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->material_out->CurrentValue = $this->material_out->FormValue;
		$this->issue_to->CurrentValue = $this->issue_to->FormValue;
		$this->pp_id->CurrentValue = $this->pp_id->FormValue;
		$this->level->CurrentValue = $this->level->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->poid->setDbValue($row['poid']);
		$this->weaving_works->setDbValue($row['weaving_works']);
		$this->week->setDbValue($row['week']);
		$this->po->setDbValue($row['po']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		if (array_key_exists('EV__product', $rs->fields)) {
			$this->product->VirtualValue = $rs->fields('EV__product'); // Set up virtual field value
		} else {
			$this->product->VirtualValue = ""; // Clear value
		}
		$this->product_id->setDbValue($row['product_id']);
		if (array_key_exists('EV__product_id', $rs->fields)) {
			$this->product_id->VirtualValue = $rs->fields('EV__product_id'); // Set up virtual field value
		} else {
			$this->product_id->VirtualValue = ""; // Clear value
		}
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->Size_wl->setDbValue($row['Size_wl']);
		$this->sqm->setDbValue($row['sqm']);
		$this->req_material_grp->setDbValue($row['req_material_grp']);
		$this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
		$this->req_material_product->setDbValue($row['req_material_product']);
		$this->req_material_rid->setDbValue($row['req_material_rid']);
		if (array_key_exists('EV__req_material_rid', $rs->fields)) {
			$this->req_material_rid->VirtualValue = $rs->fields('EV__req_material_rid'); // Set up virtual field value
		} else {
			$this->req_material_rid->VirtualValue = ""; // Clear value
		}
		$this->req_material_qty->setDbValue($row['req_material_qty']);
		$this->req_material_packing->setDbValue($row['req_material_packing']);
		$this->issue_material_grp->setDbValue($row['issue_material_grp']);
		$this->issue_material_sgrp->setDbValue($row['issue_material_sgrp']);
		$this->issue_material_product->setDbValue($row['issue_material_product']);
		$this->issue_material_rid->setDbValue($row['issue_material_rid']);
		$this->issue_material_packing->setDbValue($row['issue_material_packing']);
		$this->issue_material_qty->setDbValue($row['issue_material_qty']);
		$this->unit->setDbValue($row['unit']);
		$this->material_qty->setDbValue($row['material_qty']);
		$this->method->setDbValue($row['method']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->remarks->setDbValue($row['remarks']);
		$this->updated->setDbValue($row['updated']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->material_out->setDbValue($row['material_out']);
		$this->material_out_id->setDbValue($row['material_out_id']);
		$this->order_id->setDbValue($row['order_id']);
		$this->issue_to->setDbValue($row['issue_to']);
		$this->t_sqm->setDbValue($row['t_sqm']);
		$this->pp_id->setDbValue($row['pp_id']);
		$this->level->setDbValue($row['level']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['poid'] = NULL;
		$row['weaving_works'] = NULL;
		$row['week'] = NULL;
		$row['po'] = NULL;
		$row['buyer_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['product_id'] = NULL;
		$row['batch_no'] = NULL;
		$row['quantity'] = NULL;
		$row['Size_wl'] = NULL;
		$row['sqm'] = NULL;
		$row['req_material_grp'] = NULL;
		$row['req_material_sgrp'] = NULL;
		$row['req_material_product'] = NULL;
		$row['req_material_rid'] = NULL;
		$row['req_material_qty'] = NULL;
		$row['req_material_packing'] = NULL;
		$row['issue_material_grp'] = NULL;
		$row['issue_material_sgrp'] = NULL;
		$row['issue_material_product'] = NULL;
		$row['issue_material_rid'] = NULL;
		$row['issue_material_packing'] = NULL;
		$row['issue_material_qty'] = NULL;
		$row['unit'] = NULL;
		$row['material_qty'] = NULL;
		$row['method'] = NULL;
		$row['despatch_week'] = NULL;
		$row['despatch_date'] = NULL;
		$row['production_plan'] = NULL;
		$row['remarks'] = NULL;
		$row['updated'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['material_out'] = NULL;
		$row['material_out_id'] = NULL;
		$row['order_id'] = NULL;
		$row['issue_to'] = NULL;
		$row['t_sqm'] = NULL;
		$row['pp_id'] = NULL;
		$row['level'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->issue_material_qty->FormValue == $this->issue_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->issue_material_qty->CurrentValue)))
			$this->issue_material_qty->CurrentValue = ConvertToFloatString($this->issue_material_qty->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// poid
		// weaving_works
		// week
		// po
		// buyer_id
		// grp
		// s_grp
		// product
		// product_id
		// batch_no
		// quantity
		// Size_wl
		// sqm
		// req_material_grp
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_qty
		// req_material_packing
		// issue_material_grp
		// issue_material_sgrp
		// issue_material_product
		// issue_material_rid
		// issue_material_packing
		// issue_material_qty
		// unit
		// material_qty
		// method
		// despatch_week
		// despatch_date
		// production_plan
		// remarks
		// updated
		// operator
		// datetime
		// material_out
		// material_out_id
		// order_id
		// issue_to
		// t_sqm
		// pp_id
		// level

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// weaving_works
			$curVal = strval($this->weaving_works->CurrentValue);
			if ($curVal <> "") {
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
				if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
					}
				}
			} else {
				$this->weaving_works->ViewValue = NULL;
			}
			$this->weaving_works->ViewCustomAttributes = "";

			// week
			$curVal = strval($this->week->CurrentValue);
			if ($curVal <> "") {
				$this->week->ViewValue = $this->week->lookupCacheOption($curVal);
				if ($this->week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->week->ViewValue = $this->week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->week->ViewValue = $this->week->CurrentValue;
					}
				}
			} else {
				$this->week->ViewValue = NULL;
			}
			$this->week->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			if ($this->product->VirtualValue <> "") {
				$this->product->ViewValue = $this->product->VirtualValue;
			} else {
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// product_id
			if ($this->product_id->VirtualValue <> "") {
				$this->product_id->ViewValue = $this->product_id->VirtualValue;
			} else {
			$curVal = strval($this->product_id->CurrentValue);
			if ($curVal <> "") {
				$this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
				if ($this->product_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_id->ViewValue = $this->product_id->CurrentValue;
					}
				}
			} else {
				$this->product_id->ViewValue = NULL;
			}
			}
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// Size_wl
			$this->Size_wl->ViewValue = $this->Size_wl->CurrentValue;
			$this->Size_wl->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// req_material_grp
			$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
			$this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, 0, -2, -2, -2);
			$this->req_material_grp->ViewCustomAttributes = "";

			// req_material_sgrp
			$curVal = strval($this->req_material_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
				if ($this->req_material_sgrp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
					}
				}
			} else {
				$this->req_material_sgrp->ViewValue = NULL;
			}
			$this->req_material_sgrp->ViewCustomAttributes = "";

			// req_material_product
			$curVal = strval($this->req_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
				if ($this->req_material_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
					}
				}
			} else {
				$this->req_material_product->ViewValue = NULL;
			}
			$this->req_material_product->ViewCustomAttributes = "";

			// req_material_rid
			if ($this->req_material_rid->VirtualValue <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
			} else {
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->ViewValue = NULL;
			}
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// req_material_packing
			$curVal = strval($this->req_material_packing->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
				if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
					}
				}
			} else {
				$this->req_material_packing->ViewValue = NULL;
			}
			$this->req_material_packing->ViewCustomAttributes = "";

			// issue_material_grp
			$this->issue_material_grp->ViewValue = $this->issue_material_grp->CurrentValue;
			$this->issue_material_grp->ViewValue = FormatNumber($this->issue_material_grp->ViewValue, 0, -2, -2, -2);
			$this->issue_material_grp->ViewCustomAttributes = "";

			// issue_material_sgrp
			$curVal = strval($this->issue_material_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->lookupCacheOption($curVal);
				if ($this->issue_material_sgrp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_material_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->CurrentValue;
					}
				}
			} else {
				$this->issue_material_sgrp->ViewValue = NULL;
			}
			$this->issue_material_sgrp->ViewCustomAttributes = "";

			// issue_material_product
			$curVal = strval($this->issue_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->issue_material_product->ViewValue = $this->issue_material_product->lookupCacheOption($curVal);
				if ($this->issue_material_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`product`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->issue_material_product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_material_product->ViewValue = $this->issue_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_material_product->ViewValue = $this->issue_material_product->CurrentValue;
					}
				}
			} else {
				$this->issue_material_product->ViewValue = NULL;
			}
			$this->issue_material_product->ViewCustomAttributes = "";

			// issue_material_rid
			$this->issue_material_rid->ViewValue = $this->issue_material_rid->CurrentValue;
			$this->issue_material_rid->ViewValue = FormatNumber($this->issue_material_rid->ViewValue, 0, -2, -2, -2);
			$this->issue_material_rid->ViewCustomAttributes = "";

			// issue_material_packing
			$curVal = strval($this->issue_material_packing->CurrentValue);
			if ($curVal <> "") {
				$this->issue_material_packing->ViewValue = $this->issue_material_packing->lookupCacheOption($curVal);
				if ($this->issue_material_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_material_packing->ViewValue = $this->issue_material_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_material_packing->ViewValue = $this->issue_material_packing->CurrentValue;
					}
				}
			} else {
				$this->issue_material_packing->ViewValue = NULL;
			}
			$this->issue_material_packing->ViewCustomAttributes = "";

			// issue_material_qty
			$this->issue_material_qty->ViewValue = $this->issue_material_qty->CurrentValue;
			$this->issue_material_qty->ViewValue = FormatNumber($this->issue_material_qty->ViewValue, 2, -2, -2, -2);
			$this->issue_material_qty->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
			$curVal = strval($this->material_qty->CurrentValue);
			if ($curVal <> "") {
				$this->material_qty->ViewValue = $this->material_qty->lookupCacheOption($curVal);
				if ($this->material_qty->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->material_qty->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->material_qty->ViewValue = $this->material_qty->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
					}
				}
			} else {
				$this->material_qty->ViewValue = NULL;
			}
			$this->material_qty->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// material_out
			if (strval($this->material_out->CurrentValue) <> "") {
				$this->material_out->ViewValue = $this->material_out->optionCaption($this->material_out->CurrentValue);
			} else {
				$this->material_out->ViewValue = NULL;
			}
			$this->material_out->ViewCustomAttributes = "";

			// order_id
			$this->order_id->ViewValue = $this->order_id->CurrentValue;
			$this->order_id->ViewCustomAttributes = "";

			// issue_to
			$curVal = strval($this->issue_to->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
				if ($this->issue_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
					}
				}
			} else {
				$this->issue_to->ViewValue = NULL;
			}
			$this->issue_to->ViewCustomAttributes = "";

			// pp_id
			$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
			$this->pp_id->ViewValue = FormatNumber($this->pp_id->ViewValue, 0, -2, -2, -2);
			$this->pp_id->ViewCustomAttributes = "";

			// level
			$this->level->ViewValue = $this->level->CurrentValue;
			$this->level->ViewValue = FormatNumber($this->level->ViewValue, 0, -2, -2, -2);
			$this->level->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_id->CurrentValue)) {
				$this->buyer_id->HrefValue = "material_required_livelist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
				$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
			} else {
				$this->buyer_id->HrefValue = "";
			}
			$this->buyer_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "material_required_livelist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "material_required_livelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_id->CurrentValue)) {
				$this->product_id->HrefValue = "material_required_livelist.php?x_product_id=" . $this->product_id->CurrentValue; // Add prefix/suffix
				$this->product_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
			} else {
				$this->product_id->HrefValue = "";
			}
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// Size_wl
			$this->Size_wl->LinkCustomAttributes = "";
			$this->Size_wl->HrefValue = "";
			$this->Size_wl->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// req_material_grp
			$this->req_material_grp->LinkCustomAttributes = "";
			$this->req_material_grp->HrefValue = "";
			$this->req_material_grp->TooltipValue = "";

			// req_material_sgrp
			$this->req_material_sgrp->LinkCustomAttributes = "";
			$this->req_material_sgrp->HrefValue = "";
			$this->req_material_sgrp->TooltipValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";
			$this->req_material_packing->TooltipValue = "";

			// issue_material_grp
			$this->issue_material_grp->LinkCustomAttributes = "";
			$this->issue_material_grp->HrefValue = "";
			$this->issue_material_grp->TooltipValue = "";

			// issue_material_sgrp
			$this->issue_material_sgrp->LinkCustomAttributes = "";
			$this->issue_material_sgrp->HrefValue = "";
			$this->issue_material_sgrp->TooltipValue = "";

			// issue_material_product
			$this->issue_material_product->LinkCustomAttributes = "";
			$this->issue_material_product->HrefValue = "";
			$this->issue_material_product->TooltipValue = "";

			// issue_material_rid
			$this->issue_material_rid->LinkCustomAttributes = "";
			$this->issue_material_rid->HrefValue = "";
			$this->issue_material_rid->TooltipValue = "";

			// issue_material_packing
			$this->issue_material_packing->LinkCustomAttributes = "";
			$this->issue_material_packing->HrefValue = "";
			$this->issue_material_packing->TooltipValue = "";

			// issue_material_qty
			$this->issue_material_qty->LinkCustomAttributes = "";
			$this->issue_material_qty->HrefValue = "";
			$this->issue_material_qty->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// material_out
			$this->material_out->LinkCustomAttributes = "";
			$this->material_out->HrefValue = "";
			$this->material_out->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";
			$this->issue_to->TooltipValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";
			$this->pp_id->TooltipValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
			$this->level->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// poid
			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = "";
			$this->poid->EditValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->weaving_works->CurrentValue));
			if ($curVal <> "")
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			else
				$this->weaving_works->ViewValue = $this->weaving_works->Lookup !== NULL && is_array($this->weaving_works->Lookup->Options) ? $curVal : NULL;
			if ($this->weaving_works->ViewValue !== NULL) { // Load from cache
				$this->weaving_works->EditValue = array_values($this->weaving_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->weaving_works->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->weaving_works->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->weaving_works->EditValue = $arwrk;
			}

			// week
			$this->week->EditAttrs["class"] = "form-control";
			$this->week->EditCustomAttributes = 'ReadOnly';
			$curVal = strval($this->week->CurrentValue);
			if ($curVal <> "") {
				$this->week->EditValue = $this->week->lookupCacheOption($curVal);
				if ($this->week->EditValue === NULL) { // Lookup from database
					$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->week->EditValue = $this->week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->week->EditValue = $this->week->CurrentValue;
					}
				}
			} else {
				$this->week->EditValue = NULL;
			}
			$this->week->ViewCustomAttributes = "";

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->EditValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->EditValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			if ($this->product->VirtualValue <> "") {
				$this->product->EditValue = $this->product->VirtualValue;
			} else {
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// product_id
			$this->product_id->EditAttrs["class"] = "form-control";
			$this->product_id->EditCustomAttributes = "";
			if ($this->product_id->VirtualValue <> "") {
				$this->product_id->EditValue = $this->product_id->VirtualValue;
			} else {
			$curVal = strval($this->product_id->CurrentValue);
			if ($curVal <> "") {
				$this->product_id->EditValue = $this->product_id->lookupCacheOption($curVal);
				if ($this->product_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_id->EditValue = $this->product_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_id->EditValue = $this->product_id->CurrentValue;
					}
				}
			} else {
				$this->product_id->EditValue = NULL;
			}
			}
			$this->product_id->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->EditValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->EditValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = $this->quantity->CurrentValue;
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// Size_wl
			$this->Size_wl->EditAttrs["class"] = "form-control";
			$this->Size_wl->EditCustomAttributes = "";
			$this->Size_wl->EditValue = $this->Size_wl->CurrentValue;
			$this->Size_wl->ViewCustomAttributes = "";

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// req_material_grp
			$this->req_material_grp->EditAttrs["class"] = "form-control";
			$this->req_material_grp->EditCustomAttributes = "";
			$this->req_material_grp->EditValue = HtmlEncode($this->req_material_grp->CurrentValue);
			$this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());

			// req_material_sgrp
			$this->req_material_sgrp->EditAttrs["class"] = "form-control";
			$this->req_material_sgrp->EditCustomAttributes = "";
			$curVal = strval($this->req_material_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_sgrp->EditValue = $this->req_material_sgrp->lookupCacheOption($curVal);
				if ($this->req_material_sgrp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_sgrp->EditValue = $this->req_material_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_sgrp->EditValue = $this->req_material_sgrp->CurrentValue;
					}
				}
			} else {
				$this->req_material_sgrp->EditValue = NULL;
			}
			$this->req_material_sgrp->ViewCustomAttributes = "";

			// req_material_product
			$this->req_material_product->EditAttrs["class"] = "form-control";
			$this->req_material_product->EditCustomAttributes = "";
			$curVal = strval($this->req_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_product->EditValue = $this->req_material_product->lookupCacheOption($curVal);
				if ($this->req_material_product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_product->EditValue = $this->req_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_product->EditValue = $this->req_material_product->CurrentValue;
					}
				}
			} else {
				$this->req_material_product->EditValue = NULL;
			}
			$this->req_material_product->ViewCustomAttributes = "";

			// req_material_rid
			$this->req_material_rid->EditAttrs["class"] = "form-control";
			$this->req_material_rid->EditCustomAttributes = "";
			if ($this->req_material_rid->VirtualValue <> "") {
				$this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
			} else {
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->EditValue = NULL;
			}
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// req_material_packing
			$this->req_material_packing->EditAttrs["class"] = "form-control";
			$this->req_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_packing->CurrentValue));
			if ($curVal <> "")
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			else
				$this->req_material_packing->ViewValue = $this->req_material_packing->Lookup !== NULL && is_array($this->req_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_packing->ViewValue !== NULL) { // Load from cache
				$this->req_material_packing->EditValue = array_values($this->req_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_packing->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_packing->EditValue = $arwrk;
			}

			// issue_material_grp
			$this->issue_material_grp->EditAttrs["class"] = "form-control";
			$this->issue_material_grp->EditCustomAttributes = "";
			$this->issue_material_grp->EditValue = HtmlEncode($this->issue_material_grp->CurrentValue);
			$this->issue_material_grp->PlaceHolder = RemoveHtml($this->issue_material_grp->caption());

			// issue_material_sgrp
			$this->issue_material_sgrp->EditAttrs["class"] = "form-control";
			$this->issue_material_sgrp->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_material_sgrp->CurrentValue));
			if ($curVal <> "")
				$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->lookupCacheOption($curVal);
			else
				$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->Lookup !== NULL && is_array($this->issue_material_sgrp->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_material_sgrp->ViewValue !== NULL) { // Load from cache
				$this->issue_material_sgrp->EditValue = array_values($this->issue_material_sgrp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_material_sgrp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_material_sgrp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_material_sgrp->EditValue = $arwrk;
			}

			// issue_material_product
			$this->issue_material_product->EditAttrs["class"] = "form-control";
			$this->issue_material_product->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_material_product->CurrentValue));
			if ($curVal <> "")
				$this->issue_material_product->ViewValue = $this->issue_material_product->lookupCacheOption($curVal);
			else
				$this->issue_material_product->ViewValue = $this->issue_material_product->Lookup !== NULL && is_array($this->issue_material_product->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_material_product->ViewValue !== NULL) { // Load from cache
				$this->issue_material_product->EditValue = array_values($this->issue_material_product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`product`" . SearchString("=", $this->issue_material_product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->issue_material_product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_material_product->EditValue = $arwrk;
			}

			// issue_material_rid
			$this->issue_material_rid->EditAttrs["class"] = "form-control";
			$this->issue_material_rid->EditCustomAttributes = "";
			$this->issue_material_rid->EditValue = HtmlEncode($this->issue_material_rid->CurrentValue);
			$this->issue_material_rid->PlaceHolder = RemoveHtml($this->issue_material_rid->caption());

			// issue_material_packing
			$this->issue_material_packing->EditAttrs["class"] = "form-control";
			$this->issue_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_material_packing->CurrentValue));
			if ($curVal <> "")
				$this->issue_material_packing->ViewValue = $this->issue_material_packing->lookupCacheOption($curVal);
			else
				$this->issue_material_packing->ViewValue = $this->issue_material_packing->Lookup !== NULL && is_array($this->issue_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_material_packing->ViewValue !== NULL) { // Load from cache
				$this->issue_material_packing->EditValue = array_values($this->issue_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_material_packing->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_material_packing->EditValue = $arwrk;
			}

			// issue_material_qty
			$this->issue_material_qty->EditAttrs["class"] = "form-control";
			$this->issue_material_qty->EditCustomAttributes = "";
			$this->issue_material_qty->EditValue = HtmlEncode($this->issue_material_qty->CurrentValue);
			$this->issue_material_qty->PlaceHolder = RemoveHtml($this->issue_material_qty->caption());
			if (strval($this->issue_material_qty->EditValue) <> "" && is_numeric($this->issue_material_qty->EditValue))
				$this->issue_material_qty->EditValue = FormatNumber($this->issue_material_qty->EditValue, -2, -2, -2, -2);

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->unit->EditValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->EditValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->EditValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->EditAttrs["class"] = "form-control";
			$this->material_qty->EditCustomAttributes = "";
			$this->material_qty->EditValue = $this->material_qty->CurrentValue;
			$curVal = strval($this->material_qty->CurrentValue);
			if ($curVal <> "") {
				$this->material_qty->EditValue = $this->material_qty->lookupCacheOption($curVal);
				if ($this->material_qty->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->material_qty->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->material_qty->EditValue = $this->material_qty->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->material_qty->EditValue = $this->material_qty->CurrentValue;
					}
				}
			} else {
				$this->material_qty->EditValue = NULL;
			}
			$this->material_qty->ViewCustomAttributes = "";

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->EditValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->EditValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->EditValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->EditValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->EditValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->EditValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->EditValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// operator
			// datetime
			// material_out

			$this->material_out->EditCustomAttributes = "";
			$this->material_out->EditValue = $this->material_out->options(FALSE);

			// issue_to
			$this->issue_to->EditAttrs["class"] = "form-control";
			$this->issue_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_to->CurrentValue));
			if ($curVal <> "")
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			else
				$this->issue_to->ViewValue = $this->issue_to->Lookup !== NULL && is_array($this->issue_to->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_to->ViewValue !== NULL) { // Load from cache
				$this->issue_to->EditValue = array_values($this->issue_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` IN (0,3)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_to->EditValue = $arwrk;
			}

			// pp_id
			$this->pp_id->EditAttrs["class"] = "form-control";
			$this->pp_id->EditCustomAttributes = "";
			$this->pp_id->EditValue = HtmlEncode($this->pp_id->CurrentValue);
			$this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

			// level
			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = HtmlEncode($this->level->CurrentValue);
			$this->level->PlaceHolder = RemoveHtml($this->level->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_id->CurrentValue)) {
				$this->buyer_id->HrefValue = "material_required_livelist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
				$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
			} else {
				$this->buyer_id->HrefValue = "";
			}
			$this->buyer_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "material_required_livelist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "material_required_livelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_id->CurrentValue)) {
				$this->product_id->HrefValue = "material_required_livelist.php?x_product_id=" . $this->product_id->CurrentValue; // Add prefix/suffix
				$this->product_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
			} else {
				$this->product_id->HrefValue = "";
			}
			$this->product_id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// Size_wl
			$this->Size_wl->LinkCustomAttributes = "";
			$this->Size_wl->HrefValue = "";
			$this->Size_wl->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// req_material_grp
			$this->req_material_grp->LinkCustomAttributes = "";
			$this->req_material_grp->HrefValue = "";

			// req_material_sgrp
			$this->req_material_sgrp->LinkCustomAttributes = "";
			$this->req_material_sgrp->HrefValue = "";
			$this->req_material_sgrp->TooltipValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";

			// issue_material_grp
			$this->issue_material_grp->LinkCustomAttributes = "";
			$this->issue_material_grp->HrefValue = "";

			// issue_material_sgrp
			$this->issue_material_sgrp->LinkCustomAttributes = "";
			$this->issue_material_sgrp->HrefValue = "";

			// issue_material_product
			$this->issue_material_product->LinkCustomAttributes = "";
			$this->issue_material_product->HrefValue = "";

			// issue_material_rid
			$this->issue_material_rid->LinkCustomAttributes = "";
			$this->issue_material_rid->HrefValue = "";

			// issue_material_packing
			$this->issue_material_packing->LinkCustomAttributes = "";
			$this->issue_material_packing->HrefValue = "";

			// issue_material_qty
			$this->issue_material_qty->LinkCustomAttributes = "";
			$this->issue_material_qty->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// material_out
			$this->material_out->LinkCustomAttributes = "";
			$this->material_out->HrefValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->poid->Required) {
			if (!$this->poid->IsDetailKey && $this->poid->FormValue != NULL && $this->poid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
			}
		}
		if ($this->weaving_works->Required) {
			if (!$this->weaving_works->IsDetailKey && $this->weaving_works->FormValue != NULL && $this->weaving_works->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->weaving_works->caption(), $this->weaving_works->RequiredErrorMessage));
			}
		}
		if ($this->week->Required) {
			if (!$this->week->IsDetailKey && $this->week->FormValue != NULL && $this->week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->week->caption(), $this->week->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->product_id->Required) {
			if (!$this->product_id->IsDetailKey && $this->product_id->FormValue != NULL && $this->product_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->Size_wl->Required) {
			if (!$this->Size_wl->IsDetailKey && $this->Size_wl->FormValue != NULL && $this->Size_wl->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Size_wl->caption(), $this->Size_wl->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->req_material_grp->Required) {
			if (!$this->req_material_grp->IsDetailKey && $this->req_material_grp->FormValue != NULL && $this->req_material_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_grp->caption(), $this->req_material_grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->req_material_grp->FormValue)) {
			AddMessage($FormError, $this->req_material_grp->errorMessage());
		}
		if ($this->req_material_sgrp->Required) {
			if (!$this->req_material_sgrp->IsDetailKey && $this->req_material_sgrp->FormValue != NULL && $this->req_material_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_sgrp->caption(), $this->req_material_sgrp->RequiredErrorMessage));
			}
		}
		if ($this->req_material_product->Required) {
			if (!$this->req_material_product->IsDetailKey && $this->req_material_product->FormValue != NULL && $this->req_material_product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_product->caption(), $this->req_material_product->RequiredErrorMessage));
			}
		}
		if ($this->req_material_rid->Required) {
			if ($this->req_material_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_rid->caption(), $this->req_material_rid->RequiredErrorMessage));
			}
		}
		if ($this->req_material_qty->Required) {
			if (!$this->req_material_qty->IsDetailKey && $this->req_material_qty->FormValue != NULL && $this->req_material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_qty->caption(), $this->req_material_qty->RequiredErrorMessage));
			}
		}
		if ($this->req_material_packing->Required) {
			if (!$this->req_material_packing->IsDetailKey && $this->req_material_packing->FormValue != NULL && $this->req_material_packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_material_packing->caption(), $this->req_material_packing->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_grp->Required) {
			if (!$this->issue_material_grp->IsDetailKey && $this->issue_material_grp->FormValue != NULL && $this->issue_material_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_grp->caption(), $this->issue_material_grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->issue_material_grp->FormValue)) {
			AddMessage($FormError, $this->issue_material_grp->errorMessage());
		}
		if ($this->issue_material_sgrp->Required) {
			if (!$this->issue_material_sgrp->IsDetailKey && $this->issue_material_sgrp->FormValue != NULL && $this->issue_material_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_sgrp->caption(), $this->issue_material_sgrp->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_product->Required) {
			if (!$this->issue_material_product->IsDetailKey && $this->issue_material_product->FormValue != NULL && $this->issue_material_product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_product->caption(), $this->issue_material_product->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_rid->Required) {
			if (!$this->issue_material_rid->IsDetailKey && $this->issue_material_rid->FormValue != NULL && $this->issue_material_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_rid->caption(), $this->issue_material_rid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->issue_material_rid->FormValue)) {
			AddMessage($FormError, $this->issue_material_rid->errorMessage());
		}
		if ($this->issue_material_packing->Required) {
			if (!$this->issue_material_packing->IsDetailKey && $this->issue_material_packing->FormValue != NULL && $this->issue_material_packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_packing->caption(), $this->issue_material_packing->RequiredErrorMessage));
			}
		}
		if ($this->issue_material_qty->Required) {
			if (!$this->issue_material_qty->IsDetailKey && $this->issue_material_qty->FormValue != NULL && $this->issue_material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_material_qty->caption(), $this->issue_material_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->issue_material_qty->FormValue)) {
			AddMessage($FormError, $this->issue_material_qty->errorMessage());
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->material_qty->Required) {
			if (!$this->material_qty->IsDetailKey && $this->material_qty->FormValue != NULL && $this->material_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_qty->caption(), $this->material_qty->RequiredErrorMessage));
			}
		}
		if ($this->method->Required) {
			if (!$this->method->IsDetailKey && $this->method->FormValue != NULL && $this->method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
			}
		}
		if ($this->despatch_week->Required) {
			if (!$this->despatch_week->IsDetailKey && $this->despatch_week->FormValue != NULL && $this->despatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
			}
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_date->FormValue)) {
			AddMessage($FormError, $this->despatch_date->errorMessage());
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->material_out->Required) {
			if ($this->material_out->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_out->caption(), $this->material_out->RequiredErrorMessage));
			}
		}
		if ($this->material_out_id->Required) {
			if (!$this->material_out_id->IsDetailKey && $this->material_out_id->FormValue != NULL && $this->material_out_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_out_id->caption(), $this->material_out_id->RequiredErrorMessage));
			}
		}
		if ($this->order_id->Required) {
			if (!$this->order_id->IsDetailKey && $this->order_id->FormValue != NULL && $this->order_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_id->caption(), $this->order_id->RequiredErrorMessage));
			}
		}
		if ($this->issue_to->Required) {
			if (!$this->issue_to->IsDetailKey && $this->issue_to->FormValue != NULL && $this->issue_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
			}
		}
		if ($this->t_sqm->Required) {
			if (!$this->t_sqm->IsDetailKey && $this->t_sqm->FormValue != NULL && $this->t_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_sqm->caption(), $this->t_sqm->RequiredErrorMessage));
			}
		}
		if ($this->pp_id->Required) {
			if (!$this->pp_id->IsDetailKey && $this->pp_id->FormValue != NULL && $this->pp_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_id->caption(), $this->pp_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->pp_id->FormValue)) {
			AddMessage($FormError, $this->pp_id->errorMessage());
		}
		if ($this->level->Required) {
			if (!$this->level->IsDetailKey && $this->level->FormValue != NULL && $this->level->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->level->caption(), $this->level->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->level->FormValue)) {
			AddMessage($FormError, $this->level->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// weaving_works
			$this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, NULL, $this->weaving_works->ReadOnly);

			// req_material_grp
			$this->req_material_grp->setDbValueDef($rsnew, $this->req_material_grp->CurrentValue, NULL, $this->req_material_grp->ReadOnly);

			// req_material_packing
			$this->req_material_packing->setDbValueDef($rsnew, $this->req_material_packing->CurrentValue, 0, $this->req_material_packing->ReadOnly);

			// issue_material_grp
			$this->issue_material_grp->setDbValueDef($rsnew, $this->issue_material_grp->CurrentValue, NULL, $this->issue_material_grp->ReadOnly);

			// issue_material_sgrp
			$this->issue_material_sgrp->setDbValueDef($rsnew, $this->issue_material_sgrp->CurrentValue, NULL, $this->issue_material_sgrp->ReadOnly);

			// issue_material_product
			$this->issue_material_product->setDbValueDef($rsnew, $this->issue_material_product->CurrentValue, NULL, $this->issue_material_product->ReadOnly);

			// issue_material_rid
			$this->issue_material_rid->setDbValueDef($rsnew, $this->issue_material_rid->CurrentValue, NULL, $this->issue_material_rid->ReadOnly);

			// issue_material_packing
			$this->issue_material_packing->setDbValueDef($rsnew, $this->issue_material_packing->CurrentValue, 0, $this->issue_material_packing->ReadOnly);

			// issue_material_qty
			$this->issue_material_qty->setDbValueDef($rsnew, $this->issue_material_qty->CurrentValue, NULL, $this->issue_material_qty->ReadOnly);

			// despatch_date
			$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), CurrentDate(), $this->despatch_date->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// material_out
			$this->material_out->setDbValueDef($rsnew, $this->material_out->CurrentValue, NULL, $this->material_out->ReadOnly);

			// issue_to
			$this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, 0, $this->issue_to->ReadOnly);

			// pp_id
			$this->pp_id->setDbValueDef($rsnew, $this->pp_id->CurrentValue, NULL, $this->pp_id->ReadOnly);

			// level
			$this->level->setDbValueDef($rsnew, $this->level->CurrentValue, NULL, $this->level->ReadOnly);

			// Check referential integrity for master table 'required_material_compiled_live'
			$validMasterRecord = TRUE;
			$masterFilter = $this->sqlMasterFilter_required_material_compiled_live();
			$keyValue = isset($rsnew['po']) ? $rsnew['po'] : $rsold['po'];
			if (strval($keyValue) <> "") {
				$masterFilter = str_replace("@po@", AdjustSql($keyValue), $masterFilter);
			} else {
				$validMasterRecord = FALSE;
			}
			$keyValue = isset($rsnew['req_material_rid']) ? $rsnew['req_material_rid'] : $rsold['req_material_rid'];
			if (strval($keyValue) <> "") {
				$masterFilter = str_replace("@req_material_rid@", AdjustSql($keyValue), $masterFilter);
			} else {
				$validMasterRecord = FALSE;
			}
			if ($validMasterRecord) {
				if (!isset($GLOBALS["required_material_compiled_live"]))
					$GLOBALS["required_material_compiled_live"] = new required_material_compiled_live();
				$rsmaster = $GLOBALS["required_material_compiled_live"]->loadRs($masterFilter);
				$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
				$rsmaster->close();
			}
			if (!$validMasterRecord) {
				$relatedRecordMsg = str_replace("%t", "required_material_compiled_live", $Language->phrase("RelatedRecordRequired"));
				$this->setFailureMessage($relatedRecordMsg);
				$rs->close();
				return FALSE;
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (Get(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Get(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "required_material_compiled_live") {
				$validMaster = TRUE;
				if (Get("fk_po") !== NULL) {
					$this->po->setQueryStringValue(Get("fk_po"));
					$this->po->setSessionValue($this->po->QueryStringValue);
					if (!is_numeric($this->po->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
				if (Get("fk_req_material_rid") !== NULL) {
					$this->req_material_rid->setQueryStringValue(Get("fk_req_material_rid"));
					$this->req_material_rid->setSessionValue($this->req_material_rid->QueryStringValue);
					if (!is_numeric($this->req_material_rid->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (Post(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Post(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "required_material_compiled_live") {
				$validMaster = TRUE;
				if (Post("fk_po") !== NULL) {
					$this->po->setFormValue(Post("fk_po"));
					$this->po->setSessionValue($this->po->FormValue);
					if (!is_numeric($this->po->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
				if (Post("fk_req_material_rid") !== NULL) {
					$this->req_material_rid->setFormValue(Post("fk_req_material_rid"));
					$this->req_material_rid->setSessionValue($this->req_material_rid->FormValue);
					if (!is_numeric($this->req_material_rid->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);
			$this->setSessionWhere($this->getDetailFilter());

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRec = 1;
				$this->setStartRecordNumber($this->StartRec);
			}

			// Clear previous master key from Session
			if ($masterTblVar <> "required_material_compiled_live") {
				if ($this->po->CurrentValue == "")
					$this->po->setSessionValue("");
				if ($this->req_material_rid->CurrentValue == "")
					$this->req_material_rid->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("material_required_livelist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_material_sgrp":
					$lookupFilter = function() {
						return "`grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_material_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_unit":
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to":
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_weaving_works":
							break;
						case "x_week":
							break;
						case "x_buyer_id":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_product_id":
							break;
						case "x_batch_no":
							break;
						case "x_req_material_sgrp":
							break;
						case "x_req_material_product":
							break;
						case "x_req_material_rid":
							break;
						case "x_req_material_packing":
							break;
						case "x_issue_material_sgrp":
							break;
						case "x_issue_material_product":
							break;
						case "x_issue_material_packing":
							break;
						case "x_unit":
							break;
						case "x_material_qty":
							break;
						case "x_method":
							break;
						case "x_despatch_week":
							break;
						case "x_operator":
							break;
						case "x_issue_to":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>