<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class material_required_live_search extends material_required_live
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'material_required_live';

	// Page object name
	public $PageObjName = "material_required_live_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (material_required_live)
		if (!isset($GLOBALS["material_required_live"]) || get_class($GLOBALS["material_required_live"]) == PROJECT_NAMESPACE . "material_required_live") {
			$GLOBALS["material_required_live"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["material_required_live"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Table object (required_material_compiled_live)
		if (!isset($GLOBALS['required_material_compiled_live']))
			$GLOBALS['required_material_compiled_live'] = new required_material_compiled_live();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required_live');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $material_required_live;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($material_required_live);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "material_required_liveview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("material_required_livelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->poid->setVisibility();
		$this->weaving_works->setVisibility();
		$this->week->setVisibility();
		$this->po->setVisibility();
		$this->buyer_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_id->setVisibility();
		$this->batch_no->Visible = FALSE;
		$this->quantity->setVisibility();
		$this->Size_wl->setVisibility();
		$this->sqm->setVisibility();
		$this->req_material_grp->setVisibility();
		$this->req_material_sgrp->setVisibility();
		$this->req_material_product->setVisibility();
		$this->req_material_rid->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->req_material_packing->setVisibility();
		$this->issue_material_grp->setVisibility();
		$this->issue_material_sgrp->setVisibility();
		$this->issue_material_product->setVisibility();
		$this->issue_material_rid->setVisibility();
		$this->issue_material_packing->setVisibility();
		$this->issue_material_qty->setVisibility();
		$this->unit->setVisibility();
		$this->material_qty->setVisibility();
		$this->method->setVisibility();
		$this->despatch_week->setVisibility();
		$this->despatch_date->setVisibility();
		$this->production_plan->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->updated->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->material_out->setVisibility();
		$this->material_out_id->Visible = FALSE;
		$this->order_id->Visible = FALSE;
		$this->issue_to->setVisibility();
		$this->t_sqm->Visible = FALSE;
		$this->pp_id->setVisibility();
		$this->level->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->weaving_works);
		$this->setupLookupOptions($this->week);
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_id);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->req_material_sgrp);
		$this->setupLookupOptions($this->req_material_product);
		$this->setupLookupOptions($this->req_material_rid);
		$this->setupLookupOptions($this->req_material_packing);
		$this->setupLookupOptions($this->issue_material_sgrp);
		$this->setupLookupOptions($this->issue_material_product);
		$this->setupLookupOptions($this->issue_material_packing);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->material_qty);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->issue_to);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "material_required_livelist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->poid); // poid
		$this->buildSearchUrl($srchUrl, $this->weaving_works); // weaving_works
		$this->buildSearchUrl($srchUrl, $this->week); // week
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		$this->buildSearchUrl($srchUrl, $this->product); // product
		$this->buildSearchUrl($srchUrl, $this->product_id); // product_id
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->Size_wl); // Size_wl
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->req_material_grp); // req_material_grp
		$this->buildSearchUrl($srchUrl, $this->req_material_sgrp); // req_material_sgrp
		$this->buildSearchUrl($srchUrl, $this->req_material_product); // req_material_product
		$this->buildSearchUrl($srchUrl, $this->req_material_rid); // req_material_rid
		$this->buildSearchUrl($srchUrl, $this->req_material_qty); // req_material_qty
		$this->buildSearchUrl($srchUrl, $this->req_material_packing); // req_material_packing
		$this->buildSearchUrl($srchUrl, $this->issue_material_grp); // issue_material_grp
		$this->buildSearchUrl($srchUrl, $this->issue_material_sgrp); // issue_material_sgrp
		$this->buildSearchUrl($srchUrl, $this->issue_material_product); // issue_material_product
		$this->buildSearchUrl($srchUrl, $this->issue_material_rid); // issue_material_rid
		$this->buildSearchUrl($srchUrl, $this->issue_material_packing); // issue_material_packing
		$this->buildSearchUrl($srchUrl, $this->issue_material_qty); // issue_material_qty
		$this->buildSearchUrl($srchUrl, $this->unit); // unit
		$this->buildSearchUrl($srchUrl, $this->material_qty); // material_qty
		$this->buildSearchUrl($srchUrl, $this->method); // method
		$this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
		$this->buildSearchUrl($srchUrl, $this->despatch_date); // despatch_date
		$this->buildSearchUrl($srchUrl, $this->production_plan); // production_plan
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->material_out); // material_out
		$this->buildSearchUrl($srchUrl, $this->issue_to); // issue_to
		$this->buildSearchUrl($srchUrl, $this->pp_id); // pp_id
		$this->buildSearchUrl($srchUrl, $this->level); // level
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// poid
		if (!$this->isAddOrEdit())
			$this->poid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_poid"));
		$this->poid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_poid"));

		// weaving_works
		if (!$this->isAddOrEdit())
			$this->weaving_works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_weaving_works"));
		$this->weaving_works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_weaving_works"));

		// week
		if (!$this->isAddOrEdit())
			$this->week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_week"));
		$this->week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_week"));
		$this->week->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_week"));
		$this->week->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_week"));
		$this->week->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_week"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));
		$this->po->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_po"));
		$this->po->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_po"));
		$this->po->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_po"));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_id"));
		$this->buyer_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_id"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product"));
		$this->product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product"));

		// product_id
		if (!$this->isAddOrEdit())
			$this->product_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_id"));
		$this->product_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_id"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// Size_wl
		if (!$this->isAddOrEdit())
			$this->Size_wl->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Size_wl"));
		$this->Size_wl->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Size_wl"));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// req_material_grp
		if (!$this->isAddOrEdit())
			$this->req_material_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_grp"));
		$this->req_material_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_grp"));

		// req_material_sgrp
		if (!$this->isAddOrEdit())
			$this->req_material_sgrp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_sgrp"));
		$this->req_material_sgrp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_sgrp"));

		// req_material_product
		if (!$this->isAddOrEdit())
			$this->req_material_product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_product"));
		$this->req_material_product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_product"));

		// req_material_rid
		if (!$this->isAddOrEdit())
			$this->req_material_rid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_rid"));
		$this->req_material_rid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_rid"));

		// req_material_qty
		if (!$this->isAddOrEdit())
			$this->req_material_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_qty"));
		$this->req_material_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_qty"));

		// req_material_packing
		if (!$this->isAddOrEdit())
			$this->req_material_packing->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_packing"));
		$this->req_material_packing->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_packing"));

		// issue_material_grp
		if (!$this->isAddOrEdit())
			$this->issue_material_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_issue_material_grp"));
		$this->issue_material_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_issue_material_grp"));

		// issue_material_sgrp
		if (!$this->isAddOrEdit())
			$this->issue_material_sgrp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_issue_material_sgrp"));
		$this->issue_material_sgrp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_issue_material_sgrp"));

		// issue_material_product
		if (!$this->isAddOrEdit())
			$this->issue_material_product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_issue_material_product"));
		$this->issue_material_product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_issue_material_product"));

		// issue_material_rid
		if (!$this->isAddOrEdit())
			$this->issue_material_rid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_issue_material_rid"));
		$this->issue_material_rid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_issue_material_rid"));

		// issue_material_packing
		if (!$this->isAddOrEdit())
			$this->issue_material_packing->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_issue_material_packing"));
		$this->issue_material_packing->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_issue_material_packing"));

		// issue_material_qty
		if (!$this->isAddOrEdit())
			$this->issue_material_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_issue_material_qty"));
		$this->issue_material_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_issue_material_qty"));

		// unit
		if (!$this->isAddOrEdit())
			$this->unit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unit"));
		$this->unit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unit"));

		// material_qty
		if (!$this->isAddOrEdit())
			$this->material_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_material_qty"));
		$this->material_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_material_qty"));

		// method
		if (!$this->isAddOrEdit())
			$this->method->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_method"));
		$this->method->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_method"));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_week"));

		// despatch_date
		if (!$this->isAddOrEdit())
			$this->despatch_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_date"));
		$this->despatch_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_date"));

		// production_plan
		if (!$this->isAddOrEdit())
			$this->production_plan->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_production_plan"));
		$this->production_plan->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_production_plan"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// material_out
		if (!$this->isAddOrEdit())
			$this->material_out->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_material_out"));
		$this->material_out->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_material_out"));

		// issue_to
		if (!$this->isAddOrEdit())
			$this->issue_to->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_issue_to"));
		$this->issue_to->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_issue_to"));

		// pp_id
		if (!$this->isAddOrEdit())
			$this->pp_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pp_id"));
		$this->pp_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pp_id"));

		// level
		if (!$this->isAddOrEdit())
			$this->level->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_level"));
		$this->level->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_level"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->issue_material_qty->FormValue == $this->issue_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->issue_material_qty->CurrentValue)))
			$this->issue_material_qty->CurrentValue = ConvertToFloatString($this->issue_material_qty->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// poid
		// weaving_works
		// week
		// po
		// buyer_id
		// grp
		// s_grp
		// product
		// product_id
		// batch_no
		// quantity
		// Size_wl
		// sqm
		// req_material_grp
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_qty
		// req_material_packing
		// issue_material_grp
		// issue_material_sgrp
		// issue_material_product
		// issue_material_rid
		// issue_material_packing
		// issue_material_qty
		// unit
		// material_qty
		// method
		// despatch_week
		// despatch_date
		// production_plan
		// remarks
		// updated
		// operator
		// datetime
		// material_out
		// material_out_id
		// order_id
		// issue_to
		// t_sqm
		// pp_id
		// level

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// weaving_works
			$curVal = strval($this->weaving_works->CurrentValue);
			if ($curVal <> "") {
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
				if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
					}
				}
			} else {
				$this->weaving_works->ViewValue = NULL;
			}
			$this->weaving_works->ViewCustomAttributes = "";

			// week
			$curVal = strval($this->week->CurrentValue);
			if ($curVal <> "") {
				$this->week->ViewValue = $this->week->lookupCacheOption($curVal);
				if ($this->week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->week->ViewValue = $this->week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->week->ViewValue = $this->week->CurrentValue;
					}
				}
			} else {
				$this->week->ViewValue = NULL;
			}
			$this->week->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			if ($this->product->VirtualValue <> "") {
				$this->product->ViewValue = $this->product->VirtualValue;
			} else {
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// product_id
			if ($this->product_id->VirtualValue <> "") {
				$this->product_id->ViewValue = $this->product_id->VirtualValue;
			} else {
			$curVal = strval($this->product_id->CurrentValue);
			if ($curVal <> "") {
				$this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
				if ($this->product_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_id->ViewValue = $this->product_id->CurrentValue;
					}
				}
			} else {
				$this->product_id->ViewValue = NULL;
			}
			}
			$this->product_id->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// Size_wl
			$this->Size_wl->ViewValue = $this->Size_wl->CurrentValue;
			$this->Size_wl->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// req_material_grp
			$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
			$this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, 0, -2, -2, -2);
			$this->req_material_grp->ViewCustomAttributes = "";

			// req_material_sgrp
			$curVal = strval($this->req_material_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
				if ($this->req_material_sgrp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
					}
				}
			} else {
				$this->req_material_sgrp->ViewValue = NULL;
			}
			$this->req_material_sgrp->ViewCustomAttributes = "";

			// req_material_product
			$curVal = strval($this->req_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
				if ($this->req_material_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
					}
				}
			} else {
				$this->req_material_product->ViewValue = NULL;
			}
			$this->req_material_product->ViewCustomAttributes = "";

			// req_material_rid
			if ($this->req_material_rid->VirtualValue <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
			} else {
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->ViewValue = NULL;
			}
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// req_material_packing
			$curVal = strval($this->req_material_packing->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
				if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
					}
				}
			} else {
				$this->req_material_packing->ViewValue = NULL;
			}
			$this->req_material_packing->ViewCustomAttributes = "";

			// issue_material_grp
			$this->issue_material_grp->ViewValue = $this->issue_material_grp->CurrentValue;
			$this->issue_material_grp->ViewValue = FormatNumber($this->issue_material_grp->ViewValue, 0, -2, -2, -2);
			$this->issue_material_grp->ViewCustomAttributes = "";

			// issue_material_sgrp
			$curVal = strval($this->issue_material_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->lookupCacheOption($curVal);
				if ($this->issue_material_sgrp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_material_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_material_sgrp->ViewValue = $this->issue_material_sgrp->CurrentValue;
					}
				}
			} else {
				$this->issue_material_sgrp->ViewValue = NULL;
			}
			$this->issue_material_sgrp->ViewCustomAttributes = "";

			// issue_material_product
			$curVal = strval($this->issue_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->issue_material_product->ViewValue = $this->issue_material_product->lookupCacheOption($curVal);
				if ($this->issue_material_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`product`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->issue_material_product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_material_product->ViewValue = $this->issue_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_material_product->ViewValue = $this->issue_material_product->CurrentValue;
					}
				}
			} else {
				$this->issue_material_product->ViewValue = NULL;
			}
			$this->issue_material_product->ViewCustomAttributes = "";

			// issue_material_rid
			$this->issue_material_rid->ViewValue = $this->issue_material_rid->CurrentValue;
			$this->issue_material_rid->ViewValue = FormatNumber($this->issue_material_rid->ViewValue, 0, -2, -2, -2);
			$this->issue_material_rid->ViewCustomAttributes = "";

			// issue_material_packing
			$curVal = strval($this->issue_material_packing->CurrentValue);
			if ($curVal <> "") {
				$this->issue_material_packing->ViewValue = $this->issue_material_packing->lookupCacheOption($curVal);
				if ($this->issue_material_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_material_packing->ViewValue = $this->issue_material_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_material_packing->ViewValue = $this->issue_material_packing->CurrentValue;
					}
				}
			} else {
				$this->issue_material_packing->ViewValue = NULL;
			}
			$this->issue_material_packing->ViewCustomAttributes = "";

			// issue_material_qty
			$this->issue_material_qty->ViewValue = $this->issue_material_qty->CurrentValue;
			$this->issue_material_qty->ViewValue = FormatNumber($this->issue_material_qty->ViewValue, 2, -2, -2, -2);
			$this->issue_material_qty->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// material_qty
			$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
			$curVal = strval($this->material_qty->CurrentValue);
			if ($curVal <> "") {
				$this->material_qty->ViewValue = $this->material_qty->lookupCacheOption($curVal);
				if ($this->material_qty->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->material_qty->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->material_qty->ViewValue = $this->material_qty->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
					}
				}
			} else {
				$this->material_qty->ViewValue = NULL;
			}
			$this->material_qty->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// material_out
			if (strval($this->material_out->CurrentValue) <> "") {
				$this->material_out->ViewValue = $this->material_out->optionCaption($this->material_out->CurrentValue);
			} else {
				$this->material_out->ViewValue = NULL;
			}
			$this->material_out->ViewCustomAttributes = "";

			// order_id
			$this->order_id->ViewValue = $this->order_id->CurrentValue;
			$this->order_id->ViewCustomAttributes = "";

			// issue_to
			$curVal = strval($this->issue_to->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
				if ($this->issue_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
					}
				}
			} else {
				$this->issue_to->ViewValue = NULL;
			}
			$this->issue_to->ViewCustomAttributes = "";

			// pp_id
			$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
			$this->pp_id->ViewValue = FormatNumber($this->pp_id->ViewValue, 0, -2, -2, -2);
			$this->pp_id->ViewCustomAttributes = "";

			// level
			$this->level->ViewValue = $this->level->CurrentValue;
			$this->level->ViewValue = FormatNumber($this->level->ViewValue, 0, -2, -2, -2);
			$this->level->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// week
			$this->week->LinkCustomAttributes = "";
			$this->week->HrefValue = "";
			$this->week->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_id->CurrentValue)) {
				$this->buyer_id->HrefValue = "material_required_livelist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
				$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
			} else {
				$this->buyer_id->HrefValue = "";
			}
			$this->buyer_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "material_required_livelist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "material_required_livelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_id
			$this->product_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_id->CurrentValue)) {
				$this->product_id->HrefValue = "material_required_livelist.php?x_product_id=" . $this->product_id->CurrentValue; // Add prefix/suffix
				$this->product_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
			} else {
				$this->product_id->HrefValue = "";
			}
			$this->product_id->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// Size_wl
			$this->Size_wl->LinkCustomAttributes = "";
			$this->Size_wl->HrefValue = "";
			$this->Size_wl->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// req_material_grp
			$this->req_material_grp->LinkCustomAttributes = "";
			$this->req_material_grp->HrefValue = "";
			$this->req_material_grp->TooltipValue = "";

			// req_material_sgrp
			$this->req_material_sgrp->LinkCustomAttributes = "";
			$this->req_material_sgrp->HrefValue = "";
			$this->req_material_sgrp->TooltipValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			$this->req_material_rid->HrefValue = "";
			$this->req_material_rid->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			$this->req_material_packing->HrefValue = "";
			$this->req_material_packing->TooltipValue = "";

			// issue_material_grp
			$this->issue_material_grp->LinkCustomAttributes = "";
			$this->issue_material_grp->HrefValue = "";
			$this->issue_material_grp->TooltipValue = "";

			// issue_material_sgrp
			$this->issue_material_sgrp->LinkCustomAttributes = "";
			$this->issue_material_sgrp->HrefValue = "";
			$this->issue_material_sgrp->TooltipValue = "";

			// issue_material_product
			$this->issue_material_product->LinkCustomAttributes = "";
			$this->issue_material_product->HrefValue = "";
			$this->issue_material_product->TooltipValue = "";

			// issue_material_rid
			$this->issue_material_rid->LinkCustomAttributes = "";
			$this->issue_material_rid->HrefValue = "";
			$this->issue_material_rid->TooltipValue = "";

			// issue_material_packing
			$this->issue_material_packing->LinkCustomAttributes = "";
			$this->issue_material_packing->HrefValue = "";
			$this->issue_material_packing->TooltipValue = "";

			// issue_material_qty
			$this->issue_material_qty->LinkCustomAttributes = "";
			$this->issue_material_qty->HrefValue = "";
			$this->issue_material_qty->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// material_qty
			$this->material_qty->LinkCustomAttributes = "";
			$this->material_qty->HrefValue = "";
			$this->material_qty->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// material_out
			$this->material_out->LinkCustomAttributes = "";
			$this->material_out->HrefValue = "";
			$this->material_out->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";
			$this->issue_to->TooltipValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";
			$this->pp_id->TooltipValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
			$this->level->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// poid
			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = "";
			$this->poid->EditValue = HtmlEncode($this->poid->AdvancedSearch->SearchValue);
			$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->weaving_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			else
				$this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->Lookup !== NULL && is_array($this->weaving_works->Lookup->Options) ? $curVal : NULL;
			if ($this->weaving_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->weaving_works->EditValue = array_values($this->weaving_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->weaving_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->weaving_works->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->weaving_works->EditValue = $arwrk;
			}

			// week
			$this->week->EditAttrs["class"] = "form-control";
			$this->week->EditCustomAttributes = 'ReadOnly';
			$curVal = trim(strval($this->week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->week->AdvancedSearch->ViewValue = $this->week->lookupCacheOption($curVal);
			else
				$this->week->AdvancedSearch->ViewValue = $this->week->Lookup !== NULL && is_array($this->week->Lookup->Options) ? $curVal : NULL;
			if ($this->week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->week->EditValue = array_values($this->week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`wid`" . SearchString("=", $this->week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->week->EditValue = $arwrk;
			}
			$this->week->EditAttrs["class"] = "form-control";
			$this->week->EditCustomAttributes = 'ReadOnly';
			$curVal = trim(strval($this->week->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->week->AdvancedSearch->ViewValue2 = $this->week->lookupCacheOption($curVal);
			else
				$this->week->AdvancedSearch->ViewValue2 = $this->week->Lookup !== NULL && is_array($this->week->Lookup->Options) ? $curVal : NULL;
			if ($this->week->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->week->EditValue2 = array_values($this->week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`wid`" . SearchString("=", $this->week->AdvancedSearch->SearchValue2, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->week->EditValue2 = $arwrk;
			}

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			else
				$this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->Lookup !== NULL && is_array($this->buyer_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyer_id->EditValue = array_values($this->buyer_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_id->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = $this->grp->options(TRUE);

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->AdvancedSearch->SearchValue);
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// product_id
			$this->product_id->EditAttrs["class"] = "form-control";
			$this->product_id->EditCustomAttributes = "";
			$this->product_id->EditValue = HtmlEncode($this->product_id->AdvancedSearch->SearchValue);
			$this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// Size_wl
			$this->Size_wl->EditAttrs["class"] = "form-control";
			$this->Size_wl->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Size_wl->AdvancedSearch->SearchValue = HtmlDecode($this->Size_wl->AdvancedSearch->SearchValue);
			$this->Size_wl->EditValue = HtmlEncode($this->Size_wl->AdvancedSearch->SearchValue);
			$this->Size_wl->PlaceHolder = RemoveHtml($this->Size_wl->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// req_material_grp
			$this->req_material_grp->EditAttrs["class"] = "form-control";
			$this->req_material_grp->EditCustomAttributes = "";
			$this->req_material_grp->EditValue = HtmlEncode($this->req_material_grp->AdvancedSearch->SearchValue);
			$this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());

			// req_material_sgrp
			$this->req_material_sgrp->EditAttrs["class"] = "form-control";
			$this->req_material_sgrp->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_sgrp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->req_material_sgrp->AdvancedSearch->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
			else
				$this->req_material_sgrp->AdvancedSearch->ViewValue = $this->req_material_sgrp->Lookup !== NULL && is_array($this->req_material_sgrp->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_sgrp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->req_material_sgrp->EditValue = array_values($this->req_material_sgrp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_sgrp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->req_material_sgrp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_sgrp->EditValue = $arwrk;
			}

			// req_material_product
			$this->req_material_product->EditAttrs["class"] = "form-control";
			$this->req_material_product->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_product->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->req_material_product->AdvancedSearch->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
			else
				$this->req_material_product->AdvancedSearch->ViewValue = $this->req_material_product->Lookup !== NULL && is_array($this->req_material_product->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_product->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->req_material_product->EditValue = array_values($this->req_material_product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_product->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->req_material_product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_product->EditValue = $arwrk;
			}

			// req_material_rid
			$this->req_material_rid->EditAttrs["class"] = "form-control";
			$this->req_material_rid->EditCustomAttributes = "";
			$this->req_material_rid->EditValue = HtmlEncode($this->req_material_rid->AdvancedSearch->SearchValue);
			$this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = HtmlEncode($this->req_material_qty->AdvancedSearch->SearchValue);
			$this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());

			// req_material_packing
			$this->req_material_packing->EditAttrs["class"] = "form-control";
			$this->req_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_packing->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			else
				$this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->Lookup !== NULL && is_array($this->req_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_packing->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->req_material_packing->EditValue = array_values($this->req_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_packing->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_packing->EditValue = $arwrk;
			}

			// issue_material_grp
			$this->issue_material_grp->EditAttrs["class"] = "form-control";
			$this->issue_material_grp->EditCustomAttributes = "";
			$this->issue_material_grp->EditValue = HtmlEncode($this->issue_material_grp->AdvancedSearch->SearchValue);
			$this->issue_material_grp->PlaceHolder = RemoveHtml($this->issue_material_grp->caption());

			// issue_material_sgrp
			$this->issue_material_sgrp->EditAttrs["class"] = "form-control";
			$this->issue_material_sgrp->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_material_sgrp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->issue_material_sgrp->AdvancedSearch->ViewValue = $this->issue_material_sgrp->lookupCacheOption($curVal);
			else
				$this->issue_material_sgrp->AdvancedSearch->ViewValue = $this->issue_material_sgrp->Lookup !== NULL && is_array($this->issue_material_sgrp->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_material_sgrp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->issue_material_sgrp->EditValue = array_values($this->issue_material_sgrp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_material_sgrp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_material_sgrp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_material_sgrp->EditValue = $arwrk;
			}

			// issue_material_product
			$this->issue_material_product->EditAttrs["class"] = "form-control";
			$this->issue_material_product->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_material_product->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->issue_material_product->AdvancedSearch->ViewValue = $this->issue_material_product->lookupCacheOption($curVal);
			else
				$this->issue_material_product->AdvancedSearch->ViewValue = $this->issue_material_product->Lookup !== NULL && is_array($this->issue_material_product->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_material_product->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->issue_material_product->EditValue = array_values($this->issue_material_product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`product`" . SearchString("=", $this->issue_material_product->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->issue_material_product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_material_product->EditValue = $arwrk;
			}

			// issue_material_rid
			$this->issue_material_rid->EditAttrs["class"] = "form-control";
			$this->issue_material_rid->EditCustomAttributes = "";
			$this->issue_material_rid->EditValue = HtmlEncode($this->issue_material_rid->AdvancedSearch->SearchValue);
			$this->issue_material_rid->PlaceHolder = RemoveHtml($this->issue_material_rid->caption());

			// issue_material_packing
			$this->issue_material_packing->EditAttrs["class"] = "form-control";
			$this->issue_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_material_packing->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->issue_material_packing->AdvancedSearch->ViewValue = $this->issue_material_packing->lookupCacheOption($curVal);
			else
				$this->issue_material_packing->AdvancedSearch->ViewValue = $this->issue_material_packing->Lookup !== NULL && is_array($this->issue_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_material_packing->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->issue_material_packing->EditValue = array_values($this->issue_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_material_packing->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_material_packing->EditValue = $arwrk;
			}

			// issue_material_qty
			$this->issue_material_qty->EditAttrs["class"] = "form-control";
			$this->issue_material_qty->EditCustomAttributes = "";
			$this->issue_material_qty->EditValue = HtmlEncode($this->issue_material_qty->AdvancedSearch->SearchValue);
			$this->issue_material_qty->PlaceHolder = RemoveHtml($this->issue_material_qty->caption());

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$curVal = trim(strval($this->unit->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->unit->AdvancedSearch->ViewValue = $this->unit->lookupCacheOption($curVal);
			else
				$this->unit->AdvancedSearch->ViewValue = $this->unit->Lookup !== NULL && is_array($this->unit->Lookup->Options) ? $curVal : NULL;
			if ($this->unit->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->unit->EditValue = array_values($this->unit->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->unit->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->unit->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->unit->EditValue = $arwrk;
			}

			// material_qty
			$this->material_qty->EditAttrs["class"] = "form-control";
			$this->material_qty->EditCustomAttributes = "";
			$this->material_qty->EditValue = HtmlEncode($this->material_qty->AdvancedSearch->SearchValue);
			$curVal = strval($this->material_qty->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->material_qty->EditValue = $this->material_qty->lookupCacheOption($curVal);
				if ($this->material_qty->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->material_qty->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->material_qty->EditValue = $this->material_qty->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->material_qty->EditValue = HtmlEncode($this->material_qty->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->material_qty->EditValue = NULL;
			}
			$this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = trim(strval($this->method->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->method->AdvancedSearch->ViewValue = $this->method->lookupCacheOption($curVal);
			else
				$this->method->AdvancedSearch->ViewValue = $this->method->Lookup !== NULL && is_array($this->method->Lookup->Options) ? $curVal : NULL;
			if ($this->method->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->method->EditValue = array_values($this->method->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->method->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=21";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->method->EditValue = $arwrk;
			}

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, 0), 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			$this->production_plan->EditValue = $this->production_plan->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// material_out
			$this->material_out->EditCustomAttributes = "";
			$this->material_out->EditValue = $this->material_out->options(FALSE);

			// issue_to
			$this->issue_to->EditAttrs["class"] = "form-control";
			$this->issue_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_to->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->issue_to->AdvancedSearch->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			else
				$this->issue_to->AdvancedSearch->ViewValue = $this->issue_to->Lookup !== NULL && is_array($this->issue_to->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_to->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->issue_to->EditValue = array_values($this->issue_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_to->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` IN (0,3)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_to->EditValue = $arwrk;
			}

			// pp_id
			$this->pp_id->EditAttrs["class"] = "form-control";
			$this->pp_id->EditCustomAttributes = "";
			$this->pp_id->EditValue = HtmlEncode($this->pp_id->AdvancedSearch->SearchValue);
			$this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

			// level
			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = HtmlEncode($this->level->AdvancedSearch->SearchValue);
			$this->level->PlaceHolder = RemoveHtml($this->level->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->poid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->poid->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm->errorMessage());
		}
		if (!CheckInteger($this->req_material_grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->req_material_grp->errorMessage());
		}
		if (!CheckNumber($this->req_material_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->req_material_qty->errorMessage());
		}
		if (!CheckInteger($this->issue_material_grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->issue_material_grp->errorMessage());
		}
		if (!CheckInteger($this->issue_material_rid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->issue_material_rid->errorMessage());
		}
		if (!CheckNumber($this->issue_material_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->issue_material_qty->errorMessage());
		}
		if (!CheckNumber($this->material_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->material_qty->errorMessage());
		}
		if (!CheckDate($this->despatch_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->despatch_date->errorMessage());
		}
		if (!CheckInteger($this->pp_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pp_id->errorMessage());
		}
		if (!CheckInteger($this->level->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->level->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->poid->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->week->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->product_id->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->Size_wl->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->req_material_grp->AdvancedSearch->load();
		$this->req_material_sgrp->AdvancedSearch->load();
		$this->req_material_product->AdvancedSearch->load();
		$this->req_material_rid->AdvancedSearch->load();
		$this->req_material_qty->AdvancedSearch->load();
		$this->req_material_packing->AdvancedSearch->load();
		$this->issue_material_grp->AdvancedSearch->load();
		$this->issue_material_sgrp->AdvancedSearch->load();
		$this->issue_material_product->AdvancedSearch->load();
		$this->issue_material_rid->AdvancedSearch->load();
		$this->issue_material_packing->AdvancedSearch->load();
		$this->issue_material_qty->AdvancedSearch->load();
		$this->unit->AdvancedSearch->load();
		$this->material_qty->AdvancedSearch->load();
		$this->method->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->material_out->AdvancedSearch->load();
		$this->issue_to->AdvancedSearch->load();
		$this->pp_id->AdvancedSearch->load();
		$this->level->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("material_required_livelist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_material_sgrp":
					$lookupFilter = function() {
						return "`grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_material_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_unit":
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to":
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_weaving_works":
							break;
						case "x_week":
							break;
						case "x_buyer_id":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_product_id":
							break;
						case "x_batch_no":
							break;
						case "x_req_material_sgrp":
							break;
						case "x_req_material_product":
							break;
						case "x_req_material_rid":
							break;
						case "x_req_material_packing":
							break;
						case "x_issue_material_sgrp":
							break;
						case "x_issue_material_product":
							break;
						case "x_issue_material_packing":
							break;
						case "x_unit":
							break;
						case "x_material_qty":
							break;
						case "x_method":
							break;
						case "x_despatch_week":
							break;
						case "x_operator":
							break;
						case "x_issue_to":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>