<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for material_required_monthly_cross_company
 */
class material_required_monthly_cross_company extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $month;
	public $buyer;
	public $processed_by;
	public $design_id;
	public $size_cm;
	public $sqm;
	public $req_material_rid;
	public $req_material_packing;
	public $req_material_qty;
	public $_barcode;
	public $no;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'material_required_monthly_cross_company';
		$this->TableName = 'material_required_monthly_cross_company';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`material_required_monthly_cross_company`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// month
		$this->month = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_month', 'month', '`month`', '`month`', 200, -1, FALSE, '`month`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->month->Sortable = TRUE; // Allow sort
		$this->month->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->month->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->month->Lookup = new Lookup('month', 'not_month', FALSE, 'id', ["month_year","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->fields['month'] = &$this->month;

		// buyer
		$this->buyer = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_buyer', 'buyer', '`buyer`', '`buyer`', 19, -1, FALSE, '`buyer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer->Sortable = TRUE; // Allow sort
		$this->buyer->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer->Lookup = new Lookup('buyer', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->buyer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer'] = &$this->buyer;

		// processed_by
		$this->processed_by = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_processed_by', 'processed_by', '`processed_by`', '`processed_by`', 19, -1, FALSE, '`processed_by`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->processed_by->Sortable = TRUE; // Allow sort
		$this->processed_by->Lookup = new Lookup('processed_by', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->processed_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['processed_by'] = &$this->processed_by;

		// design_id
		$this->design_id = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 200, -1, FALSE, '`design_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->design_id->Sortable = TRUE; // Allow sort
		$this->design_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->design_id->Lookup = new Lookup('design_id', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->fields['design_id'] = &$this->design_id;

		// size_cm
		$this->size_cm = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_size_cm', 'size_cm', '`size_cm`', '`size_cm`', 200, -1, FALSE, '`size_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_cm->Nullable = FALSE; // NOT NULL field
		$this->size_cm->Required = TRUE; // Required field
		$this->size_cm->Sortable = TRUE; // Allow sort
		$this->fields['size_cm'] = &$this->size_cm;

		// sqm
		$this->sqm = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// req_material_rid
		$this->req_material_rid = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_req_material_rid', 'req_material_rid', '`req_material_rid`', '`req_material_rid`', 18, -1, FALSE, '`EV__req_material_rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'RADIO');
		$this->req_material_rid->Sortable = TRUE; // Allow sort
		$this->req_material_rid->Lookup = new Lookup('req_material_rid', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_rid'] = &$this->req_material_rid;

		// req_material_packing
		$this->req_material_packing = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_req_material_packing', 'req_material_packing', '`req_material_packing`', '`req_material_packing`', 2, -1, FALSE, '`req_material_packing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_packing->Sortable = TRUE; // Allow sort
		$this->req_material_packing->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_packing->Lookup = new Lookup('req_material_packing', 'packing_type', FALSE, 'id', ["packing","","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_packing'] = &$this->req_material_packing;

		// req_material_qty
		$this->req_material_qty = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_req_material_qty', 'req_material_qty', '`req_material_qty`', '`req_material_qty`', 5, -1, FALSE, '`req_material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_qty->Sortable = TRUE; // Allow sort
		$this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['req_material_qty'] = &$this->req_material_qty;

		// barcode
		$this->_barcode = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 201, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->fields['barcode'] = &$this->_barcode;

		// no
		$this->no = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_no', 'no', '`no`', '`no`', 201, -1, FALSE, '`no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->no->Sortable = TRUE; // Allow sort
		$this->no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['no'] = &$this->no;

		// datetime
		$this->datetime = new DbField('material_required_monthly_cross_company', 'material_required_monthly_cross_company', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`material_required_monthly_cross_company`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_required_monthly_cross_company`.`req_material_rid` LIMIT 1) AS `EV__req_material_rid` FROM `material_required_monthly_cross_company`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->req_material_rid->AdvancedSearch->SearchValue <> "" ||
			$this->req_material_rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->req_material_rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->req_material_rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->month->DbValue = $row['month'];
		$this->buyer->DbValue = $row['buyer'];
		$this->processed_by->DbValue = $row['processed_by'];
		$this->design_id->DbValue = $row['design_id'];
		$this->size_cm->DbValue = $row['size_cm'];
		$this->sqm->DbValue = $row['sqm'];
		$this->req_material_rid->DbValue = $row['req_material_rid'];
		$this->req_material_packing->DbValue = $row['req_material_packing'];
		$this->req_material_qty->DbValue = $row['req_material_qty'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->no->DbValue = $row['no'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "material_required_monthly_cross_companylist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "material_required_monthly_cross_companyview.php")
			return $Language->phrase("View");
		elseif ($pageName == "material_required_monthly_cross_companyedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "material_required_monthly_cross_companyadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "material_required_monthly_cross_companylist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("material_required_monthly_cross_companyview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("material_required_monthly_cross_companyview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "material_required_monthly_cross_companyadd.php?" . $this->getUrlParm($parm);
		else
			$url = "material_required_monthly_cross_companyadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("material_required_monthly_cross_companyedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("material_required_monthly_cross_companyadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("material_required_monthly_cross_companydelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->month->setDbValue($rs->fields('month'));
		$this->buyer->setDbValue($rs->fields('buyer'));
		$this->processed_by->setDbValue($rs->fields('processed_by'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->size_cm->setDbValue($rs->fields('size_cm'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->req_material_rid->setDbValue($rs->fields('req_material_rid'));
		$this->req_material_packing->setDbValue($rs->fields('req_material_packing'));
		$this->req_material_qty->setDbValue($rs->fields('req_material_qty'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->no->setDbValue($rs->fields('no'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// month
		// buyer
		// processed_by
		// design_id
		// size_cm
		// sqm
		// req_material_rid
		// req_material_packing
		// req_material_qty
		// barcode
		// no
		// datetime
		// month

		$curVal = strval($this->month->CurrentValue);
		if ($curVal <> "") {
			$this->month->ViewValue = $this->month->lookupCacheOption($curVal);
			if ($this->month->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->month->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->month->ViewValue = $this->month->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->month->ViewValue = $this->month->CurrentValue;
				}
			}
		} else {
			$this->month->ViewValue = NULL;
		}
		$this->month->ViewCustomAttributes = "";

		// buyer
		$curVal = strval($this->buyer->CurrentValue);
		if ($curVal <> "") {
			$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
			if ($this->buyer->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer->ViewValue = $this->buyer->CurrentValue;
				}
			}
		} else {
			$this->buyer->ViewValue = NULL;
		}
		$this->buyer->ViewCustomAttributes = "";

		// processed_by
		$this->processed_by->ViewValue = $this->processed_by->CurrentValue;
		$curVal = strval($this->processed_by->CurrentValue);
		if ($curVal <> "") {
			$this->processed_by->ViewValue = $this->processed_by->lookupCacheOption($curVal);
			if ($this->processed_by->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`partner_type` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->processed_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->processed_by->ViewValue = $this->processed_by->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->processed_by->ViewValue = $this->processed_by->CurrentValue;
				}
			}
		} else {
			$this->processed_by->ViewValue = NULL;
		}
		$this->processed_by->ViewCustomAttributes = "";

		// design_id
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "status = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->ViewValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->ViewValue = NULL;
		}
		$this->design_id->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewCustomAttributes = "";

		// req_material_rid
		if ($this->req_material_rid->VirtualValue <> "") {
			$this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
		} else {
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->ViewValue = NULL;
		}
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// req_material_packing
		$curVal = strval($this->req_material_packing->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
				}
			}
		} else {
			$this->req_material_packing->ViewValue = NULL;
		}
		$this->req_material_packing->ViewCustomAttributes = "";

		// req_material_qty
		$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, 0, 0);
		$this->req_material_qty->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// no
		$this->no->ViewValue = $this->no->CurrentValue;
		$this->no->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// month
		$this->month->LinkCustomAttributes = "";
		$this->month->HrefValue = "";
		$this->month->TooltipValue = "";

		// buyer
		$this->buyer->LinkCustomAttributes = "";
		$this->buyer->HrefValue = "";
		$this->buyer->TooltipValue = "";

		// processed_by
		$this->processed_by->LinkCustomAttributes = "";
		$this->processed_by->HrefValue = "";
		$this->processed_by->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		$this->design_id->HrefValue = "";
		$this->design_id->TooltipValue = "";

		// size_cm
		$this->size_cm->LinkCustomAttributes = "";
		$this->size_cm->HrefValue = "";
		$this->size_cm->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// req_material_rid
		$this->req_material_rid->LinkCustomAttributes = "";
		$this->req_material_rid->HrefValue = "";
		$this->req_material_rid->TooltipValue = "";

		// req_material_packing
		$this->req_material_packing->LinkCustomAttributes = "";
		$this->req_material_packing->HrefValue = "";
		$this->req_material_packing->TooltipValue = "";

		// req_material_qty
		$this->req_material_qty->LinkCustomAttributes = "";
		$this->req_material_qty->HrefValue = "";
		$this->req_material_qty->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// no
		$this->no->LinkCustomAttributes = "";
		$this->no->HrefValue = "";
		$this->no->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// month
		$this->month->EditAttrs["class"] = "form-control";
		$this->month->EditCustomAttributes = "";

		// buyer
		$this->buyer->EditAttrs["class"] = "form-control";
		$this->buyer->EditCustomAttributes = "";

		// processed_by
		$this->processed_by->EditAttrs["class"] = "form-control";
		$this->processed_by->EditCustomAttributes = "";
		$this->processed_by->EditValue = $this->processed_by->CurrentValue;
		$this->processed_by->PlaceHolder = RemoveHtml($this->processed_by->caption());

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";

		// size_cm
		$this->size_cm->EditAttrs["class"] = "form-control";
		$this->size_cm->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
		$this->size_cm->EditValue = $this->size_cm->CurrentValue;
		$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->ViewCustomAttributes = "";

		// req_material_rid
		$this->req_material_rid->EditAttrs["class"] = "form-control";
		$this->req_material_rid->EditCustomAttributes = "";
		if ($this->req_material_rid->VirtualValue <> "") {
			$this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
		} else {
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->EditValue = NULL;
		}
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// req_material_packing
		$this->req_material_packing->EditAttrs["class"] = "form-control";
		$this->req_material_packing->EditCustomAttributes = "";

		// req_material_qty
		$this->req_material_qty->EditAttrs["class"] = "form-control";
		$this->req_material_qty->EditCustomAttributes = "";
		$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, 2, -2, 0, 0);
		$this->req_material_qty->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

		// no
		$this->no->EditAttrs["class"] = "form-control";
		$this->no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->no->CurrentValue = HtmlDecode($this->no->CurrentValue);
		$this->no->EditValue = $this->no->CurrentValue;
		$this->no->PlaceHolder = RemoveHtml($this->no->caption());

		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->req_material_qty->CurrentValue))
				$this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, 0, 0);
			$this->req_material_qty->ViewCustomAttributes = "";
			$this->req_material_qty->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->month);
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->processed_by);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->no);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->month);
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->processed_by);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->no);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->month);
						$doc->exportField($this->buyer);
						$doc->exportField($this->processed_by);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->sqm);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->no);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->month);
						$doc->exportField($this->buyer);
						$doc->exportField($this->processed_by);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->sqm);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->no);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->month, '');
				$doc->exportAggregate($this->buyer, '');
				$doc->exportAggregate($this->processed_by, '');
				$doc->exportAggregate($this->design_id, '');
				$doc->exportAggregate($this->size_cm, '');
				$doc->exportAggregate($this->sqm, '');
				$doc->exportAggregate($this->req_material_rid, '');
				$doc->exportAggregate($this->req_material_packing, '');
				$doc->exportAggregate($this->req_material_qty, 'TOTAL');
				$doc->exportAggregate($this->_barcode, '');
				$doc->exportAggregate($this->no, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>