<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for material_required_weekly_loomplan
 */
class material_required_weekly_loomplan extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $poid;
	public $weaving_works;
	public $week;
	public $po;
	public $buyer_id;
	public $product_id;
	public $batch_no;
	public $quantity;
	public $Size_wl;
	public $sqm;
	public $req_material_rid;
	public $req_material_packing;
	public $req_material_qty;
	public $unit;
	public $material_qty;
	public $method;
	public $despatch_week;
	public $production_plan;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'material_required_weekly_loomplan';
		$this->TableName = 'material_required_weekly_loomplan';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`material_required_weekly_loomplan`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// poid
		$this->poid = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_poid', 'poid', '`poid`', '`poid`', 131, -1, FALSE, '`poid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->poid->Required = TRUE; // Required field
		$this->poid->Sortable = TRUE; // Allow sort
		$this->poid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['poid'] = &$this->poid;

		// weaving_works
		$this->weaving_works = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_weaving_works', 'weaving_works', '`weaving_works`', '`weaving_works`', 18, -1, FALSE, '`weaving_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->weaving_works->IsForeignKey = TRUE; // Foreign key field
		$this->weaving_works->Nullable = FALSE; // NOT NULL field
		$this->weaving_works->Sortable = TRUE; // Allow sort
		$this->weaving_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->weaving_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->weaving_works->Lookup = new Lookup('weaving_works', 'godown_table', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['weaving_works'] = &$this->weaving_works;

		// week
		$this->week = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_week', 'week', '`week`', '`week`', 200, -1, FALSE, '`week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->week->IsForeignKey = TRUE; // Foreign key field
		$this->week->Nullable = FALSE; // NOT NULL field
		$this->week->Required = TRUE; // Required field
		$this->week->Sortable = TRUE; // Allow sort
		$this->week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->week->Lookup = new Lookup('week', 'not_week', FALSE, 'id', ["week","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['week'] = &$this->week;

		// po
		$this->po = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// buyer_id
		$this->buyer_id = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 19, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_id->Required = TRUE; // Required field
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_id->Lookup = new Lookup('buyer_id', 'buyer', FALSE, 'id', ["code","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// product_id
		$this->product_id = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_product_id', 'product_id', '`product_id`', '`product_id`', 200, -1, FALSE, '`product_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_id->Required = TRUE; // Required field
		$this->product_id->Sortable = TRUE; // Allow sort
		$this->product_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_id->Lookup = new Lookup('product_id', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->product_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_id'] = &$this->product_id;

		// batch_no
		$this->batch_no = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', FALSE, 'id', ["batch_no","","",""], [], [], [], [], [], [], '`batch_no` ASC', '');
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// quantity
		$this->quantity = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 20, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->fields['quantity'] = &$this->quantity;

		// Size_wl
		$this->Size_wl = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_Size_wl', 'Size_wl', '`Size_wl`', '`Size_wl`', 200, -1, FALSE, '`Size_wl`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Size_wl->Nullable = FALSE; // NOT NULL field
		$this->Size_wl->Required = TRUE; // Required field
		$this->Size_wl->Sortable = TRUE; // Allow sort
		$this->fields['Size_wl'] = &$this->Size_wl;

		// sqm
		$this->sqm = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// req_material_rid
		$this->req_material_rid = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_req_material_rid', 'req_material_rid', '`req_material_rid`', '`req_material_rid`', 18, -1, FALSE, '`EV__req_material_rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'RADIO');
		$this->req_material_rid->IsForeignKey = TRUE; // Foreign key field
		$this->req_material_rid->Sortable = TRUE; // Allow sort
		$this->req_material_rid->Lookup = new Lookup('req_material_rid', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_rid'] = &$this->req_material_rid;

		// req_material_packing
		$this->req_material_packing = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_req_material_packing', 'req_material_packing', '`req_material_packing`', '`req_material_packing`', 2, -1, FALSE, '`req_material_packing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_packing->IsForeignKey = TRUE; // Foreign key field
		$this->req_material_packing->Sortable = TRUE; // Allow sort
		$this->req_material_packing->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_packing->Lookup = new Lookup('req_material_packing', 'packing_type', FALSE, 'id', ["packing","","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_packing'] = &$this->req_material_packing;

		// req_material_qty
		$this->req_material_qty = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_req_material_qty', 'req_material_qty', '`req_material_qty`', '`req_material_qty`', 5, -1, FALSE, '`req_material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_qty->Sortable = TRUE; // Allow sort
		$this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['req_material_qty'] = &$this->req_material_qty;

		// unit
		$this->unit = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_unit', 'unit', '`unit`', '`unit`', 18, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Required = TRUE; // Required field
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->unit->Lookup = new Lookup('unit', 'unit', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unit'] = &$this->unit;

		// material_qty
		$this->material_qty = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_material_qty', 'material_qty', '`material_qty`', '`material_qty`', 131, -1, FALSE, '`material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->material_qty->Sortable = TRUE; // Allow sort
		$this->material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['material_qty'] = &$this->material_qty;

		// method
		$this->method = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_method', 'method', '`method`', '`method`', 18, -1, FALSE, '`method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->method->Required = TRUE; // Required field
		$this->method->Sortable = TRUE; // Allow sort
		$this->method->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->method->Lookup = new Lookup('method', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['method'] = &$this->method;

		// despatch_week
		$this->despatch_week = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, 7, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Required = TRUE; // Required field
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', FALSE, 'id', ["nweek","","",""], [], [], [], [], [], [], '`nweek` ASC', '');
		$this->despatch_week->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['despatch_week'] = &$this->despatch_week;

		// production_plan
		$this->production_plan = new DbField('material_required_weekly_loomplan', 'material_required_weekly_loomplan', 'x_production_plan', 'production_plan', '`production_plan`', '`production_plan`', 17, -1, FALSE, '`production_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->production_plan->Required = TRUE; // Required field
		$this->production_plan->Sortable = TRUE; // Allow sort
		$this->production_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->production_plan->Lookup = new Lookup('production_plan', 'material_required_weekly_loomplan', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->production_plan->OptionCount = 6;
		$this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_plan'] = &$this->production_plan;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "material_required_weekly_loomplan_short") {
			if ($this->weaving_works->getSessionValue() <> "")
				$masterFilter .= "`godown`=" . QuotedValue($this->weaving_works->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
			if ($this->week->getSessionValue() <> "")
				$masterFilter .= " AND `week`=" . QuotedValue($this->week->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->req_material_rid->getSessionValue() <> "")
				$masterFilter .= " AND `rid`=" . QuotedValue($this->req_material_rid->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
			if ($this->req_material_packing->getSessionValue() <> "")
				$masterFilter .= " AND `packing_type`=" . QuotedValue($this->req_material_packing->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "material_required_weekly_loomplan_short") {
			if ($this->weaving_works->getSessionValue() <> "")
				$detailFilter .= "`weaving_works`=" . QuotedValue($this->weaving_works->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
			if ($this->week->getSessionValue() <> "")
				$detailFilter .= " AND `week`=" . QuotedValue($this->week->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->req_material_rid->getSessionValue() <> "")
				$detailFilter .= " AND `req_material_rid`=" . QuotedValue($this->req_material_rid->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
			if ($this->req_material_packing->getSessionValue() <> "")
				$detailFilter .= " AND `req_material_packing`=" . QuotedValue($this->req_material_packing->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_material_required_weekly_loomplan_short()
	{
		return "`godown`=@godown@ AND `week`='@week@' AND `rid`=@rid@ AND `packing_type`=@packing_type@";
	}

	// Detail filter
	public function sqlDetailFilter_material_required_weekly_loomplan_short()
	{
		return "`weaving_works`=@weaving_works@ AND `week`='@week@' AND `req_material_rid`=@req_material_rid@ AND `req_material_packing`=@req_material_packing@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`material_required_weekly_loomplan`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `material_required_weekly_loomplan`.`req_material_rid` LIMIT 1) AS `EV__req_material_rid` FROM `material_required_weekly_loomplan`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->req_material_rid->AdvancedSearch->SearchValue <> "" ||
			$this->req_material_rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->req_material_rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->req_material_rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->poid->DbValue = $row['poid'];
		$this->weaving_works->DbValue = $row['weaving_works'];
		$this->week->DbValue = $row['week'];
		$this->po->DbValue = $row['po'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->product_id->DbValue = $row['product_id'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->quantity->DbValue = $row['quantity'];
		$this->Size_wl->DbValue = $row['Size_wl'];
		$this->sqm->DbValue = $row['sqm'];
		$this->req_material_rid->DbValue = $row['req_material_rid'];
		$this->req_material_packing->DbValue = $row['req_material_packing'];
		$this->req_material_qty->DbValue = $row['req_material_qty'];
		$this->unit->DbValue = $row['unit'];
		$this->material_qty->DbValue = $row['material_qty'];
		$this->method->DbValue = $row['method'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->production_plan->DbValue = $row['production_plan'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "material_required_weekly_loomplanlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "material_required_weekly_loomplanview.php")
			return $Language->phrase("View");
		elseif ($pageName == "material_required_weekly_loomplanedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "material_required_weekly_loomplanadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "material_required_weekly_loomplanlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("material_required_weekly_loomplanview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("material_required_weekly_loomplanview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "material_required_weekly_loomplanadd.php?" . $this->getUrlParm($parm);
		else
			$url = "material_required_weekly_loomplanadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("material_required_weekly_loomplanedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("material_required_weekly_loomplanadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("material_required_weekly_loomplandelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "material_required_weekly_loomplan_short" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_godown=" . urlencode($this->weaving_works->CurrentValue);
			$url .= "&fk_week=" . urlencode($this->week->CurrentValue);
			$url .= "&fk_rid=" . urlencode($this->req_material_rid->CurrentValue);
			$url .= "&fk_packing_type=" . urlencode($this->req_material_packing->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->poid->setDbValue($rs->fields('poid'));
		$this->weaving_works->setDbValue($rs->fields('weaving_works'));
		$this->week->setDbValue($rs->fields('week'));
		$this->po->setDbValue($rs->fields('po'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->product_id->setDbValue($rs->fields('product_id'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->Size_wl->setDbValue($rs->fields('Size_wl'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->req_material_rid->setDbValue($rs->fields('req_material_rid'));
		$this->req_material_packing->setDbValue($rs->fields('req_material_packing'));
		$this->req_material_qty->setDbValue($rs->fields('req_material_qty'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->material_qty->setDbValue($rs->fields('material_qty'));
		$this->method->setDbValue($rs->fields('method'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->production_plan->setDbValue($rs->fields('production_plan'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// poid
		// weaving_works
		// week
		// po
		// buyer_id
		// product_id
		// batch_no

		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// quantity
		// Size_wl
		// sqm
		// req_material_rid
		// req_material_packing
		// req_material_qty
		// unit
		// material_qty
		// method
		// despatch_week
		// production_plan
		// poid

		$this->poid->ViewValue = $this->poid->CurrentValue;
		$this->poid->ViewCustomAttributes = "";

		// weaving_works
		$curVal = strval($this->weaving_works->CurrentValue);
		if ($curVal <> "") {
			$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
				}
			}
		} else {
			$this->weaving_works->ViewValue = NULL;
		}
		$this->weaving_works->ViewCustomAttributes = "";

		// week
		$curVal = strval($this->week->CurrentValue);
		if ($curVal <> "") {
			$this->week->ViewValue = $this->week->lookupCacheOption($curVal);
			if ($this->week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` >= DATE_FORMAT(NOW(), '%y%u')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->week->ViewValue = $this->week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->week->ViewValue = $this->week->CurrentValue;
				}
			}
		} else {
			$this->week->ViewValue = NULL;
		}
		$this->week->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// buyer_id
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->ViewValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// product_id
		$curVal = strval($this->product_id->CurrentValue);
		if ($curVal <> "") {
			$this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
			if ($this->product_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_id->ViewValue = $this->product_id->CurrentValue;
				}
			}
		} else {
			$this->product_id->ViewValue = NULL;
		}
		$this->product_id->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// Size_wl
		$this->Size_wl->ViewValue = $this->Size_wl->CurrentValue;
		$this->Size_wl->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewCustomAttributes = "";

		// req_material_rid
		if ($this->req_material_rid->VirtualValue <> "") {
			$this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
		} else {
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->ViewValue = NULL;
		}
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// req_material_packing
		$curVal = strval($this->req_material_packing->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
				}
			}
		} else {
			$this->req_material_packing->ViewValue = NULL;
		}
		$this->req_material_packing->ViewCustomAttributes = "";

		// req_material_qty
		$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, 0, 0, 0);
		$this->req_material_qty->ViewCustomAttributes = "";

		// unit
		$curVal = strval($this->unit->CurrentValue);
		if ($curVal <> "") {
			$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
			if ($this->unit->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->unit->ViewValue = $this->unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->unit->ViewValue = $this->unit->CurrentValue;
				}
			}
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// material_qty
		$this->material_qty->ViewValue = $this->material_qty->CurrentValue;
		$this->material_qty->ViewCustomAttributes = "";

		// method
		$curVal = strval($this->method->CurrentValue);
		if ($curVal <> "") {
			$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
			if ($this->method->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=21";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->method->ViewValue = $this->method->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->method->ViewValue = $this->method->CurrentValue;
				}
			}
		} else {
			$this->method->ViewValue = NULL;
		}
		$this->method->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// production_plan
		if (strval($this->production_plan->CurrentValue) <> "") {
			$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
		} else {
			$this->production_plan->ViewValue = NULL;
		}
		$this->production_plan->ViewCustomAttributes = "";

		// poid
		$this->poid->LinkCustomAttributes = "";
		$this->poid->HrefValue = "";
		$this->poid->TooltipValue = "";

		// weaving_works
		$this->weaving_works->LinkCustomAttributes = "";
		$this->weaving_works->HrefValue = "";
		$this->weaving_works->TooltipValue = "";

		// week
		$this->week->LinkCustomAttributes = "";
		$this->week->HrefValue = "";
		$this->week->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyer_id->CurrentValue)) {
			$this->buyer_id->HrefValue = "material_requiredlist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
			$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
		} else {
			$this->buyer_id->HrefValue = "";
		}
		$this->buyer_id->TooltipValue = "";

		// product_id
		$this->product_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->product_id->CurrentValue)) {
			$this->product_id->HrefValue = "material_requiredlist.php?x_product_item=" . $this->product_id->CurrentValue; // Add prefix/suffix
			$this->product_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
		} else {
			$this->product_id->HrefValue = "";
		}
		$this->product_id->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->batch_no->CurrentValue)) {
			$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
			$this->batch_no->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
		} else {
			$this->batch_no->HrefValue = "";
		}
		$this->batch_no->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// Size_wl
		$this->Size_wl->LinkCustomAttributes = "";
		$this->Size_wl->HrefValue = "";
		$this->Size_wl->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// req_material_rid
		$this->req_material_rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->req_material_rid->CurrentValue)) {
			$this->req_material_rid->HrefValue = "material_requiredlist.php?x_req_material_rid=" . $this->req_material_rid->CurrentValue; // Add prefix/suffix
			$this->req_material_rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
		} else {
			$this->req_material_rid->HrefValue = "";
		}
		$this->req_material_rid->TooltipValue = "";

		// req_material_packing
		$this->req_material_packing->LinkCustomAttributes = "";
		$this->req_material_packing->HrefValue = "";
		$this->req_material_packing->TooltipValue = "";

		// req_material_qty
		$this->req_material_qty->LinkCustomAttributes = "";
		$this->req_material_qty->HrefValue = "";
		$this->req_material_qty->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		$this->unit->HrefValue = "";
		$this->unit->TooltipValue = "";

		// material_qty
		$this->material_qty->LinkCustomAttributes = "";
		$this->material_qty->HrefValue = "";
		$this->material_qty->TooltipValue = "";

		// method
		$this->method->LinkCustomAttributes = "";
		$this->method->HrefValue = "";
		$this->method->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// production_plan
		$this->production_plan->LinkCustomAttributes = "";
		$this->production_plan->HrefValue = "";
		$this->production_plan->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// poid
		$this->poid->EditAttrs["class"] = "form-control";
		$this->poid->EditCustomAttributes = "";
		$this->poid->EditValue = $this->poid->CurrentValue;
		$this->poid->ViewCustomAttributes = "";

		// weaving_works
		$this->weaving_works->EditAttrs["class"] = "form-control";
		$this->weaving_works->EditCustomAttributes = "";
		if ($this->weaving_works->getSessionValue() <> "") {
			$this->weaving_works->CurrentValue = $this->weaving_works->getSessionValue();
		$curVal = strval($this->weaving_works->CurrentValue);
		if ($curVal <> "") {
			$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
				}
			}
		} else {
			$this->weaving_works->ViewValue = NULL;
		}
		$this->weaving_works->ViewCustomAttributes = "";
		} else {
		}

		// week
		$this->week->EditAttrs["class"] = "form-control";
		$this->week->EditCustomAttributes = "";
		if ($this->week->getSessionValue() <> "") {
			$this->week->CurrentValue = $this->week->getSessionValue();
		$curVal = strval($this->week->CurrentValue);
		if ($curVal <> "") {
			$this->week->ViewValue = $this->week->lookupCacheOption($curVal);
			if ($this->week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` >= DATE_FORMAT(NOW(), '%y%u')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->week->ViewValue = $this->week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->week->ViewValue = $this->week->CurrentValue;
				}
			}
		} else {
			$this->week->ViewValue = NULL;
		}
		$this->week->ViewCustomAttributes = "";
		} else {
		}

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->EditValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// product_id
		$this->product_id->EditAttrs["class"] = "form-control";
		$this->product_id->EditCustomAttributes = "";
		$curVal = strval($this->product_id->CurrentValue);
		if ($curVal <> "") {
			$this->product_id->EditValue = $this->product_id->lookupCacheOption($curVal);
			if ($this->product_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_id->EditValue = $this->product_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_id->EditValue = $this->product_id->CurrentValue;
				}
			}
		} else {
			$this->product_id->EditValue = NULL;
		}
		$this->product_id->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->EditValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->EditValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 3, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// Size_wl
		$this->Size_wl->EditAttrs["class"] = "form-control";
		$this->Size_wl->EditCustomAttributes = "";
		$this->Size_wl->EditValue = $this->Size_wl->CurrentValue;
		$this->Size_wl->ViewCustomAttributes = "";

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->ViewCustomAttributes = "";

		// req_material_rid
		$this->req_material_rid->EditAttrs["class"] = "form-control";
		$this->req_material_rid->EditCustomAttributes = "";
		if ($this->req_material_rid->VirtualValue <> "") {
			$this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
		} else {
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->EditValue = NULL;
		}
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// req_material_packing
		$this->req_material_packing->EditAttrs["class"] = "form-control";
		$this->req_material_packing->EditCustomAttributes = "";
		if ($this->req_material_packing->getSessionValue() <> "") {
			$this->req_material_packing->CurrentValue = $this->req_material_packing->getSessionValue();
		$curVal = strval($this->req_material_packing->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
				}
			}
		} else {
			$this->req_material_packing->ViewValue = NULL;
		}
		$this->req_material_packing->ViewCustomAttributes = "";
		} else {
		}

		// req_material_qty
		$this->req_material_qty->EditAttrs["class"] = "form-control";
		$this->req_material_qty->EditCustomAttributes = "";
		$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, 2, 0, 0, 0);
		$this->req_material_qty->ViewCustomAttributes = "";

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		$curVal = strval($this->unit->CurrentValue);
		if ($curVal <> "") {
			$this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
			if ($this->unit->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->unit->EditValue = $this->unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->unit->EditValue = $this->unit->CurrentValue;
				}
			}
		} else {
			$this->unit->EditValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// material_qty
		$this->material_qty->EditAttrs["class"] = "form-control";
		$this->material_qty->EditCustomAttributes = "";
		$this->material_qty->EditValue = $this->material_qty->CurrentValue;
		$this->material_qty->ViewCustomAttributes = "";

		// method
		$this->method->EditAttrs["class"] = "form-control";
		$this->method->EditCustomAttributes = "";
		$curVal = strval($this->method->CurrentValue);
		if ($curVal <> "") {
			$this->method->EditValue = $this->method->lookupCacheOption($curVal);
			if ($this->method->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=21";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->method->EditValue = $this->method->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->method->EditValue = $this->method->CurrentValue;
				}
			}
		} else {
			$this->method->EditValue = NULL;
		}
		$this->method->ViewCustomAttributes = "";

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->EditValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// production_plan
		$this->production_plan->EditAttrs["class"] = "form-control";
		$this->production_plan->EditCustomAttributes = "";
		if (strval($this->production_plan->CurrentValue) <> "") {
			$this->production_plan->EditValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
		} else {
			$this->production_plan->EditValue = NULL;
		}
		$this->production_plan->ViewCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->req_material_qty->CurrentValue))
				$this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, 0, 0, 0);
			$this->req_material_qty->ViewCustomAttributes = "";
			$this->req_material_qty->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->poid);
					$doc->exportCaption($this->weaving_works);
					$doc->exportCaption($this->week);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->product_id);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->Size_wl);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->material_qty);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->production_plan);
				} else {
					$doc->exportCaption($this->weaving_works);
					$doc->exportCaption($this->week);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->product_id);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->Size_wl);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->material_qty);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->despatch_week);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->poid);
						$doc->exportField($this->weaving_works);
						$doc->exportField($this->week);
						$doc->exportField($this->po);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->product_id);
						$doc->exportField($this->quantity);
						$doc->exportField($this->Size_wl);
						$doc->exportField($this->sqm);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->unit);
						$doc->exportField($this->material_qty);
						$doc->exportField($this->method);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->production_plan);
					} else {
						$doc->exportField($this->weaving_works);
						$doc->exportField($this->week);
						$doc->exportField($this->po);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->product_id);
						$doc->exportField($this->quantity);
						$doc->exportField($this->Size_wl);
						$doc->exportField($this->sqm);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->unit);
						$doc->exportField($this->material_qty);
						$doc->exportField($this->method);
						$doc->exportField($this->despatch_week);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->weaving_works, '');
				$doc->exportAggregate($this->week, '');
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->buyer_id, '');
				$doc->exportAggregate($this->product_id, '');
				$doc->exportAggregate($this->quantity, '');
				$doc->exportAggregate($this->Size_wl, '');
				$doc->exportAggregate($this->sqm, '');
				$doc->exportAggregate($this->req_material_rid, '');
				$doc->exportAggregate($this->req_material_packing, '');
				$doc->exportAggregate($this->req_material_qty, 'TOTAL');
				$doc->exportAggregate($this->unit, '');
				$doc->exportAggregate($this->material_qty, '');
				$doc->exportAggregate($this->method, '');
				$doc->exportAggregate($this->despatch_week, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>