<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class menus_edit extends menus
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'menus';

	// Page object name
	public $PageObjName = "menus_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (menus)
		if (!isset($GLOBALS["menus"]) || get_class($GLOBALS["menus"]) == PROJECT_NAMESPACE . "menus") {
			$GLOBALS["menus"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["menus"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'menus');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $menus;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($menus);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "menusview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("menuslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->image->setVisibility();
		$this->show_title->setVisibility();
		$this->page_title->setVisibility();
		$this->page_url->setVisibility();
		$this->target->setVisibility();
		$this->parent_id->setVisibility();
		$this->show_in_main_menu->setVisibility();
		$this->status->setVisibility();
		$this->order_by->setVisibility();
		$this->mega_menu->setVisibility();
		$this->bgcolor->setVisibility();
		$this->submenu->setVisibility();
		$this->submenu_code->setVisibility();
		$this->footer_group->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->parent_id);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("menuslist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "menuslist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'image' first before field var 'x_image'
		$val = $CurrentForm->hasValue("image") ? $CurrentForm->getValue("image") : $CurrentForm->getValue("x_image");
		if (!$this->image->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->image->Visible = FALSE; // Disable update for API request
			else
				$this->image->setFormValue($val);
		}

		// Check field name 'show_title' first before field var 'x_show_title'
		$val = $CurrentForm->hasValue("show_title") ? $CurrentForm->getValue("show_title") : $CurrentForm->getValue("x_show_title");
		if (!$this->show_title->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->show_title->Visible = FALSE; // Disable update for API request
			else
				$this->show_title->setFormValue($val);
		}

		// Check field name 'page_title' first before field var 'x_page_title'
		$val = $CurrentForm->hasValue("page_title") ? $CurrentForm->getValue("page_title") : $CurrentForm->getValue("x_page_title");
		if (!$this->page_title->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->page_title->Visible = FALSE; // Disable update for API request
			else
				$this->page_title->setFormValue($val);
		}

		// Check field name 'page_url' first before field var 'x_page_url'
		$val = $CurrentForm->hasValue("page_url") ? $CurrentForm->getValue("page_url") : $CurrentForm->getValue("x_page_url");
		if (!$this->page_url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->page_url->Visible = FALSE; // Disable update for API request
			else
				$this->page_url->setFormValue($val);
		}

		// Check field name 'target' first before field var 'x_target'
		$val = $CurrentForm->hasValue("target") ? $CurrentForm->getValue("target") : $CurrentForm->getValue("x_target");
		if (!$this->target->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->target->Visible = FALSE; // Disable update for API request
			else
				$this->target->setFormValue($val);
		}

		// Check field name 'parent_id' first before field var 'x_parent_id'
		$val = $CurrentForm->hasValue("parent_id") ? $CurrentForm->getValue("parent_id") : $CurrentForm->getValue("x_parent_id");
		if (!$this->parent_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->parent_id->Visible = FALSE; // Disable update for API request
			else
				$this->parent_id->setFormValue($val);
		}

		// Check field name 'show_in_main_menu' first before field var 'x_show_in_main_menu'
		$val = $CurrentForm->hasValue("show_in_main_menu") ? $CurrentForm->getValue("show_in_main_menu") : $CurrentForm->getValue("x_show_in_main_menu");
		if (!$this->show_in_main_menu->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->show_in_main_menu->Visible = FALSE; // Disable update for API request
			else
				$this->show_in_main_menu->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'order_by' first before field var 'x_order_by'
		$val = $CurrentForm->hasValue("order_by") ? $CurrentForm->getValue("order_by") : $CurrentForm->getValue("x_order_by");
		if (!$this->order_by->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_by->Visible = FALSE; // Disable update for API request
			else
				$this->order_by->setFormValue($val);
		}

		// Check field name 'mega_menu' first before field var 'x_mega_menu'
		$val = $CurrentForm->hasValue("mega_menu") ? $CurrentForm->getValue("mega_menu") : $CurrentForm->getValue("x_mega_menu");
		if (!$this->mega_menu->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mega_menu->Visible = FALSE; // Disable update for API request
			else
				$this->mega_menu->setFormValue($val);
		}

		// Check field name 'bgcolor' first before field var 'x_bgcolor'
		$val = $CurrentForm->hasValue("bgcolor") ? $CurrentForm->getValue("bgcolor") : $CurrentForm->getValue("x_bgcolor");
		if (!$this->bgcolor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bgcolor->Visible = FALSE; // Disable update for API request
			else
				$this->bgcolor->setFormValue($val);
		}

		// Check field name 'submenu' first before field var 'x_submenu'
		$val = $CurrentForm->hasValue("submenu") ? $CurrentForm->getValue("submenu") : $CurrentForm->getValue("x_submenu");
		if (!$this->submenu->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->submenu->Visible = FALSE; // Disable update for API request
			else
				$this->submenu->setFormValue($val);
		}

		// Check field name 'submenu_code' first before field var 'x_submenu_code'
		$val = $CurrentForm->hasValue("submenu_code") ? $CurrentForm->getValue("submenu_code") : $CurrentForm->getValue("x_submenu_code");
		if (!$this->submenu_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->submenu_code->Visible = FALSE; // Disable update for API request
			else
				$this->submenu_code->setFormValue($val);
		}

		// Check field name 'footer_group' first before field var 'x_footer_group'
		$val = $CurrentForm->hasValue("footer_group") ? $CurrentForm->getValue("footer_group") : $CurrentForm->getValue("x_footer_group");
		if (!$this->footer_group->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->footer_group->Visible = FALSE; // Disable update for API request
			else
				$this->footer_group->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->image->CurrentValue = $this->image->FormValue;
		$this->show_title->CurrentValue = $this->show_title->FormValue;
		$this->page_title->CurrentValue = $this->page_title->FormValue;
		$this->page_url->CurrentValue = $this->page_url->FormValue;
		$this->target->CurrentValue = $this->target->FormValue;
		$this->parent_id->CurrentValue = $this->parent_id->FormValue;
		$this->show_in_main_menu->CurrentValue = $this->show_in_main_menu->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->order_by->CurrentValue = $this->order_by->FormValue;
		$this->mega_menu->CurrentValue = $this->mega_menu->FormValue;
		$this->bgcolor->CurrentValue = $this->bgcolor->FormValue;
		$this->submenu->CurrentValue = $this->submenu->FormValue;
		$this->submenu_code->CurrentValue = $this->submenu_code->FormValue;
		$this->footer_group->CurrentValue = $this->footer_group->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->image->setDbValue($row['image']);
		$this->show_title->setDbValue($row['show_title']);
		$this->page_title->setDbValue($row['page_title']);
		$this->page_url->setDbValue($row['page_url']);
		$this->target->setDbValue($row['target']);
		$this->parent_id->setDbValue($row['parent_id']);
		$this->show_in_main_menu->setDbValue($row['show_in_main_menu']);
		$this->status->setDbValue($row['status']);
		$this->order_by->setDbValue($row['order_by']);
		$this->mega_menu->setDbValue($row['mega_menu']);
		$this->bgcolor->setDbValue($row['bgcolor']);
		$this->submenu->setDbValue($row['submenu']);
		$this->submenu_code->setDbValue($row['submenu_code']);
		$this->footer_group->setDbValue($row['footer_group']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['image'] = NULL;
		$row['show_title'] = NULL;
		$row['page_title'] = NULL;
		$row['page_url'] = NULL;
		$row['target'] = NULL;
		$row['parent_id'] = NULL;
		$row['show_in_main_menu'] = NULL;
		$row['status'] = NULL;
		$row['order_by'] = NULL;
		$row['mega_menu'] = NULL;
		$row['bgcolor'] = NULL;
		$row['submenu'] = NULL;
		$row['submenu_code'] = NULL;
		$row['footer_group'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// image
		// show_title
		// page_title
		// page_url
		// target
		// parent_id
		// show_in_main_menu
		// status
		// order_by
		// mega_menu
		// bgcolor
		// submenu
		// submenu_code
		// footer_group
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// image
			$this->image->ViewValue = $this->image->CurrentValue;
			$this->image->ViewCustomAttributes = "";

			// show_title
			if (strval($this->show_title->CurrentValue) <> "") {
				$this->show_title->ViewValue = $this->show_title->optionCaption($this->show_title->CurrentValue);
			} else {
				$this->show_title->ViewValue = NULL;
			}
			$this->show_title->ViewCustomAttributes = "";

			// page_title
			$this->page_title->ViewValue = $this->page_title->CurrentValue;
			$this->page_title->ViewCustomAttributes = "";

			// page_url
			$this->page_url->ViewValue = $this->page_url->CurrentValue;
			$this->page_url->ViewCustomAttributes = "";

			// target
			if (strval($this->target->CurrentValue) <> "") {
				$this->target->ViewValue = $this->target->optionCaption($this->target->CurrentValue);
			} else {
				$this->target->ViewValue = NULL;
			}
			$this->target->ViewCustomAttributes = "";

			// parent_id
			$curVal = strval($this->parent_id->CurrentValue);
			if ($curVal <> "") {
				$this->parent_id->ViewValue = $this->parent_id->lookupCacheOption($curVal);
				if ($this->parent_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->parent_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->parent_id->ViewValue = $this->parent_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->parent_id->ViewValue = $this->parent_id->CurrentValue;
					}
				}
			} else {
				$this->parent_id->ViewValue = NULL;
			}
			$this->parent_id->ViewCustomAttributes = "";

			// show_in_main_menu
			if (strval($this->show_in_main_menu->CurrentValue) <> "") {
				$this->show_in_main_menu->ViewValue = $this->show_in_main_menu->optionCaption($this->show_in_main_menu->CurrentValue);
			} else {
				$this->show_in_main_menu->ViewValue = NULL;
			}
			$this->show_in_main_menu->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// order_by
			$this->order_by->ViewValue = $this->order_by->CurrentValue;
			$this->order_by->ViewCustomAttributes = "";

			// mega_menu
			if (strval($this->mega_menu->CurrentValue) <> "") {
				$this->mega_menu->ViewValue = $this->mega_menu->optionCaption($this->mega_menu->CurrentValue);
			} else {
				$this->mega_menu->ViewValue = NULL;
			}
			$this->mega_menu->ViewCustomAttributes = "";

			// bgcolor
			$this->bgcolor->ViewValue = $this->bgcolor->CurrentValue;
			$this->bgcolor->ViewCustomAttributes = "";

			// submenu
			if (strval($this->submenu->CurrentValue) <> "") {
				$this->submenu->ViewValue = $this->submenu->optionCaption($this->submenu->CurrentValue);
			} else {
				$this->submenu->ViewValue = NULL;
			}
			$this->submenu->ViewCustomAttributes = "";

			// submenu_code
			$this->submenu_code->ViewValue = $this->submenu_code->CurrentValue;
			$this->submenu_code->ViewCustomAttributes = "";

			// footer_group
			$this->footer_group->ViewValue = $this->footer_group->CurrentValue;
			$this->footer_group->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->TooltipValue = "";

			// show_title
			$this->show_title->LinkCustomAttributes = "";
			$this->show_title->HrefValue = "";
			$this->show_title->TooltipValue = "";

			// page_title
			$this->page_title->LinkCustomAttributes = "";
			$this->page_title->HrefValue = "";
			$this->page_title->TooltipValue = "";

			// page_url
			$this->page_url->LinkCustomAttributes = "";
			$this->page_url->HrefValue = "";
			$this->page_url->TooltipValue = "";

			// target
			$this->target->LinkCustomAttributes = "";
			$this->target->HrefValue = "";
			$this->target->TooltipValue = "";

			// parent_id
			$this->parent_id->LinkCustomAttributes = "";
			$this->parent_id->HrefValue = "";
			$this->parent_id->TooltipValue = "";

			// show_in_main_menu
			$this->show_in_main_menu->LinkCustomAttributes = "";
			$this->show_in_main_menu->HrefValue = "";
			$this->show_in_main_menu->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// order_by
			$this->order_by->LinkCustomAttributes = "";
			$this->order_by->HrefValue = "";
			$this->order_by->TooltipValue = "";

			// mega_menu
			$this->mega_menu->LinkCustomAttributes = "";
			$this->mega_menu->HrefValue = "";
			$this->mega_menu->TooltipValue = "";

			// bgcolor
			$this->bgcolor->LinkCustomAttributes = "";
			$this->bgcolor->HrefValue = "";
			$this->bgcolor->TooltipValue = "";

			// submenu
			$this->submenu->LinkCustomAttributes = "";
			$this->submenu->HrefValue = "";
			$this->submenu->TooltipValue = "";

			// submenu_code
			$this->submenu_code->LinkCustomAttributes = "";
			$this->submenu_code->HrefValue = "";
			$this->submenu_code->TooltipValue = "";

			// footer_group
			$this->footer_group->LinkCustomAttributes = "";
			$this->footer_group->HrefValue = "";
			$this->footer_group->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->image->CurrentValue = HtmlDecode($this->image->CurrentValue);
			$this->image->EditValue = HtmlEncode($this->image->CurrentValue);
			$this->image->PlaceHolder = RemoveHtml($this->image->caption());

			// show_title
			$this->show_title->EditAttrs["class"] = "form-control";
			$this->show_title->EditCustomAttributes = "";
			$this->show_title->EditValue = $this->show_title->options(TRUE);

			// page_title
			$this->page_title->EditAttrs["class"] = "form-control";
			$this->page_title->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->page_title->CurrentValue = HtmlDecode($this->page_title->CurrentValue);
			$this->page_title->EditValue = HtmlEncode($this->page_title->CurrentValue);
			$this->page_title->PlaceHolder = RemoveHtml($this->page_title->caption());

			// page_url
			$this->page_url->EditAttrs["class"] = "form-control";
			$this->page_url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->page_url->CurrentValue = HtmlDecode($this->page_url->CurrentValue);
			$this->page_url->EditValue = HtmlEncode($this->page_url->CurrentValue);
			$this->page_url->PlaceHolder = RemoveHtml($this->page_url->caption());

			// target
			$this->target->EditAttrs["class"] = "form-control";
			$this->target->EditCustomAttributes = "";
			$this->target->EditValue = $this->target->options(TRUE);

			// parent_id
			$this->parent_id->EditAttrs["class"] = "form-control";
			$this->parent_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->parent_id->CurrentValue));
			if ($curVal <> "")
				$this->parent_id->ViewValue = $this->parent_id->lookupCacheOption($curVal);
			else
				$this->parent_id->ViewValue = $this->parent_id->Lookup !== NULL && is_array($this->parent_id->Lookup->Options) ? $curVal : NULL;
			if ($this->parent_id->ViewValue !== NULL) { // Load from cache
				$this->parent_id->EditValue = array_values($this->parent_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->parent_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->parent_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->parent_id->EditValue = $arwrk;
			}

			// show_in_main_menu
			$this->show_in_main_menu->EditAttrs["class"] = "form-control";
			$this->show_in_main_menu->EditCustomAttributes = "";
			$this->show_in_main_menu->EditValue = $this->show_in_main_menu->options(TRUE);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// order_by
			$this->order_by->EditAttrs["class"] = "form-control";
			$this->order_by->EditCustomAttributes = "";
			$this->order_by->EditValue = HtmlEncode($this->order_by->CurrentValue);
			$this->order_by->PlaceHolder = RemoveHtml($this->order_by->caption());

			// mega_menu
			$this->mega_menu->EditAttrs["class"] = "form-control";
			$this->mega_menu->EditCustomAttributes = "";
			$this->mega_menu->EditValue = $this->mega_menu->options(TRUE);

			// bgcolor
			$this->bgcolor->EditAttrs["class"] = "form-control";
			$this->bgcolor->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bgcolor->CurrentValue = HtmlDecode($this->bgcolor->CurrentValue);
			$this->bgcolor->EditValue = HtmlEncode($this->bgcolor->CurrentValue);
			$this->bgcolor->PlaceHolder = RemoveHtml($this->bgcolor->caption());

			// submenu
			$this->submenu->EditAttrs["class"] = "form-control";
			$this->submenu->EditCustomAttributes = "";
			$this->submenu->EditValue = $this->submenu->options(TRUE);

			// submenu_code
			$this->submenu_code->EditAttrs["class"] = "form-control";
			$this->submenu_code->EditCustomAttributes = "";
			$this->submenu_code->EditValue = HtmlEncode($this->submenu_code->CurrentValue);
			$this->submenu_code->PlaceHolder = RemoveHtml($this->submenu_code->caption());

			// footer_group
			$this->footer_group->EditAttrs["class"] = "form-control";
			$this->footer_group->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->footer_group->CurrentValue = HtmlDecode($this->footer_group->CurrentValue);
			$this->footer_group->EditValue = HtmlEncode($this->footer_group->CurrentValue);
			$this->footer_group->PlaceHolder = RemoveHtml($this->footer_group->caption());

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";

			// show_title
			$this->show_title->LinkCustomAttributes = "";
			$this->show_title->HrefValue = "";

			// page_title
			$this->page_title->LinkCustomAttributes = "";
			$this->page_title->HrefValue = "";

			// page_url
			$this->page_url->LinkCustomAttributes = "";
			$this->page_url->HrefValue = "";

			// target
			$this->target->LinkCustomAttributes = "";
			$this->target->HrefValue = "";

			// parent_id
			$this->parent_id->LinkCustomAttributes = "";
			$this->parent_id->HrefValue = "";

			// show_in_main_menu
			$this->show_in_main_menu->LinkCustomAttributes = "";
			$this->show_in_main_menu->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// order_by
			$this->order_by->LinkCustomAttributes = "";
			$this->order_by->HrefValue = "";

			// mega_menu
			$this->mega_menu->LinkCustomAttributes = "";
			$this->mega_menu->HrefValue = "";

			// bgcolor
			$this->bgcolor->LinkCustomAttributes = "";
			$this->bgcolor->HrefValue = "";

			// submenu
			$this->submenu->LinkCustomAttributes = "";
			$this->submenu->HrefValue = "";

			// submenu_code
			$this->submenu_code->LinkCustomAttributes = "";
			$this->submenu_code->HrefValue = "";

			// footer_group
			$this->footer_group->LinkCustomAttributes = "";
			$this->footer_group->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if (!$this->image->IsDetailKey && $this->image->FormValue != NULL && $this->image->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->show_title->Required) {
			if (!$this->show_title->IsDetailKey && $this->show_title->FormValue != NULL && $this->show_title->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->show_title->caption(), $this->show_title->RequiredErrorMessage));
			}
		}
		if ($this->page_title->Required) {
			if (!$this->page_title->IsDetailKey && $this->page_title->FormValue != NULL && $this->page_title->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->page_title->caption(), $this->page_title->RequiredErrorMessage));
			}
		}
		if ($this->page_url->Required) {
			if (!$this->page_url->IsDetailKey && $this->page_url->FormValue != NULL && $this->page_url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->page_url->caption(), $this->page_url->RequiredErrorMessage));
			}
		}
		if ($this->target->Required) {
			if (!$this->target->IsDetailKey && $this->target->FormValue != NULL && $this->target->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->target->caption(), $this->target->RequiredErrorMessage));
			}
		}
		if ($this->parent_id->Required) {
			if (!$this->parent_id->IsDetailKey && $this->parent_id->FormValue != NULL && $this->parent_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->parent_id->caption(), $this->parent_id->RequiredErrorMessage));
			}
		}
		if ($this->show_in_main_menu->Required) {
			if (!$this->show_in_main_menu->IsDetailKey && $this->show_in_main_menu->FormValue != NULL && $this->show_in_main_menu->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->show_in_main_menu->caption(), $this->show_in_main_menu->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->order_by->Required) {
			if (!$this->order_by->IsDetailKey && $this->order_by->FormValue != NULL && $this->order_by->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_by->caption(), $this->order_by->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->order_by->FormValue)) {
			AddMessage($FormError, $this->order_by->errorMessage());
		}
		if ($this->mega_menu->Required) {
			if (!$this->mega_menu->IsDetailKey && $this->mega_menu->FormValue != NULL && $this->mega_menu->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mega_menu->caption(), $this->mega_menu->RequiredErrorMessage));
			}
		}
		if ($this->bgcolor->Required) {
			if (!$this->bgcolor->IsDetailKey && $this->bgcolor->FormValue != NULL && $this->bgcolor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bgcolor->caption(), $this->bgcolor->RequiredErrorMessage));
			}
		}
		if ($this->submenu->Required) {
			if (!$this->submenu->IsDetailKey && $this->submenu->FormValue != NULL && $this->submenu->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->submenu->caption(), $this->submenu->RequiredErrorMessage));
			}
		}
		if ($this->submenu_code->Required) {
			if (!$this->submenu_code->IsDetailKey && $this->submenu_code->FormValue != NULL && $this->submenu_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->submenu_code->caption(), $this->submenu_code->RequiredErrorMessage));
			}
		}
		if ($this->footer_group->Required) {
			if (!$this->footer_group->IsDetailKey && $this->footer_group->FormValue != NULL && $this->footer_group->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->footer_group->caption(), $this->footer_group->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// image
			$this->image->setDbValueDef($rsnew, $this->image->CurrentValue, "", $this->image->ReadOnly);

			// show_title
			$this->show_title->setDbValueDef($rsnew, $this->show_title->CurrentValue, 0, $this->show_title->ReadOnly);

			// page_title
			$this->page_title->setDbValueDef($rsnew, $this->page_title->CurrentValue, "", $this->page_title->ReadOnly);

			// page_url
			$this->page_url->setDbValueDef($rsnew, $this->page_url->CurrentValue, "", $this->page_url->ReadOnly);

			// target
			$this->target->setDbValueDef($rsnew, $this->target->CurrentValue, 0, $this->target->ReadOnly);

			// parent_id
			$this->parent_id->setDbValueDef($rsnew, $this->parent_id->CurrentValue, 0, $this->parent_id->ReadOnly);

			// show_in_main_menu
			$this->show_in_main_menu->setDbValueDef($rsnew, $this->show_in_main_menu->CurrentValue, 0, $this->show_in_main_menu->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, $this->status->ReadOnly);

			// order_by
			$this->order_by->setDbValueDef($rsnew, $this->order_by->CurrentValue, NULL, $this->order_by->ReadOnly);

			// mega_menu
			$this->mega_menu->setDbValueDef($rsnew, $this->mega_menu->CurrentValue, 0, $this->mega_menu->ReadOnly);

			// bgcolor
			$this->bgcolor->setDbValueDef($rsnew, $this->bgcolor->CurrentValue, NULL, $this->bgcolor->ReadOnly);

			// submenu
			$this->submenu->setDbValueDef($rsnew, $this->submenu->CurrentValue, 0, $this->submenu->ReadOnly);

			// submenu_code
			$this->submenu_code->setDbValueDef($rsnew, $this->submenu_code->CurrentValue, NULL, $this->submenu_code->ReadOnly);

			// footer_group
			$this->footer_group->setDbValueDef($rsnew, $this->footer_group->CurrentValue, NULL, $this->footer_group->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("menuslist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_parent_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>