<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class message_template_admin_search extends message_template_admin
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'message_template_admin';

	// Page object name
	public $PageObjName = "message_template_admin_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (message_template_admin)
		if (!isset($GLOBALS["message_template_admin"]) || get_class($GLOBALS["message_template_admin"]) == PROJECT_NAMESPACE . "message_template_admin") {
			$GLOBALS["message_template_admin"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["message_template_admin"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'message_template_admin');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $message_template_admin;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($message_template_admin);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "message_template_adminview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("message_template_adminlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->description->setVisibility();
		$this->variables->setVisibility();
		$this->subject->setVisibility();
		$this->status_email_user->setVisibility();
		$this->email_template_user->setVisibility();
		$this->mail_to_office->setVisibility();
		$this->status_email_office->setVisibility();
		$this->email_template_office->setVisibility();
		$this->status_sms_user->setVisibility();
		$this->sms_template_user->setVisibility();
		$this->sms_template_user_id->setVisibility();
		$this->status_sms_office->setVisibility();
		$this->sms_to_office->setVisibility();
		$this->sms_template_office->setVisibility();
		$this->sms_template_office_id->setVisibility();
		$this->wa_status_user->setVisibility();
		$this->wa_type_user->setVisibility();
		$this->wa_template_user->setVisibility();
		$this->wa_status_office->setVisibility();
		$this->wa_type_office->setVisibility();
		$this->wa_to_office->setVisibility();
		$this->wa_template_office->setVisibility();
		$this->wa_id->setVisibility();
		$this->notification_status_user->setVisibility();
		$this->notification_template_user->setVisibility();
		$this->notification_status_office->setVisibility();
		$this->notification_to_office->setVisibility();
		$this->notification_template_office->setVisibility();
		$this->code->setVisibility();
		$this->visible->setVisibility();
		$this->cron->setVisibility();
		$this->next_cycle->setVisibility();
		$this->delay->setVisibility();
		$this->delay_method->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->operator_admin->setVisibility();
		$this->datetime_admin->setVisibility();
		$this->company_id->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->wa_type_user);
		$this->setupLookupOptions($this->wa_type_office);
		$this->setupLookupOptions($this->wa_id);
		$this->setupLookupOptions($this->notification_to_office);
		$this->setupLookupOptions($this->company_id);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "message_template_adminlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->description); // description
		$this->buildSearchUrl($srchUrl, $this->variables); // variables
		$this->buildSearchUrl($srchUrl, $this->subject); // subject
		$this->buildSearchUrl($srchUrl, $this->status_email_user); // status_email_user
		$this->buildSearchUrl($srchUrl, $this->email_template_user); // email_template_user
		$this->buildSearchUrl($srchUrl, $this->mail_to_office); // mail_to_office
		$this->buildSearchUrl($srchUrl, $this->status_email_office); // status_email_office
		$this->buildSearchUrl($srchUrl, $this->email_template_office); // email_template_office
		$this->buildSearchUrl($srchUrl, $this->status_sms_user); // status_sms_user
		$this->buildSearchUrl($srchUrl, $this->sms_template_user); // sms_template_user
		$this->buildSearchUrl($srchUrl, $this->sms_template_user_id); // sms_template_user_id
		$this->buildSearchUrl($srchUrl, $this->status_sms_office); // status_sms_office
		$this->buildSearchUrl($srchUrl, $this->sms_to_office); // sms_to_office
		$this->buildSearchUrl($srchUrl, $this->sms_template_office); // sms_template_office
		$this->buildSearchUrl($srchUrl, $this->sms_template_office_id); // sms_template_office_id
		$this->buildSearchUrl($srchUrl, $this->wa_status_user); // wa_status_user
		$this->buildSearchUrl($srchUrl, $this->wa_type_user); // wa_type_user
		$this->buildSearchUrl($srchUrl, $this->wa_template_user); // wa_template_user
		$this->buildSearchUrl($srchUrl, $this->wa_status_office); // wa_status_office
		$this->buildSearchUrl($srchUrl, $this->wa_type_office); // wa_type_office
		$this->buildSearchUrl($srchUrl, $this->wa_to_office); // wa_to_office
		$this->buildSearchUrl($srchUrl, $this->wa_template_office); // wa_template_office
		$this->buildSearchUrl($srchUrl, $this->wa_id); // wa_id
		$this->buildSearchUrl($srchUrl, $this->notification_status_user); // notification_status_user
		$this->buildSearchUrl($srchUrl, $this->notification_template_user); // notification_template_user
		$this->buildSearchUrl($srchUrl, $this->notification_status_office); // notification_status_office
		$this->buildSearchUrl($srchUrl, $this->notification_to_office); // notification_to_office
		$this->buildSearchUrl($srchUrl, $this->notification_template_office); // notification_template_office
		$this->buildSearchUrl($srchUrl, $this->code); // code
		$this->buildSearchUrl($srchUrl, $this->visible); // visible
		$this->buildSearchUrl($srchUrl, $this->cron); // cron
		$this->buildSearchUrl($srchUrl, $this->next_cycle); // next_cycle
		$this->buildSearchUrl($srchUrl, $this->delay); // delay
		$this->buildSearchUrl($srchUrl, $this->delay_method); // delay_method
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->operator_admin); // operator_admin
		$this->buildSearchUrl($srchUrl, $this->datetime_admin); // datetime_admin
		$this->buildSearchUrl($srchUrl, $this->company_id); // company_id
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// description
		if (!$this->isAddOrEdit())
			$this->description->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description"));
		$this->description->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description"));

		// variables
		if (!$this->isAddOrEdit())
			$this->variables->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_variables"));
		$this->variables->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_variables"));

		// subject
		if (!$this->isAddOrEdit())
			$this->subject->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_subject"));
		$this->subject->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_subject"));

		// status_email_user
		if (!$this->isAddOrEdit())
			$this->status_email_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status_email_user"));
		$this->status_email_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status_email_user"));

		// email_template_user
		if (!$this->isAddOrEdit())
			$this->email_template_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_email_template_user"));
		$this->email_template_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_email_template_user"));

		// mail_to_office
		if (!$this->isAddOrEdit())
			$this->mail_to_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mail_to_office"));
		$this->mail_to_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mail_to_office"));

		// status_email_office
		if (!$this->isAddOrEdit())
			$this->status_email_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status_email_office"));
		$this->status_email_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status_email_office"));

		// email_template_office
		if (!$this->isAddOrEdit())
			$this->email_template_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_email_template_office"));
		$this->email_template_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_email_template_office"));

		// status_sms_user
		if (!$this->isAddOrEdit())
			$this->status_sms_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status_sms_user"));
		$this->status_sms_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status_sms_user"));

		// sms_template_user
		if (!$this->isAddOrEdit())
			$this->sms_template_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sms_template_user"));
		$this->sms_template_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sms_template_user"));

		// sms_template_user_id
		if (!$this->isAddOrEdit())
			$this->sms_template_user_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sms_template_user_id"));
		$this->sms_template_user_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sms_template_user_id"));

		// status_sms_office
		if (!$this->isAddOrEdit())
			$this->status_sms_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status_sms_office"));
		$this->status_sms_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status_sms_office"));

		// sms_to_office
		if (!$this->isAddOrEdit())
			$this->sms_to_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sms_to_office"));
		$this->sms_to_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sms_to_office"));

		// sms_template_office
		if (!$this->isAddOrEdit())
			$this->sms_template_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sms_template_office"));
		$this->sms_template_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sms_template_office"));

		// sms_template_office_id
		if (!$this->isAddOrEdit())
			$this->sms_template_office_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sms_template_office_id"));
		$this->sms_template_office_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sms_template_office_id"));

		// wa_status_user
		if (!$this->isAddOrEdit())
			$this->wa_status_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_wa_status_user"));
		$this->wa_status_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_wa_status_user"));

		// wa_type_user
		if (!$this->isAddOrEdit())
			$this->wa_type_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_wa_type_user"));
		$this->wa_type_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_wa_type_user"));

		// wa_template_user
		if (!$this->isAddOrEdit())
			$this->wa_template_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_wa_template_user"));
		$this->wa_template_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_wa_template_user"));

		// wa_status_office
		if (!$this->isAddOrEdit())
			$this->wa_status_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_wa_status_office"));
		$this->wa_status_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_wa_status_office"));

		// wa_type_office
		if (!$this->isAddOrEdit())
			$this->wa_type_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_wa_type_office"));
		$this->wa_type_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_wa_type_office"));

		// wa_to_office
		if (!$this->isAddOrEdit())
			$this->wa_to_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_wa_to_office"));
		$this->wa_to_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_wa_to_office"));

		// wa_template_office
		if (!$this->isAddOrEdit())
			$this->wa_template_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_wa_template_office"));
		$this->wa_template_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_wa_template_office"));

		// wa_id
		if (!$this->isAddOrEdit())
			$this->wa_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_wa_id"));
		$this->wa_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_wa_id"));

		// notification_status_user
		if (!$this->isAddOrEdit())
			$this->notification_status_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_notification_status_user"));
		$this->notification_status_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_notification_status_user"));

		// notification_template_user
		if (!$this->isAddOrEdit())
			$this->notification_template_user->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_notification_template_user"));
		$this->notification_template_user->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_notification_template_user"));

		// notification_status_office
		if (!$this->isAddOrEdit())
			$this->notification_status_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_notification_status_office"));
		$this->notification_status_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_notification_status_office"));

		// notification_to_office
		if (!$this->isAddOrEdit())
			$this->notification_to_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_notification_to_office"));
		$this->notification_to_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_notification_to_office"));
		if (is_array($this->notification_to_office->AdvancedSearch->SearchValue))
			$this->notification_to_office->AdvancedSearch->SearchValue = implode(",", $this->notification_to_office->AdvancedSearch->SearchValue);
		if (is_array($this->notification_to_office->AdvancedSearch->SearchValue2))
			$this->notification_to_office->AdvancedSearch->SearchValue2 = implode(",", $this->notification_to_office->AdvancedSearch->SearchValue2);

		// notification_template_office
		if (!$this->isAddOrEdit())
			$this->notification_template_office->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_notification_template_office"));
		$this->notification_template_office->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_notification_template_office"));

		// code
		if (!$this->isAddOrEdit())
			$this->code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_code"));
		$this->code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_code"));

		// visible
		if (!$this->isAddOrEdit())
			$this->visible->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_visible"));
		$this->visible->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_visible"));

		// cron
		if (!$this->isAddOrEdit())
			$this->cron->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cron"));
		$this->cron->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cron"));

		// next_cycle
		if (!$this->isAddOrEdit())
			$this->next_cycle->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_next_cycle"));
		$this->next_cycle->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_next_cycle"));

		// delay
		if (!$this->isAddOrEdit())
			$this->delay->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_delay"));
		$this->delay->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_delay"));

		// delay_method
		if (!$this->isAddOrEdit())
			$this->delay_method->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_delay_method"));
		$this->delay_method->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_delay_method"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// operator_admin
		if (!$this->isAddOrEdit())
			$this->operator_admin->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator_admin"));
		$this->operator_admin->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator_admin"));

		// datetime_admin
		if (!$this->isAddOrEdit())
			$this->datetime_admin->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime_admin"));
		$this->datetime_admin->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime_admin"));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_company_id"));
		$this->company_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_company_id"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// description
		// variables
		// subject
		// status_email_user
		// email_template_user
		// mail_to_office
		// status_email_office
		// email_template_office
		// status_sms_user
		// sms_template_user
		// sms_template_user_id
		// status_sms_office
		// sms_to_office
		// sms_template_office
		// sms_template_office_id
		// wa_status_user
		// wa_type_user
		// wa_template_user
		// wa_status_office
		// wa_type_office
		// wa_to_office
		// wa_template_office
		// wa_id
		// notification_status_user
		// notification_template_user
		// notification_status_office
		// notification_to_office
		// notification_template_office
		// code
		// visible
		// cron
		// next_cycle
		// delay
		// delay_method
		// operator
		// datetime
		// operator_admin
		// datetime_admin
		// company_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// variables
			$this->variables->ViewValue = $this->variables->CurrentValue;
			$this->variables->ViewCustomAttributes = "";

			// subject
			$this->subject->ViewValue = $this->subject->CurrentValue;
			$this->subject->ViewCustomAttributes = "";

			// status_email_user
			if (strval($this->status_email_user->CurrentValue) <> "") {
				$this->status_email_user->ViewValue = $this->status_email_user->optionCaption($this->status_email_user->CurrentValue);
			} else {
				$this->status_email_user->ViewValue = NULL;
			}
			$this->status_email_user->ViewCustomAttributes = "";

			// email_template_user
			$this->email_template_user->ViewValue = $this->email_template_user->CurrentValue;
			$this->email_template_user->ViewCustomAttributes = "";

			// mail_to_office
			$this->mail_to_office->ViewValue = $this->mail_to_office->CurrentValue;
			$this->mail_to_office->ViewCustomAttributes = "";

			// status_email_office
			if (strval($this->status_email_office->CurrentValue) <> "") {
				$this->status_email_office->ViewValue = $this->status_email_office->optionCaption($this->status_email_office->CurrentValue);
			} else {
				$this->status_email_office->ViewValue = NULL;
			}
			$this->status_email_office->ViewCustomAttributes = "";

			// email_template_office
			$this->email_template_office->ViewValue = $this->email_template_office->CurrentValue;
			$this->email_template_office->ViewCustomAttributes = "";

			// status_sms_user
			if (strval($this->status_sms_user->CurrentValue) <> "") {
				$this->status_sms_user->ViewValue = $this->status_sms_user->optionCaption($this->status_sms_user->CurrentValue);
			} else {
				$this->status_sms_user->ViewValue = NULL;
			}
			$this->status_sms_user->ViewCustomAttributes = "";

			// sms_template_user
			$this->sms_template_user->ViewValue = $this->sms_template_user->CurrentValue;
			$this->sms_template_user->ViewCustomAttributes = "";

			// sms_template_user_id
			$this->sms_template_user_id->ViewValue = $this->sms_template_user_id->CurrentValue;
			$this->sms_template_user_id->ViewCustomAttributes = "";

			// status_sms_office
			if (strval($this->status_sms_office->CurrentValue) <> "") {
				$this->status_sms_office->ViewValue = $this->status_sms_office->optionCaption($this->status_sms_office->CurrentValue);
			} else {
				$this->status_sms_office->ViewValue = NULL;
			}
			$this->status_sms_office->ViewCustomAttributes = "";

			// sms_to_office
			$this->sms_to_office->ViewValue = $this->sms_to_office->CurrentValue;
			$this->sms_to_office->ViewCustomAttributes = "";

			// sms_template_office
			$this->sms_template_office->ViewValue = $this->sms_template_office->CurrentValue;
			$this->sms_template_office->ViewCustomAttributes = "";

			// sms_template_office_id
			$this->sms_template_office_id->ViewValue = $this->sms_template_office_id->CurrentValue;
			$this->sms_template_office_id->ViewCustomAttributes = "";

			// wa_status_user
			if (strval($this->wa_status_user->CurrentValue) <> "") {
				$this->wa_status_user->ViewValue = $this->wa_status_user->optionCaption($this->wa_status_user->CurrentValue);
			} else {
				$this->wa_status_user->ViewValue = NULL;
			}
			$this->wa_status_user->ViewCustomAttributes = "";

			// wa_type_user
			$curVal = strval($this->wa_type_user->CurrentValue);
			if ($curVal <> "") {
				$this->wa_type_user->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
				if ($this->wa_type_user->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->wa_type_user->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_type_user->ViewValue = $this->wa_type_user->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_type_user->ViewValue = $this->wa_type_user->CurrentValue;
					}
				}
			} else {
				$this->wa_type_user->ViewValue = NULL;
			}
			$this->wa_type_user->ViewCustomAttributes = "";

			// wa_template_user
			$this->wa_template_user->ViewValue = $this->wa_template_user->CurrentValue;
			$this->wa_template_user->ViewCustomAttributes = "";

			// wa_status_office
			if (strval($this->wa_status_office->CurrentValue) <> "") {
				$this->wa_status_office->ViewValue = $this->wa_status_office->optionCaption($this->wa_status_office->CurrentValue);
			} else {
				$this->wa_status_office->ViewValue = NULL;
			}
			$this->wa_status_office->ViewCustomAttributes = "";

			// wa_type_office
			$curVal = strval($this->wa_type_office->CurrentValue);
			if ($curVal <> "") {
				$this->wa_type_office->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
				if ($this->wa_type_office->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->wa_type_office->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_type_office->ViewValue = $this->wa_type_office->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_type_office->ViewValue = $this->wa_type_office->CurrentValue;
					}
				}
			} else {
				$this->wa_type_office->ViewValue = NULL;
			}
			$this->wa_type_office->ViewCustomAttributes = "";

			// wa_to_office
			$this->wa_to_office->ViewValue = $this->wa_to_office->CurrentValue;
			$this->wa_to_office->ViewCustomAttributes = "";

			// wa_template_office
			$this->wa_template_office->ViewValue = $this->wa_template_office->CurrentValue;
			$this->wa_template_office->ViewCustomAttributes = "";

			// wa_id
			$curVal = strval($this->wa_id->CurrentValue);
			if ($curVal <> "") {
				$this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
				if ($this->wa_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->wa_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_id->ViewValue = $this->wa_id->CurrentValue;
					}
				}
			} else {
				$this->wa_id->ViewValue = NULL;
			}
			$this->wa_id->ViewCustomAttributes = "";

			// notification_status_user
			if (strval($this->notification_status_user->CurrentValue) <> "") {
				$this->notification_status_user->ViewValue = $this->notification_status_user->optionCaption($this->notification_status_user->CurrentValue);
			} else {
				$this->notification_status_user->ViewValue = NULL;
			}
			$this->notification_status_user->ViewCustomAttributes = "";

			// notification_template_user
			$this->notification_template_user->ViewValue = $this->notification_template_user->CurrentValue;
			$this->notification_template_user->ViewCustomAttributes = "";

			// notification_status_office
			if (strval($this->notification_status_office->CurrentValue) <> "") {
				$this->notification_status_office->ViewValue = $this->notification_status_office->optionCaption($this->notification_status_office->CurrentValue);
			} else {
				$this->notification_status_office->ViewValue = NULL;
			}
			$this->notification_status_office->ViewCustomAttributes = "";

			// notification_to_office
			$curVal = strval($this->notification_to_office->CurrentValue);
			if ($curVal <> "") {
				$this->notification_to_office->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
				if ($this->notification_to_office->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->notification_to_office->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->notification_to_office->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->notification_to_office->ViewValue->add($this->notification_to_office->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->notification_to_office->ViewValue = $this->notification_to_office->CurrentValue;
					}
				}
			} else {
				$this->notification_to_office->ViewValue = NULL;
			}
			$this->notification_to_office->ViewCustomAttributes = "";

			// notification_template_office
			$this->notification_template_office->ViewValue = $this->notification_template_office->CurrentValue;
			$this->notification_template_office->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// visible
			if (strval($this->visible->CurrentValue) <> "") {
				$this->visible->ViewValue = $this->visible->optionCaption($this->visible->CurrentValue);
			} else {
				$this->visible->ViewValue = NULL;
			}
			$this->visible->ViewCustomAttributes = "";

			// cron
			if (strval($this->cron->CurrentValue) <> "") {
				$this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
			} else {
				$this->cron->ViewValue = NULL;
			}
			$this->cron->ViewCustomAttributes = "";

			// next_cycle
			$this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
			$this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, 11);
			$this->next_cycle->ViewCustomAttributes = "";

			// delay
			$this->delay->ViewValue = $this->delay->CurrentValue;
			$this->delay->ViewValue = FormatNumber($this->delay->ViewValue, 0, -2, -2, -2);
			$this->delay->ViewCustomAttributes = "";

			// delay_method
			if (strval($this->delay_method->CurrentValue) <> "") {
				$this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
			} else {
				$this->delay_method->ViewValue = NULL;
			}
			$this->delay_method->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// operator_admin
			$this->operator_admin->ViewValue = $this->operator_admin->CurrentValue;
			$this->operator_admin->ViewCustomAttributes = "";

			// datetime_admin
			$this->datetime_admin->ViewValue = $this->datetime_admin->CurrentValue;
			$this->datetime_admin->ViewValue = FormatDateTime($this->datetime_admin->ViewValue, 0);
			$this->datetime_admin->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			if (!EmptyValue($this->id->CurrentValue)) {
				$this->description->HrefValue = "mailer_view.php?MTID=" . $this->id->CurrentValue; // Add prefix/suffix
				$this->description->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
			} else {
				$this->description->HrefValue = "";
			}
			$this->description->TooltipValue = "";

			// variables
			$this->variables->LinkCustomAttributes = "";
			$this->variables->HrefValue = "";
			$this->variables->TooltipValue = "";

			// subject
			$this->subject->LinkCustomAttributes = "";
			$this->subject->HrefValue = "";
			$this->subject->TooltipValue = "";

			// status_email_user
			$this->status_email_user->LinkCustomAttributes = "";
			$this->status_email_user->HrefValue = "";
			$this->status_email_user->TooltipValue = "";

			// email_template_user
			$this->email_template_user->LinkCustomAttributes = "";
			$this->email_template_user->HrefValue = "";
			$this->email_template_user->TooltipValue = "";

			// mail_to_office
			$this->mail_to_office->LinkCustomAttributes = "";
			$this->mail_to_office->HrefValue = "";
			$this->mail_to_office->TooltipValue = "";

			// status_email_office
			$this->status_email_office->LinkCustomAttributes = "";
			$this->status_email_office->HrefValue = "";
			$this->status_email_office->TooltipValue = "";

			// email_template_office
			$this->email_template_office->LinkCustomAttributes = "";
			$this->email_template_office->HrefValue = "";
			$this->email_template_office->TooltipValue = "";

			// status_sms_user
			$this->status_sms_user->LinkCustomAttributes = "";
			$this->status_sms_user->HrefValue = "";
			$this->status_sms_user->TooltipValue = "";

			// sms_template_user
			$this->sms_template_user->LinkCustomAttributes = "";
			$this->sms_template_user->HrefValue = "";
			$this->sms_template_user->TooltipValue = "";

			// sms_template_user_id
			$this->sms_template_user_id->LinkCustomAttributes = "";
			$this->sms_template_user_id->HrefValue = "";
			$this->sms_template_user_id->TooltipValue = "";

			// status_sms_office
			$this->status_sms_office->LinkCustomAttributes = "";
			$this->status_sms_office->HrefValue = "";
			$this->status_sms_office->TooltipValue = "";

			// sms_to_office
			$this->sms_to_office->LinkCustomAttributes = "";
			$this->sms_to_office->HrefValue = "";
			$this->sms_to_office->TooltipValue = "";

			// sms_template_office
			$this->sms_template_office->LinkCustomAttributes = "";
			$this->sms_template_office->HrefValue = "";
			$this->sms_template_office->TooltipValue = "";

			// sms_template_office_id
			$this->sms_template_office_id->LinkCustomAttributes = "";
			$this->sms_template_office_id->HrefValue = "";
			$this->sms_template_office_id->TooltipValue = "";

			// wa_status_user
			$this->wa_status_user->LinkCustomAttributes = "";
			$this->wa_status_user->HrefValue = "";
			$this->wa_status_user->TooltipValue = "";

			// wa_type_user
			$this->wa_type_user->LinkCustomAttributes = "";
			$this->wa_type_user->HrefValue = "";
			$this->wa_type_user->TooltipValue = "";

			// wa_template_user
			$this->wa_template_user->LinkCustomAttributes = "";
			$this->wa_template_user->HrefValue = "";
			$this->wa_template_user->TooltipValue = "";

			// wa_status_office
			$this->wa_status_office->LinkCustomAttributes = "";
			$this->wa_status_office->HrefValue = "";
			$this->wa_status_office->TooltipValue = "";

			// wa_type_office
			$this->wa_type_office->LinkCustomAttributes = "";
			$this->wa_type_office->HrefValue = "";
			$this->wa_type_office->TooltipValue = "";

			// wa_to_office
			$this->wa_to_office->LinkCustomAttributes = "";
			$this->wa_to_office->HrefValue = "";
			$this->wa_to_office->TooltipValue = "";

			// wa_template_office
			$this->wa_template_office->LinkCustomAttributes = "";
			$this->wa_template_office->HrefValue = "";
			$this->wa_template_office->TooltipValue = "";

			// wa_id
			$this->wa_id->LinkCustomAttributes = "";
			$this->wa_id->HrefValue = "";
			$this->wa_id->TooltipValue = "";

			// notification_status_user
			$this->notification_status_user->LinkCustomAttributes = "";
			$this->notification_status_user->HrefValue = "";
			$this->notification_status_user->TooltipValue = "";

			// notification_template_user
			$this->notification_template_user->LinkCustomAttributes = "";
			$this->notification_template_user->HrefValue = "";
			$this->notification_template_user->TooltipValue = "";

			// notification_status_office
			$this->notification_status_office->LinkCustomAttributes = "";
			$this->notification_status_office->HrefValue = "";
			$this->notification_status_office->TooltipValue = "";

			// notification_to_office
			$this->notification_to_office->LinkCustomAttributes = "";
			$this->notification_to_office->HrefValue = "";
			$this->notification_to_office->TooltipValue = "";

			// notification_template_office
			$this->notification_template_office->LinkCustomAttributes = "";
			$this->notification_template_office->HrefValue = "";
			$this->notification_template_office->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";

			// visible
			$this->visible->LinkCustomAttributes = "";
			$this->visible->HrefValue = "";
			$this->visible->TooltipValue = "";

			// cron
			$this->cron->LinkCustomAttributes = "";
			$this->cron->HrefValue = "";
			$this->cron->TooltipValue = "";

			// next_cycle
			$this->next_cycle->LinkCustomAttributes = "";
			$this->next_cycle->HrefValue = "";
			$this->next_cycle->TooltipValue = "";

			// delay
			$this->delay->LinkCustomAttributes = "";
			$this->delay->HrefValue = "";
			$this->delay->TooltipValue = "";

			// delay_method
			$this->delay_method->LinkCustomAttributes = "";
			$this->delay_method->HrefValue = "";
			$this->delay_method->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// operator_admin
			$this->operator_admin->LinkCustomAttributes = "";
			$this->operator_admin->HrefValue = "";
			$this->operator_admin->TooltipValue = "";

			// datetime_admin
			$this->datetime_admin->LinkCustomAttributes = "";
			$this->datetime_admin->HrefValue = "";
			$this->datetime_admin->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 1 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
			$this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// variables
			$this->variables->EditAttrs["class"] = "form-control";
			$this->variables->EditCustomAttributes = "";
			$this->variables->EditValue = HtmlEncode($this->variables->AdvancedSearch->SearchValue);
			$this->variables->PlaceHolder = RemoveHtml($this->variables->caption());

			// subject
			$this->subject->EditAttrs["class"] = "form-control";
			$this->subject->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->subject->AdvancedSearch->SearchValue = HtmlDecode($this->subject->AdvancedSearch->SearchValue);
			$this->subject->EditValue = HtmlEncode($this->subject->AdvancedSearch->SearchValue);
			$this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

			// status_email_user
			$this->status_email_user->EditAttrs["class"] = "form-control";
			$this->status_email_user->EditCustomAttributes = "";
			$this->status_email_user->EditValue = $this->status_email_user->options(TRUE);

			// email_template_user
			$this->email_template_user->EditAttrs["class"] = "form-control";
			$this->email_template_user->EditCustomAttributes = "";
			$this->email_template_user->EditValue = HtmlEncode($this->email_template_user->AdvancedSearch->SearchValue);
			$this->email_template_user->PlaceHolder = RemoveHtml($this->email_template_user->caption());

			// mail_to_office
			$this->mail_to_office->EditAttrs["class"] = "form-control";
			$this->mail_to_office->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mail_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->mail_to_office->AdvancedSearch->SearchValue);
			$this->mail_to_office->EditValue = HtmlEncode($this->mail_to_office->AdvancedSearch->SearchValue);
			$this->mail_to_office->PlaceHolder = RemoveHtml($this->mail_to_office->caption());

			// status_email_office
			$this->status_email_office->EditAttrs["class"] = "form-control";
			$this->status_email_office->EditCustomAttributes = "";
			$this->status_email_office->EditValue = $this->status_email_office->options(TRUE);

			// email_template_office
			$this->email_template_office->EditAttrs["class"] = "form-control";
			$this->email_template_office->EditCustomAttributes = "";
			$this->email_template_office->EditValue = HtmlEncode($this->email_template_office->AdvancedSearch->SearchValue);
			$this->email_template_office->PlaceHolder = RemoveHtml($this->email_template_office->caption());

			// status_sms_user
			$this->status_sms_user->EditAttrs["class"] = "form-control";
			$this->status_sms_user->EditCustomAttributes = "";
			$this->status_sms_user->EditValue = $this->status_sms_user->options(TRUE);

			// sms_template_user
			$this->sms_template_user->EditAttrs["class"] = "form-control";
			$this->sms_template_user->EditCustomAttributes = "";
			$this->sms_template_user->EditValue = HtmlEncode($this->sms_template_user->AdvancedSearch->SearchValue);
			$this->sms_template_user->PlaceHolder = RemoveHtml($this->sms_template_user->caption());

			// sms_template_user_id
			$this->sms_template_user_id->EditAttrs["class"] = "form-control";
			$this->sms_template_user_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sms_template_user_id->AdvancedSearch->SearchValue = HtmlDecode($this->sms_template_user_id->AdvancedSearch->SearchValue);
			$this->sms_template_user_id->EditValue = HtmlEncode($this->sms_template_user_id->AdvancedSearch->SearchValue);
			$this->sms_template_user_id->PlaceHolder = RemoveHtml($this->sms_template_user_id->caption());

			// status_sms_office
			$this->status_sms_office->EditAttrs["class"] = "form-control";
			$this->status_sms_office->EditCustomAttributes = "";
			$this->status_sms_office->EditValue = $this->status_sms_office->options(TRUE);

			// sms_to_office
			$this->sms_to_office->EditAttrs["class"] = "form-control";
			$this->sms_to_office->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sms_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->sms_to_office->AdvancedSearch->SearchValue);
			$this->sms_to_office->EditValue = HtmlEncode($this->sms_to_office->AdvancedSearch->SearchValue);
			$this->sms_to_office->PlaceHolder = RemoveHtml($this->sms_to_office->caption());

			// sms_template_office
			$this->sms_template_office->EditAttrs["class"] = "form-control";
			$this->sms_template_office->EditCustomAttributes = "";
			$this->sms_template_office->EditValue = HtmlEncode($this->sms_template_office->AdvancedSearch->SearchValue);
			$this->sms_template_office->PlaceHolder = RemoveHtml($this->sms_template_office->caption());

			// sms_template_office_id
			$this->sms_template_office_id->EditAttrs["class"] = "form-control";
			$this->sms_template_office_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sms_template_office_id->AdvancedSearch->SearchValue = HtmlDecode($this->sms_template_office_id->AdvancedSearch->SearchValue);
			$this->sms_template_office_id->EditValue = HtmlEncode($this->sms_template_office_id->AdvancedSearch->SearchValue);
			$this->sms_template_office_id->PlaceHolder = RemoveHtml($this->sms_template_office_id->caption());

			// wa_status_user
			$this->wa_status_user->EditAttrs["class"] = "form-control";
			$this->wa_status_user->EditCustomAttributes = "";
			$this->wa_status_user->EditValue = $this->wa_status_user->options(TRUE);

			// wa_type_user
			$this->wa_type_user->EditAttrs["class"] = "form-control";
			$this->wa_type_user->EditCustomAttributes = "";
			$curVal = trim(strval($this->wa_type_user->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->wa_type_user->AdvancedSearch->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
			else
				$this->wa_type_user->AdvancedSearch->ViewValue = $this->wa_type_user->Lookup !== NULL && is_array($this->wa_type_user->Lookup->Options) ? $curVal : NULL;
			if ($this->wa_type_user->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->wa_type_user->EditValue = array_values($this->wa_type_user->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->wa_type_user->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 2 and `status`= 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->wa_type_user->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->wa_type_user->EditValue = $arwrk;
			}

			// wa_template_user
			$this->wa_template_user->EditAttrs["class"] = "form-control";
			$this->wa_template_user->EditCustomAttributes = "";
			$this->wa_template_user->EditValue = HtmlEncode($this->wa_template_user->AdvancedSearch->SearchValue);
			$this->wa_template_user->PlaceHolder = RemoveHtml($this->wa_template_user->caption());

			// wa_status_office
			$this->wa_status_office->EditAttrs["class"] = "form-control";
			$this->wa_status_office->EditCustomAttributes = "";
			$this->wa_status_office->EditValue = $this->wa_status_office->options(TRUE);

			// wa_type_office
			$this->wa_type_office->EditAttrs["class"] = "form-control";
			$this->wa_type_office->EditCustomAttributes = "";
			$curVal = trim(strval($this->wa_type_office->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->wa_type_office->AdvancedSearch->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
			else
				$this->wa_type_office->AdvancedSearch->ViewValue = $this->wa_type_office->Lookup !== NULL && is_array($this->wa_type_office->Lookup->Options) ? $curVal : NULL;
			if ($this->wa_type_office->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->wa_type_office->EditValue = array_values($this->wa_type_office->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->wa_type_office->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp = 2 and `status`= 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->wa_type_office->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->wa_type_office->EditValue = $arwrk;
			}

			// wa_to_office
			$this->wa_to_office->EditAttrs["class"] = "form-control";
			$this->wa_to_office->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->wa_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->wa_to_office->AdvancedSearch->SearchValue);
			$this->wa_to_office->EditValue = HtmlEncode($this->wa_to_office->AdvancedSearch->SearchValue);
			$this->wa_to_office->PlaceHolder = RemoveHtml($this->wa_to_office->caption());

			// wa_template_office
			$this->wa_template_office->EditAttrs["class"] = "form-control";
			$this->wa_template_office->EditCustomAttributes = "";
			$this->wa_template_office->EditValue = HtmlEncode($this->wa_template_office->AdvancedSearch->SearchValue);
			$this->wa_template_office->PlaceHolder = RemoveHtml($this->wa_template_office->caption());

			// wa_id
			$this->wa_id->EditAttrs["class"] = "form-control";
			$this->wa_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->wa_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->wa_id->AdvancedSearch->ViewValue = $this->wa_id->lookupCacheOption($curVal);
			else
				$this->wa_id->AdvancedSearch->ViewValue = $this->wa_id->Lookup !== NULL && is_array($this->wa_id->Lookup->Options) ? $curVal : NULL;
			if ($this->wa_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->wa_id->EditValue = array_values($this->wa_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->wa_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->wa_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->wa_id->EditValue = $arwrk;
			}

			// notification_status_user
			$this->notification_status_user->EditAttrs["class"] = "form-control";
			$this->notification_status_user->EditCustomAttributes = "";
			$this->notification_status_user->EditValue = $this->notification_status_user->options(TRUE);

			// notification_template_user
			$this->notification_template_user->EditAttrs["class"] = "form-control";
			$this->notification_template_user->EditCustomAttributes = "";
			$this->notification_template_user->EditValue = HtmlEncode($this->notification_template_user->AdvancedSearch->SearchValue);
			$this->notification_template_user->PlaceHolder = RemoveHtml($this->notification_template_user->caption());

			// notification_status_office
			$this->notification_status_office->EditAttrs["class"] = "form-control";
			$this->notification_status_office->EditCustomAttributes = "";
			$this->notification_status_office->EditValue = $this->notification_status_office->options(TRUE);

			// notification_to_office
			$this->notification_to_office->EditAttrs["class"] = "form-control";
			$this->notification_to_office->EditCustomAttributes = "";
			$curVal = trim(strval($this->notification_to_office->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->notification_to_office->AdvancedSearch->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
			else
				$this->notification_to_office->AdvancedSearch->ViewValue = $this->notification_to_office->Lookup !== NULL && is_array($this->notification_to_office->Lookup->Options) ? $curVal : NULL;
			if ($this->notification_to_office->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->notification_to_office->EditValue = array_values($this->notification_to_office->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->notification_to_office->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->notification_to_office->EditValue = $arwrk;
			}

			// notification_template_office
			$this->notification_template_office->EditAttrs["class"] = "form-control";
			$this->notification_template_office->EditCustomAttributes = "";
			$this->notification_template_office->EditValue = HtmlEncode($this->notification_template_office->AdvancedSearch->SearchValue);
			$this->notification_template_office->PlaceHolder = RemoveHtml($this->notification_template_office->caption());

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			$this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// visible
			$this->visible->EditAttrs["class"] = "form-control";
			$this->visible->EditCustomAttributes = "";
			$this->visible->EditValue = $this->visible->options(TRUE);

			// cron
			$this->cron->EditAttrs["class"] = "form-control";
			$this->cron->EditCustomAttributes = "";
			$this->cron->EditValue = $this->cron->options(TRUE);

			// next_cycle
			$this->next_cycle->EditAttrs["class"] = "form-control";
			$this->next_cycle->EditCustomAttributes = "";
			$this->next_cycle->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->next_cycle->AdvancedSearch->SearchValue, 11), 11));
			$this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

			// delay
			$this->delay->EditAttrs["class"] = "form-control";
			$this->delay->EditCustomAttributes = "";
			$this->delay->EditValue = HtmlEncode($this->delay->AdvancedSearch->SearchValue);
			$this->delay->PlaceHolder = RemoveHtml($this->delay->caption());

			// delay_method
			$this->delay_method->EditAttrs["class"] = "form-control";
			$this->delay_method->EditCustomAttributes = "";
			$this->delay_method->EditValue = $this->delay_method->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// operator_admin
			$this->operator_admin->EditAttrs["class"] = "form-control";
			$this->operator_admin->EditCustomAttributes = "";
			$this->operator_admin->EditValue = HtmlEncode($this->operator_admin->AdvancedSearch->SearchValue);
			$this->operator_admin->PlaceHolder = RemoveHtml($this->operator_admin->caption());

			// datetime_admin
			$this->datetime_admin->EditAttrs["class"] = "form-control";
			$this->datetime_admin->EditCustomAttributes = "";
			$this->datetime_admin->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime_admin->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime_admin->PlaceHolder = RemoveHtml($this->datetime_admin->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckEuroDate($this->next_cycle->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->next_cycle->errorMessage());
		}
		if (!CheckInteger($this->delay->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->delay->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckInteger($this->operator_admin->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator_admin->errorMessage());
		}
		if (!CheckDate($this->datetime_admin->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime_admin->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->description->AdvancedSearch->load();
		$this->variables->AdvancedSearch->load();
		$this->subject->AdvancedSearch->load();
		$this->status_email_user->AdvancedSearch->load();
		$this->email_template_user->AdvancedSearch->load();
		$this->mail_to_office->AdvancedSearch->load();
		$this->status_email_office->AdvancedSearch->load();
		$this->email_template_office->AdvancedSearch->load();
		$this->status_sms_user->AdvancedSearch->load();
		$this->sms_template_user->AdvancedSearch->load();
		$this->sms_template_user_id->AdvancedSearch->load();
		$this->status_sms_office->AdvancedSearch->load();
		$this->sms_to_office->AdvancedSearch->load();
		$this->sms_template_office->AdvancedSearch->load();
		$this->sms_template_office_id->AdvancedSearch->load();
		$this->wa_status_user->AdvancedSearch->load();
		$this->wa_type_user->AdvancedSearch->load();
		$this->wa_template_user->AdvancedSearch->load();
		$this->wa_status_office->AdvancedSearch->load();
		$this->wa_type_office->AdvancedSearch->load();
		$this->wa_to_office->AdvancedSearch->load();
		$this->wa_template_office->AdvancedSearch->load();
		$this->wa_id->AdvancedSearch->load();
		$this->notification_status_user->AdvancedSearch->load();
		$this->notification_template_user->AdvancedSearch->load();
		$this->notification_status_office->AdvancedSearch->load();
		$this->notification_to_office->AdvancedSearch->load();
		$this->notification_template_office->AdvancedSearch->load();
		$this->code->AdvancedSearch->load();
		$this->visible->AdvancedSearch->load();
		$this->cron->AdvancedSearch->load();
		$this->next_cycle->AdvancedSearch->load();
		$this->delay->AdvancedSearch->load();
		$this->delay_method->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->operator_admin->AdvancedSearch->load();
		$this->datetime_admin->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("message_template_adminlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`id` > 1 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_wa_type_user":
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_wa_type_office":
					$lookupFilter = function() {
						return "`grp = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_notification_to_office":
					$lookupFilter = function() {
						return "`activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_wa_type_user":
							break;
						case "x_wa_type_office":
							break;
						case "x_wa_id":
							break;
						case "x_notification_to_office":
							break;
						case "x_company_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>