<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class message_template_office_edit extends message_template_office
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'message_template_office';

	// Page object name
	public $PageObjName = "message_template_office_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (message_template_office)
		if (!isset($GLOBALS["message_template_office"]) || get_class($GLOBALS["message_template_office"]) == PROJECT_NAMESPACE . "message_template_office") {
			$GLOBALS["message_template_office"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["message_template_office"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'message_template_office');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $message_template_office;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($message_template_office);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "message_template_officeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("message_template_officelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->description->setVisibility();
		$this->variables->setVisibility();
		$this->subject->setVisibility();
		$this->status_email_user->setVisibility();
		$this->email_template_user->setVisibility();
		$this->mail_to_office->setVisibility();
		$this->status_email_office->setVisibility();
		$this->email_template_office->setVisibility();
		$this->status_sms_user->setVisibility();
		$this->sms_template_user->setVisibility();
		$this->sms_template_user_id->setVisibility();
		$this->status_sms_office->setVisibility();
		$this->sms_to_office->setVisibility();
		$this->sms_template_office->setVisibility();
		$this->sms_template_office_id->setVisibility();
		$this->wa_status_user->setVisibility();
		$this->wa_type_user->setVisibility();
		$this->wa_template_user->setVisibility();
		$this->wa_status_office->setVisibility();
		$this->wa_type_office->setVisibility();
		$this->wa_to_office->setVisibility();
		$this->wa_template_office->setVisibility();
		$this->wa_id->setVisibility();
		$this->cron->setVisibility();
		$this->next_cycle->setVisibility();
		$this->delay->setVisibility();
		$this->delay_method->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->id->Required = FALSE;
		$this->variables->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->wa_type_user);
		$this->setupLookupOptions($this->wa_type_office);
		$this->setupLookupOptions($this->wa_id);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("message_template_officelist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "message_template_officelist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id->Visible = FALSE; // Disable update for API request
			else
				$this->id->setFormValue($val);
		}

		// Check field name 'description' first before field var 'x_description'
		$val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
		if (!$this->description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description->Visible = FALSE; // Disable update for API request
			else
				$this->description->setFormValue($val);
		}

		// Check field name 'variables' first before field var 'x_variables'
		$val = $CurrentForm->hasValue("variables") ? $CurrentForm->getValue("variables") : $CurrentForm->getValue("x_variables");
		if (!$this->variables->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->variables->Visible = FALSE; // Disable update for API request
			else
				$this->variables->setFormValue($val);
		}

		// Check field name 'subject' first before field var 'x_subject'
		$val = $CurrentForm->hasValue("subject") ? $CurrentForm->getValue("subject") : $CurrentForm->getValue("x_subject");
		if (!$this->subject->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->subject->Visible = FALSE; // Disable update for API request
			else
				$this->subject->setFormValue($val);
		}

		// Check field name 'status_email_user' first before field var 'x_status_email_user'
		$val = $CurrentForm->hasValue("status_email_user") ? $CurrentForm->getValue("status_email_user") : $CurrentForm->getValue("x_status_email_user");
		if (!$this->status_email_user->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_email_user->Visible = FALSE; // Disable update for API request
			else
				$this->status_email_user->setFormValue($val);
		}

		// Check field name 'email_template_user' first before field var 'x_email_template_user'
		$val = $CurrentForm->hasValue("email_template_user") ? $CurrentForm->getValue("email_template_user") : $CurrentForm->getValue("x_email_template_user");
		if (!$this->email_template_user->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->email_template_user->Visible = FALSE; // Disable update for API request
			else
				$this->email_template_user->setFormValue($val);
		}

		// Check field name 'mail_to_office' first before field var 'x_mail_to_office'
		$val = $CurrentForm->hasValue("mail_to_office") ? $CurrentForm->getValue("mail_to_office") : $CurrentForm->getValue("x_mail_to_office");
		if (!$this->mail_to_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mail_to_office->Visible = FALSE; // Disable update for API request
			else
				$this->mail_to_office->setFormValue($val);
		}

		// Check field name 'status_email_office' first before field var 'x_status_email_office'
		$val = $CurrentForm->hasValue("status_email_office") ? $CurrentForm->getValue("status_email_office") : $CurrentForm->getValue("x_status_email_office");
		if (!$this->status_email_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_email_office->Visible = FALSE; // Disable update for API request
			else
				$this->status_email_office->setFormValue($val);
		}

		// Check field name 'email_template_office' first before field var 'x_email_template_office'
		$val = $CurrentForm->hasValue("email_template_office") ? $CurrentForm->getValue("email_template_office") : $CurrentForm->getValue("x_email_template_office");
		if (!$this->email_template_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->email_template_office->Visible = FALSE; // Disable update for API request
			else
				$this->email_template_office->setFormValue($val);
		}

		// Check field name 'status_sms_user' first before field var 'x_status_sms_user'
		$val = $CurrentForm->hasValue("status_sms_user") ? $CurrentForm->getValue("status_sms_user") : $CurrentForm->getValue("x_status_sms_user");
		if (!$this->status_sms_user->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_sms_user->Visible = FALSE; // Disable update for API request
			else
				$this->status_sms_user->setFormValue($val);
		}

		// Check field name 'sms_template_user' first before field var 'x_sms_template_user'
		$val = $CurrentForm->hasValue("sms_template_user") ? $CurrentForm->getValue("sms_template_user") : $CurrentForm->getValue("x_sms_template_user");
		if (!$this->sms_template_user->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sms_template_user->Visible = FALSE; // Disable update for API request
			else
				$this->sms_template_user->setFormValue($val);
		}

		// Check field name 'sms_template_user_id' first before field var 'x_sms_template_user_id'
		$val = $CurrentForm->hasValue("sms_template_user_id") ? $CurrentForm->getValue("sms_template_user_id") : $CurrentForm->getValue("x_sms_template_user_id");
		if (!$this->sms_template_user_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sms_template_user_id->Visible = FALSE; // Disable update for API request
			else
				$this->sms_template_user_id->setFormValue($val);
		}

		// Check field name 'status_sms_office' first before field var 'x_status_sms_office'
		$val = $CurrentForm->hasValue("status_sms_office") ? $CurrentForm->getValue("status_sms_office") : $CurrentForm->getValue("x_status_sms_office");
		if (!$this->status_sms_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_sms_office->Visible = FALSE; // Disable update for API request
			else
				$this->status_sms_office->setFormValue($val);
		}

		// Check field name 'sms_to_office' first before field var 'x_sms_to_office'
		$val = $CurrentForm->hasValue("sms_to_office") ? $CurrentForm->getValue("sms_to_office") : $CurrentForm->getValue("x_sms_to_office");
		if (!$this->sms_to_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sms_to_office->Visible = FALSE; // Disable update for API request
			else
				$this->sms_to_office->setFormValue($val);
		}

		// Check field name 'sms_template_office' first before field var 'x_sms_template_office'
		$val = $CurrentForm->hasValue("sms_template_office") ? $CurrentForm->getValue("sms_template_office") : $CurrentForm->getValue("x_sms_template_office");
		if (!$this->sms_template_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sms_template_office->Visible = FALSE; // Disable update for API request
			else
				$this->sms_template_office->setFormValue($val);
		}

		// Check field name 'sms_template_office_id' first before field var 'x_sms_template_office_id'
		$val = $CurrentForm->hasValue("sms_template_office_id") ? $CurrentForm->getValue("sms_template_office_id") : $CurrentForm->getValue("x_sms_template_office_id");
		if (!$this->sms_template_office_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sms_template_office_id->Visible = FALSE; // Disable update for API request
			else
				$this->sms_template_office_id->setFormValue($val);
		}

		// Check field name 'wa_status_user' first before field var 'x_wa_status_user'
		$val = $CurrentForm->hasValue("wa_status_user") ? $CurrentForm->getValue("wa_status_user") : $CurrentForm->getValue("x_wa_status_user");
		if (!$this->wa_status_user->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_status_user->Visible = FALSE; // Disable update for API request
			else
				$this->wa_status_user->setFormValue($val);
		}

		// Check field name 'wa_type_user' first before field var 'x_wa_type_user'
		$val = $CurrentForm->hasValue("wa_type_user") ? $CurrentForm->getValue("wa_type_user") : $CurrentForm->getValue("x_wa_type_user");
		if (!$this->wa_type_user->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_type_user->Visible = FALSE; // Disable update for API request
			else
				$this->wa_type_user->setFormValue($val);
		}

		// Check field name 'wa_template_user' first before field var 'x_wa_template_user'
		$val = $CurrentForm->hasValue("wa_template_user") ? $CurrentForm->getValue("wa_template_user") : $CurrentForm->getValue("x_wa_template_user");
		if (!$this->wa_template_user->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_template_user->Visible = FALSE; // Disable update for API request
			else
				$this->wa_template_user->setFormValue($val);
		}

		// Check field name 'wa_status_office' first before field var 'x_wa_status_office'
		$val = $CurrentForm->hasValue("wa_status_office") ? $CurrentForm->getValue("wa_status_office") : $CurrentForm->getValue("x_wa_status_office");
		if (!$this->wa_status_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_status_office->Visible = FALSE; // Disable update for API request
			else
				$this->wa_status_office->setFormValue($val);
		}

		// Check field name 'wa_type_office' first before field var 'x_wa_type_office'
		$val = $CurrentForm->hasValue("wa_type_office") ? $CurrentForm->getValue("wa_type_office") : $CurrentForm->getValue("x_wa_type_office");
		if (!$this->wa_type_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_type_office->Visible = FALSE; // Disable update for API request
			else
				$this->wa_type_office->setFormValue($val);
		}

		// Check field name 'wa_to_office' first before field var 'x_wa_to_office'
		$val = $CurrentForm->hasValue("wa_to_office") ? $CurrentForm->getValue("wa_to_office") : $CurrentForm->getValue("x_wa_to_office");
		if (!$this->wa_to_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_to_office->Visible = FALSE; // Disable update for API request
			else
				$this->wa_to_office->setFormValue($val);
		}

		// Check field name 'wa_template_office' first before field var 'x_wa_template_office'
		$val = $CurrentForm->hasValue("wa_template_office") ? $CurrentForm->getValue("wa_template_office") : $CurrentForm->getValue("x_wa_template_office");
		if (!$this->wa_template_office->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_template_office->Visible = FALSE; // Disable update for API request
			else
				$this->wa_template_office->setFormValue($val);
		}

		// Check field name 'wa_id' first before field var 'x_wa_id'
		$val = $CurrentForm->hasValue("wa_id") ? $CurrentForm->getValue("wa_id") : $CurrentForm->getValue("x_wa_id");
		if (!$this->wa_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_id->Visible = FALSE; // Disable update for API request
			else
				$this->wa_id->setFormValue($val);
		}

		// Check field name 'cron' first before field var 'x_cron'
		$val = $CurrentForm->hasValue("cron") ? $CurrentForm->getValue("cron") : $CurrentForm->getValue("x_cron");
		if (!$this->cron->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cron->Visible = FALSE; // Disable update for API request
			else
				$this->cron->setFormValue($val);
		}

		// Check field name 'next_cycle' first before field var 'x_next_cycle'
		$val = $CurrentForm->hasValue("next_cycle") ? $CurrentForm->getValue("next_cycle") : $CurrentForm->getValue("x_next_cycle");
		if (!$this->next_cycle->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->next_cycle->Visible = FALSE; // Disable update for API request
			else
				$this->next_cycle->setFormValue($val);
			$this->next_cycle->CurrentValue = UnFormatDateTime($this->next_cycle->CurrentValue, 11);
		}

		// Check field name 'delay' first before field var 'x_delay'
		$val = $CurrentForm->hasValue("delay") ? $CurrentForm->getValue("delay") : $CurrentForm->getValue("x_delay");
		if (!$this->delay->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delay->Visible = FALSE; // Disable update for API request
			else
				$this->delay->setFormValue($val);
		}

		// Check field name 'delay_method' first before field var 'x_delay_method'
		$val = $CurrentForm->hasValue("delay_method") ? $CurrentForm->getValue("delay_method") : $CurrentForm->getValue("x_delay_method");
		if (!$this->delay_method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delay_method->Visible = FALSE; // Disable update for API request
			else
				$this->delay_method->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->description->CurrentValue = $this->description->FormValue;
		$this->variables->CurrentValue = $this->variables->FormValue;
		$this->subject->CurrentValue = $this->subject->FormValue;
		$this->status_email_user->CurrentValue = $this->status_email_user->FormValue;
		$this->email_template_user->CurrentValue = $this->email_template_user->FormValue;
		$this->mail_to_office->CurrentValue = $this->mail_to_office->FormValue;
		$this->status_email_office->CurrentValue = $this->status_email_office->FormValue;
		$this->email_template_office->CurrentValue = $this->email_template_office->FormValue;
		$this->status_sms_user->CurrentValue = $this->status_sms_user->FormValue;
		$this->sms_template_user->CurrentValue = $this->sms_template_user->FormValue;
		$this->sms_template_user_id->CurrentValue = $this->sms_template_user_id->FormValue;
		$this->status_sms_office->CurrentValue = $this->status_sms_office->FormValue;
		$this->sms_to_office->CurrentValue = $this->sms_to_office->FormValue;
		$this->sms_template_office->CurrentValue = $this->sms_template_office->FormValue;
		$this->sms_template_office_id->CurrentValue = $this->sms_template_office_id->FormValue;
		$this->wa_status_user->CurrentValue = $this->wa_status_user->FormValue;
		$this->wa_type_user->CurrentValue = $this->wa_type_user->FormValue;
		$this->wa_template_user->CurrentValue = $this->wa_template_user->FormValue;
		$this->wa_status_office->CurrentValue = $this->wa_status_office->FormValue;
		$this->wa_type_office->CurrentValue = $this->wa_type_office->FormValue;
		$this->wa_to_office->CurrentValue = $this->wa_to_office->FormValue;
		$this->wa_template_office->CurrentValue = $this->wa_template_office->FormValue;
		$this->wa_id->CurrentValue = $this->wa_id->FormValue;
		$this->cron->CurrentValue = $this->cron->FormValue;
		$this->next_cycle->CurrentValue = $this->next_cycle->FormValue;
		$this->next_cycle->CurrentValue = UnFormatDateTime($this->next_cycle->CurrentValue, 11);
		$this->delay->CurrentValue = $this->delay->FormValue;
		$this->delay_method->CurrentValue = $this->delay_method->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->description->setDbValue($row['description']);
		$this->variables->setDbValue($row['variables']);
		$this->subject->setDbValue($row['subject']);
		$this->status_email_user->setDbValue($row['status_email_user']);
		$this->email_template_user->setDbValue($row['email_template_user']);
		$this->mail_to_office->setDbValue($row['mail_to_office']);
		$this->status_email_office->setDbValue($row['status_email_office']);
		$this->email_template_office->setDbValue($row['email_template_office']);
		$this->status_sms_user->setDbValue($row['status_sms_user']);
		$this->sms_template_user->setDbValue($row['sms_template_user']);
		$this->sms_template_user_id->setDbValue($row['sms_template_user_id']);
		$this->status_sms_office->setDbValue($row['status_sms_office']);
		$this->sms_to_office->setDbValue($row['sms_to_office']);
		$this->sms_template_office->setDbValue($row['sms_template_office']);
		$this->sms_template_office_id->setDbValue($row['sms_template_office_id']);
		$this->wa_status_user->setDbValue($row['wa_status_user']);
		$this->wa_type_user->setDbValue($row['wa_type_user']);
		$this->wa_template_user->setDbValue($row['wa_template_user']);
		$this->wa_status_office->setDbValue($row['wa_status_office']);
		$this->wa_type_office->setDbValue($row['wa_type_office']);
		$this->wa_to_office->setDbValue($row['wa_to_office']);
		$this->wa_template_office->setDbValue($row['wa_template_office']);
		$this->wa_id->setDbValue($row['wa_id']);
		$this->cron->setDbValue($row['cron']);
		$this->next_cycle->setDbValue($row['next_cycle']);
		$this->delay->setDbValue($row['delay']);
		$this->delay_method->setDbValue($row['delay_method']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['description'] = NULL;
		$row['variables'] = NULL;
		$row['subject'] = NULL;
		$row['status_email_user'] = NULL;
		$row['email_template_user'] = NULL;
		$row['mail_to_office'] = NULL;
		$row['status_email_office'] = NULL;
		$row['email_template_office'] = NULL;
		$row['status_sms_user'] = NULL;
		$row['sms_template_user'] = NULL;
		$row['sms_template_user_id'] = NULL;
		$row['status_sms_office'] = NULL;
		$row['sms_to_office'] = NULL;
		$row['sms_template_office'] = NULL;
		$row['sms_template_office_id'] = NULL;
		$row['wa_status_user'] = NULL;
		$row['wa_type_user'] = NULL;
		$row['wa_template_user'] = NULL;
		$row['wa_status_office'] = NULL;
		$row['wa_type_office'] = NULL;
		$row['wa_to_office'] = NULL;
		$row['wa_template_office'] = NULL;
		$row['wa_id'] = NULL;
		$row['cron'] = NULL;
		$row['next_cycle'] = NULL;
		$row['delay'] = NULL;
		$row['delay_method'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// description
		// variables
		// subject
		// status_email_user
		// email_template_user
		// mail_to_office
		// status_email_office
		// email_template_office
		// status_sms_user
		// sms_template_user
		// sms_template_user_id
		// status_sms_office
		// sms_to_office
		// sms_template_office
		// sms_template_office_id
		// wa_status_user
		// wa_type_user
		// wa_template_user
		// wa_status_office
		// wa_type_office
		// wa_to_office
		// wa_template_office
		// wa_id
		// cron
		// next_cycle
		// delay
		// delay_method
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// variables
			$this->variables->ViewValue = $this->variables->CurrentValue;
			$this->variables->ViewCustomAttributes = "";

			// subject
			$this->subject->ViewValue = $this->subject->CurrentValue;
			$this->subject->ViewCustomAttributes = "";

			// status_email_user
			if (strval($this->status_email_user->CurrentValue) <> "") {
				$this->status_email_user->ViewValue = $this->status_email_user->optionCaption($this->status_email_user->CurrentValue);
			} else {
				$this->status_email_user->ViewValue = NULL;
			}
			$this->status_email_user->ViewCustomAttributes = "";

			// email_template_user
			$this->email_template_user->ViewValue = $this->email_template_user->CurrentValue;
			$this->email_template_user->ViewCustomAttributes = "";

			// mail_to_office
			$this->mail_to_office->ViewValue = $this->mail_to_office->CurrentValue;
			$this->mail_to_office->ViewCustomAttributes = "";

			// status_email_office
			if (strval($this->status_email_office->CurrentValue) <> "") {
				$this->status_email_office->ViewValue = $this->status_email_office->optionCaption($this->status_email_office->CurrentValue);
			} else {
				$this->status_email_office->ViewValue = NULL;
			}
			$this->status_email_office->ViewCustomAttributes = "";

			// email_template_office
			$this->email_template_office->ViewValue = $this->email_template_office->CurrentValue;
			$this->email_template_office->ViewCustomAttributes = "";

			// status_sms_user
			if (strval($this->status_sms_user->CurrentValue) <> "") {
				$this->status_sms_user->ViewValue = $this->status_sms_user->optionCaption($this->status_sms_user->CurrentValue);
			} else {
				$this->status_sms_user->ViewValue = NULL;
			}
			$this->status_sms_user->ViewCustomAttributes = "";

			// sms_template_user
			$this->sms_template_user->ViewValue = $this->sms_template_user->CurrentValue;
			$this->sms_template_user->ViewCustomAttributes = "";

			// sms_template_user_id
			$this->sms_template_user_id->ViewValue = $this->sms_template_user_id->CurrentValue;
			$this->sms_template_user_id->ViewCustomAttributes = "";

			// status_sms_office
			if (strval($this->status_sms_office->CurrentValue) <> "") {
				$this->status_sms_office->ViewValue = $this->status_sms_office->optionCaption($this->status_sms_office->CurrentValue);
			} else {
				$this->status_sms_office->ViewValue = NULL;
			}
			$this->status_sms_office->ViewCustomAttributes = "";

			// sms_to_office
			$this->sms_to_office->ViewValue = $this->sms_to_office->CurrentValue;
			$this->sms_to_office->ViewCustomAttributes = "";

			// sms_template_office
			$this->sms_template_office->ViewValue = $this->sms_template_office->CurrentValue;
			$this->sms_template_office->ViewCustomAttributes = "";

			// sms_template_office_id
			$this->sms_template_office_id->ViewValue = $this->sms_template_office_id->CurrentValue;
			$this->sms_template_office_id->ViewCustomAttributes = "";

			// wa_status_user
			if (strval($this->wa_status_user->CurrentValue) <> "") {
				$this->wa_status_user->ViewValue = $this->wa_status_user->optionCaption($this->wa_status_user->CurrentValue);
			} else {
				$this->wa_status_user->ViewValue = NULL;
			}
			$this->wa_status_user->ViewCustomAttributes = "";

			// wa_type_user
			$curVal = strval($this->wa_type_user->CurrentValue);
			if ($curVal <> "") {
				$this->wa_type_user->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
				if ($this->wa_type_user->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->wa_type_user->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_type_user->ViewValue = $this->wa_type_user->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_type_user->ViewValue = $this->wa_type_user->CurrentValue;
					}
				}
			} else {
				$this->wa_type_user->ViewValue = NULL;
			}
			$this->wa_type_user->ViewCustomAttributes = "";

			// wa_template_user
			$this->wa_template_user->ViewValue = $this->wa_template_user->CurrentValue;
			$this->wa_template_user->ViewCustomAttributes = "";

			// wa_status_office
			if (strval($this->wa_status_office->CurrentValue) <> "") {
				$this->wa_status_office->ViewValue = $this->wa_status_office->optionCaption($this->wa_status_office->CurrentValue);
			} else {
				$this->wa_status_office->ViewValue = NULL;
			}
			$this->wa_status_office->ViewCustomAttributes = "";

			// wa_type_office
			$curVal = strval($this->wa_type_office->CurrentValue);
			if ($curVal <> "") {
				$this->wa_type_office->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
				if ($this->wa_type_office->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->wa_type_office->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_type_office->ViewValue = $this->wa_type_office->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_type_office->ViewValue = $this->wa_type_office->CurrentValue;
					}
				}
			} else {
				$this->wa_type_office->ViewValue = NULL;
			}
			$this->wa_type_office->ViewCustomAttributes = "";

			// wa_to_office
			$this->wa_to_office->ViewValue = $this->wa_to_office->CurrentValue;
			$this->wa_to_office->ViewCustomAttributes = "";

			// wa_template_office
			$this->wa_template_office->ViewValue = $this->wa_template_office->CurrentValue;
			$this->wa_template_office->ViewCustomAttributes = "";

			// wa_id
			$curVal = strval($this->wa_id->CurrentValue);
			if ($curVal <> "") {
				$this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
				if ($this->wa_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->wa_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_id->ViewValue = $this->wa_id->CurrentValue;
					}
				}
			} else {
				$this->wa_id->ViewValue = NULL;
			}
			$this->wa_id->ViewCustomAttributes = "";

			// cron
			if (strval($this->cron->CurrentValue) <> "") {
				$this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
			} else {
				$this->cron->ViewValue = NULL;
			}
			$this->cron->ViewCustomAttributes = "";

			// next_cycle
			$this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
			$this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, 11);
			$this->next_cycle->ViewCustomAttributes = "";

			// delay
			$this->delay->ViewValue = $this->delay->CurrentValue;
			$this->delay->ViewValue = FormatNumber($this->delay->ViewValue, 0, -2, -2, -2);
			$this->delay->ViewCustomAttributes = "";

			// delay_method
			if (strval($this->delay_method->CurrentValue) <> "") {
				$this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
			} else {
				$this->delay_method->ViewValue = NULL;
			}
			$this->delay_method->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			if (!EmptyValue($this->id->CurrentValue)) {
				$this->description->HrefValue = "mailer_view.php?MTID=" . $this->id->CurrentValue; // Add prefix/suffix
				$this->description->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
			} else {
				$this->description->HrefValue = "";
			}
			$this->description->TooltipValue = "";

			// variables
			$this->variables->LinkCustomAttributes = "";
			$this->variables->HrefValue = "";
			$this->variables->TooltipValue = "";

			// subject
			$this->subject->LinkCustomAttributes = "";
			$this->subject->HrefValue = "";
			$this->subject->TooltipValue = "";

			// status_email_user
			$this->status_email_user->LinkCustomAttributes = "";
			$this->status_email_user->HrefValue = "";
			$this->status_email_user->TooltipValue = "";

			// email_template_user
			$this->email_template_user->LinkCustomAttributes = "";
			$this->email_template_user->HrefValue = "";
			$this->email_template_user->TooltipValue = "";

			// mail_to_office
			$this->mail_to_office->LinkCustomAttributes = "";
			$this->mail_to_office->HrefValue = "";
			$this->mail_to_office->TooltipValue = "";

			// status_email_office
			$this->status_email_office->LinkCustomAttributes = "";
			$this->status_email_office->HrefValue = "";
			$this->status_email_office->TooltipValue = "";

			// email_template_office
			$this->email_template_office->LinkCustomAttributes = "";
			$this->email_template_office->HrefValue = "";
			$this->email_template_office->TooltipValue = "";

			// status_sms_user
			$this->status_sms_user->LinkCustomAttributes = "";
			$this->status_sms_user->HrefValue = "";
			$this->status_sms_user->TooltipValue = "";

			// sms_template_user
			$this->sms_template_user->LinkCustomAttributes = "";
			$this->sms_template_user->HrefValue = "";
			$this->sms_template_user->TooltipValue = "";

			// sms_template_user_id
			$this->sms_template_user_id->LinkCustomAttributes = "";
			$this->sms_template_user_id->HrefValue = "";
			$this->sms_template_user_id->TooltipValue = "";

			// status_sms_office
			$this->status_sms_office->LinkCustomAttributes = "";
			$this->status_sms_office->HrefValue = "";
			$this->status_sms_office->TooltipValue = "";

			// sms_to_office
			$this->sms_to_office->LinkCustomAttributes = "";
			$this->sms_to_office->HrefValue = "";
			$this->sms_to_office->TooltipValue = "";

			// sms_template_office
			$this->sms_template_office->LinkCustomAttributes = "";
			$this->sms_template_office->HrefValue = "";
			$this->sms_template_office->TooltipValue = "";

			// sms_template_office_id
			$this->sms_template_office_id->LinkCustomAttributes = "";
			$this->sms_template_office_id->HrefValue = "";
			$this->sms_template_office_id->TooltipValue = "";

			// wa_status_user
			$this->wa_status_user->LinkCustomAttributes = "";
			$this->wa_status_user->HrefValue = "";
			$this->wa_status_user->TooltipValue = "";

			// wa_type_user
			$this->wa_type_user->LinkCustomAttributes = "";
			$this->wa_type_user->HrefValue = "";
			$this->wa_type_user->TooltipValue = "";

			// wa_template_user
			$this->wa_template_user->LinkCustomAttributes = "";
			$this->wa_template_user->HrefValue = "";
			$this->wa_template_user->TooltipValue = "";

			// wa_status_office
			$this->wa_status_office->LinkCustomAttributes = "";
			$this->wa_status_office->HrefValue = "";
			$this->wa_status_office->TooltipValue = "";

			// wa_type_office
			$this->wa_type_office->LinkCustomAttributes = "";
			$this->wa_type_office->HrefValue = "";
			$this->wa_type_office->TooltipValue = "";

			// wa_to_office
			$this->wa_to_office->LinkCustomAttributes = "";
			$this->wa_to_office->HrefValue = "";
			$this->wa_to_office->TooltipValue = "";

			// wa_template_office
			$this->wa_template_office->LinkCustomAttributes = "";
			$this->wa_template_office->HrefValue = "";
			$this->wa_template_office->TooltipValue = "";

			// wa_id
			$this->wa_id->LinkCustomAttributes = "";
			$this->wa_id->HrefValue = "";
			$this->wa_id->TooltipValue = "";

			// cron
			$this->cron->LinkCustomAttributes = "";
			$this->cron->HrefValue = "";
			$this->cron->TooltipValue = "";

			// next_cycle
			$this->next_cycle->LinkCustomAttributes = "";
			$this->next_cycle->HrefValue = "";
			$this->next_cycle->TooltipValue = "";

			// delay
			$this->delay->LinkCustomAttributes = "";
			$this->delay->HrefValue = "";
			$this->delay->TooltipValue = "";

			// delay_method
			$this->delay_method->LinkCustomAttributes = "";
			$this->delay_method->HrefValue = "";
			$this->delay_method->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
			$this->description->EditValue = HtmlEncode($this->description->CurrentValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// variables
			$this->variables->EditAttrs["class"] = "form-control";
			$this->variables->EditCustomAttributes = "";
			$this->variables->EditValue = $this->variables->CurrentValue;
			$this->variables->ViewCustomAttributes = "";

			// subject
			$this->subject->EditAttrs["class"] = "form-control";
			$this->subject->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->subject->CurrentValue = HtmlDecode($this->subject->CurrentValue);
			$this->subject->EditValue = HtmlEncode($this->subject->CurrentValue);
			$this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

			// status_email_user
			$this->status_email_user->EditAttrs["class"] = "form-control";
			$this->status_email_user->EditCustomAttributes = "";
			$this->status_email_user->EditValue = $this->status_email_user->options(TRUE);

			// email_template_user
			$this->email_template_user->EditAttrs["class"] = "form-control";
			$this->email_template_user->EditCustomAttributes = "";
			$this->email_template_user->EditValue = HtmlEncode($this->email_template_user->CurrentValue);
			$this->email_template_user->PlaceHolder = RemoveHtml($this->email_template_user->caption());

			// mail_to_office
			$this->mail_to_office->EditAttrs["class"] = "form-control";
			$this->mail_to_office->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mail_to_office->CurrentValue = HtmlDecode($this->mail_to_office->CurrentValue);
			$this->mail_to_office->EditValue = HtmlEncode($this->mail_to_office->CurrentValue);
			$this->mail_to_office->PlaceHolder = RemoveHtml($this->mail_to_office->caption());

			// status_email_office
			$this->status_email_office->EditAttrs["class"] = "form-control";
			$this->status_email_office->EditCustomAttributes = "";
			$this->status_email_office->EditValue = $this->status_email_office->options(TRUE);

			// email_template_office
			$this->email_template_office->EditAttrs["class"] = "form-control";
			$this->email_template_office->EditCustomAttributes = "";
			$this->email_template_office->EditValue = HtmlEncode($this->email_template_office->CurrentValue);
			$this->email_template_office->PlaceHolder = RemoveHtml($this->email_template_office->caption());

			// status_sms_user
			$this->status_sms_user->EditAttrs["class"] = "form-control";
			$this->status_sms_user->EditCustomAttributes = "";
			$this->status_sms_user->EditValue = $this->status_sms_user->options(TRUE);

			// sms_template_user
			$this->sms_template_user->EditAttrs["class"] = "form-control";
			$this->sms_template_user->EditCustomAttributes = "";
			$this->sms_template_user->EditValue = HtmlEncode($this->sms_template_user->CurrentValue);
			$this->sms_template_user->PlaceHolder = RemoveHtml($this->sms_template_user->caption());

			// sms_template_user_id
			$this->sms_template_user_id->EditAttrs["class"] = "form-control";
			$this->sms_template_user_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sms_template_user_id->CurrentValue = HtmlDecode($this->sms_template_user_id->CurrentValue);
			$this->sms_template_user_id->EditValue = HtmlEncode($this->sms_template_user_id->CurrentValue);
			$this->sms_template_user_id->PlaceHolder = RemoveHtml($this->sms_template_user_id->caption());

			// status_sms_office
			$this->status_sms_office->EditAttrs["class"] = "form-control";
			$this->status_sms_office->EditCustomAttributes = "";
			$this->status_sms_office->EditValue = $this->status_sms_office->options(TRUE);

			// sms_to_office
			$this->sms_to_office->EditAttrs["class"] = "form-control";
			$this->sms_to_office->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sms_to_office->CurrentValue = HtmlDecode($this->sms_to_office->CurrentValue);
			$this->sms_to_office->EditValue = HtmlEncode($this->sms_to_office->CurrentValue);
			$this->sms_to_office->PlaceHolder = RemoveHtml($this->sms_to_office->caption());

			// sms_template_office
			$this->sms_template_office->EditAttrs["class"] = "form-control";
			$this->sms_template_office->EditCustomAttributes = "";
			$this->sms_template_office->EditValue = HtmlEncode($this->sms_template_office->CurrentValue);
			$this->sms_template_office->PlaceHolder = RemoveHtml($this->sms_template_office->caption());

			// sms_template_office_id
			$this->sms_template_office_id->EditAttrs["class"] = "form-control";
			$this->sms_template_office_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sms_template_office_id->CurrentValue = HtmlDecode($this->sms_template_office_id->CurrentValue);
			$this->sms_template_office_id->EditValue = HtmlEncode($this->sms_template_office_id->CurrentValue);
			$this->sms_template_office_id->PlaceHolder = RemoveHtml($this->sms_template_office_id->caption());

			// wa_status_user
			$this->wa_status_user->EditAttrs["class"] = "form-control";
			$this->wa_status_user->EditCustomAttributes = "";
			$this->wa_status_user->EditValue = $this->wa_status_user->options(TRUE);

			// wa_type_user
			$this->wa_type_user->EditAttrs["class"] = "form-control";
			$this->wa_type_user->EditCustomAttributes = "";
			$curVal = strval($this->wa_type_user->CurrentValue);
			if ($curVal <> "") {
				$this->wa_type_user->EditValue = $this->wa_type_user->lookupCacheOption($curVal);
				if ($this->wa_type_user->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->wa_type_user->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_type_user->EditValue = $this->wa_type_user->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_type_user->EditValue = $this->wa_type_user->CurrentValue;
					}
				}
			} else {
				$this->wa_type_user->EditValue = NULL;
			}
			$this->wa_type_user->ViewCustomAttributes = "";

			// wa_template_user
			$this->wa_template_user->EditAttrs["class"] = "form-control";
			$this->wa_template_user->EditCustomAttributes = "";
			$this->wa_template_user->EditValue = HtmlEncode($this->wa_template_user->CurrentValue);
			$this->wa_template_user->PlaceHolder = RemoveHtml($this->wa_template_user->caption());

			// wa_status_office
			$this->wa_status_office->EditAttrs["class"] = "form-control";
			$this->wa_status_office->EditCustomAttributes = "";
			$this->wa_status_office->EditValue = $this->wa_status_office->options(TRUE);

			// wa_type_office
			$this->wa_type_office->EditAttrs["class"] = "form-control";
			$this->wa_type_office->EditCustomAttributes = "";
			$curVal = strval($this->wa_type_office->CurrentValue);
			if ($curVal <> "") {
				$this->wa_type_office->EditValue = $this->wa_type_office->lookupCacheOption($curVal);
				if ($this->wa_type_office->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->wa_type_office->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_type_office->EditValue = $this->wa_type_office->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_type_office->EditValue = $this->wa_type_office->CurrentValue;
					}
				}
			} else {
				$this->wa_type_office->EditValue = NULL;
			}
			$this->wa_type_office->ViewCustomAttributes = "";

			// wa_to_office
			$this->wa_to_office->EditAttrs["class"] = "form-control";
			$this->wa_to_office->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->wa_to_office->CurrentValue = HtmlDecode($this->wa_to_office->CurrentValue);
			$this->wa_to_office->EditValue = HtmlEncode($this->wa_to_office->CurrentValue);
			$this->wa_to_office->PlaceHolder = RemoveHtml($this->wa_to_office->caption());

			// wa_template_office
			$this->wa_template_office->EditAttrs["class"] = "form-control";
			$this->wa_template_office->EditCustomAttributes = "";
			$this->wa_template_office->EditValue = HtmlEncode($this->wa_template_office->CurrentValue);
			$this->wa_template_office->PlaceHolder = RemoveHtml($this->wa_template_office->caption());

			// wa_id
			$this->wa_id->EditAttrs["class"] = "form-control";
			$this->wa_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->wa_id->CurrentValue));
			if ($curVal <> "")
				$this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
			else
				$this->wa_id->ViewValue = $this->wa_id->Lookup !== NULL && is_array($this->wa_id->Lookup->Options) ? $curVal : NULL;
			if ($this->wa_id->ViewValue !== NULL) { // Load from cache
				$this->wa_id->EditValue = array_values($this->wa_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->wa_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->wa_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->wa_id->EditValue = $arwrk;
			}

			// cron
			$this->cron->EditAttrs["class"] = "form-control";
			$this->cron->EditCustomAttributes = "";
			$this->cron->EditValue = $this->cron->options(TRUE);

			// next_cycle
			$this->next_cycle->EditAttrs["class"] = "form-control";
			$this->next_cycle->EditCustomAttributes = "";
			$this->next_cycle->EditValue = HtmlEncode(FormatDateTime($this->next_cycle->CurrentValue, 11));
			$this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

			// delay
			$this->delay->EditAttrs["class"] = "form-control";
			$this->delay->EditCustomAttributes = "";
			$this->delay->EditValue = HtmlEncode($this->delay->CurrentValue);
			$this->delay->PlaceHolder = RemoveHtml($this->delay->caption());

			// delay_method
			$this->delay_method->EditAttrs["class"] = "form-control";
			$this->delay_method->EditCustomAttributes = "";
			$this->delay_method->EditValue = $this->delay_method->options(TRUE);

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			if (!EmptyValue($this->id->CurrentValue)) {
				$this->description->HrefValue = "mailer_view.php?MTID=" . $this->id->CurrentValue; // Add prefix/suffix
				$this->description->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
			} else {
				$this->description->HrefValue = "";
			}

			// variables
			$this->variables->LinkCustomAttributes = "";
			$this->variables->HrefValue = "";
			$this->variables->TooltipValue = "";

			// subject
			$this->subject->LinkCustomAttributes = "";
			$this->subject->HrefValue = "";

			// status_email_user
			$this->status_email_user->LinkCustomAttributes = "";
			$this->status_email_user->HrefValue = "";

			// email_template_user
			$this->email_template_user->LinkCustomAttributes = "";
			$this->email_template_user->HrefValue = "";

			// mail_to_office
			$this->mail_to_office->LinkCustomAttributes = "";
			$this->mail_to_office->HrefValue = "";

			// status_email_office
			$this->status_email_office->LinkCustomAttributes = "";
			$this->status_email_office->HrefValue = "";

			// email_template_office
			$this->email_template_office->LinkCustomAttributes = "";
			$this->email_template_office->HrefValue = "";

			// status_sms_user
			$this->status_sms_user->LinkCustomAttributes = "";
			$this->status_sms_user->HrefValue = "";

			// sms_template_user
			$this->sms_template_user->LinkCustomAttributes = "";
			$this->sms_template_user->HrefValue = "";

			// sms_template_user_id
			$this->sms_template_user_id->LinkCustomAttributes = "";
			$this->sms_template_user_id->HrefValue = "";

			// status_sms_office
			$this->status_sms_office->LinkCustomAttributes = "";
			$this->status_sms_office->HrefValue = "";

			// sms_to_office
			$this->sms_to_office->LinkCustomAttributes = "";
			$this->sms_to_office->HrefValue = "";

			// sms_template_office
			$this->sms_template_office->LinkCustomAttributes = "";
			$this->sms_template_office->HrefValue = "";

			// sms_template_office_id
			$this->sms_template_office_id->LinkCustomAttributes = "";
			$this->sms_template_office_id->HrefValue = "";

			// wa_status_user
			$this->wa_status_user->LinkCustomAttributes = "";
			$this->wa_status_user->HrefValue = "";

			// wa_type_user
			$this->wa_type_user->LinkCustomAttributes = "";
			$this->wa_type_user->HrefValue = "";
			$this->wa_type_user->TooltipValue = "";

			// wa_template_user
			$this->wa_template_user->LinkCustomAttributes = "";
			$this->wa_template_user->HrefValue = "";

			// wa_status_office
			$this->wa_status_office->LinkCustomAttributes = "";
			$this->wa_status_office->HrefValue = "";

			// wa_type_office
			$this->wa_type_office->LinkCustomAttributes = "";
			$this->wa_type_office->HrefValue = "";
			$this->wa_type_office->TooltipValue = "";

			// wa_to_office
			$this->wa_to_office->LinkCustomAttributes = "";
			$this->wa_to_office->HrefValue = "";

			// wa_template_office
			$this->wa_template_office->LinkCustomAttributes = "";
			$this->wa_template_office->HrefValue = "";

			// wa_id
			$this->wa_id->LinkCustomAttributes = "";
			$this->wa_id->HrefValue = "";

			// cron
			$this->cron->LinkCustomAttributes = "";
			$this->cron->HrefValue = "";

			// next_cycle
			$this->next_cycle->LinkCustomAttributes = "";
			$this->next_cycle->HrefValue = "";

			// delay
			$this->delay->LinkCustomAttributes = "";
			$this->delay->HrefValue = "";

			// delay_method
			$this->delay_method->LinkCustomAttributes = "";
			$this->delay_method->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->description->Required) {
			if (!$this->description->IsDetailKey && $this->description->FormValue != NULL && $this->description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
			}
		}
		if ($this->variables->Required) {
			if (!$this->variables->IsDetailKey && $this->variables->FormValue != NULL && $this->variables->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->variables->caption(), $this->variables->RequiredErrorMessage));
			}
		}
		if ($this->subject->Required) {
			if (!$this->subject->IsDetailKey && $this->subject->FormValue != NULL && $this->subject->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->subject->caption(), $this->subject->RequiredErrorMessage));
			}
		}
		if ($this->status_email_user->Required) {
			if (!$this->status_email_user->IsDetailKey && $this->status_email_user->FormValue != NULL && $this->status_email_user->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_email_user->caption(), $this->status_email_user->RequiredErrorMessage));
			}
		}
		if ($this->email_template_user->Required) {
			if (!$this->email_template_user->IsDetailKey && $this->email_template_user->FormValue != NULL && $this->email_template_user->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->email_template_user->caption(), $this->email_template_user->RequiredErrorMessage));
			}
		}
		if ($this->mail_to_office->Required) {
			if (!$this->mail_to_office->IsDetailKey && $this->mail_to_office->FormValue != NULL && $this->mail_to_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mail_to_office->caption(), $this->mail_to_office->RequiredErrorMessage));
			}
		}
		if ($this->status_email_office->Required) {
			if (!$this->status_email_office->IsDetailKey && $this->status_email_office->FormValue != NULL && $this->status_email_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_email_office->caption(), $this->status_email_office->RequiredErrorMessage));
			}
		}
		if ($this->email_template_office->Required) {
			if (!$this->email_template_office->IsDetailKey && $this->email_template_office->FormValue != NULL && $this->email_template_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->email_template_office->caption(), $this->email_template_office->RequiredErrorMessage));
			}
		}
		if ($this->status_sms_user->Required) {
			if (!$this->status_sms_user->IsDetailKey && $this->status_sms_user->FormValue != NULL && $this->status_sms_user->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_sms_user->caption(), $this->status_sms_user->RequiredErrorMessage));
			}
		}
		if ($this->sms_template_user->Required) {
			if (!$this->sms_template_user->IsDetailKey && $this->sms_template_user->FormValue != NULL && $this->sms_template_user->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sms_template_user->caption(), $this->sms_template_user->RequiredErrorMessage));
			}
		}
		if ($this->sms_template_user_id->Required) {
			if (!$this->sms_template_user_id->IsDetailKey && $this->sms_template_user_id->FormValue != NULL && $this->sms_template_user_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sms_template_user_id->caption(), $this->sms_template_user_id->RequiredErrorMessage));
			}
		}
		if ($this->status_sms_office->Required) {
			if (!$this->status_sms_office->IsDetailKey && $this->status_sms_office->FormValue != NULL && $this->status_sms_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_sms_office->caption(), $this->status_sms_office->RequiredErrorMessage));
			}
		}
		if ($this->sms_to_office->Required) {
			if (!$this->sms_to_office->IsDetailKey && $this->sms_to_office->FormValue != NULL && $this->sms_to_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sms_to_office->caption(), $this->sms_to_office->RequiredErrorMessage));
			}
		}
		if ($this->sms_template_office->Required) {
			if (!$this->sms_template_office->IsDetailKey && $this->sms_template_office->FormValue != NULL && $this->sms_template_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sms_template_office->caption(), $this->sms_template_office->RequiredErrorMessage));
			}
		}
		if ($this->sms_template_office_id->Required) {
			if (!$this->sms_template_office_id->IsDetailKey && $this->sms_template_office_id->FormValue != NULL && $this->sms_template_office_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sms_template_office_id->caption(), $this->sms_template_office_id->RequiredErrorMessage));
			}
		}
		if ($this->wa_status_user->Required) {
			if (!$this->wa_status_user->IsDetailKey && $this->wa_status_user->FormValue != NULL && $this->wa_status_user->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_status_user->caption(), $this->wa_status_user->RequiredErrorMessage));
			}
		}
		if ($this->wa_type_user->Required) {
			if (!$this->wa_type_user->IsDetailKey && $this->wa_type_user->FormValue != NULL && $this->wa_type_user->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_type_user->caption(), $this->wa_type_user->RequiredErrorMessage));
			}
		}
		if ($this->wa_template_user->Required) {
			if (!$this->wa_template_user->IsDetailKey && $this->wa_template_user->FormValue != NULL && $this->wa_template_user->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_template_user->caption(), $this->wa_template_user->RequiredErrorMessage));
			}
		}
		if ($this->wa_status_office->Required) {
			if (!$this->wa_status_office->IsDetailKey && $this->wa_status_office->FormValue != NULL && $this->wa_status_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_status_office->caption(), $this->wa_status_office->RequiredErrorMessage));
			}
		}
		if ($this->wa_type_office->Required) {
			if (!$this->wa_type_office->IsDetailKey && $this->wa_type_office->FormValue != NULL && $this->wa_type_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_type_office->caption(), $this->wa_type_office->RequiredErrorMessage));
			}
		}
		if ($this->wa_to_office->Required) {
			if (!$this->wa_to_office->IsDetailKey && $this->wa_to_office->FormValue != NULL && $this->wa_to_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_to_office->caption(), $this->wa_to_office->RequiredErrorMessage));
			}
		}
		if ($this->wa_template_office->Required) {
			if (!$this->wa_template_office->IsDetailKey && $this->wa_template_office->FormValue != NULL && $this->wa_template_office->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_template_office->caption(), $this->wa_template_office->RequiredErrorMessage));
			}
		}
		if ($this->wa_id->Required) {
			if (!$this->wa_id->IsDetailKey && $this->wa_id->FormValue != NULL && $this->wa_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_id->caption(), $this->wa_id->RequiredErrorMessage));
			}
		}
		if ($this->cron->Required) {
			if (!$this->cron->IsDetailKey && $this->cron->FormValue != NULL && $this->cron->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cron->caption(), $this->cron->RequiredErrorMessage));
			}
		}
		if ($this->next_cycle->Required) {
			if (!$this->next_cycle->IsDetailKey && $this->next_cycle->FormValue != NULL && $this->next_cycle->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->next_cycle->caption(), $this->next_cycle->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->next_cycle->FormValue)) {
			AddMessage($FormError, $this->next_cycle->errorMessage());
		}
		if ($this->delay->Required) {
			if (!$this->delay->IsDetailKey && $this->delay->FormValue != NULL && $this->delay->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delay->caption(), $this->delay->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->delay->FormValue)) {
			AddMessage($FormError, $this->delay->errorMessage());
		}
		if ($this->delay_method->Required) {
			if (!$this->delay_method->IsDetailKey && $this->delay_method->FormValue != NULL && $this->delay_method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delay_method->caption(), $this->delay_method->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// description
			$this->description->setDbValueDef($rsnew, $this->description->CurrentValue, "", $this->description->ReadOnly);

			// subject
			$this->subject->setDbValueDef($rsnew, $this->subject->CurrentValue, "", $this->subject->ReadOnly);

			// status_email_user
			$this->status_email_user->setDbValueDef($rsnew, $this->status_email_user->CurrentValue, 0, $this->status_email_user->ReadOnly);

			// email_template_user
			$this->email_template_user->setDbValueDef($rsnew, $this->email_template_user->CurrentValue, NULL, $this->email_template_user->ReadOnly);

			// mail_to_office
			$this->mail_to_office->setDbValueDef($rsnew, $this->mail_to_office->CurrentValue, NULL, $this->mail_to_office->ReadOnly);

			// status_email_office
			$this->status_email_office->setDbValueDef($rsnew, $this->status_email_office->CurrentValue, 0, $this->status_email_office->ReadOnly);

			// email_template_office
			$this->email_template_office->setDbValueDef($rsnew, $this->email_template_office->CurrentValue, NULL, $this->email_template_office->ReadOnly);

			// status_sms_user
			$this->status_sms_user->setDbValueDef($rsnew, $this->status_sms_user->CurrentValue, 0, $this->status_sms_user->ReadOnly);

			// sms_template_user
			$this->sms_template_user->setDbValueDef($rsnew, $this->sms_template_user->CurrentValue, NULL, $this->sms_template_user->ReadOnly);

			// sms_template_user_id
			$this->sms_template_user_id->setDbValueDef($rsnew, $this->sms_template_user_id->CurrentValue, NULL, $this->sms_template_user_id->ReadOnly);

			// status_sms_office
			$this->status_sms_office->setDbValueDef($rsnew, $this->status_sms_office->CurrentValue, 0, $this->status_sms_office->ReadOnly);

			// sms_to_office
			$this->sms_to_office->setDbValueDef($rsnew, $this->sms_to_office->CurrentValue, NULL, $this->sms_to_office->ReadOnly);

			// sms_template_office
			$this->sms_template_office->setDbValueDef($rsnew, $this->sms_template_office->CurrentValue, NULL, $this->sms_template_office->ReadOnly);

			// sms_template_office_id
			$this->sms_template_office_id->setDbValueDef($rsnew, $this->sms_template_office_id->CurrentValue, NULL, $this->sms_template_office_id->ReadOnly);

			// wa_status_user
			$this->wa_status_user->setDbValueDef($rsnew, $this->wa_status_user->CurrentValue, 0, $this->wa_status_user->ReadOnly);

			// wa_template_user
			$this->wa_template_user->setDbValueDef($rsnew, $this->wa_template_user->CurrentValue, NULL, $this->wa_template_user->ReadOnly);

			// wa_status_office
			$this->wa_status_office->setDbValueDef($rsnew, $this->wa_status_office->CurrentValue, NULL, $this->wa_status_office->ReadOnly);

			// wa_to_office
			$this->wa_to_office->setDbValueDef($rsnew, $this->wa_to_office->CurrentValue, NULL, $this->wa_to_office->ReadOnly);

			// wa_template_office
			$this->wa_template_office->setDbValueDef($rsnew, $this->wa_template_office->CurrentValue, NULL, $this->wa_template_office->ReadOnly);

			// wa_id
			$this->wa_id->setDbValueDef($rsnew, $this->wa_id->CurrentValue, 0, $this->wa_id->ReadOnly);

			// cron
			$this->cron->setDbValueDef($rsnew, $this->cron->CurrentValue, 0, $this->cron->ReadOnly);

			// next_cycle
			$this->next_cycle->setDbValueDef($rsnew, UnFormatDateTime($this->next_cycle->CurrentValue, 11), CurrentDate(), $this->next_cycle->ReadOnly);

			// delay
			$this->delay->setDbValueDef($rsnew, $this->delay->CurrentValue, 0, $this->delay->ReadOnly);

			// delay_method
			$this->delay_method->setDbValueDef($rsnew, $this->delay_method->CurrentValue, 0, $this->delay_method->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("message_template_officelist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_wa_type_user":
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_wa_type_office":
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_wa_type_user":
							break;
						case "x_wa_type_office":
							break;
						case "x_wa_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>