<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for multiple_price
 */
class multiple_price extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $company_id;
	public $buyer;
	public $buyer_1;
	public $buyer_id;
	public $grp;
	public $product;
	public $code;
	public $packing_type;
	public $level;
	public $min_qty;
	public $max_qty;
	public $increment;
	public $price_min_qty;
	public $currency;
	public $operator;
	public $datetime;
	public $s_grp;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'multiple_price';
		$this->TableName = 'multiple_price';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`multiple_price`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('multiple_price', 'multiple_price', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// company_id
		$this->company_id = new DbField('multiple_price', 'multiple_price', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 3, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Nullable = FALSE; // NOT NULL field
		$this->company_id->Required = TRUE; // Required field
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'production_partner', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// buyer
		$this->buyer = new DbField('multiple_price', 'multiple_price', 'x_buyer', 'buyer', '0', '0', 20, -1, FALSE, '0', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->buyer->IsCustom = TRUE; // Custom field
		$this->buyer->Sortable = TRUE; // Allow sort
		$this->buyer->Lookup = new Lookup('buyer', 'multiple_price', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->buyer->OptionCount = 2;
		$this->buyer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer'] = &$this->buyer;

		// buyer_1
		$this->buyer_1 = new DbField('multiple_price', 'multiple_price', 'x_buyer_1', 'buyer_1', '\'\'', '\'\'', 201, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->buyer_1->IsCustom = TRUE; // Custom field
		$this->buyer_1->Sortable = TRUE; // Allow sort
		$this->buyer_1->Lookup = new Lookup('buyer_1', 'buyer', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['buyer_1'] = &$this->buyer_1;

		// buyer_id
		$this->buyer_id = new DbField('multiple_price', 'multiple_price', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 201, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_id->Nullable = FALSE; // NOT NULL field
		$this->buyer_id->Required = TRUE; // Required field
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->fields['buyer_id'] = &$this->buyer_id;

		// grp
		$this->grp = new DbField('multiple_price', 'multiple_price', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_product","x_packing_type","x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// product
		$this->product = new DbField('multiple_price', 'multiple_price', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', '_product_view', FALSE, 'id', ["product","","",""], ["x_grp"], ["x_code"], ["grp"], ["x_grp"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// code
		$this->code = new DbField('multiple_price', 'multiple_price', 'x_code', 'code', '`code`', '`code`', 21, -1, FALSE, '`EV__code`', TRUE, TRUE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->code->IsForeignKey = TRUE; // Foreign key field
		$this->code->Nullable = FALSE; // NOT NULL field
		$this->code->Required = TRUE; // Required field
		$this->code->Sortable = TRUE; // Allow sort
		$this->code->Lookup = new Lookup('code', 'ref', TRUE, 'id', ["product_code","","",""], ["x_product"], [], ["product"], ["x_product"], [], [], '`product_code` ASC', '');
		$this->code->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['code'] = &$this->code;

		// packing_type
		$this->packing_type = new DbField('multiple_price', 'multiple_price', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 2, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', TRUE, 'id', ["code","packing","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// level
		$this->level = new DbField('multiple_price', 'multiple_price', 'x_level', 'level', '`level`', '`level`', 16, -1, FALSE, '`level`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->level->Nullable = FALSE; // NOT NULL field
		$this->level->Required = TRUE; // Required field
		$this->level->Sortable = TRUE; // Allow sort
		$this->level->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->level->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->level->Lookup = new Lookup('level', 'multiple_price', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->level->OptionCount = 4;
		$this->level->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['level'] = &$this->level;

		// min_qty
		$this->min_qty = new DbField('multiple_price', 'multiple_price', 'x_min_qty', 'min_qty', '`min_qty`', '`min_qty`', 19, -1, FALSE, '`min_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->min_qty->Nullable = FALSE; // NOT NULL field
		$this->min_qty->Required = TRUE; // Required field
		$this->min_qty->Sortable = TRUE; // Allow sort
		$this->min_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['min_qty'] = &$this->min_qty;

		// max_qty
		$this->max_qty = new DbField('multiple_price', 'multiple_price', 'x_max_qty', 'max_qty', '`max_qty`', '`max_qty`', 19, -1, FALSE, '`max_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->max_qty->Nullable = FALSE; // NOT NULL field
		$this->max_qty->Required = TRUE; // Required field
		$this->max_qty->Sortable = TRUE; // Allow sort
		$this->max_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['max_qty'] = &$this->max_qty;

		// increment
		$this->increment = new DbField('multiple_price', 'multiple_price', 'x_increment', 'increment', '`increment`', '`increment`', 18, -1, FALSE, '`increment`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->increment->Nullable = FALSE; // NOT NULL field
		$this->increment->Required = TRUE; // Required field
		$this->increment->Sortable = TRUE; // Allow sort
		$this->increment->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['increment'] = &$this->increment;

		// price_min_qty
		$this->price_min_qty = new DbField('multiple_price', 'multiple_price', 'x_price_min_qty', 'price_min_qty', '`price_min_qty`', '`price_min_qty`', 131, -1, FALSE, '`price_min_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price_min_qty->Nullable = FALSE; // NOT NULL field
		$this->price_min_qty->Required = TRUE; // Required field
		$this->price_min_qty->Sortable = TRUE; // Allow sort
		$this->price_min_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price_min_qty'] = &$this->price_min_qty;

		// currency
		$this->currency = new DbField('multiple_price', 'multiple_price', 'x_currency', 'currency', '`currency`', '`currency`', 18, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Nullable = FALSE; // NOT NULL field
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// operator
		$this->operator = new DbField('multiple_price', 'multiple_price', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('multiple_price', 'multiple_price', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// s_grp
		$this->s_grp = new DbField('multiple_price', 'multiple_price', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "ref") {
			if ($this->code->getSessionValue() <> "")
				$masterFilter .= "`id`=" . QuotedValue($this->code->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "ref") {
			if ($this->code->getSessionValue() <> "")
				$detailFilter .= "`code`=" . QuotedValue($this->code->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_ref()
	{
		return "`id`=@id@";
	}

	// Detail filter
	public function sqlDetailFilter_ref()
	{
		return "`code`=@code@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`multiple_price`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, 0 AS `buyer`, '' AS `buyer_1` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, 0 AS `buyer`, '' AS `buyer_1`, (SELECT DISTINCT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `multiple_price`.`code` LIMIT 1) AS `EV__code` FROM `multiple_price`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if (ContainsString($orderBy, " " . $this->code->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->company_id->DbValue = $row['company_id'];
		$this->buyer->DbValue = $row['buyer'];
		$this->buyer_1->DbValue = $row['buyer_1'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->grp->DbValue = $row['grp'];
		$this->product->DbValue = $row['product'];
		$this->code->DbValue = $row['code'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->level->DbValue = $row['level'];
		$this->min_qty->DbValue = $row['min_qty'];
		$this->max_qty->DbValue = $row['max_qty'];
		$this->increment->DbValue = $row['increment'];
		$this->price_min_qty->DbValue = $row['price_min_qty'];
		$this->currency->DbValue = $row['currency'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->s_grp->DbValue = $row['s_grp'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "multiple_pricelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "multiple_priceview.php")
			return $Language->phrase("View");
		elseif ($pageName == "multiple_priceedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "multiple_priceadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "multiple_pricelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("multiple_priceview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("multiple_priceview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "multiple_priceadd.php?" . $this->getUrlParm($parm);
		else
			$url = "multiple_priceadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("multiple_priceedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("multiple_priceadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("multiple_pricedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "ref" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_id=" . urlencode($this->code->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->buyer->setDbValue($rs->fields('buyer'));
		$this->buyer_1->setDbValue($rs->fields('buyer_1'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->code->setDbValue($rs->fields('code'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->level->setDbValue($rs->fields('level'));
		$this->min_qty->setDbValue($rs->fields('min_qty'));
		$this->max_qty->setDbValue($rs->fields('max_qty'));
		$this->increment->setDbValue($rs->fields('increment'));
		$this->price_min_qty->setDbValue($rs->fields('price_min_qty'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// company_id
		// buyer
		// buyer_1
		// buyer_id
		// grp
		// product
		// code
		// packing_type
		// level
		// min_qty
		// max_qty
		// increment
		// price_min_qty
		// currency
		// operator
		// datetime
		// s_grp

		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// buyer
		if (strval($this->buyer->CurrentValue) <> "") {
			$this->buyer->ViewValue = $this->buyer->optionCaption($this->buyer->CurrentValue);
		} else {
			$this->buyer->ViewValue = NULL;
		}
		$this->buyer->ViewCustomAttributes = "";

		// buyer_1
		$curVal = strval($this->buyer_1->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_1->ViewValue = $this->buyer_1->lookupCacheOption($curVal);
			if ($this->buyer_1->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `id` > 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->buyer_1->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_1->ViewValue->add($this->buyer_1->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->buyer_1->ViewValue = $this->buyer_1->CurrentValue;
				}
			}
		} else {
			$this->buyer_1->ViewValue = NULL;
		}
		$this->buyer_1->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
		$this->buyer_id->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// code
		if ($this->code->VirtualValue <> "") {
			$this->code->ViewValue = $this->code->VirtualValue;
		} else {
		$curVal = strval($this->code->CurrentValue);
		if ($curVal <> "") {
			$this->code->ViewValue = $this->code->lookupCacheOption($curVal);
			if ($this->code->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `product_type` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->code->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->code->ViewValue = $this->code->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->code->ViewValue = $this->code->CurrentValue;
				}
			}
		} else {
			$this->code->ViewValue = NULL;
		}
		}
		$this->code->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// level
		if (strval($this->level->CurrentValue) <> "") {
			$this->level->ViewValue = $this->level->optionCaption($this->level->CurrentValue);
		} else {
			$this->level->ViewValue = NULL;
		}
		$this->level->ViewCustomAttributes = "";

		// min_qty
		$this->min_qty->ViewValue = $this->min_qty->CurrentValue;
		$this->min_qty->ViewValue = FormatNumber($this->min_qty->ViewValue, 0, -2, -2, -2);
		$this->min_qty->ViewCustomAttributes = "";

		// max_qty
		$this->max_qty->ViewValue = $this->max_qty->CurrentValue;
		$this->max_qty->ViewValue = FormatNumber($this->max_qty->ViewValue, 0, -2, -2, -2);
		$this->max_qty->ViewCustomAttributes = "";

		// increment
		$this->increment->ViewValue = $this->increment->CurrentValue;
		$this->increment->ViewValue = FormatNumber($this->increment->ViewValue, 0, -2, -2, -2);
		$this->increment->ViewCustomAttributes = "";

		// price_min_qty
		$this->price_min_qty->ViewValue = $this->price_min_qty->CurrentValue;
		$this->price_min_qty->ViewValue = FormatNumber($this->price_min_qty->ViewValue, 2, -2, -2, -2);
		$this->price_min_qty->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// buyer
		$this->buyer->LinkCustomAttributes = "";
		$this->buyer->HrefValue = "";
		$this->buyer->TooltipValue = "";

		// buyer_1
		$this->buyer_1->LinkCustomAttributes = "";
		$this->buyer_1->HrefValue = "";
		$this->buyer_1->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		$this->buyer_id->HrefValue = "";
		$this->buyer_id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "multiple_pricelist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "multiple_pricelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		if (!EmptyValue($this->code->CurrentValue)) {
			$this->code->HrefValue = "multiple_pricelist.php?x_code=" . $this->code->CurrentValue; // Add prefix/suffix
			$this->code->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
		} else {
			$this->code->HrefValue = "";
		}
		$this->code->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// level
		$this->level->LinkCustomAttributes = "";
		if (!EmptyValue($this->level->CurrentValue)) {
			$this->level->HrefValue = "multiple_pricelist.php?x_level=" . $this->level->CurrentValue; // Add prefix/suffix
			$this->level->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->level->HrefValue = FullUrl($this->level->HrefValue, "href");
		} else {
			$this->level->HrefValue = "";
		}
		$this->level->TooltipValue = "";

		// min_qty
		$this->min_qty->LinkCustomAttributes = "";
		$this->min_qty->HrefValue = "";
		$this->min_qty->TooltipValue = "";

		// max_qty
		$this->max_qty->LinkCustomAttributes = "";
		$this->max_qty->HrefValue = "";
		$this->max_qty->TooltipValue = "";

		// increment
		$this->increment->LinkCustomAttributes = "";
		$this->increment->HrefValue = "";
		$this->increment->TooltipValue = "";

		// price_min_qty
		$this->price_min_qty->LinkCustomAttributes = "";
		$this->price_min_qty->HrefValue = "";
		$this->price_min_qty->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		if (!EmptyValue($this->operator->CurrentValue)) {
			$this->operator->HrefValue = "multiple_pricelist.php?x_operator=" . $this->operator->CurrentValue; // Add prefix/suffix
			$this->operator->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
		} else {
			$this->operator->HrefValue = "";
		}
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// buyer
		$this->buyer->EditCustomAttributes = "";
		$this->buyer->EditValue = $this->buyer->options(FALSE);

		// buyer_1
		$this->buyer_1->EditCustomAttributes = "";

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = 'ReadOnly';
		if (REMOVE_XSS)
			$this->buyer_id->CurrentValue = HtmlDecode($this->buyer_id->CurrentValue);
		$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
		$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// code
		$this->code->EditCustomAttributes = "";
		if ($this->code->getSessionValue() <> "") {
			$this->code->CurrentValue = $this->code->getSessionValue();
		if ($this->code->VirtualValue <> "") {
			$this->code->ViewValue = $this->code->VirtualValue;
		} else {
		$curVal = strval($this->code->CurrentValue);
		if ($curVal <> "") {
			$this->code->ViewValue = $this->code->lookupCacheOption($curVal);
			if ($this->code->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `product_type` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->code->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->code->ViewValue = $this->code->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->code->ViewValue = $this->code->CurrentValue;
				}
			}
		} else {
			$this->code->ViewValue = NULL;
		}
		}
		$this->code->ViewCustomAttributes = "";
		} else {
		}

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// level
		$this->level->EditAttrs["class"] = "form-control";
		$this->level->EditCustomAttributes = "";
		$this->level->EditValue = $this->level->options(TRUE);

		// min_qty
		$this->min_qty->EditAttrs["class"] = "form-control";
		$this->min_qty->EditCustomAttributes = "";
		$this->min_qty->EditValue = $this->min_qty->CurrentValue;
		$this->min_qty->PlaceHolder = RemoveHtml($this->min_qty->caption());

		// max_qty
		$this->max_qty->EditAttrs["class"] = "form-control";
		$this->max_qty->EditCustomAttributes = "";
		$this->max_qty->EditValue = $this->max_qty->CurrentValue;
		$this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());

		// increment
		$this->increment->EditAttrs["class"] = "form-control";
		$this->increment->EditCustomAttributes = "";
		$this->increment->EditValue = $this->increment->CurrentValue;
		$this->increment->PlaceHolder = RemoveHtml($this->increment->caption());

		// price_min_qty
		$this->price_min_qty->EditAttrs["class"] = "form-control";
		$this->price_min_qty->EditCustomAttributes = "";
		$this->price_min_qty->EditValue = $this->price_min_qty->CurrentValue;
		$this->price_min_qty->PlaceHolder = RemoveHtml($this->price_min_qty->caption());
		if (strval($this->price_min_qty->EditValue) <> "" && is_numeric($this->price_min_qty->EditValue))
			$this->price_min_qty->EditValue = FormatNumber($this->price_min_qty->EditValue, -2, -2, -2, -2);

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";

		// operator
		// datetime
		// s_grp

		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->buyer_1);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->level);
					$doc->exportCaption($this->min_qty);
					$doc->exportCaption($this->max_qty);
					$doc->exportCaption($this->increment);
					$doc->exportCaption($this->price_min_qty);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->level);
					$doc->exportCaption($this->min_qty);
					$doc->exportCaption($this->max_qty);
					$doc->exportCaption($this->increment);
					$doc->exportCaption($this->price_min_qty);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->buyer);
						$doc->exportField($this->buyer_1);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->grp);
						$doc->exportField($this->product);
						$doc->exportField($this->code);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->level);
						$doc->exportField($this->min_qty);
						$doc->exportField($this->max_qty);
						$doc->exportField($this->increment);
						$doc->exportField($this->price_min_qty);
						$doc->exportField($this->currency);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->buyer);
						$doc->exportField($this->grp);
						$doc->exportField($this->product);
						$doc->exportField($this->code);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->level);
						$doc->exportField($this->min_qty);
						$doc->exportField($this->max_qty);
						$doc->exportField($this->increment);
						$doc->exportField($this->price_min_qty);
						$doc->exportField($this->currency);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>