<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for not_loomcard
 */
class not_loomcard extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $po;
	public $_barcode;
	public $design_size;
	public $weaving_works;
	public $grp;
	public $size_cm;
	public $w_cm;
	public $category;
	public $po_d;
	public $loom_week;
	public $loom_size;
	public $extra_loom_week;
	public $design_id;
	public $packing_type;
	public $buyers_id;
	public $sort;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'not_loomcard';
		$this->TableName = 'not_loomcard';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`not_loomcard`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// po
		$this->po = new DbField('not_loomcard', 'not_loomcard', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// barcode
		$this->_barcode = new DbField('not_loomcard', 'not_loomcard', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Nullable = FALSE; // NOT NULL field
		$this->_barcode->Required = TRUE; // Required field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['barcode'] = &$this->_barcode;

		// design_size
		$this->design_size = new DbField('not_loomcard', 'not_loomcard', 'x_design_size', 'design_size', '`design_size`', '`design_size`', 201, -1, FALSE, '`design_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design_size->Sortable = TRUE; // Allow sort
		$this->fields['design_size'] = &$this->design_size;

		// weaving_works
		$this->weaving_works = new DbField('not_loomcard', 'not_loomcard', 'x_weaving_works', 'weaving_works', '`weaving_works`', '`weaving_works`', 18, -1, FALSE, '`weaving_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->weaving_works->Nullable = FALSE; // NOT NULL field
		$this->weaving_works->Required = TRUE; // Required field
		$this->weaving_works->Sortable = TRUE; // Allow sort
		$this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['weaving_works'] = &$this->weaving_works;

		// grp
		$this->grp = new DbField('not_loomcard', 'not_loomcard', 'x_grp', 'grp', '`grp`', '`grp`', 2, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// size_cm
		$this->size_cm = new DbField('not_loomcard', 'not_loomcard', 'x_size_cm', 'size_cm', '`size_cm`', '`size_cm`', 200, -1, FALSE, '`size_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_cm->Nullable = FALSE; // NOT NULL field
		$this->size_cm->Required = TRUE; // Required field
		$this->size_cm->Sortable = TRUE; // Allow sort
		$this->fields['size_cm'] = &$this->size_cm;

		// w_cm
		$this->w_cm = new DbField('not_loomcard', 'not_loomcard', 'x_w_cm', 'w_cm', '`w_cm`', '`w_cm`', 18, -1, FALSE, '`w_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w_cm->Sortable = TRUE; // Allow sort
		$this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['w_cm'] = &$this->w_cm;

		// category
		$this->category = new DbField('not_loomcard', 'not_loomcard', 'x_category', 'category', '`category`', '`category`', 200, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->category->Nullable = FALSE; // NOT NULL field
		$this->category->Required = TRUE; // Required field
		$this->category->Sortable = TRUE; // Allow sort
		$this->fields['category'] = &$this->category;

		// po_d
		$this->po_d = new DbField('not_loomcard', 'not_loomcard', 'x_po_d', 'po_d', '`po_d`', '`po_d`', 200, -1, FALSE, '`po_d`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_d->Sortable = TRUE; // Allow sort
		$this->fields['po_d'] = &$this->po_d;

		// loom_week
		$this->loom_week = new DbField('not_loomcard', 'not_loomcard', 'x_loom_week', 'loom_week', '`loom_week`', '`loom_week`', 200, -1, FALSE, '`loom_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->loom_week->Nullable = FALSE; // NOT NULL field
		$this->loom_week->Required = TRUE; // Required field
		$this->loom_week->Sortable = TRUE; // Allow sort
		$this->loom_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['loom_week'] = &$this->loom_week;

		// loom_size
		$this->loom_size = new DbField('not_loomcard', 'not_loomcard', 'x_loom_size', 'loom_size', '`loom_size`', '`loom_size`', 200, -1, FALSE, '`loom_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->loom_size->Nullable = FALSE; // NOT NULL field
		$this->loom_size->Required = TRUE; // Required field
		$this->loom_size->Sortable = TRUE; // Allow sort
		$this->fields['loom_size'] = &$this->loom_size;

		// extra_loom_week
		$this->extra_loom_week = new DbField('not_loomcard', 'not_loomcard', 'x_extra_loom_week', 'extra_loom_week', '`extra_loom_week`', '`extra_loom_week`', 18, -1, FALSE, '`extra_loom_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->extra_loom_week->Sortable = TRUE; // Allow sort
		$this->extra_loom_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['extra_loom_week'] = &$this->extra_loom_week;

		// design_id
		$this->design_id = new DbField('not_loomcard', 'not_loomcard', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 200, -1, FALSE, '`design_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design_id->Sortable = TRUE; // Allow sort
		$this->fields['design_id'] = &$this->design_id;

		// packing_type
		$this->packing_type = new DbField('not_loomcard', 'not_loomcard', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// buyers_id
		$this->buyers_id = new DbField('not_loomcard', 'not_loomcard', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 19, -1, FALSE, '`buyers_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyers_id->Sortable = TRUE; // Allow sort
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// sort
		$this->sort = new DbField('not_loomcard', 'not_loomcard', 'x_sort', 'sort', '`sort`', '`sort`', 200, -1, FALSE, '`sort`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sort->Sortable = TRUE; // Allow sort
		$this->fields['sort'] = &$this->sort;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`not_loomcard`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->po->DbValue = $row['po'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->design_size->DbValue = $row['design_size'];
		$this->weaving_works->DbValue = $row['weaving_works'];
		$this->grp->DbValue = $row['grp'];
		$this->size_cm->DbValue = $row['size_cm'];
		$this->w_cm->DbValue = $row['w_cm'];
		$this->category->DbValue = $row['category'];
		$this->po_d->DbValue = $row['po_d'];
		$this->loom_week->DbValue = $row['loom_week'];
		$this->loom_size->DbValue = $row['loom_size'];
		$this->extra_loom_week->DbValue = $row['extra_loom_week'];
		$this->design_id->DbValue = $row['design_id'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->sort->DbValue = $row['sort'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "not_loomcardlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "not_loomcardview.php")
			return $Language->phrase("View");
		elseif ($pageName == "not_loomcardedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "not_loomcardadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "not_loomcardlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("not_loomcardview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("not_loomcardview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "not_loomcardadd.php?" . $this->getUrlParm($parm);
		else
			$url = "not_loomcardadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("not_loomcardedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("not_loomcardadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("not_loomcarddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->po->setDbValue($rs->fields('po'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->design_size->setDbValue($rs->fields('design_size'));
		$this->weaving_works->setDbValue($rs->fields('weaving_works'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->size_cm->setDbValue($rs->fields('size_cm'));
		$this->w_cm->setDbValue($rs->fields('w_cm'));
		$this->category->setDbValue($rs->fields('category'));
		$this->po_d->setDbValue($rs->fields('po_d'));
		$this->loom_week->setDbValue($rs->fields('loom_week'));
		$this->loom_size->setDbValue($rs->fields('loom_size'));
		$this->extra_loom_week->setDbValue($rs->fields('extra_loom_week'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->sort->setDbValue($rs->fields('sort'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// po
		// barcode
		// design_size
		// weaving_works
		// grp
		// size_cm
		// w_cm
		// category
		// po_d
		// loom_week
		// loom_size
		// extra_loom_week
		// design_id
		// packing_type
		// buyers_id
		// sort
		// po

		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// design_size
		$this->design_size->ViewValue = $this->design_size->CurrentValue;
		$this->design_size->ViewCustomAttributes = "";

		// weaving_works
		$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
		$this->weaving_works->ViewValue = FormatNumber($this->weaving_works->ViewValue, 0, -2, -2, -2);
		$this->weaving_works->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// w_cm
		$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
		$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 0, -2, -2, -2);
		$this->w_cm->ViewCustomAttributes = "";

		// category
		$this->category->ViewValue = $this->category->CurrentValue;
		$this->category->ViewCustomAttributes = "";

		// po_d
		$this->po_d->ViewValue = $this->po_d->CurrentValue;
		$this->po_d->ViewCustomAttributes = "";

		// loom_week
		$this->loom_week->ViewValue = $this->loom_week->CurrentValue;
		$this->loom_week->ViewCustomAttributes = "";

		// loom_size
		$this->loom_size->ViewValue = $this->loom_size->CurrentValue;
		$this->loom_size->ViewCustomAttributes = "";

		// extra_loom_week
		$this->extra_loom_week->ViewValue = $this->extra_loom_week->CurrentValue;
		$this->extra_loom_week->ViewValue = FormatNumber($this->extra_loom_week->ViewValue, 0, -2, -2, -2);
		$this->extra_loom_week->ViewCustomAttributes = "";

		// design_id
		$this->design_id->ViewValue = $this->design_id->CurrentValue;
		$this->design_id->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 0, -2, -2, -2);
		$this->packing_type->ViewCustomAttributes = "";

		// buyers_id
		$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
		$this->buyers_id->ViewValue = FormatNumber($this->buyers_id->ViewValue, 0, -2, -2, -2);
		$this->buyers_id->ViewCustomAttributes = "";

		// sort
		$this->sort->ViewValue = $this->sort->CurrentValue;
		$this->sort->ViewCustomAttributes = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// design_size
		$this->design_size->LinkCustomAttributes = "";
		$this->design_size->HrefValue = "";
		$this->design_size->TooltipValue = "";

		// weaving_works
		$this->weaving_works->LinkCustomAttributes = "";
		$this->weaving_works->HrefValue = "";
		$this->weaving_works->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// size_cm
		$this->size_cm->LinkCustomAttributes = "";
		$this->size_cm->HrefValue = "";
		$this->size_cm->TooltipValue = "";

		// w_cm
		$this->w_cm->LinkCustomAttributes = "";
		$this->w_cm->HrefValue = "";
		$this->w_cm->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// po_d
		$this->po_d->LinkCustomAttributes = "";
		$this->po_d->HrefValue = "";
		$this->po_d->TooltipValue = "";

		// loom_week
		$this->loom_week->LinkCustomAttributes = "";
		$this->loom_week->HrefValue = "";
		$this->loom_week->TooltipValue = "";

		// loom_size
		$this->loom_size->LinkCustomAttributes = "";
		$this->loom_size->HrefValue = "";
		$this->loom_size->TooltipValue = "";

		// extra_loom_week
		$this->extra_loom_week->LinkCustomAttributes = "";
		$this->extra_loom_week->HrefValue = "";
		$this->extra_loom_week->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		$this->design_id->HrefValue = "";
		$this->design_id->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		$this->buyers_id->HrefValue = "";
		$this->buyers_id->TooltipValue = "";

		// sort
		$this->sort->LinkCustomAttributes = "";
		$this->sort->HrefValue = "";
		$this->sort->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

		// design_size
		$this->design_size->EditAttrs["class"] = "form-control";
		$this->design_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design_size->CurrentValue = HtmlDecode($this->design_size->CurrentValue);
		$this->design_size->EditValue = $this->design_size->CurrentValue;
		$this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

		// weaving_works
		$this->weaving_works->EditAttrs["class"] = "form-control";
		$this->weaving_works->EditCustomAttributes = "";
		$this->weaving_works->EditValue = $this->weaving_works->CurrentValue;
		$this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// size_cm
		$this->size_cm->EditAttrs["class"] = "form-control";
		$this->size_cm->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
		$this->size_cm->EditValue = $this->size_cm->CurrentValue;
		$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

		// w_cm
		$this->w_cm->EditAttrs["class"] = "form-control";
		$this->w_cm->EditCustomAttributes = "";
		$this->w_cm->EditValue = $this->w_cm->CurrentValue;
		$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->category->CurrentValue = HtmlDecode($this->category->CurrentValue);
		$this->category->EditValue = $this->category->CurrentValue;
		$this->category->PlaceHolder = RemoveHtml($this->category->caption());

		// po_d
		$this->po_d->EditAttrs["class"] = "form-control";
		$this->po_d->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->po_d->CurrentValue = HtmlDecode($this->po_d->CurrentValue);
		$this->po_d->EditValue = $this->po_d->CurrentValue;
		$this->po_d->PlaceHolder = RemoveHtml($this->po_d->caption());

		// loom_week
		$this->loom_week->EditAttrs["class"] = "form-control";
		$this->loom_week->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->loom_week->CurrentValue = HtmlDecode($this->loom_week->CurrentValue);
		$this->loom_week->EditValue = $this->loom_week->CurrentValue;
		$this->loom_week->PlaceHolder = RemoveHtml($this->loom_week->caption());

		// loom_size
		$this->loom_size->EditAttrs["class"] = "form-control";
		$this->loom_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->loom_size->CurrentValue = HtmlDecode($this->loom_size->CurrentValue);
		$this->loom_size->EditValue = $this->loom_size->CurrentValue;
		$this->loom_size->PlaceHolder = RemoveHtml($this->loom_size->caption());

		// extra_loom_week
		$this->extra_loom_week->EditAttrs["class"] = "form-control";
		$this->extra_loom_week->EditCustomAttributes = "";
		$this->extra_loom_week->EditValue = $this->extra_loom_week->CurrentValue;
		$this->extra_loom_week->PlaceHolder = RemoveHtml($this->extra_loom_week->caption());

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design_id->CurrentValue = HtmlDecode($this->design_id->CurrentValue);
		$this->design_id->EditValue = $this->design_id->CurrentValue;
		$this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";
		$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
		$this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

		// sort
		$this->sort->EditAttrs["class"] = "form-control";
		$this->sort->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->sort->CurrentValue = HtmlDecode($this->sort->CurrentValue);
		$this->sort->EditValue = $this->sort->CurrentValue;
		$this->sort->PlaceHolder = RemoveHtml($this->sort->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->design_size);
					$doc->exportCaption($this->weaving_works);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->w_cm);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->po_d);
					$doc->exportCaption($this->loom_week);
					$doc->exportCaption($this->loom_size);
					$doc->exportCaption($this->extra_loom_week);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->sort);
				} else {
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->design_size);
					$doc->exportCaption($this->weaving_works);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->w_cm);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->po_d);
					$doc->exportCaption($this->loom_week);
					$doc->exportCaption($this->loom_size);
					$doc->exportCaption($this->extra_loom_week);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->sort);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->po);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->design_size);
						$doc->exportField($this->weaving_works);
						$doc->exportField($this->grp);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->w_cm);
						$doc->exportField($this->category);
						$doc->exportField($this->po_d);
						$doc->exportField($this->loom_week);
						$doc->exportField($this->loom_size);
						$doc->exportField($this->extra_loom_week);
						$doc->exportField($this->design_id);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->sort);
					} else {
						$doc->exportField($this->po);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->design_size);
						$doc->exportField($this->weaving_works);
						$doc->exportField($this->grp);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->w_cm);
						$doc->exportField($this->category);
						$doc->exportField($this->po_d);
						$doc->exportField($this->loom_week);
						$doc->exportField($this->loom_size);
						$doc->exportField($this->extra_loom_week);
						$doc->exportField($this->design_id);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->sort);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>