<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class oms_table_2_list extends oms_table_2
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'oms_table_2';

	// Page object name
	public $PageObjName = "oms_table_2_list";

	// Grid form hidden field names
	public $FormName = "foms_table_2list";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (oms_table_2)
		if (!isset($GLOBALS["oms_table_2"]) || get_class($GLOBALS["oms_table_2"]) == PROJECT_NAMESPACE . "oms_table_2") {
			$GLOBALS["oms_table_2"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["oms_table_2"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "oms_table_2add.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "oms_table_2delete.php";
		$this->MultiUpdateUrl = "oms_table_2update.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'oms_table_2');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option foms_table_2listsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $oms_table_2;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($oms_table_2);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->buyers_id->setVisibility();
		$this->reports_to->setVisibility();
		$this->buyer_order->setVisibility();
		$this->item->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->order_week->setVisibility();
		$this->order_date->setVisibility();
		$this->ex_factory->setVisibility();
		$this->ex_factory_p->setVisibility();
		$this->shipping_mode->setVisibility();
		$this->category->setVisibility();
		$this->cs->setVisibility();
		$this->po->setVisibility();
		$this->design->setVisibility();
		$this->size_buyer->setVisibility();
		$this->width->setVisibility();
		$this->length->setVisibility();
		$this->qty->setVisibility();
		$this->revised_qty->setVisibility();
		$this->sqm->setVisibility();
		$this->d_qty->setVisibility();
		$this->pending->setVisibility();
		$this->pending_sqm->setVisibility();
		$this->offloom->setVisibility();
		$this->pending_offloom->setVisibility();
		$this->pending_offloom_sqm->setVisibility();
		$this->cbm->setVisibility();
		$this->total_cbm->setVisibility();
		$this->weaving_works->setVisibility();
		$this->current_works->setVisibility();
		$this->remarks->setVisibility();
		$this->pl_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->sailing_week->setVisibility();
		$this->status->setVisibility();
		$this->completed->setVisibility();
		$this->rejection->setVisibility();
		$this->label->setVisibility();
		$this->weight_sqm->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->order_week);
		$this->setupLookupOptions($this->ex_factory);
		$this->setupLookupOptions($this->ex_factory_p);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->weaving_works);
		$this->setupLookupOptions($this->current_works);
		$this->setupLookupOptions($this->status);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 0) {
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "foms_table_2listsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->buyers_id->AdvancedSearch->toJson(), ","); // Field buyers_id
		$filterList = Concat($filterList, $this->reports_to->AdvancedSearch->toJson(), ","); // Field reports_to
		$filterList = Concat($filterList, $this->buyer_order->AdvancedSearch->toJson(), ","); // Field buyer_order
		$filterList = Concat($filterList, $this->item->AdvancedSearch->toJson(), ","); // Field item
		$filterList = Concat($filterList, $this->buyer_ref->AdvancedSearch->toJson(), ","); // Field buyer_ref
		$filterList = Concat($filterList, $this->order_week->AdvancedSearch->toJson(), ","); // Field order_week
		$filterList = Concat($filterList, $this->order_date->AdvancedSearch->toJson(), ","); // Field order_date
		$filterList = Concat($filterList, $this->ex_factory->AdvancedSearch->toJson(), ","); // Field ex_factory
		$filterList = Concat($filterList, $this->ex_factory_p->AdvancedSearch->toJson(), ","); // Field ex_factory_p
		$filterList = Concat($filterList, $this->shipping_mode->AdvancedSearch->toJson(), ","); // Field shipping_mode
		$filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
		$filterList = Concat($filterList, $this->cs->AdvancedSearch->toJson(), ","); // Field cs
		$filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
		$filterList = Concat($filterList, $this->design->AdvancedSearch->toJson(), ","); // Field design
		$filterList = Concat($filterList, $this->size_buyer->AdvancedSearch->toJson(), ","); // Field size_buyer
		$filterList = Concat($filterList, $this->width->AdvancedSearch->toJson(), ","); // Field width
		$filterList = Concat($filterList, $this->length->AdvancedSearch->toJson(), ","); // Field length
		$filterList = Concat($filterList, $this->qty->AdvancedSearch->toJson(), ","); // Field qty
		$filterList = Concat($filterList, $this->revised_qty->AdvancedSearch->toJson(), ","); // Field revised_qty
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->d_qty->AdvancedSearch->toJson(), ","); // Field d_qty
		$filterList = Concat($filterList, $this->pending->AdvancedSearch->toJson(), ","); // Field pending
		$filterList = Concat($filterList, $this->pending_sqm->AdvancedSearch->toJson(), ","); // Field pending_sqm
		$filterList = Concat($filterList, $this->offloom->AdvancedSearch->toJson(), ","); // Field offloom
		$filterList = Concat($filterList, $this->pending_offloom->AdvancedSearch->toJson(), ","); // Field pending_offloom
		$filterList = Concat($filterList, $this->pending_offloom_sqm->AdvancedSearch->toJson(), ","); // Field pending_offloom_sqm
		$filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
		$filterList = Concat($filterList, $this->total_cbm->AdvancedSearch->toJson(), ","); // Field total_cbm
		$filterList = Concat($filterList, $this->weaving_works->AdvancedSearch->toJson(), ","); // Field weaving_works
		$filterList = Concat($filterList, $this->current_works->AdvancedSearch->toJson(), ","); // Field current_works
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->pl_no->AdvancedSearch->toJson(), ","); // Field pl_no
		$filterList = Concat($filterList, $this->invoice_date->AdvancedSearch->toJson(), ","); // Field invoice_date
		$filterList = Concat($filterList, $this->sailing_week->AdvancedSearch->toJson(), ","); // Field sailing_week
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->completed->AdvancedSearch->toJson(), ","); // Field completed
		$filterList = Concat($filterList, $this->label->AdvancedSearch->toJson(), ","); // Field label
		$filterList = Concat($filterList, $this->weight_sqm->AdvancedSearch->toJson(), ","); // Field weight_sqm
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "foms_table_2listsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field buyers_id
		$this->buyers_id->AdvancedSearch->SearchValue = @$filter["x_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchOperator = @$filter["z_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchCondition = @$filter["v_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchValue2 = @$filter["y_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyers_id"];
		$this->buyers_id->AdvancedSearch->save();

		// Field reports_to
		$this->reports_to->AdvancedSearch->SearchValue = @$filter["x_reports_to"];
		$this->reports_to->AdvancedSearch->SearchOperator = @$filter["z_reports_to"];
		$this->reports_to->AdvancedSearch->SearchCondition = @$filter["v_reports_to"];
		$this->reports_to->AdvancedSearch->SearchValue2 = @$filter["y_reports_to"];
		$this->reports_to->AdvancedSearch->SearchOperator2 = @$filter["w_reports_to"];
		$this->reports_to->AdvancedSearch->save();

		// Field buyer_order
		$this->buyer_order->AdvancedSearch->SearchValue = @$filter["x_buyer_order"];
		$this->buyer_order->AdvancedSearch->SearchOperator = @$filter["z_buyer_order"];
		$this->buyer_order->AdvancedSearch->SearchCondition = @$filter["v_buyer_order"];
		$this->buyer_order->AdvancedSearch->SearchValue2 = @$filter["y_buyer_order"];
		$this->buyer_order->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_order"];
		$this->buyer_order->AdvancedSearch->save();

		// Field item
		$this->item->AdvancedSearch->SearchValue = @$filter["x_item"];
		$this->item->AdvancedSearch->SearchOperator = @$filter["z_item"];
		$this->item->AdvancedSearch->SearchCondition = @$filter["v_item"];
		$this->item->AdvancedSearch->SearchValue2 = @$filter["y_item"];
		$this->item->AdvancedSearch->SearchOperator2 = @$filter["w_item"];
		$this->item->AdvancedSearch->save();

		// Field buyer_ref
		$this->buyer_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->save();

		// Field order_week
		$this->order_week->AdvancedSearch->SearchValue = @$filter["x_order_week"];
		$this->order_week->AdvancedSearch->SearchOperator = @$filter["z_order_week"];
		$this->order_week->AdvancedSearch->SearchCondition = @$filter["v_order_week"];
		$this->order_week->AdvancedSearch->SearchValue2 = @$filter["y_order_week"];
		$this->order_week->AdvancedSearch->SearchOperator2 = @$filter["w_order_week"];
		$this->order_week->AdvancedSearch->save();

		// Field order_date
		$this->order_date->AdvancedSearch->SearchValue = @$filter["x_order_date"];
		$this->order_date->AdvancedSearch->SearchOperator = @$filter["z_order_date"];
		$this->order_date->AdvancedSearch->SearchCondition = @$filter["v_order_date"];
		$this->order_date->AdvancedSearch->SearchValue2 = @$filter["y_order_date"];
		$this->order_date->AdvancedSearch->SearchOperator2 = @$filter["w_order_date"];
		$this->order_date->AdvancedSearch->save();

		// Field ex_factory
		$this->ex_factory->AdvancedSearch->SearchValue = @$filter["x_ex_factory"];
		$this->ex_factory->AdvancedSearch->SearchOperator = @$filter["z_ex_factory"];
		$this->ex_factory->AdvancedSearch->SearchCondition = @$filter["v_ex_factory"];
		$this->ex_factory->AdvancedSearch->SearchValue2 = @$filter["y_ex_factory"];
		$this->ex_factory->AdvancedSearch->SearchOperator2 = @$filter["w_ex_factory"];
		$this->ex_factory->AdvancedSearch->save();

		// Field ex_factory_p
		$this->ex_factory_p->AdvancedSearch->SearchValue = @$filter["x_ex_factory_p"];
		$this->ex_factory_p->AdvancedSearch->SearchOperator = @$filter["z_ex_factory_p"];
		$this->ex_factory_p->AdvancedSearch->SearchCondition = @$filter["v_ex_factory_p"];
		$this->ex_factory_p->AdvancedSearch->SearchValue2 = @$filter["y_ex_factory_p"];
		$this->ex_factory_p->AdvancedSearch->SearchOperator2 = @$filter["w_ex_factory_p"];
		$this->ex_factory_p->AdvancedSearch->save();

		// Field shipping_mode
		$this->shipping_mode->AdvancedSearch->SearchValue = @$filter["x_shipping_mode"];
		$this->shipping_mode->AdvancedSearch->SearchOperator = @$filter["z_shipping_mode"];
		$this->shipping_mode->AdvancedSearch->SearchCondition = @$filter["v_shipping_mode"];
		$this->shipping_mode->AdvancedSearch->SearchValue2 = @$filter["y_shipping_mode"];
		$this->shipping_mode->AdvancedSearch->SearchOperator2 = @$filter["w_shipping_mode"];
		$this->shipping_mode->AdvancedSearch->save();

		// Field category
		$this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
		$this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
		$this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
		$this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
		$this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
		$this->category->AdvancedSearch->save();

		// Field cs
		$this->cs->AdvancedSearch->SearchValue = @$filter["x_cs"];
		$this->cs->AdvancedSearch->SearchOperator = @$filter["z_cs"];
		$this->cs->AdvancedSearch->SearchCondition = @$filter["v_cs"];
		$this->cs->AdvancedSearch->SearchValue2 = @$filter["y_cs"];
		$this->cs->AdvancedSearch->SearchOperator2 = @$filter["w_cs"];
		$this->cs->AdvancedSearch->save();

		// Field po
		$this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
		$this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
		$this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
		$this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
		$this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
		$this->po->AdvancedSearch->save();

		// Field design
		$this->design->AdvancedSearch->SearchValue = @$filter["x_design"];
		$this->design->AdvancedSearch->SearchOperator = @$filter["z_design"];
		$this->design->AdvancedSearch->SearchCondition = @$filter["v_design"];
		$this->design->AdvancedSearch->SearchValue2 = @$filter["y_design"];
		$this->design->AdvancedSearch->SearchOperator2 = @$filter["w_design"];
		$this->design->AdvancedSearch->save();

		// Field size_buyer
		$this->size_buyer->AdvancedSearch->SearchValue = @$filter["x_size_buyer"];
		$this->size_buyer->AdvancedSearch->SearchOperator = @$filter["z_size_buyer"];
		$this->size_buyer->AdvancedSearch->SearchCondition = @$filter["v_size_buyer"];
		$this->size_buyer->AdvancedSearch->SearchValue2 = @$filter["y_size_buyer"];
		$this->size_buyer->AdvancedSearch->SearchOperator2 = @$filter["w_size_buyer"];
		$this->size_buyer->AdvancedSearch->save();

		// Field width
		$this->width->AdvancedSearch->SearchValue = @$filter["x_width"];
		$this->width->AdvancedSearch->SearchOperator = @$filter["z_width"];
		$this->width->AdvancedSearch->SearchCondition = @$filter["v_width"];
		$this->width->AdvancedSearch->SearchValue2 = @$filter["y_width"];
		$this->width->AdvancedSearch->SearchOperator2 = @$filter["w_width"];
		$this->width->AdvancedSearch->save();

		// Field length
		$this->length->AdvancedSearch->SearchValue = @$filter["x_length"];
		$this->length->AdvancedSearch->SearchOperator = @$filter["z_length"];
		$this->length->AdvancedSearch->SearchCondition = @$filter["v_length"];
		$this->length->AdvancedSearch->SearchValue2 = @$filter["y_length"];
		$this->length->AdvancedSearch->SearchOperator2 = @$filter["w_length"];
		$this->length->AdvancedSearch->save();

		// Field qty
		$this->qty->AdvancedSearch->SearchValue = @$filter["x_qty"];
		$this->qty->AdvancedSearch->SearchOperator = @$filter["z_qty"];
		$this->qty->AdvancedSearch->SearchCondition = @$filter["v_qty"];
		$this->qty->AdvancedSearch->SearchValue2 = @$filter["y_qty"];
		$this->qty->AdvancedSearch->SearchOperator2 = @$filter["w_qty"];
		$this->qty->AdvancedSearch->save();

		// Field revised_qty
		$this->revised_qty->AdvancedSearch->SearchValue = @$filter["x_revised_qty"];
		$this->revised_qty->AdvancedSearch->SearchOperator = @$filter["z_revised_qty"];
		$this->revised_qty->AdvancedSearch->SearchCondition = @$filter["v_revised_qty"];
		$this->revised_qty->AdvancedSearch->SearchValue2 = @$filter["y_revised_qty"];
		$this->revised_qty->AdvancedSearch->SearchOperator2 = @$filter["w_revised_qty"];
		$this->revised_qty->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field d_qty
		$this->d_qty->AdvancedSearch->SearchValue = @$filter["x_d_qty"];
		$this->d_qty->AdvancedSearch->SearchOperator = @$filter["z_d_qty"];
		$this->d_qty->AdvancedSearch->SearchCondition = @$filter["v_d_qty"];
		$this->d_qty->AdvancedSearch->SearchValue2 = @$filter["y_d_qty"];
		$this->d_qty->AdvancedSearch->SearchOperator2 = @$filter["w_d_qty"];
		$this->d_qty->AdvancedSearch->save();

		// Field pending
		$this->pending->AdvancedSearch->SearchValue = @$filter["x_pending"];
		$this->pending->AdvancedSearch->SearchOperator = @$filter["z_pending"];
		$this->pending->AdvancedSearch->SearchCondition = @$filter["v_pending"];
		$this->pending->AdvancedSearch->SearchValue2 = @$filter["y_pending"];
		$this->pending->AdvancedSearch->SearchOperator2 = @$filter["w_pending"];
		$this->pending->AdvancedSearch->save();

		// Field pending_sqm
		$this->pending_sqm->AdvancedSearch->SearchValue = @$filter["x_pending_sqm"];
		$this->pending_sqm->AdvancedSearch->SearchOperator = @$filter["z_pending_sqm"];
		$this->pending_sqm->AdvancedSearch->SearchCondition = @$filter["v_pending_sqm"];
		$this->pending_sqm->AdvancedSearch->SearchValue2 = @$filter["y_pending_sqm"];
		$this->pending_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_pending_sqm"];
		$this->pending_sqm->AdvancedSearch->save();

		// Field offloom
		$this->offloom->AdvancedSearch->SearchValue = @$filter["x_offloom"];
		$this->offloom->AdvancedSearch->SearchOperator = @$filter["z_offloom"];
		$this->offloom->AdvancedSearch->SearchCondition = @$filter["v_offloom"];
		$this->offloom->AdvancedSearch->SearchValue2 = @$filter["y_offloom"];
		$this->offloom->AdvancedSearch->SearchOperator2 = @$filter["w_offloom"];
		$this->offloom->AdvancedSearch->save();

		// Field pending_offloom
		$this->pending_offloom->AdvancedSearch->SearchValue = @$filter["x_pending_offloom"];
		$this->pending_offloom->AdvancedSearch->SearchOperator = @$filter["z_pending_offloom"];
		$this->pending_offloom->AdvancedSearch->SearchCondition = @$filter["v_pending_offloom"];
		$this->pending_offloom->AdvancedSearch->SearchValue2 = @$filter["y_pending_offloom"];
		$this->pending_offloom->AdvancedSearch->SearchOperator2 = @$filter["w_pending_offloom"];
		$this->pending_offloom->AdvancedSearch->save();

		// Field pending_offloom_sqm
		$this->pending_offloom_sqm->AdvancedSearch->SearchValue = @$filter["x_pending_offloom_sqm"];
		$this->pending_offloom_sqm->AdvancedSearch->SearchOperator = @$filter["z_pending_offloom_sqm"];
		$this->pending_offloom_sqm->AdvancedSearch->SearchCondition = @$filter["v_pending_offloom_sqm"];
		$this->pending_offloom_sqm->AdvancedSearch->SearchValue2 = @$filter["y_pending_offloom_sqm"];
		$this->pending_offloom_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_pending_offloom_sqm"];
		$this->pending_offloom_sqm->AdvancedSearch->save();

		// Field cbm
		$this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
		$this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
		$this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
		$this->cbm->AdvancedSearch->save();

		// Field total_cbm
		$this->total_cbm->AdvancedSearch->SearchValue = @$filter["x_total_cbm"];
		$this->total_cbm->AdvancedSearch->SearchOperator = @$filter["z_total_cbm"];
		$this->total_cbm->AdvancedSearch->SearchCondition = @$filter["v_total_cbm"];
		$this->total_cbm->AdvancedSearch->SearchValue2 = @$filter["y_total_cbm"];
		$this->total_cbm->AdvancedSearch->SearchOperator2 = @$filter["w_total_cbm"];
		$this->total_cbm->AdvancedSearch->save();

		// Field weaving_works
		$this->weaving_works->AdvancedSearch->SearchValue = @$filter["x_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchOperator = @$filter["z_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchCondition = @$filter["v_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchValue2 = @$filter["y_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchOperator2 = @$filter["w_weaving_works"];
		$this->weaving_works->AdvancedSearch->save();

		// Field current_works
		$this->current_works->AdvancedSearch->SearchValue = @$filter["x_current_works"];
		$this->current_works->AdvancedSearch->SearchOperator = @$filter["z_current_works"];
		$this->current_works->AdvancedSearch->SearchCondition = @$filter["v_current_works"];
		$this->current_works->AdvancedSearch->SearchValue2 = @$filter["y_current_works"];
		$this->current_works->AdvancedSearch->SearchOperator2 = @$filter["w_current_works"];
		$this->current_works->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field pl_no
		$this->pl_no->AdvancedSearch->SearchValue = @$filter["x_pl_no"];
		$this->pl_no->AdvancedSearch->SearchOperator = @$filter["z_pl_no"];
		$this->pl_no->AdvancedSearch->SearchCondition = @$filter["v_pl_no"];
		$this->pl_no->AdvancedSearch->SearchValue2 = @$filter["y_pl_no"];
		$this->pl_no->AdvancedSearch->SearchOperator2 = @$filter["w_pl_no"];
		$this->pl_no->AdvancedSearch->save();

		// Field invoice_date
		$this->invoice_date->AdvancedSearch->SearchValue = @$filter["x_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchOperator = @$filter["z_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchCondition = @$filter["v_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchValue2 = @$filter["y_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_date"];
		$this->invoice_date->AdvancedSearch->save();

		// Field sailing_week
		$this->sailing_week->AdvancedSearch->SearchValue = @$filter["x_sailing_week"];
		$this->sailing_week->AdvancedSearch->SearchOperator = @$filter["z_sailing_week"];
		$this->sailing_week->AdvancedSearch->SearchCondition = @$filter["v_sailing_week"];
		$this->sailing_week->AdvancedSearch->SearchValue2 = @$filter["y_sailing_week"];
		$this->sailing_week->AdvancedSearch->SearchOperator2 = @$filter["w_sailing_week"];
		$this->sailing_week->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field completed
		$this->completed->AdvancedSearch->SearchValue = @$filter["x_completed"];
		$this->completed->AdvancedSearch->SearchOperator = @$filter["z_completed"];
		$this->completed->AdvancedSearch->SearchCondition = @$filter["v_completed"];
		$this->completed->AdvancedSearch->SearchValue2 = @$filter["y_completed"];
		$this->completed->AdvancedSearch->SearchOperator2 = @$filter["w_completed"];
		$this->completed->AdvancedSearch->save();

		// Field label
		$this->label->AdvancedSearch->SearchValue = @$filter["x_label"];
		$this->label->AdvancedSearch->SearchOperator = @$filter["z_label"];
		$this->label->AdvancedSearch->SearchCondition = @$filter["v_label"];
		$this->label->AdvancedSearch->SearchValue2 = @$filter["y_label"];
		$this->label->AdvancedSearch->SearchOperator2 = @$filter["w_label"];
		$this->label->AdvancedSearch->save();

		// Field weight_sqm
		$this->weight_sqm->AdvancedSearch->SearchValue = @$filter["x_weight_sqm"];
		$this->weight_sqm->AdvancedSearch->SearchOperator = @$filter["z_weight_sqm"];
		$this->weight_sqm->AdvancedSearch->SearchCondition = @$filter["v_weight_sqm"];
		$this->weight_sqm->AdvancedSearch->SearchValue2 = @$filter["y_weight_sqm"];
		$this->weight_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_weight_sqm"];
		$this->weight_sqm->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->buyers_id, $default, FALSE); // buyers_id
		$this->buildSearchSql($where, $this->reports_to, $default, FALSE); // reports_to
		$this->buildSearchSql($where, $this->buyer_order, $default, FALSE); // buyer_order
		$this->buildSearchSql($where, $this->item, $default, FALSE); // item
		$this->buildSearchSql($where, $this->buyer_ref, $default, FALSE); // buyer_ref
		$this->buildSearchSql($where, $this->order_week, $default, FALSE); // order_week
		$this->buildSearchSql($where, $this->order_date, $default, FALSE); // order_date
		$this->buildSearchSql($where, $this->ex_factory, $default, FALSE); // ex_factory
		$this->buildSearchSql($where, $this->ex_factory_p, $default, TRUE); // ex_factory_p
		$this->buildSearchSql($where, $this->shipping_mode, $default, FALSE); // shipping_mode
		$this->buildSearchSql($where, $this->category, $default, FALSE); // category
		$this->buildSearchSql($where, $this->cs, $default, FALSE); // cs
		$this->buildSearchSql($where, $this->po, $default, FALSE); // po
		$this->buildSearchSql($where, $this->design, $default, FALSE); // design
		$this->buildSearchSql($where, $this->size_buyer, $default, FALSE); // size_buyer
		$this->buildSearchSql($where, $this->width, $default, FALSE); // width
		$this->buildSearchSql($where, $this->length, $default, FALSE); // length
		$this->buildSearchSql($where, $this->qty, $default, FALSE); // qty
		$this->buildSearchSql($where, $this->revised_qty, $default, FALSE); // revised_qty
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->d_qty, $default, FALSE); // d_qty
		$this->buildSearchSql($where, $this->pending, $default, FALSE); // pending
		$this->buildSearchSql($where, $this->pending_sqm, $default, FALSE); // pending_sqm
		$this->buildSearchSql($where, $this->offloom, $default, FALSE); // offloom
		$this->buildSearchSql($where, $this->pending_offloom, $default, FALSE); // pending_offloom
		$this->buildSearchSql($where, $this->pending_offloom_sqm, $default, FALSE); // pending_offloom_sqm
		$this->buildSearchSql($where, $this->cbm, $default, FALSE); // cbm
		$this->buildSearchSql($where, $this->total_cbm, $default, FALSE); // total_cbm
		$this->buildSearchSql($where, $this->weaving_works, $default, FALSE); // weaving_works
		$this->buildSearchSql($where, $this->current_works, $default, FALSE); // current_works
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->pl_no, $default, FALSE); // pl_no
		$this->buildSearchSql($where, $this->invoice_date, $default, FALSE); // invoice_date
		$this->buildSearchSql($where, $this->sailing_week, $default, FALSE); // sailing_week
		$this->buildSearchSql($where, $this->status, $default, TRUE); // status
		$this->buildSearchSql($where, $this->completed, $default, TRUE); // completed
		$this->buildSearchSql($where, $this->label, $default, FALSE); // label
		$this->buildSearchSql($where, $this->weight_sqm, $default, FALSE); // weight_sqm

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->buyers_id->AdvancedSearch->save(); // buyers_id
			$this->reports_to->AdvancedSearch->save(); // reports_to
			$this->buyer_order->AdvancedSearch->save(); // buyer_order
			$this->item->AdvancedSearch->save(); // item
			$this->buyer_ref->AdvancedSearch->save(); // buyer_ref
			$this->order_week->AdvancedSearch->save(); // order_week
			$this->order_date->AdvancedSearch->save(); // order_date
			$this->ex_factory->AdvancedSearch->save(); // ex_factory
			$this->ex_factory_p->AdvancedSearch->save(); // ex_factory_p
			$this->shipping_mode->AdvancedSearch->save(); // shipping_mode
			$this->category->AdvancedSearch->save(); // category
			$this->cs->AdvancedSearch->save(); // cs
			$this->po->AdvancedSearch->save(); // po
			$this->design->AdvancedSearch->save(); // design
			$this->size_buyer->AdvancedSearch->save(); // size_buyer
			$this->width->AdvancedSearch->save(); // width
			$this->length->AdvancedSearch->save(); // length
			$this->qty->AdvancedSearch->save(); // qty
			$this->revised_qty->AdvancedSearch->save(); // revised_qty
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->d_qty->AdvancedSearch->save(); // d_qty
			$this->pending->AdvancedSearch->save(); // pending
			$this->pending_sqm->AdvancedSearch->save(); // pending_sqm
			$this->offloom->AdvancedSearch->save(); // offloom
			$this->pending_offloom->AdvancedSearch->save(); // pending_offloom
			$this->pending_offloom_sqm->AdvancedSearch->save(); // pending_offloom_sqm
			$this->cbm->AdvancedSearch->save(); // cbm
			$this->total_cbm->AdvancedSearch->save(); // total_cbm
			$this->weaving_works->AdvancedSearch->save(); // weaving_works
			$this->current_works->AdvancedSearch->save(); // current_works
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->pl_no->AdvancedSearch->save(); // pl_no
			$this->invoice_date->AdvancedSearch->save(); // invoice_date
			$this->sailing_week->AdvancedSearch->save(); // sailing_week
			$this->status->AdvancedSearch->save(); // status
			$this->completed->AdvancedSearch->save(); // completed
			$this->label->AdvancedSearch->save(); // label
			$this->weight_sqm->AdvancedSearch->save(); // weight_sqm
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->buyer_order, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->item, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ex_factory_p, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->shipping_mode, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->category, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->design, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->size_buyer, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cbm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->total_cbm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pl_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->invoice_date, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sailing_week, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->completed, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->label, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyers_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->reports_to->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_order->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->item->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->order_week->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->order_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ex_factory->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ex_factory_p->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->shipping_mode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->category->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->design->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->size_buyer->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->width->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->length->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->revised_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pending->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pending_sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->offloom->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pending_offloom->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pending_offloom_sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cbm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->total_cbm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->weaving_works->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->current_works->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sailing_week->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->completed->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->label->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->weight_sqm->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->buyers_id->AdvancedSearch->unsetSession();
		$this->reports_to->AdvancedSearch->unsetSession();
		$this->buyer_order->AdvancedSearch->unsetSession();
		$this->item->AdvancedSearch->unsetSession();
		$this->buyer_ref->AdvancedSearch->unsetSession();
		$this->order_week->AdvancedSearch->unsetSession();
		$this->order_date->AdvancedSearch->unsetSession();
		$this->ex_factory->AdvancedSearch->unsetSession();
		$this->ex_factory_p->AdvancedSearch->unsetSession();
		$this->shipping_mode->AdvancedSearch->unsetSession();
		$this->category->AdvancedSearch->unsetSession();
		$this->cs->AdvancedSearch->unsetSession();
		$this->po->AdvancedSearch->unsetSession();
		$this->design->AdvancedSearch->unsetSession();
		$this->size_buyer->AdvancedSearch->unsetSession();
		$this->width->AdvancedSearch->unsetSession();
		$this->length->AdvancedSearch->unsetSession();
		$this->qty->AdvancedSearch->unsetSession();
		$this->revised_qty->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->d_qty->AdvancedSearch->unsetSession();
		$this->pending->AdvancedSearch->unsetSession();
		$this->pending_sqm->AdvancedSearch->unsetSession();
		$this->offloom->AdvancedSearch->unsetSession();
		$this->pending_offloom->AdvancedSearch->unsetSession();
		$this->pending_offloom_sqm->AdvancedSearch->unsetSession();
		$this->cbm->AdvancedSearch->unsetSession();
		$this->total_cbm->AdvancedSearch->unsetSession();
		$this->weaving_works->AdvancedSearch->unsetSession();
		$this->current_works->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->pl_no->AdvancedSearch->unsetSession();
		$this->invoice_date->AdvancedSearch->unsetSession();
		$this->sailing_week->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->completed->AdvancedSearch->unsetSession();
		$this->label->AdvancedSearch->unsetSession();
		$this->weight_sqm->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->buyer_order->AdvancedSearch->load();
		$this->item->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->order_week->AdvancedSearch->load();
		$this->order_date->AdvancedSearch->load();
		$this->ex_factory->AdvancedSearch->load();
		$this->ex_factory_p->AdvancedSearch->load();
		$this->shipping_mode->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->cs->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->design->AdvancedSearch->load();
		$this->size_buyer->AdvancedSearch->load();
		$this->width->AdvancedSearch->load();
		$this->length->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->revised_qty->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->d_qty->AdvancedSearch->load();
		$this->pending->AdvancedSearch->load();
		$this->pending_sqm->AdvancedSearch->load();
		$this->offloom->AdvancedSearch->load();
		$this->pending_offloom->AdvancedSearch->load();
		$this->pending_offloom_sqm->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->total_cbm->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->sailing_week->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->completed->AdvancedSearch->load();
		$this->label->AdvancedSearch->load();
		$this->weight_sqm->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->buyers_id, $ctrl); // buyers_id
			$this->updateSort($this->reports_to, $ctrl); // reports_to
			$this->updateSort($this->buyer_order, $ctrl); // buyer_order
			$this->updateSort($this->item, $ctrl); // item
			$this->updateSort($this->buyer_ref, $ctrl); // buyer_ref
			$this->updateSort($this->order_week, $ctrl); // order_week
			$this->updateSort($this->order_date, $ctrl); // order_date
			$this->updateSort($this->ex_factory, $ctrl); // ex_factory
			$this->updateSort($this->ex_factory_p, $ctrl); // ex_factory_p
			$this->updateSort($this->shipping_mode, $ctrl); // shipping_mode
			$this->updateSort($this->category, $ctrl); // category
			$this->updateSort($this->cs, $ctrl); // cs
			$this->updateSort($this->po, $ctrl); // po
			$this->updateSort($this->design, $ctrl); // design
			$this->updateSort($this->size_buyer, $ctrl); // size_buyer
			$this->updateSort($this->width, $ctrl); // width
			$this->updateSort($this->length, $ctrl); // length
			$this->updateSort($this->qty, $ctrl); // qty
			$this->updateSort($this->revised_qty, $ctrl); // revised_qty
			$this->updateSort($this->sqm, $ctrl); // sqm
			$this->updateSort($this->d_qty, $ctrl); // d_qty
			$this->updateSort($this->pending, $ctrl); // pending
			$this->updateSort($this->pending_sqm, $ctrl); // pending_sqm
			$this->updateSort($this->offloom, $ctrl); // offloom
			$this->updateSort($this->pending_offloom, $ctrl); // pending_offloom
			$this->updateSort($this->pending_offloom_sqm, $ctrl); // pending_offloom_sqm
			$this->updateSort($this->cbm, $ctrl); // cbm
			$this->updateSort($this->total_cbm, $ctrl); // total_cbm
			$this->updateSort($this->weaving_works, $ctrl); // weaving_works
			$this->updateSort($this->current_works, $ctrl); // current_works
			$this->updateSort($this->remarks, $ctrl); // remarks
			$this->updateSort($this->pl_no, $ctrl); // pl_no
			$this->updateSort($this->invoice_date, $ctrl); // invoice_date
			$this->updateSort($this->sailing_week, $ctrl); // sailing_week
			$this->updateSort($this->status, $ctrl); // status
			$this->updateSort($this->completed, $ctrl); // completed
			$this->updateSort($this->rejection, $ctrl); // rejection
			$this->updateSort($this->label, $ctrl); // label
			$this->updateSort($this->weight_sqm, $ctrl); // weight_sqm
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->buyers_id->setSort("");
				$this->reports_to->setSort("");
				$this->buyer_order->setSort("");
				$this->item->setSort("");
				$this->buyer_ref->setSort("");
				$this->order_week->setSort("");
				$this->order_date->setSort("");
				$this->ex_factory->setSort("");
				$this->ex_factory_p->setSort("");
				$this->shipping_mode->setSort("");
				$this->category->setSort("");
				$this->cs->setSort("");
				$this->po->setSort("");
				$this->design->setSort("");
				$this->size_buyer->setSort("");
				$this->width->setSort("");
				$this->length->setSort("");
				$this->qty->setSort("");
				$this->revised_qty->setSort("");
				$this->sqm->setSort("");
				$this->d_qty->setSort("");
				$this->pending->setSort("");
				$this->pending_sqm->setSort("");
				$this->offloom->setSort("");
				$this->pending_offloom->setSort("");
				$this->pending_offloom_sqm->setSort("");
				$this->cbm->setSort("");
				$this->total_cbm->setSort("");
				$this->weaving_works->setSort("");
				$this->current_works->setSort("");
				$this->remarks->setSort("");
				$this->pl_no->setSort("");
				$this->invoice_date->setSort("");
				$this->sailing_week->setSort("");
				$this->status->setSort("");
				$this->completed->setSort("");
				$this->rejection->setSort("");
				$this->label->setSort("");
				$this->weight_sqm->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"foms_table_2listsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"foms_table_2listsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.foms_table_2list}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"foms_table_2listsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"oms_table_2srch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"oms_table_2\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'oms_table_2srch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"foms_table_2listsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// buyers_id
		if (!$this->isAddOrEdit())
			$this->buyers_id->AdvancedSearch->setSearchValue(Get("x_buyers_id", Get("buyers_id", "")));
		if ($this->buyers_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyers_id->AdvancedSearch->setSearchOperator(Get("z_buyers_id", ""));

		// reports_to
		if (!$this->isAddOrEdit())
			$this->reports_to->AdvancedSearch->setSearchValue(Get("x_reports_to", Get("reports_to", "")));
		if ($this->reports_to->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->reports_to->AdvancedSearch->setSearchOperator(Get("z_reports_to", ""));

		// buyer_order
		if (!$this->isAddOrEdit())
			$this->buyer_order->AdvancedSearch->setSearchValue(Get("x_buyer_order", Get("buyer_order", "")));
		if ($this->buyer_order->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_order->AdvancedSearch->setSearchOperator(Get("z_buyer_order", ""));

		// item
		if (!$this->isAddOrEdit())
			$this->item->AdvancedSearch->setSearchValue(Get("x_item", Get("item", "")));
		if ($this->item->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->item->AdvancedSearch->setSearchOperator(Get("z_item", ""));

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue(Get("x_buyer_ref", Get("buyer_ref", "")));
		if ($this->buyer_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_ref->AdvancedSearch->setSearchOperator(Get("z_buyer_ref", ""));

		// order_week
		if (!$this->isAddOrEdit())
			$this->order_week->AdvancedSearch->setSearchValue(Get("x_order_week", Get("order_week", "")));
		if ($this->order_week->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->order_week->AdvancedSearch->setSearchOperator(Get("z_order_week", ""));

		// order_date
		if (!$this->isAddOrEdit())
			$this->order_date->AdvancedSearch->setSearchValue(Get("x_order_date", Get("order_date", "")));
		if ($this->order_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->order_date->AdvancedSearch->setSearchOperator(Get("z_order_date", ""));

		// ex_factory
		if (!$this->isAddOrEdit())
			$this->ex_factory->AdvancedSearch->setSearchValue(Get("x_ex_factory", Get("ex_factory", "")));
		if ($this->ex_factory->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ex_factory->AdvancedSearch->setSearchOperator(Get("z_ex_factory", ""));

		// ex_factory_p
		if (!$this->isAddOrEdit())
			$this->ex_factory_p->AdvancedSearch->setSearchValue(Get("x_ex_factory_p", Get("ex_factory_p", "")));
		if ($this->ex_factory_p->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ex_factory_p->AdvancedSearch->setSearchOperator(Get("z_ex_factory_p", ""));
		$this->ex_factory_p->AdvancedSearch->setSearchCondition(Get("v_ex_factory_p", ""));
		$this->ex_factory_p->AdvancedSearch->setSearchValue2(Get("y_ex_factory_p", ""));
		if ($this->ex_factory_p->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ex_factory_p->AdvancedSearch->setSearchOperator2(Get("w_ex_factory_p", ""));
		if (is_array($this->ex_factory_p->AdvancedSearch->SearchValue))
			$this->ex_factory_p->AdvancedSearch->SearchValue = implode(",", $this->ex_factory_p->AdvancedSearch->SearchValue);
		if (is_array($this->ex_factory_p->AdvancedSearch->SearchValue2))
			$this->ex_factory_p->AdvancedSearch->SearchValue2 = implode(",", $this->ex_factory_p->AdvancedSearch->SearchValue2);

		// shipping_mode
		if (!$this->isAddOrEdit())
			$this->shipping_mode->AdvancedSearch->setSearchValue(Get("x_shipping_mode", Get("shipping_mode", "")));
		if ($this->shipping_mode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->shipping_mode->AdvancedSearch->setSearchOperator(Get("z_shipping_mode", ""));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue(Get("x_category", Get("category", "")));
		if ($this->category->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->category->AdvancedSearch->setSearchOperator(Get("z_category", ""));

		// cs
		if (!$this->isAddOrEdit())
			$this->cs->AdvancedSearch->setSearchValue(Get("x_cs", Get("cs", "")));
		if ($this->cs->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cs->AdvancedSearch->setSearchOperator(Get("z_cs", ""));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue(Get("x_po", Get("po", "")));
		if ($this->po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator(Get("z_po", ""));
		$this->po->AdvancedSearch->setSearchCondition(Get("v_po", ""));
		$this->po->AdvancedSearch->setSearchValue2(Get("y_po", ""));
		if ($this->po->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator2(Get("w_po", ""));

		// design
		if (!$this->isAddOrEdit())
			$this->design->AdvancedSearch->setSearchValue(Get("x_design", Get("design", "")));
		if ($this->design->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->design->AdvancedSearch->setSearchOperator(Get("z_design", ""));

		// size_buyer
		if (!$this->isAddOrEdit())
			$this->size_buyer->AdvancedSearch->setSearchValue(Get("x_size_buyer", Get("size_buyer", "")));
		if ($this->size_buyer->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->size_buyer->AdvancedSearch->setSearchOperator(Get("z_size_buyer", ""));

		// width
		if (!$this->isAddOrEdit())
			$this->width->AdvancedSearch->setSearchValue(Get("x_width", Get("width", "")));
		if ($this->width->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->width->AdvancedSearch->setSearchOperator(Get("z_width", ""));

		// length
		if (!$this->isAddOrEdit())
			$this->length->AdvancedSearch->setSearchValue(Get("x_length", Get("length", "")));
		if ($this->length->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->length->AdvancedSearch->setSearchOperator(Get("z_length", ""));

		// qty
		if (!$this->isAddOrEdit())
			$this->qty->AdvancedSearch->setSearchValue(Get("x_qty", Get("qty", "")));
		if ($this->qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty->AdvancedSearch->setSearchOperator(Get("z_qty", ""));

		// revised_qty
		if (!$this->isAddOrEdit())
			$this->revised_qty->AdvancedSearch->setSearchValue(Get("x_revised_qty", Get("revised_qty", "")));
		if ($this->revised_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->revised_qty->AdvancedSearch->setSearchOperator(Get("z_revised_qty", ""));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));

		// d_qty
		if (!$this->isAddOrEdit())
			$this->d_qty->AdvancedSearch->setSearchValue(Get("x_d_qty", Get("d_qty", "")));
		if ($this->d_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_qty->AdvancedSearch->setSearchOperator(Get("z_d_qty", ""));

		// pending
		if (!$this->isAddOrEdit())
			$this->pending->AdvancedSearch->setSearchValue(Get("x_pending", Get("pending", "")));
		if ($this->pending->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pending->AdvancedSearch->setSearchOperator(Get("z_pending", ""));
		$this->pending->AdvancedSearch->setSearchCondition(Get("v_pending", ""));
		$this->pending->AdvancedSearch->setSearchValue2(Get("y_pending", ""));
		if ($this->pending->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pending->AdvancedSearch->setSearchOperator2(Get("w_pending", ""));

		// pending_sqm
		if (!$this->isAddOrEdit())
			$this->pending_sqm->AdvancedSearch->setSearchValue(Get("x_pending_sqm", Get("pending_sqm", "")));
		if ($this->pending_sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pending_sqm->AdvancedSearch->setSearchOperator(Get("z_pending_sqm", ""));
		$this->pending_sqm->AdvancedSearch->setSearchCondition(Get("v_pending_sqm", ""));
		$this->pending_sqm->AdvancedSearch->setSearchValue2(Get("y_pending_sqm", ""));
		if ($this->pending_sqm->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pending_sqm->AdvancedSearch->setSearchOperator2(Get("w_pending_sqm", ""));

		// offloom
		if (!$this->isAddOrEdit())
			$this->offloom->AdvancedSearch->setSearchValue(Get("x_offloom", Get("offloom", "")));
		if ($this->offloom->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->offloom->AdvancedSearch->setSearchOperator(Get("z_offloom", ""));

		// pending_offloom
		if (!$this->isAddOrEdit())
			$this->pending_offloom->AdvancedSearch->setSearchValue(Get("x_pending_offloom", Get("pending_offloom", "")));
		if ($this->pending_offloom->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pending_offloom->AdvancedSearch->setSearchOperator(Get("z_pending_offloom", ""));

		// pending_offloom_sqm
		if (!$this->isAddOrEdit())
			$this->pending_offloom_sqm->AdvancedSearch->setSearchValue(Get("x_pending_offloom_sqm", Get("pending_offloom_sqm", "")));
		if ($this->pending_offloom_sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pending_offloom_sqm->AdvancedSearch->setSearchOperator(Get("z_pending_offloom_sqm", ""));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue(Get("x_cbm", Get("cbm", "")));
		if ($this->cbm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cbm->AdvancedSearch->setSearchOperator(Get("z_cbm", ""));

		// total_cbm
		if (!$this->isAddOrEdit())
			$this->total_cbm->AdvancedSearch->setSearchValue(Get("x_total_cbm", Get("total_cbm", "")));
		if ($this->total_cbm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->total_cbm->AdvancedSearch->setSearchOperator(Get("z_total_cbm", ""));

		// weaving_works
		if (!$this->isAddOrEdit())
			$this->weaving_works->AdvancedSearch->setSearchValue(Get("x_weaving_works", Get("weaving_works", "")));
		if ($this->weaving_works->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->weaving_works->AdvancedSearch->setSearchOperator(Get("z_weaving_works", ""));

		// current_works
		if (!$this->isAddOrEdit())
			$this->current_works->AdvancedSearch->setSearchValue(Get("x_current_works", Get("current_works", "")));
		if ($this->current_works->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->current_works->AdvancedSearch->setSearchOperator(Get("z_current_works", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// pl_no
		if (!$this->isAddOrEdit())
			$this->pl_no->AdvancedSearch->setSearchValue(Get("x_pl_no", Get("pl_no", "")));
		if ($this->pl_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_no->AdvancedSearch->setSearchOperator(Get("z_pl_no", ""));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue(Get("x_invoice_date", Get("invoice_date", "")));
		if ($this->invoice_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_date->AdvancedSearch->setSearchOperator(Get("z_invoice_date", ""));

		// sailing_week
		if (!$this->isAddOrEdit())
			$this->sailing_week->AdvancedSearch->setSearchValue(Get("x_sailing_week", Get("sailing_week", "")));
		if ($this->sailing_week->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sailing_week->AdvancedSearch->setSearchOperator(Get("z_sailing_week", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));
		if (is_array($this->status->AdvancedSearch->SearchValue))
			$this->status->AdvancedSearch->SearchValue = implode(",", $this->status->AdvancedSearch->SearchValue);
		if (is_array($this->status->AdvancedSearch->SearchValue2))
			$this->status->AdvancedSearch->SearchValue2 = implode(",", $this->status->AdvancedSearch->SearchValue2);

		// completed
		if (!$this->isAddOrEdit())
			$this->completed->AdvancedSearch->setSearchValue(Get("x_completed", Get("completed", "")));
		if ($this->completed->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->completed->AdvancedSearch->setSearchOperator(Get("z_completed", ""));
		if (is_array($this->completed->AdvancedSearch->SearchValue))
			$this->completed->AdvancedSearch->SearchValue = implode(",", $this->completed->AdvancedSearch->SearchValue);
		if (is_array($this->completed->AdvancedSearch->SearchValue2))
			$this->completed->AdvancedSearch->SearchValue2 = implode(",", $this->completed->AdvancedSearch->SearchValue2);

		// label
		if (!$this->isAddOrEdit())
			$this->label->AdvancedSearch->setSearchValue(Get("x_label", Get("label", "")));
		if ($this->label->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->label->AdvancedSearch->setSearchOperator(Get("z_label", ""));

		// weight_sqm
		if (!$this->isAddOrEdit())
			$this->weight_sqm->AdvancedSearch->setSearchValue(Get("x_weight_sqm", Get("weight_sqm", "")));
		if ($this->weight_sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->weight_sqm->AdvancedSearch->setSearchOperator(Get("z_weight_sqm", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->buyers_id->setDbValue($row['buyers_id']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->buyer_order->setDbValue($row['buyer_order']);
		$this->item->setDbValue($row['item']);
		$this->buyer_ref->setDbValue($row['buyer_ref']);
		$this->order_week->setDbValue($row['order_week']);
		$this->order_date->setDbValue($row['order_date']);
		$this->ex_factory->setDbValue($row['ex_factory']);
		$this->ex_factory_p->setDbValue($row['ex_factory_p']);
		$this->shipping_mode->setDbValue($row['shipping_mode']);
		$this->category->setDbValue($row['category']);
		$this->cs->setDbValue($row['cs']);
		$this->po->setDbValue($row['po']);
		$this->design->setDbValue($row['design']);
		$this->size_buyer->setDbValue($row['size_buyer']);
		$this->width->setDbValue($row['width']);
		$this->length->setDbValue($row['length']);
		$this->qty->setDbValue($row['qty']);
		$this->revised_qty->setDbValue($row['revised_qty']);
		$this->sqm->setDbValue($row['sqm']);
		$this->d_qty->setDbValue($row['d_qty']);
		$this->pending->setDbValue($row['pending']);
		$this->pending_sqm->setDbValue($row['pending_sqm']);
		$this->offloom->setDbValue($row['offloom']);
		$this->pending_offloom->setDbValue($row['pending_offloom']);
		$this->pending_offloom_sqm->setDbValue($row['pending_offloom_sqm']);
		$this->cbm->setDbValue($row['cbm']);
		$this->total_cbm->setDbValue($row['total_cbm']);
		$this->weaving_works->setDbValue($row['weaving_works']);
		$this->current_works->setDbValue($row['current_works']);
		$this->remarks->setDbValue($row['remarks']);
		$this->pl_no->setDbValue($row['pl_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->sailing_week->setDbValue($row['sailing_week']);
		$this->status->setDbValue($row['status']);
		$this->completed->setDbValue($row['completed']);
		$this->rejection->setDbValue($row['rejection']);
		$this->label->setDbValue($row['label']);
		$this->weight_sqm->setDbValue($row['weight_sqm']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['buyers_id'] = NULL;
		$row['reports_to'] = NULL;
		$row['buyer_order'] = NULL;
		$row['item'] = NULL;
		$row['buyer_ref'] = NULL;
		$row['order_week'] = NULL;
		$row['order_date'] = NULL;
		$row['ex_factory'] = NULL;
		$row['ex_factory_p'] = NULL;
		$row['shipping_mode'] = NULL;
		$row['category'] = NULL;
		$row['cs'] = NULL;
		$row['po'] = NULL;
		$row['design'] = NULL;
		$row['size_buyer'] = NULL;
		$row['width'] = NULL;
		$row['length'] = NULL;
		$row['qty'] = NULL;
		$row['revised_qty'] = NULL;
		$row['sqm'] = NULL;
		$row['d_qty'] = NULL;
		$row['pending'] = NULL;
		$row['pending_sqm'] = NULL;
		$row['offloom'] = NULL;
		$row['pending_offloom'] = NULL;
		$row['pending_offloom_sqm'] = NULL;
		$row['cbm'] = NULL;
		$row['total_cbm'] = NULL;
		$row['weaving_works'] = NULL;
		$row['current_works'] = NULL;
		$row['remarks'] = NULL;
		$row['pl_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['sailing_week'] = NULL;
		$row['status'] = NULL;
		$row['completed'] = NULL;
		$row['rejection'] = NULL;
		$row['label'] = NULL;
		$row['weight_sqm'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{
		return FALSE;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_qty->FormValue == $this->d_qty->CurrentValue && is_numeric(ConvertToFloatString($this->d_qty->CurrentValue)))
			$this->d_qty->CurrentValue = ConvertToFloatString($this->d_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending->FormValue == $this->pending->CurrentValue && is_numeric(ConvertToFloatString($this->pending->CurrentValue)))
			$this->pending->CurrentValue = ConvertToFloatString($this->pending->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_sqm->FormValue == $this->pending_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->pending_sqm->CurrentValue)))
			$this->pending_sqm->CurrentValue = ConvertToFloatString($this->pending_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->offloom->FormValue == $this->offloom->CurrentValue && is_numeric(ConvertToFloatString($this->offloom->CurrentValue)))
			$this->offloom->CurrentValue = ConvertToFloatString($this->offloom->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_offloom_sqm->FormValue == $this->pending_offloom_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->pending_offloom_sqm->CurrentValue)))
			$this->pending_offloom_sqm->CurrentValue = ConvertToFloatString($this->pending_offloom_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight_sqm->FormValue == $this->weight_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->weight_sqm->CurrentValue)))
			$this->weight_sqm->CurrentValue = ConvertToFloatString($this->weight_sqm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// buyers_id
		// reports_to
		// buyer_order
		// item
		// buyer_ref
		// order_week
		// order_date
		// ex_factory
		// ex_factory_p
		// shipping_mode
		// category
		// cs
		// po
		// design
		// size_buyer
		// width
		// length
		// qty
		// revised_qty
		// sqm
		// d_qty
		// pending
		// pending_sqm
		// offloom
		// pending_offloom
		// pending_offloom_sqm
		// cbm
		// total_cbm
		// weaving_works
		// current_works
		// remarks
		// pl_no
		// invoice_date
		// sailing_week
		// status
		// completed
		// rejection

		$this->rejection->CellCssStyle = "white-space: nowrap;";

		// label
		// weight_sqm
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->qty->CurrentValue))
				$this->qty->Total += $this->qty->CurrentValue; // Accumulate total
			if (is_numeric($this->sqm->CurrentValue))
				$this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
			if (is_numeric($this->d_qty->CurrentValue))
				$this->d_qty->Total += $this->d_qty->CurrentValue; // Accumulate total
			if (is_numeric($this->pending->CurrentValue))
				$this->pending->Total += $this->pending->CurrentValue; // Accumulate total
			if (is_numeric($this->pending_sqm->CurrentValue))
				$this->pending_sqm->Total += $this->pending_sqm->CurrentValue; // Accumulate total
			if (is_numeric($this->offloom->CurrentValue))
				$this->offloom->Total += $this->offloom->CurrentValue; // Accumulate total
			if (is_numeric($this->rejection->CurrentValue))
				$this->rejection->Total += $this->rejection->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer_order
			$this->buyer_order->ViewValue = $this->buyer_order->CurrentValue;
			$this->buyer_order->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			$this->item->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_week
			$curVal = strval($this->order_week->CurrentValue);
			if ($curVal <> "") {
				$this->order_week->ViewValue = $this->order_week->lookupCacheOption($curVal);
				if ($this->order_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->order_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->order_week->ViewValue = $this->order_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->order_week->ViewValue = $this->order_week->CurrentValue;
					}
				}
			} else {
				$this->order_week->ViewValue = NULL;
			}
			$this->order_week->ViewCustomAttributes = "";

			// order_date
			$this->order_date->ViewValue = $this->order_date->CurrentValue;
			$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 2);
			$this->order_date->ViewCustomAttributes = "";

			// ex_factory
			$curVal = strval($this->ex_factory->CurrentValue);
			if ($curVal <> "") {
				$this->ex_factory->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
				if ($this->ex_factory->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ex_factory->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->ex_factory->ViewValue = $this->ex_factory->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ex_factory->ViewValue = $this->ex_factory->CurrentValue;
					}
				}
			} else {
				$this->ex_factory->ViewValue = NULL;
			}
			$this->ex_factory->ViewCustomAttributes = "";

			// ex_factory_p
			$curVal = strval($this->ex_factory_p->CurrentValue);
			if ($curVal <> "") {
				$this->ex_factory_p->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
				if ($this->ex_factory_p->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->ex_factory_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->ex_factory_p->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->ex_factory_p->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->ex_factory_p->ViewValue = $this->ex_factory_p->CurrentValue;
					}
				}
			} else {
				$this->ex_factory_p->ViewValue = NULL;
			}
			$this->ex_factory_p->ViewCustomAttributes = "";

			// shipping_mode
			$this->shipping_mode->ViewValue = $this->shipping_mode->CurrentValue;
			$this->shipping_mode->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// cs
			if (strval($this->cs->CurrentValue) <> "") {
				$this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
			} else {
				$this->cs->ViewValue = NULL;
			}
			$this->cs->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// width
			$this->width->ViewValue = $this->width->CurrentValue;
			$this->width->ViewValue = FormatNumber($this->width->ViewValue, 0, -2, -2, -2);
			$this->width->ViewCustomAttributes = "";

			// length
			$this->length->ViewValue = $this->length->CurrentValue;
			$this->length->ViewValue = FormatNumber($this->length->ViewValue, 0, -2, -2, -2);
			$this->length->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// revised_qty
			$this->revised_qty->ViewValue = $this->revised_qty->CurrentValue;
			$this->revised_qty->ViewValue = FormatNumber($this->revised_qty->ViewValue, 0, -2, -2, -2);
			$this->revised_qty->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// d_qty
			$this->d_qty->ViewValue = $this->d_qty->CurrentValue;
			$this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, 2, -2, -2, -2);
			$this->d_qty->ViewCustomAttributes = "";

			// pending
			$this->pending->ViewValue = $this->pending->CurrentValue;
			$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 0, -1, -2, -2);
			$this->pending->ViewCustomAttributes = "";

			// pending_sqm
			$this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
			$this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, 2, -2, -2, -2);
			$this->pending_sqm->ViewCustomAttributes = "";

			// offloom
			$this->offloom->ViewValue = $this->offloom->CurrentValue;
			$this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, 0, -2, -2, -2);
			$this->offloom->ViewCustomAttributes = "";

			// pending_offloom
			$this->pending_offloom->ViewValue = $this->pending_offloom->CurrentValue;
			$this->pending_offloom->ViewValue = FormatNumber($this->pending_offloom->ViewValue, 0, -2, -2, -2);
			$this->pending_offloom->ViewCustomAttributes = "";

			// pending_offloom_sqm
			$this->pending_offloom_sqm->ViewValue = $this->pending_offloom_sqm->CurrentValue;
			$this->pending_offloom_sqm->ViewValue = FormatNumber($this->pending_offloom_sqm->ViewValue, 2, -2, -2, -2);
			$this->pending_offloom_sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// total_cbm
			$this->total_cbm->ViewValue = $this->total_cbm->CurrentValue;
			$this->total_cbm->ViewCustomAttributes = "";

			// weaving_works
			$curVal = strval($this->weaving_works->CurrentValue);
			if ($curVal <> "") {
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
				if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
					}
				}
			} else {
				$this->weaving_works->ViewValue = NULL;
			}
			$this->weaving_works->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewCustomAttributes = "";

			// sailing_week
			$this->sailing_week->ViewValue = $this->sailing_week->CurrentValue;
			$this->sailing_week->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->status->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->status->ViewValue->add($this->status->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// completed
			if (strval($this->completed->CurrentValue) <> "") {
				$this->completed->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->completed->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->completed->ViewValue->add($this->completed->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->completed->ViewValue = NULL;
			}
			$this->completed->ViewCustomAttributes = "";

			// rejection
			$this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, 0, -2, -2, -2);
			$this->rejection->ViewCustomAttributes = "";

			// label
			$this->label->ViewValue = $this->label->CurrentValue;
			$this->label->ViewCustomAttributes = "";

			// weight_sqm
			$this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
			$this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, 2, -2, -2, -2);
			$this->weight_sqm->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			$this->buyers_id->HrefValue = "";
			$this->buyers_id->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer_order
			$this->buyer_order->LinkCustomAttributes = "";
			$this->buyer_order->HrefValue = "";
			$this->buyer_order->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_order->ViewValue = $this->highlightValue($this->buyer_order);

			// item
			$this->item->LinkCustomAttributes = "";
			$this->item->HrefValue = "";
			$this->item->TooltipValue = "";
			if (!$this->isExport())
				$this->item->ViewValue = $this->highlightValue($this->item);

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			$this->buyer_ref->HrefValue = "";
			$this->buyer_ref->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_ref->ViewValue = $this->highlightValue($this->buyer_ref);

			// order_week
			$this->order_week->LinkCustomAttributes = "";
			$this->order_week->HrefValue = "";
			$this->order_week->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// ex_factory
			$this->ex_factory->LinkCustomAttributes = "";
			$this->ex_factory->HrefValue = "";
			$this->ex_factory->TooltipValue = "";

			// ex_factory_p
			$this->ex_factory_p->LinkCustomAttributes = "";
			$this->ex_factory_p->HrefValue = "";
			$this->ex_factory_p->TooltipValue = "";

			// shipping_mode
			$this->shipping_mode->LinkCustomAttributes = "";
			$this->shipping_mode->HrefValue = "";
			$this->shipping_mode->TooltipValue = "";
			if (!$this->isExport())
				$this->shipping_mode->ViewValue = $this->highlightValue($this->shipping_mode);

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// cs
			$this->cs->LinkCustomAttributes = "";
			$this->cs->HrefValue = "";
			$this->cs->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";
			if (!$this->isExport())
				$this->design->ViewValue = $this->highlightValue($this->design);

			// size_buyer
			$this->size_buyer->LinkCustomAttributes = "";
			$this->size_buyer->HrefValue = "";
			$this->size_buyer->TooltipValue = "";
			if (!$this->isExport())
				$this->size_buyer->ViewValue = $this->highlightValue($this->size_buyer);

			// width
			$this->width->LinkCustomAttributes = "";
			$this->width->HrefValue = "";
			$this->width->TooltipValue = "";

			// length
			$this->length->LinkCustomAttributes = "";
			$this->length->HrefValue = "";
			$this->length->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// revised_qty
			$this->revised_qty->LinkCustomAttributes = "";
			$this->revised_qty->HrefValue = "";
			$this->revised_qty->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// d_qty
			$this->d_qty->LinkCustomAttributes = "";
			$this->d_qty->HrefValue = "";
			$this->d_qty->TooltipValue = "";

			// pending
			$this->pending->LinkCustomAttributes = "";
			$this->pending->HrefValue = "";
			$this->pending->TooltipValue = "";

			// pending_sqm
			$this->pending_sqm->LinkCustomAttributes = "";
			$this->pending_sqm->HrefValue = "";
			$this->pending_sqm->TooltipValue = "";

			// offloom
			$this->offloom->LinkCustomAttributes = "";
			$this->offloom->HrefValue = "";
			$this->offloom->TooltipValue = "";

			// pending_offloom
			$this->pending_offloom->LinkCustomAttributes = "";
			$this->pending_offloom->HrefValue = "";
			$this->pending_offloom->TooltipValue = "";

			// pending_offloom_sqm
			$this->pending_offloom_sqm->LinkCustomAttributes = "";
			$this->pending_offloom_sqm->HrefValue = "";
			$this->pending_offloom_sqm->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";
			if (!$this->isExport())
				$this->cbm->ViewValue = $this->highlightValue($this->cbm);

			// total_cbm
			$this->total_cbm->LinkCustomAttributes = "";
			$this->total_cbm->HrefValue = "";
			$this->total_cbm->TooltipValue = "";
			if (!$this->isExport())
				$this->total_cbm->ViewValue = $this->highlightValue($this->total_cbm);

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			$this->current_works->HrefValue = "";
			$this->current_works->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";
			if (!$this->isExport())
				$this->remarks->ViewValue = $this->highlightValue($this->remarks);

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";
			if (!$this->isExport())
				$this->pl_no->ViewValue = $this->highlightValue($this->pl_no);

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";
			if (!$this->isExport())
				$this->invoice_date->ViewValue = $this->highlightValue($this->invoice_date);

			// sailing_week
			$this->sailing_week->LinkCustomAttributes = "";
			$this->sailing_week->HrefValue = "";
			$this->sailing_week->TooltipValue = "";
			if (!$this->isExport())
				$this->sailing_week->ViewValue = $this->highlightValue($this->sailing_week);

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// completed
			$this->completed->LinkCustomAttributes = "";
			$this->completed->HrefValue = "";
			$this->completed->TooltipValue = "";

			// rejection
			$this->rejection->LinkCustomAttributes = "";
			$this->rejection->HrefValue = "";
			$this->rejection->TooltipValue = "";

			// label
			$this->label->LinkCustomAttributes = "";
			$this->label->HrefValue = "";
			$this->label->TooltipValue = "";
			if (!$this->isExport())
				$this->label->ViewValue = $this->highlightValue($this->label);

			// weight_sqm
			$this->weight_sqm->LinkCustomAttributes = "";
			$this->weight_sqm->HrefValue = "";
			$this->weight_sqm->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			else
				$this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== NULL && is_array($this->buyers_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyers_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyers_id->EditValue = array_values($this->buyers_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyers_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->buyers_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyers_id->EditValue = $arwrk;
			}

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// buyer_order
			$this->buyer_order->EditAttrs["class"] = "form-control";
			$this->buyer_order->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_order->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_order->AdvancedSearch->SearchValue);
			$this->buyer_order->EditValue = HtmlEncode($this->buyer_order->AdvancedSearch->SearchValue);
			$this->buyer_order->PlaceHolder = RemoveHtml($this->buyer_order->caption());

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
			$this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

			// order_week
			$this->order_week->EditAttrs["class"] = "form-control";
			$this->order_week->EditCustomAttributes = "";

			// order_date
			$this->order_date->EditAttrs["class"] = "form-control";
			$this->order_date->EditCustomAttributes = "";
			$this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, 2), 2));
			$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

			// ex_factory
			$this->ex_factory->EditAttrs["class"] = "form-control";
			$this->ex_factory->EditCustomAttributes = "";

			// ex_factory_p
			$this->ex_factory_p->EditCustomAttributes = "";
			$curVal = trim(strval($this->ex_factory_p->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->ex_factory_p->AdvancedSearch->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
			else
				$this->ex_factory_p->AdvancedSearch->ViewValue = $this->ex_factory_p->Lookup !== NULL && is_array($this->ex_factory_p->Lookup->Options) ? $curVal : NULL;
			if ($this->ex_factory_p->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->ex_factory_p->EditValue = array_values($this->ex_factory_p->Lookup->Options);
				if ($this->ex_factory_p->AdvancedSearch->ViewValue == "")
					$this->ex_factory_p->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->ex_factory_p->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->ex_factory_p->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->ex_factory_p->AdvancedSearch->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->ex_factory_p->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ex_factory_p->EditValue = $arwrk;
			}
			$this->ex_factory_p->EditCustomAttributes = "";
			$curVal = trim(strval($this->ex_factory_p->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->ex_factory_p->AdvancedSearch->ViewValue2 = $this->ex_factory_p->lookupCacheOption($curVal);
			else
				$this->ex_factory_p->AdvancedSearch->ViewValue2 = $this->ex_factory_p->Lookup !== NULL && is_array($this->ex_factory_p->Lookup->Options) ? $curVal : NULL;
			if ($this->ex_factory_p->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->ex_factory_p->EditValue2 = array_values($this->ex_factory_p->Lookup->Options);
				if ($this->ex_factory_p->AdvancedSearch->ViewValue2 == "")
					$this->ex_factory_p->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->ex_factory_p->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->ex_factory_p->AdvancedSearch->ViewValue2 = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->ex_factory_p->AdvancedSearch->ViewValue2->add($this->ex_factory_p->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->ex_factory_p->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ex_factory_p->EditValue2 = $arwrk;
			}

			// shipping_mode
			$this->shipping_mode->EditAttrs["class"] = "form-control";
			$this->shipping_mode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->shipping_mode->AdvancedSearch->SearchValue = HtmlDecode($this->shipping_mode->AdvancedSearch->SearchValue);
			$this->shipping_mode->EditValue = HtmlEncode($this->shipping_mode->AdvancedSearch->SearchValue);
			$this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";

			// cs
			$this->cs->EditAttrs["class"] = "form-control";
			$this->cs->EditCustomAttributes = "";
			$this->cs->EditValue = $this->cs->options(TRUE);

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// design
			$this->design->EditAttrs["class"] = "form-control";
			$this->design->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design->AdvancedSearch->SearchValue = HtmlDecode($this->design->AdvancedSearch->SearchValue);
			$this->design->EditValue = HtmlEncode($this->design->AdvancedSearch->SearchValue);
			$this->design->PlaceHolder = RemoveHtml($this->design->caption());

			// size_buyer
			$this->size_buyer->EditAttrs["class"] = "form-control";
			$this->size_buyer->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_buyer->AdvancedSearch->SearchValue = HtmlDecode($this->size_buyer->AdvancedSearch->SearchValue);
			$this->size_buyer->EditValue = HtmlEncode($this->size_buyer->AdvancedSearch->SearchValue);
			$this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

			// width
			$this->width->EditAttrs["class"] = "form-control";
			$this->width->EditCustomAttributes = "";
			$this->width->EditValue = HtmlEncode($this->width->AdvancedSearch->SearchValue);
			$this->width->PlaceHolder = RemoveHtml($this->width->caption());

			// length
			$this->length->EditAttrs["class"] = "form-control";
			$this->length->EditCustomAttributes = "";
			$this->length->EditValue = HtmlEncode($this->length->AdvancedSearch->SearchValue);
			$this->length->PlaceHolder = RemoveHtml($this->length->caption());

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = HtmlEncode($this->qty->AdvancedSearch->SearchValue);
			$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

			// revised_qty
			$this->revised_qty->EditAttrs["class"] = "form-control";
			$this->revised_qty->EditCustomAttributes = "";
			$this->revised_qty->EditValue = HtmlEncode($this->revised_qty->AdvancedSearch->SearchValue);
			$this->revised_qty->PlaceHolder = RemoveHtml($this->revised_qty->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// d_qty
			$this->d_qty->EditAttrs["class"] = "form-control";
			$this->d_qty->EditCustomAttributes = "";
			$this->d_qty->EditValue = HtmlEncode($this->d_qty->AdvancedSearch->SearchValue);
			$this->d_qty->PlaceHolder = RemoveHtml($this->d_qty->caption());

			// pending
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue = HtmlEncode($this->pending->AdvancedSearch->SearchValue);
			$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue2 = HtmlEncode($this->pending->AdvancedSearch->SearchValue2);
			$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());

			// pending_sqm
			$this->pending_sqm->EditAttrs["class"] = "form-control";
			$this->pending_sqm->EditCustomAttributes = "";
			$this->pending_sqm->EditValue = HtmlEncode($this->pending_sqm->AdvancedSearch->SearchValue);
			$this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());
			$this->pending_sqm->EditAttrs["class"] = "form-control";
			$this->pending_sqm->EditCustomAttributes = "";
			$this->pending_sqm->EditValue2 = HtmlEncode($this->pending_sqm->AdvancedSearch->SearchValue2);
			$this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());

			// offloom
			$this->offloom->EditAttrs["class"] = "form-control";
			$this->offloom->EditCustomAttributes = "";
			$this->offloom->EditValue = HtmlEncode($this->offloom->AdvancedSearch->SearchValue);
			$this->offloom->PlaceHolder = RemoveHtml($this->offloom->caption());

			// pending_offloom
			$this->pending_offloom->EditAttrs["class"] = "form-control";
			$this->pending_offloom->EditCustomAttributes = "";
			$this->pending_offloom->EditValue = HtmlEncode($this->pending_offloom->AdvancedSearch->SearchValue);
			$this->pending_offloom->PlaceHolder = RemoveHtml($this->pending_offloom->caption());

			// pending_offloom_sqm
			$this->pending_offloom_sqm->EditAttrs["class"] = "form-control";
			$this->pending_offloom_sqm->EditCustomAttributes = "";
			$this->pending_offloom_sqm->EditValue = HtmlEncode($this->pending_offloom_sqm->AdvancedSearch->SearchValue);
			$this->pending_offloom_sqm->PlaceHolder = RemoveHtml($this->pending_offloom_sqm->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			$this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// total_cbm
			$this->total_cbm->EditAttrs["class"] = "form-control";
			$this->total_cbm->EditCustomAttributes = "";
			$this->total_cbm->EditValue = HtmlEncode($this->total_cbm->AdvancedSearch->SearchValue);
			$this->total_cbm->PlaceHolder = RemoveHtml($this->total_cbm->caption());

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";

			// current_works
			$this->current_works->EditAttrs["class"] = "form-control";
			$this->current_works->EditCustomAttributes = "";

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// pl_no
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pl_no->AdvancedSearch->SearchValue = HtmlDecode($this->pl_no->AdvancedSearch->SearchValue);
			$this->pl_no->EditValue = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue);
			$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode($this->invoice_date->AdvancedSearch->SearchValue);
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// sailing_week
			$this->sailing_week->EditAttrs["class"] = "form-control";
			$this->sailing_week->EditCustomAttributes = "";
			$this->sailing_week->EditValue = HtmlEncode($this->sailing_week->AdvancedSearch->SearchValue);
			$this->sailing_week->PlaceHolder = RemoveHtml($this->sailing_week->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";

			// completed
			$this->completed->EditCustomAttributes = "";
			$this->completed->EditValue = $this->completed->options(FALSE);

			// rejection
			$this->rejection->EditAttrs["class"] = "form-control";
			$this->rejection->EditCustomAttributes = "";

			// label
			$this->label->EditAttrs["class"] = "form-control";
			$this->label->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->label->AdvancedSearch->SearchValue = HtmlDecode($this->label->AdvancedSearch->SearchValue);
			$this->label->EditValue = HtmlEncode($this->label->AdvancedSearch->SearchValue);
			$this->label->PlaceHolder = RemoveHtml($this->label->caption());

			// weight_sqm
			$this->weight_sqm->EditAttrs["class"] = "form-control";
			$this->weight_sqm->EditCustomAttributes = "";
			$this->weight_sqm->EditValue = HtmlEncode($this->weight_sqm->AdvancedSearch->SearchValue);
			$this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->qty->Total = 0; // Initialize total
			$this->sqm->Total = 0; // Initialize total
			$this->d_qty->Total = 0; // Initialize total
			$this->pending->Total = 0; // Initialize total
			$this->pending_sqm->Total = 0; // Initialize total
			$this->offloom->Total = 0; // Initialize total
			$this->rejection->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->qty->CurrentValue = $this->qty->Total;
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";
			$this->qty->HrefValue = ""; // Clear href value
			$this->sqm->CurrentValue = $this->sqm->Total;
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";
			$this->sqm->HrefValue = ""; // Clear href value
			$this->d_qty->CurrentValue = $this->d_qty->Total;
			$this->d_qty->ViewValue = $this->d_qty->CurrentValue;
			$this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, 2, -2, -2, -2);
			$this->d_qty->ViewCustomAttributes = "";
			$this->d_qty->HrefValue = ""; // Clear href value
			$this->pending->CurrentValue = $this->pending->Total;
			$this->pending->ViewValue = $this->pending->CurrentValue;
			$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 0, -1, -2, -2);
			$this->pending->ViewCustomAttributes = "";
			$this->pending->HrefValue = ""; // Clear href value
			$this->pending_sqm->CurrentValue = $this->pending_sqm->Total;
			$this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
			$this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, 2, -2, -2, -2);
			$this->pending_sqm->ViewCustomAttributes = "";
			$this->pending_sqm->HrefValue = ""; // Clear href value
			$this->offloom->CurrentValue = $this->offloom->Total;
			$this->offloom->ViewValue = $this->offloom->CurrentValue;
			$this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, 0, -2, -2, -2);
			$this->offloom->ViewCustomAttributes = "";
			$this->offloom->HrefValue = ""; // Clear href value
			$this->rejection->CurrentValue = $this->rejection->Total;
			$this->rejection->ViewValue = $this->rejection->CurrentValue;
			$this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, 0, -2, -2, -2);
			$this->rejection->ViewCustomAttributes = "";
			$this->rejection->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckNumber($this->pending->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending->errorMessage());
		}
		if (!CheckNumber($this->pending->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->pending->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->buyer_order->AdvancedSearch->load();
		$this->item->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->order_week->AdvancedSearch->load();
		$this->order_date->AdvancedSearch->load();
		$this->ex_factory->AdvancedSearch->load();
		$this->ex_factory_p->AdvancedSearch->load();
		$this->shipping_mode->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->cs->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->design->AdvancedSearch->load();
		$this->size_buyer->AdvancedSearch->load();
		$this->width->AdvancedSearch->load();
		$this->length->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->revised_qty->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->d_qty->AdvancedSearch->load();
		$this->pending->AdvancedSearch->load();
		$this->pending_sqm->AdvancedSearch->load();
		$this->offloom->AdvancedSearch->load();
		$this->pending_offloom->AdvancedSearch->load();
		$this->pending_offloom_sqm->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->total_cbm->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->sailing_week->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->completed->AdvancedSearch->load();
		$this->label->AdvancedSearch->load();
		$this->weight_sqm->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.foms_table_2list,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.foms_table_2list,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.foms_table_2list,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_oms_table_2\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_oms_table_2',hdr:ew.language.phrase('ExportToEmailText'),f:document.foms_table_2list,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_weaving_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_current_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyers_id":
							break;
						case "x_reports_to":
							break;
						case "x_order_week":
							break;
						case "x_ex_factory":
							break;
						case "x_ex_factory_p":
							break;
						case "x_category":
							break;
						case "x_weaving_works":
							break;
						case "x_current_works":
							break;
						case "x_status":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		IF (isset($_GET['CID']))
		{
		ExecuteStatement("TRUNCATE TABLE `oms_table_2`");
		ExecuteStatement("INSERT INTO `oms_table_2` (`id`, `buyers_id`, `reports_to`, `order_week`, `order_date`, `category`, `weaving_works`, `current_works`, `buyer_order`, `po`, `item`, `buyer_ref`, `design`, `size_buyer`, `width`, `length`, `qty`, `revised_qty`, `sqm`, `weight_sqm`, `ex_factory`, `ex_factory_p`, `shipping_mode`, `remarks`, `d_qty`, `pl_no`, `invoice_date`, `sailing_week`, `pending`, `pending_sqm`, `cbm`, `total_cbm`, `offloom`, `status`, `rejection`, `completed`, `cs`) SELECT `id`, `buyers_id`, `reports_to`, `order_week`, `order_date`, `category`, `weaving_works`, `current_works`, `buyer_order`, `po`, `item`, `buyer_ref`, `design`, `size_buyer`, `width`, `length`, `qty`, `revised_qty`, `sqm`, `weight_sqm`, `ex_factory`, `ex_factory_p`, `shipping_mode`, `remarks`, `d_qty`, `pl_no`, `invoice_date`, `sailing_week`, `pending`, `pending_sqm`, `cbm`, `total_cbm`, `offloom`, `status`, `rejection`, `completed`, `cs` FROM `query_oms_2`");
	header("location: oms_table_2list.php");	
		}	
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		$item = &$this->OtherOptions['action']->Add("Re-fresh");
		$item->Body = '<a href="oms_table_2list.php?CID=7fa7" data-original-title ="Re-fresh"><i data-phrase="Re-fresh"  class="fa fa-refresh ew-icon" style="color:red" ></i></a>';
		$item->Visible = True;	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>