<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class oms_table_edit extends oms_table
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'oms_table';

	// Page object name
	public $PageObjName = "oms_table_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (oms_table)
		if (!isset($GLOBALS["oms_table"]) || get_class($GLOBALS["oms_table"]) == PROJECT_NAMESPACE . "oms_table") {
			$GLOBALS["oms_table"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["oms_table"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'oms_table');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $oms_table;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($oms_table);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "oms_tableview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("oms_tablelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->buyers_id->setVisibility();
		$this->reports_to->setVisibility();
		$this->buyer_order->setVisibility();
		$this->item->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->order_week->setVisibility();
		$this->order_date->setVisibility();
		$this->ex_factory->setVisibility();
		$this->ex_factory_p->setVisibility();
		$this->shipping_mode->setVisibility();
		$this->po->setVisibility();
		$this->design->setVisibility();
		$this->size_buyer->setVisibility();
		$this->width->setVisibility();
		$this->length->setVisibility();
		$this->qty->setVisibility();
		$this->revised_qty->setVisibility();
		$this->sqm->setVisibility();
		$this->d_qty->setVisibility();
		$this->pending->setVisibility();
		$this->pending_sqm->setVisibility();
		$this->offloom->setVisibility();
		$this->pending_offloom->setVisibility();
		$this->pending_offloom_sqm->setVisibility();
		$this->cbm->setVisibility();
		$this->total_cbm->setVisibility();
		$this->remarks->setVisibility();
		$this->pl_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->sailing_week->setVisibility();
		$this->seller_remarks->setVisibility();
		$this->status->setVisibility();
		$this->rejection->setVisibility();
		$this->completed->Visible = FALSE;
		$this->url->Visible = FALSE;
		$this->url2->Visible = FALSE;
		$this->weight_sqm->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->id->Required = FALSE;
		$this->ex_factory_p->Required = FALSE;
		$this->cbm->Required = FALSE;
		$this->total_cbm->Required = FALSE;
		$this->invoice_date->Required = FALSE;
		$this->sailing_week->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->order_week);
		$this->setupLookupOptions($this->ex_factory);
		$this->setupLookupOptions($this->ex_factory_p);
		$this->setupLookupOptions($this->status);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("oms_tablelist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "oms_tablelist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id->Visible = FALSE; // Disable update for API request
			else
				$this->id->setFormValue($val);
		}

		// Check field name 'buyers_id' first before field var 'x_buyers_id'
		$val = $CurrentForm->hasValue("buyers_id") ? $CurrentForm->getValue("buyers_id") : $CurrentForm->getValue("x_buyers_id");
		if (!$this->buyers_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyers_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyers_id->setFormValue($val);
		}

		// Check field name 'reports_to' first before field var 'x_reports_to'
		$val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
		if (!$this->reports_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reports_to->Visible = FALSE; // Disable update for API request
			else
				$this->reports_to->setFormValue($val);
		}

		// Check field name 'buyer_order' first before field var 'x_buyer_order'
		$val = $CurrentForm->hasValue("buyer_order") ? $CurrentForm->getValue("buyer_order") : $CurrentForm->getValue("x_buyer_order");
		if (!$this->buyer_order->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_order->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_order->setFormValue($val);
		}

		// Check field name 'item' first before field var 'x_item'
		$val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
		if (!$this->item->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->item->Visible = FALSE; // Disable update for API request
			else
				$this->item->setFormValue($val);
		}

		// Check field name 'buyer_ref' first before field var 'x_buyer_ref'
		$val = $CurrentForm->hasValue("buyer_ref") ? $CurrentForm->getValue("buyer_ref") : $CurrentForm->getValue("x_buyer_ref");
		if (!$this->buyer_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_ref->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_ref->setFormValue($val);
		}

		// Check field name 'order_week' first before field var 'x_order_week'
		$val = $CurrentForm->hasValue("order_week") ? $CurrentForm->getValue("order_week") : $CurrentForm->getValue("x_order_week");
		if (!$this->order_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_week->Visible = FALSE; // Disable update for API request
			else
				$this->order_week->setFormValue($val);
		}

		// Check field name 'order_date' first before field var 'x_order_date'
		$val = $CurrentForm->hasValue("order_date") ? $CurrentForm->getValue("order_date") : $CurrentForm->getValue("x_order_date");
		if (!$this->order_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_date->Visible = FALSE; // Disable update for API request
			else
				$this->order_date->setFormValue($val);
			$this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, 2);
		}

		// Check field name 'ex_factory' first before field var 'x_ex_factory'
		$val = $CurrentForm->hasValue("ex_factory") ? $CurrentForm->getValue("ex_factory") : $CurrentForm->getValue("x_ex_factory");
		if (!$this->ex_factory->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ex_factory->Visible = FALSE; // Disable update for API request
			else
				$this->ex_factory->setFormValue($val);
		}

		// Check field name 'ex_factory_p' first before field var 'x_ex_factory_p'
		$val = $CurrentForm->hasValue("ex_factory_p") ? $CurrentForm->getValue("ex_factory_p") : $CurrentForm->getValue("x_ex_factory_p");
		if (!$this->ex_factory_p->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ex_factory_p->Visible = FALSE; // Disable update for API request
			else
				$this->ex_factory_p->setFormValue($val);
		}

		// Check field name 'shipping_mode' first before field var 'x_shipping_mode'
		$val = $CurrentForm->hasValue("shipping_mode") ? $CurrentForm->getValue("shipping_mode") : $CurrentForm->getValue("x_shipping_mode");
		if (!$this->shipping_mode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_mode->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_mode->setFormValue($val);
		}

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'design' first before field var 'x_design'
		$val = $CurrentForm->hasValue("design") ? $CurrentForm->getValue("design") : $CurrentForm->getValue("x_design");
		if (!$this->design->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->design->Visible = FALSE; // Disable update for API request
			else
				$this->design->setFormValue($val);
		}

		// Check field name 'size_buyer' first before field var 'x_size_buyer'
		$val = $CurrentForm->hasValue("size_buyer") ? $CurrentForm->getValue("size_buyer") : $CurrentForm->getValue("x_size_buyer");
		if (!$this->size_buyer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size_buyer->Visible = FALSE; // Disable update for API request
			else
				$this->size_buyer->setFormValue($val);
		}

		// Check field name 'width' first before field var 'x_width'
		$val = $CurrentForm->hasValue("width") ? $CurrentForm->getValue("width") : $CurrentForm->getValue("x_width");
		if (!$this->width->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->width->Visible = FALSE; // Disable update for API request
			else
				$this->width->setFormValue($val);
		}

		// Check field name 'length' first before field var 'x_length'
		$val = $CurrentForm->hasValue("length") ? $CurrentForm->getValue("length") : $CurrentForm->getValue("x_length");
		if (!$this->length->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->length->Visible = FALSE; // Disable update for API request
			else
				$this->length->setFormValue($val);
		}

		// Check field name 'qty' first before field var 'x_qty'
		$val = $CurrentForm->hasValue("qty") ? $CurrentForm->getValue("qty") : $CurrentForm->getValue("x_qty");
		if (!$this->qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty->Visible = FALSE; // Disable update for API request
			else
				$this->qty->setFormValue($val);
		}

		// Check field name 'revised_qty' first before field var 'x_revised_qty'
		$val = $CurrentForm->hasValue("revised_qty") ? $CurrentForm->getValue("revised_qty") : $CurrentForm->getValue("x_revised_qty");
		if (!$this->revised_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->revised_qty->Visible = FALSE; // Disable update for API request
			else
				$this->revised_qty->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 'd_qty' first before field var 'x_d_qty'
		$val = $CurrentForm->hasValue("d_qty") ? $CurrentForm->getValue("d_qty") : $CurrentForm->getValue("x_d_qty");
		if (!$this->d_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_qty->Visible = FALSE; // Disable update for API request
			else
				$this->d_qty->setFormValue($val);
		}

		// Check field name 'pending' first before field var 'x_pending'
		$val = $CurrentForm->hasValue("pending") ? $CurrentForm->getValue("pending") : $CurrentForm->getValue("x_pending");
		if (!$this->pending->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pending->Visible = FALSE; // Disable update for API request
			else
				$this->pending->setFormValue($val);
		}

		// Check field name 'pending_sqm' first before field var 'x_pending_sqm'
		$val = $CurrentForm->hasValue("pending_sqm") ? $CurrentForm->getValue("pending_sqm") : $CurrentForm->getValue("x_pending_sqm");
		if (!$this->pending_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pending_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->pending_sqm->setFormValue($val);
		}

		// Check field name 'offloom' first before field var 'x_offloom'
		$val = $CurrentForm->hasValue("offloom") ? $CurrentForm->getValue("offloom") : $CurrentForm->getValue("x_offloom");
		if (!$this->offloom->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->offloom->Visible = FALSE; // Disable update for API request
			else
				$this->offloom->setFormValue($val);
		}

		// Check field name 'pending_offloom' first before field var 'x_pending_offloom'
		$val = $CurrentForm->hasValue("pending_offloom") ? $CurrentForm->getValue("pending_offloom") : $CurrentForm->getValue("x_pending_offloom");
		if (!$this->pending_offloom->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pending_offloom->Visible = FALSE; // Disable update for API request
			else
				$this->pending_offloom->setFormValue($val);
		}

		// Check field name 'pending_offloom_sqm' first before field var 'x_pending_offloom_sqm'
		$val = $CurrentForm->hasValue("pending_offloom_sqm") ? $CurrentForm->getValue("pending_offloom_sqm") : $CurrentForm->getValue("x_pending_offloom_sqm");
		if (!$this->pending_offloom_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pending_offloom_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->pending_offloom_sqm->setFormValue($val);
		}

		// Check field name 'cbm' first before field var 'x_cbm'
		$val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
		if (!$this->cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cbm->Visible = FALSE; // Disable update for API request
			else
				$this->cbm->setFormValue($val);
		}

		// Check field name 'total_cbm' first before field var 'x_total_cbm'
		$val = $CurrentForm->hasValue("total_cbm") ? $CurrentForm->getValue("total_cbm") : $CurrentForm->getValue("x_total_cbm");
		if (!$this->total_cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->total_cbm->Visible = FALSE; // Disable update for API request
			else
				$this->total_cbm->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'pl_no' first before field var 'x_pl_no'
		$val = $CurrentForm->hasValue("pl_no") ? $CurrentForm->getValue("pl_no") : $CurrentForm->getValue("x_pl_no");
		if (!$this->pl_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pl_no->Visible = FALSE; // Disable update for API request
			else
				$this->pl_no->setFormValue($val);
		}

		// Check field name 'invoice_date' first before field var 'x_invoice_date'
		$val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
		if (!$this->invoice_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_date->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_date->setFormValue($val);
			$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 0);
		}

		// Check field name 'sailing_week' first before field var 'x_sailing_week'
		$val = $CurrentForm->hasValue("sailing_week") ? $CurrentForm->getValue("sailing_week") : $CurrentForm->getValue("x_sailing_week");
		if (!$this->sailing_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sailing_week->Visible = FALSE; // Disable update for API request
			else
				$this->sailing_week->setFormValue($val);
		}

		// Check field name 'seller_remarks' first before field var 'x_seller_remarks'
		$val = $CurrentForm->hasValue("seller_remarks") ? $CurrentForm->getValue("seller_remarks") : $CurrentForm->getValue("x_seller_remarks");
		if (!$this->seller_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->seller_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->seller_remarks->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'rejection' first before field var 'x_rejection'
		$val = $CurrentForm->hasValue("rejection") ? $CurrentForm->getValue("rejection") : $CurrentForm->getValue("x_rejection");
		if (!$this->rejection->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rejection->Visible = FALSE; // Disable update for API request
			else
				$this->rejection->setFormValue($val);
		}

		// Check field name 'weight_sqm' first before field var 'x_weight_sqm'
		$val = $CurrentForm->hasValue("weight_sqm") ? $CurrentForm->getValue("weight_sqm") : $CurrentForm->getValue("x_weight_sqm");
		if (!$this->weight_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->weight_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->weight_sqm->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->buyers_id->CurrentValue = $this->buyers_id->FormValue;
		$this->reports_to->CurrentValue = $this->reports_to->FormValue;
		$this->buyer_order->CurrentValue = $this->buyer_order->FormValue;
		$this->item->CurrentValue = $this->item->FormValue;
		$this->buyer_ref->CurrentValue = $this->buyer_ref->FormValue;
		$this->order_week->CurrentValue = $this->order_week->FormValue;
		$this->order_date->CurrentValue = $this->order_date->FormValue;
		$this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, 2);
		$this->ex_factory->CurrentValue = $this->ex_factory->FormValue;
		$this->ex_factory_p->CurrentValue = $this->ex_factory_p->FormValue;
		$this->shipping_mode->CurrentValue = $this->shipping_mode->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->design->CurrentValue = $this->design->FormValue;
		$this->size_buyer->CurrentValue = $this->size_buyer->FormValue;
		$this->width->CurrentValue = $this->width->FormValue;
		$this->length->CurrentValue = $this->length->FormValue;
		$this->qty->CurrentValue = $this->qty->FormValue;
		$this->revised_qty->CurrentValue = $this->revised_qty->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->d_qty->CurrentValue = $this->d_qty->FormValue;
		$this->pending->CurrentValue = $this->pending->FormValue;
		$this->pending_sqm->CurrentValue = $this->pending_sqm->FormValue;
		$this->offloom->CurrentValue = $this->offloom->FormValue;
		$this->pending_offloom->CurrentValue = $this->pending_offloom->FormValue;
		$this->pending_offloom_sqm->CurrentValue = $this->pending_offloom_sqm->FormValue;
		$this->cbm->CurrentValue = $this->cbm->FormValue;
		$this->total_cbm->CurrentValue = $this->total_cbm->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->pl_no->CurrentValue = $this->pl_no->FormValue;
		$this->invoice_date->CurrentValue = $this->invoice_date->FormValue;
		$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 0);
		$this->sailing_week->CurrentValue = $this->sailing_week->FormValue;
		$this->seller_remarks->CurrentValue = $this->seller_remarks->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->rejection->CurrentValue = $this->rejection->FormValue;
		$this->weight_sqm->CurrentValue = $this->weight_sqm->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->buyers_id->setDbValue($row['buyers_id']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->buyer_order->setDbValue($row['buyer_order']);
		$this->item->setDbValue($row['item']);
		$this->buyer_ref->setDbValue($row['buyer_ref']);
		$this->order_week->setDbValue($row['order_week']);
		$this->order_date->setDbValue($row['order_date']);
		$this->ex_factory->setDbValue($row['ex_factory']);
		$this->ex_factory_p->setDbValue($row['ex_factory_p']);
		$this->shipping_mode->setDbValue($row['shipping_mode']);
		$this->po->setDbValue($row['po']);
		$this->design->setDbValue($row['design']);
		$this->size_buyer->setDbValue($row['size_buyer']);
		$this->width->setDbValue($row['width']);
		$this->length->setDbValue($row['length']);
		$this->qty->setDbValue($row['qty']);
		$this->revised_qty->setDbValue($row['revised_qty']);
		$this->sqm->setDbValue($row['sqm']);
		$this->d_qty->setDbValue($row['d_qty']);
		$this->pending->setDbValue($row['pending']);
		$this->pending_sqm->setDbValue($row['pending_sqm']);
		$this->offloom->setDbValue($row['offloom']);
		$this->pending_offloom->setDbValue($row['pending_offloom']);
		$this->pending_offloom_sqm->setDbValue($row['pending_offloom_sqm']);
		$this->cbm->setDbValue($row['cbm']);
		$this->total_cbm->setDbValue($row['total_cbm']);
		$this->remarks->setDbValue($row['remarks']);
		$this->pl_no->setDbValue($row['pl_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->sailing_week->setDbValue($row['sailing_week']);
		$this->seller_remarks->setDbValue($row['seller_remarks']);
		$this->status->setDbValue($row['status']);
		$this->rejection->setDbValue($row['rejection']);
		$this->completed->setDbValue($row['completed']);
		$this->url->setDbValue($row['url']);
		$this->url2->setDbValue($row['url2']);
		$this->weight_sqm->setDbValue($row['weight_sqm']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['buyers_id'] = NULL;
		$row['reports_to'] = NULL;
		$row['buyer_order'] = NULL;
		$row['item'] = NULL;
		$row['buyer_ref'] = NULL;
		$row['order_week'] = NULL;
		$row['order_date'] = NULL;
		$row['ex_factory'] = NULL;
		$row['ex_factory_p'] = NULL;
		$row['shipping_mode'] = NULL;
		$row['po'] = NULL;
		$row['design'] = NULL;
		$row['size_buyer'] = NULL;
		$row['width'] = NULL;
		$row['length'] = NULL;
		$row['qty'] = NULL;
		$row['revised_qty'] = NULL;
		$row['sqm'] = NULL;
		$row['d_qty'] = NULL;
		$row['pending'] = NULL;
		$row['pending_sqm'] = NULL;
		$row['offloom'] = NULL;
		$row['pending_offloom'] = NULL;
		$row['pending_offloom_sqm'] = NULL;
		$row['cbm'] = NULL;
		$row['total_cbm'] = NULL;
		$row['remarks'] = NULL;
		$row['pl_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['sailing_week'] = NULL;
		$row['seller_remarks'] = NULL;
		$row['status'] = NULL;
		$row['rejection'] = NULL;
		$row['completed'] = NULL;
		$row['url'] = NULL;
		$row['url2'] = NULL;
		$row['weight_sqm'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->id->FormValue == $this->id->CurrentValue && is_numeric(ConvertToFloatString($this->id->CurrentValue)))
			$this->id->CurrentValue = ConvertToFloatString($this->id->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_sqm->FormValue == $this->pending_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->pending_sqm->CurrentValue)))
			$this->pending_sqm->CurrentValue = ConvertToFloatString($this->pending_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_offloom_sqm->FormValue == $this->pending_offloom_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->pending_offloom_sqm->CurrentValue)))
			$this->pending_offloom_sqm->CurrentValue = ConvertToFloatString($this->pending_offloom_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight_sqm->FormValue == $this->weight_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->weight_sqm->CurrentValue)))
			$this->weight_sqm->CurrentValue = ConvertToFloatString($this->weight_sqm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// buyers_id
		// reports_to
		// buyer_order
		// item
		// buyer_ref
		// order_week
		// order_date
		// ex_factory
		// ex_factory_p
		// shipping_mode
		// po
		// design
		// size_buyer
		// width
		// length
		// qty
		// revised_qty
		// sqm
		// d_qty
		// pending
		// pending_sqm
		// offloom
		// pending_offloom
		// pending_offloom_sqm
		// cbm
		// total_cbm
		// remarks
		// pl_no
		// invoice_date
		// sailing_week
		// seller_remarks
		// status
		// rejection
		// completed
		// url
		// url2
		// weight_sqm

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer_order
			$this->buyer_order->ViewValue = $this->buyer_order->CurrentValue;
			$this->buyer_order->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			$this->item->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_week
			$curVal = strval($this->order_week->CurrentValue);
			if ($curVal <> "") {
				$this->order_week->ViewValue = $this->order_week->lookupCacheOption($curVal);
				if ($this->order_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->order_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->order_week->ViewValue = $this->order_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->order_week->ViewValue = $this->order_week->CurrentValue;
					}
				}
			} else {
				$this->order_week->ViewValue = NULL;
			}
			$this->order_week->ViewCustomAttributes = "";

			// order_date
			$this->order_date->ViewValue = $this->order_date->CurrentValue;
			$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 2);
			$this->order_date->ViewCustomAttributes = "";

			// ex_factory
			$curVal = strval($this->ex_factory->CurrentValue);
			if ($curVal <> "") {
				$this->ex_factory->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
				if ($this->ex_factory->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ex_factory->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->ex_factory->ViewValue = $this->ex_factory->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ex_factory->ViewValue = $this->ex_factory->CurrentValue;
					}
				}
			} else {
				$this->ex_factory->ViewValue = NULL;
			}
			$this->ex_factory->ViewCustomAttributes = "";

			// ex_factory_p
			$curVal = strval($this->ex_factory_p->CurrentValue);
			if ($curVal <> "") {
				$this->ex_factory_p->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
				if ($this->ex_factory_p->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->ex_factory_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->ex_factory_p->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->ex_factory_p->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->ex_factory_p->ViewValue = $this->ex_factory_p->CurrentValue;
					}
				}
			} else {
				$this->ex_factory_p->ViewValue = NULL;
			}
			$this->ex_factory_p->ViewCustomAttributes = "";

			// shipping_mode
			$this->shipping_mode->ViewValue = $this->shipping_mode->CurrentValue;
			$this->shipping_mode->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// width
			$this->width->ViewValue = $this->width->CurrentValue;
			$this->width->ViewValue = FormatNumber($this->width->ViewValue, 0, -2, -2, -2);
			$this->width->ViewCustomAttributes = "";

			// length
			$this->length->ViewValue = $this->length->CurrentValue;
			$this->length->ViewValue = FormatNumber($this->length->ViewValue, 0, -2, -2, -2);
			$this->length->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// revised_qty
			$this->revised_qty->ViewValue = $this->revised_qty->CurrentValue;
			$this->revised_qty->ViewValue = FormatNumber($this->revised_qty->ViewValue, 0, -2, -2, -2);
			$this->revised_qty->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// d_qty
			$this->d_qty->ViewValue = $this->d_qty->CurrentValue;
			$this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, 2, -2, -2, -2);
			$this->d_qty->ViewCustomAttributes = "";

			// pending
			$this->pending->ViewValue = $this->pending->CurrentValue;
			$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 0, -1, -2, -2);
			$this->pending->ViewCustomAttributes = "";

			// pending_sqm
			$this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
			$this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, 2, -2, -2, -2);
			$this->pending_sqm->ViewCustomAttributes = "";

			// offloom
			$this->offloom->ViewValue = $this->offloom->CurrentValue;
			$this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, 0, -2, -2, -2);
			$this->offloom->ViewCustomAttributes = "";

			// pending_offloom
			$this->pending_offloom->ViewValue = $this->pending_offloom->CurrentValue;
			$this->pending_offloom->ViewValue = FormatNumber($this->pending_offloom->ViewValue, 0, -2, -2, -2);
			$this->pending_offloom->ViewCustomAttributes = "";

			// pending_offloom_sqm
			$this->pending_offloom_sqm->ViewValue = $this->pending_offloom_sqm->CurrentValue;
			$this->pending_offloom_sqm->ViewValue = FormatNumber($this->pending_offloom_sqm->ViewValue, 2, -2, -2, -2);
			$this->pending_offloom_sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// total_cbm
			$this->total_cbm->ViewValue = $this->total_cbm->CurrentValue;
			$this->total_cbm->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewCustomAttributes = "";

			// sailing_week
			$this->sailing_week->ViewValue = $this->sailing_week->CurrentValue;
			$this->sailing_week->ViewCustomAttributes = "";

			// seller_remarks
			$this->seller_remarks->ViewValue = $this->seller_remarks->CurrentValue;
			$this->seller_remarks->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->status->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->status->ViewValue->add($this->status->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// rejection
			$this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, 0, -2, -2, -2);
			$this->rejection->ViewCustomAttributes = "";

			// completed
			if (strval($this->completed->CurrentValue) <> "") {
				$this->completed->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->completed->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->completed->ViewValue->add($this->completed->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->completed->ViewValue = NULL;
			}
			$this->completed->ViewCustomAttributes = "";

			// weight_sqm
			$this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
			$this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, 2, -2, -2, -2);
			$this->weight_sqm->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			$this->buyers_id->HrefValue = "";
			$this->buyers_id->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer_order
			$this->buyer_order->LinkCustomAttributes = "";
			$this->buyer_order->HrefValue = "";
			$this->buyer_order->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			$this->item->HrefValue = "";
			$this->item->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			$this->buyer_ref->HrefValue = "";
			$this->buyer_ref->TooltipValue = "";

			// order_week
			$this->order_week->LinkCustomAttributes = "";
			$this->order_week->HrefValue = "";
			$this->order_week->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// ex_factory
			$this->ex_factory->LinkCustomAttributes = "";
			$this->ex_factory->HrefValue = "";
			$this->ex_factory->TooltipValue = "";

			// ex_factory_p
			$this->ex_factory_p->LinkCustomAttributes = "";
			$this->ex_factory_p->HrefValue = "";
			$this->ex_factory_p->TooltipValue = "";

			// shipping_mode
			$this->shipping_mode->LinkCustomAttributes = "";
			$this->shipping_mode->HrefValue = "";
			$this->shipping_mode->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// size_buyer
			$this->size_buyer->LinkCustomAttributes = "";
			$this->size_buyer->HrefValue = "";
			$this->size_buyer->TooltipValue = "";

			// width
			$this->width->LinkCustomAttributes = "";
			$this->width->HrefValue = "";
			$this->width->TooltipValue = "";

			// length
			$this->length->LinkCustomAttributes = "";
			$this->length->HrefValue = "";
			$this->length->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// revised_qty
			$this->revised_qty->LinkCustomAttributes = "";
			$this->revised_qty->HrefValue = "";
			$this->revised_qty->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// d_qty
			$this->d_qty->LinkCustomAttributes = "";
			$this->d_qty->HrefValue = "";
			$this->d_qty->TooltipValue = "";

			// pending
			$this->pending->LinkCustomAttributes = "";
			if (!EmptyValue($this->url2->CurrentValue)) {
				$this->pending->HrefValue = $this->url2->CurrentValue; // Add prefix/suffix
				$this->pending->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->pending->HrefValue = FullUrl($this->pending->HrefValue, "href");
			} else {
				$this->pending->HrefValue = "";
			}
			$this->pending->TooltipValue = "";

			// pending_sqm
			$this->pending_sqm->LinkCustomAttributes = "";
			$this->pending_sqm->HrefValue = "";
			$this->pending_sqm->TooltipValue = "";

			// offloom
			$this->offloom->LinkCustomAttributes = "";
			$this->offloom->HrefValue = "";
			$this->offloom->TooltipValue = "";

			// pending_offloom
			$this->pending_offloom->LinkCustomAttributes = "";
			$this->pending_offloom->HrefValue = "";
			$this->pending_offloom->TooltipValue = "";

			// pending_offloom_sqm
			$this->pending_offloom_sqm->LinkCustomAttributes = "";
			$this->pending_offloom_sqm->HrefValue = "";
			$this->pending_offloom_sqm->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// total_cbm
			$this->total_cbm->LinkCustomAttributes = "";
			$this->total_cbm->HrefValue = "";
			$this->total_cbm->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->pl_no->HrefValue = "javascript:pldetails('" . $this->url->CurrentValue . "');"; // Add prefix/suffix
				$this->pl_no->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->pl_no->HrefValue = FullUrl($this->pl_no->HrefValue, "href");
			} else {
				$this->pl_no->HrefValue = "";
			}
			$this->pl_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// sailing_week
			$this->sailing_week->LinkCustomAttributes = "";
			$this->sailing_week->HrefValue = "";
			$this->sailing_week->TooltipValue = "";

			// seller_remarks
			$this->seller_remarks->LinkCustomAttributes = "";
			$this->seller_remarks->HrefValue = "";
			$this->seller_remarks->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// rejection
			$this->rejection->LinkCustomAttributes = "";
			$this->rejection->HrefValue = "";
			$this->rejection->TooltipValue = "";

			// weight_sqm
			$this->weight_sqm->LinkCustomAttributes = "";
			$this->weight_sqm->HrefValue = "";
			$this->weight_sqm->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->EditValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->EditValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->EditValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->EditValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->EditValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer_order
			$this->buyer_order->EditAttrs["class"] = "form-control";
			$this->buyer_order->EditCustomAttributes = "";
			$this->buyer_order->EditValue = $this->buyer_order->CurrentValue;
			$this->buyer_order->ViewCustomAttributes = "";

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			$this->item->EditValue = $this->item->CurrentValue;
			$this->item->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_week
			$this->order_week->EditAttrs["class"] = "form-control";
			$this->order_week->EditCustomAttributes = "";
			$curVal = strval($this->order_week->CurrentValue);
			if ($curVal <> "") {
				$this->order_week->EditValue = $this->order_week->lookupCacheOption($curVal);
				if ($this->order_week->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->order_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->order_week->EditValue = $this->order_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->order_week->EditValue = $this->order_week->CurrentValue;
					}
				}
			} else {
				$this->order_week->EditValue = NULL;
			}
			$this->order_week->ViewCustomAttributes = "";

			// order_date
			$this->order_date->EditAttrs["class"] = "form-control";
			$this->order_date->EditCustomAttributes = "";
			$this->order_date->EditValue = $this->order_date->CurrentValue;
			$this->order_date->EditValue = FormatDateTime($this->order_date->EditValue, 2);
			$this->order_date->ViewCustomAttributes = "";

			// ex_factory
			$this->ex_factory->EditAttrs["class"] = "form-control";
			$this->ex_factory->EditCustomAttributes = "";
			$curVal = strval($this->ex_factory->CurrentValue);
			if ($curVal <> "") {
				$this->ex_factory->EditValue = $this->ex_factory->lookupCacheOption($curVal);
				if ($this->ex_factory->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ex_factory->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->ex_factory->EditValue = $this->ex_factory->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ex_factory->EditValue = $this->ex_factory->CurrentValue;
					}
				}
			} else {
				$this->ex_factory->EditValue = NULL;
			}
			$this->ex_factory->ViewCustomAttributes = "";

			// ex_factory_p
			$this->ex_factory_p->EditAttrs["class"] = "form-control";
			$this->ex_factory_p->EditCustomAttributes = "";
			$curVal = strval($this->ex_factory_p->CurrentValue);
			if ($curVal <> "") {
				$this->ex_factory_p->EditValue = $this->ex_factory_p->lookupCacheOption($curVal);
				if ($this->ex_factory_p->EditValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->ex_factory_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->ex_factory_p->EditValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->ex_factory_p->EditValue->add($this->ex_factory_p->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->ex_factory_p->EditValue = $this->ex_factory_p->CurrentValue;
					}
				}
			} else {
				$this->ex_factory_p->EditValue = NULL;
			}
			$this->ex_factory_p->ViewCustomAttributes = "";

			// shipping_mode
			$this->shipping_mode->EditAttrs["class"] = "form-control";
			$this->shipping_mode->EditCustomAttributes = "";
			$this->shipping_mode->EditValue = $this->shipping_mode->CurrentValue;
			$this->shipping_mode->ViewCustomAttributes = "";

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = $this->po->CurrentValue;
			$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design
			$this->design->EditAttrs["class"] = "form-control";
			$this->design->EditCustomAttributes = "";
			$this->design->EditValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->EditAttrs["class"] = "form-control";
			$this->size_buyer->EditCustomAttributes = "";
			$this->size_buyer->EditValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// width
			$this->width->EditAttrs["class"] = "form-control";
			$this->width->EditCustomAttributes = "";
			$this->width->EditValue = $this->width->CurrentValue;
			$this->width->EditValue = FormatNumber($this->width->EditValue, 0, -2, -2, -2);
			$this->width->ViewCustomAttributes = "";

			// length
			$this->length->EditAttrs["class"] = "form-control";
			$this->length->EditCustomAttributes = "";
			$this->length->EditValue = $this->length->CurrentValue;
			$this->length->EditValue = FormatNumber($this->length->EditValue, 0, -2, -2, -2);
			$this->length->ViewCustomAttributes = "";

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = $this->qty->CurrentValue;
			$this->qty->EditValue = FormatNumber($this->qty->EditValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// revised_qty
			$this->revised_qty->EditAttrs["class"] = "form-control";
			$this->revised_qty->EditCustomAttributes = "";
			$this->revised_qty->EditValue = $this->revised_qty->CurrentValue;
			$this->revised_qty->EditValue = FormatNumber($this->revised_qty->EditValue, 0, -2, -2, -2);
			$this->revised_qty->ViewCustomAttributes = "";

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = $this->sqm->CurrentValue;
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// d_qty
			$this->d_qty->EditAttrs["class"] = "form-control";
			$this->d_qty->EditCustomAttributes = "";
			$this->d_qty->EditValue = $this->d_qty->CurrentValue;
			$this->d_qty->EditValue = FormatNumber($this->d_qty->EditValue, 2, -2, -2, -2);
			$this->d_qty->ViewCustomAttributes = "";

			// pending
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue = $this->pending->CurrentValue;
			$this->pending->EditValue = FormatNumber($this->pending->EditValue, 0, -1, -2, -2);
			$this->pending->ViewCustomAttributes = "";

			// pending_sqm
			$this->pending_sqm->EditAttrs["class"] = "form-control";
			$this->pending_sqm->EditCustomAttributes = "";
			$this->pending_sqm->EditValue = $this->pending_sqm->CurrentValue;
			$this->pending_sqm->EditValue = FormatNumber($this->pending_sqm->EditValue, 2, -2, -2, -2);
			$this->pending_sqm->ViewCustomAttributes = "";

			// offloom
			$this->offloom->EditAttrs["class"] = "form-control";
			$this->offloom->EditCustomAttributes = "";
			$this->offloom->EditValue = $this->offloom->CurrentValue;
			$this->offloom->EditValue = FormatNumber($this->offloom->EditValue, 0, -2, -2, -2);
			$this->offloom->ViewCustomAttributes = "";

			// pending_offloom
			$this->pending_offloom->EditAttrs["class"] = "form-control";
			$this->pending_offloom->EditCustomAttributes = "";
			$this->pending_offloom->EditValue = $this->pending_offloom->CurrentValue;
			$this->pending_offloom->EditValue = FormatNumber($this->pending_offloom->EditValue, 0, -2, -2, -2);
			$this->pending_offloom->ViewCustomAttributes = "";

			// pending_offloom_sqm
			$this->pending_offloom_sqm->EditAttrs["class"] = "form-control";
			$this->pending_offloom_sqm->EditCustomAttributes = "";
			$this->pending_offloom_sqm->EditValue = $this->pending_offloom_sqm->CurrentValue;
			$this->pending_offloom_sqm->EditValue = FormatNumber($this->pending_offloom_sqm->EditValue, 2, -2, -2, -2);
			$this->pending_offloom_sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			$this->cbm->EditValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// total_cbm
			$this->total_cbm->EditAttrs["class"] = "form-control";
			$this->total_cbm->EditCustomAttributes = "";
			$this->total_cbm->EditValue = $this->total_cbm->CurrentValue;
			$this->total_cbm->ViewCustomAttributes = "";

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			$this->pl_no->EditValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewCustomAttributes = "";

			// sailing_week
			$this->sailing_week->EditAttrs["class"] = "form-control";
			$this->sailing_week->EditCustomAttributes = "";
			$this->sailing_week->EditValue = $this->sailing_week->CurrentValue;
			$this->sailing_week->ViewCustomAttributes = "";

			// seller_remarks
			$this->seller_remarks->EditAttrs["class"] = "form-control";
			$this->seller_remarks->EditCustomAttributes = "";
			$this->seller_remarks->EditValue = HtmlEncode($this->seller_remarks->CurrentValue);
			$this->seller_remarks->PlaceHolder = RemoveHtml($this->seller_remarks->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->EditValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->EditValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->status->EditValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->status->EditValue->add($this->status->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->status->EditValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// rejection
			$this->rejection->EditAttrs["class"] = "form-control";
			$this->rejection->EditCustomAttributes = "";
			$this->rejection->EditValue = FormatNumber($this->rejection->EditValue, 0, -2, -2, -2);
			$this->rejection->ViewCustomAttributes = "";

			// weight_sqm
			$this->weight_sqm->EditAttrs["class"] = "form-control";
			$this->weight_sqm->EditCustomAttributes = "";
			$this->weight_sqm->EditValue = HtmlEncode($this->weight_sqm->CurrentValue);
			$this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
			if (strval($this->weight_sqm->EditValue) <> "" && is_numeric($this->weight_sqm->EditValue))
				$this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, -2, -2, -2, -2);

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			$this->buyers_id->HrefValue = "";
			$this->buyers_id->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer_order
			$this->buyer_order->LinkCustomAttributes = "";
			$this->buyer_order->HrefValue = "";
			$this->buyer_order->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			$this->item->HrefValue = "";
			$this->item->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			$this->buyer_ref->HrefValue = "";
			$this->buyer_ref->TooltipValue = "";

			// order_week
			$this->order_week->LinkCustomAttributes = "";
			$this->order_week->HrefValue = "";
			$this->order_week->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// ex_factory
			$this->ex_factory->LinkCustomAttributes = "";
			$this->ex_factory->HrefValue = "";
			$this->ex_factory->TooltipValue = "";

			// ex_factory_p
			$this->ex_factory_p->LinkCustomAttributes = "";
			$this->ex_factory_p->HrefValue = "";
			$this->ex_factory_p->TooltipValue = "";

			// shipping_mode
			$this->shipping_mode->LinkCustomAttributes = "";
			$this->shipping_mode->HrefValue = "";
			$this->shipping_mode->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// size_buyer
			$this->size_buyer->LinkCustomAttributes = "";
			$this->size_buyer->HrefValue = "";
			$this->size_buyer->TooltipValue = "";

			// width
			$this->width->LinkCustomAttributes = "";
			$this->width->HrefValue = "";
			$this->width->TooltipValue = "";

			// length
			$this->length->LinkCustomAttributes = "";
			$this->length->HrefValue = "";
			$this->length->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// revised_qty
			$this->revised_qty->LinkCustomAttributes = "";
			$this->revised_qty->HrefValue = "";
			$this->revised_qty->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// d_qty
			$this->d_qty->LinkCustomAttributes = "";
			$this->d_qty->HrefValue = "";
			$this->d_qty->TooltipValue = "";

			// pending
			$this->pending->LinkCustomAttributes = "";
			if (!EmptyValue($this->url2->CurrentValue)) {
				$this->pending->HrefValue = $this->url2->CurrentValue; // Add prefix/suffix
				$this->pending->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->pending->HrefValue = FullUrl($this->pending->HrefValue, "href");
			} else {
				$this->pending->HrefValue = "";
			}
			$this->pending->TooltipValue = "";

			// pending_sqm
			$this->pending_sqm->LinkCustomAttributes = "";
			$this->pending_sqm->HrefValue = "";
			$this->pending_sqm->TooltipValue = "";

			// offloom
			$this->offloom->LinkCustomAttributes = "";
			$this->offloom->HrefValue = "";
			$this->offloom->TooltipValue = "";

			// pending_offloom
			$this->pending_offloom->LinkCustomAttributes = "";
			$this->pending_offloom->HrefValue = "";
			$this->pending_offloom->TooltipValue = "";

			// pending_offloom_sqm
			$this->pending_offloom_sqm->LinkCustomAttributes = "";
			$this->pending_offloom_sqm->HrefValue = "";
			$this->pending_offloom_sqm->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// total_cbm
			$this->total_cbm->LinkCustomAttributes = "";
			$this->total_cbm->HrefValue = "";
			$this->total_cbm->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->pl_no->HrefValue = "javascript:pldetails('" . $this->url->CurrentValue . "');"; // Add prefix/suffix
				$this->pl_no->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->pl_no->HrefValue = FullUrl($this->pl_no->HrefValue, "href");
			} else {
				$this->pl_no->HrefValue = "";
			}
			$this->pl_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// sailing_week
			$this->sailing_week->LinkCustomAttributes = "";
			$this->sailing_week->HrefValue = "";
			$this->sailing_week->TooltipValue = "";

			// seller_remarks
			$this->seller_remarks->LinkCustomAttributes = "";
			$this->seller_remarks->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// rejection
			$this->rejection->LinkCustomAttributes = "";
			$this->rejection->HrefValue = "";
			$this->rejection->TooltipValue = "";

			// weight_sqm
			$this->weight_sqm->LinkCustomAttributes = "";
			$this->weight_sqm->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->buyers_id->Required) {
			if (!$this->buyers_id->IsDetailKey && $this->buyers_id->FormValue != NULL && $this->buyers_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyers_id->caption(), $this->buyers_id->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->buyer_order->Required) {
			if (!$this->buyer_order->IsDetailKey && $this->buyer_order->FormValue != NULL && $this->buyer_order->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_order->caption(), $this->buyer_order->RequiredErrorMessage));
			}
		}
		if ($this->item->Required) {
			if (!$this->item->IsDetailKey && $this->item->FormValue != NULL && $this->item->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
			}
		}
		if ($this->buyer_ref->Required) {
			if (!$this->buyer_ref->IsDetailKey && $this->buyer_ref->FormValue != NULL && $this->buyer_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_ref->caption(), $this->buyer_ref->RequiredErrorMessage));
			}
		}
		if ($this->order_week->Required) {
			if (!$this->order_week->IsDetailKey && $this->order_week->FormValue != NULL && $this->order_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_week->caption(), $this->order_week->RequiredErrorMessage));
			}
		}
		if ($this->order_date->Required) {
			if (!$this->order_date->IsDetailKey && $this->order_date->FormValue != NULL && $this->order_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_date->caption(), $this->order_date->RequiredErrorMessage));
			}
		}
		if ($this->ex_factory->Required) {
			if (!$this->ex_factory->IsDetailKey && $this->ex_factory->FormValue != NULL && $this->ex_factory->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ex_factory->caption(), $this->ex_factory->RequiredErrorMessage));
			}
		}
		if ($this->ex_factory_p->Required) {
			if ($this->ex_factory_p->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ex_factory_p->caption(), $this->ex_factory_p->RequiredErrorMessage));
			}
		}
		if ($this->shipping_mode->Required) {
			if (!$this->shipping_mode->IsDetailKey && $this->shipping_mode->FormValue != NULL && $this->shipping_mode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_mode->caption(), $this->shipping_mode->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->design->Required) {
			if (!$this->design->IsDetailKey && $this->design->FormValue != NULL && $this->design->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design->caption(), $this->design->RequiredErrorMessage));
			}
		}
		if ($this->size_buyer->Required) {
			if (!$this->size_buyer->IsDetailKey && $this->size_buyer->FormValue != NULL && $this->size_buyer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size_buyer->caption(), $this->size_buyer->RequiredErrorMessage));
			}
		}
		if ($this->width->Required) {
			if (!$this->width->IsDetailKey && $this->width->FormValue != NULL && $this->width->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->width->caption(), $this->width->RequiredErrorMessage));
			}
		}
		if ($this->length->Required) {
			if (!$this->length->IsDetailKey && $this->length->FormValue != NULL && $this->length->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->length->caption(), $this->length->RequiredErrorMessage));
			}
		}
		if ($this->qty->Required) {
			if (!$this->qty->IsDetailKey && $this->qty->FormValue != NULL && $this->qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
			}
		}
		if ($this->revised_qty->Required) {
			if (!$this->revised_qty->IsDetailKey && $this->revised_qty->FormValue != NULL && $this->revised_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->revised_qty->caption(), $this->revised_qty->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->d_qty->Required) {
			if (!$this->d_qty->IsDetailKey && $this->d_qty->FormValue != NULL && $this->d_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_qty->caption(), $this->d_qty->RequiredErrorMessage));
			}
		}
		if ($this->pending->Required) {
			if (!$this->pending->IsDetailKey && $this->pending->FormValue != NULL && $this->pending->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pending->caption(), $this->pending->RequiredErrorMessage));
			}
		}
		if ($this->pending_sqm->Required) {
			if (!$this->pending_sqm->IsDetailKey && $this->pending_sqm->FormValue != NULL && $this->pending_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pending_sqm->caption(), $this->pending_sqm->RequiredErrorMessage));
			}
		}
		if ($this->offloom->Required) {
			if (!$this->offloom->IsDetailKey && $this->offloom->FormValue != NULL && $this->offloom->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->offloom->caption(), $this->offloom->RequiredErrorMessage));
			}
		}
		if ($this->pending_offloom->Required) {
			if (!$this->pending_offloom->IsDetailKey && $this->pending_offloom->FormValue != NULL && $this->pending_offloom->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pending_offloom->caption(), $this->pending_offloom->RequiredErrorMessage));
			}
		}
		if ($this->pending_offloom_sqm->Required) {
			if (!$this->pending_offloom_sqm->IsDetailKey && $this->pending_offloom_sqm->FormValue != NULL && $this->pending_offloom_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pending_offloom_sqm->caption(), $this->pending_offloom_sqm->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if ($this->total_cbm->Required) {
			if (!$this->total_cbm->IsDetailKey && $this->total_cbm->FormValue != NULL && $this->total_cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->total_cbm->caption(), $this->total_cbm->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->pl_no->Required) {
			if (!$this->pl_no->IsDetailKey && $this->pl_no->FormValue != NULL && $this->pl_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_no->caption(), $this->pl_no->RequiredErrorMessage));
			}
		}
		if ($this->invoice_date->Required) {
			if (!$this->invoice_date->IsDetailKey && $this->invoice_date->FormValue != NULL && $this->invoice_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
			}
		}
		if ($this->sailing_week->Required) {
			if (!$this->sailing_week->IsDetailKey && $this->sailing_week->FormValue != NULL && $this->sailing_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sailing_week->caption(), $this->sailing_week->RequiredErrorMessage));
			}
		}
		if ($this->seller_remarks->Required) {
			if (!$this->seller_remarks->IsDetailKey && $this->seller_remarks->FormValue != NULL && $this->seller_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->seller_remarks->caption(), $this->seller_remarks->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if ($this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->rejection->Required) {
			if (!$this->rejection->IsDetailKey && $this->rejection->FormValue != NULL && $this->rejection->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rejection->caption(), $this->rejection->RequiredErrorMessage));
			}
		}
		if ($this->completed->Required) {
			if ($this->completed->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->completed->caption(), $this->completed->RequiredErrorMessage));
			}
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}
		if ($this->url2->Required) {
			if (!$this->url2->IsDetailKey && $this->url2->FormValue != NULL && $this->url2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url2->caption(), $this->url2->RequiredErrorMessage));
			}
		}
		if ($this->weight_sqm->Required) {
			if (!$this->weight_sqm->IsDetailKey && $this->weight_sqm->FormValue != NULL && $this->weight_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->weight_sqm->caption(), $this->weight_sqm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->weight_sqm->FormValue)) {
			AddMessage($FormError, $this->weight_sqm->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// seller_remarks
			$this->seller_remarks->setDbValueDef($rsnew, $this->seller_remarks->CurrentValue, NULL, $this->seller_remarks->ReadOnly);

			// weight_sqm
			$this->weight_sqm->setDbValueDef($rsnew, $this->weight_sqm->CurrentValue, NULL, $this->weight_sqm->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("oms_tablelist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyers_id":
							break;
						case "x_reports_to":
							break;
						case "x_order_week":
							break;
						case "x_ex_factory":
							break;
						case "x_ex_factory_p":
							break;
						case "x_status":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>