<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class oms_table_search extends oms_table
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'oms_table';

	// Page object name
	public $PageObjName = "oms_table_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (oms_table)
		if (!isset($GLOBALS["oms_table"]) || get_class($GLOBALS["oms_table"]) == PROJECT_NAMESPACE . "oms_table") {
			$GLOBALS["oms_table"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["oms_table"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'oms_table');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $oms_table;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($oms_table);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "oms_tableview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("oms_tablelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->buyers_id->setVisibility();
		$this->reports_to->setVisibility();
		$this->buyer_order->setVisibility();
		$this->item->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->order_week->setVisibility();
		$this->order_date->setVisibility();
		$this->ex_factory->setVisibility();
		$this->ex_factory_p->setVisibility();
		$this->shipping_mode->setVisibility();
		$this->po->setVisibility();
		$this->design->setVisibility();
		$this->size_buyer->setVisibility();
		$this->width->setVisibility();
		$this->length->setVisibility();
		$this->qty->setVisibility();
		$this->revised_qty->setVisibility();
		$this->sqm->setVisibility();
		$this->d_qty->setVisibility();
		$this->pending->setVisibility();
		$this->pending_sqm->setVisibility();
		$this->offloom->setVisibility();
		$this->pending_offloom->setVisibility();
		$this->pending_offloom_sqm->setVisibility();
		$this->cbm->setVisibility();
		$this->total_cbm->setVisibility();
		$this->remarks->setVisibility();
		$this->pl_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->sailing_week->setVisibility();
		$this->seller_remarks->setVisibility();
		$this->status->setVisibility();
		$this->rejection->Visible = FALSE;
		$this->completed->setVisibility();
		$this->url->Visible = FALSE;
		$this->url2->Visible = FALSE;
		$this->weight_sqm->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->order_week);
		$this->setupLookupOptions($this->ex_factory);
		$this->setupLookupOptions($this->ex_factory_p);
		$this->setupLookupOptions($this->status);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "oms_tablelist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
		$this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
		$this->buildSearchUrl($srchUrl, $this->buyer_order); // buyer_order
		$this->buildSearchUrl($srchUrl, $this->item); // item
		$this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
		$this->buildSearchUrl($srchUrl, $this->order_week); // order_week
		$this->buildSearchUrl($srchUrl, $this->order_date); // order_date
		$this->buildSearchUrl($srchUrl, $this->ex_factory); // ex_factory
		$this->buildSearchUrl($srchUrl, $this->ex_factory_p); // ex_factory_p
		$this->buildSearchUrl($srchUrl, $this->shipping_mode); // shipping_mode
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->design); // design
		$this->buildSearchUrl($srchUrl, $this->size_buyer); // size_buyer
		$this->buildSearchUrl($srchUrl, $this->width); // width
		$this->buildSearchUrl($srchUrl, $this->length); // length
		$this->buildSearchUrl($srchUrl, $this->qty); // qty
		$this->buildSearchUrl($srchUrl, $this->revised_qty); // revised_qty
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->d_qty); // d_qty
		$this->buildSearchUrl($srchUrl, $this->pending); // pending
		$this->buildSearchUrl($srchUrl, $this->pending_sqm); // pending_sqm
		$this->buildSearchUrl($srchUrl, $this->offloom); // offloom
		$this->buildSearchUrl($srchUrl, $this->pending_offloom); // pending_offloom
		$this->buildSearchUrl($srchUrl, $this->pending_offloom_sqm); // pending_offloom_sqm
		$this->buildSearchUrl($srchUrl, $this->cbm); // cbm
		$this->buildSearchUrl($srchUrl, $this->total_cbm); // total_cbm
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->pl_no); // pl_no
		$this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
		$this->buildSearchUrl($srchUrl, $this->sailing_week); // sailing_week
		$this->buildSearchUrl($srchUrl, $this->seller_remarks); // seller_remarks
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->completed); // completed
		$this->buildSearchUrl($srchUrl, $this->weight_sqm); // weight_sqm
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// buyers_id
		if (!$this->isAddOrEdit())
			$this->buyers_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyers_id"));
		$this->buyers_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyers_id"));

		// reports_to
		if (!$this->isAddOrEdit())
			$this->reports_to->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_reports_to"));
		$this->reports_to->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_reports_to"));

		// buyer_order
		if (!$this->isAddOrEdit())
			$this->buyer_order->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_order"));
		$this->buyer_order->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_order"));

		// item
		if (!$this->isAddOrEdit())
			$this->item->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_item"));
		$this->item->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_item"));

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_ref"));
		$this->buyer_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_ref"));

		// order_week
		if (!$this->isAddOrEdit())
			$this->order_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_order_week"));
		$this->order_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_order_week"));

		// order_date
		if (!$this->isAddOrEdit())
			$this->order_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_order_date"));
		$this->order_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_order_date"));

		// ex_factory
		if (!$this->isAddOrEdit())
			$this->ex_factory->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ex_factory"));
		$this->ex_factory->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ex_factory"));

		// ex_factory_p
		if (!$this->isAddOrEdit())
			$this->ex_factory_p->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ex_factory_p"));
		$this->ex_factory_p->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ex_factory_p"));
		$this->ex_factory_p->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_ex_factory_p"));
		$this->ex_factory_p->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_ex_factory_p"));
		$this->ex_factory_p->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_ex_factory_p"));
		if (is_array($this->ex_factory_p->AdvancedSearch->SearchValue))
			$this->ex_factory_p->AdvancedSearch->SearchValue = implode(",", $this->ex_factory_p->AdvancedSearch->SearchValue);
		if (is_array($this->ex_factory_p->AdvancedSearch->SearchValue2))
			$this->ex_factory_p->AdvancedSearch->SearchValue2 = implode(",", $this->ex_factory_p->AdvancedSearch->SearchValue2);

		// shipping_mode
		if (!$this->isAddOrEdit())
			$this->shipping_mode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipping_mode"));
		$this->shipping_mode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipping_mode"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));
		$this->po->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_po"));
		$this->po->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_po"));
		$this->po->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_po"));

		// design
		if (!$this->isAddOrEdit())
			$this->design->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design"));
		$this->design->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design"));

		// size_buyer
		if (!$this->isAddOrEdit())
			$this->size_buyer->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size_buyer"));
		$this->size_buyer->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size_buyer"));

		// width
		if (!$this->isAddOrEdit())
			$this->width->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_width"));
		$this->width->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_width"));

		// length
		if (!$this->isAddOrEdit())
			$this->length->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_length"));
		$this->length->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_length"));

		// qty
		if (!$this->isAddOrEdit())
			$this->qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty"));
		$this->qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty"));

		// revised_qty
		if (!$this->isAddOrEdit())
			$this->revised_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_revised_qty"));
		$this->revised_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_revised_qty"));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// d_qty
		if (!$this->isAddOrEdit())
			$this->d_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_qty"));
		$this->d_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_qty"));

		// pending
		if (!$this->isAddOrEdit())
			$this->pending->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pending"));
		$this->pending->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pending"));
		$this->pending->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_pending"));
		$this->pending->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_pending"));
		$this->pending->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_pending"));

		// pending_sqm
		if (!$this->isAddOrEdit())
			$this->pending_sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pending_sqm"));
		$this->pending_sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pending_sqm"));
		$this->pending_sqm->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_pending_sqm"));
		$this->pending_sqm->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_pending_sqm"));
		$this->pending_sqm->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_pending_sqm"));

		// offloom
		if (!$this->isAddOrEdit())
			$this->offloom->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_offloom"));
		$this->offloom->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_offloom"));

		// pending_offloom
		if (!$this->isAddOrEdit())
			$this->pending_offloom->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pending_offloom"));
		$this->pending_offloom->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pending_offloom"));

		// pending_offloom_sqm
		if (!$this->isAddOrEdit())
			$this->pending_offloom_sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pending_offloom_sqm"));
		$this->pending_offloom_sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pending_offloom_sqm"));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cbm"));
		$this->cbm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cbm"));

		// total_cbm
		if (!$this->isAddOrEdit())
			$this->total_cbm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_total_cbm"));
		$this->total_cbm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_total_cbm"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// pl_no
		if (!$this->isAddOrEdit())
			$this->pl_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_no"));
		$this->pl_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_no"));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_date"));
		$this->invoice_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_date"));

		// sailing_week
		if (!$this->isAddOrEdit())
			$this->sailing_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sailing_week"));
		$this->sailing_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sailing_week"));

		// seller_remarks
		if (!$this->isAddOrEdit())
			$this->seller_remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_seller_remarks"));
		$this->seller_remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_seller_remarks"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));
		if (is_array($this->status->AdvancedSearch->SearchValue))
			$this->status->AdvancedSearch->SearchValue = implode(",", $this->status->AdvancedSearch->SearchValue);
		if (is_array($this->status->AdvancedSearch->SearchValue2))
			$this->status->AdvancedSearch->SearchValue2 = implode(",", $this->status->AdvancedSearch->SearchValue2);

		// completed
		if (!$this->isAddOrEdit())
			$this->completed->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_completed"));
		$this->completed->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_completed"));
		if (is_array($this->completed->AdvancedSearch->SearchValue))
			$this->completed->AdvancedSearch->SearchValue = implode(",", $this->completed->AdvancedSearch->SearchValue);
		if (is_array($this->completed->AdvancedSearch->SearchValue2))
			$this->completed->AdvancedSearch->SearchValue2 = implode(",", $this->completed->AdvancedSearch->SearchValue2);

		// weight_sqm
		if (!$this->isAddOrEdit())
			$this->weight_sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_weight_sqm"));
		$this->weight_sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_weight_sqm"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->id->FormValue == $this->id->CurrentValue && is_numeric(ConvertToFloatString($this->id->CurrentValue)))
			$this->id->CurrentValue = ConvertToFloatString($this->id->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_sqm->FormValue == $this->pending_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->pending_sqm->CurrentValue)))
			$this->pending_sqm->CurrentValue = ConvertToFloatString($this->pending_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_offloom_sqm->FormValue == $this->pending_offloom_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->pending_offloom_sqm->CurrentValue)))
			$this->pending_offloom_sqm->CurrentValue = ConvertToFloatString($this->pending_offloom_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight_sqm->FormValue == $this->weight_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->weight_sqm->CurrentValue)))
			$this->weight_sqm->CurrentValue = ConvertToFloatString($this->weight_sqm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// buyers_id
		// reports_to
		// buyer_order
		// item
		// buyer_ref
		// order_week
		// order_date
		// ex_factory
		// ex_factory_p
		// shipping_mode
		// po
		// design
		// size_buyer
		// width
		// length
		// qty
		// revised_qty
		// sqm
		// d_qty
		// pending
		// pending_sqm
		// offloom
		// pending_offloom
		// pending_offloom_sqm
		// cbm
		// total_cbm
		// remarks
		// pl_no
		// invoice_date
		// sailing_week
		// seller_remarks
		// status
		// rejection
		// completed
		// url
		// url2
		// weight_sqm

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer_order
			$this->buyer_order->ViewValue = $this->buyer_order->CurrentValue;
			$this->buyer_order->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			$this->item->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_week
			$curVal = strval($this->order_week->CurrentValue);
			if ($curVal <> "") {
				$this->order_week->ViewValue = $this->order_week->lookupCacheOption($curVal);
				if ($this->order_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->order_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->order_week->ViewValue = $this->order_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->order_week->ViewValue = $this->order_week->CurrentValue;
					}
				}
			} else {
				$this->order_week->ViewValue = NULL;
			}
			$this->order_week->ViewCustomAttributes = "";

			// order_date
			$this->order_date->ViewValue = $this->order_date->CurrentValue;
			$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 2);
			$this->order_date->ViewCustomAttributes = "";

			// ex_factory
			$curVal = strval($this->ex_factory->CurrentValue);
			if ($curVal <> "") {
				$this->ex_factory->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
				if ($this->ex_factory->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ex_factory->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->ex_factory->ViewValue = $this->ex_factory->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ex_factory->ViewValue = $this->ex_factory->CurrentValue;
					}
				}
			} else {
				$this->ex_factory->ViewValue = NULL;
			}
			$this->ex_factory->ViewCustomAttributes = "";

			// ex_factory_p
			$curVal = strval($this->ex_factory_p->CurrentValue);
			if ($curVal <> "") {
				$this->ex_factory_p->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
				if ($this->ex_factory_p->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->ex_factory_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->ex_factory_p->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->ex_factory_p->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->ex_factory_p->ViewValue = $this->ex_factory_p->CurrentValue;
					}
				}
			} else {
				$this->ex_factory_p->ViewValue = NULL;
			}
			$this->ex_factory_p->ViewCustomAttributes = "";

			// shipping_mode
			$this->shipping_mode->ViewValue = $this->shipping_mode->CurrentValue;
			$this->shipping_mode->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// width
			$this->width->ViewValue = $this->width->CurrentValue;
			$this->width->ViewValue = FormatNumber($this->width->ViewValue, 0, -2, -2, -2);
			$this->width->ViewCustomAttributes = "";

			// length
			$this->length->ViewValue = $this->length->CurrentValue;
			$this->length->ViewValue = FormatNumber($this->length->ViewValue, 0, -2, -2, -2);
			$this->length->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// revised_qty
			$this->revised_qty->ViewValue = $this->revised_qty->CurrentValue;
			$this->revised_qty->ViewValue = FormatNumber($this->revised_qty->ViewValue, 0, -2, -2, -2);
			$this->revised_qty->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// d_qty
			$this->d_qty->ViewValue = $this->d_qty->CurrentValue;
			$this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, 2, -2, -2, -2);
			$this->d_qty->ViewCustomAttributes = "";

			// pending
			$this->pending->ViewValue = $this->pending->CurrentValue;
			$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 0, -1, -2, -2);
			$this->pending->ViewCustomAttributes = "";

			// pending_sqm
			$this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
			$this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, 2, -2, -2, -2);
			$this->pending_sqm->ViewCustomAttributes = "";

			// offloom
			$this->offloom->ViewValue = $this->offloom->CurrentValue;
			$this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, 0, -2, -2, -2);
			$this->offloom->ViewCustomAttributes = "";

			// pending_offloom
			$this->pending_offloom->ViewValue = $this->pending_offloom->CurrentValue;
			$this->pending_offloom->ViewValue = FormatNumber($this->pending_offloom->ViewValue, 0, -2, -2, -2);
			$this->pending_offloom->ViewCustomAttributes = "";

			// pending_offloom_sqm
			$this->pending_offloom_sqm->ViewValue = $this->pending_offloom_sqm->CurrentValue;
			$this->pending_offloom_sqm->ViewValue = FormatNumber($this->pending_offloom_sqm->ViewValue, 2, -2, -2, -2);
			$this->pending_offloom_sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// total_cbm
			$this->total_cbm->ViewValue = $this->total_cbm->CurrentValue;
			$this->total_cbm->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewCustomAttributes = "";

			// sailing_week
			$this->sailing_week->ViewValue = $this->sailing_week->CurrentValue;
			$this->sailing_week->ViewCustomAttributes = "";

			// seller_remarks
			$this->seller_remarks->ViewValue = $this->seller_remarks->CurrentValue;
			$this->seller_remarks->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->status->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->status->ViewValue->add($this->status->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// rejection
			$this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, 0, -2, -2, -2);
			$this->rejection->ViewCustomAttributes = "";

			// completed
			if (strval($this->completed->CurrentValue) <> "") {
				$this->completed->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->completed->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->completed->ViewValue->add($this->completed->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->completed->ViewValue = NULL;
			}
			$this->completed->ViewCustomAttributes = "";

			// weight_sqm
			$this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
			$this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, 2, -2, -2, -2);
			$this->weight_sqm->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			$this->buyers_id->HrefValue = "";
			$this->buyers_id->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer_order
			$this->buyer_order->LinkCustomAttributes = "";
			$this->buyer_order->HrefValue = "";
			$this->buyer_order->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			$this->item->HrefValue = "";
			$this->item->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			$this->buyer_ref->HrefValue = "";
			$this->buyer_ref->TooltipValue = "";

			// order_week
			$this->order_week->LinkCustomAttributes = "";
			$this->order_week->HrefValue = "";
			$this->order_week->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// ex_factory
			$this->ex_factory->LinkCustomAttributes = "";
			$this->ex_factory->HrefValue = "";
			$this->ex_factory->TooltipValue = "";

			// ex_factory_p
			$this->ex_factory_p->LinkCustomAttributes = "";
			$this->ex_factory_p->HrefValue = "";
			$this->ex_factory_p->TooltipValue = "";

			// shipping_mode
			$this->shipping_mode->LinkCustomAttributes = "";
			$this->shipping_mode->HrefValue = "";
			$this->shipping_mode->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// size_buyer
			$this->size_buyer->LinkCustomAttributes = "";
			$this->size_buyer->HrefValue = "";
			$this->size_buyer->TooltipValue = "";

			// width
			$this->width->LinkCustomAttributes = "";
			$this->width->HrefValue = "";
			$this->width->TooltipValue = "";

			// length
			$this->length->LinkCustomAttributes = "";
			$this->length->HrefValue = "";
			$this->length->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// revised_qty
			$this->revised_qty->LinkCustomAttributes = "";
			$this->revised_qty->HrefValue = "";
			$this->revised_qty->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// d_qty
			$this->d_qty->LinkCustomAttributes = "";
			$this->d_qty->HrefValue = "";
			$this->d_qty->TooltipValue = "";

			// pending
			$this->pending->LinkCustomAttributes = "";
			if (!EmptyValue($this->url2->CurrentValue)) {
				$this->pending->HrefValue = $this->url2->CurrentValue; // Add prefix/suffix
				$this->pending->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->pending->HrefValue = FullUrl($this->pending->HrefValue, "href");
			} else {
				$this->pending->HrefValue = "";
			}
			$this->pending->TooltipValue = "";

			// pending_sqm
			$this->pending_sqm->LinkCustomAttributes = "";
			$this->pending_sqm->HrefValue = "";
			$this->pending_sqm->TooltipValue = "";

			// offloom
			$this->offloom->LinkCustomAttributes = "";
			$this->offloom->HrefValue = "";
			$this->offloom->TooltipValue = "";

			// pending_offloom
			$this->pending_offloom->LinkCustomAttributes = "";
			$this->pending_offloom->HrefValue = "";
			$this->pending_offloom->TooltipValue = "";

			// pending_offloom_sqm
			$this->pending_offloom_sqm->LinkCustomAttributes = "";
			$this->pending_offloom_sqm->HrefValue = "";
			$this->pending_offloom_sqm->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// total_cbm
			$this->total_cbm->LinkCustomAttributes = "";
			$this->total_cbm->HrefValue = "";
			$this->total_cbm->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->pl_no->HrefValue = "javascript:pldetails('" . $this->url->CurrentValue . "');"; // Add prefix/suffix
				$this->pl_no->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->pl_no->HrefValue = FullUrl($this->pl_no->HrefValue, "href");
			} else {
				$this->pl_no->HrefValue = "";
			}
			$this->pl_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// sailing_week
			$this->sailing_week->LinkCustomAttributes = "";
			$this->sailing_week->HrefValue = "";
			$this->sailing_week->TooltipValue = "";

			// seller_remarks
			$this->seller_remarks->LinkCustomAttributes = "";
			$this->seller_remarks->HrefValue = "";
			$this->seller_remarks->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// completed
			$this->completed->LinkCustomAttributes = "";
			$this->completed->HrefValue = "";
			$this->completed->TooltipValue = "";

			// weight_sqm
			$this->weight_sqm->LinkCustomAttributes = "";
			$this->weight_sqm->HrefValue = "";
			$this->weight_sqm->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			else
				$this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== NULL && is_array($this->buyers_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyers_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyers_id->EditValue = array_values($this->buyers_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyers_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->buyers_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyers_id->EditValue = $arwrk;
			}

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// buyer_order
			$this->buyer_order->EditAttrs["class"] = "form-control";
			$this->buyer_order->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_order->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_order->AdvancedSearch->SearchValue);
			$this->buyer_order->EditValue = HtmlEncode($this->buyer_order->AdvancedSearch->SearchValue);
			$this->buyer_order->PlaceHolder = RemoveHtml($this->buyer_order->caption());

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
			$this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

			// order_week
			$this->order_week->EditAttrs["class"] = "form-control";
			$this->order_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->order_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->order_week->AdvancedSearch->ViewValue = $this->order_week->lookupCacheOption($curVal);
			else
				$this->order_week->AdvancedSearch->ViewValue = $this->order_week->Lookup !== NULL && is_array($this->order_week->Lookup->Options) ? $curVal : NULL;
			if ($this->order_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->order_week->EditValue = array_values($this->order_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->order_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->order_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->order_week->EditValue = $arwrk;
			}

			// order_date
			$this->order_date->EditAttrs["class"] = "form-control";
			$this->order_date->EditCustomAttributes = "";
			$this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, 2), 2));
			$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

			// ex_factory
			$this->ex_factory->EditAttrs["class"] = "form-control";
			$this->ex_factory->EditCustomAttributes = "";
			$curVal = trim(strval($this->ex_factory->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->ex_factory->AdvancedSearch->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
			else
				$this->ex_factory->AdvancedSearch->ViewValue = $this->ex_factory->Lookup !== NULL && is_array($this->ex_factory->Lookup->Options) ? $curVal : NULL;
			if ($this->ex_factory->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->ex_factory->EditValue = array_values($this->ex_factory->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->ex_factory->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ex_factory->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ex_factory->EditValue = $arwrk;
			}

			// ex_factory_p
			$this->ex_factory_p->EditCustomAttributes = "";
			$curVal = trim(strval($this->ex_factory_p->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->ex_factory_p->AdvancedSearch->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
			else
				$this->ex_factory_p->AdvancedSearch->ViewValue = $this->ex_factory_p->Lookup !== NULL && is_array($this->ex_factory_p->Lookup->Options) ? $curVal : NULL;
			if ($this->ex_factory_p->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->ex_factory_p->EditValue = array_values($this->ex_factory_p->Lookup->Options);
				if ($this->ex_factory_p->AdvancedSearch->ViewValue == "")
					$this->ex_factory_p->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->ex_factory_p->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->ex_factory_p->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->ex_factory_p->AdvancedSearch->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->ex_factory_p->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ex_factory_p->EditValue = $arwrk;
			}
			$this->ex_factory_p->EditCustomAttributes = "";
			$curVal = trim(strval($this->ex_factory_p->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->ex_factory_p->AdvancedSearch->ViewValue2 = $this->ex_factory_p->lookupCacheOption($curVal);
			else
				$this->ex_factory_p->AdvancedSearch->ViewValue2 = $this->ex_factory_p->Lookup !== NULL && is_array($this->ex_factory_p->Lookup->Options) ? $curVal : NULL;
			if ($this->ex_factory_p->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->ex_factory_p->EditValue2 = array_values($this->ex_factory_p->Lookup->Options);
				if ($this->ex_factory_p->AdvancedSearch->ViewValue2 == "")
					$this->ex_factory_p->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->ex_factory_p->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->ex_factory_p->AdvancedSearch->ViewValue2 = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->ex_factory_p->AdvancedSearch->ViewValue2->add($this->ex_factory_p->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->ex_factory_p->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ex_factory_p->EditValue2 = $arwrk;
			}

			// shipping_mode
			$this->shipping_mode->EditAttrs["class"] = "form-control";
			$this->shipping_mode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->shipping_mode->AdvancedSearch->SearchValue = HtmlDecode($this->shipping_mode->AdvancedSearch->SearchValue);
			$this->shipping_mode->EditValue = HtmlEncode($this->shipping_mode->AdvancedSearch->SearchValue);
			$this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// design
			$this->design->EditAttrs["class"] = "form-control";
			$this->design->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design->AdvancedSearch->SearchValue = HtmlDecode($this->design->AdvancedSearch->SearchValue);
			$this->design->EditValue = HtmlEncode($this->design->AdvancedSearch->SearchValue);
			$this->design->PlaceHolder = RemoveHtml($this->design->caption());

			// size_buyer
			$this->size_buyer->EditAttrs["class"] = "form-control";
			$this->size_buyer->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_buyer->AdvancedSearch->SearchValue = HtmlDecode($this->size_buyer->AdvancedSearch->SearchValue);
			$this->size_buyer->EditValue = HtmlEncode($this->size_buyer->AdvancedSearch->SearchValue);
			$this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

			// width
			$this->width->EditAttrs["class"] = "form-control";
			$this->width->EditCustomAttributes = "";
			$this->width->EditValue = HtmlEncode($this->width->AdvancedSearch->SearchValue);
			$this->width->PlaceHolder = RemoveHtml($this->width->caption());

			// length
			$this->length->EditAttrs["class"] = "form-control";
			$this->length->EditCustomAttributes = "";
			$this->length->EditValue = HtmlEncode($this->length->AdvancedSearch->SearchValue);
			$this->length->PlaceHolder = RemoveHtml($this->length->caption());

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = HtmlEncode($this->qty->AdvancedSearch->SearchValue);
			$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

			// revised_qty
			$this->revised_qty->EditAttrs["class"] = "form-control";
			$this->revised_qty->EditCustomAttributes = "";
			$this->revised_qty->EditValue = HtmlEncode($this->revised_qty->AdvancedSearch->SearchValue);
			$this->revised_qty->PlaceHolder = RemoveHtml($this->revised_qty->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// d_qty
			$this->d_qty->EditAttrs["class"] = "form-control";
			$this->d_qty->EditCustomAttributes = "";
			$this->d_qty->EditValue = HtmlEncode($this->d_qty->AdvancedSearch->SearchValue);
			$this->d_qty->PlaceHolder = RemoveHtml($this->d_qty->caption());

			// pending
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue = HtmlEncode($this->pending->AdvancedSearch->SearchValue);
			$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue2 = HtmlEncode($this->pending->AdvancedSearch->SearchValue2);
			$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());

			// pending_sqm
			$this->pending_sqm->EditAttrs["class"] = "form-control";
			$this->pending_sqm->EditCustomAttributes = "";
			$this->pending_sqm->EditValue = HtmlEncode($this->pending_sqm->AdvancedSearch->SearchValue);
			$this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());
			$this->pending_sqm->EditAttrs["class"] = "form-control";
			$this->pending_sqm->EditCustomAttributes = "";
			$this->pending_sqm->EditValue2 = HtmlEncode($this->pending_sqm->AdvancedSearch->SearchValue2);
			$this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());

			// offloom
			$this->offloom->EditAttrs["class"] = "form-control";
			$this->offloom->EditCustomAttributes = "";
			$this->offloom->EditValue = HtmlEncode($this->offloom->AdvancedSearch->SearchValue);
			$this->offloom->PlaceHolder = RemoveHtml($this->offloom->caption());

			// pending_offloom
			$this->pending_offloom->EditAttrs["class"] = "form-control";
			$this->pending_offloom->EditCustomAttributes = "";
			$this->pending_offloom->EditValue = HtmlEncode($this->pending_offloom->AdvancedSearch->SearchValue);
			$this->pending_offloom->PlaceHolder = RemoveHtml($this->pending_offloom->caption());

			// pending_offloom_sqm
			$this->pending_offloom_sqm->EditAttrs["class"] = "form-control";
			$this->pending_offloom_sqm->EditCustomAttributes = "";
			$this->pending_offloom_sqm->EditValue = HtmlEncode($this->pending_offloom_sqm->AdvancedSearch->SearchValue);
			$this->pending_offloom_sqm->PlaceHolder = RemoveHtml($this->pending_offloom_sqm->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			$this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// total_cbm
			$this->total_cbm->EditAttrs["class"] = "form-control";
			$this->total_cbm->EditCustomAttributes = "";
			$this->total_cbm->EditValue = HtmlEncode($this->total_cbm->AdvancedSearch->SearchValue);
			$this->total_cbm->PlaceHolder = RemoveHtml($this->total_cbm->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// pl_no
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pl_no->AdvancedSearch->SearchValue = HtmlDecode($this->pl_no->AdvancedSearch->SearchValue);
			$this->pl_no->EditValue = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue);
			$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, 0));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// sailing_week
			$this->sailing_week->EditAttrs["class"] = "form-control";
			$this->sailing_week->EditCustomAttributes = "";
			$this->sailing_week->EditValue = HtmlEncode($this->sailing_week->AdvancedSearch->SearchValue);
			$this->sailing_week->PlaceHolder = RemoveHtml($this->sailing_week->caption());

			// seller_remarks
			$this->seller_remarks->EditAttrs["class"] = "form-control";
			$this->seller_remarks->EditCustomAttributes = "";
			$this->seller_remarks->EditValue = HtmlEncode($this->seller_remarks->AdvancedSearch->SearchValue);
			$this->seller_remarks->PlaceHolder = RemoveHtml($this->seller_remarks->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
			else
				$this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== NULL && is_array($this->status->Lookup->Options) ? $curVal : NULL;
			if ($this->status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->status->EditValue = array_values($this->status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->status->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->status->EditValue = $arwrk;
			}

			// completed
			$this->completed->EditCustomAttributes = "";
			$this->completed->EditValue = $this->completed->options(FALSE);

			// weight_sqm
			$this->weight_sqm->EditAttrs["class"] = "form-control";
			$this->weight_sqm->EditCustomAttributes = "";
			$this->weight_sqm->EditValue = HtmlEncode($this->weight_sqm->AdvancedSearch->SearchValue);
			$this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckDate($this->order_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->order_date->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->width->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->width->errorMessage());
		}
		if (!CheckInteger($this->length->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->length->errorMessage());
		}
		if (!CheckInteger($this->qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty->errorMessage());
		}
		if (!CheckInteger($this->revised_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->revised_qty->errorMessage());
		}
		if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm->errorMessage());
		}
		if (!CheckNumber($this->d_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->d_qty->errorMessage());
		}
		if (!CheckNumber($this->pending->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending->errorMessage());
		}
		if (!CheckNumber($this->pending->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->pending->errorMessage());
		}
		if (!CheckNumber($this->pending_sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending_sqm->errorMessage());
		}
		if (!CheckNumber($this->pending_sqm->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->pending_sqm->errorMessage());
		}
		if (!CheckNumber($this->offloom->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->offloom->errorMessage());
		}
		if (!CheckInteger($this->pending_offloom->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending_offloom->errorMessage());
		}
		if (!CheckNumber($this->pending_offloom_sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending_offloom_sqm->errorMessage());
		}
		if (!CheckNumber($this->weight_sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->weight_sqm->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->buyer_order->AdvancedSearch->load();
		$this->item->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->order_week->AdvancedSearch->load();
		$this->order_date->AdvancedSearch->load();
		$this->ex_factory->AdvancedSearch->load();
		$this->ex_factory_p->AdvancedSearch->load();
		$this->shipping_mode->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->design->AdvancedSearch->load();
		$this->size_buyer->AdvancedSearch->load();
		$this->width->AdvancedSearch->load();
		$this->length->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->revised_qty->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->d_qty->AdvancedSearch->load();
		$this->pending->AdvancedSearch->load();
		$this->pending_sqm->AdvancedSearch->load();
		$this->offloom->AdvancedSearch->load();
		$this->pending_offloom->AdvancedSearch->load();
		$this->pending_offloom_sqm->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->total_cbm->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->sailing_week->AdvancedSearch->load();
		$this->seller_remarks->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->completed->AdvancedSearch->load();
		$this->weight_sqm->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("oms_tablelist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyers_id":
							break;
						case "x_reports_to":
							break;
						case "x_order_week":
							break;
						case "x_ex_factory":
							break;
						case "x_ex_factory_p":
							break;
						case "x_status":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>