<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for p_eastimate
 */
class p_eastimate extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $job_type;
	public $job_category;
	public $company_id;
	public $description;
	public $size;
	public $quantity;
	public $pages;
	public $paper;
	public $remarks;
	public $pr_01;
	public $qty_pr_01;
	public $pl_01;
	public $qty_pl_01;
	public $pr_02;
	public $qty_pr_02;
	public $pl_02;
	public $qty_pl_02;
	public $pr_03;
	public $qty_pr_03;
	public $pl_03;
	public $qty_pl_03;
	public $pr_04;
	public $qty_pr_04;
	public $pl_04;
	public $qty_pl_04;
	public $pa_01;
	public $qty_pa_01;
	public $pa_02;
	public $qty_pa_02;
	public $pa_03;
	public $qty_pa_03;
	public $pa_04;
	public $qty_pa_04;
	public $pa_05;
	public $qty_pa_05;
	public $pc_01;
	public $qty_pc_01;
	public $pc_02;
	public $qty_pc_02;
	public $o_01;
	public $qty_o_01;
	public $lamination_type;
	public $lamination_qty;
	public $die_type;
	public $die_qty;
	public $binding_type;
	public $binding_qty;
	public $number_type;
	public $number_qty;
	public $de_01;
	public $qty_de_01;
	public $de_02;
	public $qty_de_02;
	public $de_03;
	public $qty_de_03;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'p_eastimate';
		$this->TableName = 'p_eastimate';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`p_eastimate`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('p_eastimate', 'p_eastimate', 'x_id', 'id', '`id`', '`id`', 2, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// job_type
		$this->job_type = new DbField('p_eastimate', 'p_eastimate', 'x_job_type', 'job_type', '`job_type`', '`job_type`', 2, -1, FALSE, '`job_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->job_type->Nullable = FALSE; // NOT NULL field
		$this->job_type->Required = TRUE; // Required field
		$this->job_type->Sortable = TRUE; // Allow sort
		$this->job_type->Lookup = new Lookup('job_type', 'p_eastimate', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->job_type->OptionCount = 2;
		$this->job_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['job_type'] = &$this->job_type;

		// job_category
		$this->job_category = new DbField('p_eastimate', 'p_eastimate', 'x_job_category', 'job_category', '`job_category`', '`job_category`', 18, -1, FALSE, '`job_category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->job_category->Nullable = FALSE; // NOT NULL field
		$this->job_category->Required = TRUE; // Required field
		$this->job_category->Sortable = TRUE; // Allow sort
		$this->job_category->Lookup = new Lookup('job_category', 'p_eastimate', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->job_category->OptionCount = 2;
		$this->job_category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['job_category'] = &$this->job_category;

		// company_id
		$this->company_id = new DbField('p_eastimate', 'p_eastimate', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 2, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Required = TRUE; // Required field
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->Lookup = new Lookup('company_id', 'buyer', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// description
		$this->description = new DbField('p_eastimate', 'p_eastimate', 'x_description', 'description', '`description`', '`description`', 200, -1, FALSE, '`description`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description->Required = TRUE; // Required field
		$this->description->Sortable = TRUE; // Allow sort
		$this->fields['description'] = &$this->description;

		// size
		$this->size = new DbField('p_eastimate', 'p_eastimate', 'x_size', 'size', '`size`', '`size`', 200, -1, FALSE, '`size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->size->Nullable = FALSE; // NOT NULL field
		$this->size->Required = TRUE; // Required field
		$this->size->Sortable = TRUE; // Allow sort
		$this->size->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->size->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->size->Lookup = new Lookup('size', 'p_size', TRUE, 'description', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->size->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['size'] = &$this->size;

		// quantity
		$this->quantity = new DbField('p_eastimate', 'p_eastimate', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// pages
		$this->pages = new DbField('p_eastimate', 'p_eastimate', 'x_pages', 'pages', '`pages`', '`pages`', 200, -1, FALSE, '`pages`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pages->Nullable = FALSE; // NOT NULL field
		$this->pages->Required = TRUE; // Required field
		$this->pages->Sortable = TRUE; // Allow sort
		$this->fields['pages'] = &$this->pages;

		// paper
		$this->paper = new DbField('p_eastimate', 'p_eastimate', 'x_paper', 'paper', '`paper`', '`paper`', 2, -1, FALSE, '`paper`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->paper->Required = TRUE; // Required field
		$this->paper->Sortable = TRUE; // Allow sort
		$this->paper->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['paper'] = &$this->paper;

		// remarks
		$this->remarks = new DbField('p_eastimate', 'p_eastimate', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// pr_01
		$this->pr_01 = new DbField('p_eastimate', 'p_eastimate', 'x_pr_01', 'pr_01', '`pr_01`', '`pr_01`', 200, -1, FALSE, '`EV__pr_01`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->pr_01->Sortable = TRUE; // Allow sort
		$this->pr_01->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pr_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pr_01->Lookup = new Lookup('pr_01', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->pr_01->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pr_01'] = &$this->pr_01;

		// qty_pr_01
		$this->qty_pr_01 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pr_01', 'qty_pr_01', '`qty_pr_01`', '`qty_pr_01`', 131, -1, FALSE, '`qty_pr_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pr_01->Nullable = FALSE; // NOT NULL field
		$this->qty_pr_01->Required = TRUE; // Required field
		$this->qty_pr_01->Sortable = TRUE; // Allow sort
		$this->qty_pr_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pr_01'] = &$this->qty_pr_01;

		// pl_01
		$this->pl_01 = new DbField('p_eastimate', 'p_eastimate', 'x_pl_01', 'pl_01', '`pl_01`', '`pl_01`', 200, -1, FALSE, '`pl_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pl_01->Sortable = TRUE; // Allow sort
		$this->pl_01->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pl_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pl_01->Lookup = new Lookup('pl_01', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->pl_01->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pl_01'] = &$this->pl_01;

		// qty_pl_01
		$this->qty_pl_01 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pl_01', 'qty_pl_01', '`qty_pl_01`', '`qty_pl_01`', 131, -1, FALSE, '`qty_pl_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pl_01->Nullable = FALSE; // NOT NULL field
		$this->qty_pl_01->Required = TRUE; // Required field
		$this->qty_pl_01->Sortable = TRUE; // Allow sort
		$this->qty_pl_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pl_01'] = &$this->qty_pl_01;

		// pr_02
		$this->pr_02 = new DbField('p_eastimate', 'p_eastimate', 'x_pr_02', 'pr_02', '`pr_02`', '`pr_02`', 200, -1, FALSE, '`EV__pr_02`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->pr_02->Sortable = TRUE; // Allow sort
		$this->pr_02->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pr_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pr_02->Lookup = new Lookup('pr_02', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->pr_02->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pr_02'] = &$this->pr_02;

		// qty_pr_02
		$this->qty_pr_02 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pr_02', 'qty_pr_02', '`qty_pr_02`', '`qty_pr_02`', 131, -1, FALSE, '`qty_pr_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pr_02->Nullable = FALSE; // NOT NULL field
		$this->qty_pr_02->Required = TRUE; // Required field
		$this->qty_pr_02->Sortable = TRUE; // Allow sort
		$this->qty_pr_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pr_02'] = &$this->qty_pr_02;

		// pl_02
		$this->pl_02 = new DbField('p_eastimate', 'p_eastimate', 'x_pl_02', 'pl_02', '`pl_02`', '`pl_02`', 200, -1, FALSE, '`pl_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pl_02->Sortable = TRUE; // Allow sort
		$this->pl_02->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pl_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pl_02->Lookup = new Lookup('pl_02', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->pl_02->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pl_02'] = &$this->pl_02;

		// qty_pl_02
		$this->qty_pl_02 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pl_02', 'qty_pl_02', '`qty_pl_02`', '`qty_pl_02`', 131, -1, FALSE, '`qty_pl_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pl_02->Nullable = FALSE; // NOT NULL field
		$this->qty_pl_02->Required = TRUE; // Required field
		$this->qty_pl_02->Sortable = TRUE; // Allow sort
		$this->qty_pl_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pl_02'] = &$this->qty_pl_02;

		// pr_03
		$this->pr_03 = new DbField('p_eastimate', 'p_eastimate', 'x_pr_03', 'pr_03', '`pr_03`', '`pr_03`', 200, -1, FALSE, '`EV__pr_03`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->pr_03->Sortable = TRUE; // Allow sort
		$this->pr_03->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pr_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pr_03->Lookup = new Lookup('pr_03', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->pr_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pr_03'] = &$this->pr_03;

		// qty_pr_03
		$this->qty_pr_03 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pr_03', 'qty_pr_03', '`qty_pr_03`', '`qty_pr_03`', 131, -1, FALSE, '`qty_pr_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pr_03->Nullable = FALSE; // NOT NULL field
		$this->qty_pr_03->Required = TRUE; // Required field
		$this->qty_pr_03->Sortable = TRUE; // Allow sort
		$this->qty_pr_03->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pr_03'] = &$this->qty_pr_03;

		// pl_03
		$this->pl_03 = new DbField('p_eastimate', 'p_eastimate', 'x_pl_03', 'pl_03', '`pl_03`', '`pl_03`', 200, -1, FALSE, '`pl_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pl_03->Sortable = TRUE; // Allow sort
		$this->pl_03->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pl_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pl_03->Lookup = new Lookup('pl_03', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->pl_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pl_03'] = &$this->pl_03;

		// qty_pl_03
		$this->qty_pl_03 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pl_03', 'qty_pl_03', '`qty_pl_03`', '`qty_pl_03`', 131, -1, FALSE, '`qty_pl_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pl_03->Nullable = FALSE; // NOT NULL field
		$this->qty_pl_03->Required = TRUE; // Required field
		$this->qty_pl_03->Sortable = TRUE; // Allow sort
		$this->qty_pl_03->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pl_03'] = &$this->qty_pl_03;

		// pr_04
		$this->pr_04 = new DbField('p_eastimate', 'p_eastimate', 'x_pr_04', 'pr_04', '`pr_04`', '`pr_04`', 200, -1, FALSE, '`EV__pr_04`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->pr_04->Sortable = TRUE; // Allow sort
		$this->pr_04->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pr_04->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pr_04->Lookup = new Lookup('pr_04', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->pr_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pr_04'] = &$this->pr_04;

		// qty_pr_04
		$this->qty_pr_04 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pr_04', 'qty_pr_04', '`qty_pr_04`', '`qty_pr_04`', 131, -1, FALSE, '`qty_pr_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pr_04->Nullable = FALSE; // NOT NULL field
		$this->qty_pr_04->Required = TRUE; // Required field
		$this->qty_pr_04->Sortable = TRUE; // Allow sort
		$this->qty_pr_04->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pr_04'] = &$this->qty_pr_04;

		// pl_04
		$this->pl_04 = new DbField('p_eastimate', 'p_eastimate', 'x_pl_04', 'pl_04', '`pl_04`', '`pl_04`', 200, -1, FALSE, '`pl_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pl_04->Sortable = TRUE; // Allow sort
		$this->pl_04->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pl_04->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pl_04->Lookup = new Lookup('pl_04', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->pl_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pl_04'] = &$this->pl_04;

		// qty_pl_04
		$this->qty_pl_04 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pl_04', 'qty_pl_04', '`qty_pl_04`', '`qty_pl_04`', 131, -1, FALSE, '`qty_pl_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pl_04->Nullable = FALSE; // NOT NULL field
		$this->qty_pl_04->Required = TRUE; // Required field
		$this->qty_pl_04->Sortable = TRUE; // Allow sort
		$this->qty_pl_04->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pl_04'] = &$this->qty_pl_04;

		// pa_01
		$this->pa_01 = new DbField('p_eastimate', 'p_eastimate', 'x_pa_01', 'pa_01', '`pa_01`', '`pa_01`', 200, -1, FALSE, '`pa_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pa_01->Sortable = TRUE; // Allow sort
		$this->pa_01->Lookup = new Lookup('pa_01', 'stock_lcgp', FALSE, 'id', ["product_code_pg","","",""], [], [], [], [], [], [], '`product_code_pg` DESC', '');
		$this->fields['pa_01'] = &$this->pa_01;

		// qty_pa_01
		$this->qty_pa_01 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pa_01', 'qty_pa_01', '`qty_pa_01`', '`qty_pa_01`', 131, -1, FALSE, '`qty_pa_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pa_01->Nullable = FALSE; // NOT NULL field
		$this->qty_pa_01->Required = TRUE; // Required field
		$this->qty_pa_01->Sortable = TRUE; // Allow sort
		$this->qty_pa_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pa_01'] = &$this->qty_pa_01;

		// pa_02
		$this->pa_02 = new DbField('p_eastimate', 'p_eastimate', 'x_pa_02', 'pa_02', '`pa_02`', '`pa_02`', 200, -1, FALSE, '`pa_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pa_02->Sortable = TRUE; // Allow sort
		$this->pa_02->Lookup = new Lookup('pa_02', 'stock_lcgp', FALSE, 'id', ["product_code_pg","","",""], [], [], [], [], [], [], '`product_code_pg` DESC', '');
		$this->fields['pa_02'] = &$this->pa_02;

		// qty_pa_02
		$this->qty_pa_02 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pa_02', 'qty_pa_02', '`qty_pa_02`', '`qty_pa_02`', 131, -1, FALSE, '`qty_pa_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pa_02->Nullable = FALSE; // NOT NULL field
		$this->qty_pa_02->Required = TRUE; // Required field
		$this->qty_pa_02->Sortable = TRUE; // Allow sort
		$this->qty_pa_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pa_02'] = &$this->qty_pa_02;

		// pa_03
		$this->pa_03 = new DbField('p_eastimate', 'p_eastimate', 'x_pa_03', 'pa_03', '`pa_03`', '`pa_03`', 200, -1, FALSE, '`pa_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pa_03->Sortable = TRUE; // Allow sort
		$this->pa_03->Lookup = new Lookup('pa_03', 'stock_lcgp', FALSE, 'id', ["product_code_pg","","",""], [], [], [], [], [], [], '`product_code_pg` DESC', '');
		$this->fields['pa_03'] = &$this->pa_03;

		// qty_pa_03
		$this->qty_pa_03 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pa_03', 'qty_pa_03', '`qty_pa_03`', '`qty_pa_03`', 131, -1, FALSE, '`qty_pa_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pa_03->Nullable = FALSE; // NOT NULL field
		$this->qty_pa_03->Required = TRUE; // Required field
		$this->qty_pa_03->Sortable = TRUE; // Allow sort
		$this->qty_pa_03->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pa_03'] = &$this->qty_pa_03;

		// pa_04
		$this->pa_04 = new DbField('p_eastimate', 'p_eastimate', 'x_pa_04', 'pa_04', '`pa_04`', '`pa_04`', 200, 0, FALSE, '`pa_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pa_04->Sortable = TRUE; // Allow sort
		$this->pa_04->Lookup = new Lookup('pa_04', 'stock_lcgp', FALSE, 'id', ["product_code_pg","","",""], [], [], [], [], [], [], '`product_code_pg` DESC', '');
		$this->fields['pa_04'] = &$this->pa_04;

		// qty_pa_04
		$this->qty_pa_04 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pa_04', 'qty_pa_04', '`qty_pa_04`', '`qty_pa_04`', 131, -1, FALSE, '`qty_pa_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pa_04->Nullable = FALSE; // NOT NULL field
		$this->qty_pa_04->Required = TRUE; // Required field
		$this->qty_pa_04->Sortable = TRUE; // Allow sort
		$this->qty_pa_04->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pa_04'] = &$this->qty_pa_04;

		// pa_05
		$this->pa_05 = new DbField('p_eastimate', 'p_eastimate', 'x_pa_05', 'pa_05', '`pa_05`', '`pa_05`', 200, -1, FALSE, '`pa_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pa_05->Sortable = TRUE; // Allow sort
		$this->pa_05->Lookup = new Lookup('pa_05', 'stock_lcgp', FALSE, 'id', ["product_code_pg","","",""], [], [], [], [], [], [], '`product_code_pg` DESC', '');
		$this->pa_05->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pa_05'] = &$this->pa_05;

		// qty_pa_05
		$this->qty_pa_05 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pa_05', 'qty_pa_05', '`qty_pa_05`', '`qty_pa_05`', 131, -1, FALSE, '`qty_pa_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pa_05->Nullable = FALSE; // NOT NULL field
		$this->qty_pa_05->Required = TRUE; // Required field
		$this->qty_pa_05->Sortable = TRUE; // Allow sort
		$this->qty_pa_05->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pa_05'] = &$this->qty_pa_05;

		// pc_01
		$this->pc_01 = new DbField('p_eastimate', 'p_eastimate', 'x_pc_01', 'pc_01', '`pc_01`', '`pc_01`', 200, -1, FALSE, '`pc_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pc_01->Sortable = TRUE; // Allow sort
		$this->pc_01->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pc_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pc_01->Lookup = new Lookup('pc_01', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->fields['pc_01'] = &$this->pc_01;

		// qty_pc_01
		$this->qty_pc_01 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pc_01', 'qty_pc_01', '`qty_pc_01`', '`qty_pc_01`', 131, -1, FALSE, '`qty_pc_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pc_01->Nullable = FALSE; // NOT NULL field
		$this->qty_pc_01->Required = TRUE; // Required field
		$this->qty_pc_01->Sortable = TRUE; // Allow sort
		$this->qty_pc_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pc_01'] = &$this->qty_pc_01;

		// pc_02
		$this->pc_02 = new DbField('p_eastimate', 'p_eastimate', 'x_pc_02', 'pc_02', '`pc_02`', '`pc_02`', 200, -1, FALSE, '`pc_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pc_02->Sortable = TRUE; // Allow sort
		$this->pc_02->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pc_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pc_02->Lookup = new Lookup('pc_02', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->fields['pc_02'] = &$this->pc_02;

		// qty_pc_02
		$this->qty_pc_02 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_pc_02', 'qty_pc_02', '`qty_pc_02`', '`qty_pc_02`', 131, -1, FALSE, '`qty_pc_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_pc_02->Nullable = FALSE; // NOT NULL field
		$this->qty_pc_02->Required = TRUE; // Required field
		$this->qty_pc_02->Sortable = TRUE; // Allow sort
		$this->qty_pc_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_pc_02'] = &$this->qty_pc_02;

		// o_01
		$this->o_01 = new DbField('p_eastimate', 'p_eastimate', 'x_o_01', 'o_01', '`o_01`', '`o_01`', 200, -1, FALSE, '`o_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->o_01->Sortable = TRUE; // Allow sort
		$this->o_01->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->o_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->o_01->Lookup = new Lookup('o_01', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->fields['o_01'] = &$this->o_01;

		// qty_o_01
		$this->qty_o_01 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_o_01', 'qty_o_01', '`qty_o_01`', '`qty_o_01`', 131, -1, FALSE, '`qty_o_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_o_01->Nullable = FALSE; // NOT NULL field
		$this->qty_o_01->Required = TRUE; // Required field
		$this->qty_o_01->Sortable = TRUE; // Allow sort
		$this->qty_o_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_o_01'] = &$this->qty_o_01;

		// lamination_type
		$this->lamination_type = new DbField('p_eastimate', 'p_eastimate', 'x_lamination_type', 'lamination_type', '`lamination_type`', '`lamination_type`', 200, 0, FALSE, '`EV__lamination_type`', TRUE, TRUE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->lamination_type->Sortable = TRUE; // Allow sort
		$this->lamination_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->lamination_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->lamination_type->Lookup = new Lookup('lamination_type', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->lamination_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['lamination_type'] = &$this->lamination_type;

		// lamination_qty
		$this->lamination_qty = new DbField('p_eastimate', 'p_eastimate', 'x_lamination_qty', 'lamination_qty', '`lamination_qty`', '`lamination_qty`', 3, -1, FALSE, '`lamination_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lamination_qty->Required = TRUE; // Required field
		$this->lamination_qty->Sortable = TRUE; // Allow sort
		$this->lamination_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['lamination_qty'] = &$this->lamination_qty;

		// die_type
		$this->die_type = new DbField('p_eastimate', 'p_eastimate', 'x_die_type', 'die_type', '`die_type`', '`die_type`', 200, -1, FALSE, '`EV__die_type`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->die_type->Sortable = TRUE; // Allow sort
		$this->die_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->die_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->die_type->Lookup = new Lookup('die_type', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->die_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['die_type'] = &$this->die_type;

		// die_qty
		$this->die_qty = new DbField('p_eastimate', 'p_eastimate', 'x_die_qty', 'die_qty', '`die_qty`', '`die_qty`', 2, -1, FALSE, '`die_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->die_qty->Nullable = FALSE; // NOT NULL field
		$this->die_qty->Required = TRUE; // Required field
		$this->die_qty->Sortable = TRUE; // Allow sort
		$this->die_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['die_qty'] = &$this->die_qty;

		// binding_type
		$this->binding_type = new DbField('p_eastimate', 'p_eastimate', 'x_binding_type', 'binding_type', '`binding_type`', '`binding_type`', 200, -1, FALSE, '`binding_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->binding_type->Sortable = TRUE; // Allow sort
		$this->binding_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->binding_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->binding_type->Lookup = new Lookup('binding_type', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->binding_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['binding_type'] = &$this->binding_type;

		// binding_qty
		$this->binding_qty = new DbField('p_eastimate', 'p_eastimate', 'x_binding_qty', 'binding_qty', '`binding_qty`', '`binding_qty`', 131, -1, FALSE, '`binding_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->binding_qty->Nullable = FALSE; // NOT NULL field
		$this->binding_qty->Required = TRUE; // Required field
		$this->binding_qty->Sortable = TRUE; // Allow sort
		$this->binding_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['binding_qty'] = &$this->binding_qty;

		// number_type
		$this->number_type = new DbField('p_eastimate', 'p_eastimate', 'x_number_type', 'number_type', '`number_type`', '`number_type`', 200, -1, FALSE, '`EV__number_type`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->number_type->Sortable = TRUE; // Allow sort
		$this->number_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->number_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->number_type->Lookup = new Lookup('number_type', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->number_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['number_type'] = &$this->number_type;

		// number_qty
		$this->number_qty = new DbField('p_eastimate', 'p_eastimate', 'x_number_qty', 'number_qty', '`number_qty`', '`number_qty`', 3, -1, FALSE, '`number_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->number_qty->Nullable = FALSE; // NOT NULL field
		$this->number_qty->Required = TRUE; // Required field
		$this->number_qty->Sortable = TRUE; // Allow sort
		$this->number_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['number_qty'] = &$this->number_qty;

		// de_01
		$this->de_01 = new DbField('p_eastimate', 'p_eastimate', 'x_de_01', 'de_01', '`de_01`', '`de_01`', 200, -1, FALSE, '`EV__de_01`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->de_01->Sortable = TRUE; // Allow sort
		$this->de_01->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->de_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->de_01->Lookup = new Lookup('de_01', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->de_01->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['de_01'] = &$this->de_01;

		// qty_de_01
		$this->qty_de_01 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_de_01', 'qty_de_01', '`qty_de_01`', '`qty_de_01`', 131, -1, FALSE, '`qty_de_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_de_01->Nullable = FALSE; // NOT NULL field
		$this->qty_de_01->Required = TRUE; // Required field
		$this->qty_de_01->Sortable = TRUE; // Allow sort
		$this->qty_de_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_de_01'] = &$this->qty_de_01;

		// de_02
		$this->de_02 = new DbField('p_eastimate', 'p_eastimate', 'x_de_02', 'de_02', '`de_02`', '`de_02`', 200, -1, FALSE, '`EV__de_02`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->de_02->Sortable = TRUE; // Allow sort
		$this->de_02->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->de_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->de_02->Lookup = new Lookup('de_02', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->de_02->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['de_02'] = &$this->de_02;

		// qty_de_02
		$this->qty_de_02 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_de_02', 'qty_de_02', '`qty_de_02`', '`qty_de_02`', 131, -1, FALSE, '`qty_de_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_de_02->Nullable = FALSE; // NOT NULL field
		$this->qty_de_02->Required = TRUE; // Required field
		$this->qty_de_02->Sortable = TRUE; // Allow sort
		$this->qty_de_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_de_02'] = &$this->qty_de_02;

		// de_03
		$this->de_03 = new DbField('p_eastimate', 'p_eastimate', 'x_de_03', 'de_03', '`de_03`', '`de_03`', 200, -1, FALSE, '`EV__de_03`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->de_03->Sortable = TRUE; // Allow sort
		$this->de_03->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->de_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->de_03->Lookup = new Lookup('de_03', 'material_status', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->de_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['de_03'] = &$this->de_03;

		// qty_de_03
		$this->qty_de_03 = new DbField('p_eastimate', 'p_eastimate', 'x_qty_de_03', 'qty_de_03', '`qty_de_03`', '`qty_de_03`', 131, -1, FALSE, '`qty_de_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty_de_03->Nullable = FALSE; // NOT NULL field
		$this->qty_de_03->Required = TRUE; // Required field
		$this->qty_de_03->Sortable = TRUE; // Allow sort
		$this->qty_de_03->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['qty_de_03'] = &$this->qty_de_03;

		// operator
		$this->operator = new DbField('p_eastimate', 'p_eastimate', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('p_eastimate', 'p_eastimate', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, -1, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`p_eastimate`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `product_code` FROM `material_status` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`pr_01` LIMIT 1) AS `EV__pr_01`, (SELECT `product_code` FROM `material_status` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`pr_02` LIMIT 1) AS `EV__pr_02`, (SELECT `product_code` FROM `material_status` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`pr_03` LIMIT 1) AS `EV__pr_03`, (SELECT `product_code` FROM `material_status` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`pr_04` LIMIT 1) AS `EV__pr_04`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`lamination_type` LIMIT 1) AS `EV__lamination_type`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`die_type` LIMIT 1) AS `EV__die_type`, (SELECT `product_code` FROM `material_status` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`number_type` LIMIT 1) AS `EV__number_type`, (SELECT `product_code` FROM `material_status` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`de_01` LIMIT 1) AS `EV__de_01`, (SELECT `product_code` FROM `material_status` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`de_02` LIMIT 1) AS `EV__de_02`, (SELECT `product_code` FROM `material_status` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_eastimate`.`de_03` LIMIT 1) AS `EV__de_03` FROM `p_eastimate`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->pr_01->AdvancedSearch->SearchValue <> "" ||
			$this->pr_01->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->pr_01->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->pr_01->VirtualExpression . " "))
			return TRUE;
		if ($this->pr_02->AdvancedSearch->SearchValue <> "" ||
			$this->pr_02->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->pr_02->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->pr_02->VirtualExpression . " "))
			return TRUE;
		if ($this->pr_03->AdvancedSearch->SearchValue <> "" ||
			$this->pr_03->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->pr_03->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->pr_03->VirtualExpression . " "))
			return TRUE;
		if ($this->pr_04->AdvancedSearch->SearchValue <> "" ||
			$this->pr_04->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->pr_04->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->pr_04->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->lamination_type->VirtualExpression . " "))
			return TRUE;
		if ($this->die_type->AdvancedSearch->SearchValue <> "" ||
			$this->die_type->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->die_type->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->die_type->VirtualExpression . " "))
			return TRUE;
		if ($this->number_type->AdvancedSearch->SearchValue <> "" ||
			$this->number_type->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->number_type->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->number_type->VirtualExpression . " "))
			return TRUE;
		if ($this->de_01->AdvancedSearch->SearchValue <> "" ||
			$this->de_01->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->de_01->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->de_01->VirtualExpression . " "))
			return TRUE;
		if ($this->de_02->AdvancedSearch->SearchValue <> "" ||
			$this->de_02->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->de_02->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->de_02->VirtualExpression . " "))
			return TRUE;
		if ($this->de_03->AdvancedSearch->SearchValue <> "" ||
			$this->de_03->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->de_03->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->de_03->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->job_type->DbValue = $row['job_type'];
		$this->job_category->DbValue = $row['job_category'];
		$this->company_id->DbValue = $row['company_id'];
		$this->description->DbValue = $row['description'];
		$this->size->DbValue = $row['size'];
		$this->quantity->DbValue = $row['quantity'];
		$this->pages->DbValue = $row['pages'];
		$this->paper->DbValue = $row['paper'];
		$this->remarks->DbValue = $row['remarks'];
		$this->pr_01->DbValue = $row['pr_01'];
		$this->qty_pr_01->DbValue = $row['qty_pr_01'];
		$this->pl_01->DbValue = $row['pl_01'];
		$this->qty_pl_01->DbValue = $row['qty_pl_01'];
		$this->pr_02->DbValue = $row['pr_02'];
		$this->qty_pr_02->DbValue = $row['qty_pr_02'];
		$this->pl_02->DbValue = $row['pl_02'];
		$this->qty_pl_02->DbValue = $row['qty_pl_02'];
		$this->pr_03->DbValue = $row['pr_03'];
		$this->qty_pr_03->DbValue = $row['qty_pr_03'];
		$this->pl_03->DbValue = $row['pl_03'];
		$this->qty_pl_03->DbValue = $row['qty_pl_03'];
		$this->pr_04->DbValue = $row['pr_04'];
		$this->qty_pr_04->DbValue = $row['qty_pr_04'];
		$this->pl_04->DbValue = $row['pl_04'];
		$this->qty_pl_04->DbValue = $row['qty_pl_04'];
		$this->pa_01->DbValue = $row['pa_01'];
		$this->qty_pa_01->DbValue = $row['qty_pa_01'];
		$this->pa_02->DbValue = $row['pa_02'];
		$this->qty_pa_02->DbValue = $row['qty_pa_02'];
		$this->pa_03->DbValue = $row['pa_03'];
		$this->qty_pa_03->DbValue = $row['qty_pa_03'];
		$this->pa_04->DbValue = $row['pa_04'];
		$this->qty_pa_04->DbValue = $row['qty_pa_04'];
		$this->pa_05->DbValue = $row['pa_05'];
		$this->qty_pa_05->DbValue = $row['qty_pa_05'];
		$this->pc_01->DbValue = $row['pc_01'];
		$this->qty_pc_01->DbValue = $row['qty_pc_01'];
		$this->pc_02->DbValue = $row['pc_02'];
		$this->qty_pc_02->DbValue = $row['qty_pc_02'];
		$this->o_01->DbValue = $row['o_01'];
		$this->qty_o_01->DbValue = $row['qty_o_01'];
		$this->lamination_type->DbValue = $row['lamination_type'];
		$this->lamination_qty->DbValue = $row['lamination_qty'];
		$this->die_type->DbValue = $row['die_type'];
		$this->die_qty->DbValue = $row['die_qty'];
		$this->binding_type->DbValue = $row['binding_type'];
		$this->binding_qty->DbValue = $row['binding_qty'];
		$this->number_type->DbValue = $row['number_type'];
		$this->number_qty->DbValue = $row['number_qty'];
		$this->de_01->DbValue = $row['de_01'];
		$this->qty_de_01->DbValue = $row['qty_de_01'];
		$this->de_02->DbValue = $row['de_02'];
		$this->qty_de_02->DbValue = $row['qty_de_02'];
		$this->de_03->DbValue = $row['de_03'];
		$this->qty_de_03->DbValue = $row['qty_de_03'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "p_eastimatelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "p_eastimateview.php")
			return $Language->phrase("View");
		elseif ($pageName == "p_eastimateedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "p_eastimateadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "p_eastimatelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("p_eastimateview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("p_eastimateview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "p_eastimateadd.php?" . $this->getUrlParm($parm);
		else
			$url = "p_eastimateadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("p_eastimateedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("p_eastimateadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("p_eastimatedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->job_type->setDbValue($rs->fields('job_type'));
		$this->job_category->setDbValue($rs->fields('job_category'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->description->setDbValue($rs->fields('description'));
		$this->size->setDbValue($rs->fields('size'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->pages->setDbValue($rs->fields('pages'));
		$this->paper->setDbValue($rs->fields('paper'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->pr_01->setDbValue($rs->fields('pr_01'));
		$this->qty_pr_01->setDbValue($rs->fields('qty_pr_01'));
		$this->pl_01->setDbValue($rs->fields('pl_01'));
		$this->qty_pl_01->setDbValue($rs->fields('qty_pl_01'));
		$this->pr_02->setDbValue($rs->fields('pr_02'));
		$this->qty_pr_02->setDbValue($rs->fields('qty_pr_02'));
		$this->pl_02->setDbValue($rs->fields('pl_02'));
		$this->qty_pl_02->setDbValue($rs->fields('qty_pl_02'));
		$this->pr_03->setDbValue($rs->fields('pr_03'));
		$this->qty_pr_03->setDbValue($rs->fields('qty_pr_03'));
		$this->pl_03->setDbValue($rs->fields('pl_03'));
		$this->qty_pl_03->setDbValue($rs->fields('qty_pl_03'));
		$this->pr_04->setDbValue($rs->fields('pr_04'));
		$this->qty_pr_04->setDbValue($rs->fields('qty_pr_04'));
		$this->pl_04->setDbValue($rs->fields('pl_04'));
		$this->qty_pl_04->setDbValue($rs->fields('qty_pl_04'));
		$this->pa_01->setDbValue($rs->fields('pa_01'));
		$this->qty_pa_01->setDbValue($rs->fields('qty_pa_01'));
		$this->pa_02->setDbValue($rs->fields('pa_02'));
		$this->qty_pa_02->setDbValue($rs->fields('qty_pa_02'));
		$this->pa_03->setDbValue($rs->fields('pa_03'));
		$this->qty_pa_03->setDbValue($rs->fields('qty_pa_03'));
		$this->pa_04->setDbValue($rs->fields('pa_04'));
		$this->qty_pa_04->setDbValue($rs->fields('qty_pa_04'));
		$this->pa_05->setDbValue($rs->fields('pa_05'));
		$this->qty_pa_05->setDbValue($rs->fields('qty_pa_05'));
		$this->pc_01->setDbValue($rs->fields('pc_01'));
		$this->qty_pc_01->setDbValue($rs->fields('qty_pc_01'));
		$this->pc_02->setDbValue($rs->fields('pc_02'));
		$this->qty_pc_02->setDbValue($rs->fields('qty_pc_02'));
		$this->o_01->setDbValue($rs->fields('o_01'));
		$this->qty_o_01->setDbValue($rs->fields('qty_o_01'));
		$this->lamination_type->setDbValue($rs->fields('lamination_type'));
		$this->lamination_qty->setDbValue($rs->fields('lamination_qty'));
		$this->die_type->setDbValue($rs->fields('die_type'));
		$this->die_qty->setDbValue($rs->fields('die_qty'));
		$this->binding_type->setDbValue($rs->fields('binding_type'));
		$this->binding_qty->setDbValue($rs->fields('binding_qty'));
		$this->number_type->setDbValue($rs->fields('number_type'));
		$this->number_qty->setDbValue($rs->fields('number_qty'));
		$this->de_01->setDbValue($rs->fields('de_01'));
		$this->qty_de_01->setDbValue($rs->fields('qty_de_01'));
		$this->de_02->setDbValue($rs->fields('de_02'));
		$this->qty_de_02->setDbValue($rs->fields('qty_de_02'));
		$this->de_03->setDbValue($rs->fields('de_03'));
		$this->qty_de_03->setDbValue($rs->fields('qty_de_03'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// job_type
		// job_category
		// company_id
		// description
		// size
		// quantity
		// pages
		// paper
		// remarks
		// pr_01
		// qty_pr_01
		// pl_01
		// qty_pl_01
		// pr_02
		// qty_pr_02
		// pl_02
		// qty_pl_02
		// pr_03
		// qty_pr_03
		// pl_03
		// qty_pl_03
		// pr_04
		// qty_pr_04
		// pl_04
		// qty_pl_04
		// pa_01
		// qty_pa_01
		// pa_02
		// qty_pa_02
		// pa_03
		// qty_pa_03
		// pa_04
		// qty_pa_04
		// pa_05
		// qty_pa_05
		// pc_01
		// qty_pc_01
		// pc_02
		// qty_pc_02
		// o_01
		// qty_o_01
		// lamination_type
		// lamination_qty
		// die_type
		// die_qty
		// binding_type
		// binding_qty
		// number_type
		// number_qty
		// de_01
		// qty_de_01
		// de_02
		// qty_de_02
		// de_03
		// qty_de_03
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// job_type
		if (strval($this->job_type->CurrentValue) <> "") {
			$this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
		} else {
			$this->job_type->ViewValue = NULL;
		}
		$this->job_type->ViewCustomAttributes = "";

		// job_category
		if (strval($this->job_category->CurrentValue) <> "") {
			$this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
		} else {
			$this->job_category->ViewValue = NULL;
		}
		$this->job_category->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// description
		$this->description->ViewValue = $this->description->CurrentValue;
		$this->description->ViewCustomAttributes = "";

		// size
		$curVal = strval($this->size->CurrentValue);
		if ($curVal <> "") {
			$this->size->ViewValue = $this->size->lookupCacheOption($curVal);
			if ($this->size->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`description`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->size->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->size->ViewValue = $this->size->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->size->ViewValue = $this->size->CurrentValue;
				}
			}
		} else {
			$this->size->ViewValue = NULL;
		}
		$this->size->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// pages
		$this->pages->ViewValue = $this->pages->CurrentValue;
		$this->pages->ViewCustomAttributes = "";

		// paper
		$this->paper->ViewValue = $this->paper->CurrentValue;
		$this->paper->ViewValue = FormatNumber($this->paper->ViewValue, 0, -2, -2, -2);
		$this->paper->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// pr_01
		if ($this->pr_01->VirtualValue <> "") {
			$this->pr_01->ViewValue = $this->pr_01->VirtualValue;
		} else {
		$curVal = strval($this->pr_01->CurrentValue);
		if ($curVal <> "") {
			$this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
			if ($this->pr_01->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (116)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pr_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pr_01->ViewValue = $this->pr_01->CurrentValue;
				}
			}
		} else {
			$this->pr_01->ViewValue = NULL;
		}
		}
		$this->pr_01->ViewCustomAttributes = "";

		// qty_pr_01
		$this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
		$this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, 2, -2, -2, -2);
		$this->qty_pr_01->ViewCustomAttributes = "";

		// pl_01
		$curVal = strval($this->pl_01->CurrentValue);
		if ($curVal <> "") {
			$this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
			if ($this->pl_01->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pl_01->ViewValue = $this->pl_01->CurrentValue;
				}
			}
		} else {
			$this->pl_01->ViewValue = NULL;
		}
		$this->pl_01->ViewCustomAttributes = "";

		// qty_pl_01
		$this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
		$this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, 2, -2, -2, -2);
		$this->qty_pl_01->ViewCustomAttributes = "";

		// pr_02
		if ($this->pr_02->VirtualValue <> "") {
			$this->pr_02->ViewValue = $this->pr_02->VirtualValue;
		} else {
		$curVal = strval($this->pr_02->CurrentValue);
		if ($curVal <> "") {
			$this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
			if ($this->pr_02->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (116)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pr_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pr_02->ViewValue = $this->pr_02->CurrentValue;
				}
			}
		} else {
			$this->pr_02->ViewValue = NULL;
		}
		}
		$this->pr_02->ViewCustomAttributes = "";

		// qty_pr_02
		$this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
		$this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, 2, -2, -2, -2);
		$this->qty_pr_02->ViewCustomAttributes = "";

		// pl_02
		$curVal = strval($this->pl_02->CurrentValue);
		if ($curVal <> "") {
			$this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
			if ($this->pl_02->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pl_02->ViewValue = $this->pl_02->CurrentValue;
				}
			}
		} else {
			$this->pl_02->ViewValue = NULL;
		}
		$this->pl_02->ViewCustomAttributes = "";

		// qty_pl_02
		$this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
		$this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, 2, -2, -2, -2);
		$this->qty_pl_02->ViewCustomAttributes = "";

		// pr_03
		if ($this->pr_03->VirtualValue <> "") {
			$this->pr_03->ViewValue = $this->pr_03->VirtualValue;
		} else {
		$curVal = strval($this->pr_03->CurrentValue);
		if ($curVal <> "") {
			$this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
			if ($this->pr_03->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (116)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pr_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pr_03->ViewValue = $this->pr_03->CurrentValue;
				}
			}
		} else {
			$this->pr_03->ViewValue = NULL;
		}
		}
		$this->pr_03->ViewCustomAttributes = "";

		// qty_pr_03
		$this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
		$this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, 2, -2, -2, -2);
		$this->qty_pr_03->ViewCustomAttributes = "";

		// pl_03
		$curVal = strval($this->pl_03->CurrentValue);
		if ($curVal <> "") {
			$this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
			if ($this->pl_03->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pl_03->ViewValue = $this->pl_03->CurrentValue;
				}
			}
		} else {
			$this->pl_03->ViewValue = NULL;
		}
		$this->pl_03->ViewCustomAttributes = "";

		// qty_pl_03
		$this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
		$this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, 2, -2, -2, -2);
		$this->qty_pl_03->ViewCustomAttributes = "";

		// pr_04
		if ($this->pr_04->VirtualValue <> "") {
			$this->pr_04->ViewValue = $this->pr_04->VirtualValue;
		} else {
		$curVal = strval($this->pr_04->CurrentValue);
		if ($curVal <> "") {
			$this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
			if ($this->pr_04->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (116)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pr_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pr_04->ViewValue = $this->pr_04->CurrentValue;
				}
			}
		} else {
			$this->pr_04->ViewValue = NULL;
		}
		}
		$this->pr_04->ViewCustomAttributes = "";

		// qty_pr_04
		$this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
		$this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, 2, -2, -2, -2);
		$this->qty_pr_04->ViewCustomAttributes = "";

		// pl_04
		$curVal = strval($this->pl_04->CurrentValue);
		if ($curVal <> "") {
			$this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
			if ($this->pl_04->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pl_04->ViewValue = $this->pl_04->CurrentValue;
				}
			}
		} else {
			$this->pl_04->ViewValue = NULL;
		}
		$this->pl_04->ViewCustomAttributes = "";

		// qty_pl_04
		$this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
		$this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, 2, -2, -2, -2);
		$this->qty_pl_04->ViewCustomAttributes = "";

		// pa_01
		$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
		$curVal = strval($this->pa_01->CurrentValue);
		if ($curVal <> "") {
			$this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
			if ($this->pa_01->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return "`s_grp` IN (101,102,112)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pa_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
				}
			}
		} else {
			$this->pa_01->ViewValue = NULL;
		}
		$this->pa_01->ViewCustomAttributes = "";

		// qty_pa_01
		$this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
		$this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, 2, -2, -2, -2);
		$this->qty_pa_01->ViewCustomAttributes = "";

		// pa_02
		$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
		$curVal = strval($this->pa_02->CurrentValue);
		if ($curVal <> "") {
			$this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
			if ($this->pa_02->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return "`s_grp` IN (101,102,112)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pa_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
				}
			}
		} else {
			$this->pa_02->ViewValue = NULL;
		}
		$this->pa_02->ViewCustomAttributes = "";

		// qty_pa_02
		$this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
		$this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, 2, -2, -2, -2);
		$this->qty_pa_02->ViewCustomAttributes = "";

		// pa_03
		$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
		$curVal = strval($this->pa_03->CurrentValue);
		if ($curVal <> "") {
			$this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
			if ($this->pa_03->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return "`s_grp` IN (101,102,112)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pa_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
				}
			}
		} else {
			$this->pa_03->ViewValue = NULL;
		}
		$this->pa_03->ViewCustomAttributes = "";

		// qty_pa_03
		$this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
		$this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, 2, -2, -2, -2);
		$this->qty_pa_03->ViewCustomAttributes = "";

		// pa_04
		$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
		$curVal = strval($this->pa_04->CurrentValue);
		if ($curVal <> "") {
			$this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
			if ($this->pa_04->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return "`s_grp` IN (101,102,112)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pa_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
				}
			}
		} else {
			$this->pa_04->ViewValue = NULL;
		}
		$this->pa_04->ViewCustomAttributes = "";

		// qty_pa_04
		$this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
		$this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, 2, -2, -2, -2);
		$this->qty_pa_04->ViewCustomAttributes = "";

		// pa_05
		$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
		$curVal = strval($this->pa_05->CurrentValue);
		if ($curVal <> "") {
			$this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
			if ($this->pa_05->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return "`s_grp` IN (101,102,112)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pa_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
				}
			}
		} else {
			$this->pa_05->ViewValue = NULL;
		}
		$this->pa_05->ViewCustomAttributes = "";

		// qty_pa_05
		$this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
		$this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, 2, -2, -2, -2);
		$this->qty_pa_05->ViewCustomAttributes = "";

		// pc_01
		$curVal = strval($this->pc_01->CurrentValue);
		if ($curVal <> "") {
			$this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
			if ($this->pc_01->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (125) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pc_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pc_01->ViewValue = $this->pc_01->CurrentValue;
				}
			}
		} else {
			$this->pc_01->ViewValue = NULL;
		}
		$this->pc_01->ViewCustomAttributes = "";

		// qty_pc_01
		$this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
		$this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, 2, -2, -2, -2);
		$this->qty_pc_01->ViewCustomAttributes = "";

		// pc_02
		$curVal = strval($this->pc_02->CurrentValue);
		if ($curVal <> "") {
			$this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
			if ($this->pc_02->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (125) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pc_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pc_02->ViewValue = $this->pc_02->CurrentValue;
				}
			}
		} else {
			$this->pc_02->ViewValue = NULL;
		}
		$this->pc_02->ViewCustomAttributes = "";

		// qty_pc_02
		$this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
		$this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, 2, -2, -2, -2);
		$this->qty_pc_02->ViewCustomAttributes = "";

		// o_01
		$curVal = strval($this->o_01->CurrentValue);
		if ($curVal <> "") {
			$this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
			if ($this->o_01->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->o_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->o_01->ViewValue = $this->o_01->CurrentValue;
				}
			}
		} else {
			$this->o_01->ViewValue = NULL;
		}
		$this->o_01->ViewCustomAttributes = "";

		// qty_o_01
		$this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
		$this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, 2, -2, -2, -2);
		$this->qty_o_01->ViewCustomAttributes = "";

		// lamination_type
		if ($this->lamination_type->VirtualValue <> "") {
			$this->lamination_type->ViewValue = $this->lamination_type->VirtualValue;
		} else {
		$curVal = strval($this->lamination_type->CurrentValue);
		if ($curVal <> "") {
			$this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
			if ($this->lamination_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (123) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->lamination_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
				}
			}
		} else {
			$this->lamination_type->ViewValue = NULL;
		}
		}
		$this->lamination_type->ViewCustomAttributes = "";

		// lamination_qty
		$this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
		$this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, 0, -2, -2, -2);
		$this->lamination_qty->ViewCustomAttributes = "";

		// die_type
		if ($this->die_type->VirtualValue <> "") {
			$this->die_type->ViewValue = $this->die_type->VirtualValue;
		} else {
		$curVal = strval($this->die_type->CurrentValue);
		if ($curVal <> "") {
			$this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
			if ($this->die_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (124) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->die_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->die_type->ViewValue = $this->die_type->CurrentValue;
				}
			}
		} else {
			$this->die_type->ViewValue = NULL;
		}
		}
		$this->die_type->ViewCustomAttributes = "";

		// die_qty
		$this->die_qty->ViewValue = $this->die_qty->CurrentValue;
		$this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, 0, -2, -2, -2);
		$this->die_qty->ViewCustomAttributes = "";

		// binding_type
		$curVal = strval($this->binding_type->CurrentValue);
		if ($curVal <> "") {
			$this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
			if ($this->binding_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (114) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->binding_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->binding_type->ViewValue = $this->binding_type->CurrentValue;
				}
			}
		} else {
			$this->binding_type->ViewValue = NULL;
		}
		$this->binding_type->ViewCustomAttributes = "";

		// binding_qty
		$this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
		$this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, 2, -2, -2, -2);
		$this->binding_qty->ViewCustomAttributes = "";

		// number_type
		if ($this->number_type->VirtualValue <> "") {
			$this->number_type->ViewValue = $this->number_type->VirtualValue;
		} else {
		$curVal = strval($this->number_type->CurrentValue);
		if ($curVal <> "") {
			$this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
			if ($this->number_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (114) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->number_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->number_type->ViewValue = $this->number_type->CurrentValue;
				}
			}
		} else {
			$this->number_type->ViewValue = NULL;
		}
		}
		$this->number_type->ViewCustomAttributes = "";

		// number_qty
		$this->number_qty->ViewValue = $this->number_qty->CurrentValue;
		$this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, 0, -2, -2, -2);
		$this->number_qty->ViewCustomAttributes = "";

		// de_01
		if ($this->de_01->VirtualValue <> "") {
			$this->de_01->ViewValue = $this->de_01->VirtualValue;
		} else {
		$curVal = strval($this->de_01->CurrentValue);
		if ($curVal <> "") {
			$this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
			if ($this->de_01->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (121) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->de_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->de_01->ViewValue = $this->de_01->CurrentValue;
				}
			}
		} else {
			$this->de_01->ViewValue = NULL;
		}
		}
		$this->de_01->ViewCustomAttributes = "";

		// qty_de_01
		$this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
		$this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, 2, -2, -2, -2);
		$this->qty_de_01->ViewCustomAttributes = "";

		// de_02
		if ($this->de_02->VirtualValue <> "") {
			$this->de_02->ViewValue = $this->de_02->VirtualValue;
		} else {
		$curVal = strval($this->de_02->CurrentValue);
		if ($curVal <> "") {
			$this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
			if ($this->de_02->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (121) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->de_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->de_02->ViewValue = $this->de_02->CurrentValue;
				}
			}
		} else {
			$this->de_02->ViewValue = NULL;
		}
		}
		$this->de_02->ViewCustomAttributes = "";

		// qty_de_02
		$this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
		$this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, 2, -2, -2, -2);
		$this->qty_de_02->ViewCustomAttributes = "";

		// de_03
		if ($this->de_03->VirtualValue <> "") {
			$this->de_03->ViewValue = $this->de_03->VirtualValue;
		} else {
		$curVal = strval($this->de_03->CurrentValue);
		if ($curVal <> "") {
			$this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
			if ($this->de_03->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`s_grp` IN (121) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->de_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->de_03->ViewValue = $this->de_03->CurrentValue;
				}
			}
		} else {
			$this->de_03->ViewValue = NULL;
		}
		}
		$this->de_03->ViewCustomAttributes = "";

		// qty_de_03
		$this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
		$this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, 2, -2, -2, -2);
		$this->qty_de_03->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// job_type
		$this->job_type->LinkCustomAttributes = "";
		$this->job_type->HrefValue = "";
		$this->job_type->TooltipValue = "";

		// job_category
		$this->job_category->LinkCustomAttributes = "";
		$this->job_category->HrefValue = "";
		$this->job_category->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// description
		$this->description->LinkCustomAttributes = "";
		$this->description->HrefValue = "";
		$this->description->TooltipValue = "";

		// size
		$this->size->LinkCustomAttributes = "";
		$this->size->HrefValue = "";
		$this->size->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// pages
		$this->pages->LinkCustomAttributes = "";
		$this->pages->HrefValue = "";
		$this->pages->TooltipValue = "";

		// paper
		$this->paper->LinkCustomAttributes = "";
		$this->paper->HrefValue = "";
		$this->paper->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// pr_01
		$this->pr_01->LinkCustomAttributes = "";
		$this->pr_01->HrefValue = "";
		$this->pr_01->TooltipValue = "";

		// qty_pr_01
		$this->qty_pr_01->LinkCustomAttributes = "";
		$this->qty_pr_01->HrefValue = "";
		$this->qty_pr_01->TooltipValue = "";

		// pl_01
		$this->pl_01->LinkCustomAttributes = "";
		$this->pl_01->HrefValue = "";
		$this->pl_01->TooltipValue = "";

		// qty_pl_01
		$this->qty_pl_01->LinkCustomAttributes = "";
		$this->qty_pl_01->HrefValue = "";
		$this->qty_pl_01->TooltipValue = "";

		// pr_02
		$this->pr_02->LinkCustomAttributes = "";
		$this->pr_02->HrefValue = "";
		$this->pr_02->TooltipValue = "";

		// qty_pr_02
		$this->qty_pr_02->LinkCustomAttributes = "";
		$this->qty_pr_02->HrefValue = "";
		$this->qty_pr_02->TooltipValue = "";

		// pl_02
		$this->pl_02->LinkCustomAttributes = "";
		$this->pl_02->HrefValue = "";
		$this->pl_02->TooltipValue = "";

		// qty_pl_02
		$this->qty_pl_02->LinkCustomAttributes = "";
		$this->qty_pl_02->HrefValue = "";
		$this->qty_pl_02->TooltipValue = "";

		// pr_03
		$this->pr_03->LinkCustomAttributes = "";
		$this->pr_03->HrefValue = "";
		$this->pr_03->TooltipValue = "";

		// qty_pr_03
		$this->qty_pr_03->LinkCustomAttributes = "";
		$this->qty_pr_03->HrefValue = "";
		$this->qty_pr_03->TooltipValue = "";

		// pl_03
		$this->pl_03->LinkCustomAttributes = "";
		$this->pl_03->HrefValue = "";
		$this->pl_03->TooltipValue = "";

		// qty_pl_03
		$this->qty_pl_03->LinkCustomAttributes = "";
		$this->qty_pl_03->HrefValue = "";
		$this->qty_pl_03->TooltipValue = "";

		// pr_04
		$this->pr_04->LinkCustomAttributes = "";
		$this->pr_04->HrefValue = "";
		$this->pr_04->TooltipValue = "";

		// qty_pr_04
		$this->qty_pr_04->LinkCustomAttributes = "";
		$this->qty_pr_04->HrefValue = "";
		$this->qty_pr_04->TooltipValue = "";

		// pl_04
		$this->pl_04->LinkCustomAttributes = "";
		$this->pl_04->HrefValue = "";
		$this->pl_04->TooltipValue = "";

		// qty_pl_04
		$this->qty_pl_04->LinkCustomAttributes = "";
		$this->qty_pl_04->HrefValue = "";
		$this->qty_pl_04->TooltipValue = "";

		// pa_01
		$this->pa_01->LinkCustomAttributes = "";
		$this->pa_01->HrefValue = "";
		$this->pa_01->TooltipValue = "";

		// qty_pa_01
		$this->qty_pa_01->LinkCustomAttributes = "";
		$this->qty_pa_01->HrefValue = "";
		$this->qty_pa_01->TooltipValue = "";

		// pa_02
		$this->pa_02->LinkCustomAttributes = "";
		$this->pa_02->HrefValue = "";
		$this->pa_02->TooltipValue = "";

		// qty_pa_02
		$this->qty_pa_02->LinkCustomAttributes = "";
		$this->qty_pa_02->HrefValue = "";
		$this->qty_pa_02->TooltipValue = "";

		// pa_03
		$this->pa_03->LinkCustomAttributes = "";
		$this->pa_03->HrefValue = "";
		$this->pa_03->TooltipValue = "";

		// qty_pa_03
		$this->qty_pa_03->LinkCustomAttributes = "";
		$this->qty_pa_03->HrefValue = "";
		$this->qty_pa_03->TooltipValue = "";

		// pa_04
		$this->pa_04->LinkCustomAttributes = "";
		$this->pa_04->HrefValue = "";
		$this->pa_04->TooltipValue = "";

		// qty_pa_04
		$this->qty_pa_04->LinkCustomAttributes = "";
		$this->qty_pa_04->HrefValue = "";
		$this->qty_pa_04->TooltipValue = "";

		// pa_05
		$this->pa_05->LinkCustomAttributes = "";
		$this->pa_05->HrefValue = "";
		$this->pa_05->TooltipValue = "";

		// qty_pa_05
		$this->qty_pa_05->LinkCustomAttributes = "";
		$this->qty_pa_05->HrefValue = "";
		$this->qty_pa_05->TooltipValue = "";

		// pc_01
		$this->pc_01->LinkCustomAttributes = "";
		$this->pc_01->HrefValue = "";
		$this->pc_01->TooltipValue = "";

		// qty_pc_01
		$this->qty_pc_01->LinkCustomAttributes = "";
		$this->qty_pc_01->HrefValue = "";
		$this->qty_pc_01->TooltipValue = "";

		// pc_02
		$this->pc_02->LinkCustomAttributes = "";
		$this->pc_02->HrefValue = "";
		$this->pc_02->TooltipValue = "";

		// qty_pc_02
		$this->qty_pc_02->LinkCustomAttributes = "";
		$this->qty_pc_02->HrefValue = "";
		$this->qty_pc_02->TooltipValue = "";

		// o_01
		$this->o_01->LinkCustomAttributes = "";
		$this->o_01->HrefValue = "";
		$this->o_01->TooltipValue = "";

		// qty_o_01
		$this->qty_o_01->LinkCustomAttributes = "";
		$this->qty_o_01->HrefValue = "";
		$this->qty_o_01->TooltipValue = "";

		// lamination_type
		$this->lamination_type->LinkCustomAttributes = "";
		$this->lamination_type->HrefValue = "";
		$this->lamination_type->TooltipValue = "";

		// lamination_qty
		$this->lamination_qty->LinkCustomAttributes = "";
		$this->lamination_qty->HrefValue = "";
		$this->lamination_qty->TooltipValue = "";

		// die_type
		$this->die_type->LinkCustomAttributes = "";
		$this->die_type->HrefValue = "";
		$this->die_type->TooltipValue = "";

		// die_qty
		$this->die_qty->LinkCustomAttributes = "";
		$this->die_qty->HrefValue = "";
		$this->die_qty->TooltipValue = "";

		// binding_type
		$this->binding_type->LinkCustomAttributes = "";
		$this->binding_type->HrefValue = "";
		$this->binding_type->TooltipValue = "";

		// binding_qty
		$this->binding_qty->LinkCustomAttributes = "";
		$this->binding_qty->HrefValue = "";
		$this->binding_qty->TooltipValue = "";

		// number_type
		$this->number_type->LinkCustomAttributes = "";
		$this->number_type->HrefValue = "";
		$this->number_type->TooltipValue = "";

		// number_qty
		$this->number_qty->LinkCustomAttributes = "";
		$this->number_qty->HrefValue = "";
		$this->number_qty->TooltipValue = "";

		// de_01
		$this->de_01->LinkCustomAttributes = "";
		$this->de_01->HrefValue = "";
		$this->de_01->TooltipValue = "";

		// qty_de_01
		$this->qty_de_01->LinkCustomAttributes = "";
		$this->qty_de_01->HrefValue = "";
		$this->qty_de_01->TooltipValue = "";

		// de_02
		$this->de_02->LinkCustomAttributes = "";
		$this->de_02->HrefValue = "";
		$this->de_02->TooltipValue = "";

		// qty_de_02
		$this->qty_de_02->LinkCustomAttributes = "";
		$this->qty_de_02->HrefValue = "";
		$this->qty_de_02->TooltipValue = "";

		// de_03
		$this->de_03->LinkCustomAttributes = "";
		$this->de_03->HrefValue = "";
		$this->de_03->TooltipValue = "";

		// qty_de_03
		$this->qty_de_03->LinkCustomAttributes = "";
		$this->qty_de_03->HrefValue = "";
		$this->qty_de_03->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// job_type
		$this->job_type->EditCustomAttributes = "";
		$this->job_type->EditValue = $this->job_type->options(FALSE);

		// job_category
		$this->job_category->EditCustomAttributes = "";
		$this->job_category->EditValue = $this->job_category->options(FALSE);

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// description
		$this->description->EditAttrs["class"] = "form-control";
		$this->description->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
		$this->description->EditValue = $this->description->CurrentValue;
		$this->description->PlaceHolder = RemoveHtml($this->description->caption());

		// size
		$this->size->EditAttrs["class"] = "form-control";
		$this->size->EditCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// pages
		$this->pages->EditAttrs["class"] = "form-control";
		$this->pages->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pages->CurrentValue = HtmlDecode($this->pages->CurrentValue);
		$this->pages->EditValue = $this->pages->CurrentValue;
		$this->pages->PlaceHolder = RemoveHtml($this->pages->caption());

		// paper
		$this->paper->EditAttrs["class"] = "form-control";
		$this->paper->EditCustomAttributes = "";
		$this->paper->EditValue = $this->paper->CurrentValue;
		$this->paper->PlaceHolder = RemoveHtml($this->paper->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// pr_01
		$this->pr_01->EditAttrs["class"] = "form-control";
		$this->pr_01->EditCustomAttributes = "";

		// qty_pr_01
		$this->qty_pr_01->EditAttrs["class"] = "form-control";
		$this->qty_pr_01->EditCustomAttributes = "";
		$this->qty_pr_01->EditValue = $this->qty_pr_01->CurrentValue;
		$this->qty_pr_01->PlaceHolder = RemoveHtml($this->qty_pr_01->caption());
		if (strval($this->qty_pr_01->EditValue) <> "" && is_numeric($this->qty_pr_01->EditValue))
			$this->qty_pr_01->EditValue = FormatNumber($this->qty_pr_01->EditValue, -2, -2, -2, -2);

		// pl_01
		$this->pl_01->EditAttrs["class"] = "form-control";
		$this->pl_01->EditCustomAttributes = "";

		// qty_pl_01
		$this->qty_pl_01->EditAttrs["class"] = "form-control";
		$this->qty_pl_01->EditCustomAttributes = "";
		$this->qty_pl_01->EditValue = $this->qty_pl_01->CurrentValue;
		$this->qty_pl_01->PlaceHolder = RemoveHtml($this->qty_pl_01->caption());
		if (strval($this->qty_pl_01->EditValue) <> "" && is_numeric($this->qty_pl_01->EditValue))
			$this->qty_pl_01->EditValue = FormatNumber($this->qty_pl_01->EditValue, -2, -2, -2, -2);

		// pr_02
		$this->pr_02->EditAttrs["class"] = "form-control";
		$this->pr_02->EditCustomAttributes = "";

		// qty_pr_02
		$this->qty_pr_02->EditAttrs["class"] = "form-control";
		$this->qty_pr_02->EditCustomAttributes = "";
		$this->qty_pr_02->EditValue = $this->qty_pr_02->CurrentValue;
		$this->qty_pr_02->PlaceHolder = RemoveHtml($this->qty_pr_02->caption());
		if (strval($this->qty_pr_02->EditValue) <> "" && is_numeric($this->qty_pr_02->EditValue))
			$this->qty_pr_02->EditValue = FormatNumber($this->qty_pr_02->EditValue, -2, -2, -2, -2);

		// pl_02
		$this->pl_02->EditAttrs["class"] = "form-control";
		$this->pl_02->EditCustomAttributes = "";

		// qty_pl_02
		$this->qty_pl_02->EditAttrs["class"] = "form-control";
		$this->qty_pl_02->EditCustomAttributes = "";
		$this->qty_pl_02->EditValue = $this->qty_pl_02->CurrentValue;
		$this->qty_pl_02->PlaceHolder = RemoveHtml($this->qty_pl_02->caption());
		if (strval($this->qty_pl_02->EditValue) <> "" && is_numeric($this->qty_pl_02->EditValue))
			$this->qty_pl_02->EditValue = FormatNumber($this->qty_pl_02->EditValue, -2, -2, -2, -2);

		// pr_03
		$this->pr_03->EditAttrs["class"] = "form-control";
		$this->pr_03->EditCustomAttributes = "";

		// qty_pr_03
		$this->qty_pr_03->EditAttrs["class"] = "form-control";
		$this->qty_pr_03->EditCustomAttributes = "";
		$this->qty_pr_03->EditValue = $this->qty_pr_03->CurrentValue;
		$this->qty_pr_03->PlaceHolder = RemoveHtml($this->qty_pr_03->caption());
		if (strval($this->qty_pr_03->EditValue) <> "" && is_numeric($this->qty_pr_03->EditValue))
			$this->qty_pr_03->EditValue = FormatNumber($this->qty_pr_03->EditValue, -2, -2, -2, -2);

		// pl_03
		$this->pl_03->EditAttrs["class"] = "form-control";
		$this->pl_03->EditCustomAttributes = "";

		// qty_pl_03
		$this->qty_pl_03->EditAttrs["class"] = "form-control";
		$this->qty_pl_03->EditCustomAttributes = "";
		$this->qty_pl_03->EditValue = $this->qty_pl_03->CurrentValue;
		$this->qty_pl_03->PlaceHolder = RemoveHtml($this->qty_pl_03->caption());
		if (strval($this->qty_pl_03->EditValue) <> "" && is_numeric($this->qty_pl_03->EditValue))
			$this->qty_pl_03->EditValue = FormatNumber($this->qty_pl_03->EditValue, -2, -2, -2, -2);

		// pr_04
		$this->pr_04->EditAttrs["class"] = "form-control";
		$this->pr_04->EditCustomAttributes = "";

		// qty_pr_04
		$this->qty_pr_04->EditAttrs["class"] = "form-control";
		$this->qty_pr_04->EditCustomAttributes = "";
		$this->qty_pr_04->EditValue = $this->qty_pr_04->CurrentValue;
		$this->qty_pr_04->PlaceHolder = RemoveHtml($this->qty_pr_04->caption());
		if (strval($this->qty_pr_04->EditValue) <> "" && is_numeric($this->qty_pr_04->EditValue))
			$this->qty_pr_04->EditValue = FormatNumber($this->qty_pr_04->EditValue, -2, -2, -2, -2);

		// pl_04
		$this->pl_04->EditAttrs["class"] = "form-control";
		$this->pl_04->EditCustomAttributes = "";

		// qty_pl_04
		$this->qty_pl_04->EditAttrs["class"] = "form-control";
		$this->qty_pl_04->EditCustomAttributes = "";
		$this->qty_pl_04->EditValue = $this->qty_pl_04->CurrentValue;
		$this->qty_pl_04->PlaceHolder = RemoveHtml($this->qty_pl_04->caption());
		if (strval($this->qty_pl_04->EditValue) <> "" && is_numeric($this->qty_pl_04->EditValue))
			$this->qty_pl_04->EditValue = FormatNumber($this->qty_pl_04->EditValue, -2, -2, -2, -2);

		// pa_01
		$this->pa_01->EditAttrs["class"] = "form-control";
		$this->pa_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pa_01->CurrentValue = HtmlDecode($this->pa_01->CurrentValue);
		$this->pa_01->EditValue = $this->pa_01->CurrentValue;
		$this->pa_01->PlaceHolder = RemoveHtml($this->pa_01->caption());

		// qty_pa_01
		$this->qty_pa_01->EditAttrs["class"] = "form-control";
		$this->qty_pa_01->EditCustomAttributes = "";
		$this->qty_pa_01->EditValue = $this->qty_pa_01->CurrentValue;
		$this->qty_pa_01->PlaceHolder = RemoveHtml($this->qty_pa_01->caption());
		if (strval($this->qty_pa_01->EditValue) <> "" && is_numeric($this->qty_pa_01->EditValue))
			$this->qty_pa_01->EditValue = FormatNumber($this->qty_pa_01->EditValue, -2, -2, -2, -2);

		// pa_02
		$this->pa_02->EditAttrs["class"] = "form-control";
		$this->pa_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pa_02->CurrentValue = HtmlDecode($this->pa_02->CurrentValue);
		$this->pa_02->EditValue = $this->pa_02->CurrentValue;
		$this->pa_02->PlaceHolder = RemoveHtml($this->pa_02->caption());

		// qty_pa_02
		$this->qty_pa_02->EditAttrs["class"] = "form-control";
		$this->qty_pa_02->EditCustomAttributes = "";
		$this->qty_pa_02->EditValue = $this->qty_pa_02->CurrentValue;
		$this->qty_pa_02->PlaceHolder = RemoveHtml($this->qty_pa_02->caption());
		if (strval($this->qty_pa_02->EditValue) <> "" && is_numeric($this->qty_pa_02->EditValue))
			$this->qty_pa_02->EditValue = FormatNumber($this->qty_pa_02->EditValue, -2, -2, -2, -2);

		// pa_03
		$this->pa_03->EditAttrs["class"] = "form-control";
		$this->pa_03->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pa_03->CurrentValue = HtmlDecode($this->pa_03->CurrentValue);
		$this->pa_03->EditValue = $this->pa_03->CurrentValue;
		$this->pa_03->PlaceHolder = RemoveHtml($this->pa_03->caption());

		// qty_pa_03
		$this->qty_pa_03->EditAttrs["class"] = "form-control";
		$this->qty_pa_03->EditCustomAttributes = "";
		$this->qty_pa_03->EditValue = $this->qty_pa_03->CurrentValue;
		$this->qty_pa_03->PlaceHolder = RemoveHtml($this->qty_pa_03->caption());
		if (strval($this->qty_pa_03->EditValue) <> "" && is_numeric($this->qty_pa_03->EditValue))
			$this->qty_pa_03->EditValue = FormatNumber($this->qty_pa_03->EditValue, -2, -2, -2, -2);

		// pa_04
		$this->pa_04->EditAttrs["class"] = "form-control";
		$this->pa_04->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pa_04->CurrentValue = HtmlDecode($this->pa_04->CurrentValue);
		$this->pa_04->EditValue = $this->pa_04->CurrentValue;
		$this->pa_04->PlaceHolder = RemoveHtml($this->pa_04->caption());

		// qty_pa_04
		$this->qty_pa_04->EditAttrs["class"] = "form-control";
		$this->qty_pa_04->EditCustomAttributes = "";
		$this->qty_pa_04->EditValue = $this->qty_pa_04->CurrentValue;
		$this->qty_pa_04->PlaceHolder = RemoveHtml($this->qty_pa_04->caption());
		if (strval($this->qty_pa_04->EditValue) <> "" && is_numeric($this->qty_pa_04->EditValue))
			$this->qty_pa_04->EditValue = FormatNumber($this->qty_pa_04->EditValue, -2, -2, -2, -2);

		// pa_05
		$this->pa_05->EditAttrs["class"] = "form-control";
		$this->pa_05->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pa_05->CurrentValue = HtmlDecode($this->pa_05->CurrentValue);
		$this->pa_05->EditValue = $this->pa_05->CurrentValue;
		$this->pa_05->PlaceHolder = RemoveHtml($this->pa_05->caption());

		// qty_pa_05
		$this->qty_pa_05->EditAttrs["class"] = "form-control";
		$this->qty_pa_05->EditCustomAttributes = "";
		$this->qty_pa_05->EditValue = $this->qty_pa_05->CurrentValue;
		$this->qty_pa_05->PlaceHolder = RemoveHtml($this->qty_pa_05->caption());
		if (strval($this->qty_pa_05->EditValue) <> "" && is_numeric($this->qty_pa_05->EditValue))
			$this->qty_pa_05->EditValue = FormatNumber($this->qty_pa_05->EditValue, -2, -2, -2, -2);

		// pc_01
		$this->pc_01->EditAttrs["class"] = "form-control";
		$this->pc_01->EditCustomAttributes = "";

		// qty_pc_01
		$this->qty_pc_01->EditAttrs["class"] = "form-control";
		$this->qty_pc_01->EditCustomAttributes = "";
		$this->qty_pc_01->EditValue = $this->qty_pc_01->CurrentValue;
		$this->qty_pc_01->PlaceHolder = RemoveHtml($this->qty_pc_01->caption());
		if (strval($this->qty_pc_01->EditValue) <> "" && is_numeric($this->qty_pc_01->EditValue))
			$this->qty_pc_01->EditValue = FormatNumber($this->qty_pc_01->EditValue, -2, -2, -2, -2);

		// pc_02
		$this->pc_02->EditAttrs["class"] = "form-control";
		$this->pc_02->EditCustomAttributes = "";

		// qty_pc_02
		$this->qty_pc_02->EditAttrs["class"] = "form-control";
		$this->qty_pc_02->EditCustomAttributes = "";
		$this->qty_pc_02->EditValue = $this->qty_pc_02->CurrentValue;
		$this->qty_pc_02->PlaceHolder = RemoveHtml($this->qty_pc_02->caption());
		if (strval($this->qty_pc_02->EditValue) <> "" && is_numeric($this->qty_pc_02->EditValue))
			$this->qty_pc_02->EditValue = FormatNumber($this->qty_pc_02->EditValue, -2, -2, -2, -2);

		// o_01
		$this->o_01->EditAttrs["class"] = "form-control";
		$this->o_01->EditCustomAttributes = "";

		// qty_o_01
		$this->qty_o_01->EditAttrs["class"] = "form-control";
		$this->qty_o_01->EditCustomAttributes = "";
		$this->qty_o_01->EditValue = $this->qty_o_01->CurrentValue;
		$this->qty_o_01->PlaceHolder = RemoveHtml($this->qty_o_01->caption());
		if (strval($this->qty_o_01->EditValue) <> "" && is_numeric($this->qty_o_01->EditValue))
			$this->qty_o_01->EditValue = FormatNumber($this->qty_o_01->EditValue, -2, -2, -2, -2);

		// lamination_type
		$this->lamination_type->EditAttrs["class"] = "form-control";
		$this->lamination_type->EditCustomAttributes = "";

		// lamination_qty
		$this->lamination_qty->EditAttrs["class"] = "form-control";
		$this->lamination_qty->EditCustomAttributes = "";
		$this->lamination_qty->EditValue = $this->lamination_qty->CurrentValue;
		$this->lamination_qty->PlaceHolder = RemoveHtml($this->lamination_qty->caption());

		// die_type
		$this->die_type->EditAttrs["class"] = "form-control";
		$this->die_type->EditCustomAttributes = "";

		// die_qty
		$this->die_qty->EditAttrs["class"] = "form-control";
		$this->die_qty->EditCustomAttributes = "";
		$this->die_qty->EditValue = $this->die_qty->CurrentValue;
		$this->die_qty->PlaceHolder = RemoveHtml($this->die_qty->caption());

		// binding_type
		$this->binding_type->EditAttrs["class"] = "form-control";
		$this->binding_type->EditCustomAttributes = "";

		// binding_qty
		$this->binding_qty->EditAttrs["class"] = "form-control";
		$this->binding_qty->EditCustomAttributes = "";
		$this->binding_qty->EditValue = $this->binding_qty->CurrentValue;
		$this->binding_qty->PlaceHolder = RemoveHtml($this->binding_qty->caption());
		if (strval($this->binding_qty->EditValue) <> "" && is_numeric($this->binding_qty->EditValue))
			$this->binding_qty->EditValue = FormatNumber($this->binding_qty->EditValue, -2, -2, -2, -2);

		// number_type
		$this->number_type->EditAttrs["class"] = "form-control";
		$this->number_type->EditCustomAttributes = "";

		// number_qty
		$this->number_qty->EditAttrs["class"] = "form-control";
		$this->number_qty->EditCustomAttributes = "";
		$this->number_qty->EditValue = $this->number_qty->CurrentValue;
		$this->number_qty->PlaceHolder = RemoveHtml($this->number_qty->caption());

		// de_01
		$this->de_01->EditAttrs["class"] = "form-control";
		$this->de_01->EditCustomAttributes = "";

		// qty_de_01
		$this->qty_de_01->EditAttrs["class"] = "form-control";
		$this->qty_de_01->EditCustomAttributes = "";
		$this->qty_de_01->EditValue = $this->qty_de_01->CurrentValue;
		$this->qty_de_01->PlaceHolder = RemoveHtml($this->qty_de_01->caption());
		if (strval($this->qty_de_01->EditValue) <> "" && is_numeric($this->qty_de_01->EditValue))
			$this->qty_de_01->EditValue = FormatNumber($this->qty_de_01->EditValue, -2, -2, -2, -2);

		// de_02
		$this->de_02->EditAttrs["class"] = "form-control";
		$this->de_02->EditCustomAttributes = "";

		// qty_de_02
		$this->qty_de_02->EditAttrs["class"] = "form-control";
		$this->qty_de_02->EditCustomAttributes = "";
		$this->qty_de_02->EditValue = $this->qty_de_02->CurrentValue;
		$this->qty_de_02->PlaceHolder = RemoveHtml($this->qty_de_02->caption());
		if (strval($this->qty_de_02->EditValue) <> "" && is_numeric($this->qty_de_02->EditValue))
			$this->qty_de_02->EditValue = FormatNumber($this->qty_de_02->EditValue, -2, -2, -2, -2);

		// de_03
		$this->de_03->EditAttrs["class"] = "form-control";
		$this->de_03->EditCustomAttributes = "";

		// qty_de_03
		$this->qty_de_03->EditAttrs["class"] = "form-control";
		$this->qty_de_03->EditCustomAttributes = "";
		$this->qty_de_03->EditValue = $this->qty_de_03->CurrentValue;
		$this->qty_de_03->PlaceHolder = RemoveHtml($this->qty_de_03->caption());
		if (strval($this->qty_de_03->EditValue) <> "" && is_numeric($this->qty_de_03->EditValue))
			$this->qty_de_03->EditValue = FormatNumber($this->qty_de_03->EditValue, -2, -2, -2, -2);

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->job_type);
					$doc->exportCaption($this->job_category);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->description);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->pages);
					$doc->exportCaption($this->paper);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->pr_01);
					$doc->exportCaption($this->qty_pr_01);
					$doc->exportCaption($this->pl_01);
					$doc->exportCaption($this->qty_pl_01);
					$doc->exportCaption($this->pr_02);
					$doc->exportCaption($this->qty_pr_02);
					$doc->exportCaption($this->pl_02);
					$doc->exportCaption($this->qty_pl_02);
					$doc->exportCaption($this->pr_03);
					$doc->exportCaption($this->qty_pr_03);
					$doc->exportCaption($this->pl_03);
					$doc->exportCaption($this->qty_pl_03);
					$doc->exportCaption($this->pr_04);
					$doc->exportCaption($this->qty_pr_04);
					$doc->exportCaption($this->pl_04);
					$doc->exportCaption($this->qty_pl_04);
					$doc->exportCaption($this->pa_01);
					$doc->exportCaption($this->qty_pa_01);
					$doc->exportCaption($this->pa_02);
					$doc->exportCaption($this->qty_pa_02);
					$doc->exportCaption($this->pa_03);
					$doc->exportCaption($this->qty_pa_03);
					$doc->exportCaption($this->pa_04);
					$doc->exportCaption($this->qty_pa_04);
					$doc->exportCaption($this->pa_05);
					$doc->exportCaption($this->qty_pa_05);
					$doc->exportCaption($this->pc_01);
					$doc->exportCaption($this->qty_pc_01);
					$doc->exportCaption($this->pc_02);
					$doc->exportCaption($this->qty_pc_02);
					$doc->exportCaption($this->o_01);
					$doc->exportCaption($this->qty_o_01);
					$doc->exportCaption($this->lamination_type);
					$doc->exportCaption($this->lamination_qty);
					$doc->exportCaption($this->die_type);
					$doc->exportCaption($this->die_qty);
					$doc->exportCaption($this->binding_type);
					$doc->exportCaption($this->binding_qty);
					$doc->exportCaption($this->number_type);
					$doc->exportCaption($this->number_qty);
					$doc->exportCaption($this->de_01);
					$doc->exportCaption($this->qty_de_01);
					$doc->exportCaption($this->de_02);
					$doc->exportCaption($this->qty_de_02);
					$doc->exportCaption($this->de_03);
					$doc->exportCaption($this->qty_de_03);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->job_type);
					$doc->exportCaption($this->job_category);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->description);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->pages);
					$doc->exportCaption($this->paper);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->pr_01);
					$doc->exportCaption($this->qty_pr_01);
					$doc->exportCaption($this->pl_01);
					$doc->exportCaption($this->qty_pl_01);
					$doc->exportCaption($this->pr_02);
					$doc->exportCaption($this->qty_pr_02);
					$doc->exportCaption($this->pl_02);
					$doc->exportCaption($this->qty_pl_02);
					$doc->exportCaption($this->pr_03);
					$doc->exportCaption($this->qty_pr_03);
					$doc->exportCaption($this->pl_03);
					$doc->exportCaption($this->qty_pl_03);
					$doc->exportCaption($this->pr_04);
					$doc->exportCaption($this->qty_pr_04);
					$doc->exportCaption($this->pl_04);
					$doc->exportCaption($this->qty_pl_04);
					$doc->exportCaption($this->pa_01);
					$doc->exportCaption($this->qty_pa_01);
					$doc->exportCaption($this->pa_02);
					$doc->exportCaption($this->qty_pa_02);
					$doc->exportCaption($this->pa_03);
					$doc->exportCaption($this->qty_pa_03);
					$doc->exportCaption($this->pa_04);
					$doc->exportCaption($this->qty_pa_04);
					$doc->exportCaption($this->pa_05);
					$doc->exportCaption($this->qty_pa_05);
					$doc->exportCaption($this->pc_01);
					$doc->exportCaption($this->qty_pc_01);
					$doc->exportCaption($this->pc_02);
					$doc->exportCaption($this->qty_pc_02);
					$doc->exportCaption($this->o_01);
					$doc->exportCaption($this->qty_o_01);
					$doc->exportCaption($this->lamination_type);
					$doc->exportCaption($this->lamination_qty);
					$doc->exportCaption($this->die_type);
					$doc->exportCaption($this->die_qty);
					$doc->exportCaption($this->binding_type);
					$doc->exportCaption($this->binding_qty);
					$doc->exportCaption($this->number_type);
					$doc->exportCaption($this->number_qty);
					$doc->exportCaption($this->de_01);
					$doc->exportCaption($this->qty_de_01);
					$doc->exportCaption($this->de_02);
					$doc->exportCaption($this->qty_de_02);
					$doc->exportCaption($this->de_03);
					$doc->exportCaption($this->qty_de_03);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->job_type);
						$doc->exportField($this->job_category);
						$doc->exportField($this->company_id);
						$doc->exportField($this->description);
						$doc->exportField($this->size);
						$doc->exportField($this->quantity);
						$doc->exportField($this->pages);
						$doc->exportField($this->paper);
						$doc->exportField($this->remarks);
						$doc->exportField($this->pr_01);
						$doc->exportField($this->qty_pr_01);
						$doc->exportField($this->pl_01);
						$doc->exportField($this->qty_pl_01);
						$doc->exportField($this->pr_02);
						$doc->exportField($this->qty_pr_02);
						$doc->exportField($this->pl_02);
						$doc->exportField($this->qty_pl_02);
						$doc->exportField($this->pr_03);
						$doc->exportField($this->qty_pr_03);
						$doc->exportField($this->pl_03);
						$doc->exportField($this->qty_pl_03);
						$doc->exportField($this->pr_04);
						$doc->exportField($this->qty_pr_04);
						$doc->exportField($this->pl_04);
						$doc->exportField($this->qty_pl_04);
						$doc->exportField($this->pa_01);
						$doc->exportField($this->qty_pa_01);
						$doc->exportField($this->pa_02);
						$doc->exportField($this->qty_pa_02);
						$doc->exportField($this->pa_03);
						$doc->exportField($this->qty_pa_03);
						$doc->exportField($this->pa_04);
						$doc->exportField($this->qty_pa_04);
						$doc->exportField($this->pa_05);
						$doc->exportField($this->qty_pa_05);
						$doc->exportField($this->pc_01);
						$doc->exportField($this->qty_pc_01);
						$doc->exportField($this->pc_02);
						$doc->exportField($this->qty_pc_02);
						$doc->exportField($this->o_01);
						$doc->exportField($this->qty_o_01);
						$doc->exportField($this->lamination_type);
						$doc->exportField($this->lamination_qty);
						$doc->exportField($this->die_type);
						$doc->exportField($this->die_qty);
						$doc->exportField($this->binding_type);
						$doc->exportField($this->binding_qty);
						$doc->exportField($this->number_type);
						$doc->exportField($this->number_qty);
						$doc->exportField($this->de_01);
						$doc->exportField($this->qty_de_01);
						$doc->exportField($this->de_02);
						$doc->exportField($this->qty_de_02);
						$doc->exportField($this->de_03);
						$doc->exportField($this->qty_de_03);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->job_type);
						$doc->exportField($this->job_category);
						$doc->exportField($this->company_id);
						$doc->exportField($this->description);
						$doc->exportField($this->size);
						$doc->exportField($this->quantity);
						$doc->exportField($this->pages);
						$doc->exportField($this->paper);
						$doc->exportField($this->remarks);
						$doc->exportField($this->pr_01);
						$doc->exportField($this->qty_pr_01);
						$doc->exportField($this->pl_01);
						$doc->exportField($this->qty_pl_01);
						$doc->exportField($this->pr_02);
						$doc->exportField($this->qty_pr_02);
						$doc->exportField($this->pl_02);
						$doc->exportField($this->qty_pl_02);
						$doc->exportField($this->pr_03);
						$doc->exportField($this->qty_pr_03);
						$doc->exportField($this->pl_03);
						$doc->exportField($this->qty_pl_03);
						$doc->exportField($this->pr_04);
						$doc->exportField($this->qty_pr_04);
						$doc->exportField($this->pl_04);
						$doc->exportField($this->qty_pl_04);
						$doc->exportField($this->pa_01);
						$doc->exportField($this->qty_pa_01);
						$doc->exportField($this->pa_02);
						$doc->exportField($this->qty_pa_02);
						$doc->exportField($this->pa_03);
						$doc->exportField($this->qty_pa_03);
						$doc->exportField($this->pa_04);
						$doc->exportField($this->qty_pa_04);
						$doc->exportField($this->pa_05);
						$doc->exportField($this->qty_pa_05);
						$doc->exportField($this->pc_01);
						$doc->exportField($this->qty_pc_01);
						$doc->exportField($this->pc_02);
						$doc->exportField($this->qty_pc_02);
						$doc->exportField($this->o_01);
						$doc->exportField($this->qty_o_01);
						$doc->exportField($this->lamination_type);
						$doc->exportField($this->lamination_qty);
						$doc->exportField($this->die_type);
						$doc->exportField($this->die_qty);
						$doc->exportField($this->binding_type);
						$doc->exportField($this->binding_qty);
						$doc->exportField($this->number_type);
						$doc->exportField($this->number_qty);
						$doc->exportField($this->de_01);
						$doc->exportField($this->qty_de_01);
						$doc->exportField($this->de_02);
						$doc->exportField($this->qty_de_02);
						$doc->exportField($this->de_03);
						$doc->exportField($this->qty_de_03);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>