<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class p_eastimate_add extends p_eastimate
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'p_eastimate';

	// Page object name
	public $PageObjName = "p_eastimate_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (p_eastimate)
		if (!isset($GLOBALS["p_eastimate"]) || get_class($GLOBALS["p_eastimate"]) == PROJECT_NAMESPACE . "p_eastimate") {
			$GLOBALS["p_eastimate"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["p_eastimate"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_eastimate');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $p_eastimate;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($p_eastimate);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "p_eastimateview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("p_eastimatelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->job_type->setVisibility();
		$this->job_category->setVisibility();
		$this->company_id->setVisibility();
		$this->description->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->pages->setVisibility();
		$this->paper->setVisibility();
		$this->remarks->setVisibility();
		$this->pr_01->setVisibility();
		$this->qty_pr_01->setVisibility();
		$this->pl_01->setVisibility();
		$this->qty_pl_01->setVisibility();
		$this->pr_02->setVisibility();
		$this->qty_pr_02->setVisibility();
		$this->pl_02->setVisibility();
		$this->qty_pl_02->setVisibility();
		$this->pr_03->setVisibility();
		$this->qty_pr_03->setVisibility();
		$this->pl_03->setVisibility();
		$this->qty_pl_03->setVisibility();
		$this->pr_04->setVisibility();
		$this->qty_pr_04->setVisibility();
		$this->pl_04->setVisibility();
		$this->qty_pl_04->setVisibility();
		$this->pa_01->setVisibility();
		$this->qty_pa_01->setVisibility();
		$this->pa_02->setVisibility();
		$this->qty_pa_02->setVisibility();
		$this->pa_03->setVisibility();
		$this->qty_pa_03->setVisibility();
		$this->pa_04->setVisibility();
		$this->qty_pa_04->setVisibility();
		$this->pa_05->setVisibility();
		$this->qty_pa_05->setVisibility();
		$this->pc_01->setVisibility();
		$this->qty_pc_01->setVisibility();
		$this->pc_02->setVisibility();
		$this->qty_pc_02->setVisibility();
		$this->o_01->setVisibility();
		$this->qty_o_01->setVisibility();
		$this->lamination_type->setVisibility();
		$this->lamination_qty->setVisibility();
		$this->die_type->setVisibility();
		$this->die_qty->setVisibility();
		$this->binding_type->setVisibility();
		$this->binding_qty->setVisibility();
		$this->number_type->setVisibility();
		$this->number_qty->setVisibility();
		$this->de_01->setVisibility();
		$this->qty_de_01->setVisibility();
		$this->de_02->setVisibility();
		$this->qty_de_02->setVisibility();
		$this->de_03->setVisibility();
		$this->qty_de_03->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->size);
		$this->setupLookupOptions($this->pr_01);
		$this->setupLookupOptions($this->pl_01);
		$this->setupLookupOptions($this->pr_02);
		$this->setupLookupOptions($this->pl_02);
		$this->setupLookupOptions($this->pr_03);
		$this->setupLookupOptions($this->pl_03);
		$this->setupLookupOptions($this->pr_04);
		$this->setupLookupOptions($this->pl_04);
		$this->setupLookupOptions($this->pa_01);
		$this->setupLookupOptions($this->pa_02);
		$this->setupLookupOptions($this->pa_03);
		$this->setupLookupOptions($this->pa_04);
		$this->setupLookupOptions($this->pa_05);
		$this->setupLookupOptions($this->pc_01);
		$this->setupLookupOptions($this->pc_02);
		$this->setupLookupOptions($this->o_01);
		$this->setupLookupOptions($this->lamination_type);
		$this->setupLookupOptions($this->die_type);
		$this->setupLookupOptions($this->binding_type);
		$this->setupLookupOptions($this->number_type);
		$this->setupLookupOptions($this->de_01);
		$this->setupLookupOptions($this->de_02);
		$this->setupLookupOptions($this->de_03);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("p_eastimatelist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = 'p_polist.php';
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->job_type->CurrentValue = NULL;
		$this->job_type->OldValue = $this->job_type->CurrentValue;
		$this->job_category->CurrentValue = NULL;
		$this->job_category->OldValue = $this->job_category->CurrentValue;
		$this->company_id->CurrentValue = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID()));
		$this->description->CurrentValue = NULL;
		$this->description->OldValue = $this->description->CurrentValue;
		$this->size->CurrentValue = NULL;
		$this->size->OldValue = $this->size->CurrentValue;
		$this->quantity->CurrentValue = 0.00;
		$this->pages->CurrentValue = 0;
		$this->paper->CurrentValue = 1;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->pr_01->CurrentValue = NULL;
		$this->pr_01->OldValue = $this->pr_01->CurrentValue;
		$this->qty_pr_01->CurrentValue = 0.00;
		$this->pl_01->CurrentValue = NULL;
		$this->pl_01->OldValue = $this->pl_01->CurrentValue;
		$this->qty_pl_01->CurrentValue = 0.00;
		$this->pr_02->CurrentValue = NULL;
		$this->pr_02->OldValue = $this->pr_02->CurrentValue;
		$this->qty_pr_02->CurrentValue = 0.00;
		$this->pl_02->CurrentValue = NULL;
		$this->pl_02->OldValue = $this->pl_02->CurrentValue;
		$this->qty_pl_02->CurrentValue = 0.00;
		$this->pr_03->CurrentValue = NULL;
		$this->pr_03->OldValue = $this->pr_03->CurrentValue;
		$this->qty_pr_03->CurrentValue = 0.00;
		$this->pl_03->CurrentValue = NULL;
		$this->pl_03->OldValue = $this->pl_03->CurrentValue;
		$this->qty_pl_03->CurrentValue = 0.00;
		$this->pr_04->CurrentValue = NULL;
		$this->pr_04->OldValue = $this->pr_04->CurrentValue;
		$this->qty_pr_04->CurrentValue = 0.00;
		$this->pl_04->CurrentValue = NULL;
		$this->pl_04->OldValue = $this->pl_04->CurrentValue;
		$this->qty_pl_04->CurrentValue = 0.00;
		$this->pa_01->CurrentValue = NULL;
		$this->pa_01->OldValue = $this->pa_01->CurrentValue;
		$this->qty_pa_01->CurrentValue = 0.00;
		$this->pa_02->CurrentValue = NULL;
		$this->pa_02->OldValue = $this->pa_02->CurrentValue;
		$this->qty_pa_02->CurrentValue = 0.00;
		$this->pa_03->CurrentValue = NULL;
		$this->pa_03->OldValue = $this->pa_03->CurrentValue;
		$this->qty_pa_03->CurrentValue = 0.00;
		$this->pa_04->CurrentValue = NULL;
		$this->pa_04->OldValue = $this->pa_04->CurrentValue;
		$this->qty_pa_04->CurrentValue = 0.00;
		$this->pa_05->CurrentValue = NULL;
		$this->pa_05->OldValue = $this->pa_05->CurrentValue;
		$this->qty_pa_05->CurrentValue = 0.00;
		$this->pc_01->CurrentValue = NULL;
		$this->pc_01->OldValue = $this->pc_01->CurrentValue;
		$this->qty_pc_01->CurrentValue = 0.00;
		$this->pc_02->CurrentValue = NULL;
		$this->pc_02->OldValue = $this->pc_02->CurrentValue;
		$this->qty_pc_02->CurrentValue = 0.00;
		$this->o_01->CurrentValue = NULL;
		$this->o_01->OldValue = $this->o_01->CurrentValue;
		$this->qty_o_01->CurrentValue = 0.00;
		$this->lamination_type->CurrentValue = NULL;
		$this->lamination_type->OldValue = $this->lamination_type->CurrentValue;
		$this->lamination_qty->CurrentValue = 0.00;
		$this->die_type->CurrentValue = NULL;
		$this->die_type->OldValue = $this->die_type->CurrentValue;
		$this->die_qty->CurrentValue = 0.00;
		$this->binding_type->CurrentValue = NULL;
		$this->binding_type->OldValue = $this->binding_type->CurrentValue;
		$this->binding_qty->CurrentValue = 0.00;
		$this->number_type->CurrentValue = NULL;
		$this->number_type->OldValue = $this->number_type->CurrentValue;
		$this->number_qty->CurrentValue = 0.00;
		$this->de_01->CurrentValue = NULL;
		$this->de_01->OldValue = $this->de_01->CurrentValue;
		$this->qty_de_01->CurrentValue = 0.00;
		$this->de_02->CurrentValue = NULL;
		$this->de_02->OldValue = $this->de_02->CurrentValue;
		$this->qty_de_02->CurrentValue = 0.00;
		$this->de_03->CurrentValue = NULL;
		$this->de_03->OldValue = $this->de_03->CurrentValue;
		$this->qty_de_03->CurrentValue = 0.00;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'job_type' first before field var 'x_job_type'
		$val = $CurrentForm->hasValue("job_type") ? $CurrentForm->getValue("job_type") : $CurrentForm->getValue("x_job_type");
		if (!$this->job_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->job_type->Visible = FALSE; // Disable update for API request
			else
				$this->job_type->setFormValue($val);
		}

		// Check field name 'job_category' first before field var 'x_job_category'
		$val = $CurrentForm->hasValue("job_category") ? $CurrentForm->getValue("job_category") : $CurrentForm->getValue("x_job_category");
		if (!$this->job_category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->job_category->Visible = FALSE; // Disable update for API request
			else
				$this->job_category->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'description' first before field var 'x_description'
		$val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
		if (!$this->description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description->Visible = FALSE; // Disable update for API request
			else
				$this->description->setFormValue($val);
		}

		// Check field name 'size' first before field var 'x_size'
		$val = $CurrentForm->hasValue("size") ? $CurrentForm->getValue("size") : $CurrentForm->getValue("x_size");
		if (!$this->size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size->Visible = FALSE; // Disable update for API request
			else
				$this->size->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'pages' first before field var 'x_pages'
		$val = $CurrentForm->hasValue("pages") ? $CurrentForm->getValue("pages") : $CurrentForm->getValue("x_pages");
		if (!$this->pages->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pages->Visible = FALSE; // Disable update for API request
			else
				$this->pages->setFormValue($val);
		}

		// Check field name 'paper' first before field var 'x_paper'
		$val = $CurrentForm->hasValue("paper") ? $CurrentForm->getValue("paper") : $CurrentForm->getValue("x_paper");
		if (!$this->paper->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->paper->Visible = FALSE; // Disable update for API request
			else
				$this->paper->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'pr_01' first before field var 'x_pr_01'
		$val = $CurrentForm->hasValue("pr_01") ? $CurrentForm->getValue("pr_01") : $CurrentForm->getValue("x_pr_01");
		if (!$this->pr_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pr_01->Visible = FALSE; // Disable update for API request
			else
				$this->pr_01->setFormValue($val);
		}

		// Check field name 'qty_pr_01' first before field var 'x_qty_pr_01'
		$val = $CurrentForm->hasValue("qty_pr_01") ? $CurrentForm->getValue("qty_pr_01") : $CurrentForm->getValue("x_qty_pr_01");
		if (!$this->qty_pr_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pr_01->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pr_01->setFormValue($val);
		}

		// Check field name 'pl_01' first before field var 'x_pl_01'
		$val = $CurrentForm->hasValue("pl_01") ? $CurrentForm->getValue("pl_01") : $CurrentForm->getValue("x_pl_01");
		if (!$this->pl_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pl_01->Visible = FALSE; // Disable update for API request
			else
				$this->pl_01->setFormValue($val);
		}

		// Check field name 'qty_pl_01' first before field var 'x_qty_pl_01'
		$val = $CurrentForm->hasValue("qty_pl_01") ? $CurrentForm->getValue("qty_pl_01") : $CurrentForm->getValue("x_qty_pl_01");
		if (!$this->qty_pl_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pl_01->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pl_01->setFormValue($val);
		}

		// Check field name 'pr_02' first before field var 'x_pr_02'
		$val = $CurrentForm->hasValue("pr_02") ? $CurrentForm->getValue("pr_02") : $CurrentForm->getValue("x_pr_02");
		if (!$this->pr_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pr_02->Visible = FALSE; // Disable update for API request
			else
				$this->pr_02->setFormValue($val);
		}

		// Check field name 'qty_pr_02' first before field var 'x_qty_pr_02'
		$val = $CurrentForm->hasValue("qty_pr_02") ? $CurrentForm->getValue("qty_pr_02") : $CurrentForm->getValue("x_qty_pr_02");
		if (!$this->qty_pr_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pr_02->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pr_02->setFormValue($val);
		}

		// Check field name 'pl_02' first before field var 'x_pl_02'
		$val = $CurrentForm->hasValue("pl_02") ? $CurrentForm->getValue("pl_02") : $CurrentForm->getValue("x_pl_02");
		if (!$this->pl_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pl_02->Visible = FALSE; // Disable update for API request
			else
				$this->pl_02->setFormValue($val);
		}

		// Check field name 'qty_pl_02' first before field var 'x_qty_pl_02'
		$val = $CurrentForm->hasValue("qty_pl_02") ? $CurrentForm->getValue("qty_pl_02") : $CurrentForm->getValue("x_qty_pl_02");
		if (!$this->qty_pl_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pl_02->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pl_02->setFormValue($val);
		}

		// Check field name 'pr_03' first before field var 'x_pr_03'
		$val = $CurrentForm->hasValue("pr_03") ? $CurrentForm->getValue("pr_03") : $CurrentForm->getValue("x_pr_03");
		if (!$this->pr_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pr_03->Visible = FALSE; // Disable update for API request
			else
				$this->pr_03->setFormValue($val);
		}

		// Check field name 'qty_pr_03' first before field var 'x_qty_pr_03'
		$val = $CurrentForm->hasValue("qty_pr_03") ? $CurrentForm->getValue("qty_pr_03") : $CurrentForm->getValue("x_qty_pr_03");
		if (!$this->qty_pr_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pr_03->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pr_03->setFormValue($val);
		}

		// Check field name 'pl_03' first before field var 'x_pl_03'
		$val = $CurrentForm->hasValue("pl_03") ? $CurrentForm->getValue("pl_03") : $CurrentForm->getValue("x_pl_03");
		if (!$this->pl_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pl_03->Visible = FALSE; // Disable update for API request
			else
				$this->pl_03->setFormValue($val);
		}

		// Check field name 'qty_pl_03' first before field var 'x_qty_pl_03'
		$val = $CurrentForm->hasValue("qty_pl_03") ? $CurrentForm->getValue("qty_pl_03") : $CurrentForm->getValue("x_qty_pl_03");
		if (!$this->qty_pl_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pl_03->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pl_03->setFormValue($val);
		}

		// Check field name 'pr_04' first before field var 'x_pr_04'
		$val = $CurrentForm->hasValue("pr_04") ? $CurrentForm->getValue("pr_04") : $CurrentForm->getValue("x_pr_04");
		if (!$this->pr_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pr_04->Visible = FALSE; // Disable update for API request
			else
				$this->pr_04->setFormValue($val);
		}

		// Check field name 'qty_pr_04' first before field var 'x_qty_pr_04'
		$val = $CurrentForm->hasValue("qty_pr_04") ? $CurrentForm->getValue("qty_pr_04") : $CurrentForm->getValue("x_qty_pr_04");
		if (!$this->qty_pr_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pr_04->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pr_04->setFormValue($val);
		}

		// Check field name 'pl_04' first before field var 'x_pl_04'
		$val = $CurrentForm->hasValue("pl_04") ? $CurrentForm->getValue("pl_04") : $CurrentForm->getValue("x_pl_04");
		if (!$this->pl_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pl_04->Visible = FALSE; // Disable update for API request
			else
				$this->pl_04->setFormValue($val);
		}

		// Check field name 'qty_pl_04' first before field var 'x_qty_pl_04'
		$val = $CurrentForm->hasValue("qty_pl_04") ? $CurrentForm->getValue("qty_pl_04") : $CurrentForm->getValue("x_qty_pl_04");
		if (!$this->qty_pl_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pl_04->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pl_04->setFormValue($val);
		}

		// Check field name 'pa_01' first before field var 'x_pa_01'
		$val = $CurrentForm->hasValue("pa_01") ? $CurrentForm->getValue("pa_01") : $CurrentForm->getValue("x_pa_01");
		if (!$this->pa_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pa_01->Visible = FALSE; // Disable update for API request
			else
				$this->pa_01->setFormValue($val);
		}

		// Check field name 'qty_pa_01' first before field var 'x_qty_pa_01'
		$val = $CurrentForm->hasValue("qty_pa_01") ? $CurrentForm->getValue("qty_pa_01") : $CurrentForm->getValue("x_qty_pa_01");
		if (!$this->qty_pa_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pa_01->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pa_01->setFormValue($val);
		}

		// Check field name 'pa_02' first before field var 'x_pa_02'
		$val = $CurrentForm->hasValue("pa_02") ? $CurrentForm->getValue("pa_02") : $CurrentForm->getValue("x_pa_02");
		if (!$this->pa_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pa_02->Visible = FALSE; // Disable update for API request
			else
				$this->pa_02->setFormValue($val);
		}

		// Check field name 'qty_pa_02' first before field var 'x_qty_pa_02'
		$val = $CurrentForm->hasValue("qty_pa_02") ? $CurrentForm->getValue("qty_pa_02") : $CurrentForm->getValue("x_qty_pa_02");
		if (!$this->qty_pa_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pa_02->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pa_02->setFormValue($val);
		}

		// Check field name 'pa_03' first before field var 'x_pa_03'
		$val = $CurrentForm->hasValue("pa_03") ? $CurrentForm->getValue("pa_03") : $CurrentForm->getValue("x_pa_03");
		if (!$this->pa_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pa_03->Visible = FALSE; // Disable update for API request
			else
				$this->pa_03->setFormValue($val);
		}

		// Check field name 'qty_pa_03' first before field var 'x_qty_pa_03'
		$val = $CurrentForm->hasValue("qty_pa_03") ? $CurrentForm->getValue("qty_pa_03") : $CurrentForm->getValue("x_qty_pa_03");
		if (!$this->qty_pa_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pa_03->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pa_03->setFormValue($val);
		}

		// Check field name 'pa_04' first before field var 'x_pa_04'
		$val = $CurrentForm->hasValue("pa_04") ? $CurrentForm->getValue("pa_04") : $CurrentForm->getValue("x_pa_04");
		if (!$this->pa_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pa_04->Visible = FALSE; // Disable update for API request
			else
				$this->pa_04->setFormValue($val);
		}

		// Check field name 'qty_pa_04' first before field var 'x_qty_pa_04'
		$val = $CurrentForm->hasValue("qty_pa_04") ? $CurrentForm->getValue("qty_pa_04") : $CurrentForm->getValue("x_qty_pa_04");
		if (!$this->qty_pa_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pa_04->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pa_04->setFormValue($val);
		}

		// Check field name 'pa_05' first before field var 'x_pa_05'
		$val = $CurrentForm->hasValue("pa_05") ? $CurrentForm->getValue("pa_05") : $CurrentForm->getValue("x_pa_05");
		if (!$this->pa_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pa_05->Visible = FALSE; // Disable update for API request
			else
				$this->pa_05->setFormValue($val);
		}

		// Check field name 'qty_pa_05' first before field var 'x_qty_pa_05'
		$val = $CurrentForm->hasValue("qty_pa_05") ? $CurrentForm->getValue("qty_pa_05") : $CurrentForm->getValue("x_qty_pa_05");
		if (!$this->qty_pa_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pa_05->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pa_05->setFormValue($val);
		}

		// Check field name 'pc_01' first before field var 'x_pc_01'
		$val = $CurrentForm->hasValue("pc_01") ? $CurrentForm->getValue("pc_01") : $CurrentForm->getValue("x_pc_01");
		if (!$this->pc_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_01->Visible = FALSE; // Disable update for API request
			else
				$this->pc_01->setFormValue($val);
		}

		// Check field name 'qty_pc_01' first before field var 'x_qty_pc_01'
		$val = $CurrentForm->hasValue("qty_pc_01") ? $CurrentForm->getValue("qty_pc_01") : $CurrentForm->getValue("x_qty_pc_01");
		if (!$this->qty_pc_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pc_01->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pc_01->setFormValue($val);
		}

		// Check field name 'pc_02' first before field var 'x_pc_02'
		$val = $CurrentForm->hasValue("pc_02") ? $CurrentForm->getValue("pc_02") : $CurrentForm->getValue("x_pc_02");
		if (!$this->pc_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_02->Visible = FALSE; // Disable update for API request
			else
				$this->pc_02->setFormValue($val);
		}

		// Check field name 'qty_pc_02' first before field var 'x_qty_pc_02'
		$val = $CurrentForm->hasValue("qty_pc_02") ? $CurrentForm->getValue("qty_pc_02") : $CurrentForm->getValue("x_qty_pc_02");
		if (!$this->qty_pc_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_pc_02->Visible = FALSE; // Disable update for API request
			else
				$this->qty_pc_02->setFormValue($val);
		}

		// Check field name 'o_01' first before field var 'x_o_01'
		$val = $CurrentForm->hasValue("o_01") ? $CurrentForm->getValue("o_01") : $CurrentForm->getValue("x_o_01");
		if (!$this->o_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->o_01->Visible = FALSE; // Disable update for API request
			else
				$this->o_01->setFormValue($val);
		}

		// Check field name 'qty_o_01' first before field var 'x_qty_o_01'
		$val = $CurrentForm->hasValue("qty_o_01") ? $CurrentForm->getValue("qty_o_01") : $CurrentForm->getValue("x_qty_o_01");
		if (!$this->qty_o_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_o_01->Visible = FALSE; // Disable update for API request
			else
				$this->qty_o_01->setFormValue($val);
		}

		// Check field name 'lamination_type' first before field var 'x_lamination_type'
		$val = $CurrentForm->hasValue("lamination_type") ? $CurrentForm->getValue("lamination_type") : $CurrentForm->getValue("x_lamination_type");
		if (!$this->lamination_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lamination_type->Visible = FALSE; // Disable update for API request
			else
				$this->lamination_type->setFormValue($val);
		}

		// Check field name 'lamination_qty' first before field var 'x_lamination_qty'
		$val = $CurrentForm->hasValue("lamination_qty") ? $CurrentForm->getValue("lamination_qty") : $CurrentForm->getValue("x_lamination_qty");
		if (!$this->lamination_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lamination_qty->Visible = FALSE; // Disable update for API request
			else
				$this->lamination_qty->setFormValue($val);
		}

		// Check field name 'die_type' first before field var 'x_die_type'
		$val = $CurrentForm->hasValue("die_type") ? $CurrentForm->getValue("die_type") : $CurrentForm->getValue("x_die_type");
		if (!$this->die_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->die_type->Visible = FALSE; // Disable update for API request
			else
				$this->die_type->setFormValue($val);
		}

		// Check field name 'die_qty' first before field var 'x_die_qty'
		$val = $CurrentForm->hasValue("die_qty") ? $CurrentForm->getValue("die_qty") : $CurrentForm->getValue("x_die_qty");
		if (!$this->die_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->die_qty->Visible = FALSE; // Disable update for API request
			else
				$this->die_qty->setFormValue($val);
		}

		// Check field name 'binding_type' first before field var 'x_binding_type'
		$val = $CurrentForm->hasValue("binding_type") ? $CurrentForm->getValue("binding_type") : $CurrentForm->getValue("x_binding_type");
		if (!$this->binding_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->binding_type->Visible = FALSE; // Disable update for API request
			else
				$this->binding_type->setFormValue($val);
		}

		// Check field name 'binding_qty' first before field var 'x_binding_qty'
		$val = $CurrentForm->hasValue("binding_qty") ? $CurrentForm->getValue("binding_qty") : $CurrentForm->getValue("x_binding_qty");
		if (!$this->binding_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->binding_qty->Visible = FALSE; // Disable update for API request
			else
				$this->binding_qty->setFormValue($val);
		}

		// Check field name 'number_type' first before field var 'x_number_type'
		$val = $CurrentForm->hasValue("number_type") ? $CurrentForm->getValue("number_type") : $CurrentForm->getValue("x_number_type");
		if (!$this->number_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->number_type->Visible = FALSE; // Disable update for API request
			else
				$this->number_type->setFormValue($val);
		}

		// Check field name 'number_qty' first before field var 'x_number_qty'
		$val = $CurrentForm->hasValue("number_qty") ? $CurrentForm->getValue("number_qty") : $CurrentForm->getValue("x_number_qty");
		if (!$this->number_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->number_qty->Visible = FALSE; // Disable update for API request
			else
				$this->number_qty->setFormValue($val);
		}

		// Check field name 'de_01' first before field var 'x_de_01'
		$val = $CurrentForm->hasValue("de_01") ? $CurrentForm->getValue("de_01") : $CurrentForm->getValue("x_de_01");
		if (!$this->de_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->de_01->Visible = FALSE; // Disable update for API request
			else
				$this->de_01->setFormValue($val);
		}

		// Check field name 'qty_de_01' first before field var 'x_qty_de_01'
		$val = $CurrentForm->hasValue("qty_de_01") ? $CurrentForm->getValue("qty_de_01") : $CurrentForm->getValue("x_qty_de_01");
		if (!$this->qty_de_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_de_01->Visible = FALSE; // Disable update for API request
			else
				$this->qty_de_01->setFormValue($val);
		}

		// Check field name 'de_02' first before field var 'x_de_02'
		$val = $CurrentForm->hasValue("de_02") ? $CurrentForm->getValue("de_02") : $CurrentForm->getValue("x_de_02");
		if (!$this->de_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->de_02->Visible = FALSE; // Disable update for API request
			else
				$this->de_02->setFormValue($val);
		}

		// Check field name 'qty_de_02' first before field var 'x_qty_de_02'
		$val = $CurrentForm->hasValue("qty_de_02") ? $CurrentForm->getValue("qty_de_02") : $CurrentForm->getValue("x_qty_de_02");
		if (!$this->qty_de_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_de_02->Visible = FALSE; // Disable update for API request
			else
				$this->qty_de_02->setFormValue($val);
		}

		// Check field name 'de_03' first before field var 'x_de_03'
		$val = $CurrentForm->hasValue("de_03") ? $CurrentForm->getValue("de_03") : $CurrentForm->getValue("x_de_03");
		if (!$this->de_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->de_03->Visible = FALSE; // Disable update for API request
			else
				$this->de_03->setFormValue($val);
		}

		// Check field name 'qty_de_03' first before field var 'x_qty_de_03'
		$val = $CurrentForm->hasValue("qty_de_03") ? $CurrentForm->getValue("qty_de_03") : $CurrentForm->getValue("x_qty_de_03");
		if (!$this->qty_de_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty_de_03->Visible = FALSE; // Disable update for API request
			else
				$this->qty_de_03->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->job_type->CurrentValue = $this->job_type->FormValue;
		$this->job_category->CurrentValue = $this->job_category->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->description->CurrentValue = $this->description->FormValue;
		$this->size->CurrentValue = $this->size->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->pages->CurrentValue = $this->pages->FormValue;
		$this->paper->CurrentValue = $this->paper->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->pr_01->CurrentValue = $this->pr_01->FormValue;
		$this->qty_pr_01->CurrentValue = $this->qty_pr_01->FormValue;
		$this->pl_01->CurrentValue = $this->pl_01->FormValue;
		$this->qty_pl_01->CurrentValue = $this->qty_pl_01->FormValue;
		$this->pr_02->CurrentValue = $this->pr_02->FormValue;
		$this->qty_pr_02->CurrentValue = $this->qty_pr_02->FormValue;
		$this->pl_02->CurrentValue = $this->pl_02->FormValue;
		$this->qty_pl_02->CurrentValue = $this->qty_pl_02->FormValue;
		$this->pr_03->CurrentValue = $this->pr_03->FormValue;
		$this->qty_pr_03->CurrentValue = $this->qty_pr_03->FormValue;
		$this->pl_03->CurrentValue = $this->pl_03->FormValue;
		$this->qty_pl_03->CurrentValue = $this->qty_pl_03->FormValue;
		$this->pr_04->CurrentValue = $this->pr_04->FormValue;
		$this->qty_pr_04->CurrentValue = $this->qty_pr_04->FormValue;
		$this->pl_04->CurrentValue = $this->pl_04->FormValue;
		$this->qty_pl_04->CurrentValue = $this->qty_pl_04->FormValue;
		$this->pa_01->CurrentValue = $this->pa_01->FormValue;
		$this->qty_pa_01->CurrentValue = $this->qty_pa_01->FormValue;
		$this->pa_02->CurrentValue = $this->pa_02->FormValue;
		$this->qty_pa_02->CurrentValue = $this->qty_pa_02->FormValue;
		$this->pa_03->CurrentValue = $this->pa_03->FormValue;
		$this->qty_pa_03->CurrentValue = $this->qty_pa_03->FormValue;
		$this->pa_04->CurrentValue = $this->pa_04->FormValue;
		$this->qty_pa_04->CurrentValue = $this->qty_pa_04->FormValue;
		$this->pa_05->CurrentValue = $this->pa_05->FormValue;
		$this->qty_pa_05->CurrentValue = $this->qty_pa_05->FormValue;
		$this->pc_01->CurrentValue = $this->pc_01->FormValue;
		$this->qty_pc_01->CurrentValue = $this->qty_pc_01->FormValue;
		$this->pc_02->CurrentValue = $this->pc_02->FormValue;
		$this->qty_pc_02->CurrentValue = $this->qty_pc_02->FormValue;
		$this->o_01->CurrentValue = $this->o_01->FormValue;
		$this->qty_o_01->CurrentValue = $this->qty_o_01->FormValue;
		$this->lamination_type->CurrentValue = $this->lamination_type->FormValue;
		$this->lamination_qty->CurrentValue = $this->lamination_qty->FormValue;
		$this->die_type->CurrentValue = $this->die_type->FormValue;
		$this->die_qty->CurrentValue = $this->die_qty->FormValue;
		$this->binding_type->CurrentValue = $this->binding_type->FormValue;
		$this->binding_qty->CurrentValue = $this->binding_qty->FormValue;
		$this->number_type->CurrentValue = $this->number_type->FormValue;
		$this->number_qty->CurrentValue = $this->number_qty->FormValue;
		$this->de_01->CurrentValue = $this->de_01->FormValue;
		$this->qty_de_01->CurrentValue = $this->qty_de_01->FormValue;
		$this->de_02->CurrentValue = $this->de_02->FormValue;
		$this->qty_de_02->CurrentValue = $this->qty_de_02->FormValue;
		$this->de_03->CurrentValue = $this->de_03->FormValue;
		$this->qty_de_03->CurrentValue = $this->qty_de_03->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->job_type->setDbValue($row['job_type']);
		$this->job_category->setDbValue($row['job_category']);
		$this->company_id->setDbValue($row['company_id']);
		$this->description->setDbValue($row['description']);
		$this->size->setDbValue($row['size']);
		$this->quantity->setDbValue($row['quantity']);
		$this->pages->setDbValue($row['pages']);
		$this->paper->setDbValue($row['paper']);
		$this->remarks->setDbValue($row['remarks']);
		$this->pr_01->setDbValue($row['pr_01']);
		if (array_key_exists('EV__pr_01', $rs->fields)) {
			$this->pr_01->VirtualValue = $rs->fields('EV__pr_01'); // Set up virtual field value
		} else {
			$this->pr_01->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_01->setDbValue($row['qty_pr_01']);
		$this->pl_01->setDbValue($row['pl_01']);
		$this->qty_pl_01->setDbValue($row['qty_pl_01']);
		$this->pr_02->setDbValue($row['pr_02']);
		if (array_key_exists('EV__pr_02', $rs->fields)) {
			$this->pr_02->VirtualValue = $rs->fields('EV__pr_02'); // Set up virtual field value
		} else {
			$this->pr_02->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_02->setDbValue($row['qty_pr_02']);
		$this->pl_02->setDbValue($row['pl_02']);
		$this->qty_pl_02->setDbValue($row['qty_pl_02']);
		$this->pr_03->setDbValue($row['pr_03']);
		if (array_key_exists('EV__pr_03', $rs->fields)) {
			$this->pr_03->VirtualValue = $rs->fields('EV__pr_03'); // Set up virtual field value
		} else {
			$this->pr_03->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_03->setDbValue($row['qty_pr_03']);
		$this->pl_03->setDbValue($row['pl_03']);
		$this->qty_pl_03->setDbValue($row['qty_pl_03']);
		$this->pr_04->setDbValue($row['pr_04']);
		if (array_key_exists('EV__pr_04', $rs->fields)) {
			$this->pr_04->VirtualValue = $rs->fields('EV__pr_04'); // Set up virtual field value
		} else {
			$this->pr_04->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_04->setDbValue($row['qty_pr_04']);
		$this->pl_04->setDbValue($row['pl_04']);
		$this->qty_pl_04->setDbValue($row['qty_pl_04']);
		$this->pa_01->setDbValue($row['pa_01']);
		$this->qty_pa_01->setDbValue($row['qty_pa_01']);
		$this->pa_02->setDbValue($row['pa_02']);
		$this->qty_pa_02->setDbValue($row['qty_pa_02']);
		$this->pa_03->setDbValue($row['pa_03']);
		$this->qty_pa_03->setDbValue($row['qty_pa_03']);
		$this->pa_04->setDbValue($row['pa_04']);
		$this->qty_pa_04->setDbValue($row['qty_pa_04']);
		$this->pa_05->setDbValue($row['pa_05']);
		$this->qty_pa_05->setDbValue($row['qty_pa_05']);
		$this->pc_01->setDbValue($row['pc_01']);
		$this->qty_pc_01->setDbValue($row['qty_pc_01']);
		$this->pc_02->setDbValue($row['pc_02']);
		$this->qty_pc_02->setDbValue($row['qty_pc_02']);
		$this->o_01->setDbValue($row['o_01']);
		$this->qty_o_01->setDbValue($row['qty_o_01']);
		$this->lamination_type->setDbValue($row['lamination_type']);
		if (array_key_exists('EV__lamination_type', $rs->fields)) {
			$this->lamination_type->VirtualValue = $rs->fields('EV__lamination_type'); // Set up virtual field value
		} else {
			$this->lamination_type->VirtualValue = ""; // Clear value
		}
		$this->lamination_qty->setDbValue($row['lamination_qty']);
		$this->die_type->setDbValue($row['die_type']);
		if (array_key_exists('EV__die_type', $rs->fields)) {
			$this->die_type->VirtualValue = $rs->fields('EV__die_type'); // Set up virtual field value
		} else {
			$this->die_type->VirtualValue = ""; // Clear value
		}
		$this->die_qty->setDbValue($row['die_qty']);
		$this->binding_type->setDbValue($row['binding_type']);
		$this->binding_qty->setDbValue($row['binding_qty']);
		$this->number_type->setDbValue($row['number_type']);
		if (array_key_exists('EV__number_type', $rs->fields)) {
			$this->number_type->VirtualValue = $rs->fields('EV__number_type'); // Set up virtual field value
		} else {
			$this->number_type->VirtualValue = ""; // Clear value
		}
		$this->number_qty->setDbValue($row['number_qty']);
		$this->de_01->setDbValue($row['de_01']);
		if (array_key_exists('EV__de_01', $rs->fields)) {
			$this->de_01->VirtualValue = $rs->fields('EV__de_01'); // Set up virtual field value
		} else {
			$this->de_01->VirtualValue = ""; // Clear value
		}
		$this->qty_de_01->setDbValue($row['qty_de_01']);
		$this->de_02->setDbValue($row['de_02']);
		if (array_key_exists('EV__de_02', $rs->fields)) {
			$this->de_02->VirtualValue = $rs->fields('EV__de_02'); // Set up virtual field value
		} else {
			$this->de_02->VirtualValue = ""; // Clear value
		}
		$this->qty_de_02->setDbValue($row['qty_de_02']);
		$this->de_03->setDbValue($row['de_03']);
		if (array_key_exists('EV__de_03', $rs->fields)) {
			$this->de_03->VirtualValue = $rs->fields('EV__de_03'); // Set up virtual field value
		} else {
			$this->de_03->VirtualValue = ""; // Clear value
		}
		$this->qty_de_03->setDbValue($row['qty_de_03']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['job_type'] = $this->job_type->CurrentValue;
		$row['job_category'] = $this->job_category->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		$row['description'] = $this->description->CurrentValue;
		$row['size'] = $this->size->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['pages'] = $this->pages->CurrentValue;
		$row['paper'] = $this->paper->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['pr_01'] = $this->pr_01->CurrentValue;
		$row['qty_pr_01'] = $this->qty_pr_01->CurrentValue;
		$row['pl_01'] = $this->pl_01->CurrentValue;
		$row['qty_pl_01'] = $this->qty_pl_01->CurrentValue;
		$row['pr_02'] = $this->pr_02->CurrentValue;
		$row['qty_pr_02'] = $this->qty_pr_02->CurrentValue;
		$row['pl_02'] = $this->pl_02->CurrentValue;
		$row['qty_pl_02'] = $this->qty_pl_02->CurrentValue;
		$row['pr_03'] = $this->pr_03->CurrentValue;
		$row['qty_pr_03'] = $this->qty_pr_03->CurrentValue;
		$row['pl_03'] = $this->pl_03->CurrentValue;
		$row['qty_pl_03'] = $this->qty_pl_03->CurrentValue;
		$row['pr_04'] = $this->pr_04->CurrentValue;
		$row['qty_pr_04'] = $this->qty_pr_04->CurrentValue;
		$row['pl_04'] = $this->pl_04->CurrentValue;
		$row['qty_pl_04'] = $this->qty_pl_04->CurrentValue;
		$row['pa_01'] = $this->pa_01->CurrentValue;
		$row['qty_pa_01'] = $this->qty_pa_01->CurrentValue;
		$row['pa_02'] = $this->pa_02->CurrentValue;
		$row['qty_pa_02'] = $this->qty_pa_02->CurrentValue;
		$row['pa_03'] = $this->pa_03->CurrentValue;
		$row['qty_pa_03'] = $this->qty_pa_03->CurrentValue;
		$row['pa_04'] = $this->pa_04->CurrentValue;
		$row['qty_pa_04'] = $this->qty_pa_04->CurrentValue;
		$row['pa_05'] = $this->pa_05->CurrentValue;
		$row['qty_pa_05'] = $this->qty_pa_05->CurrentValue;
		$row['pc_01'] = $this->pc_01->CurrentValue;
		$row['qty_pc_01'] = $this->qty_pc_01->CurrentValue;
		$row['pc_02'] = $this->pc_02->CurrentValue;
		$row['qty_pc_02'] = $this->qty_pc_02->CurrentValue;
		$row['o_01'] = $this->o_01->CurrentValue;
		$row['qty_o_01'] = $this->qty_o_01->CurrentValue;
		$row['lamination_type'] = $this->lamination_type->CurrentValue;
		$row['lamination_qty'] = $this->lamination_qty->CurrentValue;
		$row['die_type'] = $this->die_type->CurrentValue;
		$row['die_qty'] = $this->die_qty->CurrentValue;
		$row['binding_type'] = $this->binding_type->CurrentValue;
		$row['binding_qty'] = $this->binding_qty->CurrentValue;
		$row['number_type'] = $this->number_type->CurrentValue;
		$row['number_qty'] = $this->number_qty->CurrentValue;
		$row['de_01'] = $this->de_01->CurrentValue;
		$row['qty_de_01'] = $this->qty_de_01->CurrentValue;
		$row['de_02'] = $this->de_02->CurrentValue;
		$row['qty_de_02'] = $this->qty_de_02->CurrentValue;
		$row['de_03'] = $this->de_03->CurrentValue;
		$row['qty_de_03'] = $this->qty_de_03->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_01->FormValue == $this->qty_pr_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_01->CurrentValue)))
			$this->qty_pr_01->CurrentValue = ConvertToFloatString($this->qty_pr_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_01->FormValue == $this->qty_pl_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_01->CurrentValue)))
			$this->qty_pl_01->CurrentValue = ConvertToFloatString($this->qty_pl_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_02->FormValue == $this->qty_pr_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_02->CurrentValue)))
			$this->qty_pr_02->CurrentValue = ConvertToFloatString($this->qty_pr_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_02->FormValue == $this->qty_pl_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_02->CurrentValue)))
			$this->qty_pl_02->CurrentValue = ConvertToFloatString($this->qty_pl_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_03->FormValue == $this->qty_pr_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_03->CurrentValue)))
			$this->qty_pr_03->CurrentValue = ConvertToFloatString($this->qty_pr_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_03->FormValue == $this->qty_pl_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_03->CurrentValue)))
			$this->qty_pl_03->CurrentValue = ConvertToFloatString($this->qty_pl_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_04->FormValue == $this->qty_pr_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_04->CurrentValue)))
			$this->qty_pr_04->CurrentValue = ConvertToFloatString($this->qty_pr_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_04->FormValue == $this->qty_pl_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_04->CurrentValue)))
			$this->qty_pl_04->CurrentValue = ConvertToFloatString($this->qty_pl_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_01->FormValue == $this->qty_pa_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_01->CurrentValue)))
			$this->qty_pa_01->CurrentValue = ConvertToFloatString($this->qty_pa_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_02->FormValue == $this->qty_pa_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_02->CurrentValue)))
			$this->qty_pa_02->CurrentValue = ConvertToFloatString($this->qty_pa_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_03->FormValue == $this->qty_pa_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_03->CurrentValue)))
			$this->qty_pa_03->CurrentValue = ConvertToFloatString($this->qty_pa_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_04->FormValue == $this->qty_pa_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_04->CurrentValue)))
			$this->qty_pa_04->CurrentValue = ConvertToFloatString($this->qty_pa_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_05->FormValue == $this->qty_pa_05->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_05->CurrentValue)))
			$this->qty_pa_05->CurrentValue = ConvertToFloatString($this->qty_pa_05->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pc_01->FormValue == $this->qty_pc_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pc_01->CurrentValue)))
			$this->qty_pc_01->CurrentValue = ConvertToFloatString($this->qty_pc_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pc_02->FormValue == $this->qty_pc_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pc_02->CurrentValue)))
			$this->qty_pc_02->CurrentValue = ConvertToFloatString($this->qty_pc_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_o_01->FormValue == $this->qty_o_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_o_01->CurrentValue)))
			$this->qty_o_01->CurrentValue = ConvertToFloatString($this->qty_o_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->binding_qty->FormValue == $this->binding_qty->CurrentValue && is_numeric(ConvertToFloatString($this->binding_qty->CurrentValue)))
			$this->binding_qty->CurrentValue = ConvertToFloatString($this->binding_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_01->FormValue == $this->qty_de_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_01->CurrentValue)))
			$this->qty_de_01->CurrentValue = ConvertToFloatString($this->qty_de_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_02->FormValue == $this->qty_de_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_02->CurrentValue)))
			$this->qty_de_02->CurrentValue = ConvertToFloatString($this->qty_de_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_03->FormValue == $this->qty_de_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_03->CurrentValue)))
			$this->qty_de_03->CurrentValue = ConvertToFloatString($this->qty_de_03->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// job_type
		// job_category
		// company_id
		// description
		// size
		// quantity
		// pages
		// paper
		// remarks
		// pr_01
		// qty_pr_01
		// pl_01
		// qty_pl_01
		// pr_02
		// qty_pr_02
		// pl_02
		// qty_pl_02
		// pr_03
		// qty_pr_03
		// pl_03
		// qty_pl_03
		// pr_04
		// qty_pr_04
		// pl_04
		// qty_pl_04
		// pa_01
		// qty_pa_01
		// pa_02
		// qty_pa_02
		// pa_03
		// qty_pa_03
		// pa_04
		// qty_pa_04
		// pa_05
		// qty_pa_05
		// pc_01
		// qty_pc_01
		// pc_02
		// qty_pc_02
		// o_01
		// qty_o_01
		// lamination_type
		// lamination_qty
		// die_type
		// die_qty
		// binding_type
		// binding_qty
		// number_type
		// number_qty
		// de_01
		// qty_de_01
		// de_02
		// qty_de_02
		// de_03
		// qty_de_03
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// job_type
			if (strval($this->job_type->CurrentValue) <> "") {
				$this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
			} else {
				$this->job_type->ViewValue = NULL;
			}
			$this->job_type->ViewCustomAttributes = "";

			// job_category
			if (strval($this->job_category->CurrentValue) <> "") {
				$this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
			} else {
				$this->job_category->ViewValue = NULL;
			}
			$this->job_category->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// size
			$curVal = strval($this->size->CurrentValue);
			if ($curVal <> "") {
				$this->size->ViewValue = $this->size->lookupCacheOption($curVal);
				if ($this->size->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`description`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->size->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->size->ViewValue = $this->size->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->size->ViewValue = $this->size->CurrentValue;
					}
				}
			} else {
				$this->size->ViewValue = NULL;
			}
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// pages
			$this->pages->ViewValue = $this->pages->CurrentValue;
			$this->pages->ViewCustomAttributes = "";

			// paper
			$this->paper->ViewValue = $this->paper->CurrentValue;
			$this->paper->ViewValue = FormatNumber($this->paper->ViewValue, 0, -2, -2, -2);
			$this->paper->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// pr_01
			if ($this->pr_01->VirtualValue <> "") {
				$this->pr_01->ViewValue = $this->pr_01->VirtualValue;
			} else {
			$curVal = strval($this->pr_01->CurrentValue);
			if ($curVal <> "") {
				$this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
				if ($this->pr_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_01->ViewValue = $this->pr_01->CurrentValue;
					}
				}
			} else {
				$this->pr_01->ViewValue = NULL;
			}
			}
			$this->pr_01->ViewCustomAttributes = "";

			// qty_pr_01
			$this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
			$this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_01->ViewCustomAttributes = "";

			// pl_01
			$curVal = strval($this->pl_01->CurrentValue);
			if ($curVal <> "") {
				$this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
				if ($this->pl_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_01->ViewValue = $this->pl_01->CurrentValue;
					}
				}
			} else {
				$this->pl_01->ViewValue = NULL;
			}
			$this->pl_01->ViewCustomAttributes = "";

			// qty_pl_01
			$this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
			$this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_01->ViewCustomAttributes = "";

			// pr_02
			if ($this->pr_02->VirtualValue <> "") {
				$this->pr_02->ViewValue = $this->pr_02->VirtualValue;
			} else {
			$curVal = strval($this->pr_02->CurrentValue);
			if ($curVal <> "") {
				$this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
				if ($this->pr_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_02->ViewValue = $this->pr_02->CurrentValue;
					}
				}
			} else {
				$this->pr_02->ViewValue = NULL;
			}
			}
			$this->pr_02->ViewCustomAttributes = "";

			// qty_pr_02
			$this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
			$this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_02->ViewCustomAttributes = "";

			// pl_02
			$curVal = strval($this->pl_02->CurrentValue);
			if ($curVal <> "") {
				$this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
				if ($this->pl_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_02->ViewValue = $this->pl_02->CurrentValue;
					}
				}
			} else {
				$this->pl_02->ViewValue = NULL;
			}
			$this->pl_02->ViewCustomAttributes = "";

			// qty_pl_02
			$this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
			$this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_02->ViewCustomAttributes = "";

			// pr_03
			if ($this->pr_03->VirtualValue <> "") {
				$this->pr_03->ViewValue = $this->pr_03->VirtualValue;
			} else {
			$curVal = strval($this->pr_03->CurrentValue);
			if ($curVal <> "") {
				$this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
				if ($this->pr_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_03->ViewValue = $this->pr_03->CurrentValue;
					}
				}
			} else {
				$this->pr_03->ViewValue = NULL;
			}
			}
			$this->pr_03->ViewCustomAttributes = "";

			// qty_pr_03
			$this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
			$this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_03->ViewCustomAttributes = "";

			// pl_03
			$curVal = strval($this->pl_03->CurrentValue);
			if ($curVal <> "") {
				$this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
				if ($this->pl_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_03->ViewValue = $this->pl_03->CurrentValue;
					}
				}
			} else {
				$this->pl_03->ViewValue = NULL;
			}
			$this->pl_03->ViewCustomAttributes = "";

			// qty_pl_03
			$this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
			$this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_03->ViewCustomAttributes = "";

			// pr_04
			if ($this->pr_04->VirtualValue <> "") {
				$this->pr_04->ViewValue = $this->pr_04->VirtualValue;
			} else {
			$curVal = strval($this->pr_04->CurrentValue);
			if ($curVal <> "") {
				$this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
				if ($this->pr_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_04->ViewValue = $this->pr_04->CurrentValue;
					}
				}
			} else {
				$this->pr_04->ViewValue = NULL;
			}
			}
			$this->pr_04->ViewCustomAttributes = "";

			// qty_pr_04
			$this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
			$this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_04->ViewCustomAttributes = "";

			// pl_04
			$curVal = strval($this->pl_04->CurrentValue);
			if ($curVal <> "") {
				$this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
				if ($this->pl_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_04->ViewValue = $this->pl_04->CurrentValue;
					}
				}
			} else {
				$this->pl_04->ViewValue = NULL;
			}
			$this->pl_04->ViewCustomAttributes = "";

			// qty_pl_04
			$this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
			$this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_04->ViewCustomAttributes = "";

			// pa_01
			$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
			$curVal = strval($this->pa_01->CurrentValue);
			if ($curVal <> "") {
				$this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
				if ($this->pa_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
					}
				}
			} else {
				$this->pa_01->ViewValue = NULL;
			}
			$this->pa_01->ViewCustomAttributes = "";

			// qty_pa_01
			$this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
			$this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_01->ViewCustomAttributes = "";

			// pa_02
			$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
			$curVal = strval($this->pa_02->CurrentValue);
			if ($curVal <> "") {
				$this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
				if ($this->pa_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
					}
				}
			} else {
				$this->pa_02->ViewValue = NULL;
			}
			$this->pa_02->ViewCustomAttributes = "";

			// qty_pa_02
			$this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
			$this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_02->ViewCustomAttributes = "";

			// pa_03
			$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
			$curVal = strval($this->pa_03->CurrentValue);
			if ($curVal <> "") {
				$this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
				if ($this->pa_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
					}
				}
			} else {
				$this->pa_03->ViewValue = NULL;
			}
			$this->pa_03->ViewCustomAttributes = "";

			// qty_pa_03
			$this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
			$this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_03->ViewCustomAttributes = "";

			// pa_04
			$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
			$curVal = strval($this->pa_04->CurrentValue);
			if ($curVal <> "") {
				$this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
				if ($this->pa_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
					}
				}
			} else {
				$this->pa_04->ViewValue = NULL;
			}
			$this->pa_04->ViewCustomAttributes = "";

			// qty_pa_04
			$this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
			$this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_04->ViewCustomAttributes = "";

			// pa_05
			$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
			$curVal = strval($this->pa_05->CurrentValue);
			if ($curVal <> "") {
				$this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
				if ($this->pa_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
					}
				}
			} else {
				$this->pa_05->ViewValue = NULL;
			}
			$this->pa_05->ViewCustomAttributes = "";

			// qty_pa_05
			$this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
			$this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_05->ViewCustomAttributes = "";

			// pc_01
			$curVal = strval($this->pc_01->CurrentValue);
			if ($curVal <> "") {
				$this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
				if ($this->pc_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pc_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pc_01->ViewValue = $this->pc_01->CurrentValue;
					}
				}
			} else {
				$this->pc_01->ViewValue = NULL;
			}
			$this->pc_01->ViewCustomAttributes = "";

			// qty_pc_01
			$this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
			$this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pc_01->ViewCustomAttributes = "";

			// pc_02
			$curVal = strval($this->pc_02->CurrentValue);
			if ($curVal <> "") {
				$this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
				if ($this->pc_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pc_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pc_02->ViewValue = $this->pc_02->CurrentValue;
					}
				}
			} else {
				$this->pc_02->ViewValue = NULL;
			}
			$this->pc_02->ViewCustomAttributes = "";

			// qty_pc_02
			$this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
			$this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pc_02->ViewCustomAttributes = "";

			// o_01
			$curVal = strval($this->o_01->CurrentValue);
			if ($curVal <> "") {
				$this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
				if ($this->o_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->o_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->o_01->ViewValue = $this->o_01->CurrentValue;
					}
				}
			} else {
				$this->o_01->ViewValue = NULL;
			}
			$this->o_01->ViewCustomAttributes = "";

			// qty_o_01
			$this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
			$this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, 2, -2, -2, -2);
			$this->qty_o_01->ViewCustomAttributes = "";

			// lamination_type
			if ($this->lamination_type->VirtualValue <> "") {
				$this->lamination_type->ViewValue = $this->lamination_type->VirtualValue;
			} else {
			$curVal = strval($this->lamination_type->CurrentValue);
			if ($curVal <> "") {
				$this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
				if ($this->lamination_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (123) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->lamination_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
					}
				}
			} else {
				$this->lamination_type->ViewValue = NULL;
			}
			}
			$this->lamination_type->ViewCustomAttributes = "";

			// lamination_qty
			$this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
			$this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, 0, -2, -2, -2);
			$this->lamination_qty->ViewCustomAttributes = "";

			// die_type
			if ($this->die_type->VirtualValue <> "") {
				$this->die_type->ViewValue = $this->die_type->VirtualValue;
			} else {
			$curVal = strval($this->die_type->CurrentValue);
			if ($curVal <> "") {
				$this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
				if ($this->die_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (124) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->die_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->die_type->ViewValue = $this->die_type->CurrentValue;
					}
				}
			} else {
				$this->die_type->ViewValue = NULL;
			}
			}
			$this->die_type->ViewCustomAttributes = "";

			// die_qty
			$this->die_qty->ViewValue = $this->die_qty->CurrentValue;
			$this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, 0, -2, -2, -2);
			$this->die_qty->ViewCustomAttributes = "";

			// binding_type
			$curVal = strval($this->binding_type->CurrentValue);
			if ($curVal <> "") {
				$this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
				if ($this->binding_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->binding_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->binding_type->ViewValue = $this->binding_type->CurrentValue;
					}
				}
			} else {
				$this->binding_type->ViewValue = NULL;
			}
			$this->binding_type->ViewCustomAttributes = "";

			// binding_qty
			$this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
			$this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, 2, -2, -2, -2);
			$this->binding_qty->ViewCustomAttributes = "";

			// number_type
			if ($this->number_type->VirtualValue <> "") {
				$this->number_type->ViewValue = $this->number_type->VirtualValue;
			} else {
			$curVal = strval($this->number_type->CurrentValue);
			if ($curVal <> "") {
				$this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
				if ($this->number_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->number_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->number_type->ViewValue = $this->number_type->CurrentValue;
					}
				}
			} else {
				$this->number_type->ViewValue = NULL;
			}
			}
			$this->number_type->ViewCustomAttributes = "";

			// number_qty
			$this->number_qty->ViewValue = $this->number_qty->CurrentValue;
			$this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, 0, -2, -2, -2);
			$this->number_qty->ViewCustomAttributes = "";

			// de_01
			if ($this->de_01->VirtualValue <> "") {
				$this->de_01->ViewValue = $this->de_01->VirtualValue;
			} else {
			$curVal = strval($this->de_01->CurrentValue);
			if ($curVal <> "") {
				$this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
				if ($this->de_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_01->ViewValue = $this->de_01->CurrentValue;
					}
				}
			} else {
				$this->de_01->ViewValue = NULL;
			}
			}
			$this->de_01->ViewCustomAttributes = "";

			// qty_de_01
			$this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
			$this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, 2, -2, -2, -2);
			$this->qty_de_01->ViewCustomAttributes = "";

			// de_02
			if ($this->de_02->VirtualValue <> "") {
				$this->de_02->ViewValue = $this->de_02->VirtualValue;
			} else {
			$curVal = strval($this->de_02->CurrentValue);
			if ($curVal <> "") {
				$this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
				if ($this->de_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_02->ViewValue = $this->de_02->CurrentValue;
					}
				}
			} else {
				$this->de_02->ViewValue = NULL;
			}
			}
			$this->de_02->ViewCustomAttributes = "";

			// qty_de_02
			$this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
			$this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, 2, -2, -2, -2);
			$this->qty_de_02->ViewCustomAttributes = "";

			// de_03
			if ($this->de_03->VirtualValue <> "") {
				$this->de_03->ViewValue = $this->de_03->VirtualValue;
			} else {
			$curVal = strval($this->de_03->CurrentValue);
			if ($curVal <> "") {
				$this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
				if ($this->de_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_03->ViewValue = $this->de_03->CurrentValue;
					}
				}
			} else {
				$this->de_03->ViewValue = NULL;
			}
			}
			$this->de_03->ViewCustomAttributes = "";

			// qty_de_03
			$this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
			$this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, 2, -2, -2, -2);
			$this->qty_de_03->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewCustomAttributes = "";

			// job_type
			$this->job_type->LinkCustomAttributes = "";
			$this->job_type->HrefValue = "";
			$this->job_type->TooltipValue = "";

			// job_category
			$this->job_category->LinkCustomAttributes = "";
			$this->job_category->HrefValue = "";
			$this->job_category->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// pages
			$this->pages->LinkCustomAttributes = "";
			$this->pages->HrefValue = "";
			$this->pages->TooltipValue = "";

			// paper
			$this->paper->LinkCustomAttributes = "";
			$this->paper->HrefValue = "";
			$this->paper->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// pr_01
			$this->pr_01->LinkCustomAttributes = "";
			$this->pr_01->HrefValue = "";
			$this->pr_01->TooltipValue = "";

			// qty_pr_01
			$this->qty_pr_01->LinkCustomAttributes = "";
			$this->qty_pr_01->HrefValue = "";
			$this->qty_pr_01->TooltipValue = "";

			// pl_01
			$this->pl_01->LinkCustomAttributes = "";
			$this->pl_01->HrefValue = "";
			$this->pl_01->TooltipValue = "";

			// qty_pl_01
			$this->qty_pl_01->LinkCustomAttributes = "";
			$this->qty_pl_01->HrefValue = "";
			$this->qty_pl_01->TooltipValue = "";

			// pr_02
			$this->pr_02->LinkCustomAttributes = "";
			$this->pr_02->HrefValue = "";
			$this->pr_02->TooltipValue = "";

			// qty_pr_02
			$this->qty_pr_02->LinkCustomAttributes = "";
			$this->qty_pr_02->HrefValue = "";
			$this->qty_pr_02->TooltipValue = "";

			// pl_02
			$this->pl_02->LinkCustomAttributes = "";
			$this->pl_02->HrefValue = "";
			$this->pl_02->TooltipValue = "";

			// qty_pl_02
			$this->qty_pl_02->LinkCustomAttributes = "";
			$this->qty_pl_02->HrefValue = "";
			$this->qty_pl_02->TooltipValue = "";

			// pr_03
			$this->pr_03->LinkCustomAttributes = "";
			$this->pr_03->HrefValue = "";
			$this->pr_03->TooltipValue = "";

			// qty_pr_03
			$this->qty_pr_03->LinkCustomAttributes = "";
			$this->qty_pr_03->HrefValue = "";
			$this->qty_pr_03->TooltipValue = "";

			// pl_03
			$this->pl_03->LinkCustomAttributes = "";
			$this->pl_03->HrefValue = "";
			$this->pl_03->TooltipValue = "";

			// qty_pl_03
			$this->qty_pl_03->LinkCustomAttributes = "";
			$this->qty_pl_03->HrefValue = "";
			$this->qty_pl_03->TooltipValue = "";

			// pr_04
			$this->pr_04->LinkCustomAttributes = "";
			$this->pr_04->HrefValue = "";
			$this->pr_04->TooltipValue = "";

			// qty_pr_04
			$this->qty_pr_04->LinkCustomAttributes = "";
			$this->qty_pr_04->HrefValue = "";
			$this->qty_pr_04->TooltipValue = "";

			// pl_04
			$this->pl_04->LinkCustomAttributes = "";
			$this->pl_04->HrefValue = "";
			$this->pl_04->TooltipValue = "";

			// qty_pl_04
			$this->qty_pl_04->LinkCustomAttributes = "";
			$this->qty_pl_04->HrefValue = "";
			$this->qty_pl_04->TooltipValue = "";

			// pa_01
			$this->pa_01->LinkCustomAttributes = "";
			$this->pa_01->HrefValue = "";
			$this->pa_01->TooltipValue = "";

			// qty_pa_01
			$this->qty_pa_01->LinkCustomAttributes = "";
			$this->qty_pa_01->HrefValue = "";
			$this->qty_pa_01->TooltipValue = "";

			// pa_02
			$this->pa_02->LinkCustomAttributes = "";
			$this->pa_02->HrefValue = "";
			$this->pa_02->TooltipValue = "";

			// qty_pa_02
			$this->qty_pa_02->LinkCustomAttributes = "";
			$this->qty_pa_02->HrefValue = "";
			$this->qty_pa_02->TooltipValue = "";

			// pa_03
			$this->pa_03->LinkCustomAttributes = "";
			$this->pa_03->HrefValue = "";
			$this->pa_03->TooltipValue = "";

			// qty_pa_03
			$this->qty_pa_03->LinkCustomAttributes = "";
			$this->qty_pa_03->HrefValue = "";
			$this->qty_pa_03->TooltipValue = "";

			// pa_04
			$this->pa_04->LinkCustomAttributes = "";
			$this->pa_04->HrefValue = "";
			$this->pa_04->TooltipValue = "";

			// qty_pa_04
			$this->qty_pa_04->LinkCustomAttributes = "";
			$this->qty_pa_04->HrefValue = "";
			$this->qty_pa_04->TooltipValue = "";

			// pa_05
			$this->pa_05->LinkCustomAttributes = "";
			$this->pa_05->HrefValue = "";
			$this->pa_05->TooltipValue = "";

			// qty_pa_05
			$this->qty_pa_05->LinkCustomAttributes = "";
			$this->qty_pa_05->HrefValue = "";
			$this->qty_pa_05->TooltipValue = "";

			// pc_01
			$this->pc_01->LinkCustomAttributes = "";
			$this->pc_01->HrefValue = "";
			$this->pc_01->TooltipValue = "";

			// qty_pc_01
			$this->qty_pc_01->LinkCustomAttributes = "";
			$this->qty_pc_01->HrefValue = "";
			$this->qty_pc_01->TooltipValue = "";

			// pc_02
			$this->pc_02->LinkCustomAttributes = "";
			$this->pc_02->HrefValue = "";
			$this->pc_02->TooltipValue = "";

			// qty_pc_02
			$this->qty_pc_02->LinkCustomAttributes = "";
			$this->qty_pc_02->HrefValue = "";
			$this->qty_pc_02->TooltipValue = "";

			// o_01
			$this->o_01->LinkCustomAttributes = "";
			$this->o_01->HrefValue = "";
			$this->o_01->TooltipValue = "";

			// qty_o_01
			$this->qty_o_01->LinkCustomAttributes = "";
			$this->qty_o_01->HrefValue = "";
			$this->qty_o_01->TooltipValue = "";

			// lamination_type
			$this->lamination_type->LinkCustomAttributes = "";
			$this->lamination_type->HrefValue = "";
			$this->lamination_type->TooltipValue = "";

			// lamination_qty
			$this->lamination_qty->LinkCustomAttributes = "";
			$this->lamination_qty->HrefValue = "";
			$this->lamination_qty->TooltipValue = "";

			// die_type
			$this->die_type->LinkCustomAttributes = "";
			$this->die_type->HrefValue = "";
			$this->die_type->TooltipValue = "";

			// die_qty
			$this->die_qty->LinkCustomAttributes = "";
			$this->die_qty->HrefValue = "";
			$this->die_qty->TooltipValue = "";

			// binding_type
			$this->binding_type->LinkCustomAttributes = "";
			$this->binding_type->HrefValue = "";
			$this->binding_type->TooltipValue = "";

			// binding_qty
			$this->binding_qty->LinkCustomAttributes = "";
			$this->binding_qty->HrefValue = "";
			$this->binding_qty->TooltipValue = "";

			// number_type
			$this->number_type->LinkCustomAttributes = "";
			$this->number_type->HrefValue = "";
			$this->number_type->TooltipValue = "";

			// number_qty
			$this->number_qty->LinkCustomAttributes = "";
			$this->number_qty->HrefValue = "";
			$this->number_qty->TooltipValue = "";

			// de_01
			$this->de_01->LinkCustomAttributes = "";
			$this->de_01->HrefValue = "";
			$this->de_01->TooltipValue = "";

			// qty_de_01
			$this->qty_de_01->LinkCustomAttributes = "";
			$this->qty_de_01->HrefValue = "";
			$this->qty_de_01->TooltipValue = "";

			// de_02
			$this->de_02->LinkCustomAttributes = "";
			$this->de_02->HrefValue = "";
			$this->de_02->TooltipValue = "";

			// qty_de_02
			$this->qty_de_02->LinkCustomAttributes = "";
			$this->qty_de_02->HrefValue = "";
			$this->qty_de_02->TooltipValue = "";

			// de_03
			$this->de_03->LinkCustomAttributes = "";
			$this->de_03->HrefValue = "";
			$this->de_03->TooltipValue = "";

			// qty_de_03
			$this->qty_de_03->LinkCustomAttributes = "";
			$this->qty_de_03->HrefValue = "";
			$this->qty_de_03->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// job_type
			$this->job_type->EditCustomAttributes = "";
			$this->job_type->EditValue = $this->job_type->options(FALSE);

			// job_category
			$this->job_category->EditCustomAttributes = "";
			$this->job_category->EditValue = $this->job_category->options(FALSE);

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
			$this->description->EditValue = HtmlEncode($this->description->CurrentValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			$curVal = trim(strval($this->size->CurrentValue));
			if ($curVal <> "")
				$this->size->ViewValue = $this->size->lookupCacheOption($curVal);
			else
				$this->size->ViewValue = $this->size->Lookup !== NULL && is_array($this->size->Lookup->Options) ? $curVal : NULL;
			if ($this->size->ViewValue !== NULL) { // Load from cache
				$this->size->EditValue = array_values($this->size->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`description`" . SearchString("=", $this->size->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->size->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->size->EditValue = $arwrk;
			}

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

			// pages
			$this->pages->EditAttrs["class"] = "form-control";
			$this->pages->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pages->CurrentValue = HtmlDecode($this->pages->CurrentValue);
			$this->pages->EditValue = HtmlEncode($this->pages->CurrentValue);
			$this->pages->PlaceHolder = RemoveHtml($this->pages->caption());

			// paper
			$this->paper->EditAttrs["class"] = "form-control";
			$this->paper->EditCustomAttributes = "";
			$this->paper->EditValue = HtmlEncode($this->paper->CurrentValue);
			$this->paper->PlaceHolder = RemoveHtml($this->paper->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// pr_01
			$this->pr_01->EditAttrs["class"] = "form-control";
			$this->pr_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->pr_01->CurrentValue));
			if ($curVal <> "")
				$this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
			else
				$this->pr_01->ViewValue = $this->pr_01->Lookup !== NULL && is_array($this->pr_01->Lookup->Options) ? $curVal : NULL;
			if ($this->pr_01->ViewValue !== NULL) { // Load from cache
				$this->pr_01->EditValue = array_values($this->pr_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pr_01->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (116)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pr_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pr_01->EditValue = $arwrk;
			}

			// qty_pr_01
			$this->qty_pr_01->EditAttrs["class"] = "form-control";
			$this->qty_pr_01->EditCustomAttributes = "";
			$this->qty_pr_01->EditValue = HtmlEncode($this->qty_pr_01->CurrentValue);
			$this->qty_pr_01->PlaceHolder = RemoveHtml($this->qty_pr_01->caption());
			if (strval($this->qty_pr_01->EditValue) <> "" && is_numeric($this->qty_pr_01->EditValue))
				$this->qty_pr_01->EditValue = FormatNumber($this->qty_pr_01->EditValue, -2, -2, -2, -2);

			// pl_01
			$this->pl_01->EditAttrs["class"] = "form-control";
			$this->pl_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_01->CurrentValue));
			if ($curVal <> "")
				$this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
			else
				$this->pl_01->ViewValue = $this->pl_01->Lookup !== NULL && is_array($this->pl_01->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_01->ViewValue !== NULL) { // Load from cache
				$this->pl_01->EditValue = array_values($this->pl_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_01->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_01->EditValue = $arwrk;
			}

			// qty_pl_01
			$this->qty_pl_01->EditAttrs["class"] = "form-control";
			$this->qty_pl_01->EditCustomAttributes = "";
			$this->qty_pl_01->EditValue = HtmlEncode($this->qty_pl_01->CurrentValue);
			$this->qty_pl_01->PlaceHolder = RemoveHtml($this->qty_pl_01->caption());
			if (strval($this->qty_pl_01->EditValue) <> "" && is_numeric($this->qty_pl_01->EditValue))
				$this->qty_pl_01->EditValue = FormatNumber($this->qty_pl_01->EditValue, -2, -2, -2, -2);

			// pr_02
			$this->pr_02->EditAttrs["class"] = "form-control";
			$this->pr_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->pr_02->CurrentValue));
			if ($curVal <> "")
				$this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
			else
				$this->pr_02->ViewValue = $this->pr_02->Lookup !== NULL && is_array($this->pr_02->Lookup->Options) ? $curVal : NULL;
			if ($this->pr_02->ViewValue !== NULL) { // Load from cache
				$this->pr_02->EditValue = array_values($this->pr_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pr_02->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (116)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pr_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pr_02->EditValue = $arwrk;
			}

			// qty_pr_02
			$this->qty_pr_02->EditAttrs["class"] = "form-control";
			$this->qty_pr_02->EditCustomAttributes = "";
			$this->qty_pr_02->EditValue = HtmlEncode($this->qty_pr_02->CurrentValue);
			$this->qty_pr_02->PlaceHolder = RemoveHtml($this->qty_pr_02->caption());
			if (strval($this->qty_pr_02->EditValue) <> "" && is_numeric($this->qty_pr_02->EditValue))
				$this->qty_pr_02->EditValue = FormatNumber($this->qty_pr_02->EditValue, -2, -2, -2, -2);

			// pl_02
			$this->pl_02->EditAttrs["class"] = "form-control";
			$this->pl_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_02->CurrentValue));
			if ($curVal <> "")
				$this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
			else
				$this->pl_02->ViewValue = $this->pl_02->Lookup !== NULL && is_array($this->pl_02->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_02->ViewValue !== NULL) { // Load from cache
				$this->pl_02->EditValue = array_values($this->pl_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_02->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_02->EditValue = $arwrk;
			}

			// qty_pl_02
			$this->qty_pl_02->EditAttrs["class"] = "form-control";
			$this->qty_pl_02->EditCustomAttributes = "";
			$this->qty_pl_02->EditValue = HtmlEncode($this->qty_pl_02->CurrentValue);
			$this->qty_pl_02->PlaceHolder = RemoveHtml($this->qty_pl_02->caption());
			if (strval($this->qty_pl_02->EditValue) <> "" && is_numeric($this->qty_pl_02->EditValue))
				$this->qty_pl_02->EditValue = FormatNumber($this->qty_pl_02->EditValue, -2, -2, -2, -2);

			// pr_03
			$this->pr_03->EditAttrs["class"] = "form-control";
			$this->pr_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->pr_03->CurrentValue));
			if ($curVal <> "")
				$this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
			else
				$this->pr_03->ViewValue = $this->pr_03->Lookup !== NULL && is_array($this->pr_03->Lookup->Options) ? $curVal : NULL;
			if ($this->pr_03->ViewValue !== NULL) { // Load from cache
				$this->pr_03->EditValue = array_values($this->pr_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pr_03->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (116)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pr_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pr_03->EditValue = $arwrk;
			}

			// qty_pr_03
			$this->qty_pr_03->EditAttrs["class"] = "form-control";
			$this->qty_pr_03->EditCustomAttributes = "";
			$this->qty_pr_03->EditValue = HtmlEncode($this->qty_pr_03->CurrentValue);
			$this->qty_pr_03->PlaceHolder = RemoveHtml($this->qty_pr_03->caption());
			if (strval($this->qty_pr_03->EditValue) <> "" && is_numeric($this->qty_pr_03->EditValue))
				$this->qty_pr_03->EditValue = FormatNumber($this->qty_pr_03->EditValue, -2, -2, -2, -2);

			// pl_03
			$this->pl_03->EditAttrs["class"] = "form-control";
			$this->pl_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_03->CurrentValue));
			if ($curVal <> "")
				$this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
			else
				$this->pl_03->ViewValue = $this->pl_03->Lookup !== NULL && is_array($this->pl_03->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_03->ViewValue !== NULL) { // Load from cache
				$this->pl_03->EditValue = array_values($this->pl_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_03->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_03->EditValue = $arwrk;
			}

			// qty_pl_03
			$this->qty_pl_03->EditAttrs["class"] = "form-control";
			$this->qty_pl_03->EditCustomAttributes = "";
			$this->qty_pl_03->EditValue = HtmlEncode($this->qty_pl_03->CurrentValue);
			$this->qty_pl_03->PlaceHolder = RemoveHtml($this->qty_pl_03->caption());
			if (strval($this->qty_pl_03->EditValue) <> "" && is_numeric($this->qty_pl_03->EditValue))
				$this->qty_pl_03->EditValue = FormatNumber($this->qty_pl_03->EditValue, -2, -2, -2, -2);

			// pr_04
			$this->pr_04->EditAttrs["class"] = "form-control";
			$this->pr_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->pr_04->CurrentValue));
			if ($curVal <> "")
				$this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
			else
				$this->pr_04->ViewValue = $this->pr_04->Lookup !== NULL && is_array($this->pr_04->Lookup->Options) ? $curVal : NULL;
			if ($this->pr_04->ViewValue !== NULL) { // Load from cache
				$this->pr_04->EditValue = array_values($this->pr_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pr_04->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (116)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pr_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pr_04->EditValue = $arwrk;
			}

			// qty_pr_04
			$this->qty_pr_04->EditAttrs["class"] = "form-control";
			$this->qty_pr_04->EditCustomAttributes = "";
			$this->qty_pr_04->EditValue = HtmlEncode($this->qty_pr_04->CurrentValue);
			$this->qty_pr_04->PlaceHolder = RemoveHtml($this->qty_pr_04->caption());
			if (strval($this->qty_pr_04->EditValue) <> "" && is_numeric($this->qty_pr_04->EditValue))
				$this->qty_pr_04->EditValue = FormatNumber($this->qty_pr_04->EditValue, -2, -2, -2, -2);

			// pl_04
			$this->pl_04->EditAttrs["class"] = "form-control";
			$this->pl_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_04->CurrentValue));
			if ($curVal <> "")
				$this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
			else
				$this->pl_04->ViewValue = $this->pl_04->Lookup !== NULL && is_array($this->pl_04->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_04->ViewValue !== NULL) { // Load from cache
				$this->pl_04->EditValue = array_values($this->pl_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_04->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_04->EditValue = $arwrk;
			}

			// qty_pl_04
			$this->qty_pl_04->EditAttrs["class"] = "form-control";
			$this->qty_pl_04->EditCustomAttributes = "";
			$this->qty_pl_04->EditValue = HtmlEncode($this->qty_pl_04->CurrentValue);
			$this->qty_pl_04->PlaceHolder = RemoveHtml($this->qty_pl_04->caption());
			if (strval($this->qty_pl_04->EditValue) <> "" && is_numeric($this->qty_pl_04->EditValue))
				$this->qty_pl_04->EditValue = FormatNumber($this->qty_pl_04->EditValue, -2, -2, -2, -2);

			// pa_01
			$this->pa_01->EditAttrs["class"] = "form-control";
			$this->pa_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_01->CurrentValue = HtmlDecode($this->pa_01->CurrentValue);
			$this->pa_01->EditValue = HtmlEncode($this->pa_01->CurrentValue);
			$curVal = strval($this->pa_01->CurrentValue);
			if ($curVal <> "") {
				$this->pa_01->EditValue = $this->pa_01->lookupCacheOption($curVal);
				if ($this->pa_01->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_01->EditValue = $this->pa_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_01->EditValue = HtmlEncode($this->pa_01->CurrentValue);
					}
				}
			} else {
				$this->pa_01->EditValue = NULL;
			}
			$this->pa_01->PlaceHolder = RemoveHtml($this->pa_01->caption());

			// qty_pa_01
			$this->qty_pa_01->EditAttrs["class"] = "form-control";
			$this->qty_pa_01->EditCustomAttributes = "";
			$this->qty_pa_01->EditValue = HtmlEncode($this->qty_pa_01->CurrentValue);
			$this->qty_pa_01->PlaceHolder = RemoveHtml($this->qty_pa_01->caption());
			if (strval($this->qty_pa_01->EditValue) <> "" && is_numeric($this->qty_pa_01->EditValue))
				$this->qty_pa_01->EditValue = FormatNumber($this->qty_pa_01->EditValue, -2, -2, -2, -2);

			// pa_02
			$this->pa_02->EditAttrs["class"] = "form-control";
			$this->pa_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_02->CurrentValue = HtmlDecode($this->pa_02->CurrentValue);
			$this->pa_02->EditValue = HtmlEncode($this->pa_02->CurrentValue);
			$curVal = strval($this->pa_02->CurrentValue);
			if ($curVal <> "") {
				$this->pa_02->EditValue = $this->pa_02->lookupCacheOption($curVal);
				if ($this->pa_02->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_02->EditValue = $this->pa_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_02->EditValue = HtmlEncode($this->pa_02->CurrentValue);
					}
				}
			} else {
				$this->pa_02->EditValue = NULL;
			}
			$this->pa_02->PlaceHolder = RemoveHtml($this->pa_02->caption());

			// qty_pa_02
			$this->qty_pa_02->EditAttrs["class"] = "form-control";
			$this->qty_pa_02->EditCustomAttributes = "";
			$this->qty_pa_02->EditValue = HtmlEncode($this->qty_pa_02->CurrentValue);
			$this->qty_pa_02->PlaceHolder = RemoveHtml($this->qty_pa_02->caption());
			if (strval($this->qty_pa_02->EditValue) <> "" && is_numeric($this->qty_pa_02->EditValue))
				$this->qty_pa_02->EditValue = FormatNumber($this->qty_pa_02->EditValue, -2, -2, -2, -2);

			// pa_03
			$this->pa_03->EditAttrs["class"] = "form-control";
			$this->pa_03->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_03->CurrentValue = HtmlDecode($this->pa_03->CurrentValue);
			$this->pa_03->EditValue = HtmlEncode($this->pa_03->CurrentValue);
			$curVal = strval($this->pa_03->CurrentValue);
			if ($curVal <> "") {
				$this->pa_03->EditValue = $this->pa_03->lookupCacheOption($curVal);
				if ($this->pa_03->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_03->EditValue = $this->pa_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_03->EditValue = HtmlEncode($this->pa_03->CurrentValue);
					}
				}
			} else {
				$this->pa_03->EditValue = NULL;
			}
			$this->pa_03->PlaceHolder = RemoveHtml($this->pa_03->caption());

			// qty_pa_03
			$this->qty_pa_03->EditAttrs["class"] = "form-control";
			$this->qty_pa_03->EditCustomAttributes = "";
			$this->qty_pa_03->EditValue = HtmlEncode($this->qty_pa_03->CurrentValue);
			$this->qty_pa_03->PlaceHolder = RemoveHtml($this->qty_pa_03->caption());
			if (strval($this->qty_pa_03->EditValue) <> "" && is_numeric($this->qty_pa_03->EditValue))
				$this->qty_pa_03->EditValue = FormatNumber($this->qty_pa_03->EditValue, -2, -2, -2, -2);

			// pa_04
			$this->pa_04->EditAttrs["class"] = "form-control";
			$this->pa_04->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_04->CurrentValue = HtmlDecode($this->pa_04->CurrentValue);
			$this->pa_04->EditValue = HtmlEncode($this->pa_04->CurrentValue);
			$curVal = strval($this->pa_04->CurrentValue);
			if ($curVal <> "") {
				$this->pa_04->EditValue = $this->pa_04->lookupCacheOption($curVal);
				if ($this->pa_04->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_04->EditValue = $this->pa_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_04->EditValue = HtmlEncode($this->pa_04->CurrentValue);
					}
				}
			} else {
				$this->pa_04->EditValue = NULL;
			}
			$this->pa_04->PlaceHolder = RemoveHtml($this->pa_04->caption());

			// qty_pa_04
			$this->qty_pa_04->EditAttrs["class"] = "form-control";
			$this->qty_pa_04->EditCustomAttributes = "";
			$this->qty_pa_04->EditValue = HtmlEncode($this->qty_pa_04->CurrentValue);
			$this->qty_pa_04->PlaceHolder = RemoveHtml($this->qty_pa_04->caption());
			if (strval($this->qty_pa_04->EditValue) <> "" && is_numeric($this->qty_pa_04->EditValue))
				$this->qty_pa_04->EditValue = FormatNumber($this->qty_pa_04->EditValue, -2, -2, -2, -2);

			// pa_05
			$this->pa_05->EditAttrs["class"] = "form-control";
			$this->pa_05->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_05->CurrentValue = HtmlDecode($this->pa_05->CurrentValue);
			$this->pa_05->EditValue = HtmlEncode($this->pa_05->CurrentValue);
			$curVal = strval($this->pa_05->CurrentValue);
			if ($curVal <> "") {
				$this->pa_05->EditValue = $this->pa_05->lookupCacheOption($curVal);
				if ($this->pa_05->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_05->EditValue = $this->pa_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_05->EditValue = HtmlEncode($this->pa_05->CurrentValue);
					}
				}
			} else {
				$this->pa_05->EditValue = NULL;
			}
			$this->pa_05->PlaceHolder = RemoveHtml($this->pa_05->caption());

			// qty_pa_05
			$this->qty_pa_05->EditAttrs["class"] = "form-control";
			$this->qty_pa_05->EditCustomAttributes = "";
			$this->qty_pa_05->EditValue = HtmlEncode($this->qty_pa_05->CurrentValue);
			$this->qty_pa_05->PlaceHolder = RemoveHtml($this->qty_pa_05->caption());
			if (strval($this->qty_pa_05->EditValue) <> "" && is_numeric($this->qty_pa_05->EditValue))
				$this->qty_pa_05->EditValue = FormatNumber($this->qty_pa_05->EditValue, -2, -2, -2, -2);

			// pc_01
			$this->pc_01->EditAttrs["class"] = "form-control";
			$this->pc_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->pc_01->CurrentValue));
			if ($curVal <> "")
				$this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
			else
				$this->pc_01->ViewValue = $this->pc_01->Lookup !== NULL && is_array($this->pc_01->Lookup->Options) ? $curVal : NULL;
			if ($this->pc_01->ViewValue !== NULL) { // Load from cache
				$this->pc_01->EditValue = array_values($this->pc_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pc_01->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (125) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pc_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pc_01->EditValue = $arwrk;
			}

			// qty_pc_01
			$this->qty_pc_01->EditAttrs["class"] = "form-control";
			$this->qty_pc_01->EditCustomAttributes = "";
			$this->qty_pc_01->EditValue = HtmlEncode($this->qty_pc_01->CurrentValue);
			$this->qty_pc_01->PlaceHolder = RemoveHtml($this->qty_pc_01->caption());
			if (strval($this->qty_pc_01->EditValue) <> "" && is_numeric($this->qty_pc_01->EditValue))
				$this->qty_pc_01->EditValue = FormatNumber($this->qty_pc_01->EditValue, -2, -2, -2, -2);

			// pc_02
			$this->pc_02->EditAttrs["class"] = "form-control";
			$this->pc_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->pc_02->CurrentValue));
			if ($curVal <> "")
				$this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
			else
				$this->pc_02->ViewValue = $this->pc_02->Lookup !== NULL && is_array($this->pc_02->Lookup->Options) ? $curVal : NULL;
			if ($this->pc_02->ViewValue !== NULL) { // Load from cache
				$this->pc_02->EditValue = array_values($this->pc_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pc_02->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (125) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pc_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pc_02->EditValue = $arwrk;
			}

			// qty_pc_02
			$this->qty_pc_02->EditAttrs["class"] = "form-control";
			$this->qty_pc_02->EditCustomAttributes = "";
			$this->qty_pc_02->EditValue = HtmlEncode($this->qty_pc_02->CurrentValue);
			$this->qty_pc_02->PlaceHolder = RemoveHtml($this->qty_pc_02->caption());
			if (strval($this->qty_pc_02->EditValue) <> "" && is_numeric($this->qty_pc_02->EditValue))
				$this->qty_pc_02->EditValue = FormatNumber($this->qty_pc_02->EditValue, -2, -2, -2, -2);

			// o_01
			$this->o_01->EditAttrs["class"] = "form-control";
			$this->o_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->o_01->CurrentValue));
			if ($curVal <> "")
				$this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
			else
				$this->o_01->ViewValue = $this->o_01->Lookup !== NULL && is_array($this->o_01->Lookup->Options) ? $curVal : NULL;
			if ($this->o_01->ViewValue !== NULL) { // Load from cache
				$this->o_01->EditValue = array_values($this->o_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->o_01->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->o_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->o_01->EditValue = $arwrk;
			}

			// qty_o_01
			$this->qty_o_01->EditAttrs["class"] = "form-control";
			$this->qty_o_01->EditCustomAttributes = "";
			$this->qty_o_01->EditValue = HtmlEncode($this->qty_o_01->CurrentValue);
			$this->qty_o_01->PlaceHolder = RemoveHtml($this->qty_o_01->caption());
			if (strval($this->qty_o_01->EditValue) <> "" && is_numeric($this->qty_o_01->EditValue))
				$this->qty_o_01->EditValue = FormatNumber($this->qty_o_01->EditValue, -2, -2, -2, -2);

			// lamination_type
			$this->lamination_type->EditAttrs["class"] = "form-control";
			$this->lamination_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->lamination_type->CurrentValue));
			if ($curVal <> "")
				$this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
			else
				$this->lamination_type->ViewValue = $this->lamination_type->Lookup !== NULL && is_array($this->lamination_type->Lookup->Options) ? $curVal : NULL;
			if ($this->lamination_type->ViewValue !== NULL) { // Load from cache
				$this->lamination_type->EditValue = array_values($this->lamination_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->lamination_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (123) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->lamination_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->lamination_type->EditValue = $arwrk;
			}

			// lamination_qty
			$this->lamination_qty->EditAttrs["class"] = "form-control";
			$this->lamination_qty->EditCustomAttributes = "";
			$this->lamination_qty->EditValue = HtmlEncode($this->lamination_qty->CurrentValue);
			$this->lamination_qty->PlaceHolder = RemoveHtml($this->lamination_qty->caption());

			// die_type
			$this->die_type->EditAttrs["class"] = "form-control";
			$this->die_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->die_type->CurrentValue));
			if ($curVal <> "")
				$this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
			else
				$this->die_type->ViewValue = $this->die_type->Lookup !== NULL && is_array($this->die_type->Lookup->Options) ? $curVal : NULL;
			if ($this->die_type->ViewValue !== NULL) { // Load from cache
				$this->die_type->EditValue = array_values($this->die_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->die_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (124) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->die_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->die_type->EditValue = $arwrk;
			}

			// die_qty
			$this->die_qty->EditAttrs["class"] = "form-control";
			$this->die_qty->EditCustomAttributes = "";
			$this->die_qty->EditValue = HtmlEncode($this->die_qty->CurrentValue);
			$this->die_qty->PlaceHolder = RemoveHtml($this->die_qty->caption());

			// binding_type
			$this->binding_type->EditAttrs["class"] = "form-control";
			$this->binding_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->binding_type->CurrentValue));
			if ($curVal <> "")
				$this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
			else
				$this->binding_type->ViewValue = $this->binding_type->Lookup !== NULL && is_array($this->binding_type->Lookup->Options) ? $curVal : NULL;
			if ($this->binding_type->ViewValue !== NULL) { // Load from cache
				$this->binding_type->EditValue = array_values($this->binding_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->binding_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (114) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->binding_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->binding_type->EditValue = $arwrk;
			}

			// binding_qty
			$this->binding_qty->EditAttrs["class"] = "form-control";
			$this->binding_qty->EditCustomAttributes = "";
			$this->binding_qty->EditValue = HtmlEncode($this->binding_qty->CurrentValue);
			$this->binding_qty->PlaceHolder = RemoveHtml($this->binding_qty->caption());
			if (strval($this->binding_qty->EditValue) <> "" && is_numeric($this->binding_qty->EditValue))
				$this->binding_qty->EditValue = FormatNumber($this->binding_qty->EditValue, -2, -2, -2, -2);

			// number_type
			$this->number_type->EditAttrs["class"] = "form-control";
			$this->number_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->number_type->CurrentValue));
			if ($curVal <> "")
				$this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
			else
				$this->number_type->ViewValue = $this->number_type->Lookup !== NULL && is_array($this->number_type->Lookup->Options) ? $curVal : NULL;
			if ($this->number_type->ViewValue !== NULL) { // Load from cache
				$this->number_type->EditValue = array_values($this->number_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->number_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (114) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->number_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->number_type->EditValue = $arwrk;
			}

			// number_qty
			$this->number_qty->EditAttrs["class"] = "form-control";
			$this->number_qty->EditCustomAttributes = "";
			$this->number_qty->EditValue = HtmlEncode($this->number_qty->CurrentValue);
			$this->number_qty->PlaceHolder = RemoveHtml($this->number_qty->caption());

			// de_01
			$this->de_01->EditAttrs["class"] = "form-control";
			$this->de_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->de_01->CurrentValue));
			if ($curVal <> "")
				$this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
			else
				$this->de_01->ViewValue = $this->de_01->Lookup !== NULL && is_array($this->de_01->Lookup->Options) ? $curVal : NULL;
			if ($this->de_01->ViewValue !== NULL) { // Load from cache
				$this->de_01->EditValue = array_values($this->de_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->de_01->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (121) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->de_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->de_01->EditValue = $arwrk;
			}

			// qty_de_01
			$this->qty_de_01->EditAttrs["class"] = "form-control";
			$this->qty_de_01->EditCustomAttributes = "";
			$this->qty_de_01->EditValue = HtmlEncode($this->qty_de_01->CurrentValue);
			$this->qty_de_01->PlaceHolder = RemoveHtml($this->qty_de_01->caption());
			if (strval($this->qty_de_01->EditValue) <> "" && is_numeric($this->qty_de_01->EditValue))
				$this->qty_de_01->EditValue = FormatNumber($this->qty_de_01->EditValue, -2, -2, -2, -2);

			// de_02
			$this->de_02->EditAttrs["class"] = "form-control";
			$this->de_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->de_02->CurrentValue));
			if ($curVal <> "")
				$this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
			else
				$this->de_02->ViewValue = $this->de_02->Lookup !== NULL && is_array($this->de_02->Lookup->Options) ? $curVal : NULL;
			if ($this->de_02->ViewValue !== NULL) { // Load from cache
				$this->de_02->EditValue = array_values($this->de_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->de_02->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (121) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->de_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->de_02->EditValue = $arwrk;
			}

			// qty_de_02
			$this->qty_de_02->EditAttrs["class"] = "form-control";
			$this->qty_de_02->EditCustomAttributes = "";
			$this->qty_de_02->EditValue = HtmlEncode($this->qty_de_02->CurrentValue);
			$this->qty_de_02->PlaceHolder = RemoveHtml($this->qty_de_02->caption());
			if (strval($this->qty_de_02->EditValue) <> "" && is_numeric($this->qty_de_02->EditValue))
				$this->qty_de_02->EditValue = FormatNumber($this->qty_de_02->EditValue, -2, -2, -2, -2);

			// de_03
			$this->de_03->EditAttrs["class"] = "form-control";
			$this->de_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->de_03->CurrentValue));
			if ($curVal <> "")
				$this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
			else
				$this->de_03->ViewValue = $this->de_03->Lookup !== NULL && is_array($this->de_03->Lookup->Options) ? $curVal : NULL;
			if ($this->de_03->ViewValue !== NULL) { // Load from cache
				$this->de_03->EditValue = array_values($this->de_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->de_03->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (121) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->de_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->de_03->EditValue = $arwrk;
			}

			// qty_de_03
			$this->qty_de_03->EditAttrs["class"] = "form-control";
			$this->qty_de_03->EditCustomAttributes = "";
			$this->qty_de_03->EditValue = HtmlEncode($this->qty_de_03->CurrentValue);
			$this->qty_de_03->PlaceHolder = RemoveHtml($this->qty_de_03->caption());
			if (strval($this->qty_de_03->EditValue) <> "" && is_numeric($this->qty_de_03->EditValue))
				$this->qty_de_03->EditValue = FormatNumber($this->qty_de_03->EditValue, -2, -2, -2, -2);

			// operator
			// datetime
			// Add refer script
			// job_type

			$this->job_type->LinkCustomAttributes = "";
			$this->job_type->HrefValue = "";

			// job_category
			$this->job_category->LinkCustomAttributes = "";
			$this->job_category->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// pages
			$this->pages->LinkCustomAttributes = "";
			$this->pages->HrefValue = "";

			// paper
			$this->paper->LinkCustomAttributes = "";
			$this->paper->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// pr_01
			$this->pr_01->LinkCustomAttributes = "";
			$this->pr_01->HrefValue = "";

			// qty_pr_01
			$this->qty_pr_01->LinkCustomAttributes = "";
			$this->qty_pr_01->HrefValue = "";

			// pl_01
			$this->pl_01->LinkCustomAttributes = "";
			$this->pl_01->HrefValue = "";

			// qty_pl_01
			$this->qty_pl_01->LinkCustomAttributes = "";
			$this->qty_pl_01->HrefValue = "";

			// pr_02
			$this->pr_02->LinkCustomAttributes = "";
			$this->pr_02->HrefValue = "";

			// qty_pr_02
			$this->qty_pr_02->LinkCustomAttributes = "";
			$this->qty_pr_02->HrefValue = "";

			// pl_02
			$this->pl_02->LinkCustomAttributes = "";
			$this->pl_02->HrefValue = "";

			// qty_pl_02
			$this->qty_pl_02->LinkCustomAttributes = "";
			$this->qty_pl_02->HrefValue = "";

			// pr_03
			$this->pr_03->LinkCustomAttributes = "";
			$this->pr_03->HrefValue = "";

			// qty_pr_03
			$this->qty_pr_03->LinkCustomAttributes = "";
			$this->qty_pr_03->HrefValue = "";

			// pl_03
			$this->pl_03->LinkCustomAttributes = "";
			$this->pl_03->HrefValue = "";

			// qty_pl_03
			$this->qty_pl_03->LinkCustomAttributes = "";
			$this->qty_pl_03->HrefValue = "";

			// pr_04
			$this->pr_04->LinkCustomAttributes = "";
			$this->pr_04->HrefValue = "";

			// qty_pr_04
			$this->qty_pr_04->LinkCustomAttributes = "";
			$this->qty_pr_04->HrefValue = "";

			// pl_04
			$this->pl_04->LinkCustomAttributes = "";
			$this->pl_04->HrefValue = "";

			// qty_pl_04
			$this->qty_pl_04->LinkCustomAttributes = "";
			$this->qty_pl_04->HrefValue = "";

			// pa_01
			$this->pa_01->LinkCustomAttributes = "";
			$this->pa_01->HrefValue = "";

			// qty_pa_01
			$this->qty_pa_01->LinkCustomAttributes = "";
			$this->qty_pa_01->HrefValue = "";

			// pa_02
			$this->pa_02->LinkCustomAttributes = "";
			$this->pa_02->HrefValue = "";

			// qty_pa_02
			$this->qty_pa_02->LinkCustomAttributes = "";
			$this->qty_pa_02->HrefValue = "";

			// pa_03
			$this->pa_03->LinkCustomAttributes = "";
			$this->pa_03->HrefValue = "";

			// qty_pa_03
			$this->qty_pa_03->LinkCustomAttributes = "";
			$this->qty_pa_03->HrefValue = "";

			// pa_04
			$this->pa_04->LinkCustomAttributes = "";
			$this->pa_04->HrefValue = "";

			// qty_pa_04
			$this->qty_pa_04->LinkCustomAttributes = "";
			$this->qty_pa_04->HrefValue = "";

			// pa_05
			$this->pa_05->LinkCustomAttributes = "";
			$this->pa_05->HrefValue = "";

			// qty_pa_05
			$this->qty_pa_05->LinkCustomAttributes = "";
			$this->qty_pa_05->HrefValue = "";

			// pc_01
			$this->pc_01->LinkCustomAttributes = "";
			$this->pc_01->HrefValue = "";

			// qty_pc_01
			$this->qty_pc_01->LinkCustomAttributes = "";
			$this->qty_pc_01->HrefValue = "";

			// pc_02
			$this->pc_02->LinkCustomAttributes = "";
			$this->pc_02->HrefValue = "";

			// qty_pc_02
			$this->qty_pc_02->LinkCustomAttributes = "";
			$this->qty_pc_02->HrefValue = "";

			// o_01
			$this->o_01->LinkCustomAttributes = "";
			$this->o_01->HrefValue = "";

			// qty_o_01
			$this->qty_o_01->LinkCustomAttributes = "";
			$this->qty_o_01->HrefValue = "";

			// lamination_type
			$this->lamination_type->LinkCustomAttributes = "";
			$this->lamination_type->HrefValue = "";

			// lamination_qty
			$this->lamination_qty->LinkCustomAttributes = "";
			$this->lamination_qty->HrefValue = "";

			// die_type
			$this->die_type->LinkCustomAttributes = "";
			$this->die_type->HrefValue = "";

			// die_qty
			$this->die_qty->LinkCustomAttributes = "";
			$this->die_qty->HrefValue = "";

			// binding_type
			$this->binding_type->LinkCustomAttributes = "";
			$this->binding_type->HrefValue = "";

			// binding_qty
			$this->binding_qty->LinkCustomAttributes = "";
			$this->binding_qty->HrefValue = "";

			// number_type
			$this->number_type->LinkCustomAttributes = "";
			$this->number_type->HrefValue = "";

			// number_qty
			$this->number_qty->LinkCustomAttributes = "";
			$this->number_qty->HrefValue = "";

			// de_01
			$this->de_01->LinkCustomAttributes = "";
			$this->de_01->HrefValue = "";

			// qty_de_01
			$this->qty_de_01->LinkCustomAttributes = "";
			$this->qty_de_01->HrefValue = "";

			// de_02
			$this->de_02->LinkCustomAttributes = "";
			$this->de_02->HrefValue = "";

			// qty_de_02
			$this->qty_de_02->LinkCustomAttributes = "";
			$this->qty_de_02->HrefValue = "";

			// de_03
			$this->de_03->LinkCustomAttributes = "";
			$this->de_03->HrefValue = "";

			// qty_de_03
			$this->qty_de_03->LinkCustomAttributes = "";
			$this->qty_de_03->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->job_type->Required) {
			if ($this->job_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->job_type->caption(), $this->job_type->RequiredErrorMessage));
			}
		}
		if ($this->job_category->Required) {
			if ($this->job_category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->job_category->caption(), $this->job_category->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->description->Required) {
			if (!$this->description->IsDetailKey && $this->description->FormValue != NULL && $this->description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
			}
		}
		if ($this->size->Required) {
			if (!$this->size->IsDetailKey && $this->size->FormValue != NULL && $this->size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->pages->Required) {
			if (!$this->pages->IsDetailKey && $this->pages->FormValue != NULL && $this->pages->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pages->caption(), $this->pages->RequiredErrorMessage));
			}
		}
		if ($this->paper->Required) {
			if (!$this->paper->IsDetailKey && $this->paper->FormValue != NULL && $this->paper->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->paper->caption(), $this->paper->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->paper->FormValue)) {
			AddMessage($FormError, $this->paper->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->pr_01->Required) {
			if (!$this->pr_01->IsDetailKey && $this->pr_01->FormValue != NULL && $this->pr_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pr_01->caption(), $this->pr_01->RequiredErrorMessage));
			}
		}
		if ($this->qty_pr_01->Required) {
			if (!$this->qty_pr_01->IsDetailKey && $this->qty_pr_01->FormValue != NULL && $this->qty_pr_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pr_01->caption(), $this->qty_pr_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pr_01->FormValue)) {
			AddMessage($FormError, $this->qty_pr_01->errorMessage());
		}
		if ($this->pl_01->Required) {
			if (!$this->pl_01->IsDetailKey && $this->pl_01->FormValue != NULL && $this->pl_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_01->caption(), $this->pl_01->RequiredErrorMessage));
			}
		}
		if ($this->qty_pl_01->Required) {
			if (!$this->qty_pl_01->IsDetailKey && $this->qty_pl_01->FormValue != NULL && $this->qty_pl_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pl_01->caption(), $this->qty_pl_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pl_01->FormValue)) {
			AddMessage($FormError, $this->qty_pl_01->errorMessage());
		}
		if ($this->pr_02->Required) {
			if (!$this->pr_02->IsDetailKey && $this->pr_02->FormValue != NULL && $this->pr_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pr_02->caption(), $this->pr_02->RequiredErrorMessage));
			}
		}
		if ($this->qty_pr_02->Required) {
			if (!$this->qty_pr_02->IsDetailKey && $this->qty_pr_02->FormValue != NULL && $this->qty_pr_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pr_02->caption(), $this->qty_pr_02->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pr_02->FormValue)) {
			AddMessage($FormError, $this->qty_pr_02->errorMessage());
		}
		if ($this->pl_02->Required) {
			if (!$this->pl_02->IsDetailKey && $this->pl_02->FormValue != NULL && $this->pl_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_02->caption(), $this->pl_02->RequiredErrorMessage));
			}
		}
		if ($this->qty_pl_02->Required) {
			if (!$this->qty_pl_02->IsDetailKey && $this->qty_pl_02->FormValue != NULL && $this->qty_pl_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pl_02->caption(), $this->qty_pl_02->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pl_02->FormValue)) {
			AddMessage($FormError, $this->qty_pl_02->errorMessage());
		}
		if ($this->pr_03->Required) {
			if (!$this->pr_03->IsDetailKey && $this->pr_03->FormValue != NULL && $this->pr_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pr_03->caption(), $this->pr_03->RequiredErrorMessage));
			}
		}
		if ($this->qty_pr_03->Required) {
			if (!$this->qty_pr_03->IsDetailKey && $this->qty_pr_03->FormValue != NULL && $this->qty_pr_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pr_03->caption(), $this->qty_pr_03->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pr_03->FormValue)) {
			AddMessage($FormError, $this->qty_pr_03->errorMessage());
		}
		if ($this->pl_03->Required) {
			if (!$this->pl_03->IsDetailKey && $this->pl_03->FormValue != NULL && $this->pl_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_03->caption(), $this->pl_03->RequiredErrorMessage));
			}
		}
		if ($this->qty_pl_03->Required) {
			if (!$this->qty_pl_03->IsDetailKey && $this->qty_pl_03->FormValue != NULL && $this->qty_pl_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pl_03->caption(), $this->qty_pl_03->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pl_03->FormValue)) {
			AddMessage($FormError, $this->qty_pl_03->errorMessage());
		}
		if ($this->pr_04->Required) {
			if (!$this->pr_04->IsDetailKey && $this->pr_04->FormValue != NULL && $this->pr_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pr_04->caption(), $this->pr_04->RequiredErrorMessage));
			}
		}
		if ($this->qty_pr_04->Required) {
			if (!$this->qty_pr_04->IsDetailKey && $this->qty_pr_04->FormValue != NULL && $this->qty_pr_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pr_04->caption(), $this->qty_pr_04->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pr_04->FormValue)) {
			AddMessage($FormError, $this->qty_pr_04->errorMessage());
		}
		if ($this->pl_04->Required) {
			if (!$this->pl_04->IsDetailKey && $this->pl_04->FormValue != NULL && $this->pl_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_04->caption(), $this->pl_04->RequiredErrorMessage));
			}
		}
		if ($this->qty_pl_04->Required) {
			if (!$this->qty_pl_04->IsDetailKey && $this->qty_pl_04->FormValue != NULL && $this->qty_pl_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pl_04->caption(), $this->qty_pl_04->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pl_04->FormValue)) {
			AddMessage($FormError, $this->qty_pl_04->errorMessage());
		}
		if ($this->pa_01->Required) {
			if (!$this->pa_01->IsDetailKey && $this->pa_01->FormValue != NULL && $this->pa_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pa_01->caption(), $this->pa_01->RequiredErrorMessage));
			}
		}
		if ($this->qty_pa_01->Required) {
			if (!$this->qty_pa_01->IsDetailKey && $this->qty_pa_01->FormValue != NULL && $this->qty_pa_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pa_01->caption(), $this->qty_pa_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pa_01->FormValue)) {
			AddMessage($FormError, $this->qty_pa_01->errorMessage());
		}
		if ($this->pa_02->Required) {
			if (!$this->pa_02->IsDetailKey && $this->pa_02->FormValue != NULL && $this->pa_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pa_02->caption(), $this->pa_02->RequiredErrorMessage));
			}
		}
		if ($this->qty_pa_02->Required) {
			if (!$this->qty_pa_02->IsDetailKey && $this->qty_pa_02->FormValue != NULL && $this->qty_pa_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pa_02->caption(), $this->qty_pa_02->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pa_02->FormValue)) {
			AddMessage($FormError, $this->qty_pa_02->errorMessage());
		}
		if ($this->pa_03->Required) {
			if (!$this->pa_03->IsDetailKey && $this->pa_03->FormValue != NULL && $this->pa_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pa_03->caption(), $this->pa_03->RequiredErrorMessage));
			}
		}
		if ($this->qty_pa_03->Required) {
			if (!$this->qty_pa_03->IsDetailKey && $this->qty_pa_03->FormValue != NULL && $this->qty_pa_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pa_03->caption(), $this->qty_pa_03->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pa_03->FormValue)) {
			AddMessage($FormError, $this->qty_pa_03->errorMessage());
		}
		if ($this->pa_04->Required) {
			if (!$this->pa_04->IsDetailKey && $this->pa_04->FormValue != NULL && $this->pa_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pa_04->caption(), $this->pa_04->RequiredErrorMessage));
			}
		}
		if ($this->qty_pa_04->Required) {
			if (!$this->qty_pa_04->IsDetailKey && $this->qty_pa_04->FormValue != NULL && $this->qty_pa_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pa_04->caption(), $this->qty_pa_04->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pa_04->FormValue)) {
			AddMessage($FormError, $this->qty_pa_04->errorMessage());
		}
		if ($this->pa_05->Required) {
			if (!$this->pa_05->IsDetailKey && $this->pa_05->FormValue != NULL && $this->pa_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pa_05->caption(), $this->pa_05->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->pa_05->FormValue)) {
			AddMessage($FormError, $this->pa_05->errorMessage());
		}
		if ($this->qty_pa_05->Required) {
			if (!$this->qty_pa_05->IsDetailKey && $this->qty_pa_05->FormValue != NULL && $this->qty_pa_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pa_05->caption(), $this->qty_pa_05->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pa_05->FormValue)) {
			AddMessage($FormError, $this->qty_pa_05->errorMessage());
		}
		if ($this->pc_01->Required) {
			if (!$this->pc_01->IsDetailKey && $this->pc_01->FormValue != NULL && $this->pc_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_01->caption(), $this->pc_01->RequiredErrorMessage));
			}
		}
		if ($this->qty_pc_01->Required) {
			if (!$this->qty_pc_01->IsDetailKey && $this->qty_pc_01->FormValue != NULL && $this->qty_pc_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pc_01->caption(), $this->qty_pc_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pc_01->FormValue)) {
			AddMessage($FormError, $this->qty_pc_01->errorMessage());
		}
		if ($this->pc_02->Required) {
			if (!$this->pc_02->IsDetailKey && $this->pc_02->FormValue != NULL && $this->pc_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_02->caption(), $this->pc_02->RequiredErrorMessage));
			}
		}
		if ($this->qty_pc_02->Required) {
			if (!$this->qty_pc_02->IsDetailKey && $this->qty_pc_02->FormValue != NULL && $this->qty_pc_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_pc_02->caption(), $this->qty_pc_02->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_pc_02->FormValue)) {
			AddMessage($FormError, $this->qty_pc_02->errorMessage());
		}
		if ($this->o_01->Required) {
			if (!$this->o_01->IsDetailKey && $this->o_01->FormValue != NULL && $this->o_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->o_01->caption(), $this->o_01->RequiredErrorMessage));
			}
		}
		if ($this->qty_o_01->Required) {
			if (!$this->qty_o_01->IsDetailKey && $this->qty_o_01->FormValue != NULL && $this->qty_o_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_o_01->caption(), $this->qty_o_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_o_01->FormValue)) {
			AddMessage($FormError, $this->qty_o_01->errorMessage());
		}
		if ($this->lamination_type->Required) {
			if (!$this->lamination_type->IsDetailKey && $this->lamination_type->FormValue != NULL && $this->lamination_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lamination_type->caption(), $this->lamination_type->RequiredErrorMessage));
			}
		}
		if ($this->lamination_qty->Required) {
			if (!$this->lamination_qty->IsDetailKey && $this->lamination_qty->FormValue != NULL && $this->lamination_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lamination_qty->caption(), $this->lamination_qty->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->lamination_qty->FormValue)) {
			AddMessage($FormError, $this->lamination_qty->errorMessage());
		}
		if ($this->die_type->Required) {
			if (!$this->die_type->IsDetailKey && $this->die_type->FormValue != NULL && $this->die_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->die_type->caption(), $this->die_type->RequiredErrorMessage));
			}
		}
		if ($this->die_qty->Required) {
			if (!$this->die_qty->IsDetailKey && $this->die_qty->FormValue != NULL && $this->die_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->die_qty->caption(), $this->die_qty->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->die_qty->FormValue)) {
			AddMessage($FormError, $this->die_qty->errorMessage());
		}
		if ($this->binding_type->Required) {
			if (!$this->binding_type->IsDetailKey && $this->binding_type->FormValue != NULL && $this->binding_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->binding_type->caption(), $this->binding_type->RequiredErrorMessage));
			}
		}
		if ($this->binding_qty->Required) {
			if (!$this->binding_qty->IsDetailKey && $this->binding_qty->FormValue != NULL && $this->binding_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->binding_qty->caption(), $this->binding_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->binding_qty->FormValue)) {
			AddMessage($FormError, $this->binding_qty->errorMessage());
		}
		if ($this->number_type->Required) {
			if (!$this->number_type->IsDetailKey && $this->number_type->FormValue != NULL && $this->number_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->number_type->caption(), $this->number_type->RequiredErrorMessage));
			}
		}
		if ($this->number_qty->Required) {
			if (!$this->number_qty->IsDetailKey && $this->number_qty->FormValue != NULL && $this->number_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->number_qty->caption(), $this->number_qty->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->number_qty->FormValue)) {
			AddMessage($FormError, $this->number_qty->errorMessage());
		}
		if ($this->de_01->Required) {
			if (!$this->de_01->IsDetailKey && $this->de_01->FormValue != NULL && $this->de_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->de_01->caption(), $this->de_01->RequiredErrorMessage));
			}
		}
		if ($this->qty_de_01->Required) {
			if (!$this->qty_de_01->IsDetailKey && $this->qty_de_01->FormValue != NULL && $this->qty_de_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_de_01->caption(), $this->qty_de_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_de_01->FormValue)) {
			AddMessage($FormError, $this->qty_de_01->errorMessage());
		}
		if ($this->de_02->Required) {
			if (!$this->de_02->IsDetailKey && $this->de_02->FormValue != NULL && $this->de_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->de_02->caption(), $this->de_02->RequiredErrorMessage));
			}
		}
		if ($this->qty_de_02->Required) {
			if (!$this->qty_de_02->IsDetailKey && $this->qty_de_02->FormValue != NULL && $this->qty_de_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_de_02->caption(), $this->qty_de_02->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_de_02->FormValue)) {
			AddMessage($FormError, $this->qty_de_02->errorMessage());
		}
		if ($this->de_03->Required) {
			if (!$this->de_03->IsDetailKey && $this->de_03->FormValue != NULL && $this->de_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->de_03->caption(), $this->de_03->RequiredErrorMessage));
			}
		}
		if ($this->qty_de_03->Required) {
			if (!$this->qty_de_03->IsDetailKey && $this->qty_de_03->FormValue != NULL && $this->qty_de_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty_de_03->caption(), $this->qty_de_03->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->qty_de_03->FormValue)) {
			AddMessage($FormError, $this->qty_de_03->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// job_type
		$this->job_type->setDbValueDef($rsnew, $this->job_type->CurrentValue, 0, strval($this->job_type->CurrentValue) == "");

		// job_category
		$this->job_category->setDbValueDef($rsnew, $this->job_category->CurrentValue, 0, strval($this->job_category->CurrentValue) == "");

		// company_id
		$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, FALSE);

		// description
		$this->description->setDbValueDef($rsnew, $this->description->CurrentValue, NULL, FALSE);

		// size
		$this->size->setDbValueDef($rsnew, $this->size->CurrentValue, "", FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, 0, strval($this->quantity->CurrentValue) == "");

		// pages
		$this->pages->setDbValueDef($rsnew, $this->pages->CurrentValue, "", strval($this->pages->CurrentValue) == "");

		// paper
		$this->paper->setDbValueDef($rsnew, $this->paper->CurrentValue, NULL, strval($this->paper->CurrentValue) == "");

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// pr_01
		$this->pr_01->setDbValueDef($rsnew, $this->pr_01->CurrentValue, NULL, FALSE);

		// qty_pr_01
		$this->qty_pr_01->setDbValueDef($rsnew, $this->qty_pr_01->CurrentValue, 0, strval($this->qty_pr_01->CurrentValue) == "");

		// pl_01
		$this->pl_01->setDbValueDef($rsnew, $this->pl_01->CurrentValue, NULL, FALSE);

		// qty_pl_01
		$this->qty_pl_01->setDbValueDef($rsnew, $this->qty_pl_01->CurrentValue, 0, strval($this->qty_pl_01->CurrentValue) == "");

		// pr_02
		$this->pr_02->setDbValueDef($rsnew, $this->pr_02->CurrentValue, NULL, FALSE);

		// qty_pr_02
		$this->qty_pr_02->setDbValueDef($rsnew, $this->qty_pr_02->CurrentValue, 0, strval($this->qty_pr_02->CurrentValue) == "");

		// pl_02
		$this->pl_02->setDbValueDef($rsnew, $this->pl_02->CurrentValue, NULL, FALSE);

		// qty_pl_02
		$this->qty_pl_02->setDbValueDef($rsnew, $this->qty_pl_02->CurrentValue, 0, strval($this->qty_pl_02->CurrentValue) == "");

		// pr_03
		$this->pr_03->setDbValueDef($rsnew, $this->pr_03->CurrentValue, NULL, FALSE);

		// qty_pr_03
		$this->qty_pr_03->setDbValueDef($rsnew, $this->qty_pr_03->CurrentValue, 0, strval($this->qty_pr_03->CurrentValue) == "");

		// pl_03
		$this->pl_03->setDbValueDef($rsnew, $this->pl_03->CurrentValue, NULL, FALSE);

		// qty_pl_03
		$this->qty_pl_03->setDbValueDef($rsnew, $this->qty_pl_03->CurrentValue, 0, strval($this->qty_pl_03->CurrentValue) == "");

		// pr_04
		$this->pr_04->setDbValueDef($rsnew, $this->pr_04->CurrentValue, NULL, FALSE);

		// qty_pr_04
		$this->qty_pr_04->setDbValueDef($rsnew, $this->qty_pr_04->CurrentValue, 0, strval($this->qty_pr_04->CurrentValue) == "");

		// pl_04
		$this->pl_04->setDbValueDef($rsnew, $this->pl_04->CurrentValue, NULL, FALSE);

		// qty_pl_04
		$this->qty_pl_04->setDbValueDef($rsnew, $this->qty_pl_04->CurrentValue, 0, strval($this->qty_pl_04->CurrentValue) == "");

		// pa_01
		$this->pa_01->setDbValueDef($rsnew, $this->pa_01->CurrentValue, NULL, FALSE);

		// qty_pa_01
		$this->qty_pa_01->setDbValueDef($rsnew, $this->qty_pa_01->CurrentValue, 0, strval($this->qty_pa_01->CurrentValue) == "");

		// pa_02
		$this->pa_02->setDbValueDef($rsnew, $this->pa_02->CurrentValue, NULL, FALSE);

		// qty_pa_02
		$this->qty_pa_02->setDbValueDef($rsnew, $this->qty_pa_02->CurrentValue, 0, strval($this->qty_pa_02->CurrentValue) == "");

		// pa_03
		$this->pa_03->setDbValueDef($rsnew, $this->pa_03->CurrentValue, NULL, FALSE);

		// qty_pa_03
		$this->qty_pa_03->setDbValueDef($rsnew, $this->qty_pa_03->CurrentValue, 0, strval($this->qty_pa_03->CurrentValue) == "");

		// pa_04
		$this->pa_04->setDbValueDef($rsnew, $this->pa_04->CurrentValue, NULL, FALSE);

		// qty_pa_04
		$this->qty_pa_04->setDbValueDef($rsnew, $this->qty_pa_04->CurrentValue, 0, strval($this->qty_pa_04->CurrentValue) == "");

		// pa_05
		$this->pa_05->setDbValueDef($rsnew, $this->pa_05->CurrentValue, NULL, FALSE);

		// qty_pa_05
		$this->qty_pa_05->setDbValueDef($rsnew, $this->qty_pa_05->CurrentValue, 0, strval($this->qty_pa_05->CurrentValue) == "");

		// pc_01
		$this->pc_01->setDbValueDef($rsnew, $this->pc_01->CurrentValue, NULL, FALSE);

		// qty_pc_01
		$this->qty_pc_01->setDbValueDef($rsnew, $this->qty_pc_01->CurrentValue, 0, FALSE);

		// pc_02
		$this->pc_02->setDbValueDef($rsnew, $this->pc_02->CurrentValue, NULL, FALSE);

		// qty_pc_02
		$this->qty_pc_02->setDbValueDef($rsnew, $this->qty_pc_02->CurrentValue, 0, FALSE);

		// o_01
		$this->o_01->setDbValueDef($rsnew, $this->o_01->CurrentValue, NULL, FALSE);

		// qty_o_01
		$this->qty_o_01->setDbValueDef($rsnew, $this->qty_o_01->CurrentValue, 0, FALSE);

		// lamination_type
		$this->lamination_type->setDbValueDef($rsnew, $this->lamination_type->CurrentValue, NULL, FALSE);

		// lamination_qty
		$this->lamination_qty->setDbValueDef($rsnew, $this->lamination_qty->CurrentValue, NULL, FALSE);

		// die_type
		$this->die_type->setDbValueDef($rsnew, $this->die_type->CurrentValue, NULL, FALSE);

		// die_qty
		$this->die_qty->setDbValueDef($rsnew, $this->die_qty->CurrentValue, 0, strval($this->die_qty->CurrentValue) == "");

		// binding_type
		$this->binding_type->setDbValueDef($rsnew, $this->binding_type->CurrentValue, NULL, FALSE);

		// binding_qty
		$this->binding_qty->setDbValueDef($rsnew, $this->binding_qty->CurrentValue, 0, strval($this->binding_qty->CurrentValue) == "");

		// number_type
		$this->number_type->setDbValueDef($rsnew, $this->number_type->CurrentValue, NULL, FALSE);

		// number_qty
		$this->number_qty->setDbValueDef($rsnew, $this->number_qty->CurrentValue, 0, strval($this->number_qty->CurrentValue) == "");

		// de_01
		$this->de_01->setDbValueDef($rsnew, $this->de_01->CurrentValue, NULL, FALSE);

		// qty_de_01
		$this->qty_de_01->setDbValueDef($rsnew, $this->qty_de_01->CurrentValue, 0, strval($this->qty_de_01->CurrentValue) == "");

		// de_02
		$this->de_02->setDbValueDef($rsnew, $this->de_02->CurrentValue, NULL, FALSE);

		// qty_de_02
		$this->qty_de_02->setDbValueDef($rsnew, $this->qty_de_02->CurrentValue, 0, strval($this->qty_de_02->CurrentValue) == "");

		// de_03
		$this->de_03->setDbValueDef($rsnew, $this->de_03->CurrentValue, NULL, FALSE);

		// qty_de_03
		$this->qty_de_03->setDbValueDef($rsnew, $this->qty_de_03->CurrentValue, 0, strval($this->qty_de_03->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("p_eastimatelist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$pages->add(8);
		$pages->add(9);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_size":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_01":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_01":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_02":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_02":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_03":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_03":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_04":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_04":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_01":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_02":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_03":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_04":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_05":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pc_01":
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pc_02":
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_o_01":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_lamination_type":
					$lookupFilter = function() {
						return "`s_grp` IN (123) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_die_type":
					$lookupFilter = function() {
						return "`s_grp` IN (124) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_binding_type":
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_number_type":
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_01":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_02":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_03":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_size":
							break;
						case "x_pr_01":
							break;
						case "x_pl_01":
							break;
						case "x_pr_02":
							break;
						case "x_pl_02":
							break;
						case "x_pr_03":
							break;
						case "x_pl_03":
							break;
						case "x_pr_04":
							break;
						case "x_pl_04":
							break;
						case "x_pa_01":
							break;
						case "x_pa_02":
							break;
						case "x_pa_03":
							break;
						case "x_pa_04":
							break;
						case "x_pa_05":
							break;
						case "x_pc_01":
							break;
						case "x_pc_02":
							break;
						case "x_o_01":
							break;
						case "x_lamination_type":
							break;
						case "x_die_type":
							break;
						case "x_binding_type":
							break;
						case "x_number_type":
							break;
						case "x_de_01":
							break;
						case "x_de_02":
							break;
						case "x_de_03":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>