<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class p_eastimate_list extends p_eastimate
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'p_eastimate';

	// Page object name
	public $PageObjName = "p_eastimate_list";

	// Grid form hidden field names
	public $FormName = "fp_eastimatelist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (p_eastimate)
		if (!isset($GLOBALS["p_eastimate"]) || get_class($GLOBALS["p_eastimate"]) == PROJECT_NAMESPACE . "p_eastimate") {
			$GLOBALS["p_eastimate"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["p_eastimate"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "p_eastimateadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "p_eastimatedelete.php";
		$this->MultiUpdateUrl = "p_eastimateupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_eastimate');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fp_eastimatelistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $p_eastimate;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($p_eastimate);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->job_type->setVisibility();
		$this->job_category->setVisibility();
		$this->company_id->setVisibility();
		$this->description->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->pages->setVisibility();
		$this->paper->setVisibility();
		$this->remarks->setVisibility();
		$this->pr_01->setVisibility();
		$this->qty_pr_01->setVisibility();
		$this->pl_01->setVisibility();
		$this->qty_pl_01->setVisibility();
		$this->pr_02->setVisibility();
		$this->qty_pr_02->setVisibility();
		$this->pl_02->setVisibility();
		$this->qty_pl_02->setVisibility();
		$this->pr_03->setVisibility();
		$this->qty_pr_03->setVisibility();
		$this->pl_03->setVisibility();
		$this->qty_pl_03->setVisibility();
		$this->pr_04->setVisibility();
		$this->qty_pr_04->setVisibility();
		$this->pl_04->setVisibility();
		$this->qty_pl_04->setVisibility();
		$this->pa_01->setVisibility();
		$this->qty_pa_01->setVisibility();
		$this->pa_02->setVisibility();
		$this->qty_pa_02->setVisibility();
		$this->pa_03->setVisibility();
		$this->qty_pa_03->setVisibility();
		$this->pa_04->setVisibility();
		$this->qty_pa_04->setVisibility();
		$this->pa_05->setVisibility();
		$this->qty_pa_05->setVisibility();
		$this->pc_01->setVisibility();
		$this->qty_pc_01->setVisibility();
		$this->pc_02->setVisibility();
		$this->qty_pc_02->setVisibility();
		$this->o_01->setVisibility();
		$this->qty_o_01->setVisibility();
		$this->lamination_type->setVisibility();
		$this->lamination_qty->setVisibility();
		$this->die_type->setVisibility();
		$this->die_qty->setVisibility();
		$this->binding_type->setVisibility();
		$this->binding_qty->setVisibility();
		$this->number_type->setVisibility();
		$this->number_qty->setVisibility();
		$this->de_01->setVisibility();
		$this->qty_de_01->setVisibility();
		$this->de_02->setVisibility();
		$this->qty_de_02->setVisibility();
		$this->de_03->setVisibility();
		$this->qty_de_03->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->size);
		$this->setupLookupOptions($this->pr_01);
		$this->setupLookupOptions($this->pl_01);
		$this->setupLookupOptions($this->pr_02);
		$this->setupLookupOptions($this->pl_02);
		$this->setupLookupOptions($this->pr_03);
		$this->setupLookupOptions($this->pl_03);
		$this->setupLookupOptions($this->pr_04);
		$this->setupLookupOptions($this->pl_04);
		$this->setupLookupOptions($this->pa_01);
		$this->setupLookupOptions($this->pa_02);
		$this->setupLookupOptions($this->pa_03);
		$this->setupLookupOptions($this->pa_04);
		$this->setupLookupOptions($this->pa_05);
		$this->setupLookupOptions($this->pc_01);
		$this->setupLookupOptions($this->pc_02);
		$this->setupLookupOptions($this->o_01);
		$this->setupLookupOptions($this->lamination_type);
		$this->setupLookupOptions($this->die_type);
		$this->setupLookupOptions($this->binding_type);
		$this->setupLookupOptions($this->number_type);
		$this->setupLookupOptions($this->de_01);
		$this->setupLookupOptions($this->de_02);
		$this->setupLookupOptions($this->de_03);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fp_eastimatelistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->job_type->AdvancedSearch->toJson(), ","); // Field job_type
		$filterList = Concat($filterList, $this->job_category->AdvancedSearch->toJson(), ","); // Field job_category
		$filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
		$filterList = Concat($filterList, $this->description->AdvancedSearch->toJson(), ","); // Field description
		$filterList = Concat($filterList, $this->size->AdvancedSearch->toJson(), ","); // Field size
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->pages->AdvancedSearch->toJson(), ","); // Field pages
		$filterList = Concat($filterList, $this->paper->AdvancedSearch->toJson(), ","); // Field paper
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->pr_01->AdvancedSearch->toJson(), ","); // Field pr_01
		$filterList = Concat($filterList, $this->qty_pr_01->AdvancedSearch->toJson(), ","); // Field qty_pr_01
		$filterList = Concat($filterList, $this->pl_01->AdvancedSearch->toJson(), ","); // Field pl_01
		$filterList = Concat($filterList, $this->qty_pl_01->AdvancedSearch->toJson(), ","); // Field qty_pl_01
		$filterList = Concat($filterList, $this->pr_02->AdvancedSearch->toJson(), ","); // Field pr_02
		$filterList = Concat($filterList, $this->qty_pr_02->AdvancedSearch->toJson(), ","); // Field qty_pr_02
		$filterList = Concat($filterList, $this->pl_02->AdvancedSearch->toJson(), ","); // Field pl_02
		$filterList = Concat($filterList, $this->qty_pl_02->AdvancedSearch->toJson(), ","); // Field qty_pl_02
		$filterList = Concat($filterList, $this->pr_03->AdvancedSearch->toJson(), ","); // Field pr_03
		$filterList = Concat($filterList, $this->qty_pr_03->AdvancedSearch->toJson(), ","); // Field qty_pr_03
		$filterList = Concat($filterList, $this->pl_03->AdvancedSearch->toJson(), ","); // Field pl_03
		$filterList = Concat($filterList, $this->qty_pl_03->AdvancedSearch->toJson(), ","); // Field qty_pl_03
		$filterList = Concat($filterList, $this->pr_04->AdvancedSearch->toJson(), ","); // Field pr_04
		$filterList = Concat($filterList, $this->qty_pr_04->AdvancedSearch->toJson(), ","); // Field qty_pr_04
		$filterList = Concat($filterList, $this->pl_04->AdvancedSearch->toJson(), ","); // Field pl_04
		$filterList = Concat($filterList, $this->qty_pl_04->AdvancedSearch->toJson(), ","); // Field qty_pl_04
		$filterList = Concat($filterList, $this->pa_01->AdvancedSearch->toJson(), ","); // Field pa_01
		$filterList = Concat($filterList, $this->qty_pa_01->AdvancedSearch->toJson(), ","); // Field qty_pa_01
		$filterList = Concat($filterList, $this->pa_02->AdvancedSearch->toJson(), ","); // Field pa_02
		$filterList = Concat($filterList, $this->qty_pa_02->AdvancedSearch->toJson(), ","); // Field qty_pa_02
		$filterList = Concat($filterList, $this->pa_03->AdvancedSearch->toJson(), ","); // Field pa_03
		$filterList = Concat($filterList, $this->qty_pa_03->AdvancedSearch->toJson(), ","); // Field qty_pa_03
		$filterList = Concat($filterList, $this->pa_04->AdvancedSearch->toJson(), ","); // Field pa_04
		$filterList = Concat($filterList, $this->qty_pa_04->AdvancedSearch->toJson(), ","); // Field qty_pa_04
		$filterList = Concat($filterList, $this->pa_05->AdvancedSearch->toJson(), ","); // Field pa_05
		$filterList = Concat($filterList, $this->qty_pa_05->AdvancedSearch->toJson(), ","); // Field qty_pa_05
		$filterList = Concat($filterList, $this->pc_01->AdvancedSearch->toJson(), ","); // Field pc_01
		$filterList = Concat($filterList, $this->qty_pc_01->AdvancedSearch->toJson(), ","); // Field qty_pc_01
		$filterList = Concat($filterList, $this->pc_02->AdvancedSearch->toJson(), ","); // Field pc_02
		$filterList = Concat($filterList, $this->qty_pc_02->AdvancedSearch->toJson(), ","); // Field qty_pc_02
		$filterList = Concat($filterList, $this->o_01->AdvancedSearch->toJson(), ","); // Field o_01
		$filterList = Concat($filterList, $this->qty_o_01->AdvancedSearch->toJson(), ","); // Field qty_o_01
		$filterList = Concat($filterList, $this->lamination_type->AdvancedSearch->toJson(), ","); // Field lamination_type
		$filterList = Concat($filterList, $this->lamination_qty->AdvancedSearch->toJson(), ","); // Field lamination_qty
		$filterList = Concat($filterList, $this->die_type->AdvancedSearch->toJson(), ","); // Field die_type
		$filterList = Concat($filterList, $this->die_qty->AdvancedSearch->toJson(), ","); // Field die_qty
		$filterList = Concat($filterList, $this->binding_type->AdvancedSearch->toJson(), ","); // Field binding_type
		$filterList = Concat($filterList, $this->binding_qty->AdvancedSearch->toJson(), ","); // Field binding_qty
		$filterList = Concat($filterList, $this->number_type->AdvancedSearch->toJson(), ","); // Field number_type
		$filterList = Concat($filterList, $this->number_qty->AdvancedSearch->toJson(), ","); // Field number_qty
		$filterList = Concat($filterList, $this->de_01->AdvancedSearch->toJson(), ","); // Field de_01
		$filterList = Concat($filterList, $this->qty_de_01->AdvancedSearch->toJson(), ","); // Field qty_de_01
		$filterList = Concat($filterList, $this->de_02->AdvancedSearch->toJson(), ","); // Field de_02
		$filterList = Concat($filterList, $this->qty_de_02->AdvancedSearch->toJson(), ","); // Field qty_de_02
		$filterList = Concat($filterList, $this->de_03->AdvancedSearch->toJson(), ","); // Field de_03
		$filterList = Concat($filterList, $this->qty_de_03->AdvancedSearch->toJson(), ","); // Field qty_de_03
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fp_eastimatelistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field job_type
		$this->job_type->AdvancedSearch->SearchValue = @$filter["x_job_type"];
		$this->job_type->AdvancedSearch->SearchOperator = @$filter["z_job_type"];
		$this->job_type->AdvancedSearch->SearchCondition = @$filter["v_job_type"];
		$this->job_type->AdvancedSearch->SearchValue2 = @$filter["y_job_type"];
		$this->job_type->AdvancedSearch->SearchOperator2 = @$filter["w_job_type"];
		$this->job_type->AdvancedSearch->save();

		// Field job_category
		$this->job_category->AdvancedSearch->SearchValue = @$filter["x_job_category"];
		$this->job_category->AdvancedSearch->SearchOperator = @$filter["z_job_category"];
		$this->job_category->AdvancedSearch->SearchCondition = @$filter["v_job_category"];
		$this->job_category->AdvancedSearch->SearchValue2 = @$filter["y_job_category"];
		$this->job_category->AdvancedSearch->SearchOperator2 = @$filter["w_job_category"];
		$this->job_category->AdvancedSearch->save();

		// Field company_id
		$this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
		$this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
		$this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
		$this->company_id->AdvancedSearch->save();

		// Field description
		$this->description->AdvancedSearch->SearchValue = @$filter["x_description"];
		$this->description->AdvancedSearch->SearchOperator = @$filter["z_description"];
		$this->description->AdvancedSearch->SearchCondition = @$filter["v_description"];
		$this->description->AdvancedSearch->SearchValue2 = @$filter["y_description"];
		$this->description->AdvancedSearch->SearchOperator2 = @$filter["w_description"];
		$this->description->AdvancedSearch->save();

		// Field size
		$this->size->AdvancedSearch->SearchValue = @$filter["x_size"];
		$this->size->AdvancedSearch->SearchOperator = @$filter["z_size"];
		$this->size->AdvancedSearch->SearchCondition = @$filter["v_size"];
		$this->size->AdvancedSearch->SearchValue2 = @$filter["y_size"];
		$this->size->AdvancedSearch->SearchOperator2 = @$filter["w_size"];
		$this->size->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field pages
		$this->pages->AdvancedSearch->SearchValue = @$filter["x_pages"];
		$this->pages->AdvancedSearch->SearchOperator = @$filter["z_pages"];
		$this->pages->AdvancedSearch->SearchCondition = @$filter["v_pages"];
		$this->pages->AdvancedSearch->SearchValue2 = @$filter["y_pages"];
		$this->pages->AdvancedSearch->SearchOperator2 = @$filter["w_pages"];
		$this->pages->AdvancedSearch->save();

		// Field paper
		$this->paper->AdvancedSearch->SearchValue = @$filter["x_paper"];
		$this->paper->AdvancedSearch->SearchOperator = @$filter["z_paper"];
		$this->paper->AdvancedSearch->SearchCondition = @$filter["v_paper"];
		$this->paper->AdvancedSearch->SearchValue2 = @$filter["y_paper"];
		$this->paper->AdvancedSearch->SearchOperator2 = @$filter["w_paper"];
		$this->paper->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field pr_01
		$this->pr_01->AdvancedSearch->SearchValue = @$filter["x_pr_01"];
		$this->pr_01->AdvancedSearch->SearchOperator = @$filter["z_pr_01"];
		$this->pr_01->AdvancedSearch->SearchCondition = @$filter["v_pr_01"];
		$this->pr_01->AdvancedSearch->SearchValue2 = @$filter["y_pr_01"];
		$this->pr_01->AdvancedSearch->SearchOperator2 = @$filter["w_pr_01"];
		$this->pr_01->AdvancedSearch->save();

		// Field qty_pr_01
		$this->qty_pr_01->AdvancedSearch->SearchValue = @$filter["x_qty_pr_01"];
		$this->qty_pr_01->AdvancedSearch->SearchOperator = @$filter["z_qty_pr_01"];
		$this->qty_pr_01->AdvancedSearch->SearchCondition = @$filter["v_qty_pr_01"];
		$this->qty_pr_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_pr_01"];
		$this->qty_pr_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pr_01"];
		$this->qty_pr_01->AdvancedSearch->save();

		// Field pl_01
		$this->pl_01->AdvancedSearch->SearchValue = @$filter["x_pl_01"];
		$this->pl_01->AdvancedSearch->SearchOperator = @$filter["z_pl_01"];
		$this->pl_01->AdvancedSearch->SearchCondition = @$filter["v_pl_01"];
		$this->pl_01->AdvancedSearch->SearchValue2 = @$filter["y_pl_01"];
		$this->pl_01->AdvancedSearch->SearchOperator2 = @$filter["w_pl_01"];
		$this->pl_01->AdvancedSearch->save();

		// Field qty_pl_01
		$this->qty_pl_01->AdvancedSearch->SearchValue = @$filter["x_qty_pl_01"];
		$this->qty_pl_01->AdvancedSearch->SearchOperator = @$filter["z_qty_pl_01"];
		$this->qty_pl_01->AdvancedSearch->SearchCondition = @$filter["v_qty_pl_01"];
		$this->qty_pl_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_pl_01"];
		$this->qty_pl_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pl_01"];
		$this->qty_pl_01->AdvancedSearch->save();

		// Field pr_02
		$this->pr_02->AdvancedSearch->SearchValue = @$filter["x_pr_02"];
		$this->pr_02->AdvancedSearch->SearchOperator = @$filter["z_pr_02"];
		$this->pr_02->AdvancedSearch->SearchCondition = @$filter["v_pr_02"];
		$this->pr_02->AdvancedSearch->SearchValue2 = @$filter["y_pr_02"];
		$this->pr_02->AdvancedSearch->SearchOperator2 = @$filter["w_pr_02"];
		$this->pr_02->AdvancedSearch->save();

		// Field qty_pr_02
		$this->qty_pr_02->AdvancedSearch->SearchValue = @$filter["x_qty_pr_02"];
		$this->qty_pr_02->AdvancedSearch->SearchOperator = @$filter["z_qty_pr_02"];
		$this->qty_pr_02->AdvancedSearch->SearchCondition = @$filter["v_qty_pr_02"];
		$this->qty_pr_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_pr_02"];
		$this->qty_pr_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pr_02"];
		$this->qty_pr_02->AdvancedSearch->save();

		// Field pl_02
		$this->pl_02->AdvancedSearch->SearchValue = @$filter["x_pl_02"];
		$this->pl_02->AdvancedSearch->SearchOperator = @$filter["z_pl_02"];
		$this->pl_02->AdvancedSearch->SearchCondition = @$filter["v_pl_02"];
		$this->pl_02->AdvancedSearch->SearchValue2 = @$filter["y_pl_02"];
		$this->pl_02->AdvancedSearch->SearchOperator2 = @$filter["w_pl_02"];
		$this->pl_02->AdvancedSearch->save();

		// Field qty_pl_02
		$this->qty_pl_02->AdvancedSearch->SearchValue = @$filter["x_qty_pl_02"];
		$this->qty_pl_02->AdvancedSearch->SearchOperator = @$filter["z_qty_pl_02"];
		$this->qty_pl_02->AdvancedSearch->SearchCondition = @$filter["v_qty_pl_02"];
		$this->qty_pl_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_pl_02"];
		$this->qty_pl_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pl_02"];
		$this->qty_pl_02->AdvancedSearch->save();

		// Field pr_03
		$this->pr_03->AdvancedSearch->SearchValue = @$filter["x_pr_03"];
		$this->pr_03->AdvancedSearch->SearchOperator = @$filter["z_pr_03"];
		$this->pr_03->AdvancedSearch->SearchCondition = @$filter["v_pr_03"];
		$this->pr_03->AdvancedSearch->SearchValue2 = @$filter["y_pr_03"];
		$this->pr_03->AdvancedSearch->SearchOperator2 = @$filter["w_pr_03"];
		$this->pr_03->AdvancedSearch->save();

		// Field qty_pr_03
		$this->qty_pr_03->AdvancedSearch->SearchValue = @$filter["x_qty_pr_03"];
		$this->qty_pr_03->AdvancedSearch->SearchOperator = @$filter["z_qty_pr_03"];
		$this->qty_pr_03->AdvancedSearch->SearchCondition = @$filter["v_qty_pr_03"];
		$this->qty_pr_03->AdvancedSearch->SearchValue2 = @$filter["y_qty_pr_03"];
		$this->qty_pr_03->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pr_03"];
		$this->qty_pr_03->AdvancedSearch->save();

		// Field pl_03
		$this->pl_03->AdvancedSearch->SearchValue = @$filter["x_pl_03"];
		$this->pl_03->AdvancedSearch->SearchOperator = @$filter["z_pl_03"];
		$this->pl_03->AdvancedSearch->SearchCondition = @$filter["v_pl_03"];
		$this->pl_03->AdvancedSearch->SearchValue2 = @$filter["y_pl_03"];
		$this->pl_03->AdvancedSearch->SearchOperator2 = @$filter["w_pl_03"];
		$this->pl_03->AdvancedSearch->save();

		// Field qty_pl_03
		$this->qty_pl_03->AdvancedSearch->SearchValue = @$filter["x_qty_pl_03"];
		$this->qty_pl_03->AdvancedSearch->SearchOperator = @$filter["z_qty_pl_03"];
		$this->qty_pl_03->AdvancedSearch->SearchCondition = @$filter["v_qty_pl_03"];
		$this->qty_pl_03->AdvancedSearch->SearchValue2 = @$filter["y_qty_pl_03"];
		$this->qty_pl_03->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pl_03"];
		$this->qty_pl_03->AdvancedSearch->save();

		// Field pr_04
		$this->pr_04->AdvancedSearch->SearchValue = @$filter["x_pr_04"];
		$this->pr_04->AdvancedSearch->SearchOperator = @$filter["z_pr_04"];
		$this->pr_04->AdvancedSearch->SearchCondition = @$filter["v_pr_04"];
		$this->pr_04->AdvancedSearch->SearchValue2 = @$filter["y_pr_04"];
		$this->pr_04->AdvancedSearch->SearchOperator2 = @$filter["w_pr_04"];
		$this->pr_04->AdvancedSearch->save();

		// Field qty_pr_04
		$this->qty_pr_04->AdvancedSearch->SearchValue = @$filter["x_qty_pr_04"];
		$this->qty_pr_04->AdvancedSearch->SearchOperator = @$filter["z_qty_pr_04"];
		$this->qty_pr_04->AdvancedSearch->SearchCondition = @$filter["v_qty_pr_04"];
		$this->qty_pr_04->AdvancedSearch->SearchValue2 = @$filter["y_qty_pr_04"];
		$this->qty_pr_04->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pr_04"];
		$this->qty_pr_04->AdvancedSearch->save();

		// Field pl_04
		$this->pl_04->AdvancedSearch->SearchValue = @$filter["x_pl_04"];
		$this->pl_04->AdvancedSearch->SearchOperator = @$filter["z_pl_04"];
		$this->pl_04->AdvancedSearch->SearchCondition = @$filter["v_pl_04"];
		$this->pl_04->AdvancedSearch->SearchValue2 = @$filter["y_pl_04"];
		$this->pl_04->AdvancedSearch->SearchOperator2 = @$filter["w_pl_04"];
		$this->pl_04->AdvancedSearch->save();

		// Field qty_pl_04
		$this->qty_pl_04->AdvancedSearch->SearchValue = @$filter["x_qty_pl_04"];
		$this->qty_pl_04->AdvancedSearch->SearchOperator = @$filter["z_qty_pl_04"];
		$this->qty_pl_04->AdvancedSearch->SearchCondition = @$filter["v_qty_pl_04"];
		$this->qty_pl_04->AdvancedSearch->SearchValue2 = @$filter["y_qty_pl_04"];
		$this->qty_pl_04->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pl_04"];
		$this->qty_pl_04->AdvancedSearch->save();

		// Field pa_01
		$this->pa_01->AdvancedSearch->SearchValue = @$filter["x_pa_01"];
		$this->pa_01->AdvancedSearch->SearchOperator = @$filter["z_pa_01"];
		$this->pa_01->AdvancedSearch->SearchCondition = @$filter["v_pa_01"];
		$this->pa_01->AdvancedSearch->SearchValue2 = @$filter["y_pa_01"];
		$this->pa_01->AdvancedSearch->SearchOperator2 = @$filter["w_pa_01"];
		$this->pa_01->AdvancedSearch->save();

		// Field qty_pa_01
		$this->qty_pa_01->AdvancedSearch->SearchValue = @$filter["x_qty_pa_01"];
		$this->qty_pa_01->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_01"];
		$this->qty_pa_01->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_01"];
		$this->qty_pa_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_01"];
		$this->qty_pa_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_01"];
		$this->qty_pa_01->AdvancedSearch->save();

		// Field pa_02
		$this->pa_02->AdvancedSearch->SearchValue = @$filter["x_pa_02"];
		$this->pa_02->AdvancedSearch->SearchOperator = @$filter["z_pa_02"];
		$this->pa_02->AdvancedSearch->SearchCondition = @$filter["v_pa_02"];
		$this->pa_02->AdvancedSearch->SearchValue2 = @$filter["y_pa_02"];
		$this->pa_02->AdvancedSearch->SearchOperator2 = @$filter["w_pa_02"];
		$this->pa_02->AdvancedSearch->save();

		// Field qty_pa_02
		$this->qty_pa_02->AdvancedSearch->SearchValue = @$filter["x_qty_pa_02"];
		$this->qty_pa_02->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_02"];
		$this->qty_pa_02->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_02"];
		$this->qty_pa_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_02"];
		$this->qty_pa_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_02"];
		$this->qty_pa_02->AdvancedSearch->save();

		// Field pa_03
		$this->pa_03->AdvancedSearch->SearchValue = @$filter["x_pa_03"];
		$this->pa_03->AdvancedSearch->SearchOperator = @$filter["z_pa_03"];
		$this->pa_03->AdvancedSearch->SearchCondition = @$filter["v_pa_03"];
		$this->pa_03->AdvancedSearch->SearchValue2 = @$filter["y_pa_03"];
		$this->pa_03->AdvancedSearch->SearchOperator2 = @$filter["w_pa_03"];
		$this->pa_03->AdvancedSearch->save();

		// Field qty_pa_03
		$this->qty_pa_03->AdvancedSearch->SearchValue = @$filter["x_qty_pa_03"];
		$this->qty_pa_03->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_03"];
		$this->qty_pa_03->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_03"];
		$this->qty_pa_03->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_03"];
		$this->qty_pa_03->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_03"];
		$this->qty_pa_03->AdvancedSearch->save();

		// Field pa_04
		$this->pa_04->AdvancedSearch->SearchValue = @$filter["x_pa_04"];
		$this->pa_04->AdvancedSearch->SearchOperator = @$filter["z_pa_04"];
		$this->pa_04->AdvancedSearch->SearchCondition = @$filter["v_pa_04"];
		$this->pa_04->AdvancedSearch->SearchValue2 = @$filter["y_pa_04"];
		$this->pa_04->AdvancedSearch->SearchOperator2 = @$filter["w_pa_04"];
		$this->pa_04->AdvancedSearch->save();

		// Field qty_pa_04
		$this->qty_pa_04->AdvancedSearch->SearchValue = @$filter["x_qty_pa_04"];
		$this->qty_pa_04->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_04"];
		$this->qty_pa_04->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_04"];
		$this->qty_pa_04->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_04"];
		$this->qty_pa_04->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_04"];
		$this->qty_pa_04->AdvancedSearch->save();

		// Field pa_05
		$this->pa_05->AdvancedSearch->SearchValue = @$filter["x_pa_05"];
		$this->pa_05->AdvancedSearch->SearchOperator = @$filter["z_pa_05"];
		$this->pa_05->AdvancedSearch->SearchCondition = @$filter["v_pa_05"];
		$this->pa_05->AdvancedSearch->SearchValue2 = @$filter["y_pa_05"];
		$this->pa_05->AdvancedSearch->SearchOperator2 = @$filter["w_pa_05"];
		$this->pa_05->AdvancedSearch->save();

		// Field qty_pa_05
		$this->qty_pa_05->AdvancedSearch->SearchValue = @$filter["x_qty_pa_05"];
		$this->qty_pa_05->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_05"];
		$this->qty_pa_05->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_05"];
		$this->qty_pa_05->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_05"];
		$this->qty_pa_05->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_05"];
		$this->qty_pa_05->AdvancedSearch->save();

		// Field pc_01
		$this->pc_01->AdvancedSearch->SearchValue = @$filter["x_pc_01"];
		$this->pc_01->AdvancedSearch->SearchOperator = @$filter["z_pc_01"];
		$this->pc_01->AdvancedSearch->SearchCondition = @$filter["v_pc_01"];
		$this->pc_01->AdvancedSearch->SearchValue2 = @$filter["y_pc_01"];
		$this->pc_01->AdvancedSearch->SearchOperator2 = @$filter["w_pc_01"];
		$this->pc_01->AdvancedSearch->save();

		// Field qty_pc_01
		$this->qty_pc_01->AdvancedSearch->SearchValue = @$filter["x_qty_pc_01"];
		$this->qty_pc_01->AdvancedSearch->SearchOperator = @$filter["z_qty_pc_01"];
		$this->qty_pc_01->AdvancedSearch->SearchCondition = @$filter["v_qty_pc_01"];
		$this->qty_pc_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_pc_01"];
		$this->qty_pc_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pc_01"];
		$this->qty_pc_01->AdvancedSearch->save();

		// Field pc_02
		$this->pc_02->AdvancedSearch->SearchValue = @$filter["x_pc_02"];
		$this->pc_02->AdvancedSearch->SearchOperator = @$filter["z_pc_02"];
		$this->pc_02->AdvancedSearch->SearchCondition = @$filter["v_pc_02"];
		$this->pc_02->AdvancedSearch->SearchValue2 = @$filter["y_pc_02"];
		$this->pc_02->AdvancedSearch->SearchOperator2 = @$filter["w_pc_02"];
		$this->pc_02->AdvancedSearch->save();

		// Field qty_pc_02
		$this->qty_pc_02->AdvancedSearch->SearchValue = @$filter["x_qty_pc_02"];
		$this->qty_pc_02->AdvancedSearch->SearchOperator = @$filter["z_qty_pc_02"];
		$this->qty_pc_02->AdvancedSearch->SearchCondition = @$filter["v_qty_pc_02"];
		$this->qty_pc_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_pc_02"];
		$this->qty_pc_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pc_02"];
		$this->qty_pc_02->AdvancedSearch->save();

		// Field o_01
		$this->o_01->AdvancedSearch->SearchValue = @$filter["x_o_01"];
		$this->o_01->AdvancedSearch->SearchOperator = @$filter["z_o_01"];
		$this->o_01->AdvancedSearch->SearchCondition = @$filter["v_o_01"];
		$this->o_01->AdvancedSearch->SearchValue2 = @$filter["y_o_01"];
		$this->o_01->AdvancedSearch->SearchOperator2 = @$filter["w_o_01"];
		$this->o_01->AdvancedSearch->save();

		// Field qty_o_01
		$this->qty_o_01->AdvancedSearch->SearchValue = @$filter["x_qty_o_01"];
		$this->qty_o_01->AdvancedSearch->SearchOperator = @$filter["z_qty_o_01"];
		$this->qty_o_01->AdvancedSearch->SearchCondition = @$filter["v_qty_o_01"];
		$this->qty_o_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_o_01"];
		$this->qty_o_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_o_01"];
		$this->qty_o_01->AdvancedSearch->save();

		// Field lamination_type
		$this->lamination_type->AdvancedSearch->SearchValue = @$filter["x_lamination_type"];
		$this->lamination_type->AdvancedSearch->SearchOperator = @$filter["z_lamination_type"];
		$this->lamination_type->AdvancedSearch->SearchCondition = @$filter["v_lamination_type"];
		$this->lamination_type->AdvancedSearch->SearchValue2 = @$filter["y_lamination_type"];
		$this->lamination_type->AdvancedSearch->SearchOperator2 = @$filter["w_lamination_type"];
		$this->lamination_type->AdvancedSearch->save();

		// Field lamination_qty
		$this->lamination_qty->AdvancedSearch->SearchValue = @$filter["x_lamination_qty"];
		$this->lamination_qty->AdvancedSearch->SearchOperator = @$filter["z_lamination_qty"];
		$this->lamination_qty->AdvancedSearch->SearchCondition = @$filter["v_lamination_qty"];
		$this->lamination_qty->AdvancedSearch->SearchValue2 = @$filter["y_lamination_qty"];
		$this->lamination_qty->AdvancedSearch->SearchOperator2 = @$filter["w_lamination_qty"];
		$this->lamination_qty->AdvancedSearch->save();

		// Field die_type
		$this->die_type->AdvancedSearch->SearchValue = @$filter["x_die_type"];
		$this->die_type->AdvancedSearch->SearchOperator = @$filter["z_die_type"];
		$this->die_type->AdvancedSearch->SearchCondition = @$filter["v_die_type"];
		$this->die_type->AdvancedSearch->SearchValue2 = @$filter["y_die_type"];
		$this->die_type->AdvancedSearch->SearchOperator2 = @$filter["w_die_type"];
		$this->die_type->AdvancedSearch->save();

		// Field die_qty
		$this->die_qty->AdvancedSearch->SearchValue = @$filter["x_die_qty"];
		$this->die_qty->AdvancedSearch->SearchOperator = @$filter["z_die_qty"];
		$this->die_qty->AdvancedSearch->SearchCondition = @$filter["v_die_qty"];
		$this->die_qty->AdvancedSearch->SearchValue2 = @$filter["y_die_qty"];
		$this->die_qty->AdvancedSearch->SearchOperator2 = @$filter["w_die_qty"];
		$this->die_qty->AdvancedSearch->save();

		// Field binding_type
		$this->binding_type->AdvancedSearch->SearchValue = @$filter["x_binding_type"];
		$this->binding_type->AdvancedSearch->SearchOperator = @$filter["z_binding_type"];
		$this->binding_type->AdvancedSearch->SearchCondition = @$filter["v_binding_type"];
		$this->binding_type->AdvancedSearch->SearchValue2 = @$filter["y_binding_type"];
		$this->binding_type->AdvancedSearch->SearchOperator2 = @$filter["w_binding_type"];
		$this->binding_type->AdvancedSearch->save();

		// Field binding_qty
		$this->binding_qty->AdvancedSearch->SearchValue = @$filter["x_binding_qty"];
		$this->binding_qty->AdvancedSearch->SearchOperator = @$filter["z_binding_qty"];
		$this->binding_qty->AdvancedSearch->SearchCondition = @$filter["v_binding_qty"];
		$this->binding_qty->AdvancedSearch->SearchValue2 = @$filter["y_binding_qty"];
		$this->binding_qty->AdvancedSearch->SearchOperator2 = @$filter["w_binding_qty"];
		$this->binding_qty->AdvancedSearch->save();

		// Field number_type
		$this->number_type->AdvancedSearch->SearchValue = @$filter["x_number_type"];
		$this->number_type->AdvancedSearch->SearchOperator = @$filter["z_number_type"];
		$this->number_type->AdvancedSearch->SearchCondition = @$filter["v_number_type"];
		$this->number_type->AdvancedSearch->SearchValue2 = @$filter["y_number_type"];
		$this->number_type->AdvancedSearch->SearchOperator2 = @$filter["w_number_type"];
		$this->number_type->AdvancedSearch->save();

		// Field number_qty
		$this->number_qty->AdvancedSearch->SearchValue = @$filter["x_number_qty"];
		$this->number_qty->AdvancedSearch->SearchOperator = @$filter["z_number_qty"];
		$this->number_qty->AdvancedSearch->SearchCondition = @$filter["v_number_qty"];
		$this->number_qty->AdvancedSearch->SearchValue2 = @$filter["y_number_qty"];
		$this->number_qty->AdvancedSearch->SearchOperator2 = @$filter["w_number_qty"];
		$this->number_qty->AdvancedSearch->save();

		// Field de_01
		$this->de_01->AdvancedSearch->SearchValue = @$filter["x_de_01"];
		$this->de_01->AdvancedSearch->SearchOperator = @$filter["z_de_01"];
		$this->de_01->AdvancedSearch->SearchCondition = @$filter["v_de_01"];
		$this->de_01->AdvancedSearch->SearchValue2 = @$filter["y_de_01"];
		$this->de_01->AdvancedSearch->SearchOperator2 = @$filter["w_de_01"];
		$this->de_01->AdvancedSearch->save();

		// Field qty_de_01
		$this->qty_de_01->AdvancedSearch->SearchValue = @$filter["x_qty_de_01"];
		$this->qty_de_01->AdvancedSearch->SearchOperator = @$filter["z_qty_de_01"];
		$this->qty_de_01->AdvancedSearch->SearchCondition = @$filter["v_qty_de_01"];
		$this->qty_de_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_de_01"];
		$this->qty_de_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_de_01"];
		$this->qty_de_01->AdvancedSearch->save();

		// Field de_02
		$this->de_02->AdvancedSearch->SearchValue = @$filter["x_de_02"];
		$this->de_02->AdvancedSearch->SearchOperator = @$filter["z_de_02"];
		$this->de_02->AdvancedSearch->SearchCondition = @$filter["v_de_02"];
		$this->de_02->AdvancedSearch->SearchValue2 = @$filter["y_de_02"];
		$this->de_02->AdvancedSearch->SearchOperator2 = @$filter["w_de_02"];
		$this->de_02->AdvancedSearch->save();

		// Field qty_de_02
		$this->qty_de_02->AdvancedSearch->SearchValue = @$filter["x_qty_de_02"];
		$this->qty_de_02->AdvancedSearch->SearchOperator = @$filter["z_qty_de_02"];
		$this->qty_de_02->AdvancedSearch->SearchCondition = @$filter["v_qty_de_02"];
		$this->qty_de_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_de_02"];
		$this->qty_de_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_de_02"];
		$this->qty_de_02->AdvancedSearch->save();

		// Field de_03
		$this->de_03->AdvancedSearch->SearchValue = @$filter["x_de_03"];
		$this->de_03->AdvancedSearch->SearchOperator = @$filter["z_de_03"];
		$this->de_03->AdvancedSearch->SearchCondition = @$filter["v_de_03"];
		$this->de_03->AdvancedSearch->SearchValue2 = @$filter["y_de_03"];
		$this->de_03->AdvancedSearch->SearchOperator2 = @$filter["w_de_03"];
		$this->de_03->AdvancedSearch->save();

		// Field qty_de_03
		$this->qty_de_03->AdvancedSearch->SearchValue = @$filter["x_qty_de_03"];
		$this->qty_de_03->AdvancedSearch->SearchOperator = @$filter["z_qty_de_03"];
		$this->qty_de_03->AdvancedSearch->SearchCondition = @$filter["v_qty_de_03"];
		$this->qty_de_03->AdvancedSearch->SearchValue2 = @$filter["y_qty_de_03"];
		$this->qty_de_03->AdvancedSearch->SearchOperator2 = @$filter["w_qty_de_03"];
		$this->qty_de_03->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->job_type, $default, FALSE); // job_type
		$this->buildSearchSql($where, $this->job_category, $default, FALSE); // job_category
		$this->buildSearchSql($where, $this->company_id, $default, FALSE); // company_id
		$this->buildSearchSql($where, $this->description, $default, FALSE); // description
		$this->buildSearchSql($where, $this->size, $default, FALSE); // size
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->pages, $default, FALSE); // pages
		$this->buildSearchSql($where, $this->paper, $default, FALSE); // paper
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->pr_01, $default, FALSE); // pr_01
		$this->buildSearchSql($where, $this->qty_pr_01, $default, FALSE); // qty_pr_01
		$this->buildSearchSql($where, $this->pl_01, $default, FALSE); // pl_01
		$this->buildSearchSql($where, $this->qty_pl_01, $default, FALSE); // qty_pl_01
		$this->buildSearchSql($where, $this->pr_02, $default, FALSE); // pr_02
		$this->buildSearchSql($where, $this->qty_pr_02, $default, FALSE); // qty_pr_02
		$this->buildSearchSql($where, $this->pl_02, $default, FALSE); // pl_02
		$this->buildSearchSql($where, $this->qty_pl_02, $default, FALSE); // qty_pl_02
		$this->buildSearchSql($where, $this->pr_03, $default, FALSE); // pr_03
		$this->buildSearchSql($where, $this->qty_pr_03, $default, FALSE); // qty_pr_03
		$this->buildSearchSql($where, $this->pl_03, $default, FALSE); // pl_03
		$this->buildSearchSql($where, $this->qty_pl_03, $default, FALSE); // qty_pl_03
		$this->buildSearchSql($where, $this->pr_04, $default, FALSE); // pr_04
		$this->buildSearchSql($where, $this->qty_pr_04, $default, FALSE); // qty_pr_04
		$this->buildSearchSql($where, $this->pl_04, $default, FALSE); // pl_04
		$this->buildSearchSql($where, $this->qty_pl_04, $default, FALSE); // qty_pl_04
		$this->buildSearchSql($where, $this->pa_01, $default, FALSE); // pa_01
		$this->buildSearchSql($where, $this->qty_pa_01, $default, FALSE); // qty_pa_01
		$this->buildSearchSql($where, $this->pa_02, $default, FALSE); // pa_02
		$this->buildSearchSql($where, $this->qty_pa_02, $default, FALSE); // qty_pa_02
		$this->buildSearchSql($where, $this->pa_03, $default, FALSE); // pa_03
		$this->buildSearchSql($where, $this->qty_pa_03, $default, FALSE); // qty_pa_03
		$this->buildSearchSql($where, $this->pa_04, $default, FALSE); // pa_04
		$this->buildSearchSql($where, $this->qty_pa_04, $default, FALSE); // qty_pa_04
		$this->buildSearchSql($where, $this->pa_05, $default, FALSE); // pa_05
		$this->buildSearchSql($where, $this->qty_pa_05, $default, FALSE); // qty_pa_05
		$this->buildSearchSql($where, $this->pc_01, $default, FALSE); // pc_01
		$this->buildSearchSql($where, $this->qty_pc_01, $default, FALSE); // qty_pc_01
		$this->buildSearchSql($where, $this->pc_02, $default, FALSE); // pc_02
		$this->buildSearchSql($where, $this->qty_pc_02, $default, FALSE); // qty_pc_02
		$this->buildSearchSql($where, $this->o_01, $default, FALSE); // o_01
		$this->buildSearchSql($where, $this->qty_o_01, $default, FALSE); // qty_o_01
		$this->buildSearchSql($where, $this->lamination_type, $default, FALSE); // lamination_type
		$this->buildSearchSql($where, $this->lamination_qty, $default, FALSE); // lamination_qty
		$this->buildSearchSql($where, $this->die_type, $default, FALSE); // die_type
		$this->buildSearchSql($where, $this->die_qty, $default, FALSE); // die_qty
		$this->buildSearchSql($where, $this->binding_type, $default, FALSE); // binding_type
		$this->buildSearchSql($where, $this->binding_qty, $default, FALSE); // binding_qty
		$this->buildSearchSql($where, $this->number_type, $default, FALSE); // number_type
		$this->buildSearchSql($where, $this->number_qty, $default, FALSE); // number_qty
		$this->buildSearchSql($where, $this->de_01, $default, FALSE); // de_01
		$this->buildSearchSql($where, $this->qty_de_01, $default, FALSE); // qty_de_01
		$this->buildSearchSql($where, $this->de_02, $default, FALSE); // de_02
		$this->buildSearchSql($where, $this->qty_de_02, $default, FALSE); // qty_de_02
		$this->buildSearchSql($where, $this->de_03, $default, FALSE); // de_03
		$this->buildSearchSql($where, $this->qty_de_03, $default, FALSE); // qty_de_03
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->job_type->AdvancedSearch->save(); // job_type
			$this->job_category->AdvancedSearch->save(); // job_category
			$this->company_id->AdvancedSearch->save(); // company_id
			$this->description->AdvancedSearch->save(); // description
			$this->size->AdvancedSearch->save(); // size
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->pages->AdvancedSearch->save(); // pages
			$this->paper->AdvancedSearch->save(); // paper
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->pr_01->AdvancedSearch->save(); // pr_01
			$this->qty_pr_01->AdvancedSearch->save(); // qty_pr_01
			$this->pl_01->AdvancedSearch->save(); // pl_01
			$this->qty_pl_01->AdvancedSearch->save(); // qty_pl_01
			$this->pr_02->AdvancedSearch->save(); // pr_02
			$this->qty_pr_02->AdvancedSearch->save(); // qty_pr_02
			$this->pl_02->AdvancedSearch->save(); // pl_02
			$this->qty_pl_02->AdvancedSearch->save(); // qty_pl_02
			$this->pr_03->AdvancedSearch->save(); // pr_03
			$this->qty_pr_03->AdvancedSearch->save(); // qty_pr_03
			$this->pl_03->AdvancedSearch->save(); // pl_03
			$this->qty_pl_03->AdvancedSearch->save(); // qty_pl_03
			$this->pr_04->AdvancedSearch->save(); // pr_04
			$this->qty_pr_04->AdvancedSearch->save(); // qty_pr_04
			$this->pl_04->AdvancedSearch->save(); // pl_04
			$this->qty_pl_04->AdvancedSearch->save(); // qty_pl_04
			$this->pa_01->AdvancedSearch->save(); // pa_01
			$this->qty_pa_01->AdvancedSearch->save(); // qty_pa_01
			$this->pa_02->AdvancedSearch->save(); // pa_02
			$this->qty_pa_02->AdvancedSearch->save(); // qty_pa_02
			$this->pa_03->AdvancedSearch->save(); // pa_03
			$this->qty_pa_03->AdvancedSearch->save(); // qty_pa_03
			$this->pa_04->AdvancedSearch->save(); // pa_04
			$this->qty_pa_04->AdvancedSearch->save(); // qty_pa_04
			$this->pa_05->AdvancedSearch->save(); // pa_05
			$this->qty_pa_05->AdvancedSearch->save(); // qty_pa_05
			$this->pc_01->AdvancedSearch->save(); // pc_01
			$this->qty_pc_01->AdvancedSearch->save(); // qty_pc_01
			$this->pc_02->AdvancedSearch->save(); // pc_02
			$this->qty_pc_02->AdvancedSearch->save(); // qty_pc_02
			$this->o_01->AdvancedSearch->save(); // o_01
			$this->qty_o_01->AdvancedSearch->save(); // qty_o_01
			$this->lamination_type->AdvancedSearch->save(); // lamination_type
			$this->lamination_qty->AdvancedSearch->save(); // lamination_qty
			$this->die_type->AdvancedSearch->save(); // die_type
			$this->die_qty->AdvancedSearch->save(); // die_qty
			$this->binding_type->AdvancedSearch->save(); // binding_type
			$this->binding_qty->AdvancedSearch->save(); // binding_qty
			$this->number_type->AdvancedSearch->save(); // number_type
			$this->number_qty->AdvancedSearch->save(); // number_qty
			$this->de_01->AdvancedSearch->save(); // de_01
			$this->qty_de_01->AdvancedSearch->save(); // qty_de_01
			$this->de_02->AdvancedSearch->save(); // de_02
			$this->qty_de_02->AdvancedSearch->save(); // qty_de_02
			$this->de_03->AdvancedSearch->save(); // de_03
			$this->qty_de_03->AdvancedSearch->save(); // qty_de_03
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->company_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pr_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pr_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pr_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pr_04, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pa_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pa_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pa_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pa_04, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pa_05, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->o_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->die_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->number_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->de_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->de_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->de_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->job_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->job_category->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->company_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->size->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pages->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->paper->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pr_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pr_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pl_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pr_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pr_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pl_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pr_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pr_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pl_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pr_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pr_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pl_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pa_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pa_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pa_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pa_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pa_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pa_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pa_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pa_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pa_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pa_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pc_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_pc_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->o_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_o_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->lamination_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->lamination_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->die_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->die_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->binding_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->binding_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->number_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->number_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->de_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_de_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->de_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_de_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->de_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty_de_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->job_type->AdvancedSearch->unsetSession();
		$this->job_category->AdvancedSearch->unsetSession();
		$this->company_id->AdvancedSearch->unsetSession();
		$this->description->AdvancedSearch->unsetSession();
		$this->size->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->pages->AdvancedSearch->unsetSession();
		$this->paper->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->pr_01->AdvancedSearch->unsetSession();
		$this->qty_pr_01->AdvancedSearch->unsetSession();
		$this->pl_01->AdvancedSearch->unsetSession();
		$this->qty_pl_01->AdvancedSearch->unsetSession();
		$this->pr_02->AdvancedSearch->unsetSession();
		$this->qty_pr_02->AdvancedSearch->unsetSession();
		$this->pl_02->AdvancedSearch->unsetSession();
		$this->qty_pl_02->AdvancedSearch->unsetSession();
		$this->pr_03->AdvancedSearch->unsetSession();
		$this->qty_pr_03->AdvancedSearch->unsetSession();
		$this->pl_03->AdvancedSearch->unsetSession();
		$this->qty_pl_03->AdvancedSearch->unsetSession();
		$this->pr_04->AdvancedSearch->unsetSession();
		$this->qty_pr_04->AdvancedSearch->unsetSession();
		$this->pl_04->AdvancedSearch->unsetSession();
		$this->qty_pl_04->AdvancedSearch->unsetSession();
		$this->pa_01->AdvancedSearch->unsetSession();
		$this->qty_pa_01->AdvancedSearch->unsetSession();
		$this->pa_02->AdvancedSearch->unsetSession();
		$this->qty_pa_02->AdvancedSearch->unsetSession();
		$this->pa_03->AdvancedSearch->unsetSession();
		$this->qty_pa_03->AdvancedSearch->unsetSession();
		$this->pa_04->AdvancedSearch->unsetSession();
		$this->qty_pa_04->AdvancedSearch->unsetSession();
		$this->pa_05->AdvancedSearch->unsetSession();
		$this->qty_pa_05->AdvancedSearch->unsetSession();
		$this->pc_01->AdvancedSearch->unsetSession();
		$this->qty_pc_01->AdvancedSearch->unsetSession();
		$this->pc_02->AdvancedSearch->unsetSession();
		$this->qty_pc_02->AdvancedSearch->unsetSession();
		$this->o_01->AdvancedSearch->unsetSession();
		$this->qty_o_01->AdvancedSearch->unsetSession();
		$this->lamination_type->AdvancedSearch->unsetSession();
		$this->lamination_qty->AdvancedSearch->unsetSession();
		$this->die_type->AdvancedSearch->unsetSession();
		$this->die_qty->AdvancedSearch->unsetSession();
		$this->binding_type->AdvancedSearch->unsetSession();
		$this->binding_qty->AdvancedSearch->unsetSession();
		$this->number_type->AdvancedSearch->unsetSession();
		$this->number_qty->AdvancedSearch->unsetSession();
		$this->de_01->AdvancedSearch->unsetSession();
		$this->qty_de_01->AdvancedSearch->unsetSession();
		$this->de_02->AdvancedSearch->unsetSession();
		$this->qty_de_02->AdvancedSearch->unsetSession();
		$this->de_03->AdvancedSearch->unsetSession();
		$this->qty_de_03->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->job_type->AdvancedSearch->load();
		$this->job_category->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->description->AdvancedSearch->load();
		$this->size->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->pages->AdvancedSearch->load();
		$this->paper->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->pr_01->AdvancedSearch->load();
		$this->qty_pr_01->AdvancedSearch->load();
		$this->pl_01->AdvancedSearch->load();
		$this->qty_pl_01->AdvancedSearch->load();
		$this->pr_02->AdvancedSearch->load();
		$this->qty_pr_02->AdvancedSearch->load();
		$this->pl_02->AdvancedSearch->load();
		$this->qty_pl_02->AdvancedSearch->load();
		$this->pr_03->AdvancedSearch->load();
		$this->qty_pr_03->AdvancedSearch->load();
		$this->pl_03->AdvancedSearch->load();
		$this->qty_pl_03->AdvancedSearch->load();
		$this->pr_04->AdvancedSearch->load();
		$this->qty_pr_04->AdvancedSearch->load();
		$this->pl_04->AdvancedSearch->load();
		$this->qty_pl_04->AdvancedSearch->load();
		$this->pa_01->AdvancedSearch->load();
		$this->qty_pa_01->AdvancedSearch->load();
		$this->pa_02->AdvancedSearch->load();
		$this->qty_pa_02->AdvancedSearch->load();
		$this->pa_03->AdvancedSearch->load();
		$this->qty_pa_03->AdvancedSearch->load();
		$this->pa_04->AdvancedSearch->load();
		$this->qty_pa_04->AdvancedSearch->load();
		$this->pa_05->AdvancedSearch->load();
		$this->qty_pa_05->AdvancedSearch->load();
		$this->pc_01->AdvancedSearch->load();
		$this->qty_pc_01->AdvancedSearch->load();
		$this->pc_02->AdvancedSearch->load();
		$this->qty_pc_02->AdvancedSearch->load();
		$this->o_01->AdvancedSearch->load();
		$this->qty_o_01->AdvancedSearch->load();
		$this->lamination_type->AdvancedSearch->load();
		$this->lamination_qty->AdvancedSearch->load();
		$this->die_type->AdvancedSearch->load();
		$this->die_qty->AdvancedSearch->load();
		$this->binding_type->AdvancedSearch->load();
		$this->binding_qty->AdvancedSearch->load();
		$this->number_type->AdvancedSearch->load();
		$this->number_qty->AdvancedSearch->load();
		$this->de_01->AdvancedSearch->load();
		$this->qty_de_01->AdvancedSearch->load();
		$this->de_02->AdvancedSearch->load();
		$this->qty_de_02->AdvancedSearch->load();
		$this->de_03->AdvancedSearch->load();
		$this->qty_de_03->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->job_type, $ctrl); // job_type
			$this->updateSort($this->job_category, $ctrl); // job_category
			$this->updateSort($this->company_id, $ctrl); // company_id
			$this->updateSort($this->description, $ctrl); // description
			$this->updateSort($this->size, $ctrl); // size
			$this->updateSort($this->quantity, $ctrl); // quantity
			$this->updateSort($this->pages, $ctrl); // pages
			$this->updateSort($this->paper, $ctrl); // paper
			$this->updateSort($this->remarks, $ctrl); // remarks
			$this->updateSort($this->pr_01, $ctrl); // pr_01
			$this->updateSort($this->qty_pr_01, $ctrl); // qty_pr_01
			$this->updateSort($this->pl_01, $ctrl); // pl_01
			$this->updateSort($this->qty_pl_01, $ctrl); // qty_pl_01
			$this->updateSort($this->pr_02, $ctrl); // pr_02
			$this->updateSort($this->qty_pr_02, $ctrl); // qty_pr_02
			$this->updateSort($this->pl_02, $ctrl); // pl_02
			$this->updateSort($this->qty_pl_02, $ctrl); // qty_pl_02
			$this->updateSort($this->pr_03, $ctrl); // pr_03
			$this->updateSort($this->qty_pr_03, $ctrl); // qty_pr_03
			$this->updateSort($this->pl_03, $ctrl); // pl_03
			$this->updateSort($this->qty_pl_03, $ctrl); // qty_pl_03
			$this->updateSort($this->pr_04, $ctrl); // pr_04
			$this->updateSort($this->qty_pr_04, $ctrl); // qty_pr_04
			$this->updateSort($this->pl_04, $ctrl); // pl_04
			$this->updateSort($this->qty_pl_04, $ctrl); // qty_pl_04
			$this->updateSort($this->pa_01, $ctrl); // pa_01
			$this->updateSort($this->qty_pa_01, $ctrl); // qty_pa_01
			$this->updateSort($this->pa_02, $ctrl); // pa_02
			$this->updateSort($this->qty_pa_02, $ctrl); // qty_pa_02
			$this->updateSort($this->pa_03, $ctrl); // pa_03
			$this->updateSort($this->qty_pa_03, $ctrl); // qty_pa_03
			$this->updateSort($this->pa_04, $ctrl); // pa_04
			$this->updateSort($this->qty_pa_04, $ctrl); // qty_pa_04
			$this->updateSort($this->pa_05, $ctrl); // pa_05
			$this->updateSort($this->qty_pa_05, $ctrl); // qty_pa_05
			$this->updateSort($this->pc_01, $ctrl); // pc_01
			$this->updateSort($this->qty_pc_01, $ctrl); // qty_pc_01
			$this->updateSort($this->pc_02, $ctrl); // pc_02
			$this->updateSort($this->qty_pc_02, $ctrl); // qty_pc_02
			$this->updateSort($this->o_01, $ctrl); // o_01
			$this->updateSort($this->qty_o_01, $ctrl); // qty_o_01
			$this->updateSort($this->lamination_type, $ctrl); // lamination_type
			$this->updateSort($this->lamination_qty, $ctrl); // lamination_qty
			$this->updateSort($this->die_type, $ctrl); // die_type
			$this->updateSort($this->die_qty, $ctrl); // die_qty
			$this->updateSort($this->binding_type, $ctrl); // binding_type
			$this->updateSort($this->binding_qty, $ctrl); // binding_qty
			$this->updateSort($this->number_type, $ctrl); // number_type
			$this->updateSort($this->number_qty, $ctrl); // number_qty
			$this->updateSort($this->de_01, $ctrl); // de_01
			$this->updateSort($this->qty_de_01, $ctrl); // qty_de_01
			$this->updateSort($this->de_02, $ctrl); // de_02
			$this->updateSort($this->qty_de_02, $ctrl); // qty_de_02
			$this->updateSort($this->de_03, $ctrl); // de_03
			$this->updateSort($this->qty_de_03, $ctrl); // qty_de_03
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->job_type->setSort("");
				$this->job_category->setSort("");
				$this->company_id->setSort("");
				$this->description->setSort("");
				$this->size->setSort("");
				$this->quantity->setSort("");
				$this->pages->setSort("");
				$this->paper->setSort("");
				$this->remarks->setSort("");
				$this->pr_01->setSort("");
				$this->qty_pr_01->setSort("");
				$this->pl_01->setSort("");
				$this->qty_pl_01->setSort("");
				$this->pr_02->setSort("");
				$this->qty_pr_02->setSort("");
				$this->pl_02->setSort("");
				$this->qty_pl_02->setSort("");
				$this->pr_03->setSort("");
				$this->qty_pr_03->setSort("");
				$this->pl_03->setSort("");
				$this->qty_pl_03->setSort("");
				$this->pr_04->setSort("");
				$this->qty_pr_04->setSort("");
				$this->pl_04->setSort("");
				$this->qty_pl_04->setSort("");
				$this->pa_01->setSort("");
				$this->qty_pa_01->setSort("");
				$this->pa_02->setSort("");
				$this->qty_pa_02->setSort("");
				$this->pa_03->setSort("");
				$this->qty_pa_03->setSort("");
				$this->pa_04->setSort("");
				$this->qty_pa_04->setSort("");
				$this->pa_05->setSort("");
				$this->qty_pa_05->setSort("");
				$this->pc_01->setSort("");
				$this->qty_pc_01->setSort("");
				$this->pc_02->setSort("");
				$this->qty_pc_02->setSort("");
				$this->o_01->setSort("");
				$this->qty_o_01->setSort("");
				$this->lamination_type->setSort("");
				$this->lamination_qty->setSort("");
				$this->die_type->setSort("");
				$this->die_qty->setSort("");
				$this->binding_type->setSort("");
				$this->binding_qty->setSort("");
				$this->number_type->setSort("");
				$this->number_qty->setSort("");
				$this->de_01->setSort("");
				$this->qty_de_01->setSort("");
				$this->de_02->setSort("");
				$this->qty_de_02->setSort("");
				$this->de_03->setSort("");
				$this->qty_de_03->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fp_eastimatelistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fp_eastimatelistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fp_eastimatelist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fp_eastimatelistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"p_eastimatesrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fp_eastimatelistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// job_type
		if (!$this->isAddOrEdit())
			$this->job_type->AdvancedSearch->setSearchValue(Get("x_job_type", Get("job_type", "")));
		if ($this->job_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->job_type->AdvancedSearch->setSearchOperator(Get("z_job_type", ""));

		// job_category
		if (!$this->isAddOrEdit())
			$this->job_category->AdvancedSearch->setSearchValue(Get("x_job_category", Get("job_category", "")));
		if ($this->job_category->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->job_category->AdvancedSearch->setSearchOperator(Get("z_job_category", ""));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue(Get("x_company_id", Get("company_id", "")));
		if ($this->company_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->company_id->AdvancedSearch->setSearchOperator(Get("z_company_id", ""));

		// description
		if (!$this->isAddOrEdit())
			$this->description->AdvancedSearch->setSearchValue(Get("x_description", Get("description", "")));
		if ($this->description->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description->AdvancedSearch->setSearchOperator(Get("z_description", ""));

		// size
		if (!$this->isAddOrEdit())
			$this->size->AdvancedSearch->setSearchValue(Get("x_size", Get("size", "")));
		if ($this->size->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->size->AdvancedSearch->setSearchOperator(Get("z_size", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// pages
		if (!$this->isAddOrEdit())
			$this->pages->AdvancedSearch->setSearchValue(Get("x_pages", Get("pages", "")));
		if ($this->pages->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pages->AdvancedSearch->setSearchOperator(Get("z_pages", ""));

		// paper
		if (!$this->isAddOrEdit())
			$this->paper->AdvancedSearch->setSearchValue(Get("x_paper", Get("paper", "")));
		if ($this->paper->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->paper->AdvancedSearch->setSearchOperator(Get("z_paper", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// pr_01
		if (!$this->isAddOrEdit())
			$this->pr_01->AdvancedSearch->setSearchValue(Get("x_pr_01", Get("pr_01", "")));
		if ($this->pr_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pr_01->AdvancedSearch->setSearchOperator(Get("z_pr_01", ""));

		// qty_pr_01
		if (!$this->isAddOrEdit())
			$this->qty_pr_01->AdvancedSearch->setSearchValue(Get("x_qty_pr_01", Get("qty_pr_01", "")));
		if ($this->qty_pr_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pr_01->AdvancedSearch->setSearchOperator(Get("z_qty_pr_01", ""));

		// pl_01
		if (!$this->isAddOrEdit())
			$this->pl_01->AdvancedSearch->setSearchValue(Get("x_pl_01", Get("pl_01", "")));
		if ($this->pl_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_01->AdvancedSearch->setSearchOperator(Get("z_pl_01", ""));

		// qty_pl_01
		if (!$this->isAddOrEdit())
			$this->qty_pl_01->AdvancedSearch->setSearchValue(Get("x_qty_pl_01", Get("qty_pl_01", "")));
		if ($this->qty_pl_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pl_01->AdvancedSearch->setSearchOperator(Get("z_qty_pl_01", ""));

		// pr_02
		if (!$this->isAddOrEdit())
			$this->pr_02->AdvancedSearch->setSearchValue(Get("x_pr_02", Get("pr_02", "")));
		if ($this->pr_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pr_02->AdvancedSearch->setSearchOperator(Get("z_pr_02", ""));

		// qty_pr_02
		if (!$this->isAddOrEdit())
			$this->qty_pr_02->AdvancedSearch->setSearchValue(Get("x_qty_pr_02", Get("qty_pr_02", "")));
		if ($this->qty_pr_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pr_02->AdvancedSearch->setSearchOperator(Get("z_qty_pr_02", ""));

		// pl_02
		if (!$this->isAddOrEdit())
			$this->pl_02->AdvancedSearch->setSearchValue(Get("x_pl_02", Get("pl_02", "")));
		if ($this->pl_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_02->AdvancedSearch->setSearchOperator(Get("z_pl_02", ""));

		// qty_pl_02
		if (!$this->isAddOrEdit())
			$this->qty_pl_02->AdvancedSearch->setSearchValue(Get("x_qty_pl_02", Get("qty_pl_02", "")));
		if ($this->qty_pl_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pl_02->AdvancedSearch->setSearchOperator(Get("z_qty_pl_02", ""));

		// pr_03
		if (!$this->isAddOrEdit())
			$this->pr_03->AdvancedSearch->setSearchValue(Get("x_pr_03", Get("pr_03", "")));
		if ($this->pr_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pr_03->AdvancedSearch->setSearchOperator(Get("z_pr_03", ""));

		// qty_pr_03
		if (!$this->isAddOrEdit())
			$this->qty_pr_03->AdvancedSearch->setSearchValue(Get("x_qty_pr_03", Get("qty_pr_03", "")));
		if ($this->qty_pr_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pr_03->AdvancedSearch->setSearchOperator(Get("z_qty_pr_03", ""));

		// pl_03
		if (!$this->isAddOrEdit())
			$this->pl_03->AdvancedSearch->setSearchValue(Get("x_pl_03", Get("pl_03", "")));
		if ($this->pl_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_03->AdvancedSearch->setSearchOperator(Get("z_pl_03", ""));

		// qty_pl_03
		if (!$this->isAddOrEdit())
			$this->qty_pl_03->AdvancedSearch->setSearchValue(Get("x_qty_pl_03", Get("qty_pl_03", "")));
		if ($this->qty_pl_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pl_03->AdvancedSearch->setSearchOperator(Get("z_qty_pl_03", ""));

		// pr_04
		if (!$this->isAddOrEdit())
			$this->pr_04->AdvancedSearch->setSearchValue(Get("x_pr_04", Get("pr_04", "")));
		if ($this->pr_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pr_04->AdvancedSearch->setSearchOperator(Get("z_pr_04", ""));

		// qty_pr_04
		if (!$this->isAddOrEdit())
			$this->qty_pr_04->AdvancedSearch->setSearchValue(Get("x_qty_pr_04", Get("qty_pr_04", "")));
		if ($this->qty_pr_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pr_04->AdvancedSearch->setSearchOperator(Get("z_qty_pr_04", ""));

		// pl_04
		if (!$this->isAddOrEdit())
			$this->pl_04->AdvancedSearch->setSearchValue(Get("x_pl_04", Get("pl_04", "")));
		if ($this->pl_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_04->AdvancedSearch->setSearchOperator(Get("z_pl_04", ""));

		// qty_pl_04
		if (!$this->isAddOrEdit())
			$this->qty_pl_04->AdvancedSearch->setSearchValue(Get("x_qty_pl_04", Get("qty_pl_04", "")));
		if ($this->qty_pl_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pl_04->AdvancedSearch->setSearchOperator(Get("z_qty_pl_04", ""));

		// pa_01
		if (!$this->isAddOrEdit())
			$this->pa_01->AdvancedSearch->setSearchValue(Get("x_pa_01", Get("pa_01", "")));
		if ($this->pa_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pa_01->AdvancedSearch->setSearchOperator(Get("z_pa_01", ""));

		// qty_pa_01
		if (!$this->isAddOrEdit())
			$this->qty_pa_01->AdvancedSearch->setSearchValue(Get("x_qty_pa_01", Get("qty_pa_01", "")));
		if ($this->qty_pa_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pa_01->AdvancedSearch->setSearchOperator(Get("z_qty_pa_01", ""));

		// pa_02
		if (!$this->isAddOrEdit())
			$this->pa_02->AdvancedSearch->setSearchValue(Get("x_pa_02", Get("pa_02", "")));
		if ($this->pa_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pa_02->AdvancedSearch->setSearchOperator(Get("z_pa_02", ""));

		// qty_pa_02
		if (!$this->isAddOrEdit())
			$this->qty_pa_02->AdvancedSearch->setSearchValue(Get("x_qty_pa_02", Get("qty_pa_02", "")));
		if ($this->qty_pa_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pa_02->AdvancedSearch->setSearchOperator(Get("z_qty_pa_02", ""));

		// pa_03
		if (!$this->isAddOrEdit())
			$this->pa_03->AdvancedSearch->setSearchValue(Get("x_pa_03", Get("pa_03", "")));
		if ($this->pa_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pa_03->AdvancedSearch->setSearchOperator(Get("z_pa_03", ""));

		// qty_pa_03
		if (!$this->isAddOrEdit())
			$this->qty_pa_03->AdvancedSearch->setSearchValue(Get("x_qty_pa_03", Get("qty_pa_03", "")));
		if ($this->qty_pa_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pa_03->AdvancedSearch->setSearchOperator(Get("z_qty_pa_03", ""));

		// pa_04
		if (!$this->isAddOrEdit())
			$this->pa_04->AdvancedSearch->setSearchValue(Get("x_pa_04", Get("pa_04", "")));
		if ($this->pa_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pa_04->AdvancedSearch->setSearchOperator(Get("z_pa_04", ""));

		// qty_pa_04
		if (!$this->isAddOrEdit())
			$this->qty_pa_04->AdvancedSearch->setSearchValue(Get("x_qty_pa_04", Get("qty_pa_04", "")));
		if ($this->qty_pa_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pa_04->AdvancedSearch->setSearchOperator(Get("z_qty_pa_04", ""));

		// pa_05
		if (!$this->isAddOrEdit())
			$this->pa_05->AdvancedSearch->setSearchValue(Get("x_pa_05", Get("pa_05", "")));
		if ($this->pa_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pa_05->AdvancedSearch->setSearchOperator(Get("z_pa_05", ""));

		// qty_pa_05
		if (!$this->isAddOrEdit())
			$this->qty_pa_05->AdvancedSearch->setSearchValue(Get("x_qty_pa_05", Get("qty_pa_05", "")));
		if ($this->qty_pa_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pa_05->AdvancedSearch->setSearchOperator(Get("z_qty_pa_05", ""));

		// pc_01
		if (!$this->isAddOrEdit())
			$this->pc_01->AdvancedSearch->setSearchValue(Get("x_pc_01", Get("pc_01", "")));
		if ($this->pc_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_01->AdvancedSearch->setSearchOperator(Get("z_pc_01", ""));

		// qty_pc_01
		if (!$this->isAddOrEdit())
			$this->qty_pc_01->AdvancedSearch->setSearchValue(Get("x_qty_pc_01", Get("qty_pc_01", "")));
		if ($this->qty_pc_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pc_01->AdvancedSearch->setSearchOperator(Get("z_qty_pc_01", ""));

		// pc_02
		if (!$this->isAddOrEdit())
			$this->pc_02->AdvancedSearch->setSearchValue(Get("x_pc_02", Get("pc_02", "")));
		if ($this->pc_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_02->AdvancedSearch->setSearchOperator(Get("z_pc_02", ""));

		// qty_pc_02
		if (!$this->isAddOrEdit())
			$this->qty_pc_02->AdvancedSearch->setSearchValue(Get("x_qty_pc_02", Get("qty_pc_02", "")));
		if ($this->qty_pc_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_pc_02->AdvancedSearch->setSearchOperator(Get("z_qty_pc_02", ""));

		// o_01
		if (!$this->isAddOrEdit())
			$this->o_01->AdvancedSearch->setSearchValue(Get("x_o_01", Get("o_01", "")));
		if ($this->o_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->o_01->AdvancedSearch->setSearchOperator(Get("z_o_01", ""));

		// qty_o_01
		if (!$this->isAddOrEdit())
			$this->qty_o_01->AdvancedSearch->setSearchValue(Get("x_qty_o_01", Get("qty_o_01", "")));
		if ($this->qty_o_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_o_01->AdvancedSearch->setSearchOperator(Get("z_qty_o_01", ""));

		// lamination_type
		if (!$this->isAddOrEdit())
			$this->lamination_type->AdvancedSearch->setSearchValue(Get("x_lamination_type", Get("lamination_type", "")));
		if ($this->lamination_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->lamination_type->AdvancedSearch->setSearchOperator(Get("z_lamination_type", ""));

		// lamination_qty
		if (!$this->isAddOrEdit())
			$this->lamination_qty->AdvancedSearch->setSearchValue(Get("x_lamination_qty", Get("lamination_qty", "")));
		if ($this->lamination_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->lamination_qty->AdvancedSearch->setSearchOperator(Get("z_lamination_qty", ""));

		// die_type
		if (!$this->isAddOrEdit())
			$this->die_type->AdvancedSearch->setSearchValue(Get("x_die_type", Get("die_type", "")));
		if ($this->die_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->die_type->AdvancedSearch->setSearchOperator(Get("z_die_type", ""));

		// die_qty
		if (!$this->isAddOrEdit())
			$this->die_qty->AdvancedSearch->setSearchValue(Get("x_die_qty", Get("die_qty", "")));
		if ($this->die_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->die_qty->AdvancedSearch->setSearchOperator(Get("z_die_qty", ""));

		// binding_type
		if (!$this->isAddOrEdit())
			$this->binding_type->AdvancedSearch->setSearchValue(Get("x_binding_type", Get("binding_type", "")));
		if ($this->binding_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->binding_type->AdvancedSearch->setSearchOperator(Get("z_binding_type", ""));

		// binding_qty
		if (!$this->isAddOrEdit())
			$this->binding_qty->AdvancedSearch->setSearchValue(Get("x_binding_qty", Get("binding_qty", "")));
		if ($this->binding_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->binding_qty->AdvancedSearch->setSearchOperator(Get("z_binding_qty", ""));

		// number_type
		if (!$this->isAddOrEdit())
			$this->number_type->AdvancedSearch->setSearchValue(Get("x_number_type", Get("number_type", "")));
		if ($this->number_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->number_type->AdvancedSearch->setSearchOperator(Get("z_number_type", ""));

		// number_qty
		if (!$this->isAddOrEdit())
			$this->number_qty->AdvancedSearch->setSearchValue(Get("x_number_qty", Get("number_qty", "")));
		if ($this->number_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->number_qty->AdvancedSearch->setSearchOperator(Get("z_number_qty", ""));

		// de_01
		if (!$this->isAddOrEdit())
			$this->de_01->AdvancedSearch->setSearchValue(Get("x_de_01", Get("de_01", "")));
		if ($this->de_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->de_01->AdvancedSearch->setSearchOperator(Get("z_de_01", ""));

		// qty_de_01
		if (!$this->isAddOrEdit())
			$this->qty_de_01->AdvancedSearch->setSearchValue(Get("x_qty_de_01", Get("qty_de_01", "")));
		if ($this->qty_de_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_de_01->AdvancedSearch->setSearchOperator(Get("z_qty_de_01", ""));

		// de_02
		if (!$this->isAddOrEdit())
			$this->de_02->AdvancedSearch->setSearchValue(Get("x_de_02", Get("de_02", "")));
		if ($this->de_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->de_02->AdvancedSearch->setSearchOperator(Get("z_de_02", ""));

		// qty_de_02
		if (!$this->isAddOrEdit())
			$this->qty_de_02->AdvancedSearch->setSearchValue(Get("x_qty_de_02", Get("qty_de_02", "")));
		if ($this->qty_de_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_de_02->AdvancedSearch->setSearchOperator(Get("z_qty_de_02", ""));

		// de_03
		if (!$this->isAddOrEdit())
			$this->de_03->AdvancedSearch->setSearchValue(Get("x_de_03", Get("de_03", "")));
		if ($this->de_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->de_03->AdvancedSearch->setSearchOperator(Get("z_de_03", ""));

		// qty_de_03
		if (!$this->isAddOrEdit())
			$this->qty_de_03->AdvancedSearch->setSearchValue(Get("x_qty_de_03", Get("qty_de_03", "")));
		if ($this->qty_de_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty_de_03->AdvancedSearch->setSearchOperator(Get("z_qty_de_03", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->job_type->setDbValue($row['job_type']);
		$this->job_category->setDbValue($row['job_category']);
		$this->company_id->setDbValue($row['company_id']);
		$this->description->setDbValue($row['description']);
		$this->size->setDbValue($row['size']);
		$this->quantity->setDbValue($row['quantity']);
		$this->pages->setDbValue($row['pages']);
		$this->paper->setDbValue($row['paper']);
		$this->remarks->setDbValue($row['remarks']);
		$this->pr_01->setDbValue($row['pr_01']);
		if (array_key_exists('EV__pr_01', $rs->fields)) {
			$this->pr_01->VirtualValue = $rs->fields('EV__pr_01'); // Set up virtual field value
		} else {
			$this->pr_01->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_01->setDbValue($row['qty_pr_01']);
		$this->pl_01->setDbValue($row['pl_01']);
		$this->qty_pl_01->setDbValue($row['qty_pl_01']);
		$this->pr_02->setDbValue($row['pr_02']);
		if (array_key_exists('EV__pr_02', $rs->fields)) {
			$this->pr_02->VirtualValue = $rs->fields('EV__pr_02'); // Set up virtual field value
		} else {
			$this->pr_02->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_02->setDbValue($row['qty_pr_02']);
		$this->pl_02->setDbValue($row['pl_02']);
		$this->qty_pl_02->setDbValue($row['qty_pl_02']);
		$this->pr_03->setDbValue($row['pr_03']);
		if (array_key_exists('EV__pr_03', $rs->fields)) {
			$this->pr_03->VirtualValue = $rs->fields('EV__pr_03'); // Set up virtual field value
		} else {
			$this->pr_03->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_03->setDbValue($row['qty_pr_03']);
		$this->pl_03->setDbValue($row['pl_03']);
		$this->qty_pl_03->setDbValue($row['qty_pl_03']);
		$this->pr_04->setDbValue($row['pr_04']);
		if (array_key_exists('EV__pr_04', $rs->fields)) {
			$this->pr_04->VirtualValue = $rs->fields('EV__pr_04'); // Set up virtual field value
		} else {
			$this->pr_04->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_04->setDbValue($row['qty_pr_04']);
		$this->pl_04->setDbValue($row['pl_04']);
		$this->qty_pl_04->setDbValue($row['qty_pl_04']);
		$this->pa_01->setDbValue($row['pa_01']);
		$this->qty_pa_01->setDbValue($row['qty_pa_01']);
		$this->pa_02->setDbValue($row['pa_02']);
		$this->qty_pa_02->setDbValue($row['qty_pa_02']);
		$this->pa_03->setDbValue($row['pa_03']);
		$this->qty_pa_03->setDbValue($row['qty_pa_03']);
		$this->pa_04->setDbValue($row['pa_04']);
		$this->qty_pa_04->setDbValue($row['qty_pa_04']);
		$this->pa_05->setDbValue($row['pa_05']);
		$this->qty_pa_05->setDbValue($row['qty_pa_05']);
		$this->pc_01->setDbValue($row['pc_01']);
		$this->qty_pc_01->setDbValue($row['qty_pc_01']);
		$this->pc_02->setDbValue($row['pc_02']);
		$this->qty_pc_02->setDbValue($row['qty_pc_02']);
		$this->o_01->setDbValue($row['o_01']);
		$this->qty_o_01->setDbValue($row['qty_o_01']);
		$this->lamination_type->setDbValue($row['lamination_type']);
		if (array_key_exists('EV__lamination_type', $rs->fields)) {
			$this->lamination_type->VirtualValue = $rs->fields('EV__lamination_type'); // Set up virtual field value
		} else {
			$this->lamination_type->VirtualValue = ""; // Clear value
		}
		$this->lamination_qty->setDbValue($row['lamination_qty']);
		$this->die_type->setDbValue($row['die_type']);
		if (array_key_exists('EV__die_type', $rs->fields)) {
			$this->die_type->VirtualValue = $rs->fields('EV__die_type'); // Set up virtual field value
		} else {
			$this->die_type->VirtualValue = ""; // Clear value
		}
		$this->die_qty->setDbValue($row['die_qty']);
		$this->binding_type->setDbValue($row['binding_type']);
		$this->binding_qty->setDbValue($row['binding_qty']);
		$this->number_type->setDbValue($row['number_type']);
		if (array_key_exists('EV__number_type', $rs->fields)) {
			$this->number_type->VirtualValue = $rs->fields('EV__number_type'); // Set up virtual field value
		} else {
			$this->number_type->VirtualValue = ""; // Clear value
		}
		$this->number_qty->setDbValue($row['number_qty']);
		$this->de_01->setDbValue($row['de_01']);
		if (array_key_exists('EV__de_01', $rs->fields)) {
			$this->de_01->VirtualValue = $rs->fields('EV__de_01'); // Set up virtual field value
		} else {
			$this->de_01->VirtualValue = ""; // Clear value
		}
		$this->qty_de_01->setDbValue($row['qty_de_01']);
		$this->de_02->setDbValue($row['de_02']);
		if (array_key_exists('EV__de_02', $rs->fields)) {
			$this->de_02->VirtualValue = $rs->fields('EV__de_02'); // Set up virtual field value
		} else {
			$this->de_02->VirtualValue = ""; // Clear value
		}
		$this->qty_de_02->setDbValue($row['qty_de_02']);
		$this->de_03->setDbValue($row['de_03']);
		if (array_key_exists('EV__de_03', $rs->fields)) {
			$this->de_03->VirtualValue = $rs->fields('EV__de_03'); // Set up virtual field value
		} else {
			$this->de_03->VirtualValue = ""; // Clear value
		}
		$this->qty_de_03->setDbValue($row['qty_de_03']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['job_type'] = NULL;
		$row['job_category'] = NULL;
		$row['company_id'] = NULL;
		$row['description'] = NULL;
		$row['size'] = NULL;
		$row['quantity'] = NULL;
		$row['pages'] = NULL;
		$row['paper'] = NULL;
		$row['remarks'] = NULL;
		$row['pr_01'] = NULL;
		$row['qty_pr_01'] = NULL;
		$row['pl_01'] = NULL;
		$row['qty_pl_01'] = NULL;
		$row['pr_02'] = NULL;
		$row['qty_pr_02'] = NULL;
		$row['pl_02'] = NULL;
		$row['qty_pl_02'] = NULL;
		$row['pr_03'] = NULL;
		$row['qty_pr_03'] = NULL;
		$row['pl_03'] = NULL;
		$row['qty_pl_03'] = NULL;
		$row['pr_04'] = NULL;
		$row['qty_pr_04'] = NULL;
		$row['pl_04'] = NULL;
		$row['qty_pl_04'] = NULL;
		$row['pa_01'] = NULL;
		$row['qty_pa_01'] = NULL;
		$row['pa_02'] = NULL;
		$row['qty_pa_02'] = NULL;
		$row['pa_03'] = NULL;
		$row['qty_pa_03'] = NULL;
		$row['pa_04'] = NULL;
		$row['qty_pa_04'] = NULL;
		$row['pa_05'] = NULL;
		$row['qty_pa_05'] = NULL;
		$row['pc_01'] = NULL;
		$row['qty_pc_01'] = NULL;
		$row['pc_02'] = NULL;
		$row['qty_pc_02'] = NULL;
		$row['o_01'] = NULL;
		$row['qty_o_01'] = NULL;
		$row['lamination_type'] = NULL;
		$row['lamination_qty'] = NULL;
		$row['die_type'] = NULL;
		$row['die_qty'] = NULL;
		$row['binding_type'] = NULL;
		$row['binding_qty'] = NULL;
		$row['number_type'] = NULL;
		$row['number_qty'] = NULL;
		$row['de_01'] = NULL;
		$row['qty_de_01'] = NULL;
		$row['de_02'] = NULL;
		$row['qty_de_02'] = NULL;
		$row['de_03'] = NULL;
		$row['qty_de_03'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_01->FormValue == $this->qty_pr_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_01->CurrentValue)))
			$this->qty_pr_01->CurrentValue = ConvertToFloatString($this->qty_pr_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_01->FormValue == $this->qty_pl_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_01->CurrentValue)))
			$this->qty_pl_01->CurrentValue = ConvertToFloatString($this->qty_pl_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_02->FormValue == $this->qty_pr_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_02->CurrentValue)))
			$this->qty_pr_02->CurrentValue = ConvertToFloatString($this->qty_pr_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_02->FormValue == $this->qty_pl_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_02->CurrentValue)))
			$this->qty_pl_02->CurrentValue = ConvertToFloatString($this->qty_pl_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_03->FormValue == $this->qty_pr_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_03->CurrentValue)))
			$this->qty_pr_03->CurrentValue = ConvertToFloatString($this->qty_pr_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_03->FormValue == $this->qty_pl_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_03->CurrentValue)))
			$this->qty_pl_03->CurrentValue = ConvertToFloatString($this->qty_pl_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_04->FormValue == $this->qty_pr_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_04->CurrentValue)))
			$this->qty_pr_04->CurrentValue = ConvertToFloatString($this->qty_pr_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_04->FormValue == $this->qty_pl_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_04->CurrentValue)))
			$this->qty_pl_04->CurrentValue = ConvertToFloatString($this->qty_pl_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_01->FormValue == $this->qty_pa_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_01->CurrentValue)))
			$this->qty_pa_01->CurrentValue = ConvertToFloatString($this->qty_pa_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_02->FormValue == $this->qty_pa_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_02->CurrentValue)))
			$this->qty_pa_02->CurrentValue = ConvertToFloatString($this->qty_pa_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_03->FormValue == $this->qty_pa_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_03->CurrentValue)))
			$this->qty_pa_03->CurrentValue = ConvertToFloatString($this->qty_pa_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_04->FormValue == $this->qty_pa_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_04->CurrentValue)))
			$this->qty_pa_04->CurrentValue = ConvertToFloatString($this->qty_pa_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_05->FormValue == $this->qty_pa_05->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_05->CurrentValue)))
			$this->qty_pa_05->CurrentValue = ConvertToFloatString($this->qty_pa_05->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pc_01->FormValue == $this->qty_pc_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pc_01->CurrentValue)))
			$this->qty_pc_01->CurrentValue = ConvertToFloatString($this->qty_pc_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pc_02->FormValue == $this->qty_pc_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pc_02->CurrentValue)))
			$this->qty_pc_02->CurrentValue = ConvertToFloatString($this->qty_pc_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_o_01->FormValue == $this->qty_o_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_o_01->CurrentValue)))
			$this->qty_o_01->CurrentValue = ConvertToFloatString($this->qty_o_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->binding_qty->FormValue == $this->binding_qty->CurrentValue && is_numeric(ConvertToFloatString($this->binding_qty->CurrentValue)))
			$this->binding_qty->CurrentValue = ConvertToFloatString($this->binding_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_01->FormValue == $this->qty_de_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_01->CurrentValue)))
			$this->qty_de_01->CurrentValue = ConvertToFloatString($this->qty_de_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_02->FormValue == $this->qty_de_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_02->CurrentValue)))
			$this->qty_de_02->CurrentValue = ConvertToFloatString($this->qty_de_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_03->FormValue == $this->qty_de_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_03->CurrentValue)))
			$this->qty_de_03->CurrentValue = ConvertToFloatString($this->qty_de_03->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// job_type
		// job_category
		// company_id
		// description
		// size
		// quantity
		// pages
		// paper
		// remarks
		// pr_01
		// qty_pr_01
		// pl_01
		// qty_pl_01
		// pr_02
		// qty_pr_02
		// pl_02
		// qty_pl_02
		// pr_03
		// qty_pr_03
		// pl_03
		// qty_pl_03
		// pr_04
		// qty_pr_04
		// pl_04
		// qty_pl_04
		// pa_01
		// qty_pa_01
		// pa_02
		// qty_pa_02
		// pa_03
		// qty_pa_03
		// pa_04
		// qty_pa_04
		// pa_05
		// qty_pa_05
		// pc_01
		// qty_pc_01
		// pc_02
		// qty_pc_02
		// o_01
		// qty_o_01
		// lamination_type
		// lamination_qty
		// die_type
		// die_qty
		// binding_type
		// binding_qty
		// number_type
		// number_qty
		// de_01
		// qty_de_01
		// de_02
		// qty_de_02
		// de_03
		// qty_de_03
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// job_type
			if (strval($this->job_type->CurrentValue) <> "") {
				$this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
			} else {
				$this->job_type->ViewValue = NULL;
			}
			$this->job_type->ViewCustomAttributes = "";

			// job_category
			if (strval($this->job_category->CurrentValue) <> "") {
				$this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
			} else {
				$this->job_category->ViewValue = NULL;
			}
			$this->job_category->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// size
			$curVal = strval($this->size->CurrentValue);
			if ($curVal <> "") {
				$this->size->ViewValue = $this->size->lookupCacheOption($curVal);
				if ($this->size->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`description`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->size->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->size->ViewValue = $this->size->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->size->ViewValue = $this->size->CurrentValue;
					}
				}
			} else {
				$this->size->ViewValue = NULL;
			}
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// pages
			$this->pages->ViewValue = $this->pages->CurrentValue;
			$this->pages->ViewCustomAttributes = "";

			// paper
			$this->paper->ViewValue = $this->paper->CurrentValue;
			$this->paper->ViewValue = FormatNumber($this->paper->ViewValue, 0, -2, -2, -2);
			$this->paper->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// pr_01
			if ($this->pr_01->VirtualValue <> "") {
				$this->pr_01->ViewValue = $this->pr_01->VirtualValue;
			} else {
			$curVal = strval($this->pr_01->CurrentValue);
			if ($curVal <> "") {
				$this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
				if ($this->pr_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_01->ViewValue = $this->pr_01->CurrentValue;
					}
				}
			} else {
				$this->pr_01->ViewValue = NULL;
			}
			}
			$this->pr_01->ViewCustomAttributes = "";

			// qty_pr_01
			$this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
			$this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_01->ViewCustomAttributes = "";

			// pl_01
			$curVal = strval($this->pl_01->CurrentValue);
			if ($curVal <> "") {
				$this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
				if ($this->pl_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_01->ViewValue = $this->pl_01->CurrentValue;
					}
				}
			} else {
				$this->pl_01->ViewValue = NULL;
			}
			$this->pl_01->ViewCustomAttributes = "";

			// qty_pl_01
			$this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
			$this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_01->ViewCustomAttributes = "";

			// pr_02
			if ($this->pr_02->VirtualValue <> "") {
				$this->pr_02->ViewValue = $this->pr_02->VirtualValue;
			} else {
			$curVal = strval($this->pr_02->CurrentValue);
			if ($curVal <> "") {
				$this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
				if ($this->pr_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_02->ViewValue = $this->pr_02->CurrentValue;
					}
				}
			} else {
				$this->pr_02->ViewValue = NULL;
			}
			}
			$this->pr_02->ViewCustomAttributes = "";

			// qty_pr_02
			$this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
			$this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_02->ViewCustomAttributes = "";

			// pl_02
			$curVal = strval($this->pl_02->CurrentValue);
			if ($curVal <> "") {
				$this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
				if ($this->pl_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_02->ViewValue = $this->pl_02->CurrentValue;
					}
				}
			} else {
				$this->pl_02->ViewValue = NULL;
			}
			$this->pl_02->ViewCustomAttributes = "";

			// qty_pl_02
			$this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
			$this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_02->ViewCustomAttributes = "";

			// pr_03
			if ($this->pr_03->VirtualValue <> "") {
				$this->pr_03->ViewValue = $this->pr_03->VirtualValue;
			} else {
			$curVal = strval($this->pr_03->CurrentValue);
			if ($curVal <> "") {
				$this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
				if ($this->pr_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_03->ViewValue = $this->pr_03->CurrentValue;
					}
				}
			} else {
				$this->pr_03->ViewValue = NULL;
			}
			}
			$this->pr_03->ViewCustomAttributes = "";

			// qty_pr_03
			$this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
			$this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_03->ViewCustomAttributes = "";

			// pl_03
			$curVal = strval($this->pl_03->CurrentValue);
			if ($curVal <> "") {
				$this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
				if ($this->pl_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_03->ViewValue = $this->pl_03->CurrentValue;
					}
				}
			} else {
				$this->pl_03->ViewValue = NULL;
			}
			$this->pl_03->ViewCustomAttributes = "";

			// qty_pl_03
			$this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
			$this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_03->ViewCustomAttributes = "";

			// pr_04
			if ($this->pr_04->VirtualValue <> "") {
				$this->pr_04->ViewValue = $this->pr_04->VirtualValue;
			} else {
			$curVal = strval($this->pr_04->CurrentValue);
			if ($curVal <> "") {
				$this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
				if ($this->pr_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_04->ViewValue = $this->pr_04->CurrentValue;
					}
				}
			} else {
				$this->pr_04->ViewValue = NULL;
			}
			}
			$this->pr_04->ViewCustomAttributes = "";

			// qty_pr_04
			$this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
			$this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_04->ViewCustomAttributes = "";

			// pl_04
			$curVal = strval($this->pl_04->CurrentValue);
			if ($curVal <> "") {
				$this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
				if ($this->pl_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_04->ViewValue = $this->pl_04->CurrentValue;
					}
				}
			} else {
				$this->pl_04->ViewValue = NULL;
			}
			$this->pl_04->ViewCustomAttributes = "";

			// qty_pl_04
			$this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
			$this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_04->ViewCustomAttributes = "";

			// pa_01
			$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
			$curVal = strval($this->pa_01->CurrentValue);
			if ($curVal <> "") {
				$this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
				if ($this->pa_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
					}
				}
			} else {
				$this->pa_01->ViewValue = NULL;
			}
			$this->pa_01->ViewCustomAttributes = "";

			// qty_pa_01
			$this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
			$this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_01->ViewCustomAttributes = "";

			// pa_02
			$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
			$curVal = strval($this->pa_02->CurrentValue);
			if ($curVal <> "") {
				$this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
				if ($this->pa_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
					}
				}
			} else {
				$this->pa_02->ViewValue = NULL;
			}
			$this->pa_02->ViewCustomAttributes = "";

			// qty_pa_02
			$this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
			$this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_02->ViewCustomAttributes = "";

			// pa_03
			$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
			$curVal = strval($this->pa_03->CurrentValue);
			if ($curVal <> "") {
				$this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
				if ($this->pa_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
					}
				}
			} else {
				$this->pa_03->ViewValue = NULL;
			}
			$this->pa_03->ViewCustomAttributes = "";

			// qty_pa_03
			$this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
			$this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_03->ViewCustomAttributes = "";

			// pa_04
			$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
			$curVal = strval($this->pa_04->CurrentValue);
			if ($curVal <> "") {
				$this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
				if ($this->pa_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
					}
				}
			} else {
				$this->pa_04->ViewValue = NULL;
			}
			$this->pa_04->ViewCustomAttributes = "";

			// qty_pa_04
			$this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
			$this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_04->ViewCustomAttributes = "";

			// pa_05
			$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
			$curVal = strval($this->pa_05->CurrentValue);
			if ($curVal <> "") {
				$this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
				if ($this->pa_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
					}
				}
			} else {
				$this->pa_05->ViewValue = NULL;
			}
			$this->pa_05->ViewCustomAttributes = "";

			// qty_pa_05
			$this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
			$this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_05->ViewCustomAttributes = "";

			// pc_01
			$curVal = strval($this->pc_01->CurrentValue);
			if ($curVal <> "") {
				$this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
				if ($this->pc_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pc_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pc_01->ViewValue = $this->pc_01->CurrentValue;
					}
				}
			} else {
				$this->pc_01->ViewValue = NULL;
			}
			$this->pc_01->ViewCustomAttributes = "";

			// qty_pc_01
			$this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
			$this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pc_01->ViewCustomAttributes = "";

			// pc_02
			$curVal = strval($this->pc_02->CurrentValue);
			if ($curVal <> "") {
				$this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
				if ($this->pc_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pc_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pc_02->ViewValue = $this->pc_02->CurrentValue;
					}
				}
			} else {
				$this->pc_02->ViewValue = NULL;
			}
			$this->pc_02->ViewCustomAttributes = "";

			// qty_pc_02
			$this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
			$this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pc_02->ViewCustomAttributes = "";

			// o_01
			$curVal = strval($this->o_01->CurrentValue);
			if ($curVal <> "") {
				$this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
				if ($this->o_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->o_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->o_01->ViewValue = $this->o_01->CurrentValue;
					}
				}
			} else {
				$this->o_01->ViewValue = NULL;
			}
			$this->o_01->ViewCustomAttributes = "";

			// qty_o_01
			$this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
			$this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, 2, -2, -2, -2);
			$this->qty_o_01->ViewCustomAttributes = "";

			// lamination_type
			if ($this->lamination_type->VirtualValue <> "") {
				$this->lamination_type->ViewValue = $this->lamination_type->VirtualValue;
			} else {
			$curVal = strval($this->lamination_type->CurrentValue);
			if ($curVal <> "") {
				$this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
				if ($this->lamination_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (123) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->lamination_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
					}
				}
			} else {
				$this->lamination_type->ViewValue = NULL;
			}
			}
			$this->lamination_type->ViewCustomAttributes = "";

			// lamination_qty
			$this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
			$this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, 0, -2, -2, -2);
			$this->lamination_qty->ViewCustomAttributes = "";

			// die_type
			if ($this->die_type->VirtualValue <> "") {
				$this->die_type->ViewValue = $this->die_type->VirtualValue;
			} else {
			$curVal = strval($this->die_type->CurrentValue);
			if ($curVal <> "") {
				$this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
				if ($this->die_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (124) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->die_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->die_type->ViewValue = $this->die_type->CurrentValue;
					}
				}
			} else {
				$this->die_type->ViewValue = NULL;
			}
			}
			$this->die_type->ViewCustomAttributes = "";

			// die_qty
			$this->die_qty->ViewValue = $this->die_qty->CurrentValue;
			$this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, 0, -2, -2, -2);
			$this->die_qty->ViewCustomAttributes = "";

			// binding_type
			$curVal = strval($this->binding_type->CurrentValue);
			if ($curVal <> "") {
				$this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
				if ($this->binding_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->binding_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->binding_type->ViewValue = $this->binding_type->CurrentValue;
					}
				}
			} else {
				$this->binding_type->ViewValue = NULL;
			}
			$this->binding_type->ViewCustomAttributes = "";

			// binding_qty
			$this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
			$this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, 2, -2, -2, -2);
			$this->binding_qty->ViewCustomAttributes = "";

			// number_type
			if ($this->number_type->VirtualValue <> "") {
				$this->number_type->ViewValue = $this->number_type->VirtualValue;
			} else {
			$curVal = strval($this->number_type->CurrentValue);
			if ($curVal <> "") {
				$this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
				if ($this->number_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->number_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->number_type->ViewValue = $this->number_type->CurrentValue;
					}
				}
			} else {
				$this->number_type->ViewValue = NULL;
			}
			}
			$this->number_type->ViewCustomAttributes = "";

			// number_qty
			$this->number_qty->ViewValue = $this->number_qty->CurrentValue;
			$this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, 0, -2, -2, -2);
			$this->number_qty->ViewCustomAttributes = "";

			// de_01
			if ($this->de_01->VirtualValue <> "") {
				$this->de_01->ViewValue = $this->de_01->VirtualValue;
			} else {
			$curVal = strval($this->de_01->CurrentValue);
			if ($curVal <> "") {
				$this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
				if ($this->de_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_01->ViewValue = $this->de_01->CurrentValue;
					}
				}
			} else {
				$this->de_01->ViewValue = NULL;
			}
			}
			$this->de_01->ViewCustomAttributes = "";

			// qty_de_01
			$this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
			$this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, 2, -2, -2, -2);
			$this->qty_de_01->ViewCustomAttributes = "";

			// de_02
			if ($this->de_02->VirtualValue <> "") {
				$this->de_02->ViewValue = $this->de_02->VirtualValue;
			} else {
			$curVal = strval($this->de_02->CurrentValue);
			if ($curVal <> "") {
				$this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
				if ($this->de_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_02->ViewValue = $this->de_02->CurrentValue;
					}
				}
			} else {
				$this->de_02->ViewValue = NULL;
			}
			}
			$this->de_02->ViewCustomAttributes = "";

			// qty_de_02
			$this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
			$this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, 2, -2, -2, -2);
			$this->qty_de_02->ViewCustomAttributes = "";

			// de_03
			if ($this->de_03->VirtualValue <> "") {
				$this->de_03->ViewValue = $this->de_03->VirtualValue;
			} else {
			$curVal = strval($this->de_03->CurrentValue);
			if ($curVal <> "") {
				$this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
				if ($this->de_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_03->ViewValue = $this->de_03->CurrentValue;
					}
				}
			} else {
				$this->de_03->ViewValue = NULL;
			}
			}
			$this->de_03->ViewCustomAttributes = "";

			// qty_de_03
			$this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
			$this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, 2, -2, -2, -2);
			$this->qty_de_03->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// job_type
			$this->job_type->LinkCustomAttributes = "";
			$this->job_type->HrefValue = "";
			$this->job_type->TooltipValue = "";

			// job_category
			$this->job_category->LinkCustomAttributes = "";
			$this->job_category->HrefValue = "";
			$this->job_category->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";
			if (!$this->isExport())
				$this->description->ViewValue = $this->highlightValue($this->description);

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// pages
			$this->pages->LinkCustomAttributes = "";
			$this->pages->HrefValue = "";
			$this->pages->TooltipValue = "";
			if (!$this->isExport())
				$this->pages->ViewValue = $this->highlightValue($this->pages);

			// paper
			$this->paper->LinkCustomAttributes = "";
			$this->paper->HrefValue = "";
			$this->paper->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";
			if (!$this->isExport())
				$this->remarks->ViewValue = $this->highlightValue($this->remarks);

			// pr_01
			$this->pr_01->LinkCustomAttributes = "";
			$this->pr_01->HrefValue = "";
			$this->pr_01->TooltipValue = "";
			if (!$this->isExport())
				$this->pr_01->ViewValue = $this->highlightValue($this->pr_01);

			// qty_pr_01
			$this->qty_pr_01->LinkCustomAttributes = "";
			$this->qty_pr_01->HrefValue = "";
			$this->qty_pr_01->TooltipValue = "";

			// pl_01
			$this->pl_01->LinkCustomAttributes = "";
			$this->pl_01->HrefValue = "";
			$this->pl_01->TooltipValue = "";

			// qty_pl_01
			$this->qty_pl_01->LinkCustomAttributes = "";
			$this->qty_pl_01->HrefValue = "";
			$this->qty_pl_01->TooltipValue = "";

			// pr_02
			$this->pr_02->LinkCustomAttributes = "";
			$this->pr_02->HrefValue = "";
			$this->pr_02->TooltipValue = "";
			if (!$this->isExport())
				$this->pr_02->ViewValue = $this->highlightValue($this->pr_02);

			// qty_pr_02
			$this->qty_pr_02->LinkCustomAttributes = "";
			$this->qty_pr_02->HrefValue = "";
			$this->qty_pr_02->TooltipValue = "";

			// pl_02
			$this->pl_02->LinkCustomAttributes = "";
			$this->pl_02->HrefValue = "";
			$this->pl_02->TooltipValue = "";

			// qty_pl_02
			$this->qty_pl_02->LinkCustomAttributes = "";
			$this->qty_pl_02->HrefValue = "";
			$this->qty_pl_02->TooltipValue = "";

			// pr_03
			$this->pr_03->LinkCustomAttributes = "";
			$this->pr_03->HrefValue = "";
			$this->pr_03->TooltipValue = "";
			if (!$this->isExport())
				$this->pr_03->ViewValue = $this->highlightValue($this->pr_03);

			// qty_pr_03
			$this->qty_pr_03->LinkCustomAttributes = "";
			$this->qty_pr_03->HrefValue = "";
			$this->qty_pr_03->TooltipValue = "";

			// pl_03
			$this->pl_03->LinkCustomAttributes = "";
			$this->pl_03->HrefValue = "";
			$this->pl_03->TooltipValue = "";

			// qty_pl_03
			$this->qty_pl_03->LinkCustomAttributes = "";
			$this->qty_pl_03->HrefValue = "";
			$this->qty_pl_03->TooltipValue = "";

			// pr_04
			$this->pr_04->LinkCustomAttributes = "";
			$this->pr_04->HrefValue = "";
			$this->pr_04->TooltipValue = "";
			if (!$this->isExport())
				$this->pr_04->ViewValue = $this->highlightValue($this->pr_04);

			// qty_pr_04
			$this->qty_pr_04->LinkCustomAttributes = "";
			$this->qty_pr_04->HrefValue = "";
			$this->qty_pr_04->TooltipValue = "";

			// pl_04
			$this->pl_04->LinkCustomAttributes = "";
			$this->pl_04->HrefValue = "";
			$this->pl_04->TooltipValue = "";

			// qty_pl_04
			$this->qty_pl_04->LinkCustomAttributes = "";
			$this->qty_pl_04->HrefValue = "";
			$this->qty_pl_04->TooltipValue = "";

			// pa_01
			$this->pa_01->LinkCustomAttributes = "";
			$this->pa_01->HrefValue = "";
			$this->pa_01->TooltipValue = "";
			if (!$this->isExport())
				$this->pa_01->ViewValue = $this->highlightValue($this->pa_01);

			// qty_pa_01
			$this->qty_pa_01->LinkCustomAttributes = "";
			$this->qty_pa_01->HrefValue = "";
			$this->qty_pa_01->TooltipValue = "";

			// pa_02
			$this->pa_02->LinkCustomAttributes = "";
			$this->pa_02->HrefValue = "";
			$this->pa_02->TooltipValue = "";
			if (!$this->isExport())
				$this->pa_02->ViewValue = $this->highlightValue($this->pa_02);

			// qty_pa_02
			$this->qty_pa_02->LinkCustomAttributes = "";
			$this->qty_pa_02->HrefValue = "";
			$this->qty_pa_02->TooltipValue = "";

			// pa_03
			$this->pa_03->LinkCustomAttributes = "";
			$this->pa_03->HrefValue = "";
			$this->pa_03->TooltipValue = "";
			if (!$this->isExport())
				$this->pa_03->ViewValue = $this->highlightValue($this->pa_03);

			// qty_pa_03
			$this->qty_pa_03->LinkCustomAttributes = "";
			$this->qty_pa_03->HrefValue = "";
			$this->qty_pa_03->TooltipValue = "";

			// pa_04
			$this->pa_04->LinkCustomAttributes = "";
			$this->pa_04->HrefValue = "";
			$this->pa_04->TooltipValue = "";

			// qty_pa_04
			$this->qty_pa_04->LinkCustomAttributes = "";
			$this->qty_pa_04->HrefValue = "";
			$this->qty_pa_04->TooltipValue = "";

			// pa_05
			$this->pa_05->LinkCustomAttributes = "";
			$this->pa_05->HrefValue = "";
			$this->pa_05->TooltipValue = "";
			if (!$this->isExport())
				$this->pa_05->ViewValue = $this->highlightValue($this->pa_05);

			// qty_pa_05
			$this->qty_pa_05->LinkCustomAttributes = "";
			$this->qty_pa_05->HrefValue = "";
			$this->qty_pa_05->TooltipValue = "";

			// pc_01
			$this->pc_01->LinkCustomAttributes = "";
			$this->pc_01->HrefValue = "";
			$this->pc_01->TooltipValue = "";

			// qty_pc_01
			$this->qty_pc_01->LinkCustomAttributes = "";
			$this->qty_pc_01->HrefValue = "";
			$this->qty_pc_01->TooltipValue = "";

			// pc_02
			$this->pc_02->LinkCustomAttributes = "";
			$this->pc_02->HrefValue = "";
			$this->pc_02->TooltipValue = "";

			// qty_pc_02
			$this->qty_pc_02->LinkCustomAttributes = "";
			$this->qty_pc_02->HrefValue = "";
			$this->qty_pc_02->TooltipValue = "";

			// o_01
			$this->o_01->LinkCustomAttributes = "";
			$this->o_01->HrefValue = "";
			$this->o_01->TooltipValue = "";

			// qty_o_01
			$this->qty_o_01->LinkCustomAttributes = "";
			$this->qty_o_01->HrefValue = "";
			$this->qty_o_01->TooltipValue = "";

			// lamination_type
			$this->lamination_type->LinkCustomAttributes = "";
			$this->lamination_type->HrefValue = "";
			$this->lamination_type->TooltipValue = "";

			// lamination_qty
			$this->lamination_qty->LinkCustomAttributes = "";
			$this->lamination_qty->HrefValue = "";
			$this->lamination_qty->TooltipValue = "";

			// die_type
			$this->die_type->LinkCustomAttributes = "";
			$this->die_type->HrefValue = "";
			$this->die_type->TooltipValue = "";
			if (!$this->isExport())
				$this->die_type->ViewValue = $this->highlightValue($this->die_type);

			// die_qty
			$this->die_qty->LinkCustomAttributes = "";
			$this->die_qty->HrefValue = "";
			$this->die_qty->TooltipValue = "";

			// binding_type
			$this->binding_type->LinkCustomAttributes = "";
			$this->binding_type->HrefValue = "";
			$this->binding_type->TooltipValue = "";

			// binding_qty
			$this->binding_qty->LinkCustomAttributes = "";
			$this->binding_qty->HrefValue = "";
			$this->binding_qty->TooltipValue = "";

			// number_type
			$this->number_type->LinkCustomAttributes = "";
			$this->number_type->HrefValue = "";
			$this->number_type->TooltipValue = "";

			// number_qty
			$this->number_qty->LinkCustomAttributes = "";
			$this->number_qty->HrefValue = "";
			$this->number_qty->TooltipValue = "";

			// de_01
			$this->de_01->LinkCustomAttributes = "";
			$this->de_01->HrefValue = "";
			$this->de_01->TooltipValue = "";
			if (!$this->isExport())
				$this->de_01->ViewValue = $this->highlightValue($this->de_01);

			// qty_de_01
			$this->qty_de_01->LinkCustomAttributes = "";
			$this->qty_de_01->HrefValue = "";
			$this->qty_de_01->TooltipValue = "";

			// de_02
			$this->de_02->LinkCustomAttributes = "";
			$this->de_02->HrefValue = "";
			$this->de_02->TooltipValue = "";

			// qty_de_02
			$this->qty_de_02->LinkCustomAttributes = "";
			$this->qty_de_02->HrefValue = "";
			$this->qty_de_02->TooltipValue = "";

			// de_03
			$this->de_03->LinkCustomAttributes = "";
			$this->de_03->HrefValue = "";
			$this->de_03->TooltipValue = "";
			if (!$this->isExport())
				$this->de_03->ViewValue = $this->highlightValue($this->de_03);

			// qty_de_03
			$this->qty_de_03->LinkCustomAttributes = "";
			$this->qty_de_03->HrefValue = "";
			$this->qty_de_03->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->job_type->AdvancedSearch->load();
		$this->job_category->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->description->AdvancedSearch->load();
		$this->size->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->pages->AdvancedSearch->load();
		$this->paper->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->pr_01->AdvancedSearch->load();
		$this->qty_pr_01->AdvancedSearch->load();
		$this->pl_01->AdvancedSearch->load();
		$this->qty_pl_01->AdvancedSearch->load();
		$this->pr_02->AdvancedSearch->load();
		$this->qty_pr_02->AdvancedSearch->load();
		$this->pl_02->AdvancedSearch->load();
		$this->qty_pl_02->AdvancedSearch->load();
		$this->pr_03->AdvancedSearch->load();
		$this->qty_pr_03->AdvancedSearch->load();
		$this->pl_03->AdvancedSearch->load();
		$this->qty_pl_03->AdvancedSearch->load();
		$this->pr_04->AdvancedSearch->load();
		$this->qty_pr_04->AdvancedSearch->load();
		$this->pl_04->AdvancedSearch->load();
		$this->qty_pl_04->AdvancedSearch->load();
		$this->pa_01->AdvancedSearch->load();
		$this->qty_pa_01->AdvancedSearch->load();
		$this->pa_02->AdvancedSearch->load();
		$this->qty_pa_02->AdvancedSearch->load();
		$this->pa_03->AdvancedSearch->load();
		$this->qty_pa_03->AdvancedSearch->load();
		$this->pa_04->AdvancedSearch->load();
		$this->qty_pa_04->AdvancedSearch->load();
		$this->pa_05->AdvancedSearch->load();
		$this->qty_pa_05->AdvancedSearch->load();
		$this->pc_01->AdvancedSearch->load();
		$this->qty_pc_01->AdvancedSearch->load();
		$this->pc_02->AdvancedSearch->load();
		$this->qty_pc_02->AdvancedSearch->load();
		$this->o_01->AdvancedSearch->load();
		$this->qty_o_01->AdvancedSearch->load();
		$this->lamination_type->AdvancedSearch->load();
		$this->lamination_qty->AdvancedSearch->load();
		$this->die_type->AdvancedSearch->load();
		$this->die_qty->AdvancedSearch->load();
		$this->binding_type->AdvancedSearch->load();
		$this->binding_qty->AdvancedSearch->load();
		$this->number_type->AdvancedSearch->load();
		$this->number_qty->AdvancedSearch->load();
		$this->de_01->AdvancedSearch->load();
		$this->qty_de_01->AdvancedSearch->load();
		$this->de_02->AdvancedSearch->load();
		$this->qty_de_02->AdvancedSearch->load();
		$this->de_03->AdvancedSearch->load();
		$this->qty_de_03->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fp_eastimatelist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fp_eastimatelist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fp_eastimatelist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_p_eastimate\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_p_eastimate',hdr:ew.language.phrase('ExportToEmailText'),f:document.fp_eastimatelist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_size":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_01":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_01":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_02":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_02":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_03":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_03":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_04":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_04":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_01":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_02":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_03":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_04":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_05":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pc_01":
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pc_02":
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_o_01":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_lamination_type":
					$lookupFilter = function() {
						return "`s_grp` IN (123) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_die_type":
					$lookupFilter = function() {
						return "`s_grp` IN (124) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_binding_type":
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_number_type":
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_01":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_02":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_03":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_size":
							break;
						case "x_pr_01":
							break;
						case "x_pl_01":
							break;
						case "x_pr_02":
							break;
						case "x_pl_02":
							break;
						case "x_pr_03":
							break;
						case "x_pl_03":
							break;
						case "x_pr_04":
							break;
						case "x_pl_04":
							break;
						case "x_pa_01":
							break;
						case "x_pa_02":
							break;
						case "x_pa_03":
							break;
						case "x_pa_04":
							break;
						case "x_pa_05":
							break;
						case "x_pc_01":
							break;
						case "x_pc_02":
							break;
						case "x_o_01":
							break;
						case "x_lamination_type":
							break;
						case "x_die_type":
							break;
						case "x_binding_type":
							break;
						case "x_number_type":
							break;
						case "x_de_01":
							break;
						case "x_de_02":
							break;
						case "x_de_03":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>