<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class p_eastimate_search extends p_eastimate
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'p_eastimate';

	// Page object name
	public $PageObjName = "p_eastimate_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (p_eastimate)
		if (!isset($GLOBALS["p_eastimate"]) || get_class($GLOBALS["p_eastimate"]) == PROJECT_NAMESPACE . "p_eastimate") {
			$GLOBALS["p_eastimate"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["p_eastimate"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_eastimate');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $p_eastimate;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($p_eastimate);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "p_eastimateview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("p_eastimatelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->job_type->setVisibility();
		$this->job_category->setVisibility();
		$this->company_id->setVisibility();
		$this->description->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->pages->setVisibility();
		$this->paper->setVisibility();
		$this->remarks->setVisibility();
		$this->pr_01->setVisibility();
		$this->qty_pr_01->setVisibility();
		$this->pl_01->setVisibility();
		$this->qty_pl_01->setVisibility();
		$this->pr_02->setVisibility();
		$this->qty_pr_02->setVisibility();
		$this->pl_02->setVisibility();
		$this->qty_pl_02->setVisibility();
		$this->pr_03->setVisibility();
		$this->qty_pr_03->setVisibility();
		$this->pl_03->setVisibility();
		$this->qty_pl_03->setVisibility();
		$this->pr_04->setVisibility();
		$this->qty_pr_04->setVisibility();
		$this->pl_04->setVisibility();
		$this->qty_pl_04->setVisibility();
		$this->pa_01->setVisibility();
		$this->qty_pa_01->setVisibility();
		$this->pa_02->setVisibility();
		$this->qty_pa_02->setVisibility();
		$this->pa_03->setVisibility();
		$this->qty_pa_03->setVisibility();
		$this->pa_04->setVisibility();
		$this->qty_pa_04->setVisibility();
		$this->pa_05->setVisibility();
		$this->qty_pa_05->setVisibility();
		$this->pc_01->setVisibility();
		$this->qty_pc_01->setVisibility();
		$this->pc_02->setVisibility();
		$this->qty_pc_02->setVisibility();
		$this->o_01->setVisibility();
		$this->qty_o_01->setVisibility();
		$this->lamination_type->setVisibility();
		$this->lamination_qty->setVisibility();
		$this->die_type->setVisibility();
		$this->die_qty->setVisibility();
		$this->binding_type->setVisibility();
		$this->binding_qty->setVisibility();
		$this->number_type->setVisibility();
		$this->number_qty->setVisibility();
		$this->de_01->setVisibility();
		$this->qty_de_01->setVisibility();
		$this->de_02->setVisibility();
		$this->qty_de_02->setVisibility();
		$this->de_03->setVisibility();
		$this->qty_de_03->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->size);
		$this->setupLookupOptions($this->pr_01);
		$this->setupLookupOptions($this->pl_01);
		$this->setupLookupOptions($this->pr_02);
		$this->setupLookupOptions($this->pl_02);
		$this->setupLookupOptions($this->pr_03);
		$this->setupLookupOptions($this->pl_03);
		$this->setupLookupOptions($this->pr_04);
		$this->setupLookupOptions($this->pl_04);
		$this->setupLookupOptions($this->pa_01);
		$this->setupLookupOptions($this->pa_02);
		$this->setupLookupOptions($this->pa_03);
		$this->setupLookupOptions($this->pa_04);
		$this->setupLookupOptions($this->pa_05);
		$this->setupLookupOptions($this->pc_01);
		$this->setupLookupOptions($this->pc_02);
		$this->setupLookupOptions($this->o_01);
		$this->setupLookupOptions($this->lamination_type);
		$this->setupLookupOptions($this->die_type);
		$this->setupLookupOptions($this->binding_type);
		$this->setupLookupOptions($this->number_type);
		$this->setupLookupOptions($this->de_01);
		$this->setupLookupOptions($this->de_02);
		$this->setupLookupOptions($this->de_03);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "p_eastimatelist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->job_type); // job_type
		$this->buildSearchUrl($srchUrl, $this->job_category); // job_category
		$this->buildSearchUrl($srchUrl, $this->company_id); // company_id
		$this->buildSearchUrl($srchUrl, $this->description); // description
		$this->buildSearchUrl($srchUrl, $this->size); // size
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->pages); // pages
		$this->buildSearchUrl($srchUrl, $this->paper); // paper
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->pr_01); // pr_01
		$this->buildSearchUrl($srchUrl, $this->qty_pr_01); // qty_pr_01
		$this->buildSearchUrl($srchUrl, $this->pl_01); // pl_01
		$this->buildSearchUrl($srchUrl, $this->qty_pl_01); // qty_pl_01
		$this->buildSearchUrl($srchUrl, $this->pr_02); // pr_02
		$this->buildSearchUrl($srchUrl, $this->qty_pr_02); // qty_pr_02
		$this->buildSearchUrl($srchUrl, $this->pl_02); // pl_02
		$this->buildSearchUrl($srchUrl, $this->qty_pl_02); // qty_pl_02
		$this->buildSearchUrl($srchUrl, $this->pr_03); // pr_03
		$this->buildSearchUrl($srchUrl, $this->qty_pr_03); // qty_pr_03
		$this->buildSearchUrl($srchUrl, $this->pl_03); // pl_03
		$this->buildSearchUrl($srchUrl, $this->qty_pl_03); // qty_pl_03
		$this->buildSearchUrl($srchUrl, $this->pr_04); // pr_04
		$this->buildSearchUrl($srchUrl, $this->qty_pr_04); // qty_pr_04
		$this->buildSearchUrl($srchUrl, $this->pl_04); // pl_04
		$this->buildSearchUrl($srchUrl, $this->qty_pl_04); // qty_pl_04
		$this->buildSearchUrl($srchUrl, $this->pa_01); // pa_01
		$this->buildSearchUrl($srchUrl, $this->qty_pa_01); // qty_pa_01
		$this->buildSearchUrl($srchUrl, $this->pa_02); // pa_02
		$this->buildSearchUrl($srchUrl, $this->qty_pa_02); // qty_pa_02
		$this->buildSearchUrl($srchUrl, $this->pa_03); // pa_03
		$this->buildSearchUrl($srchUrl, $this->qty_pa_03); // qty_pa_03
		$this->buildSearchUrl($srchUrl, $this->pa_04); // pa_04
		$this->buildSearchUrl($srchUrl, $this->qty_pa_04); // qty_pa_04
		$this->buildSearchUrl($srchUrl, $this->pa_05); // pa_05
		$this->buildSearchUrl($srchUrl, $this->qty_pa_05); // qty_pa_05
		$this->buildSearchUrl($srchUrl, $this->pc_01); // pc_01
		$this->buildSearchUrl($srchUrl, $this->qty_pc_01); // qty_pc_01
		$this->buildSearchUrl($srchUrl, $this->pc_02); // pc_02
		$this->buildSearchUrl($srchUrl, $this->qty_pc_02); // qty_pc_02
		$this->buildSearchUrl($srchUrl, $this->o_01); // o_01
		$this->buildSearchUrl($srchUrl, $this->qty_o_01); // qty_o_01
		$this->buildSearchUrl($srchUrl, $this->lamination_type); // lamination_type
		$this->buildSearchUrl($srchUrl, $this->lamination_qty); // lamination_qty
		$this->buildSearchUrl($srchUrl, $this->die_type); // die_type
		$this->buildSearchUrl($srchUrl, $this->die_qty); // die_qty
		$this->buildSearchUrl($srchUrl, $this->binding_type); // binding_type
		$this->buildSearchUrl($srchUrl, $this->binding_qty); // binding_qty
		$this->buildSearchUrl($srchUrl, $this->number_type); // number_type
		$this->buildSearchUrl($srchUrl, $this->number_qty); // number_qty
		$this->buildSearchUrl($srchUrl, $this->de_01); // de_01
		$this->buildSearchUrl($srchUrl, $this->qty_de_01); // qty_de_01
		$this->buildSearchUrl($srchUrl, $this->de_02); // de_02
		$this->buildSearchUrl($srchUrl, $this->qty_de_02); // qty_de_02
		$this->buildSearchUrl($srchUrl, $this->de_03); // de_03
		$this->buildSearchUrl($srchUrl, $this->qty_de_03); // qty_de_03
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// job_type
		if (!$this->isAddOrEdit())
			$this->job_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_job_type"));
		$this->job_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_job_type"));

		// job_category
		if (!$this->isAddOrEdit())
			$this->job_category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_job_category"));
		$this->job_category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_job_category"));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_company_id"));
		$this->company_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_company_id"));

		// description
		if (!$this->isAddOrEdit())
			$this->description->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description"));
		$this->description->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description"));

		// size
		if (!$this->isAddOrEdit())
			$this->size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size"));
		$this->size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// pages
		if (!$this->isAddOrEdit())
			$this->pages->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pages"));
		$this->pages->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pages"));

		// paper
		if (!$this->isAddOrEdit())
			$this->paper->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_paper"));
		$this->paper->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_paper"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// pr_01
		if (!$this->isAddOrEdit())
			$this->pr_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pr_01"));
		$this->pr_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pr_01"));

		// qty_pr_01
		if (!$this->isAddOrEdit())
			$this->qty_pr_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pr_01"));
		$this->qty_pr_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pr_01"));

		// pl_01
		if (!$this->isAddOrEdit())
			$this->pl_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_01"));
		$this->pl_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_01"));

		// qty_pl_01
		if (!$this->isAddOrEdit())
			$this->qty_pl_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pl_01"));
		$this->qty_pl_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pl_01"));

		// pr_02
		if (!$this->isAddOrEdit())
			$this->pr_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pr_02"));
		$this->pr_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pr_02"));

		// qty_pr_02
		if (!$this->isAddOrEdit())
			$this->qty_pr_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pr_02"));
		$this->qty_pr_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pr_02"));

		// pl_02
		if (!$this->isAddOrEdit())
			$this->pl_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_02"));
		$this->pl_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_02"));

		// qty_pl_02
		if (!$this->isAddOrEdit())
			$this->qty_pl_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pl_02"));
		$this->qty_pl_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pl_02"));

		// pr_03
		if (!$this->isAddOrEdit())
			$this->pr_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pr_03"));
		$this->pr_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pr_03"));

		// qty_pr_03
		if (!$this->isAddOrEdit())
			$this->qty_pr_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pr_03"));
		$this->qty_pr_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pr_03"));

		// pl_03
		if (!$this->isAddOrEdit())
			$this->pl_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_03"));
		$this->pl_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_03"));

		// qty_pl_03
		if (!$this->isAddOrEdit())
			$this->qty_pl_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pl_03"));
		$this->qty_pl_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pl_03"));

		// pr_04
		if (!$this->isAddOrEdit())
			$this->pr_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pr_04"));
		$this->pr_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pr_04"));

		// qty_pr_04
		if (!$this->isAddOrEdit())
			$this->qty_pr_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pr_04"));
		$this->qty_pr_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pr_04"));

		// pl_04
		if (!$this->isAddOrEdit())
			$this->pl_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_04"));
		$this->pl_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_04"));

		// qty_pl_04
		if (!$this->isAddOrEdit())
			$this->qty_pl_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pl_04"));
		$this->qty_pl_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pl_04"));

		// pa_01
		if (!$this->isAddOrEdit())
			$this->pa_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pa_01"));
		$this->pa_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pa_01"));

		// qty_pa_01
		if (!$this->isAddOrEdit())
			$this->qty_pa_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pa_01"));
		$this->qty_pa_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pa_01"));

		// pa_02
		if (!$this->isAddOrEdit())
			$this->pa_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pa_02"));
		$this->pa_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pa_02"));

		// qty_pa_02
		if (!$this->isAddOrEdit())
			$this->qty_pa_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pa_02"));
		$this->qty_pa_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pa_02"));

		// pa_03
		if (!$this->isAddOrEdit())
			$this->pa_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pa_03"));
		$this->pa_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pa_03"));

		// qty_pa_03
		if (!$this->isAddOrEdit())
			$this->qty_pa_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pa_03"));
		$this->qty_pa_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pa_03"));

		// pa_04
		if (!$this->isAddOrEdit())
			$this->pa_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pa_04"));
		$this->pa_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pa_04"));

		// qty_pa_04
		if (!$this->isAddOrEdit())
			$this->qty_pa_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pa_04"));
		$this->qty_pa_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pa_04"));

		// pa_05
		if (!$this->isAddOrEdit())
			$this->pa_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pa_05"));
		$this->pa_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pa_05"));

		// qty_pa_05
		if (!$this->isAddOrEdit())
			$this->qty_pa_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pa_05"));
		$this->qty_pa_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pa_05"));

		// pc_01
		if (!$this->isAddOrEdit())
			$this->pc_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_01"));
		$this->pc_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_01"));

		// qty_pc_01
		if (!$this->isAddOrEdit())
			$this->qty_pc_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pc_01"));
		$this->qty_pc_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pc_01"));

		// pc_02
		if (!$this->isAddOrEdit())
			$this->pc_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_02"));
		$this->pc_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_02"));

		// qty_pc_02
		if (!$this->isAddOrEdit())
			$this->qty_pc_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_pc_02"));
		$this->qty_pc_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_pc_02"));

		// o_01
		if (!$this->isAddOrEdit())
			$this->o_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_o_01"));
		$this->o_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_o_01"));

		// qty_o_01
		if (!$this->isAddOrEdit())
			$this->qty_o_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_o_01"));
		$this->qty_o_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_o_01"));

		// lamination_type
		if (!$this->isAddOrEdit())
			$this->lamination_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lamination_type"));
		$this->lamination_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lamination_type"));

		// lamination_qty
		if (!$this->isAddOrEdit())
			$this->lamination_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lamination_qty"));
		$this->lamination_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lamination_qty"));

		// die_type
		if (!$this->isAddOrEdit())
			$this->die_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_die_type"));
		$this->die_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_die_type"));

		// die_qty
		if (!$this->isAddOrEdit())
			$this->die_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_die_qty"));
		$this->die_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_die_qty"));

		// binding_type
		if (!$this->isAddOrEdit())
			$this->binding_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_binding_type"));
		$this->binding_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_binding_type"));

		// binding_qty
		if (!$this->isAddOrEdit())
			$this->binding_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_binding_qty"));
		$this->binding_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_binding_qty"));

		// number_type
		if (!$this->isAddOrEdit())
			$this->number_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_number_type"));
		$this->number_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_number_type"));

		// number_qty
		if (!$this->isAddOrEdit())
			$this->number_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_number_qty"));
		$this->number_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_number_qty"));

		// de_01
		if (!$this->isAddOrEdit())
			$this->de_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_de_01"));
		$this->de_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_de_01"));

		// qty_de_01
		if (!$this->isAddOrEdit())
			$this->qty_de_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_de_01"));
		$this->qty_de_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_de_01"));

		// de_02
		if (!$this->isAddOrEdit())
			$this->de_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_de_02"));
		$this->de_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_de_02"));

		// qty_de_02
		if (!$this->isAddOrEdit())
			$this->qty_de_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_de_02"));
		$this->qty_de_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_de_02"));

		// de_03
		if (!$this->isAddOrEdit())
			$this->de_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_de_03"));
		$this->de_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_de_03"));

		// qty_de_03
		if (!$this->isAddOrEdit())
			$this->qty_de_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty_de_03"));
		$this->qty_de_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty_de_03"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_01->FormValue == $this->qty_pr_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_01->CurrentValue)))
			$this->qty_pr_01->CurrentValue = ConvertToFloatString($this->qty_pr_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_01->FormValue == $this->qty_pl_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_01->CurrentValue)))
			$this->qty_pl_01->CurrentValue = ConvertToFloatString($this->qty_pl_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_02->FormValue == $this->qty_pr_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_02->CurrentValue)))
			$this->qty_pr_02->CurrentValue = ConvertToFloatString($this->qty_pr_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_02->FormValue == $this->qty_pl_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_02->CurrentValue)))
			$this->qty_pl_02->CurrentValue = ConvertToFloatString($this->qty_pl_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_03->FormValue == $this->qty_pr_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_03->CurrentValue)))
			$this->qty_pr_03->CurrentValue = ConvertToFloatString($this->qty_pr_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_03->FormValue == $this->qty_pl_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_03->CurrentValue)))
			$this->qty_pl_03->CurrentValue = ConvertToFloatString($this->qty_pl_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_04->FormValue == $this->qty_pr_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_04->CurrentValue)))
			$this->qty_pr_04->CurrentValue = ConvertToFloatString($this->qty_pr_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_04->FormValue == $this->qty_pl_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_04->CurrentValue)))
			$this->qty_pl_04->CurrentValue = ConvertToFloatString($this->qty_pl_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_01->FormValue == $this->qty_pa_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_01->CurrentValue)))
			$this->qty_pa_01->CurrentValue = ConvertToFloatString($this->qty_pa_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_02->FormValue == $this->qty_pa_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_02->CurrentValue)))
			$this->qty_pa_02->CurrentValue = ConvertToFloatString($this->qty_pa_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_03->FormValue == $this->qty_pa_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_03->CurrentValue)))
			$this->qty_pa_03->CurrentValue = ConvertToFloatString($this->qty_pa_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_04->FormValue == $this->qty_pa_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_04->CurrentValue)))
			$this->qty_pa_04->CurrentValue = ConvertToFloatString($this->qty_pa_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_05->FormValue == $this->qty_pa_05->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_05->CurrentValue)))
			$this->qty_pa_05->CurrentValue = ConvertToFloatString($this->qty_pa_05->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pc_01->FormValue == $this->qty_pc_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pc_01->CurrentValue)))
			$this->qty_pc_01->CurrentValue = ConvertToFloatString($this->qty_pc_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pc_02->FormValue == $this->qty_pc_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pc_02->CurrentValue)))
			$this->qty_pc_02->CurrentValue = ConvertToFloatString($this->qty_pc_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_o_01->FormValue == $this->qty_o_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_o_01->CurrentValue)))
			$this->qty_o_01->CurrentValue = ConvertToFloatString($this->qty_o_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->binding_qty->FormValue == $this->binding_qty->CurrentValue && is_numeric(ConvertToFloatString($this->binding_qty->CurrentValue)))
			$this->binding_qty->CurrentValue = ConvertToFloatString($this->binding_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_01->FormValue == $this->qty_de_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_01->CurrentValue)))
			$this->qty_de_01->CurrentValue = ConvertToFloatString($this->qty_de_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_02->FormValue == $this->qty_de_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_02->CurrentValue)))
			$this->qty_de_02->CurrentValue = ConvertToFloatString($this->qty_de_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_03->FormValue == $this->qty_de_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_03->CurrentValue)))
			$this->qty_de_03->CurrentValue = ConvertToFloatString($this->qty_de_03->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// job_type
		// job_category
		// company_id
		// description
		// size
		// quantity
		// pages
		// paper
		// remarks
		// pr_01
		// qty_pr_01
		// pl_01
		// qty_pl_01
		// pr_02
		// qty_pr_02
		// pl_02
		// qty_pl_02
		// pr_03
		// qty_pr_03
		// pl_03
		// qty_pl_03
		// pr_04
		// qty_pr_04
		// pl_04
		// qty_pl_04
		// pa_01
		// qty_pa_01
		// pa_02
		// qty_pa_02
		// pa_03
		// qty_pa_03
		// pa_04
		// qty_pa_04
		// pa_05
		// qty_pa_05
		// pc_01
		// qty_pc_01
		// pc_02
		// qty_pc_02
		// o_01
		// qty_o_01
		// lamination_type
		// lamination_qty
		// die_type
		// die_qty
		// binding_type
		// binding_qty
		// number_type
		// number_qty
		// de_01
		// qty_de_01
		// de_02
		// qty_de_02
		// de_03
		// qty_de_03
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// job_type
			if (strval($this->job_type->CurrentValue) <> "") {
				$this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
			} else {
				$this->job_type->ViewValue = NULL;
			}
			$this->job_type->ViewCustomAttributes = "";

			// job_category
			if (strval($this->job_category->CurrentValue) <> "") {
				$this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
			} else {
				$this->job_category->ViewValue = NULL;
			}
			$this->job_category->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// size
			$curVal = strval($this->size->CurrentValue);
			if ($curVal <> "") {
				$this->size->ViewValue = $this->size->lookupCacheOption($curVal);
				if ($this->size->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`description`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->size->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->size->ViewValue = $this->size->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->size->ViewValue = $this->size->CurrentValue;
					}
				}
			} else {
				$this->size->ViewValue = NULL;
			}
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// pages
			$this->pages->ViewValue = $this->pages->CurrentValue;
			$this->pages->ViewCustomAttributes = "";

			// paper
			$this->paper->ViewValue = $this->paper->CurrentValue;
			$this->paper->ViewValue = FormatNumber($this->paper->ViewValue, 0, -2, -2, -2);
			$this->paper->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// pr_01
			if ($this->pr_01->VirtualValue <> "") {
				$this->pr_01->ViewValue = $this->pr_01->VirtualValue;
			} else {
			$curVal = strval($this->pr_01->CurrentValue);
			if ($curVal <> "") {
				$this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
				if ($this->pr_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_01->ViewValue = $this->pr_01->CurrentValue;
					}
				}
			} else {
				$this->pr_01->ViewValue = NULL;
			}
			}
			$this->pr_01->ViewCustomAttributes = "";

			// qty_pr_01
			$this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
			$this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_01->ViewCustomAttributes = "";

			// pl_01
			$curVal = strval($this->pl_01->CurrentValue);
			if ($curVal <> "") {
				$this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
				if ($this->pl_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_01->ViewValue = $this->pl_01->CurrentValue;
					}
				}
			} else {
				$this->pl_01->ViewValue = NULL;
			}
			$this->pl_01->ViewCustomAttributes = "";

			// qty_pl_01
			$this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
			$this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_01->ViewCustomAttributes = "";

			// pr_02
			if ($this->pr_02->VirtualValue <> "") {
				$this->pr_02->ViewValue = $this->pr_02->VirtualValue;
			} else {
			$curVal = strval($this->pr_02->CurrentValue);
			if ($curVal <> "") {
				$this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
				if ($this->pr_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_02->ViewValue = $this->pr_02->CurrentValue;
					}
				}
			} else {
				$this->pr_02->ViewValue = NULL;
			}
			}
			$this->pr_02->ViewCustomAttributes = "";

			// qty_pr_02
			$this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
			$this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_02->ViewCustomAttributes = "";

			// pl_02
			$curVal = strval($this->pl_02->CurrentValue);
			if ($curVal <> "") {
				$this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
				if ($this->pl_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_02->ViewValue = $this->pl_02->CurrentValue;
					}
				}
			} else {
				$this->pl_02->ViewValue = NULL;
			}
			$this->pl_02->ViewCustomAttributes = "";

			// qty_pl_02
			$this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
			$this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_02->ViewCustomAttributes = "";

			// pr_03
			if ($this->pr_03->VirtualValue <> "") {
				$this->pr_03->ViewValue = $this->pr_03->VirtualValue;
			} else {
			$curVal = strval($this->pr_03->CurrentValue);
			if ($curVal <> "") {
				$this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
				if ($this->pr_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_03->ViewValue = $this->pr_03->CurrentValue;
					}
				}
			} else {
				$this->pr_03->ViewValue = NULL;
			}
			}
			$this->pr_03->ViewCustomAttributes = "";

			// qty_pr_03
			$this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
			$this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_03->ViewCustomAttributes = "";

			// pl_03
			$curVal = strval($this->pl_03->CurrentValue);
			if ($curVal <> "") {
				$this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
				if ($this->pl_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_03->ViewValue = $this->pl_03->CurrentValue;
					}
				}
			} else {
				$this->pl_03->ViewValue = NULL;
			}
			$this->pl_03->ViewCustomAttributes = "";

			// qty_pl_03
			$this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
			$this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_03->ViewCustomAttributes = "";

			// pr_04
			if ($this->pr_04->VirtualValue <> "") {
				$this->pr_04->ViewValue = $this->pr_04->VirtualValue;
			} else {
			$curVal = strval($this->pr_04->CurrentValue);
			if ($curVal <> "") {
				$this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
				if ($this->pr_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_04->ViewValue = $this->pr_04->CurrentValue;
					}
				}
			} else {
				$this->pr_04->ViewValue = NULL;
			}
			}
			$this->pr_04->ViewCustomAttributes = "";

			// qty_pr_04
			$this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
			$this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_04->ViewCustomAttributes = "";

			// pl_04
			$curVal = strval($this->pl_04->CurrentValue);
			if ($curVal <> "") {
				$this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
				if ($this->pl_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_04->ViewValue = $this->pl_04->CurrentValue;
					}
				}
			} else {
				$this->pl_04->ViewValue = NULL;
			}
			$this->pl_04->ViewCustomAttributes = "";

			// qty_pl_04
			$this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
			$this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_04->ViewCustomAttributes = "";

			// pa_01
			$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
			$curVal = strval($this->pa_01->CurrentValue);
			if ($curVal <> "") {
				$this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
				if ($this->pa_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
					}
				}
			} else {
				$this->pa_01->ViewValue = NULL;
			}
			$this->pa_01->ViewCustomAttributes = "";

			// qty_pa_01
			$this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
			$this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_01->ViewCustomAttributes = "";

			// pa_02
			$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
			$curVal = strval($this->pa_02->CurrentValue);
			if ($curVal <> "") {
				$this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
				if ($this->pa_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
					}
				}
			} else {
				$this->pa_02->ViewValue = NULL;
			}
			$this->pa_02->ViewCustomAttributes = "";

			// qty_pa_02
			$this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
			$this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_02->ViewCustomAttributes = "";

			// pa_03
			$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
			$curVal = strval($this->pa_03->CurrentValue);
			if ($curVal <> "") {
				$this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
				if ($this->pa_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
					}
				}
			} else {
				$this->pa_03->ViewValue = NULL;
			}
			$this->pa_03->ViewCustomAttributes = "";

			// qty_pa_03
			$this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
			$this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_03->ViewCustomAttributes = "";

			// pa_04
			$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
			$curVal = strval($this->pa_04->CurrentValue);
			if ($curVal <> "") {
				$this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
				if ($this->pa_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
					}
				}
			} else {
				$this->pa_04->ViewValue = NULL;
			}
			$this->pa_04->ViewCustomAttributes = "";

			// qty_pa_04
			$this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
			$this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_04->ViewCustomAttributes = "";

			// pa_05
			$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
			$curVal = strval($this->pa_05->CurrentValue);
			if ($curVal <> "") {
				$this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
				if ($this->pa_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
					}
				}
			} else {
				$this->pa_05->ViewValue = NULL;
			}
			$this->pa_05->ViewCustomAttributes = "";

			// qty_pa_05
			$this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
			$this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_05->ViewCustomAttributes = "";

			// pc_01
			$curVal = strval($this->pc_01->CurrentValue);
			if ($curVal <> "") {
				$this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
				if ($this->pc_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pc_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pc_01->ViewValue = $this->pc_01->CurrentValue;
					}
				}
			} else {
				$this->pc_01->ViewValue = NULL;
			}
			$this->pc_01->ViewCustomAttributes = "";

			// qty_pc_01
			$this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
			$this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pc_01->ViewCustomAttributes = "";

			// pc_02
			$curVal = strval($this->pc_02->CurrentValue);
			if ($curVal <> "") {
				$this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
				if ($this->pc_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pc_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pc_02->ViewValue = $this->pc_02->CurrentValue;
					}
				}
			} else {
				$this->pc_02->ViewValue = NULL;
			}
			$this->pc_02->ViewCustomAttributes = "";

			// qty_pc_02
			$this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
			$this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pc_02->ViewCustomAttributes = "";

			// o_01
			$curVal = strval($this->o_01->CurrentValue);
			if ($curVal <> "") {
				$this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
				if ($this->o_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->o_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->o_01->ViewValue = $this->o_01->CurrentValue;
					}
				}
			} else {
				$this->o_01->ViewValue = NULL;
			}
			$this->o_01->ViewCustomAttributes = "";

			// qty_o_01
			$this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
			$this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, 2, -2, -2, -2);
			$this->qty_o_01->ViewCustomAttributes = "";

			// lamination_type
			if ($this->lamination_type->VirtualValue <> "") {
				$this->lamination_type->ViewValue = $this->lamination_type->VirtualValue;
			} else {
			$curVal = strval($this->lamination_type->CurrentValue);
			if ($curVal <> "") {
				$this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
				if ($this->lamination_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (123) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->lamination_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
					}
				}
			} else {
				$this->lamination_type->ViewValue = NULL;
			}
			}
			$this->lamination_type->ViewCustomAttributes = "";

			// lamination_qty
			$this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
			$this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, 0, -2, -2, -2);
			$this->lamination_qty->ViewCustomAttributes = "";

			// die_type
			if ($this->die_type->VirtualValue <> "") {
				$this->die_type->ViewValue = $this->die_type->VirtualValue;
			} else {
			$curVal = strval($this->die_type->CurrentValue);
			if ($curVal <> "") {
				$this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
				if ($this->die_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (124) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->die_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->die_type->ViewValue = $this->die_type->CurrentValue;
					}
				}
			} else {
				$this->die_type->ViewValue = NULL;
			}
			}
			$this->die_type->ViewCustomAttributes = "";

			// die_qty
			$this->die_qty->ViewValue = $this->die_qty->CurrentValue;
			$this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, 0, -2, -2, -2);
			$this->die_qty->ViewCustomAttributes = "";

			// binding_type
			$curVal = strval($this->binding_type->CurrentValue);
			if ($curVal <> "") {
				$this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
				if ($this->binding_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->binding_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->binding_type->ViewValue = $this->binding_type->CurrentValue;
					}
				}
			} else {
				$this->binding_type->ViewValue = NULL;
			}
			$this->binding_type->ViewCustomAttributes = "";

			// binding_qty
			$this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
			$this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, 2, -2, -2, -2);
			$this->binding_qty->ViewCustomAttributes = "";

			// number_type
			if ($this->number_type->VirtualValue <> "") {
				$this->number_type->ViewValue = $this->number_type->VirtualValue;
			} else {
			$curVal = strval($this->number_type->CurrentValue);
			if ($curVal <> "") {
				$this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
				if ($this->number_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->number_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->number_type->ViewValue = $this->number_type->CurrentValue;
					}
				}
			} else {
				$this->number_type->ViewValue = NULL;
			}
			}
			$this->number_type->ViewCustomAttributes = "";

			// number_qty
			$this->number_qty->ViewValue = $this->number_qty->CurrentValue;
			$this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, 0, -2, -2, -2);
			$this->number_qty->ViewCustomAttributes = "";

			// de_01
			if ($this->de_01->VirtualValue <> "") {
				$this->de_01->ViewValue = $this->de_01->VirtualValue;
			} else {
			$curVal = strval($this->de_01->CurrentValue);
			if ($curVal <> "") {
				$this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
				if ($this->de_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_01->ViewValue = $this->de_01->CurrentValue;
					}
				}
			} else {
				$this->de_01->ViewValue = NULL;
			}
			}
			$this->de_01->ViewCustomAttributes = "";

			// qty_de_01
			$this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
			$this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, 2, -2, -2, -2);
			$this->qty_de_01->ViewCustomAttributes = "";

			// de_02
			if ($this->de_02->VirtualValue <> "") {
				$this->de_02->ViewValue = $this->de_02->VirtualValue;
			} else {
			$curVal = strval($this->de_02->CurrentValue);
			if ($curVal <> "") {
				$this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
				if ($this->de_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_02->ViewValue = $this->de_02->CurrentValue;
					}
				}
			} else {
				$this->de_02->ViewValue = NULL;
			}
			}
			$this->de_02->ViewCustomAttributes = "";

			// qty_de_02
			$this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
			$this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, 2, -2, -2, -2);
			$this->qty_de_02->ViewCustomAttributes = "";

			// de_03
			if ($this->de_03->VirtualValue <> "") {
				$this->de_03->ViewValue = $this->de_03->VirtualValue;
			} else {
			$curVal = strval($this->de_03->CurrentValue);
			if ($curVal <> "") {
				$this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
				if ($this->de_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_03->ViewValue = $this->de_03->CurrentValue;
					}
				}
			} else {
				$this->de_03->ViewValue = NULL;
			}
			}
			$this->de_03->ViewCustomAttributes = "";

			// qty_de_03
			$this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
			$this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, 2, -2, -2, -2);
			$this->qty_de_03->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// job_type
			$this->job_type->LinkCustomAttributes = "";
			$this->job_type->HrefValue = "";
			$this->job_type->TooltipValue = "";

			// job_category
			$this->job_category->LinkCustomAttributes = "";
			$this->job_category->HrefValue = "";
			$this->job_category->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// pages
			$this->pages->LinkCustomAttributes = "";
			$this->pages->HrefValue = "";
			$this->pages->TooltipValue = "";

			// paper
			$this->paper->LinkCustomAttributes = "";
			$this->paper->HrefValue = "";
			$this->paper->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// pr_01
			$this->pr_01->LinkCustomAttributes = "";
			$this->pr_01->HrefValue = "";
			$this->pr_01->TooltipValue = "";

			// qty_pr_01
			$this->qty_pr_01->LinkCustomAttributes = "";
			$this->qty_pr_01->HrefValue = "";
			$this->qty_pr_01->TooltipValue = "";

			// pl_01
			$this->pl_01->LinkCustomAttributes = "";
			$this->pl_01->HrefValue = "";
			$this->pl_01->TooltipValue = "";

			// qty_pl_01
			$this->qty_pl_01->LinkCustomAttributes = "";
			$this->qty_pl_01->HrefValue = "";
			$this->qty_pl_01->TooltipValue = "";

			// pr_02
			$this->pr_02->LinkCustomAttributes = "";
			$this->pr_02->HrefValue = "";
			$this->pr_02->TooltipValue = "";

			// qty_pr_02
			$this->qty_pr_02->LinkCustomAttributes = "";
			$this->qty_pr_02->HrefValue = "";
			$this->qty_pr_02->TooltipValue = "";

			// pl_02
			$this->pl_02->LinkCustomAttributes = "";
			$this->pl_02->HrefValue = "";
			$this->pl_02->TooltipValue = "";

			// qty_pl_02
			$this->qty_pl_02->LinkCustomAttributes = "";
			$this->qty_pl_02->HrefValue = "";
			$this->qty_pl_02->TooltipValue = "";

			// pr_03
			$this->pr_03->LinkCustomAttributes = "";
			$this->pr_03->HrefValue = "";
			$this->pr_03->TooltipValue = "";

			// qty_pr_03
			$this->qty_pr_03->LinkCustomAttributes = "";
			$this->qty_pr_03->HrefValue = "";
			$this->qty_pr_03->TooltipValue = "";

			// pl_03
			$this->pl_03->LinkCustomAttributes = "";
			$this->pl_03->HrefValue = "";
			$this->pl_03->TooltipValue = "";

			// qty_pl_03
			$this->qty_pl_03->LinkCustomAttributes = "";
			$this->qty_pl_03->HrefValue = "";
			$this->qty_pl_03->TooltipValue = "";

			// pr_04
			$this->pr_04->LinkCustomAttributes = "";
			$this->pr_04->HrefValue = "";
			$this->pr_04->TooltipValue = "";

			// qty_pr_04
			$this->qty_pr_04->LinkCustomAttributes = "";
			$this->qty_pr_04->HrefValue = "";
			$this->qty_pr_04->TooltipValue = "";

			// pl_04
			$this->pl_04->LinkCustomAttributes = "";
			$this->pl_04->HrefValue = "";
			$this->pl_04->TooltipValue = "";

			// qty_pl_04
			$this->qty_pl_04->LinkCustomAttributes = "";
			$this->qty_pl_04->HrefValue = "";
			$this->qty_pl_04->TooltipValue = "";

			// pa_01
			$this->pa_01->LinkCustomAttributes = "";
			$this->pa_01->HrefValue = "";
			$this->pa_01->TooltipValue = "";

			// qty_pa_01
			$this->qty_pa_01->LinkCustomAttributes = "";
			$this->qty_pa_01->HrefValue = "";
			$this->qty_pa_01->TooltipValue = "";

			// pa_02
			$this->pa_02->LinkCustomAttributes = "";
			$this->pa_02->HrefValue = "";
			$this->pa_02->TooltipValue = "";

			// qty_pa_02
			$this->qty_pa_02->LinkCustomAttributes = "";
			$this->qty_pa_02->HrefValue = "";
			$this->qty_pa_02->TooltipValue = "";

			// pa_03
			$this->pa_03->LinkCustomAttributes = "";
			$this->pa_03->HrefValue = "";
			$this->pa_03->TooltipValue = "";

			// qty_pa_03
			$this->qty_pa_03->LinkCustomAttributes = "";
			$this->qty_pa_03->HrefValue = "";
			$this->qty_pa_03->TooltipValue = "";

			// pa_04
			$this->pa_04->LinkCustomAttributes = "";
			$this->pa_04->HrefValue = "";
			$this->pa_04->TooltipValue = "";

			// qty_pa_04
			$this->qty_pa_04->LinkCustomAttributes = "";
			$this->qty_pa_04->HrefValue = "";
			$this->qty_pa_04->TooltipValue = "";

			// pa_05
			$this->pa_05->LinkCustomAttributes = "";
			$this->pa_05->HrefValue = "";
			$this->pa_05->TooltipValue = "";

			// qty_pa_05
			$this->qty_pa_05->LinkCustomAttributes = "";
			$this->qty_pa_05->HrefValue = "";
			$this->qty_pa_05->TooltipValue = "";

			// pc_01
			$this->pc_01->LinkCustomAttributes = "";
			$this->pc_01->HrefValue = "";
			$this->pc_01->TooltipValue = "";

			// qty_pc_01
			$this->qty_pc_01->LinkCustomAttributes = "";
			$this->qty_pc_01->HrefValue = "";
			$this->qty_pc_01->TooltipValue = "";

			// pc_02
			$this->pc_02->LinkCustomAttributes = "";
			$this->pc_02->HrefValue = "";
			$this->pc_02->TooltipValue = "";

			// qty_pc_02
			$this->qty_pc_02->LinkCustomAttributes = "";
			$this->qty_pc_02->HrefValue = "";
			$this->qty_pc_02->TooltipValue = "";

			// o_01
			$this->o_01->LinkCustomAttributes = "";
			$this->o_01->HrefValue = "";
			$this->o_01->TooltipValue = "";

			// qty_o_01
			$this->qty_o_01->LinkCustomAttributes = "";
			$this->qty_o_01->HrefValue = "";
			$this->qty_o_01->TooltipValue = "";

			// lamination_type
			$this->lamination_type->LinkCustomAttributes = "";
			$this->lamination_type->HrefValue = "";
			$this->lamination_type->TooltipValue = "";

			// lamination_qty
			$this->lamination_qty->LinkCustomAttributes = "";
			$this->lamination_qty->HrefValue = "";
			$this->lamination_qty->TooltipValue = "";

			// die_type
			$this->die_type->LinkCustomAttributes = "";
			$this->die_type->HrefValue = "";
			$this->die_type->TooltipValue = "";

			// die_qty
			$this->die_qty->LinkCustomAttributes = "";
			$this->die_qty->HrefValue = "";
			$this->die_qty->TooltipValue = "";

			// binding_type
			$this->binding_type->LinkCustomAttributes = "";
			$this->binding_type->HrefValue = "";
			$this->binding_type->TooltipValue = "";

			// binding_qty
			$this->binding_qty->LinkCustomAttributes = "";
			$this->binding_qty->HrefValue = "";
			$this->binding_qty->TooltipValue = "";

			// number_type
			$this->number_type->LinkCustomAttributes = "";
			$this->number_type->HrefValue = "";
			$this->number_type->TooltipValue = "";

			// number_qty
			$this->number_qty->LinkCustomAttributes = "";
			$this->number_qty->HrefValue = "";
			$this->number_qty->TooltipValue = "";

			// de_01
			$this->de_01->LinkCustomAttributes = "";
			$this->de_01->HrefValue = "";
			$this->de_01->TooltipValue = "";

			// qty_de_01
			$this->qty_de_01->LinkCustomAttributes = "";
			$this->qty_de_01->HrefValue = "";
			$this->qty_de_01->TooltipValue = "";

			// de_02
			$this->de_02->LinkCustomAttributes = "";
			$this->de_02->HrefValue = "";
			$this->de_02->TooltipValue = "";

			// qty_de_02
			$this->qty_de_02->LinkCustomAttributes = "";
			$this->qty_de_02->HrefValue = "";
			$this->qty_de_02->TooltipValue = "";

			// de_03
			$this->de_03->LinkCustomAttributes = "";
			$this->de_03->HrefValue = "";
			$this->de_03->TooltipValue = "";

			// qty_de_03
			$this->qty_de_03->LinkCustomAttributes = "";
			$this->qty_de_03->HrefValue = "";
			$this->qty_de_03->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// job_type
			$this->job_type->EditCustomAttributes = "";
			$this->job_type->EditValue = $this->job_type->options(FALSE);

			// job_category
			$this->job_category->EditCustomAttributes = "";
			$this->job_category->EditValue = $this->job_category->options(FALSE);

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->AdvancedSearch->SearchValue);
			$curVal = strval($this->company_id->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
			$this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			$curVal = trim(strval($this->size->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->size->AdvancedSearch->ViewValue = $this->size->lookupCacheOption($curVal);
			else
				$this->size->AdvancedSearch->ViewValue = $this->size->Lookup !== NULL && is_array($this->size->Lookup->Options) ? $curVal : NULL;
			if ($this->size->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->size->EditValue = array_values($this->size->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`description`" . SearchString("=", $this->size->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->size->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->size->EditValue = $arwrk;
			}

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// pages
			$this->pages->EditAttrs["class"] = "form-control";
			$this->pages->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pages->AdvancedSearch->SearchValue = HtmlDecode($this->pages->AdvancedSearch->SearchValue);
			$this->pages->EditValue = HtmlEncode($this->pages->AdvancedSearch->SearchValue);
			$this->pages->PlaceHolder = RemoveHtml($this->pages->caption());

			// paper
			$this->paper->EditAttrs["class"] = "form-control";
			$this->paper->EditCustomAttributes = "";
			$this->paper->EditValue = HtmlEncode($this->paper->AdvancedSearch->SearchValue);
			$this->paper->PlaceHolder = RemoveHtml($this->paper->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// pr_01
			$this->pr_01->EditAttrs["class"] = "form-control";
			$this->pr_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pr_01->AdvancedSearch->SearchValue = HtmlDecode($this->pr_01->AdvancedSearch->SearchValue);
			$this->pr_01->EditValue = HtmlEncode($this->pr_01->AdvancedSearch->SearchValue);
			$this->pr_01->PlaceHolder = RemoveHtml($this->pr_01->caption());

			// qty_pr_01
			$this->qty_pr_01->EditAttrs["class"] = "form-control";
			$this->qty_pr_01->EditCustomAttributes = "";
			$this->qty_pr_01->EditValue = HtmlEncode($this->qty_pr_01->AdvancedSearch->SearchValue);
			$this->qty_pr_01->PlaceHolder = RemoveHtml($this->qty_pr_01->caption());

			// pl_01
			$this->pl_01->EditAttrs["class"] = "form-control";
			$this->pl_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_01->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->pl_01->AdvancedSearch->ViewValue = $this->pl_01->lookupCacheOption($curVal);
			else
				$this->pl_01->AdvancedSearch->ViewValue = $this->pl_01->Lookup !== NULL && is_array($this->pl_01->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_01->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->pl_01->EditValue = array_values($this->pl_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_01->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_01->EditValue = $arwrk;
			}

			// qty_pl_01
			$this->qty_pl_01->EditAttrs["class"] = "form-control";
			$this->qty_pl_01->EditCustomAttributes = "";
			$this->qty_pl_01->EditValue = HtmlEncode($this->qty_pl_01->AdvancedSearch->SearchValue);
			$this->qty_pl_01->PlaceHolder = RemoveHtml($this->qty_pl_01->caption());

			// pr_02
			$this->pr_02->EditAttrs["class"] = "form-control";
			$this->pr_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pr_02->AdvancedSearch->SearchValue = HtmlDecode($this->pr_02->AdvancedSearch->SearchValue);
			$this->pr_02->EditValue = HtmlEncode($this->pr_02->AdvancedSearch->SearchValue);
			$this->pr_02->PlaceHolder = RemoveHtml($this->pr_02->caption());

			// qty_pr_02
			$this->qty_pr_02->EditAttrs["class"] = "form-control";
			$this->qty_pr_02->EditCustomAttributes = "";
			$this->qty_pr_02->EditValue = HtmlEncode($this->qty_pr_02->AdvancedSearch->SearchValue);
			$this->qty_pr_02->PlaceHolder = RemoveHtml($this->qty_pr_02->caption());

			// pl_02
			$this->pl_02->EditAttrs["class"] = "form-control";
			$this->pl_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_02->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->pl_02->AdvancedSearch->ViewValue = $this->pl_02->lookupCacheOption($curVal);
			else
				$this->pl_02->AdvancedSearch->ViewValue = $this->pl_02->Lookup !== NULL && is_array($this->pl_02->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_02->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->pl_02->EditValue = array_values($this->pl_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_02->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_02->EditValue = $arwrk;
			}

			// qty_pl_02
			$this->qty_pl_02->EditAttrs["class"] = "form-control";
			$this->qty_pl_02->EditCustomAttributes = "";
			$this->qty_pl_02->EditValue = HtmlEncode($this->qty_pl_02->AdvancedSearch->SearchValue);
			$this->qty_pl_02->PlaceHolder = RemoveHtml($this->qty_pl_02->caption());

			// pr_03
			$this->pr_03->EditAttrs["class"] = "form-control";
			$this->pr_03->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pr_03->AdvancedSearch->SearchValue = HtmlDecode($this->pr_03->AdvancedSearch->SearchValue);
			$this->pr_03->EditValue = HtmlEncode($this->pr_03->AdvancedSearch->SearchValue);
			$this->pr_03->PlaceHolder = RemoveHtml($this->pr_03->caption());

			// qty_pr_03
			$this->qty_pr_03->EditAttrs["class"] = "form-control";
			$this->qty_pr_03->EditCustomAttributes = "";
			$this->qty_pr_03->EditValue = HtmlEncode($this->qty_pr_03->AdvancedSearch->SearchValue);
			$this->qty_pr_03->PlaceHolder = RemoveHtml($this->qty_pr_03->caption());

			// pl_03
			$this->pl_03->EditAttrs["class"] = "form-control";
			$this->pl_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_03->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->pl_03->AdvancedSearch->ViewValue = $this->pl_03->lookupCacheOption($curVal);
			else
				$this->pl_03->AdvancedSearch->ViewValue = $this->pl_03->Lookup !== NULL && is_array($this->pl_03->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_03->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->pl_03->EditValue = array_values($this->pl_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_03->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_03->EditValue = $arwrk;
			}

			// qty_pl_03
			$this->qty_pl_03->EditAttrs["class"] = "form-control";
			$this->qty_pl_03->EditCustomAttributes = "";
			$this->qty_pl_03->EditValue = HtmlEncode($this->qty_pl_03->AdvancedSearch->SearchValue);
			$this->qty_pl_03->PlaceHolder = RemoveHtml($this->qty_pl_03->caption());

			// pr_04
			$this->pr_04->EditAttrs["class"] = "form-control";
			$this->pr_04->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pr_04->AdvancedSearch->SearchValue = HtmlDecode($this->pr_04->AdvancedSearch->SearchValue);
			$this->pr_04->EditValue = HtmlEncode($this->pr_04->AdvancedSearch->SearchValue);
			$this->pr_04->PlaceHolder = RemoveHtml($this->pr_04->caption());

			// qty_pr_04
			$this->qty_pr_04->EditAttrs["class"] = "form-control";
			$this->qty_pr_04->EditCustomAttributes = "";
			$this->qty_pr_04->EditValue = HtmlEncode($this->qty_pr_04->AdvancedSearch->SearchValue);
			$this->qty_pr_04->PlaceHolder = RemoveHtml($this->qty_pr_04->caption());

			// pl_04
			$this->pl_04->EditAttrs["class"] = "form-control";
			$this->pl_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_04->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->pl_04->AdvancedSearch->ViewValue = $this->pl_04->lookupCacheOption($curVal);
			else
				$this->pl_04->AdvancedSearch->ViewValue = $this->pl_04->Lookup !== NULL && is_array($this->pl_04->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_04->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->pl_04->EditValue = array_values($this->pl_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_04->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (115)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_04->EditValue = $arwrk;
			}

			// qty_pl_04
			$this->qty_pl_04->EditAttrs["class"] = "form-control";
			$this->qty_pl_04->EditCustomAttributes = "";
			$this->qty_pl_04->EditValue = HtmlEncode($this->qty_pl_04->AdvancedSearch->SearchValue);
			$this->qty_pl_04->PlaceHolder = RemoveHtml($this->qty_pl_04->caption());

			// pa_01
			$this->pa_01->EditAttrs["class"] = "form-control";
			$this->pa_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_01->AdvancedSearch->SearchValue = HtmlDecode($this->pa_01->AdvancedSearch->SearchValue);
			$this->pa_01->EditValue = HtmlEncode($this->pa_01->AdvancedSearch->SearchValue);
			$curVal = strval($this->pa_01->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->pa_01->EditValue = $this->pa_01->lookupCacheOption($curVal);
				if ($this->pa_01->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_01->EditValue = $this->pa_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_01->EditValue = HtmlEncode($this->pa_01->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->pa_01->EditValue = NULL;
			}
			$this->pa_01->PlaceHolder = RemoveHtml($this->pa_01->caption());

			// qty_pa_01
			$this->qty_pa_01->EditAttrs["class"] = "form-control";
			$this->qty_pa_01->EditCustomAttributes = "";
			$this->qty_pa_01->EditValue = HtmlEncode($this->qty_pa_01->AdvancedSearch->SearchValue);
			$this->qty_pa_01->PlaceHolder = RemoveHtml($this->qty_pa_01->caption());

			// pa_02
			$this->pa_02->EditAttrs["class"] = "form-control";
			$this->pa_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_02->AdvancedSearch->SearchValue = HtmlDecode($this->pa_02->AdvancedSearch->SearchValue);
			$this->pa_02->EditValue = HtmlEncode($this->pa_02->AdvancedSearch->SearchValue);
			$curVal = strval($this->pa_02->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->pa_02->EditValue = $this->pa_02->lookupCacheOption($curVal);
				if ($this->pa_02->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_02->EditValue = $this->pa_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_02->EditValue = HtmlEncode($this->pa_02->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->pa_02->EditValue = NULL;
			}
			$this->pa_02->PlaceHolder = RemoveHtml($this->pa_02->caption());

			// qty_pa_02
			$this->qty_pa_02->EditAttrs["class"] = "form-control";
			$this->qty_pa_02->EditCustomAttributes = "";
			$this->qty_pa_02->EditValue = HtmlEncode($this->qty_pa_02->AdvancedSearch->SearchValue);
			$this->qty_pa_02->PlaceHolder = RemoveHtml($this->qty_pa_02->caption());

			// pa_03
			$this->pa_03->EditAttrs["class"] = "form-control";
			$this->pa_03->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_03->AdvancedSearch->SearchValue = HtmlDecode($this->pa_03->AdvancedSearch->SearchValue);
			$this->pa_03->EditValue = HtmlEncode($this->pa_03->AdvancedSearch->SearchValue);
			$curVal = strval($this->pa_03->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->pa_03->EditValue = $this->pa_03->lookupCacheOption($curVal);
				if ($this->pa_03->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_03->EditValue = $this->pa_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_03->EditValue = HtmlEncode($this->pa_03->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->pa_03->EditValue = NULL;
			}
			$this->pa_03->PlaceHolder = RemoveHtml($this->pa_03->caption());

			// qty_pa_03
			$this->qty_pa_03->EditAttrs["class"] = "form-control";
			$this->qty_pa_03->EditCustomAttributes = "";
			$this->qty_pa_03->EditValue = HtmlEncode($this->qty_pa_03->AdvancedSearch->SearchValue);
			$this->qty_pa_03->PlaceHolder = RemoveHtml($this->qty_pa_03->caption());

			// pa_04
			$this->pa_04->EditAttrs["class"] = "form-control";
			$this->pa_04->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_04->AdvancedSearch->SearchValue = HtmlDecode($this->pa_04->AdvancedSearch->SearchValue);
			$this->pa_04->EditValue = HtmlEncode($this->pa_04->AdvancedSearch->SearchValue);
			$curVal = strval($this->pa_04->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->pa_04->EditValue = $this->pa_04->lookupCacheOption($curVal);
				if ($this->pa_04->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_04->EditValue = $this->pa_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_04->EditValue = HtmlEncode($this->pa_04->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->pa_04->EditValue = NULL;
			}
			$this->pa_04->PlaceHolder = RemoveHtml($this->pa_04->caption());

			// qty_pa_04
			$this->qty_pa_04->EditAttrs["class"] = "form-control";
			$this->qty_pa_04->EditCustomAttributes = "";
			$this->qty_pa_04->EditValue = HtmlEncode($this->qty_pa_04->AdvancedSearch->SearchValue);
			$this->qty_pa_04->PlaceHolder = RemoveHtml($this->qty_pa_04->caption());

			// pa_05
			$this->pa_05->EditAttrs["class"] = "form-control";
			$this->pa_05->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pa_05->AdvancedSearch->SearchValue = HtmlDecode($this->pa_05->AdvancedSearch->SearchValue);
			$this->pa_05->EditValue = HtmlEncode($this->pa_05->AdvancedSearch->SearchValue);
			$curVal = strval($this->pa_05->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->pa_05->EditValue = $this->pa_05->lookupCacheOption($curVal);
				if ($this->pa_05->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pa_05->EditValue = $this->pa_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_05->EditValue = HtmlEncode($this->pa_05->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->pa_05->EditValue = NULL;
			}
			$this->pa_05->PlaceHolder = RemoveHtml($this->pa_05->caption());

			// qty_pa_05
			$this->qty_pa_05->EditAttrs["class"] = "form-control";
			$this->qty_pa_05->EditCustomAttributes = "";
			$this->qty_pa_05->EditValue = HtmlEncode($this->qty_pa_05->AdvancedSearch->SearchValue);
			$this->qty_pa_05->PlaceHolder = RemoveHtml($this->qty_pa_05->caption());

			// pc_01
			$this->pc_01->EditAttrs["class"] = "form-control";
			$this->pc_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->pc_01->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->pc_01->AdvancedSearch->ViewValue = $this->pc_01->lookupCacheOption($curVal);
			else
				$this->pc_01->AdvancedSearch->ViewValue = $this->pc_01->Lookup !== NULL && is_array($this->pc_01->Lookup->Options) ? $curVal : NULL;
			if ($this->pc_01->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->pc_01->EditValue = array_values($this->pc_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pc_01->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (125) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pc_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pc_01->EditValue = $arwrk;
			}

			// qty_pc_01
			$this->qty_pc_01->EditAttrs["class"] = "form-control";
			$this->qty_pc_01->EditCustomAttributes = "";
			$this->qty_pc_01->EditValue = HtmlEncode($this->qty_pc_01->AdvancedSearch->SearchValue);
			$this->qty_pc_01->PlaceHolder = RemoveHtml($this->qty_pc_01->caption());

			// pc_02
			$this->pc_02->EditAttrs["class"] = "form-control";
			$this->pc_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->pc_02->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->pc_02->AdvancedSearch->ViewValue = $this->pc_02->lookupCacheOption($curVal);
			else
				$this->pc_02->AdvancedSearch->ViewValue = $this->pc_02->Lookup !== NULL && is_array($this->pc_02->Lookup->Options) ? $curVal : NULL;
			if ($this->pc_02->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->pc_02->EditValue = array_values($this->pc_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pc_02->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (125) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pc_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pc_02->EditValue = $arwrk;
			}

			// qty_pc_02
			$this->qty_pc_02->EditAttrs["class"] = "form-control";
			$this->qty_pc_02->EditCustomAttributes = "";
			$this->qty_pc_02->EditValue = HtmlEncode($this->qty_pc_02->AdvancedSearch->SearchValue);
			$this->qty_pc_02->PlaceHolder = RemoveHtml($this->qty_pc_02->caption());

			// o_01
			$this->o_01->EditAttrs["class"] = "form-control";
			$this->o_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->o_01->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->o_01->AdvancedSearch->ViewValue = $this->o_01->lookupCacheOption($curVal);
			else
				$this->o_01->AdvancedSearch->ViewValue = $this->o_01->Lookup !== NULL && is_array($this->o_01->Lookup->Options) ? $curVal : NULL;
			if ($this->o_01->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->o_01->EditValue = array_values($this->o_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->o_01->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->o_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->o_01->EditValue = $arwrk;
			}

			// qty_o_01
			$this->qty_o_01->EditAttrs["class"] = "form-control";
			$this->qty_o_01->EditCustomAttributes = "";
			$this->qty_o_01->EditValue = HtmlEncode($this->qty_o_01->AdvancedSearch->SearchValue);
			$this->qty_o_01->PlaceHolder = RemoveHtml($this->qty_o_01->caption());

			// lamination_type
			$this->lamination_type->EditAttrs["class"] = "form-control";
			$this->lamination_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->lamination_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->lamination_type->AdvancedSearch->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
			else
				$this->lamination_type->AdvancedSearch->ViewValue = $this->lamination_type->Lookup !== NULL && is_array($this->lamination_type->Lookup->Options) ? $curVal : NULL;
			if ($this->lamination_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->lamination_type->EditValue = array_values($this->lamination_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->lamination_type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (123) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->lamination_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->lamination_type->EditValue = $arwrk;
			}

			// lamination_qty
			$this->lamination_qty->EditAttrs["class"] = "form-control";
			$this->lamination_qty->EditCustomAttributes = "";
			$this->lamination_qty->EditValue = HtmlEncode($this->lamination_qty->AdvancedSearch->SearchValue);
			$this->lamination_qty->PlaceHolder = RemoveHtml($this->lamination_qty->caption());

			// die_type
			$this->die_type->EditAttrs["class"] = "form-control";
			$this->die_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->die_type->AdvancedSearch->SearchValue = HtmlDecode($this->die_type->AdvancedSearch->SearchValue);
			$this->die_type->EditValue = HtmlEncode($this->die_type->AdvancedSearch->SearchValue);
			$this->die_type->PlaceHolder = RemoveHtml($this->die_type->caption());

			// die_qty
			$this->die_qty->EditAttrs["class"] = "form-control";
			$this->die_qty->EditCustomAttributes = "";
			$this->die_qty->EditValue = HtmlEncode($this->die_qty->AdvancedSearch->SearchValue);
			$this->die_qty->PlaceHolder = RemoveHtml($this->die_qty->caption());

			// binding_type
			$this->binding_type->EditAttrs["class"] = "form-control";
			$this->binding_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->binding_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->binding_type->AdvancedSearch->ViewValue = $this->binding_type->lookupCacheOption($curVal);
			else
				$this->binding_type->AdvancedSearch->ViewValue = $this->binding_type->Lookup !== NULL && is_array($this->binding_type->Lookup->Options) ? $curVal : NULL;
			if ($this->binding_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->binding_type->EditValue = array_values($this->binding_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->binding_type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp` IN (114) and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->binding_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->binding_type->EditValue = $arwrk;
			}

			// binding_qty
			$this->binding_qty->EditAttrs["class"] = "form-control";
			$this->binding_qty->EditCustomAttributes = "";
			$this->binding_qty->EditValue = HtmlEncode($this->binding_qty->AdvancedSearch->SearchValue);
			$this->binding_qty->PlaceHolder = RemoveHtml($this->binding_qty->caption());

			// number_type
			$this->number_type->EditAttrs["class"] = "form-control";
			$this->number_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->number_type->AdvancedSearch->SearchValue = HtmlDecode($this->number_type->AdvancedSearch->SearchValue);
			$this->number_type->EditValue = HtmlEncode($this->number_type->AdvancedSearch->SearchValue);
			$this->number_type->PlaceHolder = RemoveHtml($this->number_type->caption());

			// number_qty
			$this->number_qty->EditAttrs["class"] = "form-control";
			$this->number_qty->EditCustomAttributes = "";
			$this->number_qty->EditValue = HtmlEncode($this->number_qty->AdvancedSearch->SearchValue);
			$this->number_qty->PlaceHolder = RemoveHtml($this->number_qty->caption());

			// de_01
			$this->de_01->EditAttrs["class"] = "form-control";
			$this->de_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->de_01->AdvancedSearch->SearchValue = HtmlDecode($this->de_01->AdvancedSearch->SearchValue);
			$this->de_01->EditValue = HtmlEncode($this->de_01->AdvancedSearch->SearchValue);
			$this->de_01->PlaceHolder = RemoveHtml($this->de_01->caption());

			// qty_de_01
			$this->qty_de_01->EditAttrs["class"] = "form-control";
			$this->qty_de_01->EditCustomAttributes = "";
			$this->qty_de_01->EditValue = HtmlEncode($this->qty_de_01->AdvancedSearch->SearchValue);
			$this->qty_de_01->PlaceHolder = RemoveHtml($this->qty_de_01->caption());

			// de_02
			$this->de_02->EditAttrs["class"] = "form-control";
			$this->de_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->de_02->AdvancedSearch->SearchValue = HtmlDecode($this->de_02->AdvancedSearch->SearchValue);
			$this->de_02->EditValue = HtmlEncode($this->de_02->AdvancedSearch->SearchValue);
			$this->de_02->PlaceHolder = RemoveHtml($this->de_02->caption());

			// qty_de_02
			$this->qty_de_02->EditAttrs["class"] = "form-control";
			$this->qty_de_02->EditCustomAttributes = "";
			$this->qty_de_02->EditValue = HtmlEncode($this->qty_de_02->AdvancedSearch->SearchValue);
			$this->qty_de_02->PlaceHolder = RemoveHtml($this->qty_de_02->caption());

			// de_03
			$this->de_03->EditAttrs["class"] = "form-control";
			$this->de_03->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->de_03->AdvancedSearch->SearchValue = HtmlDecode($this->de_03->AdvancedSearch->SearchValue);
			$this->de_03->EditValue = HtmlEncode($this->de_03->AdvancedSearch->SearchValue);
			$this->de_03->PlaceHolder = RemoveHtml($this->de_03->caption());

			// qty_de_03
			$this->qty_de_03->EditAttrs["class"] = "form-control";
			$this->qty_de_03->EditCustomAttributes = "";
			$this->qty_de_03->EditValue = HtmlEncode($this->qty_de_03->AdvancedSearch->SearchValue);
			$this->qty_de_03->PlaceHolder = RemoveHtml($this->qty_de_03->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->company_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->company_id->errorMessage());
		}
		if (!CheckNumber($this->quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->quantity->errorMessage());
		}
		if (!CheckInteger($this->paper->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->paper->errorMessage());
		}
		if (!CheckNumber($this->qty_pr_01->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pr_01->errorMessage());
		}
		if (!CheckNumber($this->qty_pl_01->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pl_01->errorMessage());
		}
		if (!CheckNumber($this->qty_pr_02->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pr_02->errorMessage());
		}
		if (!CheckNumber($this->qty_pl_02->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pl_02->errorMessage());
		}
		if (!CheckNumber($this->qty_pr_03->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pr_03->errorMessage());
		}
		if (!CheckNumber($this->qty_pl_03->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pl_03->errorMessage());
		}
		if (!CheckNumber($this->qty_pr_04->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pr_04->errorMessage());
		}
		if (!CheckNumber($this->qty_pl_04->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pl_04->errorMessage());
		}
		if (!CheckNumber($this->qty_pa_01->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pa_01->errorMessage());
		}
		if (!CheckNumber($this->qty_pa_02->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pa_02->errorMessage());
		}
		if (!CheckNumber($this->qty_pa_03->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pa_03->errorMessage());
		}
		if (!CheckNumber($this->qty_pa_04->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pa_04->errorMessage());
		}
		if (!CheckInteger($this->pa_05->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pa_05->errorMessage());
		}
		if (!CheckNumber($this->qty_pa_05->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pa_05->errorMessage());
		}
		if (!CheckNumber($this->qty_pc_01->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pc_01->errorMessage());
		}
		if (!CheckNumber($this->qty_pc_02->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_pc_02->errorMessage());
		}
		if (!CheckNumber($this->qty_o_01->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_o_01->errorMessage());
		}
		if (!CheckInteger($this->lamination_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->lamination_qty->errorMessage());
		}
		if (!CheckInteger($this->die_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->die_qty->errorMessage());
		}
		if (!CheckNumber($this->binding_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->binding_qty->errorMessage());
		}
		if (!CheckInteger($this->number_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->number_qty->errorMessage());
		}
		if (!CheckNumber($this->qty_de_01->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_de_01->errorMessage());
		}
		if (!CheckNumber($this->qty_de_02->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_de_02->errorMessage());
		}
		if (!CheckNumber($this->qty_de_03->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty_de_03->errorMessage());
		}
		if (!CheckInteger($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->job_type->AdvancedSearch->load();
		$this->job_category->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->description->AdvancedSearch->load();
		$this->size->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->pages->AdvancedSearch->load();
		$this->paper->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->pr_01->AdvancedSearch->load();
		$this->qty_pr_01->AdvancedSearch->load();
		$this->pl_01->AdvancedSearch->load();
		$this->qty_pl_01->AdvancedSearch->load();
		$this->pr_02->AdvancedSearch->load();
		$this->qty_pr_02->AdvancedSearch->load();
		$this->pl_02->AdvancedSearch->load();
		$this->qty_pl_02->AdvancedSearch->load();
		$this->pr_03->AdvancedSearch->load();
		$this->qty_pr_03->AdvancedSearch->load();
		$this->pl_03->AdvancedSearch->load();
		$this->qty_pl_03->AdvancedSearch->load();
		$this->pr_04->AdvancedSearch->load();
		$this->qty_pr_04->AdvancedSearch->load();
		$this->pl_04->AdvancedSearch->load();
		$this->qty_pl_04->AdvancedSearch->load();
		$this->pa_01->AdvancedSearch->load();
		$this->qty_pa_01->AdvancedSearch->load();
		$this->pa_02->AdvancedSearch->load();
		$this->qty_pa_02->AdvancedSearch->load();
		$this->pa_03->AdvancedSearch->load();
		$this->qty_pa_03->AdvancedSearch->load();
		$this->pa_04->AdvancedSearch->load();
		$this->qty_pa_04->AdvancedSearch->load();
		$this->pa_05->AdvancedSearch->load();
		$this->qty_pa_05->AdvancedSearch->load();
		$this->pc_01->AdvancedSearch->load();
		$this->qty_pc_01->AdvancedSearch->load();
		$this->pc_02->AdvancedSearch->load();
		$this->qty_pc_02->AdvancedSearch->load();
		$this->o_01->AdvancedSearch->load();
		$this->qty_o_01->AdvancedSearch->load();
		$this->lamination_type->AdvancedSearch->load();
		$this->lamination_qty->AdvancedSearch->load();
		$this->die_type->AdvancedSearch->load();
		$this->die_qty->AdvancedSearch->load();
		$this->binding_type->AdvancedSearch->load();
		$this->binding_qty->AdvancedSearch->load();
		$this->number_type->AdvancedSearch->load();
		$this->number_qty->AdvancedSearch->load();
		$this->de_01->AdvancedSearch->load();
		$this->qty_de_01->AdvancedSearch->load();
		$this->de_02->AdvancedSearch->load();
		$this->qty_de_02->AdvancedSearch->load();
		$this->de_03->AdvancedSearch->load();
		$this->qty_de_03->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("p_eastimatelist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$pages->add(8);
		$pages->add(9);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_size":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_01":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_01":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_02":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_02":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_03":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_03":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_04":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_04":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_01":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_02":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_03":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_04":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_05":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pc_01":
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pc_02":
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_o_01":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_lamination_type":
					$lookupFilter = function() {
						return "`s_grp` IN (123) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_die_type":
					$lookupFilter = function() {
						return "`s_grp` IN (124) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_binding_type":
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_number_type":
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_01":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_02":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_03":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_size":
							break;
						case "x_pr_01":
							break;
						case "x_pl_01":
							break;
						case "x_pr_02":
							break;
						case "x_pl_02":
							break;
						case "x_pr_03":
							break;
						case "x_pl_03":
							break;
						case "x_pr_04":
							break;
						case "x_pl_04":
							break;
						case "x_pa_01":
							break;
						case "x_pa_02":
							break;
						case "x_pa_03":
							break;
						case "x_pa_04":
							break;
						case "x_pa_05":
							break;
						case "x_pc_01":
							break;
						case "x_pc_02":
							break;
						case "x_o_01":
							break;
						case "x_lamination_type":
							break;
						case "x_die_type":
							break;
						case "x_binding_type":
							break;
						case "x_number_type":
							break;
						case "x_de_01":
							break;
						case "x_de_02":
							break;
						case "x_de_03":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>